--- upstream/lib/low/KeccakP-1600/plain-64bits/KeccakP-1600-SnP.h
+++ upstream-patched/lib/low/KeccakP-1600/plain-64bits/KeccakP-1600-SnP.h
@@ -24,31 +24,63 @@
 #include "brg_endian.h"
 #include "KeccakP-1600-opt64-config.h"
 
-#define KeccakP1600_implementation      "generic 64-bit optimized implementation (" KeccakP1600_implementation_config ")"
-#define KeccakP1600_stateSizeInBytes    200
-#define KeccakP1600_stateAlignment      8
-#define KeccakF1600_FastLoop_supported
-#define KeccakP1600_12rounds_FastLoop_supported
-
 #include <stddef.h>
 
-#define KeccakP1600_StaticInitialize()
-void KeccakP1600_Initialize(void *state);
-#if (PLATFORM_BYTE_ORDER == IS_LITTLE_ENDIAN)
-#define KeccakP1600_AddByte(state, byte, offset) \
-    ((unsigned char*)(state))[(offset)] ^= (byte)
+#define KeccakP1600_implementation_plain64 "generic 64-bit optimized implementation (" KeccakP1600_implementation_config ")"
+#define KeccakP1600_stateSizeInBytes_plain64 200
+#define KeccakP1600_stateAlignment_plain64 8
+#define KeccakF1600_FastLoop_supported_plain64
+#define KeccakP1600_12rounds_FastLoop_supported_plain64
+
+#if defined(ADD_SYMBOL_SUFFIX)
+#define KECCAK_SYMBOL_SUFFIX plain64
+#define KECCAK_IMPL_NAMESPACE(x) x##_plain64
 #else
-void KeccakP1600_AddByte(void *state, unsigned char data, unsigned int offset);
+#define KECCAK_IMPL_NAMESPACE(x) x
+#define KeccakP1600_implementation KeccakP1600_implementation_plain64
+#define KeccakP1600_stateSizeInBytes KeccakP1600_stateSizeInBytes_plain64
+#define KeccakP1600_stateAlignment KeccakP1600_stateAlignment_plain64
+#define KeccakF1600_FastLoop_supported KeccakF1600_FastLoop_supported_plain64
+#define KeccakP1600_12rounds_FastLoop_supported KeccakP1600_12rounds_FastLoop_supported_plain64
 #endif
+
+#define KeccakP1600_StaticInitialize KECCAK_IMPL_NAMESPACE(KeccakP1600_StaticInitialize)
+void KeccakP1600_StaticInitialize(void);
+
+#define KeccakP1600_Initialize KECCAK_IMPL_NAMESPACE(KeccakP1600_Initialize)
+void KeccakP1600_Initialize(void *state);
+
+#define KeccakP1600_AddByte KECCAK_IMPL_NAMESPACE(KeccakP1600_AddByte)
+void KeccakP1600_AddByte(void *state, unsigned char data, unsigned int offset);
+
+#define KeccakP1600_AddBytes KECCAK_IMPL_NAMESPACE(KeccakP1600_AddBytes)
 void KeccakP1600_AddBytes(void *state, const unsigned char *data, unsigned int offset, unsigned int length);
+
+#define KeccakP1600_OverwriteBytes KECCAK_IMPL_NAMESPACE(KeccakP1600_OverwriteBytes)
 void KeccakP1600_OverwriteBytes(void *state, const unsigned char *data, unsigned int offset, unsigned int length);
+
+#define KeccakP1600_OverwriteWithZeroes KECCAK_IMPL_NAMESPACE(KeccakP1600_OverwriteWithZeroes)
 void KeccakP1600_OverwriteWithZeroes(void *state, unsigned int byteCount);
+
+#define KeccakP1600_Permute_Nrounds KECCAK_IMPL_NAMESPACE(KeccakP1600_Permute_Nrounds)
 void KeccakP1600_Permute_Nrounds(void *state, unsigned int nrounds);
+
+#define KeccakP1600_Permute_12rounds KECCAK_IMPL_NAMESPACE(KeccakP1600_Permute_12rounds)
 void KeccakP1600_Permute_12rounds(void *state);
+
+#define KeccakP1600_Permute_24rounds KECCAK_IMPL_NAMESPACE(KeccakP1600_Permute_24rounds)
 void KeccakP1600_Permute_24rounds(void *state);
+
+#define KeccakP1600_ExtractBytes KECCAK_IMPL_NAMESPACE(KeccakP1600_ExtractBytes)
 void KeccakP1600_ExtractBytes(const void *state, unsigned char *data, unsigned int offset, unsigned int length);
+
+#define KeccakP1600_ExtractAndAddBytes KECCAK_IMPL_NAMESPACE(KeccakP1600_ExtractAndAddBytes)
 void KeccakP1600_ExtractAndAddBytes(const void *state, const unsigned char *input, unsigned char *output, unsigned int offset, unsigned int length);
+
+#define KeccakF1600_FastLoop_Absorb KECCAK_IMPL_NAMESPACE(KeccakF1600_FastLoop_Absorb)
 size_t KeccakF1600_FastLoop_Absorb(void *state, unsigned int laneCount, const unsigned char *data, size_t dataByteLen);
+
+#define KeccakP1600_12rounds_FastLoop_Absorb KECCAK_IMPL_NAMESPACE(KeccakP1600_12rounds_FastLoop_Absorb)
 size_t KeccakP1600_12rounds_FastLoop_Absorb(void *state, unsigned int laneCount, const unsigned char *data, size_t dataByteLen);
 
 #endif

