/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/lda_exc/lda_c_chachiyo.mpl
  Type of functional: lda_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t13, t14, t16, t17, t18, t19, t22, t23;
  double t24, t25, t28, t31, t32, t36, t38, t40;
  double t42, t45, t46, tzk0;

  lda_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (lda_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = POW_1_3(rho[0]);
  t10 = t8 * t9;
  t13 = params->cp * t1;
  t14 = t5 * t5;
  t16 = t7 * t7;
  t17 = 0.1e1 / t14 * t16;
  t18 = t9 * t9;
  t19 = t17 * t18;
  t22 = 0.1e1 + t3 * t10 / 0.3e1 + t13 * t19 / 0.3e1;
  t23 = log(t22);
  t24 = params->ap * t23;
  t25 = params->bf * t2;
  t28 = params->cf * t1;
  t31 = 0.1e1 + t25 * t10 / 0.3e1 + t28 * t19 / 0.3e1;
  t32 = log(t31);
  t36 = POW_1_3(p->zeta_threshold);
  t38 = my_piecewise3(0.1e1 <= p->zeta_threshold, t36 * p->zeta_threshold, 1);
  t40 = 0.2e1 * t38 - 0.2e1;
  t42 = M_CBRT2;
  t45 = 0.1e1 / (0.2e1 * t42 - 0.2e1);
  t46 = (params->af * t32 - t24) * t40 * t45;
  tzk0 = t24 + t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t13, t14, t16, t17, t18, t19, t22, t23;
  double t24, t25, t28, t31, t32, t36, t38, t40;
  double t42, t45, t46, tzk0;

  double t48, t52, t55, t57, t58, t63, t65, t69;
  double tvrho0;

  lda_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (lda_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = POW_1_3(rho[0]);
  t10 = t8 * t9;
  t13 = params->cp * t1;
  t14 = t5 * t5;
  t16 = t7 * t7;
  t17 = 0.1e1 / t14 * t16;
  t18 = t9 * t9;
  t19 = t17 * t18;
  t22 = 0.1e1 + t3 * t10 / 0.3e1 + t13 * t19 / 0.3e1;
  t23 = log(t22);
  t24 = params->ap * t23;
  t25 = params->bf * t2;
  t28 = params->cf * t1;
  t31 = 0.1e1 + t25 * t10 / 0.3e1 + t28 * t19 / 0.3e1;
  t32 = log(t31);
  t36 = POW_1_3(p->zeta_threshold);
  t38 = my_piecewise3(0.1e1 <= p->zeta_threshold, t36 * p->zeta_threshold, 1);
  t40 = 0.2e1 * t38 - 0.2e1;
  t42 = M_CBRT2;
  t45 = 0.1e1 / (0.2e1 * t42 - 0.2e1);
  t46 = (params->af * t32 - t24) * t40 * t45;
  tzk0 = t24 + t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t48 = t8 / t18;
  t52 = t17 / t9;
  t55 = t3 * t48 / 0.9e1 + 0.2e1 / 0.9e1 * t13 * t52;
  t57 = 0.1e1 / t22;
  t58 = params->ap * t55 * t57;
  t63 = t25 * t48 / 0.9e1 + 0.2e1 / 0.9e1 * t28 * t52;
  t65 = 0.1e1 / t31;
  t69 = (params->af * t63 * t65 - t58) * t40 * t45;
  tvrho0 = t24 + t46 + rho[0] * (t58 + t69);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t13, t14, t16, t17, t18, t19, t22, t23;
  double t24, t25, t28, t31, t32, t36, t38, t40;
  double t42, t45, t46, tzk0;

  double t48, t52, t55, t57, t58, t63, t65, t69;
  double tvrho0;

  double t76, t80, t83, t84, t85, t86, t88, t89;
  double t90, t94, t95, t97, t99, t100, t104, tv2rho20;

  lda_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (lda_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = POW_1_3(rho[0]);
  t10 = t8 * t9;
  t13 = params->cp * t1;
  t14 = t5 * t5;
  t16 = t7 * t7;
  t17 = 0.1e1 / t14 * t16;
  t18 = t9 * t9;
  t19 = t17 * t18;
  t22 = 0.1e1 + t3 * t10 / 0.3e1 + t13 * t19 / 0.3e1;
  t23 = log(t22);
  t24 = params->ap * t23;
  t25 = params->bf * t2;
  t28 = params->cf * t1;
  t31 = 0.1e1 + t25 * t10 / 0.3e1 + t28 * t19 / 0.3e1;
  t32 = log(t31);
  t36 = POW_1_3(p->zeta_threshold);
  t38 = my_piecewise3(0.1e1 <= p->zeta_threshold, t36 * p->zeta_threshold, 1);
  t40 = 0.2e1 * t38 - 0.2e1;
  t42 = M_CBRT2;
  t45 = 0.1e1 / (0.2e1 * t42 - 0.2e1);
  t46 = (params->af * t32 - t24) * t40 * t45;
  tzk0 = t24 + t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t48 = t8 / t18;
  t52 = t17 / t9;
  t55 = t3 * t48 / 0.9e1 + 0.2e1 / 0.9e1 * t13 * t52;
  t57 = 0.1e1 / t22;
  t58 = params->ap * t55 * t57;
  t63 = t25 * t48 / 0.9e1 + 0.2e1 / 0.9e1 * t28 * t52;
  t65 = 0.1e1 / t31;
  t69 = (params->af * t63 * t65 - t58) * t40 * t45;
  tvrho0 = t24 + t46 + rho[0] * (t58 + t69);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t76 = t8 / t18 / rho[0];
  t80 = t17 / t9 / rho[0];
  t83 = -0.2e1 / 0.27e2 * t13 * t80 - 0.2e1 / 0.27e2 * t3 * t76;
  t84 = params->ap * t83;
  t85 = t84 * t57;
  t86 = t55 * t55;
  t88 = t22 * t22;
  t89 = 0.1e1 / t88;
  t90 = params->ap * t86 * t89;
  t94 = -0.2e1 / 0.27e2 * t25 * t76 - 0.2e1 / 0.27e2 * t28 * t80;
  t95 = params->af * t94;
  t97 = t63 * t63;
  t99 = t31 * t31;
  t100 = 0.1e1 / t99;
  t104 = (-params->af * t97 * t100 + t95 * t65 - t85 + t90) * t40 * t45;
  tv2rho20 = 0.2e1 * t58 + 0.2e1 * t69 + rho[0] * (t85 - t90 + t104);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t13, t14, t16, t17, t18, t19, t22, t23;
  double t24, t25, t28, t31, t32, t36, t38, t40;
  double t42, t45, t46, tzk0;

  double t48, t52, t55, t57, t58, t63, t65, t69;
  double tvrho0;

  double t76, t80, t83, t84, t85, t86, t88, t89;
  double t90, t94, t95, t97, t99, t100, t104, tv2rho20;

  double t110, t113, t118, t122, t123, t124, t125, t126;
  double t130, t131, t132, t138, t140, t146, t151, tv3rho30;

  lda_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (lda_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = POW_1_3(rho[0]);
  t10 = t8 * t9;
  t13 = params->cp * t1;
  t14 = t5 * t5;
  t16 = t7 * t7;
  t17 = 0.1e1 / t14 * t16;
  t18 = t9 * t9;
  t19 = t17 * t18;
  t22 = 0.1e1 + t3 * t10 / 0.3e1 + t13 * t19 / 0.3e1;
  t23 = log(t22);
  t24 = params->ap * t23;
  t25 = params->bf * t2;
  t28 = params->cf * t1;
  t31 = 0.1e1 + t25 * t10 / 0.3e1 + t28 * t19 / 0.3e1;
  t32 = log(t31);
  t36 = POW_1_3(p->zeta_threshold);
  t38 = my_piecewise3(0.1e1 <= p->zeta_threshold, t36 * p->zeta_threshold, 1);
  t40 = 0.2e1 * t38 - 0.2e1;
  t42 = M_CBRT2;
  t45 = 0.1e1 / (0.2e1 * t42 - 0.2e1);
  t46 = (params->af * t32 - t24) * t40 * t45;
  tzk0 = t24 + t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t48 = t8 / t18;
  t52 = t17 / t9;
  t55 = t3 * t48 / 0.9e1 + 0.2e1 / 0.9e1 * t13 * t52;
  t57 = 0.1e1 / t22;
  t58 = params->ap * t55 * t57;
  t63 = t25 * t48 / 0.9e1 + 0.2e1 / 0.9e1 * t28 * t52;
  t65 = 0.1e1 / t31;
  t69 = (params->af * t63 * t65 - t58) * t40 * t45;
  tvrho0 = t24 + t46 + rho[0] * (t58 + t69);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t76 = t8 / t18 / rho[0];
  t80 = t17 / t9 / rho[0];
  t83 = -0.2e1 / 0.27e2 * t13 * t80 - 0.2e1 / 0.27e2 * t3 * t76;
  t84 = params->ap * t83;
  t85 = t84 * t57;
  t86 = t55 * t55;
  t88 = t22 * t22;
  t89 = 0.1e1 / t88;
  t90 = params->ap * t86 * t89;
  t94 = -0.2e1 / 0.27e2 * t25 * t76 - 0.2e1 / 0.27e2 * t28 * t80;
  t95 = params->af * t94;
  t97 = t63 * t63;
  t99 = t31 * t31;
  t100 = 0.1e1 / t99;
  t104 = (-params->af * t97 * t100 + t95 * t65 - t85 + t90) * t40 * t45;
  tv2rho20 = 0.2e1 * t58 + 0.2e1 * t69 + rho[0] * (t85 - t90 + t104);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t110 = rho[0] * rho[0];
  t113 = t8 / t18 / t110;
  t118 = t17 / t9 / t110;
  t122 = params->ap * (0.1e2 / 0.81e2 * t3 * t113 + 0.8e1 / 0.81e2 * t13 * t118);
  t123 = t122 * t57;
  t124 = t89 * t55;
  t125 = t84 * t124;
  t126 = 0.3e1 * t125;
  t130 = 0.1e1 / t88 / t22;
  t131 = params->ap * t86 * t55 * t130;
  t132 = 0.2e1 * t131;
  t138 = params->af * (0.1e2 / 0.81e2 * t25 * t113 + 0.8e1 / 0.81e2 * t28 * t118);
  t140 = t100 * t63;
  t146 = 0.1e1 / t99 / t31;
  t151 = (0.2e1 * params->af * t97 * t63 * t146 + t138 * t65 - 0.3e1 * t95 * t140 - t123 + t126 - t132) * t40 * t45;
  tv3rho30 = 0.3e1 * t85 - 0.3e1 * t90 + 0.3e1 * t104 + rho[0] * (t123 - t126 + t132 + t151);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t13, t14, t16, t17, t18, t19, t22, t23;
  double t24, t25, t28, t31, t32, t36, t38, t40;
  double t42, t45, t46, tzk0;

  double t48, t52, t55, t57, t58, t63, t65, t69;
  double tvrho0;

  double t76, t80, t83, t84, t85, t86, t88, t89;
  double t90, t94, t95, t97, t99, t100, t104, tv2rho20;

  double t110, t113, t118, t122, t123, t124, t125, t126;
  double t130, t131, t132, t138, t140, t146, t151, tv3rho30;

  double t158, t161, t166, t171, t173, t176, t177, t180;
  double t181, t183, t186, t199, t203, t205, tv4rho40;

  lda_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (lda_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = POW_1_3(rho[0]);
  t10 = t8 * t9;
  t13 = params->cp * t1;
  t14 = t5 * t5;
  t16 = t7 * t7;
  t17 = 0.1e1 / t14 * t16;
  t18 = t9 * t9;
  t19 = t17 * t18;
  t22 = 0.1e1 + t3 * t10 / 0.3e1 + t13 * t19 / 0.3e1;
  t23 = log(t22);
  t24 = params->ap * t23;
  t25 = params->bf * t2;
  t28 = params->cf * t1;
  t31 = 0.1e1 + t25 * t10 / 0.3e1 + t28 * t19 / 0.3e1;
  t32 = log(t31);
  t36 = POW_1_3(p->zeta_threshold);
  t38 = my_piecewise3(0.1e1 <= p->zeta_threshold, t36 * p->zeta_threshold, 1);
  t40 = 0.2e1 * t38 - 0.2e1;
  t42 = M_CBRT2;
  t45 = 0.1e1 / (0.2e1 * t42 - 0.2e1);
  t46 = (params->af * t32 - t24) * t40 * t45;
  tzk0 = t24 + t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t48 = t8 / t18;
  t52 = t17 / t9;
  t55 = t3 * t48 / 0.9e1 + 0.2e1 / 0.9e1 * t13 * t52;
  t57 = 0.1e1 / t22;
  t58 = params->ap * t55 * t57;
  t63 = t25 * t48 / 0.9e1 + 0.2e1 / 0.9e1 * t28 * t52;
  t65 = 0.1e1 / t31;
  t69 = (params->af * t63 * t65 - t58) * t40 * t45;
  tvrho0 = t24 + t46 + rho[0] * (t58 + t69);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t76 = t8 / t18 / rho[0];
  t80 = t17 / t9 / rho[0];
  t83 = -0.2e1 / 0.27e2 * t13 * t80 - 0.2e1 / 0.27e2 * t3 * t76;
  t84 = params->ap * t83;
  t85 = t84 * t57;
  t86 = t55 * t55;
  t88 = t22 * t22;
  t89 = 0.1e1 / t88;
  t90 = params->ap * t86 * t89;
  t94 = -0.2e1 / 0.27e2 * t25 * t76 - 0.2e1 / 0.27e2 * t28 * t80;
  t95 = params->af * t94;
  t97 = t63 * t63;
  t99 = t31 * t31;
  t100 = 0.1e1 / t99;
  t104 = (-params->af * t97 * t100 + t95 * t65 - t85 + t90) * t40 * t45;
  tv2rho20 = 0.2e1 * t58 + 0.2e1 * t69 + rho[0] * (t85 - t90 + t104);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t110 = rho[0] * rho[0];
  t113 = t8 / t18 / t110;
  t118 = t17 / t9 / t110;
  t122 = params->ap * (0.1e2 / 0.81e2 * t3 * t113 + 0.8e1 / 0.81e2 * t13 * t118);
  t123 = t122 * t57;
  t124 = t89 * t55;
  t125 = t84 * t124;
  t126 = 0.3e1 * t125;
  t130 = 0.1e1 / t88 / t22;
  t131 = params->ap * t86 * t55 * t130;
  t132 = 0.2e1 * t131;
  t138 = params->af * (0.1e2 / 0.81e2 * t25 * t113 + 0.8e1 / 0.81e2 * t28 * t118);
  t140 = t100 * t63;
  t146 = 0.1e1 / t99 / t31;
  t151 = (0.2e1 * params->af * t97 * t63 * t146 + t138 * t65 - 0.3e1 * t95 * t140 - t123 + t126 - t132) * t40 * t45;
  tv3rho30 = 0.3e1 * t85 - 0.3e1 * t90 + 0.3e1 * t104 + rho[0] * (t123 - t126 + t132 + t151);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t158 = t110 * rho[0];
  t161 = t8 / t18 / t158;
  t166 = t17 / t9 / t158;
  t171 = params->ap * (-0.8e2 / 0.243e3 * t3 * t161 - 0.56e2 / 0.243e3 * t13 * t166) * t57;
  t173 = 0.4e1 * t122 * t124;
  t176 = 0.12e2 * t84 * t130 * t86;
  t177 = t83 * t83;
  t180 = 0.3e1 * params->ap * t177 * t89;
  t181 = t86 * t86;
  t183 = t88 * t88;
  t186 = 0.6e1 * params->ap * t181 / t183;
  t199 = t94 * t94;
  t203 = t97 * t97;
  t205 = t99 * t99;
  tv4rho40 = 0.4e1 * t123 - 0.12e2 * t125 + 0.8e1 * t131 + 0.4e1 * t151 + rho[0] * (t171 - t173 + t176 - t180 - t186 + (params->af * (-0.8e2 / 0.243e3 * t25 * t161 - 0.56e2 / 0.243e3 * t28 * t166) * t65 - 0.4e1 * t138 * t140 + 0.12e2 * t95 * t146 * t97 - 0.3e1 * params->af * t199 * t100 - 0.6e1 * params->af * t203 / t205 - t171 + t173 - t176 + t180 + t186) * t40 * t45);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t11, t14, t15, t17, t18, t19, t20, t23;
  double t24, t25, t26, t29, t32, t33, t35, t36;
  double t37, t38, t39, t40, t41, t42, t43, t45;
  double t46, t47, t48, t50, t51, t53, t56, t57;
  double tzk0;

  lda_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (lda_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = rho[0] + rho[1];
  t10 = POW_1_3(t9);
  t11 = t8 * t10;
  t14 = params->cp * t1;
  t15 = t5 * t5;
  t17 = t7 * t7;
  t18 = 0.1e1 / t15 * t17;
  t19 = t10 * t10;
  t20 = t18 * t19;
  t23 = 0.1e1 + t3 * t11 / 0.3e1 + t14 * t20 / 0.3e1;
  t24 = log(t23);
  t25 = params->ap * t24;
  t26 = params->bf * t2;
  t29 = params->cf * t1;
  t32 = 0.1e1 + t26 * t11 / 0.3e1 + t29 * t20 / 0.3e1;
  t33 = log(t32);
  t35 = params->af * t33 - t25;
  t36 = rho[0] - rho[1];
  t37 = 0.1e1 / t9;
  t38 = t36 * t37;
  t39 = 0.1e1 + t38;
  t40 = t39 <= p->zeta_threshold;
  t41 = POW_1_3(p->zeta_threshold);
  t42 = t41 * p->zeta_threshold;
  t43 = POW_1_3(t39);
  t45 = my_piecewise3(t40, t42, t43 * t39);
  t46 = 0.1e1 - t38;
  t47 = t46 <= p->zeta_threshold;
  t48 = POW_1_3(t46);
  t50 = my_piecewise3(t47, t42, t48 * t46);
  t51 = t45 + t50 - 0.2e1;
  t53 = M_CBRT2;
  t56 = 0.1e1 / (0.2e1 * t53 - 0.2e1);
  t57 = t35 * t51 * t56;
  tzk0 = t25 + t57;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t11, t14, t15, t17, t18, t19, t20, t23;
  double t24, t25, t26, t29, t32, t33, t35, t36;
  double t37, t38, t39, t40, t41, t42, t43, t45;
  double t46, t47, t48, t50, t51, t53, t56, t57;
  double tzk0;

  double t59, t63, t66, t68, t69, t74, t76, t78;
  double t80, t81, t82, t83, t84, t87, t88, t91;
  double t92, t94, tvrho0, t97, t100, t101, t104, t105;
  double t107, tvrho1;

  lda_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (lda_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = rho[0] + rho[1];
  t10 = POW_1_3(t9);
  t11 = t8 * t10;
  t14 = params->cp * t1;
  t15 = t5 * t5;
  t17 = t7 * t7;
  t18 = 0.1e1 / t15 * t17;
  t19 = t10 * t10;
  t20 = t18 * t19;
  t23 = 0.1e1 + t3 * t11 / 0.3e1 + t14 * t20 / 0.3e1;
  t24 = log(t23);
  t25 = params->ap * t24;
  t26 = params->bf * t2;
  t29 = params->cf * t1;
  t32 = 0.1e1 + t26 * t11 / 0.3e1 + t29 * t20 / 0.3e1;
  t33 = log(t32);
  t35 = params->af * t33 - t25;
  t36 = rho[0] - rho[1];
  t37 = 0.1e1 / t9;
  t38 = t36 * t37;
  t39 = 0.1e1 + t38;
  t40 = t39 <= p->zeta_threshold;
  t41 = POW_1_3(p->zeta_threshold);
  t42 = t41 * p->zeta_threshold;
  t43 = POW_1_3(t39);
  t45 = my_piecewise3(t40, t42, t43 * t39);
  t46 = 0.1e1 - t38;
  t47 = t46 <= p->zeta_threshold;
  t48 = POW_1_3(t46);
  t50 = my_piecewise3(t47, t42, t48 * t46);
  t51 = t45 + t50 - 0.2e1;
  t53 = M_CBRT2;
  t56 = 0.1e1 / (0.2e1 * t53 - 0.2e1);
  t57 = t35 * t51 * t56;
  tzk0 = t25 + t57;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t59 = t8 / t19;
  t63 = t18 / t10;
  t66 = t3 * t59 / 0.9e1 + 0.2e1 / 0.9e1 * t14 * t63;
  t68 = 0.1e1 / t23;
  t69 = params->ap * t66 * t68;
  t74 = t26 * t59 / 0.9e1 + 0.2e1 / 0.9e1 * t29 * t63;
  t76 = 0.1e1 / t32;
  t78 = params->af * t74 * t76 - t69;
  t80 = t78 * t51 * t56;
  t81 = t9 * t9;
  t82 = 0.1e1 / t81;
  t83 = t36 * t82;
  t84 = t37 - t83;
  t87 = my_piecewise3(t40, 0, 0.4e1 / 0.3e1 * t43 * t84);
  t88 = -t84;
  t91 = my_piecewise3(t47, 0, 0.4e1 / 0.3e1 * t48 * t88);
  t92 = t87 + t91;
  t94 = t35 * t92 * t56;
  tvrho0 = t25 + t57 + t9 * (t69 + t80 + t94);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t97 = -t37 - t83;
  t100 = my_piecewise3(t40, 0, 0.4e1 / 0.3e1 * t43 * t97);
  t101 = -t97;
  t104 = my_piecewise3(t47, 0, 0.4e1 / 0.3e1 * t48 * t101);
  t105 = t100 + t104;
  t107 = t35 * t105 * t56;
  tvrho1 = t25 + t57 + t9 * (t69 + t80 + t107);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t11, t14, t15, t17, t18, t19, t20, t23;
  double t24, t25, t26, t29, t32, t33, t35, t36;
  double t37, t38, t39, t40, t41, t42, t43, t45;
  double t46, t47, t48, t50, t51, t53, t56, t57;
  double tzk0;

  double t59, t63, t66, t68, t69, t74, t76, t78;
  double t80, t81, t82, t83, t84, t87, t88, t91;
  double t92, t94, tvrho0, t97, t100, t101, t104, t105;
  double t107, tvrho1;

  double t110, t111, t115, t119, t122, t123, t124, t125;
  double t127, t128, t129, t133, t134, t136, t138, t139;
  double t141, t143, t145, t146, t147, t148, t149, t152;
  double t153, t154, t156, t160, t161, t162, t163, t166;
  double t170, t171, t173, tv2rho20, t177, t178, t181, t185;
  double t186, t189, t193, t194, t196, tv2rho21, t200, t201;
  double t205, t209, t210, t213, t217, t218, t220, tv2rho22;

  lda_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (lda_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = rho[0] + rho[1];
  t10 = POW_1_3(t9);
  t11 = t8 * t10;
  t14 = params->cp * t1;
  t15 = t5 * t5;
  t17 = t7 * t7;
  t18 = 0.1e1 / t15 * t17;
  t19 = t10 * t10;
  t20 = t18 * t19;
  t23 = 0.1e1 + t3 * t11 / 0.3e1 + t14 * t20 / 0.3e1;
  t24 = log(t23);
  t25 = params->ap * t24;
  t26 = params->bf * t2;
  t29 = params->cf * t1;
  t32 = 0.1e1 + t26 * t11 / 0.3e1 + t29 * t20 / 0.3e1;
  t33 = log(t32);
  t35 = params->af * t33 - t25;
  t36 = rho[0] - rho[1];
  t37 = 0.1e1 / t9;
  t38 = t36 * t37;
  t39 = 0.1e1 + t38;
  t40 = t39 <= p->zeta_threshold;
  t41 = POW_1_3(p->zeta_threshold);
  t42 = t41 * p->zeta_threshold;
  t43 = POW_1_3(t39);
  t45 = my_piecewise3(t40, t42, t43 * t39);
  t46 = 0.1e1 - t38;
  t47 = t46 <= p->zeta_threshold;
  t48 = POW_1_3(t46);
  t50 = my_piecewise3(t47, t42, t48 * t46);
  t51 = t45 + t50 - 0.2e1;
  t53 = M_CBRT2;
  t56 = 0.1e1 / (0.2e1 * t53 - 0.2e1);
  t57 = t35 * t51 * t56;
  tzk0 = t25 + t57;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t59 = t8 / t19;
  t63 = t18 / t10;
  t66 = t3 * t59 / 0.9e1 + 0.2e1 / 0.9e1 * t14 * t63;
  t68 = 0.1e1 / t23;
  t69 = params->ap * t66 * t68;
  t74 = t26 * t59 / 0.9e1 + 0.2e1 / 0.9e1 * t29 * t63;
  t76 = 0.1e1 / t32;
  t78 = params->af * t74 * t76 - t69;
  t80 = t78 * t51 * t56;
  t81 = t9 * t9;
  t82 = 0.1e1 / t81;
  t83 = t36 * t82;
  t84 = t37 - t83;
  t87 = my_piecewise3(t40, 0, 0.4e1 / 0.3e1 * t43 * t84);
  t88 = -t84;
  t91 = my_piecewise3(t47, 0, 0.4e1 / 0.3e1 * t48 * t88);
  t92 = t87 + t91;
  t94 = t35 * t92 * t56;
  tvrho0 = t25 + t57 + t9 * (t69 + t80 + t94);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t97 = -t37 - t83;
  t100 = my_piecewise3(t40, 0, 0.4e1 / 0.3e1 * t43 * t97);
  t101 = -t97;
  t104 = my_piecewise3(t47, 0, 0.4e1 / 0.3e1 * t48 * t101);
  t105 = t100 + t104;
  t107 = t35 * t105 * t56;
  tvrho1 = t25 + t57 + t9 * (t69 + t80 + t107);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t110 = 0.2e1 * t69;
  t111 = 0.2e1 * t80;
  t115 = t8 / t19 / t9;
  t119 = t18 / t10 / t9;
  t122 = -0.2e1 / 0.27e2 * t3 * t115 - 0.2e1 / 0.27e2 * t14 * t119;
  t123 = params->ap * t122;
  t124 = t123 * t68;
  t125 = t66 * t66;
  t127 = t23 * t23;
  t128 = 0.1e1 / t127;
  t129 = params->ap * t125 * t128;
  t133 = -0.2e1 / 0.27e2 * t26 * t115 - 0.2e1 / 0.27e2 * t29 * t119;
  t134 = params->af * t133;
  t136 = t74 * t74;
  t138 = t32 * t32;
  t139 = 0.1e1 / t138;
  t141 = -params->af * t136 * t139 + t134 * t76 - t124 + t129;
  t143 = t141 * t51 * t56;
  t145 = t78 * t92 * t56;
  t146 = 0.2e1 * t145;
  t147 = t43 * t43;
  t148 = 0.1e1 / t147;
  t149 = t84 * t84;
  t152 = t81 * t9;
  t153 = 0.1e1 / t152;
  t154 = t36 * t153;
  t156 = -0.2e1 * t82 + 0.2e1 * t154;
  t160 = my_piecewise3(t40, 0, 0.4e1 / 0.9e1 * t148 * t149 + 0.4e1 / 0.3e1 * t43 * t156);
  t161 = t48 * t48;
  t162 = 0.1e1 / t161;
  t163 = t88 * t88;
  t166 = -t156;
  t170 = my_piecewise3(t47, 0, 0.4e1 / 0.9e1 * t162 * t163 + 0.4e1 / 0.3e1 * t48 * t166);
  t171 = t160 + t170;
  t173 = t35 * t171 * t56;
  tv2rho20 = t110 + t111 + 0.2e1 * t94 + t9 * (t124 - t129 + t143 + t146 + t173);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t177 = t78 * t105 * t56;
  t178 = t148 * t97;
  t181 = t43 * t36;
  t185 = my_piecewise3(t40, 0, 0.4e1 / 0.9e1 * t178 * t84 + 0.8e1 / 0.3e1 * t181 * t153);
  t186 = t162 * t101;
  t189 = t48 * t36;
  t193 = my_piecewise3(t47, 0, 0.4e1 / 0.9e1 * t186 * t88 - 0.8e1 / 0.3e1 * t189 * t153);
  t194 = t185 + t193;
  t196 = t35 * t194 * t56;
  tv2rho21 = t110 + t111 + t94 + t107 + t9 * (t124 - t129 + t143 + t145 + t177 + t196);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t200 = 0.2e1 * t177;
  t201 = t97 * t97;
  t205 = 0.2e1 * t82 + 0.2e1 * t154;
  t209 = my_piecewise3(t40, 0, 0.4e1 / 0.9e1 * t148 * t201 + 0.4e1 / 0.3e1 * t43 * t205);
  t210 = t101 * t101;
  t213 = -t205;
  t217 = my_piecewise3(t47, 0, 0.4e1 / 0.9e1 * t162 * t210 + 0.4e1 / 0.3e1 * t48 * t213);
  t218 = t209 + t217;
  t220 = t35 * t218 * t56;
  tv2rho22 = t110 + t111 + 0.2e1 * t107 + t9 * (t124 - t129 + t143 + t200 + t220);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t11, t14, t15, t17, t18, t19, t20, t23;
  double t24, t25, t26, t29, t32, t33, t35, t36;
  double t37, t38, t39, t40, t41, t42, t43, t45;
  double t46, t47, t48, t50, t51, t53, t56, t57;
  double tzk0;

  double t59, t63, t66, t68, t69, t74, t76, t78;
  double t80, t81, t82, t83, t84, t87, t88, t91;
  double t92, t94, tvrho0, t97, t100, t101, t104, t105;
  double t107, tvrho1;

  double t110, t111, t115, t119, t122, t123, t124, t125;
  double t127, t128, t129, t133, t134, t136, t138, t139;
  double t141, t143, t145, t146, t147, t148, t149, t152;
  double t153, t154, t156, t160, t161, t162, t163, t166;
  double t170, t171, t173, tv2rho20, t177, t178, t181, t185;
  double t186, t189, t193, t194, t196, tv2rho21, t200, t201;
  double t205, t209, t210, t213, t217, t218, t220, tv2rho22;

  double t223, t224, t225, t230, t235, t239, t240, t241;
  double t242, t243, t247, t248, t249, t255, t257, t263;
  double t266, t268, t270, t271, t273, t276, t277, t280;
  double t283, t284, t285, t287, t291, t293, t294, t297;
  double t300, t304, t305, t307, tv3rho30, t311, t314, t316;
  double t317, t318, t321, t332, t333, t336, t347, t348;
  double t350, tv3rho31, t356, t357, t362, t367, t371, t372;
  double t377, t380, t384, t385, t387, tv3rho32, t392, t394;
  double t400, t404, t405, t410, t414, t415, t417, tv3rho33;

  lda_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (lda_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = rho[0] + rho[1];
  t10 = POW_1_3(t9);
  t11 = t8 * t10;
  t14 = params->cp * t1;
  t15 = t5 * t5;
  t17 = t7 * t7;
  t18 = 0.1e1 / t15 * t17;
  t19 = t10 * t10;
  t20 = t18 * t19;
  t23 = 0.1e1 + t3 * t11 / 0.3e1 + t14 * t20 / 0.3e1;
  t24 = log(t23);
  t25 = params->ap * t24;
  t26 = params->bf * t2;
  t29 = params->cf * t1;
  t32 = 0.1e1 + t26 * t11 / 0.3e1 + t29 * t20 / 0.3e1;
  t33 = log(t32);
  t35 = params->af * t33 - t25;
  t36 = rho[0] - rho[1];
  t37 = 0.1e1 / t9;
  t38 = t36 * t37;
  t39 = 0.1e1 + t38;
  t40 = t39 <= p->zeta_threshold;
  t41 = POW_1_3(p->zeta_threshold);
  t42 = t41 * p->zeta_threshold;
  t43 = POW_1_3(t39);
  t45 = my_piecewise3(t40, t42, t43 * t39);
  t46 = 0.1e1 - t38;
  t47 = t46 <= p->zeta_threshold;
  t48 = POW_1_3(t46);
  t50 = my_piecewise3(t47, t42, t48 * t46);
  t51 = t45 + t50 - 0.2e1;
  t53 = M_CBRT2;
  t56 = 0.1e1 / (0.2e1 * t53 - 0.2e1);
  t57 = t35 * t51 * t56;
  tzk0 = t25 + t57;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t59 = t8 / t19;
  t63 = t18 / t10;
  t66 = t3 * t59 / 0.9e1 + 0.2e1 / 0.9e1 * t14 * t63;
  t68 = 0.1e1 / t23;
  t69 = params->ap * t66 * t68;
  t74 = t26 * t59 / 0.9e1 + 0.2e1 / 0.9e1 * t29 * t63;
  t76 = 0.1e1 / t32;
  t78 = params->af * t74 * t76 - t69;
  t80 = t78 * t51 * t56;
  t81 = t9 * t9;
  t82 = 0.1e1 / t81;
  t83 = t36 * t82;
  t84 = t37 - t83;
  t87 = my_piecewise3(t40, 0, 0.4e1 / 0.3e1 * t43 * t84);
  t88 = -t84;
  t91 = my_piecewise3(t47, 0, 0.4e1 / 0.3e1 * t48 * t88);
  t92 = t87 + t91;
  t94 = t35 * t92 * t56;
  tvrho0 = t25 + t57 + t9 * (t69 + t80 + t94);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t97 = -t37 - t83;
  t100 = my_piecewise3(t40, 0, 0.4e1 / 0.3e1 * t43 * t97);
  t101 = -t97;
  t104 = my_piecewise3(t47, 0, 0.4e1 / 0.3e1 * t48 * t101);
  t105 = t100 + t104;
  t107 = t35 * t105 * t56;
  tvrho1 = t25 + t57 + t9 * (t69 + t80 + t107);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t110 = 0.2e1 * t69;
  t111 = 0.2e1 * t80;
  t115 = t8 / t19 / t9;
  t119 = t18 / t10 / t9;
  t122 = -0.2e1 / 0.27e2 * t3 * t115 - 0.2e1 / 0.27e2 * t14 * t119;
  t123 = params->ap * t122;
  t124 = t123 * t68;
  t125 = t66 * t66;
  t127 = t23 * t23;
  t128 = 0.1e1 / t127;
  t129 = params->ap * t125 * t128;
  t133 = -0.2e1 / 0.27e2 * t26 * t115 - 0.2e1 / 0.27e2 * t29 * t119;
  t134 = params->af * t133;
  t136 = t74 * t74;
  t138 = t32 * t32;
  t139 = 0.1e1 / t138;
  t141 = -params->af * t136 * t139 + t134 * t76 - t124 + t129;
  t143 = t141 * t51 * t56;
  t145 = t78 * t92 * t56;
  t146 = 0.2e1 * t145;
  t147 = t43 * t43;
  t148 = 0.1e1 / t147;
  t149 = t84 * t84;
  t152 = t81 * t9;
  t153 = 0.1e1 / t152;
  t154 = t36 * t153;
  t156 = -0.2e1 * t82 + 0.2e1 * t154;
  t160 = my_piecewise3(t40, 0, 0.4e1 / 0.9e1 * t148 * t149 + 0.4e1 / 0.3e1 * t43 * t156);
  t161 = t48 * t48;
  t162 = 0.1e1 / t161;
  t163 = t88 * t88;
  t166 = -t156;
  t170 = my_piecewise3(t47, 0, 0.4e1 / 0.9e1 * t162 * t163 + 0.4e1 / 0.3e1 * t48 * t166);
  t171 = t160 + t170;
  t173 = t35 * t171 * t56;
  tv2rho20 = t110 + t111 + 0.2e1 * t94 + t9 * (t124 - t129 + t143 + t146 + t173);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t177 = t78 * t105 * t56;
  t178 = t148 * t97;
  t181 = t43 * t36;
  t185 = my_piecewise3(t40, 0, 0.4e1 / 0.9e1 * t178 * t84 + 0.8e1 / 0.3e1 * t181 * t153);
  t186 = t162 * t101;
  t189 = t48 * t36;
  t193 = my_piecewise3(t47, 0, 0.4e1 / 0.9e1 * t186 * t88 - 0.8e1 / 0.3e1 * t189 * t153);
  t194 = t185 + t193;
  t196 = t35 * t194 * t56;
  tv2rho21 = t110 + t111 + t94 + t107 + t9 * (t124 - t129 + t143 + t145 + t177 + t196);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t200 = 0.2e1 * t177;
  t201 = t97 * t97;
  t205 = 0.2e1 * t82 + 0.2e1 * t154;
  t209 = my_piecewise3(t40, 0, 0.4e1 / 0.9e1 * t148 * t201 + 0.4e1 / 0.3e1 * t43 * t205);
  t210 = t101 * t101;
  t213 = -t205;
  t217 = my_piecewise3(t47, 0, 0.4e1 / 0.9e1 * t162 * t210 + 0.4e1 / 0.3e1 * t48 * t213);
  t218 = t209 + t217;
  t220 = t35 * t218 * t56;
  tv2rho22 = t110 + t111 + 0.2e1 * t107 + t9 * (t124 - t129 + t143 + t200 + t220);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t223 = 0.3e1 * t124;
  t224 = 0.3e1 * t129;
  t225 = 0.3e1 * t143;
  t230 = t8 / t19 / t81;
  t235 = t18 / t10 / t81;
  t239 = params->ap * (0.1e2 / 0.81e2 * t3 * t230 + 0.8e1 / 0.81e2 * t14 * t235);
  t240 = t239 * t68;
  t241 = t128 * t66;
  t242 = t123 * t241;
  t243 = 0.3e1 * t242;
  t247 = 0.1e1 / t127 / t23;
  t248 = params->ap * t125 * t66 * t247;
  t249 = 0.2e1 * t248;
  t255 = params->af * (0.1e2 / 0.81e2 * t26 * t230 + 0.8e1 / 0.81e2 * t29 * t235);
  t257 = t139 * t74;
  t263 = 0.1e1 / t138 / t32;
  t266 = 0.2e1 * params->af * t136 * t74 * t263 - 0.3e1 * t134 * t257 + t255 * t76 - t240 + t243 - t249;
  t268 = t266 * t51 * t56;
  t270 = t141 * t92 * t56;
  t271 = 0.3e1 * t270;
  t273 = t78 * t171 * t56;
  t276 = 0.1e1 / t147 / t39;
  t277 = t149 * t84;
  t280 = t148 * t84;
  t283 = t81 * t81;
  t284 = 0.1e1 / t283;
  t285 = t36 * t284;
  t287 = 0.6e1 * t153 - 0.6e1 * t285;
  t291 = my_piecewise3(t40, 0, -0.8e1 / 0.27e2 * t276 * t277 + 0.4e1 / 0.3e1 * t280 * t156 + 0.4e1 / 0.3e1 * t43 * t287);
  t293 = 0.1e1 / t161 / t46;
  t294 = t163 * t88;
  t297 = t162 * t88;
  t300 = -t287;
  t304 = my_piecewise3(t47, 0, -0.8e1 / 0.27e2 * t293 * t294 + 0.4e1 / 0.3e1 * t297 * t166 + 0.4e1 / 0.3e1 * t48 * t300);
  t305 = t291 + t304;
  t307 = t35 * t305 * t56;
  tv3rho30 = t223 - t224 + t225 + 0.6e1 * t145 + 0.3e1 * t173 + t9 * (t240 - t243 + t249 + t268 + t271 + 0.3e1 * t273 + t307);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t311 = 0.2e1 * t196;
  t314 = t141 * t105 * t56;
  t316 = t78 * t194 * t56;
  t317 = 0.2e1 * t316;
  t318 = t276 * t97;
  t321 = t148 * t36;
  t332 = my_piecewise3(t40, 0, -0.8e1 / 0.27e2 * t318 * t149 + 0.16e2 / 0.9e1 * t321 * t153 * t84 + 0.4e1 / 0.9e1 * t178 * t156 + 0.8e1 / 0.3e1 * t43 * t153 - 0.8e1 * t181 * t284);
  t333 = t293 * t101;
  t336 = t162 * t36;
  t347 = my_piecewise3(t47, 0, -0.8e1 / 0.27e2 * t333 * t163 - 0.16e2 / 0.9e1 * t336 * t153 * t88 + 0.4e1 / 0.9e1 * t186 * t166 - 0.8e1 / 0.3e1 * t48 * t153 + 0.8e1 * t189 * t284);
  t348 = t332 + t347;
  t350 = t35 * t348 * t56;
  tv3rho31 = t223 - t224 + t225 + 0.4e1 * t145 + t173 + t200 + t311 + t9 * (t240 - t243 + t249 + t268 + 0.2e1 * t270 + t273 + t314 + t317 + t350);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t356 = t78 * t218 * t56;
  t357 = t276 * t201;
  t362 = t148 * t205;
  t367 = -0.2e1 * t153 - 0.6e1 * t285;
  t371 = my_piecewise3(t40, 0, -0.8e1 / 0.27e2 * t357 * t84 + 0.16e2 / 0.9e1 * t178 * t154 + 0.4e1 / 0.9e1 * t362 * t84 + 0.4e1 / 0.3e1 * t43 * t367);
  t372 = t293 * t210;
  t377 = t162 * t213;
  t380 = -t367;
  t384 = my_piecewise3(t47, 0, -0.8e1 / 0.27e2 * t372 * t88 - 0.16e2 / 0.9e1 * t186 * t154 + 0.4e1 / 0.9e1 * t377 * t88 + 0.4e1 / 0.3e1 * t48 * t380);
  t385 = t371 + t384;
  t387 = t35 * t385 * t56;
  tv3rho32 = t223 - t224 + t225 + t146 + 0.4e1 * t177 + t311 + t220 + t9 * (t240 - t243 + t249 + t268 + t270 + 0.2e1 * t314 + t317 + t356 + t387);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t392 = 0.3e1 * t314;
  t394 = t201 * t97;
  t400 = -0.6e1 * t153 - 0.6e1 * t285;
  t404 = my_piecewise3(t40, 0, -0.8e1 / 0.27e2 * t276 * t394 + 0.4e1 / 0.3e1 * t178 * t205 + 0.4e1 / 0.3e1 * t43 * t400);
  t405 = t210 * t101;
  t410 = -t400;
  t414 = my_piecewise3(t47, 0, -0.8e1 / 0.27e2 * t293 * t405 + 0.4e1 / 0.3e1 * t186 * t213 + 0.4e1 / 0.3e1 * t48 * t410);
  t415 = t404 + t414;
  t417 = t35 * t415 * t56;
  tv3rho33 = t223 - t224 + t225 + 0.6e1 * t177 + 0.3e1 * t220 + t9 * (t240 - t243 + t249 + t268 + t392 + 0.3e1 * t356 + t417);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t11, t14, t15, t17, t18, t19, t20, t23;
  double t24, t25, t26, t29, t32, t33, t35, t36;
  double t37, t38, t39, t40, t41, t42, t43, t45;
  double t46, t47, t48, t50, t51, t53, t56, t57;
  double tzk0;

  double t59, t63, t66, t68, t69, t74, t76, t78;
  double t80, t81, t82, t83, t84, t87, t88, t91;
  double t92, t94, tvrho0, t97, t100, t101, t104, t105;
  double t107, tvrho1;

  double t110, t111, t115, t119, t122, t123, t124, t125;
  double t127, t128, t129, t133, t134, t136, t138, t139;
  double t141, t143, t145, t146, t147, t148, t149, t152;
  double t153, t154, t156, t160, t161, t162, t163, t166;
  double t170, t171, t173, tv2rho20, t177, t178, t181, t185;
  double t186, t189, t193, t194, t196, tv2rho21, t200, t201;
  double t205, t209, t210, t213, t217, t218, t220, tv2rho22;

  double t223, t224, t225, t230, t235, t239, t240, t241;
  double t242, t243, t247, t248, t249, t255, t257, t263;
  double t266, t268, t270, t271, t273, t276, t277, t280;
  double t283, t284, t285, t287, t291, t293, t294, t297;
  double t300, t304, t305, t307, tv3rho30, t311, t314, t316;
  double t317, t318, t321, t332, t333, t336, t347, t348;
  double t350, tv3rho31, t356, t357, t362, t367, t371, t372;
  double t377, t380, t384, t385, t387, tv3rho32, t392, t394;
  double t400, t404, t405, t410, t414, t415, t417, tv3rho33;

  double t420, t421, t422, t423, t429, t434, t439, t441;
  double t444, t445, t448, t449, t451, t454, t467, t471;
  double t473, t479, t481, t484, t487, t489, t491, t492;
  double t498, t504, t505, t507, t511, t512, t514, t515;
  double t521, t530, tv4rho40, t538, t543, t545, t546, t548;
  double t574, t576, t601, t603, t607, tv4rho41, t621, t623;
  double t634, t637, t653, t679, t683, tv4rho42, t692, t711;
  double t715, t736, t740, tv4rho43, t748, t753, t759, t763;
  double t764, t769, t778, tv4rho44;

  lda_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (lda_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = rho[0] + rho[1];
  t10 = POW_1_3(t9);
  t11 = t8 * t10;
  t14 = params->cp * t1;
  t15 = t5 * t5;
  t17 = t7 * t7;
  t18 = 0.1e1 / t15 * t17;
  t19 = t10 * t10;
  t20 = t18 * t19;
  t23 = 0.1e1 + t3 * t11 / 0.3e1 + t14 * t20 / 0.3e1;
  t24 = log(t23);
  t25 = params->ap * t24;
  t26 = params->bf * t2;
  t29 = params->cf * t1;
  t32 = 0.1e1 + t26 * t11 / 0.3e1 + t29 * t20 / 0.3e1;
  t33 = log(t32);
  t35 = params->af * t33 - t25;
  t36 = rho[0] - rho[1];
  t37 = 0.1e1 / t9;
  t38 = t36 * t37;
  t39 = 0.1e1 + t38;
  t40 = t39 <= p->zeta_threshold;
  t41 = POW_1_3(p->zeta_threshold);
  t42 = t41 * p->zeta_threshold;
  t43 = POW_1_3(t39);
  t45 = my_piecewise3(t40, t42, t43 * t39);
  t46 = 0.1e1 - t38;
  t47 = t46 <= p->zeta_threshold;
  t48 = POW_1_3(t46);
  t50 = my_piecewise3(t47, t42, t48 * t46);
  t51 = t45 + t50 - 0.2e1;
  t53 = M_CBRT2;
  t56 = 0.1e1 / (0.2e1 * t53 - 0.2e1);
  t57 = t35 * t51 * t56;
  tzk0 = t25 + t57;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t59 = t8 / t19;
  t63 = t18 / t10;
  t66 = t3 * t59 / 0.9e1 + 0.2e1 / 0.9e1 * t14 * t63;
  t68 = 0.1e1 / t23;
  t69 = params->ap * t66 * t68;
  t74 = t26 * t59 / 0.9e1 + 0.2e1 / 0.9e1 * t29 * t63;
  t76 = 0.1e1 / t32;
  t78 = params->af * t74 * t76 - t69;
  t80 = t78 * t51 * t56;
  t81 = t9 * t9;
  t82 = 0.1e1 / t81;
  t83 = t36 * t82;
  t84 = t37 - t83;
  t87 = my_piecewise3(t40, 0, 0.4e1 / 0.3e1 * t43 * t84);
  t88 = -t84;
  t91 = my_piecewise3(t47, 0, 0.4e1 / 0.3e1 * t48 * t88);
  t92 = t87 + t91;
  t94 = t35 * t92 * t56;
  tvrho0 = t25 + t57 + t9 * (t69 + t80 + t94);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t97 = -t37 - t83;
  t100 = my_piecewise3(t40, 0, 0.4e1 / 0.3e1 * t43 * t97);
  t101 = -t97;
  t104 = my_piecewise3(t47, 0, 0.4e1 / 0.3e1 * t48 * t101);
  t105 = t100 + t104;
  t107 = t35 * t105 * t56;
  tvrho1 = t25 + t57 + t9 * (t69 + t80 + t107);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t110 = 0.2e1 * t69;
  t111 = 0.2e1 * t80;
  t115 = t8 / t19 / t9;
  t119 = t18 / t10 / t9;
  t122 = -0.2e1 / 0.27e2 * t3 * t115 - 0.2e1 / 0.27e2 * t14 * t119;
  t123 = params->ap * t122;
  t124 = t123 * t68;
  t125 = t66 * t66;
  t127 = t23 * t23;
  t128 = 0.1e1 / t127;
  t129 = params->ap * t125 * t128;
  t133 = -0.2e1 / 0.27e2 * t26 * t115 - 0.2e1 / 0.27e2 * t29 * t119;
  t134 = params->af * t133;
  t136 = t74 * t74;
  t138 = t32 * t32;
  t139 = 0.1e1 / t138;
  t141 = -params->af * t136 * t139 + t134 * t76 - t124 + t129;
  t143 = t141 * t51 * t56;
  t145 = t78 * t92 * t56;
  t146 = 0.2e1 * t145;
  t147 = t43 * t43;
  t148 = 0.1e1 / t147;
  t149 = t84 * t84;
  t152 = t81 * t9;
  t153 = 0.1e1 / t152;
  t154 = t36 * t153;
  t156 = -0.2e1 * t82 + 0.2e1 * t154;
  t160 = my_piecewise3(t40, 0, 0.4e1 / 0.9e1 * t148 * t149 + 0.4e1 / 0.3e1 * t43 * t156);
  t161 = t48 * t48;
  t162 = 0.1e1 / t161;
  t163 = t88 * t88;
  t166 = -t156;
  t170 = my_piecewise3(t47, 0, 0.4e1 / 0.9e1 * t162 * t163 + 0.4e1 / 0.3e1 * t48 * t166);
  t171 = t160 + t170;
  t173 = t35 * t171 * t56;
  tv2rho20 = t110 + t111 + 0.2e1 * t94 + t9 * (t124 - t129 + t143 + t146 + t173);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t177 = t78 * t105 * t56;
  t178 = t148 * t97;
  t181 = t43 * t36;
  t185 = my_piecewise3(t40, 0, 0.4e1 / 0.9e1 * t178 * t84 + 0.8e1 / 0.3e1 * t181 * t153);
  t186 = t162 * t101;
  t189 = t48 * t36;
  t193 = my_piecewise3(t47, 0, 0.4e1 / 0.9e1 * t186 * t88 - 0.8e1 / 0.3e1 * t189 * t153);
  t194 = t185 + t193;
  t196 = t35 * t194 * t56;
  tv2rho21 = t110 + t111 + t94 + t107 + t9 * (t124 - t129 + t143 + t145 + t177 + t196);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t200 = 0.2e1 * t177;
  t201 = t97 * t97;
  t205 = 0.2e1 * t82 + 0.2e1 * t154;
  t209 = my_piecewise3(t40, 0, 0.4e1 / 0.9e1 * t148 * t201 + 0.4e1 / 0.3e1 * t43 * t205);
  t210 = t101 * t101;
  t213 = -t205;
  t217 = my_piecewise3(t47, 0, 0.4e1 / 0.9e1 * t162 * t210 + 0.4e1 / 0.3e1 * t48 * t213);
  t218 = t209 + t217;
  t220 = t35 * t218 * t56;
  tv2rho22 = t110 + t111 + 0.2e1 * t107 + t9 * (t124 - t129 + t143 + t200 + t220);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t223 = 0.3e1 * t124;
  t224 = 0.3e1 * t129;
  t225 = 0.3e1 * t143;
  t230 = t8 / t19 / t81;
  t235 = t18 / t10 / t81;
  t239 = params->ap * (0.1e2 / 0.81e2 * t3 * t230 + 0.8e1 / 0.81e2 * t14 * t235);
  t240 = t239 * t68;
  t241 = t128 * t66;
  t242 = t123 * t241;
  t243 = 0.3e1 * t242;
  t247 = 0.1e1 / t127 / t23;
  t248 = params->ap * t125 * t66 * t247;
  t249 = 0.2e1 * t248;
  t255 = params->af * (0.1e2 / 0.81e2 * t26 * t230 + 0.8e1 / 0.81e2 * t29 * t235);
  t257 = t139 * t74;
  t263 = 0.1e1 / t138 / t32;
  t266 = 0.2e1 * params->af * t136 * t74 * t263 - 0.3e1 * t134 * t257 + t255 * t76 - t240 + t243 - t249;
  t268 = t266 * t51 * t56;
  t270 = t141 * t92 * t56;
  t271 = 0.3e1 * t270;
  t273 = t78 * t171 * t56;
  t276 = 0.1e1 / t147 / t39;
  t277 = t149 * t84;
  t280 = t148 * t84;
  t283 = t81 * t81;
  t284 = 0.1e1 / t283;
  t285 = t36 * t284;
  t287 = 0.6e1 * t153 - 0.6e1 * t285;
  t291 = my_piecewise3(t40, 0, -0.8e1 / 0.27e2 * t276 * t277 + 0.4e1 / 0.3e1 * t280 * t156 + 0.4e1 / 0.3e1 * t43 * t287);
  t293 = 0.1e1 / t161 / t46;
  t294 = t163 * t88;
  t297 = t162 * t88;
  t300 = -t287;
  t304 = my_piecewise3(t47, 0, -0.8e1 / 0.27e2 * t293 * t294 + 0.4e1 / 0.3e1 * t297 * t166 + 0.4e1 / 0.3e1 * t48 * t300);
  t305 = t291 + t304;
  t307 = t35 * t305 * t56;
  tv3rho30 = t223 - t224 + t225 + 0.6e1 * t145 + 0.3e1 * t173 + t9 * (t240 - t243 + t249 + t268 + t271 + 0.3e1 * t273 + t307);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t311 = 0.2e1 * t196;
  t314 = t141 * t105 * t56;
  t316 = t78 * t194 * t56;
  t317 = 0.2e1 * t316;
  t318 = t276 * t97;
  t321 = t148 * t36;
  t332 = my_piecewise3(t40, 0, -0.8e1 / 0.27e2 * t318 * t149 + 0.16e2 / 0.9e1 * t321 * t153 * t84 + 0.4e1 / 0.9e1 * t178 * t156 + 0.8e1 / 0.3e1 * t43 * t153 - 0.8e1 * t181 * t284);
  t333 = t293 * t101;
  t336 = t162 * t36;
  t347 = my_piecewise3(t47, 0, -0.8e1 / 0.27e2 * t333 * t163 - 0.16e2 / 0.9e1 * t336 * t153 * t88 + 0.4e1 / 0.9e1 * t186 * t166 - 0.8e1 / 0.3e1 * t48 * t153 + 0.8e1 * t189 * t284);
  t348 = t332 + t347;
  t350 = t35 * t348 * t56;
  tv3rho31 = t223 - t224 + t225 + 0.4e1 * t145 + t173 + t200 + t311 + t9 * (t240 - t243 + t249 + t268 + 0.2e1 * t270 + t273 + t314 + t317 + t350);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t356 = t78 * t218 * t56;
  t357 = t276 * t201;
  t362 = t148 * t205;
  t367 = -0.2e1 * t153 - 0.6e1 * t285;
  t371 = my_piecewise3(t40, 0, -0.8e1 / 0.27e2 * t357 * t84 + 0.16e2 / 0.9e1 * t178 * t154 + 0.4e1 / 0.9e1 * t362 * t84 + 0.4e1 / 0.3e1 * t43 * t367);
  t372 = t293 * t210;
  t377 = t162 * t213;
  t380 = -t367;
  t384 = my_piecewise3(t47, 0, -0.8e1 / 0.27e2 * t372 * t88 - 0.16e2 / 0.9e1 * t186 * t154 + 0.4e1 / 0.9e1 * t377 * t88 + 0.4e1 / 0.3e1 * t48 * t380);
  t385 = t371 + t384;
  t387 = t35 * t385 * t56;
  tv3rho32 = t223 - t224 + t225 + t146 + 0.4e1 * t177 + t311 + t220 + t9 * (t240 - t243 + t249 + t268 + t270 + 0.2e1 * t314 + t317 + t356 + t387);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t392 = 0.3e1 * t314;
  t394 = t201 * t97;
  t400 = -0.6e1 * t153 - 0.6e1 * t285;
  t404 = my_piecewise3(t40, 0, -0.8e1 / 0.27e2 * t276 * t394 + 0.4e1 / 0.3e1 * t178 * t205 + 0.4e1 / 0.3e1 * t43 * t400);
  t405 = t210 * t101;
  t410 = -t400;
  t414 = my_piecewise3(t47, 0, -0.8e1 / 0.27e2 * t293 * t405 + 0.4e1 / 0.3e1 * t186 * t213 + 0.4e1 / 0.3e1 * t48 * t410);
  t415 = t404 + t414;
  t417 = t35 * t415 * t56;
  tv3rho33 = t223 - t224 + t225 + 0.6e1 * t177 + 0.3e1 * t220 + t9 * (t240 - t243 + t249 + t268 + t392 + 0.3e1 * t356 + t417);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t420 = 0.4e1 * t240;
  t421 = 0.12e2 * t242;
  t422 = 0.8e1 * t248;
  t423 = 0.4e1 * t268;
  t429 = t8 / t19 / t152;
  t434 = t18 / t10 / t152;
  t439 = params->ap * (-0.8e2 / 0.243e3 * t3 * t429 - 0.56e2 / 0.243e3 * t14 * t434) * t68;
  t441 = 0.4e1 * t239 * t241;
  t444 = 0.12e2 * t123 * t247 * t125;
  t445 = t122 * t122;
  t448 = 0.3e1 * params->ap * t445 * t128;
  t449 = t125 * t125;
  t451 = t127 * t127;
  t454 = 0.6e1 * params->ap * t449 / t451;
  t467 = t133 * t133;
  t471 = t136 * t136;
  t473 = t138 * t138;
  t479 = (params->af * (-0.8e2 / 0.243e3 * t26 * t429 - 0.56e2 / 0.243e3 * t29 * t434) * t76 - 0.4e1 * t255 * t257 + 0.12e2 * t134 * t263 * t136 - 0.3e1 * params->af * t467 * t139 - 0.6e1 * params->af * t471 / t473 - t439 + t441 - t444 + t448 + t454) * t51 * t56;
  t481 = t266 * t92 * t56;
  t484 = t141 * t171 * t56;
  t487 = t78 * t305 * t56;
  t489 = t39 * t39;
  t491 = 0.1e1 / t147 / t489;
  t492 = t149 * t149;
  t498 = t156 * t156;
  t504 = 0.1e1 / t283 / t9;
  t505 = t36 * t504;
  t507 = -0.24e2 * t284 + 0.24e2 * t505;
  t511 = my_piecewise3(t40, 0, 0.4e2 / 0.81e2 * t491 * t492 - 0.16e2 / 0.9e1 * t276 * t149 * t156 + 0.4e1 / 0.3e1 * t148 * t498 + 0.16e2 / 0.9e1 * t280 * t287 + 0.4e1 / 0.3e1 * t43 * t507);
  t512 = t46 * t46;
  t514 = 0.1e1 / t161 / t512;
  t515 = t163 * t163;
  t521 = t166 * t166;
  t530 = my_piecewise3(t47, 0, 0.4e2 / 0.81e2 * t514 * t515 - 0.16e2 / 0.9e1 * t293 * t163 * t166 + 0.4e1 / 0.3e1 * t162 * t521 + 0.16e2 / 0.9e1 * t297 * t300 - 0.4e1 / 0.3e1 * t48 * t507);
  tv4rho40 = t420 - t421 + t422 + t423 + 0.12e2 * t270 + 0.12e2 * t273 + 0.4e1 * t307 + t9 * (t439 - t441 + t444 - t448 - t454 + t479 + 0.4e1 * t481 + 0.6e1 * t484 + 0.4e1 * t487 + t35 * (t511 + t530) * t56);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t538 = 0.6e1 * t316;
  t543 = t266 * t105 * t56;
  t545 = t141 * t194 * t56;
  t546 = 0.3e1 * t545;
  t548 = t78 * t348 * t56;
  t574 = 0.32e2 * t181 * t504;
  t576 = my_piecewise3(t40, 0, 0.4e2 / 0.81e2 * t491 * t97 * t277 - 0.16e2 / 0.9e1 * t276 * t36 * t153 * t149 - 0.8e1 / 0.9e1 * t318 * t84 * t156 + 0.8e1 / 0.3e1 * t148 * t153 * t84 - 0.8e1 * t321 * t284 * t84 + 0.8e1 / 0.3e1 * t321 * t153 * t156 + 0.4e1 / 0.9e1 * t178 * t287 - 0.16e2 * t43 * t284 + t574);
  t601 = 0.32e2 * t189 * t504;
  t603 = my_piecewise3(t47, 0, 0.4e2 / 0.81e2 * t514 * t101 * t294 + 0.16e2 / 0.9e1 * t293 * t36 * t153 * t163 - 0.8e1 / 0.9e1 * t333 * t88 * t166 - 0.8e1 / 0.3e1 * t162 * t153 * t88 + 0.8e1 * t336 * t284 * t88 - 0.8e1 / 0.3e1 * t336 * t153 * t166 + 0.4e1 / 0.9e1 * t186 * t300 + 0.16e2 * t48 * t284 - t601);
  t607 = t439 - t441 + t444 - t448 - t454 + t479 + 0.3e1 * t481 + 0.3e1 * t484 + t487 + t543 + t546 + 0.3e1 * t548 + t35 * (t576 + t603) * t56;
  tv4rho41 = t9 * t607 + 0.9e1 * t270 + 0.6e1 * t273 + t307 + 0.3e1 * t350 + t392 + t420 - t421 + t422 + t423 + t538;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t621 = t141 * t218 * t56;
  t623 = t78 * t385 * t56;
  t634 = t36 * t36;
  t637 = 0.1e1 / t283 / t81;
  t653 = my_piecewise3(t40, 0, 0.4e2 / 0.81e2 * t491 * t201 * t149 - 0.64e2 / 0.27e2 * t318 * t84 * t36 * t153 - 0.8e1 / 0.27e2 * t357 * t156 + 0.32e2 / 0.9e1 * t148 * t634 * t637 + 0.16e2 / 0.9e1 * t178 * t153 - 0.16e2 / 0.3e1 * t178 * t285 - 0.8e1 / 0.27e2 * t276 * t205 * t149 + 0.8e1 / 0.9e1 * t148 * t367 * t84 + 0.4e1 / 0.9e1 * t362 * t156 + t574);
  t679 = my_piecewise3(t47, 0, 0.4e2 / 0.81e2 * t514 * t210 * t163 + 0.64e2 / 0.27e2 * t333 * t88 * t36 * t153 - 0.8e1 / 0.27e2 * t372 * t166 + 0.32e2 / 0.9e1 * t162 * t634 * t637 - 0.16e2 / 0.9e1 * t186 * t153 + 0.16e2 / 0.3e1 * t186 * t285 - 0.8e1 / 0.27e2 * t293 * t213 * t163 + 0.8e1 / 0.9e1 * t162 * t380 * t88 + 0.4e1 / 0.9e1 * t377 * t166 - t601);
  t683 = t439 - t441 + t444 - t448 - t454 + t479 + 0.2e1 * t481 + t484 + 0.2e1 * t543 + 0.4e1 * t545 + 0.2e1 * t548 + t621 + 0.2e1 * t623 + t35 * (t653 + t679) * t56;
  tv4rho42 = t9 * t683 + 0.6e1 * t270 + 0.2e1 * t273 + 0.6e1 * t314 + 0.8e1 * t316 + 0.2e1 * t350 + 0.2e1 * t356 + 0.2e1 * t387 + t420 - t421 + t422 + t423;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t692 = t78 * t415 * t56;
  t711 = 0.12e2 * t284 + 0.24e2 * t505;
  t715 = my_piecewise3(t40, 0, 0.4e2 / 0.81e2 * t491 * t394 * t84 - 0.16e2 / 0.9e1 * t357 * t154 - 0.8e1 / 0.9e1 * t318 * t205 * t84 + 0.8e1 / 0.3e1 * t321 * t153 * t205 + 0.4e1 / 0.3e1 * t178 * t367 + 0.4e1 / 0.9e1 * t148 * t400 * t84 + 0.4e1 / 0.3e1 * t43 * t711);
  t736 = my_piecewise3(t47, 0, 0.4e2 / 0.81e2 * t514 * t405 * t88 + 0.16e2 / 0.9e1 * t372 * t154 - 0.8e1 / 0.9e1 * t333 * t213 * t88 - 0.8e1 / 0.3e1 * t336 * t153 * t213 + 0.4e1 / 0.3e1 * t186 * t380 + 0.4e1 / 0.9e1 * t162 * t410 * t88 - 0.4e1 / 0.3e1 * t48 * t711);
  t740 = t439 - t441 + t444 - t448 - t454 + t479 + t481 + 0.3e1 * t543 + t546 + 0.3e1 * t621 + 0.3e1 * t623 + t692 + t35 * (t715 + t736) * t56;
  tv4rho43 = t9 * t740 + t271 + 0.9e1 * t314 + 0.6e1 * t356 + 0.3e1 * t387 + t417 + t420 - t421 + t422 + t423 + t538;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t748 = t201 * t201;
  t753 = t205 * t205;
  t759 = 0.24e2 * t284 + 0.24e2 * t505;
  t763 = my_piecewise3(t40, 0, 0.4e2 / 0.81e2 * t491 * t748 - 0.16e2 / 0.9e1 * t357 * t205 + 0.4e1 / 0.3e1 * t148 * t753 + 0.16e2 / 0.9e1 * t178 * t400 + 0.4e1 / 0.3e1 * t43 * t759);
  t764 = t210 * t210;
  t769 = t213 * t213;
  t778 = my_piecewise3(t47, 0, 0.4e2 / 0.81e2 * t514 * t764 - 0.16e2 / 0.9e1 * t372 * t213 + 0.4e1 / 0.3e1 * t162 * t769 + 0.16e2 / 0.9e1 * t186 * t410 - 0.4e1 / 0.3e1 * t48 * t759);
  tv4rho44 = t420 - t421 + t422 + t423 + 0.12e2 * t314 + 0.12e2 * t356 + 0.4e1 * t417 + t9 * (t439 - t441 + t444 - t448 - t454 + t479 + 0.4e1 * t543 + 0.6e1 * t621 + 0.4e1 * t692 + t35 * (t763 + t778) * t56);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

}

#endif

