; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple aarch64-none-linux-gnu | FileCheck %s

; Supported combines

define <8 x i16> @dupsext_v8i8_v8i16(i8 %src, <8 x i8> %b) {
; CHECK-LABEL: dupsext_v8i8_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.8b, w0
; CHECK-NEXT:    smull v0.8h, v1.8b, v0.8b
; CHECK-NEXT:    ret
entry:
    %in = sext i8 %src to i16
    %ext.b = sext <8 x i8> %b to <8 x i16>
    %broadcast.splatinsert = insertelement <8 x i16> undef, i16 %in, i16 0
    %broadcast.splat = shufflevector <8 x i16> %broadcast.splatinsert, <8 x i16> undef, <8 x i32> zeroinitializer
    %out = mul nsw <8 x i16> %broadcast.splat, %ext.b
    ret <8 x i16> %out
}

define <8 x i16> @dupzext_v8i8_v8i16(i8 %src, <8 x i8> %b) {
; CHECK-LABEL: dupzext_v8i8_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.8b, w0
; CHECK-NEXT:    umull v0.8h, v1.8b, v0.8b
; CHECK-NEXT:    ret
entry:
    %in = zext i8 %src to i16
    %ext.b = zext <8 x i8> %b to <8 x i16>
    %broadcast.splatinsert = insertelement <8 x i16> undef, i16 %in, i16 0
    %broadcast.splat = shufflevector <8 x i16> %broadcast.splatinsert, <8 x i16> undef, <8 x i32> zeroinitializer
    %out = mul nuw <8 x i16> %broadcast.splat, %ext.b
    ret <8 x i16> %out
}

define <4 x i32> @dupsext_v4i16_v4i32(i16 %src, <4 x i16> %b) {
; CHECK-LABEL: dupsext_v4i16_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.4h, w0
; CHECK-NEXT:    smull v0.4s, v1.4h, v0.4h
; CHECK-NEXT:    ret
entry:
    %in = sext i16 %src to i32
    %ext.b = sext <4 x i16> %b to <4 x i32>
    %broadcast.splatinsert = insertelement <4 x i32> undef, i32 %in, i32 0
    %broadcast.splat = shufflevector <4 x i32> %broadcast.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
    %out = mul nsw <4 x i32> %broadcast.splat, %ext.b
    ret <4 x i32> %out
}

define <4 x i32> @dupzext_v4i16_v4i32(i16 %src, <4 x i16> %b) {
; CHECK-LABEL: dupzext_v4i16_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.4h, w0
; CHECK-NEXT:    umull v0.4s, v1.4h, v0.4h
; CHECK-NEXT:    ret
entry:
    %in = zext i16 %src to i32
    %ext.b = zext <4 x i16> %b to <4 x i32>
    %broadcast.splatinsert = insertelement <4 x i32> undef, i32 %in, i32 0
    %broadcast.splat = shufflevector <4 x i32> %broadcast.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
    %out = mul nuw <4 x i32> %broadcast.splat, %ext.b
    ret <4 x i32> %out
}

define <2 x i64> @dupsext_v2i32_v2i64(i32 %src, <2 x i32> %b) {
; CHECK-LABEL: dupsext_v2i32_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.2s, w0
; CHECK-NEXT:    smull v0.2d, v1.2s, v0.2s
; CHECK-NEXT:    ret
entry:
    %in = sext i32 %src to i64
    %ext.b = sext <2 x i32> %b to <2 x i64>
    %broadcast.splatinsert = insertelement <2 x i64> undef, i64 %in, i64 0
    %broadcast.splat = shufflevector <2 x i64> %broadcast.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
    %out = mul nsw <2 x i64> %broadcast.splat, %ext.b
    ret <2 x i64> %out
}

define <2 x i64> @dupzext_v2i32_v2i64(i32 %src, <2 x i32> %b) {
; CHECK-LABEL: dupzext_v2i32_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.2s, w0
; CHECK-NEXT:    umull v0.2d, v1.2s, v0.2s
; CHECK-NEXT:    ret
entry:
    %in = zext i32 %src to i64
    %ext.b = zext <2 x i32> %b to <2 x i64>
    %broadcast.splatinsert = insertelement <2 x i64> undef, i64 %in, i64 0
    %broadcast.splat = shufflevector <2 x i64> %broadcast.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
    %out = mul nuw <2 x i64> %broadcast.splat, %ext.b
    ret <2 x i64> %out
}

; Unsupported combines

define <2 x i16> @dupsext_v2i8_v2i16(i8 %src, <2 x i8> %b) {
; CHECK-LABEL: dupsext_v2i8_v2i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    shl v0.2s, v0.2s, #24
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    dup v1.2s, w8
; CHECK-NEXT:    sshr v0.2s, v0.2s, #24
; CHECK-NEXT:    mul v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    ret
entry:
    %in = sext i8 %src to i16
    %ext.b = sext <2 x i8> %b to <2 x i16>
    %broadcast.splatinsert = insertelement <2 x i16> undef, i16 %in, i16 0
    %broadcast.splat = shufflevector <2 x i16> %broadcast.splatinsert, <2 x i16> undef, <2 x i32> zeroinitializer
    %out = mul nsw <2 x i16> %broadcast.splat, %ext.b
    ret <2 x i16> %out
}

define <2 x i64> @dupzext_v2i16_v2i64(i16 %src, <2 x i16> %b) {
; CHECK-LABEL: dupzext_v2i16_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d1, #0x00ffff0000ffff
; CHECK-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-NEXT:    and x8, x0, #0xffff
; CHECK-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    fmov x9, d0
; CHECK-NEXT:    mov x10, v0.d[1]
; CHECK-NEXT:    mul x9, x8, x9
; CHECK-NEXT:    mul x8, x8, x10
; CHECK-NEXT:    fmov d0, x9
; CHECK-NEXT:    mov v0.d[1], x8
; CHECK-NEXT:    ret
entry:
    %in = zext i16 %src to i64
    %ext.b = zext <2 x i16> %b to <2 x i64>
    %broadcast.splatinsert = insertelement <2 x i64> undef, i64 %in, i64 0
    %broadcast.splat = shufflevector <2 x i64> %broadcast.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
    %out = mul nuw <2 x i64> %broadcast.splat, %ext.b
    ret <2 x i64> %out
}

; dupsext_v4i8_v4i16
; dupsext_v2i8_v2i32
; dupsext_v4i8_v4i32
; dupsext_v2i8_v2i64
; dupsext_v2i16_v2i32
; dupsext_v2i16_v2i64
; dupzext_v2i8_v2i16
; dupzext_v4i8_v4i16
; dupzext_v2i8_v2i32
; dupzext_v4i8_v4i32
; dupzext_v2i8_v2i64
; dupzext_v2i16_v2i32
; dupzext_v2i16_v2i64

; Unsupported states

define <8 x i16> @nonsplat_shuffleinsert(i8 %src, <8 x i8> %b) {
; CHECK-LABEL: nonsplat_shuffleinsert:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    mul v0.8h, v1.8h, v0.8h
; CHECK-NEXT:    ret
entry:
    %in = sext i8 %src to i16
    %ext.b = sext <8 x i8> %b to <8 x i16>
    %broadcast.splatinsert = insertelement <8 x i16> undef, i16 %in, i16 1
    %broadcast.splat = shufflevector <8 x i16> %broadcast.splatinsert, <8 x i16> undef, <8 x i32> <i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1>
    %out = mul nsw <8 x i16> %broadcast.splat, %ext.b
    ret <8 x i16> %out
}

define <8 x i16> @missing_insert(<8 x i8> %b) {
; CHECK-LABEL: missing_insert:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-NEXT:    ext v1.16b, v0.16b, v0.16b, #4
; CHECK-NEXT:    mul v0.8h, v1.8h, v0.8h
; CHECK-NEXT:    ret
entry:
    %ext.b = sext <8 x i8> %b to <8 x i16>
    %broadcast.splat = shufflevector <8 x i16> %ext.b, <8 x i16> undef, <8 x i32> <i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1>
    %out = mul nsw <8 x i16> %broadcast.splat, %ext.b
    ret <8 x i16> %out
}
