; RUN: llc -march=hexagon < %s | FileCheck %s

; Generator: vdeal(0x37), vdeal(0x53), vshuff(0x2f), vdeal(0x4b), vdeal(0x27), vdeal(0x43), vshuff(0x1f), vdeal(0x5b), vshuff(0x7e), vshuff(0x6c), vdeal(0x5a), vdeal(0x38), vshuff(0x16), vshuff(0x44), vdeal(0x72)
; CHECK-LABEL: test_0000:
; CHECK-DAG: [[R00:r[0-9]+]] = #66
; CHECK-DAG: [[R01:r[0-9]+]] = #46
; CHECK-DAG: [[R02:r[0-9]+]] = #1
; CHECK: v[[H00:[0-9]+]]:[[L00:[0-9]+]] = vshuff(v1,v0,[[R00]])
; CHECK: v[[H01:[0-9]+]]:[[L01:[0-9]+]] = vshuff(v[[H00]],v[[L00]],[[R01]])
; CHECK: v[[H02:[0-9]+]]:[[L02:[0-9]+]] = vshuff(v[[H01]],v[[L01]],[[R02]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_0000(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 32, i32 64, i32 96, i32 128, i32 160, i32 192, i32 224, i32 4, i32 36, i32 68, i32 100, i32 132, i32 164, i32 196, i32 228, i32 16, i32 48, i32 80, i32 112, i32 144, i32 176, i32 208, i32 240, i32 20, i32 52, i32 84, i32 116, i32 148, i32 180, i32 212, i32 244, i32 8, i32 40, i32 72, i32 104, i32 136, i32 168, i32 200, i32 232, i32 12, i32 44, i32 76, i32 108, i32 140, i32 172, i32 204, i32 236, i32 24, i32 56, i32 88, i32 120, i32 152, i32 184, i32 216, i32 248, i32 28, i32 60, i32 92, i32 124, i32 156, i32 188, i32 220, i32 252, i32 2, i32 34, i32 66, i32 98, i32 130, i32 162, i32 194, i32 226, i32 6, i32 38, i32 70, i32 102, i32 134, i32 166, i32 198, i32 230, i32 18, i32 50, i32 82, i32 114, i32 146, i32 178, i32 210, i32 242, i32 22, i32 54, i32 86, i32 118, i32 150, i32 182, i32 214, i32 246, i32 10, i32 42, i32 74, i32 106, i32 138, i32 170, i32 202, i32 234, i32 14, i32 46, i32 78, i32 110, i32 142, i32 174, i32 206, i32 238, i32 26, i32 58, i32 90, i32 122, i32 154, i32 186, i32 218, i32 250, i32 30, i32 62, i32 94, i32 126, i32 158, i32 190, i32 222, i32 254, i32 1, i32 33, i32 65, i32 97, i32 129, i32 161, i32 193, i32 225, i32 5, i32 37, i32 69, i32 101, i32 133, i32 165, i32 197, i32 229, i32 17, i32 49, i32 81, i32 113, i32 145, i32 177, i32 209, i32 241, i32 21, i32 53, i32 85, i32 117, i32 149, i32 181, i32 213, i32 245, i32 9, i32 41, i32 73, i32 105, i32 137, i32 169, i32 201, i32 233, i32 13, i32 45, i32 77, i32 109, i32 141, i32 173, i32 205, i32 237, i32 25, i32 57, i32 89, i32 121, i32 153, i32 185, i32 217, i32 249, i32 29, i32 61, i32 93, i32 125, i32 157, i32 189, i32 221, i32 253, i32 3, i32 35, i32 67, i32 99, i32 131, i32 163, i32 195, i32 227, i32 7, i32 39, i32 71, i32 103, i32 135, i32 167, i32 199, i32 231, i32 19, i32 51, i32 83, i32 115, i32 147, i32 179, i32 211, i32 243, i32 23, i32 55, i32 87, i32 119, i32 151, i32 183, i32 215, i32 247, i32 11, i32 43, i32 75, i32 107, i32 139, i32 171, i32 203, i32 235, i32 15, i32 47, i32 79, i32 111, i32 143, i32 175, i32 207, i32 239, i32 27, i32 59, i32 91, i32 123, i32 155, i32 187, i32 219, i32 251, i32 31, i32 63, i32 95, i32 127, i32 159, i32 191, i32 223, i32 255>
  ret <256 x i8> %p
}

; Generator: vshuff(0x10), vdeal(0x2e), vshuff(0x1c), vdeal(0x2a), vshuff(0x68), vshuff(0x46), vdeal(0x74), vdeal(0x42), vdeal(0x40), vdeal(0x5e), vshuff(0x0d), vshuff(0x71), vshuff(0x35), vshuff(0x39), vshuff(0x7d)
; CHECK-LABEL: test_0001:
; CHECK-DAG: [[R10:r[0-9]+]] = #24
; CHECK-DAG: [[R11:r[0-9]+]] = #9
; CHECK-DAG: [[R12:r[0-9]+]] = #68
; CHECK-DAG: [[R13:r[0-9]+]] = #34
; CHECK: v[[H10:[0-9]+]]:[[L10:[0-9]+]] = vshuff(v1,v0,[[R10]])
; CHECK: v[[H11:[0-9]+]]:[[L11:[0-9]+]] = vdeal(v[[H10]],v[[L10]],[[R11]])
; CHECK: v[[H12:[0-9]+]]:[[L12:[0-9]+]] = vdeal(v[[H11]],v[[L11]],[[R12]])
; CHECK: v[[H13:[0-9]+]]:[[L13:[0-9]+]] = vdeal(v[[H12]],v[[L12]],[[R13]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_0001(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 128, i32 32, i32 160, i32 64, i32 192, i32 96, i32 224, i32 16, i32 144, i32 48, i32 176, i32 80, i32 208, i32 112, i32 240, i32 8, i32 136, i32 40, i32 168, i32 72, i32 200, i32 104, i32 232, i32 24, i32 152, i32 56, i32 184, i32 88, i32 216, i32 120, i32 248, i32 4, i32 132, i32 36, i32 164, i32 68, i32 196, i32 100, i32 228, i32 20, i32 148, i32 52, i32 180, i32 84, i32 212, i32 116, i32 244, i32 12, i32 140, i32 44, i32 172, i32 76, i32 204, i32 108, i32 236, i32 28, i32 156, i32 60, i32 188, i32 92, i32 220, i32 124, i32 252, i32 1, i32 129, i32 33, i32 161, i32 65, i32 193, i32 97, i32 225, i32 17, i32 145, i32 49, i32 177, i32 81, i32 209, i32 113, i32 241, i32 9, i32 137, i32 41, i32 169, i32 73, i32 201, i32 105, i32 233, i32 25, i32 153, i32 57, i32 185, i32 89, i32 217, i32 121, i32 249, i32 5, i32 133, i32 37, i32 165, i32 69, i32 197, i32 101, i32 229, i32 21, i32 149, i32 53, i32 181, i32 85, i32 213, i32 117, i32 245, i32 13, i32 141, i32 45, i32 173, i32 77, i32 205, i32 109, i32 237, i32 29, i32 157, i32 61, i32 189, i32 93, i32 221, i32 125, i32 253, i32 2, i32 130, i32 34, i32 162, i32 66, i32 194, i32 98, i32 226, i32 18, i32 146, i32 50, i32 178, i32 82, i32 210, i32 114, i32 242, i32 10, i32 138, i32 42, i32 170, i32 74, i32 202, i32 106, i32 234, i32 26, i32 154, i32 58, i32 186, i32 90, i32 218, i32 122, i32 250, i32 6, i32 134, i32 38, i32 166, i32 70, i32 198, i32 102, i32 230, i32 22, i32 150, i32 54, i32 182, i32 86, i32 214, i32 118, i32 246, i32 14, i32 142, i32 46, i32 174, i32 78, i32 206, i32 110, i32 238, i32 30, i32 158, i32 62, i32 190, i32 94, i32 222, i32 126, i32 254, i32 3, i32 131, i32 35, i32 163, i32 67, i32 195, i32 99, i32 227, i32 19, i32 147, i32 51, i32 179, i32 83, i32 211, i32 115, i32 243, i32 11, i32 139, i32 43, i32 171, i32 75, i32 203, i32 107, i32 235, i32 27, i32 155, i32 59, i32 187, i32 91, i32 219, i32 123, i32 251, i32 7, i32 135, i32 39, i32 167, i32 71, i32 199, i32 103, i32 231, i32 23, i32 151, i32 55, i32 183, i32 87, i32 215, i32 119, i32 247, i32 15, i32 143, i32 47, i32 175, i32 79, i32 207, i32 111, i32 239, i32 31, i32 159, i32 63, i32 191, i32 95, i32 223, i32 127, i32 255>
  ret <256 x i8> %p
}

; Generator: vshuff(0x01), vdeal(0x25), vdeal(0x29), vdeal(0x6d), vshuff(0x58), vshuff(0x7a), vdeal(0x47), vdeal(0x49), vdeal(0x65), vshuff(0x1e), vdeal(0x1d), vshuff(0x0c), vshuff(0x08), vshuff(0x62), vdeal(0x73)
; CHECK-LABEL: test_0002:
; CHECK-DAG: [[R20:r[0-9]+]] = #18
; CHECK-DAG: [[R21:r[0-9]+]] = #10
; CHECK-DAG: [[R22:r[0-9]+]] = #68
; CHECK-DAG: [[R23:r[0-9]+]] = #5
; CHECK: v[[H20:[0-9]+]]:[[L20:[0-9]+]] = vshuff(v1,v0,[[R20]])
; CHECK: v[[H21:[0-9]+]]:[[L21:[0-9]+]] = vdeal(v[[H20]],v[[L20]],[[R21]])
; CHECK: v[[H22:[0-9]+]]:[[L22:[0-9]+]] = vshuff(v[[H21]],v[[L21]],[[R22]])
; CHECK: v[[H23:[0-9]+]]:[[L23:[0-9]+]] = vdeal(v[[H22]],v[[L22]],[[R23]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_0002(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 128, i32 8, i32 136, i32 64, i32 192, i32 72, i32 200, i32 16, i32 144, i32 24, i32 152, i32 80, i32 208, i32 88, i32 216, i32 2, i32 130, i32 10, i32 138, i32 66, i32 194, i32 74, i32 202, i32 18, i32 146, i32 26, i32 154, i32 82, i32 210, i32 90, i32 218, i32 32, i32 160, i32 40, i32 168, i32 96, i32 224, i32 104, i32 232, i32 48, i32 176, i32 56, i32 184, i32 112, i32 240, i32 120, i32 248, i32 34, i32 162, i32 42, i32 170, i32 98, i32 226, i32 106, i32 234, i32 50, i32 178, i32 58, i32 186, i32 114, i32 242, i32 122, i32 250, i32 4, i32 132, i32 12, i32 140, i32 68, i32 196, i32 76, i32 204, i32 20, i32 148, i32 28, i32 156, i32 84, i32 212, i32 92, i32 220, i32 6, i32 134, i32 14, i32 142, i32 70, i32 198, i32 78, i32 206, i32 22, i32 150, i32 30, i32 158, i32 86, i32 214, i32 94, i32 222, i32 36, i32 164, i32 44, i32 172, i32 100, i32 228, i32 108, i32 236, i32 52, i32 180, i32 60, i32 188, i32 116, i32 244, i32 124, i32 252, i32 38, i32 166, i32 46, i32 174, i32 102, i32 230, i32 110, i32 238, i32 54, i32 182, i32 62, i32 190, i32 118, i32 246, i32 126, i32 254, i32 1, i32 129, i32 9, i32 137, i32 65, i32 193, i32 73, i32 201, i32 17, i32 145, i32 25, i32 153, i32 81, i32 209, i32 89, i32 217, i32 3, i32 131, i32 11, i32 139, i32 67, i32 195, i32 75, i32 203, i32 19, i32 147, i32 27, i32 155, i32 83, i32 211, i32 91, i32 219, i32 33, i32 161, i32 41, i32 169, i32 97, i32 225, i32 105, i32 233, i32 49, i32 177, i32 57, i32 185, i32 113, i32 241, i32 121, i32 249, i32 35, i32 163, i32 43, i32 171, i32 99, i32 227, i32 107, i32 235, i32 51, i32 179, i32 59, i32 187, i32 115, i32 243, i32 123, i32 251, i32 5, i32 133, i32 13, i32 141, i32 69, i32 197, i32 77, i32 205, i32 21, i32 149, i32 29, i32 157, i32 85, i32 213, i32 93, i32 221, i32 7, i32 135, i32 15, i32 143, i32 71, i32 199, i32 79, i32 207, i32 23, i32 151, i32 31, i32 159, i32 87, i32 215, i32 95, i32 223, i32 37, i32 165, i32 45, i32 173, i32 101, i32 229, i32 109, i32 237, i32 53, i32 181, i32 61, i32 189, i32 117, i32 245, i32 125, i32 253, i32 39, i32 167, i32 47, i32 175, i32 103, i32 231, i32 111, i32 239, i32 55, i32 183, i32 63, i32 191, i32 119, i32 247, i32 127, i32 255>
  ret <256 x i8> %p
}

; Generator: vshuff(0x60), vdeal(0x36), vdeal(0x11), vdeal(0x57), vdeal(0x45), vshuff(0x03), vdeal(0x14), vdeal(0x64), vdeal(0x3c), vdeal(0x30), vshuff(0x4e), vshuff(0x55), vshuff(0x4a), vshuff(0x4f), vshuff(0x3f)
; CHECK-LABEL: test_0003:
; CHECK-DAG: [[R30:r[0-9]+]] = #21
; CHECK-DAG: [[R31:r[0-9]+]] = #9
; CHECK-DAG: [[R32:r[0-9]+]] = #34
; CHECK-DAG: [[R33:r[0-9]+]] = #66
; CHECK: v[[H30:[0-9]+]]:[[L30:[0-9]+]] = vshuff(v1,v0,[[R30]])
; CHECK: v[[H31:[0-9]+]]:[[L31:[0-9]+]] = vdeal(v[[H30]],v[[L30]],[[R31]])
; CHECK: v[[H32:[0-9]+]]:[[L32:[0-9]+]] = vshuff(v[[H31]],v[[L31]],[[R32]])
; CHECK: v[[H33:[0-9]+]]:[[L33:[0-9]+]] = vshuff(v[[H32]],v[[L32]],[[R33]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_0003(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 8, i32 32, i32 40, i32 1, i32 9, i32 33, i32 41, i32 16, i32 24, i32 48, i32 56, i32 17, i32 25, i32 49, i32 57, i32 4, i32 12, i32 36, i32 44, i32 5, i32 13, i32 37, i32 45, i32 20, i32 28, i32 52, i32 60, i32 21, i32 29, i32 53, i32 61, i32 2, i32 10, i32 34, i32 42, i32 3, i32 11, i32 35, i32 43, i32 18, i32 26, i32 50, i32 58, i32 19, i32 27, i32 51, i32 59, i32 6, i32 14, i32 38, i32 46, i32 7, i32 15, i32 39, i32 47, i32 22, i32 30, i32 54, i32 62, i32 23, i32 31, i32 55, i32 63, i32 128, i32 136, i32 160, i32 168, i32 129, i32 137, i32 161, i32 169, i32 144, i32 152, i32 176, i32 184, i32 145, i32 153, i32 177, i32 185, i32 132, i32 140, i32 164, i32 172, i32 133, i32 141, i32 165, i32 173, i32 148, i32 156, i32 180, i32 188, i32 149, i32 157, i32 181, i32 189, i32 130, i32 138, i32 162, i32 170, i32 131, i32 139, i32 163, i32 171, i32 146, i32 154, i32 178, i32 186, i32 147, i32 155, i32 179, i32 187, i32 134, i32 142, i32 166, i32 174, i32 135, i32 143, i32 167, i32 175, i32 150, i32 158, i32 182, i32 190, i32 151, i32 159, i32 183, i32 191, i32 64, i32 72, i32 96, i32 104, i32 65, i32 73, i32 97, i32 105, i32 80, i32 88, i32 112, i32 120, i32 81, i32 89, i32 113, i32 121, i32 68, i32 76, i32 100, i32 108, i32 69, i32 77, i32 101, i32 109, i32 84, i32 92, i32 116, i32 124, i32 85, i32 93, i32 117, i32 125, i32 66, i32 74, i32 98, i32 106, i32 67, i32 75, i32 99, i32 107, i32 82, i32 90, i32 114, i32 122, i32 83, i32 91, i32 115, i32 123, i32 70, i32 78, i32 102, i32 110, i32 71, i32 79, i32 103, i32 111, i32 86, i32 94, i32 118, i32 126, i32 87, i32 95, i32 119, i32 127, i32 192, i32 200, i32 224, i32 232, i32 193, i32 201, i32 225, i32 233, i32 208, i32 216, i32 240, i32 248, i32 209, i32 217, i32 241, i32 249, i32 196, i32 204, i32 228, i32 236, i32 197, i32 205, i32 229, i32 237, i32 212, i32 220, i32 244, i32 252, i32 213, i32 221, i32 245, i32 253, i32 194, i32 202, i32 226, i32 234, i32 195, i32 203, i32 227, i32 235, i32 210, i32 218, i32 242, i32 250, i32 211, i32 219, i32 243, i32 251, i32 198, i32 206, i32 230, i32 238, i32 199, i32 207, i32 231, i32 239, i32 214, i32 222, i32 246, i32 254, i32 215, i32 223, i32 247, i32 255>
  ret <256 x i8> %p
}

; Generator: vdeal(0x63), vshuff(0x6f), vdeal(0x77), vshuff(0x75), vdeal(0x3d), vshuff(0x2d), vshuff(0x00), vshuff(0x5c), vdeal(0x04), vshuff(0x79), vshuff(0x21), vdeal(0x7b), vdeal(0x66), vshuff(0x59), vdeal(0x54)
; CHECK-LABEL: test_0004:
; CHECK-DAG: [[R40:r[0-9]+]] = #38
; CHECK-DAG: [[R41:r[0-9]+]] = #72
; CHECK-DAG: [[R42:r[0-9]+]] = #18
; CHECK: v[[H40:[0-9]+]]:[[L40:[0-9]+]] = vshuff(v1,v0,[[R40]])
; CHECK: v[[H41:[0-9]+]]:[[L41:[0-9]+]] = vshuff(v[[H40]],v[[L40]],[[R41]])
; CHECK: v[[H42:[0-9]+]]:[[L42:[0-9]+]] = vshuff(v[[H41]],v[[L41]],[[R42]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_0004(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 1, i32 64, i32 65, i32 2, i32 3, i32 66, i32 67, i32 32, i32 33, i32 96, i32 97, i32 34, i32 35, i32 98, i32 99, i32 128, i32 129, i32 192, i32 193, i32 130, i32 131, i32 194, i32 195, i32 160, i32 161, i32 224, i32 225, i32 162, i32 163, i32 226, i32 227, i32 4, i32 5, i32 68, i32 69, i32 6, i32 7, i32 70, i32 71, i32 36, i32 37, i32 100, i32 101, i32 38, i32 39, i32 102, i32 103, i32 132, i32 133, i32 196, i32 197, i32 134, i32 135, i32 198, i32 199, i32 164, i32 165, i32 228, i32 229, i32 166, i32 167, i32 230, i32 231, i32 8, i32 9, i32 72, i32 73, i32 10, i32 11, i32 74, i32 75, i32 40, i32 41, i32 104, i32 105, i32 42, i32 43, i32 106, i32 107, i32 136, i32 137, i32 200, i32 201, i32 138, i32 139, i32 202, i32 203, i32 168, i32 169, i32 232, i32 233, i32 170, i32 171, i32 234, i32 235, i32 12, i32 13, i32 76, i32 77, i32 14, i32 15, i32 78, i32 79, i32 44, i32 45, i32 108, i32 109, i32 46, i32 47, i32 110, i32 111, i32 140, i32 141, i32 204, i32 205, i32 142, i32 143, i32 206, i32 207, i32 172, i32 173, i32 236, i32 237, i32 174, i32 175, i32 238, i32 239, i32 16, i32 17, i32 80, i32 81, i32 18, i32 19, i32 82, i32 83, i32 48, i32 49, i32 112, i32 113, i32 50, i32 51, i32 114, i32 115, i32 144, i32 145, i32 208, i32 209, i32 146, i32 147, i32 210, i32 211, i32 176, i32 177, i32 240, i32 241, i32 178, i32 179, i32 242, i32 243, i32 20, i32 21, i32 84, i32 85, i32 22, i32 23, i32 86, i32 87, i32 52, i32 53, i32 116, i32 117, i32 54, i32 55, i32 118, i32 119, i32 148, i32 149, i32 212, i32 213, i32 150, i32 151, i32 214, i32 215, i32 180, i32 181, i32 244, i32 245, i32 182, i32 183, i32 246, i32 247, i32 24, i32 25, i32 88, i32 89, i32 26, i32 27, i32 90, i32 91, i32 56, i32 57, i32 120, i32 121, i32 58, i32 59, i32 122, i32 123, i32 152, i32 153, i32 216, i32 217, i32 154, i32 155, i32 218, i32 219, i32 184, i32 185, i32 248, i32 249, i32 186, i32 187, i32 250, i32 251, i32 28, i32 29, i32 92, i32 93, i32 30, i32 31, i32 94, i32 95, i32 60, i32 61, i32 124, i32 125, i32 62, i32 63, i32 126, i32 127, i32 156, i32 157, i32 220, i32 221, i32 158, i32 159, i32 222, i32 223, i32 188, i32 189, i32 252, i32 253, i32 190, i32 191, i32 254, i32 255>
  ret <256 x i8> %p
}

; Generator: vshuff(0x02), vshuff(0x1a), vshuff(0x32), vdeal(0x6b), vdeal(0x12), vdeal(0x7c), vdeal(0x52), vdeal(0x0e), vshuff(0x56), vshuff(0x0b), vshuff(0x2b), vdeal(0x19), vshuff(0x48), vdeal(0x67), vdeal(0x69)
; CHECK-LABEL: test_0005:
; CHECK-DAG: [[R50:r[0-9]+]] = #9
; CHECK-DAG: [[R51:r[0-9]+]] = #3
; CHECK-DAG: [[R52:r[0-9]+]] = #48
; CHECK-DAG: [[R53:r[0-9]+]] = #68
; CHECK: v[[H50:[0-9]+]]:[[L50:[0-9]+]] = vshuff(v1,v0,[[R50]])
; CHECK: v[[H51:[0-9]+]]:[[L51:[0-9]+]] = vdeal(v[[H50]],v[[L50]],[[R51]])
; CHECK: v[[H52:[0-9]+]]:[[L52:[0-9]+]] = vdeal(v[[H51]],v[[L51]],[[R52]])
; CHECK: v[[H53:[0-9]+]]:[[L53:[0-9]+]] = vdeal(v[[H52]],v[[L52]],[[R53]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_0005(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 2, i32 8, i32 10, i32 64, i32 66, i32 72, i32 74, i32 1, i32 3, i32 9, i32 11, i32 65, i32 67, i32 73, i32 75, i32 32, i32 34, i32 40, i32 42, i32 96, i32 98, i32 104, i32 106, i32 33, i32 35, i32 41, i32 43, i32 97, i32 99, i32 105, i32 107, i32 128, i32 130, i32 136, i32 138, i32 192, i32 194, i32 200, i32 202, i32 129, i32 131, i32 137, i32 139, i32 193, i32 195, i32 201, i32 203, i32 160, i32 162, i32 168, i32 170, i32 224, i32 226, i32 232, i32 234, i32 161, i32 163, i32 169, i32 171, i32 225, i32 227, i32 233, i32 235, i32 16, i32 18, i32 24, i32 26, i32 80, i32 82, i32 88, i32 90, i32 17, i32 19, i32 25, i32 27, i32 81, i32 83, i32 89, i32 91, i32 48, i32 50, i32 56, i32 58, i32 112, i32 114, i32 120, i32 122, i32 49, i32 51, i32 57, i32 59, i32 113, i32 115, i32 121, i32 123, i32 144, i32 146, i32 152, i32 154, i32 208, i32 210, i32 216, i32 218, i32 145, i32 147, i32 153, i32 155, i32 209, i32 211, i32 217, i32 219, i32 176, i32 178, i32 184, i32 186, i32 240, i32 242, i32 248, i32 250, i32 177, i32 179, i32 185, i32 187, i32 241, i32 243, i32 249, i32 251, i32 4, i32 6, i32 12, i32 14, i32 68, i32 70, i32 76, i32 78, i32 5, i32 7, i32 13, i32 15, i32 69, i32 71, i32 77, i32 79, i32 36, i32 38, i32 44, i32 46, i32 100, i32 102, i32 108, i32 110, i32 37, i32 39, i32 45, i32 47, i32 101, i32 103, i32 109, i32 111, i32 132, i32 134, i32 140, i32 142, i32 196, i32 198, i32 204, i32 206, i32 133, i32 135, i32 141, i32 143, i32 197, i32 199, i32 205, i32 207, i32 164, i32 166, i32 172, i32 174, i32 228, i32 230, i32 236, i32 238, i32 165, i32 167, i32 173, i32 175, i32 229, i32 231, i32 237, i32 239, i32 20, i32 22, i32 28, i32 30, i32 84, i32 86, i32 92, i32 94, i32 21, i32 23, i32 29, i32 31, i32 85, i32 87, i32 93, i32 95, i32 52, i32 54, i32 60, i32 62, i32 116, i32 118, i32 124, i32 126, i32 53, i32 55, i32 61, i32 63, i32 117, i32 119, i32 125, i32 127, i32 148, i32 150, i32 156, i32 158, i32 212, i32 214, i32 220, i32 222, i32 149, i32 151, i32 157, i32 159, i32 213, i32 215, i32 221, i32 223, i32 180, i32 182, i32 188, i32 190, i32 244, i32 246, i32 252, i32 254, i32 181, i32 183, i32 189, i32 191, i32 245, i32 247, i32 253, i32 255>
  ret <256 x i8> %p
}

; Generator: vshuff(0x34), vshuff(0x07), vdeal(0x5d), vshuff(0x05), vshuff(0x50), vshuff(0x13), vdeal(0x31), vdeal(0x6e), vdeal(0x0f), vdeal(0x2c), vdeal(0x28), vdeal(0x76), vdeal(0x22), vdeal(0x3a), vdeal(0x51)
; CHECK-LABEL: test_0006:
; CHECK-DAG: [[R60:r[0-9]+]] = #85
; CHECK-DAG: [[R61:r[0-9]+]] = #2
; CHECK: v[[H60:[0-9]+]]:[[L60:[0-9]+]] = vdeal(v1,v0,[[R60]])
; CHECK: v[[H61:[0-9]+]]:[[L61:[0-9]+]] = vshuff(v[[H60]],v[[L60]],[[R61]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_0006(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 4, i32 1, i32 5, i32 16, i32 20, i32 17, i32 21, i32 8, i32 12, i32 9, i32 13, i32 24, i32 28, i32 25, i32 29, i32 64, i32 68, i32 65, i32 69, i32 80, i32 84, i32 81, i32 85, i32 72, i32 76, i32 73, i32 77, i32 88, i32 92, i32 89, i32 93, i32 32, i32 36, i32 33, i32 37, i32 48, i32 52, i32 49, i32 53, i32 40, i32 44, i32 41, i32 45, i32 56, i32 60, i32 57, i32 61, i32 96, i32 100, i32 97, i32 101, i32 112, i32 116, i32 113, i32 117, i32 104, i32 108, i32 105, i32 109, i32 120, i32 124, i32 121, i32 125, i32 128, i32 132, i32 129, i32 133, i32 144, i32 148, i32 145, i32 149, i32 136, i32 140, i32 137, i32 141, i32 152, i32 156, i32 153, i32 157, i32 192, i32 196, i32 193, i32 197, i32 208, i32 212, i32 209, i32 213, i32 200, i32 204, i32 201, i32 205, i32 216, i32 220, i32 217, i32 221, i32 160, i32 164, i32 161, i32 165, i32 176, i32 180, i32 177, i32 181, i32 168, i32 172, i32 169, i32 173, i32 184, i32 188, i32 185, i32 189, i32 224, i32 228, i32 225, i32 229, i32 240, i32 244, i32 241, i32 245, i32 232, i32 236, i32 233, i32 237, i32 248, i32 252, i32 249, i32 253, i32 2, i32 6, i32 3, i32 7, i32 18, i32 22, i32 19, i32 23, i32 10, i32 14, i32 11, i32 15, i32 26, i32 30, i32 27, i32 31, i32 66, i32 70, i32 67, i32 71, i32 82, i32 86, i32 83, i32 87, i32 74, i32 78, i32 75, i32 79, i32 90, i32 94, i32 91, i32 95, i32 34, i32 38, i32 35, i32 39, i32 50, i32 54, i32 51, i32 55, i32 42, i32 46, i32 43, i32 47, i32 58, i32 62, i32 59, i32 63, i32 98, i32 102, i32 99, i32 103, i32 114, i32 118, i32 115, i32 119, i32 106, i32 110, i32 107, i32 111, i32 122, i32 126, i32 123, i32 127, i32 130, i32 134, i32 131, i32 135, i32 146, i32 150, i32 147, i32 151, i32 138, i32 142, i32 139, i32 143, i32 154, i32 158, i32 155, i32 159, i32 194, i32 198, i32 195, i32 199, i32 210, i32 214, i32 211, i32 215, i32 202, i32 206, i32 203, i32 207, i32 218, i32 222, i32 219, i32 223, i32 162, i32 166, i32 163, i32 167, i32 178, i32 182, i32 179, i32 183, i32 170, i32 174, i32 171, i32 175, i32 186, i32 190, i32 187, i32 191, i32 226, i32 230, i32 227, i32 231, i32 242, i32 246, i32 243, i32 247, i32 234, i32 238, i32 235, i32 239, i32 250, i32 254, i32 251, i32 255>
  ret <256 x i8> %p
}

; Generator: vshuff(0x25), vshuff(0x4c), vshuff(0x72), vdeal(0x70), vshuff(0x3b), vshuff(0x26), vshuff(0x4d), vdeal(0x20), vshuff(0x7f), vdeal(0x6a), vdeal(0x78), vshuff(0x5f), vdeal(0x10), vdeal(0x71), vshuff(0x6d)
; CHECK-LABEL: test_0007:
; CHECK-DAG: [[R70:r[0-9]+]] = #74
; CHECK-DAG: [[R71:r[0-9]+]] = #20
; CHECK-DAG: [[R72:r[0-9]+]] = #34
; CHECK: v[[H70:[0-9]+]]:[[L70:[0-9]+]] = vshuff(v1,v0,[[R70]])
; CHECK: v[[H71:[0-9]+]]:[[L71:[0-9]+]] = vdeal(v[[H70]],v[[L70]],[[R71]])
; CHECK: v[[H72:[0-9]+]]:[[L72:[0-9]+]] = vdeal(v[[H71]],v[[L71]],[[R72]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_0007(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 1, i32 32, i32 33, i32 16, i32 17, i32 48, i32 49, i32 2, i32 3, i32 34, i32 35, i32 18, i32 19, i32 50, i32 51, i32 64, i32 65, i32 96, i32 97, i32 80, i32 81, i32 112, i32 113, i32 66, i32 67, i32 98, i32 99, i32 82, i32 83, i32 114, i32 115, i32 4, i32 5, i32 36, i32 37, i32 20, i32 21, i32 52, i32 53, i32 6, i32 7, i32 38, i32 39, i32 22, i32 23, i32 54, i32 55, i32 68, i32 69, i32 100, i32 101, i32 84, i32 85, i32 116, i32 117, i32 70, i32 71, i32 102, i32 103, i32 86, i32 87, i32 118, i32 119, i32 8, i32 9, i32 40, i32 41, i32 24, i32 25, i32 56, i32 57, i32 10, i32 11, i32 42, i32 43, i32 26, i32 27, i32 58, i32 59, i32 72, i32 73, i32 104, i32 105, i32 88, i32 89, i32 120, i32 121, i32 74, i32 75, i32 106, i32 107, i32 90, i32 91, i32 122, i32 123, i32 12, i32 13, i32 44, i32 45, i32 28, i32 29, i32 60, i32 61, i32 14, i32 15, i32 46, i32 47, i32 30, i32 31, i32 62, i32 63, i32 76, i32 77, i32 108, i32 109, i32 92, i32 93, i32 124, i32 125, i32 78, i32 79, i32 110, i32 111, i32 94, i32 95, i32 126, i32 127, i32 128, i32 129, i32 160, i32 161, i32 144, i32 145, i32 176, i32 177, i32 130, i32 131, i32 162, i32 163, i32 146, i32 147, i32 178, i32 179, i32 192, i32 193, i32 224, i32 225, i32 208, i32 209, i32 240, i32 241, i32 194, i32 195, i32 226, i32 227, i32 210, i32 211, i32 242, i32 243, i32 132, i32 133, i32 164, i32 165, i32 148, i32 149, i32 180, i32 181, i32 134, i32 135, i32 166, i32 167, i32 150, i32 151, i32 182, i32 183, i32 196, i32 197, i32 228, i32 229, i32 212, i32 213, i32 244, i32 245, i32 198, i32 199, i32 230, i32 231, i32 214, i32 215, i32 246, i32 247, i32 136, i32 137, i32 168, i32 169, i32 152, i32 153, i32 184, i32 185, i32 138, i32 139, i32 170, i32 171, i32 154, i32 155, i32 186, i32 187, i32 200, i32 201, i32 232, i32 233, i32 216, i32 217, i32 248, i32 249, i32 202, i32 203, i32 234, i32 235, i32 218, i32 219, i32 250, i32 251, i32 140, i32 141, i32 172, i32 173, i32 156, i32 157, i32 188, i32 189, i32 142, i32 143, i32 174, i32 175, i32 158, i32 159, i32 190, i32 191, i32 204, i32 205, i32 236, i32 237, i32 220, i32 221, i32 252, i32 253, i32 206, i32 207, i32 238, i32 239, i32 222, i32 223, i32 254, i32 255>
  ret <256 x i8> %p
}

; Generator: vshuff(0x2e), vshuff(0x40), vdeal(0x35), vdeal(0x3e), vdeal(0x06), vshuff(0x4b), vshuff(0x24), vshuff(0x09), vdeal(0x18), vshuff(0x42), vshuff(0x43), vshuff(0x41), vshuff(0x23), vdeal(0x3f), vdeal(0x39)
; CHECK-LABEL: test_0008:
; CHECK-DAG: [[R80:r[0-9]+]] = #73
; CHECK-DAG: [[R81:r[0-9]+]] = #5
; CHECK-DAG: [[R82:r[0-9]+]] = #48
; CHECK-DAG: [[R83:r[0-9]+]] = #2
; CHECK: v[[H80:[0-9]+]]:[[L80:[0-9]+]] = vshuff(v1,v0,[[R80]])
; CHECK: v[[H81:[0-9]+]]:[[L81:[0-9]+]] = vdeal(v[[H80]],v[[L80]],[[R81]])
; CHECK: v[[H82:[0-9]+]]:[[L82:[0-9]+]] = vshuff(v[[H81]],v[[L81]],[[R82]])
; CHECK: v[[H83:[0-9]+]]:[[L83:[0-9]+]] = vshuff(v[[H82]],v[[L82]],[[R83]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_0008(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 4, i32 32, i32 36, i32 64, i32 68, i32 96, i32 100, i32 1, i32 5, i32 33, i32 37, i32 65, i32 69, i32 97, i32 101, i32 128, i32 132, i32 160, i32 164, i32 192, i32 196, i32 224, i32 228, i32 129, i32 133, i32 161, i32 165, i32 193, i32 197, i32 225, i32 229, i32 16, i32 20, i32 48, i32 52, i32 80, i32 84, i32 112, i32 116, i32 17, i32 21, i32 49, i32 53, i32 81, i32 85, i32 113, i32 117, i32 144, i32 148, i32 176, i32 180, i32 208, i32 212, i32 240, i32 244, i32 145, i32 149, i32 177, i32 181, i32 209, i32 213, i32 241, i32 245, i32 8, i32 12, i32 40, i32 44, i32 72, i32 76, i32 104, i32 108, i32 9, i32 13, i32 41, i32 45, i32 73, i32 77, i32 105, i32 109, i32 136, i32 140, i32 168, i32 172, i32 200, i32 204, i32 232, i32 236, i32 137, i32 141, i32 169, i32 173, i32 201, i32 205, i32 233, i32 237, i32 24, i32 28, i32 56, i32 60, i32 88, i32 92, i32 120, i32 124, i32 25, i32 29, i32 57, i32 61, i32 89, i32 93, i32 121, i32 125, i32 152, i32 156, i32 184, i32 188, i32 216, i32 220, i32 248, i32 252, i32 153, i32 157, i32 185, i32 189, i32 217, i32 221, i32 249, i32 253, i32 2, i32 6, i32 34, i32 38, i32 66, i32 70, i32 98, i32 102, i32 3, i32 7, i32 35, i32 39, i32 67, i32 71, i32 99, i32 103, i32 130, i32 134, i32 162, i32 166, i32 194, i32 198, i32 226, i32 230, i32 131, i32 135, i32 163, i32 167, i32 195, i32 199, i32 227, i32 231, i32 18, i32 22, i32 50, i32 54, i32 82, i32 86, i32 114, i32 118, i32 19, i32 23, i32 51, i32 55, i32 83, i32 87, i32 115, i32 119, i32 146, i32 150, i32 178, i32 182, i32 210, i32 214, i32 242, i32 246, i32 147, i32 151, i32 179, i32 183, i32 211, i32 215, i32 243, i32 247, i32 10, i32 14, i32 42, i32 46, i32 74, i32 78, i32 106, i32 110, i32 11, i32 15, i32 43, i32 47, i32 75, i32 79, i32 107, i32 111, i32 138, i32 142, i32 170, i32 174, i32 202, i32 206, i32 234, i32 238, i32 139, i32 143, i32 171, i32 175, i32 203, i32 207, i32 235, i32 239, i32 26, i32 30, i32 58, i32 62, i32 90, i32 94, i32 122, i32 126, i32 27, i32 31, i32 59, i32 63, i32 91, i32 95, i32 123, i32 127, i32 154, i32 158, i32 186, i32 190, i32 218, i32 222, i32 250, i32 254, i32 155, i32 159, i32 187, i32 191, i32 219, i32 223, i32 251, i32 255>
  ret <256 x i8> %p
}

; Generator: vshuff(0x33), vshuff(0x5e), vshuff(0x2a), vdeal(0x2f), vdeal(0x1f), vshuff(0x14), vshuff(0x17), vshuff(0x1b), vdeal(0x1c), vdeal(0x15), vshuff(0x37), vshuff(0x3c), vdeal(0x4e), vdeal(0x7d), vshuff(0x61)
; CHECK-LABEL: test_0009:
; CHECK-DAG: [[R90:r[0-9]+]] = #96
; CHECK-DAG: [[R91:r[0-9]+]] = #18
; CHECK-DAG: [[R92:r[0-9]+]] = #5
; CHECK: v[[H90:[0-9]+]]:[[L90:[0-9]+]] = vshuff(v1,v0,[[R90]])
; CHECK: v[[H91:[0-9]+]]:[[L91:[0-9]+]] = vdeal(v[[H90]],v[[L90]],[[R91]])
; CHECK: v[[H92:[0-9]+]]:[[L92:[0-9]+]] = vdeal(v[[H91]],v[[L91]],[[R92]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_0009(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 4, i32 16, i32 20, i32 2, i32 6, i32 18, i32 22, i32 8, i32 12, i32 24, i32 28, i32 10, i32 14, i32 26, i32 30, i32 64, i32 68, i32 80, i32 84, i32 66, i32 70, i32 82, i32 86, i32 72, i32 76, i32 88, i32 92, i32 74, i32 78, i32 90, i32 94, i32 128, i32 132, i32 144, i32 148, i32 130, i32 134, i32 146, i32 150, i32 136, i32 140, i32 152, i32 156, i32 138, i32 142, i32 154, i32 158, i32 192, i32 196, i32 208, i32 212, i32 194, i32 198, i32 210, i32 214, i32 200, i32 204, i32 216, i32 220, i32 202, i32 206, i32 218, i32 222, i32 32, i32 36, i32 48, i32 52, i32 34, i32 38, i32 50, i32 54, i32 40, i32 44, i32 56, i32 60, i32 42, i32 46, i32 58, i32 62, i32 96, i32 100, i32 112, i32 116, i32 98, i32 102, i32 114, i32 118, i32 104, i32 108, i32 120, i32 124, i32 106, i32 110, i32 122, i32 126, i32 160, i32 164, i32 176, i32 180, i32 162, i32 166, i32 178, i32 182, i32 168, i32 172, i32 184, i32 188, i32 170, i32 174, i32 186, i32 190, i32 224, i32 228, i32 240, i32 244, i32 226, i32 230, i32 242, i32 246, i32 232, i32 236, i32 248, i32 252, i32 234, i32 238, i32 250, i32 254, i32 1, i32 5, i32 17, i32 21, i32 3, i32 7, i32 19, i32 23, i32 9, i32 13, i32 25, i32 29, i32 11, i32 15, i32 27, i32 31, i32 65, i32 69, i32 81, i32 85, i32 67, i32 71, i32 83, i32 87, i32 73, i32 77, i32 89, i32 93, i32 75, i32 79, i32 91, i32 95, i32 129, i32 133, i32 145, i32 149, i32 131, i32 135, i32 147, i32 151, i32 137, i32 141, i32 153, i32 157, i32 139, i32 143, i32 155, i32 159, i32 193, i32 197, i32 209, i32 213, i32 195, i32 199, i32 211, i32 215, i32 201, i32 205, i32 217, i32 221, i32 203, i32 207, i32 219, i32 223, i32 33, i32 37, i32 49, i32 53, i32 35, i32 39, i32 51, i32 55, i32 41, i32 45, i32 57, i32 61, i32 43, i32 47, i32 59, i32 63, i32 97, i32 101, i32 113, i32 117, i32 99, i32 103, i32 115, i32 119, i32 105, i32 109, i32 121, i32 125, i32 107, i32 111, i32 123, i32 127, i32 161, i32 165, i32 177, i32 181, i32 163, i32 167, i32 179, i32 183, i32 169, i32 173, i32 185, i32 189, i32 171, i32 175, i32 187, i32 191, i32 225, i32 229, i32 241, i32 245, i32 227, i32 231, i32 243, i32 247, i32 233, i32 237, i32 249, i32 253, i32 235, i32 239, i32 251, i32 255>
  ret <256 x i8> %p
}

; Generator: vshuff(0x12), vshuff(0x5a), vdeal(0x46), vdeal(0x01), vshuff(0x64), vshuff(0x5b), vshuff(0x6b), vdeal(0x6c), vshuff(0x27), vdeal(0x0a), vdeal(0x08), vshuff(0x29), vdeal(0x7e), vdeal(0x0d), vdeal(0x16)
; CHECK-LABEL: test_000a:
; CHECK-DAG: [[Ra0:r[0-9]+]] = #44
; CHECK-DAG: [[Ra1:r[0-9]+]] = #6
; CHECK-DAG: [[Ra2:r[0-9]+]] = #80
; CHECK: v[[Ha0:[0-9]+]]:[[La0:[0-9]+]] = vshuff(v1,v0,[[Ra0]])
; CHECK: v[[Ha1:[0-9]+]]:[[La1:[0-9]+]] = vdeal(v[[Ha0]],v[[La0]],[[Ra1]])
; CHECK: v[[Ha2:[0-9]+]]:[[La2:[0-9]+]] = vshuff(v[[Ha1]],v[[La1]],[[Ra2]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_000a(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 1, i32 128, i32 129, i32 32, i32 33, i32 160, i32 161, i32 4, i32 5, i32 132, i32 133, i32 36, i32 37, i32 164, i32 165, i32 2, i32 3, i32 130, i32 131, i32 34, i32 35, i32 162, i32 163, i32 6, i32 7, i32 134, i32 135, i32 38, i32 39, i32 166, i32 167, i32 8, i32 9, i32 136, i32 137, i32 40, i32 41, i32 168, i32 169, i32 12, i32 13, i32 140, i32 141, i32 44, i32 45, i32 172, i32 173, i32 10, i32 11, i32 138, i32 139, i32 42, i32 43, i32 170, i32 171, i32 14, i32 15, i32 142, i32 143, i32 46, i32 47, i32 174, i32 175, i32 16, i32 17, i32 144, i32 145, i32 48, i32 49, i32 176, i32 177, i32 20, i32 21, i32 148, i32 149, i32 52, i32 53, i32 180, i32 181, i32 18, i32 19, i32 146, i32 147, i32 50, i32 51, i32 178, i32 179, i32 22, i32 23, i32 150, i32 151, i32 54, i32 55, i32 182, i32 183, i32 24, i32 25, i32 152, i32 153, i32 56, i32 57, i32 184, i32 185, i32 28, i32 29, i32 156, i32 157, i32 60, i32 61, i32 188, i32 189, i32 26, i32 27, i32 154, i32 155, i32 58, i32 59, i32 186, i32 187, i32 30, i32 31, i32 158, i32 159, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 96, i32 97, i32 224, i32 225, i32 68, i32 69, i32 196, i32 197, i32 100, i32 101, i32 228, i32 229, i32 66, i32 67, i32 194, i32 195, i32 98, i32 99, i32 226, i32 227, i32 70, i32 71, i32 198, i32 199, i32 102, i32 103, i32 230, i32 231, i32 72, i32 73, i32 200, i32 201, i32 104, i32 105, i32 232, i32 233, i32 76, i32 77, i32 204, i32 205, i32 108, i32 109, i32 236, i32 237, i32 74, i32 75, i32 202, i32 203, i32 106, i32 107, i32 234, i32 235, i32 78, i32 79, i32 206, i32 207, i32 110, i32 111, i32 238, i32 239, i32 80, i32 81, i32 208, i32 209, i32 112, i32 113, i32 240, i32 241, i32 84, i32 85, i32 212, i32 213, i32 116, i32 117, i32 244, i32 245, i32 82, i32 83, i32 210, i32 211, i32 114, i32 115, i32 242, i32 243, i32 86, i32 87, i32 214, i32 215, i32 118, i32 119, i32 246, i32 247, i32 88, i32 89, i32 216, i32 217, i32 120, i32 121, i32 248, i32 249, i32 92, i32 93, i32 220, i32 221, i32 124, i32 125, i32 252, i32 253, i32 90, i32 91, i32 218, i32 219, i32 122, i32 123, i32 250, i32 251, i32 94, i32 95, i32 222, i32 223, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; Generator: vshuff(0x74), vshuff(0x11), vshuff(0x53), vshuff(0x66), vshuff(0x1d), vdeal(0x59), vshuff(0x63), vshuff(0x49), vdeal(0x00), vshuff(0x38), vshuff(0x45), vdeal(0x68), vshuff(0x65), vshuff(0x6e), vdeal(0x62)
; CHECK-LABEL: test_000b:
; CHECK-DAG: [[Rb0:r[0-9]+]] = #68
; CHECK-DAG: [[Rb1:r[0-9]+]] = #5
; CHECK-DAG: [[Rb2:r[0-9]+]] = #18
; CHECK-DAG: [[Rb3:r[0-9]+]] = #40
; CHECK: v[[Hb0:[0-9]+]]:[[Lb0:[0-9]+]] = vshuff(v1,v0,[[Rb0]])
; CHECK: v[[Hb1:[0-9]+]]:[[Lb1:[0-9]+]] = vdeal(v[[Hb0]],v[[Lb0]],[[Rb1]])
; CHECK: v[[Hb2:[0-9]+]]:[[Lb2:[0-9]+]] = vdeal(v[[Hb1]],v[[Lb1]],[[Rb2]])
; CHECK: v[[Hb3:[0-9]+]]:[[Lb3:[0-9]+]] = vdeal(v[[Hb2]],v[[Lb2]],[[Rb3]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_000b(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 128, i32 16, i32 144, i32 64, i32 192, i32 80, i32 208, i32 32, i32 160, i32 48, i32 176, i32 96, i32 224, i32 112, i32 240, i32 1, i32 129, i32 17, i32 145, i32 65, i32 193, i32 81, i32 209, i32 33, i32 161, i32 49, i32 177, i32 97, i32 225, i32 113, i32 241, i32 2, i32 130, i32 18, i32 146, i32 66, i32 194, i32 82, i32 210, i32 34, i32 162, i32 50, i32 178, i32 98, i32 226, i32 114, i32 242, i32 3, i32 131, i32 19, i32 147, i32 67, i32 195, i32 83, i32 211, i32 35, i32 163, i32 51, i32 179, i32 99, i32 227, i32 115, i32 243, i32 4, i32 132, i32 20, i32 148, i32 68, i32 196, i32 84, i32 212, i32 36, i32 164, i32 52, i32 180, i32 100, i32 228, i32 116, i32 244, i32 5, i32 133, i32 21, i32 149, i32 69, i32 197, i32 85, i32 213, i32 37, i32 165, i32 53, i32 181, i32 101, i32 229, i32 117, i32 245, i32 6, i32 134, i32 22, i32 150, i32 70, i32 198, i32 86, i32 214, i32 38, i32 166, i32 54, i32 182, i32 102, i32 230, i32 118, i32 246, i32 7, i32 135, i32 23, i32 151, i32 71, i32 199, i32 87, i32 215, i32 39, i32 167, i32 55, i32 183, i32 103, i32 231, i32 119, i32 247, i32 8, i32 136, i32 24, i32 152, i32 72, i32 200, i32 88, i32 216, i32 40, i32 168, i32 56, i32 184, i32 104, i32 232, i32 120, i32 248, i32 9, i32 137, i32 25, i32 153, i32 73, i32 201, i32 89, i32 217, i32 41, i32 169, i32 57, i32 185, i32 105, i32 233, i32 121, i32 249, i32 10, i32 138, i32 26, i32 154, i32 74, i32 202, i32 90, i32 218, i32 42, i32 170, i32 58, i32 186, i32 106, i32 234, i32 122, i32 250, i32 11, i32 139, i32 27, i32 155, i32 75, i32 203, i32 91, i32 219, i32 43, i32 171, i32 59, i32 187, i32 107, i32 235, i32 123, i32 251, i32 12, i32 140, i32 28, i32 156, i32 76, i32 204, i32 92, i32 220, i32 44, i32 172, i32 60, i32 188, i32 108, i32 236, i32 124, i32 252, i32 13, i32 141, i32 29, i32 157, i32 77, i32 205, i32 93, i32 221, i32 45, i32 173, i32 61, i32 189, i32 109, i32 237, i32 125, i32 253, i32 14, i32 142, i32 30, i32 158, i32 78, i32 206, i32 94, i32 222, i32 46, i32 174, i32 62, i32 190, i32 110, i32 238, i32 126, i32 254, i32 15, i32 143, i32 31, i32 159, i32 79, i32 207, i32 95, i32 223, i32 47, i32 175, i32 63, i32 191, i32 111, i32 239, i32 127, i32 255>
  ret <256 x i8> %p
}

; Generator: vdeal(0x60), vdeal(0x5c), vdeal(0x4f), vshuff(0x47), vshuff(0x7b), vdeal(0x4a), vdeal(0x1e), vdeal(0x5f), vdeal(0x7a), vshuff(0x36), vshuff(0x69), vshuff(0x31), vdeal(0x03), vdeal(0x1a), vdeal(0x41)
; CHECK-LABEL: test_000c:
; CHECK-DAG: [[Rc0:r[0-9]+]] = #10
; CHECK-DAG: [[Rc1:r[0-9]+]] = #3
; CHECK-DAG: [[Rc2:r[0-9]+]] = #84
; CHECK: v[[Hc0:[0-9]+]]:[[Lc0:[0-9]+]] = vshuff(v1,v0,[[Rc0]])
; CHECK: v[[Hc1:[0-9]+]]:[[Lc1:[0-9]+]] = vdeal(v[[Hc0]],v[[Lc0]],[[Rc1]])
; CHECK: v[[Hc2:[0-9]+]]:[[Lc2:[0-9]+]] = vshuff(v[[Hc1]],v[[Lc1]],[[Rc2]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_000c(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 128, i32 8, i32 136, i32 1, i32 129, i32 9, i32 137, i32 2, i32 130, i32 10, i32 138, i32 3, i32 131, i32 11, i32 139, i32 4, i32 132, i32 12, i32 140, i32 5, i32 133, i32 13, i32 141, i32 6, i32 134, i32 14, i32 142, i32 7, i32 135, i32 15, i32 143, i32 32, i32 160, i32 40, i32 168, i32 33, i32 161, i32 41, i32 169, i32 34, i32 162, i32 42, i32 170, i32 35, i32 163, i32 43, i32 171, i32 36, i32 164, i32 44, i32 172, i32 37, i32 165, i32 45, i32 173, i32 38, i32 166, i32 46, i32 174, i32 39, i32 167, i32 47, i32 175, i32 16, i32 144, i32 24, i32 152, i32 17, i32 145, i32 25, i32 153, i32 18, i32 146, i32 26, i32 154, i32 19, i32 147, i32 27, i32 155, i32 20, i32 148, i32 28, i32 156, i32 21, i32 149, i32 29, i32 157, i32 22, i32 150, i32 30, i32 158, i32 23, i32 151, i32 31, i32 159, i32 48, i32 176, i32 56, i32 184, i32 49, i32 177, i32 57, i32 185, i32 50, i32 178, i32 58, i32 186, i32 51, i32 179, i32 59, i32 187, i32 52, i32 180, i32 60, i32 188, i32 53, i32 181, i32 61, i32 189, i32 54, i32 182, i32 62, i32 190, i32 55, i32 183, i32 63, i32 191, i32 64, i32 192, i32 72, i32 200, i32 65, i32 193, i32 73, i32 201, i32 66, i32 194, i32 74, i32 202, i32 67, i32 195, i32 75, i32 203, i32 68, i32 196, i32 76, i32 204, i32 69, i32 197, i32 77, i32 205, i32 70, i32 198, i32 78, i32 206, i32 71, i32 199, i32 79, i32 207, i32 96, i32 224, i32 104, i32 232, i32 97, i32 225, i32 105, i32 233, i32 98, i32 226, i32 106, i32 234, i32 99, i32 227, i32 107, i32 235, i32 100, i32 228, i32 108, i32 236, i32 101, i32 229, i32 109, i32 237, i32 102, i32 230, i32 110, i32 238, i32 103, i32 231, i32 111, i32 239, i32 80, i32 208, i32 88, i32 216, i32 81, i32 209, i32 89, i32 217, i32 82, i32 210, i32 90, i32 218, i32 83, i32 211, i32 91, i32 219, i32 84, i32 212, i32 92, i32 220, i32 85, i32 213, i32 93, i32 221, i32 86, i32 214, i32 94, i32 222, i32 87, i32 215, i32 95, i32 223, i32 112, i32 240, i32 120, i32 248, i32 113, i32 241, i32 121, i32 249, i32 114, i32 242, i32 122, i32 250, i32 115, i32 243, i32 123, i32 251, i32 116, i32 244, i32 124, i32 252, i32 117, i32 245, i32 125, i32 253, i32 118, i32 246, i32 126, i32 254, i32 119, i32 247, i32 127, i32 255>
  ret <256 x i8> %p
}

; Generator: vdeal(0x58), vdeal(0x0b), vdeal(0x21), vdeal(0x7f), vshuff(0x6a), vshuff(0x78), vshuff(0x52), vshuff(0x73), vshuff(0x06), vdeal(0x2d), vdeal(0x32), vdeal(0x48), vdeal(0x75), vdeal(0x55), vshuff(0x0e)
; CHECK-LABEL: test_000d:
; CHECK-DAG: [[Rd0:r[0-9]+]] = #36
; CHECK-DAG: [[Rd1:r[0-9]+]] = #80
; CHECK-DAG: [[Rd2:r[0-9]+]] = #9
; CHECK: v[[Hd0:[0-9]+]]:[[Ld0:[0-9]+]] = vshuff(v1,v0,[[Rd0]])
; CHECK: v[[Hd1:[0-9]+]]:[[Ld1:[0-9]+]] = vshuff(v[[Hd0]],v[[Ld0]],[[Rd1]])
; CHECK: v[[Hd2:[0-9]+]]:[[Ld2:[0-9]+]] = vdeal(v[[Hd1]],v[[Ld1]],[[Rd2]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_000d(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 8, i32 2, i32 10, i32 128, i32 136, i32 130, i32 138, i32 64, i32 72, i32 66, i32 74, i32 192, i32 200, i32 194, i32 202, i32 32, i32 40, i32 34, i32 42, i32 160, i32 168, i32 162, i32 170, i32 96, i32 104, i32 98, i32 106, i32 224, i32 232, i32 226, i32 234, i32 4, i32 12, i32 6, i32 14, i32 132, i32 140, i32 134, i32 142, i32 68, i32 76, i32 70, i32 78, i32 196, i32 204, i32 198, i32 206, i32 36, i32 44, i32 38, i32 46, i32 164, i32 172, i32 166, i32 174, i32 100, i32 108, i32 102, i32 110, i32 228, i32 236, i32 230, i32 238, i32 16, i32 24, i32 18, i32 26, i32 144, i32 152, i32 146, i32 154, i32 80, i32 88, i32 82, i32 90, i32 208, i32 216, i32 210, i32 218, i32 48, i32 56, i32 50, i32 58, i32 176, i32 184, i32 178, i32 186, i32 112, i32 120, i32 114, i32 122, i32 240, i32 248, i32 242, i32 250, i32 20, i32 28, i32 22, i32 30, i32 148, i32 156, i32 150, i32 158, i32 84, i32 92, i32 86, i32 94, i32 212, i32 220, i32 214, i32 222, i32 52, i32 60, i32 54, i32 62, i32 180, i32 188, i32 182, i32 190, i32 116, i32 124, i32 118, i32 126, i32 244, i32 252, i32 246, i32 254, i32 1, i32 9, i32 3, i32 11, i32 129, i32 137, i32 131, i32 139, i32 65, i32 73, i32 67, i32 75, i32 193, i32 201, i32 195, i32 203, i32 33, i32 41, i32 35, i32 43, i32 161, i32 169, i32 163, i32 171, i32 97, i32 105, i32 99, i32 107, i32 225, i32 233, i32 227, i32 235, i32 5, i32 13, i32 7, i32 15, i32 133, i32 141, i32 135, i32 143, i32 69, i32 77, i32 71, i32 79, i32 197, i32 205, i32 199, i32 207, i32 37, i32 45, i32 39, i32 47, i32 165, i32 173, i32 167, i32 175, i32 101, i32 109, i32 103, i32 111, i32 229, i32 237, i32 231, i32 239, i32 17, i32 25, i32 19, i32 27, i32 145, i32 153, i32 147, i32 155, i32 81, i32 89, i32 83, i32 91, i32 209, i32 217, i32 211, i32 219, i32 49, i32 57, i32 51, i32 59, i32 177, i32 185, i32 179, i32 187, i32 113, i32 121, i32 115, i32 123, i32 241, i32 249, i32 243, i32 251, i32 21, i32 29, i32 23, i32 31, i32 149, i32 157, i32 151, i32 159, i32 85, i32 93, i32 87, i32 95, i32 213, i32 221, i32 215, i32 223, i32 53, i32 61, i32 55, i32 63, i32 181, i32 189, i32 183, i32 191, i32 117, i32 125, i32 119, i32 127, i32 245, i32 253, i32 247, i32 255>
  ret <256 x i8> %p
}

; Generator: vdeal(0x6f), vdeal(0x13), vdeal(0x07), vdeal(0x56), vshuff(0x2c), vdeal(0x0c), vdeal(0x33), vshuff(0x22), vdeal(0x02), vshuff(0x18), vdeal(0x4d), vshuff(0x51), vshuff(0x3e), vshuff(0x77), vshuff(0x30)
; CHECK-LABEL: test_000e:
; CHECK-DAG: [[Re0:r[0-9]+]] = #65
; CHECK-DAG: [[Re1:r[0-9]+]] = #24
; CHECK-DAG: [[Re2:r[0-9]+]] = #36
; CHECK: v[[He0:[0-9]+]]:[[Le0:[0-9]+]] = vshuff(v1,v0,[[Re0]])
; CHECK: v[[He1:[0-9]+]]:[[Le1:[0-9]+]] = vdeal(v[[He0]],v[[Le0]],[[Re1]])
; CHECK: v[[He2:[0-9]+]]:[[Le2:[0-9]+]] = vdeal(v[[He1]],v[[Le1]],[[Re2]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_000e(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 128, i32 2, i32 130, i32 32, i32 160, i32 34, i32 162, i32 16, i32 144, i32 18, i32 146, i32 48, i32 176, i32 50, i32 178, i32 64, i32 192, i32 66, i32 194, i32 96, i32 224, i32 98, i32 226, i32 80, i32 208, i32 82, i32 210, i32 112, i32 240, i32 114, i32 242, i32 8, i32 136, i32 10, i32 138, i32 40, i32 168, i32 42, i32 170, i32 24, i32 152, i32 26, i32 154, i32 56, i32 184, i32 58, i32 186, i32 72, i32 200, i32 74, i32 202, i32 104, i32 232, i32 106, i32 234, i32 88, i32 216, i32 90, i32 218, i32 120, i32 248, i32 122, i32 250, i32 1, i32 129, i32 3, i32 131, i32 33, i32 161, i32 35, i32 163, i32 17, i32 145, i32 19, i32 147, i32 49, i32 177, i32 51, i32 179, i32 65, i32 193, i32 67, i32 195, i32 97, i32 225, i32 99, i32 227, i32 81, i32 209, i32 83, i32 211, i32 113, i32 241, i32 115, i32 243, i32 9, i32 137, i32 11, i32 139, i32 41, i32 169, i32 43, i32 171, i32 25, i32 153, i32 27, i32 155, i32 57, i32 185, i32 59, i32 187, i32 73, i32 201, i32 75, i32 203, i32 105, i32 233, i32 107, i32 235, i32 89, i32 217, i32 91, i32 219, i32 121, i32 249, i32 123, i32 251, i32 4, i32 132, i32 6, i32 134, i32 36, i32 164, i32 38, i32 166, i32 20, i32 148, i32 22, i32 150, i32 52, i32 180, i32 54, i32 182, i32 68, i32 196, i32 70, i32 198, i32 100, i32 228, i32 102, i32 230, i32 84, i32 212, i32 86, i32 214, i32 116, i32 244, i32 118, i32 246, i32 12, i32 140, i32 14, i32 142, i32 44, i32 172, i32 46, i32 174, i32 28, i32 156, i32 30, i32 158, i32 60, i32 188, i32 62, i32 190, i32 76, i32 204, i32 78, i32 206, i32 108, i32 236, i32 110, i32 238, i32 92, i32 220, i32 94, i32 222, i32 124, i32 252, i32 126, i32 254, i32 5, i32 133, i32 7, i32 135, i32 37, i32 165, i32 39, i32 167, i32 21, i32 149, i32 23, i32 151, i32 53, i32 181, i32 55, i32 183, i32 69, i32 197, i32 71, i32 199, i32 101, i32 229, i32 103, i32 231, i32 85, i32 213, i32 87, i32 215, i32 117, i32 245, i32 119, i32 247, i32 13, i32 141, i32 15, i32 143, i32 45, i32 173, i32 47, i32 175, i32 29, i32 157, i32 31, i32 159, i32 61, i32 189, i32 63, i32 191, i32 77, i32 205, i32 79, i32 207, i32 109, i32 237, i32 111, i32 239, i32 93, i32 221, i32 95, i32 223, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; Generator: vdeal(0x44), vshuff(0x57), vdeal(0x5e), vdeal(0x3b), vshuff(0x3d), vshuff(0x28), vdeal(0x2b), vdeal(0x09), vdeal(0x1b), vdeal(0x29), vdeal(0x6d), vdeal(0x61), vshuff(0x54), vdeal(0x34), vshuff(0x1c)
; CHECK-LABEL: test_000f:
; CHECK-DAG: [[Rf0:r[0-9]+]] = #6
; CHECK-DAG: [[Rf1:r[0-9]+]] = #58
; CHECK-DAG: [[Rf2:r[0-9]+]] = #9
; CHECK: v[[Hf0:[0-9]+]]:[[Lf0:[0-9]+]] = vshuff(v1,v0,[[Rf0]])
; CHECK: v[[Hf1:[0-9]+]]:[[Lf1:[0-9]+]] = vshuff(v[[Hf0]],v[[Lf0]],[[Rf1]])
; CHECK: v[[Hf2:[0-9]+]]:[[Lf2:[0-9]+]] = vdeal(v[[Hf1]],v[[Lf1]],[[Rf2]])
; CHECK-NOT: v{{[0-9:]+}} =
define <256 x i8> @test_000f(<256 x i8> %v0) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32><i32 0, i32 128, i32 4, i32 132, i32 2, i32 130, i32 6, i32 134, i32 32, i32 160, i32 36, i32 164, i32 34, i32 162, i32 38, i32 166, i32 8, i32 136, i32 12, i32 140, i32 10, i32 138, i32 14, i32 142, i32 40, i32 168, i32 44, i32 172, i32 42, i32 170, i32 46, i32 174, i32 16, i32 144, i32 20, i32 148, i32 18, i32 146, i32 22, i32 150, i32 48, i32 176, i32 52, i32 180, i32 50, i32 178, i32 54, i32 182, i32 24, i32 152, i32 28, i32 156, i32 26, i32 154, i32 30, i32 158, i32 56, i32 184, i32 60, i32 188, i32 58, i32 186, i32 62, i32 190, i32 64, i32 192, i32 68, i32 196, i32 66, i32 194, i32 70, i32 198, i32 96, i32 224, i32 100, i32 228, i32 98, i32 226, i32 102, i32 230, i32 72, i32 200, i32 76, i32 204, i32 74, i32 202, i32 78, i32 206, i32 104, i32 232, i32 108, i32 236, i32 106, i32 234, i32 110, i32 238, i32 80, i32 208, i32 84, i32 212, i32 82, i32 210, i32 86, i32 214, i32 112, i32 240, i32 116, i32 244, i32 114, i32 242, i32 118, i32 246, i32 88, i32 216, i32 92, i32 220, i32 90, i32 218, i32 94, i32 222, i32 120, i32 248, i32 124, i32 252, i32 122, i32 250, i32 126, i32 254, i32 1, i32 129, i32 5, i32 133, i32 3, i32 131, i32 7, i32 135, i32 33, i32 161, i32 37, i32 165, i32 35, i32 163, i32 39, i32 167, i32 9, i32 137, i32 13, i32 141, i32 11, i32 139, i32 15, i32 143, i32 41, i32 169, i32 45, i32 173, i32 43, i32 171, i32 47, i32 175, i32 17, i32 145, i32 21, i32 149, i32 19, i32 147, i32 23, i32 151, i32 49, i32 177, i32 53, i32 181, i32 51, i32 179, i32 55, i32 183, i32 25, i32 153, i32 29, i32 157, i32 27, i32 155, i32 31, i32 159, i32 57, i32 185, i32 61, i32 189, i32 59, i32 187, i32 63, i32 191, i32 65, i32 193, i32 69, i32 197, i32 67, i32 195, i32 71, i32 199, i32 97, i32 225, i32 101, i32 229, i32 99, i32 227, i32 103, i32 231, i32 73, i32 201, i32 77, i32 205, i32 75, i32 203, i32 79, i32 207, i32 105, i32 233, i32 109, i32 237, i32 107, i32 235, i32 111, i32 239, i32 81, i32 209, i32 85, i32 213, i32 83, i32 211, i32 87, i32 215, i32 113, i32 241, i32 117, i32 245, i32 115, i32 243, i32 119, i32 247, i32 89, i32 217, i32 93, i32 221, i32 91, i32 219, i32 95, i32 223, i32 121, i32 249, i32 125, i32 253, i32 123, i32 251, i32 127, i32 255>
  ret <256 x i8> %p
}

attributes #0 = { nounwind readnone "target-cpu"="hexagonv60" "target-features"="+hvx,+hvx-length128b" }
