; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-- < %s | FileCheck %s

; OR of two rotates of %a0(edi).
define i32 @f0(i32 %a0) #0 {
; CHECK-LABEL: f0:
; CHECK:       # %bb.0: # %b0
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    roll $7, %eax
; CHECK-NEXT:    roll $9, %edi
; CHECK-NEXT:    orl %edi, %eax
; CHECK-NEXT:    retq
b0:
  %v0 = shl i32 %a0, 7
  %v1 = lshr i32 %a0, 25
  %v2 = or i32 %v0, %v1
  %v3 = shl i32 %a0, 9
  %v4 = lshr i32 %a0, 23
  %v5 = or i32 %v3, %v4
  %v6 = or i32 %v2, %v5
  ret i32 %v6
}

; OR of two rotates of %a0(edi) with an extra input %a1(esi).
define i32 @f1(i32 %a0, i32 %a1) #0 {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0: # %b0
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    shll $7, %eax
; CHECK-NEXT:    roll $9, %edi
; CHECK-NEXT:    orl %esi, %edi
; CHECK-NEXT:    orl %edi, %eax
; CHECK-NEXT:    retq
b0:
  %v0 = shl i32 %a0, 7
  %v1 = lshr i32 %a0, 25
  %v2 = or i32 %v0, %a1
  %v3 = shl i32 %a0, 9
  %v4 = lshr i32 %a0, 23
  %v5 = or i32 %v3, %v4
  %v6 = or i32 %v2, %v5
  %v7 = or i32 %v6, %v1
  ret i32 %v6
}

; OR of two rotates of two different inputs: %a0(edi) and %a1(esi).
define i32 @f2(i32 %a0, i32 %a1) #0 {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edi, %ecx
; CHECK-NEXT:    shll $11, %ecx
; CHECK-NEXT:    shrl $21, %edi
; CHECK-NEXT:    movl %esi, %eax
; CHECK-NEXT:    shll $19, %eax
; CHECK-NEXT:    shrl $13, %esi
; CHECK-NEXT:    orl %edi, %esi
; CHECK-NEXT:    orl %esi, %eax
; CHECK-NEXT:    orl %ecx, %eax
; CHECK-NEXT:    retq
  %v0 = shl i32 %a0, 11
  %v1 = lshr i32 %a0, 21
  %v2 = shl i32 %a1, 19
  %v3 = lshr i32 %a1, 13
  %v4 = or i32 %v0, %v2
  %v5 = or i32 %v1, %v3
  %v6 = or i32 %v4, %v5
  ret i32 %v6
}

; ORs of multiple shifts of the same value with only one pair actually
; matching a rotate.
define i32 @f3(i32 %a0) #0 {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0: # %b0
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    leal (,%rdi,8), %ecx
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    shll $5, %eax
; CHECK-NEXT:    movl %edi, %edx
; CHECK-NEXT:    shll $7, %edx
; CHECK-NEXT:    orl %eax, %edx
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    shll $13, %eax
; CHECK-NEXT:    orl %edx, %eax
; CHECK-NEXT:    movl %edi, %edx
; CHECK-NEXT:    shll $19, %edx
; CHECK-NEXT:    orl %eax, %edx
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    shrl $2, %eax
; CHECK-NEXT:    orl %edx, %eax
; CHECK-NEXT:    movl %edi, %edx
; CHECK-NEXT:    shrl $15, %edx
; CHECK-NEXT:    orl %eax, %edx
; CHECK-NEXT:    movl %edi, %esi
; CHECK-NEXT:    shrl $23, %esi
; CHECK-NEXT:    orl %edx, %esi
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    shrl $25, %eax
; CHECK-NEXT:    orl %esi, %eax
; CHECK-NEXT:    shrl $30, %edi
; CHECK-NEXT:    orl %edi, %eax
; CHECK-NEXT:    orl %ecx, %eax
; CHECK-NEXT:    retq
b0:
  %v0 = shl i32 %a0, 3
  %v1 = shl i32 %a0, 5
  %v2 = shl i32 %a0, 7      ; rotate
  %v3 = shl i32 %a0, 13
  %v4 = shl i32 %a0, 19
  %v5 = lshr i32 %a0, 2
  %v6 = lshr i32 %a0, 15
  %v7 = lshr i32 %a0, 23
  %v8 = lshr i32 %a0, 25    ; rotate
  %v9 = lshr i32 %a0, 30
  %v10 = or i32  %v0, %v1
  %v11 = or i32 %v10, %v2
  %v12 = or i32 %v11, %v3
  %v13 = or i32 %v12, %v4
  %v14 = or i32 %v13, %v5
  %v15 = or i32 %v14, %v6
  %v16 = or i32 %v15, %v7
  %v17 = or i32 %v16, %v8
  %v18 = or i32 %v17, %v9
  ret i32 %v18
}

attributes #0 = { readnone nounwind }
