; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s -mtriple=powerpc-unknown-linux -mattr=spe | FileCheck %s -check-prefix=SPE

define i32 @test_f32_oeq_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_oeq_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r5, r6
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"oeq", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ogt_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ogt_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpgt cr0, r5, r6
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ogt", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_oge_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_oge_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r6, r6
; SPE-NEXT:    efscmpeq cr1, r5, r5
; SPE-NEXT:    crand 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    efscmplt cr0, r5, r6
; SPE-NEXT:    crandc 4*cr5+lt, 4*cr5+lt, gt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"oge", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_olt_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_olt_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmplt cr0, r5, r6
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"olt", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ole_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ole_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r6, r6
; SPE-NEXT:    efscmpeq cr1, r5, r5
; SPE-NEXT:    crand 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    efscmpgt cr0, r5, r6
; SPE-NEXT:    crandc 4*cr5+lt, 4*cr5+lt, gt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ole", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_one_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_one_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmplt cr0, r5, r6
; SPE-NEXT:    efscmpgt cr1, r5, r6
; SPE-NEXT:    cror 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"one", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ord_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ord_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r6, r6
; SPE-NEXT:    efscmpeq cr1, r5, r5
; SPE-NEXT:    crand 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ord", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ueq_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ueq_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmplt cr0, r5, r6
; SPE-NEXT:    efscmpgt cr1, r5, r6
; SPE-NEXT:    cror 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    bc 12, 4*cr5+lt, .LBB7_1
; SPE-NEXT:    blr
; SPE-NEXT:  .LBB7_1:
; SPE-NEXT:    addi r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ueq", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ugt_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ugt_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r5, r5
; SPE-NEXT:    efscmpeq cr1, r6, r6
; SPE-NEXT:    crnand 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    efscmpgt cr0, r5, r6
; SPE-NEXT:    cror 4*cr5+lt, gt, 4*cr5+lt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ugt", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_uge_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_uge_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmplt cr0, r5, r6
; SPE-NEXT:    bc 12, gt, .LBB9_1
; SPE-NEXT:    blr
; SPE-NEXT:  .LBB9_1:
; SPE-NEXT:    addi r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"uge", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ult_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ult_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r5, r5
; SPE-NEXT:    efscmpeq cr1, r6, r6
; SPE-NEXT:    crnand 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    efscmplt cr0, r5, r6
; SPE-NEXT:    cror 4*cr5+lt, gt, 4*cr5+lt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ult", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ule_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ule_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpgt cr0, r5, r6
; SPE-NEXT:    bc 12, gt, .LBB11_1
; SPE-NEXT:    blr
; SPE-NEXT:  .LBB11_1:
; SPE-NEXT:    addi r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ule", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_une_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_une_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r5, r6
; SPE-NEXT:    bc 12, gt, .LBB12_1
; SPE-NEXT:    blr
; SPE-NEXT:  .LBB12_1:
; SPE-NEXT:    addi r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"une", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_uno_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_uno_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r5, r5
; SPE-NEXT:    efscmpeq cr1, r6, r6
; SPE-NEXT:    crnand 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"uno", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_oeq_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_oeq_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpeq cr0, r5, r7
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"oeq", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ogt_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ogt_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpgt cr0, r5, r7
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ogt", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_oge_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_oge_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    evmergelo r6, r7, r8
; SPE-NEXT:    efdcmpeq cr0, r6, r6
; SPE-NEXT:    efdcmpeq cr1, r5, r5
; SPE-NEXT:    efdcmplt cr5, r5, r6
; SPE-NEXT:    crand 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    crandc 4*cr5+lt, 4*cr5+lt, 4*cr5+gt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"oge", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_olt_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_olt_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmplt cr0, r5, r7
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"olt", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ole_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ole_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    evmergelo r6, r7, r8
; SPE-NEXT:    efdcmpeq cr0, r6, r6
; SPE-NEXT:    efdcmpeq cr1, r5, r5
; SPE-NEXT:    efdcmpgt cr5, r5, r6
; SPE-NEXT:    crand 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    crandc 4*cr5+lt, 4*cr5+lt, 4*cr5+gt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ole", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_one_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_one_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmplt cr0, r5, r7
; SPE-NEXT:    efdcmpgt cr1, r5, r7
; SPE-NEXT:    cror 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"one", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ord_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ord_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    evmergelo r6, r7, r8
; SPE-NEXT:    efdcmpeq cr0, r6, r6
; SPE-NEXT:    efdcmpeq cr1, r5, r5
; SPE-NEXT:    crand 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ord", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ueq_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ueq_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmplt cr0, r5, r7
; SPE-NEXT:    efdcmpgt cr1, r5, r7
; SPE-NEXT:    cror 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    bc 12, 4*cr5+lt, .LBB21_1
; SPE-NEXT:    blr
; SPE-NEXT:  .LBB21_1:
; SPE-NEXT:    addi r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ueq", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ugt_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ugt_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpeq cr0, r5, r5
; SPE-NEXT:    efdcmpeq cr1, r7, r7
; SPE-NEXT:    efdcmpgt cr5, r5, r7
; SPE-NEXT:    crnand 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    cror 4*cr5+lt, 4*cr5+gt, 4*cr5+lt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ugt", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_uge_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_uge_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmplt cr0, r5, r7
; SPE-NEXT:    bc 12, gt, .LBB23_1
; SPE-NEXT:    blr
; SPE-NEXT:  .LBB23_1:
; SPE-NEXT:    addi r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"uge", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ult_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ult_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpeq cr0, r5, r5
; SPE-NEXT:    efdcmpeq cr1, r7, r7
; SPE-NEXT:    efdcmplt cr5, r5, r7
; SPE-NEXT:    crnand 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    cror 4*cr5+lt, 4*cr5+gt, 4*cr5+lt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ult", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ule_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ule_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpgt cr0, r5, r7
; SPE-NEXT:    bc 12, gt, .LBB25_1
; SPE-NEXT:    blr
; SPE-NEXT:  .LBB25_1:
; SPE-NEXT:    addi r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ule", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_une_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_une_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpeq cr0, r5, r7
; SPE-NEXT:    bc 12, gt, .LBB26_1
; SPE-NEXT:    blr
; SPE-NEXT:  .LBB26_1:
; SPE-NEXT:    addi r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"une", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_uno_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_uno_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpeq cr0, r5, r5
; SPE-NEXT:    efdcmpeq cr1, r7, r7
; SPE-NEXT:    crnand 4*cr5+lt, 4*cr1+gt, gt
; SPE-NEXT:    bclr 12, 4*cr5+lt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    ori r3, r4, 0
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"uno", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

attributes #0 = { strictfp nounwind }

declare i1 @llvm.experimental.constrained.fcmps.f32(float, float, metadata, metadata)
declare i1 @llvm.experimental.constrained.fcmps.f64(double, double, metadata, metadata)
