; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64-none-linux-gnu %s -o - | FileCheck --check-prefix=DAG %s
; RUN: llc -mtriple=aarch64-none-linux-gnu -global-isel %s -o - | FileCheck --check-prefix=GIS %s

declare i32 @llvm.get.fpmode.i32()
declare void @llvm.set.fpmode.i32(i32 %fpmode)
declare void @llvm.reset.fpmode()

define i32 @func_get_fpmode_soft() #0 {
; DAG-LABEL: func_get_fpmode_soft:
; DAG:       // %bb.0: // %entry
; DAG-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; DAG-NEXT:    add x0, sp, #12
; DAG-NEXT:    bl fegetmode
; DAG-NEXT:    ldr w0, [sp, #12]
; DAG-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; DAG-NEXT:    ret
;
; GIS-LABEL: func_get_fpmode_soft:
; GIS:       // %bb.0: // %entry
; GIS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; GIS-NEXT:    add x0, sp, #12
; GIS-NEXT:    bl fegetmode
; GIS-NEXT:    ldr w0, [sp, #12]
; GIS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; GIS-NEXT:    ret
entry:
  %fpmode = call i32 @llvm.get.fpmode.i32()
  ret i32 %fpmode
}

define void @func_set_fpmode_soft(i32 %fpmode) #0 {
; DAG-LABEL: func_set_fpmode_soft:
; DAG:       // %bb.0: // %entry
; DAG-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; DAG-NEXT:    str w0, [sp, #12]
; DAG-NEXT:    add x0, sp, #12
; DAG-NEXT:    bl fesetmode
; DAG-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; DAG-NEXT:    ret
;
; GIS-LABEL: func_set_fpmode_soft:
; GIS:       // %bb.0: // %entry
; GIS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; GIS-NEXT:    str w0, [sp, #12]
; GIS-NEXT:    add x0, sp, #12
; GIS-NEXT:    bl fesetmode
; GIS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; GIS-NEXT:    ret
entry:
  call void @llvm.set.fpmode.i32(i32 %fpmode)
  ret void
}

define void @func_reset_fpmode_soft() #0 {
; DAG-LABEL: func_reset_fpmode_soft:
; DAG:       // %bb.0: // %entry
; DAG-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; DAG-NEXT:    mov x0, #-1 // =0xffffffffffffffff
; DAG-NEXT:    bl fesetmode
; DAG-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; DAG-NEXT:    ret
;
; GIS-LABEL: func_reset_fpmode_soft:
; GIS:       // %bb.0: // %entry
; GIS-NEXT:    mov x0, #-1 // =0xffffffffffffffff
; GIS-NEXT:    b fesetmode
entry:
  call void @llvm.reset.fpmode()
  ret void
}

attributes #0 = { nounwind "use-soft-float"="true" }
