; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s | FileCheck %s

target triple = "aarch64"

; This function would normally scavenge a stackslot from the callee-save
; area, which would lead to spilling 's0' to that stackslot before the
; smstop and filling it with 'addvl + <offset>' after the smstop because
; the frame-pointer is not available.
; This would not be valid, since the vector-length has changed so 'addvl'
; cannot be used. This is testing that the stackslot-scavenging is disabled
; when there are any streaming-mode-changing call-sequences in the
; function.
define void @test_no_stackslot_scavenging(float %f) #0 {
; CHECK-LABEL: test_no_stackslot_scavenging:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp d15, d14, [sp, #-96]! // 16-byte Folded Spill
; CHECK-NEXT:    stp d13, d12, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    stp d11, d10, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    stp d9, d8, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    str x29, [sp, #64] // 8-byte Folded Spill
; CHECK-NEXT:    stp x30, x24, [sp, #80] // 16-byte Folded Spill
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    //APP
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    str s0, [sp, #12] // 4-byte Folded Spill
; CHECK-NEXT:    smstop sm
; CHECK-NEXT:    ldr s0, [sp, #12] // 4-byte Folded Reload
; CHECK-NEXT:    bl use_f
; CHECK-NEXT:    smstart sm
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ldp x30, x24, [sp, #80] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x29, [sp, #64] // 8-byte Folded Reload
; CHECK-NEXT:    ldp d9, d8, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d11, d10, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d13, d12, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d15, d14, [sp], #96 // 16-byte Folded Reload
; CHECK-NEXT:    ret
  %ptr = alloca <vscale x 16 x i8>
  call void asm sideeffect "", "~{x24}"() nounwind
  call void @use_f(float %f)
  ret void
}

declare void @use_f(float)

attributes #0 = { nounwind "target-features"="+sme" "aarch64_pstate_sm_enabled" }
