; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming-compatible-sve < %s | FileCheck %s


target triple = "aarch64-unknown-linux-gnu"

define void @add_v4i8(ptr %a, ptr %b) {
; CHECK-LABEL: add_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    ld1b { z0.h }, p0/z, [x0]
; CHECK-NEXT:    ld1b { z1.h }, p0/z, [x1]
; CHECK-NEXT:    add z0.h, z0.h, z1.h
; CHECK-NEXT:    st1b { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x i8>, ptr %a
  %op2 = load <4 x i8>, ptr %b
  %res = add <4 x i8> %op1, %op2
  store <4 x i8> %res, ptr %a
  ret void
}

define void @add_v8i8(ptr %a, ptr %b) {
; CHECK-LABEL: add_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr d1, [x1]
; CHECK-NEXT:    add z0.b, z0.b, z1.b
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x i8>, ptr %a
  %op2 = load <8 x i8>, ptr %b
  %res = add <8 x i8> %op1, %op2
  store <8 x i8> %res, ptr %a
  ret void
}

define void @add_v16i8(ptr %a, ptr %b) {
; CHECK-LABEL: add_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    add z0.b, z0.b, z1.b
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x i8>, ptr %a
  %op2 = load <16 x i8>, ptr %b
  %res = add <16 x i8> %op1, %op2
  store <16 x i8> %res, ptr %a
  ret void
}

define void @add_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: add_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    add z0.b, z1.b, z0.b
; CHECK-NEXT:    add z1.b, z2.b, z3.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = add <32 x i8> %op1, %op2
  store <32 x i8> %res, ptr %a
  ret void
}

define void @add_v2i16(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: add_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldrh w8, [x0, #2]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    str w8, [sp, #4]
; CHECK-NEXT:    ldrh w8, [x0]
; CHECK-NEXT:    str w8, [sp]
; CHECK-NEXT:    ldrh w8, [x1, #2]
; CHECK-NEXT:    str w8, [sp, #12]
; CHECK-NEXT:    ldrh w8, [x1]
; CHECK-NEXT:    str w8, [sp, #8]
; CHECK-NEXT:    ldp d0, d1, [sp]
; CHECK-NEXT:    add z0.s, z0.s, z1.s
; CHECK-NEXT:    st1h { z0.s }, p0, [x0]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
  %op1 = load <2 x i16>, ptr %a
  %op2 = load <2 x i16>, ptr %b
  %res = add <2 x i16> %op1, %op2
  store <2 x i16> %res, ptr %a
  ret void
}

define void @add_v4i16(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: add_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr d1, [x1]
; CHECK-NEXT:    add z0.h, z0.h, z1.h
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x i16>, ptr %a
  %op2 = load <4 x i16>, ptr %b
  %res = add <4 x i16> %op1, %op2
  store <4 x i16> %res, ptr %a
  ret void
}

define void @add_v8i16(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: add_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    add z0.h, z0.h, z1.h
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %op2 = load <8 x i16>, ptr %b
  %res = add <8 x i16> %op1, %op2
  store <8 x i16> %res, ptr %a
  ret void
}

define void @add_v16i16(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: add_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    add z0.h, z1.h, z0.h
; CHECK-NEXT:    add z1.h, z2.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = add <16 x i16> %op1, %op2
  store <16 x i16> %res, ptr %a
  ret void
}

define void @abs_v2i32(ptr %a) {
; CHECK-LABEL: abs_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    abs z0.s, p0/m, z0.s
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <2 x i32>, ptr %a
  %res = call <2 x i32> @llvm.abs.v2i32(<2 x i32> %op1, i1 false)
  store <2 x i32> %res, ptr %a
  ret void
}

define void @abs_v4i32(ptr %a) {
; CHECK-LABEL: abs_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    abs z0.s, p0/m, z0.s
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x i32>, ptr %a
  %res = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %op1, i1 false)
  store <4 x i32> %res, ptr %a
  ret void
}

define void @abs_v8i32(ptr %a) {
; CHECK-LABEL: abs_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    abs z0.s, p0/m, z0.s
; CHECK-NEXT:    abs z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %op1, i1 false)
  store <8 x i32> %res, ptr %a
  ret void
}

define void @abs_v2i64(ptr %a) {
; CHECK-LABEL: abs_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    abs z0.d, p0/m, z0.d
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <2 x i64>, ptr %a
  %res = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %op1, i1 false)
  store <2 x i64> %res, ptr %a
  ret void
}

define void @abs_v4i64(ptr %a) {
; CHECK-LABEL: abs_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    abs z0.d, p0/m, z0.d
; CHECK-NEXT:    abs z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %op1, i1 false)
  store <4 x i64> %res, ptr %a
  ret void
}

define void @fadd_v2f16(ptr %a, ptr %b) {
; CHECK-LABEL: fadd_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    ldr s0, [x0]
; CHECK-NEXT:    ldr s1, [x1]
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    str w8, [x0]
; CHECK-NEXT:    ret
  %op1 = load <2 x half>, ptr %a
  %op2 = load <2 x half>, ptr %b
  %res = fadd <2 x half> %op1, %op2
  store <2 x half> %res, ptr %a
  ret void
}

define void @fadd_v4f16(ptr %a, ptr %b) {
; CHECK-LABEL: fadd_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr d1, [x1]
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x half>, ptr %a
  %op2 = load <4 x half>, ptr %b
  %res = fadd <4 x half> %op1, %op2
  store <4 x half> %res, ptr %a
  ret void
}

define void @fadd_v8f16(ptr %a, ptr %b) {
; CHECK-LABEL: fadd_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x half>, ptr %a
  %op2 = load <8 x half>, ptr %b
  %res = fadd <8 x half> %op1, %op2
  store <8 x half> %res, ptr %a
  ret void
}

define void @fadd_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: fadd_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fadd z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = fadd <16 x half> %op1, %op2
  store <16 x half> %res, ptr %a
  ret void
}

define void @fadd_v2f32(ptr %a, ptr %b) {
; CHECK-LABEL: fadd_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr d1, [x1]
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <2 x float>, ptr %a
  %op2 = load <2 x float>, ptr %b
  %res = fadd <2 x float> %op1, %op2
  store <2 x float> %res, ptr %a
  ret void
}

define void @fadd_v4f32(ptr %a, ptr %b) {
; CHECK-LABEL: fadd_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x float>, ptr %a
  %op2 = load <4 x float>, ptr %b
  %res = fadd <4 x float> %op1, %op2
  store <4 x float> %res, ptr %a
  ret void
}

define void @fadd_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: fadd_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fadd z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = fadd <8 x float> %op1, %op2
  store <8 x float> %res, ptr %a
  ret void
}

define void @fadd_v2f64(ptr %a, ptr %b) {
; CHECK-LABEL: fadd_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <2 x double>, ptr %a
  %op2 = load <2 x double>, ptr %b
  %res = fadd <2 x double> %op1, %op2
  store <2 x double> %res, ptr %a
  ret void
}

define void @fadd_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: fadd_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fadd z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = fadd <4 x double> %op1, %op2
  store <4 x double> %res, ptr %a
  ret void
}

declare <2 x i32> @llvm.abs.v2i32(<2 x i32>, i1)
declare <4 x i32> @llvm.abs.v4i32(<4 x i32>, i1)
declare <8 x i32> @llvm.abs.v8i32(<8 x i32>, i1)
declare <2 x i64> @llvm.abs.v2i64(<2 x i64>, i1)
declare <4 x i64> @llvm.abs.v4i64(<4 x i64>, i1)
