; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; Check the vctlz* instructions that were added in P8
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr8 < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-ibm-aix-xcoff -vec-extabi -mcpu=pwr8 < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr8 -mattr=-vsx < %s | FileCheck %s --check-prefix=CHECK-NOVSX
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-ibm-aix-xcoff -vec-extabi -mcpu=pwr8 -mattr=-vsx < %s | FileCheck %s --check-prefix=CHECK-NOVSX

declare <16 x i8> @llvm.ctlz.v16i8(<16 x i8>) nounwind readnone
declare <8 x i16> @llvm.ctlz.v8i16(<8 x i16>) nounwind readnone
declare <4 x i32> @llvm.ctlz.v4i32(<4 x i32>) nounwind readnone
declare <2 x i64> @llvm.ctlz.v2i64(<2 x i64>) nounwind readnone

define <16 x i8> @test_v16i8(<16 x i8> %x) nounwind readnone {
; CHECK-LABEL: test_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vclzb 2, 2
; CHECK-NEXT:    blr
;
; CHECK-NOVSX-LABEL: test_v16i8:
; CHECK-NOVSX:       # %bb.0:
; CHECK-NOVSX-NEXT:    vclzb 2, 2
; CHECK-NOVSX-NEXT:    blr
       %vcnt = tail call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %x)
       ret <16 x i8> %vcnt
}

define <8 x i16> @test_v8i16(<8 x i16> %x) nounwind readnone {
; CHECK-LABEL: test_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vclzh 2, 2
; CHECK-NEXT:    blr
;
; CHECK-NOVSX-LABEL: test_v8i16:
; CHECK-NOVSX:       # %bb.0:
; CHECK-NOVSX-NEXT:    vclzh 2, 2
; CHECK-NOVSX-NEXT:    blr
       %vcnt = tail call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %x)
       ret <8 x i16> %vcnt
}

define <4 x i32> @test_v4i32(<4 x i32> %x) nounwind readnone {
; CHECK-LABEL: test_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vclzw 2, 2
; CHECK-NEXT:    blr
;
; CHECK-NOVSX-LABEL: test_v4i32:
; CHECK-NOVSX:       # %bb.0:
; CHECK-NOVSX-NEXT:    vclzw 2, 2
; CHECK-NOVSX-NEXT:    blr
       %vcnt = tail call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %x)
       ret <4 x i32> %vcnt
}

define <2 x i64> @test_v2i64(<2 x i64> %x) nounwind readnone {
; CHECK-LABEL: test_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vclzd 2, 2
; CHECK-NEXT:    blr
;
; CHECK-NOVSX-LABEL: test_v2i64:
; CHECK-NOVSX:       # %bb.0:
; CHECK-NOVSX-NEXT:    vclzd 2, 2
; CHECK-NOVSX-NEXT:    blr
       %vcnt = tail call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %x)
       ret <2 x i64> %vcnt
}

declare <2 x i32> @llvm.ctlz.v2i32(<2 x i32>, i1 immarg)

define <2 x i32> @illegal_ctlz(<2 x i32> %v1) {
; CHECK-LABEL: illegal_ctlz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vclzw 2, 2
; CHECK-NEXT:    blr
;
; CHECK-NOVSX-LABEL: illegal_ctlz:
; CHECK-NOVSX:       # %bb.0:
; CHECK-NOVSX-NEXT:    vclzw 2, 2
; CHECK-NOVSX-NEXT:    blr
  %v2 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %v1, i1 true)
  ret <2 x i32> %v2
}

declare <2 x i32> @llvm.cttz.v2i32(<2 x i32>, i1 immarg)

define <2 x i32> @illegal_cttz(<2 x i32> %v1) {
; CHECK-LABEL: illegal_cttz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vspltisw 3, 1
; CHECK-NEXT:    vsubuwm 3, 2, 3
; CHECK-NEXT:    xxlandc 34, 35, 34
; CHECK-NEXT:    vpopcntw 2, 2
; CHECK-NEXT:    blr
;
; CHECK-NOVSX-LABEL: illegal_cttz:
; CHECK-NOVSX:       # %bb.0:
; CHECK-NOVSX-NEXT:    vspltisw 3, 1
; CHECK-NOVSX-NEXT:    vsubuwm 3, 2, 3
; CHECK-NOVSX-NEXT:    vandc 2, 3, 2
; CHECK-NOVSX-NEXT:    vpopcntw 2, 2
; CHECK-NOVSX-NEXT:    blr
  %v2 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %v1, i1 true)
  ret <2 x i32> %v2
}
