; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-RV32
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-RV64
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvkb -verify-machineinstrs < %s | FileCheck %s --check-prefix=CHECK-ZVKB
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvkb -verify-machineinstrs < %s | FileCheck %s --check-prefix=CHECK-ZVKB

declare <vscale x 1 x i8> @llvm.fshl.nxv1i8(<vscale x 1 x i8>, <vscale x 1 x i8>, <vscale x 1 x i8>)

define <vscale x 1 x i8> @vrol_vv_nxv1i8(<vscale x 1 x i8> %a, <vscale x 1 x i8> %b) {
; CHECK-LABEL: vrol_vv_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vand.vi v10, v9, 7
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv1i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v9
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 1 x i8> @llvm.fshl.nxv1i8(<vscale x 1 x i8> %a, <vscale x 1 x i8> %a, <vscale x 1 x i8> %b)
  ret <vscale x 1 x i8> %x
}

define <vscale x 1 x i8> @vrol_vx_nxv1i8(<vscale x 1 x i8> %a, i8 %b) {
; CHECK-LABEL: vrol_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vand.vi v10, v9, 7
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv1i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %b.splat = shufflevector <vscale x 1 x i8> %b.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %x = call <vscale x 1 x i8> @llvm.fshl.nxv1i8(<vscale x 1 x i8> %a, <vscale x 1 x i8> %a, <vscale x 1 x i8> %b.splat)
  ret <vscale x 1 x i8> %x
}

declare <vscale x 2 x i8> @llvm.fshl.nxv2i8(<vscale x 2 x i8>, <vscale x 2 x i8>, <vscale x 2 x i8>)

define <vscale x 2 x i8> @vrol_vv_nxv2i8(<vscale x 2 x i8> %a, <vscale x 2 x i8> %b) {
; CHECK-LABEL: vrol_vv_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vand.vi v10, v9, 7
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv2i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v9
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 2 x i8> @llvm.fshl.nxv2i8(<vscale x 2 x i8> %a, <vscale x 2 x i8> %a, <vscale x 2 x i8> %b)
  ret <vscale x 2 x i8> %x
}

define <vscale x 2 x i8> @vrol_vx_nxv2i8(<vscale x 2 x i8> %a, i8 %b) {
; CHECK-LABEL: vrol_vx_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vand.vi v10, v9, 7
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv2i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 2 x i8> poison, i8 %b, i32 0
  %b.splat = shufflevector <vscale x 2 x i8> %b.head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %x = call <vscale x 2 x i8> @llvm.fshl.nxv2i8(<vscale x 2 x i8> %a, <vscale x 2 x i8> %a, <vscale x 2 x i8> %b.splat)
  ret <vscale x 2 x i8> %x
}

declare <vscale x 4 x i8> @llvm.fshl.nxv4i8(<vscale x 4 x i8>, <vscale x 4 x i8>, <vscale x 4 x i8>)

define <vscale x 4 x i8> @vrol_vv_nxv4i8(<vscale x 4 x i8> %a, <vscale x 4 x i8> %b) {
; CHECK-LABEL: vrol_vv_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vand.vi v10, v9, 7
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv4i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v9
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 4 x i8> @llvm.fshl.nxv4i8(<vscale x 4 x i8> %a, <vscale x 4 x i8> %a, <vscale x 4 x i8> %b)
  ret <vscale x 4 x i8> %x
}

define <vscale x 4 x i8> @vrol_vx_nxv4i8(<vscale x 4 x i8> %a, i8 %b) {
; CHECK-LABEL: vrol_vx_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vand.vi v10, v9, 7
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv4i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 4 x i8> poison, i8 %b, i32 0
  %b.splat = shufflevector <vscale x 4 x i8> %b.head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %x = call <vscale x 4 x i8> @llvm.fshl.nxv4i8(<vscale x 4 x i8> %a, <vscale x 4 x i8> %a, <vscale x 4 x i8> %b.splat)
  ret <vscale x 4 x i8> %x
}

declare <vscale x 8 x i8> @llvm.fshl.nxv8i8(<vscale x 8 x i8>, <vscale x 8 x i8>, <vscale x 8 x i8>)

define <vscale x 8 x i8> @vrol_vv_nxv8i8(<vscale x 8 x i8> %a, <vscale x 8 x i8> %b) {
; CHECK-LABEL: vrol_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vand.vi v10, v9, 7
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv8i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v9
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 8 x i8> @llvm.fshl.nxv8i8(<vscale x 8 x i8> %a, <vscale x 8 x i8> %a, <vscale x 8 x i8> %b)
  ret <vscale x 8 x i8> %x
}

define <vscale x 8 x i8> @vrol_vx_nxv8i8(<vscale x 8 x i8> %a, i8 %b) {
; CHECK-LABEL: vrol_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vand.vi v10, v9, 7
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv8i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %b.splat = shufflevector <vscale x 8 x i8> %b.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %x = call <vscale x 8 x i8> @llvm.fshl.nxv8i8(<vscale x 8 x i8> %a, <vscale x 8 x i8> %a, <vscale x 8 x i8> %b.splat)
  ret <vscale x 8 x i8> %x
}

declare <vscale x 16 x i8> @llvm.fshl.nxv16i8(<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>)

define <vscale x 16 x i8> @vrol_vv_nxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: vrol_vv_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vand.vi v12, v10, 7
; CHECK-NEXT:    vsll.vv v12, v8, v12
; CHECK-NEXT:    vrsub.vi v10, v10, 0
; CHECK-NEXT:    vand.vi v10, v10, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v10
; CHECK-NEXT:    vor.vv v8, v12, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv16i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v10
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 16 x i8> @llvm.fshl.nxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %a, <vscale x 16 x i8> %b)
  ret <vscale x 16 x i8> %x
}

define <vscale x 16 x i8> @vrol_vx_nxv16i8(<vscale x 16 x i8> %a, i8 %b) {
; CHECK-LABEL: vrol_vx_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v10, a0
; CHECK-NEXT:    vand.vi v12, v10, 7
; CHECK-NEXT:    vsll.vv v12, v8, v12
; CHECK-NEXT:    vrsub.vi v10, v10, 0
; CHECK-NEXT:    vand.vi v10, v10, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v10
; CHECK-NEXT:    vor.vv v8, v12, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv16i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 16 x i8> poison, i8 %b, i32 0
  %b.splat = shufflevector <vscale x 16 x i8> %b.head, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %x = call <vscale x 16 x i8> @llvm.fshl.nxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %a, <vscale x 16 x i8> %b.splat)
  ret <vscale x 16 x i8> %x
}

declare <vscale x 32 x i8> @llvm.fshl.nxv32i8(<vscale x 32 x i8>, <vscale x 32 x i8>, <vscale x 32 x i8>)

define <vscale x 32 x i8> @vrol_vv_nxv32i8(<vscale x 32 x i8> %a, <vscale x 32 x i8> %b) {
; CHECK-LABEL: vrol_vv_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vand.vi v16, v12, 7
; CHECK-NEXT:    vsll.vv v16, v8, v16
; CHECK-NEXT:    vrsub.vi v12, v12, 0
; CHECK-NEXT:    vand.vi v12, v12, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v12
; CHECK-NEXT:    vor.vv v8, v16, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv32i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v12
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 32 x i8> @llvm.fshl.nxv32i8(<vscale x 32 x i8> %a, <vscale x 32 x i8> %a, <vscale x 32 x i8> %b)
  ret <vscale x 32 x i8> %x
}

define <vscale x 32 x i8> @vrol_vx_nxv32i8(<vscale x 32 x i8> %a, i8 %b) {
; CHECK-LABEL: vrol_vx_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vand.vi v16, v12, 7
; CHECK-NEXT:    vsll.vv v16, v8, v16
; CHECK-NEXT:    vrsub.vi v12, v12, 0
; CHECK-NEXT:    vand.vi v12, v12, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v12
; CHECK-NEXT:    vor.vv v8, v16, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv32i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, m4, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 32 x i8> poison, i8 %b, i32 0
  %b.splat = shufflevector <vscale x 32 x i8> %b.head, <vscale x 32 x i8> poison, <vscale x 32 x i32> zeroinitializer
  %x = call <vscale x 32 x i8> @llvm.fshl.nxv32i8(<vscale x 32 x i8> %a, <vscale x 32 x i8> %a, <vscale x 32 x i8> %b.splat)
  ret <vscale x 32 x i8> %x
}

declare <vscale x 64 x i8> @llvm.fshl.nxv64i8(<vscale x 64 x i8>, <vscale x 64 x i8>, <vscale x 64 x i8>)

define <vscale x 64 x i8> @vrol_vv_nxv64i8(<vscale x 64 x i8> %a, <vscale x 64 x i8> %b) {
; CHECK-LABEL: vrol_vv_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vand.vi v24, v16, 7
; CHECK-NEXT:    vsll.vv v24, v8, v24
; CHECK-NEXT:    vrsub.vi v16, v16, 0
; CHECK-NEXT:    vand.vi v16, v16, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v16
; CHECK-NEXT:    vor.vv v8, v24, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv64i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v16
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 64 x i8> @llvm.fshl.nxv64i8(<vscale x 64 x i8> %a, <vscale x 64 x i8> %a, <vscale x 64 x i8> %b)
  ret <vscale x 64 x i8> %x
}

define <vscale x 64 x i8> @vrol_vx_nxv64i8(<vscale x 64 x i8> %a, i8 %b) {
; CHECK-LABEL: vrol_vx_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m8, ta, ma
; CHECK-NEXT:    vmv.v.x v16, a0
; CHECK-NEXT:    vand.vi v24, v16, 7
; CHECK-NEXT:    vsll.vv v24, v8, v24
; CHECK-NEXT:    vrsub.vi v16, v16, 0
; CHECK-NEXT:    vand.vi v16, v16, 7
; CHECK-NEXT:    vsrl.vv v8, v8, v16
; CHECK-NEXT:    vor.vv v8, v24, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv64i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e8, m8, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 64 x i8> poison, i8 %b, i32 0
  %b.splat = shufflevector <vscale x 64 x i8> %b.head, <vscale x 64 x i8> poison, <vscale x 64 x i32> zeroinitializer
  %x = call <vscale x 64 x i8> @llvm.fshl.nxv64i8(<vscale x 64 x i8> %a, <vscale x 64 x i8> %a, <vscale x 64 x i8> %b.splat)
  ret <vscale x 64 x i8> %x
}

declare <vscale x 1 x i16> @llvm.fshl.nxv1i16(<vscale x 1 x i16>, <vscale x 1 x i16>, <vscale x 1 x i16>)

define <vscale x 1 x i16> @vrol_vv_nxv1i16(<vscale x 1 x i16> %a, <vscale x 1 x i16> %b) {
; CHECK-LABEL: vrol_vv_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vand.vi v10, v9, 15
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 15
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv1i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v9
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 1 x i16> @llvm.fshl.nxv1i16(<vscale x 1 x i16> %a, <vscale x 1 x i16> %a, <vscale x 1 x i16> %b)
  ret <vscale x 1 x i16> %x
}

define <vscale x 1 x i16> @vrol_vx_nxv1i16(<vscale x 1 x i16> %a, i16 %b) {
; CHECK-LABEL: vrol_vx_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vand.vi v10, v9, 15
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 15
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv1i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 1 x i16> poison, i16 %b, i32 0
  %b.splat = shufflevector <vscale x 1 x i16> %b.head, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %x = call <vscale x 1 x i16> @llvm.fshl.nxv1i16(<vscale x 1 x i16> %a, <vscale x 1 x i16> %a, <vscale x 1 x i16> %b.splat)
  ret <vscale x 1 x i16> %x
}

declare <vscale x 2 x i16> @llvm.fshl.nxv2i16(<vscale x 2 x i16>, <vscale x 2 x i16>, <vscale x 2 x i16>)

define <vscale x 2 x i16> @vrol_vv_nxv2i16(<vscale x 2 x i16> %a, <vscale x 2 x i16> %b) {
; CHECK-LABEL: vrol_vv_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vand.vi v10, v9, 15
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 15
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv2i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v9
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 2 x i16> @llvm.fshl.nxv2i16(<vscale x 2 x i16> %a, <vscale x 2 x i16> %a, <vscale x 2 x i16> %b)
  ret <vscale x 2 x i16> %x
}

define <vscale x 2 x i16> @vrol_vx_nxv2i16(<vscale x 2 x i16> %a, i16 %b) {
; CHECK-LABEL: vrol_vx_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vand.vi v10, v9, 15
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 15
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv2i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 2 x i16> poison, i16 %b, i32 0
  %b.splat = shufflevector <vscale x 2 x i16> %b.head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %x = call <vscale x 2 x i16> @llvm.fshl.nxv2i16(<vscale x 2 x i16> %a, <vscale x 2 x i16> %a, <vscale x 2 x i16> %b.splat)
  ret <vscale x 2 x i16> %x
}

declare <vscale x 4 x i16> @llvm.fshl.nxv4i16(<vscale x 4 x i16>, <vscale x 4 x i16>, <vscale x 4 x i16>)

define <vscale x 4 x i16> @vrol_vv_nxv4i16(<vscale x 4 x i16> %a, <vscale x 4 x i16> %b) {
; CHECK-LABEL: vrol_vv_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vand.vi v10, v9, 15
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 15
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv4i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v9
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 4 x i16> @llvm.fshl.nxv4i16(<vscale x 4 x i16> %a, <vscale x 4 x i16> %a, <vscale x 4 x i16> %b)
  ret <vscale x 4 x i16> %x
}

define <vscale x 4 x i16> @vrol_vx_nxv4i16(<vscale x 4 x i16> %a, i16 %b) {
; CHECK-LABEL: vrol_vx_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vand.vi v10, v9, 15
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vi v9, v9, 15
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv4i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 4 x i16> poison, i16 %b, i32 0
  %b.splat = shufflevector <vscale x 4 x i16> %b.head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %x = call <vscale x 4 x i16> @llvm.fshl.nxv4i16(<vscale x 4 x i16> %a, <vscale x 4 x i16> %a, <vscale x 4 x i16> %b.splat)
  ret <vscale x 4 x i16> %x
}

declare <vscale x 8 x i16> @llvm.fshl.nxv8i16(<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>)

define <vscale x 8 x i16> @vrol_vv_nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b) {
; CHECK-LABEL: vrol_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vand.vi v12, v10, 15
; CHECK-NEXT:    vsll.vv v12, v8, v12
; CHECK-NEXT:    vrsub.vi v10, v10, 0
; CHECK-NEXT:    vand.vi v10, v10, 15
; CHECK-NEXT:    vsrl.vv v8, v8, v10
; CHECK-NEXT:    vor.vv v8, v12, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv8i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v10
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 8 x i16> @llvm.fshl.nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %a, <vscale x 8 x i16> %b)
  ret <vscale x 8 x i16> %x
}

define <vscale x 8 x i16> @vrol_vx_nxv8i16(<vscale x 8 x i16> %a, i16 %b) {
; CHECK-LABEL: vrol_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v10, a0
; CHECK-NEXT:    vand.vi v12, v10, 15
; CHECK-NEXT:    vsll.vv v12, v8, v12
; CHECK-NEXT:    vrsub.vi v10, v10, 0
; CHECK-NEXT:    vand.vi v10, v10, 15
; CHECK-NEXT:    vsrl.vv v8, v8, v10
; CHECK-NEXT:    vor.vv v8, v12, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv8i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %b.splat = shufflevector <vscale x 8 x i16> %b.head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %x = call <vscale x 8 x i16> @llvm.fshl.nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %a, <vscale x 8 x i16> %b.splat)
  ret <vscale x 8 x i16> %x
}

declare <vscale x 16 x i16> @llvm.fshl.nxv16i16(<vscale x 16 x i16>, <vscale x 16 x i16>, <vscale x 16 x i16>)

define <vscale x 16 x i16> @vrol_vv_nxv16i16(<vscale x 16 x i16> %a, <vscale x 16 x i16> %b) {
; CHECK-LABEL: vrol_vv_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vand.vi v16, v12, 15
; CHECK-NEXT:    vsll.vv v16, v8, v16
; CHECK-NEXT:    vrsub.vi v12, v12, 0
; CHECK-NEXT:    vand.vi v12, v12, 15
; CHECK-NEXT:    vsrl.vv v8, v8, v12
; CHECK-NEXT:    vor.vv v8, v16, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv16i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v12
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 16 x i16> @llvm.fshl.nxv16i16(<vscale x 16 x i16> %a, <vscale x 16 x i16> %a, <vscale x 16 x i16> %b)
  ret <vscale x 16 x i16> %x
}

define <vscale x 16 x i16> @vrol_vx_nxv16i16(<vscale x 16 x i16> %a, i16 %b) {
; CHECK-LABEL: vrol_vx_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vand.vi v16, v12, 15
; CHECK-NEXT:    vsll.vv v16, v8, v16
; CHECK-NEXT:    vrsub.vi v12, v12, 0
; CHECK-NEXT:    vand.vi v12, v12, 15
; CHECK-NEXT:    vsrl.vv v8, v8, v12
; CHECK-NEXT:    vor.vv v8, v16, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv16i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 16 x i16> poison, i16 %b, i32 0
  %b.splat = shufflevector <vscale x 16 x i16> %b.head, <vscale x 16 x i16> poison, <vscale x 16 x i32> zeroinitializer
  %x = call <vscale x 16 x i16> @llvm.fshl.nxv16i16(<vscale x 16 x i16> %a, <vscale x 16 x i16> %a, <vscale x 16 x i16> %b.splat)
  ret <vscale x 16 x i16> %x
}

declare <vscale x 32 x i16> @llvm.fshl.nxv32i16(<vscale x 32 x i16>, <vscale x 32 x i16>, <vscale x 32 x i16>)

define <vscale x 32 x i16> @vrol_vv_nxv32i16(<vscale x 32 x i16> %a, <vscale x 32 x i16> %b) {
; CHECK-LABEL: vrol_vv_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vand.vi v24, v16, 15
; CHECK-NEXT:    vsll.vv v24, v8, v24
; CHECK-NEXT:    vrsub.vi v16, v16, 0
; CHECK-NEXT:    vand.vi v16, v16, 15
; CHECK-NEXT:    vsrl.vv v8, v8, v16
; CHECK-NEXT:    vor.vv v8, v24, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv32i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v16
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 32 x i16> @llvm.fshl.nxv32i16(<vscale x 32 x i16> %a, <vscale x 32 x i16> %a, <vscale x 32 x i16> %b)
  ret <vscale x 32 x i16> %x
}

define <vscale x 32 x i16> @vrol_vx_nxv32i16(<vscale x 32 x i16> %a, i16 %b) {
; CHECK-LABEL: vrol_vx_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmv.v.x v16, a0
; CHECK-NEXT:    vand.vi v24, v16, 15
; CHECK-NEXT:    vsll.vv v24, v8, v24
; CHECK-NEXT:    vrsub.vi v16, v16, 0
; CHECK-NEXT:    vand.vi v16, v16, 15
; CHECK-NEXT:    vsrl.vv v8, v8, v16
; CHECK-NEXT:    vor.vv v8, v24, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv32i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 32 x i16> poison, i16 %b, i32 0
  %b.splat = shufflevector <vscale x 32 x i16> %b.head, <vscale x 32 x i16> poison, <vscale x 32 x i32> zeroinitializer
  %x = call <vscale x 32 x i16> @llvm.fshl.nxv32i16(<vscale x 32 x i16> %a, <vscale x 32 x i16> %a, <vscale x 32 x i16> %b.splat)
  ret <vscale x 32 x i16> %x
}

declare <vscale x 1 x i32> @llvm.fshl.nxv1i32(<vscale x 1 x i32>, <vscale x 1 x i32>, <vscale x 1 x i32>)

define <vscale x 1 x i32> @vrol_vv_nxv1i32(<vscale x 1 x i32> %a, <vscale x 1 x i32> %b) {
; CHECK-LABEL: vrol_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 31
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vand.vx v10, v9, a0
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv1i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v9
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 1 x i32> @llvm.fshl.nxv1i32(<vscale x 1 x i32> %a, <vscale x 1 x i32> %a, <vscale x 1 x i32> %b)
  ret <vscale x 1 x i32> %x
}

define <vscale x 1 x i32> @vrol_vx_nxv1i32(<vscale x 1 x i32> %a, i32 %b) {
; CHECK-RV32-LABEL: vrol_vx_nxv1i32:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    andi a1, a0, 31
; CHECK-RV32-NEXT:    vsetvli a2, zero, e32, mf2, ta, ma
; CHECK-RV32-NEXT:    vsll.vx v9, v8, a1
; CHECK-RV32-NEXT:    neg a0, a0
; CHECK-RV32-NEXT:    andi a0, a0, 31
; CHECK-RV32-NEXT:    vsrl.vx v8, v8, a0
; CHECK-RV32-NEXT:    vor.vv v8, v9, v8
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vrol_vx_nxv1i32:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-RV64-NEXT:    vmv.v.x v9, a0
; CHECK-RV64-NEXT:    li a0, 31
; CHECK-RV64-NEXT:    vand.vx v10, v9, a0
; CHECK-RV64-NEXT:    vsll.vv v10, v8, v10
; CHECK-RV64-NEXT:    vrsub.vi v9, v9, 0
; CHECK-RV64-NEXT:    vand.vx v9, v9, a0
; CHECK-RV64-NEXT:    vsrl.vv v8, v8, v9
; CHECK-RV64-NEXT:    vor.vv v8, v10, v8
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv1i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %b.splat = shufflevector <vscale x 1 x i32> %b.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %x = call <vscale x 1 x i32> @llvm.fshl.nxv1i32(<vscale x 1 x i32> %a, <vscale x 1 x i32> %a, <vscale x 1 x i32> %b.splat)
  ret <vscale x 1 x i32> %x
}

declare <vscale x 2 x i32> @llvm.fshl.nxv2i32(<vscale x 2 x i32>, <vscale x 2 x i32>, <vscale x 2 x i32>)

define <vscale x 2 x i32> @vrol_vv_nxv2i32(<vscale x 2 x i32> %a, <vscale x 2 x i32> %b) {
; CHECK-LABEL: vrol_vv_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 31
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vand.vx v10, v9, a0
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv2i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v9
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 2 x i32> @llvm.fshl.nxv2i32(<vscale x 2 x i32> %a, <vscale x 2 x i32> %a, <vscale x 2 x i32> %b)
  ret <vscale x 2 x i32> %x
}

define <vscale x 2 x i32> @vrol_vx_nxv2i32(<vscale x 2 x i32> %a, i32 %b) {
; CHECK-RV32-LABEL: vrol_vx_nxv2i32:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    andi a1, a0, 31
; CHECK-RV32-NEXT:    vsetvli a2, zero, e32, m1, ta, ma
; CHECK-RV32-NEXT:    vsll.vx v9, v8, a1
; CHECK-RV32-NEXT:    neg a0, a0
; CHECK-RV32-NEXT:    andi a0, a0, 31
; CHECK-RV32-NEXT:    vsrl.vx v8, v8, a0
; CHECK-RV32-NEXT:    vor.vv v8, v9, v8
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vrol_vx_nxv2i32:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-RV64-NEXT:    vmv.v.x v9, a0
; CHECK-RV64-NEXT:    li a0, 31
; CHECK-RV64-NEXT:    vand.vx v10, v9, a0
; CHECK-RV64-NEXT:    vsll.vv v10, v8, v10
; CHECK-RV64-NEXT:    vrsub.vi v9, v9, 0
; CHECK-RV64-NEXT:    vand.vx v9, v9, a0
; CHECK-RV64-NEXT:    vsrl.vv v8, v8, v9
; CHECK-RV64-NEXT:    vor.vv v8, v10, v8
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv2i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %b.splat = shufflevector <vscale x 2 x i32> %b.head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %x = call <vscale x 2 x i32> @llvm.fshl.nxv2i32(<vscale x 2 x i32> %a, <vscale x 2 x i32> %a, <vscale x 2 x i32> %b.splat)
  ret <vscale x 2 x i32> %x
}

declare <vscale x 4 x i32> @llvm.fshl.nxv4i32(<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>)

define <vscale x 4 x i32> @vrol_vv_nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: vrol_vv_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 31
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vand.vx v12, v10, a0
; CHECK-NEXT:    vsll.vv v12, v8, v12
; CHECK-NEXT:    vrsub.vi v10, v10, 0
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    vsrl.vv v8, v8, v10
; CHECK-NEXT:    vor.vv v8, v12, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv4i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v10
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 4 x i32> @llvm.fshl.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b)
  ret <vscale x 4 x i32> %x
}

define <vscale x 4 x i32> @vrol_vx_nxv4i32(<vscale x 4 x i32> %a, i32 %b) {
; CHECK-RV32-LABEL: vrol_vx_nxv4i32:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    andi a1, a0, 31
; CHECK-RV32-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; CHECK-RV32-NEXT:    vsll.vx v10, v8, a1
; CHECK-RV32-NEXT:    neg a0, a0
; CHECK-RV32-NEXT:    andi a0, a0, 31
; CHECK-RV32-NEXT:    vsrl.vx v8, v8, a0
; CHECK-RV32-NEXT:    vor.vv v8, v10, v8
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vrol_vx_nxv4i32:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-RV64-NEXT:    vmv.v.x v10, a0
; CHECK-RV64-NEXT:    li a0, 31
; CHECK-RV64-NEXT:    vand.vx v12, v10, a0
; CHECK-RV64-NEXT:    vsll.vv v12, v8, v12
; CHECK-RV64-NEXT:    vrsub.vi v10, v10, 0
; CHECK-RV64-NEXT:    vand.vx v10, v10, a0
; CHECK-RV64-NEXT:    vsrl.vv v8, v8, v10
; CHECK-RV64-NEXT:    vor.vv v8, v12, v8
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv4i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %b.splat = shufflevector <vscale x 4 x i32> %b.head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %x = call <vscale x 4 x i32> @llvm.fshl.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b.splat)
  ret <vscale x 4 x i32> %x
}

declare <vscale x 8 x i32> @llvm.fshl.nxv8i32(<vscale x 8 x i32>, <vscale x 8 x i32>, <vscale x 8 x i32>)

define <vscale x 8 x i32> @vrol_vv_nxv8i32(<vscale x 8 x i32> %a, <vscale x 8 x i32> %b) {
; CHECK-LABEL: vrol_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 31
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vand.vx v16, v12, a0
; CHECK-NEXT:    vsll.vv v16, v8, v16
; CHECK-NEXT:    vrsub.vi v12, v12, 0
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vsrl.vv v8, v8, v12
; CHECK-NEXT:    vor.vv v8, v16, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv8i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v12
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 8 x i32> @llvm.fshl.nxv8i32(<vscale x 8 x i32> %a, <vscale x 8 x i32> %a, <vscale x 8 x i32> %b)
  ret <vscale x 8 x i32> %x
}

define <vscale x 8 x i32> @vrol_vx_nxv8i32(<vscale x 8 x i32> %a, i32 %b) {
; CHECK-RV32-LABEL: vrol_vx_nxv8i32:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    andi a1, a0, 31
; CHECK-RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, ma
; CHECK-RV32-NEXT:    vsll.vx v12, v8, a1
; CHECK-RV32-NEXT:    neg a0, a0
; CHECK-RV32-NEXT:    andi a0, a0, 31
; CHECK-RV32-NEXT:    vsrl.vx v8, v8, a0
; CHECK-RV32-NEXT:    vor.vv v8, v12, v8
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vrol_vx_nxv8i32:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-RV64-NEXT:    vmv.v.x v12, a0
; CHECK-RV64-NEXT:    li a0, 31
; CHECK-RV64-NEXT:    vand.vx v16, v12, a0
; CHECK-RV64-NEXT:    vsll.vv v16, v8, v16
; CHECK-RV64-NEXT:    vrsub.vi v12, v12, 0
; CHECK-RV64-NEXT:    vand.vx v12, v12, a0
; CHECK-RV64-NEXT:    vsrl.vv v8, v8, v12
; CHECK-RV64-NEXT:    vor.vv v8, v16, v8
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv8i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %b.splat = shufflevector <vscale x 8 x i32> %b.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %x = call <vscale x 8 x i32> @llvm.fshl.nxv8i32(<vscale x 8 x i32> %a, <vscale x 8 x i32> %a, <vscale x 8 x i32> %b.splat)
  ret <vscale x 8 x i32> %x
}

declare <vscale x 16 x i32> @llvm.fshl.nxv16i32(<vscale x 16 x i32>, <vscale x 16 x i32>, <vscale x 16 x i32>)

define <vscale x 16 x i32> @vrol_vv_nxv16i32(<vscale x 16 x i32> %a, <vscale x 16 x i32> %b) {
; CHECK-LABEL: vrol_vv_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 31
; CHECK-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-NEXT:    vand.vx v24, v16, a0
; CHECK-NEXT:    vsll.vv v24, v8, v24
; CHECK-NEXT:    vrsub.vi v16, v16, 0
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    vsrl.vv v8, v8, v16
; CHECK-NEXT:    vor.vv v8, v24, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv16i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v16
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 16 x i32> @llvm.fshl.nxv16i32(<vscale x 16 x i32> %a, <vscale x 16 x i32> %a, <vscale x 16 x i32> %b)
  ret <vscale x 16 x i32> %x
}

define <vscale x 16 x i32> @vrol_vx_nxv16i32(<vscale x 16 x i32> %a, i32 %b) {
; CHECK-RV32-LABEL: vrol_vx_nxv16i32:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    andi a1, a0, 31
; CHECK-RV32-NEXT:    vsetvli a2, zero, e32, m8, ta, ma
; CHECK-RV32-NEXT:    vsll.vx v16, v8, a1
; CHECK-RV32-NEXT:    neg a0, a0
; CHECK-RV32-NEXT:    andi a0, a0, 31
; CHECK-RV32-NEXT:    vsrl.vx v8, v8, a0
; CHECK-RV32-NEXT:    vor.vv v8, v16, v8
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vrol_vx_nxv16i32:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-RV64-NEXT:    vmv.v.x v16, a0
; CHECK-RV64-NEXT:    li a0, 31
; CHECK-RV64-NEXT:    vand.vx v24, v16, a0
; CHECK-RV64-NEXT:    vsll.vv v24, v8, v24
; CHECK-RV64-NEXT:    vrsub.vi v16, v16, 0
; CHECK-RV64-NEXT:    vand.vx v16, v16, a0
; CHECK-RV64-NEXT:    vsrl.vv v8, v8, v16
; CHECK-RV64-NEXT:    vor.vv v8, v24, v8
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv16i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 16 x i32> poison, i32 %b, i32 0
  %b.splat = shufflevector <vscale x 16 x i32> %b.head, <vscale x 16 x i32> poison, <vscale x 16 x i32> zeroinitializer
  %x = call <vscale x 16 x i32> @llvm.fshl.nxv16i32(<vscale x 16 x i32> %a, <vscale x 16 x i32> %a, <vscale x 16 x i32> %b.splat)
  ret <vscale x 16 x i32> %x
}

declare <vscale x 1 x i64> @llvm.fshl.nxv1i64(<vscale x 1 x i64>, <vscale x 1 x i64>, <vscale x 1 x i64>)

define <vscale x 1 x i64> @vrol_vv_nxv1i64(<vscale x 1 x i64> %a, <vscale x 1 x i64> %b) {
; CHECK-LABEL: vrol_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 63
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vand.vx v10, v9, a0
; CHECK-NEXT:    vsll.vv v10, v8, v10
; CHECK-NEXT:    vrsub.vi v9, v9, 0
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vsrl.vv v8, v8, v9
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv1i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v9
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 1 x i64> @llvm.fshl.nxv1i64(<vscale x 1 x i64> %a, <vscale x 1 x i64> %a, <vscale x 1 x i64> %b)
  ret <vscale x 1 x i64> %x
}

define <vscale x 1 x i64> @vrol_vx_nxv1i64(<vscale x 1 x i64> %a, i64 %b) {
; CHECK-RV32-LABEL: vrol_vx_nxv1i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-RV32-NEXT:    vmv.v.x v9, a0
; CHECK-RV32-NEXT:    li a0, 63
; CHECK-RV32-NEXT:    vand.vx v10, v9, a0
; CHECK-RV32-NEXT:    vsll.vv v10, v8, v10
; CHECK-RV32-NEXT:    vrsub.vi v9, v9, 0
; CHECK-RV32-NEXT:    vand.vx v9, v9, a0
; CHECK-RV32-NEXT:    vsrl.vv v8, v8, v9
; CHECK-RV32-NEXT:    vor.vv v8, v10, v8
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vrol_vx_nxv1i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    andi a1, a0, 63
; CHECK-RV64-NEXT:    vsetvli a2, zero, e64, m1, ta, ma
; CHECK-RV64-NEXT:    vsll.vx v9, v8, a1
; CHECK-RV64-NEXT:    negw a0, a0
; CHECK-RV64-NEXT:    andi a0, a0, 63
; CHECK-RV64-NEXT:    vsrl.vx v8, v8, a0
; CHECK-RV64-NEXT:    vor.vv v8, v9, v8
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv1i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %b.splat = shufflevector <vscale x 1 x i64> %b.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %x = call <vscale x 1 x i64> @llvm.fshl.nxv1i64(<vscale x 1 x i64> %a, <vscale x 1 x i64> %a, <vscale x 1 x i64> %b.splat)
  ret <vscale x 1 x i64> %x
}

declare <vscale x 2 x i64> @llvm.fshl.nxv2i64(<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>)

define <vscale x 2 x i64> @vrol_vv_nxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: vrol_vv_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 63
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-NEXT:    vand.vx v12, v10, a0
; CHECK-NEXT:    vsll.vv v12, v8, v12
; CHECK-NEXT:    vrsub.vi v10, v10, 0
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    vsrl.vv v8, v8, v10
; CHECK-NEXT:    vor.vv v8, v12, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv2i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v10
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 2 x i64> @llvm.fshl.nxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %a, <vscale x 2 x i64> %b)
  ret <vscale x 2 x i64> %x
}

define <vscale x 2 x i64> @vrol_vx_nxv2i64(<vscale x 2 x i64> %a, i64 %b) {
; CHECK-RV32-LABEL: vrol_vx_nxv2i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-RV32-NEXT:    vmv.v.x v10, a0
; CHECK-RV32-NEXT:    li a0, 63
; CHECK-RV32-NEXT:    vand.vx v12, v10, a0
; CHECK-RV32-NEXT:    vsll.vv v12, v8, v12
; CHECK-RV32-NEXT:    vrsub.vi v10, v10, 0
; CHECK-RV32-NEXT:    vand.vx v10, v10, a0
; CHECK-RV32-NEXT:    vsrl.vv v8, v8, v10
; CHECK-RV32-NEXT:    vor.vv v8, v12, v8
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vrol_vx_nxv2i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    andi a1, a0, 63
; CHECK-RV64-NEXT:    vsetvli a2, zero, e64, m2, ta, ma
; CHECK-RV64-NEXT:    vsll.vx v10, v8, a1
; CHECK-RV64-NEXT:    negw a0, a0
; CHECK-RV64-NEXT:    andi a0, a0, 63
; CHECK-RV64-NEXT:    vsrl.vx v8, v8, a0
; CHECK-RV64-NEXT:    vor.vv v8, v10, v8
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv2i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 2 x i64> poison, i64 %b, i32 0
  %b.splat = shufflevector <vscale x 2 x i64> %b.head, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %x = call <vscale x 2 x i64> @llvm.fshl.nxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %a, <vscale x 2 x i64> %b.splat)
  ret <vscale x 2 x i64> %x
}

declare <vscale x 4 x i64> @llvm.fshl.nxv4i64(<vscale x 4 x i64>, <vscale x 4 x i64>, <vscale x 4 x i64>)

define <vscale x 4 x i64> @vrol_vv_nxv4i64(<vscale x 4 x i64> %a, <vscale x 4 x i64> %b) {
; CHECK-LABEL: vrol_vv_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 63
; CHECK-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-NEXT:    vand.vx v16, v12, a0
; CHECK-NEXT:    vsll.vv v16, v8, v16
; CHECK-NEXT:    vrsub.vi v12, v12, 0
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vsrl.vv v8, v8, v12
; CHECK-NEXT:    vor.vv v8, v16, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv4i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v12
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 4 x i64> @llvm.fshl.nxv4i64(<vscale x 4 x i64> %a, <vscale x 4 x i64> %a, <vscale x 4 x i64> %b)
  ret <vscale x 4 x i64> %x
}

define <vscale x 4 x i64> @vrol_vx_nxv4i64(<vscale x 4 x i64> %a, i64 %b) {
; CHECK-RV32-LABEL: vrol_vx_nxv4i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-RV32-NEXT:    vmv.v.x v12, a0
; CHECK-RV32-NEXT:    li a0, 63
; CHECK-RV32-NEXT:    vand.vx v16, v12, a0
; CHECK-RV32-NEXT:    vsll.vv v16, v8, v16
; CHECK-RV32-NEXT:    vrsub.vi v12, v12, 0
; CHECK-RV32-NEXT:    vand.vx v12, v12, a0
; CHECK-RV32-NEXT:    vsrl.vv v8, v8, v12
; CHECK-RV32-NEXT:    vor.vv v8, v16, v8
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vrol_vx_nxv4i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    andi a1, a0, 63
; CHECK-RV64-NEXT:    vsetvli a2, zero, e64, m4, ta, ma
; CHECK-RV64-NEXT:    vsll.vx v12, v8, a1
; CHECK-RV64-NEXT:    negw a0, a0
; CHECK-RV64-NEXT:    andi a0, a0, 63
; CHECK-RV64-NEXT:    vsrl.vx v8, v8, a0
; CHECK-RV64-NEXT:    vor.vv v8, v12, v8
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv4i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 4 x i64> poison, i64 %b, i32 0
  %b.splat = shufflevector <vscale x 4 x i64> %b.head, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %x = call <vscale x 4 x i64> @llvm.fshl.nxv4i64(<vscale x 4 x i64> %a, <vscale x 4 x i64> %a, <vscale x 4 x i64> %b.splat)
  ret <vscale x 4 x i64> %x
}

declare <vscale x 8 x i64> @llvm.fshl.nxv8i64(<vscale x 8 x i64>, <vscale x 8 x i64>, <vscale x 8 x i64>)

define <vscale x 8 x i64> @vrol_vv_nxv8i64(<vscale x 8 x i64> %a, <vscale x 8 x i64> %b) {
; CHECK-LABEL: vrol_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 63
; CHECK-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-NEXT:    vand.vx v24, v16, a0
; CHECK-NEXT:    vsll.vv v24, v8, v24
; CHECK-NEXT:    vrsub.vi v16, v16, 0
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    vsrl.vv v8, v8, v16
; CHECK-NEXT:    vor.vv v8, v24, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vv_nxv8i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vv v8, v8, v16
; CHECK-ZVKB-NEXT:    ret
  %x = call <vscale x 8 x i64> @llvm.fshl.nxv8i64(<vscale x 8 x i64> %a, <vscale x 8 x i64> %a, <vscale x 8 x i64> %b)
  ret <vscale x 8 x i64> %x
}

define <vscale x 8 x i64> @vrol_vx_nxv8i64(<vscale x 8 x i64> %a, i64 %b) {
; CHECK-RV32-LABEL: vrol_vx_nxv8i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-RV32-NEXT:    vmv.v.x v16, a0
; CHECK-RV32-NEXT:    li a0, 63
; CHECK-RV32-NEXT:    vand.vx v24, v16, a0
; CHECK-RV32-NEXT:    vsll.vv v24, v8, v24
; CHECK-RV32-NEXT:    vrsub.vi v16, v16, 0
; CHECK-RV32-NEXT:    vand.vx v16, v16, a0
; CHECK-RV32-NEXT:    vsrl.vv v8, v8, v16
; CHECK-RV32-NEXT:    vor.vv v8, v24, v8
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vrol_vx_nxv8i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    andi a1, a0, 63
; CHECK-RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, ma
; CHECK-RV64-NEXT:    vsll.vx v16, v8, a1
; CHECK-RV64-NEXT:    negw a0, a0
; CHECK-RV64-NEXT:    andi a0, a0, 63
; CHECK-RV64-NEXT:    vsrl.vx v8, v8, a0
; CHECK-RV64-NEXT:    vor.vv v8, v16, v8
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vrol_vx_nxv8i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-ZVKB-NEXT:    vrol.vx v8, v8, a0
; CHECK-ZVKB-NEXT:    ret
  %b.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %b.splat = shufflevector <vscale x 8 x i64> %b.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %x = call <vscale x 8 x i64> @llvm.fshl.nxv8i64(<vscale x 8 x i64> %a, <vscale x 8 x i64> %a, <vscale x 8 x i64> %b.splat)
  ret <vscale x 8 x i64> %x
}
