; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -verify-machineinstrs | FileCheck %s

define i8 @not8r(i8 noundef %a) {
; CHECK-LABEL: not8r:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    notb %dil, %al
; CHECK-NEXT:    retq
entry:
  %not = xor i8 %a, -1
  ret i8 %not
}

define i16 @not16r(i16 noundef %a) {
; CHECK-LABEL: not16r:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    notl %edi, %eax
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
entry:
  %not = xor i16 %a, -1
  ret i16 %not
}

define i32 @not32r(i32 noundef %a) {
; CHECK-LABEL: not32r:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    notl %edi, %eax
; CHECK-NEXT:    retq
entry:
  %not = xor i32 %a, -1
  ret i32 %not
}

define i64 @not64r(i64 noundef %a) {
; CHECK-LABEL: not64r:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    notq %rdi, %rax
; CHECK-NEXT:    retq
entry:
  %not = xor i64 %a, -1
  ret i64 %not
}

define i8 @not8m(ptr %ptr) {
; CHECK-LABEL: not8m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    notb (%rdi), %al
; CHECK-NEXT:    retq
entry:
  %a = load i8, ptr %ptr
  %not = xor i8 %a, -1
  ret i8 %not
}

define i16 @not16m(ptr %ptr) {
; CHECK-LABEL: not16m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movzwl (%rdi), %eax
; CHECK-NEXT:    notl %eax
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
entry:
  %a = load i16, ptr %ptr
  %not = xor i16 %a, -1
  ret i16 %not
}

define i32 @not32m(ptr %ptr) {
; CHECK-LABEL: not32m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    notl (%rdi), %eax
; CHECK-NEXT:    retq
entry:
  %a = load i32, ptr %ptr
  %not = xor i32 %a, -1
  ret i32 %not
}

define i64 @not64m(ptr %ptr) {
; CHECK-LABEL: not64m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    notq (%rdi), %rax
; CHECK-NEXT:    retq
entry:
  %a = load i64, ptr %ptr
  %not = xor i64 %a, -1
  ret i64 %not
}

define void @not8m_legacy(ptr %ptr) {
; CHECK-LABEL: not8m_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    notb (%rdi)
; CHECK-NEXT:    retq
entry:
  %a = load i8, ptr %ptr
  %not = xor i8 %a, -1
  store i8 %not, ptr %ptr
  ret void
}

define void @not16m_legacy(ptr %ptr) {
; CHECK-LABEL: not16m_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    notw (%rdi)
; CHECK-NEXT:    retq
entry:
  %a = load i16, ptr %ptr
  %not = xor i16 %a, -1
  store i16 %not, ptr %ptr
  ret void
}

define void @not32m_legacy(ptr %ptr) {
; CHECK-LABEL: not32m_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    notl (%rdi)
; CHECK-NEXT:    retq
entry:
  %a = load i32, ptr %ptr
  %not = xor i32 %a, -1
  store i32 %not, ptr %ptr
  ret void
}

define void @not64m_legacy(ptr %ptr) {
; CHECK-LABEL: not64m_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    notq (%rdi)
; CHECK-NEXT:    retq
entry:
  %a = load i64, ptr %ptr
  %not = xor i64 %a, -1
  store i64 %not, ptr %ptr
  ret void
}
