; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin10 -verify-machineinstrs                                                   | FileCheck %s --check-prefix=SDAG-X64
; RUN: llc < %s -mtriple=x86_64-apple-darwin10 -verify-machineinstrs -mattr=+avx512f                                   | FileCheck %s --check-prefix=SDAG-X64
; RUN: llc < %s -fast-isel -fast-isel-abort=1 -mtriple=x86_64-apple-darwin10 -verify-machineinstrs                     | FileCheck %s --check-prefix=FAST-X64
; RUN: llc < %s -fast-isel -fast-isel-abort=1 -mtriple=x86_64-apple-darwin10 -verify-machineinstrs -mattr=+avx512f     | FileCheck %s --check-prefix=FAST-X64
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=x86_64-apple-darwin10 -verify-machineinstrs                 | FileCheck %s --check-prefix=GISEL-X64
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=x86_64-apple-darwin10 -verify-machineinstrs -mattr=+avx512f | FileCheck %s --check-prefix=GISEL-X64

; RUN: llc < %s -mtriple=i686-apple-darwin10 -verify-machineinstrs                                                | FileCheck %s --check-prefix=SDAG-X86
; RUN: llc < %s -mtriple=i686-apple-darwin10 -verify-machineinstrs -mattr=+cmov                                   | FileCheck %s --check-prefix=SDAG-X86-CMOV
; RUN: llc < %s -fast-isel -fast-isel-abort=1 -mtriple=i686-apple-darwin10 -verify-machineinstrs                  | FileCheck %s --check-prefix=FAST-X86
; RUN: llc < %s -fast-isel -fast-isel-abort=1 -mtriple=i686-apple-darwin10 -verify-machineinstrs -mattr=+cmov     | FileCheck %s --check-prefix=FAST-X86-CMOV
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=i686-apple-darwin10 -verify-machineinstrs              | FileCheck %s --check-prefix=GISEL-X86
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=i686-apple-darwin10 -verify-machineinstrs -mattr=+cmov | FileCheck %s --check-prefix=GISEL-X86-CMOV

; Test conditional move for the supported types (i16, i32, and i32) and
; conditon input (argument or cmp).
; When cmov is not available (i8 type or X86), the branch is expected.

define zeroext i8 @select_cmov_i8(i1 zeroext %cond, i8 zeroext %a, i8 zeroext %b) {
; SDAG-X64-LABEL: select_cmov_i8:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    movl %esi, %eax
; SDAG-X64-NEXT:    testl %edi, %edi
; SDAG-X64-NEXT:    cmovel %edx, %eax
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: select_cmov_i8:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    testb $1, %dil
; FAST-X64-NEXT:    jne LBB0_2
; FAST-X64-NEXT:  ## %bb.1:
; FAST-X64-NEXT:    movl %edx, %esi
; FAST-X64-NEXT:  LBB0_2:
; FAST-X64-NEXT:    movzbl %sil, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: select_cmov_i8:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movl %edx, %eax
; GISEL-X64-NEXT:    testl %edi, %edi
; GISEL-X64-NEXT:    cmovnew %si, %ax
; GISEL-X64-NEXT:    ## kill: def $al killed $al killed $eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: select_cmov_i8:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    cmpb $0, {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    jne LBB0_1
; SDAG-X86-NEXT:  ## %bb.2:
; SDAG-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    movzbl (%eax), %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB0_1:
; SDAG-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    movzbl (%eax), %eax
; SDAG-X86-NEXT:    retl
;
; SDAG-X86-CMOV-LABEL: select_cmov_i8:
; SDAG-X86-CMOV:       ## %bb.0:
; SDAG-X86-CMOV-NEXT:    cmpb $0, {{[0-9]+}}(%esp)
; SDAG-X86-CMOV-NEXT:    leal {{[0-9]+}}(%esp), %eax
; SDAG-X86-CMOV-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; SDAG-X86-CMOV-NEXT:    cmovnel %eax, %ecx
; SDAG-X86-CMOV-NEXT:    movzbl (%ecx), %eax
; SDAG-X86-CMOV-NEXT:    retl
;
; FAST-X86-LABEL: select_cmov_i8:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    testb $1, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    jne LBB0_1
; FAST-X86-NEXT:  ## %bb.2:
; FAST-X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
; FAST-X86-NEXT:  LBB0_1:
; FAST-X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; FAST-X86-CMOV-LABEL: select_cmov_i8:
; FAST-X86-CMOV:       ## %bb.0:
; FAST-X86-CMOV-NEXT:    testb $1, {{[0-9]+}}(%esp)
; FAST-X86-CMOV-NEXT:    jne LBB0_1
; FAST-X86-CMOV-NEXT:  ## %bb.2:
; FAST-X86-CMOV-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; FAST-X86-CMOV-NEXT:    movzbl %al, %eax
; FAST-X86-CMOV-NEXT:    retl
; FAST-X86-CMOV-NEXT:  LBB0_1:
; FAST-X86-CMOV-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; FAST-X86-CMOV-NEXT:    movzbl %al, %eax
; FAST-X86-CMOV-NEXT:    retl
;
; GISEL-X86-LABEL: select_cmov_i8:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    testl %eax, %eax
; GISEL-X86-NEXT:    je LBB0_1
; GISEL-X86-NEXT:  ## %bb.2:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    ## kill: def $al killed $al killed $eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB0_1:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    ## kill: def $al killed $al killed $eax
; GISEL-X86-NEXT:    retl
;
; GISEL-X86-CMOV-LABEL: select_cmov_i8:
; GISEL-X86-CMOV:       ## %bb.0:
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-CMOV-NEXT:    testl %ecx, %ecx
; GISEL-X86-CMOV-NEXT:    cmovnew %dx, %ax
; GISEL-X86-CMOV-NEXT:    ## kill: def $al killed $al killed $eax
; GISEL-X86-CMOV-NEXT:    retl
  %1 = select i1 %cond, i8 %a, i8 %b
  ret i8 %1
}

define zeroext i16 @select_cmov_i16(i1 zeroext %cond, i16 zeroext %a, i16 zeroext %b) {
; SDAG-X64-LABEL: select_cmov_i16:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    movl %esi, %eax
; SDAG-X64-NEXT:    testl %edi, %edi
; SDAG-X64-NEXT:    cmovel %edx, %eax
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: select_cmov_i16:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    testb $1, %dil
; FAST-X64-NEXT:    cmovew %dx, %si
; FAST-X64-NEXT:    movzwl %si, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: select_cmov_i16:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movl %edx, %eax
; GISEL-X64-NEXT:    testl %edi, %edi
; GISEL-X64-NEXT:    cmovnew %si, %ax
; GISEL-X64-NEXT:    ## kill: def $ax killed $ax killed $eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: select_cmov_i16:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    cmpb $0, {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    jne LBB1_1
; SDAG-X86-NEXT:  ## %bb.2:
; SDAG-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    movzwl (%eax), %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB1_1:
; SDAG-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    movzwl (%eax), %eax
; SDAG-X86-NEXT:    retl
;
; SDAG-X86-CMOV-LABEL: select_cmov_i16:
; SDAG-X86-CMOV:       ## %bb.0:
; SDAG-X86-CMOV-NEXT:    cmpb $0, {{[0-9]+}}(%esp)
; SDAG-X86-CMOV-NEXT:    leal {{[0-9]+}}(%esp), %eax
; SDAG-X86-CMOV-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; SDAG-X86-CMOV-NEXT:    cmovnel %eax, %ecx
; SDAG-X86-CMOV-NEXT:    movzwl (%ecx), %eax
; SDAG-X86-CMOV-NEXT:    retl
;
; FAST-X86-LABEL: select_cmov_i16:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    testb $1, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    jne LBB1_1
; FAST-X86-NEXT:  ## %bb.2:
; FAST-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    movzwl %ax, %eax
; FAST-X86-NEXT:    retl
; FAST-X86-NEXT:  LBB1_1:
; FAST-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    movzwl %ax, %eax
; FAST-X86-NEXT:    retl
;
; FAST-X86-CMOV-LABEL: select_cmov_i16:
; FAST-X86-CMOV:       ## %bb.0:
; FAST-X86-CMOV-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; FAST-X86-CMOV-NEXT:    testb $1, {{[0-9]+}}(%esp)
; FAST-X86-CMOV-NEXT:    cmovew {{[0-9]+}}(%esp), %ax
; FAST-X86-CMOV-NEXT:    movzwl %ax, %eax
; FAST-X86-CMOV-NEXT:    retl
;
; GISEL-X86-LABEL: select_cmov_i16:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    testl %eax, %eax
; GISEL-X86-NEXT:    je LBB1_1
; GISEL-X86-NEXT:  ## %bb.2:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    ## kill: def $ax killed $ax killed $eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB1_1:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    ## kill: def $ax killed $ax killed $eax
; GISEL-X86-NEXT:    retl
;
; GISEL-X86-CMOV-LABEL: select_cmov_i16:
; GISEL-X86-CMOV:       ## %bb.0:
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-CMOV-NEXT:    testl %ecx, %ecx
; GISEL-X86-CMOV-NEXT:    cmovnew %dx, %ax
; GISEL-X86-CMOV-NEXT:    ## kill: def $ax killed $ax killed $eax
; GISEL-X86-CMOV-NEXT:    retl
  %1 = select i1 %cond, i16 %a, i16 %b
  ret i16 %1
}

define zeroext i16 @select_cmp_cmov_i16(i16 zeroext %a, i16 zeroext %b) {
; SDAG-X64-LABEL: select_cmp_cmov_i16:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    movl %esi, %eax
; SDAG-X64-NEXT:    cmpw %ax, %di
; SDAG-X64-NEXT:    cmovbl %edi, %eax
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: select_cmp_cmov_i16:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpw %si, %di
; FAST-X64-NEXT:    cmovbw %di, %si
; FAST-X64-NEXT:    movzwl %si, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: select_cmp_cmov_i16:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movl %edi, %eax
; GISEL-X64-NEXT:    xorl %ecx, %ecx
; GISEL-X64-NEXT:    cmpw %si, %ax
; GISEL-X64-NEXT:    setb %cl
; GISEL-X64-NEXT:    andl $1, %ecx
; GISEL-X64-NEXT:    cmovew %si, %ax
; GISEL-X64-NEXT:    ## kill: def $ax killed $ax killed $eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: select_cmp_cmov_i16:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    cmpw %cx, %ax
; SDAG-X86-NEXT:    jb LBB2_2
; SDAG-X86-NEXT:  ## %bb.1:
; SDAG-X86-NEXT:    movl %ecx, %eax
; SDAG-X86-NEXT:  LBB2_2:
; SDAG-X86-NEXT:    movzwl %ax, %eax
; SDAG-X86-NEXT:    retl
;
; SDAG-X86-CMOV-LABEL: select_cmp_cmov_i16:
; SDAG-X86-CMOV:       ## %bb.0:
; SDAG-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-CMOV-NEXT:    cmpw %ax, %cx
; SDAG-X86-CMOV-NEXT:    cmovbl %ecx, %eax
; SDAG-X86-CMOV-NEXT:    movzwl %ax, %eax
; SDAG-X86-CMOV-NEXT:    retl
;
; FAST-X86-LABEL: select_cmp_cmov_i16:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; FAST-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpw %cx, %ax
; FAST-X86-NEXT:    jb LBB2_2
; FAST-X86-NEXT:  ## %bb.1:
; FAST-X86-NEXT:    movl %ecx, %eax
; FAST-X86-NEXT:  LBB2_2:
; FAST-X86-NEXT:    movzwl %ax, %eax
; FAST-X86-NEXT:    retl
;
; FAST-X86-CMOV-LABEL: select_cmp_cmov_i16:
; FAST-X86-CMOV:       ## %bb.0:
; FAST-X86-CMOV-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; FAST-X86-CMOV-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; FAST-X86-CMOV-NEXT:    cmpw %ax, %cx
; FAST-X86-CMOV-NEXT:    cmovbw %cx, %ax
; FAST-X86-CMOV-NEXT:    movzwl %ax, %eax
; FAST-X86-CMOV-NEXT:    retl
;
; GISEL-X86-LABEL: select_cmp_cmov_i16:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    xorl %edx, %edx
; GISEL-X86-NEXT:    cmpw %ax, %cx
; GISEL-X86-NEXT:    setb %dl
; GISEL-X86-NEXT:    andl $1, %edx
; GISEL-X86-NEXT:    je LBB2_2
; GISEL-X86-NEXT:  ## %bb.1:
; GISEL-X86-NEXT:    movl %ecx, %eax
; GISEL-X86-NEXT:  LBB2_2:
; GISEL-X86-NEXT:    ## kill: def $ax killed $ax killed $eax
; GISEL-X86-NEXT:    retl
;
; GISEL-X86-CMOV-LABEL: select_cmp_cmov_i16:
; GISEL-X86-CMOV:       ## %bb.0:
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-CMOV-NEXT:    xorl %edx, %edx
; GISEL-X86-CMOV-NEXT:    cmpw %cx, %ax
; GISEL-X86-CMOV-NEXT:    setb %dl
; GISEL-X86-CMOV-NEXT:    andl $1, %edx
; GISEL-X86-CMOV-NEXT:    cmovew %cx, %ax
; GISEL-X86-CMOV-NEXT:    ## kill: def $ax killed $ax killed $eax
; GISEL-X86-CMOV-NEXT:    retl
  %1 = icmp ult i16 %a, %b
  %2 = select i1 %1, i16 %a, i16 %b
  ret i16 %2
}

define i32 @select_cmov_i32(i1 zeroext %cond, i32 %a, i32 %b) {
; SDAG-X64-LABEL: select_cmov_i32:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    movl %esi, %eax
; SDAG-X64-NEXT:    testl %edi, %edi
; SDAG-X64-NEXT:    cmovel %edx, %eax
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: select_cmov_i32:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    movl %esi, %eax
; FAST-X64-NEXT:    testb $1, %dil
; FAST-X64-NEXT:    cmovel %edx, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: select_cmov_i32:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movl %edx, %eax
; GISEL-X64-NEXT:    testl %edi, %edi
; GISEL-X64-NEXT:    cmovnel %esi, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: select_cmov_i32:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    cmpb $0, {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    jne LBB3_1
; SDAG-X86-NEXT:  ## %bb.2:
; SDAG-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    movl (%eax), %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB3_1:
; SDAG-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    movl (%eax), %eax
; SDAG-X86-NEXT:    retl
;
; SDAG-X86-CMOV-LABEL: select_cmov_i32:
; SDAG-X86-CMOV:       ## %bb.0:
; SDAG-X86-CMOV-NEXT:    cmpb $0, {{[0-9]+}}(%esp)
; SDAG-X86-CMOV-NEXT:    leal {{[0-9]+}}(%esp), %eax
; SDAG-X86-CMOV-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; SDAG-X86-CMOV-NEXT:    cmovnel %eax, %ecx
; SDAG-X86-CMOV-NEXT:    movl (%ecx), %eax
; SDAG-X86-CMOV-NEXT:    retl
;
; FAST-X86-LABEL: select_cmov_i32:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    testb $1, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    jne LBB3_1
; FAST-X86-NEXT:  ## %bb.2:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    retl
; FAST-X86-NEXT:  LBB3_1:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    retl
;
; FAST-X86-CMOV-LABEL: select_cmov_i32:
; FAST-X86-CMOV:       ## %bb.0:
; FAST-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-CMOV-NEXT:    testb $1, {{[0-9]+}}(%esp)
; FAST-X86-CMOV-NEXT:    cmovel {{[0-9]+}}(%esp), %eax
; FAST-X86-CMOV-NEXT:    retl
;
; GISEL-X86-LABEL: select_cmov_i32:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    testl %eax, %eax
; GISEL-X86-NEXT:    je LBB3_1
; GISEL-X86-NEXT:  ## %bb.2:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB3_1:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    retl
;
; GISEL-X86-CMOV-LABEL: select_cmov_i32:
; GISEL-X86-CMOV:       ## %bb.0:
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-CMOV-NEXT:    testl %ecx, %ecx
; GISEL-X86-CMOV-NEXT:    cmovnel {{[0-9]+}}(%esp), %eax
; GISEL-X86-CMOV-NEXT:    retl
  %1 = select i1 %cond, i32 %a, i32 %b
  ret i32 %1
}

define i32 @select_cmp_cmov_i32(i32 %a, i32 %b) {
; SDAG-X64-LABEL: select_cmp_cmov_i32:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    movl %esi, %eax
; SDAG-X64-NEXT:    cmpl %esi, %edi
; SDAG-X64-NEXT:    cmovbl %edi, %eax
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: select_cmp_cmov_i32:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    movl %esi, %eax
; FAST-X64-NEXT:    cmpl %esi, %edi
; FAST-X64-NEXT:    cmovbl %edi, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: select_cmp_cmov_i32:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movl %edi, %eax
; GISEL-X64-NEXT:    xorl %ecx, %ecx
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setb %cl
; GISEL-X64-NEXT:    andl $1, %ecx
; GISEL-X64-NEXT:    cmovel %esi, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: select_cmp_cmov_i32:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    cmpl %ecx, %eax
; SDAG-X86-NEXT:    jb LBB4_2
; SDAG-X86-NEXT:  ## %bb.1:
; SDAG-X86-NEXT:    movl %ecx, %eax
; SDAG-X86-NEXT:  LBB4_2:
; SDAG-X86-NEXT:    retl
;
; SDAG-X86-CMOV-LABEL: select_cmp_cmov_i32:
; SDAG-X86-CMOV:       ## %bb.0:
; SDAG-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-CMOV-NEXT:    cmpl %eax, %ecx
; SDAG-X86-CMOV-NEXT:    cmovbl %ecx, %eax
; SDAG-X86-CMOV-NEXT:    retl
;
; FAST-X86-LABEL: select_cmp_cmov_i32:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpl %ecx, %eax
; FAST-X86-NEXT:    jb LBB4_2
; FAST-X86-NEXT:  ## %bb.1:
; FAST-X86-NEXT:    movl %ecx, %eax
; FAST-X86-NEXT:  LBB4_2:
; FAST-X86-NEXT:    retl
;
; FAST-X86-CMOV-LABEL: select_cmp_cmov_i32:
; FAST-X86-CMOV:       ## %bb.0:
; FAST-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; FAST-X86-CMOV-NEXT:    cmpl %eax, %ecx
; FAST-X86-CMOV-NEXT:    cmovbl %ecx, %eax
; FAST-X86-CMOV-NEXT:    retl
;
; GISEL-X86-LABEL: select_cmp_cmov_i32:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    xorl %edx, %edx
; GISEL-X86-NEXT:    cmpl %eax, %ecx
; GISEL-X86-NEXT:    setb %dl
; GISEL-X86-NEXT:    andl $1, %edx
; GISEL-X86-NEXT:    je LBB4_2
; GISEL-X86-NEXT:  ## %bb.1:
; GISEL-X86-NEXT:    movl %ecx, %eax
; GISEL-X86-NEXT:  LBB4_2:
; GISEL-X86-NEXT:    retl
;
; GISEL-X86-CMOV-LABEL: select_cmp_cmov_i32:
; GISEL-X86-CMOV:       ## %bb.0:
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-CMOV-NEXT:    xorl %edx, %edx
; GISEL-X86-CMOV-NEXT:    cmpl %ecx, %eax
; GISEL-X86-CMOV-NEXT:    setb %dl
; GISEL-X86-CMOV-NEXT:    andl $1, %edx
; GISEL-X86-CMOV-NEXT:    cmovel %ecx, %eax
; GISEL-X86-CMOV-NEXT:    retl
  %1 = icmp ult i32 %a, %b
  %2 = select i1 %1, i32 %a, i32 %b
  ret i32 %2
}

define i64 @select_cmov_i64(i1 zeroext %cond, i64 %a, i64 %b) {
; SDAG-X64-LABEL: select_cmov_i64:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    movq %rsi, %rax
; SDAG-X64-NEXT:    testl %edi, %edi
; SDAG-X64-NEXT:    cmoveq %rdx, %rax
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: select_cmov_i64:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    movq %rsi, %rax
; FAST-X64-NEXT:    testb $1, %dil
; FAST-X64-NEXT:    cmoveq %rdx, %rax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: select_cmov_i64:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movq %rdx, %rax
; GISEL-X64-NEXT:    testl %edi, %edi
; GISEL-X64-NEXT:    cmovneq %rsi, %rax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: select_cmov_i64:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    cmpb $0, {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    jne LBB5_1
; SDAG-X86-NEXT:  ## %bb.2:
; SDAG-X86-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    jmp LBB5_3
; SDAG-X86-NEXT:  LBB5_1:
; SDAG-X86-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:  LBB5_3:
; SDAG-X86-NEXT:    movl (%ecx), %eax
; SDAG-X86-NEXT:    movl 4(%ecx), %edx
; SDAG-X86-NEXT:    retl
;
; SDAG-X86-CMOV-LABEL: select_cmov_i64:
; SDAG-X86-CMOV:       ## %bb.0:
; SDAG-X86-CMOV-NEXT:    cmpb $0, {{[0-9]+}}(%esp)
; SDAG-X86-CMOV-NEXT:    leal {{[0-9]+}}(%esp), %eax
; SDAG-X86-CMOV-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; SDAG-X86-CMOV-NEXT:    cmovnel %eax, %ecx
; SDAG-X86-CMOV-NEXT:    movl (%ecx), %eax
; SDAG-X86-CMOV-NEXT:    movl 4(%ecx), %edx
; SDAG-X86-CMOV-NEXT:    retl
;
; FAST-X86-LABEL: select_cmov_i64:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    cmpb $0, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    jne LBB5_1
; FAST-X86-NEXT:  ## %bb.2:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    retl
; FAST-X86-NEXT:  LBB5_1:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    retl
;
; FAST-X86-CMOV-LABEL: select_cmov_i64:
; FAST-X86-CMOV:       ## %bb.0:
; FAST-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %edx
; FAST-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-CMOV-NEXT:    cmpb $0, {{[0-9]+}}(%esp)
; FAST-X86-CMOV-NEXT:    cmovel {{[0-9]+}}(%esp), %eax
; FAST-X86-CMOV-NEXT:    cmovel {{[0-9]+}}(%esp), %edx
; FAST-X86-CMOV-NEXT:    retl
;
; GISEL-X86-LABEL: select_cmov_i64:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    testl %ecx, %ecx
; GISEL-X86-NEXT:    je LBB5_1
; GISEL-X86-NEXT:  ## %bb.2:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    testl %ecx, %ecx
; GISEL-X86-NEXT:    jne LBB5_5
; GISEL-X86-NEXT:  LBB5_4:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB5_1:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    testl %ecx, %ecx
; GISEL-X86-NEXT:    je LBB5_4
; GISEL-X86-NEXT:  LBB5_5:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    retl
;
; GISEL-X86-CMOV-LABEL: select_cmov_i64:
; GISEL-X86-CMOV:       ## %bb.0:
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-CMOV-NEXT:    testl %ecx, %ecx
; GISEL-X86-CMOV-NEXT:    cmovnel {{[0-9]+}}(%esp), %eax
; GISEL-X86-CMOV-NEXT:    cmovnel {{[0-9]+}}(%esp), %edx
; GISEL-X86-CMOV-NEXT:    retl
  %1 = select i1 %cond, i64 %a, i64 %b
  ret i64 %1
}

define i64 @select_cmp_cmov_i64(i64 %a, i64 %b) nounwind {
; SDAG-X64-LABEL: select_cmp_cmov_i64:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    movq %rsi, %rax
; SDAG-X64-NEXT:    cmpq %rsi, %rdi
; SDAG-X64-NEXT:    cmovbq %rdi, %rax
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: select_cmp_cmov_i64:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    movq %rsi, %rax
; FAST-X64-NEXT:    cmpq %rsi, %rdi
; FAST-X64-NEXT:    cmovbq %rdi, %rax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: select_cmp_cmov_i64:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movq %rdi, %rax
; GISEL-X64-NEXT:    xorl %ecx, %ecx
; GISEL-X64-NEXT:    cmpq %rsi, %rdi
; GISEL-X64-NEXT:    setb %cl
; GISEL-X64-NEXT:    andl $1, %ecx
; GISEL-X64-NEXT:    cmoveq %rsi, %rax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: select_cmp_cmov_i64:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    pushl %edi
; SDAG-X86-NEXT:    pushl %esi
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SDAG-X86-NEXT:    cmpl %ecx, %eax
; SDAG-X86-NEXT:    movl %edx, %edi
; SDAG-X86-NEXT:    sbbl %esi, %edi
; SDAG-X86-NEXT:    jb LBB6_2
; SDAG-X86-NEXT:  ## %bb.1:
; SDAG-X86-NEXT:    movl %ecx, %eax
; SDAG-X86-NEXT:    movl %esi, %edx
; SDAG-X86-NEXT:  LBB6_2:
; SDAG-X86-NEXT:    popl %esi
; SDAG-X86-NEXT:    popl %edi
; SDAG-X86-NEXT:    retl
;
; SDAG-X86-CMOV-LABEL: select_cmp_cmov_i64:
; SDAG-X86-CMOV:       ## %bb.0:
; SDAG-X86-CMOV-NEXT:    pushl %edi
; SDAG-X86-CMOV-NEXT:    pushl %esi
; SDAG-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SDAG-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SDAG-X86-CMOV-NEXT:    cmpl %eax, %ecx
; SDAG-X86-CMOV-NEXT:    movl %esi, %edi
; SDAG-X86-CMOV-NEXT:    sbbl %edx, %edi
; SDAG-X86-CMOV-NEXT:    cmovbl %ecx, %eax
; SDAG-X86-CMOV-NEXT:    cmovbl %esi, %edx
; SDAG-X86-CMOV-NEXT:    popl %esi
; SDAG-X86-CMOV-NEXT:    popl %edi
; SDAG-X86-CMOV-NEXT:    retl
;
; FAST-X86-LABEL: select_cmp_cmov_i64:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    pushl %edi
; FAST-X86-NEXT:    pushl %esi
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpl %esi, %eax
; FAST-X86-NEXT:    movl %edx, %edi
; FAST-X86-NEXT:    sbbl %ecx, %edi
; FAST-X86-NEXT:    jb LBB6_2
; FAST-X86-NEXT:  ## %bb.1:
; FAST-X86-NEXT:    movl %esi, %eax
; FAST-X86-NEXT:    movl %ecx, %edx
; FAST-X86-NEXT:  LBB6_2:
; FAST-X86-NEXT:    popl %esi
; FAST-X86-NEXT:    popl %edi
; FAST-X86-NEXT:    retl
;
; FAST-X86-CMOV-LABEL: select_cmp_cmov_i64:
; FAST-X86-CMOV:       ## %bb.0:
; FAST-X86-CMOV-NEXT:    pushl %edi
; FAST-X86-CMOV-NEXT:    pushl %esi
; FAST-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %edx
; FAST-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; FAST-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %esi
; FAST-X86-CMOV-NEXT:    cmpl %eax, %esi
; FAST-X86-CMOV-NEXT:    movl %ecx, %edi
; FAST-X86-CMOV-NEXT:    sbbl %edx, %edi
; FAST-X86-CMOV-NEXT:    cmovbl %esi, %eax
; FAST-X86-CMOV-NEXT:    cmovbl %ecx, %edx
; FAST-X86-CMOV-NEXT:    popl %esi
; FAST-X86-CMOV-NEXT:    popl %edi
; FAST-X86-CMOV-NEXT:    retl
;
; GISEL-X86-LABEL: select_cmp_cmov_i64:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    pushl %ebp
; GISEL-X86-NEXT:    pushl %ebx
; GISEL-X86-NEXT:    pushl %edi
; GISEL-X86-NEXT:    pushl %esi
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    xorl %ecx, %ecx
; GISEL-X86-NEXT:    cmpl %edx, %ebp
; GISEL-X86-NEXT:    setb %bl
; GISEL-X86-NEXT:    sete %cl
; GISEL-X86-NEXT:    cmpl %eax, %esi
; GISEL-X86-NEXT:    setb %bh
; GISEL-X86-NEXT:    testl %ecx, %ecx
; GISEL-X86-NEXT:    je LBB6_2
; GISEL-X86-NEXT:  ## %bb.1:
; GISEL-X86-NEXT:    movb %bh, %bl
; GISEL-X86-NEXT:  LBB6_2:
; GISEL-X86-NEXT:    movzbl %bl, %edi
; GISEL-X86-NEXT:    andl $1, %edi
; GISEL-X86-NEXT:    je LBB6_4
; GISEL-X86-NEXT:  ## %bb.3:
; GISEL-X86-NEXT:    movl %esi, %eax
; GISEL-X86-NEXT:  LBB6_4:
; GISEL-X86-NEXT:    testl %edi, %edi
; GISEL-X86-NEXT:    je LBB6_6
; GISEL-X86-NEXT:  ## %bb.5:
; GISEL-X86-NEXT:    movl %ebp, %edx
; GISEL-X86-NEXT:  LBB6_6:
; GISEL-X86-NEXT:    popl %esi
; GISEL-X86-NEXT:    popl %edi
; GISEL-X86-NEXT:    popl %ebx
; GISEL-X86-NEXT:    popl %ebp
; GISEL-X86-NEXT:    retl
;
; GISEL-X86-CMOV-LABEL: select_cmp_cmov_i64:
; GISEL-X86-CMOV:       ## %bb.0:
; GISEL-X86-CMOV-NEXT:    pushl %ebp
; GISEL-X86-CMOV-NEXT:    pushl %ebx
; GISEL-X86-CMOV-NEXT:    pushl %edi
; GISEL-X86-CMOV-NEXT:    pushl %esi
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %esi
; GISEL-X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %edi
; GISEL-X86-CMOV-NEXT:    xorl %ebx, %ebx
; GISEL-X86-CMOV-NEXT:    xorl %ecx, %ecx
; GISEL-X86-CMOV-NEXT:    cmpl %edi, %edx
; GISEL-X86-CMOV-NEXT:    setb %bl
; GISEL-X86-CMOV-NEXT:    sete %cl
; GISEL-X86-CMOV-NEXT:    xorl %eax, %eax
; GISEL-X86-CMOV-NEXT:    cmpl %esi, %ebp
; GISEL-X86-CMOV-NEXT:    setb %al
; GISEL-X86-CMOV-NEXT:    testl %ecx, %ecx
; GISEL-X86-CMOV-NEXT:    cmovnew %ax, %bx
; GISEL-X86-CMOV-NEXT:    andl $1, %ebx
; GISEL-X86-CMOV-NEXT:    cmovel %esi, %ebp
; GISEL-X86-CMOV-NEXT:    cmovel %edi, %edx
; GISEL-X86-CMOV-NEXT:    movl %ebp, %eax
; GISEL-X86-CMOV-NEXT:    popl %esi
; GISEL-X86-CMOV-NEXT:    popl %edi
; GISEL-X86-CMOV-NEXT:    popl %ebx
; GISEL-X86-CMOV-NEXT:    popl %ebp
; GISEL-X86-CMOV-NEXT:    retl
  %1 = icmp ult i64 %a, %b
  %2 = select i1 %1, i64 %a, i64 %b
  ret i64 %2
}

