// RUN: llvm-mc -triple=amdgcn -show-encoding -mcpu=gfx1100 %s | FileCheck --check-prefix=GFX11 %s

s_mov_b32 s0, s1
// GFX11: encoding: [0x01,0x00,0x80,0xbe]

s_mov_b32 s105, s104
// GFX11: encoding: [0x68,0x00,0xe9,0xbe]

s_mov_b32 s0, s104
// GFX11: encoding: [0x68,0x00,0x80,0xbe]

s_mov_b32 s105, s1
// GFX11: encoding: [0x01,0x00,0xe9,0xbe]

s_mov_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x00,0xfe,0xbe]

s_mov_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x00,0xff,0xbe]

s_mov_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x00,0xea,0xbe]

s_mov_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x00,0xeb,0xbe]

s_mov_b32 m0, s1
// GFX11: encoding: [0x01,0x00,0xfd,0xbe]

s_mov_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x00,0x80,0xbe]

s_mov_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x00,0x80,0xbe]

s_mov_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x00,0x80,0xbe]

s_mov_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x00,0x80,0xbe]

s_mov_b32 s0, m0
// GFX11: encoding: [0x7d,0x00,0x80,0xbe]

s_mov_b32 s0, 0
// GFX11: encoding: [0x80,0x00,0x80,0xbe]

s_mov_b32 s0, -1
// GFX11: encoding: [0xc1,0x00,0x80,0xbe]

s_mov_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x00,0x80,0xbe]

s_mov_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x00,0x80,0xbe]

s_mov_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x00,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_mov_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x00,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_mov_b32 s0, null
// GFX11: encoding: [0x7c,0x00,0x80,0xbe]

s_mov_b32 null, s1
// GFX11: encoding: [0x01,0x00,0xfc,0xbe]

s_mov_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x01,0x80,0xbe]

s_mov_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x01,0xe8,0xbe]

s_mov_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x01,0x80,0xbe]

s_mov_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x01,0xe8,0xbe]

s_mov_b64 exec, s[2:3]
// GFX11: encoding: [0x02,0x01,0xfe,0xbe]

s_mov_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x01,0xea,0xbe]

s_mov_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x01,0x80,0xbe]

s_mov_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x01,0x80,0xbe]

s_mov_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x01,0x80,0xbe]

s_mov_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x01,0x80,0xbe]

s_mov_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x01,0x80,0xbe]

s_mov_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x01,0x80,0xbe]

s_mov_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x01,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_mov_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x01,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_mov_b64 s[0:1], null
// GFX11: encoding: [0x7c,0x01,0x80,0xbe]

s_mov_b64 null, s[2:3]
// GFX11: encoding: [0x02,0x01,0xfc,0xbe]

s_cmov_b32 s0, s1
// GFX11: encoding: [0x01,0x02,0x80,0xbe]

s_cmov_b32 s105, s104
// GFX11: encoding: [0x68,0x02,0xe9,0xbe]

s_cmov_b32 s0, s104
// GFX11: encoding: [0x68,0x02,0x80,0xbe]

s_cmov_b32 s105, s1
// GFX11: encoding: [0x01,0x02,0xe9,0xbe]

s_cmov_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x02,0xfe,0xbe]

s_cmov_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x02,0xff,0xbe]

s_cmov_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x02,0xea,0xbe]

s_cmov_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x02,0xeb,0xbe]

s_cmov_b32 m0, s1
// GFX11: encoding: [0x01,0x02,0xfd,0xbe]

s_cmov_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x02,0x80,0xbe]

s_cmov_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x02,0x80,0xbe]

s_cmov_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x02,0x80,0xbe]

s_cmov_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x02,0x80,0xbe]

s_cmov_b32 s0, m0
// GFX11: encoding: [0x7d,0x02,0x80,0xbe]

s_cmov_b32 s0, 0
// GFX11: encoding: [0x80,0x02,0x80,0xbe]

s_cmov_b32 s0, -1
// GFX11: encoding: [0xc1,0x02,0x80,0xbe]

s_cmov_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x02,0x80,0xbe]

s_cmov_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x02,0x80,0xbe]

s_cmov_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x02,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_cmov_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x02,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_cmov_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x03,0x80,0xbe]

s_cmov_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x03,0xe8,0xbe]

s_cmov_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x03,0x80,0xbe]

s_cmov_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x03,0xe8,0xbe]

s_cmov_b64 exec, s[2:3]
// GFX11: encoding: [0x02,0x03,0xfe,0xbe]

s_cmov_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x03,0xea,0xbe]

s_cmov_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x03,0x80,0xbe]

s_cmov_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x03,0x80,0xbe]

s_cmov_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x03,0x80,0xbe]

s_cmov_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x03,0x80,0xbe]

s_cmov_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x03,0x80,0xbe]

s_cmov_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x03,0x80,0xbe]

s_cmov_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x03,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_cmov_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x03,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_not_b32 s0, s1
// GFX11: encoding: [0x01,0x1e,0x80,0xbe]

s_not_b32 s105, s104
// GFX11: encoding: [0x68,0x1e,0xe9,0xbe]

s_not_b32 s0, s104
// GFX11: encoding: [0x68,0x1e,0x80,0xbe]

s_not_b32 s105, s1
// GFX11: encoding: [0x01,0x1e,0xe9,0xbe]

s_not_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x1e,0xfe,0xbe]

s_not_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x1e,0xff,0xbe]

s_not_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x1e,0xea,0xbe]

s_not_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x1e,0xeb,0xbe]

s_not_b32 m0, s1
// GFX11: encoding: [0x01,0x1e,0xfd,0xbe]

s_not_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x1e,0x80,0xbe]

s_not_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x1e,0x80,0xbe]

s_not_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x1e,0x80,0xbe]

s_not_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x1e,0x80,0xbe]

s_not_b32 s0, m0
// GFX11: encoding: [0x7d,0x1e,0x80,0xbe]

s_not_b32 s0, 0
// GFX11: encoding: [0x80,0x1e,0x80,0xbe]

s_not_b32 s0, -1
// GFX11: encoding: [0xc1,0x1e,0x80,0xbe]

s_not_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x1e,0x80,0xbe]

s_not_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x1e,0x80,0xbe]

s_not_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x1e,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_not_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x1e,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_not_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x1f,0x80,0xbe]

s_not_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x1f,0xe8,0xbe]

s_not_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x1f,0x80,0xbe]

s_not_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x1f,0xe8,0xbe]

s_not_b64 exec, s[2:3]
// GFX11: encoding: [0x02,0x1f,0xfe,0xbe]

s_not_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x1f,0xea,0xbe]

s_not_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x1f,0x80,0xbe]

s_not_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x1f,0x80,0xbe]

s_not_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x1f,0x80,0xbe]

s_not_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x1f,0x80,0xbe]

s_not_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x1f,0x80,0xbe]

s_not_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x1f,0x80,0xbe]

s_not_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x1f,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_not_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x1f,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_wqm_b32 s0, s1
// GFX11: encoding: [0x01,0x1c,0x80,0xbe]

s_wqm_b32 s105, s104
// GFX11: encoding: [0x68,0x1c,0xe9,0xbe]

s_wqm_b32 s0, s104
// GFX11: encoding: [0x68,0x1c,0x80,0xbe]

s_wqm_b32 s105, s1
// GFX11: encoding: [0x01,0x1c,0xe9,0xbe]

s_wqm_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x1c,0xfe,0xbe]

s_wqm_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x1c,0xff,0xbe]

s_wqm_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x1c,0xea,0xbe]

s_wqm_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x1c,0xeb,0xbe]

s_wqm_b32 m0, s1
// GFX11: encoding: [0x01,0x1c,0xfd,0xbe]

s_wqm_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x1c,0x80,0xbe]

s_wqm_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x1c,0x80,0xbe]

s_wqm_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x1c,0x80,0xbe]

s_wqm_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x1c,0x80,0xbe]

s_wqm_b32 s0, m0
// GFX11: encoding: [0x7d,0x1c,0x80,0xbe]

s_wqm_b32 s0, 0
// GFX11: encoding: [0x80,0x1c,0x80,0xbe]

s_wqm_b32 s0, -1
// GFX11: encoding: [0xc1,0x1c,0x80,0xbe]

s_wqm_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x1c,0x80,0xbe]

s_wqm_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x1c,0x80,0xbe]

s_wqm_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x1c,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_wqm_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x1c,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_wqm_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x1d,0x80,0xbe]

s_wqm_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x1d,0xe8,0xbe]

s_wqm_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x1d,0x80,0xbe]

s_wqm_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x1d,0xe8,0xbe]

s_wqm_b64 exec, s[2:3]
// GFX11: encoding: [0x02,0x1d,0xfe,0xbe]

s_wqm_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x1d,0xea,0xbe]

s_wqm_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x1d,0x80,0xbe]

s_wqm_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x1d,0x80,0xbe]

s_wqm_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x1d,0x80,0xbe]

s_wqm_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x1d,0x80,0xbe]

s_wqm_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x1d,0x80,0xbe]

s_wqm_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x1d,0x80,0xbe]

s_wqm_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x1d,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_wqm_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x1d,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_brev_b32 s0, s1
// GFX11: encoding: [0x01,0x04,0x80,0xbe]

s_brev_b32 s105, s104
// GFX11: encoding: [0x68,0x04,0xe9,0xbe]

s_brev_b32 s0, s104
// GFX11: encoding: [0x68,0x04,0x80,0xbe]

s_brev_b32 s105, s1
// GFX11: encoding: [0x01,0x04,0xe9,0xbe]

s_brev_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x04,0xfe,0xbe]

s_brev_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x04,0xff,0xbe]

s_brev_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x04,0xea,0xbe]

s_brev_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x04,0xeb,0xbe]

s_brev_b32 m0, s1
// GFX11: encoding: [0x01,0x04,0xfd,0xbe]

s_brev_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x04,0x80,0xbe]

s_brev_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x04,0x80,0xbe]

s_brev_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x04,0x80,0xbe]

s_brev_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x04,0x80,0xbe]

s_brev_b32 s0, m0
// GFX11: encoding: [0x7d,0x04,0x80,0xbe]

s_brev_b32 s0, 0
// GFX11: encoding: [0x80,0x04,0x80,0xbe]

s_brev_b32 s0, -1
// GFX11: encoding: [0xc1,0x04,0x80,0xbe]

s_brev_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x04,0x80,0xbe]

s_brev_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x04,0x80,0xbe]

s_brev_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x04,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_brev_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x04,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_brev_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x05,0x80,0xbe]

s_brev_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x05,0xe8,0xbe]

s_brev_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x05,0x80,0xbe]

s_brev_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x05,0xe8,0xbe]

s_brev_b64 exec, s[2:3]
// GFX11: encoding: [0x02,0x05,0xfe,0xbe]

s_brev_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x05,0xea,0xbe]

s_brev_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x05,0x80,0xbe]

s_brev_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x05,0x80,0xbe]

s_brev_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x05,0x80,0xbe]

s_brev_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x05,0x80,0xbe]

s_brev_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x05,0x80,0xbe]

s_brev_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x05,0x80,0xbe]

s_brev_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x05,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_brev_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x05,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt0_i32_b32 s0, s1
// GFX11: encoding: [0x01,0x16,0x80,0xbe]

s_bcnt0_i32_b32 s105, s104
// GFX11: encoding: [0x68,0x16,0xe9,0xbe]

s_bcnt0_i32_b32 s0, s104
// GFX11: encoding: [0x68,0x16,0x80,0xbe]

s_bcnt0_i32_b32 s105, s1
// GFX11: encoding: [0x01,0x16,0xe9,0xbe]

s_bcnt0_i32_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x16,0xfe,0xbe]

s_bcnt0_i32_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x16,0xff,0xbe]

s_bcnt0_i32_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x16,0xea,0xbe]

s_bcnt0_i32_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x16,0xeb,0xbe]

s_bcnt0_i32_b32 m0, s1
// GFX11: encoding: [0x01,0x16,0xfd,0xbe]

s_bcnt0_i32_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x16,0x80,0xbe]

s_bcnt0_i32_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x16,0x80,0xbe]

s_bcnt0_i32_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x16,0x80,0xbe]

s_bcnt0_i32_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x16,0x80,0xbe]

s_bcnt0_i32_b32 s0, m0
// GFX11: encoding: [0x7d,0x16,0x80,0xbe]

s_bcnt0_i32_b32 s0, 0
// GFX11: encoding: [0x80,0x16,0x80,0xbe]

s_bcnt0_i32_b32 s0, -1
// GFX11: encoding: [0xc1,0x16,0x80,0xbe]

s_bcnt0_i32_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x16,0x80,0xbe]

s_bcnt0_i32_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x16,0x80,0xbe]

s_bcnt0_i32_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x16,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt0_i32_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x16,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt0_i32_b64 s0, s[2:3]
// GFX11: encoding: [0x02,0x17,0x80,0xbe]

s_bcnt0_i32_b64 s105, s[102:103]
// GFX11: encoding: [0x66,0x17,0xe9,0xbe]

s_bcnt0_i32_b64 s0, s[102:103]
// GFX11: encoding: [0x66,0x17,0x80,0xbe]

s_bcnt0_i32_b64 s105, s[2:3]
// GFX11: encoding: [0x02,0x17,0xe9,0xbe]

s_bcnt0_i32_b64 exec_lo, s[2:3]
// GFX11: encoding: [0x02,0x17,0xfe,0xbe]

s_bcnt0_i32_b64 exec_hi, s[2:3]
// GFX11: encoding: [0x02,0x17,0xff,0xbe]

s_bcnt0_i32_b64 vcc_lo, s[2:3]
// GFX11: encoding: [0x02,0x17,0xea,0xbe]

s_bcnt0_i32_b64 vcc_hi, s[2:3]
// GFX11: encoding: [0x02,0x17,0xeb,0xbe]

s_bcnt0_i32_b64 m0, s[2:3]
// GFX11: encoding: [0x02,0x17,0xfd,0xbe]

s_bcnt0_i32_b64 s0, exec
// GFX11: encoding: [0x7e,0x17,0x80,0xbe]

s_bcnt0_i32_b64 s0, vcc
// GFX11: encoding: [0x6a,0x17,0x80,0xbe]

s_bcnt0_i32_b64 s0, 0
// GFX11: encoding: [0x80,0x17,0x80,0xbe]

s_bcnt0_i32_b64 s0, -1
// GFX11: encoding: [0xc1,0x17,0x80,0xbe]

s_bcnt0_i32_b64 s0, 0.5
// GFX11: encoding: [0xf0,0x17,0x80,0xbe]

s_bcnt0_i32_b64 s0, -4.0
// GFX11: encoding: [0xf7,0x17,0x80,0xbe]

s_bcnt0_i32_b64 s0, 0x3f717273
// GFX11: encoding: [0xff,0x17,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt0_i32_b64 s0, 0xaf123456
// GFX11: encoding: [0xff,0x17,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt1_i32_b32 s0, s1
// GFX11: encoding: [0x01,0x18,0x80,0xbe]

s_bcnt1_i32_b32 s105, s104
// GFX11: encoding: [0x68,0x18,0xe9,0xbe]

s_bcnt1_i32_b32 s0, s104
// GFX11: encoding: [0x68,0x18,0x80,0xbe]

s_bcnt1_i32_b32 s105, s1
// GFX11: encoding: [0x01,0x18,0xe9,0xbe]

s_bcnt1_i32_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x18,0xfe,0xbe]

s_bcnt1_i32_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x18,0xff,0xbe]

s_bcnt1_i32_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x18,0xea,0xbe]

s_bcnt1_i32_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x18,0xeb,0xbe]

s_bcnt1_i32_b32 m0, s1
// GFX11: encoding: [0x01,0x18,0xfd,0xbe]

s_bcnt1_i32_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x18,0x80,0xbe]

s_bcnt1_i32_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x18,0x80,0xbe]

s_bcnt1_i32_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x18,0x80,0xbe]

s_bcnt1_i32_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x18,0x80,0xbe]

s_bcnt1_i32_b32 s0, m0
// GFX11: encoding: [0x7d,0x18,0x80,0xbe]

s_bcnt1_i32_b32 s0, 0
// GFX11: encoding: [0x80,0x18,0x80,0xbe]

s_bcnt1_i32_b32 s0, -1
// GFX11: encoding: [0xc1,0x18,0x80,0xbe]

s_bcnt1_i32_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x18,0x80,0xbe]

s_bcnt1_i32_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x18,0x80,0xbe]

s_bcnt1_i32_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x18,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt1_i32_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x18,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt1_i32_b64 s0, s[2:3]
// GFX11: encoding: [0x02,0x19,0x80,0xbe]

s_bcnt1_i32_b64 s105, s[102:103]
// GFX11: encoding: [0x66,0x19,0xe9,0xbe]

s_bcnt1_i32_b64 s0, s[102:103]
// GFX11: encoding: [0x66,0x19,0x80,0xbe]

s_bcnt1_i32_b64 s105, s[2:3]
// GFX11: encoding: [0x02,0x19,0xe9,0xbe]

s_bcnt1_i32_b64 exec_lo, s[2:3]
// GFX11: encoding: [0x02,0x19,0xfe,0xbe]

s_bcnt1_i32_b64 exec_hi, s[2:3]
// GFX11: encoding: [0x02,0x19,0xff,0xbe]

s_bcnt1_i32_b64 vcc_lo, s[2:3]
// GFX11: encoding: [0x02,0x19,0xea,0xbe]

s_bcnt1_i32_b64 vcc_hi, s[2:3]
// GFX11: encoding: [0x02,0x19,0xeb,0xbe]

s_bcnt1_i32_b64 m0, s[2:3]
// GFX11: encoding: [0x02,0x19,0xfd,0xbe]

s_bcnt1_i32_b64 s0, exec
// GFX11: encoding: [0x7e,0x19,0x80,0xbe]

s_bcnt1_i32_b64 s0, vcc
// GFX11: encoding: [0x6a,0x19,0x80,0xbe]

s_bcnt1_i32_b64 s0, 0
// GFX11: encoding: [0x80,0x19,0x80,0xbe]

s_bcnt1_i32_b64 s0, -1
// GFX11: encoding: [0xc1,0x19,0x80,0xbe]

s_bcnt1_i32_b64 s0, 0.5
// GFX11: encoding: [0xf0,0x19,0x80,0xbe]

s_bcnt1_i32_b64 s0, -4.0
// GFX11: encoding: [0xf7,0x19,0x80,0xbe]

s_bcnt1_i32_b64 s0, 0x3f717273
// GFX11: encoding: [0xff,0x19,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt1_i32_b64 s0, 0xaf123456
// GFX11: encoding: [0xff,0x19,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_ff1_i32_b32 s0, s1
// GFX11: encoding: [0x01,0x08,0x80,0xbe]

s_ff1_i32_b32 s105, s104
// GFX11: encoding: [0x68,0x08,0xe9,0xbe]

s_ff1_i32_b32 s0, s104
// GFX11: encoding: [0x68,0x08,0x80,0xbe]

s_ff1_i32_b32 s105, s1
// GFX11: encoding: [0x01,0x08,0xe9,0xbe]

s_ff1_i32_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x08,0xfe,0xbe]

s_ff1_i32_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x08,0xff,0xbe]

s_ff1_i32_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x08,0xea,0xbe]

s_ff1_i32_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x08,0xeb,0xbe]

s_ff1_i32_b32 m0, s1
// GFX11: encoding: [0x01,0x08,0xfd,0xbe]

s_ff1_i32_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x08,0x80,0xbe]

s_ff1_i32_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x08,0x80,0xbe]

s_ff1_i32_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x08,0x80,0xbe]

s_ff1_i32_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x08,0x80,0xbe]

s_ff1_i32_b32 s0, m0
// GFX11: encoding: [0x7d,0x08,0x80,0xbe]

s_ff1_i32_b32 s0, 0
// GFX11: encoding: [0x80,0x08,0x80,0xbe]

s_ff1_i32_b32 s0, -1
// GFX11: encoding: [0xc1,0x08,0x80,0xbe]

s_ff1_i32_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x08,0x80,0xbe]

s_ff1_i32_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x08,0x80,0xbe]

s_ff1_i32_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x08,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_ff1_i32_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x08,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_ff1_i32_b64 s0, s[2:3]
// GFX11: encoding: [0x02,0x09,0x80,0xbe]

s_ff1_i32_b64 s105, s[102:103]
// GFX11: encoding: [0x66,0x09,0xe9,0xbe]

s_ff1_i32_b64 s0, s[102:103]
// GFX11: encoding: [0x66,0x09,0x80,0xbe]

s_ff1_i32_b64 s105, s[2:3]
// GFX11: encoding: [0x02,0x09,0xe9,0xbe]

s_ff1_i32_b64 exec_lo, s[2:3]
// GFX11: encoding: [0x02,0x09,0xfe,0xbe]

s_ff1_i32_b64 exec_hi, s[2:3]
// GFX11: encoding: [0x02,0x09,0xff,0xbe]

s_ff1_i32_b64 vcc_lo, s[2:3]
// GFX11: encoding: [0x02,0x09,0xea,0xbe]

s_ff1_i32_b64 vcc_hi, s[2:3]
// GFX11: encoding: [0x02,0x09,0xeb,0xbe]

s_ff1_i32_b64 m0, s[2:3]
// GFX11: encoding: [0x02,0x09,0xfd,0xbe]

s_ff1_i32_b64 s0, exec
// GFX11: encoding: [0x7e,0x09,0x80,0xbe]

s_ff1_i32_b64 s0, vcc
// GFX11: encoding: [0x6a,0x09,0x80,0xbe]

s_ff1_i32_b64 s0, 0
// GFX11: encoding: [0x80,0x09,0x80,0xbe]

s_ff1_i32_b64 s0, -1
// GFX11: encoding: [0xc1,0x09,0x80,0xbe]

s_ff1_i32_b64 s0, 0.5
// GFX11: encoding: [0xf0,0x09,0x80,0xbe]

s_ff1_i32_b64 s0, -4.0
// GFX11: encoding: [0xf7,0x09,0x80,0xbe]

s_ff1_i32_b64 s0, 0x3f717273
// GFX11: encoding: [0xff,0x09,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_ff1_i32_b64 s0, 0xaf123456
// GFX11: encoding: [0xff,0x09,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_b32 s0, s1
// GFX11: encoding: [0x01,0x0a,0x80,0xbe]

s_flbit_i32_b32 s105, s104
// GFX11: encoding: [0x68,0x0a,0xe9,0xbe]

s_flbit_i32_b32 s0, s104
// GFX11: encoding: [0x68,0x0a,0x80,0xbe]

s_flbit_i32_b32 s105, s1
// GFX11: encoding: [0x01,0x0a,0xe9,0xbe]

s_flbit_i32_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x0a,0xfe,0xbe]

s_flbit_i32_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x0a,0xff,0xbe]

s_flbit_i32_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x0a,0xea,0xbe]

s_flbit_i32_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x0a,0xeb,0xbe]

s_flbit_i32_b32 m0, s1
// GFX11: encoding: [0x01,0x0a,0xfd,0xbe]

s_flbit_i32_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x0a,0x80,0xbe]

s_flbit_i32_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x0a,0x80,0xbe]

s_flbit_i32_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x0a,0x80,0xbe]

s_flbit_i32_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x0a,0x80,0xbe]

s_flbit_i32_b32 s0, m0
// GFX11: encoding: [0x7d,0x0a,0x80,0xbe]

s_flbit_i32_b32 s0, 0
// GFX11: encoding: [0x80,0x0a,0x80,0xbe]

s_flbit_i32_b32 s0, -1
// GFX11: encoding: [0xc1,0x0a,0x80,0xbe]

s_flbit_i32_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x0a,0x80,0xbe]

s_flbit_i32_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x0a,0x80,0xbe]

s_flbit_i32_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x0a,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x0a,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_b64 s0, s[2:3]
// GFX11: encoding: [0x02,0x0b,0x80,0xbe]

s_flbit_i32_b64 s105, s[102:103]
// GFX11: encoding: [0x66,0x0b,0xe9,0xbe]

s_flbit_i32_b64 s0, s[102:103]
// GFX11: encoding: [0x66,0x0b,0x80,0xbe]

s_flbit_i32_b64 s105, s[2:3]
// GFX11: encoding: [0x02,0x0b,0xe9,0xbe]

s_flbit_i32_b64 exec_lo, s[2:3]
// GFX11: encoding: [0x02,0x0b,0xfe,0xbe]

s_flbit_i32_b64 exec_hi, s[2:3]
// GFX11: encoding: [0x02,0x0b,0xff,0xbe]

s_flbit_i32_b64 vcc_lo, s[2:3]
// GFX11: encoding: [0x02,0x0b,0xea,0xbe]

s_flbit_i32_b64 vcc_hi, s[2:3]
// GFX11: encoding: [0x02,0x0b,0xeb,0xbe]

s_flbit_i32_b64 m0, s[2:3]
// GFX11: encoding: [0x02,0x0b,0xfd,0xbe]

s_flbit_i32_b64 s0, exec
// GFX11: encoding: [0x7e,0x0b,0x80,0xbe]

s_flbit_i32_b64 s0, vcc
// GFX11: encoding: [0x6a,0x0b,0x80,0xbe]

s_flbit_i32_b64 s0, 0
// GFX11: encoding: [0x80,0x0b,0x80,0xbe]

s_flbit_i32_b64 s0, -1
// GFX11: encoding: [0xc1,0x0b,0x80,0xbe]

s_flbit_i32_b64 s0, 0.5
// GFX11: encoding: [0xf0,0x0b,0x80,0xbe]

s_flbit_i32_b64 s0, -4.0
// GFX11: encoding: [0xf7,0x0b,0x80,0xbe]

s_flbit_i32_b64 s0, 0x3f717273
// GFX11: encoding: [0xff,0x0b,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_b64 s0, 0xaf123456
// GFX11: encoding: [0xff,0x0b,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32 s0, s1
// GFX11: encoding: [0x01,0x0c,0x80,0xbe]

s_flbit_i32 s105, s104
// GFX11: encoding: [0x68,0x0c,0xe9,0xbe]

s_flbit_i32 s0, s104
// GFX11: encoding: [0x68,0x0c,0x80,0xbe]

s_flbit_i32 s105, s1
// GFX11: encoding: [0x01,0x0c,0xe9,0xbe]

s_flbit_i32 exec_lo, s1
// GFX11: encoding: [0x01,0x0c,0xfe,0xbe]

s_flbit_i32 exec_hi, s1
// GFX11: encoding: [0x01,0x0c,0xff,0xbe]

s_flbit_i32 vcc_lo, s1
// GFX11: encoding: [0x01,0x0c,0xea,0xbe]

s_flbit_i32 vcc_hi, s1
// GFX11: encoding: [0x01,0x0c,0xeb,0xbe]

s_flbit_i32 m0, s1
// GFX11: encoding: [0x01,0x0c,0xfd,0xbe]

s_flbit_i32 s0, exec_lo
// GFX11: encoding: [0x7e,0x0c,0x80,0xbe]

s_flbit_i32 s0, exec_hi
// GFX11: encoding: [0x7f,0x0c,0x80,0xbe]

s_flbit_i32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x0c,0x80,0xbe]

s_flbit_i32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x0c,0x80,0xbe]

s_flbit_i32 s0, m0
// GFX11: encoding: [0x7d,0x0c,0x80,0xbe]

s_flbit_i32 s0, 0
// GFX11: encoding: [0x80,0x0c,0x80,0xbe]

s_flbit_i32 s0, -1
// GFX11: encoding: [0xc1,0x0c,0x80,0xbe]

s_flbit_i32 s0, 0.5
// GFX11: encoding: [0xf0,0x0c,0x80,0xbe]

s_flbit_i32 s0, -4.0
// GFX11: encoding: [0xf7,0x0c,0x80,0xbe]

s_flbit_i32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x0c,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x0c,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_i64 s0, s[2:3]
// GFX11: encoding: [0x02,0x0d,0x80,0xbe]

s_flbit_i32_i64 s105, s[102:103]
// GFX11: encoding: [0x66,0x0d,0xe9,0xbe]

s_flbit_i32_i64 s0, s[102:103]
// GFX11: encoding: [0x66,0x0d,0x80,0xbe]

s_flbit_i32_i64 s105, s[2:3]
// GFX11: encoding: [0x02,0x0d,0xe9,0xbe]

s_flbit_i32_i64 exec_lo, s[2:3]
// GFX11: encoding: [0x02,0x0d,0xfe,0xbe]

s_flbit_i32_i64 exec_hi, s[2:3]
// GFX11: encoding: [0x02,0x0d,0xff,0xbe]

s_flbit_i32_i64 vcc_lo, s[2:3]
// GFX11: encoding: [0x02,0x0d,0xea,0xbe]

s_flbit_i32_i64 vcc_hi, s[2:3]
// GFX11: encoding: [0x02,0x0d,0xeb,0xbe]

s_flbit_i32_i64 m0, s[2:3]
// GFX11: encoding: [0x02,0x0d,0xfd,0xbe]

s_flbit_i32_i64 s0, exec
// GFX11: encoding: [0x7e,0x0d,0x80,0xbe]

s_flbit_i32_i64 s0, vcc
// GFX11: encoding: [0x6a,0x0d,0x80,0xbe]

s_flbit_i32_i64 s0, 0
// GFX11: encoding: [0x80,0x0d,0x80,0xbe]

s_flbit_i32_i64 s0, -1
// GFX11: encoding: [0xc1,0x0d,0x80,0xbe]

s_flbit_i32_i64 s0, 0.5
// GFX11: encoding: [0xf0,0x0d,0x80,0xbe]

s_flbit_i32_i64 s0, -4.0
// GFX11: encoding: [0xf7,0x0d,0x80,0xbe]

s_flbit_i32_i64 s0, 0x3f717273
// GFX11: encoding: [0xff,0x0d,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_i64 s0, 0xaf123456
// GFX11: encoding: [0xff,0x0d,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_sext_i32_i8 s0, s1
// GFX11: encoding: [0x01,0x0e,0x80,0xbe]

s_sext_i32_i8 s105, s104
// GFX11: encoding: [0x68,0x0e,0xe9,0xbe]

s_sext_i32_i8 s0, s104
// GFX11: encoding: [0x68,0x0e,0x80,0xbe]

s_sext_i32_i8 s105, s1
// GFX11: encoding: [0x01,0x0e,0xe9,0xbe]

s_sext_i32_i8 exec_lo, s1
// GFX11: encoding: [0x01,0x0e,0xfe,0xbe]

s_sext_i32_i8 exec_hi, s1
// GFX11: encoding: [0x01,0x0e,0xff,0xbe]

s_sext_i32_i8 vcc_lo, s1
// GFX11: encoding: [0x01,0x0e,0xea,0xbe]

s_sext_i32_i8 vcc_hi, s1
// GFX11: encoding: [0x01,0x0e,0xeb,0xbe]

s_sext_i32_i8 m0, s1
// GFX11: encoding: [0x01,0x0e,0xfd,0xbe]

s_sext_i32_i8 s0, exec_lo
// GFX11: encoding: [0x7e,0x0e,0x80,0xbe]

s_sext_i32_i8 s0, exec_hi
// GFX11: encoding: [0x7f,0x0e,0x80,0xbe]

s_sext_i32_i8 s0, vcc_lo
// GFX11: encoding: [0x6a,0x0e,0x80,0xbe]

s_sext_i32_i8 s0, vcc_hi
// GFX11: encoding: [0x6b,0x0e,0x80,0xbe]

s_sext_i32_i8 s0, m0
// GFX11: encoding: [0x7d,0x0e,0x80,0xbe]

s_sext_i32_i8 s0, 0
// GFX11: encoding: [0x80,0x0e,0x80,0xbe]

s_sext_i32_i8 s0, -1
// GFX11: encoding: [0xc1,0x0e,0x80,0xbe]

s_sext_i32_i8 s0, 0.5
// GFX11: encoding: [0xf0,0x0e,0x80,0xbe]

s_sext_i32_i8 s0, -4.0
// GFX11: encoding: [0xf7,0x0e,0x80,0xbe]

s_sext_i32_i8 s0, 0x3f717273
// GFX11: encoding: [0xff,0x0e,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_sext_i32_i8 s0, 0xaf123456
// GFX11: encoding: [0xff,0x0e,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_sext_i32_i16 s0, s1
// GFX11: encoding: [0x01,0x0f,0x80,0xbe]

s_sext_i32_i16 s105, s104
// GFX11: encoding: [0x68,0x0f,0xe9,0xbe]

s_sext_i32_i16 s0, s104
// GFX11: encoding: [0x68,0x0f,0x80,0xbe]

s_sext_i32_i16 s105, s1
// GFX11: encoding: [0x01,0x0f,0xe9,0xbe]

s_sext_i32_i16 exec_lo, s1
// GFX11: encoding: [0x01,0x0f,0xfe,0xbe]

s_sext_i32_i16 exec_hi, s1
// GFX11: encoding: [0x01,0x0f,0xff,0xbe]

s_sext_i32_i16 vcc_lo, s1
// GFX11: encoding: [0x01,0x0f,0xea,0xbe]

s_sext_i32_i16 vcc_hi, s1
// GFX11: encoding: [0x01,0x0f,0xeb,0xbe]

s_sext_i32_i16 m0, s1
// GFX11: encoding: [0x01,0x0f,0xfd,0xbe]

s_sext_i32_i16 s0, exec_lo
// GFX11: encoding: [0x7e,0x0f,0x80,0xbe]

s_sext_i32_i16 s0, exec_hi
// GFX11: encoding: [0x7f,0x0f,0x80,0xbe]

s_sext_i32_i16 s0, vcc_lo
// GFX11: encoding: [0x6a,0x0f,0x80,0xbe]

s_sext_i32_i16 s0, vcc_hi
// GFX11: encoding: [0x6b,0x0f,0x80,0xbe]

s_sext_i32_i16 s0, m0
// GFX11: encoding: [0x7d,0x0f,0x80,0xbe]

s_sext_i32_i16 s0, 0
// GFX11: encoding: [0x80,0x0f,0x80,0xbe]

s_sext_i32_i16 s0, -1
// GFX11: encoding: [0xc1,0x0f,0x80,0xbe]

s_sext_i32_i16 s0, 0.5
// GFX11: encoding: [0xf0,0x0f,0x80,0xbe]

s_sext_i32_i16 s0, -4.0
// GFX11: encoding: [0xf7,0x0f,0x80,0xbe]

s_sext_i32_i16 s0, 0x3f717273
// GFX11: encoding: [0xff,0x0f,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_sext_i32_i16 s0, 0xaf123456
// GFX11: encoding: [0xff,0x0f,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitset0_b32 s0, s1
// GFX11: encoding: [0x01,0x10,0x80,0xbe]

s_bitset0_b32 s105, s104
// GFX11: encoding: [0x68,0x10,0xe9,0xbe]

s_bitset0_b32 s0, s104
// GFX11: encoding: [0x68,0x10,0x80,0xbe]

s_bitset0_b32 s105, s1
// GFX11: encoding: [0x01,0x10,0xe9,0xbe]

s_bitset0_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x10,0xfe,0xbe]

s_bitset0_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x10,0xff,0xbe]

s_bitset0_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x10,0xea,0xbe]

s_bitset0_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x10,0xeb,0xbe]

s_bitset0_b32 m0, s1
// GFX11: encoding: [0x01,0x10,0xfd,0xbe]

s_bitset0_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x10,0x80,0xbe]

s_bitset0_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x10,0x80,0xbe]

s_bitset0_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x10,0x80,0xbe]

s_bitset0_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x10,0x80,0xbe]

s_bitset0_b32 s0, m0
// GFX11: encoding: [0x7d,0x10,0x80,0xbe]

s_bitset0_b32 s0, 0
// GFX11: encoding: [0x80,0x10,0x80,0xbe]

s_bitset0_b32 s0, -1
// GFX11: encoding: [0xc1,0x10,0x80,0xbe]

s_bitset0_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x10,0x80,0xbe]

s_bitset0_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x10,0x80,0xbe]

s_bitset0_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x10,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitset0_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x10,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitset0_b64 s[0:1], s2
// GFX11: encoding: [0x02,0x11,0x80,0xbe]

s_bitset0_b64 s[104:105], s102
// GFX11: encoding: [0x66,0x11,0xe8,0xbe]

s_bitset0_b64 s[0:1], s102
// GFX11: encoding: [0x66,0x11,0x80,0xbe]

s_bitset0_b64 s[104:105], s2
// GFX11: encoding: [0x02,0x11,0xe8,0xbe]

s_bitset0_b64 exec, s2
// GFX11: encoding: [0x02,0x11,0xfe,0xbe]

s_bitset0_b64 vcc, s2
// GFX11: encoding: [0x02,0x11,0xea,0xbe]

s_bitset0_b64 s[0:1], exec_lo
// GFX11: encoding: [0x7e,0x11,0x80,0xbe]

s_bitset0_b64 s[0:1], exec_hi
// GFX11: encoding: [0x7f,0x11,0x80,0xbe]

s_bitset0_b64 s[0:1], vcc_lo
// GFX11: encoding: [0x6a,0x11,0x80,0xbe]

s_bitset0_b64 s[0:1], vcc_hi
// GFX11: encoding: [0x6b,0x11,0x80,0xbe]

s_bitset0_b64 s[0:1], m0
// GFX11: encoding: [0x7d,0x11,0x80,0xbe]

s_bitset0_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x11,0x80,0xbe]

s_bitset0_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x11,0x80,0xbe]

s_bitset0_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x11,0x80,0xbe]

s_bitset0_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x11,0x80,0xbe]

s_bitset0_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x11,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitset0_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x11,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitset1_b32 s0, s1
// GFX11: encoding: [0x01,0x12,0x80,0xbe]

s_bitset1_b32 s105, s104
// GFX11: encoding: [0x68,0x12,0xe9,0xbe]

s_bitset1_b32 s0, s104
// GFX11: encoding: [0x68,0x12,0x80,0xbe]

s_bitset1_b32 s105, s1
// GFX11: encoding: [0x01,0x12,0xe9,0xbe]

s_bitset1_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x12,0xfe,0xbe]

s_bitset1_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x12,0xff,0xbe]

s_bitset1_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x12,0xea,0xbe]

s_bitset1_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x12,0xeb,0xbe]

s_bitset1_b32 m0, s1
// GFX11: encoding: [0x01,0x12,0xfd,0xbe]

s_bitset1_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x12,0x80,0xbe]

s_bitset1_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x12,0x80,0xbe]

s_bitset1_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x12,0x80,0xbe]

s_bitset1_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x12,0x80,0xbe]

s_bitset1_b32 s0, m0
// GFX11: encoding: [0x7d,0x12,0x80,0xbe]

s_bitset1_b32 s0, 0
// GFX11: encoding: [0x80,0x12,0x80,0xbe]

s_bitset1_b32 s0, -1
// GFX11: encoding: [0xc1,0x12,0x80,0xbe]

s_bitset1_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x12,0x80,0xbe]

s_bitset1_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x12,0x80,0xbe]

s_bitset1_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x12,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitset1_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x12,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitset1_b64 s[0:1], s2
// GFX11: encoding: [0x02,0x13,0x80,0xbe]

s_bitset1_b64 s[104:105], s102
// GFX11: encoding: [0x66,0x13,0xe8,0xbe]

s_bitset1_b64 s[0:1], s102
// GFX11: encoding: [0x66,0x13,0x80,0xbe]

s_bitset1_b64 s[104:105], s2
// GFX11: encoding: [0x02,0x13,0xe8,0xbe]

s_bitset1_b64 exec, s2
// GFX11: encoding: [0x02,0x13,0xfe,0xbe]

s_bitset1_b64 vcc, s2
// GFX11: encoding: [0x02,0x13,0xea,0xbe]

s_bitset1_b64 s[0:1], exec_lo
// GFX11: encoding: [0x7e,0x13,0x80,0xbe]

s_bitset1_b64 s[0:1], exec_hi
// GFX11: encoding: [0x7f,0x13,0x80,0xbe]

s_bitset1_b64 s[0:1], vcc_lo
// GFX11: encoding: [0x6a,0x13,0x80,0xbe]

s_bitset1_b64 s[0:1], vcc_hi
// GFX11: encoding: [0x6b,0x13,0x80,0xbe]

s_bitset1_b64 s[0:1], m0
// GFX11: encoding: [0x7d,0x13,0x80,0xbe]

s_bitset1_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x13,0x80,0xbe]

s_bitset1_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x13,0x80,0xbe]

s_bitset1_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x13,0x80,0xbe]

s_bitset1_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x13,0x80,0xbe]

s_bitset1_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x13,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitset1_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x13,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_getpc_b64 s[0:1]
// GFX11: encoding: [0x00,0x47,0x80,0xbe]

s_getpc_b64 s[104:105]
// GFX11: encoding: [0x00,0x47,0xe8,0xbe]

s_getpc_b64 exec
// GFX11: encoding: [0x00,0x47,0xfe,0xbe]

s_getpc_b64 vcc
// GFX11: encoding: [0x00,0x47,0xea,0xbe]

s_setpc_b64 s[0:1]
// GFX11: encoding: [0x00,0x48,0x80,0xbe]

s_setpc_b64 s[104:105]
// GFX11: encoding: [0x68,0x48,0x80,0xbe]

s_setpc_b64 vcc
// GFX11: encoding: [0x6a,0x48,0x80,0xbe]

s_swappc_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x49,0x80,0xbe]

s_swappc_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x49,0xe8,0xbe]

s_swappc_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x49,0x80,0xbe]

s_swappc_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x49,0xe8,0xbe]

s_swappc_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x49,0xea,0xbe]

s_swappc_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x49,0x80,0xbe]

s_rfe_b64 s[0:1]
// GFX11: encoding: [0x00,0x4a,0x80,0xbe]

s_rfe_b64 s[104:105]
// GFX11: encoding: [0x68,0x4a,0x80,0xbe]

s_rfe_b64 vcc
// GFX11: encoding: [0x6a,0x4a,0x80,0xbe]

s_and_saveexec_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x21,0x80,0xbe]

s_and_saveexec_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x21,0xe8,0xbe]

s_and_saveexec_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x21,0x80,0xbe]

s_and_saveexec_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x21,0xe8,0xbe]

s_and_saveexec_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x21,0xea,0xbe]

s_and_saveexec_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x21,0x80,0xbe]

s_and_saveexec_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x21,0x80,0xbe]

s_and_saveexec_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x21,0x80,0xbe]

s_and_saveexec_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x21,0x80,0xbe]

s_and_saveexec_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x21,0x80,0xbe]

s_and_saveexec_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x21,0x80,0xbe]

s_and_saveexec_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x21,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_and_saveexec_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x21,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_or_saveexec_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x23,0x80,0xbe]

s_or_saveexec_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x23,0xe8,0xbe]

s_or_saveexec_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x23,0x80,0xbe]

s_or_saveexec_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x23,0xe8,0xbe]

s_or_saveexec_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x23,0xea,0xbe]

s_or_saveexec_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x23,0x80,0xbe]

s_or_saveexec_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x23,0x80,0xbe]

s_or_saveexec_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x23,0x80,0xbe]

s_or_saveexec_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x23,0x80,0xbe]

s_or_saveexec_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x23,0x80,0xbe]

s_or_saveexec_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x23,0x80,0xbe]

s_or_saveexec_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x23,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_or_saveexec_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x23,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_xor_saveexec_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x25,0x80,0xbe]

s_xor_saveexec_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x25,0xe8,0xbe]

s_xor_saveexec_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x25,0x80,0xbe]

s_xor_saveexec_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x25,0xe8,0xbe]

s_xor_saveexec_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x25,0xea,0xbe]

s_xor_saveexec_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x25,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x25,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x25,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x25,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x25,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x25,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x25,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_xor_saveexec_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x25,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_saveexec_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x31,0x80,0xbe]

s_andn2_saveexec_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x31,0xe8,0xbe]

s_andn2_saveexec_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x31,0x80,0xbe]

s_andn2_saveexec_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x31,0xe8,0xbe]

s_andn2_saveexec_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x31,0xea,0xbe]

s_andn2_saveexec_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x31,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x31,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x31,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x31,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x31,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x31,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x31,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_saveexec_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x31,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_orn2_saveexec_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x33,0x80,0xbe]

s_orn2_saveexec_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x33,0xe8,0xbe]

s_orn2_saveexec_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x33,0x80,0xbe]

s_orn2_saveexec_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x33,0xe8,0xbe]

s_orn2_saveexec_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x33,0xea,0xbe]

s_orn2_saveexec_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x33,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x33,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x33,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x33,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x33,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x33,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x33,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_orn2_saveexec_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x33,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_nand_saveexec_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x27,0x80,0xbe]

s_nand_saveexec_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x27,0xe8,0xbe]

s_nand_saveexec_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x27,0x80,0xbe]

s_nand_saveexec_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x27,0xe8,0xbe]

s_nand_saveexec_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x27,0xea,0xbe]

s_nand_saveexec_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x27,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x27,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x27,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x27,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x27,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x27,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x27,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_nand_saveexec_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x27,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_nor_saveexec_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x29,0x80,0xbe]

s_nor_saveexec_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x29,0xe8,0xbe]

s_nor_saveexec_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x29,0x80,0xbe]

s_nor_saveexec_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x29,0xe8,0xbe]

s_nor_saveexec_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x29,0xea,0xbe]

s_nor_saveexec_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x29,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x29,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x29,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x29,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x29,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x29,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x29,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_nor_saveexec_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x29,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_xnor_saveexec_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x2b,0xe8,0xbe]

s_xnor_saveexec_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x2b,0xe8,0xbe]

s_xnor_saveexec_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x2b,0xea,0xbe]

s_xnor_saveexec_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x2b,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_xnor_saveexec_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x2b,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_quadmask_b32 s0, s1
// GFX11: encoding: [0x01,0x1a,0x80,0xbe]

s_quadmask_b32 s105, s104
// GFX11: encoding: [0x68,0x1a,0xe9,0xbe]

s_quadmask_b32 s0, s104
// GFX11: encoding: [0x68,0x1a,0x80,0xbe]

s_quadmask_b32 s105, s1
// GFX11: encoding: [0x01,0x1a,0xe9,0xbe]

s_quadmask_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x1a,0xfe,0xbe]

s_quadmask_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x1a,0xff,0xbe]

s_quadmask_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x1a,0xea,0xbe]

s_quadmask_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x1a,0xeb,0xbe]

s_quadmask_b32 m0, s1
// GFX11: encoding: [0x01,0x1a,0xfd,0xbe]

s_quadmask_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x1a,0x80,0xbe]

s_quadmask_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x1a,0x80,0xbe]

s_quadmask_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x1a,0x80,0xbe]

s_quadmask_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x1a,0x80,0xbe]

s_quadmask_b32 s0, m0
// GFX11: encoding: [0x7d,0x1a,0x80,0xbe]

s_quadmask_b32 s0, 0
// GFX11: encoding: [0x80,0x1a,0x80,0xbe]

s_quadmask_b32 s0, -1
// GFX11: encoding: [0xc1,0x1a,0x80,0xbe]

s_quadmask_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x1a,0x80,0xbe]

s_quadmask_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x1a,0x80,0xbe]

s_quadmask_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x1a,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_quadmask_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x1a,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_quadmask_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x1b,0x80,0xbe]

s_quadmask_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x1b,0xe8,0xbe]

s_quadmask_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x1b,0x80,0xbe]

s_quadmask_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x1b,0xe8,0xbe]

s_quadmask_b64 exec, s[2:3]
// GFX11: encoding: [0x02,0x1b,0xfe,0xbe]

s_quadmask_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x1b,0xea,0xbe]

s_quadmask_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x1b,0x80,0xbe]

s_quadmask_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x1b,0x80,0xbe]

s_quadmask_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x1b,0x80,0xbe]

s_quadmask_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x1b,0x80,0xbe]

s_quadmask_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x1b,0x80,0xbe]

s_quadmask_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x1b,0x80,0xbe]

s_quadmask_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x1b,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_quadmask_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x1b,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_movrels_b32 s0, s1
// GFX11: encoding: [0x01,0x40,0x80,0xbe]

s_movrels_b32 s105, s104
// GFX11: encoding: [0x68,0x40,0xe9,0xbe]

s_movrels_b32 s0, s104
// GFX11: encoding: [0x68,0x40,0x80,0xbe]

s_movrels_b32 s105, s1
// GFX11: encoding: [0x01,0x40,0xe9,0xbe]

s_movrels_b32 exec_lo, s1
// GFX11: encoding: [0x01,0x40,0xfe,0xbe]

s_movrels_b32 exec_hi, s1
// GFX11: encoding: [0x01,0x40,0xff,0xbe]

s_movrels_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x40,0xea,0xbe]

s_movrels_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x40,0xeb,0xbe]

s_movrels_b32 m0, s1
// GFX11: encoding: [0x01,0x40,0xfd,0xbe]

s_movrels_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x40,0x80,0xbe]

s_movrels_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x40,0x80,0xbe]

s_movrels_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x41,0x80,0xbe]

s_movrels_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x41,0xe8,0xbe]

s_movrels_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x41,0x80,0xbe]

s_movrels_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x41,0xe8,0xbe]

s_movrels_b64 exec, s[2:3]
// GFX11: encoding: [0x02,0x41,0xfe,0xbe]

s_movrels_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x41,0xea,0xbe]

s_movrels_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x41,0x80,0xbe]

s_movreld_b32 s0, s1
// GFX11: encoding: [0x01,0x42,0x80,0xbe]

s_movreld_b32 s105, s104
// GFX11: encoding: [0x68,0x42,0xe9,0xbe]

s_movreld_b32 s0, s104
// GFX11: encoding: [0x68,0x42,0x80,0xbe]

s_movreld_b32 s105, s1
// GFX11: encoding: [0x01,0x42,0xe9,0xbe]

s_movreld_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x42,0xea,0xbe]

s_movreld_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x42,0xeb,0xbe]

s_movreld_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x42,0x80,0xbe]

s_movreld_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x42,0x80,0xbe]

s_movreld_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x42,0x80,0xbe]

s_movreld_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x42,0x80,0xbe]

s_movreld_b32 s0, m0
// GFX11: encoding: [0x7d,0x42,0x80,0xbe]

s_movreld_b32 s0, 0
// GFX11: encoding: [0x80,0x42,0x80,0xbe]

s_movreld_b32 s0, -1
// GFX11: encoding: [0xc1,0x42,0x80,0xbe]

s_movreld_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x42,0x80,0xbe]

s_movreld_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x42,0x80,0xbe]

s_movreld_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x42,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_movreld_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x42,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_movreld_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x43,0x80,0xbe]

s_movreld_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x43,0xe8,0xbe]

s_movreld_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x43,0x80,0xbe]

s_movreld_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x43,0xe8,0xbe]

s_movreld_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x43,0xea,0xbe]

s_movreld_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x43,0x80,0xbe]

s_movreld_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x43,0x80,0xbe]

s_movreld_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x43,0x80,0xbe]

s_movreld_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x43,0x80,0xbe]

s_movreld_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x43,0x80,0xbe]

s_movreld_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x43,0x80,0xbe]

s_movreld_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x43,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_movreld_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x43,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_abs_i32 s0, s1
// GFX11: encoding: [0x01,0x15,0x80,0xbe]

s_abs_i32 s105, s104
// GFX11: encoding: [0x68,0x15,0xe9,0xbe]

s_abs_i32 s0, s104
// GFX11: encoding: [0x68,0x15,0x80,0xbe]

s_abs_i32 s105, s1
// GFX11: encoding: [0x01,0x15,0xe9,0xbe]

s_abs_i32 exec_lo, s1
// GFX11: encoding: [0x01,0x15,0xfe,0xbe]

s_abs_i32 exec_hi, s1
// GFX11: encoding: [0x01,0x15,0xff,0xbe]

s_abs_i32 vcc_lo, s1
// GFX11: encoding: [0x01,0x15,0xea,0xbe]

s_abs_i32 vcc_hi, s1
// GFX11: encoding: [0x01,0x15,0xeb,0xbe]

s_abs_i32 m0, s1
// GFX11: encoding: [0x01,0x15,0xfd,0xbe]

s_abs_i32 s0, exec_lo
// GFX11: encoding: [0x7e,0x15,0x80,0xbe]

s_abs_i32 s0, exec_hi
// GFX11: encoding: [0x7f,0x15,0x80,0xbe]

s_abs_i32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x15,0x80,0xbe]

s_abs_i32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x15,0x80,0xbe]

s_abs_i32 s0, m0
// GFX11: encoding: [0x7d,0x15,0x80,0xbe]

s_abs_i32 s0, 0
// GFX11: encoding: [0x80,0x15,0x80,0xbe]

s_abs_i32 s0, -1
// GFX11: encoding: [0xc1,0x15,0x80,0xbe]

s_abs_i32 s0, 0.5
// GFX11: encoding: [0xf0,0x15,0x80,0xbe]

s_abs_i32 s0, -4.0
// GFX11: encoding: [0xf7,0x15,0x80,0xbe]

s_abs_i32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x15,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_abs_i32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x15,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_saveexec_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x2d,0x80,0xbe]

s_andn1_saveexec_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x2d,0xe8,0xbe]

s_andn1_saveexec_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x2d,0x80,0xbe]

s_andn1_saveexec_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x2d,0xe8,0xbe]

s_andn1_saveexec_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x2d,0xea,0xbe]

s_andn1_saveexec_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x2d,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x2d,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x2d,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x2d,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x2d,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x2d,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x2d,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_saveexec_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x2d,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_orn1_saveexec_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x2f,0x80,0xbe]

s_orn1_saveexec_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x2f,0xe8,0xbe]

s_orn1_saveexec_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x2f,0x80,0xbe]

s_orn1_saveexec_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x2f,0xe8,0xbe]

s_orn1_saveexec_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x2f,0xea,0xbe]

s_orn1_saveexec_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x2f,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x2f,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x2f,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x2f,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x2f,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x2f,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x2f,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_orn1_saveexec_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x2f,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_wrexec_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x35,0x80,0xbe]

s_andn1_wrexec_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x35,0xe8,0xbe]

s_andn1_wrexec_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x35,0x80,0xbe]

s_andn1_wrexec_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x35,0xe8,0xbe]

s_andn1_wrexec_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x35,0xea,0xbe]

s_andn1_wrexec_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x35,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x35,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x35,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x35,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x35,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x35,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x35,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_wrexec_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x35,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_wrexec_b64 s[0:1], s[2:3]
// GFX11: encoding: [0x02,0x37,0x80,0xbe]

s_andn2_wrexec_b64 s[104:105], s[102:103]
// GFX11: encoding: [0x66,0x37,0xe8,0xbe]

s_andn2_wrexec_b64 s[0:1], s[102:103]
// GFX11: encoding: [0x66,0x37,0x80,0xbe]

s_andn2_wrexec_b64 s[104:105], s[2:3]
// GFX11: encoding: [0x02,0x37,0xe8,0xbe]

s_andn2_wrexec_b64 vcc, s[2:3]
// GFX11: encoding: [0x02,0x37,0xea,0xbe]

s_andn2_wrexec_b64 s[0:1], exec
// GFX11: encoding: [0x7e,0x37,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], vcc
// GFX11: encoding: [0x6a,0x37,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], 0
// GFX11: encoding: [0x80,0x37,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], -1
// GFX11: encoding: [0xc1,0x37,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x37,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x37,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x37,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_wrexec_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x37,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitreplicate_b64_b32 s[0:1], s2
// GFX11: encoding: [0x02,0x14,0x80,0xbe]

s_bitreplicate_b64_b32 s[104:105], s102
// GFX11: encoding: [0x66,0x14,0xe8,0xbe]

s_bitreplicate_b64_b32 s[0:1], s102
// GFX11: encoding: [0x66,0x14,0x80,0xbe]

s_bitreplicate_b64_b32 s[104:105], s2
// GFX11: encoding: [0x02,0x14,0xe8,0xbe]

s_bitreplicate_b64_b32 exec, s2
// GFX11: encoding: [0x02,0x14,0xfe,0xbe]

s_bitreplicate_b64_b32 vcc, s2
// GFX11: encoding: [0x02,0x14,0xea,0xbe]

s_bitreplicate_b64_b32 s[0:1], exec_lo
// GFX11: encoding: [0x7e,0x14,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], exec_hi
// GFX11: encoding: [0x7f,0x14,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], vcc_lo
// GFX11: encoding: [0x6a,0x14,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], vcc_hi
// GFX11: encoding: [0x6b,0x14,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], m0
// GFX11: encoding: [0x7d,0x14,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], 0
// GFX11: encoding: [0x80,0x14,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], -1
// GFX11: encoding: [0xc1,0x14,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], 0.5
// GFX11: encoding: [0xf0,0x14,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], -4.0
// GFX11: encoding: [0xf7,0x14,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], 0x3f717273
// GFX11: encoding: [0xff,0x14,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitreplicate_b64_b32 s[0:1], 0xaf123456
// GFX11: encoding: [0xff,0x14,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_and_saveexec_b32 s0, s1
// GFX11: encoding: [0x01,0x20,0x80,0xbe]

s_and_saveexec_b32 s105, s104
// GFX11: encoding: [0x68,0x20,0xe9,0xbe]

s_and_saveexec_b32 s0, s104
// GFX11: encoding: [0x68,0x20,0x80,0xbe]

s_and_saveexec_b32 s105, s1
// GFX11: encoding: [0x01,0x20,0xe9,0xbe]

s_and_saveexec_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x20,0xea,0xbe]

s_and_saveexec_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x20,0xeb,0xbe]

s_and_saveexec_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x20,0x80,0xbe]

s_and_saveexec_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x20,0x80,0xbe]

s_and_saveexec_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x20,0x80,0xbe]

s_and_saveexec_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x20,0x80,0xbe]

s_and_saveexec_b32 s0, m0
// GFX11: encoding: [0x7d,0x20,0x80,0xbe]

s_and_saveexec_b32 s0, 0
// GFX11: encoding: [0x80,0x20,0x80,0xbe]

s_and_saveexec_b32 s0, -1
// GFX11: encoding: [0xc1,0x20,0x80,0xbe]

s_and_saveexec_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x20,0x80,0xbe]

s_and_saveexec_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x20,0x80,0xbe]

s_and_saveexec_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x20,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_and_saveexec_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x20,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_or_saveexec_b32 s0, s1
// GFX11: encoding: [0x01,0x22,0x80,0xbe]

s_or_saveexec_b32 s105, s104
// GFX11: encoding: [0x68,0x22,0xe9,0xbe]

s_or_saveexec_b32 s0, s104
// GFX11: encoding: [0x68,0x22,0x80,0xbe]

s_or_saveexec_b32 s105, s1
// GFX11: encoding: [0x01,0x22,0xe9,0xbe]

s_or_saveexec_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x22,0xea,0xbe]

s_or_saveexec_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x22,0xeb,0xbe]

s_or_saveexec_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x22,0x80,0xbe]

s_or_saveexec_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x22,0x80,0xbe]

s_or_saveexec_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x22,0x80,0xbe]

s_or_saveexec_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x22,0x80,0xbe]

s_or_saveexec_b32 s0, m0
// GFX11: encoding: [0x7d,0x22,0x80,0xbe]

s_or_saveexec_b32 s0, 0
// GFX11: encoding: [0x80,0x22,0x80,0xbe]

s_or_saveexec_b32 s0, -1
// GFX11: encoding: [0xc1,0x22,0x80,0xbe]

s_or_saveexec_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x22,0x80,0xbe]

s_or_saveexec_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x22,0x80,0xbe]

s_or_saveexec_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x22,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_or_saveexec_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x22,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_xor_saveexec_b32 s0, s1
// GFX11: encoding: [0x01,0x24,0x80,0xbe]

s_xor_saveexec_b32 s105, s104
// GFX11: encoding: [0x68,0x24,0xe9,0xbe]

s_xor_saveexec_b32 s0, s104
// GFX11: encoding: [0x68,0x24,0x80,0xbe]

s_xor_saveexec_b32 s105, s1
// GFX11: encoding: [0x01,0x24,0xe9,0xbe]

s_xor_saveexec_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x24,0xea,0xbe]

s_xor_saveexec_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x24,0xeb,0xbe]

s_xor_saveexec_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x24,0x80,0xbe]

s_xor_saveexec_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x24,0x80,0xbe]

s_xor_saveexec_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x24,0x80,0xbe]

s_xor_saveexec_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x24,0x80,0xbe]

s_xor_saveexec_b32 s0, m0
// GFX11: encoding: [0x7d,0x24,0x80,0xbe]

s_xor_saveexec_b32 s0, 0
// GFX11: encoding: [0x80,0x24,0x80,0xbe]

s_xor_saveexec_b32 s0, -1
// GFX11: encoding: [0xc1,0x24,0x80,0xbe]

s_xor_saveexec_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x24,0x80,0xbe]

s_xor_saveexec_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x24,0x80,0xbe]

s_xor_saveexec_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x24,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_xor_saveexec_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x24,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_saveexec_b32 s0, s1
// GFX11: encoding: [0x01,0x30,0x80,0xbe]

s_andn2_saveexec_b32 s105, s104
// GFX11: encoding: [0x68,0x30,0xe9,0xbe]

s_andn2_saveexec_b32 s0, s104
// GFX11: encoding: [0x68,0x30,0x80,0xbe]

s_andn2_saveexec_b32 s105, s1
// GFX11: encoding: [0x01,0x30,0xe9,0xbe]

s_andn2_saveexec_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x30,0xea,0xbe]

s_andn2_saveexec_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x30,0xeb,0xbe]

s_andn2_saveexec_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x30,0x80,0xbe]

s_andn2_saveexec_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x30,0x80,0xbe]

s_andn2_saveexec_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x30,0x80,0xbe]

s_andn2_saveexec_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x30,0x80,0xbe]

s_andn2_saveexec_b32 s0, m0
// GFX11: encoding: [0x7d,0x30,0x80,0xbe]

s_andn2_saveexec_b32 s0, 0
// GFX11: encoding: [0x80,0x30,0x80,0xbe]

s_andn2_saveexec_b32 s0, -1
// GFX11: encoding: [0xc1,0x30,0x80,0xbe]

s_andn2_saveexec_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x30,0x80,0xbe]

s_andn2_saveexec_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x30,0x80,0xbe]

s_andn2_saveexec_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x30,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_saveexec_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x30,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_orn2_saveexec_b32 s0, s1
// GFX11: encoding: [0x01,0x32,0x80,0xbe]

s_orn2_saveexec_b32 s105, s104
// GFX11: encoding: [0x68,0x32,0xe9,0xbe]

s_orn2_saveexec_b32 s0, s104
// GFX11: encoding: [0x68,0x32,0x80,0xbe]

s_orn2_saveexec_b32 s105, s1
// GFX11: encoding: [0x01,0x32,0xe9,0xbe]

s_orn2_saveexec_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x32,0xea,0xbe]

s_orn2_saveexec_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x32,0xeb,0xbe]

s_orn2_saveexec_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x32,0x80,0xbe]

s_orn2_saveexec_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x32,0x80,0xbe]

s_orn2_saveexec_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x32,0x80,0xbe]

s_orn2_saveexec_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x32,0x80,0xbe]

s_orn2_saveexec_b32 s0, m0
// GFX11: encoding: [0x7d,0x32,0x80,0xbe]

s_orn2_saveexec_b32 s0, 0
// GFX11: encoding: [0x80,0x32,0x80,0xbe]

s_orn2_saveexec_b32 s0, -1
// GFX11: encoding: [0xc1,0x32,0x80,0xbe]

s_orn2_saveexec_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x32,0x80,0xbe]

s_orn2_saveexec_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x32,0x80,0xbe]

s_orn2_saveexec_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x32,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_orn2_saveexec_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x32,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_nand_saveexec_b32 s0, s1
// GFX11: encoding: [0x01,0x26,0x80,0xbe]

s_nand_saveexec_b32 s105, s104
// GFX11: encoding: [0x68,0x26,0xe9,0xbe]

s_nand_saveexec_b32 s0, s104
// GFX11: encoding: [0x68,0x26,0x80,0xbe]

s_nand_saveexec_b32 s105, s1
// GFX11: encoding: [0x01,0x26,0xe9,0xbe]

s_nand_saveexec_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x26,0xea,0xbe]

s_nand_saveexec_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x26,0xeb,0xbe]

s_nand_saveexec_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x26,0x80,0xbe]

s_nand_saveexec_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x26,0x80,0xbe]

s_nand_saveexec_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x26,0x80,0xbe]

s_nand_saveexec_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x26,0x80,0xbe]

s_nand_saveexec_b32 s0, m0
// GFX11: encoding: [0x7d,0x26,0x80,0xbe]

s_nand_saveexec_b32 s0, 0
// GFX11: encoding: [0x80,0x26,0x80,0xbe]

s_nand_saveexec_b32 s0, -1
// GFX11: encoding: [0xc1,0x26,0x80,0xbe]

s_nand_saveexec_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x26,0x80,0xbe]

s_nand_saveexec_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x26,0x80,0xbe]

s_nand_saveexec_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x26,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_nand_saveexec_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x26,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_nor_saveexec_b32 s0, s1
// GFX11: encoding: [0x01,0x28,0x80,0xbe]

s_nor_saveexec_b32 s105, s104
// GFX11: encoding: [0x68,0x28,0xe9,0xbe]

s_nor_saveexec_b32 s0, s104
// GFX11: encoding: [0x68,0x28,0x80,0xbe]

s_nor_saveexec_b32 s105, s1
// GFX11: encoding: [0x01,0x28,0xe9,0xbe]

s_nor_saveexec_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x28,0xea,0xbe]

s_nor_saveexec_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x28,0xeb,0xbe]

s_nor_saveexec_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x28,0x80,0xbe]

s_nor_saveexec_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x28,0x80,0xbe]

s_nor_saveexec_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x28,0x80,0xbe]

s_nor_saveexec_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x28,0x80,0xbe]

s_nor_saveexec_b32 s0, m0
// GFX11: encoding: [0x7d,0x28,0x80,0xbe]

s_nor_saveexec_b32 s0, 0
// GFX11: encoding: [0x80,0x28,0x80,0xbe]

s_nor_saveexec_b32 s0, -1
// GFX11: encoding: [0xc1,0x28,0x80,0xbe]

s_nor_saveexec_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x28,0x80,0xbe]

s_nor_saveexec_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x28,0x80,0xbe]

s_nor_saveexec_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x28,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_nor_saveexec_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x28,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_xnor_saveexec_b32 s0, s1
// GFX11: encoding: [0x01,0x2a,0x80,0xbe]

s_xnor_saveexec_b32 s105, s104
// GFX11: encoding: [0x68,0x2a,0xe9,0xbe]

s_xnor_saveexec_b32 s0, s104
// GFX11: encoding: [0x68,0x2a,0x80,0xbe]

s_xnor_saveexec_b32 s105, s1
// GFX11: encoding: [0x01,0x2a,0xe9,0xbe]

s_xnor_saveexec_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x2a,0xea,0xbe]

s_xnor_saveexec_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x2a,0xeb,0xbe]

s_xnor_saveexec_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x2a,0x80,0xbe]

s_xnor_saveexec_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x2a,0x80,0xbe]

s_xnor_saveexec_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x2a,0x80,0xbe]

s_xnor_saveexec_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x2a,0x80,0xbe]

s_xnor_saveexec_b32 s0, m0
// GFX11: encoding: [0x7d,0x2a,0x80,0xbe]

s_xnor_saveexec_b32 s0, 0
// GFX11: encoding: [0x80,0x2a,0x80,0xbe]

s_xnor_saveexec_b32 s0, -1
// GFX11: encoding: [0xc1,0x2a,0x80,0xbe]

s_xnor_saveexec_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x2a,0x80,0xbe]

s_xnor_saveexec_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x2a,0x80,0xbe]

s_xnor_saveexec_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x2a,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_xnor_saveexec_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x2a,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_saveexec_b32 s0, s1
// GFX11: encoding: [0x01,0x2c,0x80,0xbe]

s_andn1_saveexec_b32 s105, s104
// GFX11: encoding: [0x68,0x2c,0xe9,0xbe]

s_andn1_saveexec_b32 s0, s104
// GFX11: encoding: [0x68,0x2c,0x80,0xbe]

s_andn1_saveexec_b32 s105, s1
// GFX11: encoding: [0x01,0x2c,0xe9,0xbe]

s_andn1_saveexec_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x2c,0xea,0xbe]

s_andn1_saveexec_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x2c,0xeb,0xbe]

s_andn1_saveexec_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x2c,0x80,0xbe]

s_andn1_saveexec_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x2c,0x80,0xbe]

s_andn1_saveexec_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x2c,0x80,0xbe]

s_andn1_saveexec_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x2c,0x80,0xbe]

s_andn1_saveexec_b32 s0, m0
// GFX11: encoding: [0x7d,0x2c,0x80,0xbe]

s_andn1_saveexec_b32 s0, 0
// GFX11: encoding: [0x80,0x2c,0x80,0xbe]

s_andn1_saveexec_b32 s0, -1
// GFX11: encoding: [0xc1,0x2c,0x80,0xbe]

s_andn1_saveexec_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x2c,0x80,0xbe]

s_andn1_saveexec_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x2c,0x80,0xbe]

s_andn1_saveexec_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x2c,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_saveexec_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x2c,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_orn1_saveexec_b32 s0, s1
// GFX11: encoding: [0x01,0x2e,0x80,0xbe]

s_orn1_saveexec_b32 s105, s104
// GFX11: encoding: [0x68,0x2e,0xe9,0xbe]

s_orn1_saveexec_b32 s0, s104
// GFX11: encoding: [0x68,0x2e,0x80,0xbe]

s_orn1_saveexec_b32 s105, s1
// GFX11: encoding: [0x01,0x2e,0xe9,0xbe]

s_orn1_saveexec_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x2e,0xea,0xbe]

s_orn1_saveexec_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x2e,0xeb,0xbe]

s_orn1_saveexec_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x2e,0x80,0xbe]

s_orn1_saveexec_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x2e,0x80,0xbe]

s_orn1_saveexec_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x2e,0x80,0xbe]

s_orn1_saveexec_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x2e,0x80,0xbe]

s_orn1_saveexec_b32 s0, m0
// GFX11: encoding: [0x7d,0x2e,0x80,0xbe]

s_orn1_saveexec_b32 s0, 0
// GFX11: encoding: [0x80,0x2e,0x80,0xbe]

s_orn1_saveexec_b32 s0, -1
// GFX11: encoding: [0xc1,0x2e,0x80,0xbe]

s_orn1_saveexec_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x2e,0x80,0xbe]

s_orn1_saveexec_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x2e,0x80,0xbe]

s_orn1_saveexec_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x2e,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_orn1_saveexec_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x2e,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_wrexec_b32 s0, s1
// GFX11: encoding: [0x01,0x34,0x80,0xbe]

s_andn1_wrexec_b32 s105, s104
// GFX11: encoding: [0x68,0x34,0xe9,0xbe]

s_andn1_wrexec_b32 s0, s104
// GFX11: encoding: [0x68,0x34,0x80,0xbe]

s_andn1_wrexec_b32 s105, s1
// GFX11: encoding: [0x01,0x34,0xe9,0xbe]

s_andn1_wrexec_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x34,0xea,0xbe]

s_andn1_wrexec_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x34,0xeb,0xbe]

s_andn1_wrexec_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x34,0x80,0xbe]

s_andn1_wrexec_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x34,0x80,0xbe]

s_andn1_wrexec_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x34,0x80,0xbe]

s_andn1_wrexec_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x34,0x80,0xbe]

s_andn1_wrexec_b32 s0, m0
// GFX11: encoding: [0x7d,0x34,0x80,0xbe]

s_andn1_wrexec_b32 s0, 0
// GFX11: encoding: [0x80,0x34,0x80,0xbe]

s_andn1_wrexec_b32 s0, -1
// GFX11: encoding: [0xc1,0x34,0x80,0xbe]

s_andn1_wrexec_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x34,0x80,0xbe]

s_andn1_wrexec_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x34,0x80,0xbe]

s_andn1_wrexec_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x34,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_wrexec_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x34,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_wrexec_b32 s0, s1
// GFX11: encoding: [0x01,0x36,0x80,0xbe]

s_andn2_wrexec_b32 s105, s104
// GFX11: encoding: [0x68,0x36,0xe9,0xbe]

s_andn2_wrexec_b32 s0, s104
// GFX11: encoding: [0x68,0x36,0x80,0xbe]

s_andn2_wrexec_b32 s105, s1
// GFX11: encoding: [0x01,0x36,0xe9,0xbe]

s_andn2_wrexec_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x36,0xea,0xbe]

s_andn2_wrexec_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x36,0xeb,0xbe]

s_andn2_wrexec_b32 s0, exec_lo
// GFX11: encoding: [0x7e,0x36,0x80,0xbe]

s_andn2_wrexec_b32 s0, exec_hi
// GFX11: encoding: [0x7f,0x36,0x80,0xbe]

s_andn2_wrexec_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x36,0x80,0xbe]

s_andn2_wrexec_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x36,0x80,0xbe]

s_andn2_wrexec_b32 s0, m0
// GFX11: encoding: [0x7d,0x36,0x80,0xbe]

s_andn2_wrexec_b32 s0, 0
// GFX11: encoding: [0x80,0x36,0x80,0xbe]

s_andn2_wrexec_b32 s0, -1
// GFX11: encoding: [0xc1,0x36,0x80,0xbe]

s_andn2_wrexec_b32 s0, 0.5
// GFX11: encoding: [0xf0,0x36,0x80,0xbe]

s_andn2_wrexec_b32 s0, -4.0
// GFX11: encoding: [0xf7,0x36,0x80,0xbe]

s_andn2_wrexec_b32 s0, 0x3f717273
// GFX11: encoding: [0xff,0x36,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_wrexec_b32 s0, 0xaf123456
// GFX11: encoding: [0xff,0x36,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_movrelsd_2_b32 s0, s1
// GFX11: encoding: [0x01,0x44,0x80,0xbe]

s_movrelsd_2_b32 s105, s104
// GFX11: encoding: [0x68,0x44,0xe9,0xbe]

s_movrelsd_2_b32 s0, s104
// GFX11: encoding: [0x68,0x44,0x80,0xbe]

s_movrelsd_2_b32 s105, s1
// GFX11: encoding: [0x01,0x44,0xe9,0xbe]

s_movrelsd_2_b32 vcc_lo, s1
// GFX11: encoding: [0x01,0x44,0xea,0xbe]

s_movrelsd_2_b32 vcc_hi, s1
// GFX11: encoding: [0x01,0x44,0xeb,0xbe]

s_movrelsd_2_b32 s0, vcc_lo
// GFX11: encoding: [0x6a,0x44,0x80,0xbe]

s_movrelsd_2_b32 s0, vcc_hi
// GFX11: encoding: [0x6b,0x44,0x80,0xbe]

s_sendmsg_rtn_b32 s1, 0x0
// GFX11: encoding: [0x00,0x4c,0x81,0xbe]

s_sendmsg_rtn_b32 s2, 0x12
// GFX11: encoding: [0x12,0x4c,0x82,0xbe]

s_sendmsg_rtn_b32 s3, 0xff
// GFX11: encoding: [0xff,0x4c,0x83,0xbe]

s_sendmsg_rtn_b64 s[0:1], 0x0
// GFX11: encoding: [0x00,0x4d,0x80,0xbe]

s_sendmsg_rtn_b64 s[2:3], 0x12
// GFX11: encoding: [0x12,0x4d,0x82,0xbe]

s_sendmsg_rtn_b64 s[4:5], 0xff
// GFX11: encoding: [0xff,0x4d,0x84,0xbe]

s_sendmsg_rtn_b32 s0, sendmsg(MSG_RTN_GET_DOORBELL)
// GFX11: encoding: [0x80,0x4c,0x80,0xbe]

s_sendmsg_rtn_b32 s0, sendmsg(MSG_RTN_GET_DDID)
// GFX11: encoding: [0x81,0x4c,0x80,0xbe]

s_sendmsg_rtn_b32 s0, sendmsg(MSG_RTN_GET_TMA)
// GFX11: encoding: [0x82,0x4c,0x80,0xbe]

s_sendmsg_rtn_b32 s0, sendmsg(MSG_RTN_GET_REALTIME)
// GFX11: encoding: [0x83,0x4c,0x80,0xbe]

s_sendmsg_rtn_b32 s0, sendmsg(MSG_RTN_SAVE_WAVE)
// GFX11: encoding: [0x84,0x4c,0x80,0xbe]

s_sendmsg_rtn_b32 s0, sendmsg(MSG_RTN_GET_TBA)
// GFX11: encoding: [0x85,0x4c,0x80,0xbe]

s_ctz_i32_b32 s5, s1
// GFX11: encoding: [0x01,0x08,0x85,0xbe]

s_ctz_i32_b32 s5, s105
// GFX11: encoding: [0x69,0x08,0x85,0xbe]

s_ctz_i32_b32 s5, vcc_lo
// GFX11: encoding: [0x6a,0x08,0x85,0xbe]

s_ctz_i32_b32 s5, vcc_hi
// GFX11: encoding: [0x6b,0x08,0x85,0xbe]

s_ctz_i32_b32 s5, ttmp15
// GFX11: encoding: [0x7b,0x08,0x85,0xbe]

s_ctz_i32_b32 s105, m0
// GFX11: encoding: [0x7d,0x08,0xe9,0xbe]

s_ctz_i32_b32 vcc_lo, exec_lo
// GFX11: encoding: [0x7e,0x08,0xea,0xbe]

s_ctz_i32_b32 vcc_hi, exec_hi
// GFX11: encoding: [0x7f,0x08,0xeb,0xbe]

s_ctz_i32_b32 ttmp15, null
// GFX11: encoding: [0x7c,0x08,0xfb,0xbe]

s_ctz_i32_b32 m0, -1
// GFX11: encoding: [0xc1,0x08,0xfd,0xbe]

s_ctz_i32_b32 exec_lo, 0.5
// GFX11: encoding: [0xf0,0x08,0xfe,0xbe]

s_ctz_i32_b32 exec_hi, src_scc
// GFX11: encoding: [0xfd,0x08,0xff,0xbe]

s_ctz_i32_b32 null, 0xaf123456
// GFX11: encoding: [0xff,0x08,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_ctz_i32_b64 s5, s[2:3]
// GFX11: encoding: [0x02,0x09,0x85,0xbe]

s_ctz_i32_b64 s5, s[104:105]
// GFX11: encoding: [0x68,0x09,0x85,0xbe]

s_ctz_i32_b64 s105, vcc
// GFX11: encoding: [0x6a,0x09,0xe9,0xbe]

s_ctz_i32_b64 vcc_lo, ttmp[14:15]
// GFX11: encoding: [0x7a,0x09,0xea,0xbe]

s_ctz_i32_b64 vcc_hi, exec
// GFX11: encoding: [0x7e,0x09,0xeb,0xbe]

s_ctz_i32_b64 ttmp15, null
// GFX11: encoding: [0x7c,0x09,0xfb,0xbe]

s_ctz_i32_b64 m0, -1
// GFX11: encoding: [0xc1,0x09,0xfd,0xbe]

s_ctz_i32_b64 exec_lo, 0.5
// GFX11: encoding: [0xf0,0x09,0xfe,0xbe]

s_ctz_i32_b64 exec_hi, src_scc
// GFX11: encoding: [0xfd,0x09,0xff,0xbe]

s_ctz_i32_b64 null, 0xaf123456
// GFX11: encoding: [0xff,0x09,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_and_not1_saveexec_b64 s[10:11], s[2:3]
// GFX11: encoding: [0x02,0x31,0x8a,0xbe]

s_and_not1_saveexec_b64 s[10:11], s[104:105]
// GFX11: encoding: [0x68,0x31,0x8a,0xbe]

s_and_not1_saveexec_b64 s[10:11], vcc
// GFX11: encoding: [0x6a,0x31,0x8a,0xbe]

s_and_not1_saveexec_b64 s[10:11], ttmp[14:15]
// GFX11: encoding: [0x7a,0x31,0x8a,0xbe]

s_and_not1_saveexec_b64 s[10:11], null
// GFX11: encoding: [0x7c,0x31,0x8a,0xbe]

s_and_not1_saveexec_b64 s[104:105], -1
// GFX11: encoding: [0xc1,0x31,0xe8,0xbe]

s_and_not1_saveexec_b64 vcc, 0.5
// GFX11: encoding: [0xf0,0x31,0xea,0xbe]

s_and_not1_saveexec_b64 ttmp[14:15], src_scc
// GFX11: encoding: [0xfd,0x31,0xfa,0xbe]

s_and_not1_saveexec_b64 null, 0xaf123456
// GFX11: encoding: [0xff,0x31,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_and_not0_saveexec_b32 s5, s1
// GFX11: encoding: [0x01,0x2c,0x85,0xbe]

s_and_not0_saveexec_b32 s5, s105
// GFX11: encoding: [0x69,0x2c,0x85,0xbe]

s_and_not0_saveexec_b32 s5, vcc_lo
// GFX11: encoding: [0x6a,0x2c,0x85,0xbe]

s_and_not0_saveexec_b32 s5, vcc_hi
// GFX11: encoding: [0x6b,0x2c,0x85,0xbe]

s_and_not0_saveexec_b32 s5, ttmp15
// GFX11: encoding: [0x7b,0x2c,0x85,0xbe]

s_and_not0_saveexec_b32 s5, exec_lo
// GFX11: encoding: [0x7e,0x2c,0x85,0xbe]

s_and_not0_saveexec_b32 s105, null
// GFX11: encoding: [0x7c,0x2c,0xe9,0xbe]

s_and_not0_saveexec_b32 vcc_lo, -1
// GFX11: encoding: [0xc1,0x2c,0xea,0xbe]

s_and_not0_saveexec_b32 vcc_hi, 0.5
// GFX11: encoding: [0xf0,0x2c,0xeb,0xbe]

s_and_not0_saveexec_b32 ttmp15, src_scc
// GFX11: encoding: [0xfd,0x2c,0xfb,0xbe]

s_and_not0_saveexec_b32 null, 0xaf123456
// GFX11: encoding: [0xff,0x2c,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_and_not0_saveexec_b64 s[10:11], s[2:3]
// GFX11: encoding: [0x02,0x2d,0x8a,0xbe]

s_and_not0_saveexec_b64 s[10:11], s[104:105]
// GFX11: encoding: [0x68,0x2d,0x8a,0xbe]

s_and_not0_saveexec_b64 s[10:11], vcc
// GFX11: encoding: [0x6a,0x2d,0x8a,0xbe]

s_and_not0_saveexec_b64 s[10:11], ttmp[14:15]
// GFX11: encoding: [0x7a,0x2d,0x8a,0xbe]

s_and_not0_saveexec_b64 s[10:11], null
// GFX11: encoding: [0x7c,0x2d,0x8a,0xbe]

s_and_not0_saveexec_b64 s[104:105], -1
// GFX11: encoding: [0xc1,0x2d,0xe8,0xbe]

s_and_not0_saveexec_b64 vcc, 0.5
// GFX11: encoding: [0xf0,0x2d,0xea,0xbe]

s_and_not0_saveexec_b64 ttmp[14:15], src_scc
// GFX11: encoding: [0xfd,0x2d,0xfa,0xbe]

s_and_not0_saveexec_b64 null, 0xaf123456
// GFX11: encoding: [0xff,0x2d,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_and_not0_wrexec_b32 s5, s1
// GFX11: encoding: [0x01,0x34,0x85,0xbe]

s_and_not0_wrexec_b32 s5, s105
// GFX11: encoding: [0x69,0x34,0x85,0xbe]

s_and_not0_wrexec_b32 s5, vcc_lo
// GFX11: encoding: [0x6a,0x34,0x85,0xbe]

s_and_not0_wrexec_b32 s5, vcc_hi
// GFX11: encoding: [0x6b,0x34,0x85,0xbe]

s_and_not0_wrexec_b32 s5, ttmp15
// GFX11: encoding: [0x7b,0x34,0x85,0xbe]

s_and_not0_wrexec_b32 s5, exec_lo
// GFX11: encoding: [0x7e,0x34,0x85,0xbe]

s_and_not0_wrexec_b32 s105, null
// GFX11: encoding: [0x7c,0x34,0xe9,0xbe]

s_and_not0_wrexec_b32 vcc_lo, -1
// GFX11: encoding: [0xc1,0x34,0xea,0xbe]

s_and_not0_wrexec_b32 vcc_hi, 0.5
// GFX11: encoding: [0xf0,0x34,0xeb,0xbe]

s_and_not0_wrexec_b32 ttmp15, src_scc
// GFX11: encoding: [0xfd,0x34,0xfb,0xbe]

s_and_not0_wrexec_b32 null, 0xaf123456
// GFX11: encoding: [0xff,0x34,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_and_not0_wrexec_b64 s[10:11], s[2:3]
// GFX11: encoding: [0x02,0x35,0x8a,0xbe]

s_and_not0_wrexec_b64 s[10:11], s[104:105]
// GFX11: encoding: [0x68,0x35,0x8a,0xbe]

s_and_not0_wrexec_b64 s[10:11], vcc
// GFX11: encoding: [0x6a,0x35,0x8a,0xbe]

s_and_not0_wrexec_b64 s[10:11], ttmp[14:15]
// GFX11: encoding: [0x7a,0x35,0x8a,0xbe]

s_and_not0_wrexec_b64 s[10:11], null
// GFX11: encoding: [0x7c,0x35,0x8a,0xbe]

s_and_not0_wrexec_b64 s[104:105], -1
// GFX11: encoding: [0xc1,0x35,0xe8,0xbe]

s_and_not0_wrexec_b64 vcc, 0.5
// GFX11: encoding: [0xf0,0x35,0xea,0xbe]

s_and_not0_wrexec_b64 ttmp[14:15], src_scc
// GFX11: encoding: [0xfd,0x35,0xfa,0xbe]

s_and_not0_wrexec_b64 null, 0xaf123456
// GFX11: encoding: [0xff,0x35,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_and_not1_saveexec_b32 s5, s1
// GFX11: encoding: [0x01,0x30,0x85,0xbe]

s_and_not1_saveexec_b32 s5, s105
// GFX11: encoding: [0x69,0x30,0x85,0xbe]

s_and_not1_saveexec_b32 s5, vcc_lo
// GFX11: encoding: [0x6a,0x30,0x85,0xbe]

s_and_not1_saveexec_b32 s5, vcc_hi
// GFX11: encoding: [0x6b,0x30,0x85,0xbe]

s_and_not1_saveexec_b32 s5, ttmp15
// GFX11: encoding: [0x7b,0x30,0x85,0xbe]

s_and_not1_saveexec_b32 s5, exec_lo
// GFX11: encoding: [0x7e,0x30,0x85,0xbe]

s_and_not1_saveexec_b32 s105, null
// GFX11: encoding: [0x7c,0x30,0xe9,0xbe]

s_and_not1_saveexec_b32 vcc_lo, -1
// GFX11: encoding: [0xc1,0x30,0xea,0xbe]

s_and_not1_saveexec_b32 vcc_hi, 0.5
// GFX11: encoding: [0xf0,0x30,0xeb,0xbe]

s_and_not1_saveexec_b32 ttmp15, src_scc
// GFX11: encoding: [0xfd,0x30,0xfb,0xbe]

s_and_not1_saveexec_b32 null, 0xaf123456
// GFX11: encoding: [0xff,0x30,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_and_not1_wrexec_b32 s5, s1
// GFX11: encoding: [0x01,0x36,0x85,0xbe]

s_and_not1_wrexec_b32 s5, s105
// GFX11: encoding: [0x69,0x36,0x85,0xbe]

s_and_not1_wrexec_b32 s5, vcc_lo
// GFX11: encoding: [0x6a,0x36,0x85,0xbe]

s_and_not1_wrexec_b32 s5, vcc_hi
// GFX11: encoding: [0x6b,0x36,0x85,0xbe]

s_and_not1_wrexec_b32 s5, ttmp15
// GFX11: encoding: [0x7b,0x36,0x85,0xbe]

s_and_not1_wrexec_b32 s5, exec_lo
// GFX11: encoding: [0x7e,0x36,0x85,0xbe]

s_and_not1_wrexec_b32 s105, null
// GFX11: encoding: [0x7c,0x36,0xe9,0xbe]

s_and_not1_wrexec_b32 vcc_lo, -1
// GFX11: encoding: [0xc1,0x36,0xea,0xbe]

s_and_not1_wrexec_b32 vcc_hi, 0.5
// GFX11: encoding: [0xf0,0x36,0xeb,0xbe]

s_and_not1_wrexec_b32 ttmp15, src_scc
// GFX11: encoding: [0xfd,0x36,0xfb,0xbe]

s_and_not1_wrexec_b32 null, 0xaf123456
// GFX11: encoding: [0xff,0x36,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_and_not1_wrexec_b64 s[10:11], s[2:3]
// GFX11: encoding: [0x02,0x37,0x8a,0xbe]

s_and_not1_wrexec_b64 s[10:11], s[104:105]
// GFX11: encoding: [0x68,0x37,0x8a,0xbe]

s_and_not1_wrexec_b64 s[10:11], vcc
// GFX11: encoding: [0x6a,0x37,0x8a,0xbe]

s_and_not1_wrexec_b64 s[10:11], ttmp[14:15]
// GFX11: encoding: [0x7a,0x37,0x8a,0xbe]

s_and_not1_wrexec_b64 s[10:11], null
// GFX11: encoding: [0x7c,0x37,0x8a,0xbe]

s_and_not1_wrexec_b64 s[104:105], -1
// GFX11: encoding: [0xc1,0x37,0xe8,0xbe]

s_and_not1_wrexec_b64 vcc, 0.5
// GFX11: encoding: [0xf0,0x37,0xea,0xbe]

s_and_not1_wrexec_b64 ttmp[14:15], src_scc
// GFX11: encoding: [0xfd,0x37,0xfa,0xbe]

s_and_not1_wrexec_b64 null, 0xaf123456
// GFX11: encoding: [0xff,0x37,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_cls_i32 s5, s1
// GFX11: encoding: [0x01,0x0c,0x85,0xbe]

s_cls_i32 s5, s105
// GFX11: encoding: [0x69,0x0c,0x85,0xbe]

s_cls_i32 s5, vcc_lo
// GFX11: encoding: [0x6a,0x0c,0x85,0xbe]

s_cls_i32 s5, vcc_hi
// GFX11: encoding: [0x6b,0x0c,0x85,0xbe]

s_cls_i32 s5, ttmp15
// GFX11: encoding: [0x7b,0x0c,0x85,0xbe]

s_cls_i32 s105, m0
// GFX11: encoding: [0x7d,0x0c,0xe9,0xbe]

s_cls_i32 vcc_lo, exec_lo
// GFX11: encoding: [0x7e,0x0c,0xea,0xbe]

s_cls_i32 vcc_hi, exec_hi
// GFX11: encoding: [0x7f,0x0c,0xeb,0xbe]

s_cls_i32 ttmp15, null
// GFX11: encoding: [0x7c,0x0c,0xfb,0xbe]

s_cls_i32 m0, -1
// GFX11: encoding: [0xc1,0x0c,0xfd,0xbe]

s_cls_i32 exec_lo, 0.5
// GFX11: encoding: [0xf0,0x0c,0xfe,0xbe]

s_cls_i32 exec_hi, src_scc
// GFX11: encoding: [0xfd,0x0c,0xff,0xbe]

s_cls_i32 null, 0xaf123456
// GFX11: encoding: [0xff,0x0c,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_cls_i32_i64 s5, s[2:3]
// GFX11: encoding: [0x02,0x0d,0x85,0xbe]

s_cls_i32_i64 s5, s[104:105]
// GFX11: encoding: [0x68,0x0d,0x85,0xbe]

s_cls_i32_i64 s105, vcc
// GFX11: encoding: [0x6a,0x0d,0xe9,0xbe]

s_cls_i32_i64 vcc_lo, ttmp[14:15]
// GFX11: encoding: [0x7a,0x0d,0xea,0xbe]

s_cls_i32_i64 vcc_hi, exec
// GFX11: encoding: [0x7e,0x0d,0xeb,0xbe]

s_cls_i32_i64 ttmp15, null
// GFX11: encoding: [0x7c,0x0d,0xfb,0xbe]

s_cls_i32_i64 m0, -1
// GFX11: encoding: [0xc1,0x0d,0xfd,0xbe]

s_cls_i32_i64 exec_lo, 0.5
// GFX11: encoding: [0xf0,0x0d,0xfe,0xbe]

s_cls_i32_i64 exec_hi, src_scc
// GFX11: encoding: [0xfd,0x0d,0xff,0xbe]

s_cls_i32_i64 null, 0xaf123456
// GFX11: encoding: [0xff,0x0d,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_clz_i32_u32 s5, s1
// GFX11: encoding: [0x01,0x0a,0x85,0xbe]

s_clz_i32_u32 s5, s105
// GFX11: encoding: [0x69,0x0a,0x85,0xbe]

s_clz_i32_u32 s5, vcc_lo
// GFX11: encoding: [0x6a,0x0a,0x85,0xbe]

s_clz_i32_u32 s5, vcc_hi
// GFX11: encoding: [0x6b,0x0a,0x85,0xbe]

s_clz_i32_u32 s5, ttmp15
// GFX11: encoding: [0x7b,0x0a,0x85,0xbe]

s_clz_i32_u32 s105, m0
// GFX11: encoding: [0x7d,0x0a,0xe9,0xbe]

s_clz_i32_u32 vcc_lo, exec_lo
// GFX11: encoding: [0x7e,0x0a,0xea,0xbe]

s_clz_i32_u32 vcc_hi, exec_hi
// GFX11: encoding: [0x7f,0x0a,0xeb,0xbe]

s_clz_i32_u32 ttmp15, null
// GFX11: encoding: [0x7c,0x0a,0xfb,0xbe]

s_clz_i32_u32 m0, -1
// GFX11: encoding: [0xc1,0x0a,0xfd,0xbe]

s_clz_i32_u32 exec_lo, 0.5
// GFX11: encoding: [0xf0,0x0a,0xfe,0xbe]

s_clz_i32_u32 exec_hi, src_scc
// GFX11: encoding: [0xfd,0x0a,0xff,0xbe]

s_clz_i32_u32 null, 0xaf123456
// GFX11: encoding: [0xff,0x0a,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_clz_i32_u64 s5, s[2:3]
// GFX11: encoding: [0x02,0x0b,0x85,0xbe]

s_clz_i32_u64 s5, s[104:105]
// GFX11: encoding: [0x68,0x0b,0x85,0xbe]

s_clz_i32_u64 s105, vcc
// GFX11: encoding: [0x6a,0x0b,0xe9,0xbe]

s_clz_i32_u64 vcc_lo, ttmp[14:15]
// GFX11: encoding: [0x7a,0x0b,0xea,0xbe]

s_clz_i32_u64 vcc_hi, exec
// GFX11: encoding: [0x7e,0x0b,0xeb,0xbe]

s_clz_i32_u64 ttmp15, null
// GFX11: encoding: [0x7c,0x0b,0xfb,0xbe]

s_clz_i32_u64 m0, -1
// GFX11: encoding: [0xc1,0x0b,0xfd,0xbe]

s_clz_i32_u64 exec_lo, 0.5
// GFX11: encoding: [0xf0,0x0b,0xfe,0xbe]

s_clz_i32_u64 exec_hi, src_scc
// GFX11: encoding: [0xfd,0x0b,0xff,0xbe]

s_clz_i32_u64 null, 0xaf123456
// GFX11: encoding: [0xff,0x0b,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_or_not0_saveexec_b32 s5, s1
// GFX11: encoding: [0x01,0x2e,0x85,0xbe]

s_or_not0_saveexec_b32 s5, s105
// GFX11: encoding: [0x69,0x2e,0x85,0xbe]

s_or_not0_saveexec_b32 s5, vcc_lo
// GFX11: encoding: [0x6a,0x2e,0x85,0xbe]

s_or_not0_saveexec_b32 s5, vcc_hi
// GFX11: encoding: [0x6b,0x2e,0x85,0xbe]

s_or_not0_saveexec_b32 s5, ttmp15
// GFX11: encoding: [0x7b,0x2e,0x85,0xbe]

s_or_not0_saveexec_b32 s5, exec_lo
// GFX11: encoding: [0x7e,0x2e,0x85,0xbe]

s_or_not0_saveexec_b32 s105, null
// GFX11: encoding: [0x7c,0x2e,0xe9,0xbe]

s_or_not0_saveexec_b32 vcc_lo, -1
// GFX11: encoding: [0xc1,0x2e,0xea,0xbe]

s_or_not0_saveexec_b32 vcc_hi, 0.5
// GFX11: encoding: [0xf0,0x2e,0xeb,0xbe]

s_or_not0_saveexec_b32 ttmp15, src_scc
// GFX11: encoding: [0xfd,0x2e,0xfb,0xbe]

s_or_not0_saveexec_b32 null, 0xaf123456
// GFX11: encoding: [0xff,0x2e,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_or_not0_saveexec_b64 s[10:11], s[2:3]
// GFX11: encoding: [0x02,0x2f,0x8a,0xbe]

s_or_not0_saveexec_b64 s[10:11], s[104:105]
// GFX11: encoding: [0x68,0x2f,0x8a,0xbe]

s_or_not0_saveexec_b64 s[10:11], vcc
// GFX11: encoding: [0x6a,0x2f,0x8a,0xbe]

s_or_not0_saveexec_b64 s[10:11], ttmp[14:15]
// GFX11: encoding: [0x7a,0x2f,0x8a,0xbe]

s_or_not0_saveexec_b64 s[10:11], null
// GFX11: encoding: [0x7c,0x2f,0x8a,0xbe]

s_or_not0_saveexec_b64 s[104:105], -1
// GFX11: encoding: [0xc1,0x2f,0xe8,0xbe]

s_or_not0_saveexec_b64 vcc, 0.5
// GFX11: encoding: [0xf0,0x2f,0xea,0xbe]

s_or_not0_saveexec_b64 ttmp[14:15], src_scc
// GFX11: encoding: [0xfd,0x2f,0xfa,0xbe]

s_or_not0_saveexec_b64 null, 0xaf123456
// GFX11: encoding: [0xff,0x2f,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_or_not1_saveexec_b32 s5, s1
// GFX11: encoding: [0x01,0x32,0x85,0xbe]

s_or_not1_saveexec_b32 s5, s105
// GFX11: encoding: [0x69,0x32,0x85,0xbe]

s_or_not1_saveexec_b32 s5, vcc_lo
// GFX11: encoding: [0x6a,0x32,0x85,0xbe]

s_or_not1_saveexec_b32 s5, vcc_hi
// GFX11: encoding: [0x6b,0x32,0x85,0xbe]

s_or_not1_saveexec_b32 s5, ttmp15
// GFX11: encoding: [0x7b,0x32,0x85,0xbe]

s_or_not1_saveexec_b32 s5, exec_lo
// GFX11: encoding: [0x7e,0x32,0x85,0xbe]

s_or_not1_saveexec_b32 s105, null
// GFX11: encoding: [0x7c,0x32,0xe9,0xbe]

s_or_not1_saveexec_b32 vcc_lo, -1
// GFX11: encoding: [0xc1,0x32,0xea,0xbe]

s_or_not1_saveexec_b32 vcc_hi, 0.5
// GFX11: encoding: [0xf0,0x32,0xeb,0xbe]

s_or_not1_saveexec_b32 ttmp15, src_scc
// GFX11: encoding: [0xfd,0x32,0xfb,0xbe]

s_or_not1_saveexec_b32 null, 0xaf123456
// GFX11: encoding: [0xff,0x32,0xfc,0xbe,0x56,0x34,0x12,0xaf]

s_or_not1_saveexec_b64 s[10:11], s[2:3]
// GFX11: encoding: [0x02,0x33,0x8a,0xbe]

s_or_not1_saveexec_b64 s[10:11], s[104:105]
// GFX11: encoding: [0x68,0x33,0x8a,0xbe]

s_or_not1_saveexec_b64 s[10:11], vcc
// GFX11: encoding: [0x6a,0x33,0x8a,0xbe]

s_or_not1_saveexec_b64 s[10:11], ttmp[14:15]
// GFX11: encoding: [0x7a,0x33,0x8a,0xbe]

s_or_not1_saveexec_b64 s[10:11], null
// GFX11: encoding: [0x7c,0x33,0x8a,0xbe]

s_or_not1_saveexec_b64 s[104:105], -1
// GFX11: encoding: [0xc1,0x33,0xe8,0xbe]

s_or_not1_saveexec_b64 vcc, 0.5
// GFX11: encoding: [0xf0,0x33,0xea,0xbe]

s_or_not1_saveexec_b64 ttmp[14:15], src_scc
// GFX11: encoding: [0xfd,0x33,0xfa,0xbe]

s_or_not1_saveexec_b64 null, 0xaf123456
// GFX11: encoding: [0xff,0x33,0xfc,0xbe,0x56,0x34,0x12,0xaf]
