# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=sapphirerapids -instruction-tables < %s | FileCheck %s

vpopcntb        %zmm1, %zmm0
vpopcntb        (%rdi), %zmm0
vpopcntb        %zmm1, %zmm0 {%k1}
vpopcntb        (%rdi), %zmm0 {%k1}
vpopcntb        %zmm1, %zmm0 {%k1} {z}
vpopcntb        (%rdi), %zmm0 {%k1} {z}

vpopcntw        %zmm1, %zmm0
vpopcntw        (%rdi), %zmm0
vpopcntw        %zmm1, %zmm0 {%k1}
vpopcntw        (%rdi), %zmm0 {%k1}
vpopcntw        %zmm1, %zmm0 {%k1} {z}
vpopcntw        (%rdi), %zmm0 {%k1} {z}

vpshufbitqmb    %zmm16, %zmm17, %k2
vpshufbitqmb    (%rdi), %zmm17, %k2
vpshufbitqmb    %zmm16, %zmm17, %k2 {%k1}
vpshufbitqmb    (%rdi), %zmm17, %k2 {%k1}

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     1.00                        vpopcntb	%zmm1, %zmm0
# CHECK-NEXT:  2      11    1.00    *                   vpopcntb	(%rdi), %zmm0
# CHECK-NEXT:  1      5     1.00                        vpopcntb	%zmm1, %zmm0 {%k1}
# CHECK-NEXT:  2      13    1.00    *                   vpopcntb	(%rdi), %zmm0 {%k1}
# CHECK-NEXT:  1      5     1.00                        vpopcntb	%zmm1, %zmm0 {%k1} {z}
# CHECK-NEXT:  2      13    1.00    *                   vpopcntb	(%rdi), %zmm0 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                        vpopcntw	%zmm1, %zmm0
# CHECK-NEXT:  2      11    1.00    *                   vpopcntw	(%rdi), %zmm0
# CHECK-NEXT:  1      5     1.00                        vpopcntw	%zmm1, %zmm0 {%k1}
# CHECK-NEXT:  2      13    1.00    *                   vpopcntw	(%rdi), %zmm0 {%k1}
# CHECK-NEXT:  1      5     1.00                        vpopcntw	%zmm1, %zmm0 {%k1} {z}
# CHECK-NEXT:  2      13    1.00    *                   vpopcntw	(%rdi), %zmm0 {%k1} {z}
# CHECK-NEXT:  2      6     1.00                        vpshufbitqmb	%zmm16, %zmm17, %k2
# CHECK-NEXT:  3      6     1.00    *                   vpshufbitqmb	(%rdi), %zmm17, %k2
# CHECK-NEXT:  2      8     1.00                        vpshufbitqmb	%zmm16, %zmm17, %k2 {%k1}
# CHECK-NEXT:  3      8     1.00    *                   vpshufbitqmb	(%rdi), %zmm17, %k2 {%k1}

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SPRPort00
# CHECK-NEXT: [1]   - SPRPort01
# CHECK-NEXT: [2]   - SPRPort02
# CHECK-NEXT: [3]   - SPRPort03
# CHECK-NEXT: [4]   - SPRPort04
# CHECK-NEXT: [5]   - SPRPort05
# CHECK-NEXT: [6]   - SPRPort06
# CHECK-NEXT: [7]   - SPRPort07
# CHECK-NEXT: [8]   - SPRPort08
# CHECK-NEXT: [9]   - SPRPort09
# CHECK-NEXT: [10]  - SPRPort10
# CHECK-NEXT: [11]  - SPRPort11
# CHECK-NEXT: [12]  - SPRPortInvalid

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]
# CHECK-NEXT: 4.00    -     2.67   2.67    -     16.00   -      -      -      -      -     2.67    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   Instructions:
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -     vpopcntb	%zmm1, %zmm0
# CHECK-NEXT:  -      -     0.33   0.33    -     1.00    -      -      -      -      -     0.33    -     vpopcntb	(%rdi), %zmm0
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -     vpopcntb	%zmm1, %zmm0 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -     1.00    -      -      -      -      -     0.33    -     vpopcntb	(%rdi), %zmm0 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -     vpopcntb	%zmm1, %zmm0 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -     1.00    -      -      -      -      -     0.33    -     vpopcntb	(%rdi), %zmm0 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -     vpopcntw	%zmm1, %zmm0
# CHECK-NEXT:  -      -     0.33   0.33    -     1.00    -      -      -      -      -     0.33    -     vpopcntw	(%rdi), %zmm0
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -     vpopcntw	%zmm1, %zmm0 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -     1.00    -      -      -      -      -     0.33    -     vpopcntw	(%rdi), %zmm0 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -     vpopcntw	%zmm1, %zmm0 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -     1.00    -      -      -      -      -     0.33    -     vpopcntw	(%rdi), %zmm0 {%k1} {z}
# CHECK-NEXT: 1.00    -      -      -      -     1.00    -      -      -      -      -      -      -     vpshufbitqmb	%zmm16, %zmm17, %k2
# CHECK-NEXT: 1.00    -     0.33   0.33    -     1.00    -      -      -      -      -     0.33    -     vpshufbitqmb	(%rdi), %zmm17, %k2
# CHECK-NEXT: 1.00    -      -      -      -     1.00    -      -      -      -      -      -      -     vpshufbitqmb	%zmm16, %zmm17, %k2 {%k1}
# CHECK-NEXT: 1.00    -     0.33   0.33    -     1.00    -      -      -      -      -     0.33    -     vpshufbitqmb	(%rdi), %zmm17, %k2 {%k1}
