; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 2
; RUN: opt -disable-output "-passes=print<scalar-evolution>" < %s 2>&1 | FileCheck %s --check-prefix=DEFAULT
; RUN: opt -disable-output "-passes=print<scalar-evolution>" -scalar-evolution-use-expensive-range-sharpening < %s 2>&1 | FileCheck %s  --check-prefix=EXPENSIVE_SHARPENING

; This test exercises the following scenario:
; given: n > 0
; for (i = 0, j = n - 1; i < n; i++, j--) {
;   a = n - i;
;   b = (n - 1) - i;
;   c = 2147483647 - 1;
; }
;
; Note that value ranges of 'i' and 'j' are the same, just inverted. It means that
; they have same ranges and same no-wrap properties. 'b' is just an alternative
; way to compute the same value as 'j'. 'a' is effectively 'j + 1' and 'c' is a
; a positive value. All involved addrecs for 'i', 'j', 'a', 'b', 'c' should have
; no-sign-wrap flag.
;
;        i's AddRec is expected to be proven no-sign-wrap
;        j's AddRec is expected to be proven no-sign-wrap
; FIXME: a's AddRec is expected to be no-sign-wrap
;        b's AddRec is expected to be no-sign-wrap
; FIXME: c's AddRec is expected to be no-sign-wrap
;        i is expected to be non-negative
;        j is expected to be non-negative
;        a is expected to be positive
;        b is expected to be non-negative
;        c is expected to be positive
define i32 @test_step_1_flags(i32 %n) {
; DEFAULT-LABEL: 'test_step_1_flags'
; DEFAULT-NEXT:  Classifying expressions for: @test_step_1_flags
; DEFAULT-NEXT:    %n.minus.1 = sub nsw i32 %n, 1
; DEFAULT-NEXT:    --> (-1 + %n) U: full-set S: full-set
; DEFAULT-NEXT:    %i = phi i32 [ 0, %entry ], [ %i.next, %loop ]
; DEFAULT-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,2147483647) S: [0,2147483647) Exits: (-1 + %n) LoopDispositions: { %loop: Computable }
; DEFAULT-NEXT:    %j = phi i32 [ %n.minus.1, %entry ], [ %j.next, %loop ]
; DEFAULT-NEXT:    --> {(-1 + %n),+,-1}<nsw><%loop> U: full-set S: full-set Exits: 0 LoopDispositions: { %loop: Computable }
; DEFAULT-NEXT:    %a = sub i32 %n, %i
; DEFAULT-NEXT:    --> {%n,+,-1}<nw><%loop> U: full-set S: full-set Exits: 1 LoopDispositions: { %loop: Computable }
; DEFAULT-NEXT:    %b = sub i32 %n.minus.1, %i
; DEFAULT-NEXT:    --> {(-1 + %n),+,-1}<nsw><%loop> U: full-set S: full-set Exits: 0 LoopDispositions: { %loop: Computable }
; DEFAULT-NEXT:    %c = sub i32 2147483647, %i
; DEFAULT-NEXT:    --> {2147483647,+,-1}<nsw><%loop> U: [1,-2147483648) S: [1,-2147483648) Exits: (-2147483648 + (-1 * %n)) LoopDispositions: { %loop: Computable }
; DEFAULT-NEXT:    %i.next = add nuw nsw i32 %i, 1
; DEFAULT-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,-2147483648) S: [1,-2147483648) Exits: %n LoopDispositions: { %loop: Computable }
; DEFAULT-NEXT:    %j.next = add nsw i32 %j, -1
; DEFAULT-NEXT:    --> {(-2 + %n),+,-1}<nw><%loop> U: full-set S: full-set Exits: -1 LoopDispositions: { %loop: Computable }
; DEFAULT-NEXT:  Determining loop execution counts for: @test_step_1_flags
; DEFAULT-NEXT:  Loop %loop: backedge-taken count is (-1 + %n)
; DEFAULT-NEXT:  Loop %loop: constant max backedge-taken count is 2147483646
; DEFAULT-NEXT:  Loop %loop: symbolic max backedge-taken count is (-1 + %n)
; DEFAULT-NEXT:  Loop %loop: Predicated backedge-taken count is (-1 + %n)
; DEFAULT-NEXT:   Predicates:
; DEFAULT-NEXT:  Loop %loop: Trip multiple is 1
;
; EXPENSIVE_SHARPENING-LABEL: 'test_step_1_flags'
; EXPENSIVE_SHARPENING-NEXT:  Classifying expressions for: @test_step_1_flags
; EXPENSIVE_SHARPENING-NEXT:    %n.minus.1 = sub nsw i32 %n, 1
; EXPENSIVE_SHARPENING-NEXT:    --> (-1 + %n) U: full-set S: full-set
; EXPENSIVE_SHARPENING-NEXT:    %i = phi i32 [ 0, %entry ], [ %i.next, %loop ]
; EXPENSIVE_SHARPENING-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,2147483647) S: [0,2147483647) Exits: (-1 + %n) LoopDispositions: { %loop: Computable }
; EXPENSIVE_SHARPENING-NEXT:    %j = phi i32 [ %n.minus.1, %entry ], [ %j.next, %loop ]
; EXPENSIVE_SHARPENING-NEXT:    --> {(-1 + %n),+,-1}<nsw><%loop> U: [0,2147483647) S: [0,2147483647) Exits: 0 LoopDispositions: { %loop: Computable }
; EXPENSIVE_SHARPENING-NEXT:    %a = sub i32 %n, %i
; EXPENSIVE_SHARPENING-NEXT:    --> {%n,+,-1}<nw><%loop> U: [1,-2147483648) S: [1,-2147483648) Exits: 1 LoopDispositions: { %loop: Computable }
; EXPENSIVE_SHARPENING-NEXT:    %b = sub i32 %n.minus.1, %i
; EXPENSIVE_SHARPENING-NEXT:    --> {(-1 + %n),+,-1}<nsw><%loop> U: [0,2147483647) S: [0,2147483647) Exits: 0 LoopDispositions: { %loop: Computable }
; EXPENSIVE_SHARPENING-NEXT:    %c = sub i32 2147483647, %i
; EXPENSIVE_SHARPENING-NEXT:    --> {2147483647,+,-1}<nsw><%loop> U: [1,-2147483648) S: [1,-2147483648) Exits: (-2147483648 + (-1 * %n)) LoopDispositions: { %loop: Computable }
; EXPENSIVE_SHARPENING-NEXT:    %i.next = add nuw nsw i32 %i, 1
; EXPENSIVE_SHARPENING-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,-2147483648) S: [1,-2147483648) Exits: %n LoopDispositions: { %loop: Computable }
; EXPENSIVE_SHARPENING-NEXT:    %j.next = add nsw i32 %j, -1
; EXPENSIVE_SHARPENING-NEXT:    --> {(-2 + %n),+,-1}<nsw><%loop> U: full-set S: [-1,2147483646) Exits: -1 LoopDispositions: { %loop: Computable }
; EXPENSIVE_SHARPENING-NEXT:  Determining loop execution counts for: @test_step_1_flags
; EXPENSIVE_SHARPENING-NEXT:  Loop %loop: backedge-taken count is (-1 + %n)
; EXPENSIVE_SHARPENING-NEXT:  Loop %loop: constant max backedge-taken count is 2147483646
; EXPENSIVE_SHARPENING-NEXT:  Loop %loop: symbolic max backedge-taken count is (-1 + %n)
; EXPENSIVE_SHARPENING-NEXT:  Loop %loop: Predicated backedge-taken count is (-1 + %n)
; EXPENSIVE_SHARPENING-NEXT:   Predicates:
; EXPENSIVE_SHARPENING-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  %n.minus.1 = sub nsw i32 %n, 1
  %precond = icmp sgt i32 %n, 0
  br i1 %precond, label %loop, label %fail

loop:
  %i = phi i32 [0, %entry], [%i.next, %loop]                      ; 0...n-1
  %j = phi i32 [%n.minus.1, %entry], [%j.next, %loop]             ; n-1...0
  %a = sub i32 %n, %i                                             ; n...1
  %b = sub i32 %n.minus.1, %i                                     ; n-1...0
  %c = sub i32 2147483647, %i                                     ; 2147483647...1
  %i.next = add nuw nsw i32 %i, 1
  %j.next = add nsw i32 %j, -1
  %cond = icmp slt i32 %i.next, %n
  br i1 %cond, label %loop, label %exit

fail:
  ret i32 -1

exit:
  ret i32 0
}
