; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --include-generated-funcs
; RUN: opt -S -passes=verify,iroutliner -ir-outlining-no-cost < %s | FileCheck %s

; Show that we do not outline when all of the phi nodes in the beginning
; block are included not in the region.

define void @function1(ptr %a, ptr %b) {
entry:
  %0 = alloca i32, align 4
  %c = load i32, ptr %0, align 4
  %y = add i32 %c, %c
  br label %test1
dummy:
  ret void
test1:
  %1 = phi i32 [ %e, %test1 ], [ %y, %entry ]
  %2 = phi i32 [ %e, %test1 ], [ %y, %entry  ]
  %e = load i32, ptr %0, align 4
  %3 = add i32 %c, %c
  br i1 true, label %test, label %test1
test:
  %d = load i32, ptr %0, align 4
  br label %first
first:
  ret void
}

define void @function2(ptr %a, ptr %b) {
entry:
  %0 = alloca i32, align 4
  %c = load i32, ptr %0, align 4
  %y = mul i32 %c, %c
  br label %test1
dummy:
  ret void
test1:
  %1 = phi i32 [ %e, %test1 ], [ %y, %entry ]
  %2 = phi i32 [ %y, %entry ], [ %e, %test1 ]
  %e = load i32, ptr %0, align 4
  %3 = add i32 %c, %c
  br i1 true, label %test, label %test1
test:
  %d = load i32, ptr %0, align 4
  br label %first
first:
  ret void
}
; CHECK-LABEL: @function1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[E_LOC:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[TMP0:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = load i32, ptr [[TMP0]], align 4
; CHECK-NEXT:    [[Y:%.*]] = add i32 [[C]], [[C]]
; CHECK-NEXT:    br label [[TEST1:%.*]]
; CHECK:       dummy:
; CHECK-NEXT:    ret void
; CHECK:       test1:
; CHECK-NEXT:    [[TMP1:%.*]] = phi i32 [ [[E_RELOAD:%.*]], [[TEST1]] ], [ [[Y]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = phi i32 [ [[E_RELOAD]], [[TEST1]] ], [ [[Y]], [[ENTRY]] ]
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[E_LOC]])
; CHECK-NEXT:    [[TARGETBLOCK:%.*]] = call i1 @outlined_ir_func_0(ptr [[TMP0]], i32 [[C]], ptr [[E_LOC]])
; CHECK-NEXT:    [[E_RELOAD]] = load i32, ptr [[E_LOC]], align 4
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[E_LOC]])
; CHECK-NEXT:    br i1 [[TARGETBLOCK]], label [[TEST1]], label [[FIRST:%.*]]
; CHECK:       first:
; CHECK-NEXT:    ret void
;
;
; CHECK-LABEL: @function2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[E_LOC:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[TMP0:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = load i32, ptr [[TMP0]], align 4
; CHECK-NEXT:    [[Y:%.*]] = mul i32 [[C]], [[C]]
; CHECK-NEXT:    br label [[TEST1:%.*]]
; CHECK:       dummy:
; CHECK-NEXT:    ret void
; CHECK:       test1:
; CHECK-NEXT:    [[TMP1:%.*]] = phi i32 [ [[E_RELOAD:%.*]], [[TEST1]] ], [ [[Y]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = phi i32 [ [[Y]], [[ENTRY]] ], [ [[E_RELOAD]], [[TEST1]] ]
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[E_LOC]])
; CHECK-NEXT:    [[TARGETBLOCK:%.*]] = call i1 @outlined_ir_func_0(ptr [[TMP0]], i32 [[C]], ptr [[E_LOC]])
; CHECK-NEXT:    [[E_RELOAD]] = load i32, ptr [[E_LOC]], align 4
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[E_LOC]])
; CHECK-NEXT:    br i1 [[TARGETBLOCK]], label [[TEST1]], label [[FIRST:%.*]]
; CHECK:       first:
; CHECK-NEXT:    ret void
;
;
; CHECK: define internal i1 @outlined_ir_func_0(
; CHECK-NEXT:  newFuncRoot:
; CHECK-NEXT:    br label [[TEST1_TO_OUTLINE:%.*]]
; CHECK:       test1_to_outline:
; CHECK-NEXT:    [[E:%.*]] = load i32, ptr [[TMP0:%.*]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = add i32 [[TMP1:%.*]], [[TMP1]]
; CHECK-NEXT:    br i1 true, label [[TEST:%.*]], label [[TEST1_EXITSTUB:%.*]]
; CHECK:       test:
; CHECK-NEXT:    [[D:%.*]] = load i32, ptr [[TMP0]], align 4
; CHECK-NEXT:    br label [[FIRST_EXITSTUB:%.*]]
; CHECK:       test1.exitStub:
; CHECK-NEXT:    store i32 [[E]], ptr [[TMP2:%.*]], align 4
; CHECK-NEXT:    ret i1 true
; CHECK:       first.exitStub:
; CHECK-NEXT:    store i32 [[E]], ptr [[TMP2]], align 4
; CHECK-NEXT:    ret i1 false
;
