; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=reassociate -S | FileCheck %s

; We cannot preserve nuw flags for mul
define i4 @nuw_preserve_negative(i4 %a, i4 %b, i4 %c) {
; CHECK-LABEL: define i4 @nuw_preserve_negative(
; CHECK-SAME: i4 [[A:%.*]], i4 [[B:%.*]], i4 [[C:%.*]]) {
; CHECK-NEXT:    [[V0:%.*]] = mul i4 [[B]], [[A]]
; CHECK-NEXT:    [[V1:%.*]] = mul i4 [[V0]], [[C]]
; CHECK-NEXT:    ret i4 [[V1]]
;
  %v0 = mul nuw i4 %a, %c
  %v1 = mul nuw i4 %v0, %b
  ret i4 %v1
}

; TODO: we can add nuw flags if we know all operands are non-zero.
define i4 @nuw_preserve_non_zero(i4 %a, i4 %b, i4 %c) {
; CHECK-LABEL: define i4 @nuw_preserve_non_zero(
; CHECK-SAME: i4 [[A:%.*]], i4 [[B:%.*]], i4 [[C:%.*]]) {
; CHECK-NEXT:    [[A0:%.*]] = add nuw i4 [[A]], 1
; CHECK-NEXT:    [[B0:%.*]] = add nuw i4 [[B]], 1
; CHECK-NEXT:    [[C0:%.*]] = add nuw i4 [[C]], 1
; CHECK-NEXT:    [[V0:%.*]] = mul i4 [[B0]], [[A0]]
; CHECK-NEXT:    [[V1:%.*]] = mul i4 [[V0]], [[C0]]
; CHECK-NEXT:    ret i4 [[V1]]
;
  %a0 = add nuw i4 %a, 1
  %b0 = add nuw i4 %b, 1
  %c0 = add nuw i4 %c, 1
  %v0 = mul nuw i4 %a0, %c0
  %v1 = mul nuw i4 %v0, %b0
  ret i4 %v1
}
