; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64 -mattr=+sve2 -verify-machineinstrs %s -o - | FileCheck %s

define <vscale x 2 x i64> @add_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: add_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    add z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %y, <vscale x 2 x i64> zeroinitializer
  %b = add <vscale x 2 x i64> %a, %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @add_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: add_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    add z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %y, <vscale x 4 x i32> zeroinitializer
  %b = add <vscale x 4 x i32> %a, %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @add_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: add_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    add z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %y, <vscale x 8 x i16> zeroinitializer
  %b = add <vscale x 8 x i16> %a, %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @add_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: add_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    add z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %y, <vscale x 16 x i8> zeroinitializer
  %b = add <vscale x 16 x i8> %a, %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @sub_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: sub_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    sub z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %y, <vscale x 2 x i64> zeroinitializer
  %b = sub <vscale x 2 x i64> %x, %a
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @sub_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: sub_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    sub z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %y, <vscale x 4 x i32> zeroinitializer
  %b = sub <vscale x 4 x i32> %x, %a
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @sub_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: sub_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    sub z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %y, <vscale x 8 x i16> zeroinitializer
  %b = sub <vscale x 8 x i16> %x, %a
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @sub_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: sub_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    sub z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %y, <vscale x 16 x i8> zeroinitializer
  %b = sub <vscale x 16 x i8> %x, %a
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @mul_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: mul_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    mul z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %y, <vscale x 2 x i64> splat (i64 1)
  %b = mul <vscale x 2 x i64> %a, %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @mul_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: mul_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    mul z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %y, <vscale x 4 x i32> splat (i32 1)
  %b = mul <vscale x 4 x i32> %a, %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mul_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: mul_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    mul z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %y, <vscale x 8 x i16> splat (i16 1)
  %b = mul <vscale x 8 x i16> %a, %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mul_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: mul_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    mul z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %y, <vscale x 16 x i8> splat (i8 1)
  %b = mul <vscale x 16 x i8> %a, %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @and_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: and_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    and z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %y, <vscale x 2 x i64> splat (i64 -1)
  %b = and <vscale x 2 x i64> %a, %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @and_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: and_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    and z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %y, <vscale x 4 x i32> splat (i32 -1)
  %b = and <vscale x 4 x i32> %a, %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @and_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: and_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    and z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %y, <vscale x 8 x i16> splat (i16 -1)
  %b = and <vscale x 8 x i16> %a, %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @and_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: and_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    and z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %y, <vscale x 16 x i8> splat (i8 -1)
  %b = and <vscale x 16 x i8> %a, %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @or_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: or_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    orr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %y, <vscale x 2 x i64> zeroinitializer
  %b = or <vscale x 2 x i64> %a, %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @or_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: or_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    orr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %y, <vscale x 4 x i32> zeroinitializer
  %b = or <vscale x 4 x i32> %a, %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @or_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: or_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    orr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %y, <vscale x 8 x i16> zeroinitializer
  %b = or <vscale x 8 x i16> %a, %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @or_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: or_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    orr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %y, <vscale x 16 x i8> zeroinitializer
  %b = or <vscale x 16 x i8> %a, %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @xor_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: xor_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    eor z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %y, <vscale x 2 x i64> zeroinitializer
  %b = xor <vscale x 2 x i64> %a, %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @xor_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: xor_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    eor z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %y, <vscale x 4 x i32> zeroinitializer
  %b = xor <vscale x 4 x i32> %a, %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @xor_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: xor_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    eor z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %y, <vscale x 8 x i16> zeroinitializer
  %b = xor <vscale x 8 x i16> %a, %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @xor_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: xor_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    eor z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %y, <vscale x 16 x i8> zeroinitializer
  %b = xor <vscale x 16 x i8> %a, %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @shl_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: shl_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p1.d, p0/z, z2.d, #0
; CHECK-NEXT:    lslr z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, p1/m, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %y, <vscale x 2 x i64> zeroinitializer
  %b = shl <vscale x 2 x i64> %x, %a
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @shl_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: shl_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    lslr z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %y, <vscale x 4 x i32> zeroinitializer
  %b = shl <vscale x 4 x i32> %x, %a
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @shl_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: shl_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p1.h, p0/z, z2.h, #0
; CHECK-NEXT:    lslr z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %y, <vscale x 8 x i16> zeroinitializer
  %b = shl <vscale x 8 x i16> %x, %a
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @shl_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: shl_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p1.b, p0/z, z2.b, #0
; CHECK-NEXT:    lslr z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.b, p1/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %y, <vscale x 16 x i8> zeroinitializer
  %b = shl <vscale x 16 x i8> %x, %a
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @ashr_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: ashr_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p1.d, p0/z, z2.d, #0
; CHECK-NEXT:    asrr z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, p1/m, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %y, <vscale x 2 x i64> zeroinitializer
  %b = ashr <vscale x 2 x i64> %x, %a
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @ashr_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: ashr_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    asrr z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %y, <vscale x 4 x i32> zeroinitializer
  %b = ashr <vscale x 4 x i32> %x, %a
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @ashr_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: ashr_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p1.h, p0/z, z2.h, #0
; CHECK-NEXT:    asrr z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %y, <vscale x 8 x i16> zeroinitializer
  %b = ashr <vscale x 8 x i16> %x, %a
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @ashr_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: ashr_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p1.b, p0/z, z2.b, #0
; CHECK-NEXT:    asrr z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.b, p1/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %y, <vscale x 16 x i8> zeroinitializer
  %b = ashr <vscale x 16 x i8> %x, %a
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @lshr_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: lshr_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p1.d, p0/z, z2.d, #0
; CHECK-NEXT:    lsrr z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, p1/m, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %y, <vscale x 2 x i64> zeroinitializer
  %b = lshr <vscale x 2 x i64> %x, %a
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @lshr_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: lshr_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    lsrr z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %y, <vscale x 4 x i32> zeroinitializer
  %b = lshr <vscale x 4 x i32> %x, %a
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @lshr_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: lshr_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p1.h, p0/z, z2.h, #0
; CHECK-NEXT:    lsrr z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %y, <vscale x 8 x i16> zeroinitializer
  %b = lshr <vscale x 8 x i16> %x, %a
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @lshr_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: lshr_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p1.b, p0/z, z2.b, #0
; CHECK-NEXT:    lsrr z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.b, p1/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %y, <vscale x 16 x i8> zeroinitializer
  %b = lshr <vscale x 16 x i8> %x, %a
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @mla_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %z, <vscale x 2 x i64> %n) {
; CHECK-LABEL: mla_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z3.d, #0
; CHECK-NEXT:    mla z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %m = mul <vscale x 2 x i64> %y, %z
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %m, <vscale x 2 x i64> zeroinitializer
  %b = add <vscale x 2 x i64> %a, %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @mla_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %z, <vscale x 4 x i32> %n) {
; CHECK-LABEL: mla_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z3.s, #0
; CHECK-NEXT:    mla z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %m = mul <vscale x 4 x i32> %y, %z
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %m, <vscale x 4 x i32> zeroinitializer
  %b = add <vscale x 4 x i32> %a, %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mla_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %z, <vscale x 8 x i16> %n) {
; CHECK-LABEL: mla_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z3.h, #0
; CHECK-NEXT:    mla z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %m = mul <vscale x 8 x i16> %y, %z
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %m, <vscale x 8 x i16> zeroinitializer
  %b = add <vscale x 8 x i16> %a, %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mla_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %z, <vscale x 16 x i8> %n) {
; CHECK-LABEL: mla_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z3.b, #0
; CHECK-NEXT:    mla z0.b, p0/m, z1.b, z2.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %m = mul <vscale x 16 x i8> %y, %z
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %m, <vscale x 16 x i8> zeroinitializer
  %b = add <vscale x 16 x i8> %a, %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @mls_nxv2i64_x(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %z, <vscale x 2 x i64> %n) {
; CHECK-LABEL: mls_nxv2i64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z3.d, #0
; CHECK-NEXT:    msb z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %m = mul <vscale x 2 x i64> %x, %y
  %a = sub <vscale x 2 x i64> %z, %m
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %x
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @mls_nxv4i32_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %z, <vscale x 4 x i32> %n) {
; CHECK-LABEL: mls_nxv4i32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z3.s, #0
; CHECK-NEXT:    msb z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %m = mul <vscale x 4 x i32> %x, %y
  %a = sub <vscale x 4 x i32> %z, %m
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %x
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mls_nxv8i16_x(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %z, <vscale x 8 x i16> %n) {
; CHECK-LABEL: mls_nxv8i16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z3.h, #0
; CHECK-NEXT:    msb z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %m = mul <vscale x 8 x i16> %x, %y
  %a = sub <vscale x 8 x i16> %z, %m
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %x
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mls_nxv16i8_x(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %z, <vscale x 16 x i8> %n) {
; CHECK-LABEL: mls_nxv16i8_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z3.b, #0
; CHECK-NEXT:    msb z0.b, p0/m, z1.b, z2.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %m = mul <vscale x 16 x i8> %x, %y
  %a = sub <vscale x 16 x i8> %z, %m
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %x
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x float> @fadd_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fadd_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x float> %y, <vscale x 4 x float> splat (float -0.000000e+00)
  %b = fadd <vscale x 4 x float> %a, %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fadd_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fadd_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x half> %y, <vscale x 8 x half> splat (half 0xH8000)
  %b = fadd <vscale x 8 x half> %a, %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fadd_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fadd_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x double> %y, <vscale x 2 x double> splat (double -0.000000e+00)
  %b = fadd <vscale x 2 x double> %a, %x
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fsub_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fsub_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fsub z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x float> %y, <vscale x 4 x float> zeroinitializer
  %b = fsub <vscale x 4 x float> %x, %a
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fsub_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fsub_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x half> %y, <vscale x 8 x half> zeroinitializer
  %b = fsub <vscale x 8 x half> %x, %a
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fsub_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fsub_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fsub z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x double> %y, <vscale x 2 x double> zeroinitializer
  %b = fsub <vscale x 2 x double> %x, %a
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fmul_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fmul_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x float> %y, <vscale x 4 x float> splat (float 1.000000e+00)
  %b = fmul <vscale x 4 x float> %a, %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fmul_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fmul_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x half> %y, <vscale x 8 x half> splat (half 0xH3C00)
  %b = fmul <vscale x 8 x half> %a, %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fmul_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fmul_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmul z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x double> %y, <vscale x 2 x double> splat (double 1.000000e+00)
  %b = fmul <vscale x 2 x double> %a, %x
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fdiv_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fdiv_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fdivr z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x float> %y, <vscale x 4 x float> splat (float 1.000000e+00)
  %b = fdiv <vscale x 4 x float> %x, %a
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fdiv_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fdiv_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fdivr z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x half> %y, <vscale x 8 x half> splat (half 0xH3C00)
  %b = fdiv <vscale x 8 x half> %x, %a
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fdiv_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fdiv_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fdivr z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    mov z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x double> %y, <vscale x 2 x double> splat (double 1.000000e+00)
  %b = fdiv <vscale x 2 x double> %x, %a
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fma_nxv4f32_x(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %z, <vscale x 4 x float> %n) {
; CHECK-LABEL: fma_nxv4f32_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z3.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmla z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %m = fmul fast <vscale x 4 x float> %y, %z
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x float> %m, <vscale x 4 x float> splat (float -0.000000e+00)
  %b = fadd fast <vscale x 4 x float> %a, %x
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fma_nxv8f16_x(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %z, <vscale x 8 x half> %n) {
; CHECK-LABEL: fma_nxv8f16_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z3.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmla z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %m = fmul fast <vscale x 8 x half> %y, %z
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x half> %m, <vscale x 8 x half> splat (half 0xH8000)
  %b = fadd fast <vscale x 8 x half> %a, %x
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fma_nxv2f64_x(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %z, <vscale x 2 x double> %n) {
; CHECK-LABEL: fma_nxv2f64_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z3.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmla z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %m = fmul fast <vscale x 2 x double> %y, %z
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x double> %m, <vscale x 2 x double> splat (double -0.000000e+00)
  %b = fadd fast <vscale x 2 x double> %a, %x
  ret <vscale x 2 x double> %b
}

define <vscale x 2 x i64> @add_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: add_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    add z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %x, <vscale x 2 x i64> zeroinitializer
  %b = add <vscale x 2 x i64> %a, %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @add_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: add_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    add z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %x, <vscale x 4 x i32> zeroinitializer
  %b = add <vscale x 4 x i32> %a, %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @add_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: add_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    add z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %x, <vscale x 8 x i16> zeroinitializer
  %b = add <vscale x 8 x i16> %a, %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @add_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: add_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    add z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %x, <vscale x 16 x i8> zeroinitializer
  %b = add <vscale x 16 x i8> %a, %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @sub_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: sub_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    sub z0.d, z0.d, z1.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = sub <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @sub_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: sub_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sub z0.s, z0.s, z1.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = sub <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @sub_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: sub_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    sub z0.h, z0.h, z1.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = sub <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @sub_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: sub_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    sub z0.b, z0.b, z1.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    sel z0.b, p0, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = sub <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @mul_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: mul_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    mul z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %x, <vscale x 2 x i64> splat (i64 1)
  %b = mul <vscale x 2 x i64> %a, %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @mul_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: mul_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    mul z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %x, <vscale x 4 x i32> splat (i32 1)
  %b = mul <vscale x 4 x i32> %a, %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mul_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: mul_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    mul z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %x, <vscale x 8 x i16> splat (i16 1)
  %b = mul <vscale x 8 x i16> %a, %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mul_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: mul_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    mul z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %x, <vscale x 16 x i8> splat (i8 1)
  %b = mul <vscale x 16 x i8> %a, %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @and_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: and_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    and z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %x, <vscale x 2 x i64> splat (i64 -1)
  %b = and <vscale x 2 x i64> %a, %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @and_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: and_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    and z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %x, <vscale x 4 x i32> splat (i32 -1)
  %b = and <vscale x 4 x i32> %a, %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @and_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: and_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    and z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %x, <vscale x 8 x i16> splat (i16 -1)
  %b = and <vscale x 8 x i16> %a, %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @and_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: and_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    and z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %x, <vscale x 16 x i8> splat (i8 -1)
  %b = and <vscale x 16 x i8> %a, %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @or_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: or_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    orr z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %x, <vscale x 2 x i64> zeroinitializer
  %b = or <vscale x 2 x i64> %a, %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @or_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: or_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    orr z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %x, <vscale x 4 x i32> zeroinitializer
  %b = or <vscale x 4 x i32> %a, %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @or_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: or_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    orr z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %x, <vscale x 8 x i16> zeroinitializer
  %b = or <vscale x 8 x i16> %a, %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @or_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: or_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    orr z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %x, <vscale x 16 x i8> zeroinitializer
  %b = or <vscale x 16 x i8> %a, %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @xor_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: xor_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    eor z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %x, <vscale x 2 x i64> zeroinitializer
  %b = xor <vscale x 2 x i64> %a, %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @xor_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: xor_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    eor z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %x, <vscale x 4 x i32> zeroinitializer
  %b = xor <vscale x 4 x i32> %a, %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @xor_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: xor_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    eor z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %x, <vscale x 8 x i16> zeroinitializer
  %b = xor <vscale x 8 x i16> %a, %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @xor_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: xor_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z2.b, #0
; CHECK-NEXT:    eor z1.b, p0/m, z1.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %x, <vscale x 16 x i8> zeroinitializer
  %b = xor <vscale x 16 x i8> %a, %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @shl_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: shl_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p1.d, p0/z, z2.d, #0
; CHECK-NEXT:    lsl z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    sel z0.d, p1, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = shl <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @shl_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: shl_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    sel z0.s, p1, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = shl <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @shl_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: shl_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p1.h, p0/z, z2.h, #0
; CHECK-NEXT:    lsl z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    sel z0.h, p1, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = shl <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @shl_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: shl_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p1.b, p0/z, z2.b, #0
; CHECK-NEXT:    lsl z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    sel z0.b, p1, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = shl <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @ashr_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: ashr_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p1.d, p0/z, z2.d, #0
; CHECK-NEXT:    asr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    sel z0.d, p1, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = ashr <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @ashr_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: ashr_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    asr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    sel z0.s, p1, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = ashr <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @ashr_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: ashr_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p1.h, p0/z, z2.h, #0
; CHECK-NEXT:    asr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    sel z0.h, p1, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = ashr <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @ashr_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: ashr_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p1.b, p0/z, z2.b, #0
; CHECK-NEXT:    asr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    sel z0.b, p1, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = ashr <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @lshr_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %n) {
; CHECK-LABEL: lshr_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p1.d, p0/z, z2.d, #0
; CHECK-NEXT:    lsr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    sel z0.d, p1, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %a = lshr <vscale x 2 x i64> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @lshr_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n) {
; CHECK-LABEL: lshr_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    lsr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    sel z0.s, p1, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = lshr <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @lshr_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %n) {
; CHECK-LABEL: lshr_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p1.h, p0/z, z2.h, #0
; CHECK-NEXT:    lsr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    sel z0.h, p1, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %a = lshr <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @lshr_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %n) {
; CHECK-LABEL: lshr_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p1.b, p0/z, z2.b, #0
; CHECK-NEXT:    lsr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    sel z0.b, p1, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %a = lshr <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @mla_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %z, <vscale x 2 x i64> %n) {
; CHECK-LABEL: mla_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z3.d, #0
; CHECK-NEXT:    mad z1.d, p0/m, z2.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %m = mul <vscale x 2 x i64> %y, %z
  %a = add <vscale x 2 x i64> %m, %x
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @mla_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %z, <vscale x 4 x i32> %n) {
; CHECK-LABEL: mla_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z3.s, #0
; CHECK-NEXT:    mad z1.s, p0/m, z2.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %m = mul <vscale x 4 x i32> %y, %z
  %a = add <vscale x 4 x i32> %m, %x
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mla_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %z, <vscale x 8 x i16> %n) {
; CHECK-LABEL: mla_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z3.h, #0
; CHECK-NEXT:    mad z1.h, p0/m, z2.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %m = mul <vscale x 8 x i16> %y, %z
  %a = add <vscale x 8 x i16> %m, %x
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mla_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %z, <vscale x 16 x i8> %n) {
; CHECK-LABEL: mla_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z3.b, #0
; CHECK-NEXT:    mad z1.b, p0/m, z2.b, z0.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %m = mul <vscale x 16 x i8> %y, %z
  %a = add <vscale x 16 x i8> %m, %x
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 2 x i64> @mls_nxv2i64_y(<vscale x 2 x i64> %x, <vscale x 2 x i64> %y, <vscale x 2 x i64> %z, <vscale x 2 x i64> %n) {
; CHECK-LABEL: mls_nxv2i64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    cmpgt p0.d, p0/z, z3.d, #0
; CHECK-NEXT:    msb z1.d, p0/m, z0.d, z2.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 2 x i64> %n, zeroinitializer
  %m = mul <vscale x 2 x i64> %x, %y
  %a = sub <vscale x 2 x i64> %z, %m
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x i64> %a, <vscale x 2 x i64> %y
  ret <vscale x 2 x i64> %b
}

define <vscale x 4 x i32> @mls_nxv4i32_y(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %z, <vscale x 4 x i32> %n) {
; CHECK-LABEL: mls_nxv4i32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p0.s, p0/z, z3.s, #0
; CHECK-NEXT:    msb z1.s, p0/m, z0.s, z2.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %m = mul <vscale x 4 x i32> %x, %y
  %a = sub <vscale x 4 x i32> %z, %m
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %y
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mls_nxv8i16_y(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y, <vscale x 8 x i16> %z, <vscale x 8 x i16> %n) {
; CHECK-LABEL: mls_nxv8i16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpgt p0.h, p0/z, z3.h, #0
; CHECK-NEXT:    msb z1.h, p0/m, z0.h, z2.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 8 x i16> %n, zeroinitializer
  %m = mul <vscale x 8 x i16> %x, %y
  %a = sub <vscale x 8 x i16> %z, %m
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %y
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mls_nxv16i8_y(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y, <vscale x 16 x i8> %z, <vscale x 16 x i8> %n) {
; CHECK-LABEL: mls_nxv16i8_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpgt p0.b, p0/z, z3.b, #0
; CHECK-NEXT:    msb z1.b, p0/m, z0.b, z2.b
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 16 x i8> %n, zeroinitializer
  %m = mul <vscale x 16 x i8> %x, %y
  %a = sub <vscale x 16 x i8> %z, %m
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %y
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x float> @fadd_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fadd_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fadd z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x float> %x, <vscale x 4 x float> splat (float -0.000000e+00)
  %b = fadd <vscale x 4 x float> %a, %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fadd_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fadd_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fadd z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x half> %x, <vscale x 8 x half> splat (half 0xH8000)
  %b = fadd <vscale x 8 x half> %a, %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fadd_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fadd_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fadd z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x double> %x, <vscale x 2 x double> splat (double -0.000000e+00)
  %b = fadd <vscale x 2 x double> %a, %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fsub_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fsub_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fsub z0.s, z0.s, z1.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = fsub <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fsub_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fsub_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fsub z0.h, z0.h, z1.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = fsub <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fsub_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fsub_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fsub z0.d, z0.d, z1.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = fsub <vscale x 2 x double> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fmul_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fmul_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmul z1.s, p0/m, z1.s, z0.s
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x float> %x, <vscale x 4 x float> splat (float 1.000000e+00)
  %b = fmul <vscale x 4 x float> %a, %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fmul_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fmul_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmul z1.h, p0/m, z1.h, z0.h
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = select <vscale x 8 x i1> %c, <vscale x 8 x half> %x, <vscale x 8 x half> splat (half 0xH3C00)
  %b = fmul <vscale x 8 x half> %a, %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fmul_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fmul_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    fmul z1.d, p0/m, z1.d, z0.d
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = select <vscale x 2 x i1> %c, <vscale x 2 x double> %x, <vscale x 2 x double> splat (double 1.000000e+00)
  %b = fmul <vscale x 2 x double> %a, %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fdiv_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %n) {
; CHECK-LABEL: fdiv_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = fdiv <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fdiv_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %n) {
; CHECK-LABEL: fdiv_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fdiv z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z2.h, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = fdiv <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fdiv_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %n) {
; CHECK-LABEL: fdiv_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fdiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z2.d, #0.0
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = fdiv <vscale x 2 x double> %x, %y
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fmai_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %z, <vscale x 4 x float> %n) {
; CHECK-LABEL: fmai_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z3.s, #0.0
; CHECK-NEXT:    fmla z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %a = call <vscale x 4 x float> @llvm.fma.nxv4f32(<vscale x 4 x float> %y, <vscale x 4 x float> %z, <vscale x 4 x float> %x)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fmai_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %z, <vscale x 8 x half> %n) {
; CHECK-LABEL: fmai_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z3.h, #0.0
; CHECK-NEXT:    fmla z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %a = call <vscale x 8 x half> @llvm.fma.nxv8f16(<vscale x 8 x half> %y, <vscale x 8 x half> %z, <vscale x 8 x half> %x)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fmai_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %z, <vscale x 2 x double> %n) {
; CHECK-LABEL: fmai_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z3.d, #0.0
; CHECK-NEXT:    fmla z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %a = call <vscale x 2 x double> @llvm.fma.nxv2f64(<vscale x 2 x double> %y, <vscale x 2 x double> %z, <vscale x 2 x double> %x)
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}

define <vscale x 4 x float> @fma_nxv4f32_y(<vscale x 4 x float> %x, <vscale x 4 x float> %y, <vscale x 4 x float> %z, <vscale x 4 x float> %n) {
; CHECK-LABEL: fma_nxv4f32_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmle p1.s, p0/z, z3.s, #0.0
; CHECK-NEXT:    fmla z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 4 x float> %n, zeroinitializer
  %m = fmul fast <vscale x 4 x float> %y, %z
  %a = fadd fast <vscale x 4 x float> %m, %x
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %y
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fma_nxv8f16_y(<vscale x 8 x half> %x, <vscale x 8 x half> %y, <vscale x 8 x half> %z, <vscale x 8 x half> %n) {
; CHECK-LABEL: fma_nxv8f16_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmle p1.h, p0/z, z3.h, #0.0
; CHECK-NEXT:    fmla z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 8 x half> %n, zeroinitializer
  %m = fmul fast <vscale x 8 x half> %y, %z
  %a = fadd fast <vscale x 8 x half> %m, %x
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %y
  ret <vscale x 8 x half> %b
}

define <vscale x 2 x double> @fma_nxv2f64_y(<vscale x 2 x double> %x, <vscale x 2 x double> %y, <vscale x 2 x double> %z, <vscale x 2 x double> %n) {
; CHECK-LABEL: fma_nxv2f64_y:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcmle p1.d, p0/z, z3.d, #0.0
; CHECK-NEXT:    fmla z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    not p0.b, p0/z, p1.b
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = fcmp ugt <vscale x 2 x double> %n, zeroinitializer
  %m = fmul fast <vscale x 2 x double> %y, %z
  %a = fadd fast <vscale x 2 x double> %m, %x
  %b = select <vscale x 2 x i1> %c, <vscale x 2 x double> %a, <vscale x 2 x double> %y
  ret <vscale x 2 x double> %b
}


define <vscale x 4 x i32> @mul_nxv4i32_multiuse_x(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y, <vscale x 4 x i32> %n, ptr %p) {
; CHECK-LABEL: mul_nxv4i32_multiuse_x:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpgt p1.s, p0/z, z2.s, #0
; CHECK-NEXT:    mov z2.s, #1 // =0x1
; CHECK-NEXT:    sel z1.s, p1, z1.s, z2.s
; CHECK-NEXT:    mul z0.s, z1.s, z0.s
; CHECK-NEXT:    st1w { z1.s }, p0, [x0]
; CHECK-NEXT:    ret
entry:
  %c = icmp sgt <vscale x 4 x i32> %n, zeroinitializer
  %a = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %y, <vscale x 4 x i32> splat (i32 1)
  store <vscale x 4 x i32> %a, ptr %p
  %b = mul <vscale x 4 x i32> %a, %x
  ret <vscale x 4 x i32> %b
}

declare <vscale x 2 x double> @llvm.fma.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.fma.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 8 x half> @llvm.fma.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>)
