; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=hawaii -verify-machineinstrs < %s | FileCheck --check-prefix=GFX7 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX10 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX11 %s

; FIXME:
; XUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=tahiti -verify-machineinstrs < %s | FileCheck --check-prefix=GFX6 %s

define amdgpu_kernel void @store_lds_v3i32(ptr addrspace(3) %out, <3 x i32> %x) {
; GFX9-LABEL: store_lds_v3i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x10
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s0
; GFX9-NEXT:    ds_write_b96 v3, v[0:2]
; GFX9-NEXT:    s_endpgm
;
; GFX7-LABEL: store_lds_v3i32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x4
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s0
; GFX7-NEXT:    ds_write_b96 v3, v[0:2]
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: store_lds_v3i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x10
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-NEXT:    v_mov_b32_e32 v2, s6
; GFX10-NEXT:    v_mov_b32_e32 v3, s0
; GFX10-NEXT:    ds_write_b96 v3, v[0:2]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_lds_v3i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x10
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s0
; GFX11-NEXT:    ds_store_b96 v3, v[0:2]
; GFX11-NEXT:    s_endpgm
  store <3 x i32> %x, ptr addrspace(3) %out
  ret void
}

define amdgpu_kernel void @store_lds_v3i32_align1(ptr addrspace(3) %out, <3 x i32> %x) {
; GFX9-LABEL: store_lds_v3i32_align1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x10
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s2, 0xffff, s4
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    s_lshr_b32 s0, s2, 8
; GFX9-NEXT:    s_lshr_b32 s1, s4, 16
; GFX9-NEXT:    ds_write_b8 v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    ds_write_b8 v1, v0 offset:1
; GFX9-NEXT:    s_lshr_b32 s0, s1, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    ds_write_b8 v1, v0 offset:2
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_and_b32 s1, 0xffff, s5
; GFX9-NEXT:    ds_write_b8 v1, v0 offset:3
; GFX9-NEXT:    s_lshr_b32 s1, s1, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    s_lshr_b32 s0, s5, 16
; GFX9-NEXT:    ds_write_b8 v1, v0 offset:4
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    ds_write_b8 v1, v0 offset:5
; GFX9-NEXT:    s_lshr_b32 s1, s0, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    ds_write_b8 v1, v0 offset:6
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    s_and_b32 s1, 0xffff, s6
; GFX9-NEXT:    ds_write_b8 v1, v0 offset:7
; GFX9-NEXT:    s_lshr_b32 s1, s1, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshr_b32 s0, s6, 16
; GFX9-NEXT:    ds_write_b8 v1, v0 offset:8
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    ds_write_b8 v1, v0 offset:9
; GFX9-NEXT:    s_lshr_b32 s1, s0, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    ds_write_b8 v1, v0 offset:10
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    ds_write_b8 v1, v0 offset:11
; GFX9-NEXT:    s_endpgm
;
; GFX7-LABEL: store_lds_v3i32_align1:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x4
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s2, s4, 0x80008
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    s_lshr_b32 s1, s4, 16
; GFX7-NEXT:    ds_write_b8 v1, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    ds_write_b8 v1, v0 offset:1
; GFX7-NEXT:    s_lshr_b32 s0, s4, 24
; GFX7-NEXT:    v_mov_b32_e32 v0, s1
; GFX7-NEXT:    ds_write_b8 v1, v0 offset:2
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    ds_write_b8 v1, v0 offset:3
; GFX7-NEXT:    s_bfe_u32 s1, s5, 0x80008
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    s_lshr_b32 s0, s5, 16
; GFX7-NEXT:    ds_write_b8 v1, v0 offset:4
; GFX7-NEXT:    v_mov_b32_e32 v0, s1
; GFX7-NEXT:    ds_write_b8 v1, v0 offset:5
; GFX7-NEXT:    s_lshr_b32 s1, s5, 24
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    ds_write_b8 v1, v0 offset:6
; GFX7-NEXT:    v_mov_b32_e32 v0, s1
; GFX7-NEXT:    ds_write_b8 v1, v0 offset:7
; GFX7-NEXT:    s_bfe_u32 s1, s6, 0x80008
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_lshr_b32 s0, s6, 16
; GFX7-NEXT:    ds_write_b8 v1, v0 offset:8
; GFX7-NEXT:    v_mov_b32_e32 v0, s1
; GFX7-NEXT:    ds_write_b8 v1, v0 offset:9
; GFX7-NEXT:    s_lshr_b32 s1, s6, 24
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    ds_write_b8 v1, v0 offset:10
; GFX7-NEXT:    v_mov_b32_e32 v0, s1
; GFX7-NEXT:    ds_write_b8 v1, v0 offset:11
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: store_lds_v3i32_align1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x10
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_lshr_b32 s1, s4, 16
; GFX10-NEXT:    v_mov_b32_e32 v1, s0
; GFX10-NEXT:    s_lshr_b32 s0, s5, 16
; GFX10-NEXT:    s_and_b32 s3, 0xffff, s5
; GFX10-NEXT:    s_and_b32 s2, 0xffff, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-NEXT:    s_lshr_b32 s4, s6, 16
; GFX10-NEXT:    s_and_b32 s5, 0xffff, s6
; GFX10-NEXT:    v_mov_b32_e32 v3, s6
; GFX10-NEXT:    s_lshr_b32 s6, s1, 8
; GFX10-NEXT:    v_mov_b32_e32 v4, s1
; GFX10-NEXT:    s_lshr_b32 s1, s3, 8
; GFX10-NEXT:    s_lshr_b32 s3, s0, 8
; GFX10-NEXT:    s_lshr_b32 s2, s2, 8
; GFX10-NEXT:    v_mov_b32_e32 v5, s0
; GFX10-NEXT:    s_lshr_b32 s0, s5, 8
; GFX10-NEXT:    v_mov_b32_e32 v9, s3
; GFX10-NEXT:    v_mov_b32_e32 v6, s2
; GFX10-NEXT:    v_mov_b32_e32 v10, s0
; GFX10-NEXT:    s_lshr_b32 s0, s4, 8
; GFX10-NEXT:    v_mov_b32_e32 v7, s6
; GFX10-NEXT:    v_mov_b32_e32 v8, s1
; GFX10-NEXT:    ds_write_b8 v1, v0
; GFX10-NEXT:    ds_write_b8 v1, v2 offset:4
; GFX10-NEXT:    ds_write_b8 v1, v4 offset:2
; GFX10-NEXT:    ds_write_b8 v1, v5 offset:6
; GFX10-NEXT:    ds_write_b8 v1, v6 offset:1
; GFX10-NEXT:    ds_write_b8 v1, v7 offset:3
; GFX10-NEXT:    ds_write_b8 v1, v8 offset:5
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v2, s0
; GFX10-NEXT:    ds_write_b8 v1, v9 offset:7
; GFX10-NEXT:    ds_write_b8 v1, v3 offset:8
; GFX10-NEXT:    ds_write_b8 v1, v10 offset:9
; GFX10-NEXT:    ds_write_b8 v1, v0 offset:10
; GFX10-NEXT:    ds_write_b8 v1, v2 offset:11
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_lds_v3i32_align1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x10
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s2, 0xffff, s4
; GFX11-NEXT:    s_lshr_b32 s1, s4, 16
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    s_lshr_b32 s4, s6, 16
; GFX11-NEXT:    s_lshr_b32 s2, s2, 8
; GFX11-NEXT:    s_lshr_b32 s0, s5, 16
; GFX11-NEXT:    s_and_b32 s3, 0xffff, s5
; GFX11-NEXT:    v_dual_mov_b32 v2, s5 :: v_dual_mov_b32 v3, s6
; GFX11-NEXT:    s_and_b32 s5, 0xffff, s6
; GFX11-NEXT:    s_lshr_b32 s6, s1, 8
; GFX11-NEXT:    v_dual_mov_b32 v6, s4 :: v_dual_mov_b32 v7, s2
; GFX11-NEXT:    v_dual_mov_b32 v4, s1 :: v_dual_mov_b32 v5, s0
; GFX11-NEXT:    s_lshr_b32 s1, s3, 8
; GFX11-NEXT:    s_lshr_b32 s3, s0, 8
; GFX11-NEXT:    s_lshr_b32 s0, s5, 8
; GFX11-NEXT:    s_lshr_b32 s5, s4, 8
; GFX11-NEXT:    v_dual_mov_b32 v8, s6 :: v_dual_mov_b32 v9, s1
; GFX11-NEXT:    v_dual_mov_b32 v10, s3 :: v_dual_mov_b32 v11, s0
; GFX11-NEXT:    v_mov_b32_e32 v12, s5
; GFX11-NEXT:    ds_store_b8 v1, v0
; GFX11-NEXT:    ds_store_b8 v1, v7 offset:1
; GFX11-NEXT:    ds_store_b8 v1, v4 offset:2
; GFX11-NEXT:    ds_store_b8 v1, v8 offset:3
; GFX11-NEXT:    ds_store_b8 v1, v2 offset:4
; GFX11-NEXT:    ds_store_b8 v1, v9 offset:5
; GFX11-NEXT:    ds_store_b8 v1, v5 offset:6
; GFX11-NEXT:    ds_store_b8 v1, v10 offset:7
; GFX11-NEXT:    ds_store_b8 v1, v3 offset:8
; GFX11-NEXT:    ds_store_b8 v1, v11 offset:9
; GFX11-NEXT:    ds_store_b8 v1, v6 offset:10
; GFX11-NEXT:    ds_store_b8 v1, v12 offset:11
; GFX11-NEXT:    s_endpgm
  store <3 x i32> %x, ptr addrspace(3) %out, align 1
  ret void
}

define amdgpu_kernel void @store_lds_v3i32_align2(ptr addrspace(3) %out, <3 x i32> %x) {
; GFX9-LABEL: store_lds_v3i32_align2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x10
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s1, s4, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    ds_write_b16 v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    ds_write_b16 v1, v0 offset:2
; GFX9-NEXT:    s_lshr_b32 s0, s5, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    ds_write_b16 v1, v0 offset:4
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    ds_write_b16 v1, v0 offset:6
; GFX9-NEXT:    s_lshr_b32 s0, s6, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    ds_write_b16 v1, v0 offset:8
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    ds_write_b16 v1, v0 offset:10
; GFX9-NEXT:    s_endpgm
;
; GFX7-LABEL: store_lds_v3i32_align2:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x4
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshr_b32 s1, s4, 16
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    ds_write_b16 v1, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s1
; GFX7-NEXT:    ds_write_b16 v1, v0 offset:2
; GFX7-NEXT:    s_lshr_b32 s0, s5, 16
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    ds_write_b16 v1, v0 offset:4
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    ds_write_b16 v1, v0 offset:6
; GFX7-NEXT:    s_lshr_b32 s0, s6, 16
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    ds_write_b16 v1, v0 offset:8
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    ds_write_b16 v1, v0 offset:10
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: store_lds_v3i32_align2:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x10
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v1, s0
; GFX10-NEXT:    s_lshr_b32 s1, s4, 16
; GFX10-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-NEXT:    s_lshr_b32 s0, s5, 16
; GFX10-NEXT:    v_mov_b32_e32 v3, s6
; GFX10-NEXT:    s_lshr_b32 s2, s6, 16
; GFX10-NEXT:    v_mov_b32_e32 v4, s1
; GFX10-NEXT:    v_mov_b32_e32 v5, s0
; GFX10-NEXT:    v_mov_b32_e32 v6, s2
; GFX10-NEXT:    ds_write_b16 v1, v0
; GFX10-NEXT:    ds_write_b16 v1, v2 offset:4
; GFX10-NEXT:    ds_write_b16 v1, v3 offset:8
; GFX10-NEXT:    ds_write_b16 v1, v4 offset:2
; GFX10-NEXT:    ds_write_b16 v1, v5 offset:6
; GFX10-NEXT:    ds_write_b16 v1, v6 offset:10
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_lds_v3i32_align2:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x10
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s1, s4, 16
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    s_lshr_b32 s0, s5, 16
; GFX11-NEXT:    v_dual_mov_b32 v2, s5 :: v_dual_mov_b32 v3, s1
; GFX11-NEXT:    s_lshr_b32 s2, s6, 16
; GFX11-NEXT:    v_dual_mov_b32 v4, s6 :: v_dual_mov_b32 v5, s0
; GFX11-NEXT:    v_mov_b32_e32 v6, s2
; GFX11-NEXT:    ds_store_b16 v1, v0
; GFX11-NEXT:    ds_store_b16 v1, v3 offset:2
; GFX11-NEXT:    ds_store_b16 v1, v2 offset:4
; GFX11-NEXT:    ds_store_b16 v1, v5 offset:6
; GFX11-NEXT:    ds_store_b16 v1, v4 offset:8
; GFX11-NEXT:    ds_store_b16 v1, v6 offset:10
; GFX11-NEXT:    s_endpgm
  store <3 x i32> %x, ptr addrspace(3) %out, align 2
  ret void
}

define amdgpu_kernel void @store_lds_v3i32_align4(ptr addrspace(3) %out, <3 x i32> %x) {
; GFX9-LABEL: store_lds_v3i32_align4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x10
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_mov_b32_e32 v3, s6
; GFX9-NEXT:    ds_write2_b32 v1, v0, v2 offset1:1
; GFX9-NEXT:    ds_write_b32 v1, v3 offset:8
; GFX9-NEXT:    s_endpgm
;
; GFX7-LABEL: store_lds_v3i32_align4:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x4
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_write2_b32 v1, v0, v2 offset1:1
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    ds_write_b32 v1, v0 offset:8
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: store_lds_v3i32_align4:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x10
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v1, s0
; GFX10-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-NEXT:    v_mov_b32_e32 v3, s6
; GFX10-NEXT:    ds_write2_b32 v1, v0, v2 offset1:1
; GFX10-NEXT:    ds_write_b32 v1, v3 offset:8
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_lds_v3i32_align4:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x10
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    v_dual_mov_b32 v2, s5 :: v_dual_mov_b32 v3, s6
; GFX11-NEXT:    ds_store_2addr_b32 v1, v0, v2 offset1:1
; GFX11-NEXT:    ds_store_b32 v1, v3 offset:8
; GFX11-NEXT:    s_endpgm
  store <3 x i32> %x, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @store_lds_v3i32_align8(ptr addrspace(3) %out, <3 x i32> %x) {
; GFX9-LABEL: store_lds_v3i32_align8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x10
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_mov_b32_e32 v3, s6
; GFX9-NEXT:    ds_write2_b32 v1, v0, v2 offset1:1
; GFX9-NEXT:    ds_write_b32 v1, v3 offset:8
; GFX9-NEXT:    s_endpgm
;
; GFX7-LABEL: store_lds_v3i32_align8:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x4
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_write2_b32 v1, v0, v2 offset1:1
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    ds_write_b32 v1, v0 offset:8
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: store_lds_v3i32_align8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x10
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v1, s0
; GFX10-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-NEXT:    v_mov_b32_e32 v3, s6
; GFX10-NEXT:    ds_write2_b32 v1, v0, v2 offset1:1
; GFX10-NEXT:    ds_write_b32 v1, v3 offset:8
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_lds_v3i32_align8:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x10
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    v_dual_mov_b32 v2, s5 :: v_dual_mov_b32 v3, s6
; GFX11-NEXT:    ds_store_2addr_b32 v1, v0, v2 offset1:1
; GFX11-NEXT:    ds_store_b32 v1, v3 offset:8
; GFX11-NEXT:    s_endpgm
  store <3 x i32> %x, ptr addrspace(3) %out, align 8
  ret void
}

define amdgpu_kernel void @store_lds_v3i32_align16(ptr addrspace(3) %out, <3 x i32> %x) {
; GFX9-LABEL: store_lds_v3i32_align16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x10
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s0
; GFX9-NEXT:    ds_write_b96 v3, v[0:2]
; GFX9-NEXT:    s_endpgm
;
; GFX7-LABEL: store_lds_v3i32_align16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x4
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s0
; GFX7-NEXT:    ds_write_b96 v3, v[0:2]
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: store_lds_v3i32_align16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x10
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-NEXT:    v_mov_b32_e32 v2, s6
; GFX10-NEXT:    v_mov_b32_e32 v3, s0
; GFX10-NEXT:    ds_write_b96 v3, v[0:2]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_lds_v3i32_align16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x10
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s0
; GFX11-NEXT:    ds_store_b96 v3, v[0:2]
; GFX11-NEXT:    s_endpgm
  store <3 x i32> %x, ptr addrspace(3) %out, align 16
  ret void
}
