; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

;
; SABD
;

define <8 x i8> @sabd_8b(<8 x i8> %a, <8 x i8> %b) #0 {
; CHECK-LABEL: sabd_8b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabd v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %a.sext = sext <8 x i8> %a to <8 x i16>
  %b.sext = sext <8 x i8> %b to <8 x i16>
  %sub = sub <8 x i16> %a.sext, %b.sext
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  %trunc = trunc <8 x i16> %abs to <8 x i8>
  ret <8 x i8> %trunc
}

define <16 x i8> @sabd_16b(<16 x i8> %a, <16 x i8> %b) #0 {
; CHECK-LABEL: sabd_16b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabd v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %a.sext = sext <16 x i8> %a to <16 x i16>
  %b.sext = sext <16 x i8> %b to <16 x i16>
  %sub = sub <16 x i16> %a.sext, %b.sext
  %abs = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %sub, i1 true)
  %trunc = trunc <16 x i16> %abs to <16 x i8>
  ret <16 x i8> %trunc
}

define <4 x i16> @sabd_4h(<4 x i16> %a, <4 x i16> %b) #0 {
; CHECK-LABEL: sabd_4h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabd v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %a.sext = sext <4 x i16> %a to <4 x i32>
  %b.sext = sext <4 x i16> %b to <4 x i32>
  %sub = sub <4 x i32> %a.sext, %b.sext
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  %trunc = trunc <4 x i32> %abs to <4 x i16>
  ret <4 x i16> %trunc
}

define <4 x i16> @sabd_4h_promoted_ops(<4 x i8> %a, <4 x i8> %b) #0 {
; CHECK-LABEL: sabd_4h_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-NEXT:    shl v1.4h, v1.4h, #8
; CHECK-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-NEXT:    sshr v1.4h, v1.4h, #8
; CHECK-NEXT:    sabd v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %a.sext = sext <4 x i8> %a to <4 x i16>
  %b.sext = sext <4 x i8> %b to <4 x i16>
  %sub = sub <4 x i16> %a.sext, %b.sext
  %abs = call <4 x i16> @llvm.abs.v4i16(<4 x i16> %sub, i1 true)
  ret <4 x i16> %abs
}

define <8 x i16> @sabd_8h(<8 x i16> %a, <8 x i16> %b) #0 {
; CHECK-LABEL: sabd_8h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabd v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %a.sext = sext <8 x i16> %a to <8 x i32>
  %b.sext = sext <8 x i16> %b to <8 x i32>
  %sub = sub <8 x i32> %a.sext, %b.sext
  %abs = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %sub, i1 true)
  %trunc = trunc <8 x i32> %abs to <8 x i16>
  ret <8 x i16> %trunc
}

define <8 x i16> @sabd_8h_promoted_ops(<8 x i8> %a, <8 x i8> %b) #0 {
; CHECK-LABEL: sabd_8h_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabdl v0.8h, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %a.sext = sext <8 x i8> %a to <8 x i16>
  %b.sext = sext <8 x i8> %b to <8 x i16>
  %sub = sub <8 x i16> %a.sext, %b.sext
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  ret <8 x i16> %abs
}

define <2 x i32> @sabd_2s(<2 x i32> %a, <2 x i32> %b) #0 {
; CHECK-LABEL: sabd_2s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabd v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %a.sext = sext <2 x i32> %a to <2 x i64>
  %b.sext = sext <2 x i32> %b to <2 x i64>
  %sub = sub <2 x i64> %a.sext, %b.sext
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  %trunc = trunc <2 x i64> %abs to <2 x i32>
  ret <2 x i32> %trunc
}

define <2 x i32> @sabd_2s_promoted_ops(<2 x i16> %a, <2 x i16> %b) #0 {
; CHECK-LABEL: sabd_2s_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shl v0.2s, v0.2s, #16
; CHECK-NEXT:    shl v1.2s, v1.2s, #16
; CHECK-NEXT:    sshr v0.2s, v0.2s, #16
; CHECK-NEXT:    sshr v1.2s, v1.2s, #16
; CHECK-NEXT:    sabd v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %a.sext = sext <2 x i16> %a to <2 x i32>
  %b.sext = sext <2 x i16> %b to <2 x i32>
  %sub = sub <2 x i32> %a.sext, %b.sext
  %abs = call <2 x i32> @llvm.abs.v2i32(<2 x i32> %sub, i1 true)
  ret <2 x i32> %abs
}

define <4 x i32> @sabd_4s(<4 x i32> %a, <4 x i32> %b) #0 {
; CHECK-LABEL: sabd_4s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabd v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %a.sext = sext <4 x i32> %a to <4 x i64>
  %b.sext = sext <4 x i32> %b to <4 x i64>
  %sub = sub <4 x i64> %a.sext, %b.sext
  %abs = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %sub, i1 true)
  %trunc = trunc <4 x i64> %abs to <4 x i32>
  ret <4 x i32> %trunc
}

define <4 x i32> @sabd_4s_promoted_ops(<4 x i16> %a, <4 x i16> %b) #0 {
; CHECK-LABEL: sabd_4s_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabdl v0.4s, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %a.sext = sext <4 x i16> %a to <4 x i32>
  %b.sext = sext <4 x i16> %b to <4 x i32>
  %sub = sub <4 x i32> %a.sext, %b.sext
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  ret <4 x i32> %abs
}

define <2 x i64> @sabd_2d(<2 x i64> %a, <2 x i64> %b) #0 {
; CHECK-LABEL: sabd_2d:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, v0.d[1]
; CHECK-NEXT:    mov x9, v1.d[1]
; CHECK-NEXT:    fmov x10, d0
; CHECK-NEXT:    fmov x12, d1
; CHECK-NEXT:    asr x14, x10, #63
; CHECK-NEXT:    asr x11, x8, #63
; CHECK-NEXT:    asr x13, x9, #63
; CHECK-NEXT:    asr x15, x12, #63
; CHECK-NEXT:    subs x8, x8, x9
; CHECK-NEXT:    sbc x9, x11, x13
; CHECK-NEXT:    subs x10, x10, x12
; CHECK-NEXT:    sbc x11, x14, x15
; CHECK-NEXT:    asr x9, x9, #63
; CHECK-NEXT:    asr x11, x11, #63
; CHECK-NEXT:    eor x8, x8, x9
; CHECK-NEXT:    eor x10, x10, x11
; CHECK-NEXT:    sub x8, x8, x9
; CHECK-NEXT:    sub x10, x10, x11
; CHECK-NEXT:    fmov d1, x8
; CHECK-NEXT:    fmov d0, x10
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    ret
  %a.sext = sext <2 x i64> %a to <2 x i128>
  %b.sext = sext <2 x i64> %b to <2 x i128>
  %sub = sub <2 x i128> %a.sext, %b.sext
  %abs = call <2 x i128> @llvm.abs.v2i128(<2 x i128> %sub, i1 true)
  %trunc = trunc <2 x i128> %abs to <2 x i64>
  ret <2 x i64> %trunc
}

define <2 x i64> @sabd_2d_promoted_ops(<2 x i32> %a, <2 x i32> %b) #0 {
; CHECK-LABEL: sabd_2d_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabdl v0.2d, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %a.sext = sext <2 x i32> %a to <2 x i64>
  %b.sext = sext <2 x i32> %b to <2 x i64>
  %sub = sub <2 x i64> %a.sext, %b.sext
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  ret <2 x i64> %abs
}

;
; UABD
;

define <8 x i8> @uabd_8b(<8 x i8> %a, <8 x i8> %b) #0 {
; CHECK-LABEL: uabd_8b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabd v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %a.zext = zext <8 x i8> %a to <8 x i16>
  %b.zext = zext <8 x i8> %b to <8 x i16>
  %sub = sub <8 x i16> %a.zext, %b.zext
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  %trunc = trunc <8 x i16> %abs to <8 x i8>
  ret <8 x i8> %trunc
}

define <16 x i8> @uabd_16b(<16 x i8> %a, <16 x i8> %b) #0 {
; CHECK-LABEL: uabd_16b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabd v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %a.zext = zext <16 x i8> %a to <16 x i16>
  %b.zext = zext <16 x i8> %b to <16 x i16>
  %sub = sub <16 x i16> %a.zext, %b.zext
  %abs = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %sub, i1 true)
  %trunc = trunc <16 x i16> %abs to <16 x i8>
  ret <16 x i8> %trunc
}

define <4 x i16> @uabd_4h(<4 x i16> %a, <4 x i16> %b) #0 {
; CHECK-LABEL: uabd_4h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabd v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %a.zext = zext <4 x i16> %a to <4 x i32>
  %b.zext = zext <4 x i16> %b to <4 x i32>
  %sub = sub <4 x i32> %a.zext, %b.zext
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  %trunc = trunc <4 x i32> %abs to <4 x i16>
  ret <4 x i16> %trunc
}

define <4 x i16> @uabd_4h_promoted_ops(<4 x i8> %a, <4 x i8> %b) #0 {
; CHECK-LABEL: uabd_4h_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-NEXT:    bic v1.4h, #255, lsl #8
; CHECK-NEXT:    uabd v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %a.zext = zext <4 x i8> %a to <4 x i16>
  %b.zext = zext <4 x i8> %b to <4 x i16>
  %sub = sub <4 x i16> %a.zext, %b.zext
  %abs = call <4 x i16> @llvm.abs.v4i16(<4 x i16> %sub, i1 true)
  ret <4 x i16> %abs
}

define <8 x i16> @uabd_8h(<8 x i16> %a, <8 x i16> %b) #0 {
; CHECK-LABEL: uabd_8h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabd v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %a.zext = zext <8 x i16> %a to <8 x i32>
  %b.zext = zext <8 x i16> %b to <8 x i32>
  %sub = sub <8 x i32> %a.zext, %b.zext
  %abs = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %sub, i1 true)
  %trunc = trunc <8 x i32> %abs to <8 x i16>
  ret <8 x i16> %trunc
}

define <8 x i16> @uabd_8h_promoted_ops(<8 x i8> %a, <8 x i8> %b) #0 {
; CHECK-LABEL: uabd_8h_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabdl v0.8h, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %a.zext = zext <8 x i8> %a to <8 x i16>
  %b.zext = zext <8 x i8> %b to <8 x i16>
  %sub = sub <8 x i16> %a.zext, %b.zext
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  ret <8 x i16> %abs
}

define <2 x i32> @uabd_2s(<2 x i32> %a, <2 x i32> %b) #0 {
; CHECK-LABEL: uabd_2s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabd v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %a.zext = zext <2 x i32> %a to <2 x i64>
  %b.zext = zext <2 x i32> %b to <2 x i64>
  %sub = sub <2 x i64> %a.zext, %b.zext
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  %trunc = trunc <2 x i64> %abs to <2 x i32>
  ret <2 x i32> %trunc
}

define <2 x i32> @uabd_2s_promoted_ops(<2 x i16> %a, <2 x i16> %b) #0 {
; CHECK-LABEL: uabd_2s_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi d2, #0x00ffff0000ffff
; CHECK-NEXT:    and v0.8b, v0.8b, v2.8b
; CHECK-NEXT:    and v1.8b, v1.8b, v2.8b
; CHECK-NEXT:    uabd v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %a.zext = zext <2 x i16> %a to <2 x i32>
  %b.zext = zext <2 x i16> %b to <2 x i32>
  %sub = sub <2 x i32> %a.zext, %b.zext
  %abs = call <2 x i32> @llvm.abs.v2i32(<2 x i32> %sub, i1 true)
  ret <2 x i32> %abs
}

define <4 x i32> @uabd_4s(<4 x i32> %a, <4 x i32> %b) #0 {
; CHECK-LABEL: uabd_4s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabd v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %a.zext = zext <4 x i32> %a to <4 x i64>
  %b.zext = zext <4 x i32> %b to <4 x i64>
  %sub = sub <4 x i64> %a.zext, %b.zext
  %abs = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %sub, i1 true)
  %trunc = trunc <4 x i64> %abs to <4 x i32>
  ret <4 x i32> %trunc
}

define <4 x i32> @uabd_4s_promoted_ops(<4 x i16> %a, <4 x i16> %b) #0 {
; CHECK-LABEL: uabd_4s_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabdl v0.4s, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %a.zext = zext <4 x i16> %a to <4 x i32>
  %b.zext = zext <4 x i16> %b to <4 x i32>
  %sub = sub <4 x i32> %a.zext, %b.zext
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  ret <4 x i32> %abs
}

define <2 x i64> @uabd_2d(<2 x i64> %a, <2 x i64> %b) #0 {
; CHECK-LABEL: uabd_2d:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, v0.d[1]
; CHECK-NEXT:    mov x9, v1.d[1]
; CHECK-NEXT:    fmov x10, d0
; CHECK-NEXT:    fmov x11, d1
; CHECK-NEXT:    subs x8, x8, x9
; CHECK-NEXT:    ngc x9, xzr
; CHECK-NEXT:    subs x10, x10, x11
; CHECK-NEXT:    ngc x11, xzr
; CHECK-NEXT:    asr x9, x9, #63
; CHECK-NEXT:    asr x11, x11, #63
; CHECK-NEXT:    eor x8, x8, x9
; CHECK-NEXT:    eor x10, x10, x11
; CHECK-NEXT:    sub x8, x8, x9
; CHECK-NEXT:    sub x10, x10, x11
; CHECK-NEXT:    fmov d1, x8
; CHECK-NEXT:    fmov d0, x10
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    ret
  %a.zext = zext <2 x i64> %a to <2 x i128>
  %b.zext = zext <2 x i64> %b to <2 x i128>
  %sub = sub <2 x i128> %a.zext, %b.zext
  %abs = call <2 x i128> @llvm.abs.v2i128(<2 x i128> %sub, i1 true)
  %trunc = trunc <2 x i128> %abs to <2 x i64>
  ret <2 x i64> %trunc
}

define <2 x i64> @uabd_2d_promoted_ops(<2 x i32> %a, <2 x i32> %b) #0 {
; CHECK-LABEL: uabd_2d_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabdl v0.2d, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %a.zext = zext <2 x i32> %a to <2 x i64>
  %b.zext = zext <2 x i32> %b to <2 x i64>
  %sub = sub <2 x i64> %a.zext, %b.zext
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  ret <2 x i64> %abs
}

define <16 x i8> @uabd_v16i8_nuw(<16 x i8> %a, <16 x i8> %b) #0 {
; CHECK-LABEL: uabd_v16i8_nuw:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    abs v0.16b, v0.16b
; CHECK-NEXT:    ret
  %sub = sub nuw <16 x i8> %a, %b
  %abs = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %sub, i1 true)
  ret <16 x i8> %abs
}

define <8 x i16> @uabd_v8i16_nuw(<8 x i16> %a, <8 x i16> %b) #0 {
; CHECK-LABEL: uabd_v8i16_nuw:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    abs v0.8h, v0.8h
; CHECK-NEXT:    ret
  %sub = sub nuw <8 x i16> %a, %b
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  ret <8 x i16> %abs
}

define <4 x i32> @uabd_v4i32_nuw(<4 x i32> %a, <4 x i32> %b) #0 {
; CHECK-LABEL: uabd_v4i32_nuw:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    abs v0.4s, v0.4s
; CHECK-NEXT:    ret
  %sub = sub nuw <4 x i32> %a, %b
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  ret <4 x i32> %abs
}

define <2 x i64> @uabd_v2i64_nuw(<2 x i64> %a, <2 x i64> %b) #0 {
; CHECK-LABEL: uabd_v2i64_nuw:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    abs v0.2d, v0.2d
; CHECK-NEXT:    ret
  %sub = sub nuw <2 x i64> %a, %b
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  ret <2 x i64> %abs
}

define <16 x i8> @sabd_v16i8_nsw(<16 x i8> %a, <16 x i8> %b) #0 {
; CHECK-LABEL: sabd_v16i8_nsw:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabd v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %sub = sub nsw <16 x i8> %a, %b
  %abs = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %sub, i1 true)
  ret <16 x i8> %abs
}

define <8 x i16> @sabd_v8i16_nsw(<8 x i16> %a, <8 x i16> %b) #0 {
; CHECK-LABEL: sabd_v8i16_nsw:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabd v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %sub = sub nsw <8 x i16> %a, %b
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  ret <8 x i16> %abs
}

define <4 x i32> @sabd_v4i32_nsw(<4 x i32> %a, <4 x i32> %b) #0 {
; CHECK-LABEL: sabd_v4i32_nsw:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabd v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %sub = sub nsw <4 x i32> %a, %b
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  ret <4 x i32> %abs
}

define <2 x i64> @sabd_v2i64_nsw(<2 x i64> %a, <2 x i64> %b) #0 {
; CHECK-LABEL: sabd_v2i64_nsw:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    abs v0.2d, v0.2d
; CHECK-NEXT:    ret
  %sub = sub nsw <2 x i64> %a, %b
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  ret <2 x i64> %abs
}

define <16 x i8> @smaxmin_v16i8(<16 x i8> %0, <16 x i8> %1) {
; CHECK-LABEL: smaxmin_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabd v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %a = tail call <16 x i8> @llvm.smax.v16i8(<16 x i8> %0, <16 x i8> %1)
  %b = tail call <16 x i8> @llvm.smin.v16i8(<16 x i8> %0, <16 x i8> %1)
  %sub = sub <16 x i8> %a, %b
  ret <16 x i8> %sub
}

define <8 x i16> @smaxmin_v8i16(<8 x i16> %0, <8 x i16> %1) {
; CHECK-LABEL: smaxmin_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabd v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %a = tail call <8 x i16> @llvm.smax.v8i16(<8 x i16> %0, <8 x i16> %1)
  %b = tail call <8 x i16> @llvm.smin.v8i16(<8 x i16> %0, <8 x i16> %1)
  %sub = sub <8 x i16> %a, %b
  ret <8 x i16> %sub
}

define <4 x i32> @smaxmin_v4i32(<4 x i32> %0, <4 x i32> %1) {
; CHECK-LABEL: smaxmin_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sabd v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %a = tail call <4 x i32> @llvm.smax.v4i32(<4 x i32> %0, <4 x i32> %1)
  %b = tail call <4 x i32> @llvm.smin.v4i32(<4 x i32> %0, <4 x i32> %1)
  %sub = sub <4 x i32> %a, %b
  ret <4 x i32> %sub
}

define <2 x i64> @smaxmin_v2i64(<2 x i64> %0, <2 x i64> %1) {
; CHECK-LABEL: smaxmin_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v2.2d, v0.2d, v1.2d
; CHECK-NEXT:    cmgt v3.2d, v1.2d, v0.2d
; CHECK-NEXT:    bsl v2.16b, v0.16b, v1.16b
; CHECK-NEXT:    bif v0.16b, v1.16b, v3.16b
; CHECK-NEXT:    sub v0.2d, v2.2d, v0.2d
; CHECK-NEXT:    ret
  %a = tail call <2 x i64> @llvm.smax.v2i64(<2 x i64> %0, <2 x i64> %1)
  %b = tail call <2 x i64> @llvm.smin.v2i64(<2 x i64> %0, <2 x i64> %1)
  %sub = sub <2 x i64> %a, %b
  ret <2 x i64> %sub
}

define <16 x i8> @umaxmin_v16i8(<16 x i8> %0, <16 x i8> %1) {
; CHECK-LABEL: umaxmin_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabd v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %a = tail call <16 x i8> @llvm.umax.v16i8(<16 x i8> %0, <16 x i8> %1)
  %b = tail call <16 x i8> @llvm.umin.v16i8(<16 x i8> %0, <16 x i8> %1)
  %sub = sub <16 x i8> %a, %b
  ret <16 x i8> %sub
}

define <8 x i16> @umaxmin_v8i16(<8 x i16> %0, <8 x i16> %1) {
; CHECK-LABEL: umaxmin_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabd v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %a = tail call <8 x i16> @llvm.umax.v8i16(<8 x i16> %0, <8 x i16> %1)
  %b = tail call <8 x i16> @llvm.umin.v8i16(<8 x i16> %0, <8 x i16> %1)
  %sub = sub <8 x i16> %a, %b
  ret <8 x i16> %sub
}

define <4 x i32> @umaxmin_v4i32(<4 x i32> %0, <4 x i32> %1) {
; CHECK-LABEL: umaxmin_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabd v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %a = tail call <4 x i32> @llvm.umax.v4i32(<4 x i32> %0, <4 x i32> %1)
  %b = tail call <4 x i32> @llvm.umin.v4i32(<4 x i32> %0, <4 x i32> %1)
  %sub = sub <4 x i32> %a, %b
  ret <4 x i32> %sub
}

define <2 x i64> @umaxmin_v2i64(<2 x i64> %0, <2 x i64> %1) {
; CHECK-LABEL: umaxmin_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v2.2d, v0.2d, v1.2d
; CHECK-NEXT:    cmhi v3.2d, v1.2d, v0.2d
; CHECK-NEXT:    bsl v2.16b, v0.16b, v1.16b
; CHECK-NEXT:    bif v0.16b, v1.16b, v3.16b
; CHECK-NEXT:    sub v0.2d, v2.2d, v0.2d
; CHECK-NEXT:    ret
  %a = tail call <2 x i64> @llvm.umax.v2i64(<2 x i64> %0, <2 x i64> %1)
  %b = tail call <2 x i64> @llvm.umin.v2i64(<2 x i64> %0, <2 x i64> %1)
  %sub = sub <2 x i64> %a, %b
  ret <2 x i64> %sub
}

define <16 x i8> @umaxmin_v16i8_com1(<16 x i8> %0, <16 x i8> %1) {
; CHECK-LABEL: umaxmin_v16i8_com1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uabd v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %a = tail call <16 x i8> @llvm.umax.v16i8(<16 x i8> %0, <16 x i8> %1)
  %b = tail call <16 x i8> @llvm.umin.v16i8(<16 x i8> %1, <16 x i8> %0)
  %sub = sub <16 x i8> %a, %b
  ret <16 x i8> %sub
}

; (abds x, y) upper bits are known zero if x and y have extra sign bits
define <4 x i16> @combine_sabd_4h_zerosign(<4 x i16> %a, <4 x i16> %b) #0 {
; CHECK-LABEL: combine_sabd_4h_zerosign:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v0.2d, #0000000000000000
; CHECK-NEXT:    ret
  %a.ext = ashr <4 x i16> %a, <i16 7, i16 8, i16 9, i16 10>
  %b.ext = ashr <4 x i16> %b, <i16 11, i16 12, i16 13, i16 14>
  %max = tail call <4 x i16> @llvm.smax.v4i16(<4 x i16> %a.ext, <4 x i16> %b.ext)
  %min = tail call <4 x i16> @llvm.smin.v4i16(<4 x i16> %a.ext, <4 x i16> %b.ext)
  %sub = sub <4 x i16> %max, %min
  %mask = and <4 x i16> %sub, <i16 32768, i16 32768, i16 32768, i16 32768>
  ret <4 x i16> %mask
}

; negative test - mask extends beyond known zero bits
define <2 x i32> @combine_sabd_2s_zerosign_negative(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: combine_sabd_2s_zerosign_negative:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshr v0.2s, v0.2s, #3
; CHECK-NEXT:    sshr v1.2s, v1.2s, #15
; CHECK-NEXT:    mvni v2.2s, #7, msl #16
; CHECK-NEXT:    sabd v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    and v0.8b, v0.8b, v2.8b
; CHECK-NEXT:    ret
  %a.ext = ashr <2 x i32> %a, <i32 3, i32 3>
  %b.ext = ashr <2 x i32> %b, <i32 15, i32 15>
  %max = tail call <2 x i32> @llvm.smax.v2i32(<2 x i32> %a.ext, <2 x i32> %b.ext)
  %min = tail call <2 x i32> @llvm.smin.v2i32(<2 x i32> %a.ext, <2 x i32> %b.ext)
  %sub = sub <2 x i32> %max, %min
  %mask = and <2 x i32> %sub, <i32 -524288, i32 -524288> ; 0xFFF80000
  ret <2 x i32> %mask
}

declare <8 x i8> @llvm.abs.v8i8(<8 x i8>, i1)
declare <16 x i8> @llvm.abs.v16i8(<16 x i8>, i1)

declare <4 x i16> @llvm.abs.v4i16(<4 x i16>, i1)
declare <8 x i16> @llvm.abs.v8i16(<8 x i16>, i1)
declare <16 x i16> @llvm.abs.v16i16(<16 x i16>, i1)

declare <2 x i32> @llvm.abs.v2i32(<2 x i32>, i1)
declare <4 x i32> @llvm.abs.v4i32(<4 x i32>, i1)
declare <8 x i32> @llvm.abs.v8i32(<8 x i32>, i1)

declare <2 x i64> @llvm.abs.v2i64(<2 x i64>, i1)
declare <4 x i64> @llvm.abs.v4i64(<4 x i64>, i1)

declare <2 x i128> @llvm.abs.v2i128(<2 x i128>, i1)

declare <16 x i8> @llvm.smax.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.smax.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.smax.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.smax.v2i64(<2 x i64>, <2 x i64>)
declare <16 x i8> @llvm.smin.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.smin.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.smin.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.smin.v2i64(<2 x i64>, <2 x i64>)
declare <16 x i8> @llvm.umax.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.umax.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.umax.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.umax.v2i64(<2 x i64>, <2 x i64>)
declare <16 x i8> @llvm.umin.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.umin.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.umin.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.umin.v2i64(<2 x i64>, <2 x i64>)

attributes #0 = { "target-features"="+neon" }
