; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -verify-machineinstrs < %s | FileCheck -check-prefixes=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -verify-machineinstrs < %s | FileCheck -check-prefixes=VI %s
; RUN: llc -mtriple=r600 -mcpu=cypress -verify-machineinstrs < %s | FileCheck -check-prefixes=EG %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9-GISEL %s

declare i7 @llvm.ctlz.i7(i7, i1) nounwind readnone
declare <2 x i7> @llvm.ctlz.v2i7(<2 x i7>, i1) nounwind readnone
declare i8 @llvm.ctlz.i8(i8, i1) nounwind readnone
declare <2 x i8> @llvm.ctlz.v2i8(<2 x i8>, i1) nounwind readnone

declare i16 @llvm.ctlz.i16(i16, i1) nounwind readnone
declare i18 @llvm.ctlz.i18(i18, i1) nounwind readnone

declare <2 x i16> @llvm.ctlz.v2i16(<2 x i16>, i1) nounwind readnone
declare <3 x i16> @llvm.ctlz.v3i16(<3 x i16>, i1) nounwind readnone
declare <4 x i16> @llvm.ctlz.v4i16(<4 x i16>, i1) nounwind readnone

declare i32 @llvm.ctlz.i32(i32, i1) nounwind readnone
declare <2 x i32> @llvm.ctlz.v2i32(<2 x i32>, i1) nounwind readnone
declare <4 x i32> @llvm.ctlz.v4i32(<4 x i32>, i1) nounwind readnone

declare i64 @llvm.ctlz.i64(i64, i1) nounwind readnone
declare <2 x i64> @llvm.ctlz.v2i64(<2 x i64>, i1) nounwind readnone
declare <4 x i64> @llvm.ctlz.v4i64(<4 x i64>, i1) nounwind readnone

declare i32 @llvm.amdgcn.workitem.id.x() nounwind readnone

define amdgpu_kernel void @s_ctlz_zero_undef_i32(ptr addrspace(1) noalias %out, i32 %val) nounwind {
; SI-LABEL: s_ctlz_zero_undef_i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[2:3], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_flbit_i32_b32 s4, s4
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctlz_zero_undef_i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_flbit_i32_b32 s2, s4
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_ctlz_zero_undef_i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     FFBH_UINT * T1.X, KC0[2].Z,
;
; GFX9-GISEL-LABEL: s_ctlz_zero_undef_i32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_flbit_i32_b32 s2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 true) nounwind readnone
  store i32 %ctlz, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_i32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v2, v0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT T0.X, T0.X,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep, align 4
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 true) nounwind readnone
  store i32 %ctlz, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_v2i32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_zero_undef_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v1, v1
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_v2i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 3, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.Y, T0.Y,
; EG-NEXT:     FFBH_UINT T0.X, T0.X,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_v2i32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dwordx2 v[0:1], v0, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX9-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr <2 x i32>, ptr addrspace(1) %valptr, i32 %tid
  %val = load <2 x i32>, ptr addrspace(1) %in.gep, align 8
  %ctlz = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %val, i1 true) nounwind readnone
  store <2 x i32> %ctlz, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_v4i32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_zero_undef_v4i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v3, v3
; SI-NEXT:    v_ffbh_u32_e32 v2, v2
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_v4i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v5, s1
; VI-NEXT:    v_mov_b32_e32 v4, s0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v3, v3
; VI-NEXT:    v_ffbh_u32_e32 v2, v2
; VI-NEXT:    v_ffbh_u32_e32 v1, v1
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_v4i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 5, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T0.W,
; EG-NEXT:     FFBH_UINT * T0.Z, T0.Z,
; EG-NEXT:     FFBH_UINT * T0.Y, T0.Y,
; EG-NEXT:     FFBH_UINT T0.X, T0.X,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_v4i32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dwordx4 v[0:3], v0, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v2, v2
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v3, v3
; GFX9-GISEL-NEXT:    global_store_dwordx4 v4, v[0:3], s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr <4 x i32>, ptr addrspace(1) %valptr, i32 %tid
  %val = load <4 x i32>, ptr addrspace(1) %in.gep, align 16
  %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %val, i1 true) nounwind readnone
  store <4 x i32> %ctlz, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @s_ctlz_zero_undef_i8_with_select(ptr addrspace(1) noalias %out, i8 %val) nounwind {
; SI-LABEL: s_ctlz_zero_undef_i8_with_select:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[2:3], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s2, s4, 24
; SI-NEXT:    s_flbit_i32_b32 s4, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctlz_zero_undef_i8_with_select:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s2, s4, 24
; VI-NEXT:    s_flbit_i32_b32 s2, s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_byte v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_ctlz_zero_undef_i8_with_select:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 14, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 40, #3
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, 0.0,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    24(3.363116e-44), 0(0.000000e+00)
; EG-NEXT:     FFBH_UINT T0.W, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, PS, literal.y,
; EG-NEXT:    255(3.573311e-43), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: s_ctlz_zero_undef_i8_with_select:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_lshl_b32 s2, s4, 24
; GFX9-GISEL-NEXT:    s_flbit_i32_b32 s2, s2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-GISEL-NEXT:    global_store_byte v1, v0, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
  %ctlz = tail call i8 @llvm.ctlz.i8(i8 %val, i1 true) nounwind readnone
  %ctlz_ret = icmp ne i8 %val, 0
  %ret = select i1 %ctlz_ret, i8 %ctlz, i8 32
  store i8 %ctlz, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @s_ctlz_zero_undef_i16_with_select(ptr addrspace(1) noalias %out, i16 %val) nounwind {
; SI-LABEL: s_ctlz_zero_undef_i16_with_select:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[2:3], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s2, s4, 16
; SI-NEXT:    s_flbit_i32_b32 s4, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctlz_zero_undef_i16_with_select:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s2, s4, 16
; VI-NEXT:    s_flbit_i32_b32 s2, s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_ctlz_zero_undef_i16_with_select:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 14, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 40, #3
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, 0.0,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     FFBH_UINT T0.W, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, PS, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: s_ctlz_zero_undef_i16_with_select:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_lshl_b32 s2, s4, 16
; GFX9-GISEL-NEXT:    s_flbit_i32_b32 s2, s2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-GISEL-NEXT:    global_store_short v1, v0, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
  %ctlz = tail call i16 @llvm.ctlz.i16(i16 %val, i1 true) nounwind readnone
  %ctlz_ret = icmp ne i16 %val, 0
  %ret = select i1 %ctlz_ret, i16 %ctlz, i16 32
  store i16 %ctlz, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @s_ctlz_zero_undef_i32_with_select(ptr addrspace(1) noalias %out, i32 %val) nounwind {
; SI-LABEL: s_ctlz_zero_undef_i32_with_select:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[2:3], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_flbit_i32_b32 s4, s4
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctlz_zero_undef_i32_with_select:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_flbit_i32_b32 s2, s4
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_ctlz_zero_undef_i32_with_select:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     FFBH_UINT * T1.X, KC0[2].Z,
;
; GFX9-GISEL-LABEL: s_ctlz_zero_undef_i32_with_select:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_flbit_i32_b32 s2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
  %ctlz = tail call i32 @llvm.ctlz.i32(i32 %val, i1 true) nounwind readnone
  %ctlz_ret = icmp ne i32 %val, 0
  %ret = select i1 %ctlz_ret, i32 %ctlz, i32 32
  store i32 %ctlz, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @s_ctlz_zero_undef_i64_with_select(ptr addrspace(1) noalias %out, i64 %val) nounwind {
; SI-LABEL: s_ctlz_zero_undef_i64_with_select:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_flbit_i32_b64 s2, s[2:3]
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctlz_zero_undef_i64_with_select:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_mov_b32_e32 v1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_flbit_i32_b64 s2, s[2:3]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_ctlz_zero_undef_i64_with_select:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     FFBH_UINT * T0.W, KC0[2].W,
; EG-NEXT:     FFBH_UINT T1.W, KC0[3].X,
; EG-NEXT:     ADD_INT * T0.W, PV.W, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, KC0[3].X, PS, PV.W,
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: s_ctlz_zero_undef_i64_with_select:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_mov_b32 s1, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_flbit_i32_b64 s0, s[6:7]
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %ctlz = tail call i64 @llvm.ctlz.i64(i64 %val, i1 true) nounwind readnone
  %ctlz_ret = icmp ne i64 %val, 0
  %ret = select i1 %ctlz_ret, i64 %ctlz, i64 32
  store i64 %ctlz, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_i8_with_select(ptr addrspace(1) noalias %out, ptr addrspace(1) nocapture readonly %arrayidx) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i8_with_select:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v0
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, 32, v1, vcc
; SI-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i8_with_select:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_load_ubyte v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v1, 24, v0
; VI-NEXT:    v_ffbh_u32_e32 v1, v1
; VI-NEXT:    v_cmp_ne_u16_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, 32, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_byte v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i8_with_select:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 16, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    24(3.363116e-44), 0(0.000000e+00)
; EG-NEXT:     FFBH_UINT T0.W, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T0.W, T0.X, literal.x, PV.W,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, T1.W, literal.y,
; EG-NEXT:    255(3.573311e-43), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i8_with_select:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_ubyte v1, v0, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v1
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v2, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX9-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, 32, v2, vcc
; GFX9-GISEL-NEXT:    global_store_byte v0, v1, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %val = load i8, ptr addrspace(1) %arrayidx, align 1
  %ctlz = tail call i8 @llvm.ctlz.i8(i8 %val, i1 true) nounwind readnone
  %ctlz_ret = icmp ne i8 %val, 0
  %ret = select i1 %ctlz_ret, i8 %ctlz, i8 32
  store i8 %ret, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_i16_with_select(ptr addrspace(1) noalias %out, ptr addrspace(1) nocapture readonly %arrayidx) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i16_with_select:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0 offset:1
; SI-NEXT:    buffer_load_ubyte v1, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, 32, v1, vcc
; SI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i16_with_select:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_add_u32 s4, s2, 1
; VI-NEXT:    s_addc_u32 s5, s3, 0
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v3, s5
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_load_ubyte v2, v[2:3]
; VI-NEXT:    flat_load_ubyte v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; VI-NEXT:    v_ffbh_u32_e32 v1, v1
; VI-NEXT:    v_cmp_ne_u16_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, 32, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i16_with_select:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 16, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     FFBH_UINT T0.W, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T0.W, T0.X, literal.x, PV.W,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, T1.W, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i16_with_select:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_ubyte v1, v0, s[6:7]
; GFX9-GISEL-NEXT:    global_load_ubyte v2, v0, s[6:7] offset:1
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v1, v2, 8, v1
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v2, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX9-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, 32, v2, vcc
; GFX9-GISEL-NEXT:    global_store_short v0, v1, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %val = load i16, ptr addrspace(1) %arrayidx, align 1
  %ctlz = tail call i16 @llvm.ctlz.i16(i16 %val, i1 true) nounwind readnone
  %ctlz_ret = icmp ne i16 %val, 0
  %ret = select i1 %ctlz_ret, i16 %ctlz, i16 32
  store i16 %ret, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_i32_with_select(ptr addrspace(1) noalias %out, ptr addrspace(1) nocapture readonly %arrayidx) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i32_with_select:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0 offset:1
; SI-NEXT:    buffer_load_ubyte v1, off, s[8:11], 0 offset:3
; SI-NEXT:    buffer_load_ubyte v2, off, s[8:11], 0
; SI-NEXT:    buffer_load_ubyte v3, off, s[8:11], 0 offset:2
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v0, v2
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v1, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_min_u32_e32 v0, 32, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i32_with_select:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_add_u32 s4, s2, 3
; VI-NEXT:    s_addc_u32 s5, s3, 0
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_mov_b32_e32 v3, s5
; VI-NEXT:    s_add_u32 s4, s2, 2
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    s_addc_u32 s5, s3, 0
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_add_u32 s2, s2, 1
; VI-NEXT:    s_addc_u32 s3, s3, 0
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_mov_b32_e32 v7, s3
; VI-NEXT:    v_mov_b32_e32 v5, s5
; VI-NEXT:    v_mov_b32_e32 v6, s2
; VI-NEXT:    flat_load_ubyte v2, v[2:3]
; VI-NEXT:    flat_load_ubyte v3, v[4:5]
; VI-NEXT:    flat_load_ubyte v4, v[6:7]
; VI-NEXT:    flat_load_ubyte v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b32_e32 v1, 8, v2
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_or_b32_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b32_e32 v2, 8, v4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_min_u32_e32 v2, 32, v0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i32_with_select:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 6, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T1.X, T0.X, 2, #1
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     LSHL * T0.W, T1.X, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     OR_INT * T0.W, PV.W, T0.X,
; EG-NEXT:     FFBH_UINT * T1.W, PV.W,
; EG-NEXT:     CNDE_INT T0.X, T0.W, literal.x, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    32(4.484155e-44), 2(2.802597e-45)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i32_with_select:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_ubyte v1, v0, s[6:7]
; GFX9-GISEL-NEXT:    global_load_ubyte v2, v0, s[6:7] offset:1
; GFX9-GISEL-NEXT:    global_load_ubyte v3, v0, s[6:7] offset:3
; GFX9-GISEL-NEXT:    global_load_ubyte v4, v0, s[6:7] offset:2
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v1, v2, 8, v1
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX9-GISEL-NEXT:    v_or3_b32 v1, v2, v3, v1
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v2, v1
; GFX9-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, 32, v2, vcc
; GFX9-GISEL-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %val = load i32, ptr addrspace(1) %arrayidx, align 1
  %ctlz = tail call i32 @llvm.ctlz.i32(i32 %val, i1 true) nounwind readnone
  %ctlz_ret = icmp ne i32 %val, 0
  %ret = select i1 %ctlz_ret, i32 %ctlz, i32 32
  store i32 %ret, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_i64_with_select(ptr addrspace(1) noalias %out, ptr addrspace(1) nocapture readonly %arrayidx) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i64_with_select:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s10, s2
; SI-NEXT:    s_mov_b32 s11, s3
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s6
; SI-NEXT:    s_mov_b32 s9, s7
; SI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0 offset:5
; SI-NEXT:    buffer_load_ubyte v1, off, s[8:11], 0 offset:7
; SI-NEXT:    buffer_load_ubyte v2, off, s[8:11], 0
; SI-NEXT:    buffer_load_ubyte v3, off, s[8:11], 0 offset:1
; SI-NEXT:    buffer_load_ubyte v4, off, s[8:11], 0 offset:2
; SI-NEXT:    buffer_load_ubyte v5, off, s[8:11], 0 offset:3
; SI-NEXT:    buffer_load_ubyte v6, off, s[8:11], 0 offset:4
; SI-NEXT:    buffer_load_ubyte v7, off, s[8:11], 0 offset:6
; SI-NEXT:    s_mov_b32 s0, s4
; SI-NEXT:    s_mov_b32 s1, s5
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v0, v6
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v1, v7
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v3, v5, v4
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 32, v1
; SI-NEXT:    v_min_u32_e32 v0, v1, v0
; SI-NEXT:    v_min_u32_e32 v0, 64, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i64_with_select:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_add_u32 s4, s2, 5
; VI-NEXT:    s_addc_u32 s5, s3, 0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_add_u32 s4, s2, 4
; VI-NEXT:    s_addc_u32 s5, s3, 0
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_mov_b32_e32 v3, s5
; VI-NEXT:    s_add_u32 s4, s2, 7
; VI-NEXT:    s_addc_u32 s5, s3, 0
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_mov_b32_e32 v5, s5
; VI-NEXT:    s_add_u32 s4, s2, 6
; VI-NEXT:    s_addc_u32 s5, s3, 0
; VI-NEXT:    v_mov_b32_e32 v7, s5
; VI-NEXT:    v_mov_b32_e32 v6, s4
; VI-NEXT:    s_add_u32 s4, s2, 3
; VI-NEXT:    s_addc_u32 s5, s3, 0
; VI-NEXT:    v_mov_b32_e32 v9, s5
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    s_add_u32 s4, s2, 2
; VI-NEXT:    s_addc_u32 s5, s3, 0
; VI-NEXT:    v_mov_b32_e32 v11, s5
; VI-NEXT:    v_mov_b32_e32 v10, s4
; VI-NEXT:    s_add_u32 s4, s2, 1
; VI-NEXT:    flat_load_ubyte v12, v[0:1]
; VI-NEXT:    flat_load_ubyte v13, v[2:3]
; VI-NEXT:    flat_load_ubyte v4, v[4:5]
; VI-NEXT:    flat_load_ubyte v5, v[6:7]
; VI-NEXT:    s_addc_u32 s5, s3, 0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    flat_load_ubyte v6, v[8:9]
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_load_ubyte v7, v[10:11]
; VI-NEXT:    flat_load_ubyte v0, v[0:1]
; VI-NEXT:    flat_load_ubyte v2, v[2:3]
; VI-NEXT:    v_mov_b32_e32 v1, 0
; VI-NEXT:    s_waitcnt vmcnt(7)
; VI-NEXT:    v_lshlrev_b32_e32 v3, 8, v12
; VI-NEXT:    s_waitcnt vmcnt(6)
; VI-NEXT:    v_or_b32_e32 v3, v3, v13
; VI-NEXT:    s_waitcnt vmcnt(5)
; VI-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_or_b32_sdwa v4, v4, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v4, v3
; VI-NEXT:    v_ffbh_u32_e32 v3, v3
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b32_e32 v4, 8, v6
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_or_b32_sdwa v4, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    v_or_b32_e32 v0, v4, v0
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 32, v0
; VI-NEXT:    v_min_u32_e32 v0, v0, v3
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_min_u32_e32 v0, 64, v0
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i64_with_select:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 3 @6
; EG-NEXT:    ALU 15, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T1.X, T0.X, 2, #1
; EG-NEXT:     VTX_READ_16 T2.X, T0.X, 4, #1
; EG-NEXT:     VTX_READ_16 T3.X, T0.X, 6, #1
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     LSHL * T0.W, T1.X, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     OR_INT * T0.W, PV.W, T0.X,
; EG-NEXT:     FFBH_UINT T1.W, PV.W,
; EG-NEXT:     LSHL * T2.W, T3.X, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.W, T0.W, literal.x, PV.W,
; EG-NEXT:     OR_INT * T1.W, PS, T2.X,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     FFBH_UINT T2.W, PS,
; EG-NEXT:     ADD_INT * T0.W, PV.W, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T1.W, PS, PV.W,
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i64_with_select:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_ubyte v0, v1, s[6:7]
; GFX9-GISEL-NEXT:    global_load_ubyte v2, v1, s[6:7] offset:1
; GFX9-GISEL-NEXT:    global_load_ubyte v3, v1, s[6:7] offset:2
; GFX9-GISEL-NEXT:    global_load_ubyte v4, v1, s[6:7] offset:3
; GFX9-GISEL-NEXT:    global_load_ubyte v5, v1, s[6:7] offset:4
; GFX9-GISEL-NEXT:    global_load_ubyte v6, v1, s[6:7] offset:5
; GFX9-GISEL-NEXT:    global_load_ubyte v7, v1, s[6:7] offset:6
; GFX9-GISEL-NEXT:    global_load_ubyte v8, v1, s[6:7] offset:7
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(6)
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v2, 8, v0
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(5)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(4)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v4
; GFX9-GISEL-NEXT:    v_or3_b32 v2, v2, v3, v0
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v4, v6, 8, v5
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v8, 24, v5
; GFX9-GISEL-NEXT:    v_or3_b32 v3, v0, v4, 0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v2
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v4, v3
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 32, v0
; GFX9-GISEL-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[2:3]
; GFX9-GISEL-NEXT:    v_min_u32_e32 v0, v4, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, 64, v0, vcc
; GFX9-GISEL-NEXT:    global_store_dwordx2 v1, v[0:1], s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %val = load i64, ptr addrspace(1) %arrayidx, align 1
  %ctlz = tail call i64 @llvm.ctlz.i64(i64 %val, i1 true) nounwind readnone
  %ctlz_ret = icmp ne i64 %val, 0
  %ret = select i1 %ctlz_ret, i64 %ctlz, i64 64
  store i64 %ret, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_i8(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_ubyte v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; VI-NEXT:    v_ffbh_u32_e32 v2, v0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_byte v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i8:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 14, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, T0.X,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    24(3.363116e-44), 0(0.000000e+00)
; EG-NEXT:     FFBH_UINT T0.W, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, PS, literal.y,
; EG-NEXT:    255(3.573311e-43), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i8:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_ashrrev_i32_e32 v3, 31, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v1, v0
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v3, vcc
; GFX9-GISEL-NEXT:    global_load_ubyte v0, v[0:1], off
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    global_store_byte v1, v0, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i8, ptr addrspace(1) %valptr, i32 %tid
  %val = load i8, ptr addrspace(1) %in.gep
  %ctlz = call i8 @llvm.ctlz.i8(i8 %val, i1 true) nounwind readnone
  store i8 %ctlz, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_ctlz_zero_undef_i64(ptr addrspace(1) noalias %out, [8 x i32], i64 %val) nounwind {
; SI-LABEL: s_ctlz_zero_undef_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_flbit_i32_b64 s4, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctlz_zero_undef_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x4c
; VI-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x24
; VI-NEXT:    v_mov_b32_e32 v1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_flbit_i32_b64 s0, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_ctlz_zero_undef_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     FFBH_UINT * T0.W, KC0[4].W,
; EG-NEXT:     FFBH_UINT T1.W, KC0[5].X,
; EG-NEXT:     ADD_INT * T0.W, PV.W, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, KC0[5].X, PS, PV.W,
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: s_ctlz_zero_undef_i64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x4c
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_mov_b32 s3, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_flbit_i32_b64 s2, s[0:1]
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %ctlz = call i64 @llvm.ctlz.i64(i64 %val, i1 true)
  store i64 %ctlz, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_ctlz_zero_undef_i64_trunc(ptr addrspace(1) noalias %out, i64 %val) nounwind {
; SI-LABEL: s_ctlz_zero_undef_i64_trunc:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_flbit_i32_b64 s2, s[2:3]
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctlz_zero_undef_i64_trunc:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_flbit_i32_b64 s2, s[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_ctlz_zero_undef_i64_trunc:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 6, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     FFBH_UINT * T0.W, KC0[2].W,
; EG-NEXT:     FFBH_UINT T1.W, KC0[3].X,
; EG-NEXT:     ADD_INT * T0.W, PV.W, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, KC0[3].X, PS, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: s_ctlz_zero_undef_i64_trunc:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_flbit_i32_b64 s0, s[6:7]
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %ctlz = call i64 @llvm.ctlz.i64(i64 %val, i1 true)
  %trunc = trunc i64 %ctlz to i32
  store i32 %trunc, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_i64(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-NEXT:    buffer_load_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v2, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 32, v2
; SI-NEXT:    v_ffbh_u32_e32 v3, v3
; SI-NEXT:    v_min_u32_e32 v2, v2, v3
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v3, 3, v0
; VI-NEXT:    v_mov_b32_e32 v2, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v3
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v4, s1
; VI-NEXT:    v_add_u32_e32 v3, vcc, s0, v3
; VI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 32, v0
; VI-NEXT:    v_ffbh_u32_e32 v1, v1
; VI-NEXT:    v_min_u32_e32 v1, v0, v1
; VI-NEXT:    flat_store_dwordx2 v[3:4], v[1:2]
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 8, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T1.W, T0.X,
; EG-NEXT:     FFBH_UINT T2.W, T0.Y,
; EG-NEXT:     ADD_INT * T1.W, PV.W, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T0.Y, PS, PV.W,
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, T0.W,
; EG-NEXT:     LSHR * T1.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dwordx2 v[0:1], v2, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 32, v0
; GFX9-GISEL-NEXT:    v_min_u32_e32 v0, v1, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %tid
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %tid
  %val = load i64, ptr addrspace(1) %in.gep
  %ctlz = call i64 @llvm.ctlz.i64(i64 %val, i1 true)
  store i64 %ctlz, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_i64_trunc(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i64_trunc:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; SI-NEXT:    v_mov_b32_e32 v2, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-NEXT:    buffer_load_dwordx2 v[3:4], v[1:2], s[4:7], 0 addr64
; SI-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; SI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v3
; SI-NEXT:    v_add_i32_e32 v0, vcc, 32, v0
; SI-NEXT:    v_ffbh_u32_e32 v3, v4
; SI-NEXT:    v_min_u32_e32 v0, v0, v3
; SI-NEXT:    buffer_store_dword v0, v[1:2], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i64_trunc:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s3
; VI-NEXT:    v_add_u32_e32 v1, vcc, s2, v1
; VI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; VI-NEXT:    flat_load_dwordx2 v[1:2], v[1:2]
; VI-NEXT:    v_mov_b32_e32 v4, s1
; VI-NEXT:    v_add_u32_e32 v3, vcc, s0, v0
; VI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v0, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 32, v0
; VI-NEXT:    v_ffbh_u32_e32 v1, v2
; VI-NEXT:    v_min_u32_e32 v0, v0, v1
; VI-NEXT:    flat_store_dword v[3:4], v0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i64_trunc:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 8, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T1.XY, T1.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T1.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T1.X,
; EG-NEXT:     LSHL T0.Z, T0.X, literal.x,
; EG-NEXT:     FFBH_UINT T1.W, T1.Y,
; EG-NEXT:     ADD_INT * T0.W, PV.W, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT T0.X, T1.Y, PS, PV.W,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, PV.Z,
; EG-NEXT:     LSHR * T1.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i64_trunc:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dwordx2 v[1:2], v1, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v2, v2
; GFX9-GISEL-NEXT:    v_add_u32_e32 v1, 32, v1
; GFX9-GISEL-NEXT:    v_min_u32_e32 v1, v2, v1
; GFX9-GISEL-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %tid
  %out.gep = getelementptr i32, ptr addrspace(1) %out, i32 %tid
  %val = load i64, ptr addrspace(1) %in.gep
  %ctlz = call i64 @llvm.ctlz.i64(i64 %val, i1 true)
  %trunc = trunc i64 %ctlz to i32
  store i32 %trunc, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_i32_sel_eq_neg1(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i32_sel_eq_neg1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i32_sel_eq_neg1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v2, v0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i32_sel_eq_neg1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 3, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T0.X,
; EG-NEXT:     CNDE_INT T0.X, T0.X, literal.x, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    -1(nan), 2(2.802597e-45)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i32_sel_eq_neg1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v0
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, v1, -1, vcc
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 true) nounwind readnone
  %cmp = icmp eq i32 %val, 0
  %sel = select i1 %cmp, i32 -1, i32 %ctlz
  store i32 %sel, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_i32_sel_ne_neg1(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i32_sel_ne_neg1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i32_sel_ne_neg1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v2, v0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i32_sel_ne_neg1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 3, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T0.X,
; EG-NEXT:     CNDE_INT T0.X, T0.X, literal.x, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    -1(nan), 2(2.802597e-45)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i32_sel_ne_neg1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v0
; GFX9-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, -1, v1, vcc
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 true) nounwind readnone
  %cmp = icmp ne i32 %val, 0
  %sel = select i1 %cmp, i32 %ctlz, i32 -1
  store i32 %sel, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_i8_sel_eq_neg1(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i8_sel_eq_neg1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_ubyte v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i8_sel_eq_neg1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v2, v0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_byte v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i8_sel_eq_neg1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 12, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, T0.X,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     FFBH_UINT T0.W, T0.X,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, PS, literal.y,
; EG-NEXT:    255(3.573311e-43), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i8_sel_eq_neg1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_ashrrev_i32_e32 v3, 31, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v1, v0
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v3, vcc
; GFX9-GISEL-NEXT:    global_load_ubyte v0, v[0:1], off
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v2, v2
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_sdwa s[0:1], v0, v1 src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, v2, -1, s[0:1]
; GFX9-GISEL-NEXT:    global_store_byte v1, v0, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %valptr.gep = getelementptr i8, ptr addrspace(1) %valptr, i32 %tid
  %val = load i8, ptr addrspace(1) %valptr.gep
  %ctlz = call i8 @llvm.ctlz.i8(i8 %val, i1 true) nounwind readnone
  %cmp = icmp eq i8 %val, 0
  %sel = select i1 %cmp, i8 -1, i8 %ctlz
  store i8 %sel, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_ctlz_zero_undef_i32_sel_eq_neg1_two_use(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i32_sel_eq_neg1_two_use:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v1, v0
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; SI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-NEXT:    buffer_store_dword v1, off, s[4:7], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i32_sel_eq_neg1_two_use:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v2, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v3, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; VI-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-NEXT:    flat_store_dword v[0:1], v3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_store_byte v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i32_sel_eq_neg1_two_use:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 11, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T3.X, 0
; EG-NEXT:    MEM_RAT MSKOR T1.XW, T2.X
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     SETE_INT * T0.W, T0.X, 0.0,
; EG-NEXT:     AND_INT T1.X, PV.W, 1,
; EG-NEXT:     MOV * T1.W, literal.x,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T1.Y, 0.0,
; EG-NEXT:     MOV * T1.Z, 0.0,
; EG-NEXT:     MOV T2.X, literal.x,
; EG-NEXT:     FFBH_UINT * T0.W, T0.X,
; EG-NEXT:    0(0.000000e+00), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T0.X, literal.x, PV.W,
; EG-NEXT:     LSHR * T3.X, KC0[2].Y, literal.y,
; EG-NEXT:    -1(nan), 2(2.802597e-45)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i32_sel_eq_neg1_two_use:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v2, v0
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, v2, -1, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-GISEL-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    global_store_byte v[0:1], v2, off
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 true) nounwind readnone
  %cmp = icmp eq i32 %val, 0
  %sel = select i1 %cmp, i32 -1, i32 %ctlz
  store volatile i32 %sel, ptr addrspace(1) %out
  store volatile i1 %cmp, ptr addrspace(1) undef
  ret void
}

; Selected on wrong constant
define amdgpu_kernel void @v_ctlz_zero_undef_i32_sel_eq_0(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i32_sel_eq_0:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v1, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i32_sel_eq_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v1, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, 0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i32_sel_eq_0:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 3, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T0.X,
; EG-NEXT:     CNDE_INT T0.X, T0.X, 0.0, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i32_sel_eq_0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v0
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 true) nounwind readnone
  %cmp = icmp eq i32 %val, 0
  %sel = select i1 %cmp, i32 0, i32 %ctlz
  store i32 %sel, ptr addrspace(1) %out
  ret void
}

; Selected on wrong constant
define amdgpu_kernel void @v_ctlz_zero_undef_i32_sel_ne_0(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i32_sel_ne_0:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v1, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i32_sel_ne_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v1, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, 0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i32_sel_ne_0:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 3, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T0.X,
; EG-NEXT:     CNDE_INT T0.X, T0.X, 0.0, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i32_sel_ne_0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v0
; GFX9-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 true) nounwind readnone
  %cmp = icmp ne i32 %val, 0
  %sel = select i1 %cmp, i32 %ctlz, i32 0
  store i32 %sel, ptr addrspace(1) %out
  ret void
}

; Compare on wrong constant
define amdgpu_kernel void @v_ctlz_zero_undef_i32_sel_eq_cmp_non0(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i32_sel_eq_cmp_non0:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v1, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 1, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i32_sel_eq_cmp_non0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v1, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 1, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, 0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i32_sel_eq_cmp_non0:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 4, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT T0.W, T0.X,
; EG-NEXT:     SETE_INT * T1.W, T0.X, 1,
; EG-NEXT:     CNDE_INT T0.X, PS, PV.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i32_sel_eq_cmp_non0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v0
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 true) nounwind readnone
  %cmp = icmp eq i32 %val, 1
  %sel = select i1 %cmp, i32 0, i32 %ctlz
  store i32 %sel, ptr addrspace(1) %out
  ret void
}

; Selected on wrong constant
define amdgpu_kernel void @v_ctlz_zero_undef_i32_sel_ne_cmp_non0(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_zero_undef_i32_sel_ne_cmp_non0:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v1, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 1, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_zero_undef_i32_sel_ne_cmp_non0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v1, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 1, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, 0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_zero_undef_i32_sel_ne_cmp_non0:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 4, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT T0.W, T0.X,
; EG-NEXT:     SETNE_INT * T1.W, T0.X, 1,
; EG-NEXT:     CNDE_INT T0.X, PS, 0.0, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i32_sel_ne_cmp_non0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v0, v0, s[6:7]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v0
; GFX9-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 1, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 true) nounwind readnone
  %cmp = icmp ne i32 %val, 1
  %sel = select i1 %cmp, i32 %ctlz, i32 0
  store i32 %sel, ptr addrspace(1) %out
  ret void
}

define i7 @v_ctlz_zero_undef_i7(i7 %val) {
; SI-LABEL: v_ctlz_zero_undef_i7:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 25, v0
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_ctlz_zero_undef_i7:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 25, v0
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_ctlz_zero_undef_i7:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i7:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 25, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %ctlz = call i7 @llvm.ctlz.i7(i7 %val, i1 true)
  ret i7 %ctlz
}

define amdgpu_kernel void @s_ctlz_zero_undef_i18(ptr addrspace(1) noalias %out, i18 %val) nounwind {
; SI-LABEL: s_ctlz_zero_undef_i18:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[2:3], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s2, s4, 14
; SI-NEXT:    s_flbit_i32_b32 s4, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    s_bfe_u32 s4, s4, 0x20010
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0 offset:2
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctlz_zero_undef_i18:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s2, s4, 14
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_flbit_i32_b32 s2, s2
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_add_u32 s0, s0, 2
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_bfe_u32 s2, s2, 0x20010
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_byte v[0:1], v2
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_ctlz_zero_undef_i18:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 28, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T1.XW, T3.X
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T2.X
; EG-NEXT:    CF_END
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     LSHL * T0.W, KC0[2].Z, literal.x,
; EG-NEXT:    14(1.961818e-44), 0(0.000000e+00)
; EG-NEXT:     FFBH_UINT T0.W, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T2.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, PS, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T1.X, PV.W, PS,
; EG-NEXT:     LSHL * T1.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T1.Y, 0.0,
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T3.W, PV.W, literal.x,
; EG-NEXT:     MOV * T4.W, literal.y,
; EG-NEXT:    3(4.203895e-45), 2(2.802597e-45)
; EG-NEXT:     BFE_UINT T0.W, T0.W, literal.x, PS,
; EG-NEXT:     LSHL * T3.W, PV.W, literal.y,
; EG-NEXT:    16(2.242078e-44), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV T1.Z, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR T2.X, T2.W, literal.x,
; EG-NEXT:     LSHR * T3.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-GISEL-LABEL: s_ctlz_zero_undef_i18:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_lshl_b32 s2, s4, 14
; GFX9-GISEL-NEXT:    s_flbit_i32_b32 s2, s2
; GFX9-GISEL-NEXT:    s_and_b32 s2, s2, 0x3ffff
; GFX9-GISEL-NEXT:    s_lshr_b32 s3, s2, 16
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-GISEL-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-GISEL-NEXT:    global_store_byte v0, v1, s[0:1] offset:2
; GFX9-GISEL-NEXT:    s_endpgm
  %ctlz = call i18 @llvm.ctlz.i18(i18 %val, i1 true) nounwind readnone
  store i18 %ctlz, ptr addrspace(1) %out, align 4
  ret void
}

define i18 @v_ctlz_zero_undef_i18(i18 %val) {
; SI-LABEL: v_ctlz_zero_undef_i18:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 14, v0
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_ctlz_zero_undef_i18:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 14, v0
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_ctlz_zero_undef_i18:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_i18:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 14, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %ctlz = call i18 @llvm.ctlz.i18(i18 %val, i1 true)
  ret i18 %ctlz
}

define <2 x i18> @v_ctlz_zero_undef_v2i18(<2 x i18> %val) {
; SI-LABEL: v_ctlz_zero_undef_v2i18:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 14, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 14, v1
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_ctlz_zero_undef_v2i18:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 14, v0
; VI-NEXT:    v_lshlrev_b32_e32 v1, 14, v1
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_ffbh_u32_e32 v1, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_ctlz_zero_undef_v2i18:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_v2i18:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 14, v0
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 14, v1
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %ctlz = call <2 x i18> @llvm.ctlz.v2i18(<2 x i18> %val, i1 true)
  ret <2 x i18> %ctlz
}

define <2 x i16> @v_ctlz_zero_undef_v2i16(<2 x i16> %val) {
; SI-LABEL: v_ctlz_zero_undef_v2i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_or_b32_e32 v0, v0, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_ctlz_zero_undef_v2i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_ffbh_u32_sdwa v1, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_ctlz_zero_undef_v2i16:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_v2i16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %ctlz = call <2 x i16> @llvm.ctlz.v2i16(<2 x i16> %val, i1 true)
  ret <2 x i16> %ctlz
}

define <3 x i16> @v_ctlz_zero_undef_v3i16(<3 x i16> %val) {
; SI-LABEL: v_ctlz_zero_undef_v3i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_ffbh_u32_e32 v3, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_or_b32_e32 v2, 0x200000, v3
; SI-NEXT:    v_alignbit_b32 v1, v3, v0, 16
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_ctlz_zero_undef_v3i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_ffbh_u32_e32 v2, v2
; VI-NEXT:    v_ffbh_u32_sdwa v0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-NEXT:    v_ffbh_u32_e32 v1, v1
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_ctlz_zero_undef_v3i16:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_v3i16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v2, v2
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v2, 16, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %ctlz = call <3 x i16> @llvm.ctlz.v3i16(<3 x i16> %val, i1 true)
  ret <3 x i16> %ctlz
}

define <4 x i16> @v_ctlz_zero_undef_v4i16(<4 x i16> %val) {
; SI-LABEL: v_ctlz_zero_undef_v4i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_ffbh_u32_e32 v3, v3
; SI-NEXT:    v_ffbh_u32_e32 v2, v2
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_ctlz_zero_undef_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_ffbh_u32_e32 v2, v2
; VI-NEXT:    v_ffbh_u32_sdwa v1, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-NEXT:    v_ffbh_u32_e32 v3, v3
; VI-NEXT:    v_ffbh_u32_sdwa v0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_ctlz_zero_undef_v4i16:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_v4i16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v2, v2
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v3, v3
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v2, 16, v0
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v1, v3, 16, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %ctlz = call <4 x i16> @llvm.ctlz.v4i16(<4 x i16> %val, i1 true)
  ret <4 x i16> %ctlz
}

define <2 x i8> @v_ctlz_zero_undef_v2i8(<2 x i8> %val) {
; SI-LABEL: v_ctlz_zero_undef_v2i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v1
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_or_b32_e32 v0, v0, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_ctlz_zero_undef_v2i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; VI-NEXT:    v_ffbh_u32_e32 v1, v1
; VI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v1
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_ctlz_zero_undef_v2i8:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_v2i8:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %ctlz = call <2 x i8> @llvm.ctlz.v2i8(<2 x i8> %val, i1 true)
  ret <2 x i8> %ctlz
}

define <2 x i7> @v_ctlz_zero_undef_v2i7(<2 x i7> %val) {
; SI-LABEL: v_ctlz_zero_undef_v2i7:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 25, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 25, v1
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_ctlz_zero_undef_v2i7:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 25, v0
; VI-NEXT:    v_lshlrev_b32_e32 v1, 25, v1
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_ffbh_u32_e32 v1, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_ctlz_zero_undef_v2i7:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
;
; GFX9-GISEL-LABEL: v_ctlz_zero_undef_v2i7:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 25, v0
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 25, v1
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX9-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %ctlz = call <2 x i7> @llvm.ctlz.v2i7(<2 x i7> %val, i1 true)
  ret <2 x i7> %ctlz
}
