; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=riscv32 -mattr=+v < %s | FileCheck %s -check-prefix=RV32
; RUN: llc -mtriple=riscv64 -mattr=+v < %s | FileCheck %s -check-prefix=RV64

; FIXED WIDTH

define i16 @ctz_v4i32(<4 x i32> %a) {
; RV32-LABEL: ctz_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmsne.vi v0, v8, 0
; RV32-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; RV32-NEXT:    vmv.v.i v8, 0
; RV32-NEXT:    vmerge.vim v8, v8, -1, v0
; RV32-NEXT:    vid.v v9
; RV32-NEXT:    vrsub.vi v9, v9, 4
; RV32-NEXT:    vand.vv v8, v8, v9
; RV32-NEXT:    vredmaxu.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 4
; RV32-NEXT:    sub a1, a1, a0
; RV32-NEXT:    andi a0, a1, 255
; RV32-NEXT:    ret
;
; RV64-LABEL: ctz_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-NEXT:    vmsne.vi v0, v8, 0
; RV64-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; RV64-NEXT:    vmv.v.i v8, 0
; RV64-NEXT:    vmerge.vim v8, v8, -1, v0
; RV64-NEXT:    vid.v v9
; RV64-NEXT:    vrsub.vi v9, v9, 4
; RV64-NEXT:    vand.vv v8, v8, v9
; RV64-NEXT:    vredmaxu.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    li a1, 4
; RV64-NEXT:    subw a1, a1, a0
; RV64-NEXT:    andi a0, a1, 255
; RV64-NEXT:    ret
  %res = call i16 @llvm.experimental.cttz.elts.i16.v4i32(<4 x i32> %a, i1 0)
  ret i16 %res
}

; ZERO IS POISON

define i32 @ctz_v2i1_poison(<2 x i1> %a) {
; RV32-LABEL: ctz_v2i1_poison:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; RV32-NEXT:    vfirst.m a0, v0
; RV32-NEXT:    ret
;
; RV64-LABEL: ctz_v2i1_poison:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; RV64-NEXT:    vfirst.m a0, v0
; RV64-NEXT:    ret
  %res = call i32 @llvm.experimental.cttz.elts.i32.v2i1(<2 x i1> %a, i1 1)
  ret i32 %res
}

declare i32 @llvm.experimental.cttz.elts.i32.v2i1(<2 x i1>, i1)
declare i16 @llvm.experimental.cttz.elts.i16.v4i32(<4 x i32>, i1)
