; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

;
; SABD
;

define <vscale x 16 x i8> @sabd_b(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b) #0 {
; CHECK-LABEL: sabd_b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    sabd z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
  %a.sext = sext <vscale x 16 x i8> %a to <vscale x 16 x i16>
  %b.sext = sext <vscale x 16 x i8> %b to <vscale x 16 x i16>
  %sub = sub <vscale x 16 x i16> %a.sext, %b.sext
  %abs = call <vscale x 16 x i16> @llvm.abs.nxv16i16(<vscale x 16 x i16> %sub, i1 true)
  %trunc = trunc <vscale x 16 x i16> %abs to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %trunc
}

define <vscale x 16 x i8> @sabd_b_promoted_ops(<vscale x 16 x i1> %a, <vscale x 16 x i1> %b) #0 {
; CHECK-LABEL: sabd_b_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z0.b, p0/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z1.b, p1/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    sabd z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
  %a.sext = sext <vscale x 16 x i1> %a to <vscale x 16 x i8>
  %b.sext = sext <vscale x 16 x i1> %b to <vscale x 16 x i8>
  %sub = sub <vscale x 16 x i8> %a.sext, %b.sext
  %abs = call <vscale x 16 x i8> @llvm.abs.nxv16i8(<vscale x 16 x i8> %sub, i1 true)
  ret <vscale x 16 x i8> %abs
}

define <vscale x 8 x i16> @sabd_h(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b) #0 {
; CHECK-LABEL: sabd_h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    sabd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
  %a.sext = sext <vscale x 8 x i16> %a to <vscale x 8 x i32>
  %b.sext = sext <vscale x 8 x i16> %b to <vscale x 8 x i32>
  %sub = sub <vscale x 8 x i32> %a.sext, %b.sext
  %abs = call <vscale x 8 x i32> @llvm.abs.nxv8i32(<vscale x 8 x i32> %sub, i1 true)
  %trunc = trunc <vscale x 8 x i32> %abs to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %trunc
}

define <vscale x 8 x i16> @sabd_h_promoted_ops(<vscale x 8 x i8> %a, <vscale x 8 x i8> %b) #0 {
; CHECK-LABEL: sabd_h_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    sxtb z0.h, p0/m, z0.h
; CHECK-NEXT:    sxtb z1.h, p0/m, z1.h
; CHECK-NEXT:    sabd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
  %a.sext = sext <vscale x 8 x i8> %a to <vscale x 8 x i16>
  %b.sext = sext <vscale x 8 x i8> %b to <vscale x 8 x i16>
  %sub = sub <vscale x 8 x i16> %a.sext, %b.sext
  %abs = call <vscale x 8 x i16> @llvm.abs.nxv8i16(<vscale x 8 x i16> %sub, i1 true)
  ret <vscale x 8 x i16> %abs
}

define <vscale x 4 x i32> @sabd_s(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) #0 {
; CHECK-LABEL: sabd_s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sabd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
  %a.sext = sext <vscale x 4 x i32> %a to <vscale x 4 x i64>
  %b.sext = sext <vscale x 4 x i32> %b to <vscale x 4 x i64>
  %sub = sub <vscale x 4 x i64> %a.sext, %b.sext
  %abs = call <vscale x 4 x i64> @llvm.abs.nxv4i64(<vscale x 4 x i64> %sub, i1 true)
  %trunc = trunc <vscale x 4 x i64> %abs to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %trunc
}

define <vscale x 4 x i32> @sabd_s_promoted_ops(<vscale x 4 x i16> %a, <vscale x 4 x i16> %b) #0 {
; CHECK-LABEL: sabd_s_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sxth z0.s, p0/m, z0.s
; CHECK-NEXT:    sxth z1.s, p0/m, z1.s
; CHECK-NEXT:    sabd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
  %a.sext = sext <vscale x 4 x i16> %a to <vscale x 4 x i32>
  %b.sext = sext <vscale x 4 x i16> %b to <vscale x 4 x i32>
  %sub = sub <vscale x 4 x i32> %a.sext, %b.sext
  %abs = call <vscale x 4 x i32> @llvm.abs.nxv4i32(<vscale x 4 x i32> %sub, i1 true)
  ret <vscale x 4 x i32> %abs
}

define <vscale x 2 x i64> @sabd_d(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) #0 {
; CHECK-LABEL: sabd_d:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    sabd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
  %a.sext = sext <vscale x 2 x i64> %a to <vscale x 2 x i128>
  %b.sext = sext <vscale x 2 x i64> %b to <vscale x 2 x i128>
  %sub = sub <vscale x 2 x i128> %a.sext, %b.sext
  %abs = call <vscale x 2 x i128> @llvm.abs.nxv2i128(<vscale x 2 x i128> %sub, i1 true)
  %trunc = trunc <vscale x 2 x i128> %abs to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %trunc
}

define <vscale x 2 x i64> @sabd_d_promoted_ops(<vscale x 2 x i32> %a, <vscale x 2 x i32> %b) #0 {
; CHECK-LABEL: sabd_d_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    sxtw z0.d, p0/m, z0.d
; CHECK-NEXT:    sxtw z1.d, p0/m, z1.d
; CHECK-NEXT:    sabd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
  %a.sext = sext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %b.sext = sext <vscale x 2 x i32> %b to <vscale x 2 x i64>
  %sub = sub <vscale x 2 x i64> %a.sext, %b.sext
  %abs = call <vscale x 2 x i64> @llvm.abs.nxv2i64(<vscale x 2 x i64> %sub, i1 true)
  ret <vscale x 2 x i64> %abs
}

;
; UABD
;

define <vscale x 16 x i8> @uabd_b(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b) #0 {
; CHECK-LABEL: uabd_b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    uabd z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
  %a.zext = zext <vscale x 16 x i8> %a to <vscale x 16 x i16>
  %b.zext = zext <vscale x 16 x i8> %b to <vscale x 16 x i16>
  %sub = sub <vscale x 16 x i16> %a.zext, %b.zext
  %abs = call <vscale x 16 x i16> @llvm.abs.nxv16i16(<vscale x 16 x i16> %sub, i1 true)
  %trunc = trunc <vscale x 16 x i16> %abs to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %trunc
}

define <vscale x 16 x i8> @uabd_b_promoted_ops(<vscale x 16 x i1> %a, <vscale x 16 x i1> %b) #0 {
; CHECK-LABEL: uabd_b_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z0.b, p0/z, #1 // =0x1
; CHECK-NEXT:    mov z1.b, p1/z, #1 // =0x1
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    uabd z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
  %a.zext = zext <vscale x 16 x i1> %a to <vscale x 16 x i8>
  %b.zext = zext <vscale x 16 x i1> %b to <vscale x 16 x i8>
  %sub = sub <vscale x 16 x i8> %a.zext, %b.zext
  %abs = call <vscale x 16 x i8> @llvm.abs.nxv16i8(<vscale x 16 x i8> %sub, i1 true)
  ret <vscale x 16 x i8> %abs
}

define <vscale x 8 x i16> @uabd_h(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b) #0 {
; CHECK-LABEL: uabd_h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    uabd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
  %a.zext = zext <vscale x 8 x i16> %a to <vscale x 8 x i32>
  %b.zext = zext <vscale x 8 x i16> %b to <vscale x 8 x i32>
  %sub = sub <vscale x 8 x i32> %a.zext, %b.zext
  %abs = call <vscale x 8 x i32> @llvm.abs.nxv8i32(<vscale x 8 x i32> %sub, i1 true)
  %trunc = trunc <vscale x 8 x i32> %abs to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %trunc
}

define <vscale x 8 x i16> @uabd_h_promoted_ops(<vscale x 8 x i8> %a, <vscale x 8 x i8> %b) #0 {
; CHECK-LABEL: uabd_h_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and z0.h, z0.h, #0xff
; CHECK-NEXT:    and z1.h, z1.h, #0xff
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    uabd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
  %a.zext = zext <vscale x 8 x i8> %a to <vscale x 8 x i16>
  %b.zext = zext <vscale x 8 x i8> %b to <vscale x 8 x i16>
  %sub = sub <vscale x 8 x i16> %a.zext, %b.zext
  %abs = call <vscale x 8 x i16> @llvm.abs.nxv8i16(<vscale x 8 x i16> %sub, i1 true)
  ret <vscale x 8 x i16> %abs
}

define <vscale x 4 x i32> @uabd_s(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) #0 {
; CHECK-LABEL: uabd_s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uabd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
  %a.zext = zext <vscale x 4 x i32> %a to <vscale x 4 x i64>
  %b.zext = zext <vscale x 4 x i32> %b to <vscale x 4 x i64>
  %sub = sub <vscale x 4 x i64> %a.zext, %b.zext
  %abs = call <vscale x 4 x i64> @llvm.abs.nxv4i64(<vscale x 4 x i64> %sub, i1 true)
  %trunc = trunc <vscale x 4 x i64> %abs to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %trunc
}

define <vscale x 4 x i32> @uabd_s_promoted_ops(<vscale x 4 x i16> %a, <vscale x 4 x i16> %b) #0 {
; CHECK-LABEL: uabd_s_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and z0.s, z0.s, #0xffff
; CHECK-NEXT:    and z1.s, z1.s, #0xffff
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uabd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
  %a.zext = zext <vscale x 4 x i16> %a to <vscale x 4 x i32>
  %b.zext = zext <vscale x 4 x i16> %b to <vscale x 4 x i32>
  %sub = sub <vscale x 4 x i32> %a.zext, %b.zext
  %abs = call <vscale x 4 x i32> @llvm.abs.nxv4i32(<vscale x 4 x i32> %sub, i1 true)
  ret <vscale x 4 x i32> %abs
}

define <vscale x 2 x i64> @uabd_d(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) #0 {
; CHECK-LABEL: uabd_d:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    uabd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
  %a.zext = zext <vscale x 2 x i64> %a to <vscale x 2 x i128>
  %b.zext = zext <vscale x 2 x i64> %b to <vscale x 2 x i128>
  %sub = sub <vscale x 2 x i128> %a.zext, %b.zext
  %abs = call <vscale x 2 x i128> @llvm.abs.nxv2i128(<vscale x 2 x i128> %sub, i1 true)
  %trunc = trunc <vscale x 2 x i128> %abs to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %trunc
}

define <vscale x 2 x i64> @uabd_d_promoted_ops(<vscale x 2 x i32> %a, <vscale x 2 x i32> %b) #0 {
; CHECK-LABEL: uabd_d_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and z0.d, z0.d, #0xffffffff
; CHECK-NEXT:    and z1.d, z1.d, #0xffffffff
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    uabd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
  %a.zext = zext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %b.zext = zext <vscale x 2 x i32> %b to <vscale x 2 x i64>
  %sub = sub <vscale x 2 x i64> %a.zext, %b.zext
  %abs = call <vscale x 2 x i64> @llvm.abs.nxv2i64(<vscale x 2 x i64> %sub, i1 true)
  ret <vscale x 2 x i64> %abs
}

; Test the situation where isLegal(ISD::ABD, typeof(%a)) returns true but %a and
; %b have differing types.
define <vscale x 4 x i32> @uabd_non_matching_extension(<vscale x 4 x i32> %a, <vscale x 4 x i8> %b) #0 {
; CHECK-LABEL: uabd_non_matching_extension:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and z1.s, z1.s, #0xff
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uabd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
  %a.zext = zext <vscale x 4 x i32> %a to <vscale x 4 x i64>
  %b.zext = zext <vscale x 4 x i8> %b to <vscale x 4 x i64>
  %sub = sub <vscale x 4 x i64> %a.zext, %b.zext
  %abs = call <vscale x 4 x i64> @llvm.abs.nxv4i64(<vscale x 4 x i64> %sub, i1 true)
  %trunc = trunc <vscale x 4 x i64> %abs to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %trunc
}

; Test the situation where isLegal(ISD::ABD, typeof(%a.zext)) returns true but
; %a and %b have differing types.
define <vscale x 4 x i32> @uabd_non_matching_promoted_ops(<vscale x 4 x i8> %a, <vscale x 4 x i16> %b) #0 {
; CHECK-LABEL: uabd_non_matching_promoted_ops:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and z0.s, z0.s, #0xff
; CHECK-NEXT:    and z1.s, z1.s, #0xffff
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uabd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
  %a.zext = zext <vscale x 4 x i8> %a to <vscale x 4 x i32>
  %b.zext = zext <vscale x 4 x i16> %b to <vscale x 4 x i32>
  %sub = sub <vscale x 4 x i32> %a.zext, %b.zext
  %abs = call <vscale x 4 x i32> @llvm.abs.nxv4i32(<vscale x 4 x i32> %sub, i1 true)
  ret <vscale x 4 x i32> %abs
}

; Test the situation where isLegal(ISD::ABD, typeof(%a)) returns true but %a and
; %b are promoted differently.
define <vscale x 4 x i32> @uabd_non_matching_promotion(<vscale x 4 x i8> %a, <vscale x 4 x i8> %b) #0 {
; CHECK-LABEL: uabd_non_matching_promotion:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    and z0.s, z0.s, #0xff
; CHECK-NEXT:    sxtb z1.s, p0/m, z1.s
; CHECK-NEXT:    sub z0.s, z0.s, z1.s
; CHECK-NEXT:    abs z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %a.zext = zext <vscale x 4 x i8> %a to <vscale x 4 x i32>
  %b.zext = sext <vscale x 4 x i8> %b to <vscale x 4 x i32>
  %sub = sub <vscale x 4 x i32> %a.zext, %b.zext
  %abs = call <vscale x 4 x i32> @llvm.abs.nxv4i32(<vscale x 4 x i32> %sub, i1 true)
  ret <vscale x 4 x i32> %abs
}

declare <vscale x 16 x i8> @llvm.abs.nxv16i8(<vscale x 16 x i8>, i1)

declare <vscale x 8 x i16> @llvm.abs.nxv8i16(<vscale x 8 x i16>, i1)
declare <vscale x 16 x i16> @llvm.abs.nxv16i16(<vscale x 16 x i16>, i1)

declare <vscale x 4 x i32> @llvm.abs.nxv4i32(<vscale x 4 x i32>, i1)
declare <vscale x 8 x i32> @llvm.abs.nxv8i32(<vscale x 8 x i32>, i1)

declare <vscale x 2 x i64> @llvm.abs.nxv2i64(<vscale x 2 x i64>, i1)
declare <vscale x 4 x i64> @llvm.abs.nxv4i64(<vscale x 4 x i64>, i1)

declare <vscale x 2 x i128> @llvm.abs.nxv2i128(<vscale x 2 x i128>, i1)

attributes #0 = { "target-features"="+neon,+sve" }
