; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=amdgpu-simplifylib,instcombine -amdgpu-prelink %s | FileCheck %s

target datalayout = "e-p:64:64-p1:64:64-p2:32:32-p3:32:32-p4:64:64-p5:32:32-p6:32:32-p7:160:256:256:32-p8:128:128-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024-v2048:2048-n32:64-S32-A5-G1-ni:7:8:9"

declare float @_Z3powff(float, float)
declare <2 x float> @_Z3powDv2_fS_(<2 x float>, <2 x float>)
declare <3 x float> @_Z3powDv3_fS_(<3 x float>, <3 x float>)
declare <4 x float> @_Z3powDv4_fS_(<4 x float>, <4 x float>)
declare <8 x float> @_Z3powDv8_fS_(<8 x float>, <8 x float>)
declare <16 x float> @_Z3powDv16_fS_(<16 x float>, <16 x float>)
declare double @_Z3powdd(double, double)
declare <2 x double> @_Z3powDv2_dS_(<2 x double>, <2 x double>)
declare <3 x double> @_Z3powDv3_dS_(<3 x double>, <3 x double>)
declare <4 x double> @_Z3powDv4_dS_(<4 x double>, <4 x double>)
declare <8 x double> @_Z3powDv8_dS_(<8 x double>, <8 x double>)
declare <16 x double> @_Z3powDv16_dS_(<16 x double>, <16 x double>)
declare half @_Z3powDhDh(half, half)
declare <2 x half> @_Z3powDv2_DhS_(<2 x half>, <2 x half>)
declare <3 x half> @_Z3powDv3_DhS_(<3 x half>, <3 x half>)
declare <4 x half> @_Z3powDv4_DhS_(<4 x half>, <4 x half>)
declare <8 x half> @_Z3powDv8_DhS_(<8 x half>, <8 x half>)
declare <16 x half> @_Z3powDv16_DhS_(<16 x half>, <16 x half>)
declare void @llvm.assume(i1 noundef)
declare float @llvm.floor.f32(float)
declare float @llvm.ceil.f32(float)
declare float @llvm.trunc.f32(float)
declare float @llvm.rint.f32(float)
declare float @llvm.nearbyint.f32(float)
declare float @llvm.round.f32(float)
declare float @llvm.roundeven.f32(float)

define float @test_pow_fast_f32(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_fast_f32
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call fast float @_Z3powff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call fast float @_Z3powff(float %x, float %y)
  ret float %pow
}

define <2 x float> @test_pow_fast_v2f32(<2 x float> %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_fast_v2f32
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call fast <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call fast <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %pow
}

define float @test_pow_afn_f32_nnan(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn float @_Z3powff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn nnan float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_afn_f32_nnan_ninf(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_ninf
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan ninf afn float @_Z3powff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float %y)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32_nnan(<2 x float> %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_nnan
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn nnan <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_nnan_ninf(<2 x float> %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_nnan_ninf
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan ninf afn <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn nnan ninf <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %pow
}

define float @test_pow_afn_f32(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_afn_f32
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z3powff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float %y)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32(<2 x float> %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %pow
}

define <3 x float> @test_pow_afn_v3f32(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_pow_afn_v3f32
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <3 x float> @_Z3powDv3_fS_(<3 x float> [[X]], <3 x float> [[Y]])
; CHECK-NEXT:    ret <3 x float> [[POW]]
;
  %pow = tail call afn <3 x float> @_Z3powDv3_fS_(<3 x float> %x, <3 x float> %y)
  ret <3 x float> %pow
}

define <4 x float> @test_pow_afn_v4f32(<4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: define <4 x float> @test_pow_afn_v4f32
; CHECK-SAME: (<4 x float> [[X:%.*]], <4 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <4 x float> @_Z3powDv4_fS_(<4 x float> [[X]], <4 x float> [[Y]])
; CHECK-NEXT:    ret <4 x float> [[POW]]
;
  %pow = tail call afn <4 x float> @_Z3powDv4_fS_(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %pow
}

define <8 x float> @test_pow_afn_v8f32(<8 x float> %x, <8 x float> %y) {
; CHECK-LABEL: define <8 x float> @test_pow_afn_v8f32
; CHECK-SAME: (<8 x float> [[X:%.*]], <8 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <8 x float> @_Z3powDv8_fS_(<8 x float> [[X]], <8 x float> [[Y]])
; CHECK-NEXT:    ret <8 x float> [[POW]]
;
  %pow = tail call afn <8 x float> @_Z3powDv8_fS_(<8 x float> %x, <8 x float> %y)
  ret <8 x float> %pow
}

define <16 x float> @test_pow_afn_v16f32(<16 x float> %x, <16 x float> %y) {
; CHECK-LABEL: define <16 x float> @test_pow_afn_v16f32
; CHECK-SAME: (<16 x float> [[X:%.*]], <16 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <16 x float> @_Z3powDv16_fS_(<16 x float> [[X]], <16 x float> [[Y]])
; CHECK-NEXT:    ret <16 x float> [[POW]]
;
  %pow = tail call afn <16 x float> @_Z3powDv16_fS_(<16 x float> %x, <16 x float> %y)
  ret <16 x float> %pow
}

define double @test_pow_afn_f64(double %x, double %y) {
; CHECK-LABEL: define double @test_pow_afn_f64
; CHECK-SAME: (double [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn double @_Z3powdd(double [[X]], double [[Y]])
; CHECK-NEXT:    ret double [[POW]]
;
  %pow = tail call afn double @_Z3powdd(double %x, double %y)
  ret double %pow
}

define <2 x double> @test_pow_afn_v2f64(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: define <2 x double> @test_pow_afn_v2f64
; CHECK-SAME: (<2 x double> [[X:%.*]], <2 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x double> @_Z3powDv2_dS_(<2 x double> [[X]], <2 x double> [[Y]])
; CHECK-NEXT:    ret <2 x double> [[POW]]
;
  %pow = tail call afn <2 x double> @_Z3powDv2_dS_(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %pow
}

define <3 x double> @test_pow_afn_v3f64(<3 x double> %x, <3 x double> %y) {
; CHECK-LABEL: define <3 x double> @test_pow_afn_v3f64
; CHECK-SAME: (<3 x double> [[X:%.*]], <3 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <3 x double> @_Z3powDv3_dS_(<3 x double> [[X]], <3 x double> [[Y]])
; CHECK-NEXT:    ret <3 x double> [[POW]]
;
  %pow = tail call afn <3 x double> @_Z3powDv3_dS_(<3 x double> %x, <3 x double> %y)
  ret <3 x double> %pow
}

define <4 x double> @test_pow_afn_v4f64(<4 x double> %x, <4 x double> %y) {
; CHECK-LABEL: define <4 x double> @test_pow_afn_v4f64
; CHECK-SAME: (<4 x double> [[X:%.*]], <4 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <4 x double> @_Z3powDv4_dS_(<4 x double> [[X]], <4 x double> [[Y]])
; CHECK-NEXT:    ret <4 x double> [[POW]]
;
  %pow = tail call afn <4 x double> @_Z3powDv4_dS_(<4 x double> %x, <4 x double> %y)
  ret <4 x double> %pow
}

define <8 x double> @test_pow_afn_v8f64(<8 x double> %x, <8 x double> %y) {
; CHECK-LABEL: define <8 x double> @test_pow_afn_v8f64
; CHECK-SAME: (<8 x double> [[X:%.*]], <8 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <8 x double> @_Z3powDv8_dS_(<8 x double> [[X]], <8 x double> [[Y]])
; CHECK-NEXT:    ret <8 x double> [[POW]]
;
  %pow = tail call afn <8 x double> @_Z3powDv8_dS_(<8 x double> %x, <8 x double> %y)
  ret <8 x double> %pow
}

define <16 x double> @test_pow_afn_v16f64(<16 x double> %x, <16 x double> %y) {
; CHECK-LABEL: define <16 x double> @test_pow_afn_v16f64
; CHECK-SAME: (<16 x double> [[X:%.*]], <16 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <16 x double> @_Z3powDv16_dS_(<16 x double> [[X]], <16 x double> [[Y]])
; CHECK-NEXT:    ret <16 x double> [[POW]]
;
  %pow = tail call afn <16 x double> @_Z3powDv16_dS_(<16 x double> %x, <16 x double> %y)
  ret <16 x double> %pow
}

define half @test_pow_afn_f16(half %x, half %y) {
; CHECK-LABEL: define half @test_pow_afn_f16
; CHECK-SAME: (half [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn half @_Z3powDhDh(half [[X]], half [[Y]])
; CHECK-NEXT:    ret half [[POW]]
;
  %pow = tail call afn half @_Z3powDhDh(half %x, half %y)
  ret half %pow
}

define <2 x half> @test_pow_afn_v2f16(<2 x half> %x, <2 x half> %y) {
; CHECK-LABEL: define <2 x half> @test_pow_afn_v2f16
; CHECK-SAME: (<2 x half> [[X:%.*]], <2 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x half> @_Z3powDv2_DhS_(<2 x half> [[X]], <2 x half> [[Y]])
; CHECK-NEXT:    ret <2 x half> [[POW]]
;
  %pow = tail call afn <2 x half> @_Z3powDv2_DhS_(<2 x half> %x, <2 x half> %y)
  ret <2 x half> %pow
}

define <3 x half> @test_pow_afn_v3f16(<3 x half> %x, <3 x half> %y) {
; CHECK-LABEL: define <3 x half> @test_pow_afn_v3f16
; CHECK-SAME: (<3 x half> [[X:%.*]], <3 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <3 x half> @_Z3powDv3_DhS_(<3 x half> [[X]], <3 x half> [[Y]])
; CHECK-NEXT:    ret <3 x half> [[POW]]
;
  %pow = tail call afn <3 x half> @_Z3powDv3_DhS_(<3 x half> %x, <3 x half> %y)
  ret <3 x half> %pow
}

define <4 x half> @test_pow_afn_v4f16(<4 x half> %x, <4 x half> %y) {
; CHECK-LABEL: define <4 x half> @test_pow_afn_v4f16
; CHECK-SAME: (<4 x half> [[X:%.*]], <4 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <4 x half> @_Z3powDv4_DhS_(<4 x half> [[X]], <4 x half> [[Y]])
; CHECK-NEXT:    ret <4 x half> [[POW]]
;
  %pow = tail call afn <4 x half> @_Z3powDv4_DhS_(<4 x half> %x, <4 x half> %y)
  ret <4 x half> %pow
}

define <8 x half> @test_pow_afn_v8f16(<8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: define <8 x half> @test_pow_afn_v8f16
; CHECK-SAME: (<8 x half> [[X:%.*]], <8 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <8 x half> @_Z3powDv8_DhS_(<8 x half> [[X]], <8 x half> [[Y]])
; CHECK-NEXT:    ret <8 x half> [[POW]]
;
  %pow = tail call afn <8 x half> @_Z3powDv8_DhS_(<8 x half> %x, <8 x half> %y)
  ret <8 x half> %pow
}

define <16 x half> @test_pow_afn_v16f16(<16 x half> %x, <16 x half> %y) {
; CHECK-LABEL: define <16 x half> @test_pow_afn_v16f16
; CHECK-SAME: (<16 x half> [[X:%.*]], <16 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <16 x half> @_Z3powDv16_DhS_(<16 x half> [[X]], <16 x half> [[Y]])
; CHECK-NEXT:    ret <16 x half> [[POW]]
;
  %pow = tail call afn <16 x half> @_Z3powDv16_DhS_(<16 x half> %x, <16 x half> %y)
  ret <16 x half> %pow
}

define float @test_pow_f32(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_f32
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z3powff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32_nnan(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_f32_nnan
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan float @_Z3powff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call nnan float @_Z3powff(float %x, float %y)
  ret float %pow
}

define <2 x float> @test_pow_v2f32(<2 x float> %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %pow
}

define <3 x float> @test_pow_v3f32(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_pow_v3f32
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <3 x float> @_Z3powDv3_fS_(<3 x float> [[X]], <3 x float> [[Y]])
; CHECK-NEXT:    ret <3 x float> [[POW]]
;
  %pow = tail call <3 x float> @_Z3powDv3_fS_(<3 x float> %x, <3 x float> %y)
  ret <3 x float> %pow
}

define <4 x float> @test_pow_v4f32(<4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: define <4 x float> @test_pow_v4f32
; CHECK-SAME: (<4 x float> [[X:%.*]], <4 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <4 x float> @_Z3powDv4_fS_(<4 x float> [[X]], <4 x float> [[Y]])
; CHECK-NEXT:    ret <4 x float> [[POW]]
;
  %pow = tail call <4 x float> @_Z3powDv4_fS_(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %pow
}

define <8 x float> @test_pow_v8f32(<8 x float> %x, <8 x float> %y) {
; CHECK-LABEL: define <8 x float> @test_pow_v8f32
; CHECK-SAME: (<8 x float> [[X:%.*]], <8 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <8 x float> @_Z3powDv8_fS_(<8 x float> [[X]], <8 x float> [[Y]])
; CHECK-NEXT:    ret <8 x float> [[POW]]
;
  %pow = tail call <8 x float> @_Z3powDv8_fS_(<8 x float> %x, <8 x float> %y)
  ret <8 x float> %pow
}

define <16 x float> @test_pow_v16f32(<16 x float> %x, <16 x float> %y) {
; CHECK-LABEL: define <16 x float> @test_pow_v16f32
; CHECK-SAME: (<16 x float> [[X:%.*]], <16 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <16 x float> @_Z3powDv16_fS_(<16 x float> [[X]], <16 x float> [[Y]])
; CHECK-NEXT:    ret <16 x float> [[POW]]
;
  %pow = tail call <16 x float> @_Z3powDv16_fS_(<16 x float> %x, <16 x float> %y)
  ret <16 x float> %pow
}

define double @test_pow_f64(double %x, double %y) {
; CHECK-LABEL: define double @test_pow_f64
; CHECK-SAME: (double [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call double @_Z3powdd(double [[X]], double [[Y]])
; CHECK-NEXT:    ret double [[POW]]
;
  %pow = tail call double @_Z3powdd(double %x, double %y)
  ret double %pow
}

define <2 x double> @test_pow_v2f64(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: define <2 x double> @test_pow_v2f64
; CHECK-SAME: (<2 x double> [[X:%.*]], <2 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x double> @_Z3powDv2_dS_(<2 x double> [[X]], <2 x double> [[Y]])
; CHECK-NEXT:    ret <2 x double> [[POW]]
;
  %pow = tail call <2 x double> @_Z3powDv2_dS_(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %pow
}

define <3 x double> @test_pow_v3f64(<3 x double> %x, <3 x double> %y) {
; CHECK-LABEL: define <3 x double> @test_pow_v3f64
; CHECK-SAME: (<3 x double> [[X:%.*]], <3 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <3 x double> @_Z3powDv3_dS_(<3 x double> [[X]], <3 x double> [[Y]])
; CHECK-NEXT:    ret <3 x double> [[POW]]
;
  %pow = tail call <3 x double> @_Z3powDv3_dS_(<3 x double> %x, <3 x double> %y)
  ret <3 x double> %pow
}

define <4 x double> @test_pow_v4f64(<4 x double> %x, <4 x double> %y) {
; CHECK-LABEL: define <4 x double> @test_pow_v4f64
; CHECK-SAME: (<4 x double> [[X:%.*]], <4 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <4 x double> @_Z3powDv4_dS_(<4 x double> [[X]], <4 x double> [[Y]])
; CHECK-NEXT:    ret <4 x double> [[POW]]
;
  %pow = tail call <4 x double> @_Z3powDv4_dS_(<4 x double> %x, <4 x double> %y)
  ret <4 x double> %pow
}

define <8 x double> @test_pow_v8f64(<8 x double> %x, <8 x double> %y) {
; CHECK-LABEL: define <8 x double> @test_pow_v8f64
; CHECK-SAME: (<8 x double> [[X:%.*]], <8 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <8 x double> @_Z3powDv8_dS_(<8 x double> [[X]], <8 x double> [[Y]])
; CHECK-NEXT:    ret <8 x double> [[POW]]
;
  %pow = tail call <8 x double> @_Z3powDv8_dS_(<8 x double> %x, <8 x double> %y)
  ret <8 x double> %pow
}

define <16 x double> @test_pow_v16f64(<16 x double> %x, <16 x double> %y) {
; CHECK-LABEL: define <16 x double> @test_pow_v16f64
; CHECK-SAME: (<16 x double> [[X:%.*]], <16 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <16 x double> @_Z3powDv16_dS_(<16 x double> [[X]], <16 x double> [[Y]])
; CHECK-NEXT:    ret <16 x double> [[POW]]
;
  %pow = tail call <16 x double> @_Z3powDv16_dS_(<16 x double> %x, <16 x double> %y)
  ret <16 x double> %pow
}

define half @test_pow_f16(half %x, half %y) {
; CHECK-LABEL: define half @test_pow_f16
; CHECK-SAME: (half [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call half @_Z3powDhDh(half [[X]], half [[Y]])
; CHECK-NEXT:    ret half [[POW]]
;
  %pow = tail call half @_Z3powDhDh(half %x, half %y)
  ret half %pow
}

define <2 x half> @test_pow_v2f16(<2 x half> %x, <2 x half> %y) {
; CHECK-LABEL: define <2 x half> @test_pow_v2f16
; CHECK-SAME: (<2 x half> [[X:%.*]], <2 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x half> @_Z3powDv2_DhS_(<2 x half> [[X]], <2 x half> [[Y]])
; CHECK-NEXT:    ret <2 x half> [[POW]]
;
  %pow = tail call <2 x half> @_Z3powDv2_DhS_(<2 x half> %x, <2 x half> %y)
  ret <2 x half> %pow
}

define <3 x half> @test_pow_v3f16(<3 x half> %x, <3 x half> %y) {
; CHECK-LABEL: define <3 x half> @test_pow_v3f16
; CHECK-SAME: (<3 x half> [[X:%.*]], <3 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <3 x half> @_Z3powDv3_DhS_(<3 x half> [[X]], <3 x half> [[Y]])
; CHECK-NEXT:    ret <3 x half> [[POW]]
;
  %pow = tail call <3 x half> @_Z3powDv3_DhS_(<3 x half> %x, <3 x half> %y)
  ret <3 x half> %pow
}

define <4 x half> @test_pow_v4f16(<4 x half> %x, <4 x half> %y) {
; CHECK-LABEL: define <4 x half> @test_pow_v4f16
; CHECK-SAME: (<4 x half> [[X:%.*]], <4 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <4 x half> @_Z3powDv4_DhS_(<4 x half> [[X]], <4 x half> [[Y]])
; CHECK-NEXT:    ret <4 x half> [[POW]]
;
  %pow = tail call <4 x half> @_Z3powDv4_DhS_(<4 x half> %x, <4 x half> %y)
  ret <4 x half> %pow
}

define <8 x half> @test_pow_v8f16(<8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: define <8 x half> @test_pow_v8f16
; CHECK-SAME: (<8 x half> [[X:%.*]], <8 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <8 x half> @_Z3powDv8_DhS_(<8 x half> [[X]], <8 x half> [[Y]])
; CHECK-NEXT:    ret <8 x half> [[POW]]
;
  %pow = tail call <8 x half> @_Z3powDv8_DhS_(<8 x half> %x, <8 x half> %y)
  ret <8 x half> %pow
}

define <16 x half> @test_pow_v16f16(<16 x half> %x, <16 x half> %y) {
; CHECK-LABEL: define <16 x half> @test_pow_v16f16
; CHECK-SAME: (<16 x half> [[X:%.*]], <16 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <16 x half> @_Z3powDv16_DhS_(<16 x half> [[X]], <16 x half> [[Y]])
; CHECK-NEXT:    ret <16 x half> [[POW]]
;
  %pow = tail call <16 x half> @_Z3powDv16_DhS_(<16 x half> %x, <16 x half> %y)
  ret <16 x half> %pow
}

define float @test_pow_afn_f32_minsize(float %x, float %y) #0 {
; CHECK-LABEL: define float @test_pow_afn_f32_minsize
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z3powff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_afn_f32_nnan_minsize(float %x, float %y) #0 {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_minsize
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn float @_Z3powff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn nnan float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_afn_f32_noinline(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_afn_f32_noinline
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z3powff(float [[X]], float [[Y]]) #[[ATTR5:[0-9]+]]
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float %y) #1
  ret float %pow
}

define float @test_pow_afn_f32_nnan_noinline(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_noinline
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn float @_Z3powff(float [[X]], float [[Y]]) #[[ATTR5]]
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn nnan float @_Z3powff(float %x, float %y) #1
  ret float %pow
}

define float @test_pow_afn_f32_strictfp(float %x, float %y) #2 {
; CHECK-LABEL: define float @test_pow_afn_f32_strictfp
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan nsz afn float @_Z3powff(float [[X]], float [[Y]]) #[[ATTR3]]
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn nsz nnan float @_Z3powff(float %x, float %y) #2
  ret float %pow
}

define float @test_pow_fast_f32_nobuiltin(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_fast_f32_nobuiltin
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call fast float @_Z3powff(float [[X]], float [[Y]]) #[[ATTR6:[0-9]+]]
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call fast float @_Z3powff(float %x, float %y) #3
  ret float %pow
}

define float @test_pow_afn_f32_0.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_0.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    ret float 1.000000e+00
;
  %pow = tail call afn float @_Z3powff(float %x, float 0.0)
  ret float %pow
}

define float @test_pow_afn_f32_neg0.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_neg0.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    ret float 1.000000e+00
;
  %pow = tail call afn float @_Z3powff(float %x, float -0.0)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32_0.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_0.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> <float 1.000000e+00, float 1.000000e+00>
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 0.0, float 0.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_neg0.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_neg0.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> <float 1.000000e+00, float 1.000000e+00>
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -0.0, float -0.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_plus_minus_0.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_plus_minus_0.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> <float 1.000000e+00, float 1.000000e+00>
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 0.0, float -0.0>)
  ret <2 x float> %pow
}

define <3 x float> @test_pow_afn_v3f32_0.0_splat_undef(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_pow_afn_v3f32_0.0_splat_undef
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    ret <3 x float> <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00>
;
  %pow = tail call afn <3 x float> @_Z3powDv3_fS_(<3 x float> %x, <3 x float> <float 0.0, float poison, float 0.0>)
  ret <3 x float> %pow
}

define <3 x float> @test_pow_afn_v3f32_neg0.0_splat_undef(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_pow_afn_v3f32_neg0.0_splat_undef
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    ret <3 x float> <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00>
;
  %pow = tail call afn <3 x float> @_Z3powDv3_fS_(<3 x float> %x, <3 x float> <float -0.0, float poison, float -0.0>)
  ret <3 x float> %pow
}

define float @test_pow_afn_f32_0.5(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_0.5
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2SQRT:%.*]] = call afn float @_Z4sqrtf(float [[X]])
; CHECK-NEXT:    ret float [[__POW2SQRT]]
;
  %pow = tail call afn float @_Z3powff(float %x, float 0.5)
  ret float %pow
}

define float @test_pow_afn_f32_neg0.5(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_neg0.5
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2RSQRT:%.*]] = call afn float @_Z5rsqrtf(float [[X]])
; CHECK-NEXT:    ret float [[__POW2RSQRT]]
;
  %pow = tail call afn float @_Z3powff(float %x, float -0.5)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32_0.5(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_0.5
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2SQRT:%.*]] = call afn <2 x float> @_Z4sqrtDv2_f(<2 x float> [[X]])
; CHECK-NEXT:    ret <2 x float> [[__POW2SQRT]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 0.5, float 0.5>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_neg0.5(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_neg0.5
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2RSQRT:%.*]] = call afn <2 x float> @_Z5rsqrtDv2_f(<2 x float> [[X]])
; CHECK-NEXT:    ret <2 x float> [[__POW2RSQRT]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -0.5, float -0.5>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_plus_minus_0.5(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_plus_minus_0.5
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> <float 5.000000e-01, float -5.000000e-01>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 0.5, float -0.5>)
  ret <2 x float> %pow
}

define <3 x float> @test_pow_afn_v3f32_0.5_splat_undef(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_pow_afn_v3f32_0.5_splat_undef
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[__POW2SQRT:%.*]] = call afn <3 x float> @_Z4sqrtDv3_f(<3 x float> [[X]])
; CHECK-NEXT:    ret <3 x float> [[__POW2SQRT]]
;
  %pow = tail call afn <3 x float> @_Z3powDv3_fS_(<3 x float> %x, <3 x float> <float 0.5, float poison, float 0.5>)
  ret <3 x float> %pow
}

define <3 x float> @test_pow_afn_v3f32_neg0.5_splat_undef(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_pow_afn_v3f32_neg0.5_splat_undef
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[__POW2RSQRT:%.*]] = call afn <3 x float> @_Z5rsqrtDv3_f(<3 x float> [[X]])
; CHECK-NEXT:    ret <3 x float> [[__POW2RSQRT]]
;
  %pow = tail call afn <3 x float> @_Z3powDv3_fS_(<3 x float> %x, <3 x float> <float -0.5, float poison, float -0.5>)
  ret <3 x float> %pow
}

define float @test_pow_afn_f32_1.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_1.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    ret float [[X]]
;
  %pow = tail call afn float @_Z3powff(float %x, float 1.0)
  ret float %pow
}

define float @test_pow_afn_f32_neg1.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_neg1.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POWRECIP:%.*]] = fdiv afn float 1.000000e+00, [[X]]
; CHECK-NEXT:    ret float [[__POWRECIP]]
;
  %pow = tail call afn float @_Z3powff(float %x, float -1.0)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32_1.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_1.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> [[X]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 1.0, float 1.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_neg1.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_neg1.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POWRECIP:%.*]] = fdiv afn <2 x float> <float 1.000000e+00, float 1.000000e+00>, [[X]]
; CHECK-NEXT:    ret <2 x float> [[__POWRECIP]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -1.0, float -1.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_plus_minus_1.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_plus_minus_1.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 1, i32 -1>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 1.0, float -1.0>)
  ret <2 x float> %pow
}

define <3 x float> @test_pow_afn_v3f32_1.0_splat_undef(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_pow_afn_v3f32_1.0_splat_undef
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    ret <3 x float> [[X]]
;
  %pow = tail call afn <3 x float> @_Z3powDv3_fS_(<3 x float> %x, <3 x float> <float 1.0, float poison, float 1.0>)
  ret <3 x float> %pow
}

define <3 x float> @test_pow_afn_v3f32_neg1.0_splat_undef(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_pow_afn_v3f32_neg1.0_splat_undef
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[__POWRECIP:%.*]] = fdiv afn <3 x float> <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00>, [[X]]
; CHECK-NEXT:    ret <3 x float> [[__POWRECIP]]
;
  %pow = tail call afn <3 x float> @_Z3powDv3_fS_(<3 x float> %x, <3 x float> <float -1.0, float poison, float -1.0>)
  ret <3 x float> %pow
}

define float @test_pow_afn_f32_2.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_2.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2:%.*]] = fmul afn float [[X]], [[X]]
; CHECK-NEXT:    ret float [[__POW2]]
;
  %pow = tail call afn float @_Z3powff(float %x, float 2.0)
  ret float %pow
}

define float @test_pow_afn_f32_neg2.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_neg2.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 -2)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float -2.0)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32_2.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_2.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2:%.*]] = fmul afn <2 x float> [[X]], [[X]]
; CHECK-NEXT:    ret <2 x float> [[__POW2]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 2.0, float 2.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_neg2.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_neg2.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 -2, i32 -2>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -2.0, float -2.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_plus_minus_2.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_plus_minus_2.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 2, i32 -2>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 2.0, float -2.0>)
  ret <2 x float> %pow
}

define float @test_pow_afn_f32_3.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_3.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 3)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float 3.0)
  ret float %pow
}

define float @test_pow_afn_f32_neg3.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_neg3.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 -3)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float -3.0)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32_3.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_3.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 3, i32 3>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 3.0, float 3.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_neg3.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_neg3.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 -3, i32 -3>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -3.0, float -3.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_plus_minus_3.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_plus_minus_3.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 3, i32 -3>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 3.0, float -3.0>)
  ret <2 x float> %pow
}

define float @test_pow_afn_f32_3.99(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_3.99
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z3powff(float [[X]], float 0x400FEB8520000000)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float 0x400FEB8520000000)
  ret float %pow
}

define float @test_pow_afn_f32_neg3.99(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_neg3.99
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z3powff(float [[X]], float 0xC00FEB8520000000)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float 0xC00FEB8520000000)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32_3.99(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_3.99
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> <float 0x400FEB8520000000, float 0x400FEB8520000000>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 0x400FEB8520000000, float 0x400FEB8520000000>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_neg3.99(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_neg3.99
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> <float 0xC00FEB8520000000, float 0xC00FEB8520000000>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 0xC00FEB8520000000, float 0xC00FEB8520000000>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_plus_minus_3.99(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_plus_minus_3.99
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> <float 0x400FEB8520000000, float 0xC00FEB8520000000>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 0x400FEB8520000000, float 0xC00FEB8520000000>)
  ret <2 x float> %pow
}

define float @test_pow_afn_f32_8.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_8.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 8)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float 8.0)
  ret float %pow
}

define float @test_pow_afn_f32_neg8.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_neg8.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 -8)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float -8.0)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32_8.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_8.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 8, i32 8>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 8.0, float 8.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_neg8.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_neg8.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 -8, i32 -8>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -8.0, float -8.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_plus_minus_8.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_plus_minus_8.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 8, i32 -8>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 8.0, float -8.0>)
  ret <2 x float> %pow
}

define float @test_pow_afn_f32_12.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_12.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 12)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float 12.0)
  ret float %pow
}

define float @test_pow_afn_f32_neg12.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_neg12.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 -12)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float -12.0)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32_12.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_12.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 12, i32 12>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 12.0, float 12.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_neg12.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_neg12.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 -12, i32 -12>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -12.0, float -12.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_plus_minus_12.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_plus_minus_12.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 12, i32 -12>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 12.0, float -12.0>)
  ret <2 x float> %pow
}

define float @test_pow_afn_f32_13.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_13.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 13)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float 13.0)
  ret float %pow
}

define float @test_pow_afn_f32_neg13.0(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_neg13.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 -13)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float -13.0)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32_13.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_13.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 13, i32 13>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 13.0, float 13.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_neg13.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_neg13.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 -13, i32 -13>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -13.0, float -13.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_13.0_15.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_13.0_15.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 13, i32 15>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 13.0, float 15.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_13.0_14.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_13.0_14.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 13, i32 14>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 13.0, float 14.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_14.0_16.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_14.0_16.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 14, i32 16>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 14.0, float 16.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_plus_minus_13.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_plus_minus_13.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 13, i32 -13>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 13.0, float -13.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_plus_minus_13.0_minus_14.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_plus_minus_13.0_minus_14.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 -13, i32 -14>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -13.0, float -14.0>)
  ret <2 x float> %pow
}

define float @test_pow_afn_f32_nnan_x_known_positive(float nofpclass(ninf nnorm nsub) %x, float %y) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_x_known_positive
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn nnan float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_afn_f32_nnan_ninf_x_known_positive(float nofpclass(ninf nnorm nsub) %x, float %y) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_ninf_x_known_positive
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn float @llvm.log2.f32(float [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn float [[__LOG2]], [[Y]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn float @llvm.exp2.f32(float [[__YLOGX]])
; CHECK-NEXT:    ret float [[__EXP2]]
;
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float %y)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32_nnan_x_known_positive(<2 x float> nofpclass(ninf nnorm nsub) %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_nnan_x_known_positive
; CHECK-SAME: (<2 x float> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn nnan <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_nnan_ninf_x_known_positive(<2 x float> nofpclass(ninf nnorm nsub) %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_nnan_ninf_x_known_positive
; CHECK-SAME: (<2 x float> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn <2 x float> @llvm.log2.v2f32(<2 x float> [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn <2 x float> [[__LOG2]], [[Y]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn <2 x float> @llvm.exp2.v2f32(<2 x float> [[__YLOGX]])
; CHECK-NEXT:    ret <2 x float> [[__EXP2]]
;
  %pow = tail call afn nnan ninf <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %pow
}

define float @test_pow_f32_x_known_positive(float nofpclass(ninf nnorm nsub) %x, float %y) {
; CHECK-LABEL: define float @test_pow_f32_x_known_positive
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_afn_f32_x_known_positive(float nofpclass(ninf nnorm nsub) %x, float %y) {
; CHECK-LABEL: define float @test_pow_afn_f32_x_known_positive
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float %y)
  ret float %pow
}

define <2 x float> @test_pow_v2f32_x_known_positive(<2 x float> nofpclass(ninf nnorm nsub) %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32_x_known_positive
; CHECK-SAME: (<2 x float> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_x_known_positive(<2 x float> nofpclass(ninf nnorm nsub) %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_x_known_positive
; CHECK-SAME: (<2 x float> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %pow
}

define double @test_pow_afn_f64_nnan_x_known_positive(double nofpclass(ninf nnorm nsub) %x, double %y) {
; CHECK-LABEL: define double @test_pow_afn_f64_nnan_x_known_positive
; CHECK-SAME: (double nofpclass(ninf nsub nnorm) [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn double @_Z4powrdd(double [[X]], double [[Y]])
; CHECK-NEXT:    ret double [[POW]]
;
  %pow = tail call afn nnan double @_Z3powdd(double %x, double %y)
  ret double %pow
}

define double @test_pow_afn_f64_nnan_ninf_x_known_positive(double nofpclass(ninf nnorm nsub) %x, double %y) {
; CHECK-LABEL: define double @test_pow_afn_f64_nnan_ninf_x_known_positive
; CHECK-SAME: (double nofpclass(ninf nsub nnorm) [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn double @_Z4log2d(double [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn double [[__LOG2]], [[Y]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn double @_Z4exp2d(double [[__YLOGX]])
; CHECK-NEXT:    ret double [[__EXP2]]
;
  %pow = tail call afn nnan ninf double @_Z3powdd(double %x, double %y)
  ret double %pow
}

define <2 x double> @test_pow_afn_v2f64_nnan_x_known_positive(<2 x double> nofpclass(ninf nnorm nsub) %x, <2 x double> %y) {
; CHECK-LABEL: define <2 x double> @test_pow_afn_v2f64_nnan_x_known_positive
; CHECK-SAME: (<2 x double> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn <2 x double> @_Z4powrDv2_dS_(<2 x double> [[X]], <2 x double> [[Y]])
; CHECK-NEXT:    ret <2 x double> [[POW]]
;
  %pow = tail call afn nnan <2 x double> @_Z3powDv2_dS_(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %pow
}

define <2 x double> @test_pow_afn_v2f64_nnan_ninf_x_known_positive(<2 x double> nofpclass(ninf nnorm nsub) %x, <2 x double> %y) {
; CHECK-LABEL: define <2 x double> @test_pow_afn_v2f64_nnan_ninf_x_known_positive
; CHECK-SAME: (<2 x double> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn <2 x double> @_Z4log2Dv2_d(<2 x double> [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn <2 x double> [[__LOG2]], [[Y]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn <2 x double> @_Z4exp2Dv2_d(<2 x double> [[__YLOGX]])
; CHECK-NEXT:    ret <2 x double> [[__EXP2]]
;
  %pow = tail call afn nnan ninf <2 x double> @_Z3powDv2_dS_(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %pow
}

define double @test_pow_f64_x_known_positive(double nofpclass(ninf nnorm nsub) %x, double %y) {
; CHECK-LABEL: define double @test_pow_f64_x_known_positive
; CHECK-SAME: (double nofpclass(ninf nsub nnorm) [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call double @_Z4powrdd(double [[X]], double [[Y]])
; CHECK-NEXT:    ret double [[POW]]
;
  %pow = tail call double @_Z3powdd(double %x, double %y)
  ret double %pow
}

define double @test_pow_afn_f64_x_known_positive(double nofpclass(ninf nnorm nsub) %x, double %y) {
; CHECK-LABEL: define double @test_pow_afn_f64_x_known_positive
; CHECK-SAME: (double nofpclass(ninf nsub nnorm) [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn double @_Z4powrdd(double [[X]], double [[Y]])
; CHECK-NEXT:    ret double [[POW]]
;
  %pow = tail call afn double @_Z3powdd(double %x, double %y)
  ret double %pow
}

define <2 x double> @test_pow_v2f64_x_known_positive(<2 x double> nofpclass(ninf nnorm nsub) %x, <2 x double> %y) {
; CHECK-LABEL: define <2 x double> @test_pow_v2f64_x_known_positive
; CHECK-SAME: (<2 x double> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x double> @_Z4powrDv2_dS_(<2 x double> [[X]], <2 x double> [[Y]])
; CHECK-NEXT:    ret <2 x double> [[POW]]
;
  %pow = tail call <2 x double> @_Z3powDv2_dS_(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %pow
}

define <2 x double> @test_pow_afn_v2f64_x_known_positive(<2 x double> nofpclass(ninf nnorm nsub) %x, <2 x double> %y) {
; CHECK-LABEL: define <2 x double> @test_pow_afn_v2f64_x_known_positive
; CHECK-SAME: (<2 x double> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x double> @_Z4powrDv2_dS_(<2 x double> [[X]], <2 x double> [[Y]])
; CHECK-NEXT:    ret <2 x double> [[POW]]
;
  %pow = tail call afn <2 x double> @_Z3powDv2_dS_(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %pow
}

define half @test_pow_afn_f16_nnan_x_known_positive(half nofpclass(ninf nnorm nsub) %x, half %y) {
; CHECK-LABEL: define half @test_pow_afn_f16_nnan_x_known_positive
; CHECK-SAME: (half nofpclass(ninf nsub nnorm) [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn half @_Z4powrDhDh(half [[X]], half [[Y]])
; CHECK-NEXT:    ret half [[POW]]
;
  %pow = tail call afn nnan half @_Z3powDhDh(half %x, half %y)
  ret half %pow
}

define half @test_pow_afn_f16_nnan_ninf_x_known_positive(half nofpclass(ninf nnorm nsub) %x, half %y) {
; CHECK-LABEL: define half @test_pow_afn_f16_nnan_ninf_x_known_positive
; CHECK-SAME: (half nofpclass(ninf nsub nnorm) [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn half @llvm.log2.f16(half [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn half [[__LOG2]], [[Y]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn half @llvm.exp2.f16(half [[__YLOGX]])
; CHECK-NEXT:    ret half [[__EXP2]]
;
  %pow = tail call afn nnan ninf half @_Z3powDhDh(half %x, half %y)
  ret half %pow
}

define <2 x half> @test_pow_afn_v2f16_nnan_x_known_positive(<2 x half> nofpclass(ninf nnorm nsub) %x, <2 x half> %y) {
; CHECK-LABEL: define <2 x half> @test_pow_afn_v2f16_nnan_x_known_positive
; CHECK-SAME: (<2 x half> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn <2 x half> @_Z4powrDv2_DhS_(<2 x half> [[X]], <2 x half> [[Y]])
; CHECK-NEXT:    ret <2 x half> [[POW]]
;
  %pow = tail call afn nnan <2 x half> @_Z3powDv2_DhS_(<2 x half> %x, <2 x half> %y)
  ret <2 x half> %pow
}

define <2 x half> @test_pow_afn_v2f16_nnan_ninf_x_known_positive(<2 x half> nofpclass(ninf nnorm nsub) %x, <2 x half> %y) {
; CHECK-LABEL: define <2 x half> @test_pow_afn_v2f16_nnan_ninf_x_known_positive
; CHECK-SAME: (<2 x half> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn <2 x half> @llvm.log2.v2f16(<2 x half> [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn <2 x half> [[__LOG2]], [[Y]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn <2 x half> @llvm.exp2.v2f16(<2 x half> [[__YLOGX]])
; CHECK-NEXT:    ret <2 x half> [[__EXP2]]
;
  %pow = tail call afn nnan ninf <2 x half> @_Z3powDv2_DhS_(<2 x half> %x, <2 x half> %y)
  ret <2 x half> %pow
}

define half @test_pow_f16_x_known_positive(half nofpclass(ninf nnorm nsub) %x, half %y) {
; CHECK-LABEL: define half @test_pow_f16_x_known_positive
; CHECK-SAME: (half nofpclass(ninf nsub nnorm) [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call half @_Z4powrDhDh(half [[X]], half [[Y]])
; CHECK-NEXT:    ret half [[POW]]
;
  %pow = tail call half @_Z3powDhDh(half %x, half %y)
  ret half %pow
}

define half @test_pow_afn_f16_x_known_positive(half nofpclass(ninf nnorm nsub) %x, half %y) {
; CHECK-LABEL: define half @test_pow_afn_f16_x_known_positive
; CHECK-SAME: (half nofpclass(ninf nsub nnorm) [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn half @_Z4powrDhDh(half [[X]], half [[Y]])
; CHECK-NEXT:    ret half [[POW]]
;
  %pow = tail call afn half @_Z3powDhDh(half %x, half %y)
  ret half %pow
}

define <2 x half> @test_pow_v2f16_x_known_positive(<2 x half> nofpclass(ninf nnorm nsub) %x, <2 x half> %y) {
; CHECK-LABEL: define <2 x half> @test_pow_v2f16_x_known_positive
; CHECK-SAME: (<2 x half> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x half> @_Z4powrDv2_DhS_(<2 x half> [[X]], <2 x half> [[Y]])
; CHECK-NEXT:    ret <2 x half> [[POW]]
;
  %pow = tail call <2 x half> @_Z3powDv2_DhS_(<2 x half> %x, <2 x half> %y)
  ret <2 x half> %pow
}

define <2 x half> @test_pow_afn_v2f16_x_known_positive(<2 x half> nofpclass(ninf nnorm nsub) %x, <2 x half> %y) {
; CHECK-LABEL: define <2 x half> @test_pow_afn_v2f16_x_known_positive
; CHECK-SAME: (<2 x half> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x half> @_Z4powrDv2_DhS_(<2 x half> [[X]], <2 x half> [[Y]])
; CHECK-NEXT:    ret <2 x half> [[POW]]
;
  %pow = tail call afn <2 x half> @_Z3powDv2_DhS_(<2 x half> %x, <2 x half> %y)
  ret <2 x half> %pow
}

define float @test_pow_f32__y_0(float %x) {
; CHECK-LABEL: define float @test_pow_f32__y_0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    ret float 1.000000e+00
;
  %pow = tail call float @_Z3powff(float %x, float 0.0)
  ret float %pow
}

define float @test_pow_f32__y_n0(float %x) {
; CHECK-LABEL: define float @test_pow_f32__y_n0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    ret float 1.000000e+00
;
  %pow = tail call float @_Z3powff(float %x, float -0.0)
  ret float %pow
}

define float @test_pow_f32__y_1(float %x) {
; CHECK-LABEL: define float @test_pow_f32__y_1
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    ret float [[X]]
;
  %pow = tail call float @_Z3powff(float %x, float 1.0)
  ret float %pow
}

define float @test_pow_f32__y_n1(float %x) {
; CHECK-LABEL: define float @test_pow_f32__y_n1
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POWRECIP:%.*]] = fdiv float 1.000000e+00, [[X]]
; CHECK-NEXT:    ret float [[__POWRECIP]]
;
  %pow = tail call float @_Z3powff(float %x, float -1.0)
  ret float %pow
}

define float @test_pow_f32__y_2(float %x) {
; CHECK-LABEL: define float @test_pow_f32__y_2
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2:%.*]] = fmul float [[X]], [[X]]
; CHECK-NEXT:    ret float [[__POW2]]
;
  %pow = tail call float @_Z3powff(float %x, float 2.0)
  ret float %pow
}

define float @test_pow_f32__y_n2(float %x) {
; CHECK-LABEL: define float @test_pow_f32__y_n2
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 -2)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call float @_Z3powff(float %x, float -2.0)
  ret float %pow
}

define float @test_pow_f32__y_half(float %x) {
; CHECK-LABEL: define float @test_pow_f32__y_half
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2SQRT:%.*]] = call float @_Z4sqrtf(float [[X]])
; CHECK-NEXT:    ret float [[__POW2SQRT]]
;
  %pow = tail call float @_Z3powff(float %x, float 0.5)
  ret float %pow
}

define float @test_pow_f32__y_neg_half(float %x) {
; CHECK-LABEL: define float @test_pow_f32__y_neg_half
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2RSQRT:%.*]] = call float @_Z5rsqrtf(float [[X]])
; CHECK-NEXT:    ret float [[__POW2RSQRT]]
;
  %pow = tail call float @_Z3powff(float %x, float -0.5)
  ret float %pow
}

define float @test_pow_f32__y_3(float %x) {
; CHECK-LABEL: define float @test_pow_f32__y_3
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 3)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call float @_Z3powff(float %x, float 3.0)
  ret float %pow
}

define float @test_pow_f32__y_n3(float %x) {
; CHECK-LABEL: define float @test_pow_f32__y_n3
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 -3)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call float @_Z3powff(float %x, float -3.0)
  ret float %pow
}

define float @test_pow_f32__y_2_5(float %x) {
; CHECK-LABEL: define float @test_pow_f32__y_2_5
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z3powff(float [[X]], float 2.500000e+00)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call float @_Z3powff(float %x, float 2.5)
  ret float %pow
}

define float @test_pow_f32__y_n_2_5(float %x) {
; CHECK-LABEL: define float @test_pow_f32__y_n_2_5
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z3powff(float [[X]], float -2.500000e+00)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call float @_Z3powff(float %x, float -2.5)
  ret float %pow
}

define <2 x float> @test_pow_v2f32__y_0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32__y_0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> <float 1.000000e+00, float 1.000000e+00>
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> zeroinitializer)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32__y_n0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32__y_n0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> <float 1.000000e+00, float 1.000000e+00>
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -0.0, float -0.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32__y_1(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32__y_1
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> [[X]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 1.0,float 1.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32__y_n1(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32__y_n1
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POWRECIP:%.*]] = fdiv <2 x float> <float 1.000000e+00, float 1.000000e+00>, [[X]]
; CHECK-NEXT:    ret <2 x float> [[__POWRECIP]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -1.0, float -1.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32__y_2(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32__y_2
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2:%.*]] = fmul <2 x float> [[X]], [[X]]
; CHECK-NEXT:    ret <2 x float> [[__POW2]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 2.0, float 2.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32__y_n2(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32__y_n2
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 -2, i32 -2>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -2.0, float -2.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32__y_half(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32__y_half
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2SQRT:%.*]] = call <2 x float> @_Z4sqrtDv2_f(<2 x float> [[X]])
; CHECK-NEXT:    ret <2 x float> [[__POW2SQRT]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 0.5, float 0.5>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32__y_neg_half(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32__y_neg_half
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2RSQRT:%.*]] = call <2 x float> @_Z5rsqrtDv2_f(<2 x float> [[X]])
; CHECK-NEXT:    ret <2 x float> [[__POW2RSQRT]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -0.5, float -0.5>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32__y_3(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32__y_3
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 3, i32 3>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 3.0, float 3.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32__y_n3(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32__y_n3
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 -3, i32 -3>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -3.0,float -3.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32__y_2_5(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32__y_2_5
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> <float 2.500000e+00, float 2.500000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 2.5, float 2.5>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32__y_n_2_5(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32__y_n_2_5
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> <float -2.500000e+00, float -2.500000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float -2.5, float -2.5>)
  ret <2 x float> %pow
}

define float @test_pow_f32__known_positive__y_0(float nofpclass(ninf nnorm nsub) %x) {
; CHECK-LABEL: define float @test_pow_f32__known_positive__y_0
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]]) {
; CHECK-NEXT:    ret float 1.000000e+00
;
  %pow = tail call float @_Z3powff(float %x, float 0.0)
  ret float %pow
}

define float @test_pow_f32__known_positive__y_1(float nofpclass(ninf nnorm nsub) %x) {
; CHECK-LABEL: define float @test_pow_f32__known_positive__y_1
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]]) {
; CHECK-NEXT:    ret float [[X]]
;
  %pow = tail call float @_Z3powff(float %x, float 1.0)
  ret float %pow
}

define float @test_pow_f32__known_positive__y_neg1(float nofpclass(ninf nnorm nsub) %x) {
; CHECK-LABEL: define float @test_pow_f32__known_positive__y_neg1
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]]) {
; CHECK-NEXT:    [[__POWRECIP:%.*]] = fdiv float 1.000000e+00, [[X]]
; CHECK-NEXT:    ret float [[__POWRECIP]]
;
  %pow = tail call float @_Z3powff(float %x, float -1.0)
  ret float %pow
}

define float @test_pow_f32__known_positive__y_2(float nofpclass(ninf nnorm nsub) %x) {
; CHECK-LABEL: define float @test_pow_f32__known_positive__y_2
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2:%.*]] = fmul float [[X]], [[X]]
; CHECK-NEXT:    ret float [[__POW2]]
;
  %pow = tail call float @_Z3powff(float %x, float 2.0)
  ret float %pow
}

define float @test_pow_f32__known_positive__y_half(float nofpclass(ninf nnorm nsub) %x) {
; CHECK-LABEL: define float @test_pow_f32__known_positive__y_half
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2SQRT:%.*]] = call float @_Z4sqrtf(float [[X]])
; CHECK-NEXT:    ret float [[__POW2SQRT]]
;
  %pow = tail call float @_Z3powff(float %x, float 0.5)
  ret float %pow
}

define float @test_pow_f32__known_positive__y_neghalf(float nofpclass(ninf nnorm nsub) %x) {
; CHECK-LABEL: define float @test_pow_f32__known_positive__y_neghalf
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2RSQRT:%.*]] = call float @_Z5rsqrtf(float [[X]])
; CHECK-NEXT:    ret float [[__POW2RSQRT]]
;
  %pow = tail call float @_Z3powff(float %x, float -0.5)
  ret float %pow
}

define float @test_pow_f32_x_assumed_oge_0(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_f32_x_assumed_oge_0
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[X_OGE_ZERO:%.*]] = fcmp oge float [[X]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_OGE_ZERO]])
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %x.oge.zero = fcmp oge float %x, 0.0
  call void @llvm.assume(i1 %x.oge.zero)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32_x_assumed_ogt_0(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_f32_x_assumed_ogt_0
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[X_OGE_ZERO:%.*]] = fcmp ogt float [[X]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_OGE_ZERO]])
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %x.oge.zero = fcmp ogt float %x, 0.0
  call void @llvm.assume(i1 %x.oge.zero)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32_x_assumed_uge_0(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_f32_x_assumed_uge_0
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[X_UGE_ZERO:%.*]] = fcmp uge float [[X]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_UGE_ZERO]])
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %x.uge.zero = fcmp uge float %x, 0.0
  call void @llvm.assume(i1 %x.uge.zero)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32_x_assumed_ugt_0(float %x, float %y) {
; CHECK-LABEL: define float @test_pow_f32_x_assumed_ugt_0
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[X_UGT_ZERO:%.*]] = fcmp ugt float [[X]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_UGT_ZERO]])
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %x.ugt.zero = fcmp ugt float %x, 0.0
  call void @llvm.assume(i1 %x.ugt.zero)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_afn_f32__y_poison(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32__y_poison
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 poison)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float poison)
  ret float %pow
}

define float @test_pow_afn_f32__y_3(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32__y_3
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 3)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float 3.0)
  ret float %pow
}

define float @test_pow_afn_f32_nnan_ninf__y_3(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_ninf__y_3
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn float [[X]], [[X]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn float [[__POWX2]], [[X]]
; CHECK-NEXT:    ret float [[__POWPROD]]
;
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float 3.0)
  ret float %pow
}

define float @test_pow_afn_f32__y_4(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32__y_4
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 4)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float 4.0)
  ret float %pow
}

define float @test_pow_afn_f32_nnan_ninf__y_4(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_ninf__y_4
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn float [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn float [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    ret float [[__POWX21]]
;
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float 4.0)
  ret float %pow
}

define float @test_pow_afn_f32_nnan_ninf__y_4_5(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_ninf__y_4_5
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan ninf afn float @_Z3powff(float [[X]], float 4.500000e+00)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float 4.5)
  ret float %pow
}

define float @test_pow_afn_f32__y_5(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32__y_5
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 5)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float 5.0)
  ret float %pow
}

define float @test_pow_afn_f32_nnan_ninf__y_5(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_ninf__y_5
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn float [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn float [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn float [[__POWX21]], [[X]]
; CHECK-NEXT:    ret float [[__POWPROD]]
;
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float 5.0)
  ret float %pow
}

define float @test_pow_afn_f32__y_neg5(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32__y_neg5
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 -5)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call afn float @_Z3powff(float %x, float -5.0)
  ret float %pow
}

define float @test_pow_afn_f32_nnan_ninf__y_neg5(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_ninf__y_neg5
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn float [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn float [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn float [[__POWX21]], [[X]]
; CHECK-NEXT:    [[__1POWPROD:%.*]] = fdiv nnan ninf afn float 1.000000e+00, [[__POWPROD]]
; CHECK-NEXT:    ret float [[__1POWPROD]]
;
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float -5.0)
  ret float %pow
}

define float @test_pow_afn_f32_nnan_ninf__y_10(float %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_ninf__y_10
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn float [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn float [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWX22:%.*]] = fmul nnan ninf afn float [[__POWX21]], [[__POWX21]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn float [[__POWX2]], [[__POWX22]]
; CHECK-NEXT:    ret float [[__POWPROD]]
;
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float 10.0)
  ret float %pow
}

define <2 x float> @test_pow_afn_v2f32_nnan_ninf__y_poison(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_nnan_ninf__y_poison
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> poison
;
  %pow = tail call afn nnan ninf <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> poison)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_nnan_ninf__y_3(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_nnan_ninf__y_3
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn <2 x float> [[X]], [[X]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn <2 x float> [[__POWX2]], [[X]]
; CHECK-NEXT:    ret <2 x float> [[__POWPROD]]
;
  %pow = tail call afn nnan ninf <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 3.0, float 3.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_nnan_ninf__y_4(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_nnan_ninf__y_4
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn <2 x float> [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn <2 x float> [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    ret <2 x float> [[__POWX21]]
;
  %pow = tail call afn nnan ninf <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 4.0, float 4.0>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_nnan_ninf__y_4_5(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_nnan_ninf__y_4_5
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan ninf afn <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> <float 4.500000e+00, float 4.500000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn nnan ninf <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 4.5, float 4.5>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_nnan_ninf__y_4_5_undef(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_nnan_ninf__y_4_5_undef
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan ninf afn <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> <float 4.500000e+00, float poison>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call afn nnan ninf <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 4.5, float poison>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_nnan_ninf__y_5(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_nnan_ninf__y_5
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn <2 x float> [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn <2 x float> [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn <2 x float> [[__POWX21]], [[X]]
; CHECK-NEXT:    ret <2 x float> [[__POWPROD]]
;
  %pow = tail call afn nnan ninf <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 5.0, float 5.0>)
  ret <2 x float> %pow
}

define float @test_pow_afn_f32_nnan_ninf__y_5_known_positive(float nofpclass(ninf nsub nnorm) %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_ninf__y_5_known_positive
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn float [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn float [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn float [[__POWX21]], [[X]]
; CHECK-NEXT:    ret float [[__POWPROD]]
;
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float 5.0)
  ret float %pow
}

; we know we can ignore missing ninf on the input from the flag on the call
define float @test_pow_afn_f32_nnan_ninf__y_5_known_positive_with_ninf_flag(float nofpclass(nsub nnorm) %x) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_ninf__y_5_known_positive_with_ninf_flag
; CHECK-SAME: (float nofpclass(nsub nnorm) [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn float [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn float [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn float [[__POWX21]], [[X]]
; CHECK-NEXT:    ret float [[__POWPROD]]
;
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float 5.0)
  ret float %pow
}

define double @test_pow_afn_f64__y_3(double %x) {
; CHECK-LABEL: define double @test_pow_afn_f64__y_3
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn double @_Z4powndi(double [[X]], i32 3)
; CHECK-NEXT:    ret double [[POW]]
;
  %pow = tail call afn double @_Z3powdd(double %x, double 3.0)
  ret double %pow
}

define double @test_pow_afn_f64_nnan_ninf__y_3(double %x) {
; CHECK-LABEL: define double @test_pow_afn_f64_nnan_ninf__y_3
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn double [[X]], [[X]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn double [[__POWX2]], [[X]]
; CHECK-NEXT:    ret double [[__POWPROD]]
;
  %pow = tail call afn nnan ninf double @_Z3powdd(double %x, double 3.0)
  ret double %pow
}

define double @test_pow_afn_f64__y_4(double %x) {
; CHECK-LABEL: define double @test_pow_afn_f64__y_4
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn double @_Z4powndi(double [[X]], i32 4)
; CHECK-NEXT:    ret double [[POW]]
;
  %pow = tail call afn double @_Z3powdd(double %x, double 4.0)
  ret double %pow
}

define double @test_pow_afn_f64_nnan_ninf__y_4(double %x) {
; CHECK-LABEL: define double @test_pow_afn_f64_nnan_ninf__y_4
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn double [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn double [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    ret double [[__POWX21]]
;
  %pow = tail call afn nnan ninf double @_Z3powdd(double %x, double 4.0)
  ret double %pow
}

define double @test_pow_afn_f64_nnan_ninf__y_4_5(double %x) {
; CHECK-LABEL: define double @test_pow_afn_f64_nnan_ninf__y_4_5
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan ninf afn double @_Z3powdd(double [[X]], double 4.500000e+00)
; CHECK-NEXT:    ret double [[POW]]
;
  %pow = tail call afn nnan ninf double @_Z3powdd(double %x, double 4.5)
  ret double %pow
}

define double @test_pow_afn_f64__y_5(double %x) {
; CHECK-LABEL: define double @test_pow_afn_f64__y_5
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn double @_Z4powndi(double [[X]], i32 5)
; CHECK-NEXT:    ret double [[POW]]
;
  %pow = tail call afn double @_Z3powdd(double %x, double 5.0)
  ret double %pow
}

define double @test_pow_afn_f64_nnan_ninf__y_5(double %x) {
; CHECK-LABEL: define double @test_pow_afn_f64_nnan_ninf__y_5
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn double [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn double [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn double [[__POWX21]], [[X]]
; CHECK-NEXT:    ret double [[__POWPROD]]
;
  %pow = tail call afn nnan ninf double @_Z3powdd(double %x, double 5.0)
  ret double %pow
}

define double @test_pow_afn_f64__y_neg5(double %x) {
; CHECK-LABEL: define double @test_pow_afn_f64__y_neg5
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn double @_Z4powndi(double [[X]], i32 -5)
; CHECK-NEXT:    ret double [[POW]]
;
  %pow = tail call afn double @_Z3powdd(double %x, double -5.0)
  ret double %pow
}

define double @test_pow_afn_f64_nnan_ninf__y_neg5(double %x) {
; CHECK-LABEL: define double @test_pow_afn_f64_nnan_ninf__y_neg5
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn double [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn double [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn double [[__POWX21]], [[X]]
; CHECK-NEXT:    [[__1POWPROD:%.*]] = fdiv nnan ninf afn double 1.000000e+00, [[__POWPROD]]
; CHECK-NEXT:    ret double [[__1POWPROD]]
;
  %pow = tail call afn nnan ninf double @_Z3powdd(double %x, double -5.0)
  ret double %pow
}

define double @test_pow_afn_f64_nnan_ninf__y_10(double %x) {
; CHECK-LABEL: define double @test_pow_afn_f64_nnan_ninf__y_10
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn double [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn double [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWX22:%.*]] = fmul nnan ninf afn double [[__POWX21]], [[__POWX21]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn double [[__POWX2]], [[__POWX22]]
; CHECK-NEXT:    ret double [[__POWPROD]]
;
  %pow = tail call afn nnan ninf double @_Z3powdd(double %x, double 10.0)
  ret double %pow
}

define <2 x double> @test_pow_afn_v2f64_nnan_ninf__y_3(<2 x double> %x) {
; CHECK-LABEL: define <2 x double> @test_pow_afn_v2f64_nnan_ninf__y_3
; CHECK-SAME: (<2 x double> [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn <2 x double> [[X]], [[X]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn <2 x double> [[__POWX2]], [[X]]
; CHECK-NEXT:    ret <2 x double> [[__POWPROD]]
;
  %pow = tail call afn nnan ninf <2 x double> @_Z3powDv2_dS_(<2 x double> %x, <2 x double> <double 3.0, double 3.0>)
  ret <2 x double> %pow
}

define <2 x double> @test_pow_afn_v2f64_nnan_ninf__y_4(<2 x double> %x) {
; CHECK-LABEL: define <2 x double> @test_pow_afn_v2f64_nnan_ninf__y_4
; CHECK-SAME: (<2 x double> [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn <2 x double> [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn <2 x double> [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    ret <2 x double> [[__POWX21]]
;
  %pow = tail call afn nnan ninf <2 x double> @_Z3powDv2_dS_(<2 x double> %x, <2 x double> <double 4.0, double 4.0>)
  ret <2 x double> %pow
}

define <2 x double> @test_pow_afn_v2f64_nnan_ninf__y_4_5(<2 x double> %x) {
; CHECK-LABEL: define <2 x double> @test_pow_afn_v2f64_nnan_ninf__y_4_5
; CHECK-SAME: (<2 x double> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan ninf afn <2 x double> @_Z3powDv2_dS_(<2 x double> [[X]], <2 x double> <double 4.500000e+00, double 4.500000e+00>)
; CHECK-NEXT:    ret <2 x double> [[POW]]
;
  %pow = tail call afn nnan ninf <2 x double> @_Z3powDv2_dS_(<2 x double> %x, <2 x double> <double 4.5, double 4.5>)
  ret <2 x double> %pow
}

define <2 x double> @test_pow_afn_v2f64_nnan_ninf__y_5(<2 x double> %x) {
; CHECK-LABEL: define <2 x double> @test_pow_afn_v2f64_nnan_ninf__y_5
; CHECK-SAME: (<2 x double> [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn <2 x double> [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn <2 x double> [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn <2 x double> [[__POWX21]], [[X]]
; CHECK-NEXT:    ret <2 x double> [[__POWPROD]]
;
  %pow = tail call afn nnan ninf <2 x double> @_Z3powDv2_dS_(<2 x double> %x, <2 x double> <double 5.0, double 5.0>)
  ret <2 x double> %pow
}

define half @test_pow_afn_f16__y_3(half %x) {
; CHECK-LABEL: define half @test_pow_afn_f16__y_3
; CHECK-SAME: (half [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn half @_Z4pownDhi(half [[X]], i32 3)
; CHECK-NEXT:    ret half [[POW]]
;
  %pow = tail call afn half @_Z3powDhDh(half %x, half 3.0)
  ret half %pow
}

define half @test_pow_afn_f16_nnan_ninf__y_3(half %x) {
; CHECK-LABEL: define half @test_pow_afn_f16_nnan_ninf__y_3
; CHECK-SAME: (half [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn half [[X]], [[X]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn half [[__POWX2]], [[X]]
; CHECK-NEXT:    ret half [[__POWPROD]]
;
  %pow = tail call afn nnan ninf half @_Z3powDhDh(half %x, half 3.0)
  ret half %pow
}

define half @test_pow_afn_f16__y_4(half %x) {
; CHECK-LABEL: define half @test_pow_afn_f16__y_4
; CHECK-SAME: (half [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn half @_Z4pownDhi(half [[X]], i32 4)
; CHECK-NEXT:    ret half [[POW]]
;
  %pow = tail call afn half @_Z3powDhDh(half %x, half 4.0)
  ret half %pow
}

define half @test_pow_afn_f16_nnan_ninf__y_4(half %x) {
; CHECK-LABEL: define half @test_pow_afn_f16_nnan_ninf__y_4
; CHECK-SAME: (half [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn half [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn half [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    ret half [[__POWX21]]
;
  %pow = tail call afn nnan ninf half @_Z3powDhDh(half %x, half 4.0)
  ret half %pow
}

define half @test_pow_afn_f16_nnan_ninf__y_4_5(half %x) {
; CHECK-LABEL: define half @test_pow_afn_f16_nnan_ninf__y_4_5
; CHECK-SAME: (half [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan ninf afn half @_Z3powDhDh(half [[X]], half 0xH4480)
; CHECK-NEXT:    ret half [[POW]]
;
  %pow = tail call afn nnan ninf half @_Z3powDhDh(half %x, half 4.5)
  ret half %pow
}

define half @test_pow_afn_f16__y_5(half %x) {
; CHECK-LABEL: define half @test_pow_afn_f16__y_5
; CHECK-SAME: (half [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn half @_Z4pownDhi(half [[X]], i32 5)
; CHECK-NEXT:    ret half [[POW]]
;
  %pow = tail call afn half @_Z3powDhDh(half %x, half 5.0)
  ret half %pow
}

define half @test_pow_afn_f16_nnan_ninf__y_5(half %x) {
; CHECK-LABEL: define half @test_pow_afn_f16_nnan_ninf__y_5
; CHECK-SAME: (half [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn half [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn half [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn half [[__POWX21]], [[X]]
; CHECK-NEXT:    ret half [[__POWPROD]]
;
  %pow = tail call afn nnan ninf half @_Z3powDhDh(half %x, half 5.0)
  ret half %pow
}

define half @test_pow_afn_f16__y_neg5(half %x) {
; CHECK-LABEL: define half @test_pow_afn_f16__y_neg5
; CHECK-SAME: (half [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call afn half @_Z4pownDhi(half [[X]], i32 -5)
; CHECK-NEXT:    ret half [[POW]]
;
  %pow = tail call afn half @_Z3powDhDh(half %x, half -5.0)
  ret half %pow
}

define half @test_pow_afn_f16_nnan_ninf__y_neg5(half %x) {
; CHECK-LABEL: define half @test_pow_afn_f16_nnan_ninf__y_neg5
; CHECK-SAME: (half [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn half [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn half [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn half [[__POWX21]], [[X]]
; CHECK-NEXT:    [[__1POWPROD:%.*]] = fdiv nnan ninf afn half 0xH3C00, [[__POWPROD]]
; CHECK-NEXT:    ret half [[__1POWPROD]]
;
  %pow = tail call afn nnan ninf half @_Z3powDhDh(half %x, half -5.0)
  ret half %pow
}

define half @test_pow_afn_f16_nnan_ninf__y_10(half %x) {
; CHECK-LABEL: define half @test_pow_afn_f16_nnan_ninf__y_10
; CHECK-SAME: (half [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn half [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn half [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWX22:%.*]] = fmul nnan ninf afn half [[__POWX21]], [[__POWX21]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn half [[__POWX2]], [[__POWX22]]
; CHECK-NEXT:    ret half [[__POWPROD]]
;
  %pow = tail call afn nnan ninf half @_Z3powDhDh(half %x, half 10.0)
  ret half %pow
}

define <2 x half> @test_pow_afn_v2f16_nnan_ninf__y_3(<2 x half> %x) {
; CHECK-LABEL: define <2 x half> @test_pow_afn_v2f16_nnan_ninf__y_3
; CHECK-SAME: (<2 x half> [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn <2 x half> [[X]], [[X]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn <2 x half> [[__POWX2]], [[X]]
; CHECK-NEXT:    ret <2 x half> [[__POWPROD]]
;
  %pow = tail call afn nnan ninf <2 x half> @_Z3powDv2_DhS_(<2 x half> %x, <2 x half> <half 3.0, half 3.0>)
  ret <2 x half> %pow
}

define <2 x half> @test_pow_afn_v2f16_nnan_ninf__y_4(<2 x half> %x) {
; CHECK-LABEL: define <2 x half> @test_pow_afn_v2f16_nnan_ninf__y_4
; CHECK-SAME: (<2 x half> [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn <2 x half> [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn <2 x half> [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    ret <2 x half> [[__POWX21]]
;
  %pow = tail call afn nnan ninf <2 x half> @_Z3powDv2_DhS_(<2 x half> %x, <2 x half> <half 4.0, half 4.0>)
  ret <2 x half> %pow
}

define <2 x half> @test_pow_afn_v2f16_nnan_ninf__y_4_5(<2 x half> %x) {
; CHECK-LABEL: define <2 x half> @test_pow_afn_v2f16_nnan_ninf__y_4_5
; CHECK-SAME: (<2 x half> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan ninf afn <2 x half> @_Z3powDv2_DhS_(<2 x half> [[X]], <2 x half> <half 0xH4480, half 0xH4480>)
; CHECK-NEXT:    ret <2 x half> [[POW]]
;
  %pow = tail call afn nnan ninf <2 x half> @_Z3powDv2_DhS_(<2 x half> %x, <2 x half> <half 4.5, half 4.5>)
  ret <2 x half> %pow
}

define <2 x half> @test_pow_afn_v2f16_nnan_ninf__y_5(<2 x half> %x) {
; CHECK-LABEL: define <2 x half> @test_pow_afn_v2f16_nnan_ninf__y_5
; CHECK-SAME: (<2 x half> [[X:%.*]]) {
; CHECK-NEXT:    [[__POWX2:%.*]] = fmul nnan ninf afn <2 x half> [[X]], [[X]]
; CHECK-NEXT:    [[__POWX21:%.*]] = fmul nnan ninf afn <2 x half> [[__POWX2]], [[__POWX2]]
; CHECK-NEXT:    [[__POWPROD:%.*]] = fmul nnan ninf afn <2 x half> [[__POWX21]], [[X]]
; CHECK-NEXT:    ret <2 x half> [[__POWPROD]]
;
  %pow = tail call afn nnan ninf <2 x half> @_Z3powDv2_DhS_(<2 x half> %x, <2 x half> <half 5.0, half 5.0>)
  ret <2 x half> %pow
}

define float @test_pow_f32_known_integral_sitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_pow_f32_known_integral_sitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i32 [[Y]] to float
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y_CAST]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y.cast = sitofp i32 %y to float
  %pow = tail call float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define float @test_pow_afn_f32_known_integral_sitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_pow_afn_f32_known_integral_sitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i32 [[Y]] to float
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y_CAST]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y.cast = sitofp i32 %y to float
  %pow = tail call afn float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define float @test_pow_afn_nnan_ninf_f32_known_integral_sitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_pow_afn_nnan_ninf_f32_known_integral_sitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i32 [[Y]] to float
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y_CAST]] to i32
; CHECK-NEXT:    [[__FABS:%.*]] = call nnan ninf afn float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn float @llvm.log2.f32(float [[__FABS]])
; CHECK-NEXT:    [[POWNI2F:%.*]] = sitofp i32 [[TMP1]] to float
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn float [[__LOG2]], [[POWNI2F]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn float @llvm.exp2.f32(float [[__YLOGX]])
; CHECK-NEXT:    [[__YEVEN:%.*]] = shl i32 [[TMP1]], 31
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast float [[X]] to i32
; CHECK-NEXT:    [[__POW_SIGN:%.*]] = and i32 [[__YEVEN]], [[TMP2]]
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float [[__EXP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = or disjoint i32 [[__POW_SIGN]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast i32 [[TMP4]] to float
; CHECK-NEXT:    ret float [[TMP5]]
;
  %y.cast = sitofp i32 %y to float
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define float @test_pow_afn_nnan_f32_known_integral_sitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_pow_afn_nnan_f32_known_integral_sitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i32 [[Y]] to float
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y_CAST]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y.cast = sitofp i32 %y to float
  %pow = tail call afn nnan float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define float @test_pow_afn_ninf_f32_known_integral_sitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_pow_afn_ninf_f32_known_integral_sitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i32 [[Y]] to float
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y_CAST]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call ninf afn float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y.cast = sitofp i32 %y to float
  %pow = tail call afn ninf float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define float @test_pow_afn_f32_known_integral_sitofp_finite_argument(float %x, i32 %y) {
; CHECK-LABEL: define float @test_pow_afn_f32_known_integral_sitofp_finite_argument
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i32 [[Y]] to float
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y_CAST]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y.cast = sitofp i32 %y to float
  %pow = tail call float @_Z3powff(float %x, float nofpclass(inf nan) %y.cast)
  ret float %pow
}

define float @test_pow_f32_known_integral_uitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_pow_f32_known_integral_uitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp i32 [[Y]] to float
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y_CAST]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y.cast = uitofp i32 %y to float
  %pow = tail call float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define float @test_pow_afn_f32_known_integral_uitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_pow_afn_f32_known_integral_uitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp i32 [[Y]] to float
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y_CAST]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y.cast = uitofp i32 %y to float
  %pow = tail call afn float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define float @test_pow_afn_nnan_ninf_f32_known_integral_uitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_pow_afn_nnan_ninf_f32_known_integral_uitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp i32 [[Y]] to float
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y_CAST]] to i32
; CHECK-NEXT:    [[__FABS:%.*]] = call nnan ninf afn float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn float @llvm.log2.f32(float [[__FABS]])
; CHECK-NEXT:    [[POWNI2F:%.*]] = sitofp i32 [[TMP1]] to float
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn float [[__LOG2]], [[POWNI2F]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn float @llvm.exp2.f32(float [[__YLOGX]])
; CHECK-NEXT:    [[__YEVEN:%.*]] = shl i32 [[TMP1]], 31
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast float [[X]] to i32
; CHECK-NEXT:    [[__POW_SIGN:%.*]] = and i32 [[__YEVEN]], [[TMP2]]
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float [[__EXP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = or disjoint i32 [[__POW_SIGN]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast i32 [[TMP4]] to float
; CHECK-NEXT:    ret float [[TMP5]]
;
  %y.cast = uitofp i32 %y to float
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

; cast from i256 may produce infinity so can't assume integer without ninf
define float @test_pow_afn_nnan_f32_known_integral_uitofp_i256(float %x, i256 %y) {
; CHECK-LABEL: define float @test_pow_afn_nnan_f32_known_integral_uitofp_i256
; CHECK-SAME: (float [[X:%.*]], i256 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp i256 [[Y]] to float
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn float @_Z3powff(float [[X]], float [[Y_CAST]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y.cast = uitofp i256 %y to float
  %pow = tail call afn nnan float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

; cast from i256 may produce infinity so can't assume integer without ninf
define float @test_pow_afn_nnan_f32_known_integral_sitofp_i256(float %x, i256 %y) {
; CHECK-LABEL: define float @test_pow_afn_nnan_f32_known_integral_sitofp_i256
; CHECK-SAME: (float [[X:%.*]], i256 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i256 [[Y]] to float
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan afn float @_Z3powff(float [[X]], float [[Y_CAST]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y.cast = sitofp i256 %y to float
  %pow = tail call afn nnan float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define float @test_pow_afn_nnan_ninf_f32_known_integral_uitofp_i256(float %x, i256 %y) {
; CHECK-LABEL: define float @test_pow_afn_nnan_ninf_f32_known_integral_uitofp_i256
; CHECK-SAME: (float [[X:%.*]], i256 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp i256 [[Y]] to float
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y_CAST]] to i32
; CHECK-NEXT:    [[__FABS:%.*]] = call nnan ninf afn float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn float @llvm.log2.f32(float [[__FABS]])
; CHECK-NEXT:    [[POWNI2F:%.*]] = sitofp i32 [[TMP1]] to float
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn float [[__LOG2]], [[POWNI2F]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn float @llvm.exp2.f32(float [[__YLOGX]])
; CHECK-NEXT:    [[__YEVEN:%.*]] = shl i32 [[TMP1]], 31
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast float [[X]] to i32
; CHECK-NEXT:    [[__POW_SIGN:%.*]] = and i32 [[__YEVEN]], [[TMP2]]
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float [[__EXP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = or disjoint i32 [[__POW_SIGN]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast i32 [[TMP4]] to float
; CHECK-NEXT:    ret float [[TMP5]]
;
  %y.cast = uitofp i256 %y to float
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define float @test_pow_afn_nnan_ninf_f32_known_integral_sitofp_i256(float %x, i256 %y) {
; CHECK-LABEL: define float @test_pow_afn_nnan_ninf_f32_known_integral_sitofp_i256
; CHECK-SAME: (float [[X:%.*]], i256 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i256 [[Y]] to float
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y_CAST]] to i32
; CHECK-NEXT:    [[__FABS:%.*]] = call nnan ninf afn float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn float @llvm.log2.f32(float [[__FABS]])
; CHECK-NEXT:    [[POWNI2F:%.*]] = sitofp i32 [[TMP1]] to float
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn float [[__LOG2]], [[POWNI2F]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn float @llvm.exp2.f32(float [[__YLOGX]])
; CHECK-NEXT:    [[__YEVEN:%.*]] = shl i32 [[TMP1]], 31
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast float [[X]] to i32
; CHECK-NEXT:    [[__POW_SIGN:%.*]] = and i32 [[__YEVEN]], [[TMP2]]
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float [[__EXP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = or disjoint i32 [[__POW_SIGN]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast i32 [[TMP4]] to float
; CHECK-NEXT:    ret float [[TMP5]]
;
  %y.cast = sitofp i256 %y to float
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define <2 x float> @test_pow_afn_nnan_ninf_v2f32_known_integral_sitofp(<2 x float> %x, <2 x i32> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_nnan_ninf_v2f32_known_integral_sitofp
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp <2 x i32> [[Y]] to <2 x float>
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi <2 x float> [[Y_CAST]] to <2 x i32>
; CHECK-NEXT:    [[__FABS:%.*]] = call nnan ninf afn <2 x float> @llvm.fabs.v2f32(<2 x float> [[X]])
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn <2 x float> @llvm.log2.v2f32(<2 x float> [[__FABS]])
; CHECK-NEXT:    [[POWNI2F:%.*]] = sitofp <2 x i32> [[TMP1]] to <2 x float>
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn <2 x float> [[__LOG2]], [[POWNI2F]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn <2 x float> @llvm.exp2.v2f32(<2 x float> [[__YLOGX]])
; CHECK-NEXT:    [[__YEVEN:%.*]] = shl <2 x i32> [[TMP1]], <i32 31, i32 31>
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <2 x float> [[X]] to <2 x i32>
; CHECK-NEXT:    [[__POW_SIGN:%.*]] = and <2 x i32> [[__YEVEN]], [[TMP2]]
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <2 x float> [[__EXP2]] to <2 x i32>
; CHECK-NEXT:    [[TMP4:%.*]] = or disjoint <2 x i32> [[__POW_SIGN]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <2 x i32> [[TMP4]] to <2 x float>
; CHECK-NEXT:    ret <2 x float> [[TMP5]]
;
  %y.cast = sitofp <2 x i32> %y to <2 x float>
  %pow = tail call afn nnan ninf <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y.cast)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32_known_integral_uitofp(<2 x float> %x, <2 x i32> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32_known_integral_uitofp
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp <2 x i32> [[Y]] to <2 x float>
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi <2 x float> [[Y_CAST]] to <2 x i32>
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> [[TMP1]])
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %y.cast = uitofp <2 x i32> %y to <2 x float>
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y.cast)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_v2f32_known_integral_uitofp(<2 x float> %x, <2 x i32> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_v2f32_known_integral_uitofp
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp <2 x i32> [[Y]] to <2 x float>
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi <2 x float> [[Y_CAST]] to <2 x i32>
; CHECK-NEXT:    [[POW:%.*]] = tail call afn <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> [[TMP1]])
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %y.cast = uitofp <2 x i32> %y to <2 x float>
  %pow = tail call afn <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y.cast)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_afn_nnan_ninf_v2f32_known_integral_uitofp(<2 x float> %x, <2 x i32> %y) {
; CHECK-LABEL: define <2 x float> @test_pow_afn_nnan_ninf_v2f32_known_integral_uitofp
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp <2 x i32> [[Y]] to <2 x float>
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi <2 x float> [[Y_CAST]] to <2 x i32>
; CHECK-NEXT:    [[__FABS:%.*]] = call nnan ninf afn <2 x float> @llvm.fabs.v2f32(<2 x float> [[X]])
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn <2 x float> @llvm.log2.v2f32(<2 x float> [[__FABS]])
; CHECK-NEXT:    [[POWNI2F:%.*]] = sitofp <2 x i32> [[TMP1]] to <2 x float>
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn <2 x float> [[__LOG2]], [[POWNI2F]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn <2 x float> @llvm.exp2.v2f32(<2 x float> [[__YLOGX]])
; CHECK-NEXT:    [[__YEVEN:%.*]] = shl <2 x i32> [[TMP1]], <i32 31, i32 31>
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <2 x float> [[X]] to <2 x i32>
; CHECK-NEXT:    [[__POW_SIGN:%.*]] = and <2 x i32> [[__YEVEN]], [[TMP2]]
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <2 x float> [[__EXP2]] to <2 x i32>
; CHECK-NEXT:    [[TMP4:%.*]] = or disjoint <2 x i32> [[__POW_SIGN]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <2 x i32> [[TMP4]] to <2 x float>
; CHECK-NEXT:    ret <2 x float> [[TMP5]]
;
  %y.cast = uitofp <2 x i32> %y to <2 x float>
  %pow = tail call afn nnan ninf <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> %y.cast)
  ret <2 x float> %pow
}

; Could fold to powr or pown
define float @test_pow_f32_known_positive_x__known_integral_sitofp(float nofpclass(ninf nsub nnorm) %x, i32 %y) {
; CHECK-LABEL: define float @test_pow_f32_known_positive_x__known_integral_sitofp
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i32 [[Y]] to float
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4powrff(float [[X]], float [[Y_CAST]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y.cast = sitofp i32 %y to float
  %pow = tail call float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define float @test_pow_afn_f32_known_positive_x__known_integral_sitofp(float nofpclass(ninf nsub nnorm) %x, i32 %y) {
; CHECK-LABEL: define float @test_pow_afn_f32_known_positive_x__known_integral_sitofp
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i32 [[Y]] to float
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4powrff(float [[X]], float [[Y_CAST]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y.cast = sitofp i32 %y to float
  %pow = tail call afn float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define float @test_pow_afn_nnan_ninf_f32__known_positive_x__known_integral_sitofp(float nofpclass(ninf nsub nnorm) %x, i32 %y) {
; CHECK-LABEL: define float @test_pow_afn_nnan_ninf_f32__known_positive_x__known_integral_sitofp
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i32 [[Y]] to float
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn float @llvm.log2.f32(float [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn float [[__LOG2]], [[Y_CAST]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn float @llvm.exp2.f32(float [[__YLOGX]])
; CHECK-NEXT:    ret float [[__EXP2]]
;
  %y.cast = sitofp i32 %y to float
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float %y.cast)
  ret float %pow
}

define float @test_pow_f32__y_known_integral_trunc_maybe_inf(float %x, float nofpclass(nan) %y.arg) {
; CHECK-LABEL: define float @test_pow_f32__y_known_integral_trunc_maybe_inf
; CHECK-SAME: (float [[X:%.*]], float nofpclass(nan) [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.trunc.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z3powff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y = call float @llvm.trunc.f32(float %y.arg)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32__y_known_integral_trunc_maybe_nan(float %x, float nofpclass(inf) %y.arg) {
; CHECK-LABEL: define float @test_pow_f32__y_known_integral_trunc_maybe_nan
; CHECK-SAME: (float [[X:%.*]], float nofpclass(inf) [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.trunc.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z3powff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y = call float @llvm.trunc.f32(float %y.arg)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

; Cannot fold to pown, may still be inf
define float @test_pow_f32__y_known_integral_trunc_nnan_use(float %x, float %y.arg) {
; CHECK-LABEL: define float @test_pow_f32__y_known_integral_trunc_nnan_use
; CHECK-SAME: (float [[X:%.*]], float [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.trunc.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[POW:%.*]] = tail call nnan float @_Z3powff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y = call float @llvm.trunc.f32(float %y.arg)
  %pow = tail call nnan float @_Z3powff(float %x, float %y)
  ret float %pow
}

; Cannot fold to pown, may still be nan
define float @test_pow_f32__y_known_integral_trunc_ninf_use(float %x, float %y.arg) {
; CHECK-LABEL: define float @test_pow_f32__y_known_integral_trunc_ninf_use
; CHECK-SAME: (float [[X:%.*]], float [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.trunc.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[POW:%.*]] = tail call ninf float @_Z3powff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y = call float @llvm.trunc.f32(float %y.arg)
  %pow = tail call ninf float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_afn_f32_nnan_ninf__y_known_integral_trunc(float %x, float %y.arg) {
; CHECK-LABEL: define float @test_pow_afn_f32_nnan_ninf__y_known_integral_trunc
; CHECK-SAME: (float [[X:%.*]], float [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.trunc.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y]] to i32
; CHECK-NEXT:    [[__FABS:%.*]] = call nnan ninf afn float @llvm.fabs.f32(float [[X]])
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn float @llvm.log2.f32(float [[__FABS]])
; CHECK-NEXT:    [[POWNI2F:%.*]] = sitofp i32 [[TMP1]] to float
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn float [[__LOG2]], [[POWNI2F]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn float @llvm.exp2.f32(float [[__YLOGX]])
; CHECK-NEXT:    [[__YEVEN:%.*]] = shl i32 [[TMP1]], 31
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast float [[X]] to i32
; CHECK-NEXT:    [[__POW_SIGN:%.*]] = and i32 [[__YEVEN]], [[TMP2]]
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float [[__EXP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = or disjoint i32 [[__POW_SIGN]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast i32 [[TMP4]] to float
; CHECK-NEXT:    ret float [[TMP5]]
;
  %y = call float @llvm.trunc.f32(float %y.arg)
  %pow = tail call afn nnan ninf float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_afn_f32__y_known_integral_trunc(float %x, float nofpclass(inf nan) %y.arg) {
; CHECK-LABEL: define float @test_pow_afn_f32__y_known_integral_trunc
; CHECK-SAME: (float [[X:%.*]], float nofpclass(nan inf) [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.trunc.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call afn float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y = call float @llvm.trunc.f32(float %y.arg)
  %pow = tail call afn float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32__y_known_integral_floor(float %x, float nofpclass(inf nan) %y.arg) {
; CHECK-LABEL: define float @test_pow_f32__y_known_integral_floor
; CHECK-SAME: (float [[X:%.*]], float nofpclass(nan inf) [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.floor.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y = call float @llvm.floor.f32(float %y.arg)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32__y_known_integral_ceil(float %x, float nofpclass(inf nan) %y.arg) {
; CHECK-LABEL: define float @test_pow_f32__y_known_integral_ceil
; CHECK-SAME: (float [[X:%.*]], float nofpclass(nan inf) [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.floor.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y = call float @llvm.floor.f32(float %y.arg)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32__y_known_integral_trunc(float %x, float nofpclass(inf nan) %y.arg) {
; CHECK-LABEL: define float @test_pow_f32__y_known_integral_trunc
; CHECK-SAME: (float [[X:%.*]], float nofpclass(nan inf) [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.trunc.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y = call float @llvm.trunc.f32(float %y.arg)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32__y_known_integral_rint(float %x, float nofpclass(inf nan) %y.arg) {
; CHECK-LABEL: define float @test_pow_f32__y_known_integral_rint
; CHECK-SAME: (float [[X:%.*]], float nofpclass(nan inf) [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.rint.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y = call float @llvm.rint.f32(float %y.arg)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32__y_known_integral_nearbyint(float %x, float nofpclass(inf nan) %y.arg) {
; CHECK-LABEL: define float @test_pow_f32__y_known_integral_nearbyint
; CHECK-SAME: (float [[X:%.*]], float nofpclass(nan inf) [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.nearbyint.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y = call float @llvm.nearbyint.f32(float %y.arg)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32__y_known_integral_round(float %x, float nofpclass(inf nan) %y.arg) {
; CHECK-LABEL: define float @test_pow_f32__y_known_integral_round
; CHECK-SAME: (float [[X:%.*]], float nofpclass(nan inf) [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.round.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y = call float @llvm.round.f32(float %y.arg)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32__y_known_integral_roundeven(float %x, float nofpclass(inf nan) %y.arg) {
; CHECK-LABEL: define float @test_pow_f32__y_known_integral_roundeven
; CHECK-SAME: (float [[X:%.*]], float nofpclass(nan inf) [[Y_ARG:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.roundeven.f32(float [[Y_ARG]])
; CHECK-NEXT:    [[TMP1:%.*]] = fptosi float [[Y]] to i32
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret float [[POW]]
;
  %y = call float @llvm.roundeven.f32(float %y.arg)
  %pow = tail call float @_Z3powff(float %x, float %y)
  ret float %pow
}

define float @test_pow_f32_known_integral_undef(float %x) {
; CHECK-LABEL: define float @test_pow_f32_known_integral_undef
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z3powff(float [[X]], float undef)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call float @_Z3powff(float %x, float undef)
  ret float %pow
}

define float @test_pow_f32_known_integral_poison(float %x) {
; CHECK-LABEL: define float @test_pow_f32_known_integral_poison
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call float @_Z4pownfi(float [[X]], i32 poison)
; CHECK-NEXT:    ret float [[POW]]
;
  %pow = tail call float @_Z3powff(float %x, float poison)
  ret float %pow
}

define <2 x float> @test_pow_v2f32_known_integral_constant_vector_undef_elt(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32_known_integral_constant_vector_undef_elt
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> [[X]], <2 x float> <float 4.000000e+00, float undef>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 4.0, float undef>)
  ret <2 x float> %pow
}

define <2 x float> @test_pow_v2f32_known_integral_constant_vector_poison_elt(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_pow_v2f32_known_integral_constant_vector_poison_elt
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POW:%.*]] = tail call <2 x float> @_Z4pownDv2_fDv2_i(<2 x float> [[X]], <2 x i32> <i32 4, i32 poison>)
; CHECK-NEXT:    ret <2 x float> [[POW]]
;
  %pow = tail call <2 x float> @_Z3powDv2_fS_(<2 x float> %x, <2 x float> <float 4.0, float poison>)
  ret <2 x float> %pow
}

attributes #0 = { minsize }
attributes #1 = { noinline }
attributes #2 = { strictfp }
attributes #3 = { nobuiltin }
