; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=amdgcn -mcpu=tahiti -verify-machineinstrs < %s | FileCheck -check-prefix=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefix=VI %s

declare i32 @llvm.amdgcn.workitem.id.x() nounwind readnone

declare i64 @llvm.ctpop.i64(i64) nounwind readnone
declare <2 x i64> @llvm.ctpop.v2i64(<2 x i64>) nounwind readnone
declare <4 x i64> @llvm.ctpop.v4i64(<4 x i64>) nounwind readnone
declare <8 x i64> @llvm.ctpop.v8i64(<8 x i64>) nounwind readnone
declare <16 x i64> @llvm.ctpop.v16i64(<16 x i64>) nounwind readnone

declare i65 @llvm.ctpop.i65(i65) nounwind readnone
declare i128 @llvm.ctpop.i128(i128) nounwind readnone

define amdgpu_kernel void @s_ctpop_i64(ptr addrspace(1) noalias %out, [8 x i32], i64 %val) nounwind {
; SI-LABEL: s_ctpop_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctpop_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x4c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %ctpop = call i64 @llvm.ctpop.i64(i64 %val) nounwind readnone
  %truncctpop = trunc i64 %ctpop to i32
  store i32 %truncctpop, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_ctpop_i64(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) nounwind {
; SI-LABEL: v_ctpop_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_bcnt_u32_b32_e64 v0, v0, 0
; SI-NEXT:    v_bcnt_u32_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctpop_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bcnt_u32_b32 v0, v0, 0
; VI-NEXT:    v_bcnt_u32_b32 v0, v1, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %tid
  %val = load i64, ptr addrspace(1) %in.gep, align 8
  %ctpop = call i64 @llvm.ctpop.i64(i64 %val) nounwind readnone
  %truncctpop = trunc i64 %ctpop to i32
  store i32 %truncctpop, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_ctpop_i64_user(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in, i64 %s.val) nounwind {
; SI-LABEL: v_ctpop_i64_user:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; SI-NEXT:    s_load_dwordx2 s[12:13], s[2:3], 0xd
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s3
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[6:7]
; SI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s4
; SI-NEXT:    s_mov_b32 s1, s5
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_bcnt_u32_b32_e64 v0, v0, 0
; SI-NEXT:    v_bcnt_u32_b32_e32 v0, v1, v0
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_or_b32_e32 v0, s12, v0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctpop_i64_user:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_add_u32_e32 v0, vcc, s6, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bcnt_u32_b32 v0, v0, 0
; VI-NEXT:    v_bcnt_u32_b32 v0, v1, v0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_or_b32_e32 v0, s0, v0
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %tid
  %val = load i64, ptr addrspace(1) %in.gep, align 8
  %ctpop = call i64 @llvm.ctpop.i64(i64 %val) nounwind readnone
  %or = or i64 %ctpop, %s.val
  store i64 %or, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_ctpop_v2i64(ptr addrspace(1) noalias %out, <2 x i64> %val) nounwind {
; SI-LABEL: s_ctpop_v2i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0xd
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; SI-NEXT:    s_bcnt1_i32_b64 s5, s[6:7]
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctpop_v2i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x34
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; VI-NEXT:    s_bcnt1_i32_b64 s5, s[6:7]
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %ctpop = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %val) nounwind readnone
  %truncctpop = trunc <2 x i64> %ctpop to <2 x i32>
  store <2 x i32> %truncctpop, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @s_ctpop_v4i64(ptr addrspace(1) noalias %out, <4 x i64> %val) nounwind {
; SI-LABEL: s_ctpop_v4i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x11
; SI-NEXT:    s_load_dwordx2 s[12:13], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s15, 0xf000
; SI-NEXT:    s_mov_b32 s14, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_bcnt1_i32_b64 s0, s[4:5]
; SI-NEXT:    s_bcnt1_i32_b64 s1, s[6:7]
; SI-NEXT:    s_bcnt1_i32_b64 s2, s[8:9]
; SI-NEXT:    s_bcnt1_i32_b64 s3, s[10:11]
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[12:15], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctpop_v4i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x44
; VI-NEXT:    s_load_dwordx2 s[12:13], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s15, 0xf000
; VI-NEXT:    s_mov_b32 s14, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_bcnt1_i32_b64 s0, s[4:5]
; VI-NEXT:    s_bcnt1_i32_b64 s1, s[6:7]
; VI-NEXT:    s_bcnt1_i32_b64 s2, s[8:9]
; VI-NEXT:    s_bcnt1_i32_b64 s3, s[10:11]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[12:15], 0
; VI-NEXT:    s_endpgm
  %ctpop = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %val) nounwind readnone
  %truncctpop = trunc <4 x i64> %ctpop to <4 x i32>
  store <4 x i32> %truncctpop, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @v_ctpop_v2i64(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) nounwind {
; SI-LABEL: v_ctpop_v2i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_bcnt_u32_b32_e64 v0, v0, 0
; SI-NEXT:    v_bcnt_u32_b32_e64 v2, v2, 0
; SI-NEXT:    v_bcnt_u32_b32_e32 v0, v1, v0
; SI-NEXT:    v_bcnt_u32_b32_e32 v1, v3, v2
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctpop_v2i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bcnt_u32_b32 v0, v0, 0
; VI-NEXT:    v_bcnt_u32_b32 v2, v2, 0
; VI-NEXT:    v_bcnt_u32_b32 v0, v1, v0
; VI-NEXT:    v_bcnt_u32_b32 v1, v3, v2
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr <2 x i64>, ptr addrspace(1) %in, i32 %tid
  %val = load <2 x i64>, ptr addrspace(1) %in.gep, align 16
  %ctpop = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %val) nounwind readnone
  %truncctpop = trunc <2 x i64> %ctpop to <2 x i32>
  store <2 x i32> %truncctpop, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @v_ctpop_v4i64(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) nounwind {
; SI-LABEL: v_ctpop_v4i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    v_lshlrev_b32_e32 v4, 5, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v5, 0
; SI-NEXT:    buffer_load_dwordx4 v[0:3], v[4:5], s[8:11], 0 addr64
; SI-NEXT:    buffer_load_dwordx4 v[4:7], v[4:5], s[8:11], 0 addr64 offset:16
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_bcnt_u32_b32_e64 v0, v0, 0
; SI-NEXT:    v_bcnt_u32_b32_e64 v2, v2, 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_bcnt_u32_b32_e64 v4, v4, 0
; SI-NEXT:    v_bcnt_u32_b32_e64 v6, v6, 0
; SI-NEXT:    v_bcnt_u32_b32_e32 v0, v1, v0
; SI-NEXT:    v_bcnt_u32_b32_e32 v1, v3, v2
; SI-NEXT:    v_bcnt_u32_b32_e32 v2, v5, v4
; SI-NEXT:    v_bcnt_u32_b32_e32 v3, v7, v6
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctpop_v4i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 5, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v4, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[4:5]
; VI-NEXT:    v_add_u32_e32 v4, vcc, 16, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_bcnt_u32_b32 v0, v0, 0
; VI-NEXT:    v_bcnt_u32_b32 v8, v2, 0
; VI-NEXT:    v_bcnt_u32_b32 v2, v1, v0
; VI-NEXT:    v_bcnt_u32_b32 v3, v3, v8
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bcnt_u32_b32 v4, v4, 0
; VI-NEXT:    v_bcnt_u32_b32 v6, v6, 0
; VI-NEXT:    v_bcnt_u32_b32 v4, v5, v4
; VI-NEXT:    v_bcnt_u32_b32 v5, v7, v6
; VI-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr <4 x i64>, ptr addrspace(1) %in, i32 %tid
  %val = load <4 x i64>, ptr addrspace(1) %in.gep, align 32
  %ctpop = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %val) nounwind readnone
  %truncctpop = trunc <4 x i64> %ctpop to <4 x i32>
  store <4 x i32> %truncctpop, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @ctpop_i64_in_br(ptr addrspace(1) %out, ptr addrspace(1) %in, i64 %ctpop_arg, i32 %cond) {
; SI-LABEL: ctpop_i64_in_br:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dword s0, s[2:3], 0xf
; SI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; SI-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s0, 0
; SI-NEXT:    s_cbranch_scc0 .LBB7_4
; SI-NEXT:  ; %bb.1: ; %else
; SI-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x2
; SI-NEXT:    s_mov_b64 s[6:7], 0
; SI-NEXT:    s_andn2_b64 vcc, exec, s[6:7]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 vcc, vcc
; SI-NEXT:    s_cbranch_vccnz .LBB7_3
; SI-NEXT:  .LBB7_2: ; %if
; SI-NEXT:    s_bcnt1_i32_b64 s0, s[2:3]
; SI-NEXT:    s_mov_b32 s1, 0
; SI-NEXT:  .LBB7_3: ; %endif
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
; SI-NEXT:  .LBB7_4:
; SI-NEXT:    ; implicit-def: $sgpr0_sgpr1
; SI-NEXT:    s_branch .LBB7_2
;
; VI-LABEL: ctpop_i64_in_br:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dword s0, s[2:3], 0x3c
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s0, 0
; VI-NEXT:    s_cbranch_scc0 .LBB7_4
; VI-NEXT:  ; %bb.1: ; %else
; VI-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x8
; VI-NEXT:    s_cbranch_execnz .LBB7_3
; VI-NEXT:  .LBB7_2: ; %if
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_bcnt1_i32_b64 s0, s[2:3]
; VI-NEXT:    s_mov_b32 s1, 0
; VI-NEXT:  .LBB7_3: ; %endif
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
; VI-NEXT:  .LBB7_4:
; VI-NEXT:    ; implicit-def: $sgpr0_sgpr1
; VI-NEXT:    s_branch .LBB7_2
entry:
  %tmp0 = icmp eq i32 %cond, 0
  br i1 %tmp0, label %if, label %else

if:
  %tmp2 = call i64 @llvm.ctpop.i64(i64 %ctpop_arg)
  br label %endif

else:
  %tmp3 = getelementptr i64, ptr addrspace(1) %in, i32 1
  %tmp4 = load i64, ptr addrspace(1) %tmp3
  br label %endif

endif:
  %tmp5 = phi i64 [%tmp2, %if], [%tmp4, %else]
  store i64 %tmp5, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_ctpop_i128(ptr addrspace(1) noalias %out, i128 %val) nounwind {
; SI-LABEL: s_ctpop_i128:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; SI-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; SI-NEXT:    s_add_i32 s4, s4, s6
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctpop_i128:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; VI-NEXT:    s_bcnt1_i32_b64 s4, s[4:5]
; VI-NEXT:    s_add_i32 s4, s4, s6
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %ctpop = call i128 @llvm.ctpop.i128(i128 %val) nounwind readnone
  %truncctpop = trunc i128 %ctpop to i32
  store i32 %truncctpop, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @s_ctpop_i65(ptr addrspace(1) noalias %out, i65 %val) nounwind {
; SI-LABEL: s_ctpop_i65:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; SI-NEXT:    s_load_dword s8, s[2:3], 0xd
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s0, s4
; SI-NEXT:    s_and_b32 s4, s8, 0xff
; SI-NEXT:    s_mov_b32 s1, s5
; SI-NEXT:    s_bcnt1_i32_b32 s4, s4
; SI-NEXT:    s_bcnt1_i32_b64 s5, s[6:7]
; SI-NEXT:    s_add_i32 s4, s5, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctpop_i65:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dword s8, s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_and_b32 s4, s8, 0xff
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    s_bcnt1_i32_b32 s4, s4
; VI-NEXT:    s_bcnt1_i32_b64 s5, s[6:7]
; VI-NEXT:    s_add_i32 s4, s5, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %ctpop = call i65 @llvm.ctpop.i65(i65 %val) nounwind readnone
  %truncctpop = trunc i65 %ctpop to i32
  store i32 %truncctpop, ptr addrspace(1) %out, align 4
  ret void
}

; FIXME: Should not have extra add
define amdgpu_kernel void @v_ctpop_i128(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) nounwind {
; SI-LABEL: v_ctpop_i128:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_bcnt_u32_b32_e64 v2, v2, 0
; SI-NEXT:    v_bcnt_u32_b32_e64 v0, v0, 0
; SI-NEXT:    v_bcnt_u32_b32_e32 v2, v3, v2
; SI-NEXT:    v_bcnt_u32_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctpop_i128:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bcnt_u32_b32 v2, v2, 0
; VI-NEXT:    v_bcnt_u32_b32 v0, v0, 0
; VI-NEXT:    v_bcnt_u32_b32 v2, v3, v2
; VI-NEXT:    v_bcnt_u32_b32 v0, v1, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i128, ptr addrspace(1) %in, i32 %tid
  %val = load i128, ptr addrspace(1) %in.gep, align 8
  %ctpop = call i128 @llvm.ctpop.i128(i128 %val) nounwind readnone
  %truncctpop = trunc i128 %ctpop to i32
  store i32 %truncctpop, ptr addrspace(1) %out, align 4
  ret void
}
