; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn-amd-amdhsa -mcpu=hawaii -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX678,GFX6 %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn-amd-amdhsa -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX678,GFX8 %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9 %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11 %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12 %s

declare float @llvm.fabs.f32(float) #0
declare float @llvm.canonicalize.f32(float) #0
declare <2 x float> @llvm.canonicalize.v2f32(<2 x float>) #0
declare <3 x float> @llvm.canonicalize.v3f32(<3 x float>) #0
declare <4 x float> @llvm.canonicalize.v4f32(<4 x float>) #0
declare <8 x float> @llvm.canonicalize.v8f32(<8 x float>) #0
declare double @llvm.fabs.f64(double) #0
declare double @llvm.canonicalize.f64(double) #0
declare <2 x double> @llvm.canonicalize.v2f64(<2 x double>) #0
declare <3 x double> @llvm.canonicalize.v3f64(<3 x double>) #0
declare <4 x double> @llvm.canonicalize.v4f64(<4 x double>) #0
declare half @llvm.canonicalize.f16(half) #0
declare <2 x half> @llvm.canonicalize.v2f16(<2 x half>) #0
declare i32 @llvm.amdgcn.workitem.id.x() #0

define amdgpu_kernel void @v_test_canonicalize_var_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: v_test_canonicalize_var_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_load_dword v2, v[0:1]
; GFX678-NEXT:    s_waitcnt vmcnt(0)
; GFX678-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_canonicalize_var_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_canonicalize_var_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_test_canonicalize_var_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e32 v1, v1, v1
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %val = load float, ptr addrspace(1) %out
  %canonicalized = call float @llvm.canonicalize.f32(float %val)
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_test_canonicalize_var_f32(ptr addrspace(1) %out, float %val) #1 {
; GFX6-LABEL: s_test_canonicalize_var_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dword s2, s[6:7], 0x2
; GFX6-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mul_f32_e64 v2, 1.0, s2
; GFX6-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    flat_store_dword v[0:1], v2
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: s_test_canonicalize_var_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[6:7], 0x8
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e64 v2, 1.0, s2
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_test_canonicalize_var_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[6:7], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e64 v1, s2, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: s_test_canonicalize_var_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x8
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e64 v1, s4, s4
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: s_test_canonicalize_var_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b96 s[0:2], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e64 v1, s2, s2
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float %val)
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_test_canonicalize_fabs_var_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: v_test_canonicalize_fabs_var_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_load_dword v2, v[0:1]
; GFX678-NEXT:    s_waitcnt vmcnt(0)
; GFX678-NEXT:    v_mul_f32_e64 v2, 1.0, |v2|
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_canonicalize_fabs_var_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f32_e64 v1, |v1|, |v1|
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_canonicalize_fabs_var_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f32_e64 v1, |v1|, |v1|
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_test_canonicalize_fabs_var_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e64 v1, |v1|, |v1|
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %val = load float, ptr addrspace(1) %out
  %val.fabs = call float @llvm.fabs.f32(float %val)
  %canonicalized = call float @llvm.canonicalize.f32(float %val.fabs)
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_test_canonicalize_fneg_fabs_var_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: v_test_canonicalize_fneg_fabs_var_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_load_dword v2, v[0:1]
; GFX678-NEXT:    s_waitcnt vmcnt(0)
; GFX678-NEXT:    v_mul_f32_e64 v2, -1.0, |v2|
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_canonicalize_fneg_fabs_var_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f32_e64 v1, -|v1|, -|v1|
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_canonicalize_fneg_fabs_var_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f32_e64 v1, -|v1|, -|v1|
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_test_canonicalize_fneg_fabs_var_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e64 v1, -|v1|, -|v1|
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %val = load float, ptr addrspace(1) %out
  %val.fabs = call float @llvm.fabs.f32(float %val)
  %val.fabs.fneg = fneg float %val.fabs
  %canonicalized = call float @llvm.canonicalize.f32(float %val.fabs.fneg)
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_test_canonicalize_fneg_var_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: v_test_canonicalize_fneg_var_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_load_dword v2, v[0:1]
; GFX678-NEXT:    s_waitcnt vmcnt(0)
; GFX678-NEXT:    v_mul_f32_e32 v2, -1.0, v2
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_canonicalize_fneg_var_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f32_e64 v1, -v1, -v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_canonicalize_fneg_var_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f32_e64 v1, -v1, -v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_test_canonicalize_fneg_var_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e64 v1, -v1, -v1
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %val = load float, ptr addrspace(1) %out
  %val.fneg = fneg float %val
  %canonicalized = call float @llvm.canonicalize.f32(float %val.fneg)
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_undef_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_undef_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_undef_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_undef_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_undef_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v0, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float undef)
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_p0_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_p0_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_p0_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_p0_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_p0_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v0, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float 0.0)
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_n0_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_n0_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_n0_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_n0_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_n0_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float -0.0)
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_p1_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_p1_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 1.0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_p1_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 1.0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_p1_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 1.0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_p1_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 1.0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float 1.0)
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_n1_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_n1_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, -1.0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_n1_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, -1.0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_n1_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, -1.0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_n1_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, -1.0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float -1.0)
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_literal_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_literal_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x41800000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_literal_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x41800000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_literal_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x41800000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_literal_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x41800000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float 16.0)
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_no_denormals_fold_canonicalize_denormal0_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v0, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 8388607 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_no_denormals_fold_canonicalize_denormal0_f32_dynamic(ptr addrspace(1) %out) #5 {
; GFX678-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32_dynamic:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    s_mov_b32 s2, 0x7fffff
; GFX678-NEXT:    v_mul_f32_e64 v2, 1.0, s2
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32_dynamic:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    s_mov_b32 s2, 0x7fffff
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_max_f32_e64 v1, s2, s2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32_dynamic:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_max_f32_e64 v1, 0x7fffff, 0x7fffff
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32_dynamic:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    v_max_num_f32_e64 v1, 0x7fffff, 0x7fffff
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 8388607 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_no_denormals_fold_canonicalize_denormal0_f32_dynamic_out(ptr addrspace(1) %out) #6 {
; GFX678-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32_dynamic_out:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    s_mov_b32 s2, 0x7fffff
; GFX678-NEXT:    v_mul_f32_e64 v2, 1.0, s2
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32_dynamic_out:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    s_mov_b32 s2, 0x7fffff
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_max_f32_e64 v1, s2, s2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32_dynamic_out:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_max_f32_e64 v1, 0x7fffff, 0x7fffff
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32_dynamic_out:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    v_max_num_f32_e64 v1, 0x7fffff, 0x7fffff
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 8388607 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_no_denormals_fold_canonicalize_denormal0_f32_dynamic_in(ptr addrspace(1) %out) #7 {
; GFX678-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32_dynamic_in:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    s_mov_b32 s2, 0x7fffff
; GFX678-NEXT:    v_mul_f32_e64 v2, 1.0, s2
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32_dynamic_in:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    s_mov_b32 s2, 0x7fffff
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_max_f32_e64 v1, s2, s2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32_dynamic_in:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_max_f32_e64 v1, 0x7fffff, 0x7fffff
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_no_denormals_fold_canonicalize_denormal0_f32_dynamic_in:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    v_max_num_f32_e64 v1, 0x7fffff, 0x7fffff
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 8388607 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_denormals_fold_canonicalize_denormal0_f32(ptr addrspace(1) %out) #3 {
; GFX678-LABEL: test_denormals_fold_canonicalize_denormal0_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x7fffff
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_denormals_fold_canonicalize_denormal0_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7fffff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_denormals_fold_canonicalize_denormal0_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fffff
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_denormals_fold_canonicalize_denormal0_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fffff
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 8388607 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_no_denormals_fold_canonicalize_denormal1_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_no_denormals_fold_canonicalize_denormal1_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_no_denormals_fold_canonicalize_denormal1_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_no_denormals_fold_canonicalize_denormal1_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_no_denormals_fold_canonicalize_denormal1_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 2155872255 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_denormals_fold_canonicalize_denormal1_f32(ptr addrspace(1) %out) #3 {
; GFX678-LABEL: test_denormals_fold_canonicalize_denormal1_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x807fffff
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_denormals_fold_canonicalize_denormal1_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x807fffff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_denormals_fold_canonicalize_denormal1_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x807fffff
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_denormals_fold_canonicalize_denormal1_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x807fffff
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 2155872255 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_qnan_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_qnan_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_qnan_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_qnan_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_qnan_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float 0x7FF8000000000000)
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_qnan_value_neg1_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_qnan_value_neg1_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_qnan_value_neg1_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_qnan_value_neg1_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_qnan_value_neg1_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 -1 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_qnan_value_neg2_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_qnan_value_neg2_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_qnan_value_neg2_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_qnan_value_neg2_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_qnan_value_neg2_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 -2 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_snan0_value_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_snan0_value_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_snan0_value_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_snan0_value_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_snan0_value_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 2139095041 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_snan1_value_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_snan1_value_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_snan1_value_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_snan1_value_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_snan1_value_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 2143289343 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_snan2_value_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_snan2_value_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_snan2_value_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_snan2_value_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_snan2_value_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 4286578689 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_snan3_value_f32(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_snan3_value_f32:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_store_dword v[0:1], v2
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_snan3_value_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_snan3_value_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_snan3_value_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7fc00000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call float @llvm.canonicalize.f32(float bitcast (i32 4290772991 to float))
  store float %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_test_canonicalize_var_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: v_test_canonicalize_var_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_load_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_waitcnt vmcnt(0)
; GFX678-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX678-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_canonicalize_var_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_canonicalize_var_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_test_canonicalize_var_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %val = load double, ptr addrspace(1) %out
  %canonicalized = call double @llvm.canonicalize.f64(double %val)
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_test_canonicalize_var_f64(ptr addrspace(1) %out, double %val) #1 {
; GFX6-LABEL: s_test_canonicalize_var_f64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_max_f64 v[2:3], s[2:3], s[2:3]
; GFX6-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: s_test_canonicalize_var_f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[0:1], s[2:3], s[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_test_canonicalize_var_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], s[2:3], s[2:3]
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: s_test_canonicalize_var_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], s[2:3], s[2:3]
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: s_test_canonicalize_var_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e64 v[0:1], s[2:3], s[2:3]
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double %val)
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_test_canonicalize_fabs_var_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: v_test_canonicalize_fabs_var_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_load_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_waitcnt vmcnt(0)
; GFX678-NEXT:    v_max_f64 v[2:3], |v[2:3]|, |v[2:3]|
; GFX678-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_canonicalize_fabs_var_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], |v[0:1]|, |v[0:1]|
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_canonicalize_fabs_var_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], |v[0:1]|, |v[0:1]|
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_test_canonicalize_fabs_var_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e64 v[0:1], |v[0:1]|, |v[0:1]|
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %val = load double, ptr addrspace(1) %out
  %val.fabs = call double @llvm.fabs.f64(double %val)
  %canonicalized = call double @llvm.canonicalize.f64(double %val.fabs)
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_test_canonicalize_fneg_fabs_var_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: v_test_canonicalize_fneg_fabs_var_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_load_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_waitcnt vmcnt(0)
; GFX678-NEXT:    v_max_f64 v[2:3], -|v[2:3]|, -|v[2:3]|
; GFX678-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_canonicalize_fneg_fabs_var_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], -|v[0:1]|, -|v[0:1]|
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_canonicalize_fneg_fabs_var_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], -|v[0:1]|, -|v[0:1]|
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_test_canonicalize_fneg_fabs_var_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e64 v[0:1], -|v[0:1]|, -|v[0:1]|
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %val = load double, ptr addrspace(1) %out
  %val.fabs = call double @llvm.fabs.f64(double %val)
  %val.fabs.fneg = fneg double %val.fabs
  %canonicalized = call double @llvm.canonicalize.f64(double %val.fabs.fneg)
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_test_canonicalize_fneg_var_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: v_test_canonicalize_fneg_var_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v0, s0
; GFX678-NEXT:    v_mov_b32_e32 v1, s1
; GFX678-NEXT:    flat_load_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_waitcnt vmcnt(0)
; GFX678-NEXT:    v_max_f64 v[2:3], -v[2:3], -v[2:3]
; GFX678-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_canonicalize_fneg_var_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], -v[0:1], -v[0:1]
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_canonicalize_fneg_var_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], -v[0:1], -v[0:1]
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_test_canonicalize_fneg_var_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e64 v[0:1], -v[0:1], -v[0:1]
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %val = load double, ptr addrspace(1) %out
  %val.fneg = fneg double %val
  %canonicalized = call double @llvm.canonicalize.f64(double %val.fneg)
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_p0_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_p0_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_mov_b32_e32 v1, v0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_p0_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_p0_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_p0_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mov_b32_e32 v1, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double 0.0)
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_n0_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_n0_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_n0_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_n0_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_n0_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double -0.0)
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_p1_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_p1_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_mov_b32_e32 v1, 0x3ff00000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_p1_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x3ff00000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_p1_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x3ff00000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_p1_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x3ff00000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double 1.0)
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_n1_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_n1_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_mov_b32_e32 v1, 0xbff00000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_n1_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xbff00000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_n1_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0xbff00000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_n1_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0xbff00000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double -1.0)
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_literal_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_literal_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_mov_b32_e32 v1, 0x40300000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_literal_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40300000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_literal_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x40300000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_literal_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x40300000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double 16.0)
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_no_denormals_fold_canonicalize_denormal0_f64(ptr addrspace(1) %out) #2 {
; GFX678-LABEL: test_no_denormals_fold_canonicalize_denormal0_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_mov_b32_e32 v1, v0
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_no_denormals_fold_canonicalize_denormal0_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_no_denormals_fold_canonicalize_denormal0_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_no_denormals_fold_canonicalize_denormal0_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mov_b32_e32 v1, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double bitcast (i64 4503599627370495 to double))
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_denormals_fold_canonicalize_denormal0_f64(ptr addrspace(1) %out) #3 {
; GFX678-LABEL: test_denormals_fold_canonicalize_denormal0_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, -1
; GFX678-NEXT:    v_mov_b32_e32 v1, 0xfffff
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_denormals_fold_canonicalize_denormal0_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, -1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xfffff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_denormals_fold_canonicalize_denormal0_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, 0xfffff
; GFX11-NEXT:    v_mov_b32_e32 v0, -1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_denormals_fold_canonicalize_denormal0_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, 0xfffff
; GFX12-NEXT:    v_mov_b32_e32 v0, -1
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double bitcast (i64 4503599627370495 to double))
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_no_denormals_fold_canonicalize_denormal1_f64(ptr addrspace(1) %out) #2 {
; GFX678-LABEL: test_no_denormals_fold_canonicalize_denormal1_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_no_denormals_fold_canonicalize_denormal1_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_no_denormals_fold_canonicalize_denormal1_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_no_denormals_fold_canonicalize_denormal1_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double bitcast (i64 9227875636482146303 to double))
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_denormals_fold_canonicalize_denormal1_f64(ptr addrspace(1) %out) #3 {
; GFX678-LABEL: test_denormals_fold_canonicalize_denormal1_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, -1
; GFX678-NEXT:    v_mov_b32_e32 v1, 0x800fffff
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_denormals_fold_canonicalize_denormal1_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, -1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x800fffff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_denormals_fold_canonicalize_denormal1_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, 0x800fffff
; GFX11-NEXT:    v_mov_b32_e32 v0, -1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_denormals_fold_canonicalize_denormal1_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, 0x800fffff
; GFX12-NEXT:    v_mov_b32_e32 v0, -1
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double bitcast (i64 9227875636482146303 to double))
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_qnan_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_qnan_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_qnan_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_qnan_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_qnan_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double 0x7FF8000000000000)
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_qnan_value_neg1_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_qnan_value_neg1_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_qnan_value_neg1_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_qnan_value_neg1_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_qnan_value_neg1_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double bitcast (i64 -1 to double))
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_qnan_value_neg2_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_qnan_value_neg2_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_qnan_value_neg2_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_qnan_value_neg2_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_qnan_value_neg2_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double bitcast (i64 -2 to double))
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_snan0_value_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_snan0_value_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_snan0_value_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_snan0_value_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_snan0_value_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double bitcast (i64 9218868437227405313 to double))
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_snan1_value_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_snan1_value_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_snan1_value_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_snan1_value_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_snan1_value_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double bitcast (i64 9223372036854775807 to double))
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_snan2_value_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_snan2_value_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_snan2_value_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_snan2_value_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_snan2_value_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double bitcast (i64 18442240474082181121 to double))
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_fold_canonicalize_snan3_value_f64(ptr addrspace(1) %out) #1 {
; GFX678-LABEL: test_fold_canonicalize_snan3_value_f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX678-NEXT:    v_mov_b32_e32 v0, 0
; GFX678-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX678-NEXT:    s_waitcnt lgkmcnt(0)
; GFX678-NEXT:    v_mov_b32_e32 v3, s1
; GFX678-NEXT:    v_mov_b32_e32 v2, s0
; GFX678-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX678-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fold_canonicalize_snan3_value_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fold_canonicalize_snan3_value_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_fold_canonicalize_snan3_value_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7ff80000
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %canonicalized = call double @llvm.canonicalize.f64(double bitcast (i64 18446744073709551615 to double))
  store double %canonicalized, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_canonicalize_value_f64_flush(ptr addrspace(1) %arg, ptr addrspace(1) %out) #4 {
; GFX6-LABEL: test_canonicalize_value_f64_flush:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, s2, v2
; GFX6-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mul_f64 v[0:1], 1.0, v[0:1]
; GFX6-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: test_canonicalize_value_f64_flush:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mul_f64 v[0:1], 1.0, v[0:1]
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: test_canonicalize_value_f64_flush:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_canonicalize_value_f64_flush:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_canonicalize_value_f64_flush:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %id = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr inbounds double, ptr addrspace(1) %arg, i32 %id
  %v = load double, ptr addrspace(1) %gep, align 8
  %canonicalized = tail call double @llvm.canonicalize.f64(double %v)
  %gep2 = getelementptr inbounds double, ptr addrspace(1) %out, i32 %id
  store double %canonicalized, ptr addrspace(1) %gep2, align 8
  ret void
}

define amdgpu_kernel void @test_canonicalize_value_f32_flush(ptr addrspace(1) %arg, ptr addrspace(1) %out) #4 {
; GFX6-LABEL: test_canonicalize_value_f32_flush:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_load_dword v0, v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v0
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_store_dword v[0:1], v3
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: test_canonicalize_value_f32_flush:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v3, 1.0, v0
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_store_dword v[0:1], v3
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: test_canonicalize_value_f32_flush:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_canonicalize_value_f32_flush:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[2:3]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_canonicalize_value_f32_flush:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e32 v1, v1, v1
; GFX12-NEXT:    global_store_b32 v0, v1, s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %id = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr inbounds float, ptr addrspace(1) %arg, i32 %id
  %v = load float, ptr addrspace(1) %gep, align 4
  %canonicalized = tail call float @llvm.canonicalize.f32(float %v)
  %gep2 = getelementptr inbounds float, ptr addrspace(1) %out, i32 %id
  store float %canonicalized, ptr addrspace(1) %gep2, align 4
  ret void
}

define amdgpu_kernel void @test_canonicalize_value_f16_flush(ptr addrspace(1) %arg, ptr addrspace(1) %out) #4 {
; GFX6-LABEL: test_canonicalize_value_f16_flush:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_load_ushort v0, v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v0
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_store_short v[0:1], v3
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: test_canonicalize_value_f16_flush:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mul_f16_e32 v3, 1.0, v0
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_store_short v[0:1], v3
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: test_canonicalize_value_f16_flush:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ushort v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX9-NEXT:    global_store_short v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_canonicalize_value_f16_flush:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_u16 v1, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX11-NEXT:    global_store_b16 v0, v1, s[2:3]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_canonicalize_value_f16_flush:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u16 v1, v0, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f16_e32 v1, v1, v1
; GFX12-NEXT:    global_store_b16 v0, v1, s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %id = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr inbounds half, ptr addrspace(1) %arg, i32 %id
  %v = load half, ptr addrspace(1) %gep, align 2
  %canonicalized = tail call half @llvm.canonicalize.f16(half %v)
  %gep2 = getelementptr inbounds half, ptr addrspace(1) %out, i32 %id
  store half %canonicalized, ptr addrspace(1) %gep2, align 2
  ret void
}


define amdgpu_kernel void @test_canonicalize_value_v2f16_flush(ptr addrspace(1) %arg, ptr addrspace(1) %out) #4 {
; GFX6-LABEL: test_canonicalize_value_v2f16_flush:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_load_dword v0, v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v4, v0, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v3, vcc
; GFX6-NEXT:    flat_store_dword v[0:1], v4
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: test_canonicalize_value_v2f16_flush:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, 0x3c00
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mul_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, 1.0, v0
; GFX8-NEXT:    v_or_b32_e32 v4, v0, v1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_store_dword v[0:1], v4
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: test_canonicalize_value_v2f16_flush:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_canonicalize_value_v2f16_flush:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[2:3]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_canonicalize_value_v2f16_flush:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v1
; GFX12-NEXT:    global_store_b32 v0, v1, s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %id = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr inbounds <2 x half>, ptr addrspace(1) %arg, i32 %id
  %v = load <2 x half>, ptr addrspace(1) %gep, align 4
  %canonicalized = tail call <2 x half> @llvm.canonicalize.v2f16(<2 x half> %v)
  %gep2 = getelementptr inbounds <2 x half>, ptr addrspace(1) %out, i32 %id
  store <2 x half> %canonicalized, ptr addrspace(1) %gep2, align 2
  ret void
}

define amdgpu_kernel void @test_canonicalize_value_f64_denorm(ptr addrspace(1) %arg, ptr addrspace(1) %out) #3 {
; GFX6-LABEL: test_canonicalize_value_f64_denorm:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, s2, v2
; GFX6-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX6-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: test_canonicalize_value_f64_denorm:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: test_canonicalize_value_f64_denorm:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_canonicalize_value_f64_denorm:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_canonicalize_value_f64_denorm:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %id = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr inbounds double, ptr addrspace(1) %arg, i32 %id
  %v = load double, ptr addrspace(1) %gep, align 8
  %canonicalized = tail call double @llvm.canonicalize.f64(double %v)
  %gep2 = getelementptr inbounds double, ptr addrspace(1) %out, i32 %id
  store double %canonicalized, ptr addrspace(1) %gep2, align 8
  ret void
}

define amdgpu_kernel void @test_canonicalize_value_f32_denorm(ptr addrspace(1) %arg, ptr addrspace(1) %out) #3 {
; GFX6-LABEL: test_canonicalize_value_f32_denorm:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_load_dword v0, v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v0
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_store_dword v[0:1], v3
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: test_canonicalize_value_f32_denorm:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v3, 1.0, v0
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_store_dword v[0:1], v3
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: test_canonicalize_value_f32_denorm:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_canonicalize_value_f32_denorm:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[2:3]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_canonicalize_value_f32_denorm:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e32 v1, v1, v1
; GFX12-NEXT:    global_store_b32 v0, v1, s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %id = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr inbounds float, ptr addrspace(1) %arg, i32 %id
  %v = load float, ptr addrspace(1) %gep, align 4
  %canonicalized = tail call float @llvm.canonicalize.f32(float %v)
  %gep2 = getelementptr inbounds float, ptr addrspace(1) %out, i32 %id
  store float %canonicalized, ptr addrspace(1) %gep2, align 4
  ret void
}

; FIXME: Conversion to float should count as the canonicalize pre-gfx8
define amdgpu_kernel void @test_canonicalize_value_f16_denorm(ptr addrspace(1) %arg, ptr addrspace(1) %out) #3 {
; GFX6-LABEL: test_canonicalize_value_f16_denorm:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_load_ushort v0, v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v0
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_store_short v[0:1], v3
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: test_canonicalize_value_f16_denorm:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_max_f16_e32 v3, v0, v0
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_store_short v[0:1], v3
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: test_canonicalize_value_f16_denorm:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ushort v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX9-NEXT:    global_store_short v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_canonicalize_value_f16_denorm:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_u16 v1, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX11-NEXT:    global_store_b16 v0, v1, s[2:3]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_canonicalize_value_f16_denorm:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u16 v1, v0, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f16_e32 v1, v1, v1
; GFX12-NEXT:    global_store_b16 v0, v1, s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %id = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr inbounds half, ptr addrspace(1) %arg, i32 %id
  %v = load half, ptr addrspace(1) %gep, align 2
  %canonicalized = tail call half @llvm.canonicalize.f16(half %v)
  %gep2 = getelementptr inbounds half, ptr addrspace(1) %out, i32 %id
  store half %canonicalized, ptr addrspace(1) %gep2, align 2
  ret void
}



define amdgpu_kernel void @test_canonicalize_value_v2f16_denorm(ptr addrspace(1) %arg, ptr addrspace(1) %out) #3 {
; GFX6-LABEL: test_canonicalize_value_v2f16_denorm:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_load_dword v0, v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v4, v0, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v3, vcc
; GFX6-NEXT:    flat_store_dword v[0:1], v4
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: test_canonicalize_value_v2f16_denorm:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v3, v0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_or_b32_e32 v3, v0, v3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_store_dword v[0:1], v3
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: test_canonicalize_value_v2f16_denorm:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_canonicalize_value_v2f16_denorm:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[2:3]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_canonicalize_value_v2f16_denorm:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v1
; GFX12-NEXT:    global_store_b32 v0, v1, s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %id = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr inbounds <2 x half>, ptr addrspace(1) %arg, i32 %id
  %v = load <2 x half>, ptr addrspace(1) %gep, align 4
  %canonicalized = tail call <2 x half> @llvm.canonicalize.v2f16(<2 x half> %v)
  %gep2 = getelementptr inbounds <2 x half>, ptr addrspace(1) %out, i32 %id
  store <2 x half> %canonicalized, ptr addrspace(1) %gep2, align 2
  ret void
}

define amdgpu_kernel void @v_test_canonicalize_var_v2f64(ptr addrspace(1) %out) #1 {
; GFX6-LABEL: v_test_canonicalize_var_v2f64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v5, s1
; GFX6-NEXT:    v_mov_b32_e32 v4, s0
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX6-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX6-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: v_test_canonicalize_var_v2f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_canonicalize_var_v2f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_canonicalize_var_v2f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b128 v[0:3], v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    global_store_b128 v4, v[0:3], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_test_canonicalize_var_v2f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b128 v[0:3], v0, s[0:1]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[2:3]
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    global_store_b128 v4, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <2 x double>, ptr addrspace(1) %out, i32 %tid
  %val = load <2 x double>, ptr addrspace(1) %gep
  %canonicalized = call <2 x double> @llvm.canonicalize.v2f64(<2 x double> %val)
  store <2 x double> %canonicalized, ptr addrspace(1) %out
  ret void
}


define <2 x float> @v_test_canonicalize_v2f32_flush(<2 x float> %arg) #1 {
; GFX678-LABEL: v_test_canonicalize_v2f32_flush:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX678-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_canonicalize_v2f32_flush:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_test_canonicalize_v2f32_flush:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_canonicalize_v2f32_flush:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v0 :: v_dual_max_num_f32 v1, v1, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %canon = call <2 x float> @llvm.canonicalize.v2f32(<2 x float> %arg)
  ret <2 x float> %canon
}


define <3 x float> @v_test_canonicalize_v3f32_flush(<3 x float> %arg) #1 {
; GFX678-LABEL: v_test_canonicalize_v3f32_flush:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX678-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX678-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_canonicalize_v3f32_flush:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_test_canonicalize_v3f32_flush:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_canonicalize_v3f32_flush:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v0 :: v_dual_max_num_f32 v1, v1, v1
; GFX12-NEXT:    v_max_num_f32_e32 v2, v2, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %canon = call <3 x float> @llvm.canonicalize.v3f32(<3 x float> %arg)
  ret <3 x float> %canon
}


define <4 x float> @v_test_canonicalize_v4f32_flush(<4 x float> %arg) #1 {
; GFX678-LABEL: v_test_canonicalize_v4f32_flush:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX678-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX678-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX678-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_canonicalize_v4f32_flush:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX9-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_test_canonicalize_v4f32_flush:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_dual_max_f32 v2, v2, v2 :: v_dual_max_f32 v3, v3, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_canonicalize_v4f32_flush:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v0 :: v_dual_max_num_f32 v1, v1, v1
; GFX12-NEXT:    v_dual_max_num_f32 v2, v2, v2 :: v_dual_max_num_f32 v3, v3, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %canon = call <4 x float> @llvm.canonicalize.v4f32(<4 x float> %arg)
  ret <4 x float> %canon
}


define <8 x float> @v_test_canonicalize_v8f32_flush(<8 x float> %arg) #1 {
; GFX678-LABEL: v_test_canonicalize_v8f32_flush:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX678-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX678-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX678-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX678-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX678-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX678-NEXT:    v_mul_f32_e32 v6, 1.0, v6
; GFX678-NEXT:    v_mul_f32_e32 v7, 1.0, v7
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_canonicalize_v8f32_flush:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX9-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX9-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX9-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-NEXT:    v_max_f32_e32 v6, v6, v6
; GFX9-NEXT:    v_max_f32_e32 v7, v7, v7
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_test_canonicalize_v8f32_flush:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_dual_max_f32 v2, v2, v2 :: v_dual_max_f32 v3, v3, v3
; GFX11-NEXT:    v_dual_max_f32 v4, v4, v4 :: v_dual_max_f32 v5, v5, v5
; GFX11-NEXT:    v_dual_max_f32 v6, v6, v6 :: v_dual_max_f32 v7, v7, v7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_canonicalize_v8f32_flush:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v0 :: v_dual_max_num_f32 v1, v1, v1
; GFX12-NEXT:    v_dual_max_num_f32 v2, v2, v2 :: v_dual_max_num_f32 v3, v3, v3
; GFX12-NEXT:    v_dual_max_num_f32 v4, v4, v4 :: v_dual_max_num_f32 v5, v5, v5
; GFX12-NEXT:    v_dual_max_num_f32 v6, v6, v6 :: v_dual_max_num_f32 v7, v7, v7
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %canon = call <8 x float> @llvm.canonicalize.v8f32(<8 x float> %arg)
  ret <8 x float> %canon
}

define <2 x double> @v_test_canonicalize_v2f64(<2 x double> %arg) #1 {
; GFX678-LABEL: v_test_canonicalize_v2f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX678-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_canonicalize_v2f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_test_canonicalize_v2f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_canonicalize_v2f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[2:3]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %canon = call <2 x double> @llvm.canonicalize.v2f64(<2 x double> %arg)
  ret <2 x double> %canon
}

define <3 x double> @v_test_canonicalize_v3f64(<3 x double> %arg) #1 {
; GFX678-LABEL: v_test_canonicalize_v3f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX678-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX678-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_canonicalize_v3f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_test_canonicalize_v3f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_canonicalize_v3f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[2:3]
; GFX12-NEXT:    v_max_num_f64_e32 v[4:5], v[4:5], v[4:5]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %canon = call <3 x double> @llvm.canonicalize.v3f64(<3 x double> %arg)
  ret <3 x double> %canon
}

define <4 x double> @v_test_canonicalize_v4f64(<4 x double> %arg) #1 {
; GFX678-LABEL: v_test_canonicalize_v4f64:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX678-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX678-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX678-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_canonicalize_v4f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX9-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_test_canonicalize_v4f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX11-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_canonicalize_v4f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[2:3]
; GFX12-NEXT:    v_max_num_f64_e32 v[4:5], v[4:5], v[4:5]
; GFX12-NEXT:    v_max_num_f64_e32 v[6:7], v[6:7], v[6:7]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %canon = call <4 x double> @llvm.canonicalize.v4f64(<4 x double> %arg)
  ret <4 x double> %canon
}

attributes #0 = { nounwind readnone }
attributes #1 = { nounwind "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
attributes #2 = { nounwind "denormal-fp-math"="preserve-sign,preserve-sign" }
attributes #3 = { nounwind "denormal-fp-math"="ieee,ieee" }
attributes #4 = { nounwind "denormal-fp-math"="preserve-sign,preserve-sign" }
attributes #5 = { nounwind "denormal-fp-math-f32"="dynamic,dynamic" }
attributes #6 = { nounwind "denormal-fp-math-f32"="dynamic,ieee" }
attributes #7 = { nounwind "denormal-fp-math-f32"="ieee,dynamic" }
