; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefixes=GCN,GFX678,GFX67,GFX6,GFX6-FASTFMA %s
; RUN: llc -mtriple=amdgcn -mcpu=pitcairn < %s | FileCheck -check-prefixes=GCN,GFX678,GFX67,GFX6,GFX6-SLOWFMA %s
; RUN: llc -mtriple=amdgcn -mcpu=hawaii < %s | FileCheck -check-prefixes=GCN,GFX678,GFX67,GFX7 %s
; RUN: llc -mtriple=amdgcn -mcpu=fiji < %s | FileCheck -check-prefixes=GCN,GFX678,GFX8 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GCN,GFX10 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 < %s | FileCheck -check-prefixes=GCN,GFX11 %s
; RUN: llc -mtriple=r600 -mcpu=redwood < %s | FileCheck -check-prefix=EG %s

; These tests check that fdiv is expanded correctly and also test that the
; scheduler is scheduling the RECIP_IEEE and MUL_IEEE instructions in separate
; instruction groups.

; These test check that fdiv using unsafe_fp_math, coarse fp div, and IEEE754 fp div.

define amdgpu_kernel void @s_fdiv_f32_ninf(ptr addrspace(1) %out, float %a, float %b) #0 {
; GFX6-FASTFMA-LABEL: s_fdiv_f32_ninf:
; GFX6-FASTFMA:       ; %bb.0: ; %entry
; GFX6-FASTFMA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX6-FASTFMA-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-FASTFMA-NEXT:    s_mov_b32 s6, -1
; GFX6-FASTFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v1, s2
; GFX6-FASTFMA-NEXT:    s_mov_b32 s4, s0
; GFX6-FASTFMA-NEXT:    s_mov_b32 s5, s1
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[0:1], s3, s3, v1
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v0, s3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v0, vcc, s2, v0, s2
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v4, v0, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v4, v0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v0, -v2, v4, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v0, v0, v3, v4
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v0, s3, v1
; GFX6-FASTFMA-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-FASTFMA-NEXT:    s_endpgm
;
; GFX6-SLOWFMA-LABEL: s_fdiv_f32_ninf:
; GFX6-SLOWFMA:       ; %bb.0: ; %entry
; GFX6-SLOWFMA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s6, -1
; GFX6-SLOWFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, s[4:5], s3, s3, v0
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v2, s3
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, vcc, s2, v2, s2
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s4, s0
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s5, s1
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v3, v1
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v1, s3, v0
; GFX6-SLOWFMA-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-SLOWFMA-NEXT:    s_endpgm
;
; GFX7-LABEL: s_fdiv_f32_ninf:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    s_mov_b32 s4, s0
; GFX7-NEXT:    s_mov_b32 s5, s1
; GFX7-NEXT:    v_div_scale_f32 v2, s[0:1], s3, s3, v1
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, s3
; GFX7-NEXT:    v_div_scale_f32 v0, vcc, s2, v0, s2
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v4, v0, v3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v4, v0
; GFX7-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX7-NEXT:    v_fma_f32 v0, -v2, v4, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v3, v4
; GFX7-NEXT:    v_div_fixup_f32 v0, v0, s3, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_f32_ninf:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_div_scale_f32 v1, s[4:5], s3, s3, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, s2, v2, s2
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX8-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX8-NEXT:    v_div_fixup_f32 v2, v1, s3, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_f32_ninf:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v0, s0, s7, s7, s6
; GFX10-NEXT:    v_div_scale_f32 v2, vcc_lo, s6, s7, s6
; GFX10-NEXT:    v_rcp_f32_e32 v1, v0
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v1, v3, v1
; GFX10-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX10-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX10-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_div_fixup_f32 v0, v0, s7, s6
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_f32_ninf:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v0, null, s3, s3, s2
; GFX11-NEXT:    v_div_scale_f32 v2, vcc_lo, s2, s3, s2
; GFX11-NEXT:    v_rcp_f32_e32 v1, v0
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v1, v3, v1
; GFX11-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX11-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX11-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    v_div_fixup_f32 v0, v0, s3, s2
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_f32_ninf:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[2].W,
; EG-NEXT:     MUL_IEEE T0.X, KC0[2].Z, PS,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv ninf float %a, %b
  store float %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_f32_ieee(ptr addrspace(1) %out, float %a, float %b) #1 {
; GFX6-FASTFMA-LABEL: s_fdiv_f32_ieee:
; GFX6-FASTFMA:       ; %bb.0: ; %entry
; GFX6-FASTFMA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX6-FASTFMA-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-FASTFMA-NEXT:    s_mov_b32 s6, -1
; GFX6-FASTFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v1, s[4:5], s3, s3, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, vcc, s2, v3, s2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX6-FASTFMA-NEXT:    s_mov_b32 s4, s0
; GFX6-FASTFMA-NEXT:    s_mov_b32 s5, s1
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v1, s3, v0
; GFX6-FASTFMA-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-FASTFMA-NEXT:    s_endpgm
;
; GFX6-SLOWFMA-LABEL: s_fdiv_f32_ieee:
; GFX6-SLOWFMA:       ; %bb.0: ; %entry
; GFX6-SLOWFMA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s6, -1
; GFX6-SLOWFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, s[4:5], s3, s3, v0
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v2, s3
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, vcc, s2, v2, s2
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s4, s0
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s5, s1
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v3, v1
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v1, s3, v0
; GFX6-SLOWFMA-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-SLOWFMA-NEXT:    s_endpgm
;
; GFX7-LABEL: s_fdiv_f32_ieee:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_div_scale_f32 v1, s[4:5], s3, s3, v0
; GFX7-NEXT:    v_rcp_f32_e32 v2, v1
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    v_div_scale_f32 v3, vcc, s2, v3, s2
; GFX7-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX7-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX7-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX7-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX7-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX7-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX7-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX7-NEXT:    s_mov_b32 s4, s0
; GFX7-NEXT:    s_mov_b32 s5, s1
; GFX7-NEXT:    v_div_fixup_f32 v0, v1, s3, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_f32_ieee:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_div_scale_f32 v1, s[4:5], s3, s3, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, s2, v2, s2
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX8-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX8-NEXT:    v_div_fixup_f32 v2, v1, s3, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_f32_ieee:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v0, s0, s7, s7, s6
; GFX10-NEXT:    v_rcp_f32_e32 v1, v0
; GFX10-NEXT:    v_fma_f32 v2, -v0, v1, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v1, v2, v1
; GFX10-NEXT:    v_div_scale_f32 v2, vcc_lo, s6, s7, s6
; GFX10-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX10-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX10-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX10-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_div_fixup_f32 v0, v0, s7, s6
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_f32_ieee:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v0, null, s3, s3, s2
; GFX11-NEXT:    v_rcp_f32_e32 v1, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v2, -v0, v1, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v1, v2, v1
; GFX11-NEXT:    v_div_scale_f32 v2, vcc_lo, s2, s3, s2
; GFX11-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX11-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX11-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX11-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    v_div_fixup_f32 v0, v0, s3, s2
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_f32_ieee:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[2].W,
; EG-NEXT:     MUL_IEEE T0.X, KC0[2].Z, PS,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv float %a, %b
  store float %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_25ulp_f32(ptr addrspace(1) %out, float %a, float %b) #0 {
; GFX67-LABEL: s_fdiv_25ulp_f32:
; GFX67:       ; %bb.0: ; %entry
; GFX67-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX67-NEXT:    v_mov_b32_e32 v0, 0x6f800000
; GFX67-NEXT:    v_mov_b32_e32 v1, 0x2f800000
; GFX67-NEXT:    s_mov_b32 s7, 0xf000
; GFX67-NEXT:    s_mov_b32 s6, -1
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    v_cmp_gt_f32_e64 vcc, |s3|, v0
; GFX67-NEXT:    v_cndmask_b32_e32 v0, 1.0, v1, vcc
; GFX67-NEXT:    v_mul_f32_e32 v1, s3, v0
; GFX67-NEXT:    v_rcp_f32_e32 v1, v1
; GFX67-NEXT:    s_mov_b32 s4, s0
; GFX67-NEXT:    s_mov_b32 s5, s1
; GFX67-NEXT:    v_mul_f32_e32 v1, s2, v1
; GFX67-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX67-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_25ulp_f32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GFX8-NEXT:    v_mov_b32_e32 v0, 0x6f800000
; GFX8-NEXT:    v_mov_b32_e32 v1, 0x2f800000
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_gt_f32_e64 vcc, |s3|, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, 1.0, v1, vcc
; GFX8-NEXT:    v_mul_f32_e32 v1, s3, v0
; GFX8-NEXT:    v_rcp_f32_e32 v1, v1
; GFX8-NEXT:    v_mul_f32_e32 v1, s2, v1
; GFX8-NEXT:    v_mul_f32_e32 v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_25ulp_f32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |s7|
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 1.0, 0x2f800000, s0
; GFX10-NEXT:    v_mul_f32_e32 v1, s7, v0
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_mul_f32_e32 v1, s6, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    global_store_dword v2, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_25ulp_f32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |s3|
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 1.0, 0x2f800000, s4
; GFX11-NEXT:    v_mul_f32_e32 v1, s3, v0
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v1, s2, v1
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_25ulp_f32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[2].W,
; EG-NEXT:     MUL_IEEE T0.X, KC0[2].Z, PS,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv float %a, %b, !fpmath !0
  store float %fdiv, ptr addrspace(1) %out
  ret void
}

; Use correct fdiv
define amdgpu_kernel void @s_fdiv_25ulp_ieee_f32(ptr addrspace(1) %out, float %a, float %b) #1 {
; GFX6-LABEL: s_fdiv_25ulp_ieee_f32:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX6-NEXT:    v_mov_b32_e32 v0, 0x7f800000
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_frexp_mant_f32_e32 v1, s3
; GFX6-NEXT:    v_mov_b32_e32 v2, s3
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |s3|, v0
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v1, v1
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, s2
; GFX6-NEXT:    v_mov_b32_e32 v4, s2
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |s2|, v0
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v2, s3
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v4, v3, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v3, s2
; GFX6-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_sub_i32_e32 v1, vcc, v3, v2
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: s_fdiv_25ulp_ieee_f32:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, s3
; GFX7-NEXT:    v_rcp_f32_e32 v0, v0
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, s3
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v2, s2
; GFX7-NEXT:    v_frexp_mant_f32_e32 v3, s2
; GFX7-NEXT:    v_mul_f32_e32 v0, v3, v0
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v2, v1
; GFX7-NEXT:    s_mov_b32 s4, s0
; GFX7-NEXT:    s_mov_b32 s5, s1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_25ulp_ieee_f32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v1, s3
; GFX8-NEXT:    v_rcp_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v0, s3
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v2, s2
; GFX8-NEXT:    v_frexp_mant_f32_e32 v3, s2
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, v2, v0
; GFX8-NEXT:    v_mul_f32_e32 v1, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v2, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_25ulp_ieee_f32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v0, s7
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, s7
; GFX10-NEXT:    v_frexp_mant_f32_e32 v2, s6
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v3, s6
; GFX10-NEXT:    v_rcp_f32_e32 v0, v0
; GFX10-NEXT:    v_sub_nc_u32_e32 v1, v3, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX10-NEXT:    global_store_dword v2, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_25ulp_ieee_f32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v0, s3
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, s3
; GFX11-NEXT:    v_frexp_mant_f32_e32 v2, s2
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v3, s2
; GFX11-NEXT:    v_rcp_f32_e32 v0, v0
; GFX11-NEXT:    v_sub_nc_u32_e32 v1, v3, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX11-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_25ulp_ieee_f32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[2].W,
; EG-NEXT:     MUL_IEEE T0.X, KC0[2].Z, PS,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv float %a, %b, !fpmath !0
  store float %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_fast_ieee_f32(ptr addrspace(1) %out, float %a, float %b) #1 {
; GFX67-LABEL: s_fdiv_fast_ieee_f32:
; GFX67:       ; %bb.0: ; %entry
; GFX67-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX67-NEXT:    s_mov_b32 s7, 0xf000
; GFX67-NEXT:    s_mov_b32 s6, -1
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    v_rcp_f32_e32 v0, s3
; GFX67-NEXT:    s_mov_b32 s4, s0
; GFX67-NEXT:    s_mov_b32 s5, s1
; GFX67-NEXT:    v_mul_f32_e32 v0, s2, v0
; GFX67-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_fast_ieee_f32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f32_e32 v0, s3
; GFX8-NEXT:    v_mul_f32_e32 v2, s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_fast_ieee_f32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f32_e32 v0, s7
; GFX10-NEXT:    v_mul_f32_e32 v0, s6, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_fast_ieee_f32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_rcp_f32_e32 v0, s3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, s2, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_fast_ieee_f32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[2].W,
; EG-NEXT:     MUL_IEEE T0.X, PS, KC0[2].Z,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv fast float %a, %b
  store float %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_f32_fast_math(ptr addrspace(1) %out, float %a, float %b) #0 {
; GFX67-LABEL: s_fdiv_f32_fast_math:
; GFX67:       ; %bb.0: ; %entry
; GFX67-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX67-NEXT:    s_mov_b32 s7, 0xf000
; GFX67-NEXT:    s_mov_b32 s6, -1
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    v_rcp_f32_e32 v0, s3
; GFX67-NEXT:    s_mov_b32 s4, s0
; GFX67-NEXT:    s_mov_b32 s5, s1
; GFX67-NEXT:    v_mul_f32_e32 v0, s2, v0
; GFX67-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_f32_fast_math:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f32_e32 v0, s3
; GFX8-NEXT:    v_mul_f32_e32 v2, s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_f32_fast_math:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f32_e32 v0, s7
; GFX10-NEXT:    v_mul_f32_e32 v0, s6, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_f32_fast_math:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_rcp_f32_e32 v0, s3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, s2, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_f32_fast_math:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[2].W,
; EG-NEXT:     MUL_IEEE T0.X, PS, KC0[2].Z,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv fast float %a, %b
  store float %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_ulp25_f32_fast_math(ptr addrspace(1) %out, float %a, float %b) #0 {
; GFX67-LABEL: s_fdiv_ulp25_f32_fast_math:
; GFX67:       ; %bb.0: ; %entry
; GFX67-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX67-NEXT:    s_mov_b32 s7, 0xf000
; GFX67-NEXT:    s_mov_b32 s6, -1
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    v_rcp_f32_e32 v0, s3
; GFX67-NEXT:    s_mov_b32 s4, s0
; GFX67-NEXT:    s_mov_b32 s5, s1
; GFX67-NEXT:    v_mul_f32_e32 v0, s2, v0
; GFX67-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_ulp25_f32_fast_math:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f32_e32 v0, s3
; GFX8-NEXT:    v_mul_f32_e32 v2, s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_ulp25_f32_fast_math:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f32_e32 v0, s7
; GFX10-NEXT:    v_mul_f32_e32 v0, s6, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_ulp25_f32_fast_math:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_rcp_f32_e32 v0, s3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, s2, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_ulp25_f32_fast_math:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[2].W,
; EG-NEXT:     MUL_IEEE T0.X, PS, KC0[2].Z,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv fast float %a, %b, !fpmath !0
  store float %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_f32_arcp_daz(ptr addrspace(1) %out, float %a, float %b) #0 {
; GFX6-FASTFMA-LABEL: s_fdiv_f32_arcp_daz:
; GFX6-FASTFMA:       ; %bb.0: ; %entry
; GFX6-FASTFMA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX6-FASTFMA-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-FASTFMA-NEXT:    s_mov_b32 s6, -1
; GFX6-FASTFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v1, s2
; GFX6-FASTFMA-NEXT:    s_mov_b32 s4, s0
; GFX6-FASTFMA-NEXT:    s_mov_b32 s5, s1
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[0:1], s3, s3, v1
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v0, s3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v0, vcc, s2, v0, s2
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v4, v0, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v4, v0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v0, -v2, v4, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v0, v0, v3, v4
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v0, s3, v1
; GFX6-FASTFMA-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-FASTFMA-NEXT:    s_endpgm
;
; GFX6-SLOWFMA-LABEL: s_fdiv_f32_arcp_daz:
; GFX6-SLOWFMA:       ; %bb.0: ; %entry
; GFX6-SLOWFMA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s6, -1
; GFX6-SLOWFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, s[4:5], s3, s3, v0
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v2, s3
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, vcc, s2, v2, s2
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s4, s0
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s5, s1
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v3, v1
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v1, s3, v0
; GFX6-SLOWFMA-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-SLOWFMA-NEXT:    s_endpgm
;
; GFX7-LABEL: s_fdiv_f32_arcp_daz:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    s_mov_b32 s4, s0
; GFX7-NEXT:    s_mov_b32 s5, s1
; GFX7-NEXT:    v_div_scale_f32 v2, s[0:1], s3, s3, v1
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, s3
; GFX7-NEXT:    v_div_scale_f32 v0, vcc, s2, v0, s2
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v4, v0, v3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v4, v0
; GFX7-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX7-NEXT:    v_fma_f32 v0, -v2, v4, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v3, v4
; GFX7-NEXT:    v_div_fixup_f32 v0, v0, s3, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_f32_arcp_daz:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_div_scale_f32 v1, s[4:5], s3, s3, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, s2, v2, s2
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX8-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX8-NEXT:    v_div_fixup_f32 v2, v1, s3, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_f32_arcp_daz:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v0, s0, s7, s7, s6
; GFX10-NEXT:    v_div_scale_f32 v2, vcc_lo, s6, s7, s6
; GFX10-NEXT:    v_rcp_f32_e32 v1, v0
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v1, v3, v1
; GFX10-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX10-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX10-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_div_fixup_f32 v0, v0, s7, s6
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_f32_arcp_daz:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v0, null, s3, s3, s2
; GFX11-NEXT:    v_div_scale_f32 v2, vcc_lo, s2, s3, s2
; GFX11-NEXT:    v_rcp_f32_e32 v1, v0
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v1, v3, v1
; GFX11-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX11-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX11-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    v_div_fixup_f32 v0, v0, s3, s2
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_f32_arcp_daz:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[2].W,
; EG-NEXT:     MUL_IEEE T0.X, KC0[2].Z, PS,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv arcp float %a, %b
  store float %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_f32_arcp_ninf(ptr addrspace(1) %out, float %a, float %b) #0 {
; GFX67-LABEL: s_fdiv_f32_arcp_ninf:
; GFX67:       ; %bb.0: ; %entry
; GFX67-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; GFX67-NEXT:    s_mov_b32 s7, 0xf000
; GFX67-NEXT:    s_mov_b32 s6, -1
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    v_rcp_f32_e32 v0, s3
; GFX67-NEXT:    s_mov_b32 s4, s0
; GFX67-NEXT:    s_mov_b32 s5, s1
; GFX67-NEXT:    v_mul_f32_e32 v0, s2, v0
; GFX67-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_f32_arcp_ninf:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f32_e32 v0, s3
; GFX8-NEXT:    v_mul_f32_e32 v2, s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_f32_arcp_ninf:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f32_e32 v0, s7
; GFX10-NEXT:    v_mul_f32_e32 v0, s6, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_f32_arcp_ninf:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_rcp_f32_e32 v0, s3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, s2, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_f32_arcp_ninf:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[2].W,
; EG-NEXT:     MUL_IEEE T0.X, PS, KC0[2].Z,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv arcp ninf float %a, %b
  store float %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_v2f32(ptr addrspace(1) %out, <2 x float> %a, <2 x float> %b) #0 {
; GFX6-FASTFMA-LABEL: s_fdiv_v2f32:
; GFX6-FASTFMA:       ; %bb.0: ; %entry
; GFX6-FASTFMA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0xb
; GFX6-FASTFMA-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; GFX6-FASTFMA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-FASTFMA-NEXT:    s_mov_b32 s2, -1
; GFX6-FASTFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[8:9], s7, s7, v1
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v0, s7
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v0, vcc, s5, v0, s5
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v4, v0, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v4, v0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v0, -v2, v4, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v0, v0, v3, v4
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, s[8:9], s6, s6, v2
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v1, v0, s7, v1
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v0, vcc, s4, v0, s4
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v0, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v3, v5, v0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v0, -v3, v5, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v0, v0, v4, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v0, s6, v2
; GFX6-FASTFMA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-FASTFMA-NEXT:    s_endpgm
;
; GFX6-SLOWFMA-LABEL: s_fdiv_v2f32:
; GFX6-SLOWFMA:       ; %bb.0: ; %entry
; GFX6-SLOWFMA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0xb
; GFX6-SLOWFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, s[0:1], s7, s7, v0
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v2, s7
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, vcc, s5, v2, s5
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v4, s4
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v3, v1
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v1, v3, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v1, v5, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, -v1, v5, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[0:1], s6, s6, v4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v1, v1, v3, v5
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v3, s6
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, s4, v3, s4
; GFX6-SLOWFMA-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s2, -1
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v5, v2
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v1, v1, s7, v0
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v0, -v2, v5, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v0, v0, v5, v5
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v0, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v0, v2, v0, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v0, s6, v4
; GFX6-SLOWFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-SLOWFMA-NEXT:    s_endpgm
;
; GFX7-LABEL: s_fdiv_v2f32:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0xb
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_div_scale_f32 v2, s[8:9], s7, s7, v1
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, s7
; GFX7-NEXT:    v_div_scale_f32 v0, vcc, s5, v0, s5
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v4, v0, v3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v4, v0
; GFX7-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX7-NEXT:    v_fma_f32 v0, -v2, v4, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v3, v4
; GFX7-NEXT:    v_div_scale_f32 v3, s[8:9], s6, s6, v2
; GFX7-NEXT:    v_rcp_f32_e32 v4, v3
; GFX7-NEXT:    v_div_fixup_f32 v1, v0, s7, v1
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_div_scale_f32 v0, vcc, s4, v0, s4
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX7-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX7-NEXT:    v_mul_f32_e32 v5, v0, v4
; GFX7-NEXT:    v_fma_f32 v6, -v3, v5, v0
; GFX7-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX7-NEXT:    v_fma_f32 v0, -v3, v5, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v4, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v0, s6, v2
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_v2f32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s5
; GFX8-NEXT:    v_div_scale_f32 v1, s[0:1], s7, s7, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, s5, v2, s5
; GFX8-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v5, v2, v3
; GFX8-NEXT:    v_fma_f32 v6, -v1, v5, v2
; GFX8-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX8-NEXT:    v_fma_f32 v1, -v1, v5, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_scale_f32 v2, s[0:1], s6, s6, v4
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v5
; GFX8-NEXT:    v_mov_b32_e32 v3, s6
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, s4, v3, s4
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX8-NEXT:    v_rcp_f32_e32 v5, v2
; GFX8-NEXT:    v_div_fixup_f32 v1, v1, s7, v0
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v0, -v2, v5, 1.0
; GFX8-NEXT:    v_fma_f32 v0, v0, v5, v5
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v0
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v0, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v0, v2, v0, v5
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    v_div_fixup_f32 v0, v0, s6, v4
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_v2f32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v0, s0, s7, s7, s5
; GFX10-NEXT:    v_div_scale_f32 v2, vcc_lo, s5, s7, s5
; GFX10-NEXT:    v_rcp_f32_e32 v1, v0
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v1, v3, v1
; GFX10-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX10-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX10-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_scale_f32 v2, s0, s6, s6, s4
; GFX10-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    v_div_fixup_f32 v1, v0, s7, s5
; GFX10-NEXT:    v_div_scale_f32 v0, vcc_lo, s4, s6, s4
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX10-NEXT:    v_mul_f32_e32 v4, v0, v3
; GFX10-NEXT:    v_fma_f32 v5, -v2, v4, v0
; GFX10-NEXT:    v_fmac_f32_e32 v4, v5, v3
; GFX10-NEXT:    v_fma_f32 v0, -v2, v4, v0
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_div_fmas_f32 v0, v0, v3, v4
; GFX10-NEXT:    v_div_fixup_f32 v0, v0, s6, s4
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_v2f32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v0, null, s7, s7, s5
; GFX11-NEXT:    v_div_scale_f32 v2, vcc_lo, s5, s7, s5
; GFX11-NEXT:    v_rcp_f32_e32 v1, v0
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v1, v3, v1
; GFX11-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX11-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX11-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_scale_f32 v2, null, s6, s6, s4
; GFX11-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    v_div_fixup_f32 v1, v0, s7, s5
; GFX11-NEXT:    v_div_scale_f32 v0, vcc_lo, s4, s6, s4
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX11-NEXT:    v_mul_f32_e32 v4, v0, v3
; GFX11-NEXT:    v_fma_f32 v5, -v2, v4, v0
; GFX11-NEXT:    v_fmac_f32_e32 v4, v5, v3
; GFX11-NEXT:    v_fma_f32 v0, -v2, v4, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v0, v0, v3, v4
; GFX11-NEXT:    v_div_fixup_f32 v0, v0, s6, s4
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_v2f32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 5, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[3].Z,
; EG-NEXT:     MUL_IEEE T0.Y, KC0[3].X, PS,
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[3].Y,
; EG-NEXT:     MUL_IEEE T0.X, KC0[2].W, PS,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv <2 x float> %a, %b
  store <2 x float> %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_ulp25_v2f32(ptr addrspace(1) %out, <2 x float> %a, <2 x float> %b) #0 {
; GFX67-LABEL: s_fdiv_ulp25_v2f32:
; GFX67:       ; %bb.0: ; %entry
; GFX67-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0xb
; GFX67-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; GFX67-NEXT:    s_mov_b32 s3, 0xf000
; GFX67-NEXT:    s_mov_b32 s2, -1
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    v_rcp_f32_e32 v0, s6
; GFX67-NEXT:    v_rcp_f32_e32 v1, s7
; GFX67-NEXT:    v_mul_f32_e32 v0, s4, v0
; GFX67-NEXT:    v_mul_f32_e32 v1, s5, v1
; GFX67-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_ulp25_v2f32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f32_e32 v0, s6
; GFX8-NEXT:    v_rcp_f32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    v_mul_f32_e32 v0, s4, v0
; GFX8-NEXT:    v_mul_f32_e32 v1, s5, v1
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_ulp25_v2f32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f32_e32 v0, s6
; GFX10-NEXT:    v_rcp_f32_e32 v1, s7
; GFX10-NEXT:    v_mul_f32_e32 v0, s4, v0
; GFX10-NEXT:    v_mul_f32_e32 v1, s5, v1
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_ulp25_v2f32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_rcp_f32_e32 v0, s6
; GFX11-NEXT:    v_rcp_f32_e32 v1, s7
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mul_f32 v0, s4, v0 :: v_dual_mul_f32 v1, s5, v1
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_ulp25_v2f32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 5, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[3].Z,
; EG-NEXT:     MUL_IEEE T0.Y, KC0[3].X, PS,
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[3].Y,
; EG-NEXT:     MUL_IEEE T0.X, KC0[2].W, PS,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv arcp <2 x float> %a, %b, !fpmath !0
  store <2 x float> %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_v2f32_fast_math(ptr addrspace(1) %out, <2 x float> %a, <2 x float> %b) #0 {
; GFX67-LABEL: s_fdiv_v2f32_fast_math:
; GFX67:       ; %bb.0: ; %entry
; GFX67-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0xb
; GFX67-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; GFX67-NEXT:    s_mov_b32 s3, 0xf000
; GFX67-NEXT:    s_mov_b32 s2, -1
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    v_rcp_f32_e32 v0, s7
; GFX67-NEXT:    v_rcp_f32_e32 v2, s6
; GFX67-NEXT:    v_mul_f32_e32 v1, s5, v0
; GFX67-NEXT:    v_mul_f32_e32 v0, s4, v2
; GFX67-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_v2f32_fast_math:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f32_e32 v0, s7
; GFX8-NEXT:    v_rcp_f32_e32 v2, s6
; GFX8-NEXT:    v_mul_f32_e32 v1, s5, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, s4, v2
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_v2f32_fast_math:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f32_e32 v0, s7
; GFX10-NEXT:    v_rcp_f32_e32 v2, s6
; GFX10-NEXT:    v_mul_f32_e32 v1, s5, v0
; GFX10-NEXT:    v_mul_f32_e32 v0, s4, v2
; GFX10-NEXT:    global_store_dwordx2 v3, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_v2f32_fast_math:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_rcp_f32_e32 v0, s7
; GFX11-NEXT:    v_rcp_f32_e32 v2, s6
; GFX11-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mul_f32 v1, s5, v0 :: v_dual_mul_f32 v0, s4, v2
; GFX11-NEXT:    global_store_b64 v3, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_v2f32_fast_math:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 5, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[3].Z,
; EG-NEXT:     MUL_IEEE T0.Y, PS, KC0[3].X,
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[3].Y,
; EG-NEXT:     MUL_IEEE T0.X, PS, KC0[2].W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv fast <2 x float> %a, %b
  store <2 x float> %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_v2f32_arcp_math(ptr addrspace(1) %out, <2 x float> %a, <2 x float> %b) #0 {
; GFX67-LABEL: s_fdiv_v2f32_arcp_math:
; GFX67:       ; %bb.0: ; %entry
; GFX67-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0xb
; GFX67-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; GFX67-NEXT:    s_mov_b32 s3, 0xf000
; GFX67-NEXT:    s_mov_b32 s2, -1
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    v_rcp_f32_e32 v0, s7
; GFX67-NEXT:    v_rcp_f32_e32 v2, s6
; GFX67-NEXT:    v_mul_f32_e32 v1, s5, v0
; GFX67-NEXT:    v_mul_f32_e32 v0, s4, v2
; GFX67-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_v2f32_arcp_math:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f32_e32 v0, s7
; GFX8-NEXT:    v_rcp_f32_e32 v2, s6
; GFX8-NEXT:    v_mul_f32_e32 v1, s5, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, s4, v2
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_v2f32_arcp_math:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f32_e32 v0, s7
; GFX10-NEXT:    v_rcp_f32_e32 v2, s6
; GFX10-NEXT:    v_mul_f32_e32 v1, s5, v0
; GFX10-NEXT:    v_mul_f32_e32 v0, s4, v2
; GFX10-NEXT:    global_store_dwordx2 v3, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_v2f32_arcp_math:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_rcp_f32_e32 v0, s7
; GFX11-NEXT:    v_rcp_f32_e32 v2, s6
; GFX11-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mul_f32 v1, s5, v0 :: v_dual_mul_f32 v0, s4, v2
; GFX11-NEXT:    global_store_b64 v3, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_v2f32_arcp_math:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 5, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[3].Z,
; EG-NEXT:     MUL_IEEE T0.Y, PS, KC0[3].X,
; EG-NEXT:     RECIP_IEEE * T0.X, KC0[3].Y,
; EG-NEXT:     MUL_IEEE T0.X, PS, KC0[2].W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv arcp ninf <2 x float> %a, %b
  store <2 x float> %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_v4f32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX6-FASTFMA-LABEL: s_fdiv_v4f32:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x9
; GFX6-FASTFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX6-FASTFMA-NEXT:    s_mov_b32 s11, 0xf000
; GFX6-FASTFMA-NEXT:    s_mov_b32 s10, -1
; GFX6-FASTFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[12:13], s7, s7, v1
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v0, s7
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v0, vcc, s3, v0, s3
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v4, v0, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v4, v0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v0, -v2, v4, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v0, v0, v3, v4
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v3, v0, s7, v1
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v1, s2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[12:13], s6, s6, v1
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v0, vcc, s2, v0, s2
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v0, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v0, -v2, v5, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v0, v0, v4, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v2, v0, s6, v1
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, s[2:3], s5, s5, v1
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v5, v4
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v0, vcc, s1, v0, s1
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v4, v5, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v6, v0, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v7, -v4, v6, v0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX6-FASTFMA-NEXT:    v_fma_f32 v0, -v4, v6, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v4, s0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v0, v0, v5, v6
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v5, s[2:3], s4, s4, v4
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v6, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v1, v0, s5, v1
; GFX6-FASTFMA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v0, vcc, s0, v0, s0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v7, -v5, v6, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, v7, v6, v6
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v7, v0, v6
; GFX6-FASTFMA-NEXT:    v_fma_f32 v8, -v5, v7, v0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v7, v8, v6, v7
; GFX6-FASTFMA-NEXT:    v_fma_f32 v0, -v5, v7, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v0, v0, v6, v7
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v0, s4, v4
; GFX6-FASTFMA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX6-FASTFMA-NEXT:    s_endpgm
;
; GFX6-SLOWFMA-LABEL: s_fdiv_v4f32:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x9
; GFX6-SLOWFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX6-SLOWFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v0, s3
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, s[10:11], s7, s7, v0
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v2, s7
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, vcc, s3, v2, s3
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v4, s2
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v7, s1
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v8, s0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v3, v1
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v1, v3, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v1, v5, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, -v1, v5, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[10:11], s6, s6, v4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v1, v1, v3, v5
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v3, s6
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v5, vcc, s2, v3, s2
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s11, 0xf000
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s10, -1
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v6, v2
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v3, v1, s7, v0
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v0, -v2, v6, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v0, v0, v6, v6
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v1, v5, v0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v1, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, v6, v0, v1
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v1, v5
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v5, s[2:3], s5, s5, v7
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v0, v2, v0, v1
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, vcc, s1, v1, s1
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v6, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v2, v0, s6, v4
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v0, -v5, v6, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v0, v0, v6, v6
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v4, v1, v0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v5, v4, v1
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v6, v0, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, -v5, v4, v1
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v5, s[2:3], s4, s4, v8
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v0, v1, v0, v4
; GFX6-SLOWFMA-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v4, vcc, s0, v1, s0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v6, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v1, v0, s5, v7
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v0, -v5, v6, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v0, v0, v6, v6
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v6, v4, v0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v7, -v5, v6, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, v7, v0, v6
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, -v5, v6, v4
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v0, v4, v0, v6
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v0, s4, v8
; GFX6-SLOWFMA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX6-SLOWFMA-NEXT:    s_endpgm
;
; GFX7-LABEL: s_fdiv_v4f32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_div_scale_f32 v2, s[12:13], s7, s7, v1
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, s7
; GFX7-NEXT:    v_div_scale_f32 v0, vcc, s3, v0, s3
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v4, v0, v3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v4, v0
; GFX7-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX7-NEXT:    v_fma_f32 v0, -v2, v4, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v3, v4
; GFX7-NEXT:    v_div_fixup_f32 v3, v0, s7, v1
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    v_div_scale_f32 v2, s[12:13], s6, s6, v1
; GFX7-NEXT:    v_rcp_f32_e32 v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_div_scale_f32 v0, vcc, s2, v0, s2
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX7-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX7-NEXT:    v_mul_f32_e32 v5, v0, v4
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v0
; GFX7-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX7-NEXT:    v_fma_f32 v0, -v2, v5, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v4, v5
; GFX7-NEXT:    v_div_fixup_f32 v2, v0, s6, v1
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_div_scale_f32 v4, s[2:3], s5, s5, v1
; GFX7-NEXT:    v_rcp_f32_e32 v5, v4
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_div_scale_f32 v0, vcc, s1, v0, s1
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v6, -v4, v5, 1.0
; GFX7-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX7-NEXT:    v_mul_f32_e32 v6, v0, v5
; GFX7-NEXT:    v_fma_f32 v7, -v4, v6, v0
; GFX7-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX7-NEXT:    v_fma_f32 v0, -v4, v6, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v5, v6
; GFX7-NEXT:    v_div_scale_f32 v5, s[2:3], s4, s4, v4
; GFX7-NEXT:    v_rcp_f32_e32 v6, v5
; GFX7-NEXT:    v_div_fixup_f32 v1, v0, s5, v1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_div_scale_f32 v0, vcc, s0, v0, s0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v7, -v5, v6, 1.0
; GFX7-NEXT:    v_fma_f32 v6, v7, v6, v6
; GFX7-NEXT:    v_mul_f32_e32 v7, v0, v6
; GFX7-NEXT:    v_fma_f32 v8, -v5, v7, v0
; GFX7-NEXT:    v_fma_f32 v7, v8, v6, v7
; GFX7-NEXT:    v_fma_f32 v0, -v5, v7, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v6, v7
; GFX7-NEXT:    v_div_fixup_f32 v0, v0, s4, v4
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_v4f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s3
; GFX8-NEXT:    v_div_scale_f32 v1, s[10:11], s7, s7, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, s3, v2, s3
; GFX8-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NEXT:    v_mov_b32_e32 v7, s1
; GFX8-NEXT:    v_mov_b32_e32 v8, s0
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v5, v2, v3
; GFX8-NEXT:    v_fma_f32 v6, -v1, v5, v2
; GFX8-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX8-NEXT:    v_fma_f32 v1, -v1, v5, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_scale_f32 v2, s[10:11], s6, s6, v4
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v5
; GFX8-NEXT:    v_mov_b32_e32 v3, s6
; GFX8-NEXT:    v_div_scale_f32 v5, vcc, s2, v3, s2
; GFX8-NEXT:    v_rcp_f32_e32 v6, v2
; GFX8-NEXT:    v_div_fixup_f32 v3, v1, s7, v0
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v0, -v2, v6, 1.0
; GFX8-NEXT:    v_fma_f32 v0, v0, v6, v6
; GFX8-NEXT:    v_mul_f32_e32 v1, v5, v0
; GFX8-NEXT:    v_fma_f32 v6, -v2, v1, v5
; GFX8-NEXT:    v_fma_f32 v1, v6, v0, v1
; GFX8-NEXT:    v_fma_f32 v2, -v2, v1, v5
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_scale_f32 v5, s[2:3], s5, s5, v7
; GFX8-NEXT:    v_div_fmas_f32 v0, v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_div_scale_f32 v1, vcc, s1, v1, s1
; GFX8-NEXT:    v_rcp_f32_e32 v6, v5
; GFX8-NEXT:    v_div_fixup_f32 v2, v0, s6, v4
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v0, -v5, v6, 1.0
; GFX8-NEXT:    v_fma_f32 v0, v0, v6, v6
; GFX8-NEXT:    v_mul_f32_e32 v4, v1, v0
; GFX8-NEXT:    v_fma_f32 v6, -v5, v4, v1
; GFX8-NEXT:    v_fma_f32 v4, v6, v0, v4
; GFX8-NEXT:    v_fma_f32 v1, -v5, v4, v1
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_scale_f32 v5, s[2:3], s4, s4, v8
; GFX8-NEXT:    v_div_fmas_f32 v0, v1, v0, v4
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    v_div_scale_f32 v4, vcc, s0, v1, s0
; GFX8-NEXT:    v_rcp_f32_e32 v6, v5
; GFX8-NEXT:    v_div_fixup_f32 v1, v0, s5, v7
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v0, -v5, v6, 1.0
; GFX8-NEXT:    v_fma_f32 v0, v0, v6, v6
; GFX8-NEXT:    v_mul_f32_e32 v6, v4, v0
; GFX8-NEXT:    v_fma_f32 v7, -v5, v6, v4
; GFX8-NEXT:    v_fma_f32 v6, v7, v0, v6
; GFX8-NEXT:    v_fma_f32 v4, -v5, v6, v4
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v0, v4, v0, v6
; GFX8-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NEXT:    v_div_fixup_f32 v0, v0, s4, v8
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_v4f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v0, s10, s7, s7, s3
; GFX10-NEXT:    v_div_scale_f32 v2, vcc_lo, s3, s7, s3
; GFX10-NEXT:    v_rcp_f32_e32 v1, v0
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v1, v3, v1
; GFX10-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX10-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX10-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_scale_f32 v2, s10, s6, s6, s2
; GFX10-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX10-NEXT:    v_div_scale_f32 v1, vcc_lo, s2, s6, s2
; GFX10-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-NEXT:    v_div_fixup_f32 v3, v0, s7, s3
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v0, -v2, v4, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v4, v0, v4
; GFX10-NEXT:    v_mul_f32_e32 v0, v1, v4
; GFX10-NEXT:    v_fma_f32 v5, -v2, v0, v1
; GFX10-NEXT:    v_fmac_f32_e32 v0, v5, v4
; GFX10-NEXT:    v_fma_f32 v1, -v2, v0, v1
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_scale_f32 v5, s3, s5, s5, s1
; GFX10-NEXT:    v_div_fmas_f32 v0, v1, v4, v0
; GFX10-NEXT:    v_div_scale_f32 v1, vcc_lo, s1, s5, s1
; GFX10-NEXT:    v_rcp_f32_e32 v6, v5
; GFX10-NEXT:    v_div_fixup_f32 v2, v0, s6, s2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v0, -v5, v6, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v6, v0, v6
; GFX10-NEXT:    v_mul_f32_e32 v0, v1, v6
; GFX10-NEXT:    v_fma_f32 v4, -v5, v0, v1
; GFX10-NEXT:    v_fmac_f32_e32 v0, v4, v6
; GFX10-NEXT:    v_fma_f32 v1, -v5, v0, v1
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_scale_f32 v4, s2, s4, s4, s0
; GFX10-NEXT:    v_div_fmas_f32 v0, v1, v6, v0
; GFX10-NEXT:    v_rcp_f32_e32 v5, v4
; GFX10-NEXT:    v_div_fixup_f32 v1, v0, s5, s1
; GFX10-NEXT:    v_div_scale_f32 v0, vcc_lo, s0, s4, s0
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v6, -v4, v5, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v5
; GFX10-NEXT:    v_mul_f32_e32 v6, v0, v5
; GFX10-NEXT:    v_fma_f32 v7, -v4, v6, v0
; GFX10-NEXT:    v_fmac_f32_e32 v6, v7, v5
; GFX10-NEXT:    v_fma_f32 v0, -v4, v6, v0
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_div_fmas_f32 v0, v0, v5, v6
; GFX10-NEXT:    v_div_fixup_f32 v0, v0, s4, s0
; GFX10-NEXT:    global_store_dwordx4 v4, v[0:3], s[8:9]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_v4f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[8:11], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b256 s[0:7], s[10:11], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v0, null, s7, s7, s3
; GFX11-NEXT:    v_div_scale_f32 v2, vcc_lo, s3, s7, s3
; GFX11-NEXT:    v_rcp_f32_e32 v1, v0
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v1, v3, v1
; GFX11-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX11-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX11-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_scale_f32 v2, null, s6, s6, s2
; GFX11-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX11-NEXT:    v_div_scale_f32 v1, vcc_lo, s2, s6, s2
; GFX11-NEXT:    v_rcp_f32_e32 v4, v2
; GFX11-NEXT:    v_div_fixup_f32 v3, v0, s7, s3
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v0, -v2, v4, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v4, v0, v4
; GFX11-NEXT:    v_mul_f32_e32 v0, v1, v4
; GFX11-NEXT:    v_fma_f32 v5, -v2, v0, v1
; GFX11-NEXT:    v_fmac_f32_e32 v0, v5, v4
; GFX11-NEXT:    v_fma_f32 v1, -v2, v0, v1
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_scale_f32 v5, null, s5, s5, s1
; GFX11-NEXT:    v_div_fmas_f32 v0, v1, v4, v0
; GFX11-NEXT:    v_div_scale_f32 v1, vcc_lo, s1, s5, s1
; GFX11-NEXT:    v_rcp_f32_e32 v6, v5
; GFX11-NEXT:    v_div_fixup_f32 v2, v0, s6, s2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v0, -v5, v6, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v6, v0, v6
; GFX11-NEXT:    v_mul_f32_e32 v0, v1, v6
; GFX11-NEXT:    v_fma_f32 v4, -v5, v0, v1
; GFX11-NEXT:    v_fmac_f32_e32 v0, v4, v6
; GFX11-NEXT:    v_fma_f32 v1, -v5, v0, v1
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_scale_f32 v4, null, s4, s4, s0
; GFX11-NEXT:    v_div_fmas_f32 v0, v1, v6, v0
; GFX11-NEXT:    v_rcp_f32_e32 v5, v4
; GFX11-NEXT:    v_div_fixup_f32 v1, v0, s5, s1
; GFX11-NEXT:    v_div_scale_f32 v0, vcc_lo, s0, s4, s0
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v6, -v4, v5, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v5
; GFX11-NEXT:    v_mul_f32_e32 v6, v0, v5
; GFX11-NEXT:    v_fma_f32 v7, -v4, v6, v0
; GFX11-NEXT:    v_fmac_f32_e32 v6, v7, v5
; GFX11-NEXT:    v_fma_f32 v0, -v4, v6, v0
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    v_div_fmas_f32 v0, v0, v5, v6
; GFX11-NEXT:    v_div_fixup_f32 v0, v0, s4, s0
; GFX11-NEXT:    global_store_b128 v4, v[0:3], s[8:9]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_v4f32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 9, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     RECIP_IEEE * T1.W, T1.W,
; EG-NEXT:     MUL_IEEE T0.W, T0.W, PS,
; EG-NEXT:     RECIP_IEEE * T1.Z, T1.Z,
; EG-NEXT:     MUL_IEEE T0.Z, T0.Z, PS,
; EG-NEXT:     RECIP_IEEE * T1.Y, T1.Y,
; EG-NEXT:     MUL_IEEE T0.Y, T0.Y, PS,
; EG-NEXT:     RECIP_IEEE * T1.X, T1.X,
; EG-NEXT:     MUL_IEEE T0.X, T0.X, PS,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <4 x float>, ptr addrspace(1) %in, i32 1
  %a = load <4 x float>, ptr addrspace(1) %in
  %b = load <4 x float>, ptr addrspace(1) %b_ptr
  %result = fdiv <4 x float> %a, %b
  store <4 x float> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_v4f32_fast_math(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX67-LABEL: s_fdiv_v4f32_fast_math:
; GFX67:       ; %bb.0:
; GFX67-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x9
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX67-NEXT:    s_mov_b32 s11, 0xf000
; GFX67-NEXT:    s_mov_b32 s10, -1
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    v_rcp_f32_e32 v0, s7
; GFX67-NEXT:    v_rcp_f32_e32 v1, s6
; GFX67-NEXT:    v_rcp_f32_e32 v4, s5
; GFX67-NEXT:    v_rcp_f32_e32 v5, s4
; GFX67-NEXT:    v_mul_f32_e32 v3, s3, v0
; GFX67-NEXT:    v_mul_f32_e32 v2, s2, v1
; GFX67-NEXT:    v_mul_f32_e32 v1, s1, v4
; GFX67-NEXT:    v_mul_f32_e32 v0, s0, v5
; GFX67-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_v4f32_fast_math:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f32_e32 v0, s7
; GFX8-NEXT:    v_rcp_f32_e32 v1, s6
; GFX8-NEXT:    v_rcp_f32_e32 v6, s5
; GFX8-NEXT:    v_rcp_f32_e32 v7, s4
; GFX8-NEXT:    v_mul_f32_e32 v3, s3, v0
; GFX8-NEXT:    v_mul_f32_e32 v2, s2, v1
; GFX8-NEXT:    v_mul_f32_e32 v1, s1, v6
; GFX8-NEXT:    v_mul_f32_e32 v0, s0, v7
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_v4f32_fast_math:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v6, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f32_e32 v0, s7
; GFX10-NEXT:    v_rcp_f32_e32 v1, s6
; GFX10-NEXT:    v_rcp_f32_e32 v4, s5
; GFX10-NEXT:    v_rcp_f32_e32 v5, s4
; GFX10-NEXT:    v_mul_f32_e32 v3, s3, v0
; GFX10-NEXT:    v_mul_f32_e32 v2, s2, v1
; GFX10-NEXT:    v_mul_f32_e32 v1, s1, v4
; GFX10-NEXT:    v_mul_f32_e32 v0, s0, v5
; GFX10-NEXT:    global_store_dwordx4 v6, v[0:3], s[8:9]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_v4f32_fast_math:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[8:11], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b256 s[0:7], s[10:11], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_rcp_f32_e32 v0, s7
; GFX11-NEXT:    v_rcp_f32_e32 v1, s6
; GFX11-NEXT:    v_rcp_f32_e32 v4, s5
; GFX11-NEXT:    v_rcp_f32_e32 v5, s4
; GFX11-NEXT:    v_dual_mov_b32 v6, 0 :: v_dual_mul_f32 v3, s3, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mul_f32 v2, s2, v1 :: v_dual_mul_f32 v1, s1, v4
; GFX11-NEXT:    v_mul_f32_e32 v0, s0, v5
; GFX11-NEXT:    global_store_b128 v6, v[0:3], s[8:9]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_v4f32_fast_math:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 9, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     RECIP_IEEE * T1.W, T1.W,
; EG-NEXT:     MUL_IEEE T0.W, PS, T0.W,
; EG-NEXT:     RECIP_IEEE * T1.Z, T1.Z,
; EG-NEXT:     MUL_IEEE T0.Z, PS, T0.Z,
; EG-NEXT:     RECIP_IEEE * T1.Y, T1.Y,
; EG-NEXT:     MUL_IEEE T0.Y, PS, T0.Y,
; EG-NEXT:     RECIP_IEEE * T1.X, T1.X,
; EG-NEXT:     MUL_IEEE T0.X, PS, T0.X,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <4 x float>, ptr addrspace(1) %in, i32 1
  %a = load <4 x float>, ptr addrspace(1) %in
  %b = load <4 x float>, ptr addrspace(1) %b_ptr
  %result = fdiv fast <4 x float> %a, %b
  store <4 x float> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_v4f32_arcp_math(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX67-LABEL: s_fdiv_v4f32_arcp_math:
; GFX67:       ; %bb.0:
; GFX67-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x9
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX67-NEXT:    s_mov_b32 s11, 0xf000
; GFX67-NEXT:    s_mov_b32 s10, -1
; GFX67-NEXT:    s_waitcnt lgkmcnt(0)
; GFX67-NEXT:    v_rcp_f32_e32 v0, s7
; GFX67-NEXT:    v_rcp_f32_e32 v1, s6
; GFX67-NEXT:    v_rcp_f32_e32 v4, s5
; GFX67-NEXT:    v_rcp_f32_e32 v5, s4
; GFX67-NEXT:    v_mul_f32_e32 v3, s3, v0
; GFX67-NEXT:    v_mul_f32_e32 v2, s2, v1
; GFX67-NEXT:    v_mul_f32_e32 v1, s1, v4
; GFX67-NEXT:    v_mul_f32_e32 v0, s0, v5
; GFX67-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_v4f32_arcp_math:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f32_e32 v0, s7
; GFX8-NEXT:    v_rcp_f32_e32 v1, s6
; GFX8-NEXT:    v_rcp_f32_e32 v6, s5
; GFX8-NEXT:    v_rcp_f32_e32 v7, s4
; GFX8-NEXT:    v_mul_f32_e32 v3, s3, v0
; GFX8-NEXT:    v_mul_f32_e32 v2, s2, v1
; GFX8-NEXT:    v_mul_f32_e32 v1, s1, v6
; GFX8-NEXT:    v_mul_f32_e32 v0, s0, v7
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_v4f32_arcp_math:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v6, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f32_e32 v0, s7
; GFX10-NEXT:    v_rcp_f32_e32 v1, s6
; GFX10-NEXT:    v_rcp_f32_e32 v4, s5
; GFX10-NEXT:    v_rcp_f32_e32 v5, s4
; GFX10-NEXT:    v_mul_f32_e32 v3, s3, v0
; GFX10-NEXT:    v_mul_f32_e32 v2, s2, v1
; GFX10-NEXT:    v_mul_f32_e32 v1, s1, v4
; GFX10-NEXT:    v_mul_f32_e32 v0, s0, v5
; GFX10-NEXT:    global_store_dwordx4 v6, v[0:3], s[8:9]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_v4f32_arcp_math:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[8:11], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b256 s[0:7], s[10:11], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_rcp_f32_e32 v0, s7
; GFX11-NEXT:    v_rcp_f32_e32 v1, s6
; GFX11-NEXT:    v_rcp_f32_e32 v4, s5
; GFX11-NEXT:    v_rcp_f32_e32 v5, s4
; GFX11-NEXT:    v_dual_mov_b32 v6, 0 :: v_dual_mul_f32 v3, s3, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mul_f32 v2, s2, v1 :: v_dual_mul_f32 v1, s1, v4
; GFX11-NEXT:    v_mul_f32_e32 v0, s0, v5
; GFX11-NEXT:    global_store_b128 v6, v[0:3], s[8:9]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_v4f32_arcp_math:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 9, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     RECIP_IEEE * T1.W, T1.W,
; EG-NEXT:     MUL_IEEE T0.W, PS, T0.W,
; EG-NEXT:     RECIP_IEEE * T1.Z, T1.Z,
; EG-NEXT:     MUL_IEEE T0.Z, PS, T0.Z,
; EG-NEXT:     RECIP_IEEE * T1.Y, T1.Y,
; EG-NEXT:     MUL_IEEE T0.Y, PS, T0.Y,
; EG-NEXT:     RECIP_IEEE * T1.X, T1.X,
; EG-NEXT:     MUL_IEEE T0.X, PS, T0.X,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <4 x float>, ptr addrspace(1) %in, i32 1
  %a = load <4 x float>, ptr addrspace(1) %in
  %b = load <4 x float>, ptr addrspace(1) %b_ptr
  %result = fdiv arcp ninf <4 x float> %a, %b
  store <4 x float> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_f32_correctly_rounded_divide_sqrt(ptr addrspace(1) %out, float %a) #0 {
; GFX6-FASTFMA-LABEL: s_fdiv_f32_correctly_rounded_divide_sqrt:
; GFX6-FASTFMA:       ; %bb.0: ; %entry
; GFX6-FASTFMA-NEXT:    s_load_dword s6, s[2:3], 0xb
; GFX6-FASTFMA-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; GFX6-FASTFMA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-FASTFMA-NEXT:    s_mov_b32 s2, -1
; GFX6-FASTFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v0, s[4:5], s6, s6, 1.0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v1, v0
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, vcc, 1.0, s6, 1.0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v1, v3, v1, v1
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v4, v1, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v0, s6, 1.0
; GFX6-FASTFMA-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-FASTFMA-NEXT:    s_endpgm
;
; GFX6-SLOWFMA-LABEL: s_fdiv_f32_correctly_rounded_divide_sqrt:
; GFX6-SLOWFMA:       ; %bb.0: ; %entry
; GFX6-SLOWFMA-NEXT:    s_load_dword s4, s[2:3], 0xb
; GFX6-SLOWFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v0, s[0:1], s4, s4, 1.0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, vcc, 1.0, s4, 1.0
; GFX6-SLOWFMA-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s2, -1
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v2, v0
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, -v0, v2, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, v3, v2, v2
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v3, v1, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, -v0, v3, v1
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v4, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v0, -v0, v3, v1
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v0, v0, v2, v3
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v0, s4, 1.0
; GFX6-SLOWFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-SLOWFMA-NEXT:    s_endpgm
;
; GFX7-LABEL: s_fdiv_f32_correctly_rounded_divide_sqrt:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s6, s[2:3], 0xb
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v0, s[4:5], s6, s6, 1.0
; GFX7-NEXT:    v_rcp_f32_e32 v1, v0
; GFX7-NEXT:    v_div_scale_f32 v2, vcc, 1.0, s6, 1.0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX7-NEXT:    v_fma_f32 v1, v3, v1, v1
; GFX7-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX7-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX7-NEXT:    v_fma_f32 v3, v4, v1, v3
; GFX7-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX7-NEXT:    v_div_fixup_f32 v0, v0, s6, 1.0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_f32_correctly_rounded_divide_sqrt:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v0, s[0:1], s4, s4, 1.0
; GFX8-NEXT:    v_div_scale_f32 v1, vcc, 1.0, s4, 1.0
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX8-NEXT:    v_rcp_f32_e32 v2, v0
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v3, -v0, v2, 1.0
; GFX8-NEXT:    v_fma_f32 v2, v3, v2, v2
; GFX8-NEXT:    v_mul_f32_e32 v3, v1, v2
; GFX8-NEXT:    v_fma_f32 v4, -v0, v3, v1
; GFX8-NEXT:    v_fma_f32 v3, v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v0, -v0, v3, v1
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v0, v0, v2, v3
; GFX8-NEXT:    v_div_fixup_f32 v2, v0, s4, 1.0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_f32_correctly_rounded_divide_sqrt:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v0, s0, s4, s4, 1.0
; GFX10-NEXT:    v_div_scale_f32 v2, vcc_lo, 1.0, s4, 1.0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    v_rcp_f32_e32 v1, v0
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v1, v3, v1
; GFX10-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX10-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX10-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_div_fixup_f32 v0, v0, s4, 1.0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_f32_correctly_rounded_divide_sqrt:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v0, null, s4, s4, 1.0
; GFX11-NEXT:    v_div_scale_f32 v2, vcc_lo, 1.0, s4, 1.0
; GFX11-NEXT:    v_rcp_f32_e32 v1, v0
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v1, v3, v1
; GFX11-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX11-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX11-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    v_div_fixup_f32 v0, v0, s4, 1.0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_f32_correctly_rounded_divide_sqrt:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     RECIP_IEEE * T1.X, KC0[2].Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv float 1.000000e+00, %a
  store float %fdiv, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fdiv_f32_denorms_correctly_rounded_divide_sqrt(ptr addrspace(1) %out, float %a) #1 {
; GFX6-FASTFMA-LABEL: s_fdiv_f32_denorms_correctly_rounded_divide_sqrt:
; GFX6-FASTFMA:       ; %bb.0: ; %entry
; GFX6-FASTFMA-NEXT:    s_load_dword s6, s[2:3], 0xb
; GFX6-FASTFMA-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; GFX6-FASTFMA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-FASTFMA-NEXT:    s_mov_b32 s2, -1
; GFX6-FASTFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v0, s[4:5], s6, s6, 1.0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v1, v0
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, vcc, 1.0, s6, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v1, v3, v1, v1
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v4, v1, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v0, s6, 1.0
; GFX6-FASTFMA-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-FASTFMA-NEXT:    s_endpgm
;
; GFX6-SLOWFMA-LABEL: s_fdiv_f32_denorms_correctly_rounded_divide_sqrt:
; GFX6-SLOWFMA:       ; %bb.0: ; %entry
; GFX6-SLOWFMA-NEXT:    s_load_dword s4, s[2:3], 0xb
; GFX6-SLOWFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v0, s[0:1], s4, s4, 1.0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, vcc, 1.0, s4, 1.0
; GFX6-SLOWFMA-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s2, -1
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v2, v0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, -v0, v2, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, v3, v2, v2
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v3, v1, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, -v0, v3, v1
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v4, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v0, -v0, v3, v1
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v0, v0, v2, v3
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v0, s4, 1.0
; GFX6-SLOWFMA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-SLOWFMA-NEXT:    s_endpgm
;
; GFX7-LABEL: s_fdiv_f32_denorms_correctly_rounded_divide_sqrt:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s6, s[2:3], 0xb
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v0, s[4:5], s6, s6, 1.0
; GFX7-NEXT:    v_rcp_f32_e32 v1, v0
; GFX7-NEXT:    v_div_scale_f32 v2, vcc, 1.0, s6, 1.0
; GFX7-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; GFX7-NEXT:    v_fma_f32 v1, v3, v1, v1
; GFX7-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX7-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX7-NEXT:    v_fma_f32 v3, v4, v1, v3
; GFX7-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX7-NEXT:    v_div_fixup_f32 v0, v0, s6, 1.0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fdiv_f32_denorms_correctly_rounded_divide_sqrt:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v0, s[0:1], s4, s4, 1.0
; GFX8-NEXT:    v_div_scale_f32 v1, vcc, 1.0, s4, 1.0
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX8-NEXT:    v_rcp_f32_e32 v2, v0
; GFX8-NEXT:    v_fma_f32 v3, -v0, v2, 1.0
; GFX8-NEXT:    v_fma_f32 v2, v3, v2, v2
; GFX8-NEXT:    v_mul_f32_e32 v3, v1, v2
; GFX8-NEXT:    v_fma_f32 v4, -v0, v3, v1
; GFX8-NEXT:    v_fma_f32 v3, v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v0, -v0, v3, v1
; GFX8-NEXT:    v_div_fmas_f32 v0, v0, v2, v3
; GFX8-NEXT:    v_div_fixup_f32 v2, v0, s4, 1.0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: s_fdiv_f32_denorms_correctly_rounded_divide_sqrt:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v0, s0, s4, s4, 1.0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    v_rcp_f32_e32 v1, v0
; GFX10-NEXT:    v_fma_f32 v2, -v0, v1, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v1, v2, v1
; GFX10-NEXT:    v_div_scale_f32 v2, vcc_lo, 1.0, s4, 1.0
; GFX10-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX10-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX10-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX10-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_div_fixup_f32 v0, v0, s4, 1.0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fdiv_f32_denorms_correctly_rounded_divide_sqrt:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v0, null, s4, s4, 1.0
; GFX11-NEXT:    v_rcp_f32_e32 v1, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v2, -v0, v1, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v1, v2, v1
; GFX11-NEXT:    v_div_scale_f32 v2, vcc_lo, 1.0, s4, 1.0
; GFX11-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX11-NEXT:    v_fma_f32 v4, -v0, v3, v2
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v1
; GFX11-NEXT:    v_fma_f32 v0, -v0, v3, v2
; GFX11-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    v_div_fixup_f32 v0, v0, s4, 1.0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; EG-LABEL: s_fdiv_f32_denorms_correctly_rounded_divide_sqrt:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     RECIP_IEEE * T1.X, KC0[2].Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %fdiv = fdiv float 1.000000e+00, %a
  store float %fdiv, ptr addrspace(1) %out
  ret void
}

define float @v_fdiv_f32_dynamic_denorm(float %a, float %b) #2 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_dynamic_denorm:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_dynamic_denorm:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic_denorm:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic_denorm:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic_denorm:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic_denorm:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 4, 2)
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s0
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic_denorm:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %fdiv = fdiv float %a, %b
  ret float %fdiv
}

define float @v_fdiv_f32_ieee(float %x, float %y) #1 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_ieee:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_ieee:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_ieee:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_ieee:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_ieee:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_ieee:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y
  ret float %div
}

define float @v_fdiv_f32_ieee_25ulp(float %x, float %y) #1 {
; GFX6-LABEL: v_fdiv_f32_ieee_25ulp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v0, v3, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_ieee_25ulp:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX7-NEXT:    v_rcp_f32_e32 v2, v2
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v3, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_ieee_25ulp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX8-NEXT:    v_rcp_f32_e32 v2, v2
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_ieee_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_ieee_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_ieee_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_dynamic(float %x, float %y) #2 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_dynamic:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_dynamic:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 4, 2)
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s0
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y
  ret float %div
}

define float @v_fdiv_f32_dynamic_25ulp(float %x, float %y) #2 {
; GFX6-LABEL: v_fdiv_f32_dynamic_25ulp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v0, v3, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic_25ulp:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX7-NEXT:    v_rcp_f32_e32 v2, v2
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v3, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic_25ulp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX8-NEXT:    v_rcp_f32_e32 v2, v2
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_daz(float %x, float %y) #0 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_daz:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_daz:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_daz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_daz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_daz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_daz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_daz:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y
  ret float %div
}

define float @v_fdiv_f32_daz_25ulp(float %x, float %y) #0 {
; GFX678-LABEL: v_fdiv_f32_daz_25ulp:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    s_mov_b32 s4, 0x6f800000
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x2f800000
; GFX678-NEXT:    v_cmp_gt_f32_e64 vcc, |v1|, s4
; GFX678-NEXT:    v_cndmask_b32_e32 v2, 1.0, v2, vcc
; GFX678-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX678-NEXT:    v_rcp_f32_e32 v1, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_daz_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v1|
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s4
; GFX10-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_daz_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v1|
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s0
; GFX11-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_daz_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y, !fpmath !0
  ret float %div
}

; If we emit an fmul, make sure it fuses into the user.
define float @v_fdiv_f32_ieee_contractable_user(float %x, float %y, float %z) #1 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_ieee_contractable_user:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v5, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX6-FASTFMA-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_ieee_contractable_user:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v3, v5, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v7, -v3, v6, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, -v3, v6, v4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v3, v3, v5, v6
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX6-SLOWFMA-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_ieee_contractable_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v4, v3
; GFX7-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX7-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX7-NEXT:    v_div_scale_f32 v5, vcc, v0, v1, v0
; GFX7-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX7-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX7-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX7-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX7-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX7-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_ieee_contractable_user:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v5, v3
; GFX8-NEXT:    v_fma_f32 v6, -v3, v5, 1.0
; GFX8-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX8-NEXT:    v_mul_f32_e32 v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v7, -v3, v6, v4
; GFX8-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX8-NEXT:    v_fma_f32 v3, -v3, v6, v4
; GFX8-NEXT:    v_div_fmas_f32 v3, v3, v5, v6
; GFX8-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_ieee_contractable_user:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v3, s4, v1, v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v4, v3
; GFX10-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v4, v5, v4
; GFX10-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX10-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX10-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX10-NEXT:    v_fmac_f32_e32 v6, v7, v4
; GFX10-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX10-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX10-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_ieee_contractable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v3, null, v1, v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v4, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v4, v5, v4
; GFX11-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX11-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX11-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX11-NEXT:    v_fmac_f32_e32 v6, v7, v4
; GFX11-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX11-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX11-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_ieee_contractable_user:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv contract float %x, %y
  %add = fadd contract float %div, %z
  ret float %add
}

define float @v_fdiv_f32_ieee_25ulp_contractable_user(float %x, float %y, float %z) #1 {
; GFX6-LABEL: v_fdiv_f32_ieee_25ulp_contractable_user:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v1, v3, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v3, v3
; GFX6-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v0, v4, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v3, v0
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_ieee_25ulp_contractable_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX7-NEXT:    v_rcp_f32_e32 v3, v3
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v4, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v4, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_ieee_25ulp_contractable_user:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX8-NEXT:    v_rcp_f32_e32 v3, v3
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v4, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v4, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_ieee_25ulp_contractable_user:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v3
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX10-NEXT:    v_ldexp_f32 v0, v3, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_ieee_25ulp_contractable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX11-NEXT:    v_ldexp_f32 v0, v3, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_ieee_25ulp_contractable_user:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv contract float %x, %y, !fpmath !0
  %add = fadd contract float %div, %z
  ret float %add
}

define float @v_fdiv_f32_dynamic_contractable_user(float %x, float %y, float %z) #2 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_dynamic_contractable_user:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v5, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FASTFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX6-FASTFMA-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_dynamic_contractable_user:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v3, v5, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v7, -v3, v6, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, -v3, v6, v4
; GFX6-SLOWFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v3, v3, v5, v6
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX6-SLOWFMA-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic_contractable_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v4, v3
; GFX7-NEXT:    v_div_scale_f32 v5, vcc, v0, v1, v0
; GFX7-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX7-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX7-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX7-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX7-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX7-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX7-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX7-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX7-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic_contractable_user:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX8-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX8-NEXT:    v_rcp_f32_e32 v5, v3
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v6, -v3, v5, 1.0
; GFX8-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX8-NEXT:    v_mul_f32_e32 v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v7, -v3, v6, v4
; GFX8-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX8-NEXT:    v_fma_f32 v3, -v3, v6, v4
; GFX8-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX8-NEXT:    v_div_fmas_f32 v3, v3, v5, v6
; GFX8-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic_contractable_user:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v3, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX10-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX10-NEXT:    v_rcp_f32_e32 v4, v3
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v4, v6, v4
; GFX10-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX10-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX10-NEXT:    v_fmac_f32_e32 v6, v7, v4
; GFX10-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX10-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX10-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic_contractable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v3, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX11-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 4, 2)
; GFX11-NEXT:    v_rcp_f32_e32 v4, v3
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v4, v6, v4
; GFX11-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX11-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX11-NEXT:    v_fmac_f32_e32 v6, v7, v4
; GFX11-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX11-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s0
; GFX11-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX11-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic_contractable_user:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv contract float %x, %y
  %add = fadd contract float %div, %z
  ret float %add
}

define float @v_fdiv_f32_dynamic_25ulp_contractable_user(float %x, float %y, float %z) #2 {
; GFX6-LABEL: v_fdiv_f32_dynamic_25ulp_contractable_user:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v1, v3, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v3, v3
; GFX6-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v0, v4, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v3, v0
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic_25ulp_contractable_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX7-NEXT:    v_rcp_f32_e32 v3, v3
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v4, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v4, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic_25ulp_contractable_user:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX8-NEXT:    v_rcp_f32_e32 v3, v3
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v4, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v4, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic_25ulp_contractable_user:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v3
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX10-NEXT:    v_ldexp_f32 v0, v3, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic_25ulp_contractable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX11-NEXT:    v_ldexp_f32 v0, v3, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic_25ulp_contractable_user:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv contract float %x, %y, !fpmath !0
  %add = fadd contract float %div, %z
  ret float %add
}

define float @v_fdiv_f32_daz_contractable_user(float %x, float %y, float %z) #0 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_daz_contractable_user:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v5, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX6-FASTFMA-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_daz_contractable_user:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v3, v5, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v7, -v3, v6, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, -v3, v6, v4
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v3, v3, v5, v6
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX6-SLOWFMA-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_daz_contractable_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v4, v3
; GFX7-NEXT:    v_div_scale_f32 v5, vcc, v0, v1, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX7-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX7-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX7-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX7-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX7-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX7-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_daz_contractable_user:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v5, v3
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v6, -v3, v5, 1.0
; GFX8-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX8-NEXT:    v_mul_f32_e32 v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v7, -v3, v6, v4
; GFX8-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX8-NEXT:    v_fma_f32 v3, -v3, v6, v4
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v3, v3, v5, v6
; GFX8-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_daz_contractable_user:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v3, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v4, v3
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v4, v6, v4
; GFX10-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX10-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX10-NEXT:    v_fmac_f32_e32 v6, v7, v4
; GFX10-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX10-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_daz_contractable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v3, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v4, v3
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v4, v6, v4
; GFX11-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX11-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX11-NEXT:    v_fmac_f32_e32 v6, v7, v4
; GFX11-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX11-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_daz_contractable_user:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv contract float %x, %y
  %add = fadd contract float %div, %z
  ret float %add
}

define float @v_fdiv_f32_daz_25ulp_contractable_user(float %x, float %y, float %z) #0 {
; GFX678-LABEL: v_fdiv_f32_daz_25ulp_contractable_user:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    s_mov_b32 s4, 0x6f800000
; GFX678-NEXT:    v_mov_b32_e32 v3, 0x2f800000
; GFX678-NEXT:    v_cmp_gt_f32_e64 vcc, |v1|, s4
; GFX678-NEXT:    v_cndmask_b32_e32 v3, 1.0, v3, vcc
; GFX678-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX678-NEXT:    v_rcp_f32_e32 v1, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX678-NEXT:    v_mad_f32 v0, v3, v0, v2
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_daz_25ulp_contractable_user:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v1|
; GFX10-NEXT:    v_cndmask_b32_e64 v3, 1.0, 0x2f800000, s4
; GFX10-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mad_f32 v0, v3, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_daz_25ulp_contractable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v1|
; GFX11-NEXT:    v_cndmask_b32_e64 v3, 1.0, 0x2f800000, s0
; GFX11-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_fma_f32 v0, v3, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_daz_25ulp_contractable_user:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv contract float %x, %y, !fpmath !0
  %add = fadd contract float %div, %z
  ret float %add
}

define float @v_fdiv_f32_ieee__nnan_ninf(float %x, float %y, float %z) #1 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_ieee__nnan_ninf:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_ieee__nnan_ninf:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_ieee__nnan_ninf:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_ieee__nnan_ninf:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_ieee__nnan_ninf:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_ieee__nnan_ninf:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_ieee__nnan_ninf:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv nnan ninf float %x, %y
  ret float %div
}

define float @v_fdiv_f32_ieee_25ulp__nnan_ninf(float %x, float %y, float %z) #1 {
; GFX6-LABEL: v_fdiv_f32_ieee_25ulp__nnan_ninf:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v0, v3, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_ieee_25ulp__nnan_ninf:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX7-NEXT:    v_rcp_f32_e32 v2, v2
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v3, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_ieee_25ulp__nnan_ninf:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX8-NEXT:    v_rcp_f32_e32 v2, v2
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_ieee_25ulp__nnan_ninf:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_ieee_25ulp__nnan_ninf:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_ieee_25ulp__nnan_ninf:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv nnan ninf float %x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_dynamic__nnan_ninf(float %x, float %y, float %z) #2 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_dynamic__nnan_ninf:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_dynamic__nnan_ninf:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic__nnan_ninf:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic__nnan_ninf:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic__nnan_ninf:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic__nnan_ninf:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 4, 2)
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s0
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic__nnan_ninf:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv nnan ninf float %x, %y
  ret float %div
}

define float @v_fdiv_f32_dynamic_25ulp__nnan_ninf(float %x, float %y, float %z) #2 {
; GFX6-LABEL: v_fdiv_f32_dynamic_25ulp__nnan_ninf:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v0, v3, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic_25ulp__nnan_ninf:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX7-NEXT:    v_rcp_f32_e32 v2, v2
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v3, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic_25ulp__nnan_ninf:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX8-NEXT:    v_rcp_f32_e32 v2, v2
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic_25ulp__nnan_ninf:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic_25ulp__nnan_ninf:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic_25ulp__nnan_ninf:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv nnan ninf float %x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_daz__nnan_ninf(float %x, float %y, float %z) #0 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_daz__nnan_ninf:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_daz__nnan_ninf:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_daz__nnan_ninf:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_daz__nnan_ninf:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_daz__nnan_ninf:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_daz__nnan_ninf:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_daz__nnan_ninf:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv nnan ninf float %x, %y
  ret float %div
}

define float @v_fdiv_f32_daz_25ulp__nnan_ninf(float %x, float %y, float %z) #0 {
; GFX678-LABEL: v_fdiv_f32_daz_25ulp__nnan_ninf:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    s_mov_b32 s4, 0x6f800000
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x2f800000
; GFX678-NEXT:    v_cmp_gt_f32_e64 vcc, |v1|, s4
; GFX678-NEXT:    v_cndmask_b32_e32 v2, 1.0, v2, vcc
; GFX678-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX678-NEXT:    v_rcp_f32_e32 v1, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_daz_25ulp__nnan_ninf:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v1|
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s4
; GFX10-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_daz_25ulp__nnan_ninf:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v1|
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s0
; GFX11-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_daz_25ulp__nnan_ninf:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv nnan ninf float %x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_ieee__nnan_ninf_contractable_user(float %x, float %y, float %z) #1 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_ieee__nnan_ninf_contractable_user:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v5, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX6-FASTFMA-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_ieee__nnan_ninf_contractable_user:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v3, v5, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v7, -v3, v6, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, -v3, v6, v4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v3, v3, v5, v6
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX6-SLOWFMA-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_ieee__nnan_ninf_contractable_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v4, v3
; GFX7-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX7-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX7-NEXT:    v_div_scale_f32 v5, vcc, v0, v1, v0
; GFX7-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX7-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX7-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX7-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX7-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX7-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_ieee__nnan_ninf_contractable_user:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v5, v3
; GFX8-NEXT:    v_fma_f32 v6, -v3, v5, 1.0
; GFX8-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX8-NEXT:    v_mul_f32_e32 v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v7, -v3, v6, v4
; GFX8-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX8-NEXT:    v_fma_f32 v3, -v3, v6, v4
; GFX8-NEXT:    v_div_fmas_f32 v3, v3, v5, v6
; GFX8-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_ieee__nnan_ninf_contractable_user:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v3, s4, v1, v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v4, v3
; GFX10-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v4, v5, v4
; GFX10-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX10-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX10-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX10-NEXT:    v_fmac_f32_e32 v6, v7, v4
; GFX10-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX10-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX10-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_ieee__nnan_ninf_contractable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v3, null, v1, v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v4, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v4, v5, v4
; GFX11-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX11-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX11-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX11-NEXT:    v_fmac_f32_e32 v6, v7, v4
; GFX11-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX11-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX11-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_ieee__nnan_ninf_contractable_user:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv nnan ninf contract float %x, %y
  %add = fadd contract float %div, %z
  ret float %add
}

define float @v_fdiv_f32_ieee_25ulp__nnan_ninf_contractable_user(float %x, float %y, float %z) #1 {
; GFX6-LABEL: v_fdiv_f32_ieee_25ulp__nnan_ninf_contractable_user:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v1, v3, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v3, v3
; GFX6-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v0, v4, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v3, v0
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_ieee_25ulp__nnan_ninf_contractable_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX7-NEXT:    v_rcp_f32_e32 v3, v3
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v4, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v4, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_ieee_25ulp__nnan_ninf_contractable_user:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX8-NEXT:    v_rcp_f32_e32 v3, v3
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v4, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v4, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_ieee_25ulp__nnan_ninf_contractable_user:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v3
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX10-NEXT:    v_ldexp_f32 v0, v3, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_ieee_25ulp__nnan_ninf_contractable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX11-NEXT:    v_ldexp_f32 v0, v3, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_ieee_25ulp__nnan_ninf_contractable_user:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv nnan ninf contract float %x, %y, !fpmath !0
  %add = fadd contract float %div, %z
  ret float %add
}

define float @v_fdiv_f32_dynamic__nnan_ninf_contractable_user(float %x, float %y, float %z) #2 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_dynamic__nnan_ninf_contractable_user:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v5, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FASTFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX6-FASTFMA-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_dynamic__nnan_ninf_contractable_user:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v3, v5, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v7, -v3, v6, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, -v3, v6, v4
; GFX6-SLOWFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v3, v3, v5, v6
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX6-SLOWFMA-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic__nnan_ninf_contractable_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v4, v3
; GFX7-NEXT:    v_div_scale_f32 v5, vcc, v0, v1, v0
; GFX7-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX7-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX7-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX7-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX7-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX7-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX7-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX7-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX7-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic__nnan_ninf_contractable_user:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX8-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX8-NEXT:    v_rcp_f32_e32 v5, v3
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v6, -v3, v5, 1.0
; GFX8-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX8-NEXT:    v_mul_f32_e32 v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v7, -v3, v6, v4
; GFX8-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX8-NEXT:    v_fma_f32 v3, -v3, v6, v4
; GFX8-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX8-NEXT:    v_div_fmas_f32 v3, v3, v5, v6
; GFX8-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic__nnan_ninf_contractable_user:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v3, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX10-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX10-NEXT:    v_rcp_f32_e32 v4, v3
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v4, v6, v4
; GFX10-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX10-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX10-NEXT:    v_fmac_f32_e32 v6, v7, v4
; GFX10-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX10-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX10-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic__nnan_ninf_contractable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v3, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX11-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 4, 2)
; GFX11-NEXT:    v_rcp_f32_e32 v4, v3
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v4, v6, v4
; GFX11-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX11-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX11-NEXT:    v_fmac_f32_e32 v6, v7, v4
; GFX11-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX11-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s0
; GFX11-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX11-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic__nnan_ninf_contractable_user:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv nnan ninf contract float %x, %y
  %add = fadd contract float %div, %z
  ret float %add
}

define float @v_fdiv_f32_dynamic_25ulp__nnan_ninf_contractable_user(float %x, float %y, float %z) #2 {
; GFX6-LABEL: v_fdiv_f32_dynamic_25ulp__nnan_ninf_contractable_user:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v1, v3, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v3, v3
; GFX6-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v0, v4, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v3, v0
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic_25ulp__nnan_ninf_contractable_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX7-NEXT:    v_rcp_f32_e32 v3, v3
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v4, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v4, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic_25ulp__nnan_ninf_contractable_user:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX8-NEXT:    v_rcp_f32_e32 v3, v3
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v4, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v4, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic_25ulp__nnan_ninf_contractable_user:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v3
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX10-NEXT:    v_ldexp_f32 v0, v3, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic_25ulp__nnan_ninf_contractable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX11-NEXT:    v_ldexp_f32 v0, v3, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic_25ulp__nnan_ninf_contractable_user:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv nnan ninf contract float %x, %y, !fpmath !0
  %add = fadd contract float %div, %z
  ret float %add
}

define float @v_fdiv_f32_daz__nnan_ninf_contractable_user(float %x, float %y, float %z) #0 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_daz__nnan_ninf_contractable_user:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v5, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX6-FASTFMA-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_daz__nnan_ninf_contractable_user:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v3, v5, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v7, -v3, v6, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, -v3, v6, v4
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v3, v3, v5, v6
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX6-SLOWFMA-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_daz__nnan_ninf_contractable_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v4, v3
; GFX7-NEXT:    v_div_scale_f32 v5, vcc, v0, v1, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX7-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX7-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX7-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX7-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX7-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX7-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_daz__nnan_ninf_contractable_user:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v5, v3
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v6, -v3, v5, 1.0
; GFX8-NEXT:    v_fma_f32 v5, v6, v5, v5
; GFX8-NEXT:    v_mul_f32_e32 v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v7, -v3, v6, v4
; GFX8-NEXT:    v_fma_f32 v6, v7, v5, v6
; GFX8-NEXT:    v_fma_f32 v3, -v3, v6, v4
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v3, v3, v5, v6
; GFX8-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_daz__nnan_ninf_contractable_user:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v3, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v4, v3
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v4, v6, v4
; GFX10-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX10-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX10-NEXT:    v_fmac_f32_e32 v6, v7, v4
; GFX10-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX10-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_daz__nnan_ninf_contractable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v3, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v4, v3
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v4, v6, v4
; GFX11-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX11-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX11-NEXT:    v_fmac_f32_e32 v6, v7, v4
; GFX11-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX11-NEXT:    v_div_fixup_f32 v0, v3, v1, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_daz__nnan_ninf_contractable_user:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv nnan ninf contract float %x, %y
  %add = fadd contract float %div, %z
  ret float %add
}

define float @v_fdiv_f32_daz_25ulp__nnan_ninf_contractable_user(float %x, float %y, float %z) #0 {
; GFX678-LABEL: v_fdiv_f32_daz_25ulp__nnan_ninf_contractable_user:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    s_mov_b32 s4, 0x6f800000
; GFX678-NEXT:    v_mov_b32_e32 v3, 0x2f800000
; GFX678-NEXT:    v_cmp_gt_f32_e64 vcc, |v1|, s4
; GFX678-NEXT:    v_cndmask_b32_e32 v3, 1.0, v3, vcc
; GFX678-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX678-NEXT:    v_rcp_f32_e32 v1, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX678-NEXT:    v_mad_f32 v0, v3, v0, v2
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_daz_25ulp__nnan_ninf_contractable_user:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v1|
; GFX10-NEXT:    v_cndmask_b32_e64 v3, 1.0, 0x2f800000, s4
; GFX10-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mad_f32 v0, v3, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_daz_25ulp__nnan_ninf_contractable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v1|
; GFX11-NEXT:    v_cndmask_b32_e64 v3, 1.0, 0x2f800000, s0
; GFX11-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_fma_f32 v0, v3, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_daz_25ulp__nnan_ninf_contractable_user:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv nnan ninf contract float %x, %y, !fpmath !0
  %add = fadd contract float %div, %z
  ret float %add
}

define float @v_fdiv_neglhs_f32_ieee(float %x, float %y) #1 {
; GFX6-FASTFMA-LABEL: v_fdiv_neglhs_f32_ieee:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, -v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, -v0, v1, -v0
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_neglhs_f32_ieee:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, -v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, -v0, v1, -v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_neglhs_f32_ieee:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, -v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, -v0, v1, -v0
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_neglhs_f32_ieee:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, -v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, -v0, v1, -v0
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_neglhs_f32_ieee:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, -v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, -v0, v1, -v0
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_neglhs_f32_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, -v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, -v0, v1, -v0
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_neglhs_f32_ieee:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %neg.x = fneg float %x
  %div = fdiv float %neg.x, %y
  ret float %div
}

define float @v_fdiv_neglhs_f32_ieee_25ulp(float %x, float %y) #1 {
; GFX6-LABEL: v_fdiv_neglhs_f32_ieee_25ulp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_frexp_mant_f32_e64 v3, -v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e64 v3, -v0, v3, s[4:5]
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_neglhs_f32_ieee_25ulp:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX7-NEXT:    v_rcp_f32_e32 v2, v2
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX7-NEXT:    v_frexp_mant_f32_e64 v0, -v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v3, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_neglhs_f32_ieee_25ulp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX8-NEXT:    v_rcp_f32_e32 v2, v2
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX8-NEXT:    v_frexp_mant_f32_e64 v0, -v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_neglhs_f32_ieee_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e64 v3, -v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_neglhs_f32_ieee_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e64 v3, -v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_neglhs_f32_ieee_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %neg.x = fneg float %x
  %div = fdiv float %neg.x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_neglhs_f32_dynamic(float %x, float %y) #2 {
; GFX6-FASTFMA-LABEL: v_fdiv_neglhs_f32_dynamic:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, -v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, -v0, v1, -v0
; GFX6-FASTFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_neglhs_f32_dynamic:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, -v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, -v0, v1, -v0
; GFX6-SLOWFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_neglhs_f32_dynamic:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, -v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, -v0, v1, -v0
; GFX7-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_neglhs_f32_dynamic:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, -v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, -v0, v1, -v0
; GFX8-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_neglhs_f32_dynamic:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, -v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, -v0, v1, -v0
; GFX10-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_neglhs_f32_dynamic:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, -v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, -v0, v1, -v0
; GFX11-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 4, 2)
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s0
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_neglhs_f32_dynamic:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %neg.x = fneg float %x
  %div = fdiv float %neg.x, %y
  ret float %div
}

define float @v_fdiv_neglhs_f32_dynamic_25ulp(float %x, float %y) #2 {
; GFX6-LABEL: v_fdiv_neglhs_f32_dynamic_25ulp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_frexp_mant_f32_e64 v3, -v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e64 v3, -v0, v3, s[4:5]
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_neglhs_f32_dynamic_25ulp:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX7-NEXT:    v_rcp_f32_e32 v2, v2
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX7-NEXT:    v_frexp_mant_f32_e64 v0, -v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v3, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_neglhs_f32_dynamic_25ulp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX8-NEXT:    v_rcp_f32_e32 v2, v2
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX8-NEXT:    v_frexp_mant_f32_e64 v0, -v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_neglhs_f32_dynamic_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e64 v3, -v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_neglhs_f32_dynamic_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e64 v3, -v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_neglhs_f32_dynamic_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %neg.x = fneg float %x
  %div = fdiv float %neg.x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_neglhs_f32_daz(float %x, float %y) #0 {
; GFX6-FASTFMA-LABEL: v_fdiv_neglhs_f32_daz:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, -v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, -v0, v1, -v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_neglhs_f32_daz:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, -v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, -v0, v1, -v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_neglhs_f32_daz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, -v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, -v0, v1, -v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_neglhs_f32_daz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, -v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, -v0, v1, -v0
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_neglhs_f32_daz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, -v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, -v0, v1, -v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_neglhs_f32_daz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, -v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, -v0, v1, -v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, -v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_neglhs_f32_daz:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %neg.x = fneg float %x
  %div = fdiv float %neg.x, %y
  ret float %div
}

define float @v_fdiv_neglhs_f32_daz_25ulp(float %x, float %y) #0 {
; GFX678-LABEL: v_fdiv_neglhs_f32_daz_25ulp:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    s_mov_b32 s4, 0x6f800000
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x2f800000
; GFX678-NEXT:    v_cmp_gt_f32_e64 vcc, |v1|, s4
; GFX678-NEXT:    v_cndmask_b32_e32 v2, 1.0, v2, vcc
; GFX678-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX678-NEXT:    v_rcp_f32_e32 v1, v1
; GFX678-NEXT:    v_mul_f32_e64 v0, -v0, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_neglhs_f32_daz_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v1|
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s4
; GFX10-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_mul_f32_e64 v0, -v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_neglhs_f32_daz_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v1|
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s0
; GFX11-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e64 v0, -v0, v1
; GFX11-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_neglhs_f32_daz_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %neg.x = fneg float %x
  %div = fdiv float %neg.x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_negrhs_f32_ieee(float %x, float %y) #1 {
; GFX6-FASTFMA-LABEL: v_fdiv_negrhs_f32_ieee:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], -v1, -v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, -v1, v0
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_negrhs_f32_ieee:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], -v1, -v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, -v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_negrhs_f32_ieee:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], -v1, -v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, -v1, v0
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_negrhs_f32_ieee:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], -v1, -v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, -v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_negrhs_f32_ieee:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, -v1, -v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, -v1, v0
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_negrhs_f32_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, -v1, -v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, -v1, v0
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_negrhs_f32_ieee:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %neg.y = fneg float %y
  %div = fdiv float %x, %neg.y
  ret float %div
}

define float @v_fdiv_negrhs_f32_ieee_25ulp(float %x, float %y) #1 {
; GFX6-LABEL: v_fdiv_negrhs_f32_ieee_25ulp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v1|, s6
; GFX6-NEXT:    v_cndmask_b32_e64 v2, -v1, v2, s[4:5]
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s6
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v0, v3, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_negrhs_f32_ieee_25ulp:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; GFX7-NEXT:    v_rcp_f32_e32 v2, v2
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v3, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_negrhs_f32_ieee_25ulp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; GFX8-NEXT:    v_rcp_f32_e32 v2, v2
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_negrhs_f32_ieee_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_negrhs_f32_ieee_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_negrhs_f32_ieee_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %neg.y = fneg float %y
  %div = fdiv float %x, %neg.y, !fpmath !0
  ret float %div
}

define float @v_fdiv_negrhs_f32_dynamic(float %x, float %y) #2 {
; GFX6-FASTFMA-LABEL: v_fdiv_negrhs_f32_dynamic:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], -v1, -v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, -v1, v0
; GFX6-FASTFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_negrhs_f32_dynamic:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], -v1, -v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, -v1, v0
; GFX6-SLOWFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_negrhs_f32_dynamic:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], -v1, -v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, -v1, v0
; GFX7-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_negrhs_f32_dynamic:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], -v1, -v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, -v1, v0
; GFX8-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_negrhs_f32_dynamic:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, -v1, -v1, v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, -v1, v0
; GFX10-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_negrhs_f32_dynamic:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, -v1, -v1, v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, -v1, v0
; GFX11-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 4, 2)
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s0
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_negrhs_f32_dynamic:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %neg.y = fneg float %y
  %div = fdiv float %x, %neg.y
  ret float %div
}

define float @v_fdiv_negrhs_f32_dynamic_25ulp(float %x, float %y) #2 {
; GFX6-LABEL: v_fdiv_negrhs_f32_dynamic_25ulp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v1|, s6
; GFX6-NEXT:    v_cndmask_b32_e64 v2, -v1, v2, s[4:5]
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s6
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v0, v3, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_negrhs_f32_dynamic_25ulp:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; GFX7-NEXT:    v_rcp_f32_e32 v2, v2
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v3, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_negrhs_f32_dynamic_25ulp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; GFX8-NEXT:    v_rcp_f32_e32 v2, v2
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_negrhs_f32_dynamic_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_negrhs_f32_dynamic_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_negrhs_f32_dynamic_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %neg.y = fneg float %y
  %div = fdiv float %x, %neg.y, !fpmath !0
  ret float %div
}

define float @v_fdiv_negrhs_f32_daz(float %x, float %y) #0 {
; GFX6-FASTFMA-LABEL: v_fdiv_negrhs_f32_daz:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], -v1, -v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, -v1, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_negrhs_f32_daz:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], -v1, -v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, -v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_negrhs_f32_daz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], -v1, -v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, -v1, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_negrhs_f32_daz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], -v1, -v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, -v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_negrhs_f32_daz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, -v1, -v1, v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, -v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_negrhs_f32_daz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, -v1, -v1, v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, -v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, -v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_negrhs_f32_daz:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %neg.y = fneg float %y
  %div = fdiv float %x, %neg.y
  ret float %div
}

define float @v_fdiv_negrhs_f32_daz_25ulp(float %x, float %y) #0 {
; GFX678-LABEL: v_fdiv_negrhs_f32_daz_25ulp:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    s_mov_b32 s4, 0x6f800000
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x2f800000
; GFX678-NEXT:    v_cmp_gt_f32_e64 vcc, |v1|, s4
; GFX678-NEXT:    v_cndmask_b32_e32 v2, 1.0, v2, vcc
; GFX678-NEXT:    v_mul_f32_e64 v1, -v1, v2
; GFX678-NEXT:    v_rcp_f32_e32 v1, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_negrhs_f32_daz_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v1|
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s4
; GFX10-NEXT:    v_mul_f32_e64 v1, -v1, v2
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_negrhs_f32_daz_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v1|
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s0
; GFX11-NEXT:    v_mul_f32_e64 v1, -v1, v2
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_negrhs_f32_daz_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %neg.y = fneg float %y
  %div = fdiv float %x, %neg.y, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_constrhs0_ieee(float %x) #1 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_constrhs0_ieee:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v1, s[4:5], s6, s6, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, v3, v2, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, s6, v0
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v1, s6, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_constrhs0_ieee:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, s[4:5], s6, s6, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, vcc, v0, s6, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v3, v1
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v1, s6, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_constrhs0_ieee:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX7-NEXT:    v_div_scale_f32 v1, s[4:5], s6, s6, v0
; GFX7-NEXT:    v_rcp_f32_e32 v2, v1
; GFX7-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX7-NEXT:    v_fma_f32 v2, v3, v2, v2
; GFX7-NEXT:    v_div_scale_f32 v3, vcc, v0, s6, v0
; GFX7-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX7-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX7-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX7-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX7-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX7-NEXT:    v_div_fixup_f32 v0, v1, s6, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_constrhs0_ieee:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX8-NEXT:    v_div_scale_f32 v1, s[4:5], s6, s6, v0
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, v0, s6, v0
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX8-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX8-NEXT:    v_div_fixup_f32 v0, v1, s6, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_constrhs0_ieee:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v1, s4, 0x4640e400, 0x4640e400, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v1
; GFX10-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_div_scale_f32 v3, vcc_lo, v0, 0x4640e400, v0
; GFX10-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX10-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX10-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX10-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX10-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX10-NEXT:    v_div_fixup_f32 v0, v1, 0x4640e400, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_constrhs0_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v1, null, 0x4640e400, 0x4640e400, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_div_scale_f32 v3, vcc_lo, v0, 0x4640e400, v0
; GFX11-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX11-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX11-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX11-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX11-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX11-NEXT:    v_div_fixup_f32 v0, v1, 0x4640e400, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_constrhs0_ieee:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, 12345.0
  ret float %div
}

define float @v_fdiv_f32_constrhs0_ieee_25ulp(float %x) #1 {
; GFX6-LABEL: v_fdiv_f32_constrhs0_ieee_25ulp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, 0x4640e400
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v0, v2, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, 0x3fa9e0f0, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_constrhs0_ieee_25ulp:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, 0x3fa9e0f0, v0
; GFX7-NEXT:    v_add_i32_e32 v1, vcc, -14, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_constrhs0_ieee_25ulp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, 0x3fa9e0f0, v0
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, -14, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_constrhs0_ieee_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_mul_f32_e32 v1, 0x3fa9e0f0, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, -14, v0
; GFX10-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_constrhs0_ieee_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_dual_mul_f32 v1, 0x3fa9e0f0, v1 :: v_dual_add_nc_u32 v0, -14, v0
; GFX11-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_constrhs0_ieee_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, 12345.0, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_constrhs0_dynamic(float %x) #2 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_constrhs0_dynamic:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v1, s[4:5], s6, s6, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, s6, v0
; GFX6-FASTFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v1, s6, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_constrhs0_dynamic:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, s[4:5], s6, s6, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, vcc, v0, s6, v0
; GFX6-SLOWFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v3, v1
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v1, s6, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_constrhs0_dynamic:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX7-NEXT:    v_div_scale_f32 v1, s[4:5], s6, s6, v0
; GFX7-NEXT:    v_rcp_f32_e32 v2, v1
; GFX7-NEXT:    v_div_scale_f32 v3, vcc, v0, s6, v0
; GFX7-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX7-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX7-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX7-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX7-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX7-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX7-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX7-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX7-NEXT:    v_div_fixup_f32 v0, v1, s6, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_constrhs0_dynamic:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX8-NEXT:    v_div_scale_f32 v1, s[4:5], s6, s6, v0
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, v0, s6, v0
; GFX8-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX8-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX8-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX8-NEXT:    v_div_fixup_f32 v0, v1, s6, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_constrhs0_dynamic:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v1, s4, 0x4640e400, 0x4640e400, v0
; GFX10-NEXT:    v_div_scale_f32 v3, vcc_lo, v0, 0x4640e400, v0
; GFX10-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX10-NEXT:    v_rcp_f32_e32 v2, v1
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v2, v4, v2
; GFX10-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX10-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX10-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX10-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX10-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX10-NEXT:    v_div_fixup_f32 v0, v1, 0x4640e400, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_constrhs0_dynamic:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v1, null, 0x4640e400, 0x4640e400, v0
; GFX11-NEXT:    v_div_scale_f32 v3, vcc_lo, v0, 0x4640e400, v0
; GFX11-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 4, 2)
; GFX11-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v2, v4, v2
; GFX11-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX11-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX11-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX11-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX11-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s0
; GFX11-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX11-NEXT:    v_div_fixup_f32 v0, v1, 0x4640e400, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_constrhs0_dynamic:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, 12345.0
  ret float %div
}

define float @v_fdiv_f32_constrhs0_dynamic_25ulp(float %x) #2 {
; GFX6-LABEL: v_fdiv_f32_constrhs0_dynamic_25ulp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, 0x4640e400
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v0, v2, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, 0x3fa9e0f0, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_constrhs0_dynamic_25ulp:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, 0x3fa9e0f0, v0
; GFX7-NEXT:    v_add_i32_e32 v1, vcc, -14, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_constrhs0_dynamic_25ulp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, 0x3fa9e0f0, v0
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, -14, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_constrhs0_dynamic_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_mul_f32_e32 v1, 0x3fa9e0f0, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, -14, v0
; GFX10-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_constrhs0_dynamic_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_dual_mul_f32 v1, 0x3fa9e0f0, v1 :: v_dual_add_nc_u32 v0, -14, v0
; GFX11-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_constrhs0_dynamic_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, 12345.0, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_constrhs0_daz(float %x) #0 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_constrhs0_daz:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v1, s[4:5], s6, s6, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, s6, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v1, s6, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_constrhs0_daz:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, s[4:5], s6, s6, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, vcc, v0, s6, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v3, v1
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v1, s6, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_constrhs0_daz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX7-NEXT:    v_div_scale_f32 v1, s[4:5], s6, s6, v0
; GFX7-NEXT:    v_rcp_f32_e32 v2, v1
; GFX7-NEXT:    v_div_scale_f32 v3, vcc, v0, s6, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX7-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX7-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX7-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX7-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX7-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX7-NEXT:    v_div_fixup_f32 v0, v1, s6, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_constrhs0_daz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX8-NEXT:    v_div_scale_f32 v1, s[4:5], s6, s6, v0
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, v0, s6, v0
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX8-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX8-NEXT:    v_div_fixup_f32 v0, v1, s6, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_constrhs0_daz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v1, s4, 0x4640e400, 0x4640e400, v0
; GFX10-NEXT:    v_div_scale_f32 v3, vcc_lo, v0, 0x4640e400, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v1
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v2, v4, v2
; GFX10-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX10-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX10-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX10-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX10-NEXT:    v_div_fixup_f32 v0, v1, 0x4640e400, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_constrhs0_daz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v1, null, 0x4640e400, 0x4640e400, v0
; GFX11-NEXT:    v_div_scale_f32 v3, vcc_lo, v0, 0x4640e400, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v2, v4, v2
; GFX11-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX11-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX11-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX11-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX11-NEXT:    v_div_fixup_f32 v0, v1, 0x4640e400, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_constrhs0_daz:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, 12345.0
  ret float %div
}

define float @v_fdiv_f32_constrhs0_daz_25ulp(float %x) #0 {
; GCN-LABEL: v_fdiv_f32_constrhs0_daz_25ulp:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x38a9e0f0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_constrhs0_daz_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, 12345.0, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_constlhs0_ieee(float %x) #1 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_constlhs0_ieee:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, s6
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, v3, v2, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, vcc, s6, v0, s6
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v1, v0, s6
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_constlhs0_ieee:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, s6
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, vcc, s6, v0, s6
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v3, v1
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v1, v0, s6
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_constlhs0_ieee:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX7-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, s6
; GFX7-NEXT:    v_rcp_f32_e32 v2, v1
; GFX7-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX7-NEXT:    v_fma_f32 v2, v3, v2, v2
; GFX7-NEXT:    v_div_scale_f32 v3, vcc, s6, v0, s6
; GFX7-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX7-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX7-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX7-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX7-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX7-NEXT:    v_div_fixup_f32 v0, v1, v0, s6
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_constlhs0_ieee:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX8-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, s6
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, s6, v0, s6
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX8-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX8-NEXT:    v_div_fixup_f32 v0, v1, v0, s6
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_constlhs0_ieee:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v1, s4, v0, v0, 0x4640e400
; GFX10-NEXT:    v_rcp_f32_e32 v2, v1
; GFX10-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_div_scale_f32 v3, vcc_lo, 0x4640e400, v0, 0x4640e400
; GFX10-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX10-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX10-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX10-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX10-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX10-NEXT:    v_div_fixup_f32 v0, v1, v0, 0x4640e400
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_constlhs0_ieee:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v1, null, v0, v0, 0x4640e400
; GFX11-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_div_scale_f32 v3, vcc_lo, 0x4640e400, v0, 0x4640e400
; GFX11-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX11-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX11-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX11-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX11-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX11-NEXT:    v_div_fixup_f32 v0, v1, v0, 0x4640e400
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_constlhs0_ieee:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float 12345.0, %x
  ret float %div
}

define float @v_fdiv_f32_constlhs0_ieee_25ulp(float %x) #1 {
; GFX6-LABEL: v_fdiv_f32_constlhs0_ieee_25ulp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v1, v1
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v2, 0x4640e400
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v2, v0
; GFX6-NEXT:    v_mul_f32_e32 v1, 0x3f40e400, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_constlhs0_ieee_25ulp:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX7-NEXT:    v_sub_i32_e32 v0, vcc, 14, v0
; GFX7-NEXT:    v_mul_f32_e32 v1, 0x3f40e400, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_constlhs0_ieee_25ulp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, 14, v0
; GFX8-NEXT:    v_mul_f32_e32 v1, 0x3f40e400, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_constlhs0_ieee_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, 14, v0
; GFX10-NEXT:    v_mul_f32_e32 v1, 0x3f40e400, v1
; GFX10-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_constlhs0_ieee_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, 14, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v1, 0x3f40e400, v1
; GFX11-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_constlhs0_ieee_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float 12345.0, %x, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_constlhs0_dynamic(float %x) #2 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_constlhs0_dynamic:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, s6
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, vcc, s6, v0, s6
; GFX6-FASTFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v1, v0, s6
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_constlhs0_dynamic:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, s6
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, vcc, s6, v0, s6
; GFX6-SLOWFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v3, v1
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v1, v0, s6
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_constlhs0_dynamic:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX7-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, s6
; GFX7-NEXT:    v_rcp_f32_e32 v2, v1
; GFX7-NEXT:    v_div_scale_f32 v3, vcc, s6, v0, s6
; GFX7-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX7-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX7-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX7-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX7-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX7-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX7-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX7-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX7-NEXT:    v_div_fixup_f32 v0, v1, v0, s6
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_constlhs0_dynamic:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX8-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, s6
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, s6, v0, s6
; GFX8-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX8-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX8-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX8-NEXT:    v_div_fixup_f32 v0, v1, v0, s6
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_constlhs0_dynamic:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v1, s4, v0, v0, 0x4640e400
; GFX10-NEXT:    v_div_scale_f32 v3, vcc_lo, 0x4640e400, v0, 0x4640e400
; GFX10-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX10-NEXT:    v_rcp_f32_e32 v2, v1
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v2, v4, v2
; GFX10-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX10-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX10-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX10-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX10-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX10-NEXT:    v_div_fixup_f32 v0, v1, v0, 0x4640e400
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_constlhs0_dynamic:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v1, null, v0, v0, 0x4640e400
; GFX11-NEXT:    v_div_scale_f32 v3, vcc_lo, 0x4640e400, v0, 0x4640e400
; GFX11-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 4, 2)
; GFX11-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v2, v4, v2
; GFX11-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX11-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX11-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX11-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX11-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s0
; GFX11-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX11-NEXT:    v_div_fixup_f32 v0, v1, v0, 0x4640e400
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_constlhs0_dynamic:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float 12345.0, %x
  ret float %div
}

define float @v_fdiv_f32_constlhs0_dynamic_25ulp(float %x) #2 {
; GFX6-LABEL: v_fdiv_f32_constlhs0_dynamic_25ulp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v1, v1
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v2, 0x4640e400
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v2, v0
; GFX6-NEXT:    v_mul_f32_e32 v1, 0x3f40e400, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_constlhs0_dynamic_25ulp:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX7-NEXT:    v_sub_i32_e32 v0, vcc, 14, v0
; GFX7-NEXT:    v_mul_f32_e32 v1, 0x3f40e400, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_constlhs0_dynamic_25ulp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, 14, v0
; GFX8-NEXT:    v_mul_f32_e32 v1, 0x3f40e400, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_constlhs0_dynamic_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, 14, v0
; GFX10-NEXT:    v_mul_f32_e32 v1, 0x3f40e400, v1
; GFX10-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_constlhs0_dynamic_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, 14, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v1, 0x3f40e400, v1
; GFX11-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_constlhs0_dynamic_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float 12345.0, %x, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_constlhs0_daz(float %x) #0 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_constlhs0_daz:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, s6
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v3, vcc, s6, v0, s6
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v1, v0, s6
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_constlhs0_daz:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, s6
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, vcc, s6, v0, s6
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v3, v1
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v1, v0, s6
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_constlhs0_daz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX7-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, s6
; GFX7-NEXT:    v_rcp_f32_e32 v2, v1
; GFX7-NEXT:    v_div_scale_f32 v3, vcc, s6, v0, s6
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX7-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX7-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX7-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX7-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX7-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX7-NEXT:    v_div_fixup_f32 v0, v1, v0, s6
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_constlhs0_daz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s6, 0x4640e400
; GFX8-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, s6
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, s6, v0, s6
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX8-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX8-NEXT:    v_div_fixup_f32 v0, v1, v0, s6
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_constlhs0_daz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v1, s4, v0, v0, 0x4640e400
; GFX10-NEXT:    v_div_scale_f32 v3, vcc_lo, 0x4640e400, v0, 0x4640e400
; GFX10-NEXT:    v_rcp_f32_e32 v2, v1
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v2, v4, v2
; GFX10-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX10-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX10-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX10-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX10-NEXT:    v_div_fixup_f32 v0, v1, v0, 0x4640e400
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_constlhs0_daz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v1, null, v0, v0, 0x4640e400
; GFX11-NEXT:    v_div_scale_f32 v3, vcc_lo, 0x4640e400, v0, 0x4640e400
; GFX11-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v2, v4, v2
; GFX11-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX11-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX11-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX11-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX11-NEXT:    v_div_fixup_f32 v0, v1, v0, 0x4640e400
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_constlhs0_daz:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float 12345.0, %x
  ret float %div
}

define float @v_fdiv_f32_constlhs0_daz_25ulp(float %x) #0 {
; GFX678-LABEL: v_fdiv_f32_constlhs0_daz_25ulp:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    s_mov_b32 s4, 0x6f800000
; GFX678-NEXT:    v_mov_b32_e32 v1, 0x2f800000
; GFX678-NEXT:    v_cmp_gt_f32_e64 vcc, |v0|, s4
; GFX678-NEXT:    v_cndmask_b32_e32 v1, 1.0, v1, vcc
; GFX678-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX678-NEXT:    v_rcp_f32_e32 v0, v0
; GFX678-NEXT:    v_mul_f32_e32 v0, 0x4640e400, v0
; GFX678-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_constlhs0_daz_25ulp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v0|
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 1.0, 0x2f800000, s4
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_rcp_f32_e32 v0, v0
; GFX10-NEXT:    v_mul_f32_e32 v0, 0x4640e400, v0
; GFX10-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_constlhs0_daz_25ulp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v0|
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 1.0, 0x2f800000, s0
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_rcp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, 0x4640e400, v0
; GFX11-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_constlhs0_daz_25ulp:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float 12345.0, %x, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_ieee_nodenorm_x(float nofpclass(sub) %x, float %y) #1 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_ieee_nodenorm_x:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_ieee_nodenorm_x:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_ieee_nodenorm_x:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_ieee_nodenorm_x:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_ieee_nodenorm_x:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_ieee_nodenorm_x:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_ieee_nodenorm_x:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y
  ret float %div
}

define float @v_fdiv_f32_ieee_25ulp_nodenorm_x(float nofpclass(sub) %x, float %y) #1 {
; GFX6-LABEL: v_fdiv_f32_ieee_25ulp_nodenorm_x:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v0, v3, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_ieee_25ulp_nodenorm_x:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX7-NEXT:    v_rcp_f32_e32 v2, v2
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v3, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_ieee_25ulp_nodenorm_x:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX8-NEXT:    v_rcp_f32_e32 v2, v2
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_ieee_25ulp_nodenorm_x:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_ieee_25ulp_nodenorm_x:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_ieee_25ulp_nodenorm_x:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_dynamic_nodenorm_x(float nofpclass(sub) %x, float %y) #2 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_dynamic_nodenorm_x:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_dynamic_nodenorm_x:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic_nodenorm_x:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic_nodenorm_x:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic_nodenorm_x:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic_nodenorm_x:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 4, 2)
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s0
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic_nodenorm_x:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y
  ret float %div
}

define float @v_fdiv_f32_dynamic_25ulp_nodenorm_x(float nofpclass(sub) %x, float %y) #2 {
; GFX6-LABEL: v_fdiv_f32_dynamic_25ulp_nodenorm_x:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v0, v3, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic_25ulp_nodenorm_x:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX7-NEXT:    v_rcp_f32_e32 v2, v2
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v3, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic_25ulp_nodenorm_x:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX8-NEXT:    v_rcp_f32_e32 v2, v2
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic_25ulp_nodenorm_x:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic_25ulp_nodenorm_x:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic_25ulp_nodenorm_x:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_daz_nodenorm_x(float nofpclass(sub) %x, float %y) #0 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_daz_nodenorm_x:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_daz_nodenorm_x:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_daz_nodenorm_x:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_daz_nodenorm_x:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_daz_nodenorm_x:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_daz_nodenorm_x:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_daz_nodenorm_x:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y
  ret float %div
}

define float @v_fdiv_f32_daz_25ulp_nodenorm_x(float nofpclass(sub) %x, float %y) #0 {
; GFX678-LABEL: v_fdiv_f32_daz_25ulp_nodenorm_x:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    s_mov_b32 s4, 0x6f800000
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x2f800000
; GFX678-NEXT:    v_cmp_gt_f32_e64 vcc, |v1|, s4
; GFX678-NEXT:    v_cndmask_b32_e32 v2, 1.0, v2, vcc
; GFX678-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX678-NEXT:    v_rcp_f32_e32 v1, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_daz_25ulp_nodenorm_x:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v1|
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s4
; GFX10-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_daz_25ulp_nodenorm_x:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v1|
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s0
; GFX11-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_daz_25ulp_nodenorm_x:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_ieee_nodenorm_y(float %x, float nofpclass(sub) %y) #1 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_ieee_nodenorm_y:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_ieee_nodenorm_y:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_ieee_nodenorm_y:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_ieee_nodenorm_y:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_ieee_nodenorm_y:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_ieee_nodenorm_y:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_ieee_nodenorm_y:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y
  ret float %div
}

define float @v_fdiv_f32_ieee_25ulp_nodenorm_y(float %x, float nofpclass(sub) %y) #1 {
; GFX6-LABEL: v_fdiv_f32_ieee_25ulp_nodenorm_y:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v0, v3, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_ieee_25ulp_nodenorm_y:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX7-NEXT:    v_rcp_f32_e32 v2, v2
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v3, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_ieee_25ulp_nodenorm_y:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX8-NEXT:    v_rcp_f32_e32 v2, v2
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_ieee_25ulp_nodenorm_y:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_ieee_25ulp_nodenorm_y:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_ieee_25ulp_nodenorm_y:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_dynamic_nodenorm_y(float %x, float nofpclass(sub) %y) #2 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_dynamic_nodenorm_y:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_dynamic_nodenorm_y:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic_nodenorm_y:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic_nodenorm_y:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic_nodenorm_y:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 4, 2)
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s4
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic_nodenorm_y:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 4, 2)
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 4, 2), s0
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic_nodenorm_y:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y
  ret float %div
}

define float @v_fdiv_f32_dynamic_25ulp_nodenorm_y(float %x, float nofpclass(sub) %y) #2 {
; GFX6-LABEL: v_fdiv_f32_dynamic_25ulp_nodenorm_y:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v0, v3, vcc
; GFX6-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_dynamic_25ulp_nodenorm_y:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX7-NEXT:    v_rcp_f32_e32 v2, v2
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX7-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX7-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_sub_i32_e32 v1, vcc, v3, v1
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_dynamic_25ulp_nodenorm_y:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX8-NEXT:    v_rcp_f32_e32 v2, v2
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_dynamic_25ulp_nodenorm_y:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX10-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX10-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_dynamic_25ulp_nodenorm_y:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_dynamic_25ulp_nodenorm_y:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y, !fpmath !0
  ret float %div
}

define float @v_fdiv_f32_daz_nodenorm_y(float %x, float nofpclass(sub) %y) #0 {
; GFX6-FASTFMA-LABEL: v_fdiv_f32_daz_nodenorm_y:
; GFX6-FASTFMA:       ; %bb.0:
; GFX6-FASTFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FASTFMA-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FASTFMA-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FASTFMA-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FASTFMA-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FASTFMA-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FASTFMA-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FASTFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FASTFMA-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FASTFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FASTFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-SLOWFMA-LABEL: v_fdiv_f32_daz_nodenorm_y:
; GFX6-SLOWFMA:       ; %bb.0:
; GFX6-SLOWFMA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-SLOWFMA-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX6-SLOWFMA-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-SLOWFMA-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-SLOWFMA-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX6-SLOWFMA-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-SLOWFMA-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-SLOWFMA-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-SLOWFMA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_fdiv_f32_daz_nodenorm_y:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX7-NEXT:    v_rcp_f32_e32 v3, v2
; GFX7-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX7-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX7-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX7-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX7-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX7-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX7-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX7-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX7-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX7-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_f32_daz_nodenorm_y:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX8-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX8-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX8-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX8-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX8-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX8-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX8-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX8-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX8-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX8-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_daz_nodenorm_y:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-NEXT:    s_denorm_mode 15
; GFX10-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-NEXT:    s_denorm_mode 12
; GFX10-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_daz_nodenorm_y:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-NEXT:    s_denorm_mode 15
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-NEXT:    s_denorm_mode 12
; GFX11-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_daz_nodenorm_y:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y
  ret float %div
}

define float @v_fdiv_f32_daz_25ulp_nodenorm_y(float %x, float nofpclass(sub) %y) #0 {
; GFX678-LABEL: v_fdiv_f32_daz_25ulp_nodenorm_y:
; GFX678:       ; %bb.0:
; GFX678-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX678-NEXT:    s_mov_b32 s4, 0x6f800000
; GFX678-NEXT:    v_mov_b32_e32 v2, 0x2f800000
; GFX678-NEXT:    v_cmp_gt_f32_e64 vcc, |v1|, s4
; GFX678-NEXT:    v_cndmask_b32_e32 v2, 1.0, v2, vcc
; GFX678-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX678-NEXT:    v_rcp_f32_e32 v1, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX678-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX678-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_daz_25ulp_nodenorm_y:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v1|
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s4
; GFX10-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_daz_25ulp_nodenorm_y:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v1|
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s0
; GFX11-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_fdiv_f32_daz_25ulp_nodenorm_y:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %div = fdiv float %x, %y, !fpmath !0
  ret float %div
}

attributes #0 = { "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
attributes #1 = { "denormal-fp-math-f32"="ieee,ieee" }
attributes #2 = { "denormal-fp-math-f32"="dynamic,dynamic" }

!0 = !{float 2.500000e+00}
