; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=arm-eabi -mattr=+vfp2 -global-isel=1 --verify-machineinstrs %s -o - | FileCheck %s

define i32 @func_get_fpenv() {
; CHECK-LABEL: func_get_fpenv:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmrs r0, fpscr
; CHECK-NEXT:    mov pc, lr
entry:
  %fpenv = call i32 @llvm.get.fpenv.i32()
  ret i32 %fpenv
}

define i32 @func_get_fpenv_soft() #0 {
; CHECK-LABEL: func_get_fpenv_soft:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, sp, #8
; CHECK-NEXT:    add r4, sp, #4
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    bl fegetenv
; CHECK-NEXT:    ldr r0, [r4]
; CHECK-NEXT:    add sp, sp, #8
; CHECK-NEXT:    pop {r4, lr}
; CHECK-NEXT:    mov pc, lr
entry:
  %fpenv = call i32 @llvm.get.fpenv.i32()
  ret i32 %fpenv
}

define void @func_set_fpenv(i32 %fpenv) {
; CHECK-LABEL: func_set_fpenv:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr fpscr, r0
; CHECK-NEXT:    mov pc, lr
entry:
  call void @llvm.set.fpenv.i32(i32 %fpenv)
  ret void
}

define void @func_set_fpenv_soft(i32 %fpenv) #0 {
; CHECK-LABEL: func_set_fpenv_soft:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, sp, #8
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    str r0, [r1]
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bl fesetenv
; CHECK-NEXT:    add sp, sp, #8
; CHECK-NEXT:    pop {r11, lr}
; CHECK-NEXT:    mov pc, lr
entry:
  call void @llvm.set.fpenv.i32(i32 %fpenv)
  ret void
}

define void @func_reset() {
; CHECK-LABEL: func_reset:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    mov r0, #0
; CHECK-NEXT:    vmsr fpscr, r0
; CHECK-NEXT:    mov pc, lr
entry:
  call void @llvm.reset.fpenv()
  ret void
}

define void @func_reset_soft() #0 {
; CHECK-LABEL: func_reset_soft:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    mvn r0, #0
; CHECK-NEXT:    bl fesetenv
; CHECK-NEXT:    pop {r11, lr}
; CHECK-NEXT:    mov pc, lr
entry:
  call void @llvm.reset.fpenv()
  ret void
}


define i32 @get_fpmode_soft() #0 {
; CHECK-LABEL: get_fpmode_soft:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, sp, #8
; CHECK-NEXT:    add r4, sp, #4
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    bl fegetmode
; CHECK-NEXT:    ldr r0, [r4]
; CHECK-NEXT:    add sp, sp, #8
; CHECK-NEXT:    pop {r4, lr}
; CHECK-NEXT:    mov pc, lr
entry:
  %fpenv = call i32 @llvm.get.fpmode.i32()
  ret i32 %fpenv
}

define i32 @get_fpmode() nounwind {
; CHECK-LABEL: get_fpmode:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmrs r0, fpscr
; CHECK-NEXT:    mov pc, lr
entry:
  %fpenv = call i32 @llvm.get.fpmode.i32()
  ret i32 %fpenv
}

define void @set_fpmode_soft(i32 %fpmode) #0 {
; CHECK-LABEL: set_fpmode_soft:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, sp, #8
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    str r0, [r1]
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bl fesetmode
; CHECK-NEXT:    add sp, sp, #8
; CHECK-NEXT:    pop {r11, lr}
; CHECK-NEXT:    mov pc, lr
entry:
  call void @llvm.set.fpmode.i32(i32 %fpmode)
  ret void
}

define void @set_fpmode(i32 %fpmode) nounwind {
; CHECK-LABEL: set_fpmode:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmrs r1, fpscr
; CHECK-NEXT:    mov r2, #159
; CHECK-NEXT:    orr r2, r2, #-134217728
; CHECK-NEXT:    and r1, r1, r2
; CHECK-NEXT:    mvn r2, #159
; CHECK-NEXT:    sub r2, r2, #-134217728
; CHECK-NEXT:    and r0, r0, r2
; CHECK-NEXT:    orr r0, r1, r0
; CHECK-NEXT:    vmsr fpscr, r0
; CHECK-NEXT:    mov pc, lr
entry:
  call void @llvm.set.fpmode.i32(i32 %fpmode)
  ret void
}

define void @reset_fpmode_soft() #0 {
; CHECK-LABEL: reset_fpmode_soft:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    mvn r0, #0
; CHECK-NEXT:    bl fesetmode
; CHECK-NEXT:    pop {r11, lr}
; CHECK-NEXT:    mov pc, lr
entry:
  call void @llvm.reset.fpmode()
  ret void
}

attributes #0 = { nounwind "use-soft-float"="true" }

