; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK,RV64

declare i8 @llvm.vector.reduce.add.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_add_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_add_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredsum.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.add.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_umax_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_umax_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vredmaxu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.umax.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_smax_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_smax_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vredmax.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.smax.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_umin_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_umin_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vredminu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.umin.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_smin_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_smin_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vredmin.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.smin.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_and_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_and_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vredand.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.and.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_or_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_or_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vredor.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.or.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_xor_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_xor_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredxor.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.xor.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_add_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_add_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredsum.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.add.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_umax_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_umax_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vredmaxu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.umax.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_smax_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_smax_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vredmax.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.smax.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_umin_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_umin_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vredminu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.umin.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_smin_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_smin_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vredmin.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.smin.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_and_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_and_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vredand.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.and.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_or_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_or_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vredor.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.or.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_xor_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_xor_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredxor.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.xor.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_add_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_add_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredsum.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.add.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_umax_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_umax_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vredmaxu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.umax.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_smax_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_smax_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vredmax.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.smax.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_umin_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_umin_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vredminu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.umin.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_smin_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_smin_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vredmin.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.smin.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_and_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_and_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vredand.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.and.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_or_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_or_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vredor.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.or.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_xor_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_xor_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredxor.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.xor.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_add_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_add_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredsum.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

define signext i16 @vwreduce_add_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vwreduce_add_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vwredsum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %e = sext <vscale x 1 x i8> %v to <vscale x 1 x i16>
  %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %e)
  ret i16 %red
}

define signext i16 @vwreduce_uadd_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vwreduce_uadd_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vwredsum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %e = sext <vscale x 1 x i8> %v to <vscale x 1 x i16>
  %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %e)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_umax_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_umax_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vredmaxu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.umax.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_smax_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_smax_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vredmax.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.smax.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_umin_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_umin_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vredminu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.umin.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_smin_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_smin_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vredmin.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.smin.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_and_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_and_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vredand.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.and.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_or_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_or_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vredor.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.or.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_xor_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_xor_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredxor.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.xor.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_add_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_add_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredsum.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

define signext i16 @vwreduce_add_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vwreduce_add_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vwredsum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %e = sext <vscale x 2 x i8> %v to <vscale x 2 x i16>
  %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %e)
  ret i16 %red
}

define signext i16 @vwreduce_uadd_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vwreduce_uadd_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vwredsum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %e = sext <vscale x 2 x i8> %v to <vscale x 2 x i16>
  %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %e)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_umax_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_umax_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vredmaxu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.umax.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_smax_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_smax_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vredmax.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.smax.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_umin_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_umin_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vredminu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.umin.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_smin_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_smin_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vredmin.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.smin.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_and_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_and_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vredand.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.and.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_or_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_or_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vredor.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.or.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_xor_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_xor_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredxor.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.xor.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_add_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_add_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredsum.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

define signext i16 @vwreduce_add_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vwreduce_add_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vwredsum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %e = sext <vscale x 4 x i8> %v to <vscale x 4 x i16>
  %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %e)
  ret i16 %red
}

define signext i16 @vwreduce_uadd_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vwreduce_uadd_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vwredsum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %e = sext <vscale x 4 x i8> %v to <vscale x 4 x i16>
  %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %e)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_umax_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_umax_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vredmaxu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.umax.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_smax_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_smax_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vredmax.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.smax.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_umin_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_umin_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vredminu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.umin.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_smin_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_smin_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vredmin.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.smin.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_and_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_and_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vredand.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.and.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_or_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_or_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vredor.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.or.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_xor_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_xor_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredxor.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.xor.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_add_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_add_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredsum.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

define signext i32 @vwreduce_add_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vwreduce_add_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vwredsum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %e = sext <vscale x 1 x i16> %v to <vscale x 1 x i32>
  %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %e)
  ret i32 %red
}

define signext i32 @vwreduce_uadd_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vwreduce_uadd_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vwredsumu.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %e = zext <vscale x 1 x i16> %v to <vscale x 1 x i32>
  %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %e)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_umax_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_umax_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vredmaxu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.umax.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_smax_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_smax_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vredmax.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.smax.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_umin_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_umin_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vredminu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.umin.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_smin_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_smin_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vredmin.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.smin.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_and_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_and_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vredand.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.and.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_or_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_or_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vredor.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.or.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_xor_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_xor_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredxor.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.xor.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_add_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_add_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredsum.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

define signext i32 @vwreduce_add_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vwreduce_add_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vwredsum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %e = sext <vscale x 2 x i16> %v to <vscale x 2 x i32>
  %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %e)
  ret i32 %red
}

define signext i32 @vwreduce_uadd_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vwreduce_uadd_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vwredsumu.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %e = zext <vscale x 2 x i16> %v to <vscale x 2 x i32>
  %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %e)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_umax_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_umax_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vredmaxu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.umax.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_smax_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_smax_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vredmax.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.smax.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_umin_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_umin_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vredminu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.umin.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_smin_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_smin_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vredmin.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.smin.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_and_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_and_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vredand.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.and.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_or_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_or_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vredor.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.or.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_xor_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_xor_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vredxor.vs v8, v8, v9
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.xor.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_add_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_add_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmv.s.x v10, zero
; CHECK-NEXT:    vredsum.vs v8, v8, v10
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

define signext i32 @vwreduce_add_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vwreduce_add_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vwredsum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %e = sext <vscale x 4 x i16> %v to <vscale x 4 x i32>
  %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %e)
  ret i32 %red
}

define signext i32 @vwreduce_uadd_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vwreduce_uadd_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v9, zero
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vwredsumu.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %e = zext <vscale x 4 x i16> %v to <vscale x 4 x i32>
  %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %e)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_umax_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_umax_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vredmaxu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.umax.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_smax_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_smax_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vredmax.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.smax.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_umin_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_umin_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vredminu.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.umin.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_smin_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_smin_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vredmin.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.smin.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_and_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_and_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vredand.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.and.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_or_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_or_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vredor.vs v8, v8, v8
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.or.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_xor_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_xor_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmv.s.x v10, zero
; CHECK-NEXT:    vredxor.vs v8, v8, v10
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.xor.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_add_nxv1i64(<vscale x 1 x i64> %v) {
; RV32-LABEL: vreduce_add_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32-NEXT:    vmv.s.x v9, zero
; RV32-NEXT:    vredsum.vs v8, v8, v9
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_add_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.s.x v9, zero
; RV64-NEXT:    vredsum.vs v8, v8, v9
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

define i64 @vwreduce_add_nxv1i32(<vscale x 1 x i32> %v) {
; RV32-LABEL: vwreduce_add_nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv.s.x v9, zero
; RV32-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; RV32-NEXT:    vwredsum.vs v8, v8, v9
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vwreduce_add_nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.s.x v9, zero
; RV64-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-NEXT:    vwredsum.vs v8, v8, v9
; RV64-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %e = sext <vscale x 1 x i32> %v to <vscale x 1 x i64>
  %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %e)
  ret i64 %red
}

define i64 @vwreduce_uadd_nxv1i32(<vscale x 1 x i32> %v) {
; RV32-LABEL: vwreduce_uadd_nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv.s.x v9, zero
; RV32-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; RV32-NEXT:    vwredsumu.vs v8, v8, v9
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vwreduce_uadd_nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.s.x v9, zero
; RV64-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-NEXT:    vwredsumu.vs v8, v8, v9
; RV64-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %e = zext <vscale x 1 x i32> %v to <vscale x 1 x i64>
  %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %e)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_umax_nxv1i64(<vscale x 1 x i64> %v) {
; RV32-LABEL: vreduce_umax_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32-NEXT:    vredmaxu.vs v8, v8, v8
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v9, v8, a0
; RV32-NEXT:    vmv.x.s a1, v9
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umax_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vredmaxu.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.umax.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_smax_nxv1i64(<vscale x 1 x i64> %v) {
; RV32-LABEL: vreduce_smax_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32-NEXT:    vredmax.vs v8, v8, v8
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v9, v8, a0
; RV32-NEXT:    vmv.x.s a1, v9
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smax_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vredmax.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.smax.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_umin_nxv1i64(<vscale x 1 x i64> %v) {
; RV32-LABEL: vreduce_umin_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32-NEXT:    vredminu.vs v8, v8, v8
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v9, v8, a0
; RV32-NEXT:    vmv.x.s a1, v9
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umin_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vredminu.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.umin.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_smin_nxv1i64(<vscale x 1 x i64> %v) {
; RV32-LABEL: vreduce_smin_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32-NEXT:    vredmin.vs v8, v8, v8
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v9, v8, a0
; RV32-NEXT:    vmv.x.s a1, v9
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vredmin.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.smin.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_and_nxv1i64(<vscale x 1 x i64> %v) {
; RV32-LABEL: vreduce_and_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32-NEXT:    vredand.vs v8, v8, v8
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v9, v8, a0
; RV32-NEXT:    vmv.x.s a1, v9
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_and_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vredand.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.and.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_or_nxv1i64(<vscale x 1 x i64> %v) {
; RV32-LABEL: vreduce_or_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32-NEXT:    vredor.vs v8, v8, v8
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v9, v8, a0
; RV32-NEXT:    vmv.x.s a1, v9
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_or_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vredor.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.or.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_xor_nxv1i64(<vscale x 1 x i64> %v) {
; RV32-LABEL: vreduce_xor_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32-NEXT:    vmv.s.x v9, zero
; RV32-NEXT:    vredxor.vs v8, v8, v9
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_xor_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.s.x v9, zero
; RV64-NEXT:    vredxor.vs v8, v8, v9
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.xor.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_add_nxv2i64(<vscale x 2 x i64> %v) {
; RV32-LABEL: vreduce_add_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32-NEXT:    vmv.s.x v10, zero
; RV32-NEXT:    vredsum.vs v8, v8, v10
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_add_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64-NEXT:    vmv.s.x v10, zero
; RV64-NEXT:    vredsum.vs v8, v8, v10
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

define i64 @vwreduce_add_nxv2i32(<vscale x 2 x i32> %v) {
; RV32-LABEL: vwreduce_add_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv.s.x v9, zero
; RV32-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; RV32-NEXT:    vwredsum.vs v8, v8, v9
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vwreduce_add_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.s.x v9, zero
; RV64-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; RV64-NEXT:    vwredsum.vs v8, v8, v9
; RV64-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %e = sext <vscale x 2 x i32> %v to <vscale x 2 x i64>
  %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %e)
  ret i64 %red
}

define i64 @vwreduce_uadd_nxv2i32(<vscale x 2 x i32> %v) {
; RV32-LABEL: vwreduce_uadd_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv.s.x v9, zero
; RV32-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; RV32-NEXT:    vwredsumu.vs v8, v8, v9
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vwreduce_uadd_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.s.x v9, zero
; RV64-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; RV64-NEXT:    vwredsumu.vs v8, v8, v9
; RV64-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %e = zext <vscale x 2 x i32> %v to <vscale x 2 x i64>
  %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %e)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_umax_nxv2i64(<vscale x 2 x i64> %v) {
; RV32-LABEL: vreduce_umax_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32-NEXT:    vredmaxu.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umax_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64-NEXT:    vredmaxu.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.umax.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_smax_nxv2i64(<vscale x 2 x i64> %v) {
; RV32-LABEL: vreduce_smax_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32-NEXT:    vredmax.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smax_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64-NEXT:    vredmax.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.smax.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_umin_nxv2i64(<vscale x 2 x i64> %v) {
; RV32-LABEL: vreduce_umin_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32-NEXT:    vredminu.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umin_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64-NEXT:    vredminu.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.umin.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_smin_nxv2i64(<vscale x 2 x i64> %v) {
; RV32-LABEL: vreduce_smin_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32-NEXT:    vredmin.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64-NEXT:    vredmin.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.smin.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_and_nxv2i64(<vscale x 2 x i64> %v) {
; RV32-LABEL: vreduce_and_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32-NEXT:    vredand.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_and_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64-NEXT:    vredand.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.and.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_or_nxv2i64(<vscale x 2 x i64> %v) {
; RV32-LABEL: vreduce_or_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32-NEXT:    vredor.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_or_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64-NEXT:    vredor.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.or.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_xor_nxv2i64(<vscale x 2 x i64> %v) {
; RV32-LABEL: vreduce_xor_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32-NEXT:    vmv.s.x v10, zero
; RV32-NEXT:    vredxor.vs v8, v8, v10
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_xor_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64-NEXT:    vmv.s.x v10, zero
; RV64-NEXT:    vredxor.vs v8, v8, v10
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.xor.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_add_nxv4i64(<vscale x 4 x i64> %v) {
; RV32-LABEL: vreduce_add_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32-NEXT:    vmv.s.x v12, zero
; RV32-NEXT:    vredsum.vs v8, v8, v12
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_add_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64-NEXT:    vmv.s.x v12, zero
; RV64-NEXT:    vredsum.vs v8, v8, v12
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

define i64 @vwreduce_add_nxv4i32(<vscale x 4 x i32> %v) {
; RV32-LABEL: vwreduce_add_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv.s.x v10, zero
; RV32-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; RV32-NEXT:    vwredsum.vs v8, v8, v10
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vwreduce_add_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.s.x v10, zero
; RV64-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; RV64-NEXT:    vwredsum.vs v8, v8, v10
; RV64-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %e = sext <vscale x 4 x i32> %v to <vscale x 4 x i64>
  %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %e)
  ret i64 %red
}

define i64 @vwreduce_uadd_nxv4i32(<vscale x 4 x i32> %v) {
; RV32-LABEL: vwreduce_uadd_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv.s.x v10, zero
; RV32-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; RV32-NEXT:    vwredsumu.vs v8, v8, v10
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vwreduce_uadd_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.s.x v10, zero
; RV64-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; RV64-NEXT:    vwredsumu.vs v8, v8, v10
; RV64-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %e = zext <vscale x 4 x i32> %v to <vscale x 4 x i64>
  %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %e)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_umax_nxv4i64(<vscale x 4 x i64> %v) {
; RV32-LABEL: vreduce_umax_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32-NEXT:    vredmaxu.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umax_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64-NEXT:    vredmaxu.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.umax.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_smax_nxv4i64(<vscale x 4 x i64> %v) {
; RV32-LABEL: vreduce_smax_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32-NEXT:    vredmax.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smax_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64-NEXT:    vredmax.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.smax.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_umin_nxv4i64(<vscale x 4 x i64> %v) {
; RV32-LABEL: vreduce_umin_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32-NEXT:    vredminu.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umin_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64-NEXT:    vredminu.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.umin.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_smin_nxv4i64(<vscale x 4 x i64> %v) {
; RV32-LABEL: vreduce_smin_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32-NEXT:    vredmin.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64-NEXT:    vredmin.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.smin.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_and_nxv4i64(<vscale x 4 x i64> %v) {
; RV32-LABEL: vreduce_and_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32-NEXT:    vredand.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_and_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64-NEXT:    vredand.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.and.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_or_nxv4i64(<vscale x 4 x i64> %v) {
; RV32-LABEL: vreduce_or_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32-NEXT:    vredor.vs v8, v8, v8
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_or_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64-NEXT:    vredor.vs v8, v8, v8
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.or.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_xor_nxv4i64(<vscale x 4 x i64> %v) {
; RV32-LABEL: vreduce_xor_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32-NEXT:    vmv.s.x v12, zero
; RV32-NEXT:    vredxor.vs v8, v8, v12
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_xor_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64-NEXT:    vmv.s.x v12, zero
; RV64-NEXT:    vredxor.vs v8, v8, v12
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.xor.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}
