; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512BW-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX512DQ-BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-BW-FCP

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i8_stride7_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i8_stride7_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa (%rdx), %xmm1
; SSE-NEXT:    movdqa (%r8), %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm0[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[3,1,0,3,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,6,6,6]
; SSE-NEXT:    packuswb %xmm3, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,0,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,2]
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    pextrw $6, %xmm2, %ecx
; SSE-NEXT:    movw %cx, 12(%rax)
; SSE-NEXT:    movq %xmm3, (%rax)
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,3,2,3]
; SSE-NEXT:    movd %xmm0, 8(%rax)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i8_stride7_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa (%rdx), %xmm1
; AVX-NEXT:    vmovdqa (%r8), %xmm2
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1,5,9,2,6,10,14,3,7,11,u,u]
; AVX-NEXT:    vpextrw $6, %xmm0, 12(%rax)
; AVX-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX-NEXT:    vmovq %xmm0, (%rax)
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i8_stride7_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1,5,9,2,6,10,14,3,7,11,u,u]
; AVX2-NEXT:    vpextrw $6, %xmm0, 12(%rax)
; AVX2-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX2-NEXT:    vmovq %xmm0, (%rax)
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i8_stride7_vf2:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FP-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-FP-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX2-FP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX2-FP-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FP-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1,5,9,2,6,10,14,3,7,11,u,u]
; AVX2-FP-NEXT:    vpextrw $6, %xmm0, 12(%rax)
; AVX2-FP-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX2-FP-NEXT:    vmovq %xmm0, (%rax)
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i8_stride7_vf2:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-FCP-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX2-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX2-FCP-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1,5,9,2,6,10,14,3,7,11,u,u]
; AVX2-FCP-NEXT:    vpextrw $6, %xmm0, 12(%rax)
; AVX2-FCP-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX2-FCP-NEXT:    vmovq %xmm0, (%rax)
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i8_stride7_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1,5,9,2,6,10,14,3,7,11,u,u]
; AVX512-NEXT:    vpextrw $6, %xmm0, 12(%rax)
; AVX512-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX512-NEXT:    vmovq %xmm0, (%rax)
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i8_stride7_vf2:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX512-FCP-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX512-FCP-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1,5,9,2,6,10,14,3,7,11,u,u]
; AVX512-FCP-NEXT:    vpextrw $6, %xmm0, 12(%rax)
; AVX512-FCP-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX512-FCP-NEXT:    vmovq %xmm0, (%rax)
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i8_stride7_vf2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX512DQ-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX512DQ-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1,5,9,2,6,10,14,3,7,11,u,u]
; AVX512DQ-NEXT:    vpextrw $6, %xmm0, 12(%rax)
; AVX512DQ-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX512DQ-NEXT:    vmovq %xmm0, (%rax)
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i8_stride7_vf2:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX512DQ-FCP-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512DQ-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX512DQ-FCP-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512DQ-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1,5,9,2,6,10,14,3,7,11,u,u]
; AVX512DQ-FCP-NEXT:    vpextrw $6, %xmm0, 12(%rax)
; AVX512DQ-FCP-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX512DQ-FCP-NEXT:    vmovq %xmm0, (%rax)
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i8_stride7_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vmovdqa (%r8), %xmm2
; AVX512BW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX512BW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512BW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1,5,9,2,6,10,14,3,7,11,u,u]
; AVX512BW-NEXT:    vpextrw $6, %xmm0, 12(%rax)
; AVX512BW-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX512BW-NEXT:    vmovq %xmm0, (%rax)
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i8_stride7_vf2:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512BW-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX512BW-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX512BW-FCP-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512BW-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX512BW-FCP-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1,5,9,2,6,10,14,3,7,11,u,u]
; AVX512BW-FCP-NEXT:    vpextrw $6, %xmm0, 12(%rax)
; AVX512BW-FCP-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX512BW-FCP-NEXT:    vmovq %xmm0, (%rax)
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i8_stride7_vf2:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-BW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX512DQ-BW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX512DQ-BW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512DQ-BW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX512DQ-BW-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512DQ-BW-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1,5,9,2,6,10,14,3,7,11,u,u]
; AVX512DQ-BW-NEXT:    vpextrw $6, %xmm0, 12(%rax)
; AVX512DQ-BW-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX512DQ-BW-NEXT:    vmovq %xmm0, (%rax)
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i8_stride7_vf2:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-BW-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX512DQ-BW-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX512DQ-BW-FCP-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512DQ-BW-FCP-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX512DQ-BW-FCP-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512DQ-BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1,5,9,2,6,10,14,3,7,11,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpextrw $6, %xmm0, 12(%rax)
; AVX512DQ-BW-FCP-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovq %xmm0, (%rax)
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <2 x i8>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i8>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i8>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i8>, ptr %in.vecptr3, align 64
  %in.vec4 = load <2 x i8>, ptr %in.vecptr4, align 64
  %in.vec5 = load <2 x i8>, ptr %in.vecptr5, align 64
  %in.vec6 = load <2 x i8>, ptr %in.vecptr6, align 64
  %1 = shufflevector <2 x i8> %in.vec0, <2 x i8> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i8> %in.vec2, <2 x i8> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <2 x i8> %in.vec4, <2 x i8> %in.vec5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = shufflevector <4 x i8> %1, <4 x i8> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = shufflevector <2 x i8> %in.vec6, <2 x i8> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %6 = shufflevector <4 x i8> %3, <4 x i8> %5, <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
  %7 = shufflevector <6 x i8> %6, <6 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 undef, i32 undef>
  %8 = shufflevector <8 x i8> %4, <8 x i8> %7, <14 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13>
  %interleaved.vec = shufflevector <14 x i8> %8, <14 x i8> poison, <14 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13>
  store <14 x i8> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i8_stride7_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i8_stride7_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa (%rdx), %xmm3
; SSE-NEXT:    movdqa (%r8), %xmm5
; SSE-NEXT:    movdqa (%r10), %xmm2
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],mem[0],xmm3[1],mem[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],mem[0],xmm5[1],mem[1]
; SSE-NEXT:    pxor %xmm7, %xmm7
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm7[0],xmm3[1],xmm7[1],xmm3[2],xmm7[2],xmm3[3],xmm7[3],xmm3[4],xmm7[4],xmm3[5],xmm7[5],xmm3[6],xmm7[6],xmm3[7],xmm7[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm1[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm1[0,1,0,2,4,5,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm6, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3],xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm8[0,2,0,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[2,1,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,4,6]
; SSE-NEXT:    packuswb %xmm8, %xmm6
; SSE-NEXT:    pand %xmm1, %xmm6
; SSE-NEXT:    por %xmm4, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; SSE-NEXT:    pand %xmm4, %xmm6
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm7[0],xmm5[1],xmm7[1],xmm5[2],xmm7[2],xmm5[3],xmm7[3],xmm5[4],xmm7[4],xmm5[5],xmm7[5],xmm5[6],xmm7[6],xmm5[7],xmm7[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm5[0,0,2,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm5[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,6,4,6,7]
; SSE-NEXT:    packuswb %xmm7, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255]
; SSE-NEXT:    pand %xmm7, %xmm8
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm2[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[0,0,0,0]
; SSE-NEXT:    pandn %xmm9, %xmm7
; SSE-NEXT:    por %xmm8, %xmm7
; SSE-NEXT:    pandn %xmm7, %xmm4
; SSE-NEXT:    por %xmm6, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[0,3,1,3,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,2,0,4,5,6,7]
; SSE-NEXT:    packuswb %xmm6, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[3,1,2,1]
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[2,0,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm3, %xmm6
; SSE-NEXT:    pand %xmm1, %xmm6
; SSE-NEXT:    pandn %xmm5, %xmm1
; SSE-NEXT:    por %xmm6, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255,0,0,0,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,3,1,4,5,6,7]
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm5
; SSE-NEXT:    por %xmm0, %xmm5
; SSE-NEXT:    pandn %xmm5, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movq %xmm3, 16(%rax)
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,3,2,3]
; SSE-NEXT:    movd %xmm0, 24(%rax)
; SSE-NEXT:    movdqa %xmm4, (%rax)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i8_stride7_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa (%rdx), %xmm1
; AVX-NEXT:    vmovdqa (%r8), %xmm2
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[0,4,8,12],zero,zero,zero,xmm0[1,5,9,13],zero,zero,zero,xmm0[2,6]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[0,4,8],zero,zero,zero,zero,xmm1[1,5,9],zero,zero
; AVX-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[10,14],zero,zero,zero,xmm0[3,7,11,15],zero,zero,zero,xmm0[u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[2,6,10],zero,zero,zero,zero,xmm1[3,7,11,u,u,u,u]
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpextrd $2, %xmm0, 24(%rax)
; AVX-NEXT:    vmovq %xmm0, 16(%rax)
; AVX-NEXT:    vmovdqa %xmm2, (%rax)
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i8_stride7_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-NEXT:    vmovdqa (%rdx), %xmm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX2-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX2-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,zero,ymm0[1,5,9,13],zero,zero,zero,ymm0[2,6],zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27],zero,zero,zero,zero
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,ymm0[26,30],zero,zero,zero,ymm0[19,23,27,31],zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX2-NEXT:    vmovq %xmm1, 16(%rax)
; AVX2-NEXT:    vmovdqa %xmm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i8_stride7_vf4:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX2-FP-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX2-FP-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX2-FP-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX2-FP-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-FP-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX2-FP-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,zero,ymm0[1,5,9,13],zero,zero,zero,ymm0[2,6],zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27],zero,zero,zero,zero
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,ymm0[26,30],zero,zero,zero,ymm0[19,23,27,31],zero,zero,zero,zero,zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FP-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX2-FP-NEXT:    vmovq %xmm1, 16(%rax)
; AVX2-FP-NEXT:    vmovdqa %xmm0, (%rax)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i8_stride7_vf4:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX2-FCP-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX2-FCP-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-FCP-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX2-FCP-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,zero,ymm0[1,5,9,13],zero,zero,zero,ymm0[2,6],zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27],zero,zero,zero,zero
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,ymm0[26,30],zero,zero,zero,ymm0[19,23,27,31],zero,zero,zero,zero,zero,zero,zero
; AVX2-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FCP-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX2-FCP-NEXT:    vmovq %xmm1, 16(%rax)
; AVX2-FCP-NEXT:    vmovdqa %xmm0, (%rax)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i8_stride7_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX512-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX512-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,zero,ymm0[1,5,9,13],zero,zero,zero,ymm0[2,6],zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27,u,u,u,u]
; AVX512-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,ymm0[26,30],zero,zero,zero,ymm0[19,23,27,31],zero,zero,zero,zero,zero,zero,zero
; AVX512-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX512-NEXT:    vmovq %xmm1, 16(%rax)
; AVX512-NEXT:    vmovdqa %xmm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i8_stride7_vf4:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512-FCP-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX512-FCP-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX512-FCP-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX512-FCP-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512-FCP-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,zero,ymm0[1,5,9,13],zero,zero,zero,ymm0[2,6],zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27,u,u,u,u]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,ymm0[26,30],zero,zero,zero,ymm0[19,23,27,31],zero,zero,zero,zero,zero,zero,zero
; AVX512-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512-FCP-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX512-FCP-NEXT:    vmovq %xmm1, 16(%rax)
; AVX512-FCP-NEXT:    vmovdqa %xmm0, (%rax)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i8_stride7_vf4:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQ-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX512DQ-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX512DQ-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX512DQ-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512DQ-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,zero,ymm0[1,5,9,13],zero,zero,zero,ymm0[2,6],zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27,u,u,u,u]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,ymm0[26,30],zero,zero,zero,ymm0[19,23,27,31],zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512DQ-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX512DQ-NEXT:    vmovq %xmm1, 16(%rax)
; AVX512DQ-NEXT:    vmovdqa %xmm0, (%rax)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i8_stride7_vf4:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQ-FCP-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,zero,ymm0[1,5,9,13],zero,zero,zero,ymm0[2,6],zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,ymm0[26,30],zero,zero,zero,ymm0[19,23,27,31],zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512DQ-FCP-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX512DQ-FCP-NEXT:    vmovq %xmm1, 16(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm0, (%rax)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i8_stride7_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX512BW-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX512BW-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512BW-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,zero,ymm0[1,5,9,13],zero,zero,zero,ymm0[2,6],zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27],zero,zero,zero,zero
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,ymm0[26,30],zero,zero,zero,ymm0[19,23,27,31],zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX512BW-NEXT:    vmovq %xmm1, 16(%rax)
; AVX512BW-NEXT:    vmovdqa %xmm0, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i8_stride7_vf4:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512BW-FCP-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX512BW-FCP-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,zero,ymm0[1,5,9,13],zero,zero,zero,ymm0[2,6],zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27],zero,zero,zero,zero
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,ymm0[26,30],zero,zero,zero,ymm0[19,23,27,31],zero,zero,zero,zero,zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-FCP-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX512BW-FCP-NEXT:    vmovq %xmm1, 16(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa %xmm0, (%rax)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i8_stride7_vf4:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQ-BW-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX512DQ-BW-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,zero,ymm0[1,5,9,13],zero,zero,zero,ymm0[2,6],zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27],zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,ymm0[26,30],zero,zero,zero,ymm0[19,23,27,31],zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512DQ-BW-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX512DQ-BW-NEXT:    vmovq %xmm1, 16(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa %xmm0, (%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i8_stride7_vf4:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQ-BW-FCP-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,zero,ymm0[1,5,9,13],zero,zero,zero,ymm0[2,6],zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27],zero,zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,ymm0[26,30],zero,zero,zero,ymm0[19,23,27,31],zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512DQ-BW-FCP-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovq %xmm1, 16(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm0, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <4 x i8>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i8>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i8>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i8>, ptr %in.vecptr3, align 64
  %in.vec4 = load <4 x i8>, ptr %in.vecptr4, align 64
  %in.vec5 = load <4 x i8>, ptr %in.vecptr5, align 64
  %in.vec6 = load <4 x i8>, ptr %in.vecptr6, align 64
  %1 = shufflevector <4 x i8> %in.vec0, <4 x i8> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i8> %in.vec2, <4 x i8> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <4 x i8> %in.vec4, <4 x i8> %in.vec5, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = shufflevector <8 x i8> %1, <8 x i8> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %5 = shufflevector <4 x i8> %in.vec6, <4 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <8 x i8> %3, <8 x i8> %5, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
  %7 = shufflevector <12 x i8> %6, <12 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <16 x i8> %4, <16 x i8> %7, <28 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27>
  %interleaved.vec = shufflevector <28 x i8> %8, <28 x i8> poison, <28 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27>
  store <28 x i8> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i8_stride7_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i8_stride7_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{.*#+}} xmm3 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm10 = mem[0],zero
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movq {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm4 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm14 = mem[0],zero
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm5 = mem[0],zero
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm0[0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[0,0,0,0,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm4, %xmm7
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm4[0],xmm7[1],xmm4[1],xmm7[2],xmm4[2],xmm7[3],xmm4[3],xmm7[4],xmm4[4],xmm7[5],xmm4[5],xmm7[6],xmm4[6],xmm7[7],xmm4[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm7[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,1,1,3]
; SSE-NEXT:    pandn %xmm8, %xmm6
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm3[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm10[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[0,1,1,0]
; SSE-NEXT:    movdqa %xmm8, %xmm12
; SSE-NEXT:    pandn %xmm11, %xmm12
; SSE-NEXT:    por %xmm0, %xmm12
; SSE-NEXT:    pand %xmm9, %xmm12
; SSE-NEXT:    pandn %xmm6, %xmm9
; SSE-NEXT:    por %xmm12, %xmm9
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm5, %xmm12
; SSE-NEXT:    movdqa %xmm5, %xmm15
; SSE-NEXT:    punpckhbw {{.*#+}} xmm15 = xmm15[8],xmm0[8],xmm15[9],xmm0[9],xmm15[10],xmm0[10],xmm15[11],xmm0[11],xmm15[12],xmm0[12],xmm15[13],xmm0[13],xmm15[14],xmm0[14],xmm15[15],xmm0[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm0[0],xmm12[1],xmm0[1],xmm12[2],xmm0[2],xmm12[3],xmm0[3],xmm12[4],xmm0[4],xmm12[5],xmm0[5],xmm12[6],xmm0[6],xmm12[7],xmm0[7]
; SSE-NEXT:    movdqa %xmm12, %xmm13
; SSE-NEXT:    punpcklwd {{.*#+}} xmm13 = xmm13[0],xmm15[0],xmm13[1],xmm15[1],xmm13[2],xmm15[2],xmm13[3],xmm15[3]
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa %xmm13, %xmm6
; SSE-NEXT:    packuswb %xmm0, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm14[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    movdqa %xmm11, %xmm14
; SSE-NEXT:    pandn %xmm0, %xmm14
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,3]
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    por %xmm0, %xmm14
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; SSE-NEXT:    pand %xmm6, %xmm9
; SSE-NEXT:    pandn %xmm14, %xmm6
; SSE-NEXT:    por %xmm9, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[2,2,3,3]
; SSE-NEXT:    movdqa %xmm11, %xmm9
; SSE-NEXT:    pandn %xmm0, %xmm9
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[2,1,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    por %xmm9, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; SSE-NEXT:    movdqa %xmm1, %xmm9
; SSE-NEXT:    pandn %xmm0, %xmm9
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm10[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm0, %xmm14
; SSE-NEXT:    pandn %xmm2, %xmm14
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,1,3]
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    por %xmm2, %xmm14
; SSE-NEXT:    pand %xmm1, %xmm14
; SSE-NEXT:    por %xmm9, %xmm14
; SSE-NEXT:    movdqa %xmm15, %xmm2
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm12[4],xmm2[5],xmm12[5],xmm2[6],xmm12[6],xmm2[7],xmm12[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm12 = xmm12[4],xmm15[4],xmm12[5],xmm15[5],xmm12[6],xmm15[6],xmm12[7],xmm15[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm12[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[0,1,2,1]
; SSE-NEXT:    packuswb %xmm2, %xmm9
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm12, %xmm9
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm15[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    pandn %xmm2, %xmm12
; SSE-NEXT:    por %xmm9, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,0,0,0,0,255,255,255,0,0,0,0,255,255]
; SSE-NEXT:    pand %xmm2, %xmm12
; SSE-NEXT:    pandn %xmm14, %xmm2
; SSE-NEXT:    por %xmm2, %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm13[2,2,3,3]
; SSE-NEXT:    psrldq {{.*#+}} xmm13 = xmm13[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    packuswb %xmm13, %xmm2
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm15[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[0,0,0,0]
; SSE-NEXT:    pandn %xmm9, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[0,1,2,2]
; SSE-NEXT:    movdqa %xmm3, %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm3[1,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[0,0,2,1]
; SSE-NEXT:    pand %xmm11, %xmm9
; SSE-NEXT:    pandn %xmm2, %xmm11
; SSE-NEXT:    por %xmm9, %xmm11
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[1,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,7,5,6,4]
; SSE-NEXT:    pandn %xmm7, %xmm8
; SSE-NEXT:    por %xmm2, %xmm8
; SSE-NEXT:    pand %xmm1, %xmm8
; SSE-NEXT:    pandn %xmm11, %xmm1
; SSE-NEXT:    por %xmm8, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3],xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm4[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm10[0],xmm4[1],xmm10[1],xmm4[2],xmm10[2],xmm4[3],xmm10[3],xmm4[4],xmm10[4],xmm4[5],xmm10[5],xmm4[6],xmm10[6],xmm4[7],xmm10[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,2,2,2]
; SSE-NEXT:    pand %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[3,1,2,3]
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm15[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,3,1,4,5,6,7]
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [0,255,255,255,255,0,0,0,255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq %xmm2, 48(%rax)
; SSE-NEXT:    movdqa %xmm1, 16(%rax)
; SSE-NEXT:    movdqa %xmm12, 32(%rax)
; SSE-NEXT:    movdqa %xmm6, (%rax)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i8_stride7_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,u],zero,zero,xmm2[5,13,u,u,u],zero,zero,xmm2[6,14,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm1[u,u,u,5,13],zero,zero,xmm1[u,u,u,6,14],zero,zero,xmm1[u,u]
; AVX-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[4,12],zero,xmm0[u,u,u,u,5,13],zero,xmm0[u,u,u,u,6,14]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm3[4,u,u,u,u],zero,zero,xmm3[5,u,u,u,u],zero,zero
; AVX-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX-NEXT:    vmovdqa {{.*#+}} xmm6 = [255,255,255,0,0,0,0,255,255,255,0,0,0,0,255,255]
; AVX-NEXT:    vpblendvb %xmm6, %xmm5, %xmm4, %xmm4
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[u],zero,zero,xmm2[7,15,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[u,7,15],zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = zero,xmm0[u,u,u,u,7,15],zero,xmm0[u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = xmm3[6,u,u,u,u],zero,zero,xmm3[7,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX-NEXT:    vmovq {{.*#+}} xmm7 = [0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpblendvb %xmm7, %xmm5, %xmm6, %xmm5
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm2[0,8,u,u,u],zero,zero,xmm2[1,9,u,u,u],zero,zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = xmm1[0,8],zero,zero,xmm1[u,u,u,1,9],zero,zero,xmm1[u,u,u,2,10]
; AVX-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[u,u,u,u,0,8],zero,xmm0[u,u,u,u,1,9],zero,xmm0[u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm8 = xmm3[u,u,u,u],zero,zero,xmm3[0,u,u,u,u],zero,zero,xmm3[1,u,u]
; AVX-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX-NEXT:    vmovdqa {{.*#+}} xmm8 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; AVX-NEXT:    vpblendvb %xmm8, %xmm6, %xmm7, %xmm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[u,u,u,3,11],zero,zero,xmm1[u,u,u,4,12],zero,zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[2,10,u,u,u],zero,zero,xmm2[3,11,u,u,u],zero,zero,xmm2[4,12]
; AVX-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,2,10],zero,xmm0[u,u,u,u,3,11],zero,xmm0[u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm3[u,u],zero,zero,xmm3[2,u,u,u,u],zero,zero,xmm3[3,u,u,u,u]
; AVX-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa {{.*#+}} xmm2 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa %xmm0, 16(%rax)
; AVX-NEXT:    vmovdqa %xmm6, (%rax)
; AVX-NEXT:    vmovq %xmm5, 48(%rax)
; AVX-NEXT:    vmovdqa %xmm4, 32(%rax)
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i8_stride7_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX2-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,ymm2[5,13],zero,zero,zero,zero,zero,ymm2[6,14],zero,zero,zero,zero,zero,zero,zero,ymm2[23,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[2,3,0,1]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,ymm4[5,13],zero,zero,zero,zero,zero,ymm4[6,14],zero,zero,zero,ymm4[23,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vpor %ymm5, %ymm3, %ymm3
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,0,2]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,ymm0[4],zero,zero,zero,zero,zero,zero,ymm0[5],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm0[23,31],zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} ymm6 = ymm1[4,12],zero,zero,zero,zero,zero,ymm1[5,13],zero,zero,zero,zero,zero,ymm1[6,14,22],zero,zero,zero,zero,zero,zero,ymm1[23],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vpor %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpblendvb %ymm6, %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[0,8],zero,zero,zero,zero,zero,ymm2[1,9],zero,zero,zero,zero,zero,ymm2[2,10,18,26],zero,zero,zero,zero,zero,ymm2[19,27],zero,zero,zero,zero,zero,ymm2[20,28]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,ymm4[0,8],zero,zero,zero,zero,zero,ymm4[1,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm4[19,27],zero,zero,zero,zero,zero,ymm4[20,28],zero,zero
; AVX2-NEXT:    vpor %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,ymm0[0],zero,zero,zero,zero,zero,zero,ymm0[1],zero,zero,zero,zero,ymm0[18,26],zero,zero,zero,zero,zero,ymm0[19,27],zero,zero,zero,zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,zero,zero,ymm1[0,8],zero,zero,zero,zero,zero,ymm1[1,9],zero,zero,zero,zero,zero,zero,zero,ymm1[18],zero,zero,zero,zero,zero,zero,ymm1[19],zero,zero,zero,zero
; AVX2-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX2-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-NEXT:    vextracti128 $1, %ymm3, %xmm0
; AVX2-NEXT:    vmovq %xmm0, 48(%rax)
; AVX2-NEXT:    vmovdqa %xmm3, 32(%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i8_stride7_vf8:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX2-FP-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FP-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[0,2,1,3]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,ymm2[5,13],zero,zero,zero,zero,zero,ymm2[6,14],zero,zero,zero,zero,zero,zero,zero,ymm2[23,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[2,3,0,1]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,ymm4[5,13],zero,zero,zero,zero,zero,ymm4[6,14],zero,zero,zero,ymm4[23,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm5, %ymm3, %ymm3
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,0,2]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,ymm0[4],zero,zero,zero,zero,zero,zero,ymm0[5],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm0[23,31],zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm6 = ymm1[4,12],zero,zero,zero,zero,zero,ymm1[5,13],zero,zero,zero,zero,zero,ymm1[6,14,22],zero,zero,zero,zero,zero,zero,ymm1[23],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm5, %ymm6, %ymm5
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm6, %ymm3, %ymm5, %ymm3
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[0,8],zero,zero,zero,zero,zero,ymm2[1,9],zero,zero,zero,zero,zero,ymm2[2,10,18,26],zero,zero,zero,zero,zero,ymm2[19,27],zero,zero,zero,zero,zero,ymm2[20,28]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,ymm4[0,8],zero,zero,zero,zero,zero,ymm4[1,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm4[19,27],zero,zero,zero,zero,zero,ymm4[20,28],zero,zero
; AVX2-FP-NEXT:    vpor %ymm4, %ymm2, %ymm2
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,ymm0[0],zero,zero,zero,zero,zero,zero,ymm0[1],zero,zero,zero,zero,ymm0[18,26],zero,zero,zero,zero,zero,ymm0[19,27],zero,zero,zero,zero,zero
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,zero,zero,ymm1[0,8],zero,zero,zero,zero,zero,ymm1[1,9],zero,zero,zero,zero,zero,zero,zero,ymm1[18],zero,zero,zero,zero,zero,zero,ymm1[19],zero,zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm1 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-FP-NEXT:    vextracti128 $1, %ymm3, %xmm0
; AVX2-FP-NEXT:    vmovq %xmm0, 48(%rax)
; AVX2-FP-NEXT:    vmovdqa %xmm3, 32(%rax)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i8_stride7_vf8:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX2-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [1,3,5,7,1,3,5,7]
; AVX2-FCP-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermd %ymm2, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,zero,ymm1[1,5,9,13],zero,zero,zero,ymm1[2,6,10,14],zero,zero,zero,ymm1[19,23,27,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [1,3,5,0,5,1,3,0]
; AVX2-FCP-NEXT:    vpermd %ymm0, %ymm3, %ymm3
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[0,4,8],zero,zero,zero,zero,ymm3[1,5,9],zero,zero,zero,zero,ymm3[2,6,18],zero,zero,zero,zero,ymm3[23,27,19],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FCP-NEXT:    vpor %ymm3, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm2[0,8],zero,zero,zero,zero,zero,ymm2[1,9],zero,zero,zero,zero,zero,ymm2[2,10,18,26],zero,zero,zero,zero,zero,ymm2[19,27],zero,zero,zero,zero,zero,ymm2[20,28]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,0,1]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,ymm2[0,8],zero,zero,zero,zero,zero,ymm2[1,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[19,27],zero,zero,zero,zero,zero,ymm2[20,28],zero,zero
; AVX2-FCP-NEXT:    vpor %ymm2, %ymm3, %ymm2
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,2,4,6,0,2,4,6]
; AVX2-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermd %ymm0, %ymm3, %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,0,4,8,u,u,u,u,1,5,9,u,u,u,u,18,22,26,u,u,u,u,19,23,27,u,u,u,u]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX2-FCP-NEXT:    vmovq %xmm0, 48(%rax)
; AVX2-FCP-NEXT:    vmovdqa %xmm1, 32(%rax)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i8_stride7_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX512-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[0,2,1,3]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm3 = ymm2[0,8],zero,zero,ymm2[u,u,u,1,9],zero,zero,ymm2[u,u,u,2,10,18,26,u,u,u],zero,zero,ymm2[19,27,u,u,u],zero,zero,ymm2[20,28]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm4 = ymm2[u,u,u,5,13],zero,zero,ymm2[u,u,u,6,14],zero,zero,ymm2[u,u,u],zero,zero,ymm2[23,31,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm3
; AVX512-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,0,1]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,ymm2[0,8,u,u,u],zero,zero,ymm2[1,9,u,u,u],zero,zero,zero,zero,ymm2[u,u,u,19,27],zero,zero,ymm2[u,u,u,20,28],zero,zero
; AVX512-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u],zero,zero,ymm2[5,13,u,u,u],zero,zero,ymm2[6,14,u,u,u,23,31],zero,zero,ymm2[u,u,u],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512-NEXT:    vinserti64x4 $1, %ymm2, %zmm4, %zmm2
; AVX512-NEXT:    vporq %zmm2, %zmm3, %zmm2
; AVX512-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,0,2]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm3 = ymm0[u,u,u,u],zero,zero,ymm0[0,u,u,u,u],zero,zero,ymm0[1,u,u,u,u,18,26],zero,ymm0[u,u,u,u,19,27],zero,ymm0[u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,ymm0[4,u,u,u,u],zero,zero,ymm0[5,u,u,u,u],zero,zero,zero,ymm0[u,u,u,u,23,31],zero,ymm0[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm0
; AVX512-NEXT:    vpshufb {{.*#+}} ymm3 = ymm1[u,u,u,u,0,8],zero,ymm1[u,u,u,u,1,9],zero,ymm1[u,u,u,u],zero,zero,ymm1[18,u,u,u,u],zero,zero,ymm1[19,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[4,12],zero,ymm1[u,u,u,u,5,13],zero,ymm1[u,u,u,u,6,14,22,u,u,u,u],zero,zero,ymm1[23,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm1
; AVX512-NEXT:    vporq %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm0
; AVX512-NEXT:    vextracti32x4 $2, %zmm0, 32(%rax)
; AVX512-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512-NEXT:    vmovq %xmm1, 48(%rax)
; AVX512-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i8_stride7_vf8:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,2,4,0]
; AVX512-FCP-NEXT:    vpermi2q %ymm3, %ymm0, %ymm1
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [0,2,4,6,0,2,4,6]
; AVX512-FCP-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpermd %ymm1, %ymm0, %ymm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27],zero,zero,zero,zero
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [1,3,5,0,5,1,3,0]
; AVX512-FCP-NEXT:    vpermd %ymm1, %ymm3, %ymm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,4,8],zero,zero,zero,zero,ymm1[1,5,9],zero,zero,zero,zero,ymm1[2,6,18],zero,zero,zero,zero,ymm1[23,27,19],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[0,8],zero,zero,ymm2[u,u,u,1,9],zero,zero,ymm2[u,u,u,2,10,18,26,u,u,u],zero,zero,ymm2[19,27,u,u,u],zero,zero,ymm2[20,28]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm2[2,3,0,1]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,ymm3[0,8,u,u,u],zero,zero,ymm3[1,9,u,u,u],zero,zero,zero,zero,ymm3[u,u,u,19,27],zero,zero,ymm3[u,u,u,20,28],zero,zero
; AVX512-FCP-NEXT:    vpternlogq $168, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm3
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [1,3,5,7,1,3,5,7]
; AVX512-FCP-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpermd %ymm2, %ymm1, %ymm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,zero,ymm1[1,5,9,13],zero,zero,zero,ymm1[2,6,10,14],zero,zero,zero,ymm1[19,23,27,31],zero,zero,zero,ymm1[u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm1
; AVX512-FCP-NEXT:    vporq %zmm0, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vextracti32x4 $2, %zmm0, 32(%rax)
; AVX512-FCP-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512-FCP-NEXT:    vmovq %xmm1, 48(%rax)
; AVX512-FCP-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i8_stride7_vf8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[0,2,1,3]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm3 = ymm2[0,8],zero,zero,ymm2[u,u,u,1,9],zero,zero,ymm2[u,u,u,2,10,18,26,u,u,u],zero,zero,ymm2[19,27,u,u,u],zero,zero,ymm2[20,28]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm4 = ymm2[u,u,u,5,13],zero,zero,ymm2[u,u,u,6,14],zero,zero,ymm2[u,u,u],zero,zero,ymm2[23,31,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm3
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,0,1]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,ymm2[0,8,u,u,u],zero,zero,ymm2[1,9,u,u,u],zero,zero,zero,zero,ymm2[u,u,u,19,27],zero,zero,ymm2[u,u,u,20,28],zero,zero
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u],zero,zero,ymm2[5,13,u,u,u],zero,zero,ymm2[6,14,u,u,u,23,31],zero,zero,ymm2[u,u,u],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm4, %zmm2
; AVX512DQ-NEXT:    vporq %zmm2, %zmm3, %zmm2
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,0,2]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm3 = ymm0[u,u,u,u],zero,zero,ymm0[0,u,u,u,u],zero,zero,ymm0[1,u,u,u,u,18,26],zero,ymm0[u,u,u,u,19,27],zero,ymm0[u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,ymm0[4,u,u,u,u],zero,zero,ymm0[5,u,u,u,u],zero,zero,zero,ymm0[u,u,u,u,23,31],zero,ymm0[u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm0
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm3 = ymm1[u,u,u,u,0,8],zero,ymm1[u,u,u,u,1,9],zero,ymm1[u,u,u,u],zero,zero,ymm1[18,u,u,u,u],zero,zero,ymm1[19,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[4,12],zero,ymm1[u,u,u,u,5,13],zero,ymm1[u,u,u,u,6,14,22,u,u,u,u],zero,zero,ymm1[23,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm1
; AVX512DQ-NEXT:    vporq %zmm0, %zmm1, %zmm0
; AVX512DQ-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm0
; AVX512DQ-NEXT:    vextracti32x4 $2, %zmm0, 32(%rax)
; AVX512DQ-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512DQ-NEXT:    vmovq %xmm1, 48(%rax)
; AVX512DQ-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i8_stride7_vf8:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,2,4,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %ymm3, %ymm0, %ymm1
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [0,2,4,6,0,2,4,6]
; AVX512DQ-FCP-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpermd %ymm1, %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4,8],zero,zero,zero,zero,ymm0[1,5,9],zero,zero,zero,zero,ymm0[18,22,26],zero,zero,zero,zero,ymm0[19,23,27],zero,zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [1,3,5,0,5,1,3,0]
; AVX512DQ-FCP-NEXT:    vpermd %ymm1, %ymm3, %ymm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,4,8],zero,zero,zero,zero,ymm1[1,5,9],zero,zero,zero,zero,ymm1[2,6,18],zero,zero,zero,zero,ymm1[23,27,19],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[0,8],zero,zero,ymm2[u,u,u,1,9],zero,zero,ymm2[u,u,u,2,10,18,26,u,u,u],zero,zero,ymm2[19,27,u,u,u],zero,zero,ymm2[20,28]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm2[2,3,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,ymm3[0,8,u,u,u],zero,zero,ymm3[1,9,u,u,u],zero,zero,zero,zero,ymm3[u,u,u,19,27],zero,zero,ymm3[u,u,u,20,28],zero,zero
; AVX512DQ-FCP-NEXT:    vpternlogq $168, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm3
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [1,3,5,7,1,3,5,7]
; AVX512DQ-FCP-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpermd %ymm2, %ymm1, %ymm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,zero,ymm1[1,5,9,13],zero,zero,zero,ymm1[2,6,10,14],zero,zero,zero,ymm1[19,23,27,31],zero,zero,zero,ymm1[u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm1
; AVX512DQ-FCP-NEXT:    vporq %zmm0, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vextracti32x4 $2, %zmm0, 32(%rax)
; AVX512DQ-FCP-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512DQ-FCP-NEXT:    vmovq %xmm1, 48(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i8_stride7_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm0[0,2,1,3,4,6,5,7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} zmm1 = zero,zero,zero,zero,zmm1[0,8],zero,zero,zero,zero,zero,zmm1[1,9],zero,zero,zero,zero,zero,zero,zero,zmm1[18],zero,zero,zero,zero,zero,zero,zmm1[19],zero,zero,zero,zero,zmm1[36,44],zero,zero,zero,zero,zero,zmm1[37,45],zero,zero,zero,zero,zero,zmm1[38,46,54],zero,zero,zero,zero,zero,zero,zmm1[55],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[1,3,0,2,5,7,4,6]
; AVX512BW-NEXT:    vpshufb {{.*#+}} zmm0 = zero,zero,zero,zero,zero,zero,zmm0[0],zero,zero,zero,zero,zero,zero,zmm0[1],zero,zero,zero,zero,zmm0[18,26],zero,zero,zero,zero,zero,zmm0[19,27],zero,zero,zero,zero,zero,zero,zero,zmm0[36],zero,zero,zero,zero,zero,zero,zmm0[37],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm0[55,63],zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm2, %zmm1
; AVX512BW-NEXT:    vpshufb {{.*#+}} zmm2 = zmm1[0,8],zero,zero,zero,zero,zero,zmm1[1,9],zero,zero,zero,zero,zero,zmm1[2,10,18,26],zero,zero,zero,zero,zero,zmm1[19,27],zero,zero,zero,zero,zero,zmm1[20,28],zero,zero,zero,zmm1[37,45],zero,zero,zero,zero,zero,zmm1[38,46],zero,zero,zero,zero,zero,zero,zero,zmm1[55,63],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,0,1,6,7,4,5]
; AVX512BW-NEXT:    vpshufb {{.*#+}} zmm1 = zero,zero,zmm1[0,8],zero,zero,zero,zero,zero,zmm1[1,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm1[19,27],zero,zero,zero,zero,zero,zmm1[20,28],zero,zero,zero,zero,zero,zero,zero,zmm1[37,45],zero,zero,zero,zero,zero,zmm1[38,46],zero,zero,zero,zmm1[55,63],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vporq %zmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    movabsq $63546854584629360, %rcx # imm = 0xE1C3870E1C3870
; AVX512BW-NEXT:    kmovq %rcx, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm1, 32(%rax)
; AVX512BW-NEXT:    vextracti32x4 $3, %zmm1, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, 48(%rax)
; AVX512BW-NEXT:    vmovdqa %ymm1, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i8_stride7_vf8:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,2,4,0]
; AVX512BW-FCP-NEXT:    vpermi2q %ymm3, %ymm0, %ymm1
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[0,8],zero,zero,zero,zero,zero,ymm2[1,9],zero,zero,zero,zero,zero,ymm2[2,10,18,26],zero,zero,zero,zero,zero,ymm2[19,27],zero,zero,zero,zero,zero,ymm2[20,28]
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm2[2,3,0,1]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,ymm3[0,8],zero,zero,zero,zero,zero,ymm3[1,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[19,27],zero,zero,zero,zero,zero,ymm3[20,28],zero,zero
; AVX512BW-FCP-NEXT:    vpor %ymm0, %ymm3, %ymm0
; AVX512BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,2,4,6,0,2,4,6]
; AVX512BW-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512BW-FCP-NEXT:    vpermd %ymm1, %ymm3, %ymm3
; AVX512BW-FCP-NEXT:    movl $236730480, %ecx # imm = 0xE1C3870
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 {%k1} = ymm3[u,u,u,u,0,4,8,u,u,u,u,1,5,9,u,u,u,u,18,22,26,u,u,u,u,19,23,27,u,u,u,u]
; AVX512BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [1,3,5,7,1,3,5,7]
; AVX512BW-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512BW-FCP-NEXT:    vpermd %ymm2, %ymm3, %ymm2
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,ymm2[1,5,9,13],zero,zero,zero,ymm2[2,6,10,14],zero,zero,zero,ymm2[19,23,27,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [1,3,5,0,5,1,3,0]
; AVX512BW-FCP-NEXT:    vpermd %ymm1, %ymm3, %ymm1
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,4,8],zero,zero,zero,zero,ymm1[1,5,9],zero,zero,zero,zero,ymm1[2,6,18],zero,zero,zero,zero,ymm1[23,27,19],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %ymm2, %ymm1, %ymm1
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512BW-FCP-NEXT:    vmovq %xmm2, 48(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa %xmm1, 32(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i8_stride7_vf8:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm0[0,2,1,3,4,6,5,7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} zmm1 = zero,zero,zero,zero,zmm1[0,8],zero,zero,zero,zero,zero,zmm1[1,9],zero,zero,zero,zero,zero,zero,zero,zmm1[18],zero,zero,zero,zero,zero,zero,zmm1[19],zero,zero,zero,zero,zmm1[36,44],zero,zero,zero,zero,zero,zmm1[37,45],zero,zero,zero,zero,zero,zmm1[38,46,54],zero,zero,zero,zero,zero,zero,zmm1[55],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[1,3,0,2,5,7,4,6]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} zmm0 = zero,zero,zero,zero,zero,zero,zmm0[0],zero,zero,zero,zero,zero,zero,zmm0[1],zero,zero,zero,zero,zmm0[18,26],zero,zero,zero,zero,zero,zmm0[19,27],zero,zero,zero,zero,zero,zero,zero,zmm0[36],zero,zero,zero,zero,zero,zero,zmm0[37],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm0[55,63],zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm2, %zmm1
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} zmm2 = zmm1[0,8],zero,zero,zero,zero,zero,zmm1[1,9],zero,zero,zero,zero,zero,zmm1[2,10,18,26],zero,zero,zero,zero,zero,zmm1[19,27],zero,zero,zero,zero,zero,zmm1[20,28],zero,zero,zero,zmm1[37,45],zero,zero,zero,zero,zero,zmm1[38,46],zero,zero,zero,zero,zero,zero,zero,zmm1[55,63],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,0,1,6,7,4,5]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} zmm1 = zero,zero,zmm1[0,8],zero,zero,zero,zero,zero,zmm1[1,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm1[19,27],zero,zero,zero,zero,zero,zmm1[20,28],zero,zero,zero,zero,zero,zero,zero,zmm1[37,45],zero,zero,zero,zero,zero,zmm1[38,46],zero,zero,zero,zmm1[55,63],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vporq %zmm2, %zmm1, %zmm1
; AVX512DQ-BW-NEXT:    movabsq $63546854584629360, %rcx # imm = 0xE1C3870E1C3870
; AVX512DQ-BW-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    vextracti32x4 $2, %zmm1, 32(%rax)
; AVX512DQ-BW-NEXT:    vextracti32x4 $3, %zmm1, %xmm0
; AVX512DQ-BW-NEXT:    vmovq %xmm0, 48(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm1, (%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i8_stride7_vf8:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,2,4,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %ymm3, %ymm0, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[0,8],zero,zero,zero,zero,zero,ymm2[1,9],zero,zero,zero,zero,zero,ymm2[2,10,18,26],zero,zero,zero,zero,zero,ymm2[19,27],zero,zero,zero,zero,zero,ymm2[20,28]
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm2[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,ymm3[0,8],zero,zero,zero,zero,zero,ymm3[1,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[19,27],zero,zero,zero,zero,zero,ymm3[20,28],zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm0, %ymm3, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,2,4,6,0,2,4,6]
; AVX512DQ-BW-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vpermd %ymm1, %ymm3, %ymm3
; AVX512DQ-BW-FCP-NEXT:    movl $236730480, %ecx # imm = 0xE1C3870
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 {%k1} = ymm3[u,u,u,u,0,4,8,u,u,u,u,1,5,9,u,u,u,u,18,22,26,u,u,u,u,19,23,27,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [1,3,5,7,1,3,5,7]
; AVX512DQ-BW-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vpermd %ymm2, %ymm3, %ymm2
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,ymm2[1,5,9,13],zero,zero,zero,ymm2[2,6,10,14],zero,zero,zero,ymm2[19,23,27,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [1,3,5,0,5,1,3,0]
; AVX512DQ-BW-FCP-NEXT:    vpermd %ymm1, %ymm3, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,4,8],zero,zero,zero,zero,ymm1[1,5,9],zero,zero,zero,zero,ymm1[2,6,18],zero,zero,zero,zero,ymm1[23,27,19],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm2, %ymm1, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512DQ-BW-FCP-NEXT:    vmovq %xmm2, 48(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm1, 32(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <8 x i8>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i8>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i8>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i8>, ptr %in.vecptr3, align 64
  %in.vec4 = load <8 x i8>, ptr %in.vecptr4, align 64
  %in.vec5 = load <8 x i8>, ptr %in.vecptr5, align 64
  %in.vec6 = load <8 x i8>, ptr %in.vecptr6, align 64
  %1 = shufflevector <8 x i8> %in.vec0, <8 x i8> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i8> %in.vec2, <8 x i8> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <8 x i8> %in.vec4, <8 x i8> %in.vec5, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = shufflevector <16 x i8> %1, <16 x i8> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %5 = shufflevector <8 x i8> %in.vec6, <8 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <16 x i8> %3, <16 x i8> %5, <24 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %7 = shufflevector <24 x i8> %6, <24 x i8> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <32 x i8> %4, <32 x i8> %7, <56 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55>
  %interleaved.vec = shufflevector <56 x i8> %8, <56 x i8> poison, <56 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 40, i32 48, i32 1, i32 9, i32 17, i32 25, i32 33, i32 41, i32 49, i32 2, i32 10, i32 18, i32 26, i32 34, i32 42, i32 50, i32 3, i32 11, i32 19, i32 27, i32 35, i32 43, i32 51, i32 4, i32 12, i32 20, i32 28, i32 36, i32 44, i32 52, i32 5, i32 13, i32 21, i32 29, i32 37, i32 45, i32 53, i32 6, i32 14, i32 22, i32 30, i32 38, i32 46, i32 54, i32 7, i32 15, i32 23, i32 31, i32 39, i32 47, i32 55>
  store <56 x i8> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i8_stride7_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i8_stride7_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $56, %rsp
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm3
; SSE-NEXT:    movdqa (%rsi), %xmm4
; SSE-NEXT:    movdqa (%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rcx), %xmm5
; SSE-NEXT:    movdqa (%r8), %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%r9), %xmm8
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm5[8],xmm1[9],xmm5[9],xmm1[10],xmm5[10],xmm1[11],xmm5[11],xmm1[12],xmm5[12],xmm1[13],xmm5[13],xmm1[14],xmm5[14],xmm1[15],xmm5[15]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm3[0,1,2,3,7,7,7,7]
; SSE-NEXT:    movdqa %xmm3, %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,2,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm9
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8],xmm4[8],xmm9[9],xmm4[9],xmm9[10],xmm4[10],xmm9[11],xmm4[11],xmm9[12],xmm4[12],xmm9[13],xmm4[13],xmm9[14],xmm4[14],xmm9[15],xmm4[15]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm9[0,1,2,3,4,6,6,7]
; SSE-NEXT:    movdqa %xmm9, (%rsp) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,1,3,3]
; SSE-NEXT:    pandn %xmm4, %xmm10
; SSE-NEXT:    por %xmm3, %xmm10
; SSE-NEXT:    pand %xmm0, %xmm10
; SSE-NEXT:    por %xmm1, %xmm10
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm7[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm8[8],xmm1[9],xmm8[9],xmm1[10],xmm8[10],xmm1[11],xmm8[11],xmm1[12],xmm8[12],xmm1[13],xmm8[13],xmm1[14],xmm8[14],xmm1[15],xmm8[15]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,3]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255]
; SSE-NEXT:    pand %xmm4, %xmm10
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    movdqa (%rax), %xmm7
; SSE-NEXT:    por %xmm10, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm7[0,1,2,3,6,7,7,7]
; SSE-NEXT:    movdqa %xmm7, %xmm15
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; SSE-NEXT:    movdqa %xmm11, %xmm7
; SSE-NEXT:    pandn %xmm1, %xmm7
; SSE-NEXT:    pand %xmm11, %xmm4
; SSE-NEXT:    por %xmm4, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,0,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm12[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm12, %xmm5
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm6[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm12, %xmm14
; SSE-NEXT:    pandn %xmm1, %xmm14
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm8[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm1, %xmm14
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255]
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm14, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,3,2,0]
; SSE-NEXT:    movdqa %xmm2, %xmm14
; SSE-NEXT:    pandn %xmm4, %xmm14
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm6[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    por %xmm4, %xmm14
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255]
; SSE-NEXT:    pand %xmm4, %xmm14
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm15[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm15, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pandn %xmm7, %xmm4
; SSE-NEXT:    por %xmm14, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm9[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm5, %xmm15
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm5[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,2]
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm8[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,2]
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    pandn %xmm1, %xmm7
; SSE-NEXT:    pshufd $230, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pshufd $229, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[1,1,2,3]
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm6[0,1,2,3,5,6,6,7]
; SSE-NEXT:    movdqa %xmm6, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,2]
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm3[0,1,2,3,4,5,6,6]
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,1,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm5, %xmm7
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    pandn %xmm7, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm8[0,0,0,0,4,5,6,7]
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,0]
; SSE-NEXT:    movdqa %xmm11, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm15[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    por %xmm0, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255]
; SSE-NEXT:    pand %xmm0, %xmm7
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    movdqa %xmm13, %xmm7
; SSE-NEXT:    pandn %xmm1, %xmm7
; SSE-NEXT:    movdqa %xmm9, %xmm5
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm9[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    movdqa %xmm6, %xmm8
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm6[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    movdqa %xmm2, %xmm9
; SSE-NEXT:    pandn %xmm1, %xmm9
; SSE-NEXT:    pand %xmm2, %xmm7
; SSE-NEXT:    por %xmm7, %xmm9
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    pandn %xmm9, %xmm14
; SSE-NEXT:    por %xmm0, %xmm14
; SSE-NEXT:    pshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,1,1,3]
; SSE-NEXT:    movdqa %xmm10, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm3[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[2,1,3,2]
; SSE-NEXT:    pand %xmm10, %xmm9
; SSE-NEXT:    por %xmm7, %xmm9
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm15[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    pshuflw $233, (%rsp), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    por %xmm7, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0]
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm9, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    pshuflw $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,0,0,0]
; SSE-NEXT:    movdqa %xmm12, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm5[0,1,2,3,4,4,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,3,3]
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    pand %xmm13, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm8[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE-NEXT:    pandn %xmm3, %xmm13
; SSE-NEXT:    por %xmm6, %xmm13
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm13, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[2,2,3,3]
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    movdqa %xmm1, %xmm13
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[2,1,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm1[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm9, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm15[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[0,1,1,3]
; SSE-NEXT:    pand %xmm12, %xmm9
; SSE-NEXT:    por %xmm9, %xmm0
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm5[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[2,1,3,2]
; SSE-NEXT:    movdqa %xmm11, %xmm9
; SSE-NEXT:    pandn %xmm7, %xmm9
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm4[2,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,0,2,1]
; SSE-NEXT:    pand %xmm11, %xmm7
; SSE-NEXT:    por %xmm7, %xmm9
; SSE-NEXT:    pand %xmm10, %xmm9
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm8[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,0,0,0]
; SSE-NEXT:    pandn %xmm7, %xmm10
; SSE-NEXT:    por %xmm9, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [255,255,255,0,0,0,0,255,255,255,0,0,0,0,255,255]
; SSE-NEXT:    pand %xmm7, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    por %xmm7, %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,1,2,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm15[1,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,0,2,1]
; SSE-NEXT:    pand %xmm2, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    por %xmm7, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm13[1,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pshufd $101, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[1,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,7,5,6,4]
; SSE-NEXT:    pandn %xmm7, %xmm11
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    pand %xmm6, %xmm11
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    por %xmm11, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm4[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm5[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,1,3]
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm8[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    pandn %xmm0, %xmm12
; SSE-NEXT:    por %xmm1, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm12, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm0, 16(%rax)
; SSE-NEXT:    movdqa %xmm10, 32(%rax)
; SSE-NEXT:    movdqa %xmm3, 64(%rax)
; SSE-NEXT:    movdqa %xmm14, (%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    addq $56, %rsp
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i8_stride7_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX-NEXT:    vmovdqa (%rdi), %xmm3
; AVX-NEXT:    vmovdqa (%rsi), %xmm5
; AVX-NEXT:    vmovdqa (%rdx), %xmm6
; AVX-NEXT:    vmovdqa (%rcx), %xmm7
; AVX-NEXT:    vmovdqa (%r8), %xmm0
; AVX-NEXT:    vmovdqa (%r9), %xmm2
; AVX-NEXT:    vmovdqa (%r10), %xmm1
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm10 = xmm3[0],xmm5[0],xmm3[1],xmm5[1],xmm3[2],xmm5[2],xmm3[3],xmm5[3],xmm3[4],xmm5[4],xmm3[5],xmm5[5],xmm3[6],xmm5[6],xmm3[7],xmm5[7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,zero,zero,xmm10[6,7],zero,zero,zero,zero,zero,xmm10[8,9],zero,zero
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm6[0],xmm7[0],xmm6[1],xmm7[1],xmm6[2],xmm7[2],xmm6[3],xmm7[3],xmm6[4],xmm7[4],xmm6[5],xmm7[5],xmm6[6],xmm7[6],xmm6[7],xmm7[7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm8 = xmm11[4,5],zero,zero,zero,zero,zero,xmm11[6,7],zero,zero,zero,zero,zero,xmm11[8,9]
; AVX-NEXT:    vpor %xmm4, %xmm8, %xmm4
; AVX-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm11[0,1],zero,zero,zero,zero,zero,xmm11[2,3],zero,zero,zero,zero,zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm9 = xmm10[0,1],zero,zero,zero,zero,zero,xmm10[2,3],zero,zero,zero,zero,zero,xmm10[4,5]
; AVX-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm8, %ymm4
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm9 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm8 = xmm9[u,u,4,5],zero,xmm9[u,u,u,u,6,7],zero,xmm9[u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm12 = xmm1[u,u],zero,zero,xmm1[2,u,u,u,u],zero,zero,xmm1[3,u,u,u,u]
; AVX-NEXT:    vpor %xmm12, %xmm8, %xmm8
; AVX-NEXT:    vpshufb {{.*#+}} xmm12 = xmm9[u,u,u,u,0,1,u,u,u,u,u,2,3,u,u,u]
; AVX-NEXT:    vpalignr {{.*#+}} xmm12 = xmm12[4,5,6,7,8,9,10,11,12,13,14,15],xmm1[0,1,2,3]
; AVX-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u,u,u,0,1,12,u,u,u,u,7,8,13,u,u]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm12, %ymm8
; AVX-NEXT:    vmovaps {{.*#+}} ymm12 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX-NEXT:    vandnps %ymm8, %ymm12, %ymm8
; AVX-NEXT:    vorps %ymm4, %ymm8, %ymm4
; AVX-NEXT:    vpshufb {{.*#+}} xmm8 = xmm5[u],zero,xmm5[7,u,u,u,u,u],zero,xmm5[8,u,u,u,u,u],zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm12 = xmm3[u,7],zero,xmm3[u,u,u,u,u,8],zero,xmm3[u,u,u,u,u,9]
; AVX-NEXT:    vpor %xmm8, %xmm12, %xmm12
; AVX-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[u,u,u],zero,xmm7[7,u,u,u,u,u],zero,xmm7[8,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm13 = xmm6[u,u,u,7],zero,xmm6[u,u,u,u,u,8],zero,xmm6[u,u,u,u]
; AVX-NEXT:    vpor %xmm8, %xmm13, %xmm13
; AVX-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX-NEXT:    vpblendvb %xmm8, %xmm12, %xmm13, %xmm12
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,zero,zero,zero,xmm11[10,11],zero,zero,zero,zero,zero,xmm11[12,13],zero,zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[10,11],zero,zero,zero,zero,zero,xmm10[12,13],zero,zero,zero,zero
; AVX-NEXT:    vpor %xmm11, %xmm10, %xmm10
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm10, %ymm10
; AVX-NEXT:    vmovaps {{.*#+}} ymm11 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX-NEXT:    vandps %ymm11, %ymm10, %ymm10
; AVX-NEXT:    vpshufb {{.*#+}} xmm12 = xmm2[u,u,u,u,u],zero,xmm2[7,u,u,u,u,u],zero,xmm2[8,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm13 = xmm0[u,u,u,u,u,7],zero,xmm0[u,u,u,u,u,8],zero,xmm0[u,u]
; AVX-NEXT:    vpor %xmm12, %xmm13, %xmm12
; AVX-NEXT:    vpshufb {{.*#+}} xmm12 = zero,xmm12[u,u,u,u,5,6],zero,xmm12[u,u,u,u,12,13],zero,xmm12[u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm13 = xmm1[6,u,u,u,u],zero,zero,xmm1[7,u,u,u,u],zero,zero,xmm1[8,u]
; AVX-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[8,9],zero,xmm9[u,u,u,u,10,11],zero,xmm9[u,u,u,u,12,13]
; AVX-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,xmm1[4,u,u,u,u],zero,zero,xmm1[5,u,u,u,u],zero,zero
; AVX-NEXT:    vpor %xmm13, %xmm9, %xmm9
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm9, %ymm9
; AVX-NEXT:    vandnps %ymm9, %ymm11, %ymm9
; AVX-NEXT:    vorps %ymm9, %ymm10, %ymm9
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm10 = xmm3[8],xmm5[8],xmm3[9],xmm5[9],xmm3[10],xmm5[10],xmm3[11],xmm5[11],xmm3[12],xmm5[12],xmm3[13],xmm5[13],xmm3[14],xmm5[14],xmm3[15],xmm5[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,zero,zero,xmm10[8,9],zero,zero,zero,zero,zero,xmm10[10,11],zero,zero,zero
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm12 = xmm7[8],xmm6[8],xmm7[9],xmm6[9],xmm7[10],xmm6[10],xmm7[11],xmm6[11],xmm7[12],xmm6[12],xmm7[13],xmm6[13],xmm7[14],xmm6[14],xmm7[15],xmm6[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[6],zero,zero,zero,zero,zero,xmm12[9,8],zero,zero,zero,zero,zero,xmm12[11,10],zero
; AVX-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm6[8],xmm7[8],xmm6[9],xmm7[9],xmm6[10],xmm7[10],xmm6[11],xmm7[11],xmm6[12],xmm7[12],xmm6[13],xmm7[13],xmm6[14],xmm7[14],xmm6[15],xmm7[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = zero,xmm6[2,3],zero,zero,zero,zero,zero,xmm6[4,5],zero,zero,zero,zero,zero,xmm6[6]
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm5[8],xmm3[8],xmm5[9],xmm3[9],xmm5[10],xmm3[10],xmm5[11],xmm3[11],xmm5[12],xmm3[12],xmm5[13],xmm3[13],xmm5[14],xmm3[14],xmm5[15],xmm3[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[2],zero,zero,zero,zero,zero,xmm3[5,4],zero,zero,zero,zero,zero,xmm3[7,6],zero
; AVX-NEXT:    vpor %xmm7, %xmm3, %xmm3
; AVX-NEXT:    vinsertf128 $1, %xmm11, %ymm3, %ymm3
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = xmm5[u,6,7],zero,xmm5[u,u,u,u,8,9],zero,xmm5[u,u,u,u,10]
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm1[u],zero,zero,xmm1[11,u,u,u,u],zero,zero,xmm1[12,u,u,u,u],zero
; AVX-NEXT:    vpor %xmm7, %xmm11, %xmm7
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,2,3],zero,xmm5[u,u,u,u,4,5],zero,xmm5[u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm1[u,u,u],zero,zero,xmm1[9,u,u,u,u],zero,zero,xmm1[10,u,u,u]
; AVX-NEXT:    vpor %xmm5, %xmm11, %xmm5
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm5, %ymm5
; AVX-NEXT:    vandnps %ymm5, %ymm8, %ymm5
; AVX-NEXT:    vorps %ymm5, %ymm3, %ymm3
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,zero,xmm6[12,13],zero,zero,zero,zero,zero,xmm6[14,15],zero,zero,zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm10[12,13],zero,zero,zero,zero,zero,xmm10[14,15],zero,zero,zero,zero,zero
; AVX-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[10],zero,xmm0[u,u,u,u,13,12],zero,xmm0[u,u,u,u,15,14],zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = zero,xmm1[13,u,u,u,u],zero,zero,xmm1[14,u,u,u,u],zero,zero,xmm1[15]
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0]
; AVX-NEXT:    vpblendvb %xmm1, %xmm5, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa %xmm0, 96(%rax)
; AVX-NEXT:    vmovaps %ymm3, 64(%rax)
; AVX-NEXT:    vmovaps %ymm9, 32(%rax)
; AVX-NEXT:    vmovaps %ymm4, (%rax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i8_stride7_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-NEXT:    vmovdqa (%rdx), %xmm5
; AVX2-NEXT:    vmovdqa (%rcx), %xmm6
; AVX2-NEXT:    vmovdqa (%r8), %xmm3
; AVX2-NEXT:    vmovdqa (%r9), %xmm4
; AVX2-NEXT:    vmovdqa (%r10), %xmm2
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm7
; AVX2-NEXT:    vinserti128 $1, %xmm6, %ymm5, %ymm8
; AVX2-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm10
; AVX2-NEXT:    vpshufb {{.*#+}} ymm9 = zero,zero,zero,ymm7[5],zero,zero,zero,zero,zero,zero,ymm7[6],zero,zero,zero,zero,zero,zero,zero,ymm7[23],zero,zero,zero,zero,zero,zero,ymm7[24],zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vpermq {{.*#+}} ymm11 = ymm7[2,3,0,1]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm11 = zero,zero,zero,zero,ymm11[5],zero,zero,zero,zero,zero,zero,ymm11[6],zero,zero,zero,zero,zero,ymm11[23],zero,zero,zero,zero,zero,zero,ymm11[24],zero,zero,zero,zero,zero,zero,ymm11[25]
; AVX2-NEXT:    vpor %ymm9, %ymm11, %ymm9
; AVX2-NEXT:    vpshufb {{.*#+}} ymm11 = zero,zero,zero,zero,zero,ymm8[5],zero,zero,zero,zero,zero,zero,ymm8[6],zero,zero,zero,zero,zero,zero,zero,ymm8[23],zero,zero,zero,zero,zero,zero,ymm8[24],zero,zero,zero,zero
; AVX2-NEXT:    vpermq {{.*#+}} ymm12 = ymm8[2,3,0,1]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm12 = zero,zero,zero,zero,zero,zero,ymm12[5],zero,zero,zero,zero,zero,zero,ymm12[6],zero,zero,zero,zero,zero,ymm12[23],zero,zero,zero,zero,zero,zero,ymm12[24],zero,zero,zero,zero,zero
; AVX2-NEXT:    vpor %ymm12, %ymm11, %ymm11
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm12 = [u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255]
; AVX2-NEXT:    vpblendvb %ymm12, %ymm9, %ymm11, %ymm9
; AVX2-NEXT:    vpshufb {{.*#+}} ymm11 = ymm10[4],zero,zero,zero,zero,zero,zero,ymm10[5],zero,zero,zero,zero,zero,zero,ymm10[6],zero,zero,zero,zero,zero,zero,zero,ymm10[23],zero,zero,zero,zero,zero,zero,ymm10[24],zero,zero
; AVX2-NEXT:    vpermq {{.*#+}} ymm12 = ymm10[2,3,0,1]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm12 = zero,ymm12[4],zero,zero,zero,zero,zero,zero,ymm12[5],zero,zero,zero,zero,zero,zero,ymm12[6],zero,zero,zero,zero,zero,ymm12[23],zero,zero,zero,zero,zero,zero,ymm12[24],zero,zero,zero
; AVX2-NEXT:    vpor %ymm12, %ymm11, %ymm11
; AVX2-NEXT:    vpshufb {{.*#+}} xmm12 = xmm2[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,0,1,0]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u]
; AVX2-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm12 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX2-NEXT:    vpblendvb %ymm12, %ymm9, %ymm11, %ymm9
; AVX2-NEXT:    vpermq {{.*#+}} ymm11 = ymm10[0,2,0,2]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,0,8,u,u,u,u,u,1,9,u,u,u,u,u,18,26,u,u,u,u,u,19,27,u,u,u,u,u]
; AVX2-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm2[1,1,0,0,4,5,6,7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[0,1,2,0]
; AVX2-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,0,1,0]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u]
; AVX2-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-NEXT:    vpermq {{.*#+}} ymm12 = ymm8[0,2,0,2]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm12 = zero,zero,ymm12[0,8],zero,zero,zero,zero,zero,ymm12[1,9],zero,zero,zero,zero,zero,ymm12[18,26],zero,zero,zero,zero,zero,ymm12[19,27],zero,zero,zero,zero,zero,ymm12[20,28]
; AVX2-NEXT:    vpermq {{.*#+}} ymm13 = ymm7[0,2,0,2]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[0,8],zero,zero,zero,zero,zero,ymm13[1,9],zero,zero,zero,zero,zero,ymm13[2,10],zero,zero,zero,zero,zero,ymm13[19,27],zero,zero,zero,zero,zero,ymm13[20,28],zero,zero
; AVX2-NEXT:    vpor %ymm12, %ymm13, %ymm12
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX2-NEXT:    vpblendvb %ymm13, %ymm12, %ymm11, %ymm11
; AVX2-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[1,3,1,3]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,1,9,u,u,u,u,u,2,10,u,u,u,u,u,19,27,u,u,u,u,u,20,28,u,u,u,u,u,21]
; AVX2-NEXT:    vpshufhw {{.*#+}} xmm12 = xmm2[0,1,2,3,4,5,5,6]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255]
; AVX2-NEXT:    vpblendvb %ymm13, %ymm10, %ymm12, %ymm10
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[3,1,1,3]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[1],zero,zero,zero,zero,zero,ymm7[10,2],zero,zero,zero,zero,zero,ymm7[11,3],zero,zero,zero,zero,zero,ymm7[20,28],zero,zero,zero,zero,zero,ymm7[21,29],zero,zero,zero
; AVX2-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[1,3,3,1]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm8 = zero,ymm8[1,9],zero,zero,zero,zero,zero,ymm8[2,10],zero,zero,zero,zero,zero,ymm8[3,19],zero,zero,zero,zero,zero,ymm8[28,20],zero,zero,zero,zero,zero,ymm8[29,21],zero
; AVX2-NEXT:    vpor %ymm7, %ymm8, %ymm7
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX2-NEXT:    vpblendvb %ymm8, %ymm7, %ymm10, %ymm7
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm5[8],xmm6[8],xmm5[9],xmm6[9],xmm5[10],xmm6[10],xmm5[11],xmm6[11],xmm5[12],xmm6[12],xmm5[13],xmm6[13],xmm5[14],xmm6[14],xmm5[15],xmm6[15]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,zero,xmm5[12,13],zero,zero,zero,zero,zero,xmm5[14,15],zero,zero,zero
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[12,13],zero,zero,zero,zero,zero,xmm0[14,15],zero,zero,zero,zero,zero
; AVX2-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm4[8],xmm3[8],xmm4[9],xmm3[9],xmm4[10],xmm3[10],xmm4[11],xmm3[11],xmm4[12],xmm3[12],xmm4[13],xmm3[13],xmm4[14],xmm3[14],xmm4[15],xmm3[15]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[10,u,u,u,u,u,13,12,u,u,u,u,u,15,14,u]
; AVX2-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,7,7,7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,1,3,2]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0]
; AVX2-NEXT:    vpblendvb %xmm3, %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0]
; AVX2-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, 96(%rax)
; AVX2-NEXT:    vmovdqa %ymm7, 64(%rax)
; AVX2-NEXT:    vmovdqa %ymm11, (%rax)
; AVX2-NEXT:    vmovdqa %ymm9, 32(%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i8_stride7_vf16:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FP-NEXT:    vmovdqa (%rdx), %xmm4
; AVX2-FP-NEXT:    vmovdqa (%rcx), %xmm5
; AVX2-FP-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-FP-NEXT:    vmovdqa (%r9), %xmm3
; AVX2-FP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm6
; AVX2-FP-NEXT:    vinserti128 $1, %xmm5, %ymm4, %ymm7
; AVX2-FP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm10
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm8 = zero,zero,zero,ymm6[5],zero,zero,zero,zero,zero,zero,ymm6[6],zero,zero,zero,zero,zero,zero,zero,ymm6[23],zero,zero,zero,zero,zero,zero,ymm6[24],zero,zero,zero,zero,zero,zero
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm9 = ymm6[2,3,0,1]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm9 = zero,zero,zero,zero,ymm9[5],zero,zero,zero,zero,zero,zero,ymm9[6],zero,zero,zero,zero,zero,ymm9[23],zero,zero,zero,zero,zero,zero,ymm9[24],zero,zero,zero,zero,zero,zero,ymm9[25]
; AVX2-FP-NEXT:    vpor %ymm8, %ymm9, %ymm8
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm9 = zero,zero,zero,zero,zero,ymm7[5],zero,zero,zero,zero,zero,zero,ymm7[6],zero,zero,zero,zero,zero,zero,zero,ymm7[23],zero,zero,zero,zero,zero,zero,ymm7[24],zero,zero,zero,zero
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm11 = ymm7[2,3,0,1]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm11 = zero,zero,zero,zero,zero,zero,ymm11[5],zero,zero,zero,zero,zero,zero,ymm11[6],zero,zero,zero,zero,zero,ymm11[23],zero,zero,zero,zero,zero,zero,ymm11[24],zero,zero,zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm11, %ymm9, %ymm9
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm11 = [u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255]
; AVX2-FP-NEXT:    vpblendvb %ymm11, %ymm8, %ymm9, %ymm9
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm10[4],zero,zero,zero,zero,zero,zero,ymm10[5],zero,zero,zero,zero,zero,zero,ymm10[6],zero,zero,zero,zero,zero,zero,zero,ymm10[23],zero,zero,zero,zero,zero,zero,ymm10[24],zero,zero
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm11 = ymm10[2,3,0,1]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm11 = zero,ymm11[4],zero,zero,zero,zero,zero,zero,ymm11[5],zero,zero,zero,zero,zero,zero,ymm11[6],zero,zero,zero,zero,zero,ymm11[23],zero,zero,zero,zero,zero,zero,ymm11[24],zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm11, %ymm8, %ymm11
; AVX2-FP-NEXT:    vmovdqa (%r10), %xmm8
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,0,1,0]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u]
; AVX2-FP-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm12 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX2-FP-NEXT:    vpblendvb %ymm12, %ymm9, %ymm11, %ymm9
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm8[2,3,2,3,0,1,0,1,8,9,10,11,2,3,2,3]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,0,1,0]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm10[0,2,0,2]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm12[u,u,u,u,0,8,u,u,u,u,u,1,9,u,u,u,u,u,18,26,u,u,u,u,u,19,27,u,u,u,u,u]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm13, %ymm12, %ymm11, %ymm11
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm7[0,2,0,2]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm12 = zero,zero,ymm12[0,8],zero,zero,zero,zero,zero,ymm12[1,9],zero,zero,zero,zero,zero,ymm12[18,26],zero,zero,zero,zero,zero,ymm12[19,27],zero,zero,zero,zero,zero,ymm12[20,28]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm13 = ymm6[0,2,0,2]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[0,8],zero,zero,zero,zero,zero,ymm13[1,9],zero,zero,zero,zero,zero,ymm13[2,10],zero,zero,zero,zero,zero,ymm13[19,27],zero,zero,zero,zero,zero,ymm13[20,28],zero,zero
; AVX2-FP-NEXT:    vpor %ymm12, %ymm13, %ymm12
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm13, %ymm12, %ymm11, %ymm11
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[8,9,10,11,8,9,10,11,10,11,12,13,10,11,12,13]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,0,1]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[1,3,1,3]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,1,9,u,u,u,u,u,2,10,u,u,u,u,u,19,27,u,u,u,u,u,20,28,u,u,u,u,u,21]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255]
; AVX2-FP-NEXT:    vpblendvb %ymm13, %ymm10, %ymm12, %ymm10
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[3,1,1,3]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[1],zero,zero,zero,zero,zero,ymm6[10,2],zero,zero,zero,zero,zero,ymm6[11,3],zero,zero,zero,zero,zero,ymm6[20,28],zero,zero,zero,zero,zero,ymm6[21,29],zero,zero,zero
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[1,3,3,1]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm7 = zero,ymm7[1,9],zero,zero,zero,zero,zero,ymm7[2,10],zero,zero,zero,zero,zero,ymm7[3,19],zero,zero,zero,zero,zero,ymm7[28,20],zero,zero,zero,zero,zero,ymm7[29,21],zero
; AVX2-FP-NEXT:    vpor %ymm6, %ymm7, %ymm6
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm6, %ymm10, %ymm6
; AVX2-FP-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm4[8],xmm5[8],xmm4[9],xmm5[9],xmm4[10],xmm5[10],xmm4[11],xmm5[11],xmm4[12],xmm5[12],xmm4[13],xmm5[13],xmm4[14],xmm5[14],xmm4[15],xmm5[15]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,zero,xmm4[12,13],zero,zero,zero,zero,zero,xmm4[14,15],zero,zero,zero
; AVX2-FP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[12,13],zero,zero,zero,zero,zero,xmm0[14,15],zero,zero,zero,zero,zero
; AVX2-FP-NEXT:    vpor %xmm4, %xmm0, %xmm0
; AVX2-FP-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm3[8],xmm2[8],xmm3[9],xmm2[9],xmm3[10],xmm2[10],xmm3[11],xmm2[11],xmm3[12],xmm2[12],xmm3[13],xmm2[13],xmm3[14],xmm2[14],xmm3[15],xmm2[15]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[10],zero,zero,zero,zero,zero,xmm1[13,12],zero,zero,zero,zero,zero,xmm1[15,14],zero
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm2 = zero,xmm8[13,14,15,4,5],zero,zero,xmm8[14,15,14,15,12],zero,zero,xmm8[15]
; AVX2-FP-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0]
; AVX2-FP-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-FP-NEXT:    vmovdqa %xmm0, 96(%rax)
; AVX2-FP-NEXT:    vmovdqa %ymm6, 64(%rax)
; AVX2-FP-NEXT:    vmovdqa %ymm11, (%rax)
; AVX2-FP-NEXT:    vmovdqa %ymm9, 32(%rax)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i8_stride7_vf16:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa (%rdx), %xmm5
; AVX2-FCP-NEXT:    vmovdqa (%rcx), %xmm6
; AVX2-FCP-NEXT:    vmovdqa (%r8), %xmm3
; AVX2-FCP-NEXT:    vmovdqa (%r9), %xmm4
; AVX2-FCP-NEXT:    vmovdqa (%r10), %xmm2
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm8
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm5, %ymm9
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm10
; AVX2-FCP-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm2[1,1,0,0,4,5,6,7]
; AVX2-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm11 = [0,1,0,1,2,0,0,1]
; AVX2-FCP-NEXT:    vpermd %ymm7, %ymm11, %ymm7
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm10[0,2,0,2]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,0,8,u,u,u,u,u,1,9,u,u,u,u,u,18,26,u,u,u,u,u,19,27,u,u,u,u,u]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm12 = [u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm12, %ymm11, %ymm7, %ymm7
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm9[0,2,0,2]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = zero,zero,ymm11[0,8],zero,zero,zero,zero,zero,ymm11[1,9],zero,zero,zero,zero,zero,ymm11[18,26],zero,zero,zero,zero,zero,ymm11[19,27],zero,zero,zero,zero,zero,ymm11[20,28]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm8[0,2,0,2]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm12[0,8],zero,zero,zero,zero,zero,ymm12[1,9],zero,zero,zero,zero,zero,ymm12[2,10],zero,zero,zero,zero,zero,ymm12[19,27],zero,zero,zero,zero,zero,ymm12[20,28],zero,zero
; AVX2-FCP-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm12, %ymm11, %ymm7, %ymm7
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm2[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,0,1,0]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm12 = [1,5,2,6,1,5,2,6]
; AVX2-FCP-NEXT:    # ymm12 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermd %ymm10, %ymm12, %ymm13
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[0,4,u,u,u,u,u,1,5,u,u,u,u,u,2,6,u,u,u,u,u,19,23,u,u,u,u,u,24,28,u,u]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm14 = [255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm14, %ymm13, %ymm11, %ymm11
; AVX2-FCP-NEXT:    vpermd %ymm9, %ymm12, %ymm13
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = zero,zero,zero,zero,zero,ymm13[1,5],zero,zero,zero,zero,zero,ymm13[2,6],zero,zero,zero,zero,zero,ymm13[19,23],zero,zero,zero,zero,zero,ymm13[24,28],zero,zero,zero,zero
; AVX2-FCP-NEXT:    vpermd %ymm8, %ymm12, %ymm12
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = zero,zero,zero,ymm12[1,5],zero,zero,zero,zero,zero,ymm12[2,6],zero,zero,zero,zero,zero,ymm12[19,23],zero,zero,zero,zero,zero,ymm12[24,28],zero,zero,zero,zero,zero,ymm12[25]
; AVX2-FCP-NEXT:    vpor %ymm13, %ymm12, %ymm12
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm13 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm13, %ymm12, %ymm11, %ymm11
; AVX2-FCP-NEXT:    vpshufhw {{.*#+}} xmm12 = xmm2[0,1,2,3,4,5,5,6]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm13 = [2,2,3,3,2,2,3,3]
; AVX2-FCP-NEXT:    # ymm13 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermd %ymm12, %ymm13, %ymm12
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[1,3,1,3]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,1,9,u,u,u,u,u,2,10,u,u,u,u,u,19,27,u,u,u,u,u,20,28,u,u,u,u,u,21]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm13, %ymm10, %ymm12, %ymm10
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[3,1,1,3]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm8[1],zero,zero,zero,zero,zero,ymm8[10,2],zero,zero,zero,zero,zero,ymm8[11,3],zero,zero,zero,zero,zero,ymm8[20,28],zero,zero,zero,zero,zero,ymm8[21,29],zero,zero,zero
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[1,3,3,1]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm9 = zero,ymm9[1,9],zero,zero,zero,zero,zero,ymm9[2,10],zero,zero,zero,zero,zero,ymm9[3,19],zero,zero,zero,zero,zero,ymm9[28,20],zero,zero,zero,zero,zero,ymm9[29,21],zero
; AVX2-FCP-NEXT:    vpor %ymm8, %ymm9, %ymm8
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm9, %ymm8, %ymm10, %ymm8
; AVX2-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm5[8],xmm6[8],xmm5[9],xmm6[9],xmm5[10],xmm6[10],xmm5[11],xmm6[11],xmm5[12],xmm6[12],xmm5[13],xmm6[13],xmm5[14],xmm6[14],xmm5[15],xmm6[15]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,zero,xmm5[12,13],zero,zero,zero,zero,zero,xmm5[14,15],zero,zero,zero
; AVX2-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[12,13],zero,zero,zero,zero,zero,xmm0[14,15],zero,zero,zero,zero,zero
; AVX2-FCP-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm4[8],xmm3[8],xmm4[9],xmm3[9],xmm4[10],xmm3[10],xmm4[11],xmm3[11],xmm4[12],xmm3[12],xmm4[13],xmm3[13],xmm4[14],xmm3[14],xmm4[15],xmm3[15]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[10],zero,zero,zero,zero,zero,xmm1[13,12],zero,zero,zero,zero,zero,xmm1[15,14],zero
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = zero,xmm2[13,14,15,4,5],zero,zero,xmm2[14,15,14,15,12],zero,zero,xmm2[15]
; AVX2-FCP-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0]
; AVX2-FCP-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-FCP-NEXT:    vmovdqa %xmm0, 96(%rax)
; AVX2-FCP-NEXT:    vmovdqa %ymm8, 64(%rax)
; AVX2-FCP-NEXT:    vmovdqa %ymm11, 32(%rax)
; AVX2-FCP-NEXT:    vmovdqa %ymm7, (%rax)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i8_stride7_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512-NEXT:    vmovdqa (%rcx), %xmm6
; AVX512-NEXT:    vmovdqa (%r8), %xmm3
; AVX512-NEXT:    vmovdqa (%r9), %xmm4
; AVX512-NEXT:    vmovdqa (%r10), %xmm2
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm8
; AVX512-NEXT:    vinserti128 $1, %xmm6, %ymm5, %ymm9
; AVX512-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm7
; AVX512-NEXT:    vpshufb {{.*#+}} ymm10 = ymm9[u,u,u,u,u,5],zero,ymm9[u,u,u,u,u,6],zero,ymm9[u,u,u,u,u],zero,ymm9[23,u,u,u,u,u],zero,ymm9[24,u,u,u,u]
; AVX512-NEXT:    vpermq {{.*#+}} ymm11 = ymm9[2,3,0,1]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,u],zero,ymm11[5,u,u,u,u,u],zero,ymm11[6,u,u,u,u,u,23],zero,ymm11[u,u,u,u,u,24],zero,ymm11[u,u,u,u]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255]
; AVX512-NEXT:    vpternlogq $50, %ymm10, %ymm12, %ymm11
; AVX512-NEXT:    vpermq {{.*#+}} ymm10 = ymm9[0,2,0,2]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm10 = zero,zero,ymm10[0,8,u,u,u],zero,zero,ymm10[1,9,u,u,u],zero,zero,ymm10[18,26,u,u,u],zero,zero,ymm10[19,27,u,u,u],zero,zero,ymm10[20,28]
; AVX512-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm10
; AVX512-NEXT:    vpshufb {{.*#+}} ymm11 = ymm8[u,u,u,5],zero,ymm8[u,u,u,u,u,6],zero,ymm8[u,u,u,u,u],zero,ymm8[23,u,u,u,u,u],zero,ymm8[24,u,u,u,u,u],zero
; AVX512-NEXT:    vpermq {{.*#+}} ymm13 = ymm8[2,3,0,1]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[u,u,u],zero,ymm13[5,u,u,u,u,u],zero,ymm13[6,u,u,u,u,u,23],zero,ymm13[u,u,u,u,u,24],zero,ymm13[u,u,u,u,u,25]
; AVX512-NEXT:    vpternlogq $200, %ymm11, %ymm12, %ymm13
; AVX512-NEXT:    vpermq {{.*#+}} ymm11 = ymm8[0,2,0,2]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[0,8],zero,zero,ymm11[u,u,u,1,9],zero,zero,ymm11[u,u,u,2,10],zero,zero,ymm11[u,u,u,19,27],zero,zero,ymm11[u,u,u,20,28],zero,zero
; AVX512-NEXT:    vinserti64x4 $1, %ymm13, %zmm11, %zmm11
; AVX512-NEXT:    vporq %zmm10, %zmm11, %zmm10
; AVX512-NEXT:    vpshufb {{.*#+}} ymm11 = ymm7[4],zero,ymm7[u,u,u,u,u,5],zero,ymm7[u,u,u,u,u,6],zero,ymm7[u,u,u,u,u],zero,ymm7[23,u,u,u,u,u],zero,ymm7[24,u,u]
; AVX512-NEXT:    vpermq {{.*#+}} ymm12 = ymm7[2,3,0,1]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm12 = zero,ymm12[4,u,u,u,u,u],zero,ymm12[5,u,u,u,u,u],zero,ymm12[6,u,u,u,u,u,23],zero,ymm12[u,u,u,u,u,24],zero,ymm12[u,u]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255]
; AVX512-NEXT:    vpternlogq $200, %ymm11, %ymm13, %ymm12
; AVX512-NEXT:    vpermq {{.*#+}} ymm11 = ymm7[0,2,0,2]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,0,8],zero,ymm11[u,u,u,u,1,9],zero,ymm11[u,u,u,u,18,26],zero,ymm11[u,u,u,u,19,27],zero,ymm11[u,u,u,u]
; AVX512-NEXT:    vinserti64x4 $1, %ymm12, %zmm11, %zmm11
; AVX512-NEXT:    vpshufb {{.*#+}} xmm12 = xmm2[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,0,1,0]
; AVX512-NEXT:    vpandn %ymm12, %ymm13, %ymm12
; AVX512-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm2[1,1,0,0,4,5,6,7]
; AVX512-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[0,1,2,0]
; AVX512-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,0,1,0]
; AVX512-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm13, %ymm13
; AVX512-NEXT:    vinserti64x4 $1, %ymm12, %zmm13, %zmm12
; AVX512-NEXT:    vporq %zmm12, %zmm11, %zmm11
; AVX512-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm10, %zmm11
; AVX512-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[3,1,1,3]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm8 = ymm8[1],zero,zero,ymm8[u,u,u,10,2],zero,zero,ymm8[u,u,u,11,3],zero,zero,ymm8[u,u,u,20,28],zero,zero,ymm8[u,u,u,21,29],zero,zero,ymm8[u]
; AVX512-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[1,3,3,1]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm9 = zero,ymm9[1,9,u,u,u],zero,zero,ymm9[2,10,u,u,u],zero,zero,ymm9[3,19,u,u,u],zero,zero,ymm9[28,20,u,u,u],zero,zero,ymm9[29,21,u]
; AVX512-NEXT:    vpor %ymm8, %ymm9, %ymm8
; AVX512-NEXT:    vpshufhw {{.*#+}} xmm9 = xmm2[0,1,2,3,4,5,5,6]
; AVX512-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX512-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[1,3,1,3]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[u,u,u,1,9],zero,ymm7[u,u,u,u,2,10],zero,ymm7[u,u,u,u,19,27],zero,ymm7[u,u,u,u,20,28],zero,ymm7[u,u,u,u,21]
; AVX512-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm9, %ymm7
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm7
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm5[8],xmm6[8],xmm5[9],xmm6[9],xmm5[10],xmm6[10],xmm5[11],xmm6[11],xmm5[12],xmm6[12],xmm5[13],xmm6[13],xmm5[14],xmm6[14],xmm5[15],xmm6[15]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u],zero,zero,xmm5[12,13,u,u,u],zero,zero,xmm5[14,15,u,u,u]
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,12,13],zero,zero,xmm0[u,u,u,14,15],zero,zero,xmm0[u,u,u]
; AVX512-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm4[8],xmm3[8],xmm4[9],xmm3[9],xmm4[10],xmm3[10],xmm4[11],xmm3[11],xmm4[12],xmm3[12],xmm4[13],xmm3[13],xmm4[14],xmm3[14],xmm4[15],xmm3[15]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[10],zero,xmm1[u,u,u,u,13,12],zero,xmm1[u,u,u,u,15,14],zero
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = zero,xmm2[13,u,u,u,u],zero,zero,xmm2[14,u,u,u,u],zero,zero,xmm2[15]
; AVX512-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX512-NEXT:    vinserti32x4 $2, %xmm1, %zmm7, %zmm0
; AVX512-NEXT:    vmovdqa %xmm1, 96(%rax)
; AVX512-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i8_stride7_vf16:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512-FCP-NEXT:    vmovdqa (%rcx), %xmm6
; AVX512-FCP-NEXT:    vmovdqa (%r8), %xmm3
; AVX512-FCP-NEXT:    vmovdqa (%r9), %xmm4
; AVX512-FCP-NEXT:    vmovdqa (%r10), %xmm2
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm7
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm5, %ymm8
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm9
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm10 = ymm8[0,2,0,2]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = zero,zero,ymm10[0,8,u,u,u],zero,zero,ymm10[1,9,u,u,u],zero,zero,ymm10[18,26,u,u,u],zero,zero,ymm10[19,27,u,u,u],zero,zero,ymm10[20,28]
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm11 = [1,5,2,6,1,5,2,6]
; AVX512-FCP-NEXT:    # ymm11 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpermd %ymm8, %ymm11, %ymm12
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm12[u,u,u],zero,zero,ymm12[1,5,u,u,u],zero,zero,ymm12[2,6,u,u,u],zero,zero,ymm12[19,23,u,u,u],zero,zero,ymm12[24,28,u,u,u],zero
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm12, %zmm10, %zmm10
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm7[0,2,0,2]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm12[0,8],zero,zero,ymm12[u,u,u,1,9],zero,zero,ymm12[u,u,u,2,10],zero,zero,ymm12[u,u,u,19,27],zero,zero,ymm12[u,u,u,20,28],zero,zero
; AVX512-FCP-NEXT:    vpermd %ymm7, %ymm11, %ymm13
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[u,u,u,1,5],zero,zero,ymm13[u,u,u,2,6],zero,zero,ymm13[u,u,u,19,23],zero,zero,ymm13[u,u,u,24,28],zero,zero,ymm13[u,u,u,25]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm13, %zmm12, %zmm12
; AVX512-FCP-NEXT:    vporq %zmm10, %zmm12, %zmm10
; AVX512-FCP-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm2[1,1,0,0,4,5,6,7]
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm13 = [0,1,0,1,0,0,0,0]
; AVX512-FCP-NEXT:    vpermd %ymm12, %ymm13, %ymm12
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = xmm2[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,0,1,0]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm13, %zmm12, %zmm12
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm9[0,2,0,2]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[u,u,u,u,0,8],zero,ymm13[u,u,u,u,1,9],zero,ymm13[u,u,u,u,18,26],zero,ymm13[u,u,u,u,19,27],zero,ymm13[u,u,u,u]
; AVX512-FCP-NEXT:    vpermd %ymm9, %ymm11, %ymm11
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[0,4],zero,ymm11[u,u,u,u,1,5],zero,ymm11[u,u,u,u,2,6],zero,ymm11[u,u,u,u,19,23],zero,ymm11[u,u,u,u,24,28],zero,ymm11[u]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm11
; AVX512-FCP-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm12, %zmm11
; AVX512-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm10, %zmm11
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[3,1,1,3]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[1],zero,zero,ymm7[u,u,u,10,2],zero,zero,ymm7[u,u,u,11,3],zero,zero,ymm7[u,u,u,20,28],zero,zero,ymm7[u,u,u,21,29],zero,zero,ymm7[u]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[1,3,3,1]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = zero,ymm8[1,9,u,u,u],zero,zero,ymm8[2,10,u,u,u],zero,zero,ymm8[3,19,u,u,u],zero,zero,ymm8[28,20,u,u,u],zero,zero,ymm8[29,21,u]
; AVX512-FCP-NEXT:    vpor %ymm7, %ymm8, %ymm7
; AVX512-FCP-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm2[0,1,2,3,4,5,5,6]
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm10 = [2,2,3,3,2,2,3,3]
; AVX512-FCP-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpermd %ymm8, %ymm10, %ymm8
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[1,3,1,3]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[u,u,u,1,9],zero,ymm9[u,u,u,u,2,10],zero,ymm9[u,u,u,u,19,27],zero,ymm9[u,u,u,u,20,28],zero,ymm9[u,u,u,u,21]
; AVX512-FCP-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm9
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm7, %ymm9
; AVX512-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm5[8],xmm6[8],xmm5[9],xmm6[9],xmm5[10],xmm6[10],xmm5[11],xmm6[11],xmm5[12],xmm6[12],xmm5[13],xmm6[13],xmm5[14],xmm6[14],xmm5[15],xmm6[15]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u],zero,zero,xmm5[12,13,u,u,u],zero,zero,xmm5[14,15,u,u,u]
; AVX512-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,12,13],zero,zero,xmm0[u,u,u,14,15],zero,zero,xmm0[u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX512-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm4[8],xmm3[8],xmm4[9],xmm3[9],xmm4[10],xmm3[10],xmm4[11],xmm3[11],xmm4[12],xmm3[12],xmm4[13],xmm3[13],xmm4[14],xmm3[14],xmm4[15],xmm3[15]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[10],zero,xmm1[u,u,u,u,13,12],zero,xmm1[u,u,u,u,15,14],zero
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = zero,xmm2[13,u,u,u,u],zero,zero,xmm2[14,u,u,u,u],zero,zero,xmm2[15]
; AVX512-FCP-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX512-FCP-NEXT:    vinserti32x4 $2, %xmm1, %zmm9, %zmm0
; AVX512-FCP-NEXT:    vmovdqa %xmm1, 96(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512-FCP-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i8_stride7_vf16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512DQ-NEXT:    vmovdqa (%rcx), %xmm6
; AVX512DQ-NEXT:    vmovdqa (%r8), %xmm3
; AVX512DQ-NEXT:    vmovdqa (%r9), %xmm4
; AVX512DQ-NEXT:    vmovdqa (%r10), %xmm2
; AVX512DQ-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm8
; AVX512DQ-NEXT:    vinserti128 $1, %xmm6, %ymm5, %ymm9
; AVX512DQ-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm7
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm10 = ymm9[u,u,u,u,u,5],zero,ymm9[u,u,u,u,u,6],zero,ymm9[u,u,u,u,u],zero,ymm9[23,u,u,u,u,u],zero,ymm9[24,u,u,u,u]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm11 = ymm9[2,3,0,1]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,u],zero,ymm11[5,u,u,u,u,u],zero,ymm11[6,u,u,u,u,u,23],zero,ymm11[u,u,u,u,u,24],zero,ymm11[u,u,u,u]
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255]
; AVX512DQ-NEXT:    vpternlogq $50, %ymm10, %ymm12, %ymm11
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm10 = ymm9[0,2,0,2]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm10 = zero,zero,ymm10[0,8,u,u,u],zero,zero,ymm10[1,9,u,u,u],zero,zero,ymm10[18,26,u,u,u],zero,zero,ymm10[19,27,u,u,u],zero,zero,ymm10[20,28]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm10
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm11 = ymm8[u,u,u,5],zero,ymm8[u,u,u,u,u,6],zero,ymm8[u,u,u,u,u],zero,ymm8[23,u,u,u,u,u],zero,ymm8[24,u,u,u,u,u],zero
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm13 = ymm8[2,3,0,1]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[u,u,u],zero,ymm13[5,u,u,u,u,u],zero,ymm13[6,u,u,u,u,u,23],zero,ymm13[u,u,u,u,u,24],zero,ymm13[u,u,u,u,u,25]
; AVX512DQ-NEXT:    vpternlogq $200, %ymm11, %ymm12, %ymm13
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm11 = ymm8[0,2,0,2]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[0,8],zero,zero,ymm11[u,u,u,1,9],zero,zero,ymm11[u,u,u,2,10],zero,zero,ymm11[u,u,u,19,27],zero,zero,ymm11[u,u,u,20,28],zero,zero
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm13, %zmm11, %zmm11
; AVX512DQ-NEXT:    vporq %zmm10, %zmm11, %zmm10
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm11 = ymm7[4],zero,ymm7[u,u,u,u,u,5],zero,ymm7[u,u,u,u,u,6],zero,ymm7[u,u,u,u,u],zero,ymm7[23,u,u,u,u,u],zero,ymm7[24,u,u]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm12 = ymm7[2,3,0,1]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm12 = zero,ymm12[4,u,u,u,u,u],zero,ymm12[5,u,u,u,u,u],zero,ymm12[6,u,u,u,u,u,23],zero,ymm12[u,u,u,u,u,24],zero,ymm12[u,u]
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255]
; AVX512DQ-NEXT:    vpternlogq $200, %ymm11, %ymm13, %ymm12
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm11 = ymm7[0,2,0,2]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,0,8],zero,ymm11[u,u,u,u,1,9],zero,ymm11[u,u,u,u,18,26],zero,ymm11[u,u,u,u,19,27],zero,ymm11[u,u,u,u]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm12, %zmm11, %zmm11
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm12 = xmm2[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,0,1,0]
; AVX512DQ-NEXT:    vpandn %ymm12, %ymm13, %ymm12
; AVX512DQ-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm2[1,1,0,0,4,5,6,7]
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[0,1,2,0]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,0,1,0]
; AVX512DQ-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm13, %ymm13
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm12, %zmm13, %zmm12
; AVX512DQ-NEXT:    vporq %zmm12, %zmm11, %zmm11
; AVX512DQ-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm10, %zmm11
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[3,1,1,3]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm8 = ymm8[1],zero,zero,ymm8[u,u,u,10,2],zero,zero,ymm8[u,u,u,11,3],zero,zero,ymm8[u,u,u,20,28],zero,zero,ymm8[u,u,u,21,29],zero,zero,ymm8[u]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[1,3,3,1]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm9 = zero,ymm9[1,9,u,u,u],zero,zero,ymm9[2,10,u,u,u],zero,zero,ymm9[3,19,u,u,u],zero,zero,ymm9[28,20,u,u,u],zero,zero,ymm9[29,21,u]
; AVX512DQ-NEXT:    vpor %ymm8, %ymm9, %ymm8
; AVX512DQ-NEXT:    vpshufhw {{.*#+}} xmm9 = xmm2[0,1,2,3,4,5,5,6]
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[1,3,1,3]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[u,u,u,1,9],zero,ymm7[u,u,u,u,2,10],zero,ymm7[u,u,u,u,19,27],zero,ymm7[u,u,u,u,20,28],zero,ymm7[u,u,u,u,21]
; AVX512DQ-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm9, %ymm7
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm7
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm5[8],xmm6[8],xmm5[9],xmm6[9],xmm5[10],xmm6[10],xmm5[11],xmm6[11],xmm5[12],xmm6[12],xmm5[13],xmm6[13],xmm5[14],xmm6[14],xmm5[15],xmm6[15]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u],zero,zero,xmm5[12,13,u,u,u],zero,zero,xmm5[14,15,u,u,u]
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,12,13],zero,zero,xmm0[u,u,u,14,15],zero,zero,xmm0[u,u,u]
; AVX512DQ-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm4[8],xmm3[8],xmm4[9],xmm3[9],xmm4[10],xmm3[10],xmm4[11],xmm3[11],xmm4[12],xmm3[12],xmm4[13],xmm3[13],xmm4[14],xmm3[14],xmm4[15],xmm3[15]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[10],zero,xmm1[u,u,u,u,13,12],zero,xmm1[u,u,u,u,15,14],zero
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm2 = zero,xmm2[13,u,u,u,u],zero,zero,xmm2[14,u,u,u,u],zero,zero,xmm2[15]
; AVX512DQ-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX512DQ-NEXT:    vinserti32x4 $2, %xmm1, %zmm7, %zmm0
; AVX512DQ-NEXT:    vmovdqa %xmm1, 96(%rax)
; AVX512DQ-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i8_stride7_vf16:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512DQ-FCP-NEXT:    vmovdqa (%rcx), %xmm6
; AVX512DQ-FCP-NEXT:    vmovdqa (%r8), %xmm3
; AVX512DQ-FCP-NEXT:    vmovdqa (%r9), %xmm4
; AVX512DQ-FCP-NEXT:    vmovdqa (%r10), %xmm2
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm7
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm5, %ymm8
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm9
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm10 = ymm8[0,2,0,2]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = zero,zero,ymm10[0,8,u,u,u],zero,zero,ymm10[1,9,u,u,u],zero,zero,ymm10[18,26,u,u,u],zero,zero,ymm10[19,27,u,u,u],zero,zero,ymm10[20,28]
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm11 = [1,5,2,6,1,5,2,6]
; AVX512DQ-FCP-NEXT:    # ymm11 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpermd %ymm8, %ymm11, %ymm12
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm12[u,u,u],zero,zero,ymm12[1,5,u,u,u],zero,zero,ymm12[2,6,u,u,u],zero,zero,ymm12[19,23,u,u,u],zero,zero,ymm12[24,28,u,u,u],zero
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm12, %zmm10, %zmm10
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm7[0,2,0,2]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm12[0,8],zero,zero,ymm12[u,u,u,1,9],zero,zero,ymm12[u,u,u,2,10],zero,zero,ymm12[u,u,u,19,27],zero,zero,ymm12[u,u,u,20,28],zero,zero
; AVX512DQ-FCP-NEXT:    vpermd %ymm7, %ymm11, %ymm13
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[u,u,u,1,5],zero,zero,ymm13[u,u,u,2,6],zero,zero,ymm13[u,u,u,19,23],zero,zero,ymm13[u,u,u,24,28],zero,zero,ymm13[u,u,u,25]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm13, %zmm12, %zmm12
; AVX512DQ-FCP-NEXT:    vporq %zmm10, %zmm12, %zmm10
; AVX512DQ-FCP-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm2[1,1,0,0,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm13 = [0,1,0,1,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermd %ymm12, %ymm13, %ymm12
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = xmm2[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,0,1,0]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm13, %zmm12, %zmm12
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm9[0,2,0,2]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[u,u,u,u,0,8],zero,ymm13[u,u,u,u,1,9],zero,ymm13[u,u,u,u,18,26],zero,ymm13[u,u,u,u,19,27],zero,ymm13[u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpermd %ymm9, %ymm11, %ymm11
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[0,4],zero,ymm11[u,u,u,u,1,5],zero,ymm11[u,u,u,u,2,6],zero,ymm11[u,u,u,u,19,23],zero,ymm11[u,u,u,u,24,28],zero,ymm11[u]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm11
; AVX512DQ-FCP-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm12, %zmm11
; AVX512DQ-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm10, %zmm11
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[3,1,1,3]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[1],zero,zero,ymm7[u,u,u,10,2],zero,zero,ymm7[u,u,u,11,3],zero,zero,ymm7[u,u,u,20,28],zero,zero,ymm7[u,u,u,21,29],zero,zero,ymm7[u]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[1,3,3,1]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = zero,ymm8[1,9,u,u,u],zero,zero,ymm8[2,10,u,u,u],zero,zero,ymm8[3,19,u,u,u],zero,zero,ymm8[28,20,u,u,u],zero,zero,ymm8[29,21,u]
; AVX512DQ-FCP-NEXT:    vpor %ymm7, %ymm8, %ymm7
; AVX512DQ-FCP-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm2[0,1,2,3,4,5,5,6]
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm10 = [2,2,3,3,2,2,3,3]
; AVX512DQ-FCP-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpermd %ymm8, %ymm10, %ymm8
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[1,3,1,3]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[u,u,u,1,9],zero,ymm9[u,u,u,u,2,10],zero,ymm9[u,u,u,u,19,27],zero,ymm9[u,u,u,u,20,28],zero,ymm9[u,u,u,u,21]
; AVX512DQ-FCP-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm9
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm7, %ymm9
; AVX512DQ-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm5[8],xmm6[8],xmm5[9],xmm6[9],xmm5[10],xmm6[10],xmm5[11],xmm6[11],xmm5[12],xmm6[12],xmm5[13],xmm6[13],xmm5[14],xmm6[14],xmm5[15],xmm6[15]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u],zero,zero,xmm5[12,13,u,u,u],zero,zero,xmm5[14,15,u,u,u]
; AVX512DQ-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,12,13],zero,zero,xmm0[u,u,u,14,15],zero,zero,xmm0[u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX512DQ-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm4[8],xmm3[8],xmm4[9],xmm3[9],xmm4[10],xmm3[10],xmm4[11],xmm3[11],xmm4[12],xmm3[12],xmm4[13],xmm3[13],xmm4[14],xmm3[14],xmm4[15],xmm3[15]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[10],zero,xmm1[u,u,u,u,13,12],zero,xmm1[u,u,u,u,15,14],zero
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = zero,xmm2[13,u,u,u,u],zero,zero,xmm2[14,u,u,u,u],zero,zero,xmm2[15]
; AVX512DQ-FCP-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, %xmm1, %zmm9, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm1, 96(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i8_stride7_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512BW-NEXT:    vmovdqa (%rsi), %xmm3
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512BW-NEXT:    vmovdqa (%rcx), %xmm5
; AVX512BW-NEXT:    vmovdqa (%r8), %xmm6
; AVX512BW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm0
; AVX512BW-NEXT:    vinserti128 $1, %xmm5, %ymm4, %ymm1
; AVX512BW-NEXT:    vinserti128 $1, (%r9), %ymm6, %ymm6
; AVX512BW-NEXT:    vinserti32x4 $2, (%r10), %zmm6, %zmm6
; AVX512BW-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm7[8],xmm6[8],xmm7[9],xmm6[9],xmm7[10],xmm6[10],xmm7[11],xmm6[11],xmm7[12],xmm6[12],xmm7[13],xmm6[13],xmm7[14],xmm6[14],xmm7[15],xmm6[15]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[10,u,u,u,u,u,13,12,u,u,u,u,u,15,14,u]
; AVX512BW-NEXT:    vextracti64x4 $1, %zmm6, %ymm8
; AVX512BW-NEXT:    vpshufhw {{.*#+}} xmm9 = xmm8[0,1,2,3,6,7,7,7]
; AVX512BW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,1,3,2]
; AVX512BW-NEXT:    movw $-32510, %cx # imm = 0x8102
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu8 %xmm9, %xmm7 {%k1}
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm2[8],xmm3[8],xmm2[9],xmm3[9],xmm2[10],xmm3[10],xmm2[11],xmm3[11],xmm2[12],xmm3[12],xmm2[13],xmm3[13],xmm2[14],xmm3[14],xmm2[15],xmm3[15]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[12,13],zero,zero,zero,zero,zero,xmm2[14,15],zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm4[8],xmm5[8],xmm4[9],xmm5[9],xmm4[10],xmm5[10],xmm4[11],xmm5[11],xmm4[12],xmm5[12],xmm4[13],xmm5[13],xmm4[14],xmm5[14],xmm4[15],xmm5[15]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm3[12,13],zero,zero,zero,zero,zero,xmm3[14,15],zero,zero,zero
; AVX512BW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512BW-NEXT:    movw $-7741, %cx # imm = 0xE1C3
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu8 %xmm7, %xmm2 {%k1}
; AVX512BW-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [4,5,4,5,5,6,5,6,4,5,4,5,5,6,5,6]
; AVX512BW-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512BW-NEXT:    vpermw %ymm8, %ymm3, %ymm3
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm4 = ymm6[1,3,1,3]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,1,9,u,u,u,u,u,2,10,u,u,u,u,u,19,27,u,u,u,u,u,20,28,u,u,u,u,u,21]
; AVX512BW-NEXT:    movl $67637280, %ecx # imm = 0x4081020
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu8 %ymm3, %ymm4 {%k1}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm3 = ymm1[1,3,3,1]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm3 = zero,ymm3[1,9],zero,zero,zero,zero,zero,ymm3[2,10],zero,zero,zero,zero,zero,ymm3[3,19],zero,zero,zero,zero,zero,ymm3[28,20],zero,zero,zero,zero,zero,ymm3[29,21],zero
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm5 = ymm0[3,1,1,3]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[1],zero,zero,zero,zero,zero,ymm5[10,2],zero,zero,zero,zero,zero,ymm5[11,3],zero,zero,zero,zero,zero,ymm5[20,28],zero,zero,zero,zero,zero,ymm5[21,29],zero,zero,zero
; AVX512BW-NEXT:    vpor %ymm3, %ymm5, %ymm3
; AVX512BW-NEXT:    movl $-2029118408, %ecx # imm = 0x870E1C38
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu8 %ymm4, %ymm3 {%k1}
; AVX512BW-NEXT:    vinserti32x4 $2, %xmm2, %zmm3, %zmm3
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [1,1,0,0,1,1,0,0,4,5,1,1,1,1,0,0,50,50,50,52,50,50,50,52,51,51,51,51,50,50,50,52]
; AVX512BW-NEXT:    vpermi2w %zmm6, %zmm8, %zmm4
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm6[4],zero,zero,zero,zero,zero,zero,ymm6[5],zero,zero,zero,zero,zero,zero,ymm6[6],zero,zero,zero,zero,zero,zero,zero,ymm6[23],zero,zero,zero,zero,zero,zero,ymm6[24],zero,zero
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[2,3,0,1]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm7 = zero,ymm7[4],zero,zero,zero,zero,zero,zero,ymm7[5],zero,zero,zero,zero,zero,zero,ymm7[6],zero,zero,zero,zero,zero,ymm7[23],zero,zero,zero,zero,zero,zero,ymm7[24],zero,zero,zero
; AVX512BW-NEXT:    vpor %ymm5, %ymm7, %ymm5
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,0,2]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,0,8,u,u,u,u,u,1,9,u,u,u,u,u,18,26,u,u,u,u,u,19,27,u,u,u,u,u]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm5, %zmm6, %zmm5
; AVX512BW-NEXT:    movabsq $4647998506761461824, %rcx # imm = 0x4081020408102040
; AVX512BW-NEXT:    kmovq %rcx, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm4, %zmm5 {%k1}
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,zero,ymm1[5],zero,zero,zero,zero,zero,zero,ymm1[6],zero,zero,zero,zero,zero,zero,zero,ymm1[23],zero,zero,zero,zero,zero,zero,ymm1[24],zero,zero,zero,zero
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm6 = ymm1[2,3,0,1]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,ymm6[5],zero,zero,zero,zero,zero,zero,ymm6[6],zero,zero,zero,zero,zero,ymm6[23],zero,zero,zero,zero,zero,zero,ymm6[24],zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpor %ymm4, %ymm6, %ymm4
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,ymm0[5],zero,zero,zero,zero,zero,zero,ymm0[6],zero,zero,zero,zero,zero,zero,zero,ymm0[23],zero,zero,zero,zero,zero,zero,ymm0[24],zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm7 = ymm0[2,3,0,1]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm7 = zero,zero,zero,zero,ymm7[5],zero,zero,zero,zero,zero,zero,ymm7[6],zero,zero,zero,zero,zero,ymm7[23],zero,zero,zero,zero,zero,zero,ymm7[24],zero,zero,zero,zero,zero,zero,ymm7[25]
; AVX512BW-NEXT:    vpor %ymm7, %ymm6, %ymm6
; AVX512BW-NEXT:    movl $202911840, %ecx # imm = 0xC183060
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu8 %ymm4, %ymm6 {%k1}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,0,2]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,8],zero,zero,zero,zero,zero,ymm0[1,9],zero,zero,zero,zero,zero,ymm0[2,10],zero,zero,zero,zero,zero,ymm0[19,27],zero,zero,zero,zero,zero,ymm0[20,28],zero,zero
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,0,2]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,ymm1[0,8],zero,zero,zero,zero,zero,ymm1[1,9],zero,zero,zero,zero,zero,ymm1[18,26],zero,zero,zero,zero,zero,ymm1[19,27],zero,zero,zero,zero,zero,ymm1[20,28]
; AVX512BW-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm6, %zmm0, %zmm0
; AVX512BW-NEXT:    movabsq $8133997386832558192, %rcx # imm = 0x70E1C3870E1C3870
; AVX512BW-NEXT:    kmovq %rcx, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm5, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa %xmm2, 96(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, (%rax)
; AVX512BW-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i8_stride7_vf16:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512BW-FCP-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512BW-FCP-NEXT:    vmovdqa (%r8), %xmm4
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm5
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm6
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%r9), %ymm4, %ymm4
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, (%r10), %zmm4, %zmm4
; AVX512BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[12,13],zero,zero,zero,zero,zero,xmm0[14,15],zero,zero,zero,zero,zero
; AVX512BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm2[8],xmm3[8],xmm2[9],xmm3[9],xmm2[10],xmm3[10],xmm2[11],xmm3[11],xmm2[12],xmm3[12],xmm2[13],xmm3[13],xmm2[14],xmm3[14],xmm2[15],xmm3[15]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,zero,xmm1[12,13],zero,zero,zero,zero,zero,xmm1[14,15],zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm4, %xmm1
; AVX512BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm1[8],xmm4[8],xmm1[9],xmm4[9],xmm1[10],xmm4[10],xmm1[11],xmm4[11],xmm1[12],xmm4[12],xmm1[13],xmm4[13],xmm1[14],xmm4[14],xmm1[15],xmm4[15]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[10],zero,zero,zero,zero,zero,xmm1[13,12],zero,zero,zero,zero,zero,xmm1[15,14],zero
; AVX512BW-FCP-NEXT:    vextracti64x4 $1, %zmm4, %ymm2
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,xmm2[13],zero,zero,zero,zero,zero,zero,xmm2[14],zero,zero,zero,zero,zero,zero,xmm2[15]
; AVX512BW-FCP-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX512BW-FCP-NEXT:    movw $-7741, %cx # imm = 0xE1C3
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %xmm1, %xmm0 {%k1}
; AVX512BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,5,4,5,5,6,5,6,4,5,4,5,5,6,5,6]
; AVX512BW-FCP-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512BW-FCP-NEXT:    vpermw %ymm2, %ymm1, %ymm1
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm4[1,3,1,3]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,1,9,u,u,u,u,u,2,10,u,u,u,u,u,19,27,u,u,u,u,u,20,28,u,u,u,u,u,21]
; AVX512BW-FCP-NEXT:    movl $67637280, %ecx # imm = 0x4081020
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm1, %ymm3 {%k1}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm6[1,3,3,1]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = zero,ymm1[1,9],zero,zero,zero,zero,zero,ymm1[2,10],zero,zero,zero,zero,zero,ymm1[3,19],zero,zero,zero,zero,zero,ymm1[28,20],zero,zero,zero,zero,zero,ymm1[29,21],zero
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm5[3,1,1,3]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[1],zero,zero,zero,zero,zero,ymm7[10,2],zero,zero,zero,zero,zero,ymm7[11,3],zero,zero,zero,zero,zero,ymm7[20,28],zero,zero,zero,zero,zero,ymm7[21,29],zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %ymm1, %ymm7, %ymm1
; AVX512BW-FCP-NEXT:    movl $-2029118408, %ecx # imm = 0x870E1C38
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm3, %ymm1 {%k1}
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, %xmm0, %zmm1, %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm3 = [1,1,0,0,1,1,0,0,4,5,1,1,1,1,0,0,50,50,50,52,50,50,50,52,51,51,51,51,50,50,50,52]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm4, %zmm2, %zmm3
; AVX512BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [1,5,2,6,1,5,2,6]
; AVX512BW-FCP-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512BW-FCP-NEXT:    vpermd %ymm4, %ymm2, %ymm7
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,2,0,2]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm7, %zmm4, %zmm4
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm4 = zmm4[u,u,u,u,0,8,u,u,u,u,u,1,9,u,u,u,u,u,18,26,u,u,u,u,u,19,27,u,u,u,u,u,32,36,u,u,u,u,u,33,37,u,u,u,u,u,34,38,u,u,u,u,u,51,55,u,u,u,u,u,56,60,u,u]
; AVX512BW-FCP-NEXT:    movabsq $4647998506761461824, %rcx # imm = 0x4081020408102040
; AVX512BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm3, %zmm4 {%k1}
; AVX512BW-FCP-NEXT:    vpermd %ymm5, %ymm2, %ymm3
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,2,0,2]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm3, %zmm5, %zmm3
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm3 = zmm3[0,8],zero,zero,zero,zero,zero,zmm3[1,9],zero,zero,zero,zero,zero,zmm3[2,10],zero,zero,zero,zero,zero,zmm3[19,27],zero,zero,zero,zero,zero,zmm3[20,28],zero,zero,zero,zero,zero,zmm3[33,37],zero,zero,zero,zero,zero,zmm3[34,38],zero,zero,zero,zero,zero,zmm3[51,55],zero,zero,zero,zero,zero,zmm3[56,60],zero,zero,zero,zero,zero,zmm3[57]
; AVX512BW-FCP-NEXT:    vpermd %ymm6, %ymm2, %ymm2
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm6[0,2,0,2]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm5, %zmm2
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm2 = zero,zero,zmm2[0,8],zero,zero,zero,zero,zero,zmm2[1,9],zero,zero,zero,zero,zero,zmm2[18,26],zero,zero,zero,zero,zero,zmm2[19,27],zero,zero,zero,zero,zero,zmm2[20,28],zero,zero,zero,zero,zero,zmm2[33,37],zero,zero,zero,zero,zero,zmm2[34,38],zero,zero,zero,zero,zero,zmm2[51,55],zero,zero,zero,zero,zero,zmm2[56,60],zero,zero,zero,zero
; AVX512BW-FCP-NEXT:    vporq %zmm3, %zmm2, %zmm2
; AVX512BW-FCP-NEXT:    movabsq $8133997386832558192, %rcx # imm = 0x70E1C3870E1C3870
; AVX512BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm4, %zmm2 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa %xmm0, 96(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm1, 64(%rax)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i8_stride7_vf16:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512DQ-BW-NEXT:    vmovdqa (%rsi), %xmm3
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512DQ-BW-NEXT:    vmovdqa (%rcx), %xmm5
; AVX512DQ-BW-NEXT:    vmovdqa (%r8), %xmm6
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm0
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm5, %ymm4, %ymm1
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%r9), %ymm6, %ymm6
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, (%r10), %zmm6, %zmm6
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX512DQ-BW-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm7[8],xmm6[8],xmm7[9],xmm6[9],xmm7[10],xmm6[10],xmm7[11],xmm6[11],xmm7[12],xmm6[12],xmm7[13],xmm6[13],xmm7[14],xmm6[14],xmm7[15],xmm6[15]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[10,u,u,u,u,u,13,12,u,u,u,u,u,15,14,u]
; AVX512DQ-BW-NEXT:    vextracti64x4 $1, %zmm6, %ymm8
; AVX512DQ-BW-NEXT:    vpshufhw {{.*#+}} xmm9 = xmm8[0,1,2,3,6,7,7,7]
; AVX512DQ-BW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,1,3,2]
; AVX512DQ-BW-NEXT:    movw $-32510, %cx # imm = 0x8102
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %xmm9, %xmm7 {%k1}
; AVX512DQ-BW-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm2[8],xmm3[8],xmm2[9],xmm3[9],xmm2[10],xmm3[10],xmm2[11],xmm3[11],xmm2[12],xmm3[12],xmm2[13],xmm3[13],xmm2[14],xmm3[14],xmm2[15],xmm3[15]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[12,13],zero,zero,zero,zero,zero,xmm2[14,15],zero,zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm4[8],xmm5[8],xmm4[9],xmm5[9],xmm4[10],xmm5[10],xmm4[11],xmm5[11],xmm4[12],xmm5[12],xmm4[13],xmm5[13],xmm4[14],xmm5[14],xmm4[15],xmm5[15]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm3[12,13],zero,zero,zero,zero,zero,xmm3[14,15],zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQ-BW-NEXT:    movw $-7741, %cx # imm = 0xE1C3
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %xmm7, %xmm2 {%k1}
; AVX512DQ-BW-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [4,5,4,5,5,6,5,6,4,5,4,5,5,6,5,6]
; AVX512DQ-BW-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512DQ-BW-NEXT:    vpermw %ymm8, %ymm3, %ymm3
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm4 = ymm6[1,3,1,3]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,1,9,u,u,u,u,u,2,10,u,u,u,u,u,19,27,u,u,u,u,u,20,28,u,u,u,u,u,21]
; AVX512DQ-BW-NEXT:    movl $67637280, %ecx # imm = 0x4081020
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm3, %ymm4 {%k1}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm3 = ymm1[1,3,3,1]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm3 = zero,ymm3[1,9],zero,zero,zero,zero,zero,ymm3[2,10],zero,zero,zero,zero,zero,ymm3[3,19],zero,zero,zero,zero,zero,ymm3[28,20],zero,zero,zero,zero,zero,ymm3[29,21],zero
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm5 = ymm0[3,1,1,3]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[1],zero,zero,zero,zero,zero,ymm5[10,2],zero,zero,zero,zero,zero,ymm5[11,3],zero,zero,zero,zero,zero,ymm5[20,28],zero,zero,zero,zero,zero,ymm5[21,29],zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %ymm3, %ymm5, %ymm3
; AVX512DQ-BW-NEXT:    movl $-2029118408, %ecx # imm = 0x870E1C38
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm4, %ymm3 {%k1}
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, %xmm2, %zmm3, %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [1,1,0,0,1,1,0,0,4,5,1,1,1,1,0,0,50,50,50,52,50,50,50,52,51,51,51,51,50,50,50,52]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm6, %zmm8, %zmm4
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm6[4],zero,zero,zero,zero,zero,zero,ymm6[5],zero,zero,zero,zero,zero,zero,ymm6[6],zero,zero,zero,zero,zero,zero,zero,ymm6[23],zero,zero,zero,zero,zero,zero,ymm6[24],zero,zero
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[2,3,0,1]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm7 = zero,ymm7[4],zero,zero,zero,zero,zero,zero,ymm7[5],zero,zero,zero,zero,zero,zero,ymm7[6],zero,zero,zero,zero,zero,ymm7[23],zero,zero,zero,zero,zero,zero,ymm7[24],zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %ymm5, %ymm7, %ymm5
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,0,2]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,0,8,u,u,u,u,u,1,9,u,u,u,u,u,18,26,u,u,u,u,u,19,27,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm5, %zmm6, %zmm5
; AVX512DQ-BW-NEXT:    movabsq $4647998506761461824, %rcx # imm = 0x4081020408102040
; AVX512DQ-BW-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm4, %zmm5 {%k1}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,zero,ymm1[5],zero,zero,zero,zero,zero,zero,ymm1[6],zero,zero,zero,zero,zero,zero,zero,ymm1[23],zero,zero,zero,zero,zero,zero,ymm1[24],zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm6 = ymm1[2,3,0,1]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,ymm6[5],zero,zero,zero,zero,zero,zero,ymm6[6],zero,zero,zero,zero,zero,ymm6[23],zero,zero,zero,zero,zero,zero,ymm6[24],zero,zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %ymm4, %ymm6, %ymm4
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,ymm0[5],zero,zero,zero,zero,zero,zero,ymm0[6],zero,zero,zero,zero,zero,zero,zero,ymm0[23],zero,zero,zero,zero,zero,zero,ymm0[24],zero,zero,zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm7 = ymm0[2,3,0,1]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm7 = zero,zero,zero,zero,ymm7[5],zero,zero,zero,zero,zero,zero,ymm7[6],zero,zero,zero,zero,zero,ymm7[23],zero,zero,zero,zero,zero,zero,ymm7[24],zero,zero,zero,zero,zero,zero,ymm7[25]
; AVX512DQ-BW-NEXT:    vpor %ymm7, %ymm6, %ymm6
; AVX512DQ-BW-NEXT:    movl $202911840, %ecx # imm = 0xC183060
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm4, %ymm6 {%k1}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,0,2]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,8],zero,zero,zero,zero,zero,ymm0[1,9],zero,zero,zero,zero,zero,ymm0[2,10],zero,zero,zero,zero,zero,ymm0[19,27],zero,zero,zero,zero,zero,ymm0[20,28],zero,zero
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,0,2]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,ymm1[0,8],zero,zero,zero,zero,zero,ymm1[1,9],zero,zero,zero,zero,zero,ymm1[18,26],zero,zero,zero,zero,zero,ymm1[19,27],zero,zero,zero,zero,zero,ymm1[20,28]
; AVX512DQ-BW-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm6, %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    movabsq $8133997386832558192, %rcx # imm = 0x70E1C3870E1C3870
; AVX512DQ-BW-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm5, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa %xmm2, 96(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, (%rax)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i8_stride7_vf16:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r8), %xmm4
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm5
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm6
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%r9), %ymm4, %ymm4
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, (%r10), %zmm4, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[12,13],zero,zero,zero,zero,zero,xmm0[14,15],zero,zero,zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm2[8],xmm3[8],xmm2[9],xmm3[9],xmm2[10],xmm3[10],xmm2[11],xmm3[11],xmm2[12],xmm3[12],xmm2[13],xmm3[13],xmm2[14],xmm3[14],xmm2[15],xmm3[15]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,zero,xmm1[12,13],zero,zero,zero,zero,zero,xmm1[14,15],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm4, %xmm1
; AVX512DQ-BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm1[8],xmm4[8],xmm1[9],xmm4[9],xmm1[10],xmm4[10],xmm1[11],xmm4[11],xmm1[12],xmm4[12],xmm1[13],xmm4[13],xmm1[14],xmm4[14],xmm1[15],xmm4[15]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[10],zero,zero,zero,zero,zero,xmm1[13,12],zero,zero,zero,zero,zero,xmm1[15,14],zero
; AVX512DQ-BW-FCP-NEXT:    vextracti64x4 $1, %zmm4, %ymm2
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,xmm2[13],zero,zero,zero,zero,zero,zero,xmm2[14],zero,zero,zero,zero,zero,zero,xmm2[15]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX512DQ-BW-FCP-NEXT:    movw $-7741, %cx # imm = 0xE1C3
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %xmm1, %xmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,5,4,5,5,6,5,6,4,5,4,5,5,6,5,6]
; AVX512DQ-BW-FCP-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vpermw %ymm2, %ymm1, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm4[1,3,1,3]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,1,9,u,u,u,u,u,2,10,u,u,u,u,u,19,27,u,u,u,u,u,20,28,u,u,u,u,u,21]
; AVX512DQ-BW-FCP-NEXT:    movl $67637280, %ecx # imm = 0x4081020
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm1, %ymm3 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm6[1,3,3,1]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = zero,ymm1[1,9],zero,zero,zero,zero,zero,ymm1[2,10],zero,zero,zero,zero,zero,ymm1[3,19],zero,zero,zero,zero,zero,ymm1[28,20],zero,zero,zero,zero,zero,ymm1[29,21],zero
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm5[3,1,1,3]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[1],zero,zero,zero,zero,zero,ymm7[10,2],zero,zero,zero,zero,zero,ymm7[11,3],zero,zero,zero,zero,zero,ymm7[20,28],zero,zero,zero,zero,zero,ymm7[21,29],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm1, %ymm7, %ymm1
; AVX512DQ-BW-FCP-NEXT:    movl $-2029118408, %ecx # imm = 0x870E1C38
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm3, %ymm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, %xmm0, %zmm1, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm3 = [1,1,0,0,1,1,0,0,4,5,1,1,1,1,0,0,50,50,50,52,50,50,50,52,51,51,51,51,50,50,50,52]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm4, %zmm2, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [1,5,2,6,1,5,2,6]
; AVX512DQ-BW-FCP-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vpermd %ymm4, %ymm2, %ymm7
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,2,0,2]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm7, %zmm4, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm4 = zmm4[u,u,u,u,0,8,u,u,u,u,u,1,9,u,u,u,u,u,18,26,u,u,u,u,u,19,27,u,u,u,u,u,32,36,u,u,u,u,u,33,37,u,u,u,u,u,34,38,u,u,u,u,u,51,55,u,u,u,u,u,56,60,u,u]
; AVX512DQ-BW-FCP-NEXT:    movabsq $4647998506761461824, %rcx # imm = 0x4081020408102040
; AVX512DQ-BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm3, %zmm4 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermd %ymm5, %ymm2, %ymm3
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,2,0,2]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm3, %zmm5, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm3 = zmm3[0,8],zero,zero,zero,zero,zero,zmm3[1,9],zero,zero,zero,zero,zero,zmm3[2,10],zero,zero,zero,zero,zero,zmm3[19,27],zero,zero,zero,zero,zero,zmm3[20,28],zero,zero,zero,zero,zero,zmm3[33,37],zero,zero,zero,zero,zero,zmm3[34,38],zero,zero,zero,zero,zero,zmm3[51,55],zero,zero,zero,zero,zero,zmm3[56,60],zero,zero,zero,zero,zero,zmm3[57]
; AVX512DQ-BW-FCP-NEXT:    vpermd %ymm6, %ymm2, %ymm2
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm6[0,2,0,2]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm5, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm2 = zero,zero,zmm2[0,8],zero,zero,zero,zero,zero,zmm2[1,9],zero,zero,zero,zero,zero,zmm2[18,26],zero,zero,zero,zero,zero,zmm2[19,27],zero,zero,zero,zero,zero,zmm2[20,28],zero,zero,zero,zero,zero,zmm2[33,37],zero,zero,zero,zero,zero,zmm2[34,38],zero,zero,zero,zero,zero,zmm2[51,55],zero,zero,zero,zero,zero,zmm2[56,60],zero,zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vporq %zmm3, %zmm2, %zmm2
; AVX512DQ-BW-FCP-NEXT:    movabsq $8133997386832558192, %rcx # imm = 0x70E1C3870E1C3870
; AVX512DQ-BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm4, %zmm2 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm0, 96(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm1, 64(%rax)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <16 x i8>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i8>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i8>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i8>, ptr %in.vecptr3, align 64
  %in.vec4 = load <16 x i8>, ptr %in.vecptr4, align 64
  %in.vec5 = load <16 x i8>, ptr %in.vecptr5, align 64
  %in.vec6 = load <16 x i8>, ptr %in.vecptr6, align 64
  %1 = shufflevector <16 x i8> %in.vec0, <16 x i8> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i8> %in.vec2, <16 x i8> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <16 x i8> %in.vec4, <16 x i8> %in.vec5, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = shufflevector <32 x i8> %1, <32 x i8> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %5 = shufflevector <16 x i8> %in.vec6, <16 x i8> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <32 x i8> %3, <32 x i8> %5, <48 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47>
  %7 = shufflevector <48 x i8> %6, <48 x i8> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <64 x i8> %4, <64 x i8> %7, <112 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111>
  %interleaved.vec = shufflevector <112 x i8> %8, <112 x i8> poison, <112 x i32> <i32 0, i32 16, i32 32, i32 48, i32 64, i32 80, i32 96, i32 1, i32 17, i32 33, i32 49, i32 65, i32 81, i32 97, i32 2, i32 18, i32 34, i32 50, i32 66, i32 82, i32 98, i32 3, i32 19, i32 35, i32 51, i32 67, i32 83, i32 99, i32 4, i32 20, i32 36, i32 52, i32 68, i32 84, i32 100, i32 5, i32 21, i32 37, i32 53, i32 69, i32 85, i32 101, i32 6, i32 22, i32 38, i32 54, i32 70, i32 86, i32 102, i32 7, i32 23, i32 39, i32 55, i32 71, i32 87, i32 103, i32 8, i32 24, i32 40, i32 56, i32 72, i32 88, i32 104, i32 9, i32 25, i32 41, i32 57, i32 73, i32 89, i32 105, i32 10, i32 26, i32 42, i32 58, i32 74, i32 90, i32 106, i32 11, i32 27, i32 43, i32 59, i32 75, i32 91, i32 107, i32 12, i32 28, i32 44, i32 60, i32 76, i32 92, i32 108, i32 13, i32 29, i32 45, i32 61, i32 77, i32 93, i32 109, i32 14, i32 30, i32 46, i32 62, i32 78, i32 94, i32 110, i32 15, i32 31, i32 47, i32 63, i32 79, i32 95, i32 111>
  store <112 x i8> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i8_stride7_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i8_stride7_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $360, %rsp # imm = 0x168
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    movdqa 16(%rsi), %xmm4
; SSE-NEXT:    movdqa 16(%rdx), %xmm3
; SSE-NEXT:    movdqa 16(%rcx), %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%r8), %xmm6
; SSE-NEXT:    movdqa 16(%r9), %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm1[0,1,2,3,6,6,6,6]
; SSE-NEXT:    movdqa %xmm1, %xmm15
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm4, %xmm8
; SSE-NEXT:    movdqa %xmm4, %xmm13
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhbw {{.*#+}} xmm8 = xmm8[8],xmm4[8],xmm8[9],xmm4[9],xmm8[10],xmm4[10],xmm8[11],xmm4[11],xmm8[12],xmm4[12],xmm8[13],xmm4[13],xmm8[14],xmm4[14],xmm8[15],xmm4[15]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm8[0,1,2,3,4,5,5,7]
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm11
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm3[0,1,2,3,6,6,6,6]
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm7[8],xmm2[9],xmm7[9],xmm2[10],xmm7[10],xmm2[11],xmm7[11],xmm2[12],xmm7[12],xmm2[13],xmm7[13],xmm2[14],xmm7[14],xmm2[15],xmm7[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[2,1,2,3]
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pand %xmm9, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm6[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,2]
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm5[8],xmm1[9],xmm5[9],xmm1[10],xmm5[10],xmm1[11],xmm5[11],xmm1[12],xmm5[12],xmm1[13],xmm5[13],xmm1[14],xmm5[14],xmm1[15],xmm5[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,2,3]
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa 16(%rax), %xmm14
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm14[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm7[0,1,2,3,6,5,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm4[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm8[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,3]
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm15[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,2]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm6[0,1,2,3,7,7,7,7]
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pand %xmm9, %xmm3
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm5[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,2,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm14[0,1,2,3,6,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,2]
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm4
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm13[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,0,3]
; SSE-NEXT:    movdqa %xmm12, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm15[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    pshufd $230, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm15, %xmm7
; SSE-NEXT:    pandn %xmm1, %xmm7
; SSE-NEXT:    pshuflw $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm15, %xmm1
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm7, %xmm3
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshufd $230, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,3,2,0]
; SSE-NEXT:    movdqa %xmm9, %xmm7
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm6[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm9, %xmm4
; SSE-NEXT:    por %xmm4, %xmm7
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm14[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    pandn %xmm4, %xmm8
; SSE-NEXT:    pand %xmm0, %xmm7
; SSE-NEXT:    por %xmm7, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm8, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsi), %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,1,2,3]
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[3,1,0,3]
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    movdqa (%rdi), %xmm13
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm13[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm12, %xmm4
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa (%rcx), %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[2,1,2,3]
; SSE-NEXT:    movdqa %xmm2, %xmm14
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,3,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm15, %xmm7
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    movdqa (%rdx), %xmm8
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm8[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm8, (%rsp) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm15, %xmm4
; SSE-NEXT:    por %xmm4, %xmm7
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm7, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa (%r9), %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm11[2,1,2,3]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,2,0]
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movdqa (%r8), %xmm7
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm7[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm9, %xmm3
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    pand %xmm0, %xmm4
; SSE-NEXT:    movdqa (%rax), %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm10[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm6[8],xmm0[9],xmm6[9],xmm0[10],xmm6[10],xmm0[11],xmm6[11],xmm0[12],xmm6[12],xmm0[13],xmm6[13],xmm0[14],xmm6[14],xmm0[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm13[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm8[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm14[8],xmm0[9],xmm14[9],xmm0[10],xmm14[10],xmm0[11],xmm14[11],xmm0[12],xmm14[12],xmm0[13],xmm14[13],xmm0[14],xmm14[14],xmm0[15],xmm14[15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm11 = xmm11[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm11[1,1,2,3]
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm7[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,2]
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm10[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm11 = xmm11[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[2,2,3,3]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm7[2,1,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; SSE-NEXT:    movdqa %xmm13, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm6[0,1,2,3,5,6,6,7]
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm15, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm4[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,0,0,0,0,255,255,255,0,0,0,0,255,255]
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm8[0,1,2,3,4,6,5,7]
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm10[2,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm5[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm14
; SSE-NEXT:    pandn %xmm1, %xmm14
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    por %xmm3, %xmm14
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm14
; SSE-NEXT:    por %xmm0, %xmm14
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,1,2,2]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm4[1,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm13, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[1,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm0[0,1,2,3,7,5,6,4]
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm7[1,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,0,2,1]
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    movdqa %xmm12, %xmm11
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm8[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,1,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm10[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm5[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    movdqa %xmm15, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,1,1,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa (%rsp), %xmm8 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm8[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,2]
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0]
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm5[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    pshuflw $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pshuflw $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,0,0,0]
; SSE-NEXT:    movdqa %xmm15, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm13[0,1,2,3,4,4,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,3,3]
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm12[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm1, %xmm10
; SSE-NEXT:    pandn %xmm3, %xmm10
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    por %xmm4, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm10, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm14 = xmm14[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm14[0,1,2,2]
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm5[1,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[1,1,2,1]
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm0[0,1,2,3,7,5,6,4]
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm8[1,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,2,1]
; SSE-NEXT:    pand %xmm11, %xmm4
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm8[0,2,2,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,1,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm13, %xmm5
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm13[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,0,0,0]
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm12[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,0,0,0]
; SSE-NEXT:    movdqa %xmm15, %xmm10
; SSE-NEXT:    pandn %xmm3, %xmm10
; SSE-NEXT:    pand %xmm15, %xmm4
; SSE-NEXT:    por %xmm4, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm10, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm7[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm14[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm3[0,1,1,0]
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm10, %xmm3
; SSE-NEXT:    pshuflw $96, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    # xmm10 = mem[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,0,2,1]
; SSE-NEXT:    pand %xmm11, %xmm10
; SSE-NEXT:    por %xmm10, %xmm3
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm8[0,1,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,2,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm13, %xmm10
; SSE-NEXT:    pandn %xmm4, %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm5[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE-NEXT:    pand %xmm13, %xmm4
; SSE-NEXT:    por %xmm4, %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm12[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    pand %xmm9, %xmm10
; SSE-NEXT:    por %xmm10, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,1,1,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm4[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,3,2]
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm12[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,2,2,2]
; SSE-NEXT:    movdqa %xmm9, %xmm5
; SSE-NEXT:    pandn %xmm3, %xmm5
; SSE-NEXT:    pshuflw $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,0,2,1]
; SSE-NEXT:    pand %xmm9, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    pshuflw $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa %xmm15, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm8[0,1,2,3,4,4,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,3,3]
; SSE-NEXT:    pand %xmm15, %xmm2
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm10[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    movdqa %xmm13, %xmm5
; SSE-NEXT:    pandn %xmm2, %xmm5
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; SSE-NEXT:    pand %xmm14, %xmm6
; SSE-NEXT:    pandn %xmm5, %xmm14
; SSE-NEXT:    por %xmm6, %xmm14
; SSE-NEXT:    pshuflw $96, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,1,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm4[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    pshuflw $216, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,1,0]
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm12[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pshuflw $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm8[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm10[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    por %xmm0, %xmm7
; SSE-NEXT:    movdqa (%rsp), %xmm5 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm5[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    pshufhw $246, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,2,3,6,5,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pandn %xmm1, %xmm13
; SSE-NEXT:    por %xmm0, %xmm13
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm6[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    pshufhw $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,3]
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm13, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm4[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,3]
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm13[0,1,2,3,6,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,2]
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[2,2,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm5[2,1,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm9
; SSE-NEXT:    por %xmm2, %xmm9
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm6[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,1,3]
; SSE-NEXT:    pand %xmm15, %xmm1
; SSE-NEXT:    pshufhw $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,2,2,2]
; SSE-NEXT:    pandn %xmm2, %xmm15
; SSE-NEXT:    por %xmm1, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; SSE-NEXT:    pand %xmm1, %xmm15
; SSE-NEXT:    pandn %xmm9, %xmm1
; SSE-NEXT:    por %xmm15, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm4[2,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,1]
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    pshufhw $216, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,3,2]
; SSE-NEXT:    pandn %xmm2, %xmm11
; SSE-NEXT:    por %xmm1, %xmm11
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm4, %xmm11
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm13[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    por %xmm11, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,0,0,0,0,255,255,255,0,0,0,0,255,255]
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm4, 32(%rax)
; SSE-NEXT:    movdqa %xmm0, 96(%rax)
; SSE-NEXT:    movdqa %xmm7, 112(%rax)
; SSE-NEXT:    movdqa %xmm14, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    addq $360, %rsp # imm = 0x168
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i8_stride7_vf32:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $216, %rsp
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovdqa 16(%rax), %xmm14
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm14[u,u,u],zero,zero,xmm14[9,u,u,u,u],zero,zero,xmm14[10,u,u,u]
; AVX-NEXT:    vmovdqa 16(%r9), %xmm2
; AVX-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa 16(%r8), %xmm3
; AVX-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm3[8],xmm2[8],xmm3[9],xmm2[9],xmm3[10],xmm2[10],xmm3[11],xmm2[11],xmm3[12],xmm2[12],xmm3[13],xmm2[13],xmm3[14],xmm2[14],xmm3[15],xmm2[15]
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,2,3],zero,xmm1[u,u,u,u,4,5],zero,xmm1[u,u,u]
; AVX-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vmovdqa {{.*#+}} xmm11 = [u,u,u,u,u,128,7,u,u,u,u,u,128,8,u,u]
; AVX-NEXT:    vpshufb %xmm11, %xmm2, %xmm1
; AVX-NEXT:    vmovdqa {{.*#+}} xmm12 = [u,u,u,u,u,7,128,u,u,u,u,u,8,128,u,u]
; AVX-NEXT:    vpshufb %xmm12, %xmm3, %xmm3
; AVX-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX-NEXT:    vmovdqa {{.*#+}} xmm8 = [128,u,u,u,u,5,6,128,u,u,u,u,12,13,128,u]
; AVX-NEXT:    vpshufb %xmm8, %xmm1, %xmm1
; AVX-NEXT:    vmovdqa {{.*#+}} xmm5 = [6,u,u,u,u,128,128,7,u,u,u,u,128,128,8,u]
; AVX-NEXT:    vpshufb %xmm5, %xmm14, %xmm3
; AVX-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm7
; AVX-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa {{.*#+}} xmm4 = [u,u,u,128,7,u,u,u,u,u,128,8,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm4, %xmm1, %xmm0
; AVX-NEXT:    vmovdqa 16(%rdx), %xmm2
; AVX-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa {{.*#+}} xmm9 = [u,u,u,7,128,u,u,u,u,u,8,128,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm9, %xmm2, %xmm3
; AVX-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm2[8],xmm1[8],xmm2[9],xmm1[9],xmm2[10],xmm1[10],xmm2[11],xmm1[11],xmm2[12],xmm1[12],xmm2[13],xmm1[13],xmm2[14],xmm1[14],xmm2[15],xmm1[15]
; AVX-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,2,3,u,u,u,u,u,4,5,u,u,u,u,u,6]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm15
; AVX-NEXT:    vmovdqa 16(%rsi), %xmm10
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [u,128,7,u,u,u,u,u,128,8,u,u,u,u,u,128]
; AVX-NEXT:    vpshufb %xmm1, %xmm10, %xmm0
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm6[u,7],zero,xmm6[u,u,u,u,u,8],zero,xmm6[u,u,u,u,u,9]
; AVX-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm10[8],xmm6[8],xmm10[9],xmm6[9],xmm10[10],xmm6[10],xmm10[11],xmm6[11],xmm10[12],xmm6[12],xmm10[13],xmm6[13],xmm10[14],xmm6[14],xmm10[15],xmm6[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[2,u,u,u,u,u,5,4,u,u,u,u,u,7,6,u]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0]
; AVX-NEXT:    vandnps %ymm15, %ymm2, %ymm15
; AVX-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX-NEXT:    vorps %ymm0, %ymm15, %ymm0
; AVX-NEXT:    vmovaps {{.*#+}} ymm2 = [0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; AVX-NEXT:    vandnps %ymm7, %ymm2, %ymm7
; AVX-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX-NEXT:    vorps %ymm7, %ymm0, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa (%r9), %xmm2
; AVX-NEXT:    vpshufb %xmm11, %xmm2, %xmm0
; AVX-NEXT:    vmovdqa %xmm2, %xmm7
; AVX-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa (%r8), %xmm3
; AVX-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm12, %xmm3, %xmm2
; AVX-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX-NEXT:    vpshufb %xmm8, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa (%rax), %xmm8
; AVX-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm5, %xmm8, %xmm2
; AVX-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa {{.*#+}} xmm5 = [128,128,4,u,u,u,u,128,128,5,u,u,u,u,128,128]
; AVX-NEXT:    vpshufb %xmm5, %xmm8, %xmm2
; AVX-NEXT:    vmovdqa %xmm5, %xmm8
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm3[0],xmm7[0],xmm3[1],xmm7[1],xmm3[2],xmm7[2],xmm3[3],xmm7[3],xmm3[4],xmm7[4],xmm3[5],xmm7[5],xmm3[6],xmm7[6],xmm3[7],xmm7[7]
; AVX-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm3[8,9],zero,xmm3[u,u,u,u,10,11],zero,xmm3[u,u,u,u,12,13]
; AVX-NEXT:    vpor %xmm2, %xmm5, %xmm2
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm15
; AVX-NEXT:    vmovdqa (%rcx), %xmm3
; AVX-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm4, %xmm3, %xmm0
; AVX-NEXT:    vmovdqa (%rdx), %xmm13
; AVX-NEXT:    vpshufb %xmm9, %xmm13, %xmm2
; AVX-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm13[0],xmm3[0],xmm13[1],xmm3[1],xmm13[2],xmm3[2],xmm13[3],xmm3[3],xmm13[4],xmm3[4],xmm13[5],xmm3[5],xmm13[6],xmm3[6],xmm13[7],xmm3[7]
; AVX-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,10,11,u,u,u,u,u,12,13,u,u]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX-NEXT:    vmovdqa (%rsi), %xmm5
; AVX-NEXT:    vpshufb %xmm1, %xmm5, %xmm2
; AVX-NEXT:    vmovdqa (%rdi), %xmm3
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm3[u,7],zero,xmm3[u,u,u,u,u,8],zero,xmm3[u,u,u,u,u,9]
; AVX-NEXT:    vpor %xmm2, %xmm11, %xmm2
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm9 = xmm3[0],xmm5[0],xmm3[1],xmm5[1],xmm3[2],xmm5[2],xmm3[3],xmm5[3],xmm3[4],xmm5[4],xmm3[5],xmm5[5],xmm3[6],xmm5[6],xmm3[7],xmm5[7]
; AVX-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa {{.*#+}} xmm12 = [u,u,u,10,11,u,u,u,u,u,12,13,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm12, %xmm9, %xmm11
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm11, %ymm11
; AVX-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255]
; AVX-NEXT:    vandnps %ymm0, %ymm4, %ymm0
; AVX-NEXT:    vandps %ymm4, %ymm11, %ymm11
; AVX-NEXT:    vorps %ymm0, %ymm11, %ymm0
; AVX-NEXT:    vmovaps {{.*#+}} ymm11 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX-NEXT:    vandnps %ymm15, %ymm11, %ymm15
; AVX-NEXT:    vandps %ymm0, %ymm11, %ymm0
; AVX-NEXT:    vorps %ymm0, %ymm15, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm8, %xmm14, %xmm0
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3],xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; AVX-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm1[8,9],zero,xmm1[u,u,u,u,10,11],zero,xmm1[u,u,u,u,12,13]
; AVX-NEXT:    vpor %xmm0, %xmm11, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm14[u,u],zero,zero,xmm14[2,u,u,u,u],zero,zero,xmm14[3,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm15 = xmm1[u,u,4,5],zero,xmm1[u,u,u,u,6,7],zero,xmm1[u,u,u,u]
; AVX-NEXT:    vpor %xmm11, %xmm15, %xmm11
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm11, %ymm15
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm6[0],xmm10[0],xmm6[1],xmm10[1],xmm6[2],xmm10[2],xmm6[3],xmm10[3],xmm6[4],xmm10[4],xmm6[5],xmm10[5],xmm6[6],xmm10[6],xmm6[7],xmm10[7]
; AVX-NEXT:    vpshufb %xmm12, %xmm11, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm12 = xmm11[u,u,u,u,u,6,7,u,u,u,u,u,8,9,u,u]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm12, %ymm12
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm9 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm9[u,u,u,u,u,10,11,u,u,u,u,u,12,13,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm9[4,5,u,u,u,u,u,6,7,u,u,u,u,u,8,9]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm14, %ymm0
; AVX-NEXT:    vandnps %ymm12, %ymm4, %ymm12
; AVX-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX-NEXT:    vorps %ymm0, %ymm12, %ymm0
; AVX-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0]
; AVX-NEXT:    vandnps %ymm15, %ymm4, %ymm12
; AVX-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX-NEXT:    vorps %ymm0, %ymm12, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm6[8],xmm10[8],xmm6[9],xmm10[9],xmm6[10],xmm10[10],xmm6[11],xmm10[11],xmm6[12],xmm10[12],xmm6[13],xmm10[13],xmm6[14],xmm10[14],xmm6[15],xmm10[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[u,u,12,13,u,u,u,u,u,14,15,u,u,u,u,u]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm10 = [u,u,u,u,8,9,u,u,u,u,u,10,11,u,u,u]
; AVX-NEXT:    vpshufb %xmm10, %xmm0, %xmm0
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[u,u,u,u,12,13,u,u,u,u,u,14,15,u,u,u]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm15 = [6,u,u,u,u,u,9,8,u,u,u,u,u,11,10,u]
; AVX-NEXT:    vpshufb %xmm15, %xmm4, %xmm4
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm4, %ymm6
; AVX-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255]
; AVX-NEXT:    vandnps %ymm0, %ymm4, %ymm0
; AVX-NEXT:    vandps %ymm4, %ymm6, %ymm6
; AVX-NEXT:    vorps %ymm0, %ymm6, %ymm0
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm8[8],xmm7[8],xmm8[9],xmm7[9],xmm8[10],xmm7[10],xmm8[11],xmm7[11],xmm8[12],xmm7[12],xmm8[13],xmm7[13],xmm8[14],xmm7[14],xmm8[15],xmm7[15]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,6,7,u,u,u,u,u,8,9,u,u,u,u,u,10]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[10,u,u,u,u,u,13,12,u,u,u,u,u,15,14,u]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm12, %ymm6
; AVX-NEXT:    vmovaps {{.*#+}} ymm12 = [255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255]
; AVX-NEXT:    vandps %ymm0, %ymm12, %ymm0
; AVX-NEXT:    vandnps %ymm6, %ymm12, %ymm6
; AVX-NEXT:    vorps %ymm6, %ymm0, %ymm0
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[0],zero,xmm6[2,3,4,5,6,7],zero,xmm6[9,10,11,12,13,14],zero
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm12 = zero,xmm14[13],zero,zero,zero,zero,zero,zero,xmm14[14],zero,zero,zero,zero,zero,zero,xmm14[15]
; AVX-NEXT:    vpor %xmm6, %xmm12, %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,2],zero,xmm0[4,5,6,7,8,9],zero,xmm0[11,12,13,14,15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm14[11],zero,zero,zero,zero,zero,zero,xmm14[12],zero,zero,zero,zero,zero
; AVX-NEXT:    vpor %xmm6, %xmm0, %xmm0
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm12 = xmm3[8],xmm5[8],xmm3[9],xmm5[9],xmm3[10],xmm5[10],xmm3[11],xmm5[11],xmm3[12],xmm5[12],xmm3[13],xmm5[13],xmm3[14],xmm5[14],xmm3[15],xmm5[15]
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm5[8],xmm3[8],xmm5[9],xmm3[9],xmm5[10],xmm3[10],xmm5[11],xmm3[11],xmm5[12],xmm3[12],xmm5[13],xmm3[13],xmm5[14],xmm3[14],xmm5[15],xmm3[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[2,u,u,u,u,u,5,4,u,u,u,u,u,7,6,u]
; AVX-NEXT:    vpshufb %xmm10, %xmm12, %xmm2
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm3[8],xmm13[8],xmm3[9],xmm13[9],xmm3[10],xmm13[10],xmm3[11],xmm13[11],xmm3[12],xmm13[12],xmm3[13],xmm13[13],xmm3[14],xmm13[14],xmm3[15],xmm13[15]
; AVX-NEXT:    vpshufb %xmm15, %xmm2, %xmm2
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm13[8],xmm3[8],xmm13[9],xmm3[9],xmm13[10],xmm3[10],xmm13[11],xmm3[11],xmm13[12],xmm3[12],xmm13[13],xmm3[13],xmm13[14],xmm3[14],xmm13[15],xmm3[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm3[u,2,3,u,u,u,u,u,4,5,u,u,u,u,u,6]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm5, %ymm2
; AVX-NEXT:    vmovaps {{.*#+}} ymm5 = [0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; AVX-NEXT:    vandnps %ymm1, %ymm5, %ymm1
; AVX-NEXT:    vandps %ymm5, %ymm2, %ymm2
; AVX-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm8[u,u,u],zero,zero,xmm8[9,u,u,u,u],zero,zero,xmm8[10,u,u,u]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm15[8],xmm10[8],xmm15[9],xmm10[9],xmm15[10],xmm10[10],xmm15[11],xmm10[11],xmm15[12],xmm10[12],xmm15[13],xmm10[13],xmm15[14],xmm10[14],xmm15[15],xmm10[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[u,u,u,2,3],zero,xmm5[u,u,u,u,4,5],zero,xmm5[u,u,u]
; AVX-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,6,7],zero,xmm5[u,u,u,u,8,9],zero,xmm5[u,u,u,u,10]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm8[u],zero,zero,xmm8[11,u,u,u,u],zero,zero,xmm8[12,u,u,u,u],zero
; AVX-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm2, %ymm2
; AVX-NEXT:    vmovaps {{.*#+}} ymm5 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX-NEXT:    vandps %ymm5, %ymm1, %ymm1
; AVX-NEXT:    vandnps %ymm2, %ymm5, %ymm2
; AVX-NEXT:    vorps %ymm2, %ymm1, %ymm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm3[u,u,u,u,12,13,u,u,u,u,u,14,15,u,u,u]
; AVX-NEXT:    vpmovsxdq {{.*#+}} xmm2 = [16777216,197120]
; AVX-NEXT:    vpshufb %xmm2, %xmm9, %xmm3
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm12[u,u,12,13,u,u,u,u,u,14,15,u,u,u,u,u]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,u,u,u,u,u,2,3,u,u,u,u,u,4,5]
; AVX-NEXT:    vpshufb %xmm3, %xmm11, %xmm7
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm5, %ymm5
; AVX-NEXT:    vandnps %ymm1, %ymm4, %ymm1
; AVX-NEXT:    vandps %ymm4, %ymm5, %ymm4
; AVX-NEXT:    vorps %ymm1, %ymm4, %ymm4
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [u,u,u,u,0,1,u,u,u,u,u,2,3,u,u,u]
; AVX-NEXT:    vmovdqa (%rsp), %xmm5 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm1, %xmm5, %xmm5
; AVX-NEXT:    vpalignr {{.*#+}} xmm5 = xmm5[4,5,6,7,8,9,10,11,12,13,14,15],xmm14[0,1,2,3]
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm10[8],xmm15[8],xmm10[9],xmm15[9],xmm10[10],xmm15[10],xmm10[11],xmm15[11],xmm10[12],xmm15[12],xmm10[13],xmm15[13],xmm10[14],xmm15[14],xmm10[15],xmm15[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[10],zero,xmm7[u,u,u,u,13,12],zero,xmm7[u,u,u,u,15,14],zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm9 = zero,xmm8[13,u,u,u,u],zero,zero,xmm8[14,u,u,u,u],zero,zero,xmm8[15]
; AVX-NEXT:    vpor %xmm7, %xmm9, %xmm7
; AVX-NEXT:    vmovdqa {{.*#+}} xmm9 = [u,u,u,u,0,1,12,u,u,u,u,7,8,13,u,u]
; AVX-NEXT:    vpshufb %xmm9, %xmm5, %xmm5
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm7, %ymm5
; AVX-NEXT:    vmovaps {{.*#+}} ymm7 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; AVX-NEXT:    vandps %ymm7, %ymm4, %ymm4
; AVX-NEXT:    vandnps %ymm5, %ymm7, %ymm5
; AVX-NEXT:    vorps %ymm5, %ymm4, %ymm5
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm7[4,5,u,u,u,u,u,6,7,u,u,u,u,u,8,9]
; AVX-NEXT:    vpshufb %xmm2, %xmm7, %xmm2
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm7[u,u,u,u,u,6,7,u,u,u,u,u,8,9,u,u]
; AVX-NEXT:    vpshufb %xmm3, %xmm7, %xmm3
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0]
; AVX-NEXT:    vandnps %ymm2, %ymm4, %ymm2
; AVX-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX-NEXT:    vorps %ymm2, %ymm3, %ymm2
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm8[u,u],zero,zero,xmm8[2,u,u,u,u],zero,zero,xmm8[3,u,u,u,u]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm7[u,u,4,5],zero,xmm7[u,u,u,u,6,7],zero,xmm7[u,u,u,u]
; AVX-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX-NEXT:    vpshufb %xmm1, %xmm7, %xmm1
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm8[0,1,2,3]
; AVX-NEXT:    vpshufb %xmm9, %xmm1, %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX-NEXT:    vmovaps {{.*#+}} ymm3 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX-NEXT:    vandps %ymm3, %ymm2, %ymm2
; AVX-NEXT:    vandnps %ymm1, %ymm3, %ymm1
; AVX-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps %ymm1, (%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 128(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 32(%rax)
; AVX-NEXT:    vmovaps %ymm5, 96(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 160(%rax)
; AVX-NEXT:    vmovaps %ymm6, 64(%rax)
; AVX-NEXT:    vmovdqa %xmm0, 192(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 208(%rax)
; AVX-NEXT:    addq $216, %rsp
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i8_stride7_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    pushq %rax
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovdqa (%rdi), %ymm4
; AVX2-NEXT:    vmovdqa (%rsi), %ymm6
; AVX2-NEXT:    vmovdqa (%rdx), %ymm3
; AVX2-NEXT:    vmovdqa (%rcx), %ymm5
; AVX2-NEXT:    vmovdqa (%r8), %ymm7
; AVX2-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa (%r9), %ymm2
; AVX2-NEXT:    vmovdqa (%rax), %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27,u,u,u,u,30,u,28,u,u,u,u,31,u,29,u]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm8 = ymm3[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm8 = ymm8[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [255,0,0,0,0,255,0,255,0,0,0,0,255,0,255,0,255,0,0,0,0,255,0,255,0,0,0,0,255,0,255,0]
; AVX2-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm8 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,30,u,28,u,u,u,u,31,u,29,u,u,u]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm9 = ymm4[0,1,2,3,6,7,7,6,8,9,10,11,14,15,15,14]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[2,2,3,3,6,6,7,7]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm10 = [0,0,255,0,255,0,0,0,0,255,0,255,0,0,0,0,0,0,255,0,255,0,0,0,0,255,0,255,0,0,0,0]
; AVX2-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm10, %ymm9, %ymm8, %ymm8
; AVX2-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm8 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm7[27],zero,ymm7[27,28,29,30],zero,ymm7[28],zero,ymm7[26,27,30,31],zero,ymm7[29]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm9 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm2[27],zero,zero,zero,zero,ymm2[30],zero,ymm2[28],zero,zero,zero,zero,ymm2[31],zero
; AVX2-NEXT:    vpor %ymm8, %ymm9, %ymm8
; AVX2-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,0,0,u,255,255,255,255,0,0,u,255,255,255,255,0,0,u,255,255,255,255,0,0,u,255,255,255,255,0,0,u]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm8 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa (%rdx), %xmm10
; AVX2-NEXT:    vmovdqa (%rcx), %xmm11
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm11[8],xmm10[8],xmm11[9],xmm10[9],xmm11[10],xmm10[10],xmm11[11],xmm10[11],xmm11[12],xmm10[12],xmm11[13],xmm10[13],xmm11[14],xmm10[14],xmm11[15],xmm10[15]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm8 = ymm0[0,1,0,1]
; AVX2-NEXT:    vmovdqa (%rdi), %xmm14
; AVX2-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm9 = xmm0[8],xmm14[8],xmm0[9],xmm14[9],xmm0[10],xmm14[10],xmm0[11],xmm14[11],xmm0[12],xmm14[12],xmm0[13],xmm14[13],xmm0[14],xmm14[14],xmm0[15],xmm14[15]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX2-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm12 = [0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u]
; AVX2-NEXT:    vpblendvb %ymm12, %ymm8, %ymm9, %ymm8
; AVX2-NEXT:    vmovdqa (%r9), %xmm12
; AVX2-NEXT:    vmovdqa (%r8), %xmm13
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm9 = xmm13[8],xmm12[8],xmm13[9],xmm12[9],xmm13[10],xmm12[10],xmm13[11],xmm12[11],xmm13[12],xmm12[12],xmm13[13],xmm12[13],xmm13[14],xmm12[14],xmm13[15],xmm12[15]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX2-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX2-NEXT:    vmovdqa (%rax), %xmm15
; AVX2-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm15[0,1,2,3,4,5,5,6]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255]
; AVX2-NEXT:    vpblendvb %ymm1, %ymm9, %ymm7, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm8, %ymm1, %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[u],zero,xmm0[7],zero,xmm0[5,u,u,u],zero,xmm0[8],zero,xmm0[6,u,u,u],zero
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = xmm14[u,7],zero,xmm14[5],zero,xmm14[u,u,u,8],zero,xmm14[6],zero,xmm14[u,u,u,9]
; AVX2-NEXT:    vpor %xmm1, %xmm7, %xmm1
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = xmm11[u,u,u],zero,xmm11[7],zero,xmm11[5,u,u,u],zero,xmm11[8],zero,xmm11[6,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm9 = xmm10[u,u,u,7],zero,xmm10[5],zero,xmm10[u,u,u,8],zero,xmm10[6],zero,xmm10[u,u]
; AVX2-NEXT:    vpor %xmm7, %xmm9, %xmm7
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm1, %ymm7, %ymm1
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = zero,xmm12[4,u,u,u],zero,xmm12[7],zero,xmm12[5,u,u,u],zero,xmm12[8],zero,xmm12[6]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm9 = xmm13[4],zero,xmm13[u,u,u,7],zero,xmm13[5],zero,xmm13[u,u,u,8],zero,xmm13[6],zero
; AVX2-NEXT:    vpor %xmm7, %xmm9, %xmm7
; AVX2-NEXT:    vpshufb {{.*#+}} xmm9 = xmm15[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,0,1,0]
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u]
; AVX2-NEXT:    vpblendvb %ymm8, %ymm7, %ymm9, %ymm7
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX2-NEXT:    vpblendvb %ymm8, %ymm1, %ymm7, %ymm9
; AVX2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm14[0],xmm0[0],xmm14[1],xmm0[1],xmm14[2],xmm0[2],xmm14[3],xmm0[3],xmm14[4],xmm0[4],xmm14[5],xmm0[5],xmm14[6],xmm0[6],xmm14[7],xmm0[7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm10[0],xmm11[0],xmm10[1],xmm11[1],xmm10[2],xmm11[2],xmm10[3],xmm11[3],xmm10[4],xmm11[4],xmm10[5],xmm11[5],xmm10[6],xmm11[6],xmm10[7],xmm11[7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm13[0],xmm12[0],xmm13[1],xmm12[1],xmm13[2],xmm12[2],xmm13[3],xmm12[3],xmm13[4],xmm12[4],xmm13[5],xmm12[5],xmm13[6],xmm12[6],xmm13[7],xmm12[7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm15[1,1,0,0,4,5,6,7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,1,2,0]
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,0,1,0]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u]
; AVX2-NEXT:    vpblendvb %ymm8, %ymm1, %ymm7, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm10
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,21,u,19,u,u,u,u,22,u,20,u,u]
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm4[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,0,1,1,4,4,5,5]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [0,0,0,255,0,255,0,0,0,0,255,0,255,0,0,0,0,0,0,255,0,255,0,0,0,0,255,0,255,0,0,0]
; AVX2-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm5[18],zero,zero,zero,zero,ymm5[21],zero,ymm5[19],zero,zero,zero,zero,ymm5[22],zero,ymm5[20]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm7 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18],zero,zero,zero,zero,ymm3[21],zero,ymm3[19],zero,zero,zero,zero,ymm3[22],zero,ymm3[20],zero
; AVX2-NEXT:    vpor %ymm1, %ymm7, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm2[20],zero,ymm2[18],zero,zero,zero,zero,ymm2[21],zero,ymm2[19],zero,zero,zero,zero,ymm2[22]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-NEXT:    vpshufb {{.*#+}} ymm7 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20],zero,ymm12[18],zero,zero,zero,zero,ymm12[21],zero,ymm12[19],zero,zero,zero,zero,ymm12[22],zero
; AVX2-NEXT:    vpor %ymm1, %ymm7, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm7 = ymm11[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm7 = ymm7[0,1,1,3,4,5,5,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,2,3,2]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255]
; AVX2-NEXT:    vpblendvb %ymm8, %ymm1, %ymm7, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm4[23],zero,ymm4[27,20,21,26],zero,ymm4[24],zero,ymm4[26,27,26,27],zero,ymm4[25]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm7 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm6[23],zero,zero,zero,zero,ymm6[26],zero,ymm6[24],zero,zero,zero,zero,ymm6[27],zero
; AVX2-NEXT:    vpor %ymm1, %ymm7, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm7 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm5[25],zero,ymm5[23],zero,zero,zero,zero,ymm5[26],zero,ymm5[24],zero,zero,zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} ymm8 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm3[25],zero,ymm3[23],zero,zero,zero,zero,ymm3[26],zero,ymm3[24],zero,zero,zero,zero,ymm3[27]
; AVX2-NEXT:    vpor %ymm7, %ymm8, %ymm7
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0]
; AVX2-NEXT:    vpblendvb %ymm8, %ymm1, %ymm7, %ymm1
; AVX2-NEXT:    vpshufb {{.*#+}} ymm7 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} ymm8 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm12[25],zero,ymm12[23],zero,zero,zero,zero,ymm12[26],zero,ymm12[24],zero,zero,zero
; AVX2-NEXT:    vmovdqa %ymm12, %ymm13
; AVX2-NEXT:    vpor %ymm7, %ymm8, %ymm7
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm8 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX2-NEXT:    vmovdqa %ymm11, %ymm12
; AVX2-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm11 = [0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u]
; AVX2-NEXT:    vpblendvb %ymm11, %ymm7, %ymm8, %ymm7
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; AVX2-NEXT:    vpblendvb %ymm8, %ymm1, %ymm7, %ymm1
; AVX2-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,ymm6[14],zero,zero,zero,zero,zero,zero,ymm6[15],zero,zero,zero,zero,zero,zero,ymm6[16],zero,zero,zero,zero,zero,zero,ymm6[17],zero,zero,zero,zero,zero,zero,ymm6[18]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,ymm4[14],zero,zero,zero,zero,zero,zero,ymm4[15],zero,zero,zero,zero,zero,zero,ymm4[16],zero,zero,zero,zero,zero,zero,ymm4[17],zero,zero,zero,zero,zero,zero,ymm4[18],zero
; AVX2-NEXT:    vpor %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,ymm5[14],zero,zero,zero,zero,zero,zero,ymm5[15],zero,zero,zero,zero,zero,zero,ymm5[16],zero,zero,zero,zero,zero,zero,ymm5[17],zero,zero,zero,zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,zero,ymm3[14],zero,zero,zero,zero,zero,zero,ymm3[15],zero,zero,zero,zero,zero,zero,ymm3[16],zero,zero,zero,zero,zero,zero,ymm3[17],zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vpor %ymm5, %ymm3, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255]
; AVX2-NEXT:    vpblendvb %ymm5, %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpshufb {{.*#+}} ymm4 = zero,ymm13[1,2,3,0,1,14],zero,ymm13[0,1,0,1,14,15],zero,ymm13[15,16,17,18,19,16],zero,ymm13[30,31,16,17,16,17],zero,ymm13[31,30,31]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[13],zero,zero,zero,zero,zero,zero,ymm2[14],zero,zero,zero,zero,zero,zero,ymm2[15],zero,zero,zero,zero,zero,zero,ymm2[16],zero,zero,zero,zero,zero,zero,ymm2[17],zero,zero,zero
; AVX2-NEXT:    vpor %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb {{.*#+}} ymm4 = ymm12[12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u]
; AVX2-NEXT:    vpblendvb %ymm5, %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; AVX2-NEXT:    vpblendvb %ymm4, %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovdqa %ymm2, 96(%rax)
; AVX2-NEXT:    vmovdqa %ymm1, 160(%rax)
; AVX2-NEXT:    vmovdqa %ymm10, (%rax)
; AVX2-NEXT:    vmovdqa %ymm0, 128(%rax)
; AVX2-NEXT:    vmovdqa %ymm9, 32(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-NEXT:    popq %rax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i8_stride7_vf32:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqa (%rsi), %ymm3
; AVX2-FP-NEXT:    vmovdqa (%rdx), %ymm0
; AVX2-FP-NEXT:    vmovdqa (%rcx), %ymm2
; AVX2-FP-NEXT:    vmovdqa (%rdx), %xmm9
; AVX2-FP-NEXT:    vmovdqa (%rcx), %xmm10
; AVX2-FP-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm10[8],xmm9[8],xmm10[9],xmm9[9],xmm10[10],xmm9[10],xmm10[11],xmm9[11],xmm10[12],xmm9[12],xmm10[13],xmm9[13],xmm10[14],xmm9[14],xmm10[15],xmm9[15]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm13
; AVX2-FP-NEXT:    vmovdqa (%rsi), %xmm15
; AVX2-FP-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm15[8],xmm13[8],xmm15[9],xmm13[9],xmm15[10],xmm13[10],xmm15[11],xmm13[11],xmm15[12],xmm13[12],xmm15[13],xmm13[13],xmm15[14],xmm13[14],xmm15[15],xmm13[15]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u]
; AVX2-FP-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-FP-NEXT:    vmovdqa (%rax), %xmm11
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm11[8,9,10,11,8,9,10,11,10,11,12,13,10,11,12,13]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa (%r9), %xmm12
; AVX2-FP-NEXT:    vmovdqa (%r8), %xmm14
; AVX2-FP-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm14[8],xmm12[8],xmm14[9],xmm12[9],xmm14[10],xmm12[10],xmm14[11],xmm12[11],xmm14[12],xmm12[12],xmm14[13],xmm12[13],xmm14[14],xmm12[14],xmm14[15],xmm12[15]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm7 = [u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255]
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm6, %ymm5, %ymm5
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX2-FP-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm15[u],zero,xmm15[7],zero,xmm15[5,u,u,u],zero,xmm15[8],zero,xmm15[6,u,u,u],zero
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm13[u,7],zero,xmm13[5],zero,xmm13[u,u,u,8],zero,xmm13[6],zero,xmm13[u,u,u,9]
; AVX2-FP-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm10[u,u,u],zero,xmm10[7],zero,xmm10[5,u,u,u],zero,xmm10[8],zero,xmm10[6,u,u]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm9[u,u,u,7],zero,xmm9[5],zero,xmm9[u,u,u,8],zero,xmm9[6],zero,xmm9[u,u]
; AVX2-FP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm7 = [u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255]
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm11[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,0,1,0]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,xmm12[4,u,u,u],zero,xmm12[7],zero,xmm12[5,u,u,u],zero,xmm12[8],zero,xmm12[6]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm14[4],zero,xmm14[u,u,u,7],zero,xmm14[5],zero,xmm14[u,u,u,8],zero,xmm14[6],zero
; AVX2-FP-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u]
; AVX2-FP-NEXT:    vpblendvb %ymm8, %ymm7, %ymm6, %ymm7
; AVX2-FP-NEXT:    vmovdqa (%r8), %ymm6
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX2-FP-NEXT:    vpblendvb %ymm8, %ymm5, %ymm7, %ymm5
; AVX2-FP-NEXT:    vmovdqa (%r9), %ymm8
; AVX2-FP-NEXT:    vmovdqa (%rax), %ymm7
; AVX2-FP-NEXT:    vpunpcklbw {{.*#+}} xmm13 = xmm13[0],xmm15[0],xmm13[1],xmm15[1],xmm13[2],xmm15[2],xmm13[3],xmm15[3],xmm13[4],xmm15[4],xmm13[5],xmm15[5],xmm13[6],xmm15[6],xmm13[7],xmm15[7]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,0,1]
; AVX2-FP-NEXT:    vpunpcklbw {{.*#+}} xmm9 = xmm9[0],xmm10[0],xmm9[1],xmm10[1],xmm9[2],xmm10[2],xmm9[3],xmm10[3],xmm9[4],xmm10[4],xmm9[5],xmm10[5],xmm9[6],xmm10[6],xmm9[7],xmm10[7]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0]
; AVX2-FP-NEXT:    vpblendvb %ymm10, %ymm13, %ymm9, %ymm9
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm11[2,3,2,3,0,1,0,1,8,9,10,11,2,3,2,3]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,0,1,0]
; AVX2-FP-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3],xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm12 = [u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm12, %ymm11, %ymm10, %ymm10
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm11, %ymm9, %ymm10, %ymm9
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm0[17,18,19,30],zero,ymm0[28],zero,ymm0[28,29,30,31],zero,ymm0[29],zero,ymm0[31]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27],zero,zero,zero,zero,ymm2[30],zero,ymm2[28],zero,zero,zero,zero,ymm2[31],zero,ymm2[29],zero
; AVX2-FP-NEXT:    vpor %ymm10, %ymm11, %ymm10
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,3,2,3]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm3[30],zero,ymm3[28],zero,zero,zero,zero,ymm3[31],zero,ymm3[29],zero,zero,zero
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero,ymm1[29],zero,zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm12, %ymm10, %ymm11, %ymm10
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm6[27],zero,ymm6[27,28,29,30],zero,ymm6[28],zero,ymm6[26,27,30,31],zero,ymm6[29]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm8[27],zero,zero,zero,zero,ymm8[30],zero,ymm8[28],zero,zero,zero,zero,ymm8[31],zero
; AVX2-FP-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,0,0,u,255,255,255,255,0,0,u,255,255,255,255,0,0,u,255,255,255,255,0,0,u,255,255,255,255,0,0,u]
; AVX2-FP-NEXT:    vpblendvb %ymm12, %ymm10, %ymm11, %ymm10
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; AVX2-FP-NEXT:    vpblendvb %ymm12, %ymm10, %ymm11, %ymm10
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm1[23],zero,ymm1[27,20,21,26],zero,ymm1[24],zero,ymm1[26,27,26,27],zero,ymm1[25]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm3[23],zero,zero,zero,zero,ymm3[26],zero,ymm3[24],zero,zero,zero,zero,ymm3[27],zero
; AVX2-FP-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero,zero,zero
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm0[25],zero,ymm0[23],zero,zero,zero,zero,ymm0[26],zero,ymm0[24],zero,zero,zero,zero,ymm0[27]
; AVX2-FP-NEXT:    vpor %ymm12, %ymm13, %ymm12
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0]
; AVX2-FP-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm8[25],zero,ymm8[23],zero,zero,zero,zero,ymm8[26],zero,ymm8[24],zero,zero
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm6[25],zero,ymm6[23],zero,zero,zero,zero,ymm6[26],zero,ymm6[24],zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm12, %ymm13, %ymm12
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,3]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm14 = [0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm14, %ymm12, %ymm13, %ymm12
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm13 = [0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm2[18],zero,zero,zero,zero,ymm2[21],zero,ymm2[19],zero,zero,zero,zero,ymm2[22],zero,ymm2[20]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18],zero,zero,zero,zero,ymm0[21],zero,ymm0[19],zero,zero,zero,zero,ymm0[22],zero,ymm0[20],zero
; AVX2-FP-NEXT:    vpor %ymm12, %ymm13, %ymm12
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,3]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm3[21],zero,ymm3[19],zero,zero,zero,zero,ymm3[22],zero,ymm3[20],zero,zero
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm14 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm1[21],zero,ymm1[19],zero,zero,zero,zero,ymm1[22],zero,ymm1[20],zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm13, %ymm14, %ymm13
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm14 = [255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm14, %ymm12, %ymm13, %ymm12
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm8[20],zero,ymm8[18],zero,zero,zero,zero,ymm8[21],zero,ymm8[19],zero,zero,zero,zero,ymm8[22]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm14 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20],zero,ymm6[18],zero,zero,zero,zero,ymm6[21],zero,ymm6[19],zero,zero,zero,zero,ymm6[22],zero
; AVX2-FP-NEXT:    vpor %ymm13, %ymm14, %ymm13
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,3,2,3]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm14 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20,21,18,19,18,19,20,21,18,19,20,21,28,29,30,31]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,2,3,2]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm15 = [u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm15, %ymm13, %ymm14, %ymm13
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm14 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0]
; AVX2-FP-NEXT:    vpblendvb %ymm14, %ymm12, %ymm13, %ymm12
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,ymm3[14],zero,zero,zero,zero,zero,zero,ymm3[15],zero,zero,zero,zero,zero,zero,ymm3[16],zero,zero,zero,zero,zero,zero,ymm3[17],zero,zero,zero,zero,zero,zero,ymm3[18]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,ymm1[14],zero,zero,zero,zero,zero,zero,ymm1[15],zero,zero,zero,zero,zero,zero,ymm1[16],zero,zero,zero,zero,zero,zero,ymm1[17],zero,zero,zero,zero,zero,zero,ymm1[18],zero
; AVX2-FP-NEXT:    vpor %ymm3, %ymm1, %ymm1
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,ymm2[14],zero,zero,zero,zero,zero,zero,ymm2[15],zero,zero,zero,zero,zero,zero,ymm2[16],zero,zero,zero,zero,zero,zero,ymm2[17],zero,zero,zero,zero,zero
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[14],zero,zero,zero,zero,zero,zero,ymm0[15],zero,zero,zero,zero,zero,zero,ymm0[16],zero,zero,zero,zero,zero,zero,ymm0[17],zero,zero,zero,zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = zero,ymm6[1,2,3,0,1,14],zero,ymm6[0,1,0,1,14,15],zero,ymm6[15,16,17,18,19,16],zero,ymm6[30,31,16,17,16,17],zero,ymm6[31,30,31]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm8[13],zero,zero,zero,zero,zero,zero,ymm8[14],zero,zero,zero,zero,zero,zero,ymm8[15],zero,zero,zero,zero,zero,zero,ymm8[16],zero,zero,zero,zero,zero,zero,ymm8[17],zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm7[12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovdqa %ymm0, 96(%rax)
; AVX2-FP-NEXT:    vmovdqa %ymm12, 128(%rax)
; AVX2-FP-NEXT:    vmovdqa %ymm11, 160(%rax)
; AVX2-FP-NEXT:    vmovdqa %ymm9, (%rax)
; AVX2-FP-NEXT:    vmovdqa %ymm10, 192(%rax)
; AVX2-FP-NEXT:    vmovdqa %ymm5, 32(%rax)
; AVX2-FP-NEXT:    vmovdqa %ymm4, 64(%rax)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i8_stride7_vf32:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqa (%rsi), %ymm3
; AVX2-FCP-NEXT:    vmovdqa (%rdx), %ymm0
; AVX2-FCP-NEXT:    vmovdqa (%rcx), %ymm2
; AVX2-FCP-NEXT:    vmovdqa (%rdx), %xmm9
; AVX2-FCP-NEXT:    vmovdqa (%rcx), %xmm10
; AVX2-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm10[8],xmm9[8],xmm10[9],xmm9[9],xmm10[10],xmm9[10],xmm10[11],xmm9[11],xmm10[12],xmm9[12],xmm10[13],xmm9[13],xmm10[14],xmm9[14],xmm10[15],xmm9[15]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm13
; AVX2-FCP-NEXT:    vmovdqa (%rsi), %xmm15
; AVX2-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm15[8],xmm13[8],xmm15[9],xmm13[9],xmm15[10],xmm13[10],xmm15[11],xmm13[11],xmm15[12],xmm13[12],xmm15[13],xmm13[13],xmm15[14],xmm13[14],xmm15[15],xmm13[15]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-FCP-NEXT:    vmovdqa (%rax), %xmm11
; AVX2-FCP-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm11[0,1,2,3,4,5,5,6]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [2,2,3,3,2,2,3,3]
; AVX2-FCP-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermd %ymm5, %ymm6, %ymm5
; AVX2-FCP-NEXT:    vmovdqa (%r9), %xmm12
; AVX2-FCP-NEXT:    vmovdqa (%r8), %xmm14
; AVX2-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm14[8],xmm12[8],xmm14[9],xmm12[9],xmm14[10],xmm12[10],xmm14[11],xmm12[11],xmm14[12],xmm12[12],xmm14[13],xmm12[13],xmm14[14],xmm12[14],xmm14[15],xmm12[15]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm7 = [u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm7, %ymm6, %ymm5, %ymm5
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm15[u],zero,xmm15[7],zero,xmm15[5,u,u,u],zero,xmm15[8],zero,xmm15[6,u,u,u],zero
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm13[u,7],zero,xmm13[5],zero,xmm13[u,u,u,8],zero,xmm13[6],zero,xmm13[u,u,u,9]
; AVX2-FCP-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm10[u,u,u],zero,xmm10[7],zero,xmm10[5,u,u,u],zero,xmm10[8],zero,xmm10[6,u,u]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm9[u,u,u,7],zero,xmm9[5],zero,xmm9[u,u,u,8],zero,xmm9[6],zero,xmm9[u,u]
; AVX2-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm7 = [u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm11[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,0,1,0]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,xmm12[4,u,u,u],zero,xmm12[7],zero,xmm12[5,u,u,u],zero,xmm12[8],zero,xmm12[6]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm14[4],zero,xmm14[u,u,u,7],zero,xmm14[5],zero,xmm14[u,u,u,8],zero,xmm14[6],zero
; AVX2-FCP-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm8, %ymm7, %ymm6, %ymm7
; AVX2-FCP-NEXT:    vmovdqa (%r8), %ymm6
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm8, %ymm5, %ymm7, %ymm5
; AVX2-FCP-NEXT:    vmovdqa (%r9), %ymm8
; AVX2-FCP-NEXT:    vmovdqa (%rax), %ymm7
; AVX2-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm13 = xmm13[0],xmm15[0],xmm13[1],xmm15[1],xmm13[2],xmm15[2],xmm13[3],xmm15[3],xmm13[4],xmm15[4],xmm13[5],xmm15[5],xmm13[6],xmm15[6],xmm13[7],xmm15[7]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,0,1]
; AVX2-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm9 = xmm9[0],xmm10[0],xmm9[1],xmm10[1],xmm9[2],xmm10[2],xmm9[3],xmm10[3],xmm9[4],xmm10[4],xmm9[5],xmm10[5],xmm9[6],xmm10[6],xmm9[7],xmm10[7]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm10, %ymm13, %ymm9, %ymm9
; AVX2-FCP-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm11[1,1,0,0,4,5,6,7]
; AVX2-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm11 = [0,1,0,1,2,0,0,1]
; AVX2-FCP-NEXT:    vpermd %ymm10, %ymm11, %ymm10
; AVX2-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3],xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm12 = [u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm12, %ymm11, %ymm10, %ymm10
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm11, %ymm9, %ymm10, %ymm9
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm2[18],zero,zero,zero,zero,ymm2[21],zero,ymm2[19],zero,zero,zero,zero,ymm2[22],zero,ymm2[20]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18],zero,zero,zero,zero,ymm0[21],zero,ymm0[19],zero,zero,zero,zero,ymm0[22],zero,ymm0[20],zero
; AVX2-FCP-NEXT:    vpor %ymm10, %ymm11, %ymm10
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,3,2,3]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm3[21],zero,ymm3[19],zero,zero,zero,zero,ymm3[22],zero,ymm3[20],zero,zero
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm1[21],zero,ymm1[19],zero,zero,zero,zero,ymm1[22],zero,ymm1[20],zero,zero,zero
; AVX2-FCP-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm12, %ymm10, %ymm11, %ymm10
; AVX2-FCP-NEXT:    vpshuflw {{.*#+}} ymm11 = ymm7[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX2-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm12 = [4,5,4,5,5,7,4,5]
; AVX2-FCP-NEXT:    vpermd %ymm11, %ymm12, %ymm11
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm8[20],zero,ymm8[18],zero,zero,zero,zero,ymm8[21],zero,ymm8[19],zero,zero,zero,zero,ymm8[22]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20],zero,ymm6[18],zero,zero,zero,zero,ymm6[21],zero,ymm6[19],zero,zero,zero,zero,ymm6[22],zero
; AVX2-FCP-NEXT:    vpor %ymm12, %ymm13, %ymm12
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm13, %ymm12, %ymm11, %ymm11
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm12, %ymm10, %ymm11, %ymm10
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm0[17,18,19,30],zero,ymm0[28],zero,ymm0[28,29,30,31],zero,ymm0[29],zero,ymm0[31]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27],zero,zero,zero,zero,ymm2[30],zero,ymm2[28],zero,zero,zero,zero,ymm2[31],zero,ymm2[29],zero
; AVX2-FCP-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm3[30],zero,ymm3[28],zero,zero,zero,zero,ymm3[31],zero,ymm3[29],zero,zero,zero
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero,ymm1[29],zero,zero,zero,zero
; AVX2-FCP-NEXT:    vpor %ymm12, %ymm13, %ymm12
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm6[27],zero,ymm6[27,28,29,30],zero,ymm6[28],zero,ymm6[26,27,30,31],zero,ymm6[29]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm8[27],zero,zero,zero,zero,ymm8[30],zero,ymm8[28],zero,zero,zero,zero,ymm8[31],zero
; AVX2-FCP-NEXT:    vpor %ymm12, %ymm13, %ymm12
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,0,0,u,255,255,255,255,0,0,u,255,255,255,255,0,0,u,255,255,255,255,0,0,u,255,255,255,255,0,0,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm1[23],zero,ymm1[27,20,21,26],zero,ymm1[24],zero,ymm1[26,27,26,27],zero,ymm1[25]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm3[23],zero,zero,zero,zero,ymm3[26],zero,ymm3[24],zero,zero,zero,zero,ymm3[27],zero
; AVX2-FCP-NEXT:    vpor %ymm12, %ymm13, %ymm12
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,3]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero,zero,zero
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm14 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm0[25],zero,ymm0[23],zero,zero,zero,zero,ymm0[26],zero,ymm0[24],zero,zero,zero,zero,ymm0[27]
; AVX2-FCP-NEXT:    vpor %ymm13, %ymm14, %ymm13
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm14 = [u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm14, %ymm12, %ymm13, %ymm12
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm8[25],zero,ymm8[23],zero,zero,zero,zero,ymm8[26],zero,ymm8[24],zero,zero
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm14 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm6[25],zero,ymm6[23],zero,zero,zero,zero,ymm6[26],zero,ymm6[24],zero,zero,zero
; AVX2-FCP-NEXT:    vpor %ymm13, %ymm14, %ymm13
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,3,2,3]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm14 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm15 = [0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm15, %ymm13, %ymm14, %ymm13
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm14 = [0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm14, %ymm12, %ymm13, %ymm12
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,ymm3[14],zero,zero,zero,zero,zero,zero,ymm3[15],zero,zero,zero,zero,zero,zero,ymm3[16],zero,zero,zero,zero,zero,zero,ymm3[17],zero,zero,zero,zero,zero,zero,ymm3[18]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,ymm1[14],zero,zero,zero,zero,zero,zero,ymm1[15],zero,zero,zero,zero,zero,zero,ymm1[16],zero,zero,zero,zero,zero,zero,ymm1[17],zero,zero,zero,zero,zero,zero,ymm1[18],zero
; AVX2-FCP-NEXT:    vpor %ymm3, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,ymm2[14],zero,zero,zero,zero,zero,zero,ymm2[15],zero,zero,zero,zero,zero,zero,ymm2[16],zero,zero,zero,zero,zero,zero,ymm2[17],zero,zero,zero,zero,zero
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[14],zero,zero,zero,zero,zero,zero,ymm0[15],zero,zero,zero,zero,zero,zero,ymm0[16],zero,zero,zero,zero,zero,zero,ymm0[17],zero,zero,zero,zero,zero,zero
; AVX2-FCP-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = zero,ymm6[1,2,3,0,1,14],zero,ymm6[0,1,0,1,14,15],zero,ymm6[15,16,17,18,19,16],zero,ymm6[30,31,16,17,16,17],zero,ymm6[31,30,31]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm8[13],zero,zero,zero,zero,zero,zero,ymm8[14],zero,zero,zero,zero,zero,zero,ymm8[15],zero,zero,zero,zero,zero,zero,ymm8[16],zero,zero,zero,zero,zero,zero,ymm8[17],zero,zero,zero
; AVX2-FCP-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm7[12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovdqa %ymm0, 96(%rax)
; AVX2-FCP-NEXT:    vmovdqa %ymm10, 128(%rax)
; AVX2-FCP-NEXT:    vmovdqa %ymm12, 160(%rax)
; AVX2-FCP-NEXT:    vmovdqa %ymm9, (%rax)
; AVX2-FCP-NEXT:    vmovdqa %ymm11, 192(%rax)
; AVX2-FCP-NEXT:    vmovdqa %ymm5, 32(%rax)
; AVX2-FCP-NEXT:    vmovdqa %ymm4, 64(%rax)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i8_stride7_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512-NEXT:    vmovdqa (%rsi), %ymm4
; AVX512-NEXT:    vmovdqa (%rdx), %ymm5
; AVX512-NEXT:    vmovdqa (%rcx), %ymm6
; AVX512-NEXT:    vmovdqa (%r8), %ymm1
; AVX512-NEXT:    vmovdqa (%r9), %ymm2
; AVX512-NEXT:    vmovdqa (%r10), %ymm0
; AVX512-NEXT:    vpshufb {{.*#+}} ymm7 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm6[18],zero,zero,zero,zero,ymm6[21],zero,ymm6[19],zero,zero,zero,zero,ymm6[22],zero,ymm6[20]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm8 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm3[23],zero,zero,zero,zero,ymm3[26],zero,ymm3[24],zero,zero,zero,zero,ymm3[27],zero,ymm3[25]
; AVX512-NEXT:    vinserti64x4 $1, %ymm8, %zmm7, %zmm7
; AVX512-NEXT:    vpermq {{.*#+}} zmm7 = zmm7[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm8 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18],zero,ymm5[18,19,20,21],zero,ymm5[19],zero,ymm5[25,26,27,22],zero,ymm5[20],zero
; AVX512-NEXT:    vpshufb {{.*#+}} ymm9 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm4[23,u,u,u],zero,ymm4[26],zero,ymm4[24,u,u,u],zero,ymm4[27],zero
; AVX512-NEXT:    vinserti64x4 $1, %ymm9, %zmm8, %zmm8
; AVX512-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vporq %zmm7, %zmm8, %zmm7
; AVX512-NEXT:    vpshufb {{.*#+}} ymm8 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm4[21],zero,ymm4[19],zero,zero,zero,zero,ymm4[22],zero,ymm4[20],zero,zero
; AVX512-NEXT:    vpshufb {{.*#+}} ymm9 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm6[25],zero,ymm6[23],zero,zero,zero,zero,ymm6[26],zero,ymm6[24],zero,zero,zero,zero
; AVX512-NEXT:    vinserti64x4 $1, %ymm9, %zmm8, %zmm8
; AVX512-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm9 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21],zero,ymm3[19],zero,ymm3[21,20,21,22],zero,ymm3[20],zero,ymm3[22,23]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm10 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25],zero,ymm5[23],zero,ymm5[21,22,23,26],zero,ymm5[24],zero,ymm5[28,29,26,27]
; AVX512-NEXT:    vinserti64x4 $1, %ymm10, %zmm9, %zmm9
; AVX512-NEXT:    vpermq {{.*#+}} zmm9 = zmm9[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vporq %zmm8, %zmm9, %zmm8
; AVX512-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm7, %zmm8
; AVX512-NEXT:    vpshufb {{.*#+}} ymm7 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,u,u,u,u,26,27,24,25]
; AVX512-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm0[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX512-NEXT:    vmovdqa64 %ymm0, %ymm18
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,5,4,0,5,0,4,0,20,21,0,23,0,21,0,23]
; AVX512-NEXT:    vpermi2d %zmm7, %zmm9, %zmm10
; AVX512-NEXT:    vpshufb {{.*#+}} ymm7 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm2[20],zero,ymm2[18],zero,zero,zero,zero,ymm2[21],zero,ymm2[19],zero,zero,zero,zero,ymm2[22]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm9 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero
; AVX512-NEXT:    vinserti64x4 $1, %ymm9, %zmm7, %zmm7
; AVX512-NEXT:    vpermq {{.*#+}} zmm7 = zmm7[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm9 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20],zero,ymm1[18],zero,ymm1[20,21,20,21],zero,ymm1[19],zero,ymm1[19,20,21,22],zero
; AVX512-NEXT:    vpshufb {{.*#+}} ymm11 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25],zero,ymm1[23],zero,ymm1[23,24,25,26],zero,ymm1[24],zero,ymm1[30,31]
; AVX512-NEXT:    vmovdqa64 %ymm1, %ymm19
; AVX512-NEXT:    vinserti64x4 $1, %ymm11, %zmm9, %zmm9
; AVX512-NEXT:    vpermq {{.*#+}} zmm9 = zmm9[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vporq %zmm7, %zmm9, %zmm7
; AVX512-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm10, %zmm7
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm7
; AVX512-NEXT:    vmovdqa (%rsi), %xmm9
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = xmm9[u],zero,xmm9[7],zero,xmm9[5,u,u,u],zero,xmm9[8],zero,xmm9[6,u,u,u],zero
; AVX512-NEXT:    vmovdqa (%rdi), %xmm10
; AVX512-NEXT:    vpshufb {{.*#+}} xmm11 = xmm10[u,7],zero,xmm10[5],zero,xmm10[u,u,u,8],zero,xmm10[6],zero,xmm10[u,u,u,9]
; AVX512-NEXT:    vpor %xmm8, %xmm11, %xmm8
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3],xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512-NEXT:    vinserti32x4 $2, %xmm8, %zmm11, %zmm8
; AVX512-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[0,1,0,1,4,5,4,5]
; AVX512-NEXT:    vmovdqa (%rcx), %xmm14
; AVX512-NEXT:    vpshufb {{.*#+}} xmm11 = xmm14[u,u,u],zero,xmm14[7],zero,xmm14[5,u,u,u],zero,xmm14[8],zero,xmm14[6,u,u]
; AVX512-NEXT:    vmovdqa (%rdx), %xmm15
; AVX512-NEXT:    vpshufb {{.*#+}} xmm12 = xmm15[u,u,u,7],zero,xmm15[5],zero,xmm15[u,u,u,8],zero,xmm15[6],zero,xmm15[u,u]
; AVX512-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm12 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3],xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512-NEXT:    vinserti32x4 $2, %xmm11, %zmm12, %zmm11
; AVX512-NEXT:    vpermq {{.*#+}} zmm16 = zmm11[0,1,0,1,4,5,4,5]
; AVX512-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm16
; AVX512-NEXT:    vmovdqa (%r9), %xmm11
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = zero,xmm11[4,u,u,u],zero,xmm11[7],zero,xmm11[5,u,u,u],zero,xmm11[8],zero,xmm11[6]
; AVX512-NEXT:    vmovdqa (%r8), %xmm12
; AVX512-NEXT:    vpshufb {{.*#+}} xmm13 = xmm12[4],zero,xmm12[u,u,u,7],zero,xmm12[5],zero,xmm12[u,u,u,8],zero,xmm12[6],zero
; AVX512-NEXT:    vpor %xmm8, %xmm13, %xmm8
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm13 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3],xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512-NEXT:    vinserti32x4 $2, %xmm8, %zmm13, %zmm8
; AVX512-NEXT:    vpermq {{.*#+}} zmm17 = zmm8[0,1,0,1,4,5,4,5]
; AVX512-NEXT:    vmovdqa (%r10), %xmm13
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = xmm13[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm13[1,1,0,0,4,5,6,7]
; AVX512-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,2,0]
; AVX512-NEXT:    vinserti64x4 $1, %ymm8, %zmm0, %zmm0
; AVX512-NEXT:    vpermq {{.*#+}} zmm8 = zmm0[0,0,1,0,4,4,5,4]
; AVX512-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm17, %zmm8
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm16, %zmm8
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,ymm4[14,u,u],zero,zero,zero,zero,ymm4[15,u,u],zero,zero,zero,zero,ymm4[16,u,u],zero,zero,zero,zero,ymm4[17,u,u],zero,zero,zero,zero,ymm4[18]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm3[0,1,14],zero,ymm3[u,u,0,1,14,15],zero,ymm3[u,u,13,2,3,16],zero,ymm3[u,u,28,29,16,17],zero,ymm3[u,u,19,28,29,18],zero
; AVX512-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm14[8],xmm15[8],xmm14[9],xmm15[9],xmm14[10],xmm15[10],xmm14[11],xmm15[11],xmm14[12],xmm15[12],xmm14[13],xmm15[13],xmm14[14],xmm15[14],xmm14[15],xmm15[15]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm6[u,u,u,u],zero,ymm6[14,u,u,u,u,u],zero,ymm6[15,u,u,u,u,u],zero,ymm6[16,u,u,u,u,u],zero,ymm6[17,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm14 = ymm5[u,u,u,u,14],zero,ymm5[u,u,u,u,u,15],zero,ymm5[u,u,u,u,u,16],zero,ymm5[u,u,u,u,u,17],zero,ymm5[u,u,u,u,u]
; AVX512-NEXT:    vpor %ymm1, %ymm14, %ymm1
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm9 = xmm9[8],xmm10[8],xmm9[9],xmm10[9],xmm9[10],xmm10[10],xmm9[11],xmm10[11],xmm9[12],xmm10[12],xmm9[13],xmm10[13],xmm9[14],xmm10[14],xmm9[15],xmm10[15]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm9, %zmm1
; AVX512-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm1
; AVX512-NEXT:    vmovdqa64 %ymm19, %ymm14
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = zero,ymm14[u],zero,zero,zero,zero,ymm14[14],zero,ymm14[u],zero,zero,zero,zero,ymm14[15],zero,ymm14[u],zero,zero,zero,zero,ymm14[16],zero,ymm14[u],zero,zero,zero,zero,ymm14[17],zero,ymm14[u],zero,zero
; AVX512-NEXT:    vpshufb {{.*#+}} ymm9 = ymm2[13,u,u,u,u,u],zero,ymm2[14,u,u,u,u,u],zero,ymm2[15,u,u,u,u,u],zero,ymm2[16,u,u,u,u,u],zero,ymm2[17,u,u,u]
; AVX512-NEXT:    vpor %ymm0, %ymm9, %ymm0
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm9 = xmm12[8],xmm11[8],xmm12[9],xmm11[9],xmm12[10],xmm11[10],xmm12[11],xmm11[11],xmm12[12],xmm11[12],xmm12[13],xmm11[13],xmm12[14],xmm11[14],xmm12[15],xmm11[15]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm9, %zmm0
; AVX512-NEXT:    vpshufhw {{.*#+}} xmm9 = xmm13[0,1,2,3,4,5,5,6]
; AVX512-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX512-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm9, %ymm9
; AVX512-NEXT:    vmovdqa64 %ymm18, %ymm11
; AVX512-NEXT:    vpshufb {{.*#+}} ymm10 = zero,ymm11[13,u,u,u,u],zero,zero,ymm11[14,u,u,u,u],zero,zero,ymm11[15,u,u,u,u],zero,zero,ymm11[16,u,u,u,u],zero,zero,ymm11[17,u,u]
; AVX512-NEXT:    vinserti64x4 $1, %ymm10, %zmm9, %zmm9
; AVX512-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm9
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm9
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm5[30],zero,ymm5[28],zero,zero,zero,zero,ymm5[31],zero,ymm5[29],zero,zero
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27,u,u,u],zero,ymm6[30],zero,ymm6[28,u,u,u],zero,ymm6[31],zero,ymm6[29,u]
; AVX512-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm4[30],zero,ymm4[28],zero,zero,zero,zero,ymm4[31],zero,ymm4[29],zero,zero,zero
; AVX512-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,30],zero,ymm3[28],zero,ymm3[30,31,30,31],zero,ymm3[29],zero,ymm3[31,28,29]
; AVX512-NEXT:    vpor %ymm1, %ymm3, %ymm1
; AVX512-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm14[27],zero,zero,zero,zero,ymm14[30],zero,ymm14[28],zero,zero,zero,zero,ymm14[31],zero,ymm14[29]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm2[27,u,u,u],zero,ymm2[30],zero,ymm2[28,u,u,u],zero,ymm2[31],zero
; AVX512-NEXT:    vpor %ymm0, %ymm2, %ymm0
; AVX512-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm2 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX512-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; AVX512-NEXT:    vmovdqa %ymm2, 192(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512-NEXT:    vmovdqa64 %zmm7, 128(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i8_stride7_vf32:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512-FCP-NEXT:    vmovdqa (%rsi), %ymm4
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %ymm5
; AVX512-FCP-NEXT:    vmovdqa (%rcx), %ymm6
; AVX512-FCP-NEXT:    vmovdqa (%r8), %ymm1
; AVX512-FCP-NEXT:    vmovdqa (%r9), %ymm2
; AVX512-FCP-NEXT:    vmovdqa64 (%r10), %ymm17
; AVX512-FCP-NEXT:    vmovdqa (%rsi), %xmm8
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm8[u],zero,xmm8[7],zero,xmm8[5,u,u,u],zero,xmm8[8],zero,xmm8[6,u,u,u],zero
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm9
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm9[u,7],zero,xmm9[5],zero,xmm9[u,u,u,8],zero,xmm9[6],zero,xmm9[u,u,u,9]
; AVX512-FCP-NEXT:    vpor %xmm7, %xmm10, %xmm7
; AVX512-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm10 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3],xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512-FCP-NEXT:    vinserti32x4 $2, %xmm7, %zmm10, %zmm7
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm7 = zmm7[0,1,0,1,4,5,4,5]
; AVX512-FCP-NEXT:    vmovdqa (%rcx), %xmm11
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm11[u,u,u],zero,xmm11[7],zero,xmm11[5,u,u,u],zero,xmm11[8],zero,xmm11[6,u,u]
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm12
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = xmm12[u,u,u,7],zero,xmm12[5],zero,xmm12[u,u,u,8],zero,xmm12[6],zero,xmm12[u,u]
; AVX512-FCP-NEXT:    vpor %xmm10, %xmm13, %xmm10
; AVX512-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm13 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3],xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512-FCP-NEXT:    vinserti32x4 $2, %xmm10, %zmm13, %zmm10
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm15 = zmm10[0,1,0,1,4,5,4,5]
; AVX512-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm7, %zmm15
; AVX512-FCP-NEXT:    vmovdqa (%r10), %xmm10
; AVX512-FCP-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm10[1,1,0,0,4,5,6,7]
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm13 = [0,1,0,1,0,0,0,0]
; AVX512-FCP-NEXT:    vpermd %ymm7, %ymm13, %ymm7
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = xmm10[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,0,1,0]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm13, %zmm7, %zmm16
; AVX512-FCP-NEXT:    vmovdqa (%r9), %xmm13
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,xmm13[4,u,u,u],zero,xmm13[7],zero,xmm13[5,u,u,u],zero,xmm13[8],zero,xmm13[6]
; AVX512-FCP-NEXT:    vmovdqa (%r8), %xmm14
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm14[4],zero,xmm14[u,u,u,7],zero,xmm14[5],zero,xmm14[u,u,u,8],zero,xmm14[6],zero
; AVX512-FCP-NEXT:    vpor %xmm7, %xmm0, %xmm0
; AVX512-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm7 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3],xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512-FCP-NEXT:    vinserti32x4 $2, %xmm0, %zmm7, %zmm0
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm7 = zmm0[0,1,0,1,4,5,4,5]
; AVX512-FCP-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm16, %zmm7
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm15, %zmm7
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,ymm4[14,u,u],zero,zero,zero,zero,ymm4[15,u,u],zero,zero,zero,zero,ymm4[16,u,u],zero,zero,zero,zero,ymm4[17,u,u],zero,zero,zero,zero,ymm4[18]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm15 = ymm3[0,1,14],zero,ymm3[u,u,0,1,14,15],zero,ymm3[u,u,13,2,3,16],zero,ymm3[u,u,28,29,16,17],zero,ymm3[u,u,19,28,29,18],zero
; AVX512-FCP-NEXT:    vpor %ymm0, %ymm15, %ymm0
; AVX512-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm11 = xmm11[8],xmm12[8],xmm11[9],xmm12[9],xmm11[10],xmm12[10],xmm11[11],xmm12[11],xmm11[12],xmm12[12],xmm11[13],xmm12[13],xmm11[14],xmm12[14],xmm11[15],xmm12[15]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,1,0,1]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm11, %zmm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm6[u,u,u,u],zero,ymm6[14,u,u,u,u,u],zero,ymm6[15,u,u,u,u,u],zero,ymm6[16,u,u,u,u,u],zero,ymm6[17,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm5[u,u,u,u,14],zero,ymm5[u,u,u,u,u,15],zero,ymm5[u,u,u,u,u,16],zero,ymm5[u,u,u,u,u,17],zero,ymm5[u,u,u,u,u]
; AVX512-FCP-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX512-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm8 = xmm8[8],xmm9[8],xmm8[9],xmm9[9],xmm8[10],xmm9[10],xmm8[11],xmm9[11],xmm8[12],xmm9[12],xmm8[13],xmm9[13],xmm8[14],xmm9[14],xmm8[15],xmm9[15]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,0,1]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm8, %zmm9
; AVX512-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm9
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,ymm1[u],zero,zero,zero,zero,ymm1[14],zero,ymm1[u],zero,zero,zero,zero,ymm1[15],zero,ymm1[u],zero,zero,zero,zero,ymm1[16],zero,ymm1[u],zero,zero,zero,zero,ymm1[17],zero,ymm1[u],zero,zero
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm2[13,u,u,u,u,u],zero,ymm2[14,u,u,u,u,u],zero,ymm2[15,u,u,u,u,u],zero,ymm2[16,u,u,u,u,u],zero,ymm2[17,u,u,u]
; AVX512-FCP-NEXT:    vpor %ymm0, %ymm8, %ymm0
; AVX512-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm8 = xmm14[8],xmm13[8],xmm14[9],xmm13[9],xmm14[10],xmm13[10],xmm14[11],xmm13[11],xmm14[12],xmm13[12],xmm14[13],xmm13[13],xmm14[14],xmm13[14],xmm14[15],xmm13[15]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,0,1]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm8, %zmm0
; AVX512-FCP-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm10[0,1,2,3,4,5,5,6]
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm10 = [2,2,3,3,2,2,3,3]
; AVX512-FCP-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpermd %ymm8, %ymm10, %ymm8
; AVX512-FCP-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm8
; AVX512-FCP-NEXT:    vmovdqa64 %ymm17, %ymm12
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = zero,ymm12[13,u,u,u,u],zero,zero,ymm12[14,u,u,u,u],zero,zero,ymm12[15,u,u,u,u],zero,zero,ymm12[16,u,u,u,u],zero,zero,ymm12[17,u,u]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm8, %zmm8
; AVX512-FCP-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm8
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm8
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm6[18],zero,zero,zero,zero,ymm6[21],zero,ymm6[19],zero,zero,zero,zero,ymm6[22],zero,ymm6[20]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm9 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm3[23],zero,zero,zero,zero,ymm3[26],zero,ymm3[24],zero,zero,zero,zero,ymm3[27],zero,ymm3[25]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm9, %zmm0, %zmm0
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm9 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18],zero,ymm5[18,19,20,21],zero,ymm5[19],zero,ymm5[25,26,27,22],zero,ymm5[20],zero
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm4[23,u,u,u],zero,ymm4[26],zero,ymm4[24,u,u,u],zero,ymm4[27],zero
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm9, %zmm9
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm9 = zmm9[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vporq %zmm0, %zmm9, %zmm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm9 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm4[21],zero,ymm4[19],zero,zero,zero,zero,ymm4[22],zero,ymm4[20],zero,zero
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm6[25],zero,ymm6[23],zero,zero,zero,zero,ymm6[26],zero,ymm6[24],zero,zero,zero,zero
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm9, %zmm9
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm9 = zmm9[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21],zero,ymm3[19],zero,ymm3[21,20,21,22],zero,ymm3[20],zero,ymm3[22,23]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25],zero,ymm5[23],zero,ymm5[21,22,23,26],zero,ymm5[24],zero,ymm5[28,29,26,27]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm10
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm10 = zmm10[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vporq %zmm9, %zmm10, %zmm9
; AVX512-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm9
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm2[20],zero,ymm2[18],zero,zero,zero,zero,ymm2[21],zero,ymm2[19],zero,zero,zero,zero,ymm2[22]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm0, %zmm0
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20],zero,ymm1[18],zero,ymm1[20,21,20,21],zero,ymm1[19],zero,ymm1[19,20,21,22],zero
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25],zero,ymm1[23],zero,ymm1[23,24,25,26],zero,ymm1[24],zero,ymm1[30,31]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm10
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm10 = zmm10[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vporq %zmm0, %zmm10, %zmm0
; AVX512-FCP-NEXT:    vpshuflw {{.*#+}} ymm10 = ymm12[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm11 = [0,5,4,0,5,0,4,0]
; AVX512-FCP-NEXT:    vpermd %ymm10, %ymm11, %ymm10
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm10
; AVX512-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm10
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm10
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm5[30],zero,ymm5[28],zero,zero,zero,zero,ymm5[31],zero,ymm5[29],zero,zero
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm5 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27,u,u,u],zero,ymm6[30],zero,ymm6[28,u,u,u],zero,ymm6[31],zero,ymm6[29,u]
; AVX512-FCP-NEXT:    vpor %ymm0, %ymm5, %ymm0
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm4[30],zero,ymm4[28],zero,zero,zero,zero,ymm4[31],zero,ymm4[29],zero,zero,zero
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,30],zero,ymm3[28],zero,ymm3[30,31,30,31],zero,ymm3[29],zero,ymm3[31,28,29]
; AVX512-FCP-NEXT:    vpor %ymm4, %ymm3, %ymm3
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm3
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm1[27],zero,zero,zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero,ymm1[29]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm2[27,u,u,u],zero,ymm2[30],zero,ymm2[28,u,u,u],zero,ymm2[31],zero
; AVX512-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm1
; AVX512-FCP-NEXT:    vmovdqa %ymm1, 192(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i8_stride7_vf32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512DQ-NEXT:    vmovdqa (%rsi), %ymm4
; AVX512DQ-NEXT:    vmovdqa (%rdx), %ymm5
; AVX512DQ-NEXT:    vmovdqa (%rcx), %ymm6
; AVX512DQ-NEXT:    vmovdqa (%r8), %ymm1
; AVX512DQ-NEXT:    vmovdqa (%r9), %ymm2
; AVX512DQ-NEXT:    vmovdqa (%r10), %ymm0
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm7 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm6[18],zero,zero,zero,zero,ymm6[21],zero,ymm6[19],zero,zero,zero,zero,ymm6[22],zero,ymm6[20]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm8 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm3[23],zero,zero,zero,zero,ymm3[26],zero,ymm3[24],zero,zero,zero,zero,ymm3[27],zero,ymm3[25]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm8, %zmm7, %zmm7
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm7 = zmm7[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm8 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18],zero,ymm5[18,19,20,21],zero,ymm5[19],zero,ymm5[25,26,27,22],zero,ymm5[20],zero
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm9 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm4[23,u,u,u],zero,ymm4[26],zero,ymm4[24,u,u,u],zero,ymm4[27],zero
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm9, %zmm8, %zmm8
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vporq %zmm7, %zmm8, %zmm7
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm8 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm4[21],zero,ymm4[19],zero,zero,zero,zero,ymm4[22],zero,ymm4[20],zero,zero
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm9 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm6[25],zero,ymm6[23],zero,zero,zero,zero,ymm6[26],zero,ymm6[24],zero,zero,zero,zero
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm9, %zmm8, %zmm8
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm9 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21],zero,ymm3[19],zero,ymm3[21,20,21,22],zero,ymm3[20],zero,ymm3[22,23]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm10 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25],zero,ymm5[23],zero,ymm5[21,22,23,26],zero,ymm5[24],zero,ymm5[28,29,26,27]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm10, %zmm9, %zmm9
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm9 = zmm9[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vporq %zmm8, %zmm9, %zmm8
; AVX512DQ-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm7, %zmm8
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm7 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,u,u,u,u,26,27,24,25]
; AVX512DQ-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm0[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX512DQ-NEXT:    vmovdqa64 %ymm0, %ymm18
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,5,4,0,5,0,4,0,20,21,0,23,0,21,0,23]
; AVX512DQ-NEXT:    vpermi2d %zmm7, %zmm9, %zmm10
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm7 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm2[20],zero,ymm2[18],zero,zero,zero,zero,ymm2[21],zero,ymm2[19],zero,zero,zero,zero,ymm2[22]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm9 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm9, %zmm7, %zmm7
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm7 = zmm7[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm9 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20],zero,ymm1[18],zero,ymm1[20,21,20,21],zero,ymm1[19],zero,ymm1[19,20,21,22],zero
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm11 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25],zero,ymm1[23],zero,ymm1[23,24,25,26],zero,ymm1[24],zero,ymm1[30,31]
; AVX512DQ-NEXT:    vmovdqa64 %ymm1, %ymm19
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm11, %zmm9, %zmm9
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm9 = zmm9[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vporq %zmm7, %zmm9, %zmm7
; AVX512DQ-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm10, %zmm7
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm7
; AVX512DQ-NEXT:    vmovdqa (%rsi), %xmm9
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm8 = xmm9[u],zero,xmm9[7],zero,xmm9[5,u,u,u],zero,xmm9[8],zero,xmm9[6,u,u,u],zero
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm10
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm11 = xmm10[u,7],zero,xmm10[5],zero,xmm10[u,u,u,8],zero,xmm10[6],zero,xmm10[u,u,u,9]
; AVX512DQ-NEXT:    vpor %xmm8, %xmm11, %xmm8
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3],xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512DQ-NEXT:    vinserti32x4 $2, %xmm8, %zmm11, %zmm8
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[0,1,0,1,4,5,4,5]
; AVX512DQ-NEXT:    vmovdqa (%rcx), %xmm14
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm11 = xmm14[u,u,u],zero,xmm14[7],zero,xmm14[5,u,u,u],zero,xmm14[8],zero,xmm14[6,u,u]
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm15
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm12 = xmm15[u,u,u,7],zero,xmm15[5],zero,xmm15[u,u,u,8],zero,xmm15[6],zero,xmm15[u,u]
; AVX512DQ-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} xmm12 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3],xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512DQ-NEXT:    vinserti32x4 $2, %xmm11, %zmm12, %zmm11
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm16 = zmm11[0,1,0,1,4,5,4,5]
; AVX512DQ-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm16
; AVX512DQ-NEXT:    vmovdqa (%r9), %xmm11
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm8 = zero,xmm11[4,u,u,u],zero,xmm11[7],zero,xmm11[5,u,u,u],zero,xmm11[8],zero,xmm11[6]
; AVX512DQ-NEXT:    vmovdqa (%r8), %xmm12
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm13 = xmm12[4],zero,xmm12[u,u,u,7],zero,xmm12[5],zero,xmm12[u,u,u,8],zero,xmm12[6],zero
; AVX512DQ-NEXT:    vpor %xmm8, %xmm13, %xmm8
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} xmm13 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3],xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512DQ-NEXT:    vinserti32x4 $2, %xmm8, %zmm13, %zmm8
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm17 = zmm8[0,1,0,1,4,5,4,5]
; AVX512DQ-NEXT:    vmovdqa (%r10), %xmm13
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm8 = xmm13[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512DQ-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm13[1,1,0,0,4,5,6,7]
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,2,0]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm8, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm8 = zmm0[0,0,1,0,4,4,5,4]
; AVX512DQ-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm17, %zmm8
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm16, %zmm8
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,ymm4[14,u,u],zero,zero,zero,zero,ymm4[15,u,u],zero,zero,zero,zero,ymm4[16,u,u],zero,zero,zero,zero,ymm4[17,u,u],zero,zero,zero,zero,ymm4[18]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm3[0,1,14],zero,ymm3[u,u,0,1,14,15],zero,ymm3[u,u,13,2,3,16],zero,ymm3[u,u,28,29,16,17],zero,ymm3[u,u,19,28,29,18],zero
; AVX512DQ-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm14[8],xmm15[8],xmm14[9],xmm15[9],xmm14[10],xmm15[10],xmm14[11],xmm15[11],xmm14[12],xmm15[12],xmm14[13],xmm15[13],xmm14[14],xmm15[14],xmm14[15],xmm15[15]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm6[u,u,u,u],zero,ymm6[14,u,u,u,u,u],zero,ymm6[15,u,u,u,u,u],zero,ymm6[16,u,u,u,u,u],zero,ymm6[17,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm14 = ymm5[u,u,u,u,14],zero,ymm5[u,u,u,u,u,15],zero,ymm5[u,u,u,u,u,16],zero,ymm5[u,u,u,u,u,17],zero,ymm5[u,u,u,u,u]
; AVX512DQ-NEXT:    vpor %ymm1, %ymm14, %ymm1
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} xmm9 = xmm9[8],xmm10[8],xmm9[9],xmm10[9],xmm9[10],xmm10[10],xmm9[11],xmm10[11],xmm9[12],xmm10[12],xmm9[13],xmm10[13],xmm9[14],xmm10[14],xmm9[15],xmm10[15]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm9, %zmm1
; AVX512DQ-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %ymm19, %ymm14
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = zero,ymm14[u],zero,zero,zero,zero,ymm14[14],zero,ymm14[u],zero,zero,zero,zero,ymm14[15],zero,ymm14[u],zero,zero,zero,zero,ymm14[16],zero,ymm14[u],zero,zero,zero,zero,ymm14[17],zero,ymm14[u],zero,zero
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm9 = ymm2[13,u,u,u,u,u],zero,ymm2[14,u,u,u,u,u],zero,ymm2[15,u,u,u,u,u],zero,ymm2[16,u,u,u,u,u],zero,ymm2[17,u,u,u]
; AVX512DQ-NEXT:    vpor %ymm0, %ymm9, %ymm0
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} xmm9 = xmm12[8],xmm11[8],xmm12[9],xmm11[9],xmm12[10],xmm11[10],xmm12[11],xmm11[11],xmm12[12],xmm11[12],xmm12[13],xmm11[13],xmm12[14],xmm11[14],xmm12[15],xmm11[15]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm9, %zmm0
; AVX512DQ-NEXT:    vpshufhw {{.*#+}} xmm9 = xmm13[0,1,2,3,4,5,5,6]
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX512DQ-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm9, %ymm9
; AVX512DQ-NEXT:    vmovdqa64 %ymm18, %ymm11
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm10 = zero,ymm11[13,u,u,u,u],zero,zero,ymm11[14,u,u,u,u],zero,zero,ymm11[15,u,u,u,u],zero,zero,ymm11[16,u,u,u,u],zero,zero,ymm11[17,u,u]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm10, %zmm9, %zmm9
; AVX512DQ-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm9
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm9
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm5[30],zero,ymm5[28],zero,zero,zero,zero,ymm5[31],zero,ymm5[29],zero,zero
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27,u,u,u],zero,ymm6[30],zero,ymm6[28,u,u,u],zero,ymm6[31],zero,ymm6[29,u]
; AVX512DQ-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm4[30],zero,ymm4[28],zero,zero,zero,zero,ymm4[31],zero,ymm4[29],zero,zero,zero
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,30],zero,ymm3[28],zero,ymm3[30,31,30,31],zero,ymm3[29],zero,ymm3[31,28,29]
; AVX512DQ-NEXT:    vpor %ymm1, %ymm3, %ymm1
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm14[27],zero,zero,zero,zero,ymm14[30],zero,ymm14[28],zero,zero,zero,zero,ymm14[31],zero,ymm14[29]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm2[27,u,u,u],zero,ymm2[30],zero,ymm2[28,u,u,u],zero,ymm2[31],zero
; AVX512DQ-NEXT:    vpor %ymm0, %ymm2, %ymm0
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm2 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; AVX512DQ-NEXT:    vmovdqa %ymm2, 192(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, 128(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i8_stride7_vf32:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512DQ-FCP-NEXT:    vmovdqa (%rsi), %ymm4
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %ymm5
; AVX512DQ-FCP-NEXT:    vmovdqa (%rcx), %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqa (%r8), %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa (%r9), %ymm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r10), %ymm17
; AVX512DQ-FCP-NEXT:    vmovdqa (%rsi), %xmm8
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm8[u],zero,xmm8[7],zero,xmm8[5,u,u,u],zero,xmm8[8],zero,xmm8[6,u,u,u],zero
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm9
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm9[u,7],zero,xmm9[5],zero,xmm9[u,u,u,8],zero,xmm9[6],zero,xmm9[u,u,u,9]
; AVX512DQ-FCP-NEXT:    vpor %xmm7, %xmm10, %xmm7
; AVX512DQ-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm10 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3],xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, %xmm7, %zmm10, %zmm7
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm7 = zmm7[0,1,0,1,4,5,4,5]
; AVX512DQ-FCP-NEXT:    vmovdqa (%rcx), %xmm11
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm11[u,u,u],zero,xmm11[7],zero,xmm11[5,u,u,u],zero,xmm11[8],zero,xmm11[6,u,u]
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm12
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = xmm12[u,u,u,7],zero,xmm12[5],zero,xmm12[u,u,u,8],zero,xmm12[6],zero,xmm12[u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm10, %xmm13, %xmm10
; AVX512DQ-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm13 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3],xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, %xmm10, %zmm13, %zmm10
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm15 = zmm10[0,1,0,1,4,5,4,5]
; AVX512DQ-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm7, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa (%r10), %xmm10
; AVX512DQ-FCP-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm10[1,1,0,0,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm13 = [0,1,0,1,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermd %ymm7, %ymm13, %ymm7
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = xmm10[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,0,1,0]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm13, %zmm7, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa (%r9), %xmm13
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,xmm13[4,u,u,u],zero,xmm13[7],zero,xmm13[5,u,u,u],zero,xmm13[8],zero,xmm13[6]
; AVX512DQ-FCP-NEXT:    vmovdqa (%r8), %xmm14
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm14[4],zero,xmm14[u,u,u,7],zero,xmm14[5],zero,xmm14[u,u,u,8],zero,xmm14[6],zero
; AVX512DQ-FCP-NEXT:    vpor %xmm7, %xmm0, %xmm0
; AVX512DQ-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm7 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3],xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, %xmm0, %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm7 = zmm0[0,1,0,1,4,5,4,5]
; AVX512DQ-FCP-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm16, %zmm7
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm15, %zmm7
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,ymm4[14,u,u],zero,zero,zero,zero,ymm4[15,u,u],zero,zero,zero,zero,ymm4[16,u,u],zero,zero,zero,zero,ymm4[17,u,u],zero,zero,zero,zero,ymm4[18]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm15 = ymm3[0,1,14],zero,ymm3[u,u,0,1,14,15],zero,ymm3[u,u,13,2,3,16],zero,ymm3[u,u,28,29,16,17],zero,ymm3[u,u,19,28,29,18],zero
; AVX512DQ-FCP-NEXT:    vpor %ymm0, %ymm15, %ymm0
; AVX512DQ-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm11 = xmm11[8],xmm12[8],xmm11[9],xmm12[9],xmm11[10],xmm12[10],xmm11[11],xmm12[11],xmm11[12],xmm12[12],xmm11[13],xmm12[13],xmm11[14],xmm12[14],xmm11[15],xmm12[15]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm11, %zmm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm6[u,u,u,u],zero,ymm6[14,u,u,u,u,u],zero,ymm6[15,u,u,u,u,u],zero,ymm6[16,u,u,u,u,u],zero,ymm6[17,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm12 = ymm5[u,u,u,u,14],zero,ymm5[u,u,u,u,u,15],zero,ymm5[u,u,u,u,u,16],zero,ymm5[u,u,u,u,u,17],zero,ymm5[u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX512DQ-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm8 = xmm8[8],xmm9[8],xmm8[9],xmm9[9],xmm8[10],xmm9[10],xmm8[11],xmm9[11],xmm8[12],xmm9[12],xmm8[13],xmm9[13],xmm8[14],xmm9[14],xmm8[15],xmm9[15]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm8, %zmm9
; AVX512DQ-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm9
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,ymm1[u],zero,zero,zero,zero,ymm1[14],zero,ymm1[u],zero,zero,zero,zero,ymm1[15],zero,ymm1[u],zero,zero,zero,zero,ymm1[16],zero,ymm1[u],zero,zero,zero,zero,ymm1[17],zero,ymm1[u],zero,zero
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm2[13,u,u,u,u,u],zero,ymm2[14,u,u,u,u,u],zero,ymm2[15,u,u,u,u,u],zero,ymm2[16,u,u,u,u,u],zero,ymm2[17,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %ymm0, %ymm8, %ymm0
; AVX512DQ-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm8 = xmm14[8],xmm13[8],xmm14[9],xmm13[9],xmm14[10],xmm13[10],xmm14[11],xmm13[11],xmm14[12],xmm13[12],xmm14[13],xmm13[13],xmm14[14],xmm13[14],xmm14[15],xmm13[15]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm8, %zmm0
; AVX512DQ-FCP-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm10[0,1,2,3,4,5,5,6]
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm10 = [2,2,3,3,2,2,3,3]
; AVX512DQ-FCP-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpermd %ymm8, %ymm10, %ymm8
; AVX512DQ-FCP-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm17, %ymm12
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = zero,ymm12[13,u,u,u,u],zero,zero,ymm12[14,u,u,u,u],zero,zero,ymm12[15,u,u,u,u],zero,zero,ymm12[16,u,u,u,u],zero,zero,ymm12[17,u,u]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm8, %zmm8
; AVX512DQ-FCP-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm8
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm8
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm6[18],zero,zero,zero,zero,ymm6[21],zero,ymm6[19],zero,zero,zero,zero,ymm6[22],zero,ymm6[20]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm9 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm3[23],zero,zero,zero,zero,ymm3[26],zero,ymm3[24],zero,zero,zero,zero,ymm3[27],zero,ymm3[25]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm9, %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm9 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18],zero,ymm5[18,19,20,21],zero,ymm5[19],zero,ymm5[25,26,27,22],zero,ymm5[20],zero
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm4[23,u,u,u],zero,ymm4[26],zero,ymm4[24,u,u,u],zero,ymm4[27],zero
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm9, %zmm9
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm9 = zmm9[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vporq %zmm0, %zmm9, %zmm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm9 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm4[21],zero,ymm4[19],zero,zero,zero,zero,ymm4[22],zero,ymm4[20],zero,zero
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm6[25],zero,ymm6[23],zero,zero,zero,zero,ymm6[26],zero,ymm6[24],zero,zero,zero,zero
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm9, %zmm9
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm9 = zmm9[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21],zero,ymm3[19],zero,ymm3[21,20,21,22],zero,ymm3[20],zero,ymm3[22,23]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25],zero,ymm5[23],zero,ymm5[21,22,23,26],zero,ymm5[24],zero,ymm5[28,29,26,27]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm10
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm10 = zmm10[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vporq %zmm9, %zmm10, %zmm9
; AVX512DQ-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm9
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm2[20],zero,ymm2[18],zero,zero,zero,zero,ymm2[21],zero,ymm2[19],zero,zero,zero,zero,ymm2[22]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20],zero,ymm1[18],zero,ymm1[20,21,20,21],zero,ymm1[19],zero,ymm1[19,20,21,22],zero
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25],zero,ymm1[23],zero,ymm1[23,24,25,26],zero,ymm1[24],zero,ymm1[30,31]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm10
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm10 = zmm10[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vporq %zmm0, %zmm10, %zmm0
; AVX512DQ-FCP-NEXT:    vpshuflw {{.*#+}} ymm10 = ymm12[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm11 = [0,5,4,0,5,0,4,0]
; AVX512DQ-FCP-NEXT:    vpermd %ymm10, %ymm11, %ymm10
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm10
; AVX512DQ-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm10
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm10
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm5[30],zero,ymm5[28],zero,zero,zero,zero,ymm5[31],zero,ymm5[29],zero,zero
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm5 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27,u,u,u],zero,ymm6[30],zero,ymm6[28,u,u,u],zero,ymm6[31],zero,ymm6[29,u]
; AVX512DQ-FCP-NEXT:    vpor %ymm0, %ymm5, %ymm0
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm4[30],zero,ymm4[28],zero,zero,zero,zero,ymm4[31],zero,ymm4[29],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,30],zero,ymm3[28],zero,ymm3[30,31,30,31],zero,ymm3[29],zero,ymm3[31,28,29]
; AVX512DQ-FCP-NEXT:    vpor %ymm4, %ymm3, %ymm3
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm3
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm1[27],zero,zero,zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero,ymm1[29]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm2[27,u,u,u],zero,ymm2[30],zero,ymm2[28,u,u,u],zero,ymm2[31],zero
; AVX512DQ-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm1, 192(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i8_stride7_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm4
; AVX512BW-NEXT:    vmovdqa (%rsi), %ymm2
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-NEXT:    vmovdqa (%rcx), %ymm3
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[0,1,0,1,14],zero,ymm1[14,15,0,1,14,15],zero,ymm1[13,14,15,16,17,16],zero,ymm1[30,31,30,31,16,17],zero,ymm1[31,28,29,30,31]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,ymm3[14],zero,zero,zero,zero,zero,zero,ymm3[15],zero,zero,zero,zero,zero,zero,ymm3[16],zero,zero,zero,zero,zero,zero,ymm3[17],zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpor %ymm0, %ymm5, %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm8
; AVX512BW-NEXT:    vmovdqa (%rsi), %xmm10
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm10[8],xmm8[8],xmm10[9],xmm8[9],xmm10[10],xmm8[10],xmm10[11],xmm8[11],xmm10[12],xmm8[12],xmm10[13],xmm8[13],xmm10[14],xmm8[14],xmm10[15],xmm8[15]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm5, %zmm5
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm4[0,1,14],zero,ymm4[12,13,0,1,14,15],zero,ymm4[3,12,13,2,3,16],zero,ymm4[30,31,28,29,16,17],zero,ymm4[31,18,19,28,29,18],zero
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,ymm2[14],zero,zero,zero,zero,zero,zero,ymm2[15],zero,zero,zero,zero,zero,zero,ymm2[16],zero,zero,zero,zero,zero,zero,ymm2[17],zero,zero,zero,zero,zero,zero,ymm2[18]
; AVX512BW-NEXT:    vpor %ymm0, %ymm6, %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm12
; AVX512BW-NEXT:    vmovdqa (%rcx), %xmm14
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm14[8],xmm12[8],xmm14[9],xmm12[9],xmm14[10],xmm12[10],xmm14[11],xmm12[11],xmm14[12],xmm12[12],xmm14[13],xmm12[13],xmm14[14],xmm12[14],xmm14[15],xmm12[15]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm6, %zmm0
; AVX512BW-NEXT:    movabsq $435749858791416001, %rcx # imm = 0x60C1830183060C1
; AVX512BW-NEXT:    kmovq %rcx, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm5, %zmm0 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm7 = ymm5[13],zero,zero,zero,zero,zero,zero,ymm5[14],zero,zero,zero,zero,zero,zero,ymm5[15],zero,zero,zero,zero,zero,zero,ymm5[16],zero,zero,zero,zero,zero,zero,ymm5[17],zero,zero,zero
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm9 = zero,zero,zero,zero,zero,zero,ymm6[14],zero,zero,zero,zero,zero,zero,ymm6[15],zero,zero,zero,zero,zero,zero,ymm6[16],zero,zero,zero,zero,zero,zero,ymm6[17],zero,zero,zero,zero
; AVX512BW-NEXT:    vpor %ymm7, %ymm9, %ymm7
; AVX512BW-NEXT:    vmovdqa (%r9), %xmm11
; AVX512BW-NEXT:    vmovdqa (%r8), %xmm13
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm9 = xmm13[8],xmm11[8],xmm13[9],xmm11[9],xmm13[10],xmm11[10],xmm13[11],xmm11[11],xmm13[12],xmm11[12],xmm13[13],xmm11[13],xmm13[14],xmm11[14],xmm13[15],xmm11[15]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm7, %zmm9, %zmm9
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vbroadcasti128 {{.*#+}} ymm15 = [4,5,4,5,5,6,5,6,4,5,4,5,5,6,5,6]
; AVX512BW-NEXT:    # ymm15 = mem[0,1,0,1]
; AVX512BW-NEXT:    vpermw %ymm7, %ymm15, %ymm15
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm16 = ymm7[12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm16, %zmm15, %zmm15
; AVX512BW-NEXT:    movabsq $2323999253380730912, %rcx # imm = 0x2040810204081020
; AVX512BW-NEXT:    kmovq %rcx, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm15, %zmm9 {%k1}
; AVX512BW-NEXT:    movabsq $4066998693416279096, %rcx # imm = 0x3870E1C3870E1C38
; AVX512BW-NEXT:    kmovq %rcx, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm9, %zmm0 {%k1}
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm9
; AVX512BW-NEXT:    vpshufb {{.*#+}} zmm9 = zmm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18],zero,zmm9[18,19,20,21],zero,zmm9[19],zero,zmm9[25,26,27,22],zero,zmm9[20],zero,zmm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,57],zero,zmm9[55],zero,zero,zero,zero,zmm9[58],zero,zmm9[56],zero,zero,zero,zero,zmm9[59],zero
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm15
; AVX512BW-NEXT:    vpshufb {{.*#+}} zmm15 = zmm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm15[18],zero,zero,zero,zero,zmm15[21],zero,zmm15[19],zero,zero,zero,zero,zmm15[22],zero,zmm15[20,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm15[55],zero,zero,zero,zero,zmm15[58],zero,zmm15[56],zero,zero,zero,zero,zmm15[59],zero,zmm15[57]
; AVX512BW-NEXT:    vporq %zmm9, %zmm15, %zmm9
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm9 = zmm9[2,3,2,3,6,7,6,7]
; AVX512BW-NEXT:    vpshuflw {{.*#+}} ymm15 = ymm4[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512BW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm15[0,0,1,1,4,4,5,5]
; AVX512BW-NEXT:    movl $676341840, %ecx # imm = 0x28502850
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm15 {%k1} = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,21,u,19,u,u,u,u,22,u,20,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm16 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25],zero,ymm1[23],zero,ymm1[21,22,23,26],zero,ymm1[24],zero,ymm1[28,29,26,27]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm17 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm3[25],zero,ymm3[23],zero,zero,zero,zero,ymm3[26],zero,ymm3[24],zero,zero,zero,zero
; AVX512BW-NEXT:    vporq %ymm16, %ymm17, %ymm16
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm16, %zmm15, %zmm15
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm15 = zmm15[2,3,2,3,6,7,6,7]
; AVX512BW-NEXT:    movabsq $-9005497107459067808, %rcx # imm = 0x83060C180C183060
; AVX512BW-NEXT:    kmovq %rcx, %k2
; AVX512BW-NEXT:    vmovdqu8 %zmm15, %zmm9 {%k2}
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm15 = [10,9,9,10,10,9,9,10,9,10,14,15,10,9,9,10,27,29,28,27,28,29,29,28,27,29,28,27,28,29,29,28]
; AVX512BW-NEXT:    vpermw %zmm7, %zmm15, %zmm15
; AVX512BW-NEXT:    vpshufb {{.*#+}} zmm16 = zmm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20],zero,zmm6[18],zero,zmm6[20,21,20,21],zero,zmm6[19],zero,zmm6[19,20,21,22],zero,zmm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,56,57,56,57],zero,zmm6[55],zero,zmm6[55,56,57,58],zero,zmm6[56],zero,zmm6[62,63]
; AVX512BW-NEXT:    vpshufb {{.*#+}} zmm17 = zmm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm5[20],zero,zmm5[18],zero,zero,zero,zero,zmm5[21],zero,zmm5[19],zero,zero,zero,zero,zmm5[22,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm5[57],zero,zmm5[55],zero,zero,zero,zero,zmm5[58],zero,zmm5[56],zero,zero
; AVX512BW-NEXT:    vporq %zmm16, %zmm17, %zmm16
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm16 = zmm16[2,3,2,3,6,7,6,7]
; AVX512BW-NEXT:    movabsq $1161999626690365456, %rcx # imm = 0x1020408102040810
; AVX512BW-NEXT:    kmovq %rcx, %k2
; AVX512BW-NEXT:    vmovdqu8 %zmm15, %zmm16 {%k2}
; AVX512BW-NEXT:    movabsq $2033499346708139548, %rcx # imm = 0x1C3870E1C3870E1C
; AVX512BW-NEXT:    kmovq %rcx, %k2
; AVX512BW-NEXT:    vmovdqu8 %zmm16, %zmm9 {%k2}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[u,u,u],zero,xmm14[7],zero,xmm14[5,u,u,u],zero,xmm14[8],zero,xmm14[6,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm12[u,u,u,7],zero,xmm12[5],zero,xmm12[u,u,u,8],zero,xmm12[6],zero,xmm12[u,u]
; AVX512BW-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm12 = xmm12[0],xmm14[0],xmm12[1],xmm14[1],xmm12[2],xmm14[2],xmm12[3],xmm14[3],xmm12[4],xmm14[4],xmm12[5],xmm14[5],xmm12[6],xmm14[6],xmm12[7],xmm14[7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512BW-NEXT:    vinserti32x4 $2, %xmm15, %zmm12, %zmm12
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm12 = zmm12[0,1,0,1,4,5,4,5]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm10[u],zero,xmm10[7],zero,xmm10[5,u,u,u],zero,xmm10[8],zero,xmm10[6,u,u,u],zero
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm8[u,7],zero,xmm8[5],zero,xmm8[u,u,u,8],zero,xmm8[6],zero,xmm8[u,u,u,9]
; AVX512BW-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm8 = xmm8[0],xmm10[0],xmm8[1],xmm10[1],xmm8[2],xmm10[2],xmm8[3],xmm10[3],xmm8[4],xmm10[4],xmm8[5],xmm10[5],xmm8[6],xmm10[6],xmm8[7],xmm10[7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512BW-NEXT:    vinserti32x4 $2, %xmm14, %zmm8, %zmm8
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[0,1,0,1,4,5,4,5]
; AVX512BW-NEXT:    movabsq $871499720017774092, %rcx # imm = 0xC183060C183060C
; AVX512BW-NEXT:    kmovq %rcx, %k2
; AVX512BW-NEXT:    vmovdqu8 %zmm12, %zmm8 {%k2}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm10 = zero,xmm11[4,u,u,u],zero,xmm11[7],zero,xmm11[5,u,u,u],zero,xmm11[8],zero,xmm11[6]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm13[4],zero,xmm13[u,u,u,7],zero,xmm13[5],zero,xmm13[u,u,u,8],zero,xmm13[6],zero
; AVX512BW-NEXT:    vpor %xmm10, %xmm12, %xmm10
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm13[0],xmm11[0],xmm13[1],xmm11[1],xmm13[2],xmm11[2],xmm13[3],xmm11[3],xmm13[4],xmm11[4],xmm13[5],xmm11[5],xmm13[6],xmm11[6],xmm13[7],xmm11[7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512BW-NEXT:    vinserti32x4 $2, %xmm10, %zmm11, %zmm10
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm10 = zmm10[0,1,0,1,4,5,4,5]
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm11 = [1,1,0,0,1,1,0,0,4,5,1,1,1,1,0,0,18,18,18,20,18,18,18,20,19,19,19,19,18,18,18,20]
; AVX512BW-NEXT:    vpermw %zmm7, %zmm11, %zmm11
; AVX512BW-NEXT:    movabsq $4647998506761461824, %rcx # imm = 0x4081020408102040
; AVX512BW-NEXT:    kmovq %rcx, %k2
; AVX512BW-NEXT:    vmovdqu8 %zmm11, %zmm10 {%k2}
; AVX512BW-NEXT:    movabsq $8133997386832558192, %rcx # imm = 0x70E1C3870E1C3870
; AVX512BW-NEXT:    kmovq %rcx, %k2
; AVX512BW-NEXT:    vmovdqu8 %zmm10, %zmm8 {%k2}
; AVX512BW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,6,7,7,6,8,9,10,11,14,15,15,14]
; AVX512BW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[2,2,3,3,6,6,7,7]
; AVX512BW-NEXT:    movl $338170920, %ecx # imm = 0x14281428
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm4 {%k2} = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,30,u,28,u,u,u,u,31,u,29,u,u,u]
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm2 = ymm4[2,3,2,3]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27,u,u,u,u,30,u,28,u,u,u,u,31,u,29,u]
; AVX512BW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm1[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512BW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,2,3,3,4,6,7,7]
; AVX512BW-NEXT:    vmovdqu8 %ymm1, %ymm3 {%k1}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm1 = ymm3[2,3,2,3]
; AVX512BW-NEXT:    movl $101455920, %ecx # imm = 0x60C1830
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu8 %ymm2, %ymm1 {%k1}
; AVX512BW-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [14,13,14,15,15,14,14,15,14,13,14,15,15,14,14,15]
; AVX512BW-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512BW-NEXT:    vpermw %ymm7, %ymm2, %ymm2
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm3 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm5[27],zero,zero,zero,zero,ymm5[30],zero,ymm5[28],zero,zero,zero,zero,ymm5[31],zero
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm6[27],zero,zero,zero,zero,ymm6[30],zero,ymm6[28],zero,zero,zero,zero,ymm6[31],zero,ymm6[29]
; AVX512BW-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX512BW-NEXT:    movl $-2130574328, %ecx # imm = 0x81020408
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu8 %ymm2, %ymm3 {%k1}
; AVX512BW-NEXT:    movl $-507279602, %ecx # imm = 0xE1C3870E
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu8 %ymm3, %ymm1 {%k1}
; AVX512BW-NEXT:    vmovdqa %ymm1, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 64(%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i8_stride7_vf32:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512BW-FCP-NEXT:    vmovdqa (%rsi), %ymm4
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-FCP-NEXT:    vmovdqa (%rcx), %ymm2
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[0,1,0,1,14],zero,ymm1[14,15,0,1,14,15],zero,ymm1[13,14,15,16,17,16],zero,ymm1[30,31,30,31,16,17],zero,ymm1[31,28,29,30,31]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,ymm2[14],zero,zero,zero,zero,zero,zero,ymm2[15],zero,zero,zero,zero,zero,zero,ymm2[16],zero,zero,zero,zero,zero,zero,ymm2[17],zero,zero,zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %ymm0, %ymm5, %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm8
; AVX512BW-FCP-NEXT:    vmovdqa (%rsi), %xmm9
; AVX512BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm9[8],xmm8[8],xmm9[9],xmm8[9],xmm9[10],xmm8[10],xmm9[11],xmm8[11],xmm9[12],xmm8[12],xmm9[13],xmm8[13],xmm9[14],xmm8[14],xmm9[15],xmm8[15]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm5, %zmm5
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm3[0,1,14],zero,ymm3[12,13,0,1,14,15],zero,ymm3[3,12,13,2,3,16],zero,ymm3[30,31,28,29,16,17],zero,ymm3[31,18,19,28,29,18],zero
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,ymm4[14],zero,zero,zero,zero,zero,zero,ymm4[15],zero,zero,zero,zero,zero,zero,ymm4[16],zero,zero,zero,zero,zero,zero,ymm4[17],zero,zero,zero,zero,zero,zero,ymm4[18]
; AVX512BW-FCP-NEXT:    vpor %ymm0, %ymm6, %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm12
; AVX512BW-FCP-NEXT:    vmovdqa (%rcx), %xmm14
; AVX512BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm14[8],xmm12[8],xmm14[9],xmm12[9],xmm14[10],xmm12[10],xmm14[11],xmm12[11],xmm14[12],xmm12[12],xmm14[13],xmm12[13],xmm14[14],xmm12[14],xmm14[15],xmm12[15]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    movabsq $435749858791416001, %rcx # imm = 0x60C1830183060C1
; AVX512BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm5, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm7 = ymm5[13],zero,zero,zero,zero,zero,zero,ymm5[14],zero,zero,zero,zero,zero,zero,ymm5[15],zero,zero,zero,zero,zero,zero,ymm5[16],zero,zero,zero,zero,zero,zero,ymm5[17],zero,zero,zero
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = zero,zero,zero,zero,zero,zero,ymm6[14],zero,zero,zero,zero,zero,zero,ymm6[15],zero,zero,zero,zero,zero,zero,ymm6[16],zero,zero,zero,zero,zero,zero,ymm6[17],zero,zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %ymm7, %ymm10, %ymm7
; AVX512BW-FCP-NEXT:    vmovdqa (%r9), %xmm11
; AVX512BW-FCP-NEXT:    vmovdqa (%r8), %xmm13
; AVX512BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm10 = xmm13[8],xmm11[8],xmm13[9],xmm11[9],xmm13[10],xmm11[10],xmm13[11],xmm11[11],xmm13[12],xmm11[12],xmm13[13],xmm11[13],xmm13[14],xmm11[14],xmm13[15],xmm11[15]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,1,0,1]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm7, %zmm10, %zmm10
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm15 = [4,5,4,5,5,6,5,6,4,5,4,5,5,6,5,6]
; AVX512BW-FCP-NEXT:    # ymm15 = mem[0,1,0,1]
; AVX512BW-FCP-NEXT:    vpermw %ymm7, %ymm15, %ymm15
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm16 = ymm7[12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm16, %zmm15, %zmm15
; AVX512BW-FCP-NEXT:    movabsq $2323999253380730912, %rcx # imm = 0x2040810204081020
; AVX512BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm15, %zmm10 {%k1}
; AVX512BW-FCP-NEXT:    movabsq $4066998693416279096, %rcx # imm = 0x3870E1C3870E1C38
; AVX512BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm10, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm10
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm10 = zmm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21],zero,zmm10[19],zero,zmm10[21,20,21,22],zero,zmm10[20],zero,zmm10[22,23,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,56,57],zero,zmm10[55],zero,zmm10[53,54,55,58],zero,zmm10[56],zero,zmm10[60,61,58,59]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm4, %zmm15
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm15 = zmm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm15[21],zero,zmm15[19],zero,zero,zero,zero,zmm15[22],zero,zmm15[20],zero,zero,zmm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zmm15[57],zero,zmm15[55],zero,zero,zero,zero,zmm15[58],zero,zmm15[56],zero,zero,zero,zero
; AVX512BW-FCP-NEXT:    vporq %zmm10, %zmm15, %zmm10
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm15 = zmm10[2,3,2,3,6,7,6,7]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm10
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm10 = zmm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18],zero,zmm10[18,19,20,21],zero,zmm10[19],zero,zmm10[25,26,27,22],zero,zmm10[20],zero,zmm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,57],zero,zmm10[55],zero,zero,zero,zero,zmm10[58],zero,zmm10[56],zero,zero,zero,zero,zmm10[59],zero
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm16
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm16 = zmm16[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm16[18],zero,zero,zero,zero,zmm16[21],zero,zmm16[19],zero,zero,zero,zero,zmm16[22],zero,zmm16[20,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm16[55],zero,zero,zero,zero,zmm16[58],zero,zmm16[56],zero,zero,zero,zero,zmm16[59],zero,zmm16[57]
; AVX512BW-FCP-NEXT:    vporq %zmm10, %zmm16, %zmm10
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm10 = zmm10[2,3,2,3,6,7,6,7]
; AVX512BW-FCP-NEXT:    movabsq $-9005497107459067808, %rcx # imm = 0x83060C180C183060
; AVX512BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm15, %zmm10 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm15 = [10,9,9,10,10,9,9,10,9,10,14,15,10,9,9,10,27,29,28,27,28,29,29,28,27,29,28,27,28,29,29,28]
; AVX512BW-FCP-NEXT:    vpermw %zmm7, %zmm15, %zmm15
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm16 = zmm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20],zero,zmm6[18],zero,zmm6[20,21,20,21],zero,zmm6[19],zero,zmm6[19,20,21,22],zero,zmm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,56,57,56,57],zero,zmm6[55],zero,zmm6[55,56,57,58],zero,zmm6[56],zero,zmm6[62,63]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm17 = zmm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm5[20],zero,zmm5[18],zero,zero,zero,zero,zmm5[21],zero,zmm5[19],zero,zero,zero,zero,zmm5[22,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm5[57],zero,zmm5[55],zero,zero,zero,zero,zmm5[58],zero,zmm5[56],zero,zero
; AVX512BW-FCP-NEXT:    vporq %zmm16, %zmm17, %zmm16
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm16 = zmm16[2,3,2,3,6,7,6,7]
; AVX512BW-FCP-NEXT:    movabsq $1161999626690365456, %rcx # imm = 0x1020408102040810
; AVX512BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm15, %zmm16 {%k1}
; AVX512BW-FCP-NEXT:    movabsq $2033499346708139548, %rcx # imm = 0x1C3870E1C3870E1C
; AVX512BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm16, %zmm10 {%k1}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[u,u,u],zero,xmm14[7],zero,xmm14[5,u,u,u],zero,xmm14[8],zero,xmm14[6,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = xmm12[u,u,u,7],zero,xmm12[5],zero,xmm12[u,u,u,8],zero,xmm12[6],zero,xmm12[u,u]
; AVX512BW-FCP-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm12 = xmm12[0],xmm14[0],xmm12[1],xmm14[1],xmm12[2],xmm14[2],xmm12[3],xmm14[3],xmm12[4],xmm14[4],xmm12[5],xmm14[5],xmm12[6],xmm14[6],xmm12[7],xmm14[7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, %xmm15, %zmm12, %zmm12
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm12 = zmm12[0,1,0,1,4,5,4,5]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm9[u],zero,xmm9[7],zero,xmm9[5,u,u,u],zero,xmm9[8],zero,xmm9[6,u,u,u],zero
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm8[u,7],zero,xmm8[5],zero,xmm8[u,u,u,8],zero,xmm8[6],zero,xmm8[u,u,u,9]
; AVX512BW-FCP-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX512BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm8 = xmm8[0],xmm9[0],xmm8[1],xmm9[1],xmm8[2],xmm9[2],xmm8[3],xmm9[3],xmm8[4],xmm9[4],xmm8[5],xmm9[5],xmm8[6],xmm9[6],xmm8[7],xmm9[7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, %xmm14, %zmm8, %zmm8
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[0,1,0,1,4,5,4,5]
; AVX512BW-FCP-NEXT:    movabsq $871499720017774092, %rcx # imm = 0xC183060C183060C
; AVX512BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm12, %zmm8 {%k1}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = zero,xmm11[4,u,u,u],zero,xmm11[7],zero,xmm11[5,u,u,u],zero,xmm11[8],zero,xmm11[6]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm13[4],zero,xmm13[u,u,u,7],zero,xmm13[5],zero,xmm13[u,u,u,8],zero,xmm13[6],zero
; AVX512BW-FCP-NEXT:    vpor %xmm9, %xmm12, %xmm9
; AVX512BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm13[0],xmm11[0],xmm13[1],xmm11[1],xmm13[2],xmm11[2],xmm13[3],xmm11[3],xmm13[4],xmm11[4],xmm13[5],xmm11[5],xmm13[6],xmm11[6],xmm13[7],xmm11[7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, %xmm9, %zmm11, %zmm9
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm9 = zmm9[0,1,0,1,4,5,4,5]
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm11 = [1,1,0,0,1,1,0,0,4,5,1,1,1,1,0,0,18,18,18,20,18,18,18,20,19,19,19,19,18,18,18,20]
; AVX512BW-FCP-NEXT:    vpermw %zmm7, %zmm11, %zmm11
; AVX512BW-FCP-NEXT:    movabsq $4647998506761461824, %rcx # imm = 0x4081020408102040
; AVX512BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm11, %zmm9 {%k1}
; AVX512BW-FCP-NEXT:    movabsq $8133997386832558192, %rcx # imm = 0x70E1C3870E1C3870
; AVX512BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm9, %zmm8 {%k1}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,30],zero,ymm3[28],zero,ymm3[30,31,30,31],zero,ymm3[29],zero,ymm3[31,28,29]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm4[30],zero,ymm4[28],zero,zero,zero,zero,ymm4[31],zero,ymm4[29],zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27],zero,zero,zero,zero,ymm2[30],zero,ymm2[28],zero,zero,zero,zero,ymm2[31],zero,ymm2[29],zero
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero,ymm1[29],zero,zero
; AVX512BW-FCP-NEXT:    vpor %ymm2, %ymm1, %ymm1
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX512BW-FCP-NEXT:    movl $101455920, %ecx # imm = 0x60C1830
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm3, %ymm1 {%k1}
; AVX512BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [14,13,14,15,15,14,14,15,14,13,14,15,15,14,14,15]
; AVX512BW-FCP-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512BW-FCP-NEXT:    vpermw %ymm7, %ymm2, %ymm2
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm5[27],zero,zero,zero,zero,ymm5[30],zero,ymm5[28],zero,zero,zero,zero,ymm5[31],zero
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm6[27],zero,zero,zero,zero,ymm6[30],zero,ymm6[28],zero,zero,zero,zero,ymm6[31],zero,ymm6[29]
; AVX512BW-FCP-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX512BW-FCP-NEXT:    movl $-2130574328, %ecx # imm = 0x81020408
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm2, %ymm3 {%k1}
; AVX512BW-FCP-NEXT:    movl $-507279602, %ecx # imm = 0xE1C3870E
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm3, %ymm1 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa %ymm1, 192(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 64(%rax)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i8_stride7_vf32:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm4
; AVX512DQ-BW-NEXT:    vmovdqa (%rsi), %ymm2
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-BW-NEXT:    vmovdqa (%rcx), %ymm3
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[0,1,0,1,14],zero,ymm1[14,15,0,1,14,15],zero,ymm1[13,14,15,16,17,16],zero,ymm1[30,31,30,31,16,17],zero,ymm1[31,28,29,30,31]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,ymm3[14],zero,zero,zero,zero,zero,zero,ymm3[15],zero,zero,zero,zero,zero,zero,ymm3[16],zero,zero,zero,zero,zero,zero,ymm3[17],zero,zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %ymm0, %ymm5, %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm8
; AVX512DQ-BW-NEXT:    vmovdqa (%rsi), %xmm10
; AVX512DQ-BW-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm10[8],xmm8[8],xmm10[9],xmm8[9],xmm10[10],xmm8[10],xmm10[11],xmm8[11],xmm10[12],xmm8[12],xmm10[13],xmm8[13],xmm10[14],xmm8[14],xmm10[15],xmm8[15]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm5, %zmm5
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm4[0,1,14],zero,ymm4[12,13,0,1,14,15],zero,ymm4[3,12,13,2,3,16],zero,ymm4[30,31,28,29,16,17],zero,ymm4[31,18,19,28,29,18],zero
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,ymm2[14],zero,zero,zero,zero,zero,zero,ymm2[15],zero,zero,zero,zero,zero,zero,ymm2[16],zero,zero,zero,zero,zero,zero,ymm2[17],zero,zero,zero,zero,zero,zero,ymm2[18]
; AVX512DQ-BW-NEXT:    vpor %ymm0, %ymm6, %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm12
; AVX512DQ-BW-NEXT:    vmovdqa (%rcx), %xmm14
; AVX512DQ-BW-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm14[8],xmm12[8],xmm14[9],xmm12[9],xmm14[10],xmm12[10],xmm14[11],xmm12[11],xmm14[12],xmm12[12],xmm14[13],xmm12[13],xmm14[14],xmm12[14],xmm14[15],xmm12[15]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    movabsq $435749858791416001, %rcx # imm = 0x60C1830183060C1
; AVX512DQ-BW-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm5, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm7 = ymm5[13],zero,zero,zero,zero,zero,zero,ymm5[14],zero,zero,zero,zero,zero,zero,ymm5[15],zero,zero,zero,zero,zero,zero,ymm5[16],zero,zero,zero,zero,zero,zero,ymm5[17],zero,zero,zero
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm9 = zero,zero,zero,zero,zero,zero,ymm6[14],zero,zero,zero,zero,zero,zero,ymm6[15],zero,zero,zero,zero,zero,zero,ymm6[16],zero,zero,zero,zero,zero,zero,ymm6[17],zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %ymm7, %ymm9, %ymm7
; AVX512DQ-BW-NEXT:    vmovdqa (%r9), %xmm11
; AVX512DQ-BW-NEXT:    vmovdqa (%r8), %xmm13
; AVX512DQ-BW-NEXT:    vpunpckhbw {{.*#+}} xmm9 = xmm13[8],xmm11[8],xmm13[9],xmm11[9],xmm13[10],xmm11[10],xmm13[11],xmm11[11],xmm13[12],xmm11[12],xmm13[13],xmm11[13],xmm13[14],xmm11[14],xmm13[15],xmm11[15]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,0,1]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm7, %zmm9, %zmm9
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vbroadcasti128 {{.*#+}} ymm15 = [4,5,4,5,5,6,5,6,4,5,4,5,5,6,5,6]
; AVX512DQ-BW-NEXT:    # ymm15 = mem[0,1,0,1]
; AVX512DQ-BW-NEXT:    vpermw %ymm7, %ymm15, %ymm15
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm16 = ymm7[12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm16, %zmm15, %zmm15
; AVX512DQ-BW-NEXT:    movabsq $2323999253380730912, %rcx # imm = 0x2040810204081020
; AVX512DQ-BW-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm15, %zmm9 {%k1}
; AVX512DQ-BW-NEXT:    movabsq $4066998693416279096, %rcx # imm = 0x3870E1C3870E1C38
; AVX512DQ-BW-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm9, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm9
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} zmm9 = zmm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18],zero,zmm9[18,19,20,21],zero,zmm9[19],zero,zmm9[25,26,27,22],zero,zmm9[20],zero,zmm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,57],zero,zmm9[55],zero,zero,zero,zero,zmm9[58],zero,zmm9[56],zero,zero,zero,zero,zmm9[59],zero
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm15
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} zmm15 = zmm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm15[18],zero,zero,zero,zero,zmm15[21],zero,zmm15[19],zero,zero,zero,zero,zmm15[22],zero,zmm15[20,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm15[55],zero,zero,zero,zero,zmm15[58],zero,zmm15[56],zero,zero,zero,zero,zmm15[59],zero,zmm15[57]
; AVX512DQ-BW-NEXT:    vporq %zmm9, %zmm15, %zmm9
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm9 = zmm9[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-NEXT:    vpshuflw {{.*#+}} ymm15 = ymm4[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512DQ-BW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm15[0,0,1,1,4,4,5,5]
; AVX512DQ-BW-NEXT:    movl $676341840, %ecx # imm = 0x28502850
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm15 {%k1} = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,21,u,19,u,u,u,u,22,u,20,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm16 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25],zero,ymm1[23],zero,ymm1[21,22,23,26],zero,ymm1[24],zero,ymm1[28,29,26,27]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm17 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm3[25],zero,ymm3[23],zero,zero,zero,zero,ymm3[26],zero,ymm3[24],zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vporq %ymm16, %ymm17, %ymm16
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm16, %zmm15, %zmm15
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm15 = zmm15[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-NEXT:    movabsq $-9005497107459067808, %rcx # imm = 0x83060C180C183060
; AVX512DQ-BW-NEXT:    kmovq %rcx, %k2
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm15, %zmm9 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm15 = [10,9,9,10,10,9,9,10,9,10,14,15,10,9,9,10,27,29,28,27,28,29,29,28,27,29,28,27,28,29,29,28]
; AVX512DQ-BW-NEXT:    vpermw %zmm7, %zmm15, %zmm15
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} zmm16 = zmm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20],zero,zmm6[18],zero,zmm6[20,21,20,21],zero,zmm6[19],zero,zmm6[19,20,21,22],zero,zmm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,56,57,56,57],zero,zmm6[55],zero,zmm6[55,56,57,58],zero,zmm6[56],zero,zmm6[62,63]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} zmm17 = zmm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm5[20],zero,zmm5[18],zero,zero,zero,zero,zmm5[21],zero,zmm5[19],zero,zero,zero,zero,zmm5[22,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm5[57],zero,zmm5[55],zero,zero,zero,zero,zmm5[58],zero,zmm5[56],zero,zero
; AVX512DQ-BW-NEXT:    vporq %zmm16, %zmm17, %zmm16
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm16 = zmm16[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-NEXT:    movabsq $1161999626690365456, %rcx # imm = 0x1020408102040810
; AVX512DQ-BW-NEXT:    kmovq %rcx, %k2
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm15, %zmm16 {%k2}
; AVX512DQ-BW-NEXT:    movabsq $2033499346708139548, %rcx # imm = 0x1C3870E1C3870E1C
; AVX512DQ-BW-NEXT:    kmovq %rcx, %k2
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm16, %zmm9 {%k2}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[u,u,u],zero,xmm14[7],zero,xmm14[5,u,u,u],zero,xmm14[8],zero,xmm14[6,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm12[u,u,u,7],zero,xmm12[5],zero,xmm12[u,u,u,8],zero,xmm12[6],zero,xmm12[u,u]
; AVX512DQ-BW-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512DQ-BW-NEXT:    vpunpcklbw {{.*#+}} xmm12 = xmm12[0],xmm14[0],xmm12[1],xmm14[1],xmm12[2],xmm14[2],xmm12[3],xmm14[3],xmm12[4],xmm14[4],xmm12[5],xmm14[5],xmm12[6],xmm14[6],xmm12[7],xmm14[7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, %xmm15, %zmm12, %zmm12
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm12 = zmm12[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm10[u],zero,xmm10[7],zero,xmm10[5,u,u,u],zero,xmm10[8],zero,xmm10[6,u,u,u],zero
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm8[u,7],zero,xmm8[5],zero,xmm8[u,u,u,8],zero,xmm8[6],zero,xmm8[u,u,u,9]
; AVX512DQ-BW-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX512DQ-BW-NEXT:    vpunpcklbw {{.*#+}} xmm8 = xmm8[0],xmm10[0],xmm8[1],xmm10[1],xmm8[2],xmm10[2],xmm8[3],xmm10[3],xmm8[4],xmm10[4],xmm8[5],xmm10[5],xmm8[6],xmm10[6],xmm8[7],xmm10[7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, %xmm14, %zmm8, %zmm8
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-NEXT:    movabsq $871499720017774092, %rcx # imm = 0xC183060C183060C
; AVX512DQ-BW-NEXT:    kmovq %rcx, %k2
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm12, %zmm8 {%k2}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm10 = zero,xmm11[4,u,u,u],zero,xmm11[7],zero,xmm11[5,u,u,u],zero,xmm11[8],zero,xmm11[6]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm13[4],zero,xmm13[u,u,u,7],zero,xmm13[5],zero,xmm13[u,u,u,8],zero,xmm13[6],zero
; AVX512DQ-BW-NEXT:    vpor %xmm10, %xmm12, %xmm10
; AVX512DQ-BW-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm13[0],xmm11[0],xmm13[1],xmm11[1],xmm13[2],xmm11[2],xmm13[3],xmm11[3],xmm13[4],xmm11[4],xmm13[5],xmm11[5],xmm13[6],xmm11[6],xmm13[7],xmm11[7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, %xmm10, %zmm11, %zmm10
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm10 = zmm10[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm11 = [1,1,0,0,1,1,0,0,4,5,1,1,1,1,0,0,18,18,18,20,18,18,18,20,19,19,19,19,18,18,18,20]
; AVX512DQ-BW-NEXT:    vpermw %zmm7, %zmm11, %zmm11
; AVX512DQ-BW-NEXT:    movabsq $4647998506761461824, %rcx # imm = 0x4081020408102040
; AVX512DQ-BW-NEXT:    kmovq %rcx, %k2
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm11, %zmm10 {%k2}
; AVX512DQ-BW-NEXT:    movabsq $8133997386832558192, %rcx # imm = 0x70E1C3870E1C3870
; AVX512DQ-BW-NEXT:    kmovq %rcx, %k2
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm10, %zmm8 {%k2}
; AVX512DQ-BW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,6,7,7,6,8,9,10,11,14,15,15,14]
; AVX512DQ-BW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[2,2,3,3,6,6,7,7]
; AVX512DQ-BW-NEXT:    movl $338170920, %ecx # imm = 0x14281428
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm4 {%k2} = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,30,u,28,u,u,u,u,31,u,29,u,u,u]
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm2 = ymm4[2,3,2,3]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27,u,u,u,u,30,u,28,u,u,u,u,31,u,29,u]
; AVX512DQ-BW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm1[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512DQ-BW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,2,3,3,4,6,7,7]
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm1, %ymm3 {%k1}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm1 = ymm3[2,3,2,3]
; AVX512DQ-BW-NEXT:    movl $101455920, %ecx # imm = 0x60C1830
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm2, %ymm1 {%k1}
; AVX512DQ-BW-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [14,13,14,15,15,14,14,15,14,13,14,15,15,14,14,15]
; AVX512DQ-BW-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512DQ-BW-NEXT:    vpermw %ymm7, %ymm2, %ymm2
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm3 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm5[27],zero,zero,zero,zero,ymm5[30],zero,ymm5[28],zero,zero,zero,zero,ymm5[31],zero
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm6[27],zero,zero,zero,zero,ymm6[30],zero,ymm6[28],zero,zero,zero,zero,ymm6[31],zero,ymm6[29]
; AVX512DQ-BW-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX512DQ-BW-NEXT:    movl $-2130574328, %ecx # imm = 0x81020408
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm2, %ymm3 {%k1}
; AVX512DQ-BW-NEXT:    movl $-507279602, %ecx # imm = 0xE1C3870E
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm3, %ymm1 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa %ymm1, 192(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, 128(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 64(%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i8_stride7_vf32:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rsi), %ymm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rcx), %ymm2
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[0,1,0,1,14],zero,ymm1[14,15,0,1,14,15],zero,ymm1[13,14,15,16,17,16],zero,ymm1[30,31,30,31,16,17],zero,ymm1[31,28,29,30,31]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,ymm2[14],zero,zero,zero,zero,zero,zero,ymm2[15],zero,zero,zero,zero,zero,zero,ymm2[16],zero,zero,zero,zero,zero,zero,ymm2[17],zero,zero,zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm0, %ymm5, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rsi), %xmm9
; AVX512DQ-BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm9[8],xmm8[8],xmm9[9],xmm8[9],xmm9[10],xmm8[10],xmm9[11],xmm8[11],xmm9[12],xmm8[12],xmm9[13],xmm8[13],xmm9[14],xmm8[14],xmm9[15],xmm8[15]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm5, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm3[0,1,14],zero,ymm3[12,13,0,1,14,15],zero,ymm3[3,12,13,2,3,16],zero,ymm3[30,31,28,29,16,17],zero,ymm3[31,18,19,28,29,18],zero
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,ymm4[14],zero,zero,zero,zero,zero,zero,ymm4[15],zero,zero,zero,zero,zero,zero,ymm4[16],zero,zero,zero,zero,zero,zero,ymm4[17],zero,zero,zero,zero,zero,zero,ymm4[18]
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm0, %ymm6, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rcx), %xmm14
; AVX512DQ-BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm14[8],xmm12[8],xmm14[9],xmm12[9],xmm14[10],xmm12[10],xmm14[11],xmm12[11],xmm14[12],xmm12[12],xmm14[13],xmm12[13],xmm14[14],xmm12[14],xmm14[15],xmm12[15]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    movabsq $435749858791416001, %rcx # imm = 0x60C1830183060C1
; AVX512DQ-BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm5, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm7 = ymm5[13],zero,zero,zero,zero,zero,zero,ymm5[14],zero,zero,zero,zero,zero,zero,ymm5[15],zero,zero,zero,zero,zero,zero,ymm5[16],zero,zero,zero,zero,zero,zero,ymm5[17],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = zero,zero,zero,zero,zero,zero,ymm6[14],zero,zero,zero,zero,zero,zero,ymm6[15],zero,zero,zero,zero,zero,zero,ymm6[16],zero,zero,zero,zero,zero,zero,ymm6[17],zero,zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm7, %ymm10, %ymm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r9), %xmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r8), %xmm13
; AVX512DQ-BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm10 = xmm13[8],xmm11[8],xmm13[9],xmm11[9],xmm13[10],xmm11[10],xmm13[11],xmm11[11],xmm13[12],xmm11[12],xmm13[13],xmm11[13],xmm13[14],xmm11[14],xmm13[15],xmm11[15]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm7, %zmm10, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm15 = [4,5,4,5,5,6,5,6,4,5,4,5,5,6,5,6]
; AVX512DQ-BW-FCP-NEXT:    # ymm15 = mem[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vpermw %ymm7, %ymm15, %ymm15
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm16 = ymm7[12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm16, %zmm15, %zmm15
; AVX512DQ-BW-FCP-NEXT:    movabsq $2323999253380730912, %rcx # imm = 0x2040810204081020
; AVX512DQ-BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm15, %zmm10 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movabsq $4066998693416279096, %rcx # imm = 0x3870E1C3870E1C38
; AVX512DQ-BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm10, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm10 = zmm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21],zero,zmm10[19],zero,zmm10[21,20,21,22],zero,zmm10[20],zero,zmm10[22,23,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,56,57],zero,zmm10[55],zero,zmm10[53,54,55,58],zero,zmm10[56],zero,zmm10[60,61,58,59]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm4, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm15 = zmm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm15[21],zero,zmm15[19],zero,zero,zero,zero,zmm15[22],zero,zmm15[20],zero,zero,zmm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zmm15[57],zero,zmm15[55],zero,zero,zero,zero,zmm15[58],zero,zmm15[56],zero,zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vporq %zmm10, %zmm15, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm15 = zmm10[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm10 = zmm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18],zero,zmm10[18,19,20,21],zero,zmm10[19],zero,zmm10[25,26,27,22],zero,zmm10[20],zero,zmm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,57],zero,zmm10[55],zero,zero,zero,zero,zmm10[58],zero,zmm10[56],zero,zero,zero,zero,zmm10[59],zero
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm16 = zmm16[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm16[18],zero,zero,zero,zero,zmm16[21],zero,zmm16[19],zero,zero,zero,zero,zmm16[22],zero,zmm16[20,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm16[55],zero,zero,zero,zero,zmm16[58],zero,zmm16[56],zero,zero,zero,zero,zmm16[59],zero,zmm16[57]
; AVX512DQ-BW-FCP-NEXT:    vporq %zmm10, %zmm16, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm10 = zmm10[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-FCP-NEXT:    movabsq $-9005497107459067808, %rcx # imm = 0x83060C180C183060
; AVX512DQ-BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm15, %zmm10 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm15 = [10,9,9,10,10,9,9,10,9,10,14,15,10,9,9,10,27,29,28,27,28,29,29,28,27,29,28,27,28,29,29,28]
; AVX512DQ-BW-FCP-NEXT:    vpermw %zmm7, %zmm15, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm16 = zmm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20],zero,zmm6[18],zero,zmm6[20,21,20,21],zero,zmm6[19],zero,zmm6[19,20,21,22],zero,zmm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,56,57,56,57],zero,zmm6[55],zero,zmm6[55,56,57,58],zero,zmm6[56],zero,zmm6[62,63]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm17 = zmm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm5[20],zero,zmm5[18],zero,zero,zero,zero,zmm5[21],zero,zmm5[19],zero,zero,zero,zero,zmm5[22,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm5[57],zero,zmm5[55],zero,zero,zero,zero,zmm5[58],zero,zmm5[56],zero,zero
; AVX512DQ-BW-FCP-NEXT:    vporq %zmm16, %zmm17, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm16 = zmm16[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-FCP-NEXT:    movabsq $1161999626690365456, %rcx # imm = 0x1020408102040810
; AVX512DQ-BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm15, %zmm16 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movabsq $2033499346708139548, %rcx # imm = 0x1C3870E1C3870E1C
; AVX512DQ-BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm16, %zmm10 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[u,u,u],zero,xmm14[7],zero,xmm14[5,u,u,u],zero,xmm14[8],zero,xmm14[6,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = xmm12[u,u,u,7],zero,xmm12[5],zero,xmm12[u,u,u,8],zero,xmm12[6],zero,xmm12[u,u]
; AVX512DQ-BW-FCP-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512DQ-BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm12 = xmm12[0],xmm14[0],xmm12[1],xmm14[1],xmm12[2],xmm14[2],xmm12[3],xmm14[3],xmm12[4],xmm14[4],xmm12[5],xmm14[5],xmm12[6],xmm14[6],xmm12[7],xmm14[7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, %xmm15, %zmm12, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm12 = zmm12[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm9[u],zero,xmm9[7],zero,xmm9[5,u,u,u],zero,xmm9[8],zero,xmm9[6,u,u,u],zero
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm8[u,7],zero,xmm8[5],zero,xmm8[u,u,u,8],zero,xmm8[6],zero,xmm8[u,u,u,9]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX512DQ-BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm8 = xmm8[0],xmm9[0],xmm8[1],xmm9[1],xmm8[2],xmm9[2],xmm8[3],xmm9[3],xmm8[4],xmm9[4],xmm8[5],xmm9[5],xmm8[6],xmm9[6],xmm8[7],xmm9[7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, %xmm14, %zmm8, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-FCP-NEXT:    movabsq $871499720017774092, %rcx # imm = 0xC183060C183060C
; AVX512DQ-BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm12, %zmm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = zero,xmm11[4,u,u,u],zero,xmm11[7],zero,xmm11[5,u,u,u],zero,xmm11[8],zero,xmm11[6]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm13[4],zero,xmm13[u,u,u,7],zero,xmm13[5],zero,xmm13[u,u,u,8],zero,xmm13[6],zero
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm9, %xmm12, %xmm9
; AVX512DQ-BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm13[0],xmm11[0],xmm13[1],xmm11[1],xmm13[2],xmm11[2],xmm13[3],xmm11[3],xmm13[4],xmm11[4],xmm13[5],xmm11[5],xmm13[6],xmm11[6],xmm13[7],xmm11[7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, %xmm9, %zmm11, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm9 = zmm9[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm11 = [1,1,0,0,1,1,0,0,4,5,1,1,1,1,0,0,18,18,18,20,18,18,18,20,19,19,19,19,18,18,18,20]
; AVX512DQ-BW-FCP-NEXT:    vpermw %zmm7, %zmm11, %zmm11
; AVX512DQ-BW-FCP-NEXT:    movabsq $4647998506761461824, %rcx # imm = 0x4081020408102040
; AVX512DQ-BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm11, %zmm9 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movabsq $8133997386832558192, %rcx # imm = 0x70E1C3870E1C3870
; AVX512DQ-BW-FCP-NEXT:    kmovq %rcx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm9, %zmm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,30],zero,ymm3[28],zero,ymm3[30,31,30,31],zero,ymm3[29],zero,ymm3[31,28,29]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm4[30],zero,ymm4[28],zero,zero,zero,zero,ymm4[31],zero,ymm4[29],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27],zero,zero,zero,zero,ymm2[30],zero,ymm2[28],zero,zero,zero,zero,ymm2[31],zero,ymm2[29],zero
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero,ymm1[29],zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm2, %ymm1, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX512DQ-BW-FCP-NEXT:    movl $101455920, %ecx # imm = 0x60C1830
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm3, %ymm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [14,13,14,15,15,14,14,15,14,13,14,15,15,14,14,15]
; AVX512DQ-BW-FCP-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vpermw %ymm7, %ymm2, %ymm2
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm5[27],zero,zero,zero,zero,ymm5[30],zero,ymm5[28],zero,zero,zero,zero,ymm5[31],zero
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm6[27],zero,zero,zero,zero,ymm6[30],zero,ymm6[28],zero,zero,zero,zero,ymm6[31],zero,ymm6[29]
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX512DQ-BW-FCP-NEXT:    movl $-2130574328, %ecx # imm = 0x81020408
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm2, %ymm3 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movl $-507279602, %ecx # imm = 0xE1C3870E
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm3, %ymm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm1, 192(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 64(%rax)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <32 x i8>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i8>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i8>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i8>, ptr %in.vecptr3, align 64
  %in.vec4 = load <32 x i8>, ptr %in.vecptr4, align 64
  %in.vec5 = load <32 x i8>, ptr %in.vecptr5, align 64
  %in.vec6 = load <32 x i8>, ptr %in.vecptr6, align 64
  %1 = shufflevector <32 x i8> %in.vec0, <32 x i8> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i8> %in.vec2, <32 x i8> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <32 x i8> %in.vec4, <32 x i8> %in.vec5, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = shufflevector <64 x i8> %1, <64 x i8> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %5 = shufflevector <32 x i8> %in.vec6, <32 x i8> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <64 x i8> %3, <64 x i8> %5, <96 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95>
  %7 = shufflevector <96 x i8> %6, <96 x i8> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <128 x i8> %4, <128 x i8> %7, <224 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223>
  %interleaved.vec = shufflevector <224 x i8> %8, <224 x i8> poison, <224 x i32> <i32 0, i32 32, i32 64, i32 96, i32 128, i32 160, i32 192, i32 1, i32 33, i32 65, i32 97, i32 129, i32 161, i32 193, i32 2, i32 34, i32 66, i32 98, i32 130, i32 162, i32 194, i32 3, i32 35, i32 67, i32 99, i32 131, i32 163, i32 195, i32 4, i32 36, i32 68, i32 100, i32 132, i32 164, i32 196, i32 5, i32 37, i32 69, i32 101, i32 133, i32 165, i32 197, i32 6, i32 38, i32 70, i32 102, i32 134, i32 166, i32 198, i32 7, i32 39, i32 71, i32 103, i32 135, i32 167, i32 199, i32 8, i32 40, i32 72, i32 104, i32 136, i32 168, i32 200, i32 9, i32 41, i32 73, i32 105, i32 137, i32 169, i32 201, i32 10, i32 42, i32 74, i32 106, i32 138, i32 170, i32 202, i32 11, i32 43, i32 75, i32 107, i32 139, i32 171, i32 203, i32 12, i32 44, i32 76, i32 108, i32 140, i32 172, i32 204, i32 13, i32 45, i32 77, i32 109, i32 141, i32 173, i32 205, i32 14, i32 46, i32 78, i32 110, i32 142, i32 174, i32 206, i32 15, i32 47, i32 79, i32 111, i32 143, i32 175, i32 207, i32 16, i32 48, i32 80, i32 112, i32 144, i32 176, i32 208, i32 17, i32 49, i32 81, i32 113, i32 145, i32 177, i32 209, i32 18, i32 50, i32 82, i32 114, i32 146, i32 178, i32 210, i32 19, i32 51, i32 83, i32 115, i32 147, i32 179, i32 211, i32 20, i32 52, i32 84, i32 116, i32 148, i32 180, i32 212, i32 21, i32 53, i32 85, i32 117, i32 149, i32 181, i32 213, i32 22, i32 54, i32 86, i32 118, i32 150, i32 182, i32 214, i32 23, i32 55, i32 87, i32 119, i32 151, i32 183, i32 215, i32 24, i32 56, i32 88, i32 120, i32 152, i32 184, i32 216, i32 25, i32 57, i32 89, i32 121, i32 153, i32 185, i32 217, i32 26, i32 58, i32 90, i32 122, i32 154, i32 186, i32 218, i32 27, i32 59, i32 91, i32 123, i32 155, i32 187, i32 219, i32 28, i32 60, i32 92, i32 124, i32 156, i32 188, i32 220, i32 29, i32 61, i32 93, i32 125, i32 157, i32 189, i32 221, i32 30, i32 62, i32 94, i32 126, i32 158, i32 190, i32 222, i32 31, i32 63, i32 95, i32 127, i32 159, i32 191, i32 223>
  store <224 x i8> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i8_stride7_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i8_stride7_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $648, %rsp # imm = 0x288
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa 48(%rdi), %xmm14
; SSE-NEXT:    movdqa 48(%rsi), %xmm2
; SSE-NEXT:    movdqa 48(%rdx), %xmm3
; SSE-NEXT:    movdqa 48(%rcx), %xmm10
; SSE-NEXT:    movdqa 48(%r8), %xmm5
; SSE-NEXT:    movdqa 48(%r9), %xmm8
; SSE-NEXT:    movdqa 48(%rax), %xmm13
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm14[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[2,1,2,3]
; SSE-NEXT:    movdqa %xmm2, %xmm11
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,0,3]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255]
; SSE-NEXT:    pand %xmm12, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm3[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm10[2,1,2,3]
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm5[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm5, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,2]
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255]
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm8[2,1,2,3]
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,0]
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255]
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm13[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm11[8],xmm0[9],xmm11[9],xmm0[10],xmm11[10],xmm0[11],xmm11[11],xmm0[12],xmm11[12],xmm0[13],xmm11[13],xmm0[14],xmm11[14],xmm0[15],xmm11[15]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm0[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm5
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm14[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,2,2,2]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm5, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm6[0,1,2,3,6,6,6,6]
; SSE-NEXT:    movdqa %xmm6, %xmm15
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,2,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm6
; SSE-NEXT:    pandn %xmm5, %xmm6
; SSE-NEXT:    movdqa %xmm10, %xmm5
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm10[8],xmm5[9],xmm10[9],xmm5[10],xmm10[10],xmm5[11],xmm10[11],xmm5[12],xmm10[12],xmm5[13],xmm10[13],xmm5[14],xmm10[14],xmm5[15],xmm10[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm5[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pand %xmm7, %xmm8
; SSE-NEXT:    por %xmm6, %xmm8
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    por %xmm3, %xmm8
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm9[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,3,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    por %xmm8, %xmm6
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm3[1,1,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm4, %xmm11
; SSE-NEXT:    pandn %xmm8, %xmm11
; SSE-NEXT:    pand %xmm4, %xmm6
; SSE-NEXT:    por %xmm6, %xmm11
; SSE-NEXT:    movdqa %xmm13, %xmm10
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm13[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,1,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm8
; SSE-NEXT:    pand %xmm1, %xmm11
; SSE-NEXT:    por %xmm11, %xmm8
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,1,1,3]
; SSE-NEXT:    movdqa %xmm4, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm8
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm15[0,1,2,3,4,5,5,7]
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,1,3,2]
; SSE-NEXT:    pand %xmm4, %xmm6
; SSE-NEXT:    por %xmm8, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0]
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm8
; SSE-NEXT:    movdqa %xmm14, %xmm13
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm14[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,2,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm11
; SSE-NEXT:    pandn %xmm6, %xmm11
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm0[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,0,2,1]
; SSE-NEXT:    pand %xmm7, %xmm6
; SSE-NEXT:    por %xmm11, %xmm6
; SSE-NEXT:    pand %xmm1, %xmm6
; SSE-NEXT:    por %xmm8, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm9[0,1,2,3,4,4,6,5]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[2,1,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm4, %xmm11
; SSE-NEXT:    pandn %xmm8, %xmm11
; SSE-NEXT:    pand %xmm4, %xmm6
; SSE-NEXT:    por %xmm6, %xmm11
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm3[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm9, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm8
; SSE-NEXT:    pand %xmm9, %xmm11
; SSE-NEXT:    movdqa %xmm9, %xmm14
; SSE-NEXT:    por %xmm11, %xmm8
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm10[0,1,2,3,4,5,5,7]
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,2,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm11, %xmm9
; SSE-NEXT:    pandn %xmm6, %xmm9
; SSE-NEXT:    pand %xmm11, %xmm8
; SSE-NEXT:    por %xmm8, %xmm9
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,6,5,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,2,2,3]
; SSE-NEXT:    movdqa %xmm11, %xmm6
; SSE-NEXT:    pandn %xmm5, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm15[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,2,2,2]
; SSE-NEXT:    pand %xmm11, %xmm5
; SSE-NEXT:    por %xmm5, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm8, %xmm5
; SSE-NEXT:    pandn %xmm6, %xmm5
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,3]
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm13[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    por %xmm5, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm1[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm5
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    pand %xmm7, %xmm6
; SSE-NEXT:    por %xmm6, %xmm5
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm3[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,3]
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm10[0,1,2,3,6,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,0,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm4, %xmm11
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa (%rcx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm14, %xmm5
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    movdqa (%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    movdqa %xmm14, %xmm9
; SSE-NEXT:    por %xmm0, %xmm5
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa (%r9), %xmm15
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm15[2,1,2,3]
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,2,0]
; SSE-NEXT:    movdqa %xmm7, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    movdqa (%r8), %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm1[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    movdqa (%rax), %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm4[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm2, %xmm14
; SSE-NEXT:    pandn %xmm3, %xmm14
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    por %xmm6, %xmm14
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm14, %xmm1
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,0,3]
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa 16(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa 16(%rcx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm9, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    movdqa 16(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa 16(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,2,0]
; SSE-NEXT:    movdqa %xmm7, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    movdqa 16(%r8), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm1[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    movdqa 16(%rax), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm1[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm2, %xmm14
; SSE-NEXT:    pandn %xmm3, %xmm14
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    por %xmm6, %xmm14
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm14, %xmm1
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[3,1,0,3]
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm1[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm11, %xmm3
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa 32(%rcx), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm9, %xmm5
; SSE-NEXT:    movdqa %xmm9, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    movdqa 32(%rdx), %xmm9
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm9[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm12
; SSE-NEXT:    por %xmm0, %xmm12
; SSE-NEXT:    movdqa 32(%r9), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,0]
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa 32(%r8), %xmm11
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm11[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    movdqa 32(%rax), %xmm13
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm13[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pand %xmm10, %xmm12
; SSE-NEXT:    pandn %xmm2, %xmm10
; SSE-NEXT:    por %xmm12, %xmm10
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw $170, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm6[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm5[8],xmm1[9],xmm5[9],xmm1[10],xmm5[10],xmm1[11],xmm5[11],xmm1[12],xmm5[12],xmm1[13],xmm5[13],xmm1[14],xmm5[14],xmm1[15],xmm5[15]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pand %xmm14, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm15 = xmm15[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm15[1,1,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm8[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,3,2]
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm4[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm4, %xmm15
; SSE-NEXT:    pandn %xmm3, %xmm15
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    por %xmm2, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm15, %xmm0
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm0[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    movdqa %xmm12, %xmm8
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pshufhw $170, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,2]
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm14, %xmm12
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    pshufhw $170, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pand %xmm14, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    pshufhw $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,3,2]
; SSE-NEXT:    pand %xmm14, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufhw $164, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,3,3]
; SSE-NEXT:    movdqa %xmm4, %xmm15
; SSE-NEXT:    pandn %xmm3, %xmm15
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    por %xmm2, %xmm15
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm15, %xmm0
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm0[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pshufhw $170, (%rsp), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,2]
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm9[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,2,3]
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm11[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,3,2]
; SSE-NEXT:    pand %xmm14, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm13[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,3,3]
; SSE-NEXT:    movdqa %xmm4, %xmm15
; SSE-NEXT:    pandn %xmm3, %xmm15
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    por %xmm2, %xmm15
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm15, %xmm10
; SSE-NEXT:    por %xmm1, %xmm10
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm5[0,0,2,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm5, %xmm14
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,1,3]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm8
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm6[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm0, %xmm15
; SSE-NEXT:    pandn %xmm2, %xmm15
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm4[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[0,1,1,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm9, %xmm6
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm15, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm5[0,1,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm0, %xmm15
; SSE-NEXT:    pandn %xmm2, %xmm15
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm13[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    por %xmm2, %xmm15
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm11[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa %xmm7, %xmm10
; SSE-NEXT:    pandn %xmm2, %xmm10
; SSE-NEXT:    pand %xmm7, %xmm15
; SSE-NEXT:    por %xmm15, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[0,1,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm3[1,1,2,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm3, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[0,0,2,1]
; SSE-NEXT:    pand %xmm7, %xmm10
; SSE-NEXT:    por %xmm2, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; SSE-NEXT:    movdqa %xmm0, %xmm15
; SSE-NEXT:    movdqa %xmm0, %xmm12
; SSE-NEXT:    pandn %xmm10, %xmm15
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm14[1,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm2[0,1,2,3,7,5,6,4]
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm10, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm8[1,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,0,2,1]
; SSE-NEXT:    pand %xmm0, %xmm10
; SSE-NEXT:    por %xmm10, %xmm2
; SSE-NEXT:    pand %xmm12, %xmm2
; SSE-NEXT:    por %xmm15, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm5[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,1,1,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm0, %xmm15
; SSE-NEXT:    pandn %xmm10, %xmm15
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm13[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,0,0,0]
; SSE-NEXT:    pand %xmm0, %xmm10
; SSE-NEXT:    por %xmm10, %xmm15
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm11[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    pand %xmm13, %xmm15
; SSE-NEXT:    por %xmm15, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm14[2,2,3,3]
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm8[2,1,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm8, %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm4[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm13, %xmm15
; SSE-NEXT:    movdqa %xmm13, %xmm8
; SSE-NEXT:    pandn %xmm0, %xmm8
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm9[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    por %xmm0, %xmm8
; SSE-NEXT:    pand %xmm12, %xmm8
; SSE-NEXT:    por %xmm2, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,0,0,0,0,255,255,255,0,0,0,0,255,255]
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    pandn %xmm8, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm5[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,3,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pandn %xmm2, %xmm5
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[2,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm11[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    pand %xmm1, %xmm5
; SSE-NEXT:    por %xmm5, %xmm8
; SSE-NEXT:    pand %xmm6, %xmm8
; SSE-NEXT:    por %xmm0, %xmm8
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,1,1,3]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm10[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,2]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0]
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm9[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    pandn %xmm0, %xmm8
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm14[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm8, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm13[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    movdqa %xmm15, %xmm5
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm3[0,1,2,3,4,4,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,3]
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    por %xmm0, %xmm5
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm11[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm12, %xmm8
; SSE-NEXT:    pandn %xmm0, %xmm8
; SSE-NEXT:    pand %xmm12, %xmm5
; SSE-NEXT:    por %xmm5, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm8, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm6[0,1,2,3,6,5,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm10[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm14[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm2[2,1,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pandn %xmm6, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm9[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,2,2,2]
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    movdqa %xmm3, %xmm10
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm4[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm13[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,3]
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm11[0,1,2,3,6,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,1,3,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm8
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    por %xmm0, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0]
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pandn %xmm8, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm9 = xmm9[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm9[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm11[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm5[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,1,1,0]
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[0,1,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; SSE-NEXT:    movdqa %xmm12, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm13[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    pand %xmm12, %xmm2
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm14[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    pand %xmm7, %xmm6
; SSE-NEXT:    por %xmm6, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pandn %xmm8, %xmm6
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[0,1,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[1,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[1,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm0[0,1,2,3,7,5,6,4]
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm11[1,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,0,2,1]
; SSE-NEXT:    pand %xmm4, %xmm6
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,1,3]
; SSE-NEXT:    movdqa %xmm10, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm13[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm14[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa %xmm15, %xmm8
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    pand %xmm15, %xmm6
; SSE-NEXT:    movdqa %xmm15, %xmm10
; SSE-NEXT:    por %xmm6, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm8, %xmm2
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[2,2,3,3]
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm11[2,1,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm5[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm15, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    pand %xmm12, %xmm6
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [255,255,255,0,0,0,0,255,255,255,0,0,0,0,255,255]
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm3[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,3,2]
; SSE-NEXT:    movdqa %xmm4, %xmm12
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    movdqa %xmm13, %xmm5
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm13[2,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm14[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm8, %xmm4
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    por %xmm6, %xmm4
; SSE-NEXT:    pand %xmm9, %xmm4
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm15[0,1,1,3]
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm11[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,2]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0]
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    pandn %xmm0, %xmm8
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm9[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm8, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm13[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,0,0,0]
; SSE-NEXT:    movdqa %xmm10, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm8
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm5[0,1,2,3,4,4,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,1,3,3]
; SSE-NEXT:    pand %xmm10, %xmm6
; SSE-NEXT:    por %xmm6, %xmm8
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm14[0,1,2,3,4,5,5,7]
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,2,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm10
; SSE-NEXT:    pandn %xmm6, %xmm10
; SSE-NEXT:    pand %xmm3, %xmm8
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    por %xmm8, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pandn %xmm10, %xmm4
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm15[0,1,2,3,6,5,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm11[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm3, %xmm14
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm8
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm9[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[2,1,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm1[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,2,2,2]
; SSE-NEXT:    pand %xmm4, %xmm6
; SSE-NEXT:    movdqa %xmm4, %xmm11
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm8, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm5[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,2,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm8
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm13[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,2,2,3]
; SSE-NEXT:    pand %xmm7, %xmm6
; SSE-NEXT:    por %xmm8, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm2[0,1,2,3,6,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[2,1,3,2]
; SSE-NEXT:    movdqa %xmm12, %xmm10
; SSE-NEXT:    pandn %xmm8, %xmm10
; SSE-NEXT:    pand %xmm12, %xmm6
; SSE-NEXT:    movdqa %xmm12, %xmm4
; SSE-NEXT:    por %xmm6, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm10, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm9 = xmm9[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm9[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    movdqa %xmm11, %xmm8
; SSE-NEXT:    pandn %xmm0, %xmm8
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm11[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    por %xmm0, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm10
; SSE-NEXT:    pandn %xmm8, %xmm10
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm5[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[0,1,1,0]
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm8, %xmm0
; SSE-NEXT:    movdqa (%rsp), %xmm13 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm13[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,0,2,1]
; SSE-NEXT:    pand %xmm12, %xmm8
; SSE-NEXT:    por %xmm8, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm10, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm3[0,1,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,0,2,1]
; SSE-NEXT:    movdqa %xmm14, %xmm10
; SSE-NEXT:    pandn %xmm8, %xmm10
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm1[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,0,0,0]
; SSE-NEXT:    pand %xmm14, %xmm8
; SSE-NEXT:    por %xmm8, %xmm10
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm6[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,0,0,0]
; SSE-NEXT:    movdqa %xmm7, %xmm15
; SSE-NEXT:    pandn %xmm8, %xmm15
; SSE-NEXT:    pand %xmm7, %xmm10
; SSE-NEXT:    por %xmm10, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; SSE-NEXT:    movdqa %xmm8, %xmm10
; SSE-NEXT:    pandn %xmm15, %xmm10
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    por %xmm0, %xmm10
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[0,1,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    pandn %xmm0, %xmm8
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm13[1,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm8, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; SSE-NEXT:    movdqa %xmm12, %xmm8
; SSE-NEXT:    pandn %xmm0, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[1,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm0[0,1,2,3,7,5,6,4]
; SSE-NEXT:    movdqa %xmm4, %xmm14
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm11[1,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,0,2,1]
; SSE-NEXT:    pand %xmm4, %xmm10
; SSE-NEXT:    por %xmm10, %xmm0
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm12, %xmm4
; SSE-NEXT:    por %xmm8, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm3[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,1,1,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm10
; SSE-NEXT:    pandn %xmm8, %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,0,0,0]
; SSE-NEXT:    pand %xmm2, %xmm8
; SSE-NEXT:    por %xmm8, %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm6[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm15
; SSE-NEXT:    pandn %xmm8, %xmm15
; SSE-NEXT:    pand %xmm2, %xmm10
; SSE-NEXT:    movdqa %xmm2, %xmm12
; SSE-NEXT:    por %xmm10, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm8
; SSE-NEXT:    pandn %xmm15, %xmm8
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm0, %xmm8
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[2,2,3,3]
; SSE-NEXT:    movdqa %xmm7, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm11[2,1,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm4, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm10
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm5[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm12, %xmm15
; SSE-NEXT:    pandn %xmm0, %xmm15
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm13[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm0, %xmm15
; SSE-NEXT:    pand %xmm4, %xmm15
; SSE-NEXT:    por %xmm10, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,0,0,0,0,255,255,255,0,0,0,0,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm10
; SSE-NEXT:    pandn %xmm15, %xmm10
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm3[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,2]
; SSE-NEXT:    movdqa %xmm14, %xmm15
; SSE-NEXT:    pandn %xmm0, %xmm15
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[2,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    movdqa %xmm14, %xmm4
; SSE-NEXT:    por %xmm0, %xmm15
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm6[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm1, %xmm9
; SSE-NEXT:    pandn %xmm0, %xmm9
; SSE-NEXT:    pand %xmm1, %xmm15
; SSE-NEXT:    por %xmm15, %xmm9
; SSE-NEXT:    pand %xmm2, %xmm9
; SSE-NEXT:    por %xmm10, %xmm9
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,1,1,3]
; SSE-NEXT:    movdqa %xmm1, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm10
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm11[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,2]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    por %xmm10, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm13[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[2,2,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm15
; SSE-NEXT:    pandn %xmm10, %xmm15
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm3[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,0,2,1]
; SSE-NEXT:    pand %xmm7, %xmm10
; SSE-NEXT:    por %xmm15, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0]
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm10, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm5[1,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    movdqa %xmm12, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm10
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm8[0,1,2,3,4,4,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,3]
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm0, %xmm10
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm6[0,1,2,3,4,5,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm14, %xmm15
; SSE-NEXT:    pandn %xmm0, %xmm15
; SSE-NEXT:    pand %xmm14, %xmm10
; SSE-NEXT:    por %xmm10, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm15, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm2[0,1,2,3,6,5,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    movdqa %xmm14, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm10
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm11[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    por %xmm0, %xmm10
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm3[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm1, %xmm15
; SSE-NEXT:    pandn %xmm0, %xmm15
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm13[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; SSE-NEXT:    pand %xmm0, %xmm15
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    por %xmm15, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm8[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm10
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm5[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,3]
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm10, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm6[0,1,2,3,6,7,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[2,1,3,2]
; SSE-NEXT:    movdqa %xmm4, %xmm14
; SSE-NEXT:    movdqa %xmm4, %xmm15
; SSE-NEXT:    pandn %xmm10, %xmm15
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm0, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm15, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm12[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; SSE-NEXT:    movdqa %xmm2, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm10
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm11[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    por %xmm0, %xmm10
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm8[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,0]
; SSE-NEXT:    movdqa %xmm4, %xmm15
; SSE-NEXT:    pandn %xmm0, %xmm15
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm13[0,0,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm0, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255]
; SSE-NEXT:    pand %xmm0, %xmm15
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    por %xmm15, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm5[0,1,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,0,2,1]
; SSE-NEXT:    pandn %xmm10, %xmm15
; SSE-NEXT:    por %xmm0, %xmm15
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    movdqa %xmm7, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm10
; SSE-NEXT:    pand %xmm7, %xmm15
; SSE-NEXT:    por %xmm15, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm8[0,1,2,2]
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm13[1,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; SSE-NEXT:    movdqa %xmm4, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm12[1,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,5,6,4]
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm11[1,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    por %xmm10, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    movdqa %xmm6, %xmm4
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm5[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,1,1,3]
; SSE-NEXT:    pandn %xmm10, %xmm4
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm1, %xmm15
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm6, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm10
; SSE-NEXT:    pand %xmm6, %xmm4
; SSE-NEXT:    por %xmm4, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm10, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm12[2,2,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm11[2,1,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,0,2,1]
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    por %xmm3, %xmm7
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm13[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm8[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,2,2,2]
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm7, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[2,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm5[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,3,2]
; SSE-NEXT:    pandn %xmm3, %xmm14
; SSE-NEXT:    por %xmm0, %xmm14
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm3, %xmm14
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm15[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm14, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,0,0,0,0,255,255,255,0,0,0,0,255,255]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm3, 368(%rax)
; SSE-NEXT:    movdqa %xmm1, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movdqa %xmm9, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    addq $648, %rsp # imm = 0x288
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i8_stride7_vf64:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $616, %rsp # imm = 0x268
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovdqa 16(%rax), %xmm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = zero,xmm6[13,u,u,u,u],zero,zero,xmm6[14,u,u,u,u],zero,zero,xmm6[15]
; AVX-NEXT:    vmovdqa 16(%r8), %xmm3
; AVX-NEXT:    vmovdqa 16(%r9), %xmm4
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm4[8],xmm3[8],xmm4[9],xmm3[9],xmm4[10],xmm3[10],xmm4[11],xmm3[11],xmm4[12],xmm3[12],xmm4[13],xmm3[13],xmm4[14],xmm3[14],xmm4[15],xmm3[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[10],zero,xmm1[u,u,u,u,13,12],zero,xmm1[u,u,u,u,15,14],zero
; AVX-NEXT:    vpor %xmm0, %xmm1, %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm6[u],zero,zero,xmm6[11,u,u,u,u],zero,zero,xmm6[12,u,u,u,u],zero
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm3[8],xmm4[8],xmm3[9],xmm4[9],xmm3[10],xmm4[10],xmm3[11],xmm4[11],xmm3[12],xmm4[12],xmm3[13],xmm4[13],xmm3[14],xmm4[14],xmm3[15],xmm4[15]
; AVX-NEXT:    vmovdqa %xmm4, %xmm8
; AVX-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa %xmm3, %xmm10
; AVX-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[u,6,7],zero,xmm0[u,u,u,u,8,9],zero,xmm0[u,u,u,u,10]
; AVX-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX-NEXT:    vmovdqa 16(%rsi), %xmm7
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm11
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm11[8],xmm7[8],xmm11[9],xmm7[9],xmm11[10],xmm7[10],xmm11[11],xmm7[11],xmm11[12],xmm7[12],xmm11[13],xmm7[13],xmm11[14],xmm7[14],xmm11[15],xmm7[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm2[u,u,12,13,u,u,u,u,u,14,15,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,8,9,u,u,u,u,u,10,11,u,u,u]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm3
; AVX-NEXT:    vmovdqa 16(%rcx), %xmm12
; AVX-NEXT:    vmovdqa 16(%rdx), %xmm13
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm12[8],xmm13[8],xmm12[9],xmm13[9],xmm12[10],xmm13[10],xmm12[11],xmm13[11],xmm12[12],xmm13[12],xmm12[13],xmm13[13],xmm12[14],xmm13[14],xmm12[15],xmm13[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[6,u,u,u,u,u,9,8,u,u,u,u,u,11,10,u]
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm13[8],xmm12[8],xmm13[9],xmm12[9],xmm13[10],xmm12[10],xmm13[11],xmm12[11],xmm13[12],xmm12[12],xmm13[13],xmm12[13],xmm13[14],xmm12[14],xmm13[15],xmm12[15]
; AVX-NEXT:    vmovdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[u,u,u,u,12,13,u,u,u,u,u,14,15,u,u,u]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm4
; AVX-NEXT:    vmovaps {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255]
; AVX-NEXT:    vandnps %ymm3, %ymm5, %ymm3
; AVX-NEXT:    vandps %ymm5, %ymm4, %ymm4
; AVX-NEXT:    vorps %ymm3, %ymm4, %ymm3
; AVX-NEXT:    vmovaps {{.*#+}} ymm4 = [255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0]
; AVX-NEXT:    vandnps %ymm1, %ymm4, %ymm1
; AVX-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX-NEXT:    vorps %ymm1, %ymm3, %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,2,3],zero,xmm0[u,u,u,u,4,5],zero,xmm0[u,u,u]
; AVX-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm6[u,u,u],zero,zero,xmm6[9,u,u,u,u],zero,zero,xmm6[10,u,u,u]
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [u,u,u,u,u,128,7,u,u,u,u,u,128,8,u,u]
; AVX-NEXT:    vpshufb %xmm3, %xmm8, %xmm1
; AVX-NEXT:    vmovdqa %xmm3, %xmm8
; AVX-NEXT:    vmovdqa {{.*#+}} xmm4 = [u,u,u,u,u,7,128,u,u,u,u,u,8,128,u,u]
; AVX-NEXT:    vpshufb %xmm4, %xmm10, %xmm3
; AVX-NEXT:    vmovdqa %xmm4, %xmm10
; AVX-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX-NEXT:    vmovdqa {{.*#+}} xmm5 = [128,u,u,u,u,5,6,128,u,u,u,u,12,13,128,u]
; AVX-NEXT:    vpshufb %xmm5, %xmm1, %xmm1
; AVX-NEXT:    vmovdqa {{.*#+}} xmm4 = [6,u,u,u,u,128,128,7,u,u,u,u,128,128,8,u]
; AVX-NEXT:    vpshufb %xmm4, %xmm6, %xmm3
; AVX-NEXT:    vmovdqa %xmm4, %xmm6
; AVX-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [u,u,u,128,7,u,u,u,u,u,128,8,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm3, %xmm12, %xmm1
; AVX-NEXT:    vmovdqa %xmm3, %xmm12
; AVX-NEXT:    vmovdqa {{.*#+}} xmm9 = [u,u,u,7,128,u,u,u,u,u,8,128,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm9, %xmm13, %xmm3
; AVX-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,2,3,u,u,u,u,u,4,5,u,u,u,u,u,6]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vmovdqa {{.*#+}} xmm14 = [u,128,7,u,u,u,u,u,128,8,u,u,u,u,u,128]
; AVX-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm14, %xmm7, %xmm2
; AVX-NEXT:    vmovdqa {{.*#+}} xmm4 = [u,7,128,u,u,u,u,u,8,128,u,u,u,u,u,9]
; AVX-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm4, %xmm11, %xmm3
; AVX-NEXT:    vmovdqa %xmm4, %xmm13
; AVX-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm7[8],xmm11[8],xmm7[9],xmm11[9],xmm7[10],xmm11[10],xmm7[11],xmm11[11],xmm7[12],xmm11[12],xmm7[13],xmm11[13],xmm7[14],xmm11[14],xmm7[15],xmm11[15]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm15 = [2,u,u,u,u,u,5,4,u,u,u,u,u,7,6,u]
; AVX-NEXT:    vpshufb %xmm15, %xmm3, %xmm3
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX-NEXT:    vmovaps {{.*#+}} ymm3 = [255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0]
; AVX-NEXT:    vandnps %ymm1, %ymm3, %ymm1
; AVX-NEXT:    vandps %ymm3, %ymm2, %ymm2
; AVX-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX-NEXT:    vmovaps {{.*#+}} ymm2 = [0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; AVX-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa 32(%r8), %xmm3
; AVX-NEXT:    vmovdqa 32(%r9), %xmm4
; AVX-NEXT:    vpshufb %xmm8, %xmm4, %xmm0
; AVX-NEXT:    vpshufb %xmm10, %xmm3, %xmm1
; AVX-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpshufb %xmm5, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa 32(%rax), %xmm2
; AVX-NEXT:    vpshufb %xmm6, %xmm2, %xmm1
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm2[4,u,u,u,u],zero,zero,xmm2[5,u,u,u,u],zero,zero
; AVX-NEXT:    vmovdqa %xmm2, %xmm8
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3],xmm3[4],xmm4[4],xmm3[5],xmm4[5],xmm3[6],xmm4[6],xmm3[7],xmm4[7]
; AVX-NEXT:    vmovdqa %xmm4, %xmm11
; AVX-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa %xmm3, %xmm10
; AVX-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[8,9],zero,xmm2[u,u,u,u,10,11],zero,xmm2[u,u,u,u,12,13]
; AVX-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm4
; AVX-NEXT:    vmovdqa 32(%rcx), %xmm0
; AVX-NEXT:    vmovdqa 32(%rdx), %xmm2
; AVX-NEXT:    vpshufb %xmm12, %xmm0, %xmm1
; AVX-NEXT:    vpshufb %xmm9, %xmm2, %xmm3
; AVX-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; AVX-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,10,11,u,u,u,u,u,12,13,u,u]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm5
; AVX-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX-NEXT:    vmovdqa 32(%rdi), %xmm3
; AVX-NEXT:    vpshufb %xmm14, %xmm1, %xmm6
; AVX-NEXT:    vpshufb %xmm13, %xmm3, %xmm7
; AVX-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm7 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa {{.*#+}} xmm12 = [u,u,u,10,11,u,u,u,u,u,12,13,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm12, %xmm7, %xmm7
; AVX-NEXT:    vmovdqa %xmm12, %xmm9
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX-NEXT:    vmovaps {{.*#+}} ymm7 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255]
; AVX-NEXT:    vandnps %ymm5, %ymm7, %ymm5
; AVX-NEXT:    vandps %ymm7, %ymm6, %ymm6
; AVX-NEXT:    vorps %ymm5, %ymm6, %ymm5
; AVX-NEXT:    vmovaps {{.*#+}} ymm6 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX-NEXT:    vandnps %ymm4, %ymm6, %ymm4
; AVX-NEXT:    vandps %ymm6, %ymm5, %ymm5
; AVX-NEXT:    vorps %ymm4, %ymm5, %ymm4
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm8[u],zero,zero,xmm8[11,u,u,u,u],zero,zero,xmm8[12,u,u,u,u],zero
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm10[8],xmm11[8],xmm10[9],xmm11[9],xmm10[10],xmm11[10],xmm10[11],xmm11[11],xmm10[12],xmm11[12],xmm10[13],xmm11[13],xmm10[14],xmm11[14],xmm10[15],xmm11[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[u,6,7],zero,xmm5[u,u,u,u,8,9],zero,xmm5[u,u,u,u,10]
; AVX-NEXT:    vpor %xmm4, %xmm6, %xmm4
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,2,3],zero,xmm5[u,u,u,u,4,5],zero,xmm5[u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm8[u,u,u],zero,zero,xmm8[9,u,u,u,u],zero,zero,xmm8[10,u,u,u]
; AVX-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; AVX-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm1[8],xmm3[8],xmm1[9],xmm3[9],xmm1[10],xmm3[10],xmm1[11],xmm3[11],xmm1[12],xmm3[12],xmm1[13],xmm3[13],xmm1[14],xmm3[14],xmm1[15],xmm3[15]
; AVX-NEXT:    vpshufb %xmm15, %xmm1, %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm5[u,u,u,u,8,9,u,u,u,u,u,10,11,u,u,u]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; AVX-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa {{.*#+}} xmm0 = [6,u,u,u,u,u,9,8,u,u,u,u,u,11,10,u]
; AVX-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,2,3,u,u,u,u,u,4,5,u,u,u,u,u,6]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX-NEXT:    vmovaps {{.*#+}} ymm2 = [0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; AVX-NEXT:    vandnps %ymm1, %ymm2, %ymm1
; AVX-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX-NEXT:    vandnps %ymm4, %ymm2, %ymm1
; AVX-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa 48(%rax), %xmm12
; AVX-NEXT:    vmovdqa 48(%r8), %xmm2
; AVX-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa 48(%r9), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa {{.*#+}} xmm5 = [128,128,4,u,u,u,u,128,128,5,u,u,u,u,128,128]
; AVX-NEXT:    vpshufb %xmm5, %xmm12, %xmm0
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa {{.*#+}} xmm14 = [8,9,128,u,u,u,u,10,11,128,u,u,u,u,12,13]
; AVX-NEXT:    vpshufb %xmm14, %xmm2, %xmm1
; AVX-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm12[u,u],zero,zero,xmm12[2,u,u,u,u],zero,zero,xmm12[3,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm2[u,u,4,5],zero,xmm2[u,u,u,u,6,7],zero,xmm2[u,u,u,u]
; AVX-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vmovdqa 48(%rsi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm10
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm10[0],xmm1[0],xmm10[1],xmm1[1],xmm10[2],xmm1[2],xmm10[3],xmm1[3],xmm10[4],xmm1[4],xmm10[5],xmm1[5],xmm10[6],xmm1[6],xmm10[7],xmm1[7]
; AVX-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm9, %xmm2, %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm2[u,u,u,u,u,6,7,u,u,u,u,u,8,9,u,u]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX-NEXT:    vmovdqa 48(%rcx), %xmm2
; AVX-NEXT:    vmovdqa %xmm2, (%rsp) # 16-byte Spill
; AVX-NEXT:    vmovdqa 48(%rdx), %xmm13
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm13[0],xmm2[0],xmm13[1],xmm2[1],xmm13[2],xmm2[2],xmm13[3],xmm2[3],xmm13[4],xmm2[4],xmm13[5],xmm2[5],xmm13[6],xmm2[6],xmm13[7],xmm2[7]
; AVX-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa {{.*#+}} xmm9 = [u,u,u,u,u,10,11,u,u,u,u,u,12,13,u,u]
; AVX-NEXT:    vpshufb %xmm9, %xmm4, %xmm3
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm4[4,5,u,u,u,u,u,6,7,u,u,u,u,u,8,9]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm11, %ymm3
; AVX-NEXT:    vandnps %ymm1, %ymm7, %ymm1
; AVX-NEXT:    vandps %ymm7, %ymm3, %ymm3
; AVX-NEXT:    vorps %ymm1, %ymm3, %ymm1
; AVX-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0]
; AVX-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa (%r9), %xmm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm6[u,u,u,u,u],zero,xmm6[7,u,u,u,u,u],zero,xmm6[8,u,u]
; AVX-NEXT:    vmovdqa (%r8), %xmm8
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm8[u,u,u,u,u,7],zero,xmm8[u,u,u,u,u,8],zero,xmm8[u,u]
; AVX-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = zero,xmm0[u,u,u,u,5,6],zero,xmm0[u,u,u,u,12,13],zero,xmm0[u]
; AVX-NEXT:    vmovdqa (%rax), %xmm7
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm7[6,u,u,u,u],zero,zero,xmm7[7,u,u,u,u],zero,zero,xmm7[8,u]
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpshufb %xmm5, %xmm7, %xmm1
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3],xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm14, %xmm4, %xmm15
; AVX-NEXT:    vpor %xmm1, %xmm15, %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm15
; AVX-NEXT:    vmovdqa (%rcx), %xmm5
; AVX-NEXT:    vmovdqa (%rdx), %xmm3
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm5[u,u,u],zero,xmm5[7,u,u,u,u,u],zero,xmm5[8,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm3[u,u,u,7],zero,xmm3[u,u,u,u,u,8],zero,xmm3[u,u,u,u]
; AVX-NEXT:    vpor %xmm0, %xmm14, %xmm0
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm3[0],xmm5[0],xmm3[1],xmm5[1],xmm3[2],xmm5[2],xmm3[3],xmm5[3],xmm3[4],xmm5[4],xmm3[5],xmm5[5],xmm3[6],xmm5[6],xmm3[7],xmm5[7]
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm9, %xmm1, %xmm14
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm14, %ymm4
; AVX-NEXT:    vmovdqa (%rsi), %xmm14
; AVX-NEXT:    vmovdqa (%rdi), %xmm2
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm14[u],zero,xmm14[7,u,u,u,u,u],zero,xmm14[8,u,u,u,u,u],zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm2[u,7],zero,xmm2[u,u,u,u,u,8],zero,xmm2[u,u,u,u,u,9]
; AVX-NEXT:    vpor %xmm1, %xmm11, %xmm1
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm2[0],xmm14[0],xmm2[1],xmm14[1],xmm2[2],xmm14[2],xmm2[3],xmm14[3],xmm2[4],xmm14[4],xmm2[5],xmm14[5],xmm2[6],xmm14[6],xmm2[7],xmm14[7]
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm0[u,u,u,10,11,u,u,u,u,u,12,13,u,u,u,u]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm11, %ymm1
; AVX-NEXT:    vmovaps {{.*#+}} ymm9 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255]
; AVX-NEXT:    vandnps %ymm4, %ymm9, %ymm4
; AVX-NEXT:    vandps %ymm1, %ymm9, %ymm1
; AVX-NEXT:    vorps %ymm4, %ymm1, %ymm1
; AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX-NEXT:    vandnps %ymm15, %ymm0, %ymm4
; AVX-NEXT:    vandps %ymm0, %ymm1, %ymm1
; AVX-NEXT:    vorps %ymm4, %ymm1, %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm7[u],zero,zero,xmm7[11,u,u,u,u],zero,zero,xmm7[12,u,u,u,u],zero
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm8[8],xmm6[8],xmm8[9],xmm6[9],xmm8[10],xmm6[10],xmm8[11],xmm6[11],xmm8[12],xmm6[12],xmm8[13],xmm6[13],xmm8[14],xmm6[14],xmm8[15],xmm6[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm4[u,6,7],zero,xmm4[u,u,u,u,8,9],zero,xmm4[u,u,u,u,10]
; AVX-NEXT:    vpor %xmm1, %xmm11, %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,2,3],zero,xmm4[u,u,u,u,4,5],zero,xmm4[u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm7[u,u,u],zero,zero,xmm7[9,u,u,u,u],zero,zero,xmm7[10,u,u,u]
; AVX-NEXT:    vpor %xmm4, %xmm11, %xmm4
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm4, %ymm1
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm14[8],xmm2[9],xmm14[9],xmm2[10],xmm14[10],xmm2[11],xmm14[11],xmm2[12],xmm14[12],xmm2[13],xmm14[13],xmm2[14],xmm14[14],xmm2[15],xmm14[15]
; AVX-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm14[8],xmm2[8],xmm14[9],xmm2[9],xmm14[10],xmm2[10],xmm14[11],xmm2[11],xmm14[12],xmm2[12],xmm14[13],xmm2[13],xmm14[14],xmm2[14],xmm14[15],xmm2[15]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm6 = [2,u,u,u,u,u,5,4,u,u,u,u,u,7,6,u]
; AVX-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa {{.*#+}} xmm14 = [u,u,u,u,8,9,u,u,u,u,u,10,11,u,u,u]
; AVX-NEXT:    vpshufb %xmm14, %xmm4, %xmm4
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm3[8],xmm5[9],xmm3[9],xmm5[10],xmm3[10],xmm5[11],xmm3[11],xmm5[12],xmm3[12],xmm5[13],xmm3[13],xmm5[14],xmm3[14],xmm5[15],xmm3[15]
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm3[8],xmm5[8],xmm3[9],xmm5[9],xmm3[10],xmm5[10],xmm3[11],xmm5[11],xmm3[12],xmm5[12],xmm3[13],xmm5[13],xmm3[14],xmm5[14],xmm3[15],xmm5[15]
; AVX-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa {{.*#+}} xmm7 = [6,u,u,u,u,u,9,8,u,u,u,u,u,11,10,u]
; AVX-NEXT:    vpshufb %xmm7, %xmm4, %xmm2
; AVX-NEXT:    vmovdqa {{.*#+}} xmm5 = [u,2,3,u,u,u,u,u,4,5,u,u,u,u,u,6]
; AVX-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX-NEXT:    vmovaps {{.*#+}} ymm3 = [0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255]
; AVX-NEXT:    vandnps %ymm0, %ymm3, %ymm0
; AVX-NEXT:    vandps %ymm3, %ymm2, %ymm2
; AVX-NEXT:    vorps %ymm0, %ymm2, %ymm0
; AVX-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX-NEXT:    vandnps %ymm1, %ymm2, %ymm1
; AVX-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpunpcklbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3],xmm0[4],mem[4],xmm0[5],mem[5],xmm0[6],mem[6],xmm0[7],mem[7]
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm3[4,u,u,u,u],zero,zero,xmm3[5,u,u,u,u],zero,zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm1[8,9],zero,xmm1[u,u,u,u,10,11],zero,xmm1[u,u,u,u,12,13]
; AVX-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm3[u,u],zero,zero,xmm3[2,u,u,u,u],zero,zero,xmm3[3,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[u,u,4,5],zero,xmm1[u,u,u,u,6,7],zero,xmm1[u,u,u,u]
; AVX-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpunpcklbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3],xmm1[4],mem[4],xmm1[5],mem[5],xmm1[6],mem[6],xmm1[7],mem[7]
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[u,u,u,10,11,u,u,u,u,u,12,13,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm1[u,u,u,u,u,6,7,u,u,u,u,u,8,9,u,u]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpunpcklbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3],xmm1[4],mem[4],xmm1[5],mem[5],xmm1[6],mem[6],xmm1[7],mem[7]
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm1[u,u,u,u,u,10,11,u,u,u,u,u,12,13,u,u]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm2 = [4,5,u,u,u,u,u,6,7,u,u,u,u,u,8,9]
; AVX-NEXT:    vpshufb %xmm2, %xmm1, %xmm11
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm11, %ymm4
; AVX-NEXT:    vandnps %ymm3, %ymm9, %ymm3
; AVX-NEXT:    vandps %ymm4, %ymm9, %ymm4
; AVX-NEXT:    vorps %ymm3, %ymm4, %ymm3
; AVX-NEXT:    vmovaps {{.*#+}} ymm1 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0]
; AVX-NEXT:    vandnps %ymm0, %ymm1, %ymm0
; AVX-NEXT:    vandps %ymm1, %ymm3, %ymm3
; AVX-NEXT:    vorps %ymm0, %ymm3, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa (%rsp), %xmm9 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm9[u,u,u],zero,xmm9[7,u,u,u,u,u],zero,xmm9[8,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm13[u,u,u,7],zero,xmm13[u,u,u,u,u,8],zero,xmm13[u,u,u,u]
; AVX-NEXT:    vpor %xmm0, %xmm3, %xmm3
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm13[8],xmm9[8],xmm13[9],xmm9[9],xmm13[10],xmm9[10],xmm13[11],xmm9[11],xmm13[12],xmm9[12],xmm13[13],xmm9[13],xmm13[14],xmm9[14],xmm13[15],xmm9[15]
; AVX-NEXT:    vpshufb %xmm5, %xmm0, %xmm4
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm1[u],zero,xmm1[7,u,u,u,u,u],zero,xmm1[8,u,u,u,u,u],zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm10[u,7],zero,xmm10[u,u,u,u,u,8],zero,xmm10[u,u,u,u,u,9]
; AVX-NEXT:    vpor %xmm4, %xmm11, %xmm4
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm11 = xmm1[8],xmm10[8],xmm1[9],xmm10[9],xmm1[10],xmm10[10],xmm1[11],xmm10[11],xmm1[12],xmm10[12],xmm1[13],xmm10[13],xmm1[14],xmm10[14],xmm1[15],xmm10[15]
; AVX-NEXT:    vmovdqa %xmm1, %xmm8
; AVX-NEXT:    vpshufb %xmm6, %xmm11, %xmm11
; AVX-NEXT:    vinsertf128 $1, %xmm11, %ymm4, %ymm4
; AVX-NEXT:    vmovaps {{.*#+}} ymm1 = [255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0]
; AVX-NEXT:    vandnps %ymm3, %ymm1, %ymm3
; AVX-NEXT:    vandps %ymm1, %ymm4, %ymm4
; AVX-NEXT:    vorps %ymm3, %ymm4, %ymm3
; AVX-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,1,2],zero,xmm4[u,u,6,7,8,9],zero,xmm4[u,u,13,14,15]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,zero,xmm6[9,u,u],zero,zero,zero,zero,xmm6[10,u,u],zero,zero,zero
; AVX-NEXT:    vpor %xmm4, %xmm11, %xmm4
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,1,2,3],zero,xmm4[u,6,7,8,9,10],zero,xmm4[u,13,14,15]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,zero,zero,xmm5[9,u],zero,zero,zero,zero,zero,xmm5[10,u],zero,zero,zero
; AVX-NEXT:    vpor %xmm4, %xmm11, %xmm4
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,1,2,3,4],zero,xmm4[6,7,8,9,10,11],zero,xmm4[13,14,15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,zero,zero,zero,xmm12[9],zero,zero,zero,zero,zero,zero,xmm12[10],zero,zero,zero
; AVX-NEXT:    vpor %xmm4, %xmm11, %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,1,2,3,4],zero,xmm3[u,u,8,9,10,11],zero,xmm3[u,u,15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm6[u],zero,zero,zero,zero,xmm6[7,u,u],zero,zero,zero,zero,xmm6[8,u,u],zero
; AVX-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,1,2,3,4,5],zero,xmm3[u,8,9,10,11,12],zero,xmm3[u,15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm5[u],zero,zero,zero,zero,zero,xmm5[7,u],zero,zero,zero,zero,zero,xmm5[8,u],zero
; AVX-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = zero,xmm3[1,2,3,4,5,6],zero,xmm3[8,9,10,11,12,13],zero,xmm3[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm12[6],zero,zero,zero,zero,zero,zero,xmm12[7],zero,zero,zero,zero,zero,zero,xmm12[8],zero
; AVX-NEXT:    vpor %xmm4, %xmm3, %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm10[8],xmm8[8],xmm10[9],xmm8[9],xmm10[10],xmm8[10],xmm10[11],xmm8[11],xmm10[12],xmm8[12],xmm10[13],xmm8[13],xmm10[14],xmm8[14],xmm10[15],xmm8[15]
; AVX-NEXT:    vpshufb %xmm14, %xmm3, %xmm4
; AVX-NEXT:    vpmovsxdq {{.*#+}} xmm10 = [218890240,986624]
; AVX-NEXT:    vpshufb %xmm10, %xmm3, %xmm3
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm9[8],xmm13[8],xmm9[9],xmm13[9],xmm9[10],xmm13[10],xmm9[11],xmm13[11],xmm9[12],xmm13[12],xmm9[13],xmm13[13],xmm9[14],xmm13[14],xmm9[15],xmm13[15]
; AVX-NEXT:    vpshufb %xmm7, %xmm4, %xmm4
; AVX-NEXT:    vmovdqa {{.*#+}} xmm7 = [u,u,u,u,12,13,u,u,u,u,u,14,15,u,u,u]
; AVX-NEXT:    vpshufb %xmm7, %xmm0, %xmm0
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm4, %ymm0
; AVX-NEXT:    vmovaps {{.*#+}} ymm1 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255]
; AVX-NEXT:    vandnps %ymm3, %ymm1, %ymm3
; AVX-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vmovaps %ymm1, %ymm8
; AVX-NEXT:    vorps %ymm3, %ymm0, %ymm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[0],zero,xmm0[u,u,4,5,6,7],zero,xmm0[u,u,11,12,13,14],zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = zero,xmm6[11,u,u],zero,zero,zero,zero,xmm6[12,u,u],zero,zero,zero,zero,xmm6[13]
; AVX-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[0,1],zero,xmm3[u,4,5,6,7,8],zero,xmm3[u,11,12,13,14,15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,xmm5[11,u],zero,zero,zero,zero,zero,xmm5[12,u],zero,zero,zero,zero,zero
; AVX-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[0,1,2],zero,xmm3[4,5,6,7,8,9],zero,xmm3[11,12,13,14,15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm12[11],zero,zero,zero,zero,zero,zero,xmm12[12],zero,zero,zero,zero,zero
; AVX-NEXT:    vpor %xmm4, %xmm3, %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX-NEXT:    vpalignr {{.*#+}} xmm0 = xmm6[14,15],xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = zero,xmm0[u,4,5,6,7,0],zero,xmm0[u,11,12,13,14,1],zero,xmm0[u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm5[13,u],zero,zero,zero,zero,zero,xmm5[14,u],zero,zero,zero,zero,zero,xmm5[15,u]
; AVX-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0],zero,xmm0[2,3,4,5,6,7],zero,xmm0[9,10,11,12,13,14],zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = zero,xmm12[13],zero,zero,zero,zero,zero,zero,xmm12[14],zero,zero,zero,zero,zero,zero,xmm12[15]
; AVX-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpmovsxdq {{.*#+}} xmm15 = [16777216,197120]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm15, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm7, %xmm1, %xmm3
; AVX-NEXT:    vmovdqa %xmm7, %xmm9
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,u,u,u,u,u,2,3,u,u,u,u,u,4,5]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm3, %xmm1, %xmm4
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm10, %xmm1, %xmm7
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm7, %ymm4
; AVX-NEXT:    vandnps %ymm0, %ymm8, %ymm0
; AVX-NEXT:    vandps %ymm4, %ymm8, %ymm4
; AVX-NEXT:    vorps %ymm0, %ymm4, %ymm0
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpunpckhbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm4 # 16-byte Folded Reload
; AVX-NEXT:    # xmm4 = xmm1[8],mem[8],xmm1[9],mem[9],xmm1[10],mem[10],xmm1[11],mem[11],xmm1[12],mem[12],xmm1[13],mem[13],xmm1[14],mem[14],xmm1[15],mem[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[10],zero,xmm4[u,u,u,u,13,12],zero,xmm4[u,u,u,u,15,14],zero
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = zero,xmm14[13,u,u,u,u],zero,zero,xmm14[14,u,u,u,u],zero,zero,xmm14[15]
; AVX-NEXT:    vpor %xmm7, %xmm4, %xmm7
; AVX-NEXT:    vmovdqa {{.*#+}} xmm4 = [u,u,u,u,0,1,u,u,u,u,u,2,3,u,u,u]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm4, %xmm1, %xmm10
; AVX-NEXT:    vpalignr {{.*#+}} xmm5 = xmm10[4,5,6,7,8,9,10,11,12,13,14,15],xmm12[0,1,2,3]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm11 = [u,u,u,u,0,1,12,u,u,u,u,7,8,13,u,u]
; AVX-NEXT:    vpshufb %xmm11, %xmm5, %xmm5
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm7, %ymm5
; AVX-NEXT:    vmovaps {{.*#+}} ymm7 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; AVX-NEXT:    vandps %ymm7, %ymm0, %ymm0
; AVX-NEXT:    vandnps %ymm5, %ymm7, %ymm5
; AVX-NEXT:    vorps %ymm5, %ymm0, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm2, %xmm8, %xmm5
; AVX-NEXT:    vpshufb %xmm15, %xmm8, %xmm10
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm10, %ymm5
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX-NEXT:    vmovdqa {{.*#+}} xmm6 = [u,u,u,u,u,6,7,u,u,u,u,u,8,9,u,u]
; AVX-NEXT:    vpshufb %xmm6, %xmm8, %xmm10
; AVX-NEXT:    vpshufb %xmm3, %xmm8, %xmm12
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm12, %ymm10
; AVX-NEXT:    vmovaps {{.*#+}} ymm12 = [255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0]
; AVX-NEXT:    vandnps %ymm5, %ymm12, %ymm5
; AVX-NEXT:    vandps %ymm12, %ymm10, %ymm10
; AVX-NEXT:    vorps %ymm5, %ymm10, %ymm5
; AVX-NEXT:    vmovdqa {{.*#+}} xmm0 = [u,u,128,128,2,u,u,u,u,128,128,3,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm0, %xmm14, %xmm10
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [u,u,4,5,128,u,u,u,u,6,7,128,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm1, %xmm8, %xmm13
; AVX-NEXT:    vpor %xmm10, %xmm13, %xmm10
; AVX-NEXT:    vpshufb %xmm4, %xmm8, %xmm13
; AVX-NEXT:    vpalignr {{.*#+}} xmm13 = xmm13[4,5,6,7,8,9,10,11,12,13,14,15],xmm14[0,1,2,3]
; AVX-NEXT:    vpshufb %xmm11, %xmm13, %xmm13
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm13, %ymm10
; AVX-NEXT:    vmovaps {{.*#+}} ymm13 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX-NEXT:    vandps %ymm5, %ymm13, %ymm5
; AVX-NEXT:    vandnps %ymm10, %ymm13, %ymm10
; AVX-NEXT:    vorps %ymm5, %ymm10, %ymm10
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm2, %xmm8, %xmm5
; AVX-NEXT:    vpshufb %xmm15, %xmm8, %xmm14
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm14, %ymm5
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm6, %xmm2, %xmm14
; AVX-NEXT:    vpshufb %xmm3, %xmm2, %xmm8
; AVX-NEXT:    vinsertf128 $1, %xmm14, %ymm8, %ymm8
; AVX-NEXT:    vandnps %ymm5, %ymm12, %ymm5
; AVX-NEXT:    vandps %ymm12, %ymm8, %ymm8
; AVX-NEXT:    vorps %ymm5, %ymm8, %ymm5
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm0, %xmm6, %xmm8
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm1, %xmm0, %xmm12
; AVX-NEXT:    vpor %xmm8, %xmm12, %xmm8
; AVX-NEXT:    vpshufb %xmm4, %xmm0, %xmm12
; AVX-NEXT:    vpalignr {{.*#+}} xmm12 = xmm12[4,5,6,7,8,9,10,11,12,13,14,15],xmm6[0,1,2,3]
; AVX-NEXT:    vpshufb %xmm11, %xmm12, %xmm12
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm12, %ymm8
; AVX-NEXT:    vandps %ymm5, %ymm13, %ymm5
; AVX-NEXT:    vandnps %ymm8, %ymm13, %ymm8
; AVX-NEXT:    vorps %ymm5, %ymm8, %ymm5
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm15, %xmm0, %xmm8
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm9, %xmm0, %xmm9
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm9, %ymm8
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm3, %xmm0, %xmm2
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[u,u,12,13,u,u,u,u,u,14,15,u,u,u,u,u]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255]
; AVX-NEXT:    vandnps %ymm8, %ymm0, %ymm3
; AVX-NEXT:    vandps %ymm0, %ymm2, %ymm2
; AVX-NEXT:    vorps %ymm3, %ymm2, %ymm2
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = zero,xmm6[13,u,u,u,u],zero,zero,xmm6[14,u,u,u,u],zero,zero,xmm6[15]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpunpckhbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm6 # 16-byte Folded Reload
; AVX-NEXT:    # xmm6 = xmm0[8],mem[8],xmm0[9],mem[9],xmm0[10],mem[10],xmm0[11],mem[11],xmm0[12],mem[12],xmm0[13],mem[13],xmm0[14],mem[14],xmm0[15],mem[15]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[10],zero,xmm6[u,u,u,u,13,12],zero,xmm6[u,u,u,u,15,14],zero
; AVX-NEXT:    vpor %xmm3, %xmm6, %xmm3
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm4, %xmm0, %xmm1
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm0[0,1,2,3]
; AVX-NEXT:    vpshufb %xmm11, %xmm1, %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX-NEXT:    vandps %ymm7, %ymm2, %ymm2
; AVX-NEXT:    vandnps %ymm1, %ymm7, %ymm1
; AVX-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX-NEXT:    vmovaps %ymm1, 96(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX-NEXT:    vmovaps %ymm5, (%rax)
; AVX-NEXT:    vmovaps %ymm10, 224(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 352(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 432(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 416(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 384(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 400(%rax)
; AVX-NEXT:    addq $616, %rsp # imm = 0x268
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i8_stride7_vf64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $824, %rsp # imm = 0x338
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 32(%rsi), %ymm2
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 32(%rdx), %ymm6
; AVX2-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 32(%rcx), %ymm7
; AVX2-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 32(%r8), %ymm5
; AVX2-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 32(%r9), %ymm4
; AVX2-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 32(%rax), %ymm3
; AVX2-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm0[23],zero,ymm0[27,20,21,26],zero,ymm0[24],zero,ymm0[26,27,26,27],zero,ymm0[25]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero,zero,zero,ymm2[27],zero
; AVX2-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm7[25],zero,ymm7[23],zero,zero,zero,zero,ymm7[26],zero,ymm7[24],zero,zero,zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[25],zero,ymm6[23],zero,zero,zero,zero,ymm6[26],zero,ymm6[24],zero,zero,zero,zero,ymm6[27]
; AVX2-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25,22,23,22,23,24,25,26,27,24,25,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,25,24,23,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa (%r8), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa (%r9), %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm0[27],zero,ymm0[27,28,29,30],zero,ymm0[28],zero,ymm0[26,27,30,31],zero,ymm0[29]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm1[27],zero,zero,zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero
; AVX2-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqa (%rax), %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqa (%rdx), %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm1[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vmovdqa (%rcx), %ymm2
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[11,u,u,u,u,14,u,12,u,u,u,u,15,u,13,u,27,u,u,u,u,30,u,28,u,u,u,u,31,u,29,u]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [255,0,0,0,0,255,0,255,0,0,0,0,255,0,255,0,255,0,0,0,0,255,0,255,0,0,0,0,255,0,255,0]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vmovdqa (%rdi), %ymm2
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm2[0,1,2,3,6,7,7,6,8,9,10,11,14,15,15,14]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[2,2,3,3,6,6,7,7]
; AVX2-NEXT:    vmovdqa (%rsi), %ymm3
; AVX2-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,14,u,12,u,u,u,u,15,u,13,u,u,u,u,u,u,30,u,28,u,u,u,u,31,u,29,u,u,u]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [0,0,255,0,255,0,0,0,0,255,0,255,0,0,0,0,0,0,255,0,255,0,0,0,0,255,0,255,0,0,0,0]
; AVX2-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX2-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u]
; AVX2-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 32(%rsi), %xmm13
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm2[0],xmm13[0],xmm2[1],xmm13[1],xmm2[2],xmm13[2],xmm2[3],xmm13[3],xmm2[4],xmm13[4],xmm2[5],xmm13[5],xmm2[6],xmm13[6],xmm2[7],xmm13[7]
; AVX2-NEXT:    vmovdqa %xmm2, %xmm14
; AVX2-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX2-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vmovdqa 32(%rcx), %xmm11
; AVX2-NEXT:    vmovdqa 32(%rdx), %xmm9
; AVX2-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm9[0],xmm11[0],xmm9[1],xmm11[1],xmm9[2],xmm11[2],xmm9[3],xmm11[3],xmm9[4],xmm11[4],xmm9[5],xmm11[5],xmm9[6],xmm11[6],xmm9[7],xmm11[7]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX2-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0]
; AVX2-NEXT:    vpblendvb %ymm5, %ymm0, %ymm2, %ymm10
; AVX2-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa (%rdi), %xmm6
; AVX2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3],xmm6[4],xmm0[4],xmm6[5],xmm0[5],xmm6[6],xmm0[6],xmm6[7],xmm0[7]
; AVX2-NEXT:    vmovdqa %xmm6, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovdqa (%rcx), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa (%rdx), %xmm7
; AVX2-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm7[0],xmm1[0],xmm7[1],xmm1[1],xmm7[2],xmm1[2],xmm7[3],xmm1[3],xmm7[4],xmm1[4],xmm7[5],xmm1[5],xmm7[6],xmm1[6],xmm7[7],xmm1[7]
; AVX2-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm5, %ymm0, %ymm1, %ymm4
; AVX2-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 32(%r8), %xmm2
; AVX2-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; AVX2-NEXT:    vmovdqa %xmm2, %xmm8
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm0 = [u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX2-NEXT:    vpshufb %xmm0, %xmm1, %xmm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-NEXT:    vmovdqa 32(%rax), %xmm2
; AVX2-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm2[1,1,0,0,4,5,6,7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,1,0]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vmovdqa (%r9), %xmm3
; AVX2-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa (%r8), %xmm5
; AVX2-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vpunpcklbw {{.*#+}} xmm12 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3],xmm5[4],xmm3[4],xmm5[5],xmm3[5],xmm5[6],xmm3[6],xmm5[7],xmm3[7]
; AVX2-NEXT:    vpshufb %xmm0, %xmm12, %xmm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm12 = ymm0[0,1,0,1]
; AVX2-NEXT:    vmovdqa (%rax), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vpshuflw {{.*#+}} xmm15 = xmm0[1,1,0,0,4,5,6,7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[0,1,2,0]
; AVX2-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,0,1,0]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm12, %ymm15, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX2-NEXT:    vpblendvb %ymm12, %ymm10, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendvb %ymm12, %ymm4, %ymm2, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm1 = [u,128,7,128,5,u,u,u,128,8,128,6,u,u,u,128]
; AVX2-NEXT:    vpshufb %xmm1, %xmm13, %xmm2
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [u,7,128,5,128,u,u,u,8,128,6,128,u,u,u,9]
; AVX2-NEXT:    vpshufb %xmm4, %xmm14, %xmm12
; AVX2-NEXT:    vpor %xmm2, %xmm12, %xmm2
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm15 = [u,u,u,128,7,128,5,u,u,u,128,8,128,6,u,u]
; AVX2-NEXT:    vpshufb %xmm15, %xmm11, %xmm12
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm0 = [u,u,u,7,128,5,128,u,u,u,8,128,6,128,u,u]
; AVX2-NEXT:    vpshufb %xmm0, %xmm9, %xmm14
; AVX2-NEXT:    vpor %xmm12, %xmm14, %xmm12
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm14 = [u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255]
; AVX2-NEXT:    vpblendvb %ymm14, %ymm2, %ymm12, %ymm2
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vpshufb %xmm4, %xmm6, %xmm2
; AVX2-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-NEXT:    vpshufb %xmm15, %xmm6, %xmm2
; AVX2-NEXT:    vpshufb %xmm0, %xmm7, %xmm0
; AVX2-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm14, %ymm1, %ymm0, %ymm12
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm1 = [128,4,u,u,u,128,7,128,5,u,u,u,128,8,128,6]
; AVX2-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-NEXT:    vpshufb %xmm1, %xmm10, %xmm2
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [4,128,u,u,u,7,128,5,128,u,u,u,8,128,6,128]
; AVX2-NEXT:    vmovdqa %xmm8, %xmm3
; AVX2-NEXT:    vpshufb %xmm4, %xmm8, %xmm14
; AVX2-NEXT:    vpor %xmm2, %xmm14, %xmm2
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm14 = [4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX2-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-NEXT:    vpshufb %xmm14, %xmm5, %xmm15
; AVX2-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,0,1,0]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u]
; AVX2-NEXT:    vpblendvb %ymm0, %ymm2, %ymm15, %ymm2
; AVX2-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-NEXT:    vpshufb %xmm1, %xmm8, %xmm1
; AVX2-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-NEXT:    vpshufb %xmm4, %xmm15, %xmm4
; AVX2-NEXT:    vpor %xmm1, %xmm4, %xmm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-NEXT:    vpshufb %xmm14, %xmm7, %xmm4
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,1,0]
; AVX2-NEXT:    vpblendvb %ymm0, %ymm1, %ymm4, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX2-NEXT:    vpblendvb %ymm1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendvb %ymm1, %ymm12, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm11[8],xmm9[8],xmm11[9],xmm9[9],xmm11[10],xmm9[10],xmm11[11],xmm9[11],xmm11[12],xmm9[12],xmm11[13],xmm9[13],xmm11[14],xmm9[14],xmm11[15],xmm9[15]
; AVX2-NEXT:    vpunpckhbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = xmm13[8],mem[8],xmm13[9],mem[9],xmm13[10],mem[10],xmm13[11],mem[11],xmm13[12],mem[12],xmm13[13],mem[13],xmm13[14],mem[14],xmm13[15],mem[15]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm2 = [6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX2-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm9 = [2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX2-NEXT:    vpshufb %xmm9, %xmm1, %xmm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u]
; AVX2-NEXT:    vpblendvb %ymm4, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpunpckhbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = xmm6[8],mem[8],xmm6[9],mem[9],xmm6[10],mem[10],xmm6[11],mem[11],xmm6[12],mem[12],xmm6[13],mem[13],xmm6[14],mem[14],xmm6[15],mem[15]
; AVX2-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-NEXT:    vpunpckhbw (%rsp), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm2 = xmm2[8],mem[8],xmm2[9],mem[9],xmm2[10],mem[10],xmm2[11],mem[11],xmm2[12],mem[12],xmm2[13],mem[13],xmm2[14],mem[14],xmm2[15],mem[15]
; AVX2-NEXT:    vpshufb %xmm9, %xmm2, %xmm2
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm4, %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm3[8],xmm10[8],xmm3[9],xmm10[9],xmm3[10],xmm10[10],xmm3[11],xmm10[11],xmm3[12],xmm10[12],xmm3[13],xmm10[13],xmm3[14],xmm10[14],xmm3[15],xmm10[15]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX2-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm5[0,1,2,3,4,5,5,6]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255]
; AVX2-NEXT:    vpblendvb %ymm5, %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm15[8],xmm8[8],xmm15[9],xmm8[9],xmm15[10],xmm8[10],xmm15[11],xmm8[11],xmm15[12],xmm8[12],xmm15[13],xmm8[13],xmm15[14],xmm8[14],xmm15[15],xmm8[15]
; AVX2-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX2-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm7[0,1,2,3,4,5,5,6]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX2-NEXT:    vpblendvb %ymm4, %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm3, %ymm0, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm4, %ymm0, %ymm5
; AVX2-NEXT:    vpor %ymm2, %ymm5, %ymm2
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-NEXT:    vpshuflw $150, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm5 = mem[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[0,1,1,3,4,5,5,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,3,2]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm6 = [u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255]
; AVX2-NEXT:    vpblendvb %ymm6, %ymm2, %ymm5, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm3, %ymm8, %ymm3
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm4, %ymm13, %ymm4
; AVX2-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm14[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[0,1,1,3,4,5,5,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,2,3,2]
; AVX2-NEXT:    vpblendvb %ymm6, %ymm3, %ymm4, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshuflw $233, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm4 = mem[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[0,0,1,1,4,4,5,5]
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm5 = [5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm5, %ymm11, %ymm6
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [0,0,0,255,0,255,0,0,0,0,255,0,255,0,0,0,0,0,0,255,0,255,0,0,0,0,255,0,255,0,0,0]
; AVX2-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm4, %ymm6, %ymm4
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm5, %ymm1, %ymm5
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm6 = ymm0[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[0,0,1,1,4,4,5,5]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm6, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20]
; AVX2-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm6, %ymm2, %ymm7
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm3, %ymm10, %ymm9
; AVX2-NEXT:    vpor %ymm7, %ymm9, %ymm7
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm7, %ymm4, %ymm4
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm6, %ymm15, %ymm6
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm3, %ymm12, %ymm7
; AVX2-NEXT:    vpor %ymm6, %ymm7, %ymm6
; AVX2-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,3,2,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm6, %ymm5, %ymm5
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vpblendvb %ymm6, %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vpblendvb %ymm6, %ymm5, %ymm3, %ymm3
; AVX2-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm0[23],zero,ymm0[27,20,21,26],zero,ymm0[24],zero,ymm0[26,27,26,27],zero,ymm0[25]
; AVX2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm5 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm1[23],zero,zero,zero,zero,ymm1[26],zero,ymm1[24],zero,zero,zero,zero,ymm1[27],zero
; AVX2-NEXT:    vpor %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpshufb {{.*#+}} ymm5 = ymm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm15[25],zero,ymm15[23],zero,zero,zero,zero,ymm15[26],zero,ymm15[24],zero,zero,zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm12[25],zero,ymm12[23],zero,zero,zero,zero,ymm12[26],zero,ymm12[24],zero,zero,zero,zero,ymm12[27]
; AVX2-NEXT:    vpor %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0]
; AVX2-NEXT:    vpblendvb %ymm3, %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpshufb {{.*#+}} ymm5 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm8[25],zero,ymm8[23],zero,zero,zero,zero,ymm8[26],zero,ymm8[24],zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} ymm6 = ymm13[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm13[25],zero,ymm13[23],zero,zero,zero,zero,ymm13[26],zero,ymm13[24],zero,zero,zero
; AVX2-NEXT:    vpor %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpshufb {{.*#+}} ymm6 = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX2-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,3,2,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm7 = [0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; AVX2-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm6 = [128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128,128,18]
; AVX2-NEXT:    vpshufb %ymm6, %ymm11, %ymm5
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm7 = [0,128,14,128,128,128,128,1,128,15,128,128,128,128,2,128,16,128,30,128,128,128,128,17,128,31,128,128,128,128,18,128]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm7, %ymm4, %ymm8
; AVX2-NEXT:    vpor %ymm5, %ymm8, %ymm5
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm8 = [128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128]
; AVX2-NEXT:    vpshufb %ymm8, %ymm2, %ymm9
; AVX2-NEXT:    vmovdqa %ymm2, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [128,128,0,128,14,128,128,128,128,1,128,15,128,128,128,128,128,128,16,128,30,128,128,128,128,17,128,31,128,128,128,128]
; AVX2-NEXT:    vpshufb %ymm1, %ymm10, %ymm11
; AVX2-NEXT:    vmovdqa %ymm10, %ymm2
; AVX2-NEXT:    vpor %ymm9, %ymm11, %ymm9
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm11 = [u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255]
; AVX2-NEXT:    vpblendvb %ymm11, %ymm5, %ymm9, %ymm5
; AVX2-NEXT:    vpshufb %ymm6, %ymm0, %ymm6
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm7, %ymm0, %ymm7
; AVX2-NEXT:    vpor %ymm6, %ymm7, %ymm6
; AVX2-NEXT:    vpshufb %ymm8, %ymm15, %ymm7
; AVX2-NEXT:    vpshufb %ymm1, %ymm12, %ymm8
; AVX2-NEXT:    vpor %ymm7, %ymm8, %ymm7
; AVX2-NEXT:    vpblendvb %ymm11, %ymm6, %ymm7, %ymm6
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm7 = [128,1,2,3,0,128,14,128,0,1,0,1,128,15,128,15,128,17,18,19,16,128,30,128,16,17,16,17,128,31,128,31]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm7, %ymm0, %ymm8
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm9 = [13,128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm9, %ymm15, %ymm10
; AVX2-NEXT:    vpor %ymm8, %ymm10, %ymm8
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm10 = [12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm10, %ymm1, %ymm11
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u]
; AVX2-NEXT:    vpblendvb %ymm12, %ymm8, %ymm11, %ymm8
; AVX2-NEXT:    vpshufb %ymm7, %ymm13, %ymm7
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm9, %ymm11, %ymm9
; AVX2-NEXT:    vpor %ymm7, %ymm9, %ymm7
; AVX2-NEXT:    vpshufb %ymm10, %ymm14, %ymm9
; AVX2-NEXT:    vpblendvb %ymm12, %ymm7, %ymm9, %ymm7
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm9 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm5, %ymm8, %ymm5
; AVX2-NEXT:    vpblendvb %ymm9, %ymm6, %ymm7, %ymm6
; AVX2-NEXT:    vpshufb {{.*#+}} ymm7 = ymm3[11,u,u,u,u,14,u,12,u,u,u,u,15,u,13,u,27,u,u,u,u,30,u,28,u,u,u,u,31,u,29,u]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm8 = ymm2[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm8 = ymm8[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-NEXT:    vpblendvb %ymm2, %ymm7, %ymm8, %ymm7
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-NEXT:    vpshufb {{.*#+}} ymm8 = ymm2[u,u,u,14,u,12,u,u,u,u,15,u,13,u,u,u,u,u,u,30,u,28,u,u,u,u,31,u,29,u,u,u]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm9 = ymm4[0,1,2,3,6,7,7,6,8,9,10,11,14,15,15,14]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[2,2,3,3,6,6,7,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-NEXT:    vpblendvb %ymm2, %ymm9, %ymm8, %ymm8
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm7, %ymm8, %ymm7
; AVX2-NEXT:    vpshufb {{.*#+}} ymm8 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,26,27,30,31,30,31,28,29,28,29,28,29,28,29]
; AVX2-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,2]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-NEXT:    vpshufb {{.*#+}} ymm8 = ymm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29,28,27,u,u,u,31,30,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,2,2,2]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-NEXT:    vpshufb {{.*#+}} ymm8 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovdqa %ymm6, 96(%rax)
; AVX2-NEXT:    vmovdqa %ymm5, 320(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-NEXT:    vmovdqa %ymm7, 416(%rax)
; AVX2-NEXT:    addq $824, %rsp # imm = 0x338
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i8_stride7_vf64:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $616, %rsp # imm = 0x268
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqa 32(%rsi), %ymm7
; AVX2-FP-NEXT:    vmovdqa 32(%rdx), %ymm6
; AVX2-FP-NEXT:    vmovdqa 32(%rcx), %ymm2
; AVX2-FP-NEXT:    vmovdqa 32(%r8), %ymm4
; AVX2-FP-NEXT:    vmovdqa 32(%r9), %ymm5
; AVX2-FP-NEXT:    vmovdqa 32(%rax), %ymm3
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm1[23],zero,ymm1[27,20,21,26],zero,ymm1[24],zero,ymm1[26,27,26,27],zero,ymm1[25]
; AVX2-FP-NEXT:    vmovdqa %ymm1, %ymm8
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm7[23],zero,zero,zero,zero,ymm7[26],zero,ymm7[24],zero,zero,zero,zero,ymm7[27],zero
; AVX2-FP-NEXT:    vmovdqa %ymm7, %ymm9
; AVX2-FP-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero,zero,zero
; AVX2-FP-NEXT:    vmovdqa %ymm2, %ymm7
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[25],zero,ymm6[23],zero,zero,zero,zero,ymm6[26],zero,ymm6[24],zero,zero,zero,zero,ymm6[27]
; AVX2-FP-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25,22,23,22,23,24,25,26,27,24,25,30,31]
; AVX2-FP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,25,24,23,u,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX2-FP-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[17,18,19,30],zero,ymm6[28],zero,ymm6[28,29,30,31],zero,ymm6[29],zero,ymm6[31]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27],zero,zero,zero,zero,ymm7[30],zero,ymm7[28],zero,zero,zero,zero,ymm7[31],zero,ymm7[29],zero
; AVX2-FP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm9[30],zero,ymm9[28],zero,zero,zero,zero,ymm9[31],zero,ymm9[29],zero,zero,zero
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm8[30],zero,ymm8[28],zero,zero,zero,zero,ymm8[31],zero,ymm8[29],zero,zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,26,27,30,31,30,31,28,29,28,29,28,29,28,29]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,2]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29,28,27,u,u,u,31,30,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-FP-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX2-FP-NEXT:    vmovdqa %xmm2, %xmm7
; AVX2-FP-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa %xmm1, %xmm15
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX2-FP-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa 32(%rcx), %xmm9
; AVX2-FP-NEXT:    vmovdqa 32(%rdx), %xmm5
; AVX2-FP-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm5[0],xmm9[0],xmm5[1],xmm9[1],xmm5[2],xmm9[2],xmm5[3],xmm9[3],xmm5[4],xmm9[4],xmm5[5],xmm9[5],xmm5[6],xmm9[6],xmm5[7],xmm9[7]
; AVX2-FP-NEXT:    vmovdqa %xmm5, %xmm11
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX2-FP-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0]
; AVX2-FP-NEXT:    vpblendvb %ymm5, %ymm0, %ymm2, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-FP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm4
; AVX2-FP-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3],xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; AVX2-FP-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX2-FP-NEXT:    vmovdqa (%rcx), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-FP-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm6[0],xmm1[0],xmm6[1],xmm1[1],xmm6[2],xmm1[2],xmm6[3],xmm1[3],xmm6[4],xmm1[4],xmm6[5],xmm1[5],xmm6[6],xmm1[6],xmm6[7],xmm1[7]
; AVX2-FP-NEXT:    vmovdqa %xmm6, %xmm10
; AVX2-FP-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm5, %ymm0, %ymm1, %ymm3
; AVX2-FP-NEXT:    vmovdqa 32(%rax), %xmm0
; AVX2-FP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm6 = [2,3,2,3,0,1,0,1,8,9,10,11,2,3,2,3]
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm0, %xmm1
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,0]
; AVX2-FP-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX2-FP-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 32(%r8), %xmm14
; AVX2-FP-NEXT:    vpunpcklbw {{.*#+}} xmm5 = xmm14[0],xmm0[0],xmm14[1],xmm0[1],xmm14[2],xmm0[2],xmm14[3],xmm0[3],xmm14[4],xmm0[4],xmm14[5],xmm0[5],xmm14[6],xmm0[6],xmm14[7],xmm0[7]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm0 = [u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX2-FP-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm5, %ymm1, %ymm1
; AVX2-FP-NEXT:    vmovdqa (%r9), %xmm5
; AVX2-FP-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa (%r8), %xmm8
; AVX2-FP-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vpunpcklbw {{.*#+}} xmm12 = xmm8[0],xmm5[0],xmm8[1],xmm5[1],xmm8[2],xmm5[2],xmm8[3],xmm5[3],xmm8[4],xmm5[4],xmm8[5],xmm5[5],xmm8[6],xmm5[6],xmm8[7],xmm5[7]
; AVX2-FP-NEXT:    vpshufb %xmm0, %xmm12, %xmm12
; AVX2-FP-NEXT:    vmovdqa (%rax), %xmm13
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm13, %xmm6
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,0,1,0]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm12, %ymm6, %ymm2
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm6, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendvb %ymm6, %ymm3, %ymm2, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm1 = [u,128,7,128,5,u,u,u,128,8,128,6,u,u,u,128]
; AVX2-FP-NEXT:    vpshufb %xmm1, %xmm15, %xmm2
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm3 = [u,7,128,5,128,u,u,u,8,128,6,128,u,u,u,9]
; AVX2-FP-NEXT:    vpshufb %xmm3, %xmm7, %xmm6
; AVX2-FP-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm6 = [u,u,u,128,7,128,5,u,u,u,128,8,128,6,u,u]
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm9, %xmm12
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm0 = [u,u,u,7,128,5,128,u,u,u,8,128,6,128,u,u]
; AVX2-FP-NEXT:    vmovdqa %xmm11, %xmm7
; AVX2-FP-NEXT:    vpshufb %xmm0, %xmm11, %xmm15
; AVX2-FP-NEXT:    vpor %xmm12, %xmm15, %xmm12
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm15 = [u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255]
; AVX2-FP-NEXT:    vpblendvb %ymm15, %ymm2, %ymm12, %ymm2
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-FP-NEXT:    vpshufb %xmm1, %xmm12, %xmm1
; AVX2-FP-NEXT:    vpshufb %xmm3, %xmm4, %xmm2
; AVX2-FP-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX2-FP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm5, %xmm2
; AVX2-FP-NEXT:    vpshufb %xmm0, %xmm10, %xmm0
; AVX2-FP-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm15, %ymm1, %ymm0, %ymm11
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm1 = [128,4,u,u,u,128,7,128,5,u,u,u,128,8,128,6]
; AVX2-FP-NEXT:    vmovdqa (%rsp), %xmm8 # 16-byte Reload
; AVX2-FP-NEXT:    vpshufb %xmm1, %xmm8, %xmm2
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,128,u,u,u,7,128,5,128,u,u,u,8,128,6,128]
; AVX2-FP-NEXT:    vpshufb %xmm3, %xmm14, %xmm6
; AVX2-FP-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm6 = [4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX2-FP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm4, %xmm15
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,0,1,0]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u]
; AVX2-FP-NEXT:    vpblendvb %ymm0, %ymm2, %ymm15, %ymm2
; AVX2-FP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FP-NEXT:    vpshufb %xmm1, %xmm10, %xmm1
; AVX2-FP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FP-NEXT:    vpshufb %xmm3, %xmm15, %xmm3
; AVX2-FP-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm13, %xmm3
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,1,0]
; AVX2-FP-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm0
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX2-FP-NEXT:    vpblendvb %ymm1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendvb %ymm1, %ymm11, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm9[8],xmm7[8],xmm9[9],xmm7[9],xmm9[10],xmm7[10],xmm9[11],xmm7[11],xmm9[12],xmm7[12],xmm9[13],xmm7[13],xmm9[14],xmm7[14],xmm9[15],xmm7[15]
; AVX2-FP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vpunpckhbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = xmm1[8],mem[8],xmm1[9],mem[9],xmm1[10],mem[10],xmm1[11],mem[11],xmm1[12],mem[12],xmm1[13],mem[13],xmm1[14],mem[14],xmm1[15],mem[15]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm2 = [6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX2-FP-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm3 = [2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX2-FP-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u]
; AVX2-FP-NEXT:    vpblendvb %ymm6, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpunpckhbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = xmm5[8],mem[8],xmm5[9],mem[9],xmm5[10],mem[10],xmm5[11],mem[11],xmm5[12],mem[12],xmm5[13],mem[13],xmm5[14],mem[14],xmm5[15],mem[15]
; AVX2-FP-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX2-FP-NEXT:    vpunpckhbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm2 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm2 = xmm12[8],mem[8],xmm12[9],mem[9],xmm12[10],mem[10],xmm12[11],mem[11],xmm12[12],mem[12],xmm12[13],mem[13],xmm12[14],mem[14],xmm12[15],mem[15]
; AVX2-FP-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm6, %ymm1, %ymm2, %ymm1
; AVX2-FP-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm14[8],xmm8[8],xmm14[9],xmm8[9],xmm14[10],xmm8[10],xmm14[11],xmm8[11],xmm14[12],xmm8[12],xmm14[13],xmm8[13],xmm14[14],xmm8[14],xmm14[15],xmm8[15]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm3 = [8,9,10,11,8,9,10,11,10,11,12,13,10,11,12,13]
; AVX2-FP-NEXT:    vpshufb %xmm3, %xmm4, %xmm4
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm6 = [u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm2, %xmm2
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm7 = [u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255]
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm2, %ymm4, %ymm2
; AVX2-FP-NEXT:    vpshufb %xmm3, %xmm13, %xmm3
; AVX2-FP-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm15[8],xmm10[8],xmm15[9],xmm10[9],xmm15[10],xmm10[10],xmm15[11],xmm10[11],xmm15[12],xmm10[12],xmm15[13],xmm10[13],xmm15[14],xmm10[14],xmm15[15],xmm10[15]
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm4, %xmm4
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm4, %ymm3, %ymm3
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX2-FP-NEXT:    vpblendvb %ymm4, %ymm0, %ymm2, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm1[17,18,19,30],zero,ymm1[28],zero,ymm1[28,29,30,31],zero,ymm1[29],zero,ymm1[31]
; AVX2-FP-NEXT:    vmovdqa %ymm1, %ymm3
; AVX2-FP-NEXT:    vmovdqa (%rcx), %ymm5
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27],zero,zero,zero,zero,ymm5[30],zero,ymm5[28],zero,zero,zero,zero,ymm5[31],zero,ymm5[29],zero
; AVX2-FP-NEXT:    vpor %ymm0, %ymm1, %ymm2
; AVX2-FP-NEXT:    vmovdqa (%rsi), %ymm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm0[30],zero,ymm0[28],zero,zero,zero,zero,ymm0[31],zero,ymm0[29],zero,zero,zero
; AVX2-FP-NEXT:    vmovdqa %ymm0, %ymm11
; AVX2-FP-NEXT:    vmovdqa (%rdi), %ymm13
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm13[30],zero,ymm13[28],zero,zero,zero,zero,ymm13[31],zero,ymm13[29],zero,zero,zero,zero
; AVX2-FP-NEXT:    vpor %ymm4, %ymm6, %ymm4
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm0, %ymm2, %ymm4, %ymm6
; AVX2-FP-NEXT:    vmovdqa (%r8), %ymm14
; AVX2-FP-NEXT:    vmovdqa (%r9), %ymm1
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm14[27],zero,ymm14[27,28,29,30],zero,ymm14[28],zero,ymm14[26,27,30,31],zero,ymm14[29]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm7 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm1[27],zero,zero,zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero
; AVX2-FP-NEXT:    vmovdqu %ymm1, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vpor %ymm2, %ymm7, %ymm7
; AVX2-FP-NEXT:    vmovdqa (%rax), %ymm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX2-FP-NEXT:    vmovdqa %ymm0, %ymm10
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0]
; AVX2-FP-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0]
; AVX2-FP-NEXT:    vpblendvb %ymm8, %ymm6, %ymm7, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm13[23],zero,ymm13[27,20,21,26],zero,ymm13[24],zero,ymm13[26,27,26,27],zero,ymm13[25]
; AVX2-FP-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm11[23],zero,zero,zero,zero,ymm11[26],zero,ymm11[24],zero,zero,zero,zero,ymm11[27],zero
; AVX2-FP-NEXT:    vmovdqa %ymm11, %ymm2
; AVX2-FP-NEXT:    vpor %ymm6, %ymm8, %ymm6
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm5[25],zero,ymm5[23],zero,zero,zero,zero,ymm5[26],zero,ymm5[24],zero,zero,zero,zero
; AVX2-FP-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm9 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[25],zero,ymm3[23],zero,zero,zero,zero,ymm3[26],zero,ymm3[24],zero,zero,zero,zero,ymm3[27]
; AVX2-FP-NEXT:    vpor %ymm8, %ymm9, %ymm8
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,3,2,3]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0]
; AVX2-FP-NEXT:    vpblendvb %ymm0, %ymm6, %ymm8, %ymm6
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm1[25],zero,ymm1[23],zero,zero,zero,zero,ymm1[26],zero,ymm1[24],zero,zero
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm9 = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm14[25],zero,ymm14[23],zero,zero,zero,zero,ymm14[26],zero,ymm14[24],zero,zero,zero
; AVX2-FP-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpor %ymm8, %ymm9, %ymm8
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm9 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,3,2,3]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm10 = [0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm9 = [0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm9, %ymm6, %ymm8, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20]
; AVX2-FP-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm9, %ymm0, %ymm8
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm10 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm10, %ymm0, %ymm11
; AVX2-FP-NEXT:    vpor %ymm8, %ymm11, %ymm8
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm11 = [128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128]
; AVX2-FP-NEXT:    # ymm11 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm11, %ymm7, %ymm12
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128,128]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm0, %ymm1, %ymm15
; AVX2-FP-NEXT:    vpor %ymm12, %ymm15, %ymm12
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm15, %ymm8, %ymm12, %ymm4
; AVX2-FP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpshufb %ymm9, %ymm5, %ymm9
; AVX2-FP-NEXT:    vpshufb %ymm10, %ymm3, %ymm10
; AVX2-FP-NEXT:    vpor %ymm9, %ymm10, %ymm9
; AVX2-FP-NEXT:    vmovdqa %ymm2, %ymm3
; AVX2-FP-NEXT:    vpshufb %ymm11, %ymm2, %ymm10
; AVX2-FP-NEXT:    vpshufb %ymm0, %ymm13, %ymm11
; AVX2-FP-NEXT:    vpor %ymm10, %ymm11, %ymm10
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,3,2,3]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,3,2,3]
; AVX2-FP-NEXT:    vpblendvb %ymm15, %ymm9, %ymm10, %ymm9
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm10 = [128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22]
; AVX2-FP-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm10, %ymm8, %ymm11
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm12 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm12, %ymm4, %ymm13
; AVX2-FP-NEXT:    vpor %ymm11, %ymm13, %ymm11
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm13 = [20,21,18,19,18,19,20,21,18,19,20,21,28,29,30,31,20,21,18,19,18,19,20,21,18,19,20,21,28,29,30,31]
; AVX2-FP-NEXT:    # ymm13 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm13, %ymm6, %ymm15
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[2,2,3,2]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm0, %ymm11, %ymm15, %ymm11
; AVX2-FP-NEXT:    vmovdqu (%rsp), %ymm15 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm10, %ymm15, %ymm10
; AVX2-FP-NEXT:    vpshufb %ymm12, %ymm14, %ymm12
; AVX2-FP-NEXT:    vpor %ymm10, %ymm12, %ymm10
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,3,2,3]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm13, %ymm2, %ymm12
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,2,3,2]
; AVX2-FP-NEXT:    vpblendvb %ymm0, %ymm10, %ymm12, %ymm0
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0]
; AVX2-FP-NEXT:    vpblendvb %ymm10, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX2-FP-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendvb %ymm10, %ymm9, %ymm0, %ymm9
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128,128,18]
; AVX2-FP-NEXT:    vpshufb %ymm0, %ymm7, %ymm10
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm11 = [0,128,14,128,128,128,128,1,128,15,128,128,128,128,2,128,16,128,30,128,128,128,128,17,128,31,128,128,128,128,18,128]
; AVX2-FP-NEXT:    vpshufb %ymm11, %ymm1, %ymm12
; AVX2-FP-NEXT:    vpor %ymm10, %ymm12, %ymm10
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm12 = [128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm12, %ymm1, %ymm13
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm14 = [128,128,0,128,14,128,128,128,128,1,128,15,128,128,128,128,128,128,16,128,30,128,128,128,128,17,128,31,128,128,128,128]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm14, %ymm1, %ymm7
; AVX2-FP-NEXT:    vpor %ymm7, %ymm13, %ymm7
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm13, %ymm10, %ymm7, %ymm10
; AVX2-FP-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm11, %ymm1, %ymm1
; AVX2-FP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpshufb %ymm12, %ymm5, %ymm1
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm14, %ymm3, %ymm3
; AVX2-FP-NEXT:    vpor %ymm1, %ymm3, %ymm1
; AVX2-FP-NEXT:    vpblendvb %ymm13, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm1 = [128,1,2,3,0,128,14,128,0,1,0,1,128,15,128,15,128,17,18,19,16,128,30,128,16,17,16,17,128,31,128,31]
; AVX2-FP-NEXT:    vpshufb %ymm1, %ymm4, %ymm3
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm5 = [13,128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128]
; AVX2-FP-NEXT:    vpshufb %ymm5, %ymm8, %ymm7
; AVX2-FP-NEXT:    vpor %ymm3, %ymm7, %ymm3
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm7 = [12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX2-FP-NEXT:    vpshufb %ymm7, %ymm6, %ymm11
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm12, %ymm3, %ymm11, %ymm3
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm1, %ymm4, %ymm1
; AVX2-FP-NEXT:    vpshufb %ymm5, %ymm15, %ymm4
; AVX2-FP-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX2-FP-NEXT:    vpshufb %ymm7, %ymm2, %ymm2
; AVX2-FP-NEXT:    vpblendvb %ymm12, %ymm1, %ymm2, %ymm1
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm10, %ymm3, %ymm3
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovdqa %ymm0, 96(%rax)
; AVX2-FP-NEXT:    vmovdqa %ymm3, 320(%rax)
; AVX2-FP-NEXT:    vmovdqa %ymm9, 128(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FP-NEXT:    addq $616, %rsp # imm = 0x268
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i8_stride7_vf64:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $616, %rsp # imm = 0x268
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqa 32(%rsi), %ymm7
; AVX2-FCP-NEXT:    vmovdqa 32(%rdx), %ymm6
; AVX2-FCP-NEXT:    vmovdqa 32(%rcx), %ymm2
; AVX2-FCP-NEXT:    vmovdqa 32(%r8), %ymm4
; AVX2-FCP-NEXT:    vmovdqa 32(%r9), %ymm5
; AVX2-FCP-NEXT:    vmovdqa 32(%rax), %ymm3
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm1[23],zero,ymm1[27,20,21,26],zero,ymm1[24],zero,ymm1[26,27,26,27],zero,ymm1[25]
; AVX2-FCP-NEXT:    vmovdqa %ymm1, %ymm8
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm7[23],zero,zero,zero,zero,ymm7[26],zero,ymm7[24],zero,zero,zero,zero,ymm7[27],zero
; AVX2-FCP-NEXT:    vmovdqa %ymm7, %ymm9
; AVX2-FCP-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero,zero,zero
; AVX2-FCP-NEXT:    vmovdqa %ymm2, %ymm7
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[25],zero,ymm6[23],zero,zero,zero,zero,ymm6[26],zero,ymm6[24],zero,zero,zero,zero,ymm6[27]
; AVX2-FCP-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25,22,23,22,23,24,25,26,27,24,25,30,31]
; AVX2-FCP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,25,24,23,u,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX2-FCP-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[17,18,19,30],zero,ymm6[28],zero,ymm6[28,29,30,31],zero,ymm6[29],zero,ymm6[31]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27],zero,zero,zero,zero,ymm7[30],zero,ymm7[28],zero,zero,zero,zero,ymm7[31],zero,ymm7[29],zero
; AVX2-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm9[30],zero,ymm9[28],zero,zero,zero,zero,ymm9[31],zero,ymm9[29],zero,zero,zero
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm8[30],zero,ymm8[28],zero,zero,zero,zero,ymm8[31],zero,ymm8[29],zero,zero,zero,zero
; AVX2-FCP-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,26,27,30,31,30,31,28,29,28,29,28,29,28,29]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,2]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u,255,255,255,255,0,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29,28,27,u,u,u,31,30,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u,255,255,255,255,255,0,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX2-FCP-NEXT:    vmovdqa %xmm1, %xmm14
; AVX2-FCP-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX2-FCP-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa 32(%rcx), %xmm10
; AVX2-FCP-NEXT:    vmovdqa 32(%rdx), %xmm7
; AVX2-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm7[0],xmm10[0],xmm7[1],xmm10[1],xmm7[2],xmm10[2],xmm7[3],xmm10[3],xmm7[4],xmm10[4],xmm7[5],xmm10[5],xmm7[6],xmm10[6],xmm7[7],xmm10[7]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX2-FCP-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm4, %ymm0, %ymm2, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa (%rsi), %xmm11
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm12
; AVX2-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3],xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX2-FCP-NEXT:    vmovdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vmovdqa (%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; AVX2-FCP-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm4, %ymm0, %ymm1, %ymm6
; AVX2-FCP-NEXT:    vmovdqa 32(%rax), %xmm0
; AVX2-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[1,1,0,0,4,5,6,7]
; AVX2-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [0,1,0,1,2,0,0,1]
; AVX2-FCP-NEXT:    vpermd %ymm1, %ymm3, %ymm4
; AVX2-FCP-NEXT:    vmovdqa 32(%r9), %xmm8
; AVX2-FCP-NEXT:    vmovdqa 32(%r8), %xmm13
; AVX2-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm5 = xmm13[0],xmm8[0],xmm13[1],xmm8[1],xmm13[2],xmm8[2],xmm13[3],xmm8[3],xmm13[4],xmm8[4],xmm13[5],xmm8[5],xmm13[6],xmm8[6],xmm13[7],xmm8[7]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm2 = [u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm2, %xmm5, %xmm5
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm1 = [u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm1, %ymm5, %ymm4, %ymm0
; AVX2-FCP-NEXT:    vmovdqa (%rax), %xmm4
; AVX2-FCP-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[1,1,0,0,4,5,6,7]
; AVX2-FCP-NEXT:    vpermd %ymm4, %ymm3, %ymm3
; AVX2-FCP-NEXT:    vmovdqa (%r9), %xmm9
; AVX2-FCP-NEXT:    vmovdqa (%r8), %xmm5
; AVX2-FCP-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm15 = xmm5[0],xmm9[0],xmm5[1],xmm9[1],xmm5[2],xmm9[2],xmm5[3],xmm9[3],xmm5[4],xmm9[4],xmm5[5],xmm9[5],xmm5[6],xmm9[6],xmm5[7],xmm9[7]
; AVX2-FCP-NEXT:    vpshufb %xmm2, %xmm15, %xmm2
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm1, %ymm2, %ymm3, %ymm1
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm6, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm1 = [u,128,7,128,5,u,u,u,128,8,128,6,u,u,u,128]
; AVX2-FCP-NEXT:    vpshufb %xmm1, %xmm14, %xmm0
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm2 = [u,7,128,5,128,u,u,u,8,128,6,128,u,u,u,9]
; AVX2-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FCP-NEXT:    vpshufb %xmm2, %xmm3, %xmm3
; AVX2-FCP-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm3 = [u,u,u,128,7,128,5,u,u,u,128,8,128,6,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm3, %xmm10, %xmm6
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm15 = [u,u,u,7,128,5,128,u,u,u,8,128,6,128,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm15, %xmm7, %xmm14
; AVX2-FCP-NEXT:    vpor %xmm6, %xmm14, %xmm6
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm14 = [u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm14, %ymm0, %ymm6, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpshufb %xmm1, %xmm11, %xmm1
; AVX2-FCP-NEXT:    vpshufb %xmm2, %xmm12, %xmm2
; AVX2-FCP-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX2-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vpshufb %xmm3, %xmm5, %xmm2
; AVX2-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FCP-NEXT:    vpshufb %xmm15, %xmm4, %xmm3
; AVX2-FCP-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm14, %ymm1, %ymm2, %ymm1
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm2 = [128,4,u,u,u,128,7,128,5,u,u,u,128,8,128,6]
; AVX2-FCP-NEXT:    vpshufb %xmm2, %xmm8, %xmm3
; AVX2-FCP-NEXT:    vmovdqa %xmm8, %xmm11
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm6 = [4,128,u,u,u,7,128,5,128,u,u,u,8,128,6,128]
; AVX2-FCP-NEXT:    vpshufb %xmm6, %xmm13, %xmm14
; AVX2-FCP-NEXT:    vpor %xmm3, %xmm14, %xmm3
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm14 = [4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX2-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FCP-NEXT:    vpshufb %xmm14, %xmm8, %xmm15
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,0,1,0]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm0, %ymm3, %ymm15, %ymm3
; AVX2-FCP-NEXT:    vpshufb %xmm2, %xmm9, %xmm2
; AVX2-FCP-NEXT:    vmovdqa %xmm9, %xmm12
; AVX2-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-FCP-NEXT:    vpshufb %xmm6, %xmm9, %xmm6
; AVX2-FCP-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FCP-NEXT:    vpshufb %xmm14, %xmm15, %xmm6
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,0,1,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm0, %ymm2, %ymm6, %ymm0
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm10[8],xmm7[8],xmm10[9],xmm7[9],xmm10[10],xmm7[10],xmm10[11],xmm7[11],xmm10[12],xmm7[12],xmm10[13],xmm7[13],xmm10[14],xmm7[14],xmm10[15],xmm7[15]
; AVX2-FCP-NEXT:    vmovdqa (%rsp), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vpunpckhbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = xmm1[8],mem[8],xmm1[9],mem[9],xmm1[10],mem[10],xmm1[11],mem[11],xmm1[12],mem[12],xmm1[13],mem[13],xmm1[14],mem[14],xmm1[15],mem[15]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm2 = [6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX2-FCP-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm3 = [2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX2-FCP-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm6, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm5[8],xmm4[8],xmm5[9],xmm4[9],xmm5[10],xmm4[10],xmm5[11],xmm4[11],xmm5[12],xmm4[12],xmm5[13],xmm4[13],xmm5[14],xmm4[14],xmm5[15],xmm4[15]
; AVX2-FCP-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX2-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-FCP-NEXT:    vpunpckhbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm2 = xmm2[8],mem[8],xmm2[9],mem[9],xmm2[10],mem[10],xmm2[11],mem[11],xmm2[12],mem[12],xmm2[13],mem[13],xmm2[14],mem[14],xmm2[15],mem[15]
; AVX2-FCP-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm6, %ymm1, %ymm2, %ymm1
; AVX2-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm13[8],xmm11[8],xmm13[9],xmm11[9],xmm13[10],xmm11[10],xmm13[11],xmm11[11],xmm13[12],xmm11[12],xmm13[13],xmm11[13],xmm13[14],xmm11[14],xmm13[15],xmm11[15]
; AVX2-FCP-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm8[0,1,2,3,4,5,5,6]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [2,2,3,3,2,2,3,3]
; AVX2-FCP-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermd %ymm3, %ymm6, %ymm3
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm7 = [u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX2-FCP-NEXT:    vpshufb %xmm7, %xmm2, %xmm2
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm5 = [u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm5, %ymm2, %ymm3, %ymm2
; AVX2-FCP-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm15[0,1,2,3,4,5,5,6]
; AVX2-FCP-NEXT:    vpermd %ymm3, %ymm6, %ymm3
; AVX2-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm9[8],xmm12[8],xmm9[9],xmm12[9],xmm9[10],xmm12[10],xmm9[11],xmm12[11],xmm9[12],xmm12[12],xmm9[13],xmm12[13],xmm9[14],xmm12[14],xmm9[15],xmm12[15]
; AVX2-FCP-NEXT:    vpshufb %xmm7, %xmm4, %xmm4
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm5, %ymm4, %ymm3, %ymm3
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm4, %ymm0, %ymm2, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm1[17,18,19,30],zero,ymm1[28],zero,ymm1[28,29,30,31],zero,ymm1[29],zero,ymm1[31]
; AVX2-FCP-NEXT:    vmovdqa %ymm1, %ymm3
; AVX2-FCP-NEXT:    vmovdqa (%rcx), %ymm5
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27],zero,zero,zero,zero,ymm5[30],zero,ymm5[28],zero,zero,zero,zero,ymm5[31],zero,ymm5[29],zero
; AVX2-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm2
; AVX2-FCP-NEXT:    vmovdqa (%rsi), %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm0[30],zero,ymm0[28],zero,zero,zero,zero,ymm0[31],zero,ymm0[29],zero,zero,zero
; AVX2-FCP-NEXT:    vmovdqa %ymm0, %ymm11
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %ymm13
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm13[30],zero,ymm13[28],zero,zero,zero,zero,ymm13[31],zero,ymm13[29],zero,zero,zero,zero
; AVX2-FCP-NEXT:    vpor %ymm4, %ymm6, %ymm4
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm0, %ymm2, %ymm4, %ymm6
; AVX2-FCP-NEXT:    vmovdqa (%r8), %ymm14
; AVX2-FCP-NEXT:    vmovdqa (%r9), %ymm1
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm14[27],zero,ymm14[27,28,29,30],zero,ymm14[28],zero,ymm14[26,27,30,31],zero,ymm14[29]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm7 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm1[27],zero,zero,zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero
; AVX2-FCP-NEXT:    vmovdqu %ymm1, (%rsp) # 32-byte Spill
; AVX2-FCP-NEXT:    vpor %ymm2, %ymm7, %ymm7
; AVX2-FCP-NEXT:    vmovdqa (%rax), %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX2-FCP-NEXT:    vmovdqa %ymm0, %ymm10
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm8, %ymm6, %ymm7, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm13[23],zero,ymm13[27,20,21,26],zero,ymm13[24],zero,ymm13[26,27,26,27],zero,ymm13[25]
; AVX2-FCP-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm11[23],zero,zero,zero,zero,ymm11[26],zero,ymm11[24],zero,zero,zero,zero,ymm11[27],zero
; AVX2-FCP-NEXT:    vmovdqa %ymm11, %ymm2
; AVX2-FCP-NEXT:    vpor %ymm6, %ymm8, %ymm6
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm5[25],zero,ymm5[23],zero,zero,zero,zero,ymm5[26],zero,ymm5[24],zero,zero,zero,zero
; AVX2-FCP-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm9 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[25],zero,ymm3[23],zero,zero,zero,zero,ymm3[26],zero,ymm3[24],zero,zero,zero,zero,ymm3[27]
; AVX2-FCP-NEXT:    vpor %ymm8, %ymm9, %ymm8
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,3,2,3]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm0, %ymm6, %ymm8, %ymm6
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm1[25],zero,ymm1[23],zero,zero,zero,zero,ymm1[26],zero,ymm1[24],zero,zero
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm9 = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm14[25],zero,ymm14[23],zero,zero,zero,zero,ymm14[26],zero,ymm14[24],zero,zero,zero
; AVX2-FCP-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpor %ymm8, %ymm9, %ymm8
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm9 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,3,2,3]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm10 = [0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm9 = [0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm9, %ymm6, %ymm8, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20]
; AVX2-FCP-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm9, %ymm0, %ymm8
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm10 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm10, %ymm0, %ymm11
; AVX2-FCP-NEXT:    vpor %ymm8, %ymm11, %ymm8
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm11 = [128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128]
; AVX2-FCP-NEXT:    # ymm11 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm11, %ymm7, %ymm12
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128,128]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm0, %ymm1, %ymm15
; AVX2-FCP-NEXT:    vpor %ymm12, %ymm15, %ymm12
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u,u,0,0,255,255,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm15, %ymm8, %ymm12, %ymm4
; AVX2-FCP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpshufb %ymm9, %ymm5, %ymm9
; AVX2-FCP-NEXT:    vpshufb %ymm10, %ymm3, %ymm10
; AVX2-FCP-NEXT:    vpor %ymm9, %ymm10, %ymm9
; AVX2-FCP-NEXT:    vmovdqa %ymm2, %ymm3
; AVX2-FCP-NEXT:    vpshufb %ymm11, %ymm2, %ymm10
; AVX2-FCP-NEXT:    vpshufb %ymm0, %ymm13, %ymm11
; AVX2-FCP-NEXT:    vpor %ymm10, %ymm11, %ymm10
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,3,2,3]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,3,2,3]
; AVX2-FCP-NEXT:    vpblendvb %ymm15, %ymm9, %ymm10, %ymm9
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm10 = [128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22]
; AVX2-FCP-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm10, %ymm8, %ymm11
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm12 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm12, %ymm2, %ymm13
; AVX2-FCP-NEXT:    vpor %ymm11, %ymm13, %ymm11
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshuflw {{.*#+}} ymm13 = ymm6[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX2-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm15 = [4,5,4,5,5,7,4,5]
; AVX2-FCP-NEXT:    vpermd %ymm13, %ymm15, %ymm13
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm0, %ymm11, %ymm13, %ymm11
; AVX2-FCP-NEXT:    vmovdqu (%rsp), %ymm4 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm10, %ymm4, %ymm10
; AVX2-FCP-NEXT:    vpshufb %ymm12, %ymm14, %ymm12
; AVX2-FCP-NEXT:    vpor %ymm10, %ymm12, %ymm10
; AVX2-FCP-NEXT:    vpshuflw $150, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm12 = mem[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX2-FCP-NEXT:    vpermd %ymm12, %ymm15, %ymm12
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,3,2,3]
; AVX2-FCP-NEXT:    vpblendvb %ymm0, %ymm10, %ymm12, %ymm0
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm10, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm14 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    vpblendvb %ymm10, %ymm9, %ymm0, %ymm9
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128,128,18]
; AVX2-FCP-NEXT:    vpshufb %ymm0, %ymm7, %ymm10
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm11 = [0,128,14,128,128,128,128,1,128,15,128,128,128,128,2,128,16,128,30,128,128,128,128,17,128,31,128,128,128,128,18,128]
; AVX2-FCP-NEXT:    vpshufb %ymm11, %ymm1, %ymm12
; AVX2-FCP-NEXT:    vpor %ymm10, %ymm12, %ymm10
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm12 = [128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm12, %ymm1, %ymm13
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm15 = [128,128,0,128,14,128,128,128,128,1,128,15,128,128,128,128,128,128,16,128,30,128,128,128,128,17,128,31,128,128,128,128]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm15, %ymm1, %ymm7
; AVX2-FCP-NEXT:    vpor %ymm7, %ymm13, %ymm7
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255,0,0,u,u,u,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm13, %ymm10, %ymm7, %ymm10
; AVX2-FCP-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm11, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpshufb %ymm12, %ymm5, %ymm1
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm15, %ymm3, %ymm3
; AVX2-FCP-NEXT:    vpor %ymm1, %ymm3, %ymm1
; AVX2-FCP-NEXT:    vpblendvb %ymm13, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm1 = [128,1,2,3,0,128,14,128,0,1,0,1,128,15,128,15,128,17,18,19,16,128,30,128,16,17,16,17,128,31,128,31]
; AVX2-FCP-NEXT:    vpshufb %ymm1, %ymm2, %ymm3
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm5 = [13,128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128]
; AVX2-FCP-NEXT:    vpshufb %ymm5, %ymm8, %ymm7
; AVX2-FCP-NEXT:    vpor %ymm3, %ymm7, %ymm3
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm7 = [12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX2-FCP-NEXT:    vpshufb %ymm7, %ymm6, %ymm11
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u,u,u,255,255,0,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm12, %ymm3, %ymm11, %ymm3
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX2-FCP-NEXT:    vpshufb %ymm5, %ymm4, %ymm4
; AVX2-FCP-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm7, %ymm2, %ymm2
; AVX2-FCP-NEXT:    vpblendvb %ymm12, %ymm1, %ymm2, %ymm1
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255,255,255,0,0,0,255,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm10, %ymm3, %ymm3
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovdqa %ymm0, 96(%rax)
; AVX2-FCP-NEXT:    vmovdqa %ymm3, 320(%rax)
; AVX2-FCP-NEXT:    vmovdqa %ymm9, 128(%rax)
; AVX2-FCP-NEXT:    vmovdqa %ymm14, 352(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FCP-NEXT:    addq $616, %rsp # imm = 0x268
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i8_stride7_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    subq $1384, %rsp # imm = 0x568
; AVX512-NEXT:    vmovdqa (%rsi), %ymm7
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,ymm7[14],zero,zero,zero,zero,zero,zero,ymm7[15],zero,zero,zero,zero,zero,zero,ymm7[16],zero,zero,zero,zero,zero,zero,ymm7[17],zero,zero,zero,zero,zero,zero,ymm7[18]
; AVX512-NEXT:    vmovdqa (%rdi), %ymm2
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[0,1,14],zero,ymm2[12,13,0,1,14,15],zero,ymm2[3,12,13,2,3,16],zero,ymm2[30,31,28,29,16,17],zero,ymm2[31,18,19,28,29,18],zero
; AVX512-NEXT:    vmovdqa64 %ymm2, %ymm20
; AVX512-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-NEXT:    vmovdqa (%rcx), %ymm15
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm2 = [128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128]
; AVX512-NEXT:    vpshufb %ymm2, %ymm15, %ymm0
; AVX512-NEXT:    vmovdqa64 %ymm2, %ymm23
; AVX512-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,0,1,14,128,14,15,0,1,14,15,128,13,14,15,16,17,16,128,30,31,30,31,16,17,128,31,28,29,30,31]
; AVX512-NEXT:    vpshufb %ymm3, %ymm2, %ymm1
; AVX512-NEXT:    vmovdqa64 %ymm3, %ymm26
; AVX512-NEXT:    vmovdqa64 %ymm2, %ymm18
; AVX512-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-NEXT:    vmovdqa (%r8), %ymm14
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm2 = [128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128]
; AVX512-NEXT:    vpshufb %ymm2, %ymm14, %ymm0
; AVX512-NEXT:    vmovdqa64 %ymm2, %ymm27
; AVX512-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-NEXT:    vmovdqa (%r9), %ymm8
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [13,0,0,0,128,16,128,14,0,0,0,128,17,128,15,0,13,0,0,0,128,16,128,14,0,0,0,128,17,128,15,0]
; AVX512-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512-NEXT:    vpshufb %ymm3, %ymm8, %ymm1
; AVX512-NEXT:    vmovdqa64 %ymm3, %ymm17
; AVX512-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-NEXT:    vmovdqa 32(%rsi), %ymm10
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [128,128,128,30,128,28,128,128,128,128,31,128,29,128,128,128,128,128,128,30,128,28,128,128,128,128,31,128,29,128,128,128]
; AVX512-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX512-NEXT:    vpshufb %ymm6, %ymm10, %ymm0
; AVX512-NEXT:    vmovdqa 32(%rdi), %ymm9
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm9[23],zero,zero,zero,zero,ymm9[26],zero,ymm9[24],zero,zero,zero,zero,ymm9[27],zero,ymm9[25]
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm1 = [12,13,14,128,12,128,14,15,14,15,128,13,128,15,12,13,28,29,30,128,28,128,30,31,30,31,128,29,128,31,28,29]
; AVX512-NEXT:    vpshufb %ymm1, %ymm9, %ymm0
; AVX512-NEXT:    vmovdqa64 %ymm1, %ymm19
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm10[23,u,u,u],zero,ymm10[26],zero,ymm10[24,u,u,u],zero,ymm10[27],zero
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa 32(%rdx), %ymm5
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [128,128,128,128,30,128,28,128,128,128,128,31,128,29,128,128,128,128,128,128,30,128,28,128,128,128,128,31,128,29,128,128]
; AVX512-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512-NEXT:    vpshufb %ymm1, %ymm5, %ymm2
; AVX512-NEXT:    vmovdqa 32(%rcx), %ymm4
; AVX512-NEXT:    vpshufb {{.*#+}} ymm3 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm4[25],zero,ymm4[23],zero,zero,zero,zero,ymm4[26],zero,ymm4[24],zero,zero,zero,zero
; AVX512-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [27,0,0,0,128,30,128,28,0,0,0,128,31,128,29,0,27,0,0,0,128,30,128,28,0,0,0,128,31,128,29,0]
; AVX512-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512-NEXT:    vpshufb %ymm0, %ymm4, %ymm2
; AVX512-NEXT:    vmovdqa64 %ymm0, %ymm21
; AVX512-NEXT:    vpshufb {{.*#+}} ymm3 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25],zero,ymm5[23],zero,ymm5[21,22,23,26],zero,ymm5[24],zero,ymm5[28,29,26,27]
; AVX512-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa 32(%r8), %ymm3
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [128,27,128,128,128,128,30,128,28,128,128,128,128,31,128,29,128,27,128,128,128,128,30,128,28,128,128,128,128,31,128,29]
; AVX512-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512-NEXT:    vpshufb %ymm0, %ymm3, %ymm11
; AVX512-NEXT:    vmovdqa64 %ymm0, %ymm25
; AVX512-NEXT:    vmovdqa 32(%r9), %ymm2
; AVX512-NEXT:    vpshufb {{.*#+}} ymm12 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero
; AVX512-NEXT:    vinserti64x4 $1, %ymm11, %zmm12, %zmm11
; AVX512-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm11 = [29,128,27,0,0,0,128,30,128,28,0,0,0,128,31,128,29,128,27,0,0,0,128,30,128,28,0,0,0,128,31,128]
; AVX512-NEXT:    # ymm11 = mem[0,1,0,1]
; AVX512-NEXT:    vpshufb %ymm11, %ymm2, %ymm12
; AVX512-NEXT:    vpshufb {{.*#+}} ymm13 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25],zero,ymm3[23],zero,ymm3[23,24,25,26],zero,ymm3[24],zero,ymm3[30,31]
; AVX512-NEXT:    vinserti64x4 $1, %ymm12, %zmm13, %zmm12
; AVX512-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa 32(%rax), %ymm0
; AVX512-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-NEXT:    vpshufb {{.*#+}} ymm12 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm13 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX512-NEXT:    vinserti64x4 $1, %ymm12, %zmm13, %zmm12
; AVX512-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpshufb %ymm6, %ymm7, %ymm6
; AVX512-NEXT:    vmovdqa64 %ymm7, %ymm22
; AVX512-NEXT:    vmovdqa64 %ymm20, %ymm7
; AVX512-NEXT:    vmovdqa64 %ymm19, %ymm0
; AVX512-NEXT:    vpshufb %ymm0, %ymm7, %ymm7
; AVX512-NEXT:    vpor %ymm6, %ymm7, %ymm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %ymm18, %ymm12
; AVX512-NEXT:    vpshufb %ymm1, %ymm12, %ymm6
; AVX512-NEXT:    vmovdqa64 %ymm21, %ymm0
; AVX512-NEXT:    vpshufb %ymm0, %ymm15, %ymm7
; AVX512-NEXT:    vmovdqa64 %ymm15, %ymm19
; AVX512-NEXT:    vpor %ymm6, %ymm7, %ymm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %ymm25, %ymm0
; AVX512-NEXT:    vpshufb %ymm0, %ymm14, %ymm6
; AVX512-NEXT:    vpshufb %ymm11, %ymm8, %ymm7
; AVX512-NEXT:    vmovdqa64 %ymm8, %ymm16
; AVX512-NEXT:    vpor %ymm6, %ymm7, %ymm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa 32(%rdx), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-NEXT:    vmovdqa 32(%rcx), %xmm1
; AVX512-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm11 = [u,u,u,128,7,128,5,u,u,u,128,8,128,6,u,u]
; AVX512-NEXT:    vpshufb %xmm11, %xmm1, %xmm6
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm1 = [u,u,u,7,128,5,128,u,u,u,8,128,6,128,u,u]
; AVX512-NEXT:    vpshufb %xmm1, %xmm0, %xmm7
; AVX512-NEXT:    vmovdqa64 %xmm1, %xmm21
; AVX512-NEXT:    vpor %xmm6, %xmm7, %xmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa 32(%rsi), %xmm15
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm6 = [u,128,7,128,5,u,u,u,128,8,128,6,u,u,u,128]
; AVX512-NEXT:    vpshufb %xmm6, %xmm15, %xmm7
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm13 = [u,7,128,5,128,u,u,u,8,128,6,128,u,u,u,9]
; AVX512-NEXT:    vpshufb %xmm13, %xmm0, %xmm8
; AVX512-NEXT:    vmovdqa64 %xmm0, %xmm30
; AVX512-NEXT:    vpor %xmm7, %xmm8, %xmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm28 = [0,0,0,0,2,3,0,1,0,18,0,19,18,0,19,0]
; AVX512-NEXT:    vmovdqa 32(%rax), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm0[0,1,2,3,4,5,5,6]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = xmm0[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512-NEXT:    vpermi2d %zmm7, %zmm8, %zmm28
; AVX512-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX512-NEXT:    vmovdqa 32(%r8), %xmm14
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm1 = [128,4,u,u,u,128,7,128,5,u,u,u,128,8,128,6]
; AVX512-NEXT:    vpshufb %xmm1, %xmm0, %xmm7
; AVX512-NEXT:    vmovdqa64 %xmm1, %xmm24
; AVX512-NEXT:    vmovdqa64 %xmm0, %xmm18
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,128,u,u,u,7,128,5,128,u,u,u,8,128,6,128]
; AVX512-NEXT:    vpshufb %xmm0, %xmm14, %xmm8
; AVX512-NEXT:    vmovdqa64 %xmm0, %xmm29
; AVX512-NEXT:    vporq %xmm7, %xmm8, %xmm31
; AVX512-NEXT:    vmovdqa64 %ymm23, %ymm0
; AVX512-NEXT:    vpshufb %ymm0, %ymm4, %ymm7
; AVX512-NEXT:    vmovdqa64 %ymm26, %ymm0
; AVX512-NEXT:    vpshufb %ymm0, %ymm5, %ymm8
; AVX512-NEXT:    vpor %ymm7, %ymm8, %ymm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20]
; AVX512-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512-NEXT:    vpshufb %ymm1, %ymm4, %ymm0
; AVX512-NEXT:    vmovdqa64 %ymm1, %ymm23
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [18,128,18,19,20,21,128,19,128,25,26,27,22,128,20,128,18,128,18,19,20,21,128,19,128,25,26,27,22,128,20,128]
; AVX512-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX512-NEXT:    vpshufb %ymm7, %ymm5, %ymm1
; AVX512-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,ymm10[14],zero,zero,zero,zero,zero,zero,ymm10[15],zero,zero,zero,zero,zero,zero,ymm10[16],zero,zero,zero,zero,zero,zero,ymm10[17],zero,zero,zero,zero,zero,zero,ymm10[18]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm9[0,1,14],zero,ymm9[12,13,0,1,14,15],zero,ymm9[3,12,13,2,3,16],zero,ymm9[30,31,28,29,16,17],zero,ymm9[31,18,19,28,29,18],zero
; AVX512-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128]
; AVX512-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512-NEXT:    vpshufb %ymm0, %ymm10, %ymm1
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm8 = [2,3,4,5,128,3,128,5,4,5,6,128,4,128,6,7,18,19,20,21,128,19,128,21,20,21,22,128,20,128,22,23]
; AVX512-NEXT:    vpshufb %ymm8, %ymm9, %ymm4
; AVX512-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX512-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22]
; AVX512-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512-NEXT:    vpshufb %ymm1, %ymm2, %ymm4
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [20,128,18,128,20,21,20,21,128,19,128,19,20,21,22,128,20,128,18,128,20,21,20,21,128,19,128,19,20,21,22,128]
; AVX512-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512-NEXT:    vpshufb %ymm9, %ymm3, %ymm5
; AVX512-NEXT:    vpor %ymm4, %ymm5, %ymm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %ymm27, %ymm4
; AVX512-NEXT:    vpshufb %ymm4, %ymm3, %ymm3
; AVX512-NEXT:    vmovdqa64 %ymm17, %ymm4
; AVX512-NEXT:    vpshufb %ymm4, %ymm2, %ymm2
; AVX512-NEXT:    vpor %ymm3, %ymm2, %ymm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa (%rsi), %xmm3
; AVX512-NEXT:    vpshufb %xmm6, %xmm3, %xmm2
; AVX512-NEXT:    vmovdqa64 %xmm3, %xmm25
; AVX512-NEXT:    vmovdqa (%rdi), %xmm4
; AVX512-NEXT:    vpshufb %xmm13, %xmm4, %xmm3
; AVX512-NEXT:    vmovdqa64 %xmm4, %xmm27
; AVX512-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512-NEXT:    vpshufb %xmm11, %xmm3, %xmm2
; AVX512-NEXT:    vmovdqa64 %xmm3, %xmm17
; AVX512-NEXT:    vmovdqa (%rdx), %xmm13
; AVX512-NEXT:    vmovdqa64 %xmm21, %xmm3
; AVX512-NEXT:    vpshufb %xmm3, %xmm13, %xmm3
; AVX512-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-NEXT:    vmovdqa (%r9), %xmm11
; AVX512-NEXT:    vmovdqa64 %xmm24, %xmm2
; AVX512-NEXT:    vpshufb %xmm2, %xmm11, %xmm2
; AVX512-NEXT:    vmovdqa (%r8), %xmm10
; AVX512-NEXT:    vmovdqa64 %xmm29, %xmm3
; AVX512-NEXT:    vpshufb %xmm3, %xmm10, %xmm3
; AVX512-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-NEXT:    vmovdqa64 %ymm20, %ymm4
; AVX512-NEXT:    vpshufb {{.*#+}} ymm2 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm4[23],zero,zero,zero,zero,ymm4[26],zero,ymm4[24],zero,zero,zero,zero,ymm4[27],zero,ymm4[25]
; AVX512-NEXT:    vmovdqa64 %ymm22, %ymm3
; AVX512-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm3[23,u,u,u],zero,ymm3[26],zero,ymm3[24,u,u,u],zero,ymm3[27],zero
; AVX512-NEXT:    vpshufb %ymm8, %ymm4, %ymm2
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm29
; AVX512-NEXT:    vmovdqa64 %ymm19, %ymm2
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero,zero,zero
; AVX512-NEXT:    vmovdqa64 %ymm23, %ymm3
; AVX512-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm26
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25],zero,ymm12[23],zero,ymm12[21,22,23,26],zero,ymm12[24],zero,ymm12[28,29,26,27]
; AVX512-NEXT:    vpshufb %ymm7, %ymm12, %ymm2
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm23
; AVX512-NEXT:    vmovdqa64 %ymm16, %ymm2
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero
; AVX512-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25],zero,ymm1[23],zero,ymm1[23,24,25,26],zero,ymm1[24],zero,ymm1[30,31]
; AVX512-NEXT:    vpshufb %ymm9, %ymm1, %ymm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa (%rax), %ymm8
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm16 = [0,5,4,0,5,0,4,0,20,21,0,23,0,21,0,23]
; AVX512-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm8[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm2, %zmm16
; AVX512-NEXT:    vmovdqa (%rax), %xmm5
; AVX512-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm5[0,1,2,3,4,5,5,6]
; AVX512-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX512-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm9 = [128,13,128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128]
; AVX512-NEXT:    vpshufb %ymm9, %ymm8, %ymm3
; AVX512-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm19
; AVX512-NEXT:    vmovdqa64 %xmm30, %xmm4
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm4[0],xmm15[0],xmm4[1],xmm15[1],xmm4[2],xmm15[2],xmm4[3],xmm15[3],xmm4[4],xmm15[4],xmm4[5],xmm15[5],xmm4[6],xmm15[6],xmm4[7],xmm15[7]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm0 = [0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512-NEXT:    vpshufb %xmm0, %xmm3, %xmm3
; AVX512-NEXT:    vmovdqa64 %xmm0, %xmm24
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm6 = zmm0[2,3,2,3],zmm3[0,1,0,1]
; AVX512-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX512-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm1[0],xmm7[0],xmm1[1],xmm7[1],xmm1[2],xmm7[2],xmm1[3],xmm7[3],xmm1[4],xmm7[4],xmm1[5],xmm7[5],xmm1[6],xmm7[6],xmm1[7],xmm7[7]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512-NEXT:    vpshufb %xmm0, %xmm3, %xmm3
; AVX512-NEXT:    vmovdqa64 %xmm0, %xmm21
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm22 = zmm0[2,3,2,3],zmm3[0,1,0,1]
; AVX512-NEXT:    vmovdqa64 %xmm18, %xmm2
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm12 = xmm14[0],xmm2[0],xmm14[1],xmm2[1],xmm14[2],xmm2[2],xmm14[3],xmm2[3],xmm14[4],xmm2[4],xmm14[5],xmm2[5],xmm14[6],xmm2[6],xmm14[7],xmm2[7]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm0 = [u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512-NEXT:    vpshufb %xmm0, %xmm12, %xmm12
; AVX512-NEXT:    vmovdqa64 %xmm0, %xmm20
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm30 = zmm0[2,3,2,3],zmm12[0,1,0,1]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX512-NEXT:    vmovdqa64 %ymm0, %ymm18
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm7[8],xmm1[8],xmm7[9],xmm1[9],xmm7[10],xmm1[10],xmm7[11],xmm1[11],xmm7[12],xmm1[12],xmm7[13],xmm1[13],xmm7[14],xmm1[14],xmm7[15],xmm1[15]
; AVX512-NEXT:    vmovdqa64 %xmm17, %xmm3
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm8 = xmm3[8],xmm13[8],xmm3[9],xmm13[9],xmm3[10],xmm13[10],xmm3[11],xmm13[11],xmm3[12],xmm13[12],xmm3[13],xmm13[13],xmm3[14],xmm13[14],xmm3[15],xmm13[15]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm1 = [6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512-NEXT:    vpshufb %xmm1, %xmm8, %xmm12
; AVX512-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vinserti32x4 $2, %xmm0, %zmm1, %zmm8
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm15[8],xmm4[8],xmm15[9],xmm4[9],xmm15[10],xmm4[10],xmm15[11],xmm4[11],xmm15[12],xmm4[12],xmm15[13],xmm4[13],xmm15[14],xmm4[14],xmm15[15],xmm4[15]
; AVX512-NEXT:    vmovdqa64 %xmm25, %xmm4
; AVX512-NEXT:    vmovdqa64 %xmm27, %xmm7
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm15 = xmm4[8],xmm7[8],xmm4[9],xmm7[9],xmm4[10],xmm7[10],xmm4[11],xmm7[11],xmm4[12],xmm7[12],xmm4[13],xmm7[13],xmm4[14],xmm7[14],xmm4[15],xmm7[15]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm0 = [2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512-NEXT:    vpshufb %xmm0, %xmm15, %xmm15
; AVX512-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vinserti32x4 $2, %xmm0, %zmm1, %zmm17
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm14[8],xmm2[8],xmm14[9],xmm2[9],xmm14[10],xmm2[10],xmm14[11],xmm2[11],xmm14[12],xmm2[12],xmm14[13],xmm2[13],xmm14[14],xmm2[14],xmm14[15],xmm2[15]
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm14 = xmm10[8],xmm11[8],xmm10[9],xmm11[9],xmm10[10],xmm11[10],xmm10[11],xmm11[11],xmm10[12],xmm11[12],xmm10[13],xmm11[13],xmm10[14],xmm11[14],xmm10[15],xmm11[15]
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm0 = [u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512-NEXT:    vpshufb %xmm0, %xmm14, %xmm14
; AVX512-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512-NEXT:    vinserti32x4 $2, %xmm0, %zmm31, %zmm31
; AVX512-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512-NEXT:    vpshufb %ymm9, %ymm0, %ymm1
; AVX512-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm0[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX512-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[0,1,1,3,4,5,5,7]
; AVX512-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,3,2]
; AVX512-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm9, %ymm9
; AVX512-NEXT:    vinserti64x4 $1, %ymm9, %zmm1, %zmm9
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; AVX512-NEXT:    vpternlogq $226, %zmm6, %zmm1, %zmm22
; AVX512-NEXT:    vpermq $238, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX512-NEXT:    # ymm6 = mem[2,3,2,3]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $1, %ymm6, %zmm0, %zmm6
; AVX512-NEXT:    vpermq $238, {{[-0-9]+}}(%r{{[sb]}}p), %ymm27 # 32-byte Folded Reload
; AVX512-NEXT:    # ymm27 = mem[2,3,2,3]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $1, %ymm27, %zmm0, %zmm27
; AVX512-NEXT:    vpternlogq $226, %zmm6, %zmm1, %zmm27
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm7[0],xmm4[0],xmm7[1],xmm4[1],xmm7[2],xmm4[2],xmm7[3],xmm4[3],xmm7[4],xmm4[4],xmm7[5],xmm4[5],xmm7[6],xmm4[6],xmm7[7],xmm4[7]
; AVX512-NEXT:    vmovdqa64 %xmm24, %xmm0
; AVX512-NEXT:    vpshufb %xmm0, %xmm1, %xmm1
; AVX512-NEXT:    vinserti32x4 $2, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm1 # 16-byte Folded Reload
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm6 = xmm13[0],xmm3[0],xmm13[1],xmm3[1],xmm13[2],xmm3[2],xmm13[3],xmm3[3],xmm13[4],xmm3[4],xmm13[5],xmm3[5],xmm13[6],xmm3[6],xmm13[7],xmm3[7]
; AVX512-NEXT:    vmovdqa64 %xmm21, %xmm0
; AVX512-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX512-NEXT:    vinserti32x4 $2, {{[-0-9]+}}(%r{{[sb]}}p), %zmm6, %zmm6 # 16-byte Folded Reload
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm10 = xmm10[0],xmm11[0],xmm10[1],xmm11[1],xmm10[2],xmm11[2],xmm10[3],xmm11[3],xmm10[4],xmm11[4],xmm10[5],xmm11[5],xmm10[6],xmm11[6],xmm10[7],xmm11[7]
; AVX512-NEXT:    vmovdqa64 %xmm20, %xmm0
; AVX512-NEXT:    vpshufb %xmm0, %xmm10, %xmm10
; AVX512-NEXT:    vinserti32x4 $2, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm10 # 16-byte Folded Reload
; AVX512-NEXT:    vpshufb {{.*#+}} xmm11 = xmm5[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[1,1,0,0,4,5,6,7]
; AVX512-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,1,2,0]
; AVX512-NEXT:    vinserti64x4 $1, %ymm11, %zmm5, %zmm5
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm11 # 64-byte Folded Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm13, %zmm13 # 64-byte Folded Reload
; AVX512-NEXT:    vpermq {{.*#+}} zmm11 = zmm11[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vpermq {{.*#+}} zmm13 = zmm13[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm11, %zmm13
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm11 # 64-byte Folded Reload
; AVX512-NEXT:    vpermq {{.*#+}} zmm11 = zmm11[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm21 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255]
; AVX512-NEXT:    vpternlogq $184, %zmm13, %zmm21, %zmm11
; AVX512-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[0,1,0,1,4,5,4,5]
; AVX512-NEXT:    vpermq {{.*#+}} zmm7 = zmm17[0,1,0,1,4,5,4,5]
; AVX512-NEXT:    vpternlogq $226, %zmm8, %zmm21, %zmm7
; AVX512-NEXT:    vpermq {{.*#+}} ymm8 = ymm15[0,1,0,1]
; AVX512-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,0,1]
; AVX512-NEXT:    vpermq {{.*#+}} ymm13 = ymm14[0,1,0,1]
; AVX512-NEXT:    vpermq {{.*#+}} ymm14 = ymm18[2,3,2,3]
; AVX512-NEXT:    vpshuflw $5, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX512-NEXT:    # xmm15 = mem[1,1,0,0,4,5,6,7]
; AVX512-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[0,1,2,0]
; AVX512-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm29, %zmm20 # 64-byte Folded Reload
; AVX512-NEXT:    vporq %zmm26, %zmm23, %zmm17
; AVX512-NEXT:    vpermq {{.*#+}} zmm18 = zmm20[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vpermq {{.*#+}} zmm17 = zmm17[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vpternlogq $226, %zmm18, %zmm21, %zmm17
; AVX512-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm8 # 32-byte Folded Reload
; AVX512-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm12, %zmm12 # 32-byte Folded Reload
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm12
; AVX512-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm13, %zmm8 # 32-byte Folded Reload
; AVX512-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm19
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm12, %zmm19
; AVX512-NEXT:    vpermq $238, {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm8 = mem[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm11, %zmm8
; AVX512-NEXT:    vpermq {{.*#+}} ymm11 = ymm15[0,0,1,0]
; AVX512-NEXT:    vinserti64x4 $1, %ymm11, %zmm14, %zmm11
; AVX512-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm30, %zmm11
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm22, %zmm11
; AVX512-NEXT:    vpermq {{.*#+}} zmm0 = zmm31[0,1,0,1,4,5,4,5]
; AVX512-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm28, %zmm0
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm7, %zmm0
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 $84, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm3 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm3 = zmm3[0,1,2,3],mem[2,3,2,3]
; AVX512-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm9
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm27, %zmm9
; AVX512-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[0,1,0,1,4,5,4,5]
; AVX512-NEXT:    vpermq {{.*#+}} zmm3 = zmm6[0,1,0,1,4,5,4,5]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm3
; AVX512-NEXT:    vpermq {{.*#+}} zmm1 = zmm10[0,1,0,1,4,5,4,5]
; AVX512-NEXT:    vpermq {{.*#+}} zmm5 = zmm5[0,0,1,0,4,4,5,4]
; AVX512-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm5
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm5
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm1 # 64-byte Folded Reload
; AVX512-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm16
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm17, %zmm16
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa64 %zmm16, 128(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512-NEXT:    vmovdqa64 %zmm9, 320(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm0, 256(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm11, 192(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm8, 384(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm19, 64(%rax)
; AVX512-NEXT:    addq $1384, %rsp # imm = 0x568
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i8_stride7_vf64:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    subq $1432, %rsp # imm = 0x598
; AVX512-FCP-NEXT:    vmovdqa 32(%rsi), %ymm3
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm3[30],zero,ymm3[28],zero,zero,zero,zero,ymm3[31],zero,ymm3[29],zero,zero,zero
; AVX512-FCP-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [128,23,128,128,128,128,26,128,24,128,128,128,128,27,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128,27,128,25]
; AVX512-FCP-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufb %ymm4, %ymm2, %ymm1
; AVX512-FCP-NEXT:    vmovdqa64 %ymm4, %ymm25
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,30],zero,ymm2[28],zero,ymm2[30,31,30,31],zero,ymm2[29],zero,ymm2[31,28,29]
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [25,128,23,0,0,0,128,26,128,24,0,0,0,128,27,128,25,128,23,0,0,0,128,26,128,24,0,0,0,128,27,128]
; AVX512-FCP-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufb %ymm2, %ymm3, %ymm1
; AVX512-FCP-NEXT:    vmovdqa64 %ymm2, %ymm16
; AVX512-FCP-NEXT:    vmovdqa64 %ymm3, %ymm27
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa 32(%rdx), %ymm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero,ymm1[29],zero,zero
; AVX512-FCP-NEXT:    vmovdqa %ymm1, %ymm2
; AVX512-FCP-NEXT:    vmovdqa 32(%rcx), %ymm15
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [128,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128,128,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128]
; AVX512-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufb %ymm3, %ymm15, %ymm1
; AVX512-FCP-NEXT:    vmovdqa64 %ymm3, %ymm29
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27,u,u,u],zero,ymm15[30],zero,ymm15[28,u,u,u],zero,ymm15[31],zero,ymm15[29,u]
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [24,25,128,23,128,21,22,23,26,128,24,128,28,29,26,27,24,25,128,23,128,21,22,23,26,128,24,128,28,29,26,27]
; AVX512-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufb %ymm3, %ymm2, %ymm1
; AVX512-FCP-NEXT:    vmovdqa64 %ymm3, %ymm31
; AVX512-FCP-NEXT:    vmovdqa64 %ymm2, %ymm26
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa 32(%r8), %ymm2
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm2[27],zero,zero,zero,zero,ymm2[30],zero,ymm2[28],zero,zero,zero,zero,ymm2[31],zero,ymm2[29]
; AVX512-FCP-NEXT:    vmovdqa 32(%r9), %ymm3
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [128,128,128,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128,128,128,25,128,23,128,128,128,128,26,128,24,128,128]
; AVX512-FCP-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufb %ymm4, %ymm3, %ymm1
; AVX512-FCP-NEXT:    vmovdqa64 %ymm4, %ymm21
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm3[27,u,u,u],zero,ymm3[30],zero,ymm3[28,u,u,u],zero,ymm3[31],zero
; AVX512-FCP-NEXT:    vmovdqa64 %ymm3, %ymm23
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [24,25,24,25,128,23,128,23,24,25,26,128,24,128,30,31,24,25,24,25,128,23,128,23,24,25,26,128,24,128,30,31]
; AVX512-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufb %ymm3, %ymm2, %ymm1
; AVX512-FCP-NEXT:    vmovdqa64 %ymm3, %ymm20
; AVX512-FCP-NEXT:    vmovdqa64 %ymm2, %ymm19
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    vmovdqa 32(%rax), %ymm1
; AVX512-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa (%rsi), %ymm6
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,ymm6[14],zero,zero,zero,zero,zero,zero,ymm6[15],zero,zero,zero,zero,zero,zero,ymm6[16],zero,zero,zero,zero,zero,zero,ymm6[17],zero,zero,zero,zero,zero,zero,ymm6[18]
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm5
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm5[0,1,14],zero,ymm5[12,13,0,1,14,15],zero,ymm5[3,12,13,2,3,16],zero,ymm5[30,31,28,29,16,17],zero,ymm5[31,18,19,28,29,18],zero
; AVX512-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-FCP-NEXT:    vmovdqa (%rcx), %ymm3
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,ymm3[14],zero,zero,zero,zero,zero,zero,ymm3[15],zero,zero,zero,zero,zero,zero,ymm3[16],zero,zero,zero,zero,zero,zero,ymm3[17],zero,zero,zero,zero,zero
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[0,1,0,1,14],zero,ymm2[14,15,0,1,14,15],zero,ymm2[13,14,15,16,17,16],zero,ymm2[30,31,30,31,16,17],zero,ymm2[31,28,29,30,31]
; AVX512-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-FCP-NEXT:    vmovdqa (%r8), %ymm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,zero,zero,ymm1[14],zero,zero,zero,zero,zero,zero,ymm1[15],zero,zero,zero,zero,zero,zero,ymm1[16],zero,zero,zero,zero,zero,zero,ymm1[17],zero,zero,zero,zero
; AVX512-FCP-NEXT:    vmovdqa (%r9), %ymm14
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm7 = ymm14[13,u,u,u,u,u],zero,ymm14[14,u,u,u,u,u],zero,ymm14[15,u,u,u,u,u],zero,ymm14[16,u,u,u,u,u],zero,ymm14[17,u,u,u]
; AVX512-FCP-NEXT:    vpor %ymm4, %ymm7, %ymm4
; AVX512-FCP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-FCP-NEXT:    vmovdqa 32(%rdx), %xmm9
; AVX512-FCP-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-FCP-NEXT:    vmovdqa 32(%rcx), %xmm0
; AVX512-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm4 = [u,u,u,128,7,128,5,u,u,u,128,8,128,6,u,u]
; AVX512-FCP-NEXT:    vpshufb %xmm4, %xmm0, %xmm7
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm8 = [u,u,u,7,128,5,128,u,u,u,8,128,6,128,u,u]
; AVX512-FCP-NEXT:    vpshufb %xmm8, %xmm9, %xmm9
; AVX512-FCP-NEXT:    vpor %xmm7, %xmm9, %xmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 32(%rsi), %xmm9
; AVX512-FCP-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm7 = [u,128,7,128,5,u,u,u,128,8,128,6,u,u,u,128]
; AVX512-FCP-NEXT:    vpshufb %xmm7, %xmm9, %xmm9
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm10 = [u,7,128,5,128,u,u,u,8,128,6,128,u,u,u,9]
; AVX512-FCP-NEXT:    vpshufb %xmm10, %xmm0, %xmm11
; AVX512-FCP-NEXT:    vmovdqa64 %xmm0, %xmm28
; AVX512-FCP-NEXT:    vpor %xmm9, %xmm11, %xmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa 32(%r9), %xmm9
; AVX512-FCP-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-FCP-NEXT:    vmovdqa 32(%r8), %xmm0
; AVX512-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm11 = [128,4,u,u,u,128,7,128,5,u,u,u,128,8,128,6]
; AVX512-FCP-NEXT:    vpshufb %xmm11, %xmm9, %xmm9
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm13 = [4,128,u,u,u,7,128,5,128,u,u,u,8,128,6,128]
; AVX512-FCP-NEXT:    vpshufb %xmm13, %xmm0, %xmm12
; AVX512-FCP-NEXT:    vpor %xmm9, %xmm12, %xmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa (%rsi), %xmm0
; AVX512-FCP-NEXT:    vpshufb %xmm7, %xmm0, %xmm7
; AVX512-FCP-NEXT:    vmovdqa64 %xmm0, %xmm24
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vpshufb %xmm10, %xmm0, %xmm10
; AVX512-FCP-NEXT:    vmovdqa64 %xmm0, %xmm17
; AVX512-FCP-NEXT:    vpor %xmm7, %xmm10, %xmm0
; AVX512-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-FCP-NEXT:    vmovdqa (%rcx), %xmm10
; AVX512-FCP-NEXT:    vpshufb %xmm4, %xmm10, %xmm4
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm9
; AVX512-FCP-NEXT:    vpshufb %xmm8, %xmm9, %xmm8
; AVX512-FCP-NEXT:    vpor %xmm4, %xmm8, %xmm0
; AVX512-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512-FCP-NEXT:    vmovdqa (%r9), %xmm8
; AVX512-FCP-NEXT:    vpshufb %xmm11, %xmm8, %xmm11
; AVX512-FCP-NEXT:    vmovdqa (%r8), %xmm7
; AVX512-FCP-NEXT:    vpshufb %xmm13, %xmm7, %xmm13
; AVX512-FCP-NEXT:    vporq %xmm11, %xmm13, %xmm30
; AVX512-FCP-NEXT:    vmovdqa64 %ymm25, %ymm0
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm5, %ymm11
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm12 = [128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128]
; AVX512-FCP-NEXT:    # ymm12 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufb %ymm12, %ymm6, %ymm13
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %ymm16, %ymm0
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm6, %ymm11
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [18,19,20,21,128,19,128,21,20,21,22,128,20,128,22,23,18,19,20,21,128,19,128,21,20,21,22,128,20,128,22,23]
; AVX512-FCP-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm5, %ymm13
; AVX512-FCP-NEXT:    vmovdqa64 %ymm0, %ymm22
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %ymm29, %ymm0
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm3, %ymm11
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20]
; AVX512-FCP-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm3, %ymm13
; AVX512-FCP-NEXT:    vmovdqa64 %ymm0, %ymm29
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %ymm31, %ymm0
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm2, %ymm11
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [18,128,18,19,20,21,128,19,128,25,26,27,22,128,20,128,18,128,18,19,20,21,128,19,128,25,26,27,22,128,20,128]
; AVX512-FCP-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufb %ymm4, %ymm2, %ymm13
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 %ymm21, %ymm0
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm14, %ymm11
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22]
; AVX512-FCP-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm14, %ymm13
; AVX512-FCP-NEXT:    vmovdqa64 %ymm0, %ymm18
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %ymm20, %ymm0
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm1, %ymm11
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [20,128,18,128,20,21,20,21,128,19,128,19,20,21,22,128,20,128,18,128,20,21,20,21,128,19,128,19,20,21,22,128]
; AVX512-FCP-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm1, %ymm13
; AVX512-FCP-NEXT:    vmovdqa64 %ymm0, %ymm16
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm6[30],zero,ymm6[28],zero,zero,zero,zero,ymm6[31],zero,ymm6[29],zero,zero,zero
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,30],zero,ymm5[28],zero,ymm5[30,31,30,31],zero,ymm5[29],zero,ymm5[31,28,29]
; AVX512-FCP-NEXT:    vporq %ymm6, %ymm5, %ymm20
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm2[30],zero,ymm2[28],zero,zero,zero,zero,ymm2[31],zero,ymm2[29],zero,zero
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27,u,u,u],zero,ymm3[30],zero,ymm3[28,u,u,u],zero,ymm3[31],zero,ymm3[29,u]
; AVX512-FCP-NEXT:    vpor %ymm2, %ymm3, %ymm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm1[27],zero,zero,zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero,ymm1[29]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm14[27,u,u,u],zero,ymm14[30],zero,ymm14[28,u,u,u],zero,ymm14[31],zero
; AVX512-FCP-NEXT:    vporq %ymm1, %ymm0, %ymm21
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,ymm15[14],zero,zero,zero,zero,zero,zero,ymm15[15],zero,zero,zero,zero,zero,zero,ymm15[16],zero,zero,zero,zero,zero,zero,ymm15[17],zero,zero,zero,zero,zero
; AVX512-FCP-NEXT:    vmovdqa64 %ymm26, %ymm2
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[0,1,0,1,14],zero,ymm2[14,15,0,1,14,15],zero,ymm2[13,14,15,16,17,16],zero,ymm2[30,31,30,31,16,17],zero,ymm2[31,28,29,30,31]
; AVX512-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %ymm29, %ymm0
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm15, %ymm0
; AVX512-FCP-NEXT:    vpshufb %ymm4, %ymm2, %ymm1
; AVX512-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %ymm27, %ymm3
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,ymm3[14],zero,zero,zero,zero,zero,zero,ymm3[15],zero,zero,zero,zero,zero,zero,ymm3[16],zero,zero,zero,zero,zero,zero,ymm3[17],zero,zero,zero,zero,zero,zero,ymm3[18]
; AVX512-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[0,1,14],zero,ymm2[12,13,0,1,14,15],zero,ymm2[3,12,13,2,3,16],zero,ymm2[30,31,28,29,16,17],zero,ymm2[31,18,19,28,29,18],zero
; AVX512-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpshufb %ymm12, %ymm3, %ymm0
; AVX512-FCP-NEXT:    vmovdqa64 %ymm22, %ymm1
; AVX512-FCP-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512-FCP-NEXT:    vporq %ymm0, %ymm1, %ymm29
; AVX512-FCP-NEXT:    vmovdqa64 %ymm23, %ymm2
; AVX512-FCP-NEXT:    vmovdqa64 %ymm18, %ymm0
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX512-FCP-NEXT:    vmovdqa64 %ymm19, %ymm3
; AVX512-FCP-NEXT:    vmovdqa64 %ymm16, %ymm1
; AVX512-FCP-NEXT:    vpshufb %ymm1, %ymm3, %ymm1
; AVX512-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,ymm3[14],zero,zero,zero,zero,zero,zero,ymm3[15],zero,zero,zero,zero,zero,zero,ymm3[16],zero,zero,zero,zero,zero,zero,ymm3[17],zero,zero,zero,zero
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[13,u,u,u,u,u],zero,ymm2[14,u,u,u,u,u],zero,ymm2[15,u,u,u,u,u],zero,ymm2[16,u,u,u,u,u],zero,ymm2[17,u,u,u]
; AVX512-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa (%rax), %xmm1
; AVX512-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [2,2,3,3,2,2,3,3]
; AVX512-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512-FCP-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm1[0,1,2,3,4,5,5,6]
; AVX512-FCP-NEXT:    vmovdqa64 %xmm1, %xmm23
; AVX512-FCP-NEXT:    vpermd %ymm0, %ymm3, %ymm0
; AVX512-FCP-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-FCP-NEXT:    vmovdqa (%rax), %ymm15
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,ymm15[13],zero,zero,zero,zero,zero,zero,ymm15[14],zero,zero,zero,zero,zero,zero,ymm15[15],zero,zero,zero,zero,zero,zero,ymm15[16],zero,zero,zero,zero,zero,zero,ymm15[17],zero,zero
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm18
; AVX512-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm10[8],xmm9[8],xmm10[9],xmm9[9],xmm10[10],xmm9[10],xmm10[11],xmm9[11],xmm10[12],xmm9[12],xmm10[13],xmm9[13],xmm10[14],xmm9[14],xmm10[15],xmm9[15]
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm5 = [6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512-FCP-NEXT:    vpshufb %xmm5, %xmm0, %xmm0
; AVX512-FCP-NEXT:    vmovdqa64 %ymm0, %ymm27
; AVX512-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 {{[-0-9]+}}(%r{{[sb]}}p), %xmm16 # 16-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %xmm16, %xmm1
; AVX512-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm12[8],xmm1[8],xmm12[9],xmm1[9],xmm12[10],xmm1[10],xmm12[11],xmm1[11],xmm12[12],xmm1[12],xmm12[13],xmm1[13],xmm12[14],xmm1[14],xmm12[15],xmm1[15]
; AVX512-FCP-NEXT:    vpshufb %xmm5, %xmm0, %xmm0
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti32x4 $2, %xmm0, %zmm1, %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 %xmm24, %xmm4
; AVX512-FCP-NEXT:    vmovdqa64 %xmm17, %xmm1
; AVX512-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm4[8],xmm1[8],xmm4[9],xmm1[9],xmm4[10],xmm1[10],xmm4[11],xmm1[11],xmm4[12],xmm1[12],xmm4[13],xmm1[13],xmm4[14],xmm1[14],xmm4[15],xmm1[15]
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm2 = [2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512-FCP-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX512-FCP-NEXT:    vmovdqa64 %ymm0, %ymm24
; AVX512-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %xmm28, %xmm5
; AVX512-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm13[8],xmm5[8],xmm13[9],xmm5[9],xmm13[10],xmm5[10],xmm13[11],xmm5[11],xmm13[12],xmm5[12],xmm13[13],xmm5[13],xmm13[14],xmm5[14],xmm13[15],xmm5[15]
; AVX512-FCP-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti32x4 $2, %xmm0, %zmm2, %zmm17
; AVX512-FCP-NEXT:    vmovdqa 32(%rax), %xmm6
; AVX512-FCP-NEXT:    vpshufhw {{.*#+}} xmm14 = xmm6[0,1,2,3,4,5,5,6]
; AVX512-FCP-NEXT:    vpermd %ymm14, %ymm3, %ymm31
; AVX512-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm7[8],xmm8[8],xmm7[9],xmm8[9],xmm7[10],xmm8[10],xmm7[11],xmm8[11],xmm7[12],xmm8[12],xmm7[13],xmm8[13],xmm7[14],xmm8[14],xmm7[15],xmm8[15]
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm14 = [u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512-FCP-NEXT:    vpshufb %xmm14, %xmm3, %xmm0
; AVX512-FCP-NEXT:    vmovdqa64 %ymm0, %ymm22
; AVX512-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX512-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX512-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm11 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; AVX512-FCP-NEXT:    vpshufb %xmm14, %xmm11, %xmm11
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti32x4 $2, %xmm11, %zmm3, %zmm28
; AVX512-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3],xmm1[4],xmm4[4],xmm1[5],xmm4[5],xmm1[6],xmm4[6],xmm1[7],xmm4[7]
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm14 = [0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512-FCP-NEXT:    vpshufb %xmm14, %xmm11, %xmm11
; AVX512-FCP-NEXT:    vinserti32x4 $2, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm26 # 16-byte Folded Reload
; AVX512-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm9 = xmm9[0],xmm10[0],xmm9[1],xmm10[1],xmm9[2],xmm10[2],xmm9[3],xmm10[3],xmm9[4],xmm10[4],xmm9[5],xmm10[5],xmm9[6],xmm10[6],xmm9[7],xmm10[7]
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512-FCP-NEXT:    vpshufb %xmm3, %xmm9, %xmm9
; AVX512-FCP-NEXT:    vinserti32x4 $2, {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm9 # 16-byte Folded Reload
; AVX512-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3],xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm11 = [u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512-FCP-NEXT:    vpshufb %xmm11, %xmm7, %xmm7
; AVX512-FCP-NEXT:    vinserti32x4 $2, %xmm30, %zmm7, %zmm7
; AVX512-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm8 = xmm5[0],xmm13[0],xmm5[1],xmm13[1],xmm5[2],xmm13[2],xmm5[3],xmm13[3],xmm5[4],xmm13[4],xmm5[5],xmm13[5],xmm5[6],xmm13[6],xmm5[7],xmm13[7]
; AVX512-FCP-NEXT:    vpshufb %xmm14, %xmm8, %xmm8
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm20[2,3,2,3],zmm8[0,1,0,1]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512-FCP-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm8 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512-FCP-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm13, %zmm20 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm20 = zmm20[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm20
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512-FCP-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm8 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm30 = zmm8[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255]
; AVX512-FCP-NEXT:    vpternlogq $184, %zmm20, %zmm8, %zmm30
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm5 = zmm19[0,1,0,1,4,5,4,5]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm20 = zmm17[0,1,0,1,4,5,4,5]
; AVX512-FCP-NEXT:    vpternlogq $226, %zmm5, %zmm8, %zmm20
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm1 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm25, %zmm5 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm25 = zmm1[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm1 = zmm5[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vpternlogq $226, %zmm25, %zmm8, %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %xmm16, %xmm4
; AVX512-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm5 = xmm4[0],xmm12[0],xmm4[1],xmm12[1],xmm4[2],xmm12[2],xmm4[3],xmm12[3],xmm4[4],xmm12[4],xmm4[5],xmm12[5],xmm4[6],xmm12[6],xmm4[7],xmm12[7]
; AVX512-FCP-NEXT:    vpshufb %xmm3, %xmm5, %xmm5
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm10 = zmm3[2,3,2,3],zmm5[0,1,0,1]
; AVX512-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm5 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; AVX512-FCP-NEXT:    vpshufb %xmm11, %xmm5, %xmm5
; AVX512-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; AVX512-FCP-NEXT:    vpternlogq $226, %zmm14, %zmm8, %zmm10
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm21 = zmm21[2,3,2,3],zmm5[0,1,0,1]
; AVX512-FCP-NEXT:    vpermq $238, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX512-FCP-NEXT:    # ymm11 = mem[2,3,2,3]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm0, %zmm11
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm14 = ymm29[2,3,2,3]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm14, %zmm0, %zmm14
; AVX512-FCP-NEXT:    vpternlogq $226, %zmm11, %zmm8, %zmm14
; AVX512-FCP-NEXT:    vmovdqa64 %xmm23, %xmm0
; AVX512-FCP-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm0[1,1,0,0,4,5,6,7]
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm11 = [0,1,0,1,2,0,0,1]
; AVX512-FCP-NEXT:    vpermd %ymm8, %ymm11, %ymm16
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm5 = [4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512-FCP-NEXT:    vpshufb %xmm5, %xmm0, %xmm12
; AVX512-FCP-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; AVX512-FCP-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm6[1,1,0,0,4,5,6,7]
; AVX512-FCP-NEXT:    vpermd %ymm0, %ymm11, %ymm2
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX512-FCP-NEXT:    vpshuflw {{.*#+}} ymm15 = ymm15[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm17 = [4,5,4,5,5,7,4,5]
; AVX512-FCP-NEXT:    vpermd %ymm15, %ymm17, %ymm15
; AVX512-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = zero,ymm13[13],zero,zero,zero,zero,zero,zero,ymm13[14],zero,zero,zero,zero,zero,zero,ymm13[15],zero,zero,zero,zero,zero,zero,ymm13[16],zero,zero,zero,zero,zero,zero,ymm13[17],zero,zero
; AVX512-FCP-NEXT:    vpshuflw {{.*#+}} ymm13 = ymm13[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX512-FCP-NEXT:    vpermd %ymm13, %ymm17, %ymm13
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm24[0,1,0,1]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm17 = ymm27[0,1,0,1]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm22[0,1,0,1]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,1,0]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm12[0,0,1,0]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512-FCP-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm13, %ymm13
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm13, %zmm8, %zmm8
; AVX512-FCP-NEXT:    vpermq $238, {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm13 = mem[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm30, %zmm13
; AVX512-FCP-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm6, %zmm6 # 32-byte Folded Reload
; AVX512-FCP-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm17, %zmm17 # 32-byte Folded Reload
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm6, %zmm17
; AVX512-FCP-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm3 # 32-byte Folded Reload
; AVX512-FCP-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm18
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm17, %zmm18
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm31, %zmm5, %zmm3
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm5 = zmm28[0,1,0,1,4,5,4,5]
; AVX512-FCP-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm5
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm20, %zmm5
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm3 = zmm26[0,1,0,1,4,5,4,5]
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm6 = zmm9[0,1,0,1,4,5,4,5]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm6
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm4, %zmm16, %zmm3
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm4 = zmm7[0,1,0,1,4,5,4,5]
; AVX512-FCP-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm4
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm6, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm3 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm15, %zmm6
; AVX512-FCP-NEXT:    vpermq {{.*#+}} zmm3 = zmm3[2,3,2,3,6,7,6,7]
; AVX512-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm6
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm6
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm21, %zmm0
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm10, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vshufi64x2 $84, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm1 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm1 = zmm1[0,1,2,3],mem[2,3,2,3]
; AVX512-FCP-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm8
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm14, %zmm8
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, 320(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 256(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, 64(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, 384(%rax)
; AVX512-FCP-NEXT:    addq $1432, %rsp # imm = 0x598
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i8_stride7_vf64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    subq $1384, %rsp # imm = 0x568
; AVX512DQ-NEXT:    vmovdqa (%rsi), %ymm7
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,ymm7[14],zero,zero,zero,zero,zero,zero,ymm7[15],zero,zero,zero,zero,zero,zero,ymm7[16],zero,zero,zero,zero,zero,zero,ymm7[17],zero,zero,zero,zero,zero,zero,ymm7[18]
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm2
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[0,1,14],zero,ymm2[12,13,0,1,14,15],zero,ymm2[3,12,13,2,3,16],zero,ymm2[30,31,28,29,16,17],zero,ymm2[31,18,19,28,29,18],zero
; AVX512DQ-NEXT:    vmovdqa64 %ymm2, %ymm20
; AVX512DQ-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-NEXT:    vmovdqa (%rcx), %ymm15
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128]
; AVX512DQ-NEXT:    vpshufb %ymm2, %ymm15, %ymm0
; AVX512DQ-NEXT:    vmovdqa64 %ymm2, %ymm23
; AVX512DQ-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,0,1,14,128,14,15,0,1,14,15,128,13,14,15,16,17,16,128,30,31,30,31,16,17,128,31,28,29,30,31]
; AVX512DQ-NEXT:    vpshufb %ymm3, %ymm2, %ymm1
; AVX512DQ-NEXT:    vmovdqa64 %ymm3, %ymm26
; AVX512DQ-NEXT:    vmovdqa64 %ymm2, %ymm18
; AVX512DQ-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-NEXT:    vmovdqa (%r8), %ymm14
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128]
; AVX512DQ-NEXT:    vpshufb %ymm2, %ymm14, %ymm0
; AVX512DQ-NEXT:    vmovdqa64 %ymm2, %ymm27
; AVX512DQ-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-NEXT:    vmovdqa (%r9), %ymm8
; AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [13,0,0,0,128,16,128,14,0,0,0,128,17,128,15,0,13,0,0,0,128,16,128,14,0,0,0,128,17,128,15,0]
; AVX512DQ-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512DQ-NEXT:    vpshufb %ymm3, %ymm8, %ymm1
; AVX512DQ-NEXT:    vmovdqa64 %ymm3, %ymm17
; AVX512DQ-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-NEXT:    vmovdqa 32(%rsi), %ymm10
; AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [128,128,128,30,128,28,128,128,128,128,31,128,29,128,128,128,128,128,128,30,128,28,128,128,128,128,31,128,29,128,128,128]
; AVX512DQ-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX512DQ-NEXT:    vpshufb %ymm6, %ymm10, %ymm0
; AVX512DQ-NEXT:    vmovdqa 32(%rdi), %ymm9
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm9[23],zero,zero,zero,zero,ymm9[26],zero,ymm9[24],zero,zero,zero,zero,ymm9[27],zero,ymm9[25]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm1 = [12,13,14,128,12,128,14,15,14,15,128,13,128,15,12,13,28,29,30,128,28,128,30,31,30,31,128,29,128,31,28,29]
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm9, %ymm0
; AVX512DQ-NEXT:    vmovdqa64 %ymm1, %ymm19
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm10[23,u,u,u],zero,ymm10[26],zero,ymm10[24,u,u,u],zero,ymm10[27],zero
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa 32(%rdx), %ymm5
; AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [128,128,128,128,30,128,28,128,128,128,128,31,128,29,128,128,128,128,128,128,30,128,28,128,128,128,128,31,128,29,128,128]
; AVX512DQ-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm5, %ymm2
; AVX512DQ-NEXT:    vmovdqa 32(%rcx), %ymm4
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm3 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm4[25],zero,ymm4[23],zero,zero,zero,zero,ymm4[26],zero,ymm4[24],zero,zero,zero,zero
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [27,0,0,0,128,30,128,28,0,0,0,128,31,128,29,0,27,0,0,0,128,30,128,28,0,0,0,128,31,128,29,0]
; AVX512DQ-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm4, %ymm2
; AVX512DQ-NEXT:    vmovdqa64 %ymm0, %ymm21
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm3 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25],zero,ymm5[23],zero,ymm5[21,22,23,26],zero,ymm5[24],zero,ymm5[28,29,26,27]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa 32(%r8), %ymm3
; AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [128,27,128,128,128,128,30,128,28,128,128,128,128,31,128,29,128,27,128,128,128,128,30,128,28,128,128,128,128,31,128,29]
; AVX512DQ-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm11
; AVX512DQ-NEXT:    vmovdqa64 %ymm0, %ymm25
; AVX512DQ-NEXT:    vmovdqa 32(%r9), %ymm2
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm12 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm11, %zmm12, %zmm11
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm11 = [29,128,27,0,0,0,128,30,128,28,0,0,0,128,31,128,29,128,27,0,0,0,128,30,128,28,0,0,0,128,31,128]
; AVX512DQ-NEXT:    # ymm11 = mem[0,1,0,1]
; AVX512DQ-NEXT:    vpshufb %ymm11, %ymm2, %ymm12
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm13 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25],zero,ymm3[23],zero,ymm3[23,24,25,26],zero,ymm3[24],zero,ymm3[30,31]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm12, %zmm13, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    vmovdqa 32(%rax), %ymm0
; AVX512DQ-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm12 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm13 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm12, %zmm13, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpshufb %ymm6, %ymm7, %ymm6
; AVX512DQ-NEXT:    vmovdqa64 %ymm7, %ymm22
; AVX512DQ-NEXT:    vmovdqa64 %ymm20, %ymm7
; AVX512DQ-NEXT:    vmovdqa64 %ymm19, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm7, %ymm7
; AVX512DQ-NEXT:    vpor %ymm6, %ymm7, %ymm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %ymm18, %ymm12
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm12, %ymm6
; AVX512DQ-NEXT:    vmovdqa64 %ymm21, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm15, %ymm7
; AVX512DQ-NEXT:    vmovdqa64 %ymm15, %ymm19
; AVX512DQ-NEXT:    vpor %ymm6, %ymm7, %ymm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %ymm25, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm14, %ymm6
; AVX512DQ-NEXT:    vpshufb %ymm11, %ymm8, %ymm7
; AVX512DQ-NEXT:    vmovdqa64 %ymm8, %ymm16
; AVX512DQ-NEXT:    vpor %ymm6, %ymm7, %ymm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa 32(%rdx), %xmm0
; AVX512DQ-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-NEXT:    vmovdqa 32(%rcx), %xmm1
; AVX512DQ-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm11 = [u,u,u,128,7,128,5,u,u,u,128,8,128,6,u,u]
; AVX512DQ-NEXT:    vpshufb %xmm11, %xmm1, %xmm6
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm1 = [u,u,u,7,128,5,128,u,u,u,8,128,6,128,u,u]
; AVX512DQ-NEXT:    vpshufb %xmm1, %xmm0, %xmm7
; AVX512DQ-NEXT:    vmovdqa64 %xmm1, %xmm21
; AVX512DQ-NEXT:    vpor %xmm6, %xmm7, %xmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX512DQ-NEXT:    vmovdqa 32(%rsi), %xmm15
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm6 = [u,128,7,128,5,u,u,u,128,8,128,6,u,u,u,128]
; AVX512DQ-NEXT:    vpshufb %xmm6, %xmm15, %xmm7
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm13 = [u,7,128,5,128,u,u,u,8,128,6,128,u,u,u,9]
; AVX512DQ-NEXT:    vpshufb %xmm13, %xmm0, %xmm8
; AVX512DQ-NEXT:    vmovdqa64 %xmm0, %xmm30
; AVX512DQ-NEXT:    vpor %xmm7, %xmm8, %xmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm28 = [0,0,0,0,2,3,0,1,0,18,0,19,18,0,19,0]
; AVX512DQ-NEXT:    vmovdqa 32(%rax), %xmm0
; AVX512DQ-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm0[0,1,2,3,4,5,5,6]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm8 = xmm0[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512DQ-NEXT:    vpermi2d %zmm7, %zmm8, %zmm28
; AVX512DQ-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX512DQ-NEXT:    vmovdqa 32(%r8), %xmm14
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm1 = [128,4,u,u,u,128,7,128,5,u,u,u,128,8,128,6]
; AVX512DQ-NEXT:    vpshufb %xmm1, %xmm0, %xmm7
; AVX512DQ-NEXT:    vmovdqa64 %xmm1, %xmm24
; AVX512DQ-NEXT:    vmovdqa64 %xmm0, %xmm18
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,128,u,u,u,7,128,5,128,u,u,u,8,128,6,128]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm14, %xmm8
; AVX512DQ-NEXT:    vmovdqa64 %xmm0, %xmm29
; AVX512DQ-NEXT:    vporq %xmm7, %xmm8, %xmm31
; AVX512DQ-NEXT:    vmovdqa64 %ymm23, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm4, %ymm7
; AVX512DQ-NEXT:    vmovdqa64 %ymm26, %ymm0
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm5, %ymm8
; AVX512DQ-NEXT:    vpor %ymm7, %ymm8, %ymm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20]
; AVX512DQ-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm4, %ymm0
; AVX512DQ-NEXT:    vmovdqa64 %ymm1, %ymm23
; AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [18,128,18,19,20,21,128,19,128,25,26,27,22,128,20,128,18,128,18,19,20,21,128,19,128,25,26,27,22,128,20,128]
; AVX512DQ-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX512DQ-NEXT:    vpshufb %ymm7, %ymm5, %ymm1
; AVX512DQ-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,ymm10[14],zero,zero,zero,zero,zero,zero,ymm10[15],zero,zero,zero,zero,zero,zero,ymm10[16],zero,zero,zero,zero,zero,zero,ymm10[17],zero,zero,zero,zero,zero,zero,ymm10[18]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm9[0,1,14],zero,ymm9[12,13,0,1,14,15],zero,ymm9[3,12,13,2,3,16],zero,ymm9[30,31,28,29,16,17],zero,ymm9[31,18,19,28,29,18],zero
; AVX512DQ-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128]
; AVX512DQ-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm10, %ymm1
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm8 = [2,3,4,5,128,3,128,5,4,5,6,128,4,128,6,7,18,19,20,21,128,19,128,21,20,21,22,128,20,128,22,23]
; AVX512DQ-NEXT:    vpshufb %ymm8, %ymm9, %ymm4
; AVX512DQ-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX512DQ-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22]
; AVX512DQ-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm4
; AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [20,128,18,128,20,21,20,21,128,19,128,19,20,21,22,128,20,128,18,128,20,21,20,21,128,19,128,19,20,21,22,128]
; AVX512DQ-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512DQ-NEXT:    vpshufb %ymm9, %ymm3, %ymm5
; AVX512DQ-NEXT:    vpor %ymm4, %ymm5, %ymm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %ymm27, %ymm4
; AVX512DQ-NEXT:    vpshufb %ymm4, %ymm3, %ymm3
; AVX512DQ-NEXT:    vmovdqa64 %ymm17, %ymm4
; AVX512DQ-NEXT:    vpshufb %ymm4, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpor %ymm3, %ymm2, %ymm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa (%rsi), %xmm3
; AVX512DQ-NEXT:    vpshufb %xmm6, %xmm3, %xmm2
; AVX512DQ-NEXT:    vmovdqa64 %xmm3, %xmm25
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm4
; AVX512DQ-NEXT:    vpshufb %xmm13, %xmm4, %xmm3
; AVX512DQ-NEXT:    vmovdqa64 %xmm4, %xmm27
; AVX512DQ-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQ-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512DQ-NEXT:    vpshufb %xmm11, %xmm3, %xmm2
; AVX512DQ-NEXT:    vmovdqa64 %xmm3, %xmm17
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm13
; AVX512DQ-NEXT:    vmovdqa64 %xmm21, %xmm3
; AVX512DQ-NEXT:    vpshufb %xmm3, %xmm13, %xmm3
; AVX512DQ-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQ-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-NEXT:    vmovdqa (%r9), %xmm11
; AVX512DQ-NEXT:    vmovdqa64 %xmm24, %xmm2
; AVX512DQ-NEXT:    vpshufb %xmm2, %xmm11, %xmm2
; AVX512DQ-NEXT:    vmovdqa (%r8), %xmm10
; AVX512DQ-NEXT:    vmovdqa64 %xmm29, %xmm3
; AVX512DQ-NEXT:    vpshufb %xmm3, %xmm10, %xmm3
; AVX512DQ-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQ-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %ymm20, %ymm4
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm2 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm4[23],zero,zero,zero,zero,ymm4[26],zero,ymm4[24],zero,zero,zero,zero,ymm4[27],zero,ymm4[25]
; AVX512DQ-NEXT:    vmovdqa64 %ymm22, %ymm3
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,ymm3[23,u,u,u],zero,ymm3[26],zero,ymm3[24,u,u,u],zero,ymm3[27],zero
; AVX512DQ-NEXT:    vpshufb %ymm8, %ymm4, %ymm2
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm29
; AVX512DQ-NEXT:    vmovdqa64 %ymm19, %ymm2
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero,zero,zero
; AVX512DQ-NEXT:    vmovdqa64 %ymm23, %ymm3
; AVX512DQ-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm26
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25],zero,ymm12[23],zero,ymm12[21,22,23,26],zero,ymm12[24],zero,ymm12[28,29,26,27]
; AVX512DQ-NEXT:    vpshufb %ymm7, %ymm12, %ymm2
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm23
; AVX512DQ-NEXT:    vmovdqa64 %ymm16, %ymm2
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm2[25],zero,ymm2[23],zero,zero,zero,zero,ymm2[26],zero,ymm2[24],zero,zero
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25],zero,ymm1[23],zero,ymm1[23,24,25,26],zero,ymm1[24],zero,ymm1[30,31]
; AVX512DQ-NEXT:    vpshufb %ymm9, %ymm1, %ymm1
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa (%rax), %ymm8
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm16 = [0,5,4,0,5,0,4,0,20,21,0,23,0,21,0,23]
; AVX512DQ-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm8[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm2, %zmm16
; AVX512DQ-NEXT:    vmovdqa (%rax), %xmm5
; AVX512DQ-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm5[0,1,2,3,4,5,5,6]
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX512DQ-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm9 = [128,13,128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128]
; AVX512DQ-NEXT:    vpshufb %ymm9, %ymm8, %ymm3
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm19
; AVX512DQ-NEXT:    vmovdqa64 %xmm30, %xmm4
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm4[0],xmm15[0],xmm4[1],xmm15[1],xmm4[2],xmm15[2],xmm4[3],xmm15[3],xmm4[4],xmm15[4],xmm4[5],xmm15[5],xmm4[6],xmm15[6],xmm4[7],xmm15[7]
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm0 = [0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm3, %xmm3
; AVX512DQ-NEXT:    vmovdqa64 %xmm0, %xmm24
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm6 = zmm0[2,3,2,3],zmm3[0,1,0,1]
; AVX512DQ-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX512DQ-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm1[0],xmm7[0],xmm1[1],xmm7[1],xmm1[2],xmm7[2],xmm1[3],xmm7[3],xmm1[4],xmm7[4],xmm1[5],xmm7[5],xmm1[6],xmm7[6],xmm1[7],xmm7[7]
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm3, %xmm3
; AVX512DQ-NEXT:    vmovdqa64 %xmm0, %xmm21
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm22 = zmm0[2,3,2,3],zmm3[0,1,0,1]
; AVX512DQ-NEXT:    vmovdqa64 %xmm18, %xmm2
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} xmm12 = xmm14[0],xmm2[0],xmm14[1],xmm2[1],xmm14[2],xmm2[2],xmm14[3],xmm2[3],xmm14[4],xmm2[4],xmm14[5],xmm2[5],xmm14[6],xmm2[6],xmm14[7],xmm2[7]
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm0 = [u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm12, %xmm12
; AVX512DQ-NEXT:    vmovdqa64 %xmm0, %xmm20
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm30 = zmm0[2,3,2,3],zmm12[0,1,0,1]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX512DQ-NEXT:    vmovdqa64 %ymm0, %ymm18
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm7[8],xmm1[8],xmm7[9],xmm1[9],xmm7[10],xmm1[10],xmm7[11],xmm1[11],xmm7[12],xmm1[12],xmm7[13],xmm1[13],xmm7[14],xmm1[14],xmm7[15],xmm1[15]
; AVX512DQ-NEXT:    vmovdqa64 %xmm17, %xmm3
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} xmm8 = xmm3[8],xmm13[8],xmm3[9],xmm13[9],xmm3[10],xmm13[10],xmm3[11],xmm13[11],xmm3[12],xmm13[12],xmm3[13],xmm13[13],xmm3[14],xmm13[14],xmm3[15],xmm13[15]
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm1 = [6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512DQ-NEXT:    vpshufb %xmm1, %xmm8, %xmm12
; AVX512DQ-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti32x4 $2, %xmm0, %zmm1, %zmm8
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm15[8],xmm4[8],xmm15[9],xmm4[9],xmm15[10],xmm4[10],xmm15[11],xmm4[11],xmm15[12],xmm4[12],xmm15[13],xmm4[13],xmm15[14],xmm4[14],xmm15[15],xmm4[15]
; AVX512DQ-NEXT:    vmovdqa64 %xmm25, %xmm4
; AVX512DQ-NEXT:    vmovdqa64 %xmm27, %xmm7
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} xmm15 = xmm4[8],xmm7[8],xmm4[9],xmm7[9],xmm4[10],xmm7[10],xmm4[11],xmm7[11],xmm4[12],xmm7[12],xmm4[13],xmm7[13],xmm4[14],xmm7[14],xmm4[15],xmm7[15]
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm0 = [2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm15, %xmm15
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti32x4 $2, %xmm0, %zmm1, %zmm17
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm14[8],xmm2[8],xmm14[9],xmm2[9],xmm14[10],xmm2[10],xmm14[11],xmm2[11],xmm14[12],xmm2[12],xmm14[13],xmm2[13],xmm14[14],xmm2[14],xmm14[15],xmm2[15]
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} xmm14 = xmm10[8],xmm11[8],xmm10[9],xmm11[9],xmm10[10],xmm11[10],xmm10[11],xmm11[11],xmm10[12],xmm11[12],xmm10[13],xmm11[13],xmm10[14],xmm11[14],xmm10[15],xmm11[15]
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm0 = [u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm14, %xmm14
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512DQ-NEXT:    vinserti32x4 $2, %xmm0, %zmm31, %zmm31
; AVX512DQ-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-NEXT:    vpshufb %ymm9, %ymm0, %ymm1
; AVX512DQ-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm0[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX512DQ-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[0,1,1,3,4,5,5,7]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,3,2]
; AVX512DQ-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm9, %ymm9
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm9, %zmm1, %zmm9
; AVX512DQ-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; AVX512DQ-NEXT:    vpternlogq $226, %zmm6, %zmm1, %zmm22
; AVX512DQ-NEXT:    vpermq $238, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX512DQ-NEXT:    # ymm6 = mem[2,3,2,3]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm6, %zmm0, %zmm6
; AVX512DQ-NEXT:    vpermq $238, {{[-0-9]+}}(%r{{[sb]}}p), %ymm27 # 32-byte Folded Reload
; AVX512DQ-NEXT:    # ymm27 = mem[2,3,2,3]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm27, %zmm0, %zmm27
; AVX512DQ-NEXT:    vpternlogq $226, %zmm6, %zmm1, %zmm27
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm7[0],xmm4[0],xmm7[1],xmm4[1],xmm7[2],xmm4[2],xmm7[3],xmm4[3],xmm7[4],xmm4[4],xmm7[5],xmm4[5],xmm7[6],xmm4[6],xmm7[7],xmm4[7]
; AVX512DQ-NEXT:    vmovdqa64 %xmm24, %xmm0
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm1, %xmm1
; AVX512DQ-NEXT:    vinserti32x4 $2, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm1 # 16-byte Folded Reload
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} xmm6 = xmm13[0],xmm3[0],xmm13[1],xmm3[1],xmm13[2],xmm3[2],xmm13[3],xmm3[3],xmm13[4],xmm3[4],xmm13[5],xmm3[5],xmm13[6],xmm3[6],xmm13[7],xmm3[7]
; AVX512DQ-NEXT:    vmovdqa64 %xmm21, %xmm0
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX512DQ-NEXT:    vinserti32x4 $2, {{[-0-9]+}}(%r{{[sb]}}p), %zmm6, %zmm6 # 16-byte Folded Reload
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} xmm10 = xmm10[0],xmm11[0],xmm10[1],xmm11[1],xmm10[2],xmm11[2],xmm10[3],xmm11[3],xmm10[4],xmm11[4],xmm10[5],xmm11[5],xmm10[6],xmm11[6],xmm10[7],xmm11[7]
; AVX512DQ-NEXT:    vmovdqa64 %xmm20, %xmm0
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm10, %xmm10
; AVX512DQ-NEXT:    vinserti32x4 $2, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm10 # 16-byte Folded Reload
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm11 = xmm5[4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512DQ-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[1,1,0,0,4,5,6,7]
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,1,2,0]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm11, %zmm5, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm11 # 64-byte Folded Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512DQ-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm13, %zmm13 # 64-byte Folded Reload
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm11 = zmm11[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm13 = zmm13[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm11, %zmm13
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm11 # 64-byte Folded Reload
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm11 = zmm11[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vmovdqa64 {{.*#+}} zmm21 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255]
; AVX512DQ-NEXT:    vpternlogq $184, %zmm13, %zmm21, %zmm11
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[0,1,0,1,4,5,4,5]
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm7 = zmm17[0,1,0,1,4,5,4,5]
; AVX512DQ-NEXT:    vpternlogq $226, %zmm8, %zmm21, %zmm7
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm8 = ymm15[0,1,0,1]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,0,1]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm13 = ymm14[0,1,0,1]
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm14 = ymm18[2,3,2,3]
; AVX512DQ-NEXT:    vpshuflw $5, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; AVX512DQ-NEXT:    # xmm15 = mem[1,1,0,0,4,5,6,7]
; AVX512DQ-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[0,1,2,0]
; AVX512DQ-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm29, %zmm20 # 64-byte Folded Reload
; AVX512DQ-NEXT:    vporq %zmm26, %zmm23, %zmm17
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm18 = zmm20[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm17 = zmm17[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vpternlogq $226, %zmm18, %zmm21, %zmm17
; AVX512DQ-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm8 # 32-byte Folded Reload
; AVX512DQ-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm12, %zmm12 # 32-byte Folded Reload
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm12
; AVX512DQ-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm13, %zmm8 # 32-byte Folded Reload
; AVX512DQ-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm19
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm12, %zmm19
; AVX512DQ-NEXT:    vpermq $238, {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm8 = mem[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm11, %zmm8
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm11 = ymm15[0,0,1,0]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm11, %zmm14, %zmm11
; AVX512DQ-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm30, %zmm11
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm22, %zmm11
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm0 = zmm31[0,1,0,1,4,5,4,5]
; AVX512DQ-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm28, %zmm0
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm7, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 $84, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm3 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm3 = zmm3[0,1,2,3],mem[2,3,2,3]
; AVX512DQ-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm9
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm27, %zmm9
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[0,1,0,1,4,5,4,5]
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm3 = zmm6[0,1,0,1,4,5,4,5]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm3
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm1 = zmm10[0,1,0,1,4,5,4,5]
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm5 = zmm5[0,0,1,0,4,4,5,4]
; AVX512DQ-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm5
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm1 # 64-byte Folded Reload
; AVX512DQ-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512DQ-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm16
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm17, %zmm16
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, 128(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 320(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 256(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, 192(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, 384(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, 64(%rax)
; AVX512DQ-NEXT:    addq $1384, %rsp # imm = 0x568
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i8_stride7_vf64:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    subq $1432, %rsp # imm = 0x598
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rsi), %ymm3
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm3[30],zero,ymm3[28],zero,zero,zero,zero,ymm3[31],zero,ymm3[29],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512DQ-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [128,23,128,128,128,128,26,128,24,128,128,128,128,27,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128,27,128,25]
; AVX512DQ-FCP-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm4, %ymm2, %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm4, %ymm25
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,30],zero,ymm2[28],zero,ymm2[30,31,30,31],zero,ymm2[29],zero,ymm2[31,28,29]
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [25,128,23,0,0,0,128,26,128,24,0,0,0,128,27,128,25,128,23,0,0,0,128,26,128,24,0,0,0,128,27,128]
; AVX512DQ-FCP-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm2, %ymm3, %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm2, %ymm16
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm3, %ymm27
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rdx), %ymm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero,ymm1[29],zero,zero
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm1, %ymm2
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rcx), %ymm15
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [128,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128,128,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128]
; AVX512DQ-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm3, %ymm15, %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm3, %ymm29
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27,u,u,u],zero,ymm15[30],zero,ymm15[28,u,u,u],zero,ymm15[31],zero,ymm15[29,u]
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [24,25,128,23,128,21,22,23,26,128,24,128,28,29,26,27,24,25,128,23,128,21,22,23,26,128,24,128,28,29,26,27]
; AVX512DQ-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm3, %ymm2, %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm3, %ymm31
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm2, %ymm26
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%r8), %ymm2
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm2[27],zero,zero,zero,zero,ymm2[30],zero,ymm2[28],zero,zero,zero,zero,ymm2[31],zero,ymm2[29]
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%r9), %ymm3
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [128,128,128,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128,128,128,25,128,23,128,128,128,128,26,128,24,128,128]
; AVX512DQ-FCP-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm4, %ymm3, %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm4, %ymm21
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm3[27,u,u,u],zero,ymm3[30],zero,ymm3[28,u,u,u],zero,ymm3[31],zero
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm3, %ymm23
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [24,25,24,25,128,23,128,23,24,25,26,128,24,128,30,31,24,25,24,25,128,23,128,23,24,25,26,128,24,128,30,31]
; AVX512DQ-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm3, %ymm2, %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm3, %ymm20
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm2, %ymm19
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rax), %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa (%rsi), %ymm6
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,ymm6[14],zero,zero,zero,zero,zero,zero,ymm6[15],zero,zero,zero,zero,zero,zero,ymm6[16],zero,zero,zero,zero,zero,zero,ymm6[17],zero,zero,zero,zero,zero,zero,ymm6[18]
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm5
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm5[0,1,14],zero,ymm5[12,13,0,1,14,15],zero,ymm5[3,12,13,2,3,16],zero,ymm5[30,31,28,29,16,17],zero,ymm5[31,18,19,28,29,18],zero
; AVX512DQ-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa (%rcx), %ymm3
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,ymm3[14],zero,zero,zero,zero,zero,zero,ymm3[15],zero,zero,zero,zero,zero,zero,ymm3[16],zero,zero,zero,zero,zero,zero,ymm3[17],zero,zero,zero,zero,zero
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[0,1,0,1,14],zero,ymm2[14,15,0,1,14,15],zero,ymm2[13,14,15,16,17,16],zero,ymm2[30,31,30,31,16,17],zero,ymm2[31,28,29,30,31]
; AVX512DQ-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa (%r8), %ymm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,zero,zero,ymm1[14],zero,zero,zero,zero,zero,zero,ymm1[15],zero,zero,zero,zero,zero,zero,ymm1[16],zero,zero,zero,zero,zero,zero,ymm1[17],zero,zero,zero,zero
; AVX512DQ-FCP-NEXT:    vmovdqa (%r9), %ymm14
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm7 = ymm14[13,u,u,u,u,u],zero,ymm14[14,u,u,u,u,u],zero,ymm14[15,u,u,u,u,u],zero,ymm14[16,u,u,u,u,u],zero,ymm14[17,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %ymm4, %ymm7, %ymm4
; AVX512DQ-FCP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rdx), %xmm9
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rcx), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm4 = [u,u,u,128,7,128,5,u,u,u,128,8,128,6,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm4, %xmm0, %xmm7
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm8 = [u,u,u,7,128,5,128,u,u,u,8,128,6,128,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm8, %xmm9, %xmm9
; AVX512DQ-FCP-NEXT:    vpor %xmm7, %xmm9, %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rsi), %xmm9
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm7 = [u,128,7,128,5,u,u,u,128,8,128,6,u,u,u,128]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm7, %xmm9, %xmm9
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm10 = [u,7,128,5,128,u,u,u,8,128,6,128,u,u,u,9]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm10, %xmm0, %xmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 %xmm0, %xmm28
; AVX512DQ-FCP-NEXT:    vpor %xmm9, %xmm11, %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%r9), %xmm9
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%r8), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm11 = [128,4,u,u,u,128,7,128,5,u,u,u,128,8,128,6]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm11, %xmm9, %xmm9
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm13 = [4,128,u,u,u,7,128,5,128,u,u,u,8,128,6,128]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm13, %xmm0, %xmm12
; AVX512DQ-FCP-NEXT:    vpor %xmm9, %xmm12, %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa (%rsi), %xmm0
; AVX512DQ-FCP-NEXT:    vpshufb %xmm7, %xmm0, %xmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 %xmm0, %xmm24
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vpshufb %xmm10, %xmm0, %xmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 %xmm0, %xmm17
; AVX512DQ-FCP-NEXT:    vpor %xmm7, %xmm10, %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa (%rcx), %xmm10
; AVX512DQ-FCP-NEXT:    vpshufb %xmm4, %xmm10, %xmm4
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm9
; AVX512DQ-FCP-NEXT:    vpshufb %xmm8, %xmm9, %xmm8
; AVX512DQ-FCP-NEXT:    vpor %xmm4, %xmm8, %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa (%r9), %xmm8
; AVX512DQ-FCP-NEXT:    vpshufb %xmm11, %xmm8, %xmm11
; AVX512DQ-FCP-NEXT:    vmovdqa (%r8), %xmm7
; AVX512DQ-FCP-NEXT:    vpshufb %xmm13, %xmm7, %xmm13
; AVX512DQ-FCP-NEXT:    vporq %xmm11, %xmm13, %xmm30
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm25, %ymm0
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm5, %ymm11
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm12 = [128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128]
; AVX512DQ-FCP-NEXT:    # ymm12 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm12, %ymm6, %ymm13
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm16, %ymm0
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm6, %ymm11
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [18,19,20,21,128,19,128,21,20,21,22,128,20,128,22,23,18,19,20,21,128,19,128,21,20,21,22,128,20,128,22,23]
; AVX512DQ-FCP-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm5, %ymm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm0, %ymm22
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm29, %ymm0
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm3, %ymm11
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20]
; AVX512DQ-FCP-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm3, %ymm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm0, %ymm29
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm31, %ymm0
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm2, %ymm11
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [18,128,18,19,20,21,128,19,128,25,26,27,22,128,20,128,18,128,18,19,20,21,128,19,128,25,26,27,22,128,20,128]
; AVX512DQ-FCP-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm4, %ymm2, %ymm13
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm21, %ymm0
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm14, %ymm11
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22]
; AVX512DQ-FCP-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm14, %ymm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm0, %ymm18
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm20, %ymm0
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm1, %ymm11
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [20,128,18,128,20,21,20,21,128,19,128,19,20,21,22,128,20,128,18,128,20,21,20,21,128,19,128,19,20,21,22,128]
; AVX512DQ-FCP-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm1, %ymm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm0, %ymm16
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm13, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm6[30],zero,ymm6[28],zero,zero,zero,zero,ymm6[31],zero,ymm6[29],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,30],zero,ymm5[28],zero,ymm5[30,31,30,31],zero,ymm5[29],zero,ymm5[31,28,29]
; AVX512DQ-FCP-NEXT:    vporq %ymm6, %ymm5, %ymm20
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm2[30],zero,ymm2[28],zero,zero,zero,zero,ymm2[31],zero,ymm2[29],zero,zero
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27,u,u,u],zero,ymm3[30],zero,ymm3[28,u,u,u],zero,ymm3[31],zero,ymm3[29,u]
; AVX512DQ-FCP-NEXT:    vpor %ymm2, %ymm3, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm1[27],zero,zero,zero,zero,ymm1[30],zero,ymm1[28],zero,zero,zero,zero,ymm1[31],zero,ymm1[29]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm14[27,u,u,u],zero,ymm14[30],zero,ymm14[28,u,u,u],zero,ymm14[31],zero
; AVX512DQ-FCP-NEXT:    vporq %ymm1, %ymm0, %ymm21
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,ymm15[14],zero,zero,zero,zero,zero,zero,ymm15[15],zero,zero,zero,zero,zero,zero,ymm15[16],zero,zero,zero,zero,zero,zero,ymm15[17],zero,zero,zero,zero,zero
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm26, %ymm2
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[0,1,0,1,14],zero,ymm2[14,15,0,1,14,15],zero,ymm2[13,14,15,16,17,16],zero,ymm2[30,31,30,31,16,17],zero,ymm2[31,28,29,30,31]
; AVX512DQ-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm29, %ymm0
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm15, %ymm0
; AVX512DQ-FCP-NEXT:    vpshufb %ymm4, %ymm2, %ymm1
; AVX512DQ-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm27, %ymm3
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,ymm3[14],zero,zero,zero,zero,zero,zero,ymm3[15],zero,zero,zero,zero,zero,zero,ymm3[16],zero,zero,zero,zero,zero,zero,ymm3[17],zero,zero,zero,zero,zero,zero,ymm3[18]
; AVX512DQ-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[0,1,14],zero,ymm2[12,13,0,1,14,15],zero,ymm2[3,12,13,2,3,16],zero,ymm2[30,31,28,29,16,17],zero,ymm2[31,18,19,28,29,18],zero
; AVX512DQ-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpshufb %ymm12, %ymm3, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm22, %ymm1
; AVX512DQ-FCP-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512DQ-FCP-NEXT:    vporq %ymm0, %ymm1, %ymm29
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm23, %ymm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm18, %ymm0
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm19, %ymm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm16, %ymm1
; AVX512DQ-FCP-NEXT:    vpshufb %ymm1, %ymm3, %ymm1
; AVX512DQ-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,ymm3[14],zero,zero,zero,zero,zero,zero,ymm3[15],zero,zero,zero,zero,zero,zero,ymm3[16],zero,zero,zero,zero,zero,zero,ymm3[17],zero,zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[13,u,u,u,u,u],zero,ymm2[14,u,u,u,u,u],zero,ymm2[15,u,u,u,u,u],zero,ymm2[16,u,u,u,u,u],zero,ymm2[17,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa (%rax), %xmm1
; AVX512DQ-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [2,2,3,3,2,2,3,3]
; AVX512DQ-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm1[0,1,2,3,4,5,5,6]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %xmm1, %xmm23
; AVX512DQ-FCP-NEXT:    vpermd %ymm0, %ymm3, %ymm0
; AVX512DQ-FCP-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rax), %ymm15
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,ymm15[13],zero,zero,zero,zero,zero,zero,ymm15[14],zero,zero,zero,zero,zero,zero,ymm15[15],zero,zero,zero,zero,zero,zero,ymm15[16],zero,zero,zero,zero,zero,zero,ymm15[17],zero,zero
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm18
; AVX512DQ-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm10[8],xmm9[8],xmm10[9],xmm9[9],xmm10[10],xmm9[10],xmm10[11],xmm9[11],xmm10[12],xmm9[12],xmm10[13],xmm9[13],xmm10[14],xmm9[14],xmm10[15],xmm9[15]
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm5 = [6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm5, %xmm0, %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm0, %ymm27
; AVX512DQ-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 {{[-0-9]+}}(%r{{[sb]}}p), %xmm16 # 16-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %xmm16, %xmm1
; AVX512DQ-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm12[8],xmm1[8],xmm12[9],xmm1[9],xmm12[10],xmm1[10],xmm12[11],xmm1[11],xmm12[12],xmm1[12],xmm12[13],xmm1[13],xmm12[14],xmm1[14],xmm12[15],xmm1[15]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm5, %xmm0, %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, %xmm0, %zmm1, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 %xmm24, %xmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 %xmm17, %xmm1
; AVX512DQ-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm4[8],xmm1[8],xmm4[9],xmm1[9],xmm4[10],xmm1[10],xmm4[11],xmm1[11],xmm4[12],xmm1[12],xmm4[13],xmm1[13],xmm4[14],xmm1[14],xmm4[15],xmm1[15]
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm2 = [2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm0, %ymm24
; AVX512DQ-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %xmm28, %xmm5
; AVX512DQ-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm13[8],xmm5[8],xmm13[9],xmm5[9],xmm13[10],xmm5[10],xmm13[11],xmm5[11],xmm13[12],xmm5[12],xmm13[13],xmm5[13],xmm13[14],xmm5[14],xmm13[15],xmm5[15]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, %xmm0, %zmm2, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rax), %xmm6
; AVX512DQ-FCP-NEXT:    vpshufhw {{.*#+}} xmm14 = xmm6[0,1,2,3,4,5,5,6]
; AVX512DQ-FCP-NEXT:    vpermd %ymm14, %ymm3, %ymm31
; AVX512DQ-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm7[8],xmm8[8],xmm7[9],xmm8[9],xmm7[10],xmm8[10],xmm7[11],xmm8[11],xmm7[12],xmm8[12],xmm7[13],xmm8[13],xmm7[14],xmm8[14],xmm7[15],xmm8[15]
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm14 = [u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm14, %xmm3, %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %ymm0, %ymm22
; AVX512DQ-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX512DQ-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm11 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm14, %xmm11, %xmm11
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, %xmm11, %zmm3, %zmm28
; AVX512DQ-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3],xmm1[4],xmm4[4],xmm1[5],xmm4[5],xmm1[6],xmm4[6],xmm1[7],xmm4[7]
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm14 = [0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm14, %xmm11, %xmm11
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm26 # 16-byte Folded Reload
; AVX512DQ-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm9 = xmm9[0],xmm10[0],xmm9[1],xmm10[1],xmm9[2],xmm10[2],xmm9[3],xmm10[3],xmm9[4],xmm10[4],xmm9[5],xmm10[5],xmm9[6],xmm10[6],xmm9[7],xmm10[7]
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm3, %xmm9, %xmm9
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm9 # 16-byte Folded Reload
; AVX512DQ-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3],xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm11 = [u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm11, %xmm7, %xmm7
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, %xmm30, %zmm7, %zmm7
; AVX512DQ-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm8 = xmm5[0],xmm13[0],xmm5[1],xmm13[1],xmm5[2],xmm13[2],xmm5[3],xmm13[3],xmm5[4],xmm13[4],xmm5[5],xmm13[5],xmm5[6],xmm13[6],xmm5[7],xmm13[7]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm14, %xmm8, %xmm8
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm20[2,3,2,3],zmm8[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm8 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm13, %zmm20 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm8 = zmm8[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm20 = zmm20[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm8 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm30 = zmm8[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255]
; AVX512DQ-FCP-NEXT:    vpternlogq $184, %zmm20, %zmm8, %zmm30
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm5 = zmm19[0,1,0,1,4,5,4,5]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm20 = zmm17[0,1,0,1,4,5,4,5]
; AVX512DQ-FCP-NEXT:    vpternlogq $226, %zmm5, %zmm8, %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm1 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm25, %zmm5 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm25 = zmm1[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm1 = zmm5[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vpternlogq $226, %zmm25, %zmm8, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %xmm16, %xmm4
; AVX512DQ-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm5 = xmm4[0],xmm12[0],xmm4[1],xmm12[1],xmm4[2],xmm12[2],xmm4[3],xmm12[3],xmm4[4],xmm12[4],xmm4[5],xmm12[5],xmm4[6],xmm12[6],xmm4[7],xmm12[7]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm3, %xmm5, %xmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm10 = zmm3[2,3,2,3],zmm5[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm5 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm11, %xmm5, %xmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255,255,255,255,0,0,255,255]
; AVX512DQ-FCP-NEXT:    vpternlogq $226, %zmm14, %zmm8, %zmm10
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm21 = zmm21[2,3,2,3],zmm5[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpermq $238, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # ymm11 = mem[2,3,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm0, %zmm11
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm14 = ymm29[2,3,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm14, %zmm0, %zmm14
; AVX512DQ-FCP-NEXT:    vpternlogq $226, %zmm11, %zmm8, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqa64 %xmm23, %xmm0
; AVX512DQ-FCP-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm0[1,1,0,0,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm11 = [0,1,0,1,2,0,0,1]
; AVX512DQ-FCP-NEXT:    vpermd %ymm8, %ymm11, %ymm16
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm5 = [4,5,4,5,4,5,8,9,6,7,6,7,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm5, %xmm0, %xmm12
; AVX512DQ-FCP-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; AVX512DQ-FCP-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm6[1,1,0,0,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermd %ymm0, %ymm11, %ymm2
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,24,25,22,23,24,25,26,27,26,27,24,25]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,26,27,28,29,30,31,30,31,28,29,28,29,30,31]
; AVX512DQ-FCP-NEXT:    vpshuflw {{.*#+}} ymm15 = ymm15[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm17 = [4,5,4,5,5,7,4,5]
; AVX512DQ-FCP-NEXT:    vpermd %ymm15, %ymm17, %ymm15
; AVX512DQ-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = zero,ymm13[13],zero,zero,zero,zero,zero,zero,ymm13[14],zero,zero,zero,zero,zero,zero,ymm13[15],zero,zero,zero,zero,zero,zero,ymm13[16],zero,zero,zero,zero,zero,zero,ymm13[17],zero,zero
; AVX512DQ-FCP-NEXT:    vpshuflw {{.*#+}} ymm13 = ymm13[2,1,1,2,4,5,6,7,10,9,9,10,12,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermd %ymm13, %ymm17, %ymm13
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm24[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm17 = ymm27[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm22[0,1,0,1]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,1,0]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm12[0,0,1,0]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512DQ-FCP-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm13, %ymm13
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm13, %zmm8, %zmm8
; AVX512DQ-FCP-NEXT:    vpermq $238, {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm13 = mem[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm30, %zmm13
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm6, %zmm6 # 32-byte Folded Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm17, %zmm17 # 32-byte Folded Reload
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm6, %zmm17
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm3 # 32-byte Folded Reload
; AVX512DQ-FCP-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm18
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm17, %zmm18
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm31, %zmm5, %zmm3
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm5 = zmm28[0,1,0,1,4,5,4,5]
; AVX512DQ-FCP-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm5
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm20, %zmm5
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm3 = zmm26[0,1,0,1,4,5,4,5]
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm6 = zmm9[0,1,0,1,4,5,4,5]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm6
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm4, %zmm16, %zmm3
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm4 = zmm7[0,1,0,1,4,5,4,5]
; AVX512DQ-FCP-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm4
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm6, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vporq {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm3 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm15, %zmm6
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} zmm3 = zmm3[2,3,2,3,6,7,6,7]
; AVX512DQ-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm6
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm6
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm21, %zmm0
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm10, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vshufi64x2 $84, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm1 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm1 = zmm1[0,1,2,3],mem[2,3,2,3]
; AVX512DQ-FCP-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm8
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm14, %zmm8
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, 320(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 256(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, 64(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, 384(%rax)
; AVX512DQ-FCP-NEXT:    addq $1432, %rsp # imm = 0x598
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i8_stride7_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa (%rax), %ymm13
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} ymm26 = [12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX512BW-NEXT:    vpshufb %ymm26, %ymm13, %ymm0
; AVX512BW-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,5,4,5,5,6,5,6,4,5,4,5,5,6,5,6]
; AVX512BW-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512BW-NEXT:    vpermw %ymm13, %ymm1, %ymm1
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqa (%r9), %ymm9
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} ymm17 = [13,128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128]
; AVX512BW-NEXT:    vpshufb %ymm17, %ymm9, %ymm1
; AVX512BW-NEXT:    vmovdqa (%r8), %ymm10
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} ymm21 = [128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128]
; AVX512BW-NEXT:    vpshufb %ymm21, %ymm10, %ymm2
; AVX512BW-NEXT:    vpor %ymm1, %ymm2, %ymm2
; AVX512BW-NEXT:    vmovdqa (%r9), %xmm1
; AVX512BW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512BW-NEXT:    vmovdqa (%r8), %xmm12
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm12[8],xmm1[8],xmm12[9],xmm1[9],xmm12[10],xmm1[10],xmm12[11],xmm1[11],xmm12[12],xmm1[12],xmm12[13],xmm1[13],xmm12[14],xmm1[14],xmm12[15],xmm1[15]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm4, %zmm8
; AVX512BW-NEXT:    movabsq $2323999253380730912, %r10 # imm = 0x2040810204081020
; AVX512BW-NEXT:    kmovq %r10, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm8 {%k1}
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm14
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm0 = [0,1,0,1,14,128,14,15,0,1,14,15,128,13,14,15,16,17,16,128,30,31,30,31,16,17,128,31,28,29,30,31]
; AVX512BW-NEXT:    vpshufb %ymm0, %ymm14, %ymm2
; AVX512BW-NEXT:    vmovdqa (%rcx), %ymm15
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} ymm20 = [128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128]
; AVX512BW-NEXT:    vpshufb %ymm20, %ymm15, %ymm4
; AVX512BW-NEXT:    vpor %ymm2, %ymm4, %ymm2
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512BW-NEXT:    vmovdqa (%rcx), %xmm5
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm5[8],xmm4[8],xmm5[9],xmm4[9],xmm5[10],xmm4[10],xmm5[11],xmm4[11],xmm5[12],xmm4[12],xmm5[13],xmm4[13],xmm5[14],xmm4[14],xmm5[15],xmm4[15]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm6, %zmm22
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %ymm18
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} ymm24 = [0,1,14,128,12,13,0,1,14,15,128,3,12,13,2,3,16,128,30,31,28,29,16,17,128,31,18,19,28,29,18,128]
; AVX512BW-NEXT:    vpshufb %ymm24, %ymm18, %ymm2
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %ymm19
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} ymm25 = [128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128,128,18]
; AVX512BW-NEXT:    vpshufb %ymm25, %ymm19, %ymm6
; AVX512BW-NEXT:    vpor %ymm2, %ymm6, %ymm2
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm6
; AVX512BW-NEXT:    vmovdqa (%rsi), %xmm7
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm23 = xmm7[8],xmm6[8],xmm7[9],xmm6[9],xmm7[10],xmm6[10],xmm7[11],xmm6[11],xmm7[12],xmm6[12],xmm7[13],xmm6[13],xmm7[14],xmm6[14],xmm7[15],xmm6[15]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm23 = xmm23[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm23 = ymm23[0,1,0,1]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm23, %zmm3
; AVX512BW-NEXT:    movabsq $435749860008887046, %r10 # imm = 0x60C183060C18306
; AVX512BW-NEXT:    kmovq %r10, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm22, %zmm3 {%k1}
; AVX512BW-NEXT:    movabsq $4066998693416279096, %r10 # imm = 0x3870E1C3870E1C38
; AVX512BW-NEXT:    kmovq %r10, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm8, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqa64 32(%rdx), %ymm29
; AVX512BW-NEXT:    vpshufb %ymm0, %ymm29, %ymm0
; AVX512BW-NEXT:    vmovdqa64 32(%rcx), %ymm30
; AVX512BW-NEXT:    vpshufb %ymm20, %ymm30, %ymm8
; AVX512BW-NEXT:    vpor %ymm0, %ymm8, %ymm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,18,128,18,19,20,21,128,19,128,25,26,27,22,128,20,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,24,25,128,23,128,21,22,23,26,128,24,128,28,29,26,27]
; AVX512BW-NEXT:    vpshufb %ymm20, %ymm29, %ymm8
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128]
; AVX512BW-NEXT:    vpshufb %ymm22, %ymm30, %ymm23
; AVX512BW-NEXT:    vporq %ymm8, %ymm23, %ymm8
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm8, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 32(%rsi), %ymm28
; AVX512BW-NEXT:    vmovdqa64 32(%rdi), %ymm16
; AVX512BW-NEXT:    vpshuflw {{.*#+}} ymm8 = ymm16[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512BW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm8[0,0,1,1,4,4,5,5]
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} ymm23 = [5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6]
; AVX512BW-NEXT:    movl $676341840, %r10d # imm = 0x28502850
; AVX512BW-NEXT:    kmovd %r10d, %k1
; AVX512BW-NEXT:    vpshufb %ymm23, %ymm28, %ymm8 {%k1}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX512BW-NEXT:    vpshufb %ymm24, %ymm16, %ymm24
; AVX512BW-NEXT:    vpshufb %ymm25, %ymm28, %ymm25
; AVX512BW-NEXT:    vporq %ymm24, %ymm25, %ymm24
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm8, %zmm24, %zmm8
; AVX512BW-NEXT:    movabsq $3485998880071096368, %r10 # imm = 0x3060C183060C1830
; AVX512BW-NEXT:    kmovq %r10, %k2
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm8 {%k2}
; AVX512BW-NEXT:    vmovdqa64 32(%r9), %ymm31
; AVX512BW-NEXT:    vpshufb %ymm17, %ymm31, %ymm17
; AVX512BW-NEXT:    vmovdqa 32(%r8), %ymm1
; AVX512BW-NEXT:    vpshufb %ymm21, %ymm1, %ymm21
; AVX512BW-NEXT:    vporq %ymm17, %ymm21, %ymm17
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm24 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,20,128,18,128,20,21,20,21,128,19,128,19,20,21,22,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,24,25,24,25,128,23,128,23,24,25,26,128,24,128,30,31]
; AVX512BW-NEXT:    vpshufb %ymm24, %ymm1, %ymm21
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm25 = [u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,128,128,128,25,128,23,128,128,128,128,26,128,24,128,128]
; AVX512BW-NEXT:    vpshufb %ymm25, %ymm31, %ymm27
; AVX512BW-NEXT:    vporq %ymm21, %ymm27, %ymm21
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm21 = ymm21[2,3,2,3]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm21, %zmm17, %zmm21
; AVX512BW-NEXT:    vmovdqa64 32(%rax), %ymm17
; AVX512BW-NEXT:    vpshufb %ymm26, %ymm17, %ymm27
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm26 = [10,9,9,10,10,9,9,10,9,10,14,15,10,9,9,10,27,29,28,27,28,29,29,28,27,29,28,27,28,29,29,28]
; AVX512BW-NEXT:    vpermw %ymm17, %ymm26, %ymm11
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm11, %zmm27, %zmm11
; AVX512BW-NEXT:    movabsq $145249953336295682, %r10 # imm = 0x204081020408102
; AVX512BW-NEXT:    kmovq %r10, %k3
; AVX512BW-NEXT:    vmovdqu8 %zmm11, %zmm21 {%k3}
; AVX512BW-NEXT:    movabsq $-4357498600088870461, %r10 # imm = 0xC3870E1C3870E1C3
; AVX512BW-NEXT:    kmovq %r10, %k3
; AVX512BW-NEXT:    vmovdqu8 %zmm21, %zmm8 {%k3}
; AVX512BW-NEXT:    vpshufhw {{.*#+}} ymm11 = ymm16[0,1,2,3,6,7,7,6,8,9,10,11,14,15,15,14]
; AVX512BW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm11[2,2,3,3,6,6,7,7]
; AVX512BW-NEXT:    movl $338170920, %r10d # imm = 0x14281428
; AVX512BW-NEXT:    kmovd %r10d, %k4
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} ymm27 = [13,12,15,14,13,12,15,14,13,12,15,14,13,12,15,14,13,12,15,14,13,12,15,14,13,12,15,14,13,12,15,14]
; AVX512BW-NEXT:    vpshufb %ymm27, %ymm28, %ymm11 {%k4}
; AVX512BW-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [25,128,23,128,128,128,128,26,128,24,128,128,128,128,27,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128,27,128]
; AVX512BW-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512BW-NEXT:    vpshufb %ymm2, %ymm28, %ymm21
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} ymm28 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,23,128,128,128,128,26,128,24,128,128,128,128,27,128,25]
; AVX512BW-NEXT:    vpshufb %ymm28, %ymm16, %ymm16
; AVX512BW-NEXT:    vporq %ymm21, %ymm16, %ymm16
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm11, %zmm16, %zmm16
; AVX512BW-NEXT:    vpshufhw {{.*#+}} ymm11 = ymm29[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512BW-NEXT:    vpshufd {{.*#+}} ymm21 = ymm11[0,2,3,3,4,6,7,7]
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} ymm11 = [11,0,0,0,15,14,13,12,11,0,0,0,15,14,13,12,11,0,0,0,15,14,13,12,11,0,0,0,15,14,13,12]
; AVX512BW-NEXT:    vpshufb %ymm11, %ymm30, %ymm0
; AVX512BW-NEXT:    vmovdqu8 %ymm21, %ymm0 {%k1}
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm21 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm29[24,25],zero,ymm29[23],zero,ymm29[21,22,23,26],zero,ymm29[24],zero,ymm29[28,29,26,27]
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm29 = ymm30[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm30[25],zero,ymm30[23],zero,zero,zero,zero,ymm30[26],zero,ymm30[24],zero,zero,zero,zero
; AVX512BW-NEXT:    vporq %ymm21, %ymm29, %ymm21
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm21, %zmm0
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm16 = zmm16[2,3,2,3,6,7,6,7]
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[2,3,2,3,6,7,6,7]
; AVX512BW-NEXT:    movabsq $1742999440035548184, %r10 # imm = 0x183060C183060C18
; AVX512BW-NEXT:    kmovq %r10, %k3
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm16 {%k3}
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm0
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm1[0,1,2,3],zmm0[4,5,6,7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} zmm1 = zmm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25],zero,zmm1[23],zero,zmm1[23,24,25,26],zero,zmm1[24],zero,zmm1[30,31,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,61],zero,zmm1[59],zero,zero,zero,zero,zmm1[62],zero,zmm1[60],zero,zero,zero,zero,zmm1[63],zero
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm29
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm21 = zmm31[0,1,2,3],zmm29[4,5,6,7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} zmm21 = zmm21[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm21[25],zero,zmm21[23],zero,zero,zero,zero,zmm21[26],zero,zmm21[24],zero,zero,zmm21[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm21[59],zero,zero,zero,zero,zmm21[62],zero,zmm21[60],zero,zero,zero,zero,zmm21[63],zero,zmm21[61]
; AVX512BW-NEXT:    vporq %zmm1, %zmm21, %zmm1
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512BW-NEXT:    movabsq $6971997760142192736, %r10 # imm = 0x60C183060C183060
; AVX512BW-NEXT:    kmovq %r10, %k3
; AVX512BW-NEXT:    vmovdqu8 %zmm1, %zmm16 {%k3}
; AVX512BW-NEXT:    vmovdqa64 (%rax), %zmm21
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm1 = [11,13,12,11,12,13,13,12,11,13,12,11,12,13,13,12,62,61,62,63,63,62,62,63,62,61,62,63,63,62,62,63]
; AVX512BW-NEXT:    vpermi2w %zmm21, %zmm17, %zmm1
; AVX512BW-NEXT:    movabsq $-9150747060186627967, %rax # imm = 0x8102040810204081
; AVX512BW-NEXT:    kmovq %rax, %k5
; AVX512BW-NEXT:    vmovdqu8 %zmm1, %zmm16 {%k5}
; AVX512BW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm18[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512BW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,0,1,1,4,4,5,5]
; AVX512BW-NEXT:    vpshufb %ymm23, %ymm19, %ymm1 {%k1}
; AVX512BW-NEXT:    vpshufb %ymm2, %ymm19, %ymm2
; AVX512BW-NEXT:    vpshufb %ymm28, %ymm18, %ymm23
; AVX512BW-NEXT:    vporq %ymm2, %ymm23, %ymm2
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm14, %zmm2, %zmm2
; AVX512BW-NEXT:    vpshufb %zmm20, %zmm2, %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm20
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm15, %zmm20, %zmm20
; AVX512BW-NEXT:    vpshufb %zmm22, %zmm20, %zmm20
; AVX512BW-NEXT:    vporq %zmm2, %zmm20, %zmm2
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm20 = zmm2[2,3,2,3,6,7,6,7]
; AVX512BW-NEXT:    vmovdqu8 %zmm1, %zmm20 {%k3}
; AVX512BW-NEXT:    vmovdqa64 32(%r9), %xmm22
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm10, %zmm29, %zmm1
; AVX512BW-NEXT:    vpshufb %zmm24, %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqa64 32(%r8), %xmm23
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm9, %zmm0, %zmm0
; AVX512BW-NEXT:    vpshufb %zmm25, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa 32(%rdx), %xmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqa 32(%rcx), %xmm2
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm13, %zmm21, %zmm13
; AVX512BW-NEXT:    vpermw %zmm13, %zmm26, %zmm24
; AVX512BW-NEXT:    movabsq $1161999626690365456, %rax # imm = 0x1020408102040810
; AVX512BW-NEXT:    kmovq %rax, %k5
; AVX512BW-NEXT:    vmovdqu8 %zmm24, %zmm1 {%k5}
; AVX512BW-NEXT:    vmovdqa64 32(%rdi), %xmm24
; AVX512BW-NEXT:    movabsq $2033499346708139548, %rax # imm = 0x1C3870E1C3870E1C
; AVX512BW-NEXT:    kmovq %rax, %k5
; AVX512BW-NEXT:    vmovdqu8 %zmm1, %zmm20 {%k5}
; AVX512BW-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX512BW-NEXT:    vpshufhw {{.*#+}} ymm18 = ymm18[0,1,2,3,6,7,7,6,8,9,10,11,14,15,15,14]
; AVX512BW-NEXT:    vpshufd {{.*#+}} ymm25 = ymm18[2,2,3,3,6,6,7,7]
; AVX512BW-NEXT:    vpshufb %ymm27, %ymm19, %ymm25 {%k4}
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm19 = xmm24[0],xmm1[0],xmm24[1],xmm1[1],xmm24[2],xmm1[2],xmm24[3],xmm1[3],xmm24[4],xmm1[4],xmm24[5],xmm1[5],xmm24[6],xmm1[6],xmm24[7],xmm1[7]
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} xmm18 = [0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512BW-NEXT:    vpshufb %xmm18, %xmm19, %xmm19
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm25 = zmm25[2,3,2,3],zmm19[0,1,0,1]
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm26 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; AVX512BW-NEXT:    vpshufb %ymm11, %ymm15, %ymm11
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} xmm19 = [4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512BW-NEXT:    vpshufb %xmm19, %xmm26, %xmm15
; AVX512BW-NEXT:    vpshufhw {{.*#+}} ymm14 = ymm14[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512BW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm14[0,2,3,3,4,6,7,7]
; AVX512BW-NEXT:    vmovdqu8 %ymm14, %ymm11 {%k1}
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm11[2,3,2,3],zmm15[0,1,0,1]
; AVX512BW-NEXT:    vmovdqu8 %zmm25, %zmm14 {%k2}
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm23[0],xmm22[0],xmm23[1],xmm22[1],xmm23[2],xmm22[2],xmm23[3],xmm22[3],xmm23[4],xmm22[4],xmm23[5],xmm22[5],xmm23[6],xmm22[6],xmm23[7],xmm22[7]
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm15 = [u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512BW-NEXT:    vpshufb %xmm15, %xmm11, %xmm11
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm9[27],zero,zero,zero,zero,ymm9[30],zero,ymm9[28],zero,zero,zero,zero,ymm9[31],zero
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm10[27],zero,zero,zero,zero,ymm10[30],zero,ymm10[28],zero,zero,zero,zero,ymm10[31],zero,ymm10[29]
; AVX512BW-NEXT:    vpor %ymm9, %ymm10, %ymm9
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm9 = zmm9[2,3,2,3],zmm11[0,1,0,1]
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm10 = [14,13,14,15,15,14,14,15,14,13,14,15,15,14,14,15,17,17,16,16,17,17,16,16,20,21,17,17,17,17,16,16]
; AVX512BW-NEXT:    vpermw %zmm21, %zmm10, %zmm10
; AVX512BW-NEXT:    movabsq $580999813345182728, %rax # imm = 0x810204081020408
; AVX512BW-NEXT:    kmovq %rax, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm10, %zmm9 {%k1}
; AVX512BW-NEXT:    movabsq $1016749673354069774, %rax # imm = 0xE1C3870E1C3870E
; AVX512BW-NEXT:    kmovq %rax, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm9, %zmm14 {%k1}
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm10 = [u,u,u,128,7,128,5,u,u,u,128,8,128,6,u,u]
; AVX512BW-NEXT:    vpshufb %xmm10, %xmm2, %xmm9
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm11 = [u,u,u,7,128,5,128,u,u,u,8,128,6,128,u,u]
; AVX512BW-NEXT:    vpshufb %xmm11, %xmm0, %xmm25
; AVX512BW-NEXT:    vporq %xmm9, %xmm25, %xmm9
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512BW-NEXT:    vinserti32x4 $2, %xmm0, %zmm9, %zmm0
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm2 = [u,128,7,128,5,u,u,u,128,8,128,6,u,u,u,128]
; AVX512BW-NEXT:    vpshufb %xmm2, %xmm1, %xmm9
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} xmm25 = [u,7,128,5,128,u,u,u,8,128,6,128,u,u,u,9]
; AVX512BW-NEXT:    vpshufb %xmm25, %xmm24, %xmm26
; AVX512BW-NEXT:    vporq %xmm9, %xmm26, %xmm9
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm1[8],xmm24[8],xmm1[9],xmm24[9],xmm1[10],xmm24[10],xmm1[11],xmm24[11],xmm1[12],xmm24[12],xmm1[13],xmm24[13],xmm1[14],xmm24[14],xmm1[15],xmm24[15]
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[0,1,0,1,4,5,4,5]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512BW-NEXT:    vinserti32x4 $2, %xmm1, %zmm9, %zmm1
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm9 = zmm1[0,1,0,1,4,5,4,5]
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm9 {%k3}
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm0 = [128,4,u,u,u,128,7,128,5,u,u,u,128,8,128,6]
; AVX512BW-NEXT:    vpshufb %xmm0, %xmm22, %xmm1
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm24 = [2,2,2,4,2,2,2,4,3,3,3,3,2,2,2,4,52,53,52,53,53,54,53,54,52,53,52,53,53,54,53,54]
; AVX512BW-NEXT:    vpermi2w %zmm21, %zmm17, %zmm24
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} xmm17 = [4,128,u,u,u,7,128,5,128,u,u,u,8,128,6,128]
; AVX512BW-NEXT:    vpshufb %xmm17, %xmm23, %xmm21
; AVX512BW-NEXT:    vporq %xmm1, %xmm21, %xmm1
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm21 = xmm23[8],xmm22[8],xmm23[9],xmm22[9],xmm23[10],xmm22[10],xmm23[11],xmm22[11],xmm23[12],xmm22[12],xmm23[13],xmm22[13],xmm23[14],xmm22[14],xmm23[15],xmm22[15]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm21 = xmm21[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512BW-NEXT:    vinserti32x4 $2, %xmm21, %zmm1, %zmm1
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[0,1,0,1,4,5,4,5]
; AVX512BW-NEXT:    movabsq $290499906672591364, %rax # imm = 0x408102040810204
; AVX512BW-NEXT:    kmovq %rax, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm24, %zmm1 {%k1}
; AVX512BW-NEXT:    movabsq $-8714997200177740921, %rax # imm = 0x870E1C3870E1C387
; AVX512BW-NEXT:    kmovq %rax, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm1, %zmm9 {%k1}
; AVX512BW-NEXT:    vpshufb %xmm10, %xmm5, %xmm1
; AVX512BW-NEXT:    vpshufb %xmm11, %xmm4, %xmm10
; AVX512BW-NEXT:    vpor %xmm1, %xmm10, %xmm1
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1],xmm4[2],xmm5[2],xmm4[3],xmm5[3],xmm4[4],xmm5[4],xmm4[5],xmm5[5],xmm4[6],xmm5[6],xmm4[7],xmm5[7]
; AVX512BW-NEXT:    vpshufb %xmm19, %xmm4, %xmm4
; AVX512BW-NEXT:    vinserti32x4 $2, %xmm1, %zmm4, %zmm1
; AVX512BW-NEXT:    vpshufb %xmm2, %xmm7, %xmm2
; AVX512BW-NEXT:    vpshufb %xmm25, %xmm6, %xmm4
; AVX512BW-NEXT:    vpor %xmm2, %xmm4, %xmm2
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm6[0],xmm7[0],xmm6[1],xmm7[1],xmm6[2],xmm7[2],xmm6[3],xmm7[3],xmm6[4],xmm7[4],xmm6[5],xmm7[5],xmm6[6],xmm7[6],xmm6[7],xmm7[7]
; AVX512BW-NEXT:    vpshufb %xmm18, %xmm4, %xmm4
; AVX512BW-NEXT:    vinserti32x4 $2, %xmm2, %zmm4, %zmm2
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[0,1,0,1,4,5,4,5]
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm2 = zmm2[0,1,0,1,4,5,4,5]
; AVX512BW-NEXT:    movabsq $871499720017774092, %rax # imm = 0xC183060C183060C
; AVX512BW-NEXT:    kmovq %rax, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm1, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX512BW-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX512BW-NEXT:    vpshufb %xmm17, %xmm12, %xmm1
; AVX512BW-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm12[0],xmm4[0],xmm12[1],xmm4[1],xmm12[2],xmm4[2],xmm12[3],xmm4[3],xmm12[4],xmm4[4],xmm12[5],xmm4[5],xmm12[6],xmm4[6],xmm12[7],xmm4[7]
; AVX512BW-NEXT:    vpshufb %xmm15, %xmm1, %xmm1
; AVX512BW-NEXT:    vinserti32x4 $2, %xmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm1 = [1,1,0,0,1,1,0,0,4,5,1,1,1,1,0,0,18,18,18,20,18,18,18,20,19,19,19,19,18,18,18,20]
; AVX512BW-NEXT:    vpermw %zmm13, %zmm1, %zmm1
; AVX512BW-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[0,1,0,1,4,5,4,5]
; AVX512BW-NEXT:    movabsq $4647998506761461824, %rax # imm = 0x4081020408102040
; AVX512BW-NEXT:    kmovq %rax, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    movabsq $8133997386832558192, %rax # imm = 0x70E1C3870E1C3870
; AVX512BW-NEXT:    kmovq %rax, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 320(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm20, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 384(%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i8_stride7_vf64:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    subq $104, %rsp
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    vmovdqa (%rax), %ymm2
; AVX512BW-FCP-NEXT:    vmovdqu %ymm2, (%rsp) # 32-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 {{.*#+}} ymm20 = [12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX512BW-FCP-NEXT:    vpshufb %ymm20, %ymm2, %ymm0
; AVX512BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,5,4,5,5,6,5,6,4,5,4,5,5,6,5,6]
; AVX512BW-FCP-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512BW-FCP-NEXT:    vpermw %ymm2, %ymm1, %ymm1
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa (%r9), %ymm1
; AVX512BW-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [13,128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128]
; AVX512BW-FCP-NEXT:    vpshufb %ymm0, %ymm1, %ymm3
; AVX512BW-FCP-NEXT:    vmovdqa (%r8), %ymm4
; AVX512BW-FCP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} ymm1 = [128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128]
; AVX512BW-FCP-NEXT:    vpshufb %ymm1, %ymm4, %ymm4
; AVX512BW-FCP-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r9), %xmm16
; AVX512BW-FCP-NEXT:    vmovdqa (%r8), %xmm15
; AVX512BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm15[8],xmm16[8],xmm15[9],xmm16[9],xmm15[10],xmm16[10],xmm15[11],xmm16[11],xmm15[12],xmm16[12],xmm15[13],xmm16[13],xmm15[14],xmm16[14],xmm15[15],xmm16[15]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm3
; AVX512BW-FCP-NEXT:    movabsq $2323999253380730912, %r10 # imm = 0x2040810204081020
; AVX512BW-FCP-NEXT:    kmovq %r10, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm2, %zmm3 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %ymm4
; AVX512BW-FCP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,0,1,14,128,14,15,0,1,14,15,128,13,14,15,16,17,16,128,30,31,30,31,16,17,128,31,28,29,30,31]
; AVX512BW-FCP-NEXT:    vpshufb %ymm2, %ymm4, %ymm4
; AVX512BW-FCP-NEXT:    vmovdqa (%rcx), %ymm6
; AVX512BW-FCP-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} ymm5 = [128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128]
; AVX512BW-FCP-NEXT:    vpshufb %ymm5, %ymm6, %ymm6
; AVX512BW-FCP-NEXT:    vpor %ymm4, %ymm6, %ymm4
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %xmm17
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %xmm19
; AVX512BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm19[8],xmm17[8],xmm19[9],xmm17[9],xmm19[10],xmm17[10],xmm19[11],xmm17[11],xmm19[12],xmm17[12],xmm19[13],xmm17[13],xmm19[14],xmm17[14],xmm19[15],xmm17[15]
; AVX512BW-FCP-NEXT:    vmovdqa64 {{.*#+}} xmm29 = [6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512BW-FCP-NEXT:    vpshufb %xmm29, %xmm6, %xmm6
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm4, %zmm6, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512BW-FCP-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} ymm9 = [0,1,14,128,12,13,0,1,14,15,128,3,12,13,2,3,16,128,30,31,28,29,16,17,128,31,18,19,28,29,18,128]
; AVX512BW-FCP-NEXT:    vpshufb %ymm9, %ymm6, %ymm6
; AVX512BW-FCP-NEXT:    vmovdqa (%rsi), %ymm7
; AVX512BW-FCP-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 {{.*#+}} ymm23 = [128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128,128,18]
; AVX512BW-FCP-NEXT:    vpshufb %ymm23, %ymm7, %ymm21
; AVX512BW-FCP-NEXT:    vporq %ymm6, %ymm21, %ymm6
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %xmm21
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %xmm22
; AVX512BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm24 = xmm22[8],xmm21[8],xmm22[9],xmm21[9],xmm22[10],xmm21[10],xmm22[11],xmm21[11],xmm22[12],xmm21[12],xmm22[13],xmm21[13],xmm22[14],xmm21[14],xmm22[15],xmm21[15]
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm7 = [2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512BW-FCP-NEXT:    vpshufb %xmm7, %xmm24, %xmm24
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm24 = ymm24[0,1,0,1]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm6, %zmm24, %zmm14
; AVX512BW-FCP-NEXT:    movabsq $435749860008887046, %r10 # imm = 0x60C183060C18306
; AVX512BW-FCP-NEXT:    kmovq %r10, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm4, %zmm14 {%k1}
; AVX512BW-FCP-NEXT:    movabsq $4066998693416279096, %r10 # imm = 0x3870E1C3870E1C38
; AVX512BW-FCP-NEXT:    kmovq %r10, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm3, %zmm14 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rdx), %ymm3
; AVX512BW-FCP-NEXT:    vpshufb %ymm2, %ymm3, %ymm4
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rcx), %ymm2
; AVX512BW-FCP-NEXT:    vpshufb %ymm5, %ymm2, %ymm5
; AVX512BW-FCP-NEXT:    vpor %ymm4, %ymm5, %ymm4
; AVX512BW-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,18,128,18,19,20,21,128,19,128,25,26,27,22,128,20,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,24,25,128,23,128,21,22,23,26,128,24,128,28,29,26,27]
; AVX512BW-FCP-NEXT:    vpshufb %ymm5, %ymm3, %ymm5
; AVX512BW-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128]
; AVX512BW-FCP-NEXT:    vpshufb %ymm6, %ymm2, %ymm24
; AVX512BW-FCP-NEXT:    vporq %ymm5, %ymm24, %ymm5
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm5, %zmm4, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX512BW-FCP-NEXT:    vpshufb %ymm9, %ymm5, %ymm9
; AVX512BW-FCP-NEXT:    vmovdqa64 32(%rsi), %ymm25
; AVX512BW-FCP-NEXT:    vpshufb %ymm23, %ymm25, %ymm23
; AVX512BW-FCP-NEXT:    vporq %ymm9, %ymm23, %ymm9
; AVX512BW-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,18,19,20,21,128,19,128,21,20,21,22,128,20,128,22,23,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25,128,23,128,128,128,128,26,128,24,128,128,128,128,27,128]
; AVX512BW-FCP-NEXT:    vpshufb %ymm6, %ymm5, %ymm23
; AVX512BW-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,23,128,128,128,128,26,128,24,128,128,128,128,27,128,25]
; AVX512BW-FCP-NEXT:    vpshufb %ymm6, %ymm25, %ymm24
; AVX512BW-FCP-NEXT:    vporq %ymm23, %ymm24, %ymm23
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm23 = ymm23[2,3,2,3]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm23, %zmm9, %zmm9
; AVX512BW-FCP-NEXT:    movabsq $3485998880071096368, %r10 # imm = 0x3060C183060C1830
; AVX512BW-FCP-NEXT:    kmovq %r10, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm4, %zmm9 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa 32(%r9), %ymm4
; AVX512BW-FCP-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa64 32(%r8), %ymm28
; AVX512BW-FCP-NEXT:    vpshufb %ymm1, %ymm28, %ymm1
; AVX512BW-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,20,128,18,128,20,21,20,21,128,19,128,19,20,21,22,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,24,25,24,25,128,23,128,23,24,25,26,128,24,128,30,31]
; AVX512BW-FCP-NEXT:    vpshufb %ymm1, %ymm28, %ymm1
; AVX512BW-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,128,128,128,25,128,23,128,128,128,128,26,128,24,128,128]
; AVX512BW-FCP-NEXT:    vpshufb %ymm6, %ymm4, %ymm23
; AVX512BW-FCP-NEXT:    vporq %ymm1, %ymm23, %ymm1
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rax), %ymm6
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm23 = [10,9,9,10,10,9,9,10,9,10,14,15,10,9,9,10]
; AVX512BW-FCP-NEXT:    vpermw %ymm6, %ymm23, %ymm23
; AVX512BW-FCP-NEXT:    vpshufb %ymm20, %ymm6, %ymm20
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm23, %zmm20, %zmm20
; AVX512BW-FCP-NEXT:    movabsq $145249953336295682, %r10 # imm = 0x204081020408102
; AVX512BW-FCP-NEXT:    kmovq %r10, %k2
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm20, %zmm1 {%k2}
; AVX512BW-FCP-NEXT:    movabsq $-4357498600088870461, %r10 # imm = 0xC3870E1C3870E1C3
; AVX512BW-FCP-NEXT:    kmovq %r10, %k2
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm9 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm23
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm3[0,1,2,3],zmm23[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm1 = zmm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25],zero,zmm1[23],zero,zmm1[21,22,23,26],zero,zmm1[24],zero,zmm1[28,29,26,27,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,59],zero,zero,zero,zero,zmm1[62],zero,zmm1[60],zero,zero,zero,zero,zmm1[63],zero,zmm1[61],zero
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm24
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm24[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm2 = zmm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zmm2[25],zero,zmm2[23],zero,zero,zero,zero,zmm2[26],zero,zmm2[24],zero,zero,zero,zero,zmm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[62],zero,zmm2[60],zero,zero,zero,zero,zmm2[63],zero,zmm2[61],zero,zero
; AVX512BW-FCP-NEXT:    vporq %zmm1, %zmm2, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm26
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm25[0,1,2,3],zmm26[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm2 = zmm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,zmm2[23],zero,zero,zero,zero,zmm2[26],zero,zmm2[24],zero,zero,zero,zero,zmm2[27],zero,zmm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,60,61,62],zero,zmm2[60],zero,zmm2[62,63,62,63],zero,zmm2[61],zero,zmm2[63,60,61]
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm27
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm5[0,1,2,3],zmm27[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm3 = zmm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm3[23],zero,zero,zero,zero,zmm3[26],zero,zmm3[24],zero,zero,zero,zero,zmm3[27],zero,zmm3[25,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zmm3[62],zero,zmm3[60],zero,zero,zero,zero,zmm3[63],zero,zmm3[61],zero,zero,zero
; AVX512BW-FCP-NEXT:    vporq %zmm2, %zmm3, %zmm2
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm20 = zmm2[2,3,2,3,6,7,6,7]
; AVX512BW-FCP-NEXT:    movabsq $1742999440035548184, %r10 # imm = 0x183060C183060C18
; AVX512BW-FCP-NEXT:    kmovq %r10, %k2
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm20 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r9), %zmm25
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm28[0,1,2,3],zmm25[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm1 = zmm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25],zero,zmm1[23],zero,zmm1[23,24,25,26],zero,zmm1[24],zero,zmm1[30,31,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,61],zero,zmm1[59],zero,zero,zero,zero,zmm1[62],zero,zmm1[60],zero,zero,zero,zero,zmm1[63],zero
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm28
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm4[0,1,2,3],zmm28[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm2 = zmm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[25],zero,zmm2[23],zero,zero,zero,zero,zmm2[26],zero,zmm2[24],zero,zero,zmm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm2[59],zero,zero,zero,zero,zmm2[62],zero,zmm2[60],zero,zero,zero,zero,zmm2[63],zero,zmm2[61]
; AVX512BW-FCP-NEXT:    vporq %zmm1, %zmm2, %zmm1
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512BW-FCP-NEXT:    movabsq $6971997760142192736, %r10 # imm = 0x60C183060C183060
; AVX512BW-FCP-NEXT:    kmovq %r10, %k2
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm20 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rax), %zmm31
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm1 = [11,13,12,11,12,13,13,12,11,13,12,11,12,13,13,12,62,61,62,63,63,62,62,63,62,61,62,63,63,62,62,63]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm31, %zmm6, %zmm1
; AVX512BW-FCP-NEXT:    movabsq $-9150747060186627967, %rax # imm = 0x8102040810204081
; AVX512BW-FCP-NEXT:    kmovq %rax, %k3
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm20 {%k3}
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rdx), %xmm5
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rcx), %xmm4
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm13 = [u,u,u,128,7,128,5,u,u,u,128,8,128,6,u,u]
; AVX512BW-FCP-NEXT:    vpshufb %xmm13, %xmm4, %xmm1
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm12 = [u,u,u,7,128,5,128,u,u,u,8,128,6,128,u,u]
; AVX512BW-FCP-NEXT:    vpshufb %xmm12, %xmm5, %xmm2
; AVX512BW-FCP-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX512BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm4[8],xmm5[8],xmm4[9],xmm5[9],xmm4[10],xmm5[10],xmm4[11],xmm5[11],xmm4[12],xmm5[12],xmm4[13],xmm5[13],xmm4[14],xmm5[14],xmm4[15],xmm5[15]
; AVX512BW-FCP-NEXT:    vpshufb %xmm29, %xmm2, %xmm2
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, %xmm2, %zmm1, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm11 = [u,128,7,128,5,u,u,u,128,8,128,6,u,u,u,128]
; AVX512BW-FCP-NEXT:    vpshufb %xmm11, %xmm1, %xmm29
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm8 = [u,7,128,5,128,u,u,u,8,128,6,128,u,u,u,9]
; AVX512BW-FCP-NEXT:    vpshufb %xmm8, %xmm2, %xmm30
; AVX512BW-FCP-NEXT:    vporq %xmm29, %xmm30, %xmm29
; AVX512BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm30 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; AVX512BW-FCP-NEXT:    vpshufb %xmm7, %xmm30, %xmm30
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, %xmm30, %zmm29, %zmm29
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm3 = zmm3[0,1,0,1,4,5,4,5]
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm29 = zmm29[0,1,0,1,4,5,4,5]
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm3, %zmm29 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqa64 32(%r9), %xmm30
; AVX512BW-FCP-NEXT:    vmovdqa 32(%r8), %xmm3
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm10 = [128,4,u,u,u,128,7,128,5,u,u,u,128,8,128,6]
; AVX512BW-FCP-NEXT:    vpshufb %xmm10, %xmm30, %xmm0
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm7 = [4,128,u,u,u,7,128,5,128,u,u,u,8,128,6,128]
; AVX512BW-FCP-NEXT:    vpshufb %xmm7, %xmm3, %xmm18
; AVX512BW-FCP-NEXT:    vporq %xmm0, %xmm18, %xmm0
; AVX512BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm18 = xmm3[8],xmm30[8],xmm3[9],xmm30[9],xmm3[10],xmm30[10],xmm3[11],xmm30[11],xmm3[12],xmm30[12],xmm3[13],xmm30[13],xmm3[14],xmm30[14],xmm3[15],xmm30[15]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm18 = xmm18[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, %xmm18, %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm18 = [2,2,2,4,2,2,2,4,3,3,3,3,2,2,2,4,52,53,52,53,53,54,53,54,52,53,52,53,53,54,53,54]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm31, %zmm6, %zmm18
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[0,1,0,1,4,5,4,5]
; AVX512BW-FCP-NEXT:    movabsq $290499906672591364, %rax # imm = 0x408102040810204
; AVX512BW-FCP-NEXT:    kmovq %rax, %k3
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm18, %zmm0 {%k3}
; AVX512BW-FCP-NEXT:    movabsq $-8714997200177740921, %rax # imm = 0x870E1C3870E1C387
; AVX512BW-FCP-NEXT:    kmovq %rax, %k3
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm0, %zmm29 {%k3}
; AVX512BW-FCP-NEXT:    vpshufb %xmm13, %xmm19, %xmm0
; AVX512BW-FCP-NEXT:    vpshufb %xmm12, %xmm17, %xmm6
; AVX512BW-FCP-NEXT:    vpor %xmm0, %xmm6, %xmm0
; AVX512BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm6 = xmm17[0],xmm19[0],xmm17[1],xmm19[1],xmm17[2],xmm19[2],xmm17[3],xmm19[3],xmm17[4],xmm19[4],xmm17[5],xmm19[5],xmm17[6],xmm19[6],xmm17[7],xmm19[7]
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm12 = [4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512BW-FCP-NEXT:    vpshufb %xmm12, %xmm6, %xmm6
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, %xmm0, %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vpshufb %xmm11, %xmm22, %xmm6
; AVX512BW-FCP-NEXT:    vpshufb %xmm8, %xmm21, %xmm8
; AVX512BW-FCP-NEXT:    vpor %xmm6, %xmm8, %xmm6
; AVX512BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm8 = xmm21[0],xmm22[0],xmm21[1],xmm22[1],xmm21[2],xmm22[2],xmm21[3],xmm22[3],xmm21[4],xmm22[4],xmm21[5],xmm22[5],xmm21[6],xmm22[6],xmm21[7],xmm22[7]
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm11 = [0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512BW-FCP-NEXT:    vpshufb %xmm11, %xmm8, %xmm8
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, %xmm6, %zmm8, %zmm6
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm8 = zmm0[0,1,0,1,4,5,4,5]
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm0 = zmm6[0,1,0,1,4,5,4,5]
; AVX512BW-FCP-NEXT:    movabsq $871499720017774092, %rax # imm = 0xC183060C183060C
; AVX512BW-FCP-NEXT:    kmovq %rax, %k3
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm8, %zmm0 {%k3}
; AVX512BW-FCP-NEXT:    vpshufb %xmm10, %xmm16, %xmm6
; AVX512BW-FCP-NEXT:    vpshufb %xmm7, %xmm15, %xmm7
; AVX512BW-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm7 = xmm15[0],xmm16[0],xmm15[1],xmm16[1],xmm15[2],xmm16[2],xmm15[3],xmm16[3],xmm15[4],xmm16[4],xmm15[5],xmm16[5],xmm15[6],xmm16[6],xmm15[7],xmm16[7]
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm10 = [u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb %xmm10, %xmm7, %xmm7
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, %xmm6, %zmm7, %zmm6
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm6 = zmm6[0,1,0,1,4,5,4,5]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%rsp), %zmm31, %zmm8 # 32-byte Folded Reload
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm7 = [1,1,0,0,1,1,0,0,4,5,1,1,1,1,0,0,18,18,18,20,18,18,18,20,19,19,19,19,18,18,18,20]
; AVX512BW-FCP-NEXT:    vpermw %zmm8, %zmm7, %zmm7
; AVX512BW-FCP-NEXT:    movabsq $4647998506761461824, %rax # imm = 0x4081020408102040
; AVX512BW-FCP-NEXT:    kmovq %rax, %k3
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm7, %zmm6 {%k3}
; AVX512BW-FCP-NEXT:    movabsq $8133997386832558192, %rax # imm = 0x70E1C3870E1C3870
; AVX512BW-FCP-NEXT:    kmovq %rax, %k3
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm6, %zmm0 {%k3}
; AVX512BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX512BW-FCP-NEXT:    vpshufb %xmm11, %xmm1, %xmm1
; AVX512BW-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm13[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,30],zero,ymm13[28],zero,ymm13[30,31,30,31],zero,ymm13[29],zero,ymm13[31,28,29]
; AVX512BW-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm6 = ymm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm15[30],zero,ymm15[28],zero,zero,zero,zero,ymm15[31],zero,ymm15[29],zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %ymm2, %ymm6, %ymm2
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm2[2,3,2,3],zmm1[0,1,0,1]
; AVX512BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3],xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; AVX512BW-FCP-NEXT:    vpshufb %xmm12, %xmm2, %xmm2
; AVX512BW-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27],zero,zero,zero,zero,ymm11[30],zero,ymm11[28],zero,zero,zero,zero,ymm11[31],zero,ymm11[29],zero
; AVX512BW-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm5 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm7[30],zero,ymm7[28],zero,zero,zero,zero,ymm7[31],zero,ymm7[29],zero,zero
; AVX512BW-FCP-NEXT:    vpor %ymm4, %ymm5, %ymm4
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm4[2,3,2,3],zmm2[0,1,0,1]
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm2 {%k1}
; AVX512BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm3[0],xmm30[0],xmm3[1],xmm30[1],xmm3[2],xmm30[2],xmm3[3],xmm30[3],xmm3[4],xmm30[4],xmm3[5],xmm30[5],xmm3[6],xmm30[6],xmm3[7],xmm30[7]
; AVX512BW-FCP-NEXT:    vpshufb %xmm10, %xmm1, %xmm1
; AVX512BW-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm5[27],zero,zero,zero,zero,ymm5[30],zero,ymm5[28],zero,zero,zero,zero,ymm5[31],zero
; AVX512BW-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm6[27],zero,zero,zero,zero,ymm6[30],zero,ymm6[28],zero,zero,zero,zero,ymm6[31],zero,ymm6[29]
; AVX512BW-FCP-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm3[2,3,2,3],zmm1[0,1,0,1]
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm3 = [14,13,14,15,15,14,14,15,14,13,14,15,15,14,14,15,17,17,16,16,17,17,16,16,20,21,17,17,17,17,16,16]
; AVX512BW-FCP-NEXT:    vpermw %zmm31, %zmm3, %zmm3
; AVX512BW-FCP-NEXT:    movabsq $580999813345182728, %rax # imm = 0x810204081020408
; AVX512BW-FCP-NEXT:    kmovq %rax, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    movabsq $1016749673354069774, %rax # imm = 0xE1C3870E1C3870E
; AVX512BW-FCP-NEXT:    kmovq %rax, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm2 {%k1}
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm15, %zmm26, %zmm1
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm1 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm1[18,19,20,21],zero,zmm1[19],zero,zmm1[21,20,21,22],zero,zmm1[20],zero,zmm1[22,23,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,57],zero,zmm1[55],zero,zero,zero,zero,zmm1[58],zero,zmm1[56],zero,zero,zero,zero,zmm1[59],zero
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm13, %zmm27, %zmm3
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm3 = zmm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm3[21],zero,zmm3[19],zero,zero,zero,zero,zmm3[22],zero,zmm3[20],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm3[55],zero,zero,zero,zero,zmm3[58],zero,zmm3[56],zero,zero,zero,zero,zmm3[59],zero,zmm3[57]
; AVX512BW-FCP-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm7, %zmm24, %zmm3
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm3[18],zero,zmm3[18,19,20,21],zero,zmm3[19],zero,zmm3[25,26,27,22],zero,zmm3[20],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm3[56,57],zero,zmm3[55],zero,zmm3[53,54,55,58],zero,zmm3[56],zero,zmm3[60,61,58,59]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm23, %zmm4
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm4 = zmm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm4[18],zero,zero,zero,zero,zmm4[21],zero,zmm4[19],zero,zero,zero,zero,zmm4[22],zero,zmm4[20,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zmm4[57],zero,zmm4[55],zero,zero,zero,zero,zmm4[58],zero,zmm4[56],zero,zero,zero,zero
; AVX512BW-FCP-NEXT:    vporq %zmm3, %zmm4, %zmm3
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm3 = zmm3[2,3,2,3,6,7,6,7]
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm3 {%k2}
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm6, %zmm28, %zmm1
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm1 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm1[20],zero,zmm1[18],zero,zmm1[20,21,20,21],zero,zmm1[19],zero,zmm1[19,20,21,22],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm1[56,57,56,57],zero,zmm1[55],zero,zmm1[55,56,57,58],zero,zmm1[56],zero,zmm1[62,63]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm5, %zmm25, %zmm4
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} zmm4 = zmm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm4[20],zero,zmm4[18],zero,zero,zero,zero,zmm4[21],zero,zmm4[19],zero,zero,zero,zero,zmm4[22,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm4[57],zero,zmm4[55],zero,zero,zero,zero,zmm4[58],zero,zmm4[56],zero,zero
; AVX512BW-FCP-NEXT:    vporq %zmm1, %zmm4, %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [10,9,9,10,10,9,9,10,9,10,14,15,10,9,9,10,27,29,28,27,28,29,29,28,27,29,28,27,28,29,29,28]
; AVX512BW-FCP-NEXT:    vpermw %zmm8, %zmm4, %zmm4
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512BW-FCP-NEXT:    movabsq $1161999626690365456, %rax # imm = 0x1020408102040810
; AVX512BW-FCP-NEXT:    kmovq %rax, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm4, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    movabsq $2033499346708139548, %rax # imm = 0x1C3870E1C3870E1C
; AVX512BW-FCP-NEXT:    kmovq %rax, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm3 {%k1}
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, 128(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, 320(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 192(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, (%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm29, 256(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, 64(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, 384(%rax)
; AVX512BW-FCP-NEXT:    addq $104, %rsp
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i8_stride7_vf64:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    vmovdqa (%rax), %ymm13
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} ymm26 = [12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX512DQ-BW-NEXT:    vpshufb %ymm26, %ymm13, %ymm0
; AVX512DQ-BW-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,5,4,5,5,6,5,6,4,5,4,5,5,6,5,6]
; AVX512DQ-BW-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512DQ-BW-NEXT:    vpermw %ymm13, %ymm1, %ymm1
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa (%r9), %ymm9
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} ymm17 = [13,128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128]
; AVX512DQ-BW-NEXT:    vpshufb %ymm17, %ymm9, %ymm1
; AVX512DQ-BW-NEXT:    vmovdqa (%r8), %ymm10
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} ymm21 = [128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128]
; AVX512DQ-BW-NEXT:    vpshufb %ymm21, %ymm10, %ymm2
; AVX512DQ-BW-NEXT:    vpor %ymm1, %ymm2, %ymm2
; AVX512DQ-BW-NEXT:    vmovdqa (%r9), %xmm1
; AVX512DQ-BW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa (%r8), %xmm12
; AVX512DQ-BW-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm12[8],xmm1[8],xmm12[9],xmm1[9],xmm12[10],xmm1[10],xmm12[11],xmm1[11],xmm12[12],xmm1[12],xmm12[13],xmm1[13],xmm12[14],xmm1[14],xmm12[15],xmm1[15]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm4, %zmm8
; AVX512DQ-BW-NEXT:    movabsq $2323999253380730912, %r10 # imm = 0x2040810204081020
; AVX512DQ-BW-NEXT:    kmovq %r10, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm0, %zmm8 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %ymm14
; AVX512DQ-BW-NEXT:    vmovdqa {{.*#+}} ymm0 = [0,1,0,1,14,128,14,15,0,1,14,15,128,13,14,15,16,17,16,128,30,31,30,31,16,17,128,31,28,29,30,31]
; AVX512DQ-BW-NEXT:    vpshufb %ymm0, %ymm14, %ymm2
; AVX512DQ-BW-NEXT:    vmovdqa (%rcx), %ymm15
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} ymm20 = [128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128]
; AVX512DQ-BW-NEXT:    vpshufb %ymm20, %ymm15, %ymm4
; AVX512DQ-BW-NEXT:    vpor %ymm2, %ymm4, %ymm2
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512DQ-BW-NEXT:    vmovdqa (%rcx), %xmm5
; AVX512DQ-BW-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm5[8],xmm4[8],xmm5[9],xmm4[9],xmm5[10],xmm4[10],xmm5[11],xmm4[11],xmm5[12],xmm4[12],xmm5[13],xmm4[13],xmm5[14],xmm4[14],xmm5[15],xmm4[15]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm6, %zmm22
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %ymm18
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} ymm24 = [0,1,14,128,12,13,0,1,14,15,128,3,12,13,2,3,16,128,30,31,28,29,16,17,128,31,18,19,28,29,18,128]
; AVX512DQ-BW-NEXT:    vpshufb %ymm24, %ymm18, %ymm2
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %ymm19
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} ymm25 = [128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128,128,18]
; AVX512DQ-BW-NEXT:    vpshufb %ymm25, %ymm19, %ymm6
; AVX512DQ-BW-NEXT:    vpor %ymm2, %ymm6, %ymm2
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm6
; AVX512DQ-BW-NEXT:    vmovdqa (%rsi), %xmm7
; AVX512DQ-BW-NEXT:    vpunpckhbw {{.*#+}} xmm23 = xmm7[8],xmm6[8],xmm7[9],xmm6[9],xmm7[10],xmm6[10],xmm7[11],xmm6[11],xmm7[12],xmm6[12],xmm7[13],xmm6[13],xmm7[14],xmm6[14],xmm7[15],xmm6[15]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm23 = xmm23[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm23 = ymm23[0,1,0,1]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm23, %zmm3
; AVX512DQ-BW-NEXT:    movabsq $435749860008887046, %r10 # imm = 0x60C183060C18306
; AVX512DQ-BW-NEXT:    kmovq %r10, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm22, %zmm3 {%k1}
; AVX512DQ-BW-NEXT:    movabsq $4066998693416279096, %r10 # imm = 0x3870E1C3870E1C38
; AVX512DQ-BW-NEXT:    kmovq %r10, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm8, %zmm3 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 32(%rdx), %ymm29
; AVX512DQ-BW-NEXT:    vpshufb %ymm0, %ymm29, %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa64 32(%rcx), %ymm30
; AVX512DQ-BW-NEXT:    vpshufb %ymm20, %ymm30, %ymm8
; AVX512DQ-BW-NEXT:    vpor %ymm0, %ymm8, %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,18,128,18,19,20,21,128,19,128,25,26,27,22,128,20,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,24,25,128,23,128,21,22,23,26,128,24,128,28,29,26,27]
; AVX512DQ-BW-NEXT:    vpshufb %ymm20, %ymm29, %ymm8
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128]
; AVX512DQ-BW-NEXT:    vpshufb %ymm22, %ymm30, %ymm23
; AVX512DQ-BW-NEXT:    vporq %ymm8, %ymm23, %ymm8
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm8, %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 32(%rsi), %ymm28
; AVX512DQ-BW-NEXT:    vmovdqa64 32(%rdi), %ymm16
; AVX512DQ-BW-NEXT:    vpshuflw {{.*#+}} ymm8 = ymm16[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512DQ-BW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm8[0,0,1,1,4,4,5,5]
; AVX512DQ-BW-NEXT:    vpbroadcastd {{.*#+}} ymm23 = [5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6]
; AVX512DQ-BW-NEXT:    movl $676341840, %r10d # imm = 0x28502850
; AVX512DQ-BW-NEXT:    kmovd %r10d, %k1
; AVX512DQ-BW-NEXT:    vpshufb %ymm23, %ymm28, %ymm8 {%k1}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,3,2,3]
; AVX512DQ-BW-NEXT:    vpshufb %ymm24, %ymm16, %ymm24
; AVX512DQ-BW-NEXT:    vpshufb %ymm25, %ymm28, %ymm25
; AVX512DQ-BW-NEXT:    vporq %ymm24, %ymm25, %ymm24
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm8, %zmm24, %zmm8
; AVX512DQ-BW-NEXT:    movabsq $3485998880071096368, %r10 # imm = 0x3060C183060C1830
; AVX512DQ-BW-NEXT:    kmovq %r10, %k2
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm0, %zmm8 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqa64 32(%r9), %ymm31
; AVX512DQ-BW-NEXT:    vpshufb %ymm17, %ymm31, %ymm17
; AVX512DQ-BW-NEXT:    vmovdqa 32(%r8), %ymm1
; AVX512DQ-BW-NEXT:    vpshufb %ymm21, %ymm1, %ymm21
; AVX512DQ-BW-NEXT:    vporq %ymm17, %ymm21, %ymm17
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} zmm24 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,20,128,18,128,20,21,20,21,128,19,128,19,20,21,22,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,24,25,24,25,128,23,128,23,24,25,26,128,24,128,30,31]
; AVX512DQ-BW-NEXT:    vpshufb %ymm24, %ymm1, %ymm21
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} zmm25 = [u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,128,128,128,25,128,23,128,128,128,128,26,128,24,128,128]
; AVX512DQ-BW-NEXT:    vpshufb %ymm25, %ymm31, %ymm27
; AVX512DQ-BW-NEXT:    vporq %ymm21, %ymm27, %ymm21
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm21 = ymm21[2,3,2,3]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm21, %zmm17, %zmm21
; AVX512DQ-BW-NEXT:    vmovdqa64 32(%rax), %ymm17
; AVX512DQ-BW-NEXT:    vpshufb %ymm26, %ymm17, %ymm27
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm26 = [10,9,9,10,10,9,9,10,9,10,14,15,10,9,9,10,27,29,28,27,28,29,29,28,27,29,28,27,28,29,29,28]
; AVX512DQ-BW-NEXT:    vpermw %ymm17, %ymm26, %ymm11
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm11, %zmm27, %zmm11
; AVX512DQ-BW-NEXT:    movabsq $145249953336295682, %r10 # imm = 0x204081020408102
; AVX512DQ-BW-NEXT:    kmovq %r10, %k3
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm11, %zmm21 {%k3}
; AVX512DQ-BW-NEXT:    movabsq $-4357498600088870461, %r10 # imm = 0xC3870E1C3870E1C3
; AVX512DQ-BW-NEXT:    kmovq %r10, %k3
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm21, %zmm8 {%k3}
; AVX512DQ-BW-NEXT:    vpshufhw {{.*#+}} ymm11 = ymm16[0,1,2,3,6,7,7,6,8,9,10,11,14,15,15,14]
; AVX512DQ-BW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm11[2,2,3,3,6,6,7,7]
; AVX512DQ-BW-NEXT:    movl $338170920, %r10d # imm = 0x14281428
; AVX512DQ-BW-NEXT:    kmovd %r10d, %k4
; AVX512DQ-BW-NEXT:    vpbroadcastd {{.*#+}} ymm27 = [13,12,15,14,13,12,15,14,13,12,15,14,13,12,15,14,13,12,15,14,13,12,15,14,13,12,15,14,13,12,15,14]
; AVX512DQ-BW-NEXT:    vpshufb %ymm27, %ymm28, %ymm11 {%k4}
; AVX512DQ-BW-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [25,128,23,128,128,128,128,26,128,24,128,128,128,128,27,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128,27,128]
; AVX512DQ-BW-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512DQ-BW-NEXT:    vpshufb %ymm2, %ymm28, %ymm21
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} ymm28 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,23,128,128,128,128,26,128,24,128,128,128,128,27,128,25]
; AVX512DQ-BW-NEXT:    vpshufb %ymm28, %ymm16, %ymm16
; AVX512DQ-BW-NEXT:    vporq %ymm21, %ymm16, %ymm16
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm11, %zmm16, %zmm16
; AVX512DQ-BW-NEXT:    vpshufhw {{.*#+}} ymm11 = ymm29[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512DQ-BW-NEXT:    vpshufd {{.*#+}} ymm21 = ymm11[0,2,3,3,4,6,7,7]
; AVX512DQ-BW-NEXT:    vpbroadcastq {{.*#+}} ymm11 = [11,0,0,0,15,14,13,12,11,0,0,0,15,14,13,12,11,0,0,0,15,14,13,12,11,0,0,0,15,14,13,12]
; AVX512DQ-BW-NEXT:    vpshufb %ymm11, %ymm30, %ymm0
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm21, %ymm0 {%k1}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm21 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm29[24,25],zero,ymm29[23],zero,ymm29[21,22,23,26],zero,ymm29[24],zero,ymm29[28,29,26,27]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm29 = ymm30[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm30[25],zero,ymm30[23],zero,zero,zero,zero,ymm30[26],zero,ymm30[24],zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vporq %ymm21, %ymm29, %ymm21
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm21, %zmm0
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm16 = zmm16[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-NEXT:    movabsq $1742999440035548184, %r10 # imm = 0x183060C183060C18
; AVX512DQ-BW-NEXT:    kmovq %r10, %k3
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm0, %zmm16 {%k3}
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r9), %zmm0
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm1[0,1,2,3],zmm0[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} zmm1 = zmm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25],zero,zmm1[23],zero,zmm1[23,24,25,26],zero,zmm1[24],zero,zmm1[30,31,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,61],zero,zmm1[59],zero,zero,zero,zero,zmm1[62],zero,zmm1[60],zero,zero,zero,zero,zmm1[63],zero
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r8), %zmm29
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm21 = zmm31[0,1,2,3],zmm29[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} zmm21 = zmm21[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm21[25],zero,zmm21[23],zero,zero,zero,zero,zmm21[26],zero,zmm21[24],zero,zero,zmm21[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm21[59],zero,zero,zero,zero,zmm21[62],zero,zmm21[60],zero,zero,zero,zero,zmm21[63],zero,zmm21[61]
; AVX512DQ-BW-NEXT:    vporq %zmm1, %zmm21, %zmm1
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-NEXT:    movabsq $6971997760142192736, %r10 # imm = 0x60C183060C183060
; AVX512DQ-BW-NEXT:    kmovq %r10, %k3
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm1, %zmm16 {%k3}
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rax), %zmm21
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm1 = [11,13,12,11,12,13,13,12,11,13,12,11,12,13,13,12,62,61,62,63,63,62,62,63,62,61,62,63,63,62,62,63]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm21, %zmm17, %zmm1
; AVX512DQ-BW-NEXT:    movabsq $-9150747060186627967, %rax # imm = 0x8102040810204081
; AVX512DQ-BW-NEXT:    kmovq %rax, %k5
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm1, %zmm16 {%k5}
; AVX512DQ-BW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm18[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512DQ-BW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,0,1,1,4,4,5,5]
; AVX512DQ-BW-NEXT:    vpshufb %ymm23, %ymm19, %ymm1 {%k1}
; AVX512DQ-BW-NEXT:    vpshufb %ymm2, %ymm19, %ymm2
; AVX512DQ-BW-NEXT:    vpshufb %ymm28, %ymm18, %ymm23
; AVX512DQ-BW-NEXT:    vporq %ymm2, %ymm23, %ymm2
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm14, %zmm2, %zmm2
; AVX512DQ-BW-NEXT:    vpshufb %zmm20, %zmm2, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm20
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm15, %zmm20, %zmm20
; AVX512DQ-BW-NEXT:    vpshufb %zmm22, %zmm20, %zmm20
; AVX512DQ-BW-NEXT:    vporq %zmm2, %zmm20, %zmm2
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm20 = zmm2[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm1, %zmm20 {%k3}
; AVX512DQ-BW-NEXT:    vmovdqa64 32(%r9), %xmm22
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm10, %zmm29, %zmm1
; AVX512DQ-BW-NEXT:    vpshufb %zmm24, %zmm1, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 32(%r8), %xmm23
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm9, %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vpshufb %zmm25, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa 32(%rdx), %xmm0
; AVX512DQ-BW-NEXT:    vporq %zmm1, %zmm2, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa 32(%rcx), %xmm2
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm13, %zmm21, %zmm13
; AVX512DQ-BW-NEXT:    vpermw %zmm13, %zmm26, %zmm24
; AVX512DQ-BW-NEXT:    movabsq $1161999626690365456, %rax # imm = 0x1020408102040810
; AVX512DQ-BW-NEXT:    kmovq %rax, %k5
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm24, %zmm1 {%k5}
; AVX512DQ-BW-NEXT:    vmovdqa64 32(%rdi), %xmm24
; AVX512DQ-BW-NEXT:    movabsq $2033499346708139548, %rax # imm = 0x1C3870E1C3870E1C
; AVX512DQ-BW-NEXT:    kmovq %rax, %k5
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm1, %zmm20 {%k5}
; AVX512DQ-BW-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX512DQ-BW-NEXT:    vpshufhw {{.*#+}} ymm18 = ymm18[0,1,2,3,6,7,7,6,8,9,10,11,14,15,15,14]
; AVX512DQ-BW-NEXT:    vpshufd {{.*#+}} ymm25 = ymm18[2,2,3,3,6,6,7,7]
; AVX512DQ-BW-NEXT:    vpshufb %ymm27, %ymm19, %ymm25 {%k4}
; AVX512DQ-BW-NEXT:    vpunpcklbw {{.*#+}} xmm19 = xmm24[0],xmm1[0],xmm24[1],xmm1[1],xmm24[2],xmm1[2],xmm24[3],xmm1[3],xmm24[4],xmm1[4],xmm24[5],xmm1[5],xmm24[6],xmm1[6],xmm24[7],xmm1[7]
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} xmm18 = [0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512DQ-BW-NEXT:    vpshufb %xmm18, %xmm19, %xmm19
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm25 = zmm25[2,3,2,3],zmm19[0,1,0,1]
; AVX512DQ-BW-NEXT:    vpunpcklbw {{.*#+}} xmm26 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; AVX512DQ-BW-NEXT:    vpshufb %ymm11, %ymm15, %ymm11
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} xmm19 = [4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512DQ-BW-NEXT:    vpshufb %xmm19, %xmm26, %xmm15
; AVX512DQ-BW-NEXT:    vpshufhw {{.*#+}} ymm14 = ymm14[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512DQ-BW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm14[0,2,3,3,4,6,7,7]
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm14, %ymm11 {%k1}
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm11[2,3,2,3],zmm15[0,1,0,1]
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm25, %zmm14 {%k2}
; AVX512DQ-BW-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm23[0],xmm22[0],xmm23[1],xmm22[1],xmm23[2],xmm22[2],xmm23[3],xmm22[3],xmm23[4],xmm22[4],xmm23[5],xmm22[5],xmm23[6],xmm22[6],xmm23[7],xmm22[7]
; AVX512DQ-BW-NEXT:    vmovdqa {{.*#+}} xmm15 = [u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb %xmm15, %xmm11, %xmm11
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm9[27],zero,zero,zero,zero,ymm9[30],zero,ymm9[28],zero,zero,zero,zero,ymm9[31],zero
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm10[27],zero,zero,zero,zero,ymm10[30],zero,ymm10[28],zero,zero,zero,zero,ymm10[31],zero,ymm10[29]
; AVX512DQ-BW-NEXT:    vpor %ymm9, %ymm10, %ymm9
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm9 = zmm9[2,3,2,3],zmm11[0,1,0,1]
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm10 = [14,13,14,15,15,14,14,15,14,13,14,15,15,14,14,15,17,17,16,16,17,17,16,16,20,21,17,17,17,17,16,16]
; AVX512DQ-BW-NEXT:    vpermw %zmm21, %zmm10, %zmm10
; AVX512DQ-BW-NEXT:    movabsq $580999813345182728, %rax # imm = 0x810204081020408
; AVX512DQ-BW-NEXT:    kmovq %rax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm10, %zmm9 {%k1}
; AVX512DQ-BW-NEXT:    movabsq $1016749673354069774, %rax # imm = 0xE1C3870E1C3870E
; AVX512DQ-BW-NEXT:    kmovq %rax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm9, %zmm14 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa {{.*#+}} xmm10 = [u,u,u,128,7,128,5,u,u,u,128,8,128,6,u,u]
; AVX512DQ-BW-NEXT:    vpshufb %xmm10, %xmm2, %xmm9
; AVX512DQ-BW-NEXT:    vmovdqa {{.*#+}} xmm11 = [u,u,u,7,128,5,128,u,u,u,8,128,6,128,u,u]
; AVX512DQ-BW-NEXT:    vpshufb %xmm11, %xmm0, %xmm25
; AVX512DQ-BW-NEXT:    vporq %xmm9, %xmm25, %xmm9
; AVX512DQ-BW-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, %xmm0, %zmm9, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa {{.*#+}} xmm2 = [u,128,7,128,5,u,u,u,128,8,128,6,u,u,u,128]
; AVX512DQ-BW-NEXT:    vpshufb %xmm2, %xmm1, %xmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} xmm25 = [u,7,128,5,128,u,u,u,8,128,6,128,u,u,u,9]
; AVX512DQ-BW-NEXT:    vpshufb %xmm25, %xmm24, %xmm26
; AVX512DQ-BW-NEXT:    vporq %xmm9, %xmm26, %xmm9
; AVX512DQ-BW-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm1[8],xmm24[8],xmm1[9],xmm24[9],xmm1[10],xmm24[10],xmm1[11],xmm24[11],xmm1[12],xmm24[12],xmm1[13],xmm24[13],xmm1[14],xmm24[14],xmm1[15],xmm24[15]
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, %xmm1, %zmm9, %zmm1
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm9 = zmm1[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm0, %zmm9 {%k3}
; AVX512DQ-BW-NEXT:    vmovdqa {{.*#+}} xmm0 = [128,4,u,u,u,128,7,128,5,u,u,u,128,8,128,6]
; AVX512DQ-BW-NEXT:    vpshufb %xmm0, %xmm22, %xmm1
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm24 = [2,2,2,4,2,2,2,4,3,3,3,3,2,2,2,4,52,53,52,53,53,54,53,54,52,53,52,53,53,54,53,54]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm21, %zmm17, %zmm24
; AVX512DQ-BW-NEXT:    vmovdqa64 {{.*#+}} xmm17 = [4,128,u,u,u,7,128,5,128,u,u,u,8,128,6,128]
; AVX512DQ-BW-NEXT:    vpshufb %xmm17, %xmm23, %xmm21
; AVX512DQ-BW-NEXT:    vporq %xmm1, %xmm21, %xmm1
; AVX512DQ-BW-NEXT:    vpunpckhbw {{.*#+}} xmm21 = xmm23[8],xmm22[8],xmm23[9],xmm22[9],xmm23[10],xmm22[10],xmm23[11],xmm22[11],xmm23[12],xmm22[12],xmm23[13],xmm22[13],xmm23[14],xmm22[14],xmm23[15],xmm22[15]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm21 = xmm21[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, %xmm21, %zmm1, %zmm1
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-NEXT:    movabsq $290499906672591364, %rax # imm = 0x408102040810204
; AVX512DQ-BW-NEXT:    kmovq %rax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm24, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    movabsq $-8714997200177740921, %rax # imm = 0x870E1C3870E1C387
; AVX512DQ-BW-NEXT:    kmovq %rax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm1, %zmm9 {%k1}
; AVX512DQ-BW-NEXT:    vpshufb %xmm10, %xmm5, %xmm1
; AVX512DQ-BW-NEXT:    vpshufb %xmm11, %xmm4, %xmm10
; AVX512DQ-BW-NEXT:    vpor %xmm1, %xmm10, %xmm1
; AVX512DQ-BW-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1],xmm4[2],xmm5[2],xmm4[3],xmm5[3],xmm4[4],xmm5[4],xmm4[5],xmm5[5],xmm4[6],xmm5[6],xmm4[7],xmm5[7]
; AVX512DQ-BW-NEXT:    vpshufb %xmm19, %xmm4, %xmm4
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, %xmm1, %zmm4, %zmm1
; AVX512DQ-BW-NEXT:    vpshufb %xmm2, %xmm7, %xmm2
; AVX512DQ-BW-NEXT:    vpshufb %xmm25, %xmm6, %xmm4
; AVX512DQ-BW-NEXT:    vpor %xmm2, %xmm4, %xmm2
; AVX512DQ-BW-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm6[0],xmm7[0],xmm6[1],xmm7[1],xmm6[2],xmm7[2],xmm6[3],xmm7[3],xmm6[4],xmm7[4],xmm6[5],xmm7[5],xmm6[6],xmm7[6],xmm6[7],xmm7[7]
; AVX512DQ-BW-NEXT:    vpshufb %xmm18, %xmm4, %xmm4
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, %xmm2, %zmm4, %zmm2
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm2 = zmm2[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-NEXT:    movabsq $871499720017774092, %rax # imm = 0xC183060C183060C
; AVX512DQ-BW-NEXT:    kmovq %rax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm1, %zmm2 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX512DQ-BW-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX512DQ-BW-NEXT:    vpshufb %xmm17, %xmm12, %xmm1
; AVX512DQ-BW-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX512DQ-BW-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm12[0],xmm4[0],xmm12[1],xmm4[1],xmm12[2],xmm4[2],xmm12[3],xmm4[3],xmm12[4],xmm4[4],xmm12[5],xmm4[5],xmm12[6],xmm4[6],xmm12[7],xmm4[7]
; AVX512DQ-BW-NEXT:    vpshufb %xmm15, %xmm1, %xmm1
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, %xmm0, %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm1 = [1,1,0,0,1,1,0,0,4,5,1,1,1,1,0,0,18,18,18,20,18,18,18,20,19,19,19,19,18,18,18,20]
; AVX512DQ-BW-NEXT:    vpermw %zmm13, %zmm1, %zmm1
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-NEXT:    movabsq $4647998506761461824, %rax # imm = 0x4081020408102040
; AVX512DQ-BW-NEXT:    kmovq %rax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm1, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    movabsq $8133997386832558192, %rax # imm = 0x70E1C3870E1C3870
; AVX512DQ-BW-NEXT:    kmovq %rax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm0, %zmm2 {%k1}
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, 320(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, 256(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, 192(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, 128(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, 64(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, 384(%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i8_stride7_vf64:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    subq $104, %rsp
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rax), %ymm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu %ymm2, (%rsp) # 32-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 {{.*#+}} ymm20 = [12,13,2,3,12,13,0,1,14,15,2,3,0,1,14,15,28,29,18,19,28,29,16,17,30,31,18,19,16,17,30,31]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm20, %ymm2, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,5,4,5,5,6,5,6,4,5,4,5,5,6,5,6]
; AVX512DQ-BW-FCP-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vpermw %ymm2, %ymm1, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r9), %ymm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [13,128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm0, %ymm1, %ymm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r8), %ymm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} ymm1 = [128,128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm1, %ymm4, %ymm4
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r9), %xmm16
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r8), %xmm15
; AVX512DQ-BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm15[8],xmm16[8],xmm15[9],xmm16[9],xmm15[10],xmm16[10],xmm15[11],xmm16[11],xmm15[12],xmm16[12],xmm15[13],xmm16[13],xmm15[14],xmm16[14],xmm15[15],xmm16[15]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm3
; AVX512DQ-BW-FCP-NEXT:    movabsq $2323999253380730912, %r10 # imm = 0x2040810204081020
; AVX512DQ-BW-FCP-NEXT:    kmovq %r10, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm2, %zmm3 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %ymm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,0,1,14,128,14,15,0,1,14,15,128,13,14,15,16,17,16,128,30,31,30,31,16,17,128,31,28,29,30,31]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm2, %ymm4, %ymm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rcx), %ymm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} ymm5 = [128,128,128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm5, %ymm6, %ymm6
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm4, %ymm6, %ymm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %xmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %xmm19
; AVX512DQ-BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm19[8],xmm17[8],xmm19[9],xmm17[9],xmm19[10],xmm17[10],xmm19[11],xmm17[11],xmm19[12],xmm17[12],xmm19[13],xmm17[13],xmm19[14],xmm17[14],xmm19[15],xmm17[15]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 {{.*#+}} xmm29 = [6,3,2,u,u,u,9,8,5,4,u,u,u,11,10,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm29, %xmm6, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm4, %zmm6, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} ymm9 = [0,1,14,128,12,13,0,1,14,15,128,3,12,13,2,3,16,128,30,31,28,29,16,17,128,31,18,19,28,29,18,128]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm9, %ymm6, %ymm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rsi), %ymm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 {{.*#+}} ymm23 = [128,128,128,14,128,128,128,128,128,128,15,128,128,128,128,128,128,16,128,128,128,128,128,128,17,128,128,128,128,128,128,18]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm23, %ymm7, %ymm21
; AVX512DQ-BW-FCP-NEXT:    vporq %ymm6, %ymm21, %ymm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %xmm21
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %xmm22
; AVX512DQ-BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm24 = xmm22[8],xmm21[8],xmm22[9],xmm21[9],xmm22[10],xmm21[10],xmm22[11],xmm21[11],xmm22[12],xmm21[12],xmm22[13],xmm21[13],xmm22[14],xmm21[14],xmm22[15],xmm21[15]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm7 = [2,u,u,u,9,8,5,4,u,u,u,11,10,7,6,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm7, %xmm24, %xmm24
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm24 = ymm24[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm6, %zmm24, %zmm14
; AVX512DQ-BW-FCP-NEXT:    movabsq $435749860008887046, %r10 # imm = 0x60C183060C18306
; AVX512DQ-BW-FCP-NEXT:    kmovq %r10, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm4, %zmm14 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movabsq $4066998693416279096, %r10 # imm = 0x3870E1C3870E1C38
; AVX512DQ-BW-FCP-NEXT:    kmovq %r10, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm3, %zmm14 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rdx), %ymm3
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm2, %ymm3, %ymm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rcx), %ymm2
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm5, %ymm2, %ymm5
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm4, %ymm5, %ymm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,18,128,18,19,20,21,128,19,128,25,26,27,22,128,20,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,24,25,128,23,128,21,22,23,26,128,24,128,28,29,26,27]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm5, %ymm3, %ymm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,18,128,128,128,128,21,128,19,128,128,128,128,22,128,20,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,128,25,128,23,128,128,128,128,26,128,24,128,128,128,128]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm6, %ymm2, %ymm24
; AVX512DQ-BW-FCP-NEXT:    vporq %ymm5, %ymm24, %ymm5
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm5, %zmm4, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm9, %ymm5, %ymm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 32(%rsi), %ymm25
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm23, %ymm25, %ymm23
; AVX512DQ-BW-FCP-NEXT:    vporq %ymm9, %ymm23, %ymm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,18,19,20,21,128,19,128,21,20,21,22,128,20,128,22,23,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25,128,23,128,128,128,128,26,128,24,128,128,128,128,27,128]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm6, %ymm5, %ymm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,128,128,128,21,128,19,128,128,128,128,22,128,20,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,23,128,128,128,128,26,128,24,128,128,128,128,27,128,25]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm6, %ymm25, %ymm24
; AVX512DQ-BW-FCP-NEXT:    vporq %ymm23, %ymm24, %ymm23
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm23 = ymm23[2,3,2,3]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm23, %zmm9, %zmm9
; AVX512DQ-BW-FCP-NEXT:    movabsq $3485998880071096368, %r10 # imm = 0x3060C183060C1830
; AVX512DQ-BW-FCP-NEXT:    kmovq %r10, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm4, %zmm9 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%r9), %ymm4
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm0, %ymm4, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 32(%r8), %ymm28
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm1, %ymm28, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,20,128,18,128,20,21,20,21,128,19,128,19,20,21,22,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,24,25,24,25,128,23,128,23,24,25,26,128,24,128,30,31]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm1, %ymm28, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,20,128,18,128,128,128,128,21,128,19,128,128,128,128,22,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,128,128,128,128,25,128,23,128,128,128,128,26,128,24,128,128]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm6, %ymm4, %ymm23
; AVX512DQ-BW-FCP-NEXT:    vporq %ymm1, %ymm23, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rax), %ymm6
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm23 = [10,9,9,10,10,9,9,10,9,10,14,15,10,9,9,10]
; AVX512DQ-BW-FCP-NEXT:    vpermw %ymm6, %ymm23, %ymm23
; AVX512DQ-BW-FCP-NEXT:    vpshufb %ymm20, %ymm6, %ymm20
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm23, %zmm20, %zmm20
; AVX512DQ-BW-FCP-NEXT:    movabsq $145249953336295682, %r10 # imm = 0x204081020408102
; AVX512DQ-BW-FCP-NEXT:    kmovq %r10, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm20, %zmm1 {%k2}
; AVX512DQ-BW-FCP-NEXT:    movabsq $-4357498600088870461, %r10 # imm = 0xC3870E1C3870E1C3
; AVX512DQ-BW-FCP-NEXT:    kmovq %r10, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm9 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm23
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm3[0,1,2,3],zmm23[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm1 = zmm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25],zero,zmm1[23],zero,zmm1[21,22,23,26],zero,zmm1[24],zero,zmm1[28,29,26,27,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,59],zero,zero,zero,zero,zmm1[62],zero,zmm1[60],zero,zero,zero,zero,zmm1[63],zero,zmm1[61],zero
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm24
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm24[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm2 = zmm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zmm2[25],zero,zmm2[23],zero,zero,zero,zero,zmm2[26],zero,zmm2[24],zero,zero,zero,zero,zmm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[62],zero,zmm2[60],zero,zero,zero,zero,zmm2[63],zero,zmm2[61],zero,zero
; AVX512DQ-BW-FCP-NEXT:    vporq %zmm1, %zmm2, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm26
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm25[0,1,2,3],zmm26[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm2 = zmm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,25],zero,zmm2[23],zero,zero,zero,zero,zmm2[26],zero,zmm2[24],zero,zero,zero,zero,zmm2[27],zero,zmm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,60,61,62],zero,zmm2[60],zero,zmm2[62,63,62,63],zero,zmm2[61],zero,zmm2[63,60,61]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm27
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm5[0,1,2,3],zmm27[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm3 = zmm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm3[23],zero,zero,zero,zero,zmm3[26],zero,zmm3[24],zero,zero,zero,zero,zmm3[27],zero,zmm3[25,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zmm3[62],zero,zmm3[60],zero,zero,zero,zero,zmm3[63],zero,zmm3[61],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vporq %zmm2, %zmm3, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm20 = zmm2[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-FCP-NEXT:    movabsq $1742999440035548184, %r10 # imm = 0x183060C183060C18
; AVX512DQ-BW-FCP-NEXT:    kmovq %r10, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm20 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r9), %zmm25
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm28[0,1,2,3],zmm25[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm1 = zmm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25],zero,zmm1[23],zero,zmm1[23,24,25,26],zero,zmm1[24],zero,zmm1[30,31,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,61],zero,zmm1[59],zero,zero,zero,zero,zmm1[62],zero,zmm1[60],zero,zero,zero,zero,zmm1[63],zero
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm28
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm4[0,1,2,3],zmm28[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm2 = zmm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm2[25],zero,zmm2[23],zero,zero,zero,zero,zmm2[26],zero,zmm2[24],zero,zero,zmm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm2[59],zero,zero,zero,zero,zmm2[62],zero,zmm2[60],zero,zero,zero,zero,zmm2[63],zero,zmm2[61]
; AVX512DQ-BW-FCP-NEXT:    vporq %zmm1, %zmm2, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-FCP-NEXT:    movabsq $6971997760142192736, %r10 # imm = 0x60C183060C183060
; AVX512DQ-BW-FCP-NEXT:    kmovq %r10, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm20 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rax), %zmm31
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm1 = [11,13,12,11,12,13,13,12,11,13,12,11,12,13,13,12,62,61,62,63,63,62,62,63,62,61,62,63,63,62,62,63]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm31, %zmm6, %zmm1
; AVX512DQ-BW-FCP-NEXT:    movabsq $-9150747060186627967, %rax # imm = 0x8102040810204081
; AVX512DQ-BW-FCP-NEXT:    kmovq %rax, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm20 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rdx), %xmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rcx), %xmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm13 = [u,u,u,128,7,128,5,u,u,u,128,8,128,6,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm13, %xmm4, %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm12 = [u,u,u,7,128,5,128,u,u,u,8,128,6,128,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm12, %xmm5, %xmm2
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX512DQ-BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm4[8],xmm5[8],xmm4[9],xmm5[9],xmm4[10],xmm5[10],xmm4[11],xmm5[11],xmm4[12],xmm5[12],xmm4[13],xmm5[13],xmm4[14],xmm5[14],xmm4[15],xmm5[15]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm29, %xmm2, %xmm2
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, %xmm2, %zmm1, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm11 = [u,128,7,128,5,u,u,u,128,8,128,6,u,u,u,128]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm11, %xmm1, %xmm29
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm8 = [u,7,128,5,128,u,u,u,8,128,6,128,u,u,u,9]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm8, %xmm2, %xmm30
; AVX512DQ-BW-FCP-NEXT:    vporq %xmm29, %xmm30, %xmm29
; AVX512DQ-BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm30 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm7, %xmm30, %xmm30
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, %xmm30, %zmm29, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm3 = zmm3[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm29 = zmm29[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm3, %zmm29 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 32(%r9), %xmm30
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%r8), %xmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm10 = [128,4,u,u,u,128,7,128,5,u,u,u,128,8,128,6]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm10, %xmm30, %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm7 = [4,128,u,u,u,7,128,5,128,u,u,u,8,128,6,128]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm7, %xmm3, %xmm18
; AVX512DQ-BW-FCP-NEXT:    vporq %xmm0, %xmm18, %xmm0
; AVX512DQ-BW-FCP-NEXT:    vpunpckhbw {{.*#+}} xmm18 = xmm3[8],xmm30[8],xmm3[9],xmm30[9],xmm3[10],xmm30[10],xmm3[11],xmm30[11],xmm3[12],xmm30[12],xmm3[13],xmm30[13],xmm3[14],xmm30[14],xmm3[15],xmm30[15]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm18 = xmm18[u,6,7,2,3,u,u,u,8,9,4,5,u,u,u,10]
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, %xmm18, %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm18 = [2,2,2,4,2,2,2,4,3,3,3,3,2,2,2,4,52,53,52,53,53,54,53,54,52,53,52,53,53,54,53,54]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm31, %zmm6, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm0 = zmm0[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-FCP-NEXT:    movabsq $290499906672591364, %rax # imm = 0x408102040810204
; AVX512DQ-BW-FCP-NEXT:    kmovq %rax, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm18, %zmm0 {%k3}
; AVX512DQ-BW-FCP-NEXT:    movabsq $-8714997200177740921, %rax # imm = 0x870E1C3870E1C387
; AVX512DQ-BW-FCP-NEXT:    kmovq %rax, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm0, %zmm29 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm13, %xmm19, %xmm0
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm12, %xmm17, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm0, %xmm6, %xmm0
; AVX512DQ-BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm6 = xmm17[0],xmm19[0],xmm17[1],xmm19[1],xmm17[2],xmm19[2],xmm17[3],xmm19[3],xmm17[4],xmm19[4],xmm17[5],xmm19[5],xmm17[6],xmm19[6],xmm17[7],xmm19[7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm12 = [4,5,0,1,u,u,u,6,7,2,3,u,u,u,8,9]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm12, %xmm6, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, %xmm0, %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm11, %xmm22, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm8, %xmm21, %xmm8
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm6, %xmm8, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm8 = xmm21[0],xmm22[0],xmm21[1],xmm22[1],xmm21[2],xmm22[2],xmm21[3],xmm22[3],xmm21[4],xmm22[4],xmm21[5],xmm22[5],xmm21[6],xmm22[6],xmm21[7],xmm22[7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm11 = [0,1,u,u,u,6,7,2,3,u,u,u,8,9,4,5]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm11, %xmm8, %xmm8
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, %xmm6, %zmm8, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm8 = zmm0[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm0 = zmm6[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-FCP-NEXT:    movabsq $871499720017774092, %rax # imm = 0xC183060C183060C
; AVX512DQ-BW-FCP-NEXT:    kmovq %rax, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm8, %zmm0 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm10, %xmm16, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm7, %xmm15, %xmm7
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm7 = xmm15[0],xmm16[0],xmm15[1],xmm16[1],xmm15[2],xmm16[2],xmm15[3],xmm16[3],xmm15[4],xmm16[4],xmm15[5],xmm16[5],xmm15[6],xmm16[6],xmm15[7],xmm16[7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm10 = [u,u,4,5,0,1,u,u,u,6,7,2,3,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm10, %xmm7, %xmm7
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, %xmm6, %zmm7, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm6 = zmm6[0,1,0,1,4,5,4,5]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%rsp), %zmm31, %zmm8 # 32-byte Folded Reload
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm7 = [1,1,0,0,1,1,0,0,4,5,1,1,1,1,0,0,18,18,18,20,18,18,18,20,19,19,19,19,18,18,18,20]
; AVX512DQ-BW-FCP-NEXT:    vpermw %zmm8, %zmm7, %zmm7
; AVX512DQ-BW-FCP-NEXT:    movabsq $4647998506761461824, %rax # imm = 0x4081020408102040
; AVX512DQ-BW-FCP-NEXT:    kmovq %rax, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm7, %zmm6 {%k3}
; AVX512DQ-BW-FCP-NEXT:    movabsq $8133997386832558192, %rax # imm = 0x70E1C3870E1C3870
; AVX512DQ-BW-FCP-NEXT:    kmovq %rax, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm6, %zmm0 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm11, %xmm1, %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm13[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,30],zero,ymm13[28],zero,ymm13[30,31,30,31],zero,ymm13[29],zero,ymm13[31,28,29]
; AVX512DQ-BW-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm6 = ymm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,ymm15[30],zero,ymm15[28],zero,zero,zero,zero,ymm15[31],zero,ymm15[29],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm2, %ymm6, %ymm2
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm2[2,3,2,3],zmm1[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3],xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm12, %xmm2, %xmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,27],zero,zero,zero,zero,ymm11[30],zero,ymm11[28],zero,zero,zero,zero,ymm11[31],zero,ymm11[29],zero
; AVX512DQ-BW-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm5 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm7[30],zero,ymm7[28],zero,zero,zero,zero,ymm7[31],zero,ymm7[29],zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm4, %ymm5, %ymm4
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm4[2,3,2,3],zmm2[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm2 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm3[0],xmm30[0],xmm3[1],xmm30[1],xmm3[2],xmm30[2],xmm3[3],xmm30[3],xmm3[4],xmm30[4],xmm3[5],xmm30[5],xmm3[6],xmm30[6],xmm3[7],xmm30[7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm10, %xmm1, %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,29],zero,ymm5[27],zero,zero,zero,zero,ymm5[30],zero,ymm5[28],zero,zero,zero,zero,ymm5[31],zero
; AVX512DQ-BW-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,ymm6[27],zero,zero,zero,zero,ymm6[30],zero,ymm6[28],zero,zero,zero,zero,ymm6[31],zero,ymm6[29]
; AVX512DQ-BW-FCP-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm3[2,3,2,3],zmm1[0,1,0,1]
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm3 = [14,13,14,15,15,14,14,15,14,13,14,15,15,14,14,15,17,17,16,16,17,17,16,16,20,21,17,17,17,17,16,16]
; AVX512DQ-BW-FCP-NEXT:    vpermw %zmm31, %zmm3, %zmm3
; AVX512DQ-BW-FCP-NEXT:    movabsq $580999813345182728, %rax # imm = 0x810204081020408
; AVX512DQ-BW-FCP-NEXT:    kmovq %rax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movabsq $1016749673354069774, %rax # imm = 0xE1C3870E1C3870E
; AVX512DQ-BW-FCP-NEXT:    kmovq %rax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm2 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm15, %zmm26, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm1 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm1[18,19,20,21],zero,zmm1[19],zero,zmm1[21,20,21,22],zero,zmm1[20],zero,zmm1[22,23,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,57],zero,zmm1[55],zero,zero,zero,zero,zmm1[58],zero,zmm1[56],zero,zero,zero,zero,zmm1[59],zero
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm13, %zmm27, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm3 = zmm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm3[21],zero,zmm3[19],zero,zero,zero,zero,zmm3[22],zero,zmm3[20],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm3[55],zero,zero,zero,zero,zmm3[58],zero,zmm3[56],zero,zero,zero,zero,zmm3[59],zero,zmm3[57]
; AVX512DQ-BW-FCP-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm7, %zmm24, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm3[18],zero,zmm3[18,19,20,21],zero,zmm3[19],zero,zmm3[25,26,27,22],zero,zmm3[20],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm3[56,57],zero,zmm3[55],zero,zmm3[53,54,55,58],zero,zmm3[56],zero,zmm3[60,61,58,59]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm23, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm4 = zmm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm4[18],zero,zero,zero,zero,zmm4[21],zero,zmm4[19],zero,zero,zero,zero,zmm4[22],zero,zmm4[20,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zmm4[57],zero,zmm4[55],zero,zero,zero,zero,zmm4[58],zero,zmm4[56],zero,zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vporq %zmm3, %zmm4, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm3 = zmm3[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm3 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm6, %zmm28, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm1 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm1[20],zero,zmm1[18],zero,zmm1[20,21,20,21],zero,zmm1[19],zero,zmm1[19,20,21,22],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zmm1[56,57,56,57],zero,zmm1[55],zero,zmm1[55,56,57,58],zero,zmm1[56],zero,zmm1[62,63]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm5, %zmm25, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} zmm4 = zmm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zmm4[20],zero,zmm4[18],zero,zero,zero,zero,zmm4[21],zero,zmm4[19],zero,zero,zero,zero,zmm4[22,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zmm4[57],zero,zmm4[55],zero,zero,zero,zero,zmm4[58],zero,zmm4[56],zero,zero
; AVX512DQ-BW-FCP-NEXT:    vporq %zmm1, %zmm4, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [10,9,9,10,10,9,9,10,9,10,14,15,10,9,9,10,27,29,28,27,28,29,29,28,27,29,28,27,28,29,29,28]
; AVX512DQ-BW-FCP-NEXT:    vpermw %zmm8, %zmm4, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} zmm1 = zmm1[2,3,2,3,6,7,6,7]
; AVX512DQ-BW-FCP-NEXT:    movabsq $1161999626690365456, %rax # imm = 0x1020408102040810
; AVX512DQ-BW-FCP-NEXT:    kmovq %rax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm4, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movabsq $2033499346708139548, %rax # imm = 0x1C3870E1C3870E1C
; AVX512DQ-BW-FCP-NEXT:    kmovq %rax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm1, %zmm3 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, 128(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, 320(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 192(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm29, 256(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, 64(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, 384(%rax)
; AVX512DQ-BW-FCP-NEXT:    addq $104, %rsp
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <64 x i8>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i8>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i8>, ptr %in.vecptr2, align 64
  %in.vec3 = load <64 x i8>, ptr %in.vecptr3, align 64
  %in.vec4 = load <64 x i8>, ptr %in.vecptr4, align 64
  %in.vec5 = load <64 x i8>, ptr %in.vecptr5, align 64
  %in.vec6 = load <64 x i8>, ptr %in.vecptr6, align 64
  %1 = shufflevector <64 x i8> %in.vec0, <64 x i8> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i8> %in.vec2, <64 x i8> %in.vec3, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %3 = shufflevector <64 x i8> %in.vec4, <64 x i8> %in.vec5, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %4 = shufflevector <128 x i8> %1, <128 x i8> %2, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %5 = shufflevector <64 x i8> %in.vec6, <64 x i8> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <128 x i8> %3, <128 x i8> %5, <192 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191>
  %7 = shufflevector <192 x i8> %6, <192 x i8> poison, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <256 x i8> %4, <256 x i8> %7, <448 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255, i32 256, i32 257, i32 258, i32 259, i32 260, i32 261, i32 262, i32 263, i32 264, i32 265, i32 266, i32 267, i32 268, i32 269, i32 270, i32 271, i32 272, i32 273, i32 274, i32 275, i32 276, i32 277, i32 278, i32 279, i32 280, i32 281, i32 282, i32 283, i32 284, i32 285, i32 286, i32 287, i32 288, i32 289, i32 290, i32 291, i32 292, i32 293, i32 294, i32 295, i32 296, i32 297, i32 298, i32 299, i32 300, i32 301, i32 302, i32 303, i32 304, i32 305, i32 306, i32 307, i32 308, i32 309, i32 310, i32 311, i32 312, i32 313, i32 314, i32 315, i32 316, i32 317, i32 318, i32 319, i32 320, i32 321, i32 322, i32 323, i32 324, i32 325, i32 326, i32 327, i32 328, i32 329, i32 330, i32 331, i32 332, i32 333, i32 334, i32 335, i32 336, i32 337, i32 338, i32 339, i32 340, i32 341, i32 342, i32 343, i32 344, i32 345, i32 346, i32 347, i32 348, i32 349, i32 350, i32 351, i32 352, i32 353, i32 354, i32 355, i32 356, i32 357, i32 358, i32 359, i32 360, i32 361, i32 362, i32 363, i32 364, i32 365, i32 366, i32 367, i32 368, i32 369, i32 370, i32 371, i32 372, i32 373, i32 374, i32 375, i32 376, i32 377, i32 378, i32 379, i32 380, i32 381, i32 382, i32 383, i32 384, i32 385, i32 386, i32 387, i32 388, i32 389, i32 390, i32 391, i32 392, i32 393, i32 394, i32 395, i32 396, i32 397, i32 398, i32 399, i32 400, i32 401, i32 402, i32 403, i32 404, i32 405, i32 406, i32 407, i32 408, i32 409, i32 410, i32 411, i32 412, i32 413, i32 414, i32 415, i32 416, i32 417, i32 418, i32 419, i32 420, i32 421, i32 422, i32 423, i32 424, i32 425, i32 426, i32 427, i32 428, i32 429, i32 430, i32 431, i32 432, i32 433, i32 434, i32 435, i32 436, i32 437, i32 438, i32 439, i32 440, i32 441, i32 442, i32 443, i32 444, i32 445, i32 446, i32 447>
  %interleaved.vec = shufflevector <448 x i8> %8, <448 x i8> poison, <448 x i32> <i32 0, i32 64, i32 128, i32 192, i32 256, i32 320, i32 384, i32 1, i32 65, i32 129, i32 193, i32 257, i32 321, i32 385, i32 2, i32 66, i32 130, i32 194, i32 258, i32 322, i32 386, i32 3, i32 67, i32 131, i32 195, i32 259, i32 323, i32 387, i32 4, i32 68, i32 132, i32 196, i32 260, i32 324, i32 388, i32 5, i32 69, i32 133, i32 197, i32 261, i32 325, i32 389, i32 6, i32 70, i32 134, i32 198, i32 262, i32 326, i32 390, i32 7, i32 71, i32 135, i32 199, i32 263, i32 327, i32 391, i32 8, i32 72, i32 136, i32 200, i32 264, i32 328, i32 392, i32 9, i32 73, i32 137, i32 201, i32 265, i32 329, i32 393, i32 10, i32 74, i32 138, i32 202, i32 266, i32 330, i32 394, i32 11, i32 75, i32 139, i32 203, i32 267, i32 331, i32 395, i32 12, i32 76, i32 140, i32 204, i32 268, i32 332, i32 396, i32 13, i32 77, i32 141, i32 205, i32 269, i32 333, i32 397, i32 14, i32 78, i32 142, i32 206, i32 270, i32 334, i32 398, i32 15, i32 79, i32 143, i32 207, i32 271, i32 335, i32 399, i32 16, i32 80, i32 144, i32 208, i32 272, i32 336, i32 400, i32 17, i32 81, i32 145, i32 209, i32 273, i32 337, i32 401, i32 18, i32 82, i32 146, i32 210, i32 274, i32 338, i32 402, i32 19, i32 83, i32 147, i32 211, i32 275, i32 339, i32 403, i32 20, i32 84, i32 148, i32 212, i32 276, i32 340, i32 404, i32 21, i32 85, i32 149, i32 213, i32 277, i32 341, i32 405, i32 22, i32 86, i32 150, i32 214, i32 278, i32 342, i32 406, i32 23, i32 87, i32 151, i32 215, i32 279, i32 343, i32 407, i32 24, i32 88, i32 152, i32 216, i32 280, i32 344, i32 408, i32 25, i32 89, i32 153, i32 217, i32 281, i32 345, i32 409, i32 26, i32 90, i32 154, i32 218, i32 282, i32 346, i32 410, i32 27, i32 91, i32 155, i32 219, i32 283, i32 347, i32 411, i32 28, i32 92, i32 156, i32 220, i32 284, i32 348, i32 412, i32 29, i32 93, i32 157, i32 221, i32 285, i32 349, i32 413, i32 30, i32 94, i32 158, i32 222, i32 286, i32 350, i32 414, i32 31, i32 95, i32 159, i32 223, i32 287, i32 351, i32 415, i32 32, i32 96, i32 160, i32 224, i32 288, i32 352, i32 416, i32 33, i32 97, i32 161, i32 225, i32 289, i32 353, i32 417, i32 34, i32 98, i32 162, i32 226, i32 290, i32 354, i32 418, i32 35, i32 99, i32 163, i32 227, i32 291, i32 355, i32 419, i32 36, i32 100, i32 164, i32 228, i32 292, i32 356, i32 420, i32 37, i32 101, i32 165, i32 229, i32 293, i32 357, i32 421, i32 38, i32 102, i32 166, i32 230, i32 294, i32 358, i32 422, i32 39, i32 103, i32 167, i32 231, i32 295, i32 359, i32 423, i32 40, i32 104, i32 168, i32 232, i32 296, i32 360, i32 424, i32 41, i32 105, i32 169, i32 233, i32 297, i32 361, i32 425, i32 42, i32 106, i32 170, i32 234, i32 298, i32 362, i32 426, i32 43, i32 107, i32 171, i32 235, i32 299, i32 363, i32 427, i32 44, i32 108, i32 172, i32 236, i32 300, i32 364, i32 428, i32 45, i32 109, i32 173, i32 237, i32 301, i32 365, i32 429, i32 46, i32 110, i32 174, i32 238, i32 302, i32 366, i32 430, i32 47, i32 111, i32 175, i32 239, i32 303, i32 367, i32 431, i32 48, i32 112, i32 176, i32 240, i32 304, i32 368, i32 432, i32 49, i32 113, i32 177, i32 241, i32 305, i32 369, i32 433, i32 50, i32 114, i32 178, i32 242, i32 306, i32 370, i32 434, i32 51, i32 115, i32 179, i32 243, i32 307, i32 371, i32 435, i32 52, i32 116, i32 180, i32 244, i32 308, i32 372, i32 436, i32 53, i32 117, i32 181, i32 245, i32 309, i32 373, i32 437, i32 54, i32 118, i32 182, i32 246, i32 310, i32 374, i32 438, i32 55, i32 119, i32 183, i32 247, i32 311, i32 375, i32 439, i32 56, i32 120, i32 184, i32 248, i32 312, i32 376, i32 440, i32 57, i32 121, i32 185, i32 249, i32 313, i32 377, i32 441, i32 58, i32 122, i32 186, i32 250, i32 314, i32 378, i32 442, i32 59, i32 123, i32 187, i32 251, i32 315, i32 379, i32 443, i32 60, i32 124, i32 188, i32 252, i32 316, i32 380, i32 444, i32 61, i32 125, i32 189, i32 253, i32 317, i32 381, i32 445, i32 62, i32 126, i32 190, i32 254, i32 318, i32 382, i32 446, i32 63, i32 127, i32 191, i32 255, i32 319, i32 383, i32 447>
  store <448 x i8> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
