; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+v,+m -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=OMIT-FP %s
; RUN: llc -mtriple=riscv64 -mattr=+v,+m -verify-machineinstrs -frame-pointer=all < %s \
; RUN:   | FileCheck -check-prefix=NO-OMIT-FP %s
; RUN: llc -mtriple=riscv64 -mattr=+v,+m,+zcmp -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=OMIT-FP-ZCMP %s
; RUN: llc -mtriple=riscv64 -mattr=+v,+m,+zcmp -verify-machineinstrs -frame-pointer=all < %s \
; RUN:   | FileCheck -check-prefix=NO-OMIT-FP-ZCMP %s

define riscv_vector_cc <vscale x 1 x i32> @test_vector_callee_cfi(<vscale x 1 x i32> %va) {
; OMIT-FP-LABEL: test_vector_callee_cfi:
; OMIT-FP:       # %bb.0: # %entry
; OMIT-FP-NEXT:    addi sp, sp, -48
; OMIT-FP-NEXT:    .cfi_def_cfa_offset 48
; OMIT-FP-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; OMIT-FP-NEXT:    .cfi_offset s1, -8
; OMIT-FP-NEXT:    csrr a0, vlenb
; OMIT-FP-NEXT:    slli a1, a0, 3
; OMIT-FP-NEXT:    sub a0, a1, a0
; OMIT-FP-NEXT:    sub sp, sp, a0
; OMIT-FP-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x30, 0x22, 0x11, 0x07, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 48 + 7 * vlenb
; OMIT-FP-NEXT:    csrr a0, vlenb
; OMIT-FP-NEXT:    li a1, 6
; OMIT-FP-NEXT:    mul a0, a0, a1
; OMIT-FP-NEXT:    add a0, sp, a0
; OMIT-FP-NEXT:    addi a0, a0, 32
; OMIT-FP-NEXT:    vs1r.v v1, (a0) # Unknown-size Folded Spill
; OMIT-FP-NEXT:    csrr a0, vlenb
; OMIT-FP-NEXT:    slli a0, a0, 2
; OMIT-FP-NEXT:    add a0, sp, a0
; OMIT-FP-NEXT:    addi a0, a0, 32
; OMIT-FP-NEXT:    vs2r.v v2, (a0) # Unknown-size Folded Spill
; OMIT-FP-NEXT:    addi a0, sp, 32
; OMIT-FP-NEXT:    vs4r.v v4, (a0) # Unknown-size Folded Spill
; OMIT-FP-NEXT:    .cfi_escape 0x10, 0x61, 0x0b, 0x11, 0x70, 0x22, 0x11, 0x7f, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v1 @ cfa - 16 - 1 * vlenb
; OMIT-FP-NEXT:    .cfi_escape 0x10, 0x62, 0x0b, 0x11, 0x70, 0x22, 0x11, 0x7d, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v2 @ cfa - 16 - 3 * vlenb
; OMIT-FP-NEXT:    .cfi_escape 0x10, 0x63, 0x0b, 0x11, 0x70, 0x22, 0x11, 0x7e, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v3 @ cfa - 16 - 2 * vlenb
; OMIT-FP-NEXT:    .cfi_escape 0x10, 0x64, 0x0b, 0x11, 0x70, 0x22, 0x11, 0x79, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v4 @ cfa - 16 - 7 * vlenb
; OMIT-FP-NEXT:    .cfi_escape 0x10, 0x65, 0x0b, 0x11, 0x70, 0x22, 0x11, 0x7a, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v5 @ cfa - 16 - 6 * vlenb
; OMIT-FP-NEXT:    .cfi_escape 0x10, 0x66, 0x0b, 0x11, 0x70, 0x22, 0x11, 0x7b, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v6 @ cfa - 16 - 5 * vlenb
; OMIT-FP-NEXT:    .cfi_escape 0x10, 0x67, 0x0b, 0x11, 0x70, 0x22, 0x11, 0x7c, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v7 @ cfa - 16 - 4 * vlenb
; OMIT-FP-NEXT:    #APP
; OMIT-FP-NEXT:    #NO_APP
; OMIT-FP-NEXT:    csrr a0, vlenb
; OMIT-FP-NEXT:    li a1, 6
; OMIT-FP-NEXT:    mul a0, a0, a1
; OMIT-FP-NEXT:    add a0, sp, a0
; OMIT-FP-NEXT:    addi a0, a0, 32
; OMIT-FP-NEXT:    vl1r.v v1, (a0) # Unknown-size Folded Reload
; OMIT-FP-NEXT:    csrr a0, vlenb
; OMIT-FP-NEXT:    slli a0, a0, 2
; OMIT-FP-NEXT:    add a0, sp, a0
; OMIT-FP-NEXT:    addi a0, a0, 32
; OMIT-FP-NEXT:    vl2r.v v2, (a0) # Unknown-size Folded Reload
; OMIT-FP-NEXT:    addi a0, sp, 32
; OMIT-FP-NEXT:    vl4r.v v4, (a0) # Unknown-size Folded Reload
; OMIT-FP-NEXT:    csrr a0, vlenb
; OMIT-FP-NEXT:    slli a1, a0, 3
; OMIT-FP-NEXT:    sub a0, a1, a0
; OMIT-FP-NEXT:    add sp, sp, a0
; OMIT-FP-NEXT:    .cfi_def_cfa sp, 48
; OMIT-FP-NEXT:    .cfi_restore v1
; OMIT-FP-NEXT:    .cfi_restore v2
; OMIT-FP-NEXT:    .cfi_restore v3
; OMIT-FP-NEXT:    .cfi_restore v4
; OMIT-FP-NEXT:    .cfi_restore v5
; OMIT-FP-NEXT:    .cfi_restore v6
; OMIT-FP-NEXT:    .cfi_restore v7
; OMIT-FP-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; OMIT-FP-NEXT:    .cfi_restore s1
; OMIT-FP-NEXT:    addi sp, sp, 48
; OMIT-FP-NEXT:    .cfi_def_cfa_offset 0
; OMIT-FP-NEXT:    ret
;
; NO-OMIT-FP-LABEL: test_vector_callee_cfi:
; NO-OMIT-FP:       # %bb.0: # %entry
; NO-OMIT-FP-NEXT:    addi sp, sp, -48
; NO-OMIT-FP-NEXT:    .cfi_def_cfa_offset 48
; NO-OMIT-FP-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; NO-OMIT-FP-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; NO-OMIT-FP-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; NO-OMIT-FP-NEXT:    .cfi_offset ra, -8
; NO-OMIT-FP-NEXT:    .cfi_offset s0, -16
; NO-OMIT-FP-NEXT:    .cfi_offset s1, -24
; NO-OMIT-FP-NEXT:    addi s0, sp, 48
; NO-OMIT-FP-NEXT:    .cfi_def_cfa s0, 0
; NO-OMIT-FP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-NEXT:    slli a1, a0, 3
; NO-OMIT-FP-NEXT:    sub a0, a1, a0
; NO-OMIT-FP-NEXT:    sub sp, sp, a0
; NO-OMIT-FP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-NEXT:    sub a0, s0, a0
; NO-OMIT-FP-NEXT:    addi a0, a0, -48
; NO-OMIT-FP-NEXT:    vs1r.v v1, (a0) # Unknown-size Folded Spill
; NO-OMIT-FP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-NEXT:    slli a1, a0, 1
; NO-OMIT-FP-NEXT:    add a0, a1, a0
; NO-OMIT-FP-NEXT:    sub a0, s0, a0
; NO-OMIT-FP-NEXT:    addi a0, a0, -48
; NO-OMIT-FP-NEXT:    vs2r.v v2, (a0) # Unknown-size Folded Spill
; NO-OMIT-FP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-NEXT:    slli a1, a0, 3
; NO-OMIT-FP-NEXT:    sub a0, a1, a0
; NO-OMIT-FP-NEXT:    sub a0, s0, a0
; NO-OMIT-FP-NEXT:    addi a0, a0, -48
; NO-OMIT-FP-NEXT:    vs4r.v v4, (a0) # Unknown-size Folded Spill
; NO-OMIT-FP-NEXT:    .cfi_escape 0x10, 0x61, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x7f, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v1 @ cfa - 48 - 1 * vlenb
; NO-OMIT-FP-NEXT:    .cfi_escape 0x10, 0x62, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x7d, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v2 @ cfa - 48 - 3 * vlenb
; NO-OMIT-FP-NEXT:    .cfi_escape 0x10, 0x63, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x7e, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v3 @ cfa - 48 - 2 * vlenb
; NO-OMIT-FP-NEXT:    .cfi_escape 0x10, 0x64, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x79, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v4 @ cfa - 48 - 7 * vlenb
; NO-OMIT-FP-NEXT:    .cfi_escape 0x10, 0x65, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x7a, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v5 @ cfa - 48 - 6 * vlenb
; NO-OMIT-FP-NEXT:    .cfi_escape 0x10, 0x66, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x7b, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v6 @ cfa - 48 - 5 * vlenb
; NO-OMIT-FP-NEXT:    .cfi_escape 0x10, 0x67, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x7c, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v7 @ cfa - 48 - 4 * vlenb
; NO-OMIT-FP-NEXT:    #APP
; NO-OMIT-FP-NEXT:    #NO_APP
; NO-OMIT-FP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-NEXT:    sub a0, s0, a0
; NO-OMIT-FP-NEXT:    addi a0, a0, -48
; NO-OMIT-FP-NEXT:    vl1r.v v1, (a0) # Unknown-size Folded Reload
; NO-OMIT-FP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-NEXT:    slli a1, a0, 1
; NO-OMIT-FP-NEXT:    add a0, a1, a0
; NO-OMIT-FP-NEXT:    sub a0, s0, a0
; NO-OMIT-FP-NEXT:    addi a0, a0, -48
; NO-OMIT-FP-NEXT:    vl2r.v v2, (a0) # Unknown-size Folded Reload
; NO-OMIT-FP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-NEXT:    slli a1, a0, 3
; NO-OMIT-FP-NEXT:    sub a0, a1, a0
; NO-OMIT-FP-NEXT:    sub a0, s0, a0
; NO-OMIT-FP-NEXT:    addi a0, a0, -48
; NO-OMIT-FP-NEXT:    vl4r.v v4, (a0) # Unknown-size Folded Reload
; NO-OMIT-FP-NEXT:    .cfi_restore v1
; NO-OMIT-FP-NEXT:    .cfi_restore v2
; NO-OMIT-FP-NEXT:    .cfi_restore v3
; NO-OMIT-FP-NEXT:    .cfi_restore v4
; NO-OMIT-FP-NEXT:    .cfi_restore v5
; NO-OMIT-FP-NEXT:    .cfi_restore v6
; NO-OMIT-FP-NEXT:    .cfi_restore v7
; NO-OMIT-FP-NEXT:    addi sp, s0, -48
; NO-OMIT-FP-NEXT:    .cfi_def_cfa sp, 48
; NO-OMIT-FP-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; NO-OMIT-FP-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; NO-OMIT-FP-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; NO-OMIT-FP-NEXT:    .cfi_restore ra
; NO-OMIT-FP-NEXT:    .cfi_restore s0
; NO-OMIT-FP-NEXT:    .cfi_restore s1
; NO-OMIT-FP-NEXT:    addi sp, sp, 48
; NO-OMIT-FP-NEXT:    .cfi_def_cfa_offset 0
; NO-OMIT-FP-NEXT:    ret
;
; OMIT-FP-ZCMP-LABEL: test_vector_callee_cfi:
; OMIT-FP-ZCMP:       # %bb.0: # %entry
; OMIT-FP-ZCMP-NEXT:    cm.push {ra, s0-s1}, -48
; OMIT-FP-ZCMP-NEXT:    .cfi_def_cfa_offset 48
; OMIT-FP-ZCMP-NEXT:    .cfi_offset s1, -8
; OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; OMIT-FP-ZCMP-NEXT:    slli a1, a0, 3
; OMIT-FP-ZCMP-NEXT:    sub a0, a1, a0
; OMIT-FP-ZCMP-NEXT:    sub sp, sp, a0
; OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x30, 0x22, 0x11, 0x07, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 48 + 7 * vlenb
; OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; OMIT-FP-ZCMP-NEXT:    li a1, 6
; OMIT-FP-ZCMP-NEXT:    mul a0, a0, a1
; OMIT-FP-ZCMP-NEXT:    add a0, a0, sp
; OMIT-FP-ZCMP-NEXT:    addi a0, a0, 16
; OMIT-FP-ZCMP-NEXT:    vs1r.v v1, (a0) # Unknown-size Folded Spill
; OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; OMIT-FP-ZCMP-NEXT:    slli a0, a0, 2
; OMIT-FP-ZCMP-NEXT:    add a0, a0, sp
; OMIT-FP-ZCMP-NEXT:    addi a0, a0, 16
; OMIT-FP-ZCMP-NEXT:    vs2r.v v2, (a0) # Unknown-size Folded Spill
; OMIT-FP-ZCMP-NEXT:    addi a0, sp, 16
; OMIT-FP-ZCMP-NEXT:    vs4r.v v4, (a0) # Unknown-size Folded Spill
; OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x61, 0x0b, 0x11, 0x60, 0x22, 0x11, 0x7f, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v1 @ cfa - 32 - 1 * vlenb
; OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x62, 0x0b, 0x11, 0x60, 0x22, 0x11, 0x7d, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v2 @ cfa - 32 - 3 * vlenb
; OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x63, 0x0b, 0x11, 0x60, 0x22, 0x11, 0x7e, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v3 @ cfa - 32 - 2 * vlenb
; OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x64, 0x0b, 0x11, 0x60, 0x22, 0x11, 0x79, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v4 @ cfa - 32 - 7 * vlenb
; OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x65, 0x0b, 0x11, 0x60, 0x22, 0x11, 0x7a, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v5 @ cfa - 32 - 6 * vlenb
; OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x66, 0x0b, 0x11, 0x60, 0x22, 0x11, 0x7b, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v6 @ cfa - 32 - 5 * vlenb
; OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x67, 0x0b, 0x11, 0x60, 0x22, 0x11, 0x7c, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v7 @ cfa - 32 - 4 * vlenb
; OMIT-FP-ZCMP-NEXT:    #APP
; OMIT-FP-ZCMP-NEXT:    #NO_APP
; OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; OMIT-FP-ZCMP-NEXT:    li a1, 6
; OMIT-FP-ZCMP-NEXT:    mul a0, a0, a1
; OMIT-FP-ZCMP-NEXT:    add a0, a0, sp
; OMIT-FP-ZCMP-NEXT:    addi a0, a0, 16
; OMIT-FP-ZCMP-NEXT:    vl1r.v v1, (a0) # Unknown-size Folded Reload
; OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; OMIT-FP-ZCMP-NEXT:    slli a0, a0, 2
; OMIT-FP-ZCMP-NEXT:    add a0, a0, sp
; OMIT-FP-ZCMP-NEXT:    addi a0, a0, 16
; OMIT-FP-ZCMP-NEXT:    vl2r.v v2, (a0) # Unknown-size Folded Reload
; OMIT-FP-ZCMP-NEXT:    addi a0, sp, 16
; OMIT-FP-ZCMP-NEXT:    vl4r.v v4, (a0) # Unknown-size Folded Reload
; OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; OMIT-FP-ZCMP-NEXT:    slli a1, a0, 3
; OMIT-FP-ZCMP-NEXT:    sub a0, a1, a0
; OMIT-FP-ZCMP-NEXT:    add sp, sp, a0
; OMIT-FP-ZCMP-NEXT:    .cfi_def_cfa sp, 48
; OMIT-FP-ZCMP-NEXT:    .cfi_restore v1
; OMIT-FP-ZCMP-NEXT:    .cfi_restore v2
; OMIT-FP-ZCMP-NEXT:    .cfi_restore v3
; OMIT-FP-ZCMP-NEXT:    .cfi_restore v4
; OMIT-FP-ZCMP-NEXT:    .cfi_restore v5
; OMIT-FP-ZCMP-NEXT:    .cfi_restore v6
; OMIT-FP-ZCMP-NEXT:    .cfi_restore v7
; OMIT-FP-ZCMP-NEXT:    cm.popret {ra, s0-s1}, 48
;
; NO-OMIT-FP-ZCMP-LABEL: test_vector_callee_cfi:
; NO-OMIT-FP-ZCMP:       # %bb.0: # %entry
; NO-OMIT-FP-ZCMP-NEXT:    addi sp, sp, -48
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_def_cfa_offset 48
; NO-OMIT-FP-ZCMP-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; NO-OMIT-FP-ZCMP-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; NO-OMIT-FP-ZCMP-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_offset ra, -8
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_offset s0, -16
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_offset s1, -24
; NO-OMIT-FP-ZCMP-NEXT:    addi s0, sp, 48
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_def_cfa s0, 0
; NO-OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-ZCMP-NEXT:    slli a1, a0, 3
; NO-OMIT-FP-ZCMP-NEXT:    sub a0, a1, a0
; NO-OMIT-FP-ZCMP-NEXT:    sub sp, sp, a0
; NO-OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-ZCMP-NEXT:    sub a0, s0, a0
; NO-OMIT-FP-ZCMP-NEXT:    addi a0, a0, -48
; NO-OMIT-FP-ZCMP-NEXT:    vs1r.v v1, (a0) # Unknown-size Folded Spill
; NO-OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-ZCMP-NEXT:    slli a1, a0, 1
; NO-OMIT-FP-ZCMP-NEXT:    add a0, a0, a1
; NO-OMIT-FP-ZCMP-NEXT:    sub a0, s0, a0
; NO-OMIT-FP-ZCMP-NEXT:    addi a0, a0, -48
; NO-OMIT-FP-ZCMP-NEXT:    vs2r.v v2, (a0) # Unknown-size Folded Spill
; NO-OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-ZCMP-NEXT:    slli a1, a0, 3
; NO-OMIT-FP-ZCMP-NEXT:    sub a0, a1, a0
; NO-OMIT-FP-ZCMP-NEXT:    sub a0, s0, a0
; NO-OMIT-FP-ZCMP-NEXT:    addi a0, a0, -48
; NO-OMIT-FP-ZCMP-NEXT:    vs4r.v v4, (a0) # Unknown-size Folded Spill
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x61, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x7f, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v1 @ cfa - 48 - 1 * vlenb
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x62, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x7d, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v2 @ cfa - 48 - 3 * vlenb
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x63, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x7e, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v3 @ cfa - 48 - 2 * vlenb
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x64, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x79, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v4 @ cfa - 48 - 7 * vlenb
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x65, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x7a, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v5 @ cfa - 48 - 6 * vlenb
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x66, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x7b, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v6 @ cfa - 48 - 5 * vlenb
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_escape 0x10, 0x67, 0x0b, 0x11, 0x50, 0x22, 0x11, 0x7c, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # $v7 @ cfa - 48 - 4 * vlenb
; NO-OMIT-FP-ZCMP-NEXT:    #APP
; NO-OMIT-FP-ZCMP-NEXT:    #NO_APP
; NO-OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-ZCMP-NEXT:    sub a0, s0, a0
; NO-OMIT-FP-ZCMP-NEXT:    addi a0, a0, -48
; NO-OMIT-FP-ZCMP-NEXT:    vl1r.v v1, (a0) # Unknown-size Folded Reload
; NO-OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-ZCMP-NEXT:    slli a1, a0, 1
; NO-OMIT-FP-ZCMP-NEXT:    add a0, a0, a1
; NO-OMIT-FP-ZCMP-NEXT:    sub a0, s0, a0
; NO-OMIT-FP-ZCMP-NEXT:    addi a0, a0, -48
; NO-OMIT-FP-ZCMP-NEXT:    vl2r.v v2, (a0) # Unknown-size Folded Reload
; NO-OMIT-FP-ZCMP-NEXT:    csrr a0, vlenb
; NO-OMIT-FP-ZCMP-NEXT:    slli a1, a0, 3
; NO-OMIT-FP-ZCMP-NEXT:    sub a0, a1, a0
; NO-OMIT-FP-ZCMP-NEXT:    sub a0, s0, a0
; NO-OMIT-FP-ZCMP-NEXT:    addi a0, a0, -48
; NO-OMIT-FP-ZCMP-NEXT:    vl4r.v v4, (a0) # Unknown-size Folded Reload
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_restore v1
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_restore v2
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_restore v3
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_restore v4
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_restore v5
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_restore v6
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_restore v7
; NO-OMIT-FP-ZCMP-NEXT:    addi sp, s0, -48
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_def_cfa sp, 48
; NO-OMIT-FP-ZCMP-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; NO-OMIT-FP-ZCMP-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; NO-OMIT-FP-ZCMP-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_restore ra
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_restore s0
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_restore s1
; NO-OMIT-FP-ZCMP-NEXT:    addi sp, sp, 48
; NO-OMIT-FP-ZCMP-NEXT:    .cfi_def_cfa_offset 0
; NO-OMIT-FP-ZCMP-NEXT:    ret
entry:
  call void asm sideeffect "",
  "~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{s1}"()

  ret <vscale x 1 x i32> %va
}
