; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=x86_64-unknown-unknown --show-mc-encoding -mattr=+avx10.2-256 | FileCheck %s --check-prefixes=CHECK,X64
; RUN: llc < %s -verify-machineinstrs -mtriple=i686-unknown-unknown --show-mc-encoding -mattr=+avx10.2-256 | FileCheck %s --check-prefixes=CHECK,X86

declare <16 x bfloat> @llvm.x86.avx10.vminbf16256(<16 x bfloat>, <16 x bfloat>)

define <16 x bfloat> @test_int_x86_avx10_min_bf16_256(<16 x bfloat> %x1, <16 x bfloat> %x2) {
; CHECK-LABEL: test_int_x86_avx10_min_bf16_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vminbf16 %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x7d,0x28,0x5d,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res0 = call <16 x bfloat> @llvm.x86.avx10.vminbf16256(<16 x bfloat> %x1, <16 x bfloat> %x2)
  ret <16 x bfloat> %res0
}

define <16 x bfloat> @test_int_x86_avx10_maskz_min_bf16_256(<16 x bfloat> %x1, <16 x bfloat> %x2, i16 %msk) {
; X64-LABEL: test_int_x86_avx10_maskz_min_bf16_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminbf16 %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x5d,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_min_bf16_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminbf16 %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x5d,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i16 %msk to <16 x i1>
  %res0 = call <16 x bfloat> @llvm.x86.avx10.vminbf16256(<16 x bfloat> %x1, <16 x bfloat> %x2)
  %res1 = select <16 x i1> %mask, <16 x bfloat> %res0, <16 x bfloat> zeroinitializer
  ret <16 x bfloat> %res1
}

declare <8 x bfloat> @llvm.x86.avx10.vminbf16128(<8 x bfloat>, <8 x bfloat>)

define <8 x bfloat> @test_int_x86_avx10_min_bf16_128(<8 x bfloat> %x1, <8 x bfloat> %x2) {
; CHECK-LABEL: test_int_x86_avx10_min_bf16_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vminbf16 %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7d,0x08,0x5d,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res0 = call <8 x bfloat> @llvm.x86.avx10.vminbf16128(<8 x bfloat> %x1, <8 x bfloat> %x2)
  ret <8 x bfloat> %res0
}

define <8 x bfloat> @test_int_x86_avx10_maskz_min_bf16_128(<8 x bfloat> %x1, <8 x bfloat> %x2, i8 %msk) {
; X64-LABEL: test_int_x86_avx10_maskz_min_bf16_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminbf16 %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x5d,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_min_bf16_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminbf16 %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x5d,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i8 %msk to <8 x i1>
  %res0 = call <8 x bfloat> @llvm.x86.avx10.vminbf16128(<8 x bfloat> %x1, <8 x bfloat> %x2)
  %res1 = select <8 x i1> %mask, <8 x bfloat> %res0, <8 x bfloat> zeroinitializer
  ret <8 x bfloat> %res1
}

declare <16 x bfloat> @llvm.x86.avx10.vmaxbf16256(<16 x bfloat>, <16 x bfloat>)

define <16 x bfloat> @test_int_x86_avx10_max_bf16_256(<16 x bfloat> %x1, <16 x bfloat> %x2) {
; CHECK-LABEL: test_int_x86_avx10_max_bf16_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxbf16 %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x7d,0x28,0x5f,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res0 = call <16 x bfloat> @llvm.x86.avx10.vmaxbf16256(<16 x bfloat> %x1, <16 x bfloat> %x2)
  ret <16 x bfloat> %res0
}

define <16 x bfloat> @test_int_x86_avx10_maskz_max_bf16_256(<16 x bfloat> %x1, <16 x bfloat> %x2, i16 %msk) {
; X64-LABEL: test_int_x86_avx10_maskz_max_bf16_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmaxbf16 %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x5f,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_max_bf16_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmaxbf16 %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x5f,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i16 %msk to <16 x i1>
  %res0 = call <16 x bfloat> @llvm.x86.avx10.vmaxbf16256(<16 x bfloat> %x1, <16 x bfloat> %x2)
  %res1 = select <16 x i1> %mask, <16 x bfloat> %res0, <16 x bfloat> zeroinitializer
  ret <16 x bfloat> %res1
}

declare <8 x bfloat> @llvm.x86.avx10.vmaxbf16128(<8 x bfloat>, <8 x bfloat>)

define <8 x bfloat> @test_int_x86_avx10_max_bf16_128(<8 x bfloat> %x1, <8 x bfloat> %x2) {
; CHECK-LABEL: test_int_x86_avx10_max_bf16_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxbf16 %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7d,0x08,0x5f,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res0 = call <8 x bfloat> @llvm.x86.avx10.vmaxbf16128(<8 x bfloat> %x1, <8 x bfloat> %x2)
  ret <8 x bfloat> %res0
}

define <8 x bfloat> @test_int_x86_avx10_maskz_max_bf16_128(<8 x bfloat> %x1, <8 x bfloat> %x2, i8 %msk) {
; X64-LABEL: test_int_x86_avx10_maskz_max_bf16_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmaxbf16 %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x5f,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_max_bf16_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmaxbf16 %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x5f,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i8 %msk to <8 x i1>
  %res0 = call <8 x bfloat> @llvm.x86.avx10.vmaxbf16128(<8 x bfloat> %x1, <8 x bfloat> %x2)
  %res1 = select <8 x i1> %mask, <8 x bfloat> %res0, <8 x bfloat> zeroinitializer
  ret <8 x bfloat> %res1
}

declare i32 @llvm.x86.avx10.vcomisbf16eq(<8 x bfloat>, <8 x bfloat>)
declare i32 @llvm.x86.avx10.vcomisbf16lt(<8 x bfloat>, <8 x bfloat>)
declare i32 @llvm.x86.avx10.vcomisbf16le(<8 x bfloat>, <8 x bfloat>)
declare i32 @llvm.x86.avx10.vcomisbf16gt(<8 x bfloat>, <8 x bfloat>)
declare i32 @llvm.x86.avx10.vcomisbf16ge(<8 x bfloat>, <8 x bfloat>)
declare i32 @llvm.x86.avx10.vcomisbf16neq(<8 x bfloat>, <8 x bfloat>)

define i32 @test_x86_avx10_com_nesbf16_eq(<8 x bfloat> %a0, <8 x bfloat> %a1) {
; CHECK-LABEL: test_x86_avx10_com_nesbf16_eq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcomisbf16 %xmm1, %xmm0 # encoding: [0x62,0xf5,0x7d,0x08,0x2f,0xc1]
; CHECK-NEXT:    setnp %al # encoding: [0x0f,0x9b,0xc0]
; CHECK-NEXT:    sete %cl # encoding: [0x0f,0x94,0xc1]
; CHECK-NEXT:    andb %al, %cl # encoding: [0x20,0xc1]
; CHECK-NEXT:    movzbl %cl, %eax # encoding: [0x0f,0xb6,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call i32 @llvm.x86.avx10.vcomisbf16eq(<8 x bfloat> %a0, <8 x bfloat> %a1)
  ret i32 %res
}

define i32 @test_x86_avx10_com_nesbf16_lt(<8 x bfloat> %a0, <8 x bfloat> %a1) {
; CHECK-LABEL: test_x86_avx10_com_nesbf16_lt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    vcomisbf16 %xmm0, %xmm1 # encoding: [0x62,0xf5,0x7d,0x08,0x2f,0xc8]
; CHECK-NEXT:    seta %al # encoding: [0x0f,0x97,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call i32 @llvm.x86.avx10.vcomisbf16lt(<8 x bfloat> %a0, <8 x bfloat> %a1)
  ret i32 %res
}

define i32 @test_x86_avx10_com_nesbf16_le(<8 x bfloat> %a0, <8 x bfloat> %a1) {
; CHECK-LABEL: test_x86_avx10_com_nesbf16_le:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    vcomisbf16 %xmm0, %xmm1 # encoding: [0x62,0xf5,0x7d,0x08,0x2f,0xc8]
; CHECK-NEXT:    setae %al # encoding: [0x0f,0x93,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call i32 @llvm.x86.avx10.vcomisbf16le(<8 x bfloat> %a0, <8 x bfloat> %a1)
  ret i32 %res
}

define i32 @test_x86_avx10_com_nesbf16_gt(<8 x bfloat> %a0, <8 x bfloat> %a1) {
; CHECK-LABEL: test_x86_avx10_com_nesbf16_gt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    vcomisbf16 %xmm1, %xmm0 # encoding: [0x62,0xf5,0x7d,0x08,0x2f,0xc1]
; CHECK-NEXT:    setae %al # encoding: [0x0f,0x93,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call i32 @llvm.x86.avx10.vcomisbf16ge(<8 x bfloat> %a0, <8 x bfloat> %a1)
  ret i32 %res
}

define i32 @test_x86_avx10_com_nesbf16_neq(<8 x bfloat> %a0, <8 x bfloat> %a1) {
; CHECK-LABEL: test_x86_avx10_com_nesbf16_neq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcomisbf16 %xmm1, %xmm0 # encoding: [0x62,0xf5,0x7d,0x08,0x2f,0xc1]
; CHECK-NEXT:    setp %al # encoding: [0x0f,0x9a,0xc0]
; CHECK-NEXT:    setne %cl # encoding: [0x0f,0x95,0xc1]
; CHECK-NEXT:    orb %al, %cl # encoding: [0x08,0xc1]
; CHECK-NEXT:    movzbl %cl, %eax # encoding: [0x0f,0xb6,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call i32 @llvm.x86.avx10.vcomisbf16neq(<8 x bfloat> %a0, <8 x bfloat> %a1)
  ret i32 %res
}

declare <8 x bfloat> @llvm.x86.avx10.mask.rsqrt.bf16.128(<8 x bfloat>, <8 x bfloat>, i8)
declare <16 x bfloat> @llvm.x86.avx10.mask.rsqrt.bf16.256(<16 x bfloat>, <16 x bfloat>, i16)

define <8 x bfloat> @test_rsqrt_bf16_128(<8 x bfloat> %a0) {
; CHECK-LABEL: test_rsqrt_bf16_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrsqrtbf16 %xmm0, %xmm0 # encoding: [0x62,0xf6,0x7c,0x08,0x4e,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x bfloat> @llvm.x86.avx10.mask.rsqrt.bf16.128(<8 x bfloat> %a0, <8 x bfloat> zeroinitializer, i8 -1)
  ret <8 x bfloat> %res
}

define <16 x bfloat> @test_rsqrt_bf16_256(<16 x bfloat> %a0) {
; CHECK-LABEL: test_rsqrt_bf16_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrsqrtbf16 %ymm0, %ymm0 # encoding: [0x62,0xf6,0x7c,0x28,0x4e,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <16 x bfloat> @llvm.x86.avx10.mask.rsqrt.bf16.256(<16 x bfloat> %a0, <16 x bfloat> zeroinitializer, i16 -1)
  ret <16 x bfloat> %res
}

declare <8 x bfloat> @llvm.x86.avx10.mask.rcp.bf16.128(<8 x bfloat>, <8 x bfloat>, i8)
declare <16 x bfloat> @llvm.x86.avx10.mask.rcp.bf16.256(<16 x bfloat>, <16 x bfloat>, i16)

define <8 x bfloat> @test_rcp_bf16_128(<8 x bfloat> %a0, <8 x bfloat> %a1, i8 %mask) {
; X64-LABEL: test_rcp_bf16_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrcpbf16 %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf6,0x7c,0x09,0x4c,0xc8]
; X64-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_rcp_bf16_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrcpbf16 %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf6,0x7c,0x09,0x4c,0xc8]
; X86-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <8 x bfloat> @llvm.x86.avx10.mask.rcp.bf16.128(<8 x bfloat> %a0, <8 x bfloat> %a1, i8 %mask)
  ret <8 x bfloat> %res
}

define <16 x bfloat> @test_rcp_bf16_256(<16 x bfloat> %a0, <16 x bfloat> %a1, i16 %mask) {
; X64-LABEL: test_rcp_bf16_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrcpbf16 %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf6,0x7c,0x29,0x4c,0xc8]
; X64-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_rcp_bf16_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrcpbf16 %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf6,0x7c,0x29,0x4c,0xc8]
; X86-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <16 x bfloat> @llvm.x86.avx10.mask.rcp.bf16.256(<16 x bfloat> %a0, <16 x bfloat> %a1, i16 %mask)
  ret <16 x bfloat> %res
}

declare <8 x bfloat> @llvm.x86.avx10.mask.reduce.bf16.128(<8 x bfloat>, i32, <8 x bfloat>, i8)
declare <16 x bfloat> @llvm.x86.avx10.mask.reduce.bf16.256(<16 x bfloat>, i32, <16 x bfloat>, i16)

define <8 x bfloat>@test_int_x86_avx512_mask_reduce_bf16_128(<8 x bfloat> %x0, <8 x bfloat> %x2, i8 %x3) {
; X64-LABEL: test_int_x86_avx512_mask_reduce_bf16_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vreducebf16 $8, %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x09,0x56,0xc8,0x08]
; X64-NEXT:    vreducebf16 $4, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7f,0x08,0x56,0xc0,0x04]
; X64-NEXT:    vaddbf16 %xmm0, %xmm1, %xmm0 # encoding: [0x62,0xf5,0x75,0x08,0x58,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_reduce_bf16_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vreducebf16 $8, %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x09,0x56,0xc8,0x08]
; X86-NEXT:    vreducebf16 $4, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7f,0x08,0x56,0xc0,0x04]
; X86-NEXT:    vaddbf16 %xmm0, %xmm1, %xmm0 # encoding: [0x62,0xf5,0x75,0x08,0x58,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <8 x bfloat> @llvm.x86.avx10.mask.reduce.bf16.128(<8 x bfloat> %x0, i32 8, <8 x bfloat> %x2, i8 %x3)
  %res1 = call <8 x bfloat> @llvm.x86.avx10.mask.reduce.bf16.128(<8 x bfloat> %x0, i32 4, <8 x bfloat> %x2, i8 -1)
  %res2 = fadd <8 x bfloat> %res, %res1
  ret <8 x bfloat> %res2
}

define <16 x bfloat>@test_int_x86_avx512_mask_reduce_bf16_256(<16 x bfloat> %x0, <16 x bfloat> %x2, i16 %x3) {
; X64-LABEL: test_int_x86_avx512_mask_reduce_bf16_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vreducebf16 $8, %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x29,0x56,0xc8,0x08]
; X64-NEXT:    vreducebf16 $4, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7f,0x28,0x56,0xc0,0x04]
; X64-NEXT:    vaddbf16 %ymm0, %ymm1, %ymm0 # encoding: [0x62,0xf5,0x75,0x28,0x58,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_reduce_bf16_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vreducebf16 $8, %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x29,0x56,0xc8,0x08]
; X86-NEXT:    vreducebf16 $4, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7f,0x28,0x56,0xc0,0x04]
; X86-NEXT:    vaddbf16 %ymm0, %ymm1, %ymm0 # encoding: [0x62,0xf5,0x75,0x28,0x58,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <16 x bfloat> @llvm.x86.avx10.mask.reduce.bf16.256(<16 x bfloat> %x0, i32 8, <16 x bfloat> %x2, i16 %x3)
  %res1 = call <16 x bfloat> @llvm.x86.avx10.mask.reduce.bf16.256(<16 x bfloat> %x0, i32 4, <16 x bfloat> %x2, i16 -1)
  %res2 = fadd <16 x bfloat> %res, %res1
  ret <16 x bfloat> %res2
}

declare <8 x i1> @llvm.x86.avx10.fpclass.bf16.128(<8 x bfloat>, i32)
declare <16 x i1> @llvm.x86.avx10.fpclass.bf16.256(<16 x bfloat>, i32)

define i8 @test_int_x86_avx512_fpclass_bf16_128(<8 x bfloat> %x0) {
; CHECK-LABEL: test_int_x86_avx512_fpclass_bf16_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfpclassbf16 $2, %xmm0, %k1 # encoding: [0x62,0xf3,0x7f,0x08,0x66,0xc8,0x02]
; CHECK-NEXT:    # k1 = isPositiveZero(xmm0)
; CHECK-NEXT:    vfpclassbf16 $4, %xmm0, %k0 {%k1} # encoding: [0x62,0xf3,0x7f,0x09,0x66,0xc0,0x04]
; CHECK-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x i1> @llvm.x86.avx10.fpclass.bf16.128(<8 x bfloat> %x0, i32 4)
  %res1 = call <8 x i1> @llvm.x86.avx10.fpclass.bf16.128(<8 x bfloat> %x0, i32 2)
  %1 = and <8 x i1> %res1, %res
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define i16 @test_int_x86_avx512_fpclass_bf16_256(<16 x bfloat> %x0) {
; CHECK-LABEL: test_int_x86_avx512_fpclass_bf16_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfpclassbf16 $2, %ymm0, %k1 # encoding: [0x62,0xf3,0x7f,0x28,0x66,0xc8,0x02]
; CHECK-NEXT:    # k1 = isPositiveZero(ymm0)
; CHECK-NEXT:    vfpclassbf16 $4, %ymm0, %k0 {%k1} # encoding: [0x62,0xf3,0x7f,0x29,0x66,0xc0,0x04]
; CHECK-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <16 x i1> @llvm.x86.avx10.fpclass.bf16.256(<16 x bfloat> %x0, i32 4)
  %res1 = call <16 x i1> @llvm.x86.avx10.fpclass.bf16.256(<16 x bfloat> %x0, i32 2)
  %1 = and <16 x i1> %res1, %res
  %2 = bitcast <16 x i1> %1 to i16
  ret i16 %2
}

declare <8 x bfloat> @llvm.x86.avx10.mask.getexp.bf16.128(<8 x bfloat>, <8 x bfloat>, i8)
declare <16 x bfloat> @llvm.x86.avx10.mask.getexp.bf16.256(<16 x bfloat>, <16 x bfloat>, i16)

define <8 x bfloat>@test_int_x86_avx512_getexp_bf16_128(<8 x bfloat> %x0) {
; CHECK-LABEL: test_int_x86_avx512_getexp_bf16_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgetexpbf16 %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7d,0x08,0x42,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x bfloat> @llvm.x86.avx10.mask.getexp.bf16.128(<8 x bfloat> %x0, <8 x bfloat> zeroinitializer, i8 -1)
  ret <8 x bfloat> %res
}

define <8 x bfloat>@test_int_x86_avx512_mask_getexp_bf16_128(<8 x bfloat> %x0, <8 x bfloat> %x1, i8 %x2) {
; X64-LABEL: test_int_x86_avx512_mask_getexp_bf16_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetexpbf16 %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7d,0x09,0x42,0xc8]
; X64-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_getexp_bf16_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetexpbf16 %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7d,0x09,0x42,0xc8]
; X86-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <8 x bfloat> @llvm.x86.avx10.mask.getexp.bf16.128(<8 x bfloat> %x0, <8 x bfloat> %x1, i8 %x2)
  ret <8 x bfloat> %res
}

define <8 x bfloat>@test_int_x86_avx512_maskz_getexp_bf16_128(<8 x bfloat> %x0, i8 %x2) {
; X64-LABEL: test_int_x86_avx512_maskz_getexp_bf16_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetexpbf16 %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x42,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_maskz_getexp_bf16_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetexpbf16 %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x42,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <8 x bfloat> @llvm.x86.avx10.mask.getexp.bf16.128(<8 x bfloat> %x0, <8 x bfloat> zeroinitializer, i8 %x2)
  ret <8 x bfloat> %res
}

define <16 x bfloat>@test_int_x86_avx512_getexp_bf16_256(<16 x bfloat> %x0) {
; CHECK-LABEL: test_int_x86_avx512_getexp_bf16_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgetexpbf16 %ymm0, %ymm0 # encoding: [0x62,0xf5,0x7d,0x28,0x42,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <16 x bfloat> @llvm.x86.avx10.mask.getexp.bf16.256(<16 x bfloat> %x0, <16 x bfloat> zeroinitializer, i16 -1)
  ret <16 x bfloat> %res
}

define <16 x bfloat>@test_int_x86_avx512_mask_getexp_bf16_256(<16 x bfloat> %x0, <16 x bfloat> %x1, i16 %x2) {
; X64-LABEL: test_int_x86_avx512_mask_getexp_bf16_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetexpbf16 %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0x7d,0x29,0x42,0xc8]
; X64-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_getexp_bf16_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetexpbf16 %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0x7d,0x29,0x42,0xc8]
; X86-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <16 x bfloat> @llvm.x86.avx10.mask.getexp.bf16.256(<16 x bfloat> %x0, <16 x bfloat> %x1, i16 %x2)
  ret <16 x bfloat> %res
}

define <16 x bfloat>@test_int_x86_avx512_maskz_getexp_bf16_256(<16 x bfloat> %x0, i16 %x2) {
; X64-LABEL: test_int_x86_avx512_maskz_getexp_bf16_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetexpbf16 %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x42,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_maskz_getexp_bf16_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetexpbf16 %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x42,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <16 x bfloat> @llvm.x86.avx10.mask.getexp.bf16.256(<16 x bfloat> %x0, <16 x bfloat> zeroinitializer, i16 %x2)
  ret <16 x bfloat> %res
}

declare <8 x bfloat> @llvm.x86.avx10.mask.getmant.bf16.128(<8 x bfloat>, i32, <8 x bfloat>, i8)
declare <16 x bfloat> @llvm.x86.avx10.mask.getmant.bf16.256(<16 x bfloat>, i32, <16 x bfloat>, i16)

define <8 x bfloat>@test_int_x86_avx512_mask_getmant_bf16_128(<8 x bfloat> %x0, <8 x bfloat> %x2, i8 %x3) {
; X64-LABEL: test_int_x86_avx512_mask_getmant_bf16_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetmantbf16 $8, %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x09,0x26,0xc8,0x08]
; X64-NEXT:    vgetmantbf16 $4, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7f,0x08,0x26,0xc0,0x04]
; X64-NEXT:    vaddbf16 %xmm0, %xmm1, %xmm0 # encoding: [0x62,0xf5,0x75,0x08,0x58,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_getmant_bf16_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetmantbf16 $8, %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x09,0x26,0xc8,0x08]
; X86-NEXT:    vgetmantbf16 $4, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7f,0x08,0x26,0xc0,0x04]
; X86-NEXT:    vaddbf16 %xmm0, %xmm1, %xmm0 # encoding: [0x62,0xf5,0x75,0x08,0x58,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <8 x bfloat> @llvm.x86.avx10.mask.getmant.bf16.128(<8 x bfloat> %x0, i32 8, <8 x bfloat> %x2, i8 %x3)
  %res1 = call <8 x bfloat> @llvm.x86.avx10.mask.getmant.bf16.128(<8 x bfloat> %x0, i32 4, <8 x bfloat> %x2, i8 -1)
  %res2 = fadd <8 x bfloat> %res, %res1
  ret <8 x bfloat> %res2
}

define <16 x bfloat>@test_int_x86_avx512_mask_getmant_bf16_256(<16 x bfloat> %x0, <16 x bfloat> %x2, i16 %x3) {
; X64-LABEL: test_int_x86_avx512_mask_getmant_bf16_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetmantbf16 $8, %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x29,0x26,0xc8,0x08]
; X64-NEXT:    vgetmantbf16 $4, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7f,0x28,0x26,0xc0,0x04]
; X64-NEXT:    vaddbf16 %ymm0, %ymm1, %ymm0 # encoding: [0x62,0xf5,0x75,0x28,0x58,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_getmant_bf16_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetmantbf16 $8, %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x29,0x26,0xc8,0x08]
; X86-NEXT:    vgetmantbf16 $4, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7f,0x28,0x26,0xc0,0x04]
; X86-NEXT:    vaddbf16 %ymm0, %ymm1, %ymm0 # encoding: [0x62,0xf5,0x75,0x28,0x58,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <16 x bfloat> @llvm.x86.avx10.mask.getmant.bf16.256(<16 x bfloat> %x0, i32 8, <16 x bfloat> %x2, i16 %x3)
  %res1 = call <16 x bfloat> @llvm.x86.avx10.mask.getmant.bf16.256(<16 x bfloat> %x0, i32 4, <16 x bfloat> %x2, i16 -1)
  %res2 = fadd <16 x bfloat> %res, %res1
  ret <16 x bfloat> %res2
}

declare <8 x bfloat> @llvm.x86.avx10.mask.rndscale.bf16.128(<8 x bfloat>, i32, <8 x bfloat>, i8)
declare <16 x bfloat> @llvm.x86.avx10.mask.rndscale.bf16.256(<16 x bfloat>, i32, <16 x bfloat>, i16)

define <8 x bfloat>@test_int_x86_avx512_mask_rndscale_bf16_128(<8 x bfloat> %x0, <8 x bfloat> %x2, i8 %x3) {
; X64-LABEL: test_int_x86_avx512_mask_rndscale_bf16_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrndscalebf16 $8, %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x09,0x08,0xc8,0x08]
; X64-NEXT:    vrndscalebf16 $4, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7f,0x08,0x08,0xc0,0x04]
; X64-NEXT:    vaddbf16 %xmm0, %xmm1, %xmm0 # encoding: [0x62,0xf5,0x75,0x08,0x58,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_rndscale_bf16_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrndscalebf16 $8, %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x09,0x08,0xc8,0x08]
; X86-NEXT:    vrndscalebf16 $4, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7f,0x08,0x08,0xc0,0x04]
; X86-NEXT:    vaddbf16 %xmm0, %xmm1, %xmm0 # encoding: [0x62,0xf5,0x75,0x08,0x58,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <8 x bfloat> @llvm.x86.avx10.mask.rndscale.bf16.128(<8 x bfloat> %x0, i32 8, <8 x bfloat> %x2, i8 %x3)
  %res1 = call <8 x bfloat> @llvm.x86.avx10.mask.rndscale.bf16.128(<8 x bfloat> %x0, i32 4, <8 x bfloat> %x2, i8 -1)
  %res2 = fadd <8 x bfloat> %res, %res1
  ret <8 x bfloat> %res2
}

define <16 x bfloat>@test_int_x86_avx512_mask_rndscale_bf16_256(<16 x bfloat> %x0, <16 x bfloat> %x2, i16 %x3) {
; X64-LABEL: test_int_x86_avx512_mask_rndscale_bf16_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrndscalebf16 $8, %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x29,0x08,0xc8,0x08]
; X64-NEXT:    vrndscalebf16 $4, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7f,0x28,0x08,0xc0,0x04]
; X64-NEXT:    vaddbf16 %ymm0, %ymm1, %ymm0 # encoding: [0x62,0xf5,0x75,0x28,0x58,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_rndscale_bf16_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrndscalebf16 $8, %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x29,0x08,0xc8,0x08]
; X86-NEXT:    vrndscalebf16 $4, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7f,0x28,0x08,0xc0,0x04]
; X86-NEXT:    vaddbf16 %ymm0, %ymm1, %ymm0 # encoding: [0x62,0xf5,0x75,0x28,0x58,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <16 x bfloat> @llvm.x86.avx10.mask.rndscale.bf16.256(<16 x bfloat> %x0, i32 8, <16 x bfloat> %x2, i16 %x3)
  %res1 = call <16 x bfloat> @llvm.x86.avx10.mask.rndscale.bf16.256(<16 x bfloat> %x0, i32 4, <16 x bfloat> %x2, i16 -1)
  %res2 = fadd <16 x bfloat> %res, %res1
  ret <16 x bfloat> %res2
}

declare <8 x bfloat> @llvm.x86.avx10.mask.scalef.bf16.128(<8 x bfloat>, <8 x bfloat>, <8 x bfloat>, i8)
declare <16 x bfloat> @llvm.x86.avx10.mask.scalef.bf16.256(<16 x bfloat>, <16 x bfloat>, <16 x bfloat>, i16)

define <8 x bfloat>@test_int_x86_avx512_scalef_bf16_128(<8 x bfloat> %x0, <8 x bfloat> %x1) {
; CHECK-LABEL: test_int_x86_avx512_scalef_bf16_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscalefbf16 %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf6,0x7c,0x08,0x2c,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <8 x bfloat> @llvm.x86.avx10.mask.scalef.bf16.128(<8 x bfloat> %x0, <8 x bfloat> %x1, <8 x bfloat> zeroinitializer, i8 -1)
  ret <8 x bfloat> %res
}

define <8 x bfloat>@test_int_x86_avx512_mask_scalef_bf16_128(<8 x bfloat> %x0, <8 x bfloat> %x1, <8 x bfloat> %x2, i8 %x3) {
; X64-LABEL: test_int_x86_avx512_mask_scalef_bf16_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vscalefbf16 %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf6,0x7c,0x09,0x2c,0xd1]
; X64-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_scalef_bf16_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vscalefbf16 %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf6,0x7c,0x09,0x2c,0xd1]
; X86-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i8 %x3 to <8 x i1>
  %res = call <8 x bfloat> @llvm.x86.avx10.mask.scalef.bf16.128(<8 x bfloat> %x0, <8 x bfloat> %x1, <8 x bfloat> %x2, i8 %x3)
  ret <8 x bfloat> %res
}

define <8 x bfloat>@test_int_x86_avx512_maskz_scalef_bf16_128(<8 x bfloat> %x0, <8 x bfloat> %x1, i8 %x3) {
; X64-LABEL: test_int_x86_avx512_maskz_scalef_bf16_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vscalefbf16 %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf6,0x7c,0x89,0x2c,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_maskz_scalef_bf16_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vscalefbf16 %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf6,0x7c,0x89,0x2c,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i8 %x3 to <8 x i1>
  %res = call <8 x bfloat> @llvm.x86.avx10.mask.scalef.bf16.128(<8 x bfloat> %x0, <8 x bfloat> %x1, <8 x bfloat> zeroinitializer, i8 %x3)
  ret <8 x bfloat> %res
}

define <16 x bfloat>@test_int_x86_avx512_scalef_bf16_256(<16 x bfloat> %x0, <16 x bfloat> %x1) {
; CHECK-LABEL: test_int_x86_avx512_scalef_bf16_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscalefbf16 %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf6,0x7c,0x28,0x2c,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <16 x bfloat> @llvm.x86.avx10.mask.scalef.bf16.256(<16 x bfloat> %x0, <16 x bfloat> %x1, <16 x bfloat> zeroinitializer, i16 -1)
  ret <16 x bfloat> %res
}

define <16 x bfloat>@test_int_x86_avx512_mask_scalef_bf16_256(<16 x bfloat> %x0, <16 x bfloat> %x1, <16 x bfloat> %x2, i16 %x3) {
; X64-LABEL: test_int_x86_avx512_mask_scalef_bf16_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vscalefbf16 %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf6,0x7c,0x29,0x2c,0xd1]
; X64-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_scalef_bf16_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vscalefbf16 %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf6,0x7c,0x29,0x2c,0xd1]
; X86-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i16 %x3 to <16 x i1>
  %res = call <16 x bfloat> @llvm.x86.avx10.mask.scalef.bf16.256(<16 x bfloat> %x0, <16 x bfloat> %x1, <16 x bfloat> %x2, i16 %x3)
  ret <16 x bfloat> %res
}

define <16 x bfloat>@test_int_x86_avx512_maskz_scalef_bf16_256(<16 x bfloat> %x0, <16 x bfloat> %x1, i16 %x3) {
; X64-LABEL: test_int_x86_avx512_maskz_scalef_bf16_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vscalefbf16 %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf6,0x7c,0xa9,0x2c,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_maskz_scalef_bf16_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vscalefbf16 %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf6,0x7c,0xa9,0x2c,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i16 %x3 to <16 x i1>
  %res = call <16 x bfloat> @llvm.x86.avx10.mask.scalef.bf16.256(<16 x bfloat> %x0, <16 x bfloat> %x1, <16 x bfloat> zeroinitializer, i16 %x3)
  ret <16 x bfloat> %res
}
