; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64

declare <1 x i1> @llvm.experimental.constrained.fptosi.v1i1.v1f16(<1 x half>, metadata)
define <1 x i1> @vfptosi_v1f16_v1i1(<1 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f16_v1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <1 x i1> @llvm.experimental.constrained.fptosi.v1i1.v1f16(<1 x half> %va, metadata !"fpexcept.strict")
  ret <1 x i1> %evec
}

declare <1 x i1> @llvm.experimental.constrained.fptoui.v1i1.v1f16(<1 x half>, metadata)
define <1 x i1> @vfptoui_v1f16_v1i1(<1 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f16_v1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <1 x i1> @llvm.experimental.constrained.fptoui.v1i1.v1f16(<1 x half> %va, metadata !"fpexcept.strict")
  ret <1 x i1> %evec
}

declare <1 x i7> @llvm.experimental.constrained.fptosi.v1i7.v1f16(<1 x half>, metadata)
define <1 x i7> @vfptosi_v1f16_v1i7(<1 x half> %va) strictfp {
; RV32-LABEL: vfptosi_v1f16_v1i7:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; RV32-NEXT:    vfmv.f.s fa5, v8
; RV32-NEXT:    fcvt.w.h a0, fa5, rtz
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_v1f16_v1i7:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; RV64-NEXT:    vfmv.f.s fa5, v8
; RV64-NEXT:    fcvt.l.h a0, fa5, rtz
; RV64-NEXT:    ret
  %evec = call <1 x i7> @llvm.experimental.constrained.fptosi.v1i7.v1f16(<1 x half> %va, metadata !"fpexcept.strict")
  ret <1 x i7> %evec
}

declare <1 x i7> @llvm.experimental.constrained.fptoui.v1i7.v1f16(<1 x half>, metadata)
define <1 x i7> @vfptoui_v1f16_v1i7(<1 x half> %va) strictfp {
; RV32-LABEL: vfptoui_v1f16_v1i7:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; RV32-NEXT:    vfmv.f.s fa5, v8
; RV32-NEXT:    fcvt.w.h a0, fa5, rtz
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_v1f16_v1i7:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; RV64-NEXT:    vfmv.f.s fa5, v8
; RV64-NEXT:    fcvt.l.h a0, fa5, rtz
; RV64-NEXT:    ret
  %evec = call <1 x i7> @llvm.experimental.constrained.fptoui.v1i7.v1f16(<1 x half> %va, metadata !"fpexcept.strict")
  ret <1 x i7> %evec
}

declare <1 x i8> @llvm.experimental.constrained.fptosi.v1i8.v1f16(<1 x half>, metadata)
define <1 x i8> @vfptosi_v1f16_v1i8(<1 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f16_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x i8> @llvm.experimental.constrained.fptosi.v1i8.v1f16(<1 x half> %va, metadata !"fpexcept.strict")
  ret <1 x i8> %evec
}

declare <1 x i8> @llvm.experimental.constrained.fptoui.v1i8.v1f16(<1 x half>, metadata)
define <1 x i8> @vfptoui_v1f16_v1i8(<1 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f16_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x i8> @llvm.experimental.constrained.fptoui.v1i8.v1f16(<1 x half> %va, metadata !"fpexcept.strict")
  ret <1 x i8> %evec
}

declare <1 x i16> @llvm.experimental.constrained.fptosi.v1i16.v1f16(<1 x half>, metadata)
define <1 x i16> @vfptosi_v1f16_v1i16(<1 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f16_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <1 x i16> @llvm.experimental.constrained.fptosi.v1i16.v1f16(<1 x half> %va, metadata !"fpexcept.strict")
  ret <1 x i16> %evec
}

declare <1 x i16> @llvm.experimental.constrained.fptoui.v1i16.v1f16(<1 x half>, metadata)
define <1 x i16> @vfptoui_v1f16_v1i16(<1 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f16_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <1 x i16> @llvm.experimental.constrained.fptoui.v1i16.v1f16(<1 x half> %va, metadata !"fpexcept.strict")
  ret <1 x i16> %evec
}

declare <1 x i32> @llvm.experimental.constrained.fptosi.v1i32.v1f16(<1 x half>, metadata)
define <1 x i32> @vfptosi_v1f16_v1i32(<1 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f16_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x i32> @llvm.experimental.constrained.fptosi.v1i32.v1f16(<1 x half> %va, metadata !"fpexcept.strict")
  ret <1 x i32> %evec
}

declare <1 x i32> @llvm.experimental.constrained.fptoui.v1i32.v1f16(<1 x half>, metadata)
define <1 x i32> @vfptoui_v1f16_v1i32(<1 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f16_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x i32> @llvm.experimental.constrained.fptoui.v1i32.v1f16(<1 x half> %va, metadata !"fpexcept.strict")
  ret <1 x i32> %evec
}

declare <1 x i64> @llvm.experimental.constrained.fptosi.v1i64.v1f16(<1 x half>, metadata)
define <1 x i64> @vfptosi_v1f16_v1i64(<1 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f16_v1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x i64> @llvm.experimental.constrained.fptosi.v1i64.v1f16(<1 x half> %va, metadata !"fpexcept.strict")
  ret <1 x i64> %evec
}

declare <1 x i64> @llvm.experimental.constrained.fptoui.v1i64.v1f16(<1 x half>, metadata)
define <1 x i64> @vfptoui_v1f16_v1i64(<1 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f16_v1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x i64> @llvm.experimental.constrained.fptoui.v1i64.v1f16(<1 x half> %va, metadata !"fpexcept.strict")
  ret <1 x i64> %evec
}

declare <2 x i1> @llvm.experimental.constrained.fptosi.v2i1.v2f16(<2 x half>, metadata)
define <2 x i1> @vfptosi_v2f16_v2i1(<2 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f16_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <2 x i1> @llvm.experimental.constrained.fptosi.v2i1.v2f16(<2 x half> %va, metadata !"fpexcept.strict")
  ret <2 x i1> %evec
}

declare <2 x i1> @llvm.experimental.constrained.fptoui.v2i1.v2f16(<2 x half>, metadata)
define <2 x i1> @vfptoui_v2f16_v2i1(<2 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f16_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <2 x i1> @llvm.experimental.constrained.fptoui.v2i1.v2f16(<2 x half> %va, metadata !"fpexcept.strict")
  ret <2 x i1> %evec
}

declare <2 x i8> @llvm.experimental.constrained.fptosi.v2i8.v2f16(<2 x half>, metadata)
define <2 x i8> @vfptosi_v2f16_v2i8(<2 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f16_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x i8> @llvm.experimental.constrained.fptosi.v2i8.v2f16(<2 x half> %va, metadata !"fpexcept.strict")
  ret <2 x i8> %evec
}

declare <2 x i8> @llvm.experimental.constrained.fptoui.v2i8.v2f16(<2 x half>, metadata)
define <2 x i8> @vfptoui_v2f16_v2i8(<2 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f16_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x i8> @llvm.experimental.constrained.fptoui.v2i8.v2f16(<2 x half> %va, metadata !"fpexcept.strict")
  ret <2 x i8> %evec
}

declare <2 x i16> @llvm.experimental.constrained.fptosi.v2i16.v2f16(<2 x half>, metadata)
define <2 x i16> @vfptosi_v2f16_v2i16(<2 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f16_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <2 x i16> @llvm.experimental.constrained.fptosi.v2i16.v2f16(<2 x half> %va, metadata !"fpexcept.strict")
  ret <2 x i16> %evec
}

declare <2 x i16> @llvm.experimental.constrained.fptoui.v2i16.v2f16(<2 x half>, metadata)
define <2 x i16> @vfptoui_v2f16_v2i16(<2 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f16_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <2 x i16> @llvm.experimental.constrained.fptoui.v2i16.v2f16(<2 x half> %va, metadata !"fpexcept.strict")
  ret <2 x i16> %evec
}

declare <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f16(<2 x half>, metadata)
define <2 x i32> @vfptosi_v2f16_v2i32(<2 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f16_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f16(<2 x half> %va, metadata !"fpexcept.strict")
  ret <2 x i32> %evec
}

declare <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f16(<2 x half>, metadata)
define <2 x i32> @vfptoui_v2f16_v2i32(<2 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f16_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f16(<2 x half> %va, metadata !"fpexcept.strict")
  ret <2 x i32> %evec
}

declare <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f16(<2 x half>, metadata)
define <2 x i64> @vfptosi_v2f16_v2i64(<2 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f16_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f16(<2 x half> %va, metadata !"fpexcept.strict")
  ret <2 x i64> %evec
}

declare <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f16(<2 x half>, metadata)
define <2 x i64> @vfptoui_v2f16_v2i64(<2 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f16_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f16(<2 x half> %va, metadata !"fpexcept.strict")
  ret <2 x i64> %evec
}

declare <4 x i1> @llvm.experimental.constrained.fptosi.v4i1.v4f16(<4 x half>, metadata)
define <4 x i1> @vfptosi_v4f16_v4i1(<4 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f16_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <4 x i1> @llvm.experimental.constrained.fptosi.v4i1.v4f16(<4 x half> %va, metadata !"fpexcept.strict")
  ret <4 x i1> %evec
}

declare <4 x i1> @llvm.experimental.constrained.fptoui.v4i1.v4f16(<4 x half>, metadata)
define <4 x i1> @vfptoui_v4f16_v4i1(<4 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f16_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <4 x i1> @llvm.experimental.constrained.fptoui.v4i1.v4f16(<4 x half> %va, metadata !"fpexcept.strict")
  ret <4 x i1> %evec
}

declare <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f16(<4 x half>, metadata)
define <4 x i8> @vfptosi_v4f16_v4i8(<4 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f16_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f16(<4 x half> %va, metadata !"fpexcept.strict")
  ret <4 x i8> %evec
}

declare <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f16(<4 x half>, metadata)
define <4 x i8> @vfptoui_v4f16_v4i8(<4 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f16_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f16(<4 x half> %va, metadata !"fpexcept.strict")
  ret <4 x i8> %evec
}

declare <4 x i16> @llvm.experimental.constrained.fptosi.v4i16.v4f16(<4 x half>, metadata)
define <4 x i16> @vfptosi_v4f16_v4i16(<4 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f16_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <4 x i16> @llvm.experimental.constrained.fptosi.v4i16.v4f16(<4 x half> %va, metadata !"fpexcept.strict")
  ret <4 x i16> %evec
}

declare <4 x i16> @llvm.experimental.constrained.fptoui.v4i16.v4f16(<4 x half>, metadata)
define <4 x i16> @vfptoui_v4f16_v4i16(<4 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f16_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <4 x i16> @llvm.experimental.constrained.fptoui.v4i16.v4f16(<4 x half> %va, metadata !"fpexcept.strict")
  ret <4 x i16> %evec
}

declare <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f16(<4 x half>, metadata)
define <4 x i32> @vfptosi_v4f16_v4i32(<4 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f16_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f16(<4 x half> %va, metadata !"fpexcept.strict")
  ret <4 x i32> %evec
}

declare <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f16(<4 x half>, metadata)
define <4 x i32> @vfptoui_v4f16_v4i32(<4 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f16_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f16(<4 x half> %va, metadata !"fpexcept.strict")
  ret <4 x i32> %evec
}

declare <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f16(<4 x half>, metadata)
define <4 x i64> @vfptosi_v4f16_v4i64(<4 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f16_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f16(<4 x half> %va, metadata !"fpexcept.strict")
  ret <4 x i64> %evec
}

declare <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f16(<4 x half>, metadata)
define <4 x i64> @vfptoui_v4f16_v4i64(<4 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f16_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f16(<4 x half> %va, metadata !"fpexcept.strict")
  ret <4 x i64> %evec
}

declare <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f16(<8 x half>, metadata)
define <8 x i1> @vfptosi_v8f16_v8i1(<8 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f16_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f16(<8 x half> %va, metadata !"fpexcept.strict")
  ret <8 x i1> %evec
}

declare <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f16(<8 x half>, metadata)
define <8 x i1> @vfptoui_v8f16_v8i1(<8 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f16_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f16(<8 x half> %va, metadata !"fpexcept.strict")
  ret <8 x i1> %evec
}

declare <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f16(<8 x half>, metadata)
define <8 x i8> @vfptosi_v8f16_v8i8(<8 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f16_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f16(<8 x half> %va, metadata !"fpexcept.strict")
  ret <8 x i8> %evec
}

declare <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f16(<8 x half>, metadata)
define <8 x i8> @vfptoui_v8f16_v8i8(<8 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f16_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f16(<8 x half> %va, metadata !"fpexcept.strict")
  ret <8 x i8> %evec
}

declare <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f16(<8 x half>, metadata)
define <8 x i16> @vfptosi_v8f16_v8i16(<8 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f16_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f16(<8 x half> %va, metadata !"fpexcept.strict")
  ret <8 x i16> %evec
}

declare <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f16(<8 x half>, metadata)
define <8 x i16> @vfptoui_v8f16_v8i16(<8 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f16_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f16(<8 x half> %va, metadata !"fpexcept.strict")
  ret <8 x i16> %evec
}

declare <8 x i32> @llvm.experimental.constrained.fptosi.v8i32.v8f16(<8 x half>, metadata)
define <8 x i32> @vfptosi_v8f16_v8i32(<8 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f16_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x i32> @llvm.experimental.constrained.fptosi.v8i32.v8f16(<8 x half> %va, metadata !"fpexcept.strict")
  ret <8 x i32> %evec
}

declare <8 x i32> @llvm.experimental.constrained.fptoui.v8i32.v8f16(<8 x half>, metadata)
define <8 x i32> @vfptoui_v8f16_v8i32(<8 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f16_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x i32> @llvm.experimental.constrained.fptoui.v8i32.v8f16(<8 x half> %va, metadata !"fpexcept.strict")
  ret <8 x i32> %evec
}

declare <8 x i64> @llvm.experimental.constrained.fptosi.v8i64.v8f16(<8 x half>, metadata)
define <8 x i64> @vfptosi_v8f16_v8i64(<8 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f16_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x i64> @llvm.experimental.constrained.fptosi.v8i64.v8f16(<8 x half> %va, metadata !"fpexcept.strict")
  ret <8 x i64> %evec
}

declare <8 x i64> @llvm.experimental.constrained.fptoui.v8i64.v8f16(<8 x half>, metadata)
define <8 x i64> @vfptoui_v8f16_v8i64(<8 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f16_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x i64> @llvm.experimental.constrained.fptoui.v8i64.v8f16(<8 x half> %va, metadata !"fpexcept.strict")
  ret <8 x i64> %evec
}

declare <16 x i1> @llvm.experimental.constrained.fptosi.v16i1.v16f16(<16 x half>, metadata)
define <16 x i1> @vfptosi_v16f16_v16i1(<16 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v16f16_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vand.vi v8, v10, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <16 x i1> @llvm.experimental.constrained.fptosi.v16i1.v16f16(<16 x half> %va, metadata !"fpexcept.strict")
  ret <16 x i1> %evec
}

declare <16 x i1> @llvm.experimental.constrained.fptoui.v16i1.v16f16(<16 x half>, metadata)
define <16 x i1> @vfptoui_v16f16_v16i1(<16 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v16f16_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vand.vi v8, v10, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <16 x i1> @llvm.experimental.constrained.fptoui.v16i1.v16f16(<16 x half> %va, metadata !"fpexcept.strict")
  ret <16 x i1> %evec
}

declare <16 x i8> @llvm.experimental.constrained.fptosi.v16i8.v16f16(<16 x half>, metadata)
define <16 x i8> @vfptosi_v16f16_v16i8(<16 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v16f16_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <16 x i8> @llvm.experimental.constrained.fptosi.v16i8.v16f16(<16 x half> %va, metadata !"fpexcept.strict")
  ret <16 x i8> %evec
}

declare <16 x i8> @llvm.experimental.constrained.fptoui.v16i8.v16f16(<16 x half>, metadata)
define <16 x i8> @vfptoui_v16f16_v16i8(<16 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v16f16_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <16 x i8> @llvm.experimental.constrained.fptoui.v16i8.v16f16(<16 x half> %va, metadata !"fpexcept.strict")
  ret <16 x i8> %evec
}

declare <16 x i16> @llvm.experimental.constrained.fptosi.v16i16.v16f16(<16 x half>, metadata)
define <16 x i16> @vfptosi_v16f16_v16i16(<16 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v16f16_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <16 x i16> @llvm.experimental.constrained.fptosi.v16i16.v16f16(<16 x half> %va, metadata !"fpexcept.strict")
  ret <16 x i16> %evec
}

declare <16 x i16> @llvm.experimental.constrained.fptoui.v16i16.v16f16(<16 x half>, metadata)
define <16 x i16> @vfptoui_v16f16_v16i16(<16 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v16f16_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <16 x i16> @llvm.experimental.constrained.fptoui.v16i16.v16f16(<16 x half> %va, metadata !"fpexcept.strict")
  ret <16 x i16> %evec
}

declare <16 x i32> @llvm.experimental.constrained.fptosi.v16i32.v16f16(<16 x half>, metadata)
define <16 x i32> @vfptosi_v16f16_v16i32(<16 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v16f16_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <16 x i32> @llvm.experimental.constrained.fptosi.v16i32.v16f16(<16 x half> %va, metadata !"fpexcept.strict")
  ret <16 x i32> %evec
}

declare <16 x i32> @llvm.experimental.constrained.fptoui.v16i32.v16f16(<16 x half>, metadata)
define <16 x i32> @vfptoui_v16f16_v16i32(<16 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v16f16_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <16 x i32> @llvm.experimental.constrained.fptoui.v16i32.v16f16(<16 x half> %va, metadata !"fpexcept.strict")
  ret <16 x i32> %evec
}

declare <32 x i1> @llvm.experimental.constrained.fptosi.v32i1.v32f16(<32 x half>, metadata)
define <32 x i1> @vfptosi_v32f16_v32i1(<32 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v32f16_v32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vand.vi v8, v12, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <32 x i1> @llvm.experimental.constrained.fptosi.v32i1.v32f16(<32 x half> %va, metadata !"fpexcept.strict")
  ret <32 x i1> %evec
}

declare <32 x i1> @llvm.experimental.constrained.fptoui.v32i1.v32f16(<32 x half>, metadata)
define <32 x i1> @vfptoui_v32f16_v32i1(<32 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v32f16_v32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vand.vi v8, v12, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <32 x i1> @llvm.experimental.constrained.fptoui.v32i1.v32f16(<32 x half> %va, metadata !"fpexcept.strict")
  ret <32 x i1> %evec
}

declare <32 x i8> @llvm.experimental.constrained.fptosi.v32i8.v32f16(<32 x half>, metadata)
define <32 x i8> @vfptosi_v32f16_v32i8(<32 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v32f16_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <32 x i8> @llvm.experimental.constrained.fptosi.v32i8.v32f16(<32 x half> %va, metadata !"fpexcept.strict")
  ret <32 x i8> %evec
}

declare <32 x i8> @llvm.experimental.constrained.fptoui.v32i8.v32f16(<32 x half>, metadata)
define <32 x i8> @vfptoui_v32f16_v32i8(<32 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v32f16_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <32 x i8> @llvm.experimental.constrained.fptoui.v32i8.v32f16(<32 x half> %va, metadata !"fpexcept.strict")
  ret <32 x i8> %evec
}

declare <32 x i16> @llvm.experimental.constrained.fptosi.v32i16.v32f16(<32 x half>, metadata)
define <32 x i16> @vfptosi_v32f16_v32i16(<32 x half> %va) strictfp {
; CHECK-LABEL: vfptosi_v32f16_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <32 x i16> @llvm.experimental.constrained.fptosi.v32i16.v32f16(<32 x half> %va, metadata !"fpexcept.strict")
  ret <32 x i16> %evec
}

declare <32 x i16> @llvm.experimental.constrained.fptoui.v32i16.v32f16(<32 x half>, metadata)
define <32 x i16> @vfptoui_v32f16_v32i16(<32 x half> %va) strictfp {
; CHECK-LABEL: vfptoui_v32f16_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <32 x i16> @llvm.experimental.constrained.fptoui.v32i16.v32f16(<32 x half> %va, metadata !"fpexcept.strict")
  ret <32 x i16> %evec
}

declare <1 x i1> @llvm.experimental.constrained.fptosi.v1i1.v1f32(<1 x float>, metadata)
define <1 x i1> @vfptosi_v1f32_v1i1(<1 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f32_v1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <1 x i1> @llvm.experimental.constrained.fptosi.v1i1.v1f32(<1 x float> %va, metadata !"fpexcept.strict")
  ret <1 x i1> %evec
}

declare <1 x i1> @llvm.experimental.constrained.fptoui.v1i1.v1f32(<1 x float>, metadata)
define <1 x i1> @vfptoui_v1f32_v1i1(<1 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f32_v1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <1 x i1> @llvm.experimental.constrained.fptoui.v1i1.v1f32(<1 x float> %va, metadata !"fpexcept.strict")
  ret <1 x i1> %evec
}

declare <1 x i8> @llvm.experimental.constrained.fptosi.v1i8.v1f32(<1 x float>, metadata)
define <1 x i8> @vfptosi_v1f32_v1i8(<1 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f32_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = call <1 x i8> @llvm.experimental.constrained.fptosi.v1i8.v1f32(<1 x float> %va, metadata !"fpexcept.strict")
  ret <1 x i8> %evec
}

declare <1 x i8> @llvm.experimental.constrained.fptoui.v1i8.v1f32(<1 x float>, metadata)
define <1 x i8> @vfptoui_v1f32_v1i8(<1 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f32_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = call <1 x i8> @llvm.experimental.constrained.fptoui.v1i8.v1f32(<1 x float> %va, metadata !"fpexcept.strict")
  ret <1 x i8> %evec
}

declare <1 x i16> @llvm.experimental.constrained.fptosi.v1i16.v1f32(<1 x float>, metadata)
define <1 x i16> @vfptosi_v1f32_v1i16(<1 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f32_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x i16> @llvm.experimental.constrained.fptosi.v1i16.v1f32(<1 x float> %va, metadata !"fpexcept.strict")
  ret <1 x i16> %evec
}

declare <1 x i16> @llvm.experimental.constrained.fptoui.v1i16.v1f32(<1 x float>, metadata)
define <1 x i16> @vfptoui_v1f32_v1i16(<1 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f32_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x i16> @llvm.experimental.constrained.fptoui.v1i16.v1f32(<1 x float> %va, metadata !"fpexcept.strict")
  ret <1 x i16> %evec
}

declare <1 x i32> @llvm.experimental.constrained.fptosi.v1i32.v1f32(<1 x float>, metadata)
define <1 x i32> @vfptosi_v1f32_v1i32(<1 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f32_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <1 x i32> @llvm.experimental.constrained.fptosi.v1i32.v1f32(<1 x float> %va, metadata !"fpexcept.strict")
  ret <1 x i32> %evec
}

declare <1 x i32> @llvm.experimental.constrained.fptoui.v1i32.v1f32(<1 x float>, metadata)
define <1 x i32> @vfptoui_v1f32_v1i32(<1 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f32_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <1 x i32> @llvm.experimental.constrained.fptoui.v1i32.v1f32(<1 x float> %va, metadata !"fpexcept.strict")
  ret <1 x i32> %evec
}

declare <1 x i64> @llvm.experimental.constrained.fptosi.v1i64.v1f32(<1 x float>, metadata)
define <1 x i64> @vfptosi_v1f32_v1i64(<1 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f32_v1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x i64> @llvm.experimental.constrained.fptosi.v1i64.v1f32(<1 x float> %va, metadata !"fpexcept.strict")
  ret <1 x i64> %evec
}

declare <1 x i64> @llvm.experimental.constrained.fptoui.v1i64.v1f32(<1 x float>, metadata)
define <1 x i64> @vfptoui_v1f32_v1i64(<1 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f32_v1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x i64> @llvm.experimental.constrained.fptoui.v1i64.v1f32(<1 x float> %va, metadata !"fpexcept.strict")
  ret <1 x i64> %evec
}

declare <2 x i1> @llvm.experimental.constrained.fptosi.v2i1.v2f32(<2 x float>, metadata)
define <2 x i1> @vfptosi_v2f32_v2i1(<2 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f32_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <2 x i1> @llvm.experimental.constrained.fptosi.v2i1.v2f32(<2 x float> %va, metadata !"fpexcept.strict")
  ret <2 x i1> %evec
}

declare <2 x i1> @llvm.experimental.constrained.fptoui.v2i1.v2f32(<2 x float>, metadata)
define <2 x i1> @vfptoui_v2f32_v2i1(<2 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f32_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <2 x i1> @llvm.experimental.constrained.fptoui.v2i1.v2f32(<2 x float> %va, metadata !"fpexcept.strict")
  ret <2 x i1> %evec
}

declare <2 x i8> @llvm.experimental.constrained.fptosi.v2i8.v2f32(<2 x float>, metadata)
define <2 x i8> @vfptosi_v2f32_v2i8(<2 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f32_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = call <2 x i8> @llvm.experimental.constrained.fptosi.v2i8.v2f32(<2 x float> %va, metadata !"fpexcept.strict")
  ret <2 x i8> %evec
}

declare <2 x i8> @llvm.experimental.constrained.fptoui.v2i8.v2f32(<2 x float>, metadata)
define <2 x i8> @vfptoui_v2f32_v2i8(<2 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f32_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = call <2 x i8> @llvm.experimental.constrained.fptoui.v2i8.v2f32(<2 x float> %va, metadata !"fpexcept.strict")
  ret <2 x i8> %evec
}

declare <2 x i16> @llvm.experimental.constrained.fptosi.v2i16.v2f32(<2 x float>, metadata)
define <2 x i16> @vfptosi_v2f32_v2i16(<2 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f32_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x i16> @llvm.experimental.constrained.fptosi.v2i16.v2f32(<2 x float> %va, metadata !"fpexcept.strict")
  ret <2 x i16> %evec
}

declare <2 x i16> @llvm.experimental.constrained.fptoui.v2i16.v2f32(<2 x float>, metadata)
define <2 x i16> @vfptoui_v2f32_v2i16(<2 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f32_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x i16> @llvm.experimental.constrained.fptoui.v2i16.v2f32(<2 x float> %va, metadata !"fpexcept.strict")
  ret <2 x i16> %evec
}

declare <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f32(<2 x float>, metadata)
define <2 x i32> @vfptosi_v2f32_v2i32(<2 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f32_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f32(<2 x float> %va, metadata !"fpexcept.strict")
  ret <2 x i32> %evec
}

declare <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f32(<2 x float>, metadata)
define <2 x i32> @vfptoui_v2f32_v2i32(<2 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f32_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f32(<2 x float> %va, metadata !"fpexcept.strict")
  ret <2 x i32> %evec
}

declare <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f32(<2 x float>, metadata)
define <2 x i64> @vfptosi_v2f32_v2i64(<2 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f32_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f32(<2 x float> %va, metadata !"fpexcept.strict")
  ret <2 x i64> %evec
}

declare <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f32(<2 x float>, metadata)
define <2 x i64> @vfptoui_v2f32_v2i64(<2 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f32_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f32(<2 x float> %va, metadata !"fpexcept.strict")
  ret <2 x i64> %evec
}

declare <4 x i1> @llvm.experimental.constrained.fptosi.v4i1.v4f32(<4 x float>, metadata)
define <4 x i1> @vfptosi_v4f32_v4i1(<4 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f32_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <4 x i1> @llvm.experimental.constrained.fptosi.v4i1.v4f32(<4 x float> %va, metadata !"fpexcept.strict")
  ret <4 x i1> %evec
}

declare <4 x i1> @llvm.experimental.constrained.fptoui.v4i1.v4f32(<4 x float>, metadata)
define <4 x i1> @vfptoui_v4f32_v4i1(<4 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f32_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <4 x i1> @llvm.experimental.constrained.fptoui.v4i1.v4f32(<4 x float> %va, metadata !"fpexcept.strict")
  ret <4 x i1> %evec
}

declare <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f32(<4 x float>, metadata)
define <4 x i8> @vfptosi_v4f32_v4i8(<4 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f32_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = call <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f32(<4 x float> %va, metadata !"fpexcept.strict")
  ret <4 x i8> %evec
}

declare <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f32(<4 x float>, metadata)
define <4 x i8> @vfptoui_v4f32_v4i8(<4 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f32_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = call <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f32(<4 x float> %va, metadata !"fpexcept.strict")
  ret <4 x i8> %evec
}

declare <4 x i16> @llvm.experimental.constrained.fptosi.v4i16.v4f32(<4 x float>, metadata)
define <4 x i16> @vfptosi_v4f32_v4i16(<4 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f32_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x i16> @llvm.experimental.constrained.fptosi.v4i16.v4f32(<4 x float> %va, metadata !"fpexcept.strict")
  ret <4 x i16> %evec
}

declare <4 x i16> @llvm.experimental.constrained.fptoui.v4i16.v4f32(<4 x float>, metadata)
define <4 x i16> @vfptoui_v4f32_v4i16(<4 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f32_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x i16> @llvm.experimental.constrained.fptoui.v4i16.v4f32(<4 x float> %va, metadata !"fpexcept.strict")
  ret <4 x i16> %evec
}

declare <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f32(<4 x float>, metadata)
define <4 x i32> @vfptosi_v4f32_v4i32(<4 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f32_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f32(<4 x float> %va, metadata !"fpexcept.strict")
  ret <4 x i32> %evec
}

declare <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f32(<4 x float>, metadata)
define <4 x i32> @vfptoui_v4f32_v4i32(<4 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f32_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f32(<4 x float> %va, metadata !"fpexcept.strict")
  ret <4 x i32> %evec
}

declare <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f32(<4 x float>, metadata)
define <4 x i64> @vfptosi_v4f32_v4i64(<4 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f32_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f32(<4 x float> %va, metadata !"fpexcept.strict")
  ret <4 x i64> %evec
}

declare <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f32(<4 x float>, metadata)
define <4 x i64> @vfptoui_v4f32_v4i64(<4 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f32_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f32(<4 x float> %va, metadata !"fpexcept.strict")
  ret <4 x i64> %evec
}

declare <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f32(<8 x float>, metadata)
define <8 x i1> @vfptosi_v8f32_v8i1(<8 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f32_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vand.vi v8, v10, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f32(<8 x float> %va, metadata !"fpexcept.strict")
  ret <8 x i1> %evec
}

declare <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f32(<8 x float>, metadata)
define <8 x i1> @vfptoui_v8f32_v8i1(<8 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f32_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vand.vi v8, v10, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f32(<8 x float> %va, metadata !"fpexcept.strict")
  ret <8 x i1> %evec
}

declare <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f32(<8 x float>, metadata)
define <8 x i8> @vfptosi_v8f32_v8i8(<8 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f32_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    ret
  %evec = call <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f32(<8 x float> %va, metadata !"fpexcept.strict")
  ret <8 x i8> %evec
}

declare <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f32(<8 x float>, metadata)
define <8 x i8> @vfptoui_v8f32_v8i8(<8 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f32_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    ret
  %evec = call <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f32(<8 x float> %va, metadata !"fpexcept.strict")
  ret <8 x i8> %evec
}

declare <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f32(<8 x float>, metadata)
define <8 x i16> @vfptosi_v8f32_v8i16(<8 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f32_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f32(<8 x float> %va, metadata !"fpexcept.strict")
  ret <8 x i16> %evec
}

declare <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f32(<8 x float>, metadata)
define <8 x i16> @vfptoui_v8f32_v8i16(<8 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f32_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f32(<8 x float> %va, metadata !"fpexcept.strict")
  ret <8 x i16> %evec
}

declare <8 x i32> @llvm.experimental.constrained.fptosi.v8i32.v8f32(<8 x float>, metadata)
define <8 x i32> @vfptosi_v8f32_v8i32(<8 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f32_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <8 x i32> @llvm.experimental.constrained.fptosi.v8i32.v8f32(<8 x float> %va, metadata !"fpexcept.strict")
  ret <8 x i32> %evec
}

declare <8 x i32> @llvm.experimental.constrained.fptoui.v8i32.v8f32(<8 x float>, metadata)
define <8 x i32> @vfptoui_v8f32_v8i32(<8 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f32_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <8 x i32> @llvm.experimental.constrained.fptoui.v8i32.v8f32(<8 x float> %va, metadata !"fpexcept.strict")
  ret <8 x i32> %evec
}

declare <8 x i64> @llvm.experimental.constrained.fptosi.v8i64.v8f32(<8 x float>, metadata)
define <8 x i64> @vfptosi_v8f32_v8i64(<8 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f32_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x i64> @llvm.experimental.constrained.fptosi.v8i64.v8f32(<8 x float> %va, metadata !"fpexcept.strict")
  ret <8 x i64> %evec
}

declare <8 x i64> @llvm.experimental.constrained.fptoui.v8i64.v8f32(<8 x float>, metadata)
define <8 x i64> @vfptoui_v8f32_v8i64(<8 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f32_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x i64> @llvm.experimental.constrained.fptoui.v8i64.v8f32(<8 x float> %va, metadata !"fpexcept.strict")
  ret <8 x i64> %evec
}

declare <16 x i1> @llvm.experimental.constrained.fptosi.v16i1.v16f32(<16 x float>, metadata)
define <16 x i1> @vfptosi_v16f32_v16i1(<16 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v16f32_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vand.vi v8, v12, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <16 x i1> @llvm.experimental.constrained.fptosi.v16i1.v16f32(<16 x float> %va, metadata !"fpexcept.strict")
  ret <16 x i1> %evec
}

declare <16 x i1> @llvm.experimental.constrained.fptoui.v16i1.v16f32(<16 x float>, metadata)
define <16 x i1> @vfptoui_v16f32_v16i1(<16 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v16f32_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vand.vi v8, v12, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <16 x i1> @llvm.experimental.constrained.fptoui.v16i1.v16f32(<16 x float> %va, metadata !"fpexcept.strict")
  ret <16 x i1> %evec
}

declare <16 x i8> @llvm.experimental.constrained.fptosi.v16i8.v16f32(<16 x float>, metadata)
define <16 x i8> @vfptosi_v16f32_v16i8(<16 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v16f32_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    ret
  %evec = call <16 x i8> @llvm.experimental.constrained.fptosi.v16i8.v16f32(<16 x float> %va, metadata !"fpexcept.strict")
  ret <16 x i8> %evec
}

declare <16 x i8> @llvm.experimental.constrained.fptoui.v16i8.v16f32(<16 x float>, metadata)
define <16 x i8> @vfptoui_v16f32_v16i8(<16 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v16f32_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    ret
  %evec = call <16 x i8> @llvm.experimental.constrained.fptoui.v16i8.v16f32(<16 x float> %va, metadata !"fpexcept.strict")
  ret <16 x i8> %evec
}

declare <16 x i16> @llvm.experimental.constrained.fptosi.v16i16.v16f32(<16 x float>, metadata)
define <16 x i16> @vfptosi_v16f32_v16i16(<16 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v16f32_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <16 x i16> @llvm.experimental.constrained.fptosi.v16i16.v16f32(<16 x float> %va, metadata !"fpexcept.strict")
  ret <16 x i16> %evec
}

declare <16 x i16> @llvm.experimental.constrained.fptoui.v16i16.v16f32(<16 x float>, metadata)
define <16 x i16> @vfptoui_v16f32_v16i16(<16 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v16f32_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <16 x i16> @llvm.experimental.constrained.fptoui.v16i16.v16f32(<16 x float> %va, metadata !"fpexcept.strict")
  ret <16 x i16> %evec
}

declare <16 x i32> @llvm.experimental.constrained.fptosi.v16i32.v16f32(<16 x float>, metadata)
define <16 x i32> @vfptosi_v16f32_v16i32(<16 x float> %va) strictfp {
; CHECK-LABEL: vfptosi_v16f32_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <16 x i32> @llvm.experimental.constrained.fptosi.v16i32.v16f32(<16 x float> %va, metadata !"fpexcept.strict")
  ret <16 x i32> %evec
}

declare <16 x i32> @llvm.experimental.constrained.fptoui.v16i32.v16f32(<16 x float>, metadata)
define <16 x i32> @vfptoui_v16f32_v16i32(<16 x float> %va) strictfp {
; CHECK-LABEL: vfptoui_v16f32_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <16 x i32> @llvm.experimental.constrained.fptoui.v16i32.v16f32(<16 x float> %va, metadata !"fpexcept.strict")
  ret <16 x i32> %evec
}

declare <1 x i1> @llvm.experimental.constrained.fptosi.v1i1.v1f64(<1 x double>, metadata)
define <1 x i1> @vfptosi_v1f64_v1i1(<1 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f64_v1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <1 x i1> @llvm.experimental.constrained.fptosi.v1i1.v1f64(<1 x double> %va, metadata !"fpexcept.strict")
  ret <1 x i1> %evec
}

declare <1 x i1> @llvm.experimental.constrained.fptoui.v1i1.v1f64(<1 x double>, metadata)
define <1 x i1> @vfptoui_v1f64_v1i1(<1 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f64_v1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <1 x i1> @llvm.experimental.constrained.fptoui.v1i1.v1f64(<1 x double> %va, metadata !"fpexcept.strict")
  ret <1 x i1> %evec
}

declare <1 x i8> @llvm.experimental.constrained.fptosi.v1i8.v1f64(<1 x double>, metadata)
define <1 x i8> @vfptosi_v1f64_v1i8(<1 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f64_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = call <1 x i8> @llvm.experimental.constrained.fptosi.v1i8.v1f64(<1 x double> %va, metadata !"fpexcept.strict")
  ret <1 x i8> %evec
}

declare <1 x i8> @llvm.experimental.constrained.fptoui.v1i8.v1f64(<1 x double>, metadata)
define <1 x i8> @vfptoui_v1f64_v1i8(<1 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f64_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = call <1 x i8> @llvm.experimental.constrained.fptoui.v1i8.v1f64(<1 x double> %va, metadata !"fpexcept.strict")
  ret <1 x i8> %evec
}

declare <1 x i16> @llvm.experimental.constrained.fptosi.v1i16.v1f64(<1 x double>, metadata)
define <1 x i16> @vfptosi_v1f64_v1i16(<1 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f64_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = call <1 x i16> @llvm.experimental.constrained.fptosi.v1i16.v1f64(<1 x double> %va, metadata !"fpexcept.strict")
  ret <1 x i16> %evec
}

declare <1 x i16> @llvm.experimental.constrained.fptoui.v1i16.v1f64(<1 x double>, metadata)
define <1 x i16> @vfptoui_v1f64_v1i16(<1 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f64_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = call <1 x i16> @llvm.experimental.constrained.fptoui.v1i16.v1f64(<1 x double> %va, metadata !"fpexcept.strict")
  ret <1 x i16> %evec
}

declare <1 x i32> @llvm.experimental.constrained.fptosi.v1i32.v1f64(<1 x double>, metadata)
define <1 x i32> @vfptosi_v1f64_v1i32(<1 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f64_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x i32> @llvm.experimental.constrained.fptosi.v1i32.v1f64(<1 x double> %va, metadata !"fpexcept.strict")
  ret <1 x i32> %evec
}

declare <1 x i32> @llvm.experimental.constrained.fptoui.v1i32.v1f64(<1 x double>, metadata)
define <1 x i32> @vfptoui_v1f64_v1i32(<1 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f64_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x i32> @llvm.experimental.constrained.fptoui.v1i32.v1f64(<1 x double> %va, metadata !"fpexcept.strict")
  ret <1 x i32> %evec
}

declare <1 x i64> @llvm.experimental.constrained.fptosi.v1i64.v1f64(<1 x double>, metadata)
define <1 x i64> @vfptosi_v1f64_v1i64(<1 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v1f64_v1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <1 x i64> @llvm.experimental.constrained.fptosi.v1i64.v1f64(<1 x double> %va, metadata !"fpexcept.strict")
  ret <1 x i64> %evec
}

declare <1 x i64> @llvm.experimental.constrained.fptoui.v1i64.v1f64(<1 x double>, metadata)
define <1 x i64> @vfptoui_v1f64_v1i64(<1 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v1f64_v1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <1 x i64> @llvm.experimental.constrained.fptoui.v1i64.v1f64(<1 x double> %va, metadata !"fpexcept.strict")
  ret <1 x i64> %evec
}

declare <2 x i1> @llvm.experimental.constrained.fptosi.v2i1.v2f64(<2 x double>, metadata)
define <2 x i1> @vfptosi_v2f64_v2i1(<2 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f64_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <2 x i1> @llvm.experimental.constrained.fptosi.v2i1.v2f64(<2 x double> %va, metadata !"fpexcept.strict")
  ret <2 x i1> %evec
}

declare <2 x i1> @llvm.experimental.constrained.fptoui.v2i1.v2f64(<2 x double>, metadata)
define <2 x i1> @vfptoui_v2f64_v2i1(<2 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f64_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <2 x i1> @llvm.experimental.constrained.fptoui.v2i1.v2f64(<2 x double> %va, metadata !"fpexcept.strict")
  ret <2 x i1> %evec
}

declare <2 x i8> @llvm.experimental.constrained.fptosi.v2i8.v2f64(<2 x double>, metadata)
define <2 x i8> @vfptosi_v2f64_v2i8(<2 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f64_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = call <2 x i8> @llvm.experimental.constrained.fptosi.v2i8.v2f64(<2 x double> %va, metadata !"fpexcept.strict")
  ret <2 x i8> %evec
}

declare <2 x i8> @llvm.experimental.constrained.fptoui.v2i8.v2f64(<2 x double>, metadata)
define <2 x i8> @vfptoui_v2f64_v2i8(<2 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f64_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = call <2 x i8> @llvm.experimental.constrained.fptoui.v2i8.v2f64(<2 x double> %va, metadata !"fpexcept.strict")
  ret <2 x i8> %evec
}

declare <2 x i16> @llvm.experimental.constrained.fptosi.v2i16.v2f64(<2 x double>, metadata)
define <2 x i16> @vfptosi_v2f64_v2i16(<2 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f64_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = call <2 x i16> @llvm.experimental.constrained.fptosi.v2i16.v2f64(<2 x double> %va, metadata !"fpexcept.strict")
  ret <2 x i16> %evec
}

declare <2 x i16> @llvm.experimental.constrained.fptoui.v2i16.v2f64(<2 x double>, metadata)
define <2 x i16> @vfptoui_v2f64_v2i16(<2 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f64_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = call <2 x i16> @llvm.experimental.constrained.fptoui.v2i16.v2f64(<2 x double> %va, metadata !"fpexcept.strict")
  ret <2 x i16> %evec
}

declare <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f64(<2 x double>, metadata)
define <2 x i32> @vfptosi_v2f64_v2i32(<2 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f64_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f64(<2 x double> %va, metadata !"fpexcept.strict")
  ret <2 x i32> %evec
}

declare <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f64(<2 x double>, metadata)
define <2 x i32> @vfptoui_v2f64_v2i32(<2 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f64_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f64(<2 x double> %va, metadata !"fpexcept.strict")
  ret <2 x i32> %evec
}

declare <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f64(<2 x double>, metadata)
define <2 x i64> @vfptosi_v2f64_v2i64(<2 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v2f64_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f64(<2 x double> %va, metadata !"fpexcept.strict")
  ret <2 x i64> %evec
}

declare <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f64(<2 x double>, metadata)
define <2 x i64> @vfptoui_v2f64_v2i64(<2 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v2f64_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f64(<2 x double> %va, metadata !"fpexcept.strict")
  ret <2 x i64> %evec
}

declare <4 x i1> @llvm.experimental.constrained.fptosi.v4i1.v4f64(<4 x double>, metadata)
define <4 x i1> @vfptosi_v4f64_v4i1(<4 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f64_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vand.vi v8, v10, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <4 x i1> @llvm.experimental.constrained.fptosi.v4i1.v4f64(<4 x double> %va, metadata !"fpexcept.strict")
  ret <4 x i1> %evec
}

declare <4 x i1> @llvm.experimental.constrained.fptoui.v4i1.v4f64(<4 x double>, metadata)
define <4 x i1> @vfptoui_v4f64_v4i1(<4 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f64_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vand.vi v8, v10, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <4 x i1> @llvm.experimental.constrained.fptoui.v4i1.v4f64(<4 x double> %va, metadata !"fpexcept.strict")
  ret <4 x i1> %evec
}

declare <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f64(<4 x double>, metadata)
define <4 x i8> @vfptosi_v4f64_v4i8(<4 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f64_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = call <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f64(<4 x double> %va, metadata !"fpexcept.strict")
  ret <4 x i8> %evec
}

declare <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f64(<4 x double>, metadata)
define <4 x i8> @vfptoui_v4f64_v4i8(<4 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f64_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = call <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f64(<4 x double> %va, metadata !"fpexcept.strict")
  ret <4 x i8> %evec
}

declare <4 x i16> @llvm.experimental.constrained.fptosi.v4i16.v4f64(<4 x double>, metadata)
define <4 x i16> @vfptosi_v4f64_v4i16(<4 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f64_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    ret
  %evec = call <4 x i16> @llvm.experimental.constrained.fptosi.v4i16.v4f64(<4 x double> %va, metadata !"fpexcept.strict")
  ret <4 x i16> %evec
}

declare <4 x i16> @llvm.experimental.constrained.fptoui.v4i16.v4f64(<4 x double>, metadata)
define <4 x i16> @vfptoui_v4f64_v4i16(<4 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f64_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    ret
  %evec = call <4 x i16> @llvm.experimental.constrained.fptoui.v4i16.v4f64(<4 x double> %va, metadata !"fpexcept.strict")
  ret <4 x i16> %evec
}

declare <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f64(<4 x double>, metadata)
define <4 x i32> @vfptosi_v4f64_v4i32(<4 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f64_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f64(<4 x double> %va, metadata !"fpexcept.strict")
  ret <4 x i32> %evec
}

declare <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f64(<4 x double>, metadata)
define <4 x i32> @vfptoui_v4f64_v4i32(<4 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f64_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f64(<4 x double> %va, metadata !"fpexcept.strict")
  ret <4 x i32> %evec
}

declare <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f64(<4 x double>, metadata)
define <4 x i64> @vfptosi_v4f64_v4i64(<4 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v4f64_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f64(<4 x double> %va, metadata !"fpexcept.strict")
  ret <4 x i64> %evec
}

declare <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f64(<4 x double>, metadata)
define <4 x i64> @vfptoui_v4f64_v4i64(<4 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v4f64_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f64(<4 x double> %va, metadata !"fpexcept.strict")
  ret <4 x i64> %evec
}

declare <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f64(<8 x double>, metadata)
define <8 x i1> @vfptosi_v8f64_v8i1(<8 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f64_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vand.vi v8, v12, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f64(<8 x double> %va, metadata !"fpexcept.strict")
  ret <8 x i1> %evec
}

declare <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f64(<8 x double>, metadata)
define <8 x i1> @vfptoui_v8f64_v8i1(<8 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f64_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vand.vi v8, v12, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = call <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f64(<8 x double> %va, metadata !"fpexcept.strict")
  ret <8 x i1> %evec
}

declare <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f64(<8 x double>, metadata)
define <8 x i8> @vfptosi_v8f64_v8i8(<8 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f64_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = call <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f64(<8 x double> %va, metadata !"fpexcept.strict")
  ret <8 x i8> %evec
}

declare <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f64(<8 x double>, metadata)
define <8 x i8> @vfptoui_v8f64_v8i8(<8 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f64_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = call <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f64(<8 x double> %va, metadata !"fpexcept.strict")
  ret <8 x i8> %evec
}

declare <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f64(<8 x double>, metadata)
define <8 x i16> @vfptosi_v8f64_v8i16(<8 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f64_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    ret
  %evec = call <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f64(<8 x double> %va, metadata !"fpexcept.strict")
  ret <8 x i16> %evec
}

declare <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f64(<8 x double>, metadata)
define <8 x i16> @vfptoui_v8f64_v8i16(<8 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f64_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    ret
  %evec = call <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f64(<8 x double> %va, metadata !"fpexcept.strict")
  ret <8 x i16> %evec
}

declare <8 x i32> @llvm.experimental.constrained.fptosi.v8i32.v8f64(<8 x double>, metadata)
define <8 x i32> @vfptosi_v8f64_v8i32(<8 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f64_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x i32> @llvm.experimental.constrained.fptosi.v8i32.v8f64(<8 x double> %va, metadata !"fpexcept.strict")
  ret <8 x i32> %evec
}

declare <8 x i32> @llvm.experimental.constrained.fptoui.v8i32.v8f64(<8 x double>, metadata)
define <8 x i32> @vfptoui_v8f64_v8i32(<8 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f64_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x i32> @llvm.experimental.constrained.fptoui.v8i32.v8f64(<8 x double> %va, metadata !"fpexcept.strict")
  ret <8 x i32> %evec
}

declare <8 x i64> @llvm.experimental.constrained.fptosi.v8i64.v8f64(<8 x double>, metadata)
define <8 x i64> @vfptosi_v8f64_v8i64(<8 x double> %va) strictfp {
; CHECK-LABEL: vfptosi_v8f64_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <8 x i64> @llvm.experimental.constrained.fptosi.v8i64.v8f64(<8 x double> %va, metadata !"fpexcept.strict")
  ret <8 x i64> %evec
}

declare <8 x i64> @llvm.experimental.constrained.fptoui.v8i64.v8f64(<8 x double>, metadata)
define <8 x i64> @vfptoui_v8f64_v8i64(<8 x double> %va) strictfp {
; CHECK-LABEL: vfptoui_v8f64_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <8 x i64> @llvm.experimental.constrained.fptoui.v8i64.v8f64(<8 x double> %va, metadata !"fpexcept.strict")
  ret <8 x i64> %evec
}
