// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 2
// RUN: %clang_cc1 -triple x86_64-linux-gnu -O2 -emit-llvm -o - %s | FileCheck %s

struct Tail {
  ~Tail();
  int a : 16;
  int b : 8;
};

struct Char {
  int a : 16;
  int b : 8;
  char c;
};

struct Int {
  int a : 16;
  int b : 8;
  int c;
};


// CHECK-LABEL: define dso_local void @_Z1AP4Tail
// CHECK-SAME: (ptr nocapture noundef [[P:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[BF_LOAD:%.*]] = load i16, ptr [[P]], align 4
// CHECK-NEXT:    [[INC:%.*]] = add i16 [[BF_LOAD]], 1
// CHECK-NEXT:    store i16 [[INC]], ptr [[P]], align 4
// CHECK-NEXT:    ret void
//
void A (Tail *p) {
  p->a++;
}

// CHECK-LABEL: define dso_local void @_Z1BP4Tail
// CHECK-SAME: (ptr nocapture noundef [[P:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[B:%.*]] = getelementptr inbounds nuw i8, ptr [[P]], i64 2
// CHECK-NEXT:    [[BF_LOAD:%.*]] = load i8, ptr [[B]], align 2
// CHECK-NEXT:    [[INC:%.*]] = add i8 [[BF_LOAD]], 1
// CHECK-NEXT:    store i8 [[INC]], ptr [[B]], align 2
// CHECK-NEXT:    ret void
//
void B (Tail *p) {
  p->b++;
}

// CHECK-LABEL: define dso_local void @_Z1AP4Char
// CHECK-SAME: (ptr nocapture noundef [[P:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[BF_LOAD:%.*]] = load i16, ptr [[P]], align 4
// CHECK-NEXT:    [[INC:%.*]] = add i16 [[BF_LOAD]], 1
// CHECK-NEXT:    store i16 [[INC]], ptr [[P]], align 4
// CHECK-NEXT:    ret void
//
void A (Char *p) {
  p->a++;
}

// CHECK-LABEL: define dso_local void @_Z1BP4Char
// CHECK-SAME: (ptr nocapture noundef [[P:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[B:%.*]] = getelementptr inbounds nuw i8, ptr [[P]], i64 2
// CHECK-NEXT:    [[BF_LOAD:%.*]] = load i8, ptr [[B]], align 2
// CHECK-NEXT:    [[INC:%.*]] = add i8 [[BF_LOAD]], 1
// CHECK-NEXT:    store i8 [[INC]], ptr [[B]], align 2
// CHECK-NEXT:    ret void
//
void B (Char *p) {
  p->b++;
}

// CHECK-LABEL: define dso_local void @_Z1AP3Int
// CHECK-SAME: (ptr nocapture noundef [[P:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[BF_LOAD:%.*]] = load i32, ptr [[P]], align 4
// CHECK-NEXT:    [[INC:%.*]] = add i32 [[BF_LOAD]], 1
// CHECK-NEXT:    [[BF_VALUE:%.*]] = and i32 [[INC]], 65535
// CHECK-NEXT:    [[BF_CLEAR:%.*]] = and i32 [[BF_LOAD]], -65536
// CHECK-NEXT:    [[BF_SET:%.*]] = or disjoint i32 [[BF_VALUE]], [[BF_CLEAR]]
// CHECK-NEXT:    store i32 [[BF_SET]], ptr [[P]], align 4
// CHECK-NEXT:    ret void
//
void A (Int *p) {
  p->a++;
}

// CHECK-LABEL: define dso_local void @_Z1BP3Int
// CHECK-SAME: (ptr nocapture noundef [[P:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[BF_LOAD:%.*]] = load i32, ptr [[P]], align 4
// CHECK-NEXT:    [[BF_VALUE:%.*]] = add i32 [[BF_LOAD]], 65536
// CHECK-NEXT:    [[BF_SHL2:%.*]] = and i32 [[BF_VALUE]], 16711680
// CHECK-NEXT:    [[BF_CLEAR:%.*]] = and i32 [[BF_LOAD]], -16711681
// CHECK-NEXT:    [[BF_SET:%.*]] = or disjoint i32 [[BF_SHL2]], [[BF_CLEAR]]
// CHECK-NEXT:    store i32 [[BF_SET]], ptr [[P]], align 4
// CHECK-NEXT:    ret void
//
void B (Int *p) {
  p->b++;
}
