; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple aarch64-arm-linux-gnu --enable-machine-outliner -outliner-leaf-descendants=false \
; RUN:   -verify-machineinstrs %s -o - | FileCheck --check-prefixes CHECK,V8A %s
; RUN: llc -mtriple aarch64 -enable-machine-outliner -outliner-leaf-descendants=false \
; RUN:   -verify-machineinstrs -mattr=+v8.3a %s -o - | \
; RUN:   FileCheck %s --check-prefixes CHECK,V83A

declare i32 @thunk_called_fn(i32, i32, i32, i32)

define i32 @a() #0 {
; V8A-LABEL: a:
; V8A:       // %bb.0: // %entry
; V8A-NEXT:    .cfi_negate_ra_state
; V8A-NEXT:    hint #25
; V8A-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; V8A-NEXT:    .cfi_def_cfa_offset 16
; V8A-NEXT:    .cfi_offset w30, -16
; V8A-NEXT:    mov w0, #1 // =0x1
; V8A-NEXT:    mov w1, #2 // =0x2
; V8A-NEXT:    mov w2, #3 // =0x3
; V8A-NEXT:    mov w3, #4 // =0x4
; V8A-NEXT:    bl thunk_called_fn
; V8A-NEXT:    add w0, w0, #8
; V8A-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; V8A-NEXT:    hint #29
; V8A-NEXT:    ret
;
; V83A-LABEL: a:
; V83A:       // %bb.0: // %entry
; V83A-NEXT:    .cfi_negate_ra_state
; V83A-NEXT:    paciasp
; V83A-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; V83A-NEXT:    .cfi_def_cfa_offset 16
; V83A-NEXT:    .cfi_offset w30, -16
; V83A-NEXT:    mov w0, #1 // =0x1
; V83A-NEXT:    mov w1, #2 // =0x2
; V83A-NEXT:    mov w2, #3 // =0x3
; V83A-NEXT:    mov w3, #4 // =0x4
; V83A-NEXT:    bl thunk_called_fn
; V83A-NEXT:    add w0, w0, #8
; V83A-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; V83A-NEXT:    retaa
entry:
  %call = tail call i32 @thunk_called_fn(i32 1, i32 2, i32 3, i32 4)
  %cx = add i32 %call, 8
  ret i32 %cx
}

define i32 @b() #0 {
; V8A-LABEL: b:
; V8A:       // %bb.0: // %entry
; V8A-NEXT:    .cfi_negate_ra_state
; V8A-NEXT:    hint #25
; V8A-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; V8A-NEXT:    .cfi_def_cfa_offset 16
; V8A-NEXT:    .cfi_offset w30, -16
; V8A-NEXT:    mov w0, #1 // =0x1
; V8A-NEXT:    mov w1, #2 // =0x2
; V8A-NEXT:    mov w2, #3 // =0x3
; V8A-NEXT:    mov w3, #4 // =0x4
; V8A-NEXT:    bl thunk_called_fn
; V8A-NEXT:    add w0, w0, #88
; V8A-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; V8A-NEXT:    hint #29
; V8A-NEXT:    ret
;
; V83A-LABEL: b:
; V83A:       // %bb.0: // %entry
; V83A-NEXT:    .cfi_negate_ra_state
; V83A-NEXT:    paciasp
; V83A-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; V83A-NEXT:    .cfi_def_cfa_offset 16
; V83A-NEXT:    .cfi_offset w30, -16
; V83A-NEXT:    mov w0, #1 // =0x1
; V83A-NEXT:    mov w1, #2 // =0x2
; V83A-NEXT:    mov w2, #3 // =0x3
; V83A-NEXT:    mov w3, #4 // =0x4
; V83A-NEXT:    bl thunk_called_fn
; V83A-NEXT:    add w0, w0, #88
; V83A-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; V83A-NEXT:    retaa
entry:
  %call = tail call i32 @thunk_called_fn(i32 1, i32 2, i32 3, i32 4)
  %cx = add i32 %call, 88
  ret i32 %cx
}

define hidden i32 @c(ptr %fptr) #0 {
; V8A-LABEL: c:
; V8A:       // %bb.0: // %entry
; V8A-NEXT:    .cfi_negate_ra_state
; V8A-NEXT:    hint #25
; V8A-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; V8A-NEXT:    .cfi_def_cfa_offset 16
; V8A-NEXT:    .cfi_offset w30, -16
; V8A-NEXT:    mov x8, x0
; V8A-NEXT:    mov w0, #1 // =0x1
; V8A-NEXT:    mov w1, #2 // =0x2
; V8A-NEXT:    mov w2, #3 // =0x3
; V8A-NEXT:    mov w3, #4 // =0x4
; V8A-NEXT:    blr x8
; V8A-NEXT:    add w0, w0, #8
; V8A-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; V8A-NEXT:    hint #29
; V8A-NEXT:    ret
;
; V83A-LABEL: c:
; V83A:       // %bb.0: // %entry
; V83A-NEXT:    .cfi_negate_ra_state
; V83A-NEXT:    paciasp
; V83A-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; V83A-NEXT:    .cfi_def_cfa_offset 16
; V83A-NEXT:    .cfi_offset w30, -16
; V83A-NEXT:    mov x8, x0
; V83A-NEXT:    mov w0, #1 // =0x1
; V83A-NEXT:    mov w1, #2 // =0x2
; V83A-NEXT:    mov w2, #3 // =0x3
; V83A-NEXT:    mov w3, #4 // =0x4
; V83A-NEXT:    blr x8
; V83A-NEXT:    add w0, w0, #8
; V83A-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; V83A-NEXT:    retaa
entry:
  %call = tail call i32 %fptr(i32 1, i32 2, i32 3, i32 4)
  %add = add nsw i32 %call, 8
  ret i32 %add
}

define hidden i32 @d(ptr %fptr) #0 {
; V8A-LABEL: d:
; V8A:       // %bb.0: // %entry
; V8A-NEXT:    .cfi_negate_ra_state
; V8A-NEXT:    hint #25
; V8A-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; V8A-NEXT:    .cfi_def_cfa_offset 16
; V8A-NEXT:    .cfi_offset w30, -16
; V8A-NEXT:    mov x8, x0
; V8A-NEXT:    mov w0, #1 // =0x1
; V8A-NEXT:    mov w1, #2 // =0x2
; V8A-NEXT:    mov w2, #3 // =0x3
; V8A-NEXT:    mov w3, #4 // =0x4
; V8A-NEXT:    blr x8
; V8A-NEXT:    add w0, w0, #88
; V8A-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; V8A-NEXT:    hint #29
; V8A-NEXT:    ret
;
; V83A-LABEL: d:
; V83A:       // %bb.0: // %entry
; V83A-NEXT:    .cfi_negate_ra_state
; V83A-NEXT:    paciasp
; V83A-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; V83A-NEXT:    .cfi_def_cfa_offset 16
; V83A-NEXT:    .cfi_offset w30, -16
; V83A-NEXT:    mov x8, x0
; V83A-NEXT:    mov w0, #1 // =0x1
; V83A-NEXT:    mov w1, #2 // =0x2
; V83A-NEXT:    mov w2, #3 // =0x3
; V83A-NEXT:    mov w3, #4 // =0x4
; V83A-NEXT:    blr x8
; V83A-NEXT:    add w0, w0, #88
; V83A-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; V83A-NEXT:    retaa
entry:
  %call = tail call i32 %fptr(i32 1, i32 2, i32 3, i32 4)
  %add = add nsw i32 %call, 88
  ret i32 %add
}

attributes #0 = { "sign-return-address"="non-leaf" minsize }

; CHECK-NOT:        OUTLINED_FUNCTION_{{.*}}
; CHECK-NOT:         .cfi_b_key_frame
; CHECK-NOT:         paci{{[a,b]}}sp
; CHECK-NOT:         hint #2{{[5,7]}}
; CHECK-NOT:         .cfi_negate_ra_state
; CHECK-NOT:         auti{{[a,b]}}sp
; CHECK-NOT:         hint #{{[29,31]}}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
