; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=x86_64-unknown-unknown --show-mc-encoding -mattr=+avxvnniint16 | FileCheck %s
; RUN: llc < %s -verify-machineinstrs -mtriple=i686-unknown-unknown --show-mc-encoding -mattr=+avxvnniint16 | FileCheck %s
; RUN: llc < %s -verify-machineinstrs -mtriple=x86_64-unknown-unknown --show-mc-encoding -mattr=+avx10.2-256 | FileCheck %s --check-prefix=AVX10
; RUN: llc < %s -verify-machineinstrs -mtriple=i686-unknown-unknown --show-mc-encoding -mattr=+avx10.2-256 | FileCheck %s --check-prefix=AVX10

define <4 x i32> @test_int_x86_avx2_vpdpwsud_128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: test_int_x86_avx2_vpdpwsud_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwsud %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x72,0xd2,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
;
; AVX10-LABEL: test_int_x86_avx2_vpdpwsud_128:
; AVX10:       # %bb.0:
; AVX10-NEXT:    vpdpwsud %xmm2, %xmm1, %xmm0 # encoding: [0x62,0xf2,0x76,0x08,0xd2,0xc2]
; AVX10-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx2.vpdpwsud.128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C)
  ret <4 x i32> %ret
}
declare <4 x i32> @llvm.x86.avx2.vpdpwsud.128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C)

define <8 x i32> @test_int_x86_avx2_vpdpwsud_256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C) {
; CHECK-LABEL: test_int_x86_avx2_vpdpwsud_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwsud %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0x76,0xd2,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
;
; AVX10-LABEL: test_int_x86_avx2_vpdpwsud_256:
; AVX10:       # %bb.0:
; AVX10-NEXT:    vpdpwsud %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf2,0x76,0x28,0xd2,0xc2]
; AVX10-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx2.vpdpwsud.256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C)
  ret <8 x i32> %ret
}
declare <8 x i32> @llvm.x86.avx2.vpdpwsud.256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C)

define <4 x i32> @test_int_x86_avx2_vpdpwsuds_128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: test_int_x86_avx2_vpdpwsuds_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwsuds %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x72,0xd3,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
;
; AVX10-LABEL: test_int_x86_avx2_vpdpwsuds_128:
; AVX10:       # %bb.0:
; AVX10-NEXT:    vpdpwsuds %xmm2, %xmm1, %xmm0 # encoding: [0x62,0xf2,0x76,0x08,0xd3,0xc2]
; AVX10-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx2.vpdpwsuds.128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C)
  ret <4 x i32> %ret
}
declare <4 x i32> @llvm.x86.avx2.vpdpwsuds.128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C)

define <8 x i32> @test_int_x86_avx2_vpdpwsuds_256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C) {
; CHECK-LABEL: test_int_x86_avx2_vpdpwsuds_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwsuds %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0x76,0xd3,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
;
; AVX10-LABEL: test_int_x86_avx2_vpdpwsuds_256:
; AVX10:       # %bb.0:
; AVX10-NEXT:    vpdpwsuds %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf2,0x76,0x28,0xd3,0xc2]
; AVX10-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx2.vpdpwsuds.256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C)
  ret <8 x i32> %ret
}
declare <8 x i32> @llvm.x86.avx2.vpdpwsuds.256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C)

define <4 x i32> @test_int_x86_avx2_vpdpwusd_128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: test_int_x86_avx2_vpdpwusd_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwusd %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0xd2,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
;
; AVX10-LABEL: test_int_x86_avx2_vpdpwusd_128:
; AVX10:       # %bb.0:
; AVX10-NEXT:    vpdpwusd %xmm2, %xmm1, %xmm0 # encoding: [0x62,0xf2,0x75,0x08,0xd2,0xc2]
; AVX10-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx2.vpdpwusd.128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C)
  ret <4 x i32> %ret
}
declare <4 x i32> @llvm.x86.avx2.vpdpwusd.128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C)

define <8 x i32> @test_int_x86_avx2_vpdpwusd_256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C) {
; CHECK-LABEL: test_int_x86_avx2_vpdpwusd_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwusd %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0x75,0xd2,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
;
; AVX10-LABEL: test_int_x86_avx2_vpdpwusd_256:
; AVX10:       # %bb.0:
; AVX10-NEXT:    vpdpwusd %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf2,0x75,0x28,0xd2,0xc2]
; AVX10-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx2.vpdpwusd.256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C)
  ret <8 x i32> %ret
}
declare <8 x i32> @llvm.x86.avx2.vpdpwusd.256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C)

define <4 x i32> @test_int_x86_avx2_vpdpwusds_128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: test_int_x86_avx2_vpdpwusds_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwusds %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0xd3,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
;
; AVX10-LABEL: test_int_x86_avx2_vpdpwusds_128:
; AVX10:       # %bb.0:
; AVX10-NEXT:    vpdpwusds %xmm2, %xmm1, %xmm0 # encoding: [0x62,0xf2,0x75,0x08,0xd3,0xc2]
; AVX10-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx2.vpdpwusds.128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C)
  ret <4 x i32> %ret
}
declare <4 x i32> @llvm.x86.avx2.vpdpwusds.128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C)

define <8 x i32> @test_int_x86_avx2_vpdpwusds_256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C) {
; CHECK-LABEL: test_int_x86_avx2_vpdpwusds_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwusds %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0x75,0xd3,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
;
; AVX10-LABEL: test_int_x86_avx2_vpdpwusds_256:
; AVX10:       # %bb.0:
; AVX10-NEXT:    vpdpwusds %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf2,0x75,0x28,0xd3,0xc2]
; AVX10-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx2.vpdpwusds.256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C)
  ret <8 x i32> %ret
}
declare <8 x i32> @llvm.x86.avx2.vpdpwusds.256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C)

define <4 x i32> @test_int_x86_avx2_vpdpwuud_128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: test_int_x86_avx2_vpdpwuud_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwuud %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x70,0xd2,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
;
; AVX10-LABEL: test_int_x86_avx2_vpdpwuud_128:
; AVX10:       # %bb.0:
; AVX10-NEXT:    vpdpwuud %xmm2, %xmm1, %xmm0 # encoding: [0x62,0xf2,0x74,0x08,0xd2,0xc2]
; AVX10-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx2.vpdpwuud.128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C)
  ret <4 x i32> %ret
}
declare <4 x i32> @llvm.x86.avx2.vpdpwuud.128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C)

define <8 x i32> @test_int_x86_avx2_vpdpwuud_256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C) {
; CHECK-LABEL: test_int_x86_avx2_vpdpwuud_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwuud %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0x74,0xd2,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
;
; AVX10-LABEL: test_int_x86_avx2_vpdpwuud_256:
; AVX10:       # %bb.0:
; AVX10-NEXT:    vpdpwuud %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf2,0x74,0x28,0xd2,0xc2]
; AVX10-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx2.vpdpwuud.256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C)
  ret <8 x i32> %ret
}
declare <8 x i32> @llvm.x86.avx2.vpdpwuud.256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C)

define <4 x i32> @test_int_x86_avx2_vpdpwuuds_128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: test_int_x86_avx2_vpdpwuuds_128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwuuds %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x70,0xd3,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
;
; AVX10-LABEL: test_int_x86_avx2_vpdpwuuds_128:
; AVX10:       # %bb.0:
; AVX10-NEXT:    vpdpwuuds %xmm2, %xmm1, %xmm0 # encoding: [0x62,0xf2,0x74,0x08,0xd3,0xc2]
; AVX10-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx2.vpdpwuuds.128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C)
  ret <4 x i32> %ret
}
declare <4 x i32> @llvm.x86.avx2.vpdpwuuds.128(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C)

define <8 x i32> @test_int_x86_avx2_vpdpwuuds_256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C) {
; CHECK-LABEL: test_int_x86_avx2_vpdpwuuds_256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwuuds %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0x74,0xd3,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
;
; AVX10-LABEL: test_int_x86_avx2_vpdpwuuds_256:
; AVX10:       # %bb.0:
; AVX10-NEXT:    vpdpwuuds %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf2,0x74,0x28,0xd3,0xc2]
; AVX10-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx2.vpdpwuuds.256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C)
  ret <8 x i32> %ret
}
declare <8 x i32> @llvm.x86.avx2.vpdpwuuds.256(<8 x i32> %A, <8 x i32> %B, <8 x i32> %C)
