; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=arm64-none-linux-gnu -mattr=+neon -global-isel=0 | FileCheck %s --check-prefixes=CHECK,CHECK-GI
; RUN: llc < %s -verify-machineinstrs -mtriple=arm64-none-linux-gnu -mattr=+neon -global-isel=1 | FileCheck %s --check-prefixes=CHECK,CHECK-SD


%struct.uint8x16x2_t = type { [2 x <16 x i8>] }
%struct.poly8x16x2_t = type { [2 x <16 x i8>] }
%struct.uint8x16x3_t = type { [3 x <16 x i8>] }
%struct.int8x16x2_t = type { [2 x <16 x i8>] }
%struct.int16x8x2_t = type { [2 x <8 x i16>] }
%struct.int32x4x2_t = type { [2 x <4 x i32>] }
%struct.int64x2x2_t = type { [2 x <2 x i64>] }
%struct.float32x4x2_t = type { [2 x <4 x float>] }
%struct.float64x2x2_t = type { [2 x <2 x double>] }
%struct.int8x8x2_t = type { [2 x <8 x i8>] }
%struct.int16x4x2_t = type { [2 x <4 x i16>] }
%struct.int32x2x2_t = type { [2 x <2 x i32>] }
%struct.int64x1x2_t = type { [2 x <1 x i64>] }
%struct.float32x2x2_t = type { [2 x <2 x float>] }
%struct.float64x1x2_t = type { [2 x <1 x double>] }
%struct.int8x16x3_t = type { [3 x <16 x i8>] }
%struct.int16x8x3_t = type { [3 x <8 x i16>] }
%struct.int32x4x3_t = type { [3 x <4 x i32>] }
%struct.int64x2x3_t = type { [3 x <2 x i64>] }
%struct.float32x4x3_t = type { [3 x <4 x float>] }
%struct.float64x2x3_t = type { [3 x <2 x double>] }
%struct.int8x8x3_t = type { [3 x <8 x i8>] }
%struct.int16x4x3_t = type { [3 x <4 x i16>] }
%struct.int32x2x3_t = type { [3 x <2 x i32>] }
%struct.int64x1x3_t = type { [3 x <1 x i64>] }
%struct.float32x2x3_t = type { [3 x <2 x float>] }
%struct.float64x1x3_t = type { [3 x <1 x double>] }
%struct.int8x16x4_t = type { [4 x <16 x i8>] }
%struct.int16x8x4_t = type { [4 x <8 x i16>] }
%struct.int32x4x4_t = type { [4 x <4 x i32>] }
%struct.int64x2x4_t = type { [4 x <2 x i64>] }
%struct.float32x4x4_t = type { [4 x <4 x float>] }
%struct.float64x2x4_t = type { [4 x <2 x double>] }
%struct.int8x8x4_t = type { [4 x <8 x i8>] }
%struct.int16x4x4_t = type { [4 x <4 x i16>] }
%struct.int32x2x4_t = type { [4 x <2 x i32>] }
%struct.int64x1x4_t = type { [4 x <1 x i64>] }
%struct.float32x2x4_t = type { [4 x <2 x float>] }
%struct.float64x1x4_t = type { [4 x <1 x double>] }

define <16 x i8> @test_ld_from_poll_v16i8(<16 x i8> %a) {
; CHECK-LABEL: test_ld_from_poll_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI0_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI0_0]
; CHECK-NEXT:    add v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %b = add <16 x i8> %a, <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 9, i8 10, i8 11, i8 2, i8 13, i8 14, i8 15, i8 16>
  ret <16 x i8> %b
}

define <8 x i16> @test_ld_from_poll_v8i16(<8 x i16> %a) {
; CHECK-LABEL: test_ld_from_poll_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI1_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI1_0]
; CHECK-NEXT:    add v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
entry:
  %b = add <8 x i16> %a, <i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8>
  ret <8 x i16> %b
}

define <4 x i32> @test_ld_from_poll_v4i32(<4 x i32> %a) {
; CHECK-LABEL: test_ld_from_poll_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI2_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI2_0]
; CHECK-NEXT:    add v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %b = add <4 x i32> %a, <i32 1, i32 2, i32 3, i32 4>
  ret <4 x i32> %b
}

define <2 x i64> @test_ld_from_poll_v2i64(<2 x i64> %a) {
; CHECK-LABEL: test_ld_from_poll_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI3_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI3_0]
; CHECK-NEXT:    add v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %b = add <2 x i64> %a, <i64 1, i64 2>
  ret <2 x i64> %b
}

define <4 x float> @test_ld_from_poll_v4f32(<4 x float> %a) {
; CHECK-LABEL: test_ld_from_poll_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI4_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI4_0]
; CHECK-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %b = fadd <4 x float> %a, <float 1.0, float 2.0, float 3.0, float 4.0>
  ret <4 x float> %b
}

define <2 x double> @test_ld_from_poll_v2f64(<2 x double> %a) {
; CHECK-LABEL: test_ld_from_poll_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI5_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI5_0]
; CHECK-NEXT:    fadd v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %b = fadd <2 x double> %a, <double 1.0, double 2.0>
  ret <2 x double> %b
}

define <8 x i8> @test_ld_from_poll_v8i8(<8 x i8> %a) {
; CHECK-LABEL: test_ld_from_poll_v8i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI6_0
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI6_0]
; CHECK-NEXT:    add v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %b = add <8 x i8> %a, <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8>
  ret <8 x i8> %b
}

define <4 x i16> @test_ld_from_poll_v4i16(<4 x i16> %a) {
; CHECK-LABEL: test_ld_from_poll_v4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI7_0
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI7_0]
; CHECK-NEXT:    add v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
entry:
  %b = add <4 x i16> %a, <i16 1, i16 2, i16 3, i16 4>
  ret <4 x i16> %b
}

define <2 x i32> @test_ld_from_poll_v2i32(<2 x i32> %a) {
; CHECK-LABEL: test_ld_from_poll_v2i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI8_0
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI8_0]
; CHECK-NEXT:    add v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
entry:
  %b = add <2 x i32> %a, <i32 1, i32 2>
  ret <2 x i32> %b
}

define <16 x i8> @test_vld1q_dup_s8(ptr %a) {
; CHECK-LABEL: test_vld1q_dup_s8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1r { v0.16b }, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load i8, ptr %a, align 1
  %1 = insertelement <16 x i8> undef, i8 %0, i32 0
  %lane = shufflevector <16 x i8> %1, <16 x i8> undef, <16 x i32> zeroinitializer
  ret <16 x i8> %lane
}

define <8 x i16> @test_vld1q_dup_s16(ptr %a) {
; CHECK-LABEL: test_vld1q_dup_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1r { v0.8h }, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load i16, ptr %a, align 2
  %1 = insertelement <8 x i16> undef, i16 %0, i32 0
  %lane = shufflevector <8 x i16> %1, <8 x i16> undef, <8 x i32> zeroinitializer
  ret <8 x i16> %lane
}

define <4 x i32> @test_vld1q_dup_s32(ptr %a) {
; CHECK-LABEL: test_vld1q_dup_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1r { v0.4s }, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load i32, ptr %a, align 4
  %1 = insertelement <4 x i32> undef, i32 %0, i32 0
  %lane = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %lane
}

define <2 x i64> @test_vld1q_dup_s64(ptr %a) {
; CHECK-LABEL: test_vld1q_dup_s64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1r { v0.2d }, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load i64, ptr %a, align 8
  %1 = insertelement <2 x i64> undef, i64 %0, i32 0
  %lane = shufflevector <2 x i64> %1, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %lane
}

define <4 x float> @test_vld1q_dup_f32(ptr %a) {
; CHECK-LABEL: test_vld1q_dup_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1r { v0.4s }, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load float, ptr %a, align 4
  %1 = insertelement <4 x float> undef, float %0, i32 0
  %lane = shufflevector <4 x float> %1, <4 x float> undef, <4 x i32> zeroinitializer
  ret <4 x float> %lane
}

define <2 x double> @test_vld1q_dup_f64(ptr %a) {
; CHECK-LABEL: test_vld1q_dup_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1r { v0.2d }, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load double, ptr %a, align 8
  %1 = insertelement <2 x double> undef, double %0, i32 0
  %lane = shufflevector <2 x double> %1, <2 x double> undef, <2 x i32> zeroinitializer
  ret <2 x double> %lane
}

define <8 x i8> @test_vld1_dup_s8(ptr %a) {
; CHECK-LABEL: test_vld1_dup_s8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1r { v0.8b }, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load i8, ptr %a, align 1
  %1 = insertelement <8 x i8> undef, i8 %0, i32 0
  %lane = shufflevector <8 x i8> %1, <8 x i8> undef, <8 x i32> zeroinitializer
  ret <8 x i8> %lane
}

define <4 x i16> @test_vld1_dup_s16(ptr %a) {
; CHECK-LABEL: test_vld1_dup_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1r { v0.4h }, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load i16, ptr %a, align 2
  %1 = insertelement <4 x i16> undef, i16 %0, i32 0
  %lane = shufflevector <4 x i16> %1, <4 x i16> undef, <4 x i32> zeroinitializer
  ret <4 x i16> %lane
}

define <2 x i32> @test_vld1_dup_s32(ptr %a) {
; CHECK-LABEL: test_vld1_dup_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1r { v0.2s }, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load i32, ptr %a, align 4
  %1 = insertelement <2 x i32> undef, i32 %0, i32 0
  %lane = shufflevector <2 x i32> %1, <2 x i32> undef, <2 x i32> zeroinitializer
  ret <2 x i32> %lane
}

define <1 x i64> @test_vld1_dup_s64(ptr %a) {
; CHECK-LABEL: test_vld1_dup_s64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load i64, ptr %a, align 8
  %1 = insertelement <1 x i64> undef, i64 %0, i32 0
  ret <1 x i64> %1
}

define <2 x float> @test_vld1_dup_f32(ptr %a) {
; CHECK-LABEL: test_vld1_dup_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1r { v0.2s }, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load float, ptr %a, align 4
  %1 = insertelement <2 x float> undef, float %0, i32 0
  %lane = shufflevector <2 x float> %1, <2 x float> undef, <2 x i32> zeroinitializer
  ret <2 x float> %lane
}

define <1 x double> @test_vld1_dup_f64(ptr %a) {
; CHECK-LABEL: test_vld1_dup_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load double, ptr %a, align 8
  %1 = insertelement <1 x double> undef, double %0, i32 0
  ret <1 x double> %1
}

define <1 x i64> @testDUP.v1i64(ptr %a, ptr %b) #0 {
; As there is a store operation depending on %1, LD1R pattern can't be selected.
; So LDR and FMOV should be emitted.
; CHECK-GI-LABEL: testDUP.v1i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    ldr x8, [x0]
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    str x8, [x1]
; CHECK-GI-NEXT:    ret
;
; CHECK-SD-LABEL: testDUP.v1i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ldr d0, [x0]
; CHECK-SD-NEXT:    str d0, [x1]
; CHECK-SD-NEXT:    ret
  %1 = load i64, ptr %a, align 8
  store i64 %1, ptr %b, align 8
  %vecinit.i = insertelement <1 x i64> undef, i64 %1, i32 0
  ret <1 x i64> %vecinit.i
}

define <1 x double> @testDUP.v1f64(ptr %a, ptr %b) #0 {
; As there is a store operation depending on %1, LD1R pattern can't be selected.
; So LDR and FMOV should be emitted.
; CHECK-LABEL: testDUP.v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    str d0, [x1]
; CHECK-NEXT:    ret
  %1 = load double, ptr %a, align 8
  store double %1, ptr %b, align 8
  %vecinit.i = insertelement <1 x double> undef, double %1, i32 0
  ret <1 x double> %vecinit.i
}

define <16 x i8> @test_vld1q_lane_s8(ptr %a, <16 x i8> %b) {
; CHECK-GI-LABEL: test_vld1q_lane_s8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ld1 { v0.b }[15], [x0]
; CHECK-GI-NEXT:    ret
;
; CHECK-SD-LABEL: test_vld1q_lane_s8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldr b1, [x0]
; CHECK-SD-NEXT:    mov v0.b[15], v1.b[0]
; CHECK-SD-NEXT:    ret
entry:
  %0 = load i8, ptr %a, align 1
  %vld1_lane = insertelement <16 x i8> %b, i8 %0, i32 15
  ret <16 x i8> %vld1_lane
}

define <8 x i16> @test_vld1q_lane_s16(ptr %a, <8 x i16> %b) {
; CHECK-LABEL: test_vld1q_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1 { v0.h }[7], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load i16, ptr %a, align 2
  %vld1_lane = insertelement <8 x i16> %b, i16 %0, i32 7
  ret <8 x i16> %vld1_lane
}

define <4 x i32> @test_vld1q_lane_s32(ptr %a, <4 x i32> %b) {
; CHECK-LABEL: test_vld1q_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1 { v0.s }[3], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load i32, ptr %a, align 4
  %vld1_lane = insertelement <4 x i32> %b, i32 %0, i32 3
  ret <4 x i32> %vld1_lane
}

define <2 x i64> @test_vld1q_lane_s64(ptr %a, <2 x i64> %b) {
; CHECK-LABEL: test_vld1q_lane_s64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1 { v0.d }[1], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load i64, ptr %a, align 8
  %vld1_lane = insertelement <2 x i64> %b, i64 %0, i32 1
  ret <2 x i64> %vld1_lane
}

define <4 x float> @test_vld1q_lane_f32(ptr %a, <4 x float> %b) {
; CHECK-LABEL: test_vld1q_lane_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1 { v0.s }[3], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load float, ptr %a, align 4
  %vld1_lane = insertelement <4 x float> %b, float %0, i32 3
  ret <4 x float> %vld1_lane
}

define <2 x double> @test_vld1q_lane_f64(ptr %a, <2 x double> %b) {
; CHECK-LABEL: test_vld1q_lane_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ld1 { v0.d }[1], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load double, ptr %a, align 8
  %vld1_lane = insertelement <2 x double> %b, double %0, i32 1
  ret <2 x double> %vld1_lane
}

define <8 x i8> @test_vld1_lane_s8(ptr %a, <8 x i8> %b) {
; CHECK-GI-LABEL: test_vld1_lane_s8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    ld1 { v0.b }[7], [x0]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
;
; CHECK-SD-LABEL: test_vld1_lane_s8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldr b1, [x0]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov v0.b[7], v1.b[0]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
entry:
  %0 = load i8, ptr %a, align 1
  %vld1_lane = insertelement <8 x i8> %b, i8 %0, i32 7
  ret <8 x i8> %vld1_lane
}

define <4 x i16> @test_vld1_lane_s16(ptr %a, <4 x i16> %b) {
; CHECK-LABEL: test_vld1_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    ld1 { v0.h }[3], [x0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %0 = load i16, ptr %a, align 2
  %vld1_lane = insertelement <4 x i16> %b, i16 %0, i32 3
  ret <4 x i16> %vld1_lane
}

define <2 x i32> @test_vld1_lane_s32(ptr %a, <2 x i32> %b) {
; CHECK-LABEL: test_vld1_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    ld1 { v0.s }[1], [x0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %0 = load i32, ptr %a, align 4
  %vld1_lane = insertelement <2 x i32> %b, i32 %0, i32 1
  ret <2 x i32> %vld1_lane
}

define <1 x i64> @test_vld1_lane_s64(ptr %a, <1 x i64> %b) {
; CHECK-LABEL: test_vld1_lane_s64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load i64, ptr %a, align 8
  %vld1_lane = insertelement <1 x i64> undef, i64 %0, i32 0
  ret <1 x i64> %vld1_lane
}

define <2 x float> @test_vld1_lane_f32(ptr %a, <2 x float> %b) {
; CHECK-LABEL: test_vld1_lane_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    ld1 { v0.s }[1], [x0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %0 = load float, ptr %a, align 4
  %vld1_lane = insertelement <2 x float> %b, float %0, i32 1
  ret <2 x float> %vld1_lane
}

define <1 x double> @test_vld1_lane_f64(ptr %a, <1 x double> %b) {
; CHECK-LABEL: test_vld1_lane_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load double, ptr %a, align 8
  %vld1_lane = insertelement <1 x double> undef, double %0, i32 0
  ret <1 x double> %vld1_lane
}

define void @test_vst1q_lane_s8(ptr %a, <16 x i8> %b) {
; CHECK-LABEL: test_vst1q_lane_s8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1 { v0.b }[15], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <16 x i8> %b, i32 15
  store i8 %0, ptr %a, align 1
  ret void
}

define void @test_vst1q_lane_s16(ptr %a, <8 x i16> %b) {
; CHECK-LABEL: test_vst1q_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1 { v0.h }[7], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <8 x i16> %b, i32 7
  store i16 %0, ptr %a, align 2
  ret void
}

define void @test_vst1q_lane0_s16(ptr %a, <8 x i16> %b) {
; CHECK-LABEL: test_vst1q_lane0_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str h0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <8 x i16> %b, i32 0
  store i16 %0, ptr %a, align 2
  ret void
}

define void @test_vst1q_lane_s32(ptr %a, <4 x i32> %b) {
; CHECK-LABEL: test_vst1q_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1 { v0.s }[3], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <4 x i32> %b, i32 3
  store i32 %0, ptr %a, align 4
  ret void
}

define void @test_vst1q_lane0_s32(ptr %a, <4 x i32> %b) {
; CHECK-LABEL: test_vst1q_lane0_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str s0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <4 x i32> %b, i32 0
  store i32 %0, ptr %a, align 4
  ret void
}

define void @test_vst1q_lane_s64(ptr %a, <2 x i64> %b) {
; CHECK-LABEL: test_vst1q_lane_s64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1 { v0.d }[1], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <2 x i64> %b, i32 1
  store i64 %0, ptr %a, align 8
  ret void
}

define void @test_vst1q_lane0_s64(ptr %a, <2 x i64> %b) {
; CHECK-LABEL: test_vst1q_lane0_s64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <2 x i64> %b, i32 0
  store i64 %0, ptr %a, align 8
  ret void
}

define void @test_vst1q_lane_f32(ptr %a, <4 x float> %b) {
; CHECK-LABEL: test_vst1q_lane_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1 { v0.s }[3], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <4 x float> %b, i32 3
  store float %0, ptr %a, align 4
  ret void
}

define void @test_vst1q_lane0_f32(ptr %a, <4 x float> %b) {
; CHECK-LABEL: test_vst1q_lane0_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str s0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <4 x float> %b, i32 0
  store float %0, ptr %a, align 4
  ret void
}

define void @test_vst1q_lane_f64(ptr %a, <2 x double> %b) {
; CHECK-LABEL: test_vst1q_lane_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1 { v0.d }[1], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <2 x double> %b, i32 1
  store double %0, ptr %a, align 8
  ret void
}

define void @test_vst1q_lane0_f64(ptr %a, <2 x double> %b) {
; CHECK-LABEL: test_vst1q_lane0_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <2 x double> %b, i32 0
  store double %0, ptr %a, align 8
  ret void
}

define void @test_vst1_lane_s8(ptr %a, <8 x i8> %b) {
; CHECK-LABEL: test_vst1_lane_s8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    st1 { v0.b }[7], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <8 x i8> %b, i32 7
  store i8 %0, ptr %a, align 1
  ret void
}

define void @test_vst1_lane_s16(ptr %a, <4 x i16> %b) {
; CHECK-LABEL: test_vst1_lane_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    st1 { v0.h }[3], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <4 x i16> %b, i32 3
  store i16 %0, ptr %a, align 2
  ret void
}

define void @test_vst1_lane0_s16(ptr %a, <4 x i16> %b) {
; CHECK-GI-LABEL: test_vst1_lane0_s16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    ret
;
; CHECK-SD-LABEL: test_vst1_lane0_s16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    str h0, [x0]
; CHECK-SD-NEXT:    ret
entry:
  %0 = extractelement <4 x i16> %b, i32 0
  store i16 %0, ptr %a, align 2
  ret void
}

define void @test_vst1_lane_s32(ptr %a, <2 x i32> %b) {
; CHECK-LABEL: test_vst1_lane_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    st1 { v0.s }[1], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <2 x i32> %b, i32 1
  store i32 %0, ptr %a, align 4
  ret void
}

define void @test_vst1_lane0_s32(ptr %a, <2 x i32> %b) {
; CHECK-GI-LABEL: test_vst1_lane0_s32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str s0, [x0]
; CHECK-GI-NEXT:    ret
;
; CHECK-SD-LABEL: test_vst1_lane0_s32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    str s0, [x0]
; CHECK-SD-NEXT:    ret
entry:
  %0 = extractelement <2 x i32> %b, i32 0
  store i32 %0, ptr %a, align 4
  ret void
}

define void @test_vst1_lane_s64(ptr %a, <1 x i64> %b) {
; CHECK-GI-LABEL: test_vst1_lane_s64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str d0, [x0]
; CHECK-GI-NEXT:    ret
;
; CHECK-SD-LABEL: test_vst1_lane_s64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    str d0, [x0]
; CHECK-SD-NEXT:    ret
entry:
  %0 = extractelement <1 x i64> %b, i32 0
  store i64 %0, ptr %a, align 8
  ret void
}

define void @test_vst1_lane_f32(ptr %a, <2 x float> %b) {
; CHECK-LABEL: test_vst1_lane_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    st1 { v0.s }[1], [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <2 x float> %b, i32 1
  store float %0, ptr %a, align 4
  ret void
}

define void @test_vst1_lane0_f32(ptr %a, <2 x float> %b) {
; CHECK-GI-LABEL: test_vst1_lane0_f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str s0, [x0]
; CHECK-GI-NEXT:    ret
;
; CHECK-SD-LABEL: test_vst1_lane0_f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    str s0, [x0]
; CHECK-SD-NEXT:    ret
entry:
  %0 = extractelement <2 x float> %b, i32 0
  store float %0, ptr %a, align 4
  ret void
}

define void @test_vst1_lane_f64(ptr %a, <1 x double> %b) {
; CHECK-LABEL: test_vst1_lane_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = extractelement <1 x double> %b, i32 0
  store double %0, ptr %a, align 8
  ret void
}
