; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64 %s -o - | FileCheck %s --check-prefixes=CHECK,SDAG
; RUN: llc -mtriple=aarch64 -global-isel -global-isel-abort=1 %s -o - | FileCheck %s --check-prefixes=CHECK,GISEL

; These tests just check that the plumbing is in place for @llvm.bitreverse.

declare <2 x i16> @llvm.bitreverse.v2i16(<2 x i16>) readnone

define <2 x i16> @f(<2 x i16> %a) {
; SDAG-LABEL: f:
; SDAG:       // %bb.0:
; SDAG-NEXT:    rev32 v0.8b, v0.8b
; SDAG-NEXT:    rbit v0.8b, v0.8b
; SDAG-NEXT:    ushr v0.2s, v0.2s, #16
; SDAG-NEXT:    ret
;
; GISEL-LABEL: f:
; GISEL:       // %bb.0:
; GISEL-NEXT:    uzp1 v0.4h, v0.4h, v0.4h
; GISEL-NEXT:    mov w8, #61680 // =0xf0f0
; GISEL-NEXT:    dup v1.2s, w8
; GISEL-NEXT:    mov w8, #4 // =0x4
; GISEL-NEXT:    fmov s3, w8
; GISEL-NEXT:    rev16 v0.8b, v0.8b
; GISEL-NEXT:    mov v3.h[1], w8
; GISEL-NEXT:    mov w8, #52428 // =0xcccc
; GISEL-NEXT:    ushll v2.4s, v0.4h, #0
; GISEL-NEXT:    neg v4.4h, v3.4h
; GISEL-NEXT:    and v2.8b, v2.8b, v1.8b
; GISEL-NEXT:    uzp1 v2.4h, v2.4h, v0.4h
; GISEL-NEXT:    ushl v0.4h, v0.4h, v3.4h
; GISEL-NEXT:    ushll v0.4s, v0.4h, #0
; GISEL-NEXT:    ushl v2.4h, v2.4h, v4.4h
; GISEL-NEXT:    and v0.8b, v0.8b, v1.8b
; GISEL-NEXT:    ushll v1.4s, v2.4h, #0
; GISEL-NEXT:    dup v2.2s, w8
; GISEL-NEXT:    mov w8, #2 // =0x2
; GISEL-NEXT:    orr v0.8b, v1.8b, v0.8b
; GISEL-NEXT:    fmov s1, w8
; GISEL-NEXT:    and v3.8b, v0.8b, v2.8b
; GISEL-NEXT:    uzp1 v0.4h, v0.4h, v0.4h
; GISEL-NEXT:    mov v1.h[1], w8
; GISEL-NEXT:    mov w8, #43690 // =0xaaaa
; GISEL-NEXT:    uzp1 v3.4h, v3.4h, v0.4h
; GISEL-NEXT:    neg v4.4h, v1.4h
; GISEL-NEXT:    ushl v0.4h, v0.4h, v1.4h
; GISEL-NEXT:    ushll v0.4s, v0.4h, #0
; GISEL-NEXT:    ushl v1.4h, v3.4h, v4.4h
; GISEL-NEXT:    and v0.8b, v0.8b, v2.8b
; GISEL-NEXT:    dup v2.2s, w8
; GISEL-NEXT:    mov w8, #1 // =0x1
; GISEL-NEXT:    ushll v1.4s, v1.4h, #0
; GISEL-NEXT:    orr v0.8b, v1.8b, v0.8b
; GISEL-NEXT:    fmov s1, w8
; GISEL-NEXT:    and v3.8b, v0.8b, v2.8b
; GISEL-NEXT:    uzp1 v0.4h, v0.4h, v0.4h
; GISEL-NEXT:    mov v1.h[1], w8
; GISEL-NEXT:    uzp1 v3.4h, v3.4h, v0.4h
; GISEL-NEXT:    neg v4.4h, v1.4h
; GISEL-NEXT:    ushl v0.4h, v0.4h, v1.4h
; GISEL-NEXT:    ushll v0.4s, v0.4h, #0
; GISEL-NEXT:    ushl v1.4h, v3.4h, v4.4h
; GISEL-NEXT:    and v0.8b, v0.8b, v2.8b
; GISEL-NEXT:    ushll v1.4s, v1.4h, #0
; GISEL-NEXT:    orr v0.8b, v1.8b, v0.8b
; GISEL-NEXT:    ret
  %b = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> %a)
  ret <2 x i16> %b
}

declare i8 @llvm.bitreverse.i8(i8) readnone

define i8 @g(i8 %a) {
; CHECK-LABEL: g:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rbit w8, w0
; CHECK-NEXT:    lsr w0, w8, #24
; CHECK-NEXT:    ret
  %b = call i8 @llvm.bitreverse.i8(i8 %a)
  ret i8 %b
}

declare i16 @llvm.bitreverse.i16(i16) readnone

define i16 @g_16(i16 %a) {
; CHECK-LABEL: g_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rbit w8, w0
; CHECK-NEXT:    lsr w0, w8, #16
; CHECK-NEXT:    ret
  %b = call i16 @llvm.bitreverse.i16(i16 %a)
  ret i16 %b
}

declare i32 @llvm.bitreverse.i32(i32) readnone

define i32 @g_32(i32 %a) {
; CHECK-LABEL: g_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rbit w0, w0
; CHECK-NEXT:    ret
  %b = call i32 @llvm.bitreverse.i32(i32 %a)
  ret i32 %b
}

declare i64 @llvm.bitreverse.i64(i64) readnone

define i64 @g_64(i64 %a) {
; CHECK-LABEL: g_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rbit x0, x0
; CHECK-NEXT:    ret
  %b = call i64 @llvm.bitreverse.i64(i64 %a)
  ret i64 %b
}

declare <8 x i8> @llvm.bitreverse.v8i8(<8 x i8>) readnone

define <8 x i8> @g_vec(<8 x i8> %a) {
; CHECK-LABEL: g_vec:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rbit v0.8b, v0.8b
; CHECK-NEXT:    ret
  %b = call <8 x i8> @llvm.bitreverse.v8i8(<8 x i8> %a)
  ret <8 x i8> %b
}

declare <16 x i8> @llvm.bitreverse.v16i8(<16 x i8>) readnone

define <16 x i8> @g_vec_16x8(<16 x i8> %a) {
; CHECK-LABEL: g_vec_16x8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rbit v0.16b, v0.16b
; CHECK-NEXT:    ret
  %b = call <16 x i8> @llvm.bitreverse.v16i8(<16 x i8> %a)
  ret <16 x i8> %b
}

declare <4 x i16> @llvm.bitreverse.v4i16(<4 x i16>) readnone

define <4 x i16> @g_vec_4x16(<4 x i16> %a) {
; SDAG-LABEL: g_vec_4x16:
; SDAG:       // %bb.0:
; SDAG-NEXT:    rev16 v0.8b, v0.8b
; SDAG-NEXT:    rbit v0.8b, v0.8b
; SDAG-NEXT:    ret
;
; GISEL-LABEL: g_vec_4x16:
; GISEL:       // %bb.0:
; GISEL-NEXT:    movi v1.8b, #240
; GISEL-NEXT:    rev16 v0.8b, v0.8b
; GISEL-NEXT:    and v2.8b, v0.8b, v1.8b
; GISEL-NEXT:    shl v0.4h, v0.4h, #4
; GISEL-NEXT:    ushr v2.4h, v2.4h, #4
; GISEL-NEXT:    and v0.8b, v0.8b, v1.8b
; GISEL-NEXT:    movi v1.8b, #204
; GISEL-NEXT:    orr v0.8b, v2.8b, v0.8b
; GISEL-NEXT:    and v2.8b, v0.8b, v1.8b
; GISEL-NEXT:    shl v0.4h, v0.4h, #2
; GISEL-NEXT:    ushr v2.4h, v2.4h, #2
; GISEL-NEXT:    and v0.8b, v0.8b, v1.8b
; GISEL-NEXT:    movi v1.8b, #170
; GISEL-NEXT:    orr v0.8b, v2.8b, v0.8b
; GISEL-NEXT:    and v2.8b, v0.8b, v1.8b
; GISEL-NEXT:    shl v0.4h, v0.4h, #1
; GISEL-NEXT:    ushr v2.4h, v2.4h, #1
; GISEL-NEXT:    and v0.8b, v0.8b, v1.8b
; GISEL-NEXT:    orr v0.8b, v2.8b, v0.8b
; GISEL-NEXT:    ret
  %b = call <4 x i16> @llvm.bitreverse.v4i16(<4 x i16> %a)
  ret <4 x i16> %b
}

declare <8 x i16> @llvm.bitreverse.v8i16(<8 x i16>) readnone

define <8 x i16> @g_vec_8x16(<8 x i16> %a) {
; SDAG-LABEL: g_vec_8x16:
; SDAG:       // %bb.0:
; SDAG-NEXT:    rev16 v0.16b, v0.16b
; SDAG-NEXT:    rbit v0.16b, v0.16b
; SDAG-NEXT:    ret
;
; GISEL-LABEL: g_vec_8x16:
; GISEL:       // %bb.0:
; GISEL-NEXT:    movi v1.16b, #240
; GISEL-NEXT:    rev16 v0.16b, v0.16b
; GISEL-NEXT:    and v2.16b, v0.16b, v1.16b
; GISEL-NEXT:    shl v0.8h, v0.8h, #4
; GISEL-NEXT:    ushr v2.8h, v2.8h, #4
; GISEL-NEXT:    and v0.16b, v0.16b, v1.16b
; GISEL-NEXT:    movi v1.16b, #204
; GISEL-NEXT:    orr v0.16b, v2.16b, v0.16b
; GISEL-NEXT:    and v2.16b, v0.16b, v1.16b
; GISEL-NEXT:    shl v0.8h, v0.8h, #2
; GISEL-NEXT:    ushr v2.8h, v2.8h, #2
; GISEL-NEXT:    and v0.16b, v0.16b, v1.16b
; GISEL-NEXT:    movi v1.16b, #170
; GISEL-NEXT:    orr v0.16b, v2.16b, v0.16b
; GISEL-NEXT:    and v2.16b, v0.16b, v1.16b
; GISEL-NEXT:    shl v0.8h, v0.8h, #1
; GISEL-NEXT:    ushr v2.8h, v2.8h, #1
; GISEL-NEXT:    and v0.16b, v0.16b, v1.16b
; GISEL-NEXT:    orr v0.16b, v2.16b, v0.16b
; GISEL-NEXT:    ret
  %b = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> %a)
  ret <8 x i16> %b
}

declare <2 x i32> @llvm.bitreverse.v2i32(<2 x i32>) readnone

define <2 x i32> @g_vec_2x32(<2 x i32> %a) {
; SDAG-LABEL: g_vec_2x32:
; SDAG:       // %bb.0:
; SDAG-NEXT:    rev32 v0.8b, v0.8b
; SDAG-NEXT:    rbit v0.8b, v0.8b
; SDAG-NEXT:    ret
;
; GISEL-LABEL: g_vec_2x32:
; GISEL:       // %bb.0:
; GISEL-NEXT:    movi v1.8b, #240
; GISEL-NEXT:    rev32 v0.8b, v0.8b
; GISEL-NEXT:    and v2.8b, v0.8b, v1.8b
; GISEL-NEXT:    shl v0.2s, v0.2s, #4
; GISEL-NEXT:    ushr v2.2s, v2.2s, #4
; GISEL-NEXT:    and v0.8b, v0.8b, v1.8b
; GISEL-NEXT:    movi v1.8b, #204
; GISEL-NEXT:    orr v0.8b, v2.8b, v0.8b
; GISEL-NEXT:    and v2.8b, v0.8b, v1.8b
; GISEL-NEXT:    shl v0.2s, v0.2s, #2
; GISEL-NEXT:    ushr v2.2s, v2.2s, #2
; GISEL-NEXT:    and v0.8b, v0.8b, v1.8b
; GISEL-NEXT:    movi v1.8b, #170
; GISEL-NEXT:    orr v0.8b, v2.8b, v0.8b
; GISEL-NEXT:    and v2.8b, v0.8b, v1.8b
; GISEL-NEXT:    shl v0.2s, v0.2s, #1
; GISEL-NEXT:    ushr v2.2s, v2.2s, #1
; GISEL-NEXT:    and v0.8b, v0.8b, v1.8b
; GISEL-NEXT:    orr v0.8b, v2.8b, v0.8b
; GISEL-NEXT:    ret
  %b = call <2 x i32> @llvm.bitreverse.v2i32(<2 x i32> %a)
  ret <2 x i32> %b
}

declare <4 x i32> @llvm.bitreverse.v4i32(<4 x i32>) readnone

define <4 x i32> @g_vec_4x32(<4 x i32> %a) {
; SDAG-LABEL: g_vec_4x32:
; SDAG:       // %bb.0:
; SDAG-NEXT:    rev32 v0.16b, v0.16b
; SDAG-NEXT:    rbit v0.16b, v0.16b
; SDAG-NEXT:    ret
;
; GISEL-LABEL: g_vec_4x32:
; GISEL:       // %bb.0:
; GISEL-NEXT:    movi v1.16b, #240
; GISEL-NEXT:    rev32 v0.16b, v0.16b
; GISEL-NEXT:    and v2.16b, v0.16b, v1.16b
; GISEL-NEXT:    shl v0.4s, v0.4s, #4
; GISEL-NEXT:    ushr v2.4s, v2.4s, #4
; GISEL-NEXT:    and v0.16b, v0.16b, v1.16b
; GISEL-NEXT:    movi v1.16b, #204
; GISEL-NEXT:    orr v0.16b, v2.16b, v0.16b
; GISEL-NEXT:    and v2.16b, v0.16b, v1.16b
; GISEL-NEXT:    shl v0.4s, v0.4s, #2
; GISEL-NEXT:    ushr v2.4s, v2.4s, #2
; GISEL-NEXT:    and v0.16b, v0.16b, v1.16b
; GISEL-NEXT:    movi v1.16b, #170
; GISEL-NEXT:    orr v0.16b, v2.16b, v0.16b
; GISEL-NEXT:    and v2.16b, v0.16b, v1.16b
; GISEL-NEXT:    shl v0.4s, v0.4s, #1
; GISEL-NEXT:    ushr v2.4s, v2.4s, #1
; GISEL-NEXT:    and v0.16b, v0.16b, v1.16b
; GISEL-NEXT:    orr v0.16b, v2.16b, v0.16b
; GISEL-NEXT:    ret
  %b = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> %a)
  ret <4 x i32> %b
}

declare <1 x i64> @llvm.bitreverse.v1i64(<1 x i64>) readnone

define <1 x i64> @g_vec_1x64(<1 x i64> %a) {
; SDAG-LABEL: g_vec_1x64:
; SDAG:       // %bb.0:
; SDAG-NEXT:    rev64 v0.8b, v0.8b
; SDAG-NEXT:    rbit v0.8b, v0.8b
; SDAG-NEXT:    ret
;
; GISEL-LABEL: g_vec_1x64:
; GISEL:       // %bb.0:
; GISEL-NEXT:    fmov x8, d0
; GISEL-NEXT:    rbit x8, x8
; GISEL-NEXT:    fmov d0, x8
; GISEL-NEXT:    ret
  %b = call <1 x i64> @llvm.bitreverse.v1i64(<1 x i64> %a)
  ret <1 x i64> %b
}

declare <2 x i64> @llvm.bitreverse.v2i64(<2 x i64>) readnone

define <2 x i64> @g_vec_2x64(<2 x i64> %a) {
; SDAG-LABEL: g_vec_2x64:
; SDAG:       // %bb.0:
; SDAG-NEXT:    rev64 v0.16b, v0.16b
; SDAG-NEXT:    rbit v0.16b, v0.16b
; SDAG-NEXT:    ret
;
; GISEL-LABEL: g_vec_2x64:
; GISEL:       // %bb.0:
; GISEL-NEXT:    movi v1.16b, #240
; GISEL-NEXT:    rev64 v0.16b, v0.16b
; GISEL-NEXT:    and v2.16b, v0.16b, v1.16b
; GISEL-NEXT:    shl v0.2d, v0.2d, #4
; GISEL-NEXT:    ushr v2.2d, v2.2d, #4
; GISEL-NEXT:    and v0.16b, v0.16b, v1.16b
; GISEL-NEXT:    movi v1.16b, #204
; GISEL-NEXT:    orr v0.16b, v2.16b, v0.16b
; GISEL-NEXT:    and v2.16b, v0.16b, v1.16b
; GISEL-NEXT:    shl v0.2d, v0.2d, #2
; GISEL-NEXT:    ushr v2.2d, v2.2d, #2
; GISEL-NEXT:    and v0.16b, v0.16b, v1.16b
; GISEL-NEXT:    movi v1.16b, #170
; GISEL-NEXT:    orr v0.16b, v2.16b, v0.16b
; GISEL-NEXT:    and v2.16b, v0.16b, v1.16b
; GISEL-NEXT:    shl v0.2d, v0.2d, #1
; GISEL-NEXT:    ushr v2.2d, v2.2d, #1
; GISEL-NEXT:    and v0.16b, v0.16b, v1.16b
; GISEL-NEXT:    orr v0.16b, v2.16b, v0.16b
; GISEL-NEXT:    ret
  %b = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %a)
  ret <2 x i64> %b
}
