; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64 -mattr=+sve2 %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SVE2
; RUN: llc -mtriple=aarch64 -mattr=+sve %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SVE

define <vscale x 2 x i64> @signed_wide_add_nxv4i32(<vscale x 2 x i64> %acc, <vscale x 4 x i32> %input){
; CHECK-SVE2-LABEL: signed_wide_add_nxv4i32:
; CHECK-SVE2:       // %bb.0: // %entry
; CHECK-SVE2-NEXT:    saddwb z0.d, z0.d, z1.s
; CHECK-SVE2-NEXT:    saddwt z0.d, z0.d, z1.s
; CHECK-SVE2-NEXT:    ret
;
; CHECK-SVE-LABEL: signed_wide_add_nxv4i32:
; CHECK-SVE:       // %bb.0: // %entry
; CHECK-SVE-NEXT:    sunpklo z2.d, z1.s
; CHECK-SVE-NEXT:    sunpkhi z1.d, z1.s
; CHECK-SVE-NEXT:    add z0.d, z0.d, z2.d
; CHECK-SVE-NEXT:    add z0.d, z1.d, z0.d
; CHECK-SVE-NEXT:    ret
entry:
    %input.wide = sext <vscale x 4 x i32> %input to <vscale x 4 x i64>
    %partial.reduce = tail call <vscale x 2 x i64> @llvm.experimental.vector.partial.reduce.add.nxv2i64.nxv4i64(<vscale x 2 x i64> %acc, <vscale x 4 x i64> %input.wide)
    ret <vscale x 2 x i64> %partial.reduce
}

define <vscale x 2 x i64> @unsigned_wide_add_nxv4i32(<vscale x 2 x i64> %acc, <vscale x 4 x i32> %input){
; CHECK-SVE2-LABEL: unsigned_wide_add_nxv4i32:
; CHECK-SVE2:       // %bb.0: // %entry
; CHECK-SVE2-NEXT:    uaddwb z0.d, z0.d, z1.s
; CHECK-SVE2-NEXT:    uaddwt z0.d, z0.d, z1.s
; CHECK-SVE2-NEXT:    ret
;
; CHECK-SVE-LABEL: unsigned_wide_add_nxv4i32:
; CHECK-SVE:       // %bb.0: // %entry
; CHECK-SVE-NEXT:    uunpklo z2.d, z1.s
; CHECK-SVE-NEXT:    uunpkhi z1.d, z1.s
; CHECK-SVE-NEXT:    add z0.d, z0.d, z2.d
; CHECK-SVE-NEXT:    add z0.d, z1.d, z0.d
; CHECK-SVE-NEXT:    ret
entry:
    %input.wide = zext <vscale x 4 x i32> %input to <vscale x 4 x i64>
    %partial.reduce = tail call <vscale x 2 x i64> @llvm.experimental.vector.partial.reduce.add.nxv2i64.nxv4i64(<vscale x 2 x i64> %acc, <vscale x 4 x i64> %input.wide)
    ret <vscale x 2 x i64> %partial.reduce
}

define <vscale x 4 x i32> @signed_wide_add_nxv8i16(<vscale x 4 x i32> %acc, <vscale x 8 x i16> %input){
; CHECK-SVE2-LABEL: signed_wide_add_nxv8i16:
; CHECK-SVE2:       // %bb.0: // %entry
; CHECK-SVE2-NEXT:    saddwb z0.s, z0.s, z1.h
; CHECK-SVE2-NEXT:    saddwt z0.s, z0.s, z1.h
; CHECK-SVE2-NEXT:    ret
;
; CHECK-SVE-LABEL: signed_wide_add_nxv8i16:
; CHECK-SVE:       // %bb.0: // %entry
; CHECK-SVE-NEXT:    sunpklo z2.s, z1.h
; CHECK-SVE-NEXT:    sunpkhi z1.s, z1.h
; CHECK-SVE-NEXT:    add z0.s, z0.s, z2.s
; CHECK-SVE-NEXT:    add z0.s, z1.s, z0.s
; CHECK-SVE-NEXT:    ret
entry:
    %input.wide = sext <vscale x 8 x i16> %input to <vscale x 8 x i32>
    %partial.reduce = tail call <vscale x 4 x i32> @llvm.experimental.vector.partial.reduce.add.nxv4i32.nxv8i32(<vscale x 4 x i32> %acc, <vscale x 8 x i32> %input.wide)
    ret <vscale x 4 x i32> %partial.reduce
}

define <vscale x 4 x i32> @unsigned_wide_add_nxv8i16(<vscale x 4 x i32> %acc, <vscale x 8 x i16> %input){
; CHECK-SVE2-LABEL: unsigned_wide_add_nxv8i16:
; CHECK-SVE2:       // %bb.0: // %entry
; CHECK-SVE2-NEXT:    uaddwb z0.s, z0.s, z1.h
; CHECK-SVE2-NEXT:    uaddwt z0.s, z0.s, z1.h
; CHECK-SVE2-NEXT:    ret
;
; CHECK-SVE-LABEL: unsigned_wide_add_nxv8i16:
; CHECK-SVE:       // %bb.0: // %entry
; CHECK-SVE-NEXT:    uunpklo z2.s, z1.h
; CHECK-SVE-NEXT:    uunpkhi z1.s, z1.h
; CHECK-SVE-NEXT:    add z0.s, z0.s, z2.s
; CHECK-SVE-NEXT:    add z0.s, z1.s, z0.s
; CHECK-SVE-NEXT:    ret
entry:
    %input.wide = zext <vscale x 8 x i16> %input to <vscale x 8 x i32>
    %partial.reduce = tail call <vscale x 4 x i32> @llvm.experimental.vector.partial.reduce.add.nxv4i32.nxv8i32(<vscale x 4 x i32> %acc, <vscale x 8 x i32> %input.wide)
    ret <vscale x 4 x i32> %partial.reduce
}

define <vscale x 8 x i16> @signed_wide_add_nxv16i8(<vscale x 8 x i16> %acc, <vscale x 16 x i8> %input){
; CHECK-SVE2-LABEL: signed_wide_add_nxv16i8:
; CHECK-SVE2:       // %bb.0: // %entry
; CHECK-SVE2-NEXT:    saddwb z0.h, z0.h, z1.b
; CHECK-SVE2-NEXT:    saddwt z0.h, z0.h, z1.b
; CHECK-SVE2-NEXT:    ret
;
; CHECK-SVE-LABEL: signed_wide_add_nxv16i8:
; CHECK-SVE:       // %bb.0: // %entry
; CHECK-SVE-NEXT:    sunpklo z2.h, z1.b
; CHECK-SVE-NEXT:    sunpkhi z1.h, z1.b
; CHECK-SVE-NEXT:    add z0.h, z0.h, z2.h
; CHECK-SVE-NEXT:    add z0.h, z1.h, z0.h
; CHECK-SVE-NEXT:    ret
entry:
    %input.wide = sext <vscale x 16 x i8> %input to <vscale x 16 x i16>
    %partial.reduce = tail call <vscale x 8 x i16> @llvm.experimental.vector.partial.reduce.add.nxv8i16.nxv16i16(<vscale x 8 x i16> %acc, <vscale x 16 x i16> %input.wide)
    ret <vscale x 8 x i16> %partial.reduce
}

define <vscale x 8 x i16> @unsigned_wide_add_nxv16i8(<vscale x 8 x i16> %acc, <vscale x 16 x i8> %input){
; CHECK-SVE2-LABEL: unsigned_wide_add_nxv16i8:
; CHECK-SVE2:       // %bb.0: // %entry
; CHECK-SVE2-NEXT:    uaddwb z0.h, z0.h, z1.b
; CHECK-SVE2-NEXT:    uaddwt z0.h, z0.h, z1.b
; CHECK-SVE2-NEXT:    ret
;
; CHECK-SVE-LABEL: unsigned_wide_add_nxv16i8:
; CHECK-SVE:       // %bb.0: // %entry
; CHECK-SVE-NEXT:    uunpklo z2.h, z1.b
; CHECK-SVE-NEXT:    uunpkhi z1.h, z1.b
; CHECK-SVE-NEXT:    add z0.h, z0.h, z2.h
; CHECK-SVE-NEXT:    add z0.h, z1.h, z0.h
; CHECK-SVE-NEXT:    ret
entry:
    %input.wide = zext <vscale x 16 x i8> %input to <vscale x 16 x i16>
    %partial.reduce = tail call <vscale x 8 x i16> @llvm.experimental.vector.partial.reduce.add.nxv8i16.nxv16i16(<vscale x 8 x i16> %acc, <vscale x 16 x i16> %input.wide)
    ret <vscale x 8 x i16> %partial.reduce
}

define <vscale x 2 x i32> @signed_wide_add_nxv4i16(<vscale x 2 x i32> %acc, <vscale x 4 x i16> %input){
; CHECK-LABEL: signed_wide_add_nxv4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sxth z1.s, p0/m, z1.s
; CHECK-NEXT:    uunpklo z2.d, z1.s
; CHECK-NEXT:    uunpkhi z1.d, z1.s
; CHECK-NEXT:    add z0.d, z0.d, z2.d
; CHECK-NEXT:    add z0.d, z1.d, z0.d
; CHECK-NEXT:    ret
entry:
    %input.wide = sext <vscale x 4 x i16> %input to <vscale x 4 x i32>
    %partial.reduce = tail call <vscale x 2 x i32> @llvm.experimental.vector.partial.reduce.add.nxv2i32.nxv4i32(<vscale x 2 x i32> %acc, <vscale x 4 x i32> %input.wide)
    ret <vscale x 2 x i32> %partial.reduce
}

define <vscale x 2 x i32> @unsigned_wide_add_nxv4i16(<vscale x 2 x i32> %acc, <vscale x 4 x i16> %input){
; CHECK-LABEL: unsigned_wide_add_nxv4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and z1.s, z1.s, #0xffff
; CHECK-NEXT:    uunpklo z2.d, z1.s
; CHECK-NEXT:    uunpkhi z1.d, z1.s
; CHECK-NEXT:    add z0.d, z0.d, z2.d
; CHECK-NEXT:    add z0.d, z1.d, z0.d
; CHECK-NEXT:    ret
entry:
    %input.wide = zext <vscale x 4 x i16> %input to <vscale x 4 x i32>
    %partial.reduce = tail call <vscale x 2 x i32> @llvm.experimental.vector.partial.reduce.add.nxv2i32.nxv4i32(<vscale x 2 x i32> %acc, <vscale x 4 x i32> %input.wide)
    ret <vscale x 2 x i32> %partial.reduce
}

define <vscale x 4 x i64> @signed_wide_add_nxv8i32(<vscale x 4 x i64> %acc, <vscale x 8 x i32> %input){
; CHECK-LABEL: signed_wide_add_nxv8i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sunpkhi z4.d, z2.s
; CHECK-NEXT:    sunpklo z2.d, z2.s
; CHECK-NEXT:    sunpkhi z5.d, z3.s
; CHECK-NEXT:    sunpklo z3.d, z3.s
; CHECK-NEXT:    add z0.d, z0.d, z2.d
; CHECK-NEXT:    add z1.d, z1.d, z4.d
; CHECK-NEXT:    add z0.d, z3.d, z0.d
; CHECK-NEXT:    add z1.d, z5.d, z1.d
; CHECK-NEXT:    ret
entry:
    %input.wide = sext <vscale x 8 x i32> %input to <vscale x 8 x i64>
    %partial.reduce = tail call <vscale x 4 x i64> @llvm.experimental.vector.partial.reduce.add.nxv4i64.nxv8i64(<vscale x 4 x i64> %acc, <vscale x 8 x i64> %input.wide)
    ret <vscale x 4 x i64> %partial.reduce
}

define <vscale x 4 x i64> @unsigned_wide_add_nxv8i32(<vscale x 4 x i64> %acc, <vscale x 8 x i32> %input){
; CHECK-LABEL: unsigned_wide_add_nxv8i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uunpkhi z4.d, z2.s
; CHECK-NEXT:    uunpklo z2.d, z2.s
; CHECK-NEXT:    uunpkhi z5.d, z3.s
; CHECK-NEXT:    uunpklo z3.d, z3.s
; CHECK-NEXT:    add z0.d, z0.d, z2.d
; CHECK-NEXT:    add z1.d, z1.d, z4.d
; CHECK-NEXT:    add z0.d, z3.d, z0.d
; CHECK-NEXT:    add z1.d, z5.d, z1.d
; CHECK-NEXT:    ret
entry:
    %input.wide = zext <vscale x 8 x i32> %input to <vscale x 8 x i64>
    %partial.reduce = tail call <vscale x 4 x i64> @llvm.experimental.vector.partial.reduce.add.nxv4i64.nxv8i64(<vscale x 4 x i64> %acc, <vscale x 8 x i64> %input.wide)
    ret <vscale x 4 x i64> %partial.reduce
}
