; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: not --crash llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 -global-isel=0 -verify-machineinstrs < %s 2>&1 | FileCheck -check-prefix=GFX9-SDAG-ERR %s
; RUN: not --crash llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 -global-isel=1 -verify-machineinstrs < %s 2>&1 | FileCheck -check-prefix=GFX9-GISEL-ERR %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 -mattr=+architected-sgprs -global-isel=0 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 -mattr=+architected-sgprs -global-isel=1 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1200 -global-isel=0 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX12 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1200 -global-isel=1 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX12 %s

; GFX9-SDAG-ERR: LLVM ERROR: Cannot select: intrinsic %llvm.amdgcn.wave.id
; GFX9-GISEL-ERR: LLVM ERROR: unable to legalize instruction: {{.*}} = G_INTRINSIC intrinsic(@llvm.amdgcn.wave.id)

define amdgpu_cs void @test_wave_id(ptr addrspace(1) %out) {
; GFX9-LABEL: test_wave_id:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_bfe_u32 s0, ttmp8, 0x50019
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: test_wave_id:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_bfe_u32 s0, ttmp8, 0x50019
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-NEXT:    s_endpgm
  %waveid = call i32 @llvm.amdgcn.wave.id()
  store i32 %waveid, ptr addrspace(1) %out
  ret void
}

define amdgpu_gfx void @test_wave_id_callable(ptr addrspace(1) %out) {
; GFX9-LABEL: test_wave_id_callable:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s34, ttmp8, 0x50019
; GFX9-NEXT:    v_mov_b32_e32 v2, s34
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_wave_id_callable:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_bfe_u32 s0, ttmp8, 0x50019
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %waveid = call i32 @llvm.amdgcn.wave.id()
  store i32 %waveid, ptr addrspace(1) %out
  ret void
}

declare i32 @llvm.amdgcn.wave.id()
