; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 -mattr=+d < %s | FileCheck %s

;; This test checks that LLVM can do basic stripping and reapplying of branches
;; to basic blocks.

declare void @test_true()
declare void @test_false()

;; !0 corresponds to a branch being taken, !1 to not being taken.
!0 = !{!"branch_weights", i32 64, i32 4}
!1 = !{!"branch_weights", i32 4, i32 64}

define void @test_bcc_fallthrough_taken(i64 %in) nounwind {
; CHECK-LABEL: test_bcc_fallthrough_taken:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    ori $a1, $zero, 42
; CHECK-NEXT:    bne $a0, $a1, .LBB0_3
; CHECK-NEXT:  # %bb.1: # %true
; CHECK-NEXT:    bl %plt(test_true)
; CHECK-NEXT:  .LBB0_2: # %true
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB0_3: # %false
; CHECK-NEXT:    bl %plt(test_false)
; CHECK-NEXT:    b .LBB0_2
  %tst = icmp eq i64 %in, 42
  br i1 %tst, label %true, label %false, !prof !0

;; Expected layout order is: Entry, TrueBlock, FalseBlock
;; Entry->TrueBlock is the common path, which should be taken whenever the
;; conditional branch is false.

true:
  call void @test_true()
  ret void

false:
  call void @test_false()
  ret void
}

define void @test_bcc_fallthrough_nottaken(i64 %in) nounwind {
; CHECK-LABEL: test_bcc_fallthrough_nottaken:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    ori $a1, $zero, 42
; CHECK-NEXT:    beq $a0, $a1, .LBB1_3
; CHECK-NEXT:  # %bb.1: # %false
; CHECK-NEXT:    bl %plt(test_false)
; CHECK-NEXT:  .LBB1_2: # %true
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB1_3: # %true
; CHECK-NEXT:    bl %plt(test_true)
; CHECK-NEXT:    b .LBB1_2
  %tst = icmp eq i64 %in, 42
  br i1 %tst, label %true, label %false, !prof !1

;; Expected layout order is: Entry, FalseBlock, TrueBlock
;; Entry->FalseBlock is the common path, which should be taken whenever the
;; conditional branch is false.

true:
  call void @test_true()
  ret void

false:
  call void @test_false()
  ret void
}
