; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --mattr=+d < %s | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch64 --mattr=+d < %s | FileCheck %s --check-prefix=LA64

define double @f64_positive_zero() nounwind {
; LA32-LABEL: f64_positive_zero:
; LA32:       # %bb.0:
; LA32-NEXT:    movgr2fr.w $fa0, $zero
; LA32-NEXT:    movgr2frh.w $fa0, $zero
; LA32-NEXT:    ret
;
; LA64-LABEL: f64_positive_zero:
; LA64:       # %bb.0:
; LA64-NEXT:    movgr2fr.d $fa0, $zero
; LA64-NEXT:    ret
  ret double 0.0
}

define double @f64_negative_zero() nounwind {
; LA32-LABEL: f64_negative_zero:
; LA32:       # %bb.0:
; LA32-NEXT:    movgr2fr.w $fa0, $zero
; LA32-NEXT:    movgr2frh.w $fa0, $zero
; LA32-NEXT:    fneg.d $fa0, $fa0
; LA32-NEXT:    ret
;
; LA64-LABEL: f64_negative_zero:
; LA64:       # %bb.0:
; LA64-NEXT:    movgr2fr.d $fa0, $zero
; LA64-NEXT:    fneg.d $fa0, $fa0
; LA64-NEXT:    ret
  ret double -0.0
}

define double @f64_constant_pi() nounwind {
; LA32-LABEL: f64_constant_pi:
; LA32:       # %bb.0:
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI2_0)
; LA32-NEXT:    fld.d $fa0, $a0, %pc_lo12(.LCPI2_0)
; LA32-NEXT:    ret
;
; LA64-LABEL: f64_constant_pi:
; LA64:       # %bb.0:
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI2_0)
; LA64-NEXT:    fld.d $fa0, $a0, %pc_lo12(.LCPI2_0)
; LA64-NEXT:    ret
  ret double 3.1415926535897931159979634685441851615905761718750
}

define double @f64_add_fimm1(double %a) nounwind {
; LA32-LABEL: f64_add_fimm1:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $a0, $zero, 1
; LA32-NEXT:    movgr2fr.w $fa1, $a0
; LA32-NEXT:    ffint.s.w $fa1, $fa1
; LA32-NEXT:    fcvt.d.s $fa1, $fa1
; LA32-NEXT:    fadd.d $fa0, $fa0, $fa1
; LA32-NEXT:    ret
;
; LA64-LABEL: f64_add_fimm1:
; LA64:       # %bb.0:
; LA64-NEXT:    vldi $vr1, -912
; LA64-NEXT:    fadd.d $fa0, $fa0, $fa1
; LA64-NEXT:    ret
  %1 = fadd double %a, 1.0
  ret double %1
}

define double @f64_positive_fimm1() nounwind {
; LA32-LABEL: f64_positive_fimm1:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $a0, $zero, 1
; LA32-NEXT:    movgr2fr.w $fa0, $a0
; LA32-NEXT:    ffint.s.w $fa0, $fa0
; LA32-NEXT:    fcvt.d.s $fa0, $fa0
; LA32-NEXT:    ret
;
; LA64-LABEL: f64_positive_fimm1:
; LA64:       # %bb.0:
; LA64-NEXT:    vldi $vr0, -912
; LA64-NEXT:    ret
  ret double 1.0
}
