; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=+d < %s | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch64 -mattr=+d < %s | FileCheck %s --check-prefix=LA64

define i8 @load_i8() nounwind {
; LA32-LABEL: load_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    ld.b $a0, $zero, 40
; LA32-NEXT:    ret
;
; LA64-LABEL: load_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.b $a0, $zero, 40
; LA64-NEXT:    ret
  %a = load i8, ptr inttoptr (i64 40 to ptr), align 8
  ret i8 %a
}

define signext i8 @load_i8_sext() nounwind {
; LA32-LABEL: load_i8_sext:
; LA32:       # %bb.0:
; LA32-NEXT:    ld.b $a0, $zero, 40
; LA32-NEXT:    ret
;
; LA64-LABEL: load_i8_sext:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.b $a0, $zero, 40
; LA64-NEXT:    ret
  %a = load i8, ptr inttoptr (i64 40 to ptr), align 8
  ret i8 %a
}

define i16 @load_i16() nounwind {
; LA32-LABEL: load_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    ld.h $a0, $zero, 40
; LA32-NEXT:    ret
;
; LA64-LABEL: load_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.h $a0, $zero, 40
; LA64-NEXT:    ret
  %a = load i16, ptr inttoptr (i64 40 to ptr), align 8
  ret i16 %a
}

define signext i16 @load_i16_sext() nounwind {
; LA32-LABEL: load_i16_sext:
; LA32:       # %bb.0:
; LA32-NEXT:    ld.h $a0, $zero, 40
; LA32-NEXT:    ret
;
; LA64-LABEL: load_i16_sext:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.h $a0, $zero, 40
; LA64-NEXT:    ret
  %a = load i16, ptr inttoptr (i64 40 to ptr), align 8
  ret i16 %a
}

define i32 @load_i32() nounwind {
; LA32-LABEL: load_i32:
; LA32:       # %bb.0:
; LA32-NEXT:    ld.w $a0, $zero, 40
; LA32-NEXT:    ret
;
; LA64-LABEL: load_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $a0, $zero, 40
; LA64-NEXT:    ret
  %a = load i32, ptr inttoptr (i64 40 to ptr), align 8
  ret i32 %a
}

define signext i32 @load_i32_sext() nounwind {
; LA32-LABEL: load_i32_sext:
; LA32:       # %bb.0:
; LA32-NEXT:    ld.w $a0, $zero, 40
; LA32-NEXT:    ret
;
; LA64-LABEL: load_i32_sext:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.w $a0, $zero, 40
; LA64-NEXT:    ret
  %a = load i32, ptr inttoptr (i64 40 to ptr), align 8
  ret i32 %a
}

define i64 @load_i64() nounwind {
; LA32-LABEL: load_i64:
; LA32:       # %bb.0:
; LA32-NEXT:    ld.w $a0, $zero, 40
; LA32-NEXT:    ld.w $a1, $zero, 44
; LA32-NEXT:    ret
;
; LA64-LABEL: load_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    ld.d $a0, $zero, 40
; LA64-NEXT:    ret
  %a = load i64, ptr inttoptr (i64 40 to ptr), align 8
  ret i64 %a
}

define void @store_i8(i8 %v) nounwind {
; LA32-LABEL: store_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    st.b $a0, $zero, 40
; LA32-NEXT:    ret
;
; LA64-LABEL: store_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    st.b $a0, $zero, 40
; LA64-NEXT:    ret
  store i8 %v, ptr inttoptr (i64 40 to ptr), align 8
  ret void
}

define void @store_i16(i16 %v) nounwind {
; LA32-LABEL: store_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    st.h $a0, $zero, 40
; LA32-NEXT:    ret
;
; LA64-LABEL: store_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    st.h $a0, $zero, 40
; LA64-NEXT:    ret
  store i16 %v, ptr inttoptr (i64 40 to ptr), align 8
  ret void
}

define void @store_i32(i32 %v) nounwind {
; LA32-LABEL: store_i32:
; LA32:       # %bb.0:
; LA32-NEXT:    st.w $a0, $zero, 40
; LA32-NEXT:    ret
;
; LA64-LABEL: store_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    st.w $a0, $zero, 40
; LA64-NEXT:    ret
  store i32 %v, ptr inttoptr (i64 40 to ptr), align 8
  ret void
}

define void @store_i64(i64 %v) nounwind {
; LA32-LABEL: store_i64:
; LA32:       # %bb.0:
; LA32-NEXT:    st.w $a1, $zero, 44
; LA32-NEXT:    st.w $a0, $zero, 40
; LA32-NEXT:    ret
;
; LA64-LABEL: store_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    st.d $a0, $zero, 40
; LA64-NEXT:    ret
  store i64 %v, ptr inttoptr (i64 40 to ptr), align 8
  ret void
}
