; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-gnu-linux -mcpu=pwr9 < %s | FileCheck %s -check-prefix=CHECK-LE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-gnu-linux -mcpu=pwr9 < %s | FileCheck %s -check-prefix=CHECK-BE

define zeroext i8 @test_add1(<16 x i8> %a, i32 signext %index, i8 zeroext %c) {
; CHECK-LE-LABEL: test_add1:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    clrldi 3, 5, 32
; CHECK-LE-NEXT:    vextubrx 3, 3, 2
; CHECK-LE-NEXT:    add 3, 3, 6
; CHECK-LE-NEXT:    clrldi 3, 3, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: test_add1:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    clrldi 3, 5, 32
; CHECK-BE-NEXT:    vextublx 3, 3, 2
; CHECK-BE-NEXT:    add 3, 3, 6
; CHECK-BE-NEXT:    clrldi 3, 3, 56
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %a, i32 %index
  %conv = zext i8 %vecext to i32
  %conv1 = zext i8 %c to i32
  %add = add nuw nsw i32 %conv, %conv1
  %conv2 = trunc i32 %add to i8
  ret i8 %conv2
}

define signext i8 @test_add2(<16 x i8> %a, i32 signext %index, i8 signext %c) {
; CHECK-LE-LABEL: test_add2:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    clrldi 3, 5, 32
; CHECK-LE-NEXT:    vextubrx 3, 3, 2
; CHECK-LE-NEXT:    add 3, 3, 6
; CHECK-LE-NEXT:    extsb 3, 3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: test_add2:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    clrldi 3, 5, 32
; CHECK-BE-NEXT:    vextublx 3, 3, 2
; CHECK-BE-NEXT:    add 3, 3, 6
; CHECK-BE-NEXT:    extsb 3, 3
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %a, i32 %index
  %conv3 = zext i8 %vecext to i32
  %conv14 = zext i8 %c to i32
  %add = add nuw nsw i32 %conv3, %conv14
  %conv2 = trunc i32 %add to i8
  ret i8 %conv2
}

define zeroext i16 @test_add3(<8 x i16> %a, i32 signext %index, i16 zeroext %c) {
; CHECK-LE-LABEL: test_add3:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    clrldi 3, 5, 32
; CHECK-LE-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-LE-NEXT:    vextuhrx 3, 3, 2
; CHECK-LE-NEXT:    add 3, 3, 6
; CHECK-LE-NEXT:    clrldi 3, 3, 48
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: test_add3:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    clrldi 3, 5, 32
; CHECK-BE-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-BE-NEXT:    vextuhlx 3, 3, 2
; CHECK-BE-NEXT:    add 3, 3, 6
; CHECK-BE-NEXT:    clrldi 3, 3, 48
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %a, i32 %index
  %conv = zext i16 %vecext to i32
  %conv1 = zext i16 %c to i32
  %add = add nuw nsw i32 %conv, %conv1
  %conv2 = trunc i32 %add to i16
  ret i16 %conv2
}

define signext i16 @test_add4(<8 x i16> %a, i32 signext %index, i16 signext %c) {
; CHECK-LE-LABEL: test_add4:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    clrldi 3, 5, 32
; CHECK-LE-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-LE-NEXT:    vextuhrx 3, 3, 2
; CHECK-LE-NEXT:    add 3, 3, 6
; CHECK-LE-NEXT:    extsh 3, 3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: test_add4:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    clrldi 3, 5, 32
; CHECK-BE-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-BE-NEXT:    vextuhlx 3, 3, 2
; CHECK-BE-NEXT:    add 3, 3, 6
; CHECK-BE-NEXT:    extsh 3, 3
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %a, i32 %index
  %conv5 = zext i16 %vecext to i32
  %conv16 = zext i16 %c to i32
  %add = add nuw nsw i32 %conv5, %conv16
  %conv2 = trunc i32 %add to i16
  ret i16 %conv2
}

define zeroext i32 @test_add5(<4 x i32> %a, i32 signext %index, i32 zeroext %c) {
; CHECK-LE-LABEL: test_add5:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    clrldi 3, 5, 32
; CHECK-LE-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-LE-NEXT:    vextuwrx 3, 3, 2
; CHECK-LE-NEXT:    add 3, 3, 6
; CHECK-LE-NEXT:    clrldi 3, 3, 32
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: test_add5:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    clrldi 3, 5, 32
; CHECK-BE-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-BE-NEXT:    vextuwlx 3, 3, 2
; CHECK-BE-NEXT:    add 3, 3, 6
; CHECK-BE-NEXT:    clrldi 3, 3, 32
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 %index
  %add = add i32 %vecext, %c
  ret i32 %add
}

define signext i32 @test_add6(<4 x i32> %a, i32 signext %index, i32 signext %c) {
; CHECK-LE-LABEL: test_add6:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    clrldi 3, 5, 32
; CHECK-LE-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-LE-NEXT:    vextuwrx 3, 3, 2
; CHECK-LE-NEXT:    add 3, 3, 6
; CHECK-LE-NEXT:    extsw 3, 3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: test_add6:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    clrldi 3, 5, 32
; CHECK-BE-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-BE-NEXT:    vextuwlx 3, 3, 2
; CHECK-BE-NEXT:    add 3, 3, 6
; CHECK-BE-NEXT:    extsw 3, 3
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 %index
  %add = add nsw i32 %vecext, %c
  ret i32 %add
}

; When extracting word element 2 on LE, it's better to use mfvsrwz rather than vextuwrx
define zeroext i32 @test7(<4 x i32> %a) {
; CHECK-LE-LABEL: test7:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrwz 3, 34
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: test7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    li 3, 8
; CHECK-BE-NEXT:    vextuwlx 3, 3, 2
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 2
  ret i32 %vecext
}

define zeroext i32 @testadd_7(<4 x i32> %a, i32 zeroext %c) {
; CHECK-LE-LABEL: testadd_7:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrwz 3, 34
; CHECK-LE-NEXT:    add 3, 3, 5
; CHECK-LE-NEXT:    clrldi 3, 3, 32
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: testadd_7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    li 3, 8
; CHECK-BE-NEXT:    vextuwlx 3, 3, 2
; CHECK-BE-NEXT:    add 3, 3, 5
; CHECK-BE-NEXT:    clrldi 3, 3, 32
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 2
  %add = add i32 %vecext, %c
  ret i32 %add
}

define signext i32 @test8(<4 x i32> %a) {
; CHECK-LE-LABEL: test8:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrwz 3, 34
; CHECK-LE-NEXT:    extsw 3, 3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: test8:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    li 3, 8
; CHECK-BE-NEXT:    vextuwlx 3, 3, 2
; CHECK-BE-NEXT:    extsw 3, 3
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 2
  ret i32 %vecext
}

define signext i32 @testadd_8(<4 x i32> %a, i32 signext %c) {
; CHECK-LE-LABEL: testadd_8:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrwz 3, 34
; CHECK-LE-NEXT:    add 3, 3, 5
; CHECK-LE-NEXT:    extsw 3, 3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: testadd_8:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    li 3, 8
; CHECK-BE-NEXT:    vextuwlx 3, 3, 2
; CHECK-BE-NEXT:    add 3, 3, 5
; CHECK-BE-NEXT:    extsw 3, 3
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 2
  %add = add nsw i32 %vecext, %c
  ret i32 %add
}

; When extracting word element 1 on BE, it's better to use mfvsrwz rather than vextuwlx
define signext i32 @test9(<4 x i32> %a) {
; CHECK-LE-LABEL: test9:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    li 3, 4
; CHECK-LE-NEXT:    vextuwrx 3, 3, 2
; CHECK-LE-NEXT:    extsw 3, 3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: test9:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    mfvsrwz 3, 34
; CHECK-BE-NEXT:    extsw 3, 3
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 1
  ret i32 %vecext
}

define signext i32 @testadd_9(<4 x i32> %a, i32 signext %c) {
; CHECK-LE-LABEL: testadd_9:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    li 3, 4
; CHECK-LE-NEXT:    vextuwrx 3, 3, 2
; CHECK-LE-NEXT:    add 3, 3, 5
; CHECK-LE-NEXT:    extsw 3, 3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: testadd_9:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    mfvsrwz 3, 34
; CHECK-BE-NEXT:    add 3, 3, 5
; CHECK-BE-NEXT:    extsw 3, 3
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 1
  %add = add nsw i32 %vecext, %c
  ret i32 %add
}
