; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -disable-output -passes=print-mustexecute %s 2>&1 | FileCheck %s

; Infinite loop.
; Make sure that the backedge is mustexec.
define void @test_no_exit_block(i1 %cond, i32 %a, i32 %b) {
; CHECK-LABEL: @test_no_exit_block(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ] ; (mustexec in: loop)
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[MAYBE_TAKEN:%.*]], label [[BACKEDGE]] ; (mustexec in: loop)
; CHECK:       maybe_taken:
; CHECK-NOT:   mustexec
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    br label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1 ; (mustexec in: loop)
; CHECK-NEXT:    br label [[LOOP]] ; (mustexec in: loop)
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %backedge ]
  br i1 %cond, label %maybe_taken, label %backedge

maybe_taken:
  %div = sdiv i32 %a, %b
  br label %backedge

backedge:
  %iv.next = add i32 %iv, 1
  br label %loop
}

; Unlike the test before, we can say that backedge is mustexec, which is the
; correct behavior.
define void @test_impossible_exit_on_latch(i1 %cond, i32 %a, i32 %b) {
; CHECK-LABEL: @test_impossible_exit_on_latch(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ] ; (mustexec in: loop)
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[MAYBE_TAKEN:%.*]], label [[BACKEDGE]] ; (mustexec in: loop)
; CHECK:       maybe_taken:
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    br label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1 ; (mustexec in: loop)
; CHECK-NEXT:    br i1 true, label [[LOOP]], label [[EXIT:%.*]] ; (mustexec in: loop)
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %backedge ]
  br i1 %cond, label %maybe_taken, label %backedge

maybe_taken:
  %div = sdiv i32 %a, %b
  br label %backedge

backedge:
  %iv.next = add i32 %iv, 1
  br i1 true, label %loop, label %exit

exit:
  ret void
}

; Make sure that sdiv is NOT marked as mustexec.
define void @test_impossible_exit_in_untaken_block(i1 %cond, i32 %a, i32 %b, ptr %p) {
; CHECK-LABEL: @test_impossible_exit_in_untaken_block(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ] ; (mustexec in: loop)
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[MAYBE_TAKEN:%.*]], label [[BACKEDGE]] ; (mustexec in: loop)
; CHECK:       maybe_taken:
; CHECK-NOT:   mustexec
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    store i32 [[DIV]], ptr [[P:%.*]]
; CHECK-NEXT:    br i1 true, label [[BACKEDGE]], label [[EXIT:%.*]]
; CHECK:       backedge:
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1 ; (mustexec in: loop)
; CHECK-NEXT:    br label [[LOOP]] ; (mustexec in: loop)
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %backedge ]
  br i1 %cond, label %maybe_taken, label %backedge

maybe_taken:
  %div = sdiv i32 %a, %b
  store i32 %div, ptr %p
  br i1 true, label %backedge, label %exit

backedge:
  %iv.next = add i32 %iv, 1
  br label %loop

exit:
  ret void
}
