; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=thumbv7-none-eabi | FileCheck %s --check-prefixes=CHECK,CHECK-LE
; RUN: llc < %s -mtriple=thumbebv7-none-eabi | FileCheck %s --check-prefixes=CHECK,CHECK-BE

define void @store_v8i8(ptr %ptr, <8 x i8> %val) {
; CHECK-LABEL: store_v8i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    ldr r0, [r0]
; CHECK-NEXT:    str r3, [r0, #4]
; CHECK-NEXT:    str r2, [r0]
; CHECK-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <8 x i8> %val, ptr %A, align 1
    ret void
}

define void @store_v8i8_update(ptr %ptr, <8 x i8> %val) {
; CHECK-LE-LABEL: store_v8i8_update:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    vst1.8 {d16}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v8i8_update:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev64.8 d16, d16
; CHECK-BE-NEXT:    vst1.8 {d16}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <8 x i8> %val, ptr %A, align 1
    %inc = getelementptr <8 x i8>, ptr %A, i38 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v4i16(ptr %ptr, <4 x i16> %val) {
; CHECK-LABEL: store_v4i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    ldr r0, [r0]
; CHECK-NEXT:    str r3, [r0, #4]
; CHECK-NEXT:    str r2, [r0]
; CHECK-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <4 x i16> %val, ptr %A, align 1
    ret void
}

define void @store_v4i16_update(ptr %ptr, <4 x i16> %val) {
; CHECK-LE-LABEL: store_v4i16_update:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    vst1.8 {d16}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v4i16_update:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev64.8 d16, d16
; CHECK-BE-NEXT:    vst1.8 {d16}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <4 x i16> %val, ptr %A, align 1
    %inc = getelementptr <4 x i16>, ptr %A, i34 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v2i32(ptr %ptr, <2 x i32> %val) {
; CHECK-LABEL: store_v2i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    ldr r0, [r0]
; CHECK-NEXT:    str r3, [r0, #4]
; CHECK-NEXT:    str r2, [r0]
; CHECK-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <2 x i32> %val, ptr %A, align 1
    ret void
}

define void @store_v2i32_update(ptr %ptr, <2 x i32> %val) {
; CHECK-LE-LABEL: store_v2i32_update:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    vst1.8 {d16}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v2i32_update:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev64.8 d16, d16
; CHECK-BE-NEXT:    vst1.8 {d16}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <2 x i32> %val, ptr %A, align 1
    %inc = getelementptr <2 x i32>, ptr %A, i32 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v2f32(ptr %ptr, <2 x float> %val) {
; CHECK-LABEL: store_v2f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    ldr r0, [r0]
; CHECK-NEXT:    str r3, [r0, #4]
; CHECK-NEXT:    str r2, [r0]
; CHECK-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <2 x float> %val, ptr %A, align 1
    ret void
}

define void @store_v2f32_update(ptr %ptr, <2 x float> %val) {
; CHECK-LE-LABEL: store_v2f32_update:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    vst1.8 {d16}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v2f32_update:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev64.8 d16, d16
; CHECK-BE-NEXT:    vst1.8 {d16}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <2 x float> %val, ptr %A, align 1
    %inc = getelementptr <2 x float>, ptr %A, i32 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v1i64(ptr %ptr, <1 x i64> %val) {
; CHECK-LABEL: store_v1i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    ldr r0, [r0]
; CHECK-NEXT:    str r3, [r0, #4]
; CHECK-NEXT:    str r2, [r0]
; CHECK-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <1 x i64> %val, ptr %A, align 1
    ret void
}

define void @store_v1i64_update(ptr %ptr, <1 x i64> %val) {
; CHECK-LE-LABEL: store_v1i64_update:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    vst1.8 {d16}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v1i64_update:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev64.8 d16, d16
; CHECK-BE-NEXT:    vst1.8 {d16}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <1 x i64> %val, ptr %A, align 1
    %inc = getelementptr <1 x i64>, ptr %A, i31 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v16i8(ptr %ptr, <16 x i8> %val) {
; CHECK-LE-LABEL: store_v16i8:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    ldr r0, [r0]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    vst1.8 {d16, d17}, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v16i8:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r0, [r0]
; CHECK-BE-NEXT:    vrev64.8 q8, q8
; CHECK-BE-NEXT:    vst1.8 {d16, d17}, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <16 x i8> %val, ptr %A, align 1
    ret void
}

define void @store_v16i8_update(ptr %ptr, <16 x i8> %val) {
; CHECK-LE-LABEL: store_v16i8_update:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vst1.8 {d16, d17}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v16i8_update:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev64.8 q8, q8
; CHECK-BE-NEXT:    vst1.8 {d16, d17}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <16 x i8> %val, ptr %A, align 1
    %inc = getelementptr <16 x i8>, ptr %A, i316 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v8i16(ptr %ptr, <8 x i16> %val) {
; CHECK-LE-LABEL: store_v8i16:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    ldr r0, [r0]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    vst1.8 {d16, d17}, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v8i16:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r0, [r0]
; CHECK-BE-NEXT:    vrev64.8 q8, q8
; CHECK-BE-NEXT:    vst1.8 {d16, d17}, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <8 x i16> %val, ptr %A, align 1
    ret void
}

define void @store_v8i16_update(ptr %ptr, <8 x i16> %val) {
; CHECK-LE-LABEL: store_v8i16_update:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vst1.8 {d16, d17}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v8i16_update:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev64.8 q8, q8
; CHECK-BE-NEXT:    vst1.8 {d16, d17}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <8 x i16> %val, ptr %A, align 1
    %inc = getelementptr <8 x i16>, ptr %A, i38 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v4i32(ptr %ptr, <4 x i32> %val) {
; CHECK-LE-LABEL: store_v4i32:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    ldr r0, [r0]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    vst1.8 {d16, d17}, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v4i32:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r0, [r0]
; CHECK-BE-NEXT:    vrev64.8 q8, q8
; CHECK-BE-NEXT:    vst1.8 {d16, d17}, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <4 x i32> %val, ptr %A, align 1
    ret void
}

define void @store_v4i32_update(ptr %ptr, <4 x i32> %val) {
; CHECK-LE-LABEL: store_v4i32_update:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vst1.8 {d16, d17}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v4i32_update:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev64.8 q8, q8
; CHECK-BE-NEXT:    vst1.8 {d16, d17}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <4 x i32> %val, ptr %A, align 1
    %inc = getelementptr <4 x i32>, ptr %A, i34 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v4f32(ptr %ptr, <4 x float> %val) {
; CHECK-LE-LABEL: store_v4f32:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    ldr r0, [r0]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    vst1.8 {d16, d17}, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v4f32:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r0, [r0]
; CHECK-BE-NEXT:    vrev64.8 q8, q8
; CHECK-BE-NEXT:    vst1.8 {d16, d17}, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <4 x float> %val, ptr %A, align 1
    ret void
}

define void @store_v4f32_update(ptr %ptr, <4 x float> %val) {
; CHECK-LE-LABEL: store_v4f32_update:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vst1.8 {d16, d17}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v4f32_update:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev64.8 q8, q8
; CHECK-BE-NEXT:    vst1.8 {d16, d17}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <4 x float> %val, ptr %A, align 1
    %inc = getelementptr <4 x float>, ptr %A, i34 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v2i64(ptr %ptr, <2 x i64> %val) {
; CHECK-LE-LABEL: store_v2i64:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    ldr r0, [r0]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    vst1.8 {d16, d17}, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v2i64:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r0, [r0]
; CHECK-BE-NEXT:    vrev64.8 q8, q8
; CHECK-BE-NEXT:    vst1.8 {d16, d17}, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <2 x i64> %val, ptr %A, align 1
    ret void
}

define void @store_v2i64_update(ptr %ptr, <2 x i64> %val) {
; CHECK-LE-LABEL: store_v2i64_update:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vst1.8 {d16, d17}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v2i64_update:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev64.8 q8, q8
; CHECK-BE-NEXT:    vst1.8 {d16, d17}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <2 x i64> %val, ptr %A, align 1
    %inc = getelementptr <2 x i64>, ptr %A, i32 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v2i64_update_aligned2(ptr %ptr, <2 x i64> %val) {
; CHECK-LE-LABEL: store_v2i64_update_aligned2:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vst1.16 {d16, d17}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v2i64_update_aligned2:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev64.16 q8, q8
; CHECK-BE-NEXT:    vst1.16 {d16, d17}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <2 x i64> %val, ptr %A, align 2
    %inc = getelementptr <2 x i64>, ptr %A, i32 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v2i64_update_aligned4(ptr %ptr, <2 x i64> %val) {
; CHECK-LE-LABEL: store_v2i64_update_aligned4:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vst1.32 {d16, d17}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v2i64_update_aligned4:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev64.32 q8, q8
; CHECK-BE-NEXT:    vst1.32 {d16, d17}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <2 x i64> %val, ptr %A, align 4
    %inc = getelementptr <2 x i64>, ptr %A, i32 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v2i64_update_aligned8(ptr %ptr, <2 x i64> %val) {
; CHECK-LE-LABEL: store_v2i64_update_aligned8:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vst1.64 {d16, d17}, [r1]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v2i64_update_aligned8:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vst1.64 {d16, d17}, [r1]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <2 x i64> %val, ptr %A, align 8
    %inc = getelementptr <2 x i64>, ptr %A, i32 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @store_v2i64_update_aligned16(ptr %ptr, <2 x i64> %val) {
; CHECK-LE-LABEL: store_v2i64_update_aligned16:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    vst1.64 {d16, d17}, [r1:128]!
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: store_v2i64_update_aligned16:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vst1.64 {d16, d17}, [r1:128]!
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    store  <2 x i64> %val, ptr %A, align 16
    %inc = getelementptr <2 x i64>, ptr %A, i32 1
    store ptr %inc, ptr %ptr
    ret void
}

define void @truncstore_v4i32tov4i8(ptr %ptr, <4 x i32> %val) {
; CHECK-LE-LABEL: truncstore_v4i32tov4i8:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    ldr r0, [r0]
; CHECK-LE-NEXT:    vmovn.i32 d16, q8
; CHECK-LE-NEXT:    vuzp.8 d16, d17
; CHECK-LE-NEXT:    vst1.32 {d16[0]}, [r0:32]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: truncstore_v4i32tov4i8:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    vrev64.32 q8, q8
; CHECK-BE-NEXT:    vmovn.i32 d16, q8
; CHECK-BE-NEXT:    vrev16.8 d16, d16
; CHECK-BE-NEXT:    vuzp.8 d16, d17
; CHECK-BE-NEXT:    ldr r0, [r0]
; CHECK-BE-NEXT:    vrev32.8 d16, d17
; CHECK-BE-NEXT:    vst1.32 {d16[0]}, [r0:32]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    %trunc = trunc <4 x i32> %val to <4 x i8>
    store  <4 x i8> %trunc, ptr %A, align 4
    ret void
}

define void @truncstore_v4i32tov4i8_fake_update(ptr %ptr, <4 x i32> %val) {
; CHECK-LE-LABEL: truncstore_v4i32tov4i8_fake_update:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vldr d17, [sp]
; CHECK-LE-NEXT:    vmov d16, r2, r3
; CHECK-LE-NEXT:    ldr r1, [r0]
; CHECK-LE-NEXT:    movs r2, #16
; CHECK-LE-NEXT:    vmovn.i32 d16, q8
; CHECK-LE-NEXT:    vuzp.8 d16, d17
; CHECK-LE-NEXT:    vst1.32 {d16[0]}, [r1:32], r2
; CHECK-LE-NEXT:    str r1, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: truncstore_v4i32tov4i8_fake_update:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d17, [sp]
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    movs r2, #16
; CHECK-BE-NEXT:    vrev64.32 q8, q8
; CHECK-BE-NEXT:    vmovn.i32 d16, q8
; CHECK-BE-NEXT:    vrev16.8 d16, d16
; CHECK-BE-NEXT:    vuzp.8 d16, d17
; CHECK-BE-NEXT:    ldr r1, [r0]
; CHECK-BE-NEXT:    vrev32.8 d16, d17
; CHECK-BE-NEXT:    vst1.32 {d16[0]}, [r1:32], r2
; CHECK-BE-NEXT:    str r1, [r0]
; CHECK-BE-NEXT:    bx lr
    %A = load ptr, ptr %ptr
    %trunc = trunc <4 x i32> %val to <4 x i8>
    store  <4 x i8> %trunc, ptr %A, align 4
    %inc = getelementptr <4 x i8>, ptr %A, i38 4
    store ptr %inc, ptr %ptr
    ret void
}

define ptr @test_vst1_1reg(ptr %ptr.in, ptr %ptr.out) {
; CHECK-LE-LABEL: test_vst1_1reg:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-LE-NEXT:    movs r0, #32
; CHECK-LE-NEXT:    vst1.32 {d16, d17}, [r1], r0
; CHECK-LE-NEXT:    mov r0, r1
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vst1_1reg:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-BE-NEXT:    movs r0, #32
; CHECK-BE-NEXT:    vrev64.32 q8, q8
; CHECK-BE-NEXT:    vst1.32 {d16, d17}, [r1], r0
; CHECK-BE-NEXT:    mov r0, r1
; CHECK-BE-NEXT:    bx lr
  %val = load <4 x i32>, ptr %ptr.in
  store <4 x i32> %val, ptr %ptr.out
  %next = getelementptr <4 x i32>, ptr %ptr.out, i32 2
  ret ptr %next
}

; PR56970
define void @v3i8store(ptr %p) {
; CHECK-LE-LABEL: v3i8store:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    .pad #4
; CHECK-LE-NEXT:    sub sp, #4
; CHECK-LE-NEXT:    movs r1, #0
; CHECK-LE-NEXT:    mov r2, sp
; CHECK-LE-NEXT:    str r1, [sp]
; CHECK-LE-NEXT:    vld1.32 {d16[0]}, [r2:32]
; CHECK-LE-NEXT:    strb r1, [r0, #2]
; CHECK-LE-NEXT:    vmovl.u16 q8, d16
; CHECK-LE-NEXT:    vmov.32 r2, d16[0]
; CHECK-LE-NEXT:    strh r2, [r0]
; CHECK-LE-NEXT:    add sp, #4
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: v3i8store:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    .pad #4
; CHECK-BE-NEXT:    sub sp, #4
; CHECK-BE-NEXT:    movs r1, #0
; CHECK-BE-NEXT:    mov r2, sp
; CHECK-BE-NEXT:    str r1, [sp]
; CHECK-BE-NEXT:    vld1.32 {d16[0]}, [r2:32]
; CHECK-BE-NEXT:    strb r1, [r0, #2]
; CHECK-BE-NEXT:    vrev32.16 d16, d16
; CHECK-BE-NEXT:    vmovl.u16 q8, d16
; CHECK-BE-NEXT:    vmov.32 r2, d16[0]
; CHECK-BE-NEXT:    strh r2, [r0]
; CHECK-BE-NEXT:    add sp, #4
; CHECK-BE-NEXT:    bx lr
  store <3 x i8> zeroinitializer, ptr %p, align 4
  ret void
}

define void @v3i64shuffle(ptr %p, <3 x i64> %a) {
; CHECK-LE-LABEL: v3i64shuffle:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vmov.i32 q8, #0x0
; CHECK-LE-NEXT:    ldrd r12, r1, [sp, #8]
; CHECK-LE-NEXT:    vmov d18, r2, r3
; CHECK-LE-NEXT:    vorr d19, d16, d16
; CHECK-LE-NEXT:    str r1, [r0, #20]
; CHECK-LE-NEXT:    vst1.32 {d18, d19}, [r0]!
; CHECK-LE-NEXT:    str.w r12, [r0]
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: v3i64shuffle:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vldr d16, [sp, #8]
; CHECK-BE-NEXT:    vmov.i32 q9, #0x0
; CHECK-BE-NEXT:    vrev64.32 q8, q8
; CHECK-BE-NEXT:    vmov r12, r1, d16
; CHECK-BE-NEXT:    vmov d16, r3, r2
; CHECK-BE-NEXT:    vorr d17, d18, d18
; CHECK-BE-NEXT:    vrev64.32 q8, q8
; CHECK-BE-NEXT:    str r1, [r0, #20]
; CHECK-BE-NEXT:    vst1.32 {d16, d17}, [r0]!
; CHECK-BE-NEXT:    str.w r12, [r0]
; CHECK-BE-NEXT:    bx lr
  %b = shufflevector <3 x i64> %a, <3 x i64> zeroinitializer, <3 x i32> <i32 0, i32 3, i32 2>
  store <3 x i64> %b, ptr %p, align 4
  ret void
}

