; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -mattr=+v \
; RUN:   -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK
; RUN: llc -mtriple=riscv64 -mattr=+v \
; RUN:   -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK

define target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_tuple_zero_power_of_2() {
; CHECK-LABEL: test_tuple_zero_power_of_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    ret
entry:
  ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) zeroinitializer
}

define target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @test_tuple_zero_non_power_of_2() {
; CHECK-LABEL: test_tuple_zero_non_power_of_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    vmv.v.i v12, 0
; CHECK-NEXT:    ret
entry:
  ret target("riscv.vector.tuple", <vscale x 16 x i8>, 3) zeroinitializer
}

define target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_tuple_zero_insert1(<vscale x 4 x i32> %a) {
; CHECK-LABEL: test_tuple_zero_insert1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    ret
entry:
  %1 = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) zeroinitializer, <vscale x 4 x i32> %a, i32 0)
  ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1
}

define target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_tuple_zero_insert2(<vscale x 4 x i32> %a) {
; CHECK-LABEL: test_tuple_zero_insert2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v6, 0
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    ret
entry:
  %1 = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) zeroinitializer, <vscale x 4 x i32> %a, i32 1)
  ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1
}
