// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32 -show-encoding %s | FileCheck --check-prefix=GFX10 %s
// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize64 -show-encoding %s | FileCheck --check-prefix=GFX10 %s

//===----------------------------------------------------------------------===//
// ENC_SOP1.
//===----------------------------------------------------------------------===//

s_mov_b32 s0, s1
// GFX10: encoding: [0x01,0x03,0x80,0xbe]

s_mov_b32 s105, s104
// GFX10: encoding: [0x68,0x03,0xe9,0xbe]

s_mov_b32 s0, s104
// GFX10: encoding: [0x68,0x03,0x80,0xbe]

s_mov_b32 s105, s1
// GFX10: encoding: [0x01,0x03,0xe9,0xbe]

s_mov_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x03,0xfe,0xbe]

s_mov_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x03,0xff,0xbe]

s_mov_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x03,0xea,0xbe]

s_mov_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x03,0xeb,0xbe]

s_mov_b32 m0, s1
// GFX10: encoding: [0x01,0x03,0xfc,0xbe]

s_mov_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x03,0x80,0xbe]

s_mov_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x03,0x80,0xbe]

s_mov_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x03,0x80,0xbe]

s_mov_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x03,0x80,0xbe]

s_mov_b32 s0, m0
// GFX10: encoding: [0x7c,0x03,0x80,0xbe]

s_mov_b32 s0, 0
// GFX10: encoding: [0x80,0x03,0x80,0xbe]

s_mov_b32 s0, -1
// GFX10: encoding: [0xc1,0x03,0x80,0xbe]

s_mov_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x03,0x80,0xbe]

s_mov_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x03,0x80,0xbe]

s_mov_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x03,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_mov_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x03,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_mov_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x04,0x80,0xbe]

s_mov_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x04,0xe8,0xbe]

s_mov_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x04,0x80,0xbe]

s_mov_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x04,0xe8,0xbe]

s_mov_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x04,0xfe,0xbe]

s_mov_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x04,0xea,0xbe]

s_mov_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x04,0x80,0xbe]

s_mov_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x04,0x80,0xbe]

s_mov_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x04,0x80,0xbe]

s_mov_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x04,0x80,0xbe]

s_mov_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x04,0x80,0xbe]

s_mov_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x04,0x80,0xbe]

s_mov_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x04,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_mov_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x04,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_cmov_b32 s0, s1
// GFX10: encoding: [0x01,0x05,0x80,0xbe]

s_cmov_b32 s105, s104
// GFX10: encoding: [0x68,0x05,0xe9,0xbe]

s_cmov_b32 s0, s104
// GFX10: encoding: [0x68,0x05,0x80,0xbe]

s_cmov_b32 s105, s1
// GFX10: encoding: [0x01,0x05,0xe9,0xbe]

s_cmov_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x05,0xfe,0xbe]

s_cmov_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x05,0xff,0xbe]

s_cmov_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x05,0xea,0xbe]

s_cmov_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x05,0xeb,0xbe]

s_cmov_b32 m0, s1
// GFX10: encoding: [0x01,0x05,0xfc,0xbe]

s_cmov_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x05,0x80,0xbe]

s_cmov_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x05,0x80,0xbe]

s_cmov_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x05,0x80,0xbe]

s_cmov_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x05,0x80,0xbe]

s_cmov_b32 s0, m0
// GFX10: encoding: [0x7c,0x05,0x80,0xbe]

s_cmov_b32 s0, 0
// GFX10: encoding: [0x80,0x05,0x80,0xbe]

s_cmov_b32 s0, -1
// GFX10: encoding: [0xc1,0x05,0x80,0xbe]

s_cmov_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x05,0x80,0xbe]

s_cmov_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x05,0x80,0xbe]

s_cmov_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x05,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_cmov_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x05,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_cmov_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x06,0x80,0xbe]

s_cmov_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x06,0xe8,0xbe]

s_cmov_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x06,0x80,0xbe]

s_cmov_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x06,0xe8,0xbe]

s_cmov_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x06,0xfe,0xbe]

s_cmov_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x06,0xea,0xbe]

s_cmov_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x06,0x80,0xbe]

s_cmov_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x06,0x80,0xbe]

s_cmov_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x06,0x80,0xbe]

s_cmov_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x06,0x80,0xbe]

s_cmov_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x06,0x80,0xbe]

s_cmov_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x06,0x80,0xbe]

s_cmov_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x06,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_cmov_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x06,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_not_b32 s0, s1
// GFX10: encoding: [0x01,0x07,0x80,0xbe]

s_not_b32 s105, s104
// GFX10: encoding: [0x68,0x07,0xe9,0xbe]

s_not_b32 s0, s104
// GFX10: encoding: [0x68,0x07,0x80,0xbe]

s_not_b32 s105, s1
// GFX10: encoding: [0x01,0x07,0xe9,0xbe]

s_not_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x07,0xfe,0xbe]

s_not_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x07,0xff,0xbe]

s_not_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x07,0xea,0xbe]

s_not_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x07,0xeb,0xbe]

s_not_b32 m0, s1
// GFX10: encoding: [0x01,0x07,0xfc,0xbe]

s_not_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x07,0x80,0xbe]

s_not_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x07,0x80,0xbe]

s_not_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x07,0x80,0xbe]

s_not_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x07,0x80,0xbe]

s_not_b32 s0, m0
// GFX10: encoding: [0x7c,0x07,0x80,0xbe]

s_not_b32 s0, 0
// GFX10: encoding: [0x80,0x07,0x80,0xbe]

s_not_b32 s0, -1
// GFX10: encoding: [0xc1,0x07,0x80,0xbe]

s_not_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x07,0x80,0xbe]

s_not_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x07,0x80,0xbe]

s_not_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x07,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_not_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x07,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_not_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x08,0x80,0xbe]

s_not_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x08,0xe8,0xbe]

s_not_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x08,0x80,0xbe]

s_not_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x08,0xe8,0xbe]

s_not_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x08,0xfe,0xbe]

s_not_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x08,0xea,0xbe]

s_not_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x08,0x80,0xbe]

s_not_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x08,0x80,0xbe]

s_not_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x08,0x80,0xbe]

s_not_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x08,0x80,0xbe]

s_not_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x08,0x80,0xbe]

s_not_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x08,0x80,0xbe]

s_not_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x08,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_not_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x08,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_wqm_b32 s0, s1
// GFX10: encoding: [0x01,0x09,0x80,0xbe]

s_wqm_b32 s105, s104
// GFX10: encoding: [0x68,0x09,0xe9,0xbe]

s_wqm_b32 s0, s104
// GFX10: encoding: [0x68,0x09,0x80,0xbe]

s_wqm_b32 s105, s1
// GFX10: encoding: [0x01,0x09,0xe9,0xbe]

s_wqm_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x09,0xfe,0xbe]

s_wqm_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x09,0xff,0xbe]

s_wqm_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x09,0xea,0xbe]

s_wqm_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x09,0xeb,0xbe]

s_wqm_b32 m0, s1
// GFX10: encoding: [0x01,0x09,0xfc,0xbe]

s_wqm_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x09,0x80,0xbe]

s_wqm_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x09,0x80,0xbe]

s_wqm_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x09,0x80,0xbe]

s_wqm_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x09,0x80,0xbe]

s_wqm_b32 s0, m0
// GFX10: encoding: [0x7c,0x09,0x80,0xbe]

s_wqm_b32 s0, 0
// GFX10: encoding: [0x80,0x09,0x80,0xbe]

s_wqm_b32 s0, -1
// GFX10: encoding: [0xc1,0x09,0x80,0xbe]

s_wqm_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x09,0x80,0xbe]

s_wqm_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x09,0x80,0xbe]

s_wqm_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x09,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_wqm_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x09,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_wqm_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x0a,0x80,0xbe]

s_wqm_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x0a,0xe8,0xbe]

s_wqm_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x0a,0x80,0xbe]

s_wqm_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x0a,0xe8,0xbe]

s_wqm_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x0a,0xfe,0xbe]

s_wqm_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x0a,0xea,0xbe]

s_wqm_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x0a,0x80,0xbe]

s_wqm_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x0a,0x80,0xbe]

s_wqm_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x0a,0x80,0xbe]

s_wqm_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x0a,0x80,0xbe]

s_wqm_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x0a,0x80,0xbe]

s_wqm_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x0a,0x80,0xbe]

s_wqm_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x0a,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_wqm_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x0a,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_brev_b32 s0, s1
// GFX10: encoding: [0x01,0x0b,0x80,0xbe]

s_brev_b32 s105, s104
// GFX10: encoding: [0x68,0x0b,0xe9,0xbe]

s_brev_b32 s0, s104
// GFX10: encoding: [0x68,0x0b,0x80,0xbe]

s_brev_b32 s105, s1
// GFX10: encoding: [0x01,0x0b,0xe9,0xbe]

s_brev_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x0b,0xfe,0xbe]

s_brev_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x0b,0xff,0xbe]

s_brev_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x0b,0xea,0xbe]

s_brev_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x0b,0xeb,0xbe]

s_brev_b32 m0, s1
// GFX10: encoding: [0x01,0x0b,0xfc,0xbe]

s_brev_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x0b,0x80,0xbe]

s_brev_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x0b,0x80,0xbe]

s_brev_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x0b,0x80,0xbe]

s_brev_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x0b,0x80,0xbe]

s_brev_b32 s0, m0
// GFX10: encoding: [0x7c,0x0b,0x80,0xbe]

s_brev_b32 s0, 0
// GFX10: encoding: [0x80,0x0b,0x80,0xbe]

s_brev_b32 s0, -1
// GFX10: encoding: [0xc1,0x0b,0x80,0xbe]

s_brev_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x0b,0x80,0xbe]

s_brev_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x0b,0x80,0xbe]

s_brev_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x0b,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_brev_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x0b,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_brev_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x0c,0x80,0xbe]

s_brev_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x0c,0xe8,0xbe]

s_brev_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x0c,0x80,0xbe]

s_brev_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x0c,0xe8,0xbe]

s_brev_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x0c,0xfe,0xbe]

s_brev_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x0c,0xea,0xbe]

s_brev_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x0c,0x80,0xbe]

s_brev_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x0c,0x80,0xbe]

s_brev_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x0c,0x80,0xbe]

s_brev_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x0c,0x80,0xbe]

s_brev_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x0c,0x80,0xbe]

s_brev_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x0c,0x80,0xbe]

s_brev_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x0c,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_brev_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x0c,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt0_i32_b32 s0, s1
// GFX10: encoding: [0x01,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s105, s104
// GFX10: encoding: [0x68,0x0d,0xe9,0xbe]

s_bcnt0_i32_b32 s0, s104
// GFX10: encoding: [0x68,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s105, s1
// GFX10: encoding: [0x01,0x0d,0xe9,0xbe]

s_bcnt0_i32_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x0d,0xfe,0xbe]

s_bcnt0_i32_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x0d,0xff,0xbe]

s_bcnt0_i32_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x0d,0xea,0xbe]

s_bcnt0_i32_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x0d,0xeb,0xbe]

s_bcnt0_i32_b32 m0, s1
// GFX10: encoding: [0x01,0x0d,0xfc,0xbe]

s_bcnt0_i32_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, m0
// GFX10: encoding: [0x7c,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, 0
// GFX10: encoding: [0x80,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, -1
// GFX10: encoding: [0xc1,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x0d,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt0_i32_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x0d,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt0_i32_b64 s0, s[2:3]
// GFX10: encoding: [0x02,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s105, s[102:103]
// GFX10: encoding: [0x66,0x0e,0xe9,0xbe]

s_bcnt0_i32_b64 s0, s[102:103]
// GFX10: encoding: [0x66,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s105, s[2:3]
// GFX10: encoding: [0x02,0x0e,0xe9,0xbe]

s_bcnt0_i32_b64 exec_lo, s[2:3]
// GFX10: encoding: [0x02,0x0e,0xfe,0xbe]

s_bcnt0_i32_b64 exec_hi, s[2:3]
// GFX10: encoding: [0x02,0x0e,0xff,0xbe]

s_bcnt0_i32_b64 vcc_lo, s[2:3]
// GFX10: encoding: [0x02,0x0e,0xea,0xbe]

s_bcnt0_i32_b64 vcc_hi, s[2:3]
// GFX10: encoding: [0x02,0x0e,0xeb,0xbe]

s_bcnt0_i32_b64 m0, s[2:3]
// GFX10: encoding: [0x02,0x0e,0xfc,0xbe]

s_bcnt0_i32_b64 s0, exec
// GFX10: encoding: [0x7e,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s0, vcc
// GFX10: encoding: [0x6a,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s0, 0
// GFX10: encoding: [0x80,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s0, -1
// GFX10: encoding: [0xc1,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s0, 0.5
// GFX10: encoding: [0xf0,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s0, -4.0
// GFX10: encoding: [0xf7,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s0, 0x3f717273
// GFX10: encoding: [0xff,0x0e,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt0_i32_b64 s0, 0xaf123456
// GFX10: encoding: [0xff,0x0e,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt1_i32_b32 s0, s1
// GFX10: encoding: [0x01,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s105, s104
// GFX10: encoding: [0x68,0x0f,0xe9,0xbe]

s_bcnt1_i32_b32 s0, s104
// GFX10: encoding: [0x68,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s105, s1
// GFX10: encoding: [0x01,0x0f,0xe9,0xbe]

s_bcnt1_i32_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x0f,0xfe,0xbe]

s_bcnt1_i32_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x0f,0xff,0xbe]

s_bcnt1_i32_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x0f,0xea,0xbe]

s_bcnt1_i32_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x0f,0xeb,0xbe]

s_bcnt1_i32_b32 m0, s1
// GFX10: encoding: [0x01,0x0f,0xfc,0xbe]

s_bcnt1_i32_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, m0
// GFX10: encoding: [0x7c,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, 0
// GFX10: encoding: [0x80,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, -1
// GFX10: encoding: [0xc1,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x0f,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt1_i32_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x0f,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt1_i32_b64 s0, s[2:3]
// GFX10: encoding: [0x02,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s105, s[102:103]
// GFX10: encoding: [0x66,0x10,0xe9,0xbe]

s_bcnt1_i32_b64 s0, s[102:103]
// GFX10: encoding: [0x66,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s105, s[2:3]
// GFX10: encoding: [0x02,0x10,0xe9,0xbe]

s_bcnt1_i32_b64 exec_lo, s[2:3]
// GFX10: encoding: [0x02,0x10,0xfe,0xbe]

s_bcnt1_i32_b64 exec_hi, s[2:3]
// GFX10: encoding: [0x02,0x10,0xff,0xbe]

s_bcnt1_i32_b64 vcc_lo, s[2:3]
// GFX10: encoding: [0x02,0x10,0xea,0xbe]

s_bcnt1_i32_b64 vcc_hi, s[2:3]
// GFX10: encoding: [0x02,0x10,0xeb,0xbe]

s_bcnt1_i32_b64 m0, s[2:3]
// GFX10: encoding: [0x02,0x10,0xfc,0xbe]

s_bcnt1_i32_b64 s0, exec
// GFX10: encoding: [0x7e,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s0, vcc
// GFX10: encoding: [0x6a,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s0, 0
// GFX10: encoding: [0x80,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s0, -1
// GFX10: encoding: [0xc1,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s0, 0.5
// GFX10: encoding: [0xf0,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s0, -4.0
// GFX10: encoding: [0xf7,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s0, 0x3f717273
// GFX10: encoding: [0xff,0x10,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt1_i32_b64 s0, 0xaf123456
// GFX10: encoding: [0xff,0x10,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_ff0_i32_b32 s0, s1
// GFX10: encoding: [0x01,0x11,0x80,0xbe]

s_ff0_i32_b32 s105, s104
// GFX10: encoding: [0x68,0x11,0xe9,0xbe]

s_ff0_i32_b32 s0, s104
// GFX10: encoding: [0x68,0x11,0x80,0xbe]

s_ff0_i32_b32 s105, s1
// GFX10: encoding: [0x01,0x11,0xe9,0xbe]

s_ff0_i32_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x11,0xfe,0xbe]

s_ff0_i32_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x11,0xff,0xbe]

s_ff0_i32_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x11,0xea,0xbe]

s_ff0_i32_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x11,0xeb,0xbe]

s_ff0_i32_b32 m0, s1
// GFX10: encoding: [0x01,0x11,0xfc,0xbe]

s_ff0_i32_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, m0
// GFX10: encoding: [0x7c,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, 0
// GFX10: encoding: [0x80,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, -1
// GFX10: encoding: [0xc1,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x11,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_ff0_i32_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x11,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_ff0_i32_b64 s0, s[2:3]
// GFX10: encoding: [0x02,0x12,0x80,0xbe]

s_ff0_i32_b64 s105, s[102:103]
// GFX10: encoding: [0x66,0x12,0xe9,0xbe]

s_ff0_i32_b64 s0, s[102:103]
// GFX10: encoding: [0x66,0x12,0x80,0xbe]

s_ff0_i32_b64 s105, s[2:3]
// GFX10: encoding: [0x02,0x12,0xe9,0xbe]

s_ff0_i32_b64 exec_lo, s[2:3]
// GFX10: encoding: [0x02,0x12,0xfe,0xbe]

s_ff0_i32_b64 exec_hi, s[2:3]
// GFX10: encoding: [0x02,0x12,0xff,0xbe]

s_ff0_i32_b64 vcc_lo, s[2:3]
// GFX10: encoding: [0x02,0x12,0xea,0xbe]

s_ff0_i32_b64 vcc_hi, s[2:3]
// GFX10: encoding: [0x02,0x12,0xeb,0xbe]

s_ff0_i32_b64 m0, s[2:3]
// GFX10: encoding: [0x02,0x12,0xfc,0xbe]

s_ff0_i32_b64 s0, exec
// GFX10: encoding: [0x7e,0x12,0x80,0xbe]

s_ff0_i32_b64 s0, vcc
// GFX10: encoding: [0x6a,0x12,0x80,0xbe]

s_ff0_i32_b64 s0, 0
// GFX10: encoding: [0x80,0x12,0x80,0xbe]

s_ff0_i32_b64 s0, -1
// GFX10: encoding: [0xc1,0x12,0x80,0xbe]

s_ff0_i32_b64 s0, 0.5
// GFX10: encoding: [0xf0,0x12,0x80,0xbe]

s_ff0_i32_b64 s0, -4.0
// GFX10: encoding: [0xf7,0x12,0x80,0xbe]

s_ff0_i32_b64 s0, 0x3f717273
// GFX10: encoding: [0xff,0x12,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_ff0_i32_b64 s0, 0xaf123456
// GFX10: encoding: [0xff,0x12,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_ff1_i32_b32 s0, s1
// GFX10: encoding: [0x01,0x13,0x80,0xbe]

s_ff1_i32_b32 s105, s104
// GFX10: encoding: [0x68,0x13,0xe9,0xbe]

s_ff1_i32_b32 s0, s104
// GFX10: encoding: [0x68,0x13,0x80,0xbe]

s_ff1_i32_b32 s105, s1
// GFX10: encoding: [0x01,0x13,0xe9,0xbe]

s_ff1_i32_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x13,0xfe,0xbe]

s_ff1_i32_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x13,0xff,0xbe]

s_ff1_i32_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x13,0xea,0xbe]

s_ff1_i32_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x13,0xeb,0xbe]

s_ff1_i32_b32 m0, s1
// GFX10: encoding: [0x01,0x13,0xfc,0xbe]

s_ff1_i32_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, m0
// GFX10: encoding: [0x7c,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, 0
// GFX10: encoding: [0x80,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, -1
// GFX10: encoding: [0xc1,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x13,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_ff1_i32_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x13,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_ff1_i32_b64 s0, s[2:3]
// GFX10: encoding: [0x02,0x14,0x80,0xbe]

s_ff1_i32_b64 s105, s[102:103]
// GFX10: encoding: [0x66,0x14,0xe9,0xbe]

s_ff1_i32_b64 s0, s[102:103]
// GFX10: encoding: [0x66,0x14,0x80,0xbe]

s_ff1_i32_b64 s105, s[2:3]
// GFX10: encoding: [0x02,0x14,0xe9,0xbe]

s_ff1_i32_b64 exec_lo, s[2:3]
// GFX10: encoding: [0x02,0x14,0xfe,0xbe]

s_ff1_i32_b64 exec_hi, s[2:3]
// GFX10: encoding: [0x02,0x14,0xff,0xbe]

s_ff1_i32_b64 vcc_lo, s[2:3]
// GFX10: encoding: [0x02,0x14,0xea,0xbe]

s_ff1_i32_b64 vcc_hi, s[2:3]
// GFX10: encoding: [0x02,0x14,0xeb,0xbe]

s_ff1_i32_b64 m0, s[2:3]
// GFX10: encoding: [0x02,0x14,0xfc,0xbe]

s_ff1_i32_b64 s0, exec
// GFX10: encoding: [0x7e,0x14,0x80,0xbe]

s_ff1_i32_b64 s0, vcc
// GFX10: encoding: [0x6a,0x14,0x80,0xbe]

s_ff1_i32_b64 s0, 0
// GFX10: encoding: [0x80,0x14,0x80,0xbe]

s_ff1_i32_b64 s0, -1
// GFX10: encoding: [0xc1,0x14,0x80,0xbe]

s_ff1_i32_b64 s0, 0.5
// GFX10: encoding: [0xf0,0x14,0x80,0xbe]

s_ff1_i32_b64 s0, -4.0
// GFX10: encoding: [0xf7,0x14,0x80,0xbe]

s_ff1_i32_b64 s0, 0x3f717273
// GFX10: encoding: [0xff,0x14,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_ff1_i32_b64 s0, 0xaf123456
// GFX10: encoding: [0xff,0x14,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_b32 s0, s1
// GFX10: encoding: [0x01,0x15,0x80,0xbe]

s_flbit_i32_b32 s105, s104
// GFX10: encoding: [0x68,0x15,0xe9,0xbe]

s_flbit_i32_b32 s0, s104
// GFX10: encoding: [0x68,0x15,0x80,0xbe]

s_flbit_i32_b32 s105, s1
// GFX10: encoding: [0x01,0x15,0xe9,0xbe]

s_flbit_i32_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x15,0xfe,0xbe]

s_flbit_i32_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x15,0xff,0xbe]

s_flbit_i32_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x15,0xea,0xbe]

s_flbit_i32_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x15,0xeb,0xbe]

s_flbit_i32_b32 m0, s1
// GFX10: encoding: [0x01,0x15,0xfc,0xbe]

s_flbit_i32_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, m0
// GFX10: encoding: [0x7c,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, 0
// GFX10: encoding: [0x80,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, -1
// GFX10: encoding: [0xc1,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x15,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x15,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_b64 s0, s[2:3]
// GFX10: encoding: [0x02,0x16,0x80,0xbe]

s_flbit_i32_b64 s105, s[102:103]
// GFX10: encoding: [0x66,0x16,0xe9,0xbe]

s_flbit_i32_b64 s0, s[102:103]
// GFX10: encoding: [0x66,0x16,0x80,0xbe]

s_flbit_i32_b64 s105, s[2:3]
// GFX10: encoding: [0x02,0x16,0xe9,0xbe]

s_flbit_i32_b64 exec_lo, s[2:3]
// GFX10: encoding: [0x02,0x16,0xfe,0xbe]

s_flbit_i32_b64 exec_hi, s[2:3]
// GFX10: encoding: [0x02,0x16,0xff,0xbe]

s_flbit_i32_b64 vcc_lo, s[2:3]
// GFX10: encoding: [0x02,0x16,0xea,0xbe]

s_flbit_i32_b64 vcc_hi, s[2:3]
// GFX10: encoding: [0x02,0x16,0xeb,0xbe]

s_flbit_i32_b64 m0, s[2:3]
// GFX10: encoding: [0x02,0x16,0xfc,0xbe]

s_flbit_i32_b64 s0, exec
// GFX10: encoding: [0x7e,0x16,0x80,0xbe]

s_flbit_i32_b64 s0, vcc
// GFX10: encoding: [0x6a,0x16,0x80,0xbe]

s_flbit_i32_b64 s0, 0
// GFX10: encoding: [0x80,0x16,0x80,0xbe]

s_flbit_i32_b64 s0, -1
// GFX10: encoding: [0xc1,0x16,0x80,0xbe]

s_flbit_i32_b64 s0, 0.5
// GFX10: encoding: [0xf0,0x16,0x80,0xbe]

s_flbit_i32_b64 s0, -4.0
// GFX10: encoding: [0xf7,0x16,0x80,0xbe]

s_flbit_i32_b64 s0, 0x3f717273
// GFX10: encoding: [0xff,0x16,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_b64 s0, 0xaf123456
// GFX10: encoding: [0xff,0x16,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32 s0, s1
// GFX10: encoding: [0x01,0x17,0x80,0xbe]

s_flbit_i32 s105, s104
// GFX10: encoding: [0x68,0x17,0xe9,0xbe]

s_flbit_i32 s0, s104
// GFX10: encoding: [0x68,0x17,0x80,0xbe]

s_flbit_i32 s105, s1
// GFX10: encoding: [0x01,0x17,0xe9,0xbe]

s_flbit_i32 exec_lo, s1
// GFX10: encoding: [0x01,0x17,0xfe,0xbe]

s_flbit_i32 exec_hi, s1
// GFX10: encoding: [0x01,0x17,0xff,0xbe]

s_flbit_i32 vcc_lo, s1
// GFX10: encoding: [0x01,0x17,0xea,0xbe]

s_flbit_i32 vcc_hi, s1
// GFX10: encoding: [0x01,0x17,0xeb,0xbe]

s_flbit_i32 m0, s1
// GFX10: encoding: [0x01,0x17,0xfc,0xbe]

s_flbit_i32 s0, exec_lo
// GFX10: encoding: [0x7e,0x17,0x80,0xbe]

s_flbit_i32 s0, exec_hi
// GFX10: encoding: [0x7f,0x17,0x80,0xbe]

s_flbit_i32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x17,0x80,0xbe]

s_flbit_i32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x17,0x80,0xbe]

s_flbit_i32 s0, m0
// GFX10: encoding: [0x7c,0x17,0x80,0xbe]

s_flbit_i32 s0, 0
// GFX10: encoding: [0x80,0x17,0x80,0xbe]

s_flbit_i32 s0, -1
// GFX10: encoding: [0xc1,0x17,0x80,0xbe]

s_flbit_i32 s0, 0.5
// GFX10: encoding: [0xf0,0x17,0x80,0xbe]

s_flbit_i32 s0, -4.0
// GFX10: encoding: [0xf7,0x17,0x80,0xbe]

s_flbit_i32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x17,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x17,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_i64 s0, s[2:3]
// GFX10: encoding: [0x02,0x18,0x80,0xbe]

s_flbit_i32_i64 s105, s[102:103]
// GFX10: encoding: [0x66,0x18,0xe9,0xbe]

s_flbit_i32_i64 s0, s[102:103]
// GFX10: encoding: [0x66,0x18,0x80,0xbe]

s_flbit_i32_i64 s105, s[2:3]
// GFX10: encoding: [0x02,0x18,0xe9,0xbe]

s_flbit_i32_i64 exec_lo, s[2:3]
// GFX10: encoding: [0x02,0x18,0xfe,0xbe]

s_flbit_i32_i64 exec_hi, s[2:3]
// GFX10: encoding: [0x02,0x18,0xff,0xbe]

s_flbit_i32_i64 vcc_lo, s[2:3]
// GFX10: encoding: [0x02,0x18,0xea,0xbe]

s_flbit_i32_i64 vcc_hi, s[2:3]
// GFX10: encoding: [0x02,0x18,0xeb,0xbe]

s_flbit_i32_i64 m0, s[2:3]
// GFX10: encoding: [0x02,0x18,0xfc,0xbe]

s_flbit_i32_i64 s0, exec
// GFX10: encoding: [0x7e,0x18,0x80,0xbe]

s_flbit_i32_i64 s0, vcc
// GFX10: encoding: [0x6a,0x18,0x80,0xbe]

s_flbit_i32_i64 s0, 0
// GFX10: encoding: [0x80,0x18,0x80,0xbe]

s_flbit_i32_i64 s0, -1
// GFX10: encoding: [0xc1,0x18,0x80,0xbe]

s_flbit_i32_i64 s0, 0.5
// GFX10: encoding: [0xf0,0x18,0x80,0xbe]

s_flbit_i32_i64 s0, -4.0
// GFX10: encoding: [0xf7,0x18,0x80,0xbe]

s_flbit_i32_i64 s0, 0x3f717273
// GFX10: encoding: [0xff,0x18,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_i64 s0, 0xaf123456
// GFX10: encoding: [0xff,0x18,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_sext_i32_i8 s0, s1
// GFX10: encoding: [0x01,0x19,0x80,0xbe]

s_sext_i32_i8 s105, s104
// GFX10: encoding: [0x68,0x19,0xe9,0xbe]

s_sext_i32_i8 s0, s104
// GFX10: encoding: [0x68,0x19,0x80,0xbe]

s_sext_i32_i8 s105, s1
// GFX10: encoding: [0x01,0x19,0xe9,0xbe]

s_sext_i32_i8 exec_lo, s1
// GFX10: encoding: [0x01,0x19,0xfe,0xbe]

s_sext_i32_i8 exec_hi, s1
// GFX10: encoding: [0x01,0x19,0xff,0xbe]

s_sext_i32_i8 vcc_lo, s1
// GFX10: encoding: [0x01,0x19,0xea,0xbe]

s_sext_i32_i8 vcc_hi, s1
// GFX10: encoding: [0x01,0x19,0xeb,0xbe]

s_sext_i32_i8 m0, s1
// GFX10: encoding: [0x01,0x19,0xfc,0xbe]

s_sext_i32_i8 s0, exec_lo
// GFX10: encoding: [0x7e,0x19,0x80,0xbe]

s_sext_i32_i8 s0, exec_hi
// GFX10: encoding: [0x7f,0x19,0x80,0xbe]

s_sext_i32_i8 s0, vcc_lo
// GFX10: encoding: [0x6a,0x19,0x80,0xbe]

s_sext_i32_i8 s0, vcc_hi
// GFX10: encoding: [0x6b,0x19,0x80,0xbe]

s_sext_i32_i8 s0, m0
// GFX10: encoding: [0x7c,0x19,0x80,0xbe]

s_sext_i32_i8 s0, 0
// GFX10: encoding: [0x80,0x19,0x80,0xbe]

s_sext_i32_i8 s0, -1
// GFX10: encoding: [0xc1,0x19,0x80,0xbe]

s_sext_i32_i8 s0, 0.5
// GFX10: encoding: [0xf0,0x19,0x80,0xbe]

s_sext_i32_i8 s0, -4.0
// GFX10: encoding: [0xf7,0x19,0x80,0xbe]

s_sext_i32_i8 s0, 0x3f717273
// GFX10: encoding: [0xff,0x19,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_sext_i32_i8 s0, 0xaf123456
// GFX10: encoding: [0xff,0x19,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_sext_i32_i16 s0, s1
// GFX10: encoding: [0x01,0x1a,0x80,0xbe]

s_sext_i32_i16 s105, s104
// GFX10: encoding: [0x68,0x1a,0xe9,0xbe]

s_sext_i32_i16 s0, s104
// GFX10: encoding: [0x68,0x1a,0x80,0xbe]

s_sext_i32_i16 s105, s1
// GFX10: encoding: [0x01,0x1a,0xe9,0xbe]

s_sext_i32_i16 exec_lo, s1
// GFX10: encoding: [0x01,0x1a,0xfe,0xbe]

s_sext_i32_i16 exec_hi, s1
// GFX10: encoding: [0x01,0x1a,0xff,0xbe]

s_sext_i32_i16 vcc_lo, s1
// GFX10: encoding: [0x01,0x1a,0xea,0xbe]

s_sext_i32_i16 vcc_hi, s1
// GFX10: encoding: [0x01,0x1a,0xeb,0xbe]

s_sext_i32_i16 m0, s1
// GFX10: encoding: [0x01,0x1a,0xfc,0xbe]

s_sext_i32_i16 s0, exec_lo
// GFX10: encoding: [0x7e,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, exec_hi
// GFX10: encoding: [0x7f,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, vcc_lo
// GFX10: encoding: [0x6a,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, vcc_hi
// GFX10: encoding: [0x6b,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, m0
// GFX10: encoding: [0x7c,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, 0
// GFX10: encoding: [0x80,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, -1
// GFX10: encoding: [0xc1,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, 0.5
// GFX10: encoding: [0xf0,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, -4.0
// GFX10: encoding: [0xf7,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, 0x3f717273
// GFX10: encoding: [0xff,0x1a,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_sext_i32_i16 s0, 0xaf123456
// GFX10: encoding: [0xff,0x1a,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitset0_b32 s0, s1
// GFX10: encoding: [0x01,0x1b,0x80,0xbe]

s_bitset0_b32 s105, s104
// GFX10: encoding: [0x68,0x1b,0xe9,0xbe]

s_bitset0_b32 s0, s104
// GFX10: encoding: [0x68,0x1b,0x80,0xbe]

s_bitset0_b32 s105, s1
// GFX10: encoding: [0x01,0x1b,0xe9,0xbe]

s_bitset0_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x1b,0xfe,0xbe]

s_bitset0_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x1b,0xff,0xbe]

s_bitset0_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x1b,0xea,0xbe]

s_bitset0_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x1b,0xeb,0xbe]

s_bitset0_b32 m0, s1
// GFX10: encoding: [0x01,0x1b,0xfc,0xbe]

s_bitset0_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x1b,0x80,0xbe]

s_bitset0_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x1b,0x80,0xbe]

s_bitset0_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x1b,0x80,0xbe]

s_bitset0_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x1b,0x80,0xbe]

s_bitset0_b32 s0, m0
// GFX10: encoding: [0x7c,0x1b,0x80,0xbe]

s_bitset0_b32 s0, 0
// GFX10: encoding: [0x80,0x1b,0x80,0xbe]

s_bitset0_b32 s0, -1
// GFX10: encoding: [0xc1,0x1b,0x80,0xbe]

s_bitset0_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x1b,0x80,0xbe]

s_bitset0_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x1b,0x80,0xbe]

s_bitset0_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x1b,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitset0_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x1b,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitset0_b64 s[0:1], s2
// GFX10: encoding: [0x02,0x1c,0x80,0xbe]

s_bitset0_b64 s[104:105], s102
// GFX10: encoding: [0x66,0x1c,0xe8,0xbe]

s_bitset0_b64 s[0:1], s102
// GFX10: encoding: [0x66,0x1c,0x80,0xbe]

s_bitset0_b64 s[104:105], s2
// GFX10: encoding: [0x02,0x1c,0xe8,0xbe]

s_bitset0_b64 exec, s2
// GFX10: encoding: [0x02,0x1c,0xfe,0xbe]

s_bitset0_b64 vcc, s2
// GFX10: encoding: [0x02,0x1c,0xea,0xbe]

s_bitset0_b64 s[0:1], exec_lo
// GFX10: encoding: [0x7e,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], exec_hi
// GFX10: encoding: [0x7f,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], vcc_lo
// GFX10: encoding: [0x6a,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], vcc_hi
// GFX10: encoding: [0x6b,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], m0
// GFX10: encoding: [0x7c,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x1c,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitset0_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x1c,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitset1_b32 s0, s1
// GFX10: encoding: [0x01,0x1d,0x80,0xbe]

s_bitset1_b32 s105, s104
// GFX10: encoding: [0x68,0x1d,0xe9,0xbe]

s_bitset1_b32 s0, s104
// GFX10: encoding: [0x68,0x1d,0x80,0xbe]

s_bitset1_b32 s105, s1
// GFX10: encoding: [0x01,0x1d,0xe9,0xbe]

s_bitset1_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x1d,0xfe,0xbe]

s_bitset1_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x1d,0xff,0xbe]

s_bitset1_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x1d,0xea,0xbe]

s_bitset1_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x1d,0xeb,0xbe]

s_bitset1_b32 m0, s1
// GFX10: encoding: [0x01,0x1d,0xfc,0xbe]

s_bitset1_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x1d,0x80,0xbe]

s_bitset1_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x1d,0x80,0xbe]

s_bitset1_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x1d,0x80,0xbe]

s_bitset1_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x1d,0x80,0xbe]

s_bitset1_b32 s0, m0
// GFX10: encoding: [0x7c,0x1d,0x80,0xbe]

s_bitset1_b32 s0, 0
// GFX10: encoding: [0x80,0x1d,0x80,0xbe]

s_bitset1_b32 s0, -1
// GFX10: encoding: [0xc1,0x1d,0x80,0xbe]

s_bitset1_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x1d,0x80,0xbe]

s_bitset1_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x1d,0x80,0xbe]

s_bitset1_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x1d,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitset1_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x1d,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitset1_b64 s[0:1], s2
// GFX10: encoding: [0x02,0x1e,0x80,0xbe]

s_bitset1_b64 s[104:105], s102
// GFX10: encoding: [0x66,0x1e,0xe8,0xbe]

s_bitset1_b64 s[0:1], s102
// GFX10: encoding: [0x66,0x1e,0x80,0xbe]

s_bitset1_b64 s[104:105], s2
// GFX10: encoding: [0x02,0x1e,0xe8,0xbe]

s_bitset1_b64 exec, s2
// GFX10: encoding: [0x02,0x1e,0xfe,0xbe]

s_bitset1_b64 vcc, s2
// GFX10: encoding: [0x02,0x1e,0xea,0xbe]

s_bitset1_b64 s[0:1], exec_lo
// GFX10: encoding: [0x7e,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], exec_hi
// GFX10: encoding: [0x7f,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], vcc_lo
// GFX10: encoding: [0x6a,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], vcc_hi
// GFX10: encoding: [0x6b,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], m0
// GFX10: encoding: [0x7c,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x1e,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitset1_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x1e,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_getpc_b64 s[0:1]
// GFX10: encoding: [0x00,0x1f,0x80,0xbe]

s_getpc_b64 s[104:105]
// GFX10: encoding: [0x00,0x1f,0xe8,0xbe]

s_getpc_b64 exec
// GFX10: encoding: [0x00,0x1f,0xfe,0xbe]

s_getpc_b64 vcc
// GFX10: encoding: [0x00,0x1f,0xea,0xbe]

s_setpc_b64 s[0:1]
// GFX10: encoding: [0x00,0x20,0x80,0xbe]

s_setpc_b64 s[104:105]
// GFX10: encoding: [0x68,0x20,0x80,0xbe]

s_setpc_b64 vcc
// GFX10: encoding: [0x6a,0x20,0x80,0xbe]

s_swappc_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x21,0x80,0xbe]

s_swappc_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x21,0xe8,0xbe]

s_swappc_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x21,0x80,0xbe]

s_swappc_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x21,0xe8,0xbe]

s_swappc_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x21,0xea,0xbe]

s_swappc_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x21,0x80,0xbe]

s_rfe_b64 s[0:1]
// GFX10: encoding: [0x00,0x22,0x80,0xbe]

s_rfe_b64 s[104:105]
// GFX10: encoding: [0x68,0x22,0x80,0xbe]

s_rfe_b64 vcc
// GFX10: encoding: [0x6a,0x22,0x80,0xbe]

s_and_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x24,0x80,0xbe]

s_and_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x24,0xe8,0xbe]

s_and_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x24,0x80,0xbe]

s_and_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x24,0xe8,0xbe]

s_and_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x24,0xfe,0xbe]

s_and_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x24,0xea,0xbe]

s_and_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x24,0x80,0xbe]

s_and_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x24,0x80,0xbe]

s_and_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x24,0x80,0xbe]

s_and_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x24,0x80,0xbe]

s_and_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x24,0x80,0xbe]

s_and_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x24,0x80,0xbe]

s_and_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x24,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_and_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x24,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_or_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x25,0x80,0xbe]

s_or_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x25,0xe8,0xbe]

s_or_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x25,0x80,0xbe]

s_or_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x25,0xe8,0xbe]

s_or_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x25,0xfe,0xbe]

s_or_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x25,0xea,0xbe]

s_or_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x25,0x80,0xbe]

s_or_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x25,0x80,0xbe]

s_or_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x25,0x80,0xbe]

s_or_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x25,0x80,0xbe]

s_or_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x25,0x80,0xbe]

s_or_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x25,0x80,0xbe]

s_or_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x25,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_or_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x25,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_xor_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x26,0xe8,0xbe]

s_xor_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x26,0xe8,0xbe]

s_xor_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x26,0xfe,0xbe]

s_xor_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x26,0xea,0xbe]

s_xor_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x26,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_xor_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x26,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x27,0xe8,0xbe]

s_andn2_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x27,0xe8,0xbe]

s_andn2_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x27,0xfe,0xbe]

s_andn2_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x27,0xea,0xbe]

s_andn2_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x27,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x27,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_orn2_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x28,0xe8,0xbe]

s_orn2_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x28,0xe8,0xbe]

s_orn2_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x28,0xfe,0xbe]

s_orn2_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x28,0xea,0xbe]

s_orn2_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x28,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_orn2_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x28,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_nand_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x29,0xe8,0xbe]

s_nand_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x29,0xe8,0xbe]

s_nand_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x29,0xfe,0xbe]

s_nand_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x29,0xea,0xbe]

s_nand_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x29,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_nand_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x29,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_nor_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x2a,0xe8,0xbe]

s_nor_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x2a,0xe8,0xbe]

s_nor_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x2a,0xfe,0xbe]

s_nor_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x2a,0xea,0xbe]

s_nor_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x2a,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_nor_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x2a,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_xnor_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x2b,0xe8,0xbe]

s_xnor_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x2b,0xe8,0xbe]

s_xnor_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x2b,0xfe,0xbe]

s_xnor_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x2b,0xea,0xbe]

s_xnor_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x2b,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_xnor_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x2b,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_quadmask_b32 s0, s1
// GFX10: encoding: [0x01,0x2c,0x80,0xbe]

s_quadmask_b32 s105, s104
// GFX10: encoding: [0x68,0x2c,0xe9,0xbe]

s_quadmask_b32 s0, s104
// GFX10: encoding: [0x68,0x2c,0x80,0xbe]

s_quadmask_b32 s105, s1
// GFX10: encoding: [0x01,0x2c,0xe9,0xbe]

s_quadmask_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x2c,0xfe,0xbe]

s_quadmask_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x2c,0xff,0xbe]

s_quadmask_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x2c,0xea,0xbe]

s_quadmask_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x2c,0xeb,0xbe]

s_quadmask_b32 m0, s1
// GFX10: encoding: [0x01,0x2c,0xfc,0xbe]

s_quadmask_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x2c,0x80,0xbe]

s_quadmask_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x2c,0x80,0xbe]

s_quadmask_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x2c,0x80,0xbe]

s_quadmask_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x2c,0x80,0xbe]

s_quadmask_b32 s0, m0
// GFX10: encoding: [0x7c,0x2c,0x80,0xbe]

s_quadmask_b32 s0, 0
// GFX10: encoding: [0x80,0x2c,0x80,0xbe]

s_quadmask_b32 s0, -1
// GFX10: encoding: [0xc1,0x2c,0x80,0xbe]

s_quadmask_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x2c,0x80,0xbe]

s_quadmask_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x2c,0x80,0xbe]

s_quadmask_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x2c,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_quadmask_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x2c,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_quadmask_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x2d,0x80,0xbe]

s_quadmask_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x2d,0xe8,0xbe]

s_quadmask_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x2d,0x80,0xbe]

s_quadmask_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x2d,0xe8,0xbe]

s_quadmask_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x2d,0xfe,0xbe]

s_quadmask_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x2d,0xea,0xbe]

s_quadmask_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x2d,0x80,0xbe]

s_quadmask_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x2d,0x80,0xbe]

s_quadmask_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x2d,0x80,0xbe]

s_quadmask_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x2d,0x80,0xbe]

s_quadmask_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x2d,0x80,0xbe]

s_quadmask_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x2d,0x80,0xbe]

s_quadmask_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x2d,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_quadmask_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x2d,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_movrels_b32 s0, s1
// GFX10: encoding: [0x01,0x2e,0x80,0xbe]

s_movrels_b32 s105, s104
// GFX10: encoding: [0x68,0x2e,0xe9,0xbe]

s_movrels_b32 s0, s104
// GFX10: encoding: [0x68,0x2e,0x80,0xbe]

s_movrels_b32 s105, s1
// GFX10: encoding: [0x01,0x2e,0xe9,0xbe]

s_movrels_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x2e,0xfe,0xbe]

s_movrels_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x2e,0xff,0xbe]

s_movrels_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x2e,0xea,0xbe]

s_movrels_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x2e,0xeb,0xbe]

s_movrels_b32 m0, s1
// GFX10: encoding: [0x01,0x2e,0xfc,0xbe]

s_movrels_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x2e,0x80,0xbe]

s_movrels_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x2e,0x80,0xbe]

s_movrels_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x2f,0x80,0xbe]

s_movrels_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x2f,0xe8,0xbe]

s_movrels_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x2f,0x80,0xbe]

s_movrels_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x2f,0xe8,0xbe]

s_movrels_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x2f,0xfe,0xbe]

s_movrels_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x2f,0xea,0xbe]

s_movrels_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x2f,0x80,0xbe]

s_movreld_b32 s0, s1
// GFX10: encoding: [0x01,0x30,0x80,0xbe]

s_movreld_b32 s105, s104
// GFX10: encoding: [0x68,0x30,0xe9,0xbe]

s_movreld_b32 s0, s104
// GFX10: encoding: [0x68,0x30,0x80,0xbe]

s_movreld_b32 s105, s1
// GFX10: encoding: [0x01,0x30,0xe9,0xbe]

s_movreld_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x30,0xea,0xbe]

s_movreld_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x30,0xeb,0xbe]

s_movreld_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x30,0x80,0xbe]

s_movreld_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x30,0x80,0xbe]

s_movreld_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x30,0x80,0xbe]

s_movreld_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x30,0x80,0xbe]

s_movreld_b32 s0, m0
// GFX10: encoding: [0x7c,0x30,0x80,0xbe]

s_movreld_b32 s0, 0
// GFX10: encoding: [0x80,0x30,0x80,0xbe]

s_movreld_b32 s0, -1
// GFX10: encoding: [0xc1,0x30,0x80,0xbe]

s_movreld_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x30,0x80,0xbe]

s_movreld_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x30,0x80,0xbe]

s_movreld_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x30,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_movreld_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x30,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_movreld_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x31,0x80,0xbe]

s_movreld_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x31,0xe8,0xbe]

s_movreld_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x31,0x80,0xbe]

s_movreld_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x31,0xe8,0xbe]

s_movreld_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x31,0xea,0xbe]

s_movreld_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x31,0x80,0xbe]

s_movreld_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x31,0x80,0xbe]

s_movreld_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x31,0x80,0xbe]

s_movreld_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x31,0x80,0xbe]

s_movreld_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x31,0x80,0xbe]

s_movreld_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x31,0x80,0xbe]

s_movreld_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x31,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_movreld_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x31,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_abs_i32 s0, s1
// GFX10: encoding: [0x01,0x34,0x80,0xbe]

s_abs_i32 s105, s104
// GFX10: encoding: [0x68,0x34,0xe9,0xbe]

s_abs_i32 s0, s104
// GFX10: encoding: [0x68,0x34,0x80,0xbe]

s_abs_i32 s105, s1
// GFX10: encoding: [0x01,0x34,0xe9,0xbe]

s_abs_i32 exec_lo, s1
// GFX10: encoding: [0x01,0x34,0xfe,0xbe]

s_abs_i32 exec_hi, s1
// GFX10: encoding: [0x01,0x34,0xff,0xbe]

s_abs_i32 vcc_lo, s1
// GFX10: encoding: [0x01,0x34,0xea,0xbe]

s_abs_i32 vcc_hi, s1
// GFX10: encoding: [0x01,0x34,0xeb,0xbe]

s_abs_i32 m0, s1
// GFX10: encoding: [0x01,0x34,0xfc,0xbe]

s_abs_i32 s0, exec_lo
// GFX10: encoding: [0x7e,0x34,0x80,0xbe]

s_abs_i32 s0, exec_hi
// GFX10: encoding: [0x7f,0x34,0x80,0xbe]

s_abs_i32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x34,0x80,0xbe]

s_abs_i32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x34,0x80,0xbe]

s_abs_i32 s0, m0
// GFX10: encoding: [0x7c,0x34,0x80,0xbe]

s_abs_i32 s0, 0
// GFX10: encoding: [0x80,0x34,0x80,0xbe]

s_abs_i32 s0, -1
// GFX10: encoding: [0xc1,0x34,0x80,0xbe]

s_abs_i32 s0, 0.5
// GFX10: encoding: [0xf0,0x34,0x80,0xbe]

s_abs_i32 s0, -4.0
// GFX10: encoding: [0xf7,0x34,0x80,0xbe]

s_abs_i32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x34,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_abs_i32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x34,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x37,0xe8,0xbe]

s_andn1_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x37,0xe8,0xbe]

s_andn1_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x37,0xfe,0xbe]

s_andn1_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x37,0xea,0xbe]

s_andn1_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x37,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x37,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_orn1_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x38,0xe8,0xbe]

s_orn1_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x38,0xe8,0xbe]

s_orn1_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x38,0xfe,0xbe]

s_orn1_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x38,0xea,0xbe]

s_orn1_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x38,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_orn1_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x38,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_wrexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x39,0xe8,0xbe]

s_andn1_wrexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x39,0xe8,0xbe]

s_andn1_wrexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x39,0xfe,0xbe]

s_andn1_wrexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x39,0xea,0xbe]

s_andn1_wrexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x39,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_wrexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x39,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_wrexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x3a,0xe8,0xbe]

s_andn2_wrexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x3a,0xe8,0xbe]

s_andn2_wrexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x3a,0xfe,0xbe]

s_andn2_wrexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x3a,0xea,0xbe]

s_andn2_wrexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x3a,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_wrexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x3a,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitreplicate_b64_b32 s[0:1], s2
// GFX10: encoding: [0x02,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[104:105], s102
// GFX10: encoding: [0x66,0x3b,0xe8,0xbe]

s_bitreplicate_b64_b32 s[0:1], s102
// GFX10: encoding: [0x66,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[104:105], s2
// GFX10: encoding: [0x02,0x3b,0xe8,0xbe]

s_bitreplicate_b64_b32 exec, s2
// GFX10: encoding: [0x02,0x3b,0xfe,0xbe]

s_bitreplicate_b64_b32 vcc, s2
// GFX10: encoding: [0x02,0x3b,0xea,0xbe]

s_bitreplicate_b64_b32 s[0:1], exec_lo
// GFX10: encoding: [0x7e,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], exec_hi
// GFX10: encoding: [0x7f,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], vcc_lo
// GFX10: encoding: [0x6a,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], vcc_hi
// GFX10: encoding: [0x6b,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], m0
// GFX10: encoding: [0x7c,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], 0
// GFX10: encoding: [0x80,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], -1
// GFX10: encoding: [0xc1,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x3b,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitreplicate_b64_b32 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x3b,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_and_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x3c,0x80,0xbe]

s_and_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x3c,0xe9,0xbe]

s_and_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x3c,0x80,0xbe]

s_and_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x3c,0xe9,0xbe]

s_and_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x3c,0xfe,0xbe]

s_and_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x3c,0xff,0xbe]

s_and_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x3c,0xea,0xbe]

s_and_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x3c,0xeb,0xbe]

s_and_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x3c,0xfc,0xbe]

s_and_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x3c,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_and_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x3c,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_or_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x3d,0x80,0xbe]

s_or_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x3d,0xe9,0xbe]

s_or_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x3d,0x80,0xbe]

s_or_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x3d,0xe9,0xbe]

s_or_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x3d,0xfe,0xbe]

s_or_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x3d,0xff,0xbe]

s_or_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x3d,0xea,0xbe]

s_or_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x3d,0xeb,0xbe]

s_or_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x3d,0xfc,0xbe]

s_or_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x3d,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_or_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x3d,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_xor_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x3e,0xe9,0xbe]

s_xor_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x3e,0xe9,0xbe]

s_xor_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x3e,0xfe,0xbe]

s_xor_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x3e,0xff,0xbe]

s_xor_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x3e,0xea,0xbe]

s_xor_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x3e,0xeb,0xbe]

s_xor_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x3e,0xfc,0xbe]

s_xor_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x3e,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_xor_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x3e,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x3f,0xe9,0xbe]

s_andn2_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x3f,0xe9,0xbe]

s_andn2_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x3f,0xfe,0xbe]

s_andn2_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x3f,0xff,0xbe]

s_andn2_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x3f,0xea,0xbe]

s_andn2_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x3f,0xeb,0xbe]

s_andn2_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x3f,0xfc,0xbe]

s_andn2_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x3f,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x3f,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_orn2_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x40,0xe9,0xbe]

s_orn2_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x40,0xe9,0xbe]

s_orn2_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x40,0xfe,0xbe]

s_orn2_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x40,0xff,0xbe]

s_orn2_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x40,0xea,0xbe]

s_orn2_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x40,0xeb,0xbe]

s_orn2_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x40,0xfc,0xbe]

s_orn2_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x40,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_orn2_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x40,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_nand_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x41,0x80,0xbe]

s_nand_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x41,0xe9,0xbe]

s_nand_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x41,0x80,0xbe]

s_nand_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x41,0xe9,0xbe]

s_nand_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x41,0xfe,0xbe]

s_nand_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x41,0xff,0xbe]

s_nand_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x41,0xea,0xbe]

s_nand_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x41,0xeb,0xbe]

s_nand_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x41,0xfc,0xbe]

s_nand_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x41,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_nand_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x41,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_nor_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x42,0x80,0xbe]

s_nor_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x42,0xe9,0xbe]

s_nor_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x42,0x80,0xbe]

s_nor_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x42,0xe9,0xbe]

s_nor_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x42,0xfe,0xbe]

s_nor_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x42,0xff,0xbe]

s_nor_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x42,0xea,0xbe]

s_nor_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x42,0xeb,0xbe]

s_nor_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x42,0xfc,0xbe]

s_nor_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x42,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_nor_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x42,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_xnor_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x43,0xe9,0xbe]

s_xnor_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x43,0xe9,0xbe]

s_xnor_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x43,0xfe,0xbe]

s_xnor_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x43,0xff,0xbe]

s_xnor_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x43,0xea,0xbe]

s_xnor_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x43,0xeb,0xbe]

s_xnor_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x43,0xfc,0xbe]

s_xnor_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x43,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_xnor_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x43,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x44,0xe9,0xbe]

s_andn1_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x44,0xe9,0xbe]

s_andn1_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x44,0xfe,0xbe]

s_andn1_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x44,0xff,0xbe]

s_andn1_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x44,0xea,0xbe]

s_andn1_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x44,0xeb,0xbe]

s_andn1_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x44,0xfc,0xbe]

s_andn1_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x44,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x44,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_orn1_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x45,0xe9,0xbe]

s_orn1_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x45,0xe9,0xbe]

s_orn1_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x45,0xfe,0xbe]

s_orn1_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x45,0xff,0xbe]

s_orn1_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x45,0xea,0xbe]

s_orn1_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x45,0xeb,0xbe]

s_orn1_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x45,0xfc,0xbe]

s_orn1_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x45,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_orn1_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x45,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_wrexec_b32 s0, s1
// GFX10: encoding: [0x01,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s105, s104
// GFX10: encoding: [0x68,0x46,0xe9,0xbe]

s_andn1_wrexec_b32 s0, s104
// GFX10: encoding: [0x68,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s105, s1
// GFX10: encoding: [0x01,0x46,0xe9,0xbe]

s_andn1_wrexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x46,0xfe,0xbe]

s_andn1_wrexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x46,0xff,0xbe]

s_andn1_wrexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x46,0xea,0xbe]

s_andn1_wrexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x46,0xeb,0xbe]

s_andn1_wrexec_b32 m0, s1
// GFX10: encoding: [0x01,0x46,0xfc,0xbe]

s_andn1_wrexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, 0
// GFX10: encoding: [0x80,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x46,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_wrexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x46,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_wrexec_b32 s0, s1
// GFX10: encoding: [0x01,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s105, s104
// GFX10: encoding: [0x68,0x47,0xe9,0xbe]

s_andn2_wrexec_b32 s0, s104
// GFX10: encoding: [0x68,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s105, s1
// GFX10: encoding: [0x01,0x47,0xe9,0xbe]

s_andn2_wrexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x47,0xfe,0xbe]

s_andn2_wrexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x47,0xff,0xbe]

s_andn2_wrexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x47,0xea,0xbe]

s_andn2_wrexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x47,0xeb,0xbe]

s_andn2_wrexec_b32 m0, s1
// GFX10: encoding: [0x01,0x47,0xfc,0xbe]

s_andn2_wrexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, 0
// GFX10: encoding: [0x80,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x47,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_wrexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x47,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_movrelsd_2_b32 s0, s1
// GFX10: encoding: [0x01,0x49,0x80,0xbe]

s_movrelsd_2_b32 s105, s104
// GFX10: encoding: [0x68,0x49,0xe9,0xbe]

s_movrelsd_2_b32 s0, s104
// GFX10: encoding: [0x68,0x49,0x80,0xbe]

s_movrelsd_2_b32 s105, s1
// GFX10: encoding: [0x01,0x49,0xe9,0xbe]

s_movrelsd_2_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x49,0xea,0xbe]

s_movrelsd_2_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x49,0xeb,0xbe]

s_movrelsd_2_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x49,0x80,0xbe]

s_movrelsd_2_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x49,0x80,0xbe]

//===----------------------------------------------------------------------===//
// ENC_SOP2.
//===----------------------------------------------------------------------===//

s_add_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x80]

s_add_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x80]

s_add_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x80]

s_add_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x80]

s_add_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x80]

s_add_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x80]

s_add_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x80]

s_add_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x80]

s_add_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x80]

s_add_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x80]

s_add_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x80]

s_add_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x80]

s_add_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x80]

s_add_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x80]

s_add_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x80]

s_add_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x80]

s_add_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x80]

s_add_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x80]

s_add_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x80]

s_add_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x80]

s_add_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x80]

s_add_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x80]

s_add_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x80,0x73,0x72,0x71,0x3f]

s_add_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x80,0x56,0x34,0x12,0xaf]

s_add_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x80]

s_add_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x80]

s_add_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x80]

s_add_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x80]

s_add_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x80]

s_add_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x80]

s_add_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x80]

s_add_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x80]

s_add_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x80]

s_add_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x80,0x73,0x72,0x71,0x3f]

s_add_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x80,0x56,0x34,0x12,0xaf]

s_sub_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x80]

s_sub_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x80]

s_sub_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x80]

s_sub_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x80]

s_sub_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x80]

s_sub_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x80]

s_sub_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x80]

s_sub_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x80]

s_sub_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x80]

s_sub_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x80]

s_sub_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x80]

s_sub_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x80]

s_sub_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x80]

s_sub_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x80]

s_sub_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x80]

s_sub_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x80]

s_sub_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x80]

s_sub_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x80]

s_sub_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x80]

s_sub_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x80]

s_sub_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x80]

s_sub_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x80]

s_sub_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x80,0x73,0x72,0x71,0x3f]

s_sub_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x80,0x56,0x34,0x12,0xaf]

s_sub_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x80]

s_sub_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x80]

s_sub_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x80]

s_sub_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x80]

s_sub_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x80]

s_sub_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x80]

s_sub_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x80]

s_sub_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x80]

s_sub_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x80]

s_sub_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x80,0x73,0x72,0x71,0x3f]

s_sub_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x80,0x56,0x34,0x12,0xaf]

s_add_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x81]

s_add_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x81]

s_add_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x81]

s_add_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x81]

s_add_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x81]

s_add_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x81]

s_add_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x81]

s_add_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x81]

s_add_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x81]

s_add_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x81]

s_add_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x81]

s_add_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x81]

s_add_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x81]

s_add_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x81]

s_add_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x81]

s_add_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x81]

s_add_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x81]

s_add_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x81]

s_add_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x81]

s_add_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x81]

s_add_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x81]

s_add_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x81]

s_add_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x81,0x73,0x72,0x71,0x3f]

s_add_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x81,0x56,0x34,0x12,0xaf]

s_add_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x81]

s_add_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x81]

s_add_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x81]

s_add_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x81]

s_add_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x81]

s_add_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x81]

s_add_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x81]

s_add_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x81]

s_add_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x81]

s_add_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x81,0x73,0x72,0x71,0x3f]

s_add_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x81,0x56,0x34,0x12,0xaf]

s_sub_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x81]

s_sub_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x81]

s_sub_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x81]

s_sub_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x81]

s_sub_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x81]

s_sub_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x81]

s_sub_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x81]

s_sub_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x81]

s_sub_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x81]

s_sub_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x81]

s_sub_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x81]

s_sub_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x81]

s_sub_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x81]

s_sub_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x81]

s_sub_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x81]

s_sub_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x81]

s_sub_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x81]

s_sub_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x81]

s_sub_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x81]

s_sub_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x81]

s_sub_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x81]

s_sub_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x81]

s_sub_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x81,0x73,0x72,0x71,0x3f]

s_sub_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x81,0x56,0x34,0x12,0xaf]

s_sub_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x81]

s_sub_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x81]

s_sub_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x81]

s_sub_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x81]

s_sub_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x81]

s_sub_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x81]

s_sub_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x81]

s_sub_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x81]

s_sub_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x81]

s_sub_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x81,0x73,0x72,0x71,0x3f]

s_sub_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x81,0x56,0x34,0x12,0xaf]

s_addc_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x82]

s_addc_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x82]

s_addc_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x82]

s_addc_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x82]

s_addc_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x82]

s_addc_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x82]

s_addc_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x82]

s_addc_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x82]

s_addc_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x82]

s_addc_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x82]

s_addc_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x82]

s_addc_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x82]

s_addc_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x82]

s_addc_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x82]

s_addc_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x82]

s_addc_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x82]

s_addc_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x82]

s_addc_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x82]

s_addc_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x82]

s_addc_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x82]

s_addc_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x82]

s_addc_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x82]

s_addc_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x82,0x73,0x72,0x71,0x3f]

s_addc_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x82,0x56,0x34,0x12,0xaf]

s_addc_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x82]

s_addc_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x82]

s_addc_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x82]

s_addc_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x82]

s_addc_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x82]

s_addc_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x82]

s_addc_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x82]

s_addc_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x82]

s_addc_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x82]

s_addc_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x82,0x73,0x72,0x71,0x3f]

s_addc_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x82,0x56,0x34,0x12,0xaf]

s_subb_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x82]

s_subb_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x82]

s_subb_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x82]

s_subb_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x82]

s_subb_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x82]

s_subb_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x82]

s_subb_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x82]

s_subb_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x82]

s_subb_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x82]

s_subb_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x82]

s_subb_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x82]

s_subb_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x82]

s_subb_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x82]

s_subb_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x82]

s_subb_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x82]

s_subb_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x82]

s_subb_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x82]

s_subb_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x82]

s_subb_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x82]

s_subb_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x82]

s_subb_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x82]

s_subb_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x82]

s_subb_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x82,0x73,0x72,0x71,0x3f]

s_subb_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x82,0x56,0x34,0x12,0xaf]

s_subb_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x82]

s_subb_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x82]

s_subb_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x82]

s_subb_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x82]

s_subb_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x82]

s_subb_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x82]

s_subb_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x82]

s_subb_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x82]

s_subb_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x82]

s_subb_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x82,0x73,0x72,0x71,0x3f]

s_subb_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x82,0x56,0x34,0x12,0xaf]

s_min_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x83]

s_min_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x83]

s_min_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x83]

s_min_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x83]

s_min_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x83]

s_min_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x83]

s_min_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x83]

s_min_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x83]

s_min_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x83]

s_min_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x83]

s_min_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x83]

s_min_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x83]

s_min_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x83]

s_min_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x83]

s_min_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x83]

s_min_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x83]

s_min_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x83]

s_min_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x83]

s_min_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x83]

s_min_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x83]

s_min_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x83]

s_min_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x83]

s_min_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x83,0x73,0x72,0x71,0x3f]

s_min_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x83,0x56,0x34,0x12,0xaf]

s_min_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x83]

s_min_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x83]

s_min_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x83]

s_min_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x83]

s_min_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x83]

s_min_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x83]

s_min_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x83]

s_min_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x83]

s_min_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x83]

s_min_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x83,0x73,0x72,0x71,0x3f]

s_min_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x83,0x56,0x34,0x12,0xaf]

s_min_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x83]

s_min_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x83]

s_min_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x83]

s_min_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x83]

s_min_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x83]

s_min_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x83]

s_min_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x83]

s_min_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x83]

s_min_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x83]

s_min_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x83]

s_min_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x83]

s_min_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x83]

s_min_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x83]

s_min_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x83]

s_min_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x83]

s_min_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x83]

s_min_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x83]

s_min_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x83]

s_min_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x83]

s_min_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x83]

s_min_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x83]

s_min_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x83]

s_min_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x83,0x73,0x72,0x71,0x3f]

s_min_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x83,0x56,0x34,0x12,0xaf]

s_min_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x83]

s_min_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x83]

s_min_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x83]

s_min_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x83]

s_min_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x83]

s_min_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x83]

s_min_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x83]

s_min_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x83]

s_min_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x83]

s_min_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x83,0x73,0x72,0x71,0x3f]

s_min_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x83,0x56,0x34,0x12,0xaf]

s_max_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x84]

s_max_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x84]

s_max_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x84]

s_max_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x84]

s_max_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x84]

s_max_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x84]

s_max_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x84]

s_max_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x84]

s_max_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x84]

s_max_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x84]

s_max_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x84]

s_max_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x84]

s_max_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x84]

s_max_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x84]

s_max_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x84]

s_max_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x84]

s_max_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x84]

s_max_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x84]

s_max_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x84]

s_max_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x84]

s_max_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x84]

s_max_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x84]

s_max_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x84,0x73,0x72,0x71,0x3f]

s_max_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x84,0x56,0x34,0x12,0xaf]

s_max_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x84]

s_max_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x84]

s_max_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x84]

s_max_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x84]

s_max_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x84]

s_max_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x84]

s_max_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x84]

s_max_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x84]

s_max_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x84]

s_max_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x84,0x73,0x72,0x71,0x3f]

s_max_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x84,0x56,0x34,0x12,0xaf]

s_max_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x84]

s_max_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x84]

s_max_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x84]

s_max_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x84]

s_max_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x84]

s_max_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x84]

s_max_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x84]

s_max_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x84]

s_max_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x84]

s_max_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x84]

s_max_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x84]

s_max_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x84]

s_max_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x84]

s_max_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x84]

s_max_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x84]

s_max_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x84]

s_max_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x84]

s_max_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x84]

s_max_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x84]

s_max_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x84]

s_max_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x84]

s_max_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x84]

s_max_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x84,0x73,0x72,0x71,0x3f]

s_max_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x84,0x56,0x34,0x12,0xaf]

s_max_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x84]

s_max_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x84]

s_max_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x84]

s_max_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x84]

s_max_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x84]

s_max_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x84]

s_max_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x84]

s_max_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x84]

s_max_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x84]

s_max_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x84,0x73,0x72,0x71,0x3f]

s_max_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x84,0x56,0x34,0x12,0xaf]

s_cselect_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x85]

s_cselect_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x85]

s_cselect_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x85]

s_cselect_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x85]

s_cselect_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x85]

s_cselect_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x85]

s_cselect_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x85]

s_cselect_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x85]

s_cselect_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x85]

s_cselect_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x85]

s_cselect_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x85]

s_cselect_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x85]

s_cselect_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x85]

s_cselect_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x85]

s_cselect_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x85]

s_cselect_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x85]

s_cselect_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x85]

s_cselect_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x85]

s_cselect_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x85]

s_cselect_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x85]

s_cselect_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x85]

s_cselect_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x85]

s_cselect_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x85]

s_cselect_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x85]

s_cselect_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x85]

s_cselect_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x85]

s_cselect_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x85]

s_cselect_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x85]

s_cselect_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x85]

s_cselect_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x85]

s_cselect_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x85]

s_cselect_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x85]

s_cselect_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x85]

s_cselect_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x85]

s_cselect_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x85]

s_cselect_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x85]

s_cselect_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x85]

s_cselect_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x85]

s_cselect_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x85]

s_cselect_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x85]

s_cselect_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x85]

s_cselect_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x85]

s_cselect_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x85]

s_cselect_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x85]

s_cselect_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x85]

s_cselect_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x85]

s_cselect_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x85,0x56,0x34,0x12,0xaf]

s_and_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x87]

s_and_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x87]

s_and_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x87]

s_and_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x87]

s_and_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x87]

s_and_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x87]

s_and_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x87]

s_and_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x87]

s_and_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x87]

s_and_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x87]

s_and_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x87]

s_and_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x87]

s_and_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x87]

s_and_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x87]

s_and_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x87]

s_and_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x87]

s_and_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x87]

s_and_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x87]

s_and_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x87]

s_and_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x87]

s_and_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x87]

s_and_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x87]

s_and_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x87,0x73,0x72,0x71,0x3f]

s_and_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x87,0x56,0x34,0x12,0xaf]

s_and_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x87]

s_and_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x87]

s_and_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x87]

s_and_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x87]

s_and_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x87]

s_and_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x87]

s_and_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x87]

s_and_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x87]

s_and_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x87]

s_and_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x87,0x73,0x72,0x71,0x3f]

s_and_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x87,0x56,0x34,0x12,0xaf]

s_and_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x87]

s_and_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x87]

s_and_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x87]

s_and_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x87]

s_and_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x87]

s_and_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x87]

s_and_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x87]

s_and_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x87]

s_and_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x87]

s_and_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x87]

s_and_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x87]

s_and_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x87]

s_and_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x87]

s_and_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x87]

s_and_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x87]

s_and_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x87]

s_and_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x87,0x73,0x72,0x71,0x3f]

s_and_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x87,0x56,0x34,0x12,0xaf]

s_and_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x87]

s_and_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x87]

s_and_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x87]

s_and_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x87]

s_and_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x87]

s_and_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x87]

s_and_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x87,0x73,0x72,0x71,0x3f]

s_and_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x87,0x56,0x34,0x12,0xaf]

s_or_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x88]

s_or_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x88]

s_or_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x88]

s_or_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x88]

s_or_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x88]

s_or_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x88]

s_or_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x88]

s_or_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x88]

s_or_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x88]

s_or_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x88]

s_or_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x88]

s_or_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x88]

s_or_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x88]

s_or_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x88]

s_or_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x88]

s_or_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x88]

s_or_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x88]

s_or_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x88]

s_or_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x88]

s_or_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x88]

s_or_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x88]

s_or_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x88]

s_or_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x88,0x73,0x72,0x71,0x3f]

s_or_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x88,0x56,0x34,0x12,0xaf]

s_or_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x88]

s_or_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x88]

s_or_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x88]

s_or_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x88]

s_or_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x88]

s_or_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x88]

s_or_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x88]

s_or_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x88]

s_or_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x88]

s_or_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x88,0x73,0x72,0x71,0x3f]

s_or_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x88,0x56,0x34,0x12,0xaf]

s_or_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x88]

s_or_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x88]

s_or_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x88]

s_or_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x88]

s_or_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x88]

s_or_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x88]

s_or_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x88]

s_or_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x88]

s_or_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x88]

s_or_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x88]

s_or_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x88]

s_or_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x88]

s_or_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x88]

s_or_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x88]

s_or_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x88]

s_or_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x88]

s_or_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x88,0x73,0x72,0x71,0x3f]

s_or_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x88,0x56,0x34,0x12,0xaf]

s_or_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x88]

s_or_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x88]

s_or_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x88]

s_or_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x88]

s_or_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x88]

s_or_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x88]

s_or_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x88,0x73,0x72,0x71,0x3f]

s_or_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x88,0x56,0x34,0x12,0xaf]

s_xor_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x89]

s_xor_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x89]

s_xor_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x89]

s_xor_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x89]

s_xor_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x89]

s_xor_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x89]

s_xor_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x89]

s_xor_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x89]

s_xor_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x89]

s_xor_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x89]

s_xor_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x89]

s_xor_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x89]

s_xor_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x89]

s_xor_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x89]

s_xor_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x89]

s_xor_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x89]

s_xor_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x89]

s_xor_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x89]

s_xor_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x89]

s_xor_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x89]

s_xor_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x89]

s_xor_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x89]

s_xor_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x89,0x73,0x72,0x71,0x3f]

s_xor_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x89,0x56,0x34,0x12,0xaf]

s_xor_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x89]

s_xor_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x89]

s_xor_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x89]

s_xor_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x89]

s_xor_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x89]

s_xor_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x89]

s_xor_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x89]

s_xor_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x89]

s_xor_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x89]

s_xor_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x89,0x73,0x72,0x71,0x3f]

s_xor_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x89,0x56,0x34,0x12,0xaf]

s_xor_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x89]

s_xor_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x89]

s_xor_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x89]

s_xor_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x89]

s_xor_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x89]

s_xor_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x89]

s_xor_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x89]

s_xor_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x89]

s_xor_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x89]

s_xor_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x89]

s_xor_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x89]

s_xor_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x89]

s_xor_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x89]

s_xor_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x89]

s_xor_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x89]

s_xor_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x89,0x73,0x72,0x71,0x3f]

s_xor_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x89,0x56,0x34,0x12,0xaf]

s_xor_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x89,0x73,0x72,0x71,0x3f]

s_xor_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x89,0x56,0x34,0x12,0xaf]

s_andn2_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x8a]

s_andn2_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x8a]

s_andn2_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x8a]

s_andn2_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x8a]

s_andn2_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x8a]

s_andn2_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x8a]

s_andn2_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x8a]

s_andn2_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x8a]

s_andn2_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x8a]

s_andn2_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x8a]

s_andn2_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x8a]

s_andn2_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x8a]

s_andn2_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x8a]

s_andn2_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x8a]

s_andn2_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x8a]

s_andn2_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x8a]

s_andn2_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x8a]

s_andn2_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x8a]

s_andn2_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x8a]

s_andn2_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x8a]

s_andn2_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x8a]

s_andn2_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x8a]

s_andn2_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8a,0x73,0x72,0x71,0x3f]

s_andn2_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8a,0x56,0x34,0x12,0xaf]

s_andn2_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x8a]

s_andn2_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x8a]

s_andn2_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x8a]

s_andn2_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x8a]

s_andn2_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x8a]

s_andn2_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x8a]

s_andn2_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x8a]

s_andn2_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x8a]

s_andn2_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x8a]

s_andn2_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x8a,0x73,0x72,0x71,0x3f]

s_andn2_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x8a,0x56,0x34,0x12,0xaf]

s_andn2_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x8a]

s_andn2_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x8a]

s_andn2_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x8a]

s_andn2_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x8a]

s_andn2_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x8a]

s_andn2_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x8a]

s_andn2_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x8a]

s_andn2_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x8a]

s_andn2_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x8a]

s_andn2_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8a,0x73,0x72,0x71,0x3f]

s_andn2_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8a,0x56,0x34,0x12,0xaf]

s_andn2_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x8a,0x73,0x72,0x71,0x3f]

s_andn2_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x8a,0x56,0x34,0x12,0xaf]

s_orn2_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x8b]

s_orn2_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x8b]

s_orn2_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x8b]

s_orn2_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x8b]

s_orn2_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x8b]

s_orn2_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x8b]

s_orn2_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x8b]

s_orn2_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x8b]

s_orn2_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x8b]

s_orn2_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x8b]

s_orn2_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x8b]

s_orn2_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x8b]

s_orn2_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x8b]

s_orn2_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x8b]

s_orn2_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x8b]

s_orn2_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x8b]

s_orn2_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x8b]

s_orn2_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x8b]

s_orn2_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x8b]

s_orn2_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x8b]

s_orn2_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x8b]

s_orn2_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x8b]

s_orn2_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8b,0x73,0x72,0x71,0x3f]

s_orn2_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8b,0x56,0x34,0x12,0xaf]

s_orn2_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x8b]

s_orn2_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x8b]

s_orn2_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x8b]

s_orn2_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x8b]

s_orn2_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x8b]

s_orn2_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x8b]

s_orn2_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x8b]

s_orn2_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x8b]

s_orn2_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x8b]

s_orn2_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x8b,0x73,0x72,0x71,0x3f]

s_orn2_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x8b,0x56,0x34,0x12,0xaf]

s_orn2_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x8b]

s_orn2_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x8b]

s_orn2_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x8b]

s_orn2_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x8b]

s_orn2_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x8b]

s_orn2_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x8b]

s_orn2_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x8b]

s_orn2_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x8b]

s_orn2_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x8b]

s_orn2_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8b,0x73,0x72,0x71,0x3f]

s_orn2_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8b,0x56,0x34,0x12,0xaf]

s_orn2_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x8b,0x73,0x72,0x71,0x3f]

s_orn2_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x8b,0x56,0x34,0x12,0xaf]

s_nand_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x8c]

s_nand_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x8c]

s_nand_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x8c]

s_nand_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x8c]

s_nand_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x8c]

s_nand_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x8c]

s_nand_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x8c]

s_nand_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x8c]

s_nand_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x8c]

s_nand_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x8c]

s_nand_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x8c]

s_nand_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x8c]

s_nand_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x8c]

s_nand_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x8c]

s_nand_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x8c]

s_nand_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x8c]

s_nand_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x8c]

s_nand_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x8c]

s_nand_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x8c]

s_nand_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x8c]

s_nand_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x8c]

s_nand_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x8c]

s_nand_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8c,0x73,0x72,0x71,0x3f]

s_nand_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8c,0x56,0x34,0x12,0xaf]

s_nand_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x8c]

s_nand_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x8c]

s_nand_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x8c]

s_nand_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x8c]

s_nand_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x8c]

s_nand_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x8c]

s_nand_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x8c]

s_nand_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x8c]

s_nand_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x8c]

s_nand_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x8c,0x73,0x72,0x71,0x3f]

s_nand_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x8c,0x56,0x34,0x12,0xaf]

s_nand_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x8c]

s_nand_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x8c]

s_nand_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x8c]

s_nand_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x8c]

s_nand_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x8c]

s_nand_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x8c]

s_nand_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x8c]

s_nand_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x8c]

s_nand_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x8c]

s_nand_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x8c]

s_nand_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x8c]

s_nand_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x8c]

s_nand_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x8c]

s_nand_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x8c]

s_nand_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x8c]

s_nand_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8c,0x73,0x72,0x71,0x3f]

s_nand_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8c,0x56,0x34,0x12,0xaf]

s_nand_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x8c,0x73,0x72,0x71,0x3f]

s_nand_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x8c,0x56,0x34,0x12,0xaf]

s_nor_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x8d]

s_nor_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x8d]

s_nor_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x8d]

s_nor_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x8d]

s_nor_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x8d]

s_nor_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x8d]

s_nor_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x8d]

s_nor_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x8d]

s_nor_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x8d]

s_nor_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x8d]

s_nor_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x8d]

s_nor_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x8d]

s_nor_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x8d]

s_nor_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x8d]

s_nor_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x8d]

s_nor_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x8d]

s_nor_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x8d]

s_nor_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x8d]

s_nor_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x8d]

s_nor_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x8d]

s_nor_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x8d]

s_nor_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x8d]

s_nor_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8d,0x73,0x72,0x71,0x3f]

s_nor_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8d,0x56,0x34,0x12,0xaf]

s_nor_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x8d]

s_nor_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x8d]

s_nor_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x8d]

s_nor_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x8d]

s_nor_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x8d]

s_nor_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x8d]

s_nor_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x8d]

s_nor_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x8d]

s_nor_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x8d]

s_nor_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x8d,0x73,0x72,0x71,0x3f]

s_nor_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x8d,0x56,0x34,0x12,0xaf]

s_nor_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x8d]

s_nor_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x8d]

s_nor_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x8d]

s_nor_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x8d]

s_nor_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x8d]

s_nor_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x8d]

s_nor_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x8d]

s_nor_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x8d]

s_nor_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x8d]

s_nor_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x8d]

s_nor_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x8d]

s_nor_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x8d]

s_nor_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x8d]

s_nor_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x8d]

s_nor_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x8d]

s_nor_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8d,0x73,0x72,0x71,0x3f]

s_nor_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8d,0x56,0x34,0x12,0xaf]

s_nor_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x8d,0x73,0x72,0x71,0x3f]

s_nor_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x8d,0x56,0x34,0x12,0xaf]

s_xnor_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x8e]

s_xnor_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x8e]

s_xnor_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x8e]

s_xnor_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x8e]

s_xnor_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x8e]

s_xnor_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x8e]

s_xnor_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x8e]

s_xnor_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x8e]

s_xnor_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x8e]

s_xnor_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x8e]

s_xnor_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x8e]

s_xnor_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x8e]

s_xnor_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x8e]

s_xnor_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x8e]

s_xnor_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x8e]

s_xnor_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x8e]

s_xnor_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x8e]

s_xnor_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x8e]

s_xnor_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x8e]

s_xnor_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x8e]

s_xnor_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x8e]

s_xnor_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x8e]

s_xnor_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8e,0x73,0x72,0x71,0x3f]

s_xnor_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8e,0x56,0x34,0x12,0xaf]

s_xnor_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x8e]

s_xnor_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x8e]

s_xnor_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x8e]

s_xnor_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x8e]

s_xnor_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x8e]

s_xnor_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x8e]

s_xnor_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x8e]

s_xnor_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x8e]

s_xnor_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x8e]

s_xnor_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x8e,0x73,0x72,0x71,0x3f]

s_xnor_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x8e,0x56,0x34,0x12,0xaf]

s_xnor_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x8e]

s_xnor_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x8e]

s_xnor_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x8e]

s_xnor_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x8e]

s_xnor_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x8e]

s_xnor_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x8e]

s_xnor_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x8e]

s_xnor_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x8e]

s_xnor_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x8e]

s_xnor_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8e,0x73,0x72,0x71,0x3f]

s_xnor_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8e,0x56,0x34,0x12,0xaf]

s_xnor_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x8e,0x73,0x72,0x71,0x3f]

s_xnor_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x8e,0x56,0x34,0x12,0xaf]

s_lshl_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x8f]

s_lshl_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x8f]

s_lshl_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x8f]

s_lshl_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x8f]

s_lshl_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x8f]

s_lshl_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x8f]

s_lshl_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x8f]

s_lshl_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x8f]

s_lshl_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x8f]

s_lshl_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x8f]

s_lshl_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x8f]

s_lshl_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x8f]

s_lshl_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x8f]

s_lshl_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x8f]

s_lshl_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x8f]

s_lshl_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x8f]

s_lshl_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x8f]

s_lshl_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x8f]

s_lshl_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x8f]

s_lshl_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x8f]

s_lshl_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x8f]

s_lshl_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x8f]

s_lshl_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8f,0x73,0x72,0x71,0x3f]

s_lshl_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8f,0x56,0x34,0x12,0xaf]

s_lshl_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x8f]

s_lshl_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x8f]

s_lshl_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x8f]

s_lshl_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x8f]

s_lshl_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x8f]

s_lshl_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x8f]

s_lshl_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x8f]

s_lshl_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x8f]

s_lshl_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x8f]

s_lshl_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x8f,0x73,0x72,0x71,0x3f]

s_lshl_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x8f,0x56,0x34,0x12,0xaf]

s_lshl_b64 s[0:1], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x80,0x8f]

s_lshl_b64 s[104:105], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0xe8,0x8f]

s_lshl_b64 s[0:1], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0x80,0x8f]

s_lshl_b64 s[104:105], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0xe8,0x8f]

s_lshl_b64 s[104:105], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0xe8,0x8f]

s_lshl_b64 s[104:105], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xe8,0x8f]

s_lshl_b64 s[0:1], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0x80,0x8f]

s_lshl_b64 exec, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xfe,0x8f]

s_lshl_b64 vcc, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xea,0x8f]

s_lshl_b64 s[0:1], exec, s4
// GFX10: encoding: [0x7e,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], vcc, s4
// GFX10: encoding: [0x6a,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], 0, s4
// GFX10: encoding: [0x80,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], -1, s4
// GFX10: encoding: [0xc1,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], 0.5, s4
// GFX10: encoding: [0xf0,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], -4.0, s4
// GFX10: encoding: [0xf7,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], 0x3f717273, s4
// GFX10: encoding: [0xff,0x04,0x80,0x8f,0x73,0x72,0x71,0x3f]

s_lshl_b64 s[0:1], 0xaf123456, s4
// GFX10: encoding: [0xff,0x04,0x80,0x8f,0x56,0x34,0x12,0xaf]

s_lshl_b64 s[0:1], s[2:3], exec_lo
// GFX10: encoding: [0x02,0x7e,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], vcc_lo
// GFX10: encoding: [0x02,0x6a,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x8f,0x73,0x72,0x71,0x3f]

s_lshl_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x8f,0x56,0x34,0x12,0xaf]

s_lshr_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x90]

s_lshr_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x90]

s_lshr_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x90]

s_lshr_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x90]

s_lshr_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x90]

s_lshr_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x90]

s_lshr_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x90]

s_lshr_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x90]

s_lshr_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x90]

s_lshr_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x90]

s_lshr_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x90]

s_lshr_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x90]

s_lshr_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x90]

s_lshr_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x90]

s_lshr_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x90]

s_lshr_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x90]

s_lshr_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x90]

s_lshr_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x90]

s_lshr_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x90]

s_lshr_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x90]

s_lshr_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x90]

s_lshr_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x90]

s_lshr_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x90,0x73,0x72,0x71,0x3f]

s_lshr_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x90,0x56,0x34,0x12,0xaf]

s_lshr_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x90]

s_lshr_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x90]

s_lshr_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x90]

s_lshr_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x90]

s_lshr_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x90]

s_lshr_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x90]

s_lshr_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x90]

s_lshr_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x90]

s_lshr_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x90]

s_lshr_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x90,0x73,0x72,0x71,0x3f]

s_lshr_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x90,0x56,0x34,0x12,0xaf]

s_lshr_b64 s[0:1], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x80,0x90]

s_lshr_b64 s[104:105], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0xe8,0x90]

s_lshr_b64 s[0:1], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0x80,0x90]

s_lshr_b64 s[104:105], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0xe8,0x90]

s_lshr_b64 s[104:105], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0xe8,0x90]

s_lshr_b64 s[104:105], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xe8,0x90]

s_lshr_b64 s[0:1], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0x80,0x90]

s_lshr_b64 exec, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xfe,0x90]

s_lshr_b64 vcc, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xea,0x90]

s_lshr_b64 s[0:1], exec, s4
// GFX10: encoding: [0x7e,0x04,0x80,0x90]

s_lshr_b64 s[0:1], vcc, s4
// GFX10: encoding: [0x6a,0x04,0x80,0x90]

s_lshr_b64 s[0:1], 0, s4
// GFX10: encoding: [0x80,0x04,0x80,0x90]

s_lshr_b64 s[0:1], -1, s4
// GFX10: encoding: [0xc1,0x04,0x80,0x90]

s_lshr_b64 s[0:1], 0.5, s4
// GFX10: encoding: [0xf0,0x04,0x80,0x90]

s_lshr_b64 s[0:1], -4.0, s4
// GFX10: encoding: [0xf7,0x04,0x80,0x90]

s_lshr_b64 s[0:1], 0x3f717273, s4
// GFX10: encoding: [0xff,0x04,0x80,0x90,0x73,0x72,0x71,0x3f]

s_lshr_b64 s[0:1], 0xaf123456, s4
// GFX10: encoding: [0xff,0x04,0x80,0x90,0x56,0x34,0x12,0xaf]

s_lshr_b64 s[0:1], s[2:3], exec_lo
// GFX10: encoding: [0x02,0x7e,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], vcc_lo
// GFX10: encoding: [0x02,0x6a,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x90,0x73,0x72,0x71,0x3f]

s_lshr_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x90,0x56,0x34,0x12,0xaf]

s_ashr_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x91]

s_ashr_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x91]

s_ashr_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x91]

s_ashr_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x91]

s_ashr_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x91]

s_ashr_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x91]

s_ashr_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x91]

s_ashr_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x91]

s_ashr_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x91]

s_ashr_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x91]

s_ashr_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x91]

s_ashr_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x91]

s_ashr_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x91]

s_ashr_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x91]

s_ashr_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x91]

s_ashr_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x91]

s_ashr_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x91]

s_ashr_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x91]

s_ashr_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x91]

s_ashr_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x91]

s_ashr_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x91]

s_ashr_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x91]

s_ashr_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x91,0x73,0x72,0x71,0x3f]

s_ashr_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x91,0x56,0x34,0x12,0xaf]

s_ashr_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x91]

s_ashr_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x91]

s_ashr_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x91]

s_ashr_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x91]

s_ashr_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x91]

s_ashr_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x91]

s_ashr_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x91]

s_ashr_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x91]

s_ashr_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x91]

s_ashr_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x91,0x73,0x72,0x71,0x3f]

s_ashr_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x91,0x56,0x34,0x12,0xaf]

s_ashr_i64 s[0:1], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x80,0x91]

s_ashr_i64 s[104:105], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0xe8,0x91]

s_ashr_i64 s[0:1], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0x80,0x91]

s_ashr_i64 s[104:105], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0xe8,0x91]

s_ashr_i64 s[104:105], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0xe8,0x91]

s_ashr_i64 s[104:105], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xe8,0x91]

s_ashr_i64 s[0:1], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0x80,0x91]

s_ashr_i64 exec, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xfe,0x91]

s_ashr_i64 vcc, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xea,0x91]

s_ashr_i64 s[0:1], exec, s4
// GFX10: encoding: [0x7e,0x04,0x80,0x91]

s_ashr_i64 s[0:1], vcc, s4
// GFX10: encoding: [0x6a,0x04,0x80,0x91]

s_ashr_i64 s[0:1], 0, s4
// GFX10: encoding: [0x80,0x04,0x80,0x91]

s_ashr_i64 s[0:1], -1, s4
// GFX10: encoding: [0xc1,0x04,0x80,0x91]

s_ashr_i64 s[0:1], 0.5, s4
// GFX10: encoding: [0xf0,0x04,0x80,0x91]

s_ashr_i64 s[0:1], -4.0, s4
// GFX10: encoding: [0xf7,0x04,0x80,0x91]

s_ashr_i64 s[0:1], 0x3f717273, s4
// GFX10: encoding: [0xff,0x04,0x80,0x91,0x73,0x72,0x71,0x3f]

s_ashr_i64 s[0:1], 0xaf123456, s4
// GFX10: encoding: [0xff,0x04,0x80,0x91,0x56,0x34,0x12,0xaf]

s_ashr_i64 s[0:1], s[2:3], exec_lo
// GFX10: encoding: [0x02,0x7e,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], vcc_lo
// GFX10: encoding: [0x02,0x6a,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x91,0x73,0x72,0x71,0x3f]

s_ashr_i64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x91,0x56,0x34,0x12,0xaf]

s_bfm_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x92]

s_bfm_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x92]

s_bfm_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x92]

s_bfm_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x92]

s_bfm_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x92]

s_bfm_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x92]

s_bfm_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x92]

s_bfm_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x92]

s_bfm_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x92]

s_bfm_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x92]

s_bfm_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x92]

s_bfm_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x92]

s_bfm_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x92]

s_bfm_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x92]

s_bfm_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x92]

s_bfm_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x92]

s_bfm_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x92]

s_bfm_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x92]

s_bfm_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x92]

s_bfm_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x92]

s_bfm_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x92]

s_bfm_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x92]

s_bfm_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x92,0x73,0x72,0x71,0x3f]

s_bfm_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x92,0x56,0x34,0x12,0xaf]

s_bfm_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x92]

s_bfm_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x92]

s_bfm_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x92]

s_bfm_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x92]

s_bfm_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x92]

s_bfm_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x92]

s_bfm_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x92]

s_bfm_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x92]

s_bfm_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x92]

s_bfm_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x92,0x73,0x72,0x71,0x3f]

s_bfm_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x92,0x56,0x34,0x12,0xaf]

s_bfm_b64 s[0:1], s2, s3
// GFX10: encoding: [0x02,0x03,0x80,0x92]

s_bfm_b64 s[104:105], s103, s102
// GFX10: encoding: [0x67,0x66,0xe8,0x92]

s_bfm_b64 s[0:1], s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x92]

s_bfm_b64 s[104:105], s2, s103
// GFX10: encoding: [0x02,0x67,0xe8,0x92]

s_bfm_b64 s[104:105], s104, s3
// GFX10: encoding: [0x68,0x03,0xe8,0x92]

s_bfm_b64 s[104:105], s2, s3
// GFX10: encoding: [0x02,0x03,0xe8,0x92]

s_bfm_b64 s[0:1], s104, s3
// GFX10: encoding: [0x68,0x03,0x80,0x92]

s_bfm_b64 s[0:1], s2, s103
// GFX10: encoding: [0x02,0x67,0x80,0x92]

s_bfm_b64 exec, s2, s3
// GFX10: encoding: [0x02,0x03,0xfe,0x92]

s_bfm_b64 vcc, s2, s3
// GFX10: encoding: [0x02,0x03,0xea,0x92]

s_bfm_b64 s[0:1], exec_lo, s3
// GFX10: encoding: [0x7e,0x03,0x80,0x92]

s_bfm_b64 s[0:1], exec_hi, s3
// GFX10: encoding: [0x7f,0x03,0x80,0x92]

s_bfm_b64 s[0:1], vcc_lo, s3
// GFX10: encoding: [0x6a,0x03,0x80,0x92]

s_bfm_b64 s[0:1], vcc_hi, s3
// GFX10: encoding: [0x6b,0x03,0x80,0x92]

s_bfm_b64 s[0:1], m0, s3
// GFX10: encoding: [0x7c,0x03,0x80,0x92]

s_bfm_b64 s[0:1], 0, s3
// GFX10: encoding: [0x80,0x03,0x80,0x92]

s_bfm_b64 s[0:1], -1, s3
// GFX10: encoding: [0xc1,0x03,0x80,0x92]

s_bfm_b64 s[0:1], 0.5, s3
// GFX10: encoding: [0xf0,0x03,0x80,0x92]

s_bfm_b64 s[0:1], -4.0, s3
// GFX10: encoding: [0xf7,0x03,0x80,0x92]

s_bfm_b64 s[0:1], 0x3f717273, s3
// GFX10: encoding: [0xff,0x03,0x80,0x92,0x73,0x72,0x71,0x3f]

s_bfm_b64 s[0:1], 0xaf123456, s3
// GFX10: encoding: [0xff,0x03,0x80,0x92,0x56,0x34,0x12,0xaf]

s_bfm_b64 s[0:1], s2, exec_lo
// GFX10: encoding: [0x02,0x7e,0x80,0x92]

s_bfm_b64 s[0:1], s2, exec_hi
// GFX10: encoding: [0x02,0x7f,0x80,0x92]

s_bfm_b64 s[0:1], s2, vcc_lo
// GFX10: encoding: [0x02,0x6a,0x80,0x92]

s_bfm_b64 s[0:1], s2, vcc_hi
// GFX10: encoding: [0x02,0x6b,0x80,0x92]

s_bfm_b64 s[0:1], s2, m0
// GFX10: encoding: [0x02,0x7c,0x80,0x92]

s_bfm_b64 s[0:1], s2, 0
// GFX10: encoding: [0x02,0x80,0x80,0x92]

s_bfm_b64 s[0:1], s2, -1
// GFX10: encoding: [0x02,0xc1,0x80,0x92]

s_bfm_b64 s[0:1], s2, 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x92]

s_bfm_b64 s[0:1], s2, -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x92]

s_bfm_b64 s[0:1], s2, 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x92,0x73,0x72,0x71,0x3f]

s_bfm_b64 s[0:1], s2, 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x92,0x56,0x34,0x12,0xaf]

s_mul_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x93]

s_mul_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x93]

s_mul_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x93]

s_mul_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x93]

s_mul_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x93]

s_mul_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x93]

s_mul_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x93]

s_mul_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x93]

s_mul_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x93]

s_mul_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x93]

s_mul_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x93]

s_mul_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x93]

s_mul_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x93]

s_mul_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x93]

s_mul_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x93]

s_mul_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x93]

s_mul_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x93]

s_mul_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x93]

s_mul_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x93]

s_mul_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x93]

s_mul_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x93]

s_mul_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x93]

s_mul_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x93,0x73,0x72,0x71,0x3f]

s_mul_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x93,0x56,0x34,0x12,0xaf]

s_mul_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x93]

s_mul_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x93]

s_mul_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x93]

s_mul_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x93]

s_mul_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x93]

s_mul_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x93]

s_mul_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x93]

s_mul_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x93]

s_mul_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x93]

s_mul_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x93,0x73,0x72,0x71,0x3f]

s_mul_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x93,0x56,0x34,0x12,0xaf]

s_bfe_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x93]

s_bfe_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x93]

s_bfe_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x93]

s_bfe_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x93]

s_bfe_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x93]

s_bfe_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x93]

s_bfe_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x93]

s_bfe_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x93]

s_bfe_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x93]

s_bfe_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x93]

s_bfe_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x93]

s_bfe_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x93]

s_bfe_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x93]

s_bfe_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x93]

s_bfe_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x93]

s_bfe_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x93]

s_bfe_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x93]

s_bfe_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x93]

s_bfe_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x93]

s_bfe_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x93]

s_bfe_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x93]

s_bfe_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x93]

s_bfe_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x93,0x73,0x72,0x71,0x3f]

s_bfe_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x93,0x56,0x34,0x12,0xaf]

s_bfe_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x93]

s_bfe_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x93]

s_bfe_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x93]

s_bfe_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x93]

s_bfe_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x93]

s_bfe_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x93]

s_bfe_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x93]

s_bfe_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x93]

s_bfe_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x93]

s_bfe_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x93,0x73,0x72,0x71,0x3f]

s_bfe_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x93,0x56,0x34,0x12,0xaf]

s_bfe_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x94]

s_bfe_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x94]

s_bfe_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x94]

s_bfe_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x94]

s_bfe_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x94]

s_bfe_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x94]

s_bfe_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x94]

s_bfe_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x94]

s_bfe_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x94]

s_bfe_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x94]

s_bfe_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x94]

s_bfe_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x94]

s_bfe_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x94]

s_bfe_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x94]

s_bfe_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x94]

s_bfe_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x94]

s_bfe_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x94]

s_bfe_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x94]

s_bfe_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x94]

s_bfe_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x94]

s_bfe_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x94]

s_bfe_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x94]

s_bfe_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x94,0x73,0x72,0x71,0x3f]

s_bfe_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x94,0x56,0x34,0x12,0xaf]

s_bfe_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x94]

s_bfe_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x94]

s_bfe_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x94]

s_bfe_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x94]

s_bfe_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x94]

s_bfe_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x94]

s_bfe_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x94]

s_bfe_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x94]

s_bfe_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x94]

s_bfe_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x94,0x73,0x72,0x71,0x3f]

s_bfe_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x94,0x56,0x34,0x12,0xaf]

s_bfe_u64 s[0:1], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x80,0x94]

s_bfe_u64 s[104:105], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0xe8,0x94]

s_bfe_u64 s[0:1], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0x80,0x94]

s_bfe_u64 s[104:105], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0xe8,0x94]

s_bfe_u64 s[104:105], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0xe8,0x94]

s_bfe_u64 s[104:105], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xe8,0x94]

s_bfe_u64 s[0:1], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0x80,0x94]

s_bfe_u64 exec, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xfe,0x94]

s_bfe_u64 vcc, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xea,0x94]

s_bfe_u64 s[0:1], exec, s4
// GFX10: encoding: [0x7e,0x04,0x80,0x94]

s_bfe_u64 s[0:1], vcc, s4
// GFX10: encoding: [0x6a,0x04,0x80,0x94]

s_bfe_u64 s[0:1], 0, s4
// GFX10: encoding: [0x80,0x04,0x80,0x94]

s_bfe_u64 s[0:1], -1, s4
// GFX10: encoding: [0xc1,0x04,0x80,0x94]

s_bfe_u64 s[0:1], 0.5, s4
// GFX10: encoding: [0xf0,0x04,0x80,0x94]

s_bfe_u64 s[0:1], -4.0, s4
// GFX10: encoding: [0xf7,0x04,0x80,0x94]

s_bfe_u64 s[0:1], 0x3f717273, s4
// GFX10: encoding: [0xff,0x04,0x80,0x94,0x73,0x72,0x71,0x3f]

s_bfe_u64 s[0:1], 0xaf123456, s4
// GFX10: encoding: [0xff,0x04,0x80,0x94,0x56,0x34,0x12,0xaf]

s_bfe_u64 s[0:1], s[2:3], exec_lo
// GFX10: encoding: [0x02,0x7e,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], vcc_lo
// GFX10: encoding: [0x02,0x6a,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x94,0x73,0x72,0x71,0x3f]

s_bfe_u64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x94,0x56,0x34,0x12,0xaf]

s_bfe_i64 s[0:1], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x00,0x95]

s_bfe_i64 s[104:105], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0x68,0x95]

s_bfe_i64 s[0:1], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0x00,0x95]

s_bfe_i64 s[104:105], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0x68,0x95]

s_bfe_i64 s[104:105], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0x68,0x95]

s_bfe_i64 s[104:105], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x68,0x95]

s_bfe_i64 s[0:1], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0x00,0x95]

s_bfe_i64 exec, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x7e,0x95]

s_bfe_i64 vcc, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x6a,0x95]

s_bfe_i64 s[0:1], exec, s4
// GFX10: encoding: [0x7e,0x04,0x00,0x95]

s_bfe_i64 s[0:1], vcc, s4
// GFX10: encoding: [0x6a,0x04,0x00,0x95]

s_bfe_i64 s[0:1], 0, s4
// GFX10: encoding: [0x80,0x04,0x00,0x95]

s_bfe_i64 s[0:1], -1, s4
// GFX10: encoding: [0xc1,0x04,0x00,0x95]

s_bfe_i64 s[0:1], 0.5, s4
// GFX10: encoding: [0xf0,0x04,0x00,0x95]

s_bfe_i64 s[0:1], -4.0, s4
// GFX10: encoding: [0xf7,0x04,0x00,0x95]

s_bfe_i64 s[0:1], 0x3f717273, s4
// GFX10: encoding: [0xff,0x04,0x00,0x95,0x73,0x72,0x71,0x3f]

s_bfe_i64 s[0:1], 0xaf123456, s4
// GFX10: encoding: [0xff,0x04,0x00,0x95,0x56,0x34,0x12,0xaf]

s_bfe_i64 s[0:1], s[2:3], exec_lo
// GFX10: encoding: [0x02,0x7e,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], vcc_lo
// GFX10: encoding: [0x02,0x6a,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x00,0x95,0x73,0x72,0x71,0x3f]

s_bfe_i64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x00,0x95,0x56,0x34,0x12,0xaf]

s_absdiff_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x96]

s_absdiff_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x96]

s_absdiff_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x96]

s_absdiff_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x96]

s_absdiff_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x96]

s_absdiff_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x96]

s_absdiff_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x96]

s_absdiff_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x96]

s_absdiff_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x96]

s_absdiff_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x96]

s_absdiff_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x96]

s_absdiff_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x96]

s_absdiff_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x96]

s_absdiff_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x96]

s_absdiff_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x96]

s_absdiff_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x96]

s_absdiff_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x96]

s_absdiff_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x96]

s_absdiff_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x96]

s_absdiff_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x96]

s_absdiff_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x96]

s_absdiff_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x96]

s_absdiff_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x96,0x73,0x72,0x71,0x3f]

s_absdiff_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x96,0x56,0x34,0x12,0xaf]

s_absdiff_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x96]

s_absdiff_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x96]

s_absdiff_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x96]

s_absdiff_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x96]

s_absdiff_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x96]

s_absdiff_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x96]

s_absdiff_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x96]

s_absdiff_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x96]

s_absdiff_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x96]

s_absdiff_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x96,0x73,0x72,0x71,0x3f]

s_absdiff_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x96,0x56,0x34,0x12,0xaf]

s_lshl1_add_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x97]

s_lshl1_add_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x97]

s_lshl1_add_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x97]

s_lshl1_add_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x97]

s_lshl1_add_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x97]

s_lshl1_add_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x97]

s_lshl1_add_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x97]

s_lshl1_add_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x97]

s_lshl1_add_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x97]

s_lshl1_add_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x97]

s_lshl1_add_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x97]

s_lshl1_add_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x97]

s_lshl1_add_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x97]

s_lshl1_add_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x97]

s_lshl1_add_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x97]

s_lshl1_add_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x97]

s_lshl1_add_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x97]

s_lshl1_add_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x97]

s_lshl1_add_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x97]

s_lshl1_add_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x97]

s_lshl1_add_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x97]

s_lshl1_add_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x97]

s_lshl1_add_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x97,0x73,0x72,0x71,0x3f]

s_lshl1_add_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x97,0x56,0x34,0x12,0xaf]

s_lshl1_add_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x97]

s_lshl1_add_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x97]

s_lshl1_add_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x97]

s_lshl1_add_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x97]

s_lshl1_add_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x97]

s_lshl1_add_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x97]

s_lshl1_add_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x97]

s_lshl1_add_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x97]

s_lshl1_add_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x97]

s_lshl1_add_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x97,0x73,0x72,0x71,0x3f]

s_lshl1_add_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x97,0x56,0x34,0x12,0xaf]

s_lshl2_add_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x97]

s_lshl2_add_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x97]

s_lshl2_add_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x97]

s_lshl2_add_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x97]

s_lshl2_add_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x97]

s_lshl2_add_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x97]

s_lshl2_add_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x97]

s_lshl2_add_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x97]

s_lshl2_add_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x97]

s_lshl2_add_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x97]

s_lshl2_add_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x97]

s_lshl2_add_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x97]

s_lshl2_add_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x97]

s_lshl2_add_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x97]

s_lshl2_add_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x97]

s_lshl2_add_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x97]

s_lshl2_add_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x97]

s_lshl2_add_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x97]

s_lshl2_add_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x97]

s_lshl2_add_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x97]

s_lshl2_add_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x97]

s_lshl2_add_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x97]

s_lshl2_add_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x97,0x73,0x72,0x71,0x3f]

s_lshl2_add_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x97,0x56,0x34,0x12,0xaf]

s_lshl2_add_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x97]

s_lshl2_add_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x97]

s_lshl2_add_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x97]

s_lshl2_add_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x97]

s_lshl2_add_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x97]

s_lshl2_add_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x97]

s_lshl2_add_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x97]

s_lshl2_add_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x97]

s_lshl2_add_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x97]

s_lshl2_add_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x97,0x73,0x72,0x71,0x3f]

s_lshl2_add_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x97,0x56,0x34,0x12,0xaf]

s_lshl3_add_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x98]

s_lshl3_add_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x98]

s_lshl3_add_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x98]

s_lshl3_add_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x98]

s_lshl3_add_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x98]

s_lshl3_add_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x98]

s_lshl3_add_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x98]

s_lshl3_add_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x98]

s_lshl3_add_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x98]

s_lshl3_add_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x98]

s_lshl3_add_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x98]

s_lshl3_add_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x98]

s_lshl3_add_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x98]

s_lshl3_add_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x98]

s_lshl3_add_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x98]

s_lshl3_add_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x98]

s_lshl3_add_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x98]

s_lshl3_add_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x98]

s_lshl3_add_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x98]

s_lshl3_add_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x98]

s_lshl3_add_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x98]

s_lshl3_add_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x98]

s_lshl3_add_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x98,0x73,0x72,0x71,0x3f]

s_lshl3_add_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x98,0x56,0x34,0x12,0xaf]

s_lshl3_add_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x98]

s_lshl3_add_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x98]

s_lshl3_add_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x98]

s_lshl3_add_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x98]

s_lshl3_add_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x98]

s_lshl3_add_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x98]

s_lshl3_add_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x98]

s_lshl3_add_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x98]

s_lshl3_add_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x98]

s_lshl3_add_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x98,0x73,0x72,0x71,0x3f]

s_lshl3_add_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x98,0x56,0x34,0x12,0xaf]

s_lshl4_add_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x98]

s_lshl4_add_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x98]

s_lshl4_add_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x98]

s_lshl4_add_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x98]

s_lshl4_add_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x98]

s_lshl4_add_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x98]

s_lshl4_add_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x98]

s_lshl4_add_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x98]

s_lshl4_add_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x98]

s_lshl4_add_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x98]

s_lshl4_add_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x98]

s_lshl4_add_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x98]

s_lshl4_add_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x98]

s_lshl4_add_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x98]

s_lshl4_add_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x98]

s_lshl4_add_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x98]

s_lshl4_add_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x98]

s_lshl4_add_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x98]

s_lshl4_add_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x98]

s_lshl4_add_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x98]

s_lshl4_add_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x98]

s_lshl4_add_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x98]

s_lshl4_add_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x98,0x73,0x72,0x71,0x3f]

s_lshl4_add_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x98,0x56,0x34,0x12,0xaf]

s_lshl4_add_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x98]

s_lshl4_add_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x98]

s_lshl4_add_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x98]

s_lshl4_add_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x98]

s_lshl4_add_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x98]

s_lshl4_add_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x98]

s_lshl4_add_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x98]

s_lshl4_add_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x98]

s_lshl4_add_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x98]

s_lshl4_add_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x98,0x73,0x72,0x71,0x3f]

s_lshl4_add_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x98,0x56,0x34,0x12,0xaf]

s_pack_ll_b32_b16 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x99]

s_pack_ll_b32_b16 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x99]

s_pack_ll_b32_b16 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x99]

s_pack_ll_b32_b16 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x99]

s_pack_ll_b32_b16 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x99]

s_pack_ll_b32_b16 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x99]

s_pack_ll_b32_b16 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x99]

s_pack_ll_b32_b16 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x99]

s_pack_ll_b32_b16 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x99]

s_pack_ll_b32_b16 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x99]

s_pack_ll_b32_b16 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x99]

s_pack_ll_b32_b16 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x99]

s_pack_ll_b32_b16 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x99,0x73,0x72,0x71,0x3f]

s_pack_ll_b32_b16 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x99,0x56,0x34,0x12,0xaf]

s_pack_ll_b32_b16 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x99,0x73,0x72,0x71,0x3f]

s_pack_ll_b32_b16 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x99,0x56,0x34,0x12,0xaf]

s_pack_lh_b32_b16 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x99]

s_pack_lh_b32_b16 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x99]

s_pack_lh_b32_b16 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x99]

s_pack_lh_b32_b16 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x99]

s_pack_lh_b32_b16 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x99]

s_pack_lh_b32_b16 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x99]

s_pack_lh_b32_b16 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x99]

s_pack_lh_b32_b16 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x99]

s_pack_lh_b32_b16 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x99]

s_pack_lh_b32_b16 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x99]

s_pack_lh_b32_b16 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x99]

s_pack_lh_b32_b16 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x99]

s_pack_lh_b32_b16 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x99,0x73,0x72,0x71,0x3f]

s_pack_lh_b32_b16 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x99,0x56,0x34,0x12,0xaf]

s_pack_lh_b32_b16 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x99,0x73,0x72,0x71,0x3f]

s_pack_lh_b32_b16 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x99,0x56,0x34,0x12,0xaf]

s_pack_hh_b32_b16 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x9a]

s_pack_hh_b32_b16 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x9a]

s_pack_hh_b32_b16 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x9a]

s_pack_hh_b32_b16 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x9a]

s_pack_hh_b32_b16 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x9a]

s_pack_hh_b32_b16 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x9a]

s_pack_hh_b32_b16 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x9a]

s_pack_hh_b32_b16 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x9a]

s_pack_hh_b32_b16 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x9a]

s_pack_hh_b32_b16 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x9a]

s_pack_hh_b32_b16 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x9a]

s_pack_hh_b32_b16 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x9a,0x73,0x72,0x71,0x3f]

s_pack_hh_b32_b16 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x9a,0x56,0x34,0x12,0xaf]

s_pack_hh_b32_b16 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x9a,0x73,0x72,0x71,0x3f]

s_pack_hh_b32_b16 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x9a,0x56,0x34,0x12,0xaf]

s_mul_hi_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x9a]

s_mul_hi_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x9a]

s_mul_hi_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x9a]

s_mul_hi_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x9a]

s_mul_hi_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x9a]

s_mul_hi_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x9a]

s_mul_hi_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x9a]

s_mul_hi_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x9a]

s_mul_hi_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x9a]

s_mul_hi_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x9a]

s_mul_hi_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x9a]

s_mul_hi_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x9a]

s_mul_hi_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x9a]

s_mul_hi_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x9a]

s_mul_hi_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x9a]

s_mul_hi_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x9a]

s_mul_hi_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x9a]

s_mul_hi_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x9a]

s_mul_hi_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x9a]

s_mul_hi_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x9a]

s_mul_hi_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x9a]

s_mul_hi_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x9a]

s_mul_hi_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x9a,0x73,0x72,0x71,0x3f]

s_mul_hi_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x9a,0x56,0x34,0x12,0xaf]

s_mul_hi_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x9a]

s_mul_hi_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x9a]

s_mul_hi_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x9a]

s_mul_hi_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x9a]

s_mul_hi_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x9a]

s_mul_hi_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x9a]

s_mul_hi_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x9a]

s_mul_hi_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x9a]

s_mul_hi_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x9a]

s_mul_hi_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x9a,0x73,0x72,0x71,0x3f]

s_mul_hi_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x9a,0x56,0x34,0x12,0xaf]

s_mul_hi_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x9b]

s_mul_hi_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x9b]

s_mul_hi_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x9b]

s_mul_hi_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x9b]

s_mul_hi_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x9b]

s_mul_hi_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x9b]

s_mul_hi_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x9b]

s_mul_hi_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x9b]

s_mul_hi_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x9b]

s_mul_hi_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x9b]

s_mul_hi_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x9b]

s_mul_hi_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x9b]

s_mul_hi_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x9b]

s_mul_hi_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x9b]

s_mul_hi_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x9b]

s_mul_hi_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x9b]

s_mul_hi_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x9b]

s_mul_hi_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x9b]

s_mul_hi_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x9b]

s_mul_hi_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x9b]

s_mul_hi_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x9b]

s_mul_hi_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x9b]

s_mul_hi_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x9b,0x73,0x72,0x71,0x3f]

s_mul_hi_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x9b,0x56,0x34,0x12,0xaf]

s_mul_hi_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x9b]

s_mul_hi_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x9b]

s_mul_hi_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x9b]

s_mul_hi_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x9b]

s_mul_hi_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x9b]

s_mul_hi_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x9b]

s_mul_hi_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x9b]

s_mul_hi_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x9b]

s_mul_hi_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x9b]

s_mul_hi_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x9b,0x73,0x72,0x71,0x3f]

s_mul_hi_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x9b,0x56,0x34,0x12,0xaf]

//===----------------------------------------------------------------------===//
// ENC_SOPC.
//===----------------------------------------------------------------------===//

s_cmp_eq_i32 s0, s1
// GFX10: encoding: [0x00,0x01,0x00,0xbf]

s_cmp_eq_i32 s105, s104
// GFX10: encoding: [0x69,0x68,0x00,0xbf]

s_cmp_eq_i32 s0, s104
// GFX10: encoding: [0x00,0x68,0x00,0xbf]

s_cmp_eq_i32 s105, s1
// GFX10: encoding: [0x69,0x01,0x00,0xbf]

s_cmp_eq_i32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x00,0xbf]

s_cmp_eq_i32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x00,0xbf]

s_cmp_eq_i32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x00,0xbf]

s_cmp_eq_i32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x00,0xbf]

s_cmp_eq_i32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x00,0xbf]

s_cmp_eq_i32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x00,0xbf]

s_cmp_eq_i32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x00,0xbf]

s_cmp_eq_i32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x00,0xbf]

s_cmp_eq_i32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x00,0xbf]

s_cmp_eq_i32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x00,0xbf]

s_cmp_eq_i32 s0, 0
// GFX10: encoding: [0x00,0x80,0x00,0xbf]

s_cmp_eq_i32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x00,0xbf]

s_cmp_eq_i32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x00,0xbf]

s_cmp_eq_i32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x00,0xbf]

s_cmp_eq_i32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x00,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_i32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x00,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_i32 s0, s1
// GFX10: encoding: [0x00,0x01,0x01,0xbf]

s_cmp_lg_i32 s105, s104
// GFX10: encoding: [0x69,0x68,0x01,0xbf]

s_cmp_lg_i32 s0, s104
// GFX10: encoding: [0x00,0x68,0x01,0xbf]

s_cmp_lg_i32 s105, s1
// GFX10: encoding: [0x69,0x01,0x01,0xbf]

s_cmp_lg_i32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x01,0xbf]

s_cmp_lg_i32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x01,0xbf]

s_cmp_lg_i32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x01,0xbf]

s_cmp_lg_i32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x01,0xbf]

s_cmp_lg_i32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x01,0xbf]

s_cmp_lg_i32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x01,0xbf]

s_cmp_lg_i32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x01,0xbf]

s_cmp_lg_i32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x01,0xbf]

s_cmp_lg_i32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x01,0xbf]

s_cmp_lg_i32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x01,0xbf]

s_cmp_lg_i32 s0, 0
// GFX10: encoding: [0x00,0x80,0x01,0xbf]

s_cmp_lg_i32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x01,0xbf]

s_cmp_lg_i32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x01,0xbf]

s_cmp_lg_i32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x01,0xbf]

s_cmp_lg_i32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x01,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_i32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x01,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_i32 s0, s1
// GFX10: encoding: [0x00,0x01,0x02,0xbf]

s_cmp_gt_i32 s105, s104
// GFX10: encoding: [0x69,0x68,0x02,0xbf]

s_cmp_gt_i32 s0, s104
// GFX10: encoding: [0x00,0x68,0x02,0xbf]

s_cmp_gt_i32 s105, s1
// GFX10: encoding: [0x69,0x01,0x02,0xbf]

s_cmp_gt_i32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x02,0xbf]

s_cmp_gt_i32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x02,0xbf]

s_cmp_gt_i32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x02,0xbf]

s_cmp_gt_i32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x02,0xbf]

s_cmp_gt_i32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x02,0xbf]

s_cmp_gt_i32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x02,0xbf]

s_cmp_gt_i32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x02,0xbf]

s_cmp_gt_i32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x02,0xbf]

s_cmp_gt_i32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x02,0xbf]

s_cmp_gt_i32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x02,0xbf]

s_cmp_gt_i32 s0, 0
// GFX10: encoding: [0x00,0x80,0x02,0xbf]

s_cmp_gt_i32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x02,0xbf]

s_cmp_gt_i32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x02,0xbf]

s_cmp_gt_i32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x02,0xbf]

s_cmp_gt_i32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x02,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_i32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x02,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_i32 s0, s1
// GFX10: encoding: [0x00,0x01,0x03,0xbf]

s_cmp_ge_i32 s105, s104
// GFX10: encoding: [0x69,0x68,0x03,0xbf]

s_cmp_ge_i32 s0, s104
// GFX10: encoding: [0x00,0x68,0x03,0xbf]

s_cmp_ge_i32 s105, s1
// GFX10: encoding: [0x69,0x01,0x03,0xbf]

s_cmp_ge_i32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x03,0xbf]

s_cmp_ge_i32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x03,0xbf]

s_cmp_ge_i32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x03,0xbf]

s_cmp_ge_i32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x03,0xbf]

s_cmp_ge_i32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x03,0xbf]

s_cmp_ge_i32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x03,0xbf]

s_cmp_ge_i32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x03,0xbf]

s_cmp_ge_i32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x03,0xbf]

s_cmp_ge_i32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x03,0xbf]

s_cmp_ge_i32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x03,0xbf]

s_cmp_ge_i32 s0, 0
// GFX10: encoding: [0x00,0x80,0x03,0xbf]

s_cmp_ge_i32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x03,0xbf]

s_cmp_ge_i32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x03,0xbf]

s_cmp_ge_i32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x03,0xbf]

s_cmp_ge_i32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x03,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_i32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x03,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_i32 s0, s1
// GFX10: encoding: [0x00,0x01,0x04,0xbf]

s_cmp_lt_i32 s105, s104
// GFX10: encoding: [0x69,0x68,0x04,0xbf]

s_cmp_lt_i32 s0, s104
// GFX10: encoding: [0x00,0x68,0x04,0xbf]

s_cmp_lt_i32 s105, s1
// GFX10: encoding: [0x69,0x01,0x04,0xbf]

s_cmp_lt_i32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x04,0xbf]

s_cmp_lt_i32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x04,0xbf]

s_cmp_lt_i32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x04,0xbf]

s_cmp_lt_i32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x04,0xbf]

s_cmp_lt_i32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x04,0xbf]

s_cmp_lt_i32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x04,0xbf]

s_cmp_lt_i32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x04,0xbf]

s_cmp_lt_i32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x04,0xbf]

s_cmp_lt_i32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x04,0xbf]

s_cmp_lt_i32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x04,0xbf]

s_cmp_lt_i32 s0, 0
// GFX10: encoding: [0x00,0x80,0x04,0xbf]

s_cmp_lt_i32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x04,0xbf]

s_cmp_lt_i32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x04,0xbf]

s_cmp_lt_i32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x04,0xbf]

s_cmp_lt_i32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x04,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_i32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x04,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_i32 s0, s1
// GFX10: encoding: [0x00,0x01,0x05,0xbf]

s_cmp_le_i32 s105, s104
// GFX10: encoding: [0x69,0x68,0x05,0xbf]

s_cmp_le_i32 s0, s104
// GFX10: encoding: [0x00,0x68,0x05,0xbf]

s_cmp_le_i32 s105, s1
// GFX10: encoding: [0x69,0x01,0x05,0xbf]

s_cmp_le_i32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x05,0xbf]

s_cmp_le_i32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x05,0xbf]

s_cmp_le_i32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x05,0xbf]

s_cmp_le_i32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x05,0xbf]

s_cmp_le_i32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x05,0xbf]

s_cmp_le_i32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x05,0xbf]

s_cmp_le_i32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x05,0xbf]

s_cmp_le_i32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x05,0xbf]

s_cmp_le_i32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x05,0xbf]

s_cmp_le_i32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x05,0xbf]

s_cmp_le_i32 s0, 0
// GFX10: encoding: [0x00,0x80,0x05,0xbf]

s_cmp_le_i32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x05,0xbf]

s_cmp_le_i32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x05,0xbf]

s_cmp_le_i32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x05,0xbf]

s_cmp_le_i32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x05,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_i32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x05,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u32 s0, s1
// GFX10: encoding: [0x00,0x01,0x06,0xbf]

s_cmp_eq_u32 s105, s104
// GFX10: encoding: [0x69,0x68,0x06,0xbf]

s_cmp_eq_u32 s0, s104
// GFX10: encoding: [0x00,0x68,0x06,0xbf]

s_cmp_eq_u32 s105, s1
// GFX10: encoding: [0x69,0x01,0x06,0xbf]

s_cmp_eq_u32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x06,0xbf]

s_cmp_eq_u32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x06,0xbf]

s_cmp_eq_u32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x06,0xbf]

s_cmp_eq_u32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x06,0xbf]

s_cmp_eq_u32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x06,0xbf]

s_cmp_eq_u32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x06,0xbf]

s_cmp_eq_u32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x06,0xbf]

s_cmp_eq_u32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x06,0xbf]

s_cmp_eq_u32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x06,0xbf]

s_cmp_eq_u32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x06,0xbf]

s_cmp_eq_u32 s0, 0
// GFX10: encoding: [0x00,0x80,0x06,0xbf]

s_cmp_eq_u32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x06,0xbf]

s_cmp_eq_u32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x06,0xbf]

s_cmp_eq_u32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x06,0xbf]

s_cmp_eq_u32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x06,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x06,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u32 s0, s1
// GFX10: encoding: [0x00,0x01,0x07,0xbf]

s_cmp_lg_u32 s105, s104
// GFX10: encoding: [0x69,0x68,0x07,0xbf]

s_cmp_lg_u32 s0, s104
// GFX10: encoding: [0x00,0x68,0x07,0xbf]

s_cmp_lg_u32 s105, s1
// GFX10: encoding: [0x69,0x01,0x07,0xbf]

s_cmp_lg_u32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x07,0xbf]

s_cmp_lg_u32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x07,0xbf]

s_cmp_lg_u32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x07,0xbf]

s_cmp_lg_u32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x07,0xbf]

s_cmp_lg_u32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x07,0xbf]

s_cmp_lg_u32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x07,0xbf]

s_cmp_lg_u32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x07,0xbf]

s_cmp_lg_u32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x07,0xbf]

s_cmp_lg_u32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x07,0xbf]

s_cmp_lg_u32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x07,0xbf]

s_cmp_lg_u32 s0, 0
// GFX10: encoding: [0x00,0x80,0x07,0xbf]

s_cmp_lg_u32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x07,0xbf]

s_cmp_lg_u32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x07,0xbf]

s_cmp_lg_u32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x07,0xbf]

s_cmp_lg_u32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x07,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x07,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_u32 s0, s1
// GFX10: encoding: [0x00,0x01,0x08,0xbf]

s_cmp_gt_u32 s105, s104
// GFX10: encoding: [0x69,0x68,0x08,0xbf]

s_cmp_gt_u32 s0, s104
// GFX10: encoding: [0x00,0x68,0x08,0xbf]

s_cmp_gt_u32 s105, s1
// GFX10: encoding: [0x69,0x01,0x08,0xbf]

s_cmp_gt_u32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x08,0xbf]

s_cmp_gt_u32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x08,0xbf]

s_cmp_gt_u32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x08,0xbf]

s_cmp_gt_u32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x08,0xbf]

s_cmp_gt_u32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x08,0xbf]

s_cmp_gt_u32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x08,0xbf]

s_cmp_gt_u32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x08,0xbf]

s_cmp_gt_u32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x08,0xbf]

s_cmp_gt_u32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x08,0xbf]

s_cmp_gt_u32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x08,0xbf]

s_cmp_gt_u32 s0, 0
// GFX10: encoding: [0x00,0x80,0x08,0xbf]

s_cmp_gt_u32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x08,0xbf]

s_cmp_gt_u32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x08,0xbf]

s_cmp_gt_u32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x08,0xbf]

s_cmp_gt_u32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x08,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_u32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x08,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_u32 s0, s1
// GFX10: encoding: [0x00,0x01,0x09,0xbf]

s_cmp_ge_u32 s105, s104
// GFX10: encoding: [0x69,0x68,0x09,0xbf]

s_cmp_ge_u32 s0, s104
// GFX10: encoding: [0x00,0x68,0x09,0xbf]

s_cmp_ge_u32 s105, s1
// GFX10: encoding: [0x69,0x01,0x09,0xbf]

s_cmp_ge_u32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x09,0xbf]

s_cmp_ge_u32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x09,0xbf]

s_cmp_ge_u32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x09,0xbf]

s_cmp_ge_u32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x09,0xbf]

s_cmp_ge_u32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x09,0xbf]

s_cmp_ge_u32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x09,0xbf]

s_cmp_ge_u32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x09,0xbf]

s_cmp_ge_u32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x09,0xbf]

s_cmp_ge_u32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x09,0xbf]

s_cmp_ge_u32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x09,0xbf]

s_cmp_ge_u32 s0, 0
// GFX10: encoding: [0x00,0x80,0x09,0xbf]

s_cmp_ge_u32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x09,0xbf]

s_cmp_ge_u32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x09,0xbf]

s_cmp_ge_u32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x09,0xbf]

s_cmp_ge_u32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x09,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_u32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x09,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_u32 s0, s1
// GFX10: encoding: [0x00,0x01,0x0a,0xbf]

s_cmp_lt_u32 s105, s104
// GFX10: encoding: [0x69,0x68,0x0a,0xbf]

s_cmp_lt_u32 s0, s104
// GFX10: encoding: [0x00,0x68,0x0a,0xbf]

s_cmp_lt_u32 s105, s1
// GFX10: encoding: [0x69,0x01,0x0a,0xbf]

s_cmp_lt_u32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x0a,0xbf]

s_cmp_lt_u32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x0a,0xbf]

s_cmp_lt_u32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x0a,0xbf]

s_cmp_lt_u32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x0a,0xbf]

s_cmp_lt_u32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x0a,0xbf]

s_cmp_lt_u32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x0a,0xbf]

s_cmp_lt_u32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x0a,0xbf]

s_cmp_lt_u32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x0a,0xbf]

s_cmp_lt_u32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x0a,0xbf]

s_cmp_lt_u32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x0a,0xbf]

s_cmp_lt_u32 s0, 0
// GFX10: encoding: [0x00,0x80,0x0a,0xbf]

s_cmp_lt_u32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x0a,0xbf]

s_cmp_lt_u32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x0a,0xbf]

s_cmp_lt_u32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x0a,0xbf]

s_cmp_lt_u32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x0a,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_u32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x0a,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_u32 s0, s1
// GFX10: encoding: [0x00,0x01,0x0b,0xbf]

s_cmp_le_u32 s105, s104
// GFX10: encoding: [0x69,0x68,0x0b,0xbf]

s_cmp_le_u32 s0, s104
// GFX10: encoding: [0x00,0x68,0x0b,0xbf]

s_cmp_le_u32 s105, s1
// GFX10: encoding: [0x69,0x01,0x0b,0xbf]

s_cmp_le_u32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x0b,0xbf]

s_cmp_le_u32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x0b,0xbf]

s_cmp_le_u32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x0b,0xbf]

s_cmp_le_u32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x0b,0xbf]

s_cmp_le_u32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x0b,0xbf]

s_cmp_le_u32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x0b,0xbf]

s_cmp_le_u32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x0b,0xbf]

s_cmp_le_u32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x0b,0xbf]

s_cmp_le_u32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x0b,0xbf]

s_cmp_le_u32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x0b,0xbf]

s_cmp_le_u32 s0, 0
// GFX10: encoding: [0x00,0x80,0x0b,0xbf]

s_cmp_le_u32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x0b,0xbf]

s_cmp_le_u32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x0b,0xbf]

s_cmp_le_u32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x0b,0xbf]

s_cmp_le_u32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x0b,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_u32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x0b,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b32 s0, s1
// GFX10: encoding: [0x00,0x01,0x0c,0xbf]

s_bitcmp0_b32 s105, s104
// GFX10: encoding: [0x69,0x68,0x0c,0xbf]

s_bitcmp0_b32 s0, s104
// GFX10: encoding: [0x00,0x68,0x0c,0xbf]

s_bitcmp0_b32 s105, s1
// GFX10: encoding: [0x69,0x01,0x0c,0xbf]

s_bitcmp0_b32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x0c,0xbf]

s_bitcmp0_b32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x0c,0xbf]

s_bitcmp0_b32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x0c,0xbf]

s_bitcmp0_b32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x0c,0xbf]

s_bitcmp0_b32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x0c,0xbf]

s_bitcmp0_b32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x0c,0xbf]

s_bitcmp0_b32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x0c,0xbf]

s_bitcmp0_b32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x0c,0xbf]

s_bitcmp0_b32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x0c,0xbf]

s_bitcmp0_b32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x0c,0xbf]

s_bitcmp0_b32 s0, 0
// GFX10: encoding: [0x00,0x80,0x0c,0xbf]

s_bitcmp0_b32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x0c,0xbf]

s_bitcmp0_b32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x0c,0xbf]

s_bitcmp0_b32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x0c,0xbf]

s_bitcmp0_b32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x0c,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x0c,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b32 s0, s1
// GFX10: encoding: [0x00,0x01,0x0d,0xbf]

s_bitcmp1_b32 s105, s104
// GFX10: encoding: [0x69,0x68,0x0d,0xbf]

s_bitcmp1_b32 s0, s104
// GFX10: encoding: [0x00,0x68,0x0d,0xbf]

s_bitcmp1_b32 s105, s1
// GFX10: encoding: [0x69,0x01,0x0d,0xbf]

s_bitcmp1_b32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x0d,0xbf]

s_bitcmp1_b32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x0d,0xbf]

s_bitcmp1_b32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x0d,0xbf]

s_bitcmp1_b32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x0d,0xbf]

s_bitcmp1_b32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x0d,0xbf]

s_bitcmp1_b32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x0d,0xbf]

s_bitcmp1_b32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x0d,0xbf]

s_bitcmp1_b32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x0d,0xbf]

s_bitcmp1_b32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x0d,0xbf]

s_bitcmp1_b32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x0d,0xbf]

s_bitcmp1_b32 s0, 0
// GFX10: encoding: [0x00,0x80,0x0d,0xbf]

s_bitcmp1_b32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x0d,0xbf]

s_bitcmp1_b32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x0d,0xbf]

s_bitcmp1_b32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x0d,0xbf]

s_bitcmp1_b32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x0d,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x0d,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b64 s[0:1], s2
// GFX10: encoding: [0x00,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[104:105], s102
// GFX10: encoding: [0x68,0x66,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], s102
// GFX10: encoding: [0x00,0x66,0x0e,0xbf]

s_bitcmp0_b64 s[104:105], s2
// GFX10: encoding: [0x68,0x02,0x0e,0xbf]

s_bitcmp0_b64 exec, s2
// GFX10: encoding: [0x7e,0x02,0x0e,0xbf]

s_bitcmp0_b64 vcc, s2
// GFX10: encoding: [0x6a,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], exec_lo
// GFX10: encoding: [0x00,0x7e,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], exec_hi
// GFX10: encoding: [0x00,0x7f,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], vcc_lo
// GFX10: encoding: [0x00,0x6a,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], vcc_hi
// GFX10: encoding: [0x00,0x6b,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], m0
// GFX10: encoding: [0x00,0x7c,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], 0
// GFX10: encoding: [0x00,0x80,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], -1
// GFX10: encoding: [0x00,0xc1,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], 0.5
// GFX10: encoding: [0x00,0xf0,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], -4.0
// GFX10: encoding: [0x00,0xf7,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0x00,0xff,0x0e,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0x00,0xff,0x0e,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b64 s[0:1], s2
// GFX10: encoding: [0x00,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[104:105], s102
// GFX10: encoding: [0x68,0x66,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], s102
// GFX10: encoding: [0x00,0x66,0x0f,0xbf]

s_bitcmp1_b64 s[104:105], s2
// GFX10: encoding: [0x68,0x02,0x0f,0xbf]

s_bitcmp1_b64 exec, s2
// GFX10: encoding: [0x7e,0x02,0x0f,0xbf]

s_bitcmp1_b64 vcc, s2
// GFX10: encoding: [0x6a,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], exec_lo
// GFX10: encoding: [0x00,0x7e,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], exec_hi
// GFX10: encoding: [0x00,0x7f,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], vcc_lo
// GFX10: encoding: [0x00,0x6a,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], vcc_hi
// GFX10: encoding: [0x00,0x6b,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], m0
// GFX10: encoding: [0x00,0x7c,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], 0
// GFX10: encoding: [0x00,0x80,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], -1
// GFX10: encoding: [0x00,0xc1,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], 0.5
// GFX10: encoding: [0x00,0xf0,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], -4.0
// GFX10: encoding: [0x00,0xf7,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0x00,0xff,0x0f,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0x00,0xff,0x0f,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u64 s[0:1], s[2:3]
// GFX10: encoding: [0x00,0x02,0x12,0xbf]

s_cmp_eq_u64 s[104:105], s[102:103]
// GFX10: encoding: [0x68,0x66,0x12,0xbf]

s_cmp_eq_u64 s[0:1], s[102:103]
// GFX10: encoding: [0x00,0x66,0x12,0xbf]

s_cmp_eq_u64 s[104:105], s[2:3]
// GFX10: encoding: [0x68,0x02,0x12,0xbf]

s_cmp_eq_u64 exec, s[2:3]
// GFX10: encoding: [0x7e,0x02,0x12,0xbf]

s_cmp_eq_u64 vcc, s[2:3]
// GFX10: encoding: [0x6a,0x02,0x12,0xbf]

s_cmp_eq_u64 s[0:1], exec
// GFX10: encoding: [0x00,0x7e,0x12,0xbf]

s_cmp_eq_u64 s[0:1], vcc
// GFX10: encoding: [0x00,0x6a,0x12,0xbf]

s_cmp_eq_u64 s[0:1], 0
// GFX10: encoding: [0x00,0x80,0x12,0xbf]

s_cmp_eq_u64 s[0:1], -1
// GFX10: encoding: [0x00,0xc1,0x12,0xbf]

s_cmp_eq_u64 s[0:1], 0.5
// GFX10: encoding: [0x00,0xf0,0x12,0xbf]

s_cmp_eq_u64 s[0:1], -4.0
// GFX10: encoding: [0x00,0xf7,0x12,0xbf]

s_cmp_eq_u64 s[0:1], 0x3f717273
// GFX10: encoding: [0x00,0xff,0x12,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u64 s[0:1], 0xaf123456
// GFX10: encoding: [0x00,0xff,0x12,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u64 s[0:1], s[2:3]
// GFX10: encoding: [0x00,0x02,0x13,0xbf]

s_cmp_lg_u64 s[104:105], s[102:103]
// GFX10: encoding: [0x68,0x66,0x13,0xbf]

s_cmp_lg_u64 s[0:1], s[102:103]
// GFX10: encoding: [0x00,0x66,0x13,0xbf]

s_cmp_lg_u64 s[104:105], s[2:3]
// GFX10: encoding: [0x68,0x02,0x13,0xbf]

s_cmp_lg_u64 exec, s[2:3]
// GFX10: encoding: [0x7e,0x02,0x13,0xbf]

s_cmp_lg_u64 vcc, s[2:3]
// GFX10: encoding: [0x6a,0x02,0x13,0xbf]

s_cmp_lg_u64 s[0:1], exec
// GFX10: encoding: [0x00,0x7e,0x13,0xbf]

s_cmp_lg_u64 s[0:1], vcc
// GFX10: encoding: [0x00,0x6a,0x13,0xbf]

s_cmp_lg_u64 s[0:1], 0
// GFX10: encoding: [0x00,0x80,0x13,0xbf]

s_cmp_lg_u64 s[0:1], -1
// GFX10: encoding: [0x00,0xc1,0x13,0xbf]

s_cmp_lg_u64 s[0:1], 0.5
// GFX10: encoding: [0x00,0xf0,0x13,0xbf]

s_cmp_lg_u64 s[0:1], -4.0
// GFX10: encoding: [0x00,0xf7,0x13,0xbf]

s_cmp_lg_u64 s[0:1], 0x3f717273
// GFX10: encoding: [0x00,0xff,0x13,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u64 s[0:1], 0xaf123456
// GFX10: encoding: [0x00,0xff,0x13,0xbf,0x56,0x34,0x12,0xaf]

//===----------------------------------------------------------------------===//
// ENC_SOPK.
//===----------------------------------------------------------------------===//

s_movk_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb0]

s_movk_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb0]

s_movk_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb0]

s_movk_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb0]

s_movk_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb0]

s_movk_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb0]

s_movk_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb0]

s_movk_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb0]

s_version 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb0]

s_version 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb0]

s_cmovk_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb1]

s_cmovk_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb1]

s_cmovk_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb1]

s_cmovk_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb1]

s_cmovk_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb1]

s_cmovk_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb1]

s_cmovk_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb1]

s_cmovk_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb1]

s_cmpk_eq_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb1]

s_cmpk_eq_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb1]

s_cmpk_eq_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb1]

s_cmpk_eq_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb1]

s_cmpk_eq_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb1]

s_cmpk_eq_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb1]

s_cmpk_eq_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb1]

s_cmpk_eq_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb1]

s_cmpk_lg_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb2]

s_cmpk_lg_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb2]

s_cmpk_lg_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb2]

s_cmpk_lg_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb2]

s_cmpk_lg_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb2]

s_cmpk_lg_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb2]

s_cmpk_lg_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb2]

s_cmpk_lg_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb2]

s_cmpk_gt_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb2]

s_cmpk_gt_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb2]

s_cmpk_gt_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb2]

s_cmpk_gt_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb2]

s_cmpk_gt_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb2]

s_cmpk_gt_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb2]

s_cmpk_gt_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb2]

s_cmpk_gt_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb2]

s_cmpk_ge_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb3]

s_cmpk_ge_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb3]

s_cmpk_ge_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb3]

s_cmpk_ge_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb3]

s_cmpk_ge_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb3]

s_cmpk_ge_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb3]

s_cmpk_ge_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb3]

s_cmpk_ge_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb3]

s_cmpk_lt_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb3]

s_cmpk_lt_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb3]

s_cmpk_lt_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb3]

s_cmpk_lt_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb3]

s_cmpk_lt_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb3]

s_cmpk_lt_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb3]

s_cmpk_lt_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb3]

s_cmpk_lt_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb3]

s_cmpk_le_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb4]

s_cmpk_le_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb4]

s_cmpk_le_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb4]

s_cmpk_le_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb4]

s_cmpk_le_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb4]

s_cmpk_le_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb4]

s_cmpk_le_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb4]

s_cmpk_le_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb4]

s_cmpk_eq_u32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb4]

s_cmpk_eq_u32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb4]

s_cmpk_eq_u32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb4]

s_cmpk_eq_u32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb4]

s_cmpk_eq_u32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb4]

s_cmpk_eq_u32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb4]

s_cmpk_eq_u32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb4]

s_cmpk_eq_u32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb4]

s_cmpk_lg_u32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb5]

s_cmpk_lg_u32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb5]

s_cmpk_lg_u32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb5]

s_cmpk_lg_u32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb5]

s_cmpk_lg_u32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb5]

s_cmpk_lg_u32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb5]

s_cmpk_lg_u32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb5]

s_cmpk_lg_u32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb5]

s_cmpk_gt_u32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb5]

s_cmpk_gt_u32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb5]

s_cmpk_gt_u32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb5]

s_cmpk_gt_u32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb5]

s_cmpk_gt_u32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb5]

s_cmpk_gt_u32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb5]

s_cmpk_gt_u32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb5]

s_cmpk_gt_u32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb5]

s_cmpk_ge_u32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb6]

s_cmpk_ge_u32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb6]

s_cmpk_ge_u32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb6]

s_cmpk_ge_u32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb6]

s_cmpk_ge_u32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb6]

s_cmpk_ge_u32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb6]

s_cmpk_ge_u32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb6]

s_cmpk_ge_u32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb6]

s_cmpk_lt_u32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb6]

s_cmpk_lt_u32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb6]

s_cmpk_lt_u32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb6]

s_cmpk_lt_u32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb6]

s_cmpk_lt_u32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb6]

s_cmpk_lt_u32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb6]

s_cmpk_lt_u32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb6]

s_cmpk_lt_u32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb6]

s_cmpk_le_u32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb7]

s_cmpk_le_u32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb7]

s_cmpk_le_u32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb7]

s_cmpk_le_u32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb7]

s_cmpk_le_u32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb7]

s_cmpk_le_u32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb7]

s_cmpk_le_u32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb7]

s_cmpk_le_u32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb7]

s_addk_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb7]

s_addk_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb7]

s_addk_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb7]

s_addk_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb7]

s_addk_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb7]

s_addk_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb7]

s_addk_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb7]

s_addk_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb7]

s_mulk_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb8]

s_mulk_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb8]

s_mulk_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb8]

s_mulk_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb8]

s_mulk_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb8]

s_mulk_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb8]

s_mulk_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb8]

s_mulk_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb8]

s_getreg_b32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb9]

s_getreg_b32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb9]

s_getreg_b32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb9]

s_getreg_b32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb9]

s_getreg_b32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb9]

s_getreg_b32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb9]

s_getreg_b32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb9]

s_getreg_b32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb9]

s_setreg_b32 0x1234, s0
// GFX10: encoding: [0x34,0x12,0x80,0xb9]

s_setreg_b32 0xc1d1, s0
// GFX10: encoding: [0xd1,0xc1,0x80,0xb9]

s_setreg_b32 0x1234, s105
// GFX10: encoding: [0x34,0x12,0xe9,0xb9]

s_setreg_b32 0x1234, exec_lo
// GFX10: encoding: [0x34,0x12,0xfe,0xb9]

s_setreg_b32 0x1234, exec_hi
// GFX10: encoding: [0x34,0x12,0xff,0xb9]

s_setreg_b32 0x1234, vcc_lo
// GFX10: encoding: [0x34,0x12,0xea,0xb9]

s_setreg_b32 0x1234, vcc_hi
// GFX10: encoding: [0x34,0x12,0xeb,0xb9]

s_setreg_b32 0x1234, m0
// GFX10: encoding: [0x34,0x12,0xfc,0xb9]

s_setreg_imm32_b32 0x1234, 0x11213141
// GFX10: encoding: [0x34,0x12,0x80,0xba,0x41,0x31,0x21,0x11]

s_setreg_imm32_b32 0xc1d1, 0x11213141
// GFX10: encoding: [0xd1,0xc1,0x80,0xba,0x41,0x31,0x21,0x11]

s_setreg_imm32_b32 0x1234, 0xa1b1c1d1
// GFX10: encoding: [0x34,0x12,0x80,0xba,0xd1,0xc1,0xb1,0xa1]

s_setreg_imm32_b32 0xc1d1, 0xa1b1c1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xba,0xd1,0xc1,0xb1,0xa1]

s_call_b64 s[0:1], 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xbb]

s_call_b64 s[0:1], 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xbb]

s_call_b64 s[104:105], 0x1234
// GFX10: encoding: [0x34,0x12,0x68,0xbb]

s_call_b64 exec, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xbb]

s_call_b64 vcc, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xbb]

s_waitcnt_vscnt s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xbb]

s_waitcnt_vscnt s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xbb]

s_waitcnt_vscnt s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xbb]

s_waitcnt_vscnt exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xbb]

s_waitcnt_vscnt exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xbb]

s_waitcnt_vscnt vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xbb]

s_waitcnt_vscnt vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xbb]

s_waitcnt_vscnt m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xbb]

s_waitcnt_vmcnt s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xbc]

s_waitcnt_vmcnt s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xbc]

s_waitcnt_vmcnt s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xbc]

s_waitcnt_vmcnt exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xbc]

s_waitcnt_vmcnt exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xbc]

s_waitcnt_vmcnt vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xbc]

s_waitcnt_vmcnt vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xbc]

s_waitcnt_vmcnt m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xbc]

s_waitcnt_expcnt s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xbc]

s_waitcnt_expcnt s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xbc]

s_waitcnt_expcnt s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xbc]

s_waitcnt_expcnt exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xbc]

s_waitcnt_expcnt exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xbc]

s_waitcnt_expcnt vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xbc]

s_waitcnt_expcnt vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xbc]

s_waitcnt_expcnt m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xbc]

s_waitcnt_lgkmcnt s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xbd]

s_waitcnt_lgkmcnt s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xbd]

s_waitcnt_lgkmcnt s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xbd]

s_waitcnt_lgkmcnt exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xbd]

s_waitcnt_lgkmcnt exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xbd]

s_waitcnt_lgkmcnt vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xbd]

s_waitcnt_lgkmcnt vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xbd]

s_waitcnt_lgkmcnt m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xbd]

s_waitcnt_depctr 0xfffe
// GFX10: encoding: [0xfe,0xff,0xa3,0xbf]

s_waitcnt_depctr 0
// GFX10: encoding: [0x00,0x00,0xa3,0xbf]

s_wait_idle
// GFX10: encoding: [0x00,0x00,0xa2,0xbf]

s_subvector_loop_begin s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xbd]

s_subvector_loop_begin s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xbd]

s_subvector_loop_begin s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xbd]

s_subvector_loop_begin exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xbd]

s_subvector_loop_begin exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xbd]

s_subvector_loop_begin vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xbd]

s_subvector_loop_begin vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xbd]

s_subvector_loop_begin m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xbd]

s_subvector_loop_end s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xbe]

s_subvector_loop_end s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xbe]

s_subvector_loop_end s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xbe]

s_subvector_loop_end exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xbe]

s_subvector_loop_end exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xbe]

s_subvector_loop_end vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xbe]

s_subvector_loop_end vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xbe]

s_subvector_loop_end m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xbe]

//===----------------------------------------------------------------------===//
// ENC_SOPP.
//===----------------------------------------------------------------------===//

s_nop 0x0
// GFX10: encoding: [0x00,0x00,0x80,0xbf]

s_nop 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xbf]

s_nop 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xbf]

s_endpgm
// GFX10: encoding: [0x00,0x00,0x81,0xbf]

s_endpgm 1
// GFX10: encoding: [0x01,0x00,0x81,0xbf]

s_endpgm 65535
// GFX10: encoding: [0xff,0xff,0x81,0xbf]

s_branch 0x0
// GFX10: encoding: [0x00,0x00,0x82,0xbf]

s_branch 0x1234
// GFX10: encoding: [0x34,0x12,0x82,0xbf]

s_branch 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x82,0xbf]

s_wakeup
// GFX10: encoding: [0x00,0x00,0x83,0xbf]

s_cbranch_scc0 0x0
// GFX10: encoding: [0x00,0x00,0x84,0xbf]

s_cbranch_scc0 0x1234
// GFX10: encoding: [0x34,0x12,0x84,0xbf]

s_cbranch_scc0 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x84,0xbf]

s_cbranch_scc1 0x0
// GFX10: encoding: [0x00,0x00,0x85,0xbf]

s_cbranch_scc1 0x1234
// GFX10: encoding: [0x34,0x12,0x85,0xbf]

s_cbranch_scc1 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x85,0xbf]

s_cbranch_vccz 0x0
// GFX10: encoding: [0x00,0x00,0x86,0xbf]

s_cbranch_vccz 0x1234
// GFX10: encoding: [0x34,0x12,0x86,0xbf]

s_cbranch_vccz 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x86,0xbf]

s_cbranch_vccnz 0x0
// GFX10: encoding: [0x00,0x00,0x87,0xbf]

s_cbranch_vccnz 0x1234
// GFX10: encoding: [0x34,0x12,0x87,0xbf]

s_cbranch_vccnz 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x87,0xbf]

s_cbranch_execz 0x0
// GFX10: encoding: [0x00,0x00,0x88,0xbf]

s_cbranch_execz 0x1234
// GFX10: encoding: [0x34,0x12,0x88,0xbf]

s_cbranch_execz 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x88,0xbf]

s_cbranch_execnz 0x0
// GFX10: encoding: [0x00,0x00,0x89,0xbf]

s_cbranch_execnz 0x1234
// GFX10: encoding: [0x34,0x12,0x89,0xbf]

s_cbranch_execnz 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x89,0xbf]

s_barrier
// GFX10: encoding: [0x00,0x00,0x8a,0xbf]

s_setkill 0x0
// GFX10: encoding: [0x00,0x00,0x8b,0xbf]

s_setkill 0x1234
// GFX10: encoding: [0x34,0x12,0x8b,0xbf]

s_setkill 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x8b,0xbf]

s_waitcnt 0x0
// GFX10: encoding: [0x00,0x00,0x8c,0xbf]

s_waitcnt 0x1234
// GFX10: encoding: [0x34,0x12,0x8c,0xbf]

s_waitcnt 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x8c,0xbf]

s_sethalt 0x0
// GFX10: encoding: [0x00,0x00,0x8d,0xbf]

s_sethalt 0x1234
// GFX10: encoding: [0x34,0x12,0x8d,0xbf]

s_sethalt 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x8d,0xbf]

s_sleep 0x0
// GFX10: encoding: [0x00,0x00,0x8e,0xbf]

s_sleep 0x1234
// GFX10: encoding: [0x34,0x12,0x8e,0xbf]

s_sleep 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x8e,0xbf]

s_setprio 0x0
// GFX10: encoding: [0x00,0x00,0x8f,0xbf]

s_setprio 0x1234
// GFX10: encoding: [0x34,0x12,0x8f,0xbf]

s_setprio 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x8f,0xbf]

s_sendmsg 0x0
// GFX10: encoding: [0x00,0x00,0x90,0xbf]

s_sendmsg 0x1234
// GFX10: encoding: [0x34,0x12,0x90,0xbf]

s_sendmsg 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x90,0xbf]

s_sendmsghalt 0x0
// GFX10: encoding: [0x00,0x00,0x91,0xbf]

s_sendmsghalt 0x1234
// GFX10: encoding: [0x34,0x12,0x91,0xbf]

s_sendmsghalt 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x91,0xbf]

s_trap 0x0
// GFX10: encoding: [0x00,0x00,0x92,0xbf]

s_trap 0x1234
// GFX10: encoding: [0x34,0x12,0x92,0xbf]

s_trap 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x92,0xbf]

s_icache_inv
// GFX10: encoding: [0x00,0x00,0x93,0xbf]

s_incperflevel 0x0
// GFX10: encoding: [0x00,0x00,0x94,0xbf]

s_incperflevel 0x1234
// GFX10: encoding: [0x34,0x12,0x94,0xbf]

s_incperflevel 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x94,0xbf]

s_decperflevel 0x0
// GFX10: encoding: [0x00,0x00,0x95,0xbf]

s_decperflevel 0x1234
// GFX10: encoding: [0x34,0x12,0x95,0xbf]

s_decperflevel 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x95,0xbf]

s_ttracedata
// GFX10: encoding: [0x00,0x00,0x96,0xbf]

s_cbranch_cdbgsys 0x0
// GFX10: encoding: [0x00,0x00,0x97,0xbf]

s_cbranch_cdbgsys 0x1234
// GFX10: encoding: [0x34,0x12,0x97,0xbf]

s_cbranch_cdbgsys 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x97,0xbf]

s_cbranch_cdbguser 0x0
// GFX10: encoding: [0x00,0x00,0x98,0xbf]

s_cbranch_cdbguser 0x1234
// GFX10: encoding: [0x34,0x12,0x98,0xbf]

s_cbranch_cdbguser 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x98,0xbf]

s_cbranch_cdbgsys_or_user 0x0
// GFX10: encoding: [0x00,0x00,0x99,0xbf]

s_cbranch_cdbgsys_or_user 0x1234
// GFX10: encoding: [0x34,0x12,0x99,0xbf]

s_cbranch_cdbgsys_or_user 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x99,0xbf]

s_cbranch_cdbgsys_and_user 0x0
// GFX10: encoding: [0x00,0x00,0x9a,0xbf]

s_cbranch_cdbgsys_and_user 0x1234
// GFX10: encoding: [0x34,0x12,0x9a,0xbf]

s_cbranch_cdbgsys_and_user 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x9a,0xbf]

s_endpgm_saved
// GFX10: encoding: [0x00,0x00,0x9b,0xbf]

s_endpgm_ordered_ps_done
// GFX10: encoding: [0x00,0x00,0x9e,0xbf]

s_code_end
// GFX10: encoding: [0x00,0x00,0x9f,0xbf]

s_inst_prefetch 0x0
// GFX10: encoding: [0x00,0x00,0xa0,0xbf]

s_inst_prefetch 0x1234
// GFX10: encoding: [0x34,0x12,0xa0,0xbf]

s_inst_prefetch 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0xa0,0xbf]

s_clause 0x0
// GFX10: encoding: [0x00,0x00,0xa1,0xbf]

s_clause 0x1234
// GFX10: encoding: [0x34,0x12,0xa1,0xbf]

s_clause 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0xa1,0xbf]

s_round_mode 0x0
// GFX10: encoding: [0x00,0x00,0xa4,0xbf]

s_round_mode 0x1234
// GFX10: encoding: [0x34,0x12,0xa4,0xbf]

s_round_mode 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0xa4,0xbf]

s_denorm_mode 0x0
// GFX10: encoding: [0x00,0x00,0xa5,0xbf]

s_denorm_mode 0x1234
// GFX10: encoding: [0x34,0x12,0xa5,0xbf]

s_denorm_mode 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0xa5,0xbf]

s_ttracedata_imm 0x0
// GFX10: encoding: [0x00,0x00,0xa8,0xbf]

s_ttracedata_imm 0x1234
// GFX10: encoding: [0x34,0x12,0xa8,0xbf]

s_ttracedata_imm 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0xa8,0xbf]
