; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64-none-linux-gnu -aarch64-enable-atomic-cfg-tidy=0 -verify-machineinstrs -o - %s | FileCheck %s

; LLVM should be able to cope with multiple uses of the same flag-setting
; instruction at different points of a routine. Either by rematerializing the
; compare or by saving and restoring the flag register.

declare void @bar()

@var = global i32 0

define i32 @test_multiflag(i32 %n, i32 %m, i32 %o) {
; CHECK-LABEL: test_multiflag:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-32]! // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    adrp x8, :got:var
; CHECK-NEXT:    cmp w0, w1
; CHECK-NEXT:    mov w19, w1
; CHECK-NEXT:    ldr x8, [x8, :got_lo12:var]
; CHECK-NEXT:    cset w9, ne
; CHECK-NEXT:    mov w20, w0
; CHECK-NEXT:    str w9, [x8]
; CHECK-NEXT:    bl bar
; CHECK-NEXT:    cmp w20, w19
; CHECK-NEXT:    b.eq .LBB0_2
; CHECK-NEXT:  // %bb.1: // %iftrue
; CHECK-NEXT:    mov w0, #42 // =0x2a
; CHECK-NEXT:    b .LBB0_3
; CHECK-NEXT:  .LBB0_2: // %iffalse
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:  .LBB0_3: // %iftrue
; CHECK-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp], #32 // 8-byte Folded Reload
; CHECK-NEXT:    ret

  %test = icmp ne i32 %n, %m

  %val = zext i1 %test to i32


  store i32 %val, ptr @var

  call void @bar()

  ; Currently, the comparison is emitted again. An MSR/MRS pair would also be
  ; acceptable, but assuming the call preserves NZCV is not.
  br i1 %test, label %iftrue, label %iffalse

iftrue:
  ret i32 42
iffalse:
  ret i32 0
}
